/* util-html.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from util-html.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libxml/HTMLtree.h>
#include <libxml/HTMLparser.h>
#include <libxml/tree.h>
#include <libxml/parser.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _xmlFreeDoc0(var) ((var == NULL) ? NULL : (var = (xmlFreeDoc (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

VALA_EXTERN GRegex* geary_html_WHITESPACE_REGEX;
GRegex* geary_html_WHITESPACE_REGEX = NULL;
VALA_EXTERN gint geary_html_init_count;
gint geary_html_init_count = 0;
VALA_EXTERN GeeHashSet* geary_html_breaking_elements;
GeeHashSet* geary_html_breaking_elements = NULL;
VALA_EXTERN GeeHashSet* geary_html_spacing_elements;
GeeHashSet* geary_html_spacing_elements = NULL;
VALA_EXTERN GeeHashSet* geary_html_alt_text_elements;
GeeHashSet* geary_html_alt_text_elements = NULL;
VALA_EXTERN GeeHashSet* geary_html_ignored_elements;
GeeHashSet* geary_html_ignored_elements = NULL;

VALA_EXTERN void geary_html_init_element_sets (void);
static guint _geary_ascii_stri_hash_gee_hash_data_func (gconstpointer v,
                                                 gpointer self);
static gboolean _geary_ascii_stri_equal_gee_equal_data_func (gconstpointer a,
                                                      gconstpointer b,
                                                      gpointer self);
static gboolean ____lambda181_ (GMatchInfo* info,
                         GString* _result_);
static gboolean _____lambda181__gregex_eval_callback (GMatchInfo* match_info,
                                               GString* _result_,
                                               gpointer self);
VALA_EXTERN void geary_html_recurse_html_nodes_for_text (xmlNode* node,
                                             gboolean include_blockquotes,
                                             GString* text);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

/**
 * Must be called before ''any'' call to the HTML namespace.
 *
 * This will be initialized by the Engine when it's opened; or call this
 * directly to use these functions earlier.
 */
void
geary_html_init (void)
{
	gint _tmp0_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = geary_html_init_count;
	geary_html_init_count = _tmp0_ + 1;
	if (_tmp0_ != 0) {
		return;
	}
	geary_html_init_element_sets ();
	{
		GRegex* _tmp1_ = NULL;
		GRegex* _tmp2_;
		GRegex* _tmp3_;
		_tmp2_ = g_regex_new ("(\\R|\\t|[ ]+)", 0, 0, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_regex_unref0 (geary_html_WHITESPACE_REGEX);
		geary_html_WHITESPACE_REGEX = _tmp3_;
		_g_regex_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		_vala_assert (TRUE, "true");
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static guint
_geary_ascii_stri_hash_gee_hash_data_func (gconstpointer v,
                                           gpointer self)
{
	guint result;
	result = geary_ascii_stri_hash ((const gchar*) v);
	return result;
}

static gboolean
_geary_ascii_stri_equal_gee_equal_data_func (gconstpointer a,
                                             gconstpointer b,
                                             gpointer self)
{
	gboolean result;
	result = geary_ascii_stri_equal ((const gchar*) a, (const gchar*) b);
	return result;
}

void
geary_html_init_element_sets (void)
{
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar** _tmp27_;
	gchar** _tmp28_;
	gint _tmp28__length1;
	GeeHashSet* _tmp29_;
	GeeHashSet* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar** _tmp36_;
	gchar** _tmp37_;
	gint _tmp37__length1;
	GeeHashSet* _tmp38_;
	GeeHashSet* _tmp39_;
	gchar* _tmp40_;
	gchar** _tmp41_;
	gchar** _tmp42_;
	gint _tmp42__length1;
	GeeHashSet* _tmp43_;
	GeeHashSet* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar** _tmp52_;
	gchar** _tmp53_;
	gint _tmp53__length1;
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _geary_ascii_stri_hash_gee_hash_data_func, NULL, NULL, _geary_ascii_stri_equal_gee_equal_data_func, NULL, NULL);
	_g_object_unref0 (geary_html_breaking_elements);
	geary_html_breaking_elements = _tmp0_;
	_tmp1_ = geary_html_breaking_elements;
	_tmp2_ = g_strdup ("address");
	_tmp3_ = g_strdup ("blockquote");
	_tmp4_ = g_strdup ("br");
	_tmp5_ = g_strdup ("caption");
	_tmp6_ = g_strdup ("center");
	_tmp7_ = g_strdup ("div");
	_tmp8_ = g_strdup ("dt");
	_tmp9_ = g_strdup ("embed");
	_tmp10_ = g_strdup ("form");
	_tmp11_ = g_strdup ("h1");
	_tmp12_ = g_strdup ("h2");
	_tmp13_ = g_strdup ("h3");
	_tmp14_ = g_strdup ("h4");
	_tmp15_ = g_strdup ("h5");
	_tmp16_ = g_strdup ("h6");
	_tmp17_ = g_strdup ("hr");
	_tmp18_ = g_strdup ("iframe");
	_tmp19_ = g_strdup ("li");
	_tmp20_ = g_strdup ("map");
	_tmp21_ = g_strdup ("menu");
	_tmp22_ = g_strdup ("noscript");
	_tmp23_ = g_strdup ("object");
	_tmp24_ = g_strdup ("p");
	_tmp25_ = g_strdup ("pre");
	_tmp26_ = g_strdup ("tr");
	_tmp27_ = g_new0 (gchar*, 25 + 1);
	_tmp27_[0] = _tmp2_;
	_tmp27_[1] = _tmp3_;
	_tmp27_[2] = _tmp4_;
	_tmp27_[3] = _tmp5_;
	_tmp27_[4] = _tmp6_;
	_tmp27_[5] = _tmp7_;
	_tmp27_[6] = _tmp8_;
	_tmp27_[7] = _tmp9_;
	_tmp27_[8] = _tmp10_;
	_tmp27_[9] = _tmp11_;
	_tmp27_[10] = _tmp12_;
	_tmp27_[11] = _tmp13_;
	_tmp27_[12] = _tmp14_;
	_tmp27_[13] = _tmp15_;
	_tmp27_[14] = _tmp16_;
	_tmp27_[15] = _tmp17_;
	_tmp27_[16] = _tmp18_;
	_tmp27_[17] = _tmp19_;
	_tmp27_[18] = _tmp20_;
	_tmp27_[19] = _tmp21_;
	_tmp27_[20] = _tmp22_;
	_tmp27_[21] = _tmp23_;
	_tmp27_[22] = _tmp24_;
	_tmp27_[23] = _tmp25_;
	_tmp27_[24] = _tmp26_;
	_tmp28_ = _tmp27_;
	_tmp28__length1 = 25;
	gee_collection_add_all_array (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection), _tmp28_, (gint) 25);
	_tmp28_ = (_vala_array_free (_tmp28_, _tmp28__length1, (GDestroyNotify) g_free), NULL);
	_tmp29_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _geary_ascii_stri_hash_gee_hash_data_func, NULL, NULL, _geary_ascii_stri_equal_gee_equal_data_func, NULL, NULL);
	_g_object_unref0 (geary_html_spacing_elements);
	geary_html_spacing_elements = _tmp29_;
	_tmp30_ = geary_html_spacing_elements;
	_tmp31_ = g_strdup ("dt");
	_tmp32_ = g_strdup ("dd");
	_tmp33_ = g_strdup ("img");
	_tmp34_ = g_strdup ("td");
	_tmp35_ = g_strdup ("th");
	_tmp36_ = g_new0 (gchar*, 5 + 1);
	_tmp36_[0] = _tmp31_;
	_tmp36_[1] = _tmp32_;
	_tmp36_[2] = _tmp33_;
	_tmp36_[3] = _tmp34_;
	_tmp36_[4] = _tmp35_;
	_tmp37_ = _tmp36_;
	_tmp37__length1 = 5;
	gee_collection_add_all_array (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEE_TYPE_COLLECTION, GeeCollection), _tmp37_, (gint) 5);
	_tmp37_ = (_vala_array_free (_tmp37_, _tmp37__length1, (GDestroyNotify) g_free), NULL);
	_tmp38_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _geary_ascii_stri_hash_gee_hash_data_func, NULL, NULL, _geary_ascii_stri_equal_gee_equal_data_func, NULL, NULL);
	_g_object_unref0 (geary_html_alt_text_elements);
	geary_html_alt_text_elements = _tmp38_;
	_tmp39_ = geary_html_alt_text_elements;
	_tmp40_ = g_strdup ("img");
	_tmp41_ = g_new0 (gchar*, 1 + 1);
	_tmp41_[0] = _tmp40_;
	_tmp42_ = _tmp41_;
	_tmp42__length1 = 1;
	gee_collection_add_all_array (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, GEE_TYPE_COLLECTION, GeeCollection), _tmp42_, (gint) 1);
	_tmp42_ = (_vala_array_free (_tmp42_, _tmp42__length1, (GDestroyNotify) g_free), NULL);
	_tmp43_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _geary_ascii_stri_hash_gee_hash_data_func, NULL, NULL, _geary_ascii_stri_equal_gee_equal_data_func, NULL, NULL);
	_g_object_unref0 (geary_html_ignored_elements);
	geary_html_ignored_elements = _tmp43_;
	_tmp44_ = geary_html_ignored_elements;
	_tmp45_ = g_strdup ("base");
	_tmp46_ = g_strdup ("link");
	_tmp47_ = g_strdup ("meta");
	_tmp48_ = g_strdup ("head");
	_tmp49_ = g_strdup ("script");
	_tmp50_ = g_strdup ("style");
	_tmp51_ = g_strdup ("template");
	_tmp52_ = g_new0 (gchar*, 7 + 1);
	_tmp52_[0] = _tmp45_;
	_tmp52_[1] = _tmp46_;
	_tmp52_[2] = _tmp47_;
	_tmp52_[3] = _tmp48_;
	_tmp52_[4] = _tmp49_;
	_tmp52_[5] = _tmp50_;
	_tmp52_[6] = _tmp51_;
	_tmp53_ = _tmp52_;
	_tmp53__length1 = 7;
	gee_collection_add_all_array (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, GEE_TYPE_COLLECTION, GeeCollection), _tmp53_, (gint) 7);
	_tmp53_ = (_vala_array_free (_tmp53_, _tmp53__length1, (GDestroyNotify) g_free), NULL);
}

/** Converts plain text to HTML with reserved characters escaped. */
inline gchar*
geary_html_escape_markup (const gchar* plain)
{
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* result;
	if (!geary_string_is_empty (plain)) {
		_tmp1_ = g_utf8_validate (plain, (gssize) -1, NULL);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* _tmp2_;
		_tmp2_ = g_markup_escape_text (plain, (gssize) -1);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	} else {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	}
	result = _tmp0_;
	return result;
}

/** Converts plain text to HTML with whitespace (SP, CR, LF) preserved. */
static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gboolean
____lambda181_ (GMatchInfo* info,
                GString* _result_)
{
	gchar* match = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (info != NULL, FALSE);
	g_return_val_if_fail (_result_ != NULL, FALSE);
	_tmp0_ = g_match_info_fetch (info, 0);
	match = _tmp0_;
	_tmp1_ = match;
	if (string_get (_tmp1_, (glong) 0) == ' ') {
		g_string_append_c (_result_, ' ');
		{
			gint len = 0;
			const gchar* _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			_tmp2_ = match;
			_tmp3_ = strlen (_tmp2_);
			_tmp4_ = _tmp3_;
			len = _tmp4_ - 1;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					if (!_tmp5_) {
						gint _tmp6_;
						_tmp6_ = len;
						len = _tmp6_ - 1;
					}
					_tmp5_ = FALSE;
					if (!(len > 0)) {
						break;
					}
					g_string_append (_result_, "&nbsp;");
				}
			}
		}
	} else {
		const gchar* _tmp7_;
		_tmp7_ = match;
		if (g_strcmp0 (_tmp7_, "\t") == 0) {
			g_string_append (_result_, " &nbsp;&nbsp;&nbsp;");
		} else {
			g_string_append (_result_, "<br>");
		}
	}
	result = FALSE;
	_g_free0 (match);
	return result;
}

static gboolean
_____lambda181__gregex_eval_callback (GMatchInfo* match_info,
                                      GString* _result_,
                                      gpointer self)
{
	gboolean result;
	result = ____lambda181_ (match_info, _result_);
	return result;
}

gchar*
geary_html_preserve_whitespace (const gchar* text)
{
	gchar* preserved = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	_tmp0_ = g_strdup ("");
	preserved = _tmp0_;
	if (!geary_string_is_empty (text)) {
		{
			gchar* _tmp1_ = NULL;
			GRegex* _tmp2_;
			const gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp2_ = geary_html_WHITESPACE_REGEX;
			_tmp3_ = text;
			_tmp4_ = g_regex_replace_eval (_tmp2_, _tmp3_, (gssize) -1, 0, 0, _____lambda181__gregex_eval_callback, NULL, &_inner_error0_);
			_tmp1_ = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp5_ = _tmp1_;
			_tmp1_ = NULL;
			_g_free0 (preserved);
			preserved = _tmp5_;
			_g_free0 (_tmp1_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			GError* _tmp6_;
			const gchar* _tmp7_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp6_ = err;
			_tmp7_ = _tmp6_->message;
			g_debug ("util-html.vala:133: Error preserving whitespace: %s", _tmp7_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (preserved);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = preserved;
	return result;
}

/**
 * Escape reserved HTML entities and preserves whitespace, if needed.
 *
 * Returns a string with reserved HTML entities escaped and
 * whitespace preserved if the given string does not have HTML
 * tags.
 */
gchar*
geary_html_smart_escape (const gchar* text)
{
	const gchar* _tmp0_ = NULL;
	gchar* escaped = NULL;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = text;
	if (_tmp0_ == NULL) {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	escaped = _tmp1_;
	if (text != NULL) {
		gboolean is_html = FALSE;
		is_html = g_regex_match_simple ("<[A-Z]+ ?(?: [^>]*)?\\/?>", text, G_REGEX_CASELESS, 0);
		if (!is_html) {
			const gchar* _tmp2_;
			gchar* _tmp3_;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp2_ = escaped;
			_tmp3_ = geary_html_escape_markup (_tmp2_);
			_g_free0 (escaped);
			escaped = _tmp3_;
			_tmp4_ = escaped;
			_tmp5_ = geary_html_preserve_whitespace (_tmp4_);
			_g_free0 (escaped);
			escaped = _tmp5_;
		}
	}
	result = escaped;
	return result;
}

/**
 * Does a very approximate conversion from HTML to text.
 *
 * This does more than stripping tags -- it inserts line breaks where
 * appropriate, decodes entities, etc. Note the full string is parsed
 * by libxml's HTML parser to create a DOM-like tree representation,
 * which is then walked, so this function can be somewhat
 * computationally expensive.
 */
gchar*
geary_html_html_to_text (const gchar* html,
                         gboolean include_blockquotes,
                         const gchar* encoding)
{
	xmlDoc* doc = NULL;
	xmlDoc* _tmp0_;
	GString* text = NULL;
	GString* _tmp1_;
	xmlDoc* _tmp2_;
	GString* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result;
	g_return_val_if_fail (html != NULL, NULL);
	g_return_val_if_fail (encoding != NULL, NULL);
	_tmp0_ = htmlReadDoc ((xmlChar*) html, "", encoding, (gint) (((((HTML_PARSE_RECOVER | HTML_PARSE_NOERROR) | HTML_PARSE_NOWARNING) | HTML_PARSE_NOBLANKS) | HTML_PARSE_NONET) | HTML_PARSE_COMPACT));
	doc = _tmp0_;
	_tmp1_ = g_string_new ("");
	text = _tmp1_;
	_tmp2_ = doc;
	if (_tmp2_ != NULL) {
		xmlDoc* _tmp3_;
		xmlNode* _tmp4_;
		GString* _tmp5_;
		xmlDoc* _tmp6_;
		_tmp3_ = doc;
		_tmp4_ = xmlDocGetRootElement (_tmp3_);
		_tmp5_ = text;
		geary_html_recurse_html_nodes_for_text (_tmp4_, include_blockquotes, _tmp5_);
		_tmp6_ = doc;
		_xmlFreeDoc0 (_tmp6_);
	}
	_tmp7_ = text;
	_tmp8_ = _tmp7_->str;
	_tmp9_ = g_strdup (_tmp8_);
	result = _tmp9_;
	_g_string_free0 (text);
	return result;
}

void
geary_html_recurse_html_nodes_for_text (xmlNode* node,
                                        gboolean include_blockquotes,
                                        GString* text)
{
	g_return_if_fail (text != NULL);
	{
		xmlNode* n = NULL;
		n = node;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				xmlNode* _tmp3_;
				xmlNode* _tmp4_;
				if (!_tmp0_) {
					xmlNode* _tmp1_;
					xmlNode* _tmp2_;
					_tmp1_ = n;
					_tmp2_ = _tmp1_->next;
					n = _tmp2_;
				}
				_tmp0_ = FALSE;
				_tmp3_ = n;
				if (!(_tmp3_ != NULL)) {
					break;
				}
				_tmp4_ = n;
				if (_tmp4_->type == XML_TEXT_NODE) {
					xmlNode* _tmp5_;
					const gchar* _tmp6_;
					_tmp5_ = n;
					_tmp6_ = _tmp5_->content;
					g_string_append (text, _tmp6_);
				} else {
					xmlNode* _tmp7_;
					_tmp7_ = n;
					if (_tmp7_->type == XML_ELEMENT_NODE) {
						gchar* name = NULL;
						xmlNode* _tmp8_;
						const gchar* _tmp9_;
						gchar* _tmp10_;
						gboolean _tmp11_ = FALSE;
						_tmp8_ = n;
						_tmp9_ = _tmp8_->name;
						_tmp10_ = g_strdup (_tmp9_);
						name = _tmp10_;
						if (include_blockquotes) {
							_tmp11_ = TRUE;
						} else {
							const gchar* _tmp12_;
							_tmp12_ = name;
							_tmp11_ = g_strcmp0 (_tmp12_, "blockquote") != 0;
						}
						if (_tmp11_) {
							GeeHashSet* _tmp13_;
							const gchar* _tmp14_;
							GeeHashSet* _tmp18_;
							const gchar* _tmp19_;
							GeeHashSet* _tmp22_;
							const gchar* _tmp23_;
							GeeHashSet* _tmp24_;
							const gchar* _tmp25_;
							_tmp13_ = geary_html_alt_text_elements;
							_tmp14_ = name;
							if (gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp14_)) {
								gchar* alt_text = NULL;
								gchar* _tmp15_;
								const gchar* _tmp16_;
								_tmp15_ = (gchar*) xmlGetProp (node, (xmlChar*) "alt");
								alt_text = _tmp15_;
								_tmp16_ = alt_text;
								if (_tmp16_ != NULL) {
									const gchar* _tmp17_;
									_tmp17_ = alt_text;
									g_string_append (text, _tmp17_);
								}
								_g_free0 (alt_text);
							}
							_tmp18_ = geary_html_ignored_elements;
							_tmp19_ = name;
							if (!gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp19_)) {
								xmlNode* _tmp20_;
								xmlNode* _tmp21_;
								_tmp20_ = n;
								_tmp21_ = _tmp20_->children;
								geary_html_recurse_html_nodes_for_text (_tmp21_, include_blockquotes, text);
							}
							_tmp22_ = geary_html_spacing_elements;
							_tmp23_ = name;
							if (gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp23_)) {
								g_string_append (text, " ");
							}
							_tmp24_ = geary_html_breaking_elements;
							_tmp25_ = name;
							if (gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp25_)) {
								g_string_append (text, "\n");
							}
						}
						_g_free0 (name);
					}
				}
			}
		}
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

