/* smtp-command.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from smtp-command.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

gchar*
geary_smtp_command_serialize (GearySmtpCommand self)
{
	gchar* result;
	switch (self) {
		case GEARY_SMTP_COMMAND_HELO:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("helo");
			result = _tmp0_;
			return result;
		}
		case GEARY_SMTP_COMMAND_EHLO:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("ehlo");
			result = _tmp1_;
			return result;
		}
		case GEARY_SMTP_COMMAND_QUIT:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("quit");
			result = _tmp2_;
			return result;
		}
		case GEARY_SMTP_COMMAND_HELP:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("help");
			result = _tmp3_;
			return result;
		}
		case GEARY_SMTP_COMMAND_NOOP:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("noop");
			result = _tmp4_;
			return result;
		}
		case GEARY_SMTP_COMMAND_RSET:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("rset");
			result = _tmp5_;
			return result;
		}
		case GEARY_SMTP_COMMAND_AUTH:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("AUTH");
			result = _tmp6_;
			return result;
		}
		case GEARY_SMTP_COMMAND_MAIL:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("mail");
			result = _tmp7_;
			return result;
		}
		case GEARY_SMTP_COMMAND_RCPT:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("rcpt");
			result = _tmp8_;
			return result;
		}
		case GEARY_SMTP_COMMAND_DATA:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("data");
			result = _tmp9_;
			return result;
		}
		case GEARY_SMTP_COMMAND_STARTTLS:
		{
			gchar* _tmp10_;
			_tmp10_ = g_strdup ("STARTTLS");
			result = _tmp10_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

GearySmtpCommand
geary_smtp_command_deserialize (const gchar* str,
                                GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	static GQuark _tmp2_label8 = 0;
	static GQuark _tmp2_label9 = 0;
	static GQuark _tmp2_label10 = 0;
	GError* _inner_error0_ = NULL;
	GearySmtpCommand result;
	g_return_val_if_fail (str != NULL, 0);
	_tmp0_ = geary_ascii_strdown (str);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	g_free (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("helo")))) {
		switch (0) {
			default:
			{
				result = GEARY_SMTP_COMMAND_HELO;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("ehlo")))) {
		switch (0) {
			default:
			{
				result = GEARY_SMTP_COMMAND_EHLO;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("quit")))) {
		switch (0) {
			default:
			{
				result = GEARY_SMTP_COMMAND_QUIT;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("help")))) {
		switch (0) {
			default:
			{
				result = GEARY_SMTP_COMMAND_HELP;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("noop")))) {
		switch (0) {
			default:
			{
				result = GEARY_SMTP_COMMAND_NOOP;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("rset")))) {
		switch (0) {
			default:
			{
				result = GEARY_SMTP_COMMAND_RSET;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("auth")))) {
		switch (0) {
			default:
			{
				result = GEARY_SMTP_COMMAND_AUTH;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("mail")))) {
		switch (0) {
			default:
			{
				result = GEARY_SMTP_COMMAND_MAIL;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label8) ? _tmp2_label8 : (_tmp2_label8 = g_quark_from_static_string ("rcpt")))) {
		switch (0) {
			default:
			{
				result = GEARY_SMTP_COMMAND_RCPT;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label9) ? _tmp2_label9 : (_tmp2_label9 = g_quark_from_static_string ("data")))) {
		switch (0) {
			default:
			{
				result = GEARY_SMTP_COMMAND_DATA;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label10) ? _tmp2_label10 : (_tmp2_label10 = g_quark_from_static_string ("starttls")))) {
		switch (0) {
			default:
			{
				result = GEARY_SMTP_COMMAND_STARTTLS;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GError* _tmp4_;
				_tmp4_ = g_error_new (GEARY_SMTP_ERROR, GEARY_SMTP_ERROR_PARSE_ERROR, "Unknown command \"%s\"", str);
				_inner_error0_ = _tmp4_;
				if (_inner_error0_->domain == GEARY_SMTP_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return 0;
				}
			}
		}
	}
}

 G_GNUC_NO_INLINE static GType
geary_smtp_command_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_SMTP_COMMAND_HELO, "GEARY_SMTP_COMMAND_HELO", "helo"}, {GEARY_SMTP_COMMAND_EHLO, "GEARY_SMTP_COMMAND_EHLO", "ehlo"}, {GEARY_SMTP_COMMAND_QUIT, "GEARY_SMTP_COMMAND_QUIT", "quit"}, {GEARY_SMTP_COMMAND_HELP, "GEARY_SMTP_COMMAND_HELP", "help"}, {GEARY_SMTP_COMMAND_NOOP, "GEARY_SMTP_COMMAND_NOOP", "noop"}, {GEARY_SMTP_COMMAND_RSET, "GEARY_SMTP_COMMAND_RSET", "rset"}, {GEARY_SMTP_COMMAND_AUTH, "GEARY_SMTP_COMMAND_AUTH", "auth"}, {GEARY_SMTP_COMMAND_MAIL, "GEARY_SMTP_COMMAND_MAIL", "mail"}, {GEARY_SMTP_COMMAND_RCPT, "GEARY_SMTP_COMMAND_RCPT", "rcpt"}, {GEARY_SMTP_COMMAND_DATA, "GEARY_SMTP_COMMAND_DATA", "data"}, {GEARY_SMTP_COMMAND_STARTTLS, "GEARY_SMTP_COMMAND_STARTTLS", "starttls"}, {0, NULL, NULL}};
	GType geary_smtp_command_type_id;
	geary_smtp_command_type_id = g_enum_register_static ("GearySmtpCommand", values);
	return geary_smtp_command_type_id;
}

GType
geary_smtp_command_get_type (void)
{
	static gsize geary_smtp_command_type_id__once = 0;
	if (g_once_init_enter (&geary_smtp_command_type_id__once)) {
		GType geary_smtp_command_type_id;
		geary_smtp_command_type_id = geary_smtp_command_get_type_once ();
		g_once_init_leave (&geary_smtp_command_type_id__once, geary_smtp_command_type_id);
	}
	return geary_smtp_command_type_id__once;
}

