/* imap-internal-date.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from imap-internal-date.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <stdio.h>
#include <float.h>
#include <math.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_IMAP_INTERNAL_DATE_0_PROPERTY,
	GEARY_IMAP_INTERNAL_DATE_VALUE_PROPERTY,
	GEARY_IMAP_INTERNAL_DATE_ORIGINAL_PROPERTY,
	GEARY_IMAP_INTERNAL_DATE_NUM_PROPERTIES
};
static GParamSpec* geary_imap_internal_date_properties[GEARY_IMAP_INTERNAL_DATE_NUM_PROPERTIES];
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GearyImapInternalDatePrivate {
	GDateTime* _value;
	gchar* _original;
};

static gint GearyImapInternalDate_private_offset;
static gpointer geary_imap_internal_date_parent_class = NULL;
static GearyImapMessageDataIface * geary_imap_internal_date_geary_imap_message_data_parent_iface = NULL;
static GeeHashableIface * geary_imap_internal_date_gee_hashable_parent_iface = NULL;
static GeeComparableIface * geary_imap_internal_date_gee_comparable_parent_iface = NULL;

static void geary_imap_internal_date_set_value (GearyImapInternalDate* self,
                                         GDateTime* value);
static void geary_imap_internal_date_set_original (GearyImapInternalDate* self,
                                            const gchar* value);
static GearyImapInternalDate* geary_imap_internal_date_new (const gchar* original,
                                                     GDateTime* datetime);
static GearyImapInternalDate* geary_imap_internal_date_construct (GType object_type,
                                                           const gchar* original,
                                                           GDateTime* datetime);
static gchar* geary_imap_internal_date_get_en_us_mon (GearyImapInternalDate* self);
static guint geary_imap_internal_date_real_hash (GeeHashable* base);
static gboolean geary_imap_internal_date_real_equal_to (GeeHashable* base,
                                                 GearyImapInternalDate* other);
static gint geary_imap_internal_date_real_compare_to (GeeComparable* base,
                                               GearyImapInternalDate* other);
static gchar* geary_imap_internal_date_real_to_string (GearyMessageDataAbstractMessageData* base);
static void geary_imap_internal_date_finalize (GObject * obj);
static GType geary_imap_internal_date_get_type_once (void);
static void _vala_geary_imap_internal_date_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_geary_imap_internal_date_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);

static const gchar* GEARY_IMAP_INTERNAL_DATE_EN_US_MON[12] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
static const gchar* GEARY_IMAP_INTERNAL_DATE_EN_US_MON_DOWN[12] = {"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};

static inline gpointer
geary_imap_internal_date_get_instance_private (GearyImapInternalDate* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapInternalDate_private_offset);
}

GDateTime*
geary_imap_internal_date_get_value (GearyImapInternalDate* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_INTERNAL_DATE (self), NULL);
	_tmp0_ = self->priv->_value;
	result = _tmp0_;
	return result;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static void
geary_imap_internal_date_set_value (GearyImapInternalDate* self,
                                    GDateTime* value)
{
	GDateTime* old_value;
	g_return_if_fail (GEARY_IMAP_IS_INTERNAL_DATE (self));
	old_value = geary_imap_internal_date_get_value (self);
	if (old_value != value) {
		GDateTime* _tmp0_;
		_tmp0_ = _g_date_time_ref0 (value);
		_g_date_time_unref0 (self->priv->_value);
		self->priv->_value = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_internal_date_properties[GEARY_IMAP_INTERNAL_DATE_VALUE_PROPERTY]);
	}
}

const gchar*
geary_imap_internal_date_get_original (GearyImapInternalDate* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_INTERNAL_DATE (self), NULL);
	_tmp0_ = self->priv->_original;
	result = _tmp0_;
	return result;
}

static void
geary_imap_internal_date_set_original (GearyImapInternalDate* self,
                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_IMAP_IS_INTERNAL_DATE (self));
	old_value = geary_imap_internal_date_get_original (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_original);
		self->priv->_original = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_internal_date_properties[GEARY_IMAP_INTERNAL_DATE_ORIGINAL_PROPERTY]);
	}
}

static GearyImapInternalDate*
geary_imap_internal_date_construct (GType object_type,
                                    const gchar* original,
                                    GDateTime* datetime)
{
	GearyImapInternalDate * self = NULL;
	g_return_val_if_fail (original != NULL, NULL);
	g_return_val_if_fail (datetime != NULL, NULL);
	self = (GearyImapInternalDate*) geary_message_data_abstract_message_data_construct (object_type);
	geary_imap_internal_date_set_original (self, original);
	geary_imap_internal_date_set_value (self, datetime);
	return self;
}

static GearyImapInternalDate*
geary_imap_internal_date_new (const gchar* original,
                              GDateTime* datetime)
{
	return geary_imap_internal_date_construct (GEARY_IMAP_TYPE_INTERNAL_DATE, original, datetime);
}

GearyImapInternalDate*
geary_imap_internal_date_construct_from_date_time (GType object_type,
                                                   GDateTime* datetime,
                                                   GError** error)
{
	GearyImapInternalDate * self = NULL;
	g_return_val_if_fail (datetime != NULL, NULL);
	self = (GearyImapInternalDate*) geary_message_data_abstract_message_data_construct (object_type);
	geary_imap_internal_date_set_value (self, datetime);
	return self;
}

GearyImapInternalDate*
geary_imap_internal_date_new_from_date_time (GDateTime* datetime,
                                             GError** error)
{
	return geary_imap_internal_date_construct_from_date_time (GEARY_IMAP_TYPE_INTERNAL_DATE, datetime, error);
}

static GTimeZone*
vala_g_time_zone_new_identifier (const gchar* identifier,
                                 GError** error)
{
	GTimeZone* self;
	GError* _inner_error0_ = NULL;
	self = (GTimeZone*) g_time_zone_new_identifier (identifier);
	if (((GTimeZone*) self) == NULL) {
		GError* _tmp0_;
		_tmp0_ = g_error_new_literal (G_CONVERT_ERROR, G_CONVERT_ERROR_ILLEGAL_SEQUENCE, "Invalid identifier argument");
		_inner_error0_ = _tmp0_;
		g_propagate_error (error, _inner_error0_);
		_g_time_zone_unref0 (self);
		return NULL;
	}
	return self;
}

GearyImapInternalDate*
geary_imap_internal_date_decode (const gchar* internaldate,
                                 GError** error)
{
	gint _tmp1_;
	gint _tmp2_;
	gint day = 0;
	gint year = 0;
	gint hour = 0;
	gint min = 0;
	gint sec = 0;
	gchar mon[4] = {0};
	gchar _tmp6_[4] = {0};
	gchar tz[6] = {0};
	gchar _tmp7_[6] = {0};
	gint count = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gint month = 0;
	gchar* mon_down = NULL;
	gchar* _tmp21_;
	GTimeZone* timezone = NULL;
	gchar _tmp27_;
	GTimeZone* _tmp36_;
	GDateTime* datetime = NULL;
	GTimeZone* _tmp38_;
	GDateTime* _tmp39_;
	GDateTime* _tmp40_;
	GearyImapInternalDate* _tmp41_;
	GError* _inner_error0_ = NULL;
	GearyImapInternalDate* result;
	g_return_val_if_fail (internaldate != NULL, NULL);
	if (geary_string_is_empty (internaldate)) {
		GError* _tmp0_;
		_tmp0_ = g_error_new_literal (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_PARSE_ERROR, "Invalid INTERNALDATE: empty string");
		_inner_error0_ = _tmp0_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = strlen (internaldate);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 64) {
		gint _tmp3_;
		gint _tmp4_;
		GError* _tmp5_;
		_tmp3_ = strlen (internaldate);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_PARSE_ERROR, "Invalid INTERNALDATE: too long (%d)", _tmp4_);
		_inner_error0_ = _tmp5_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp6_[0] = (gchar) 0;
	memcpy (mon, _tmp6_, 4 * sizeof (gchar));
	_tmp7_[0] = (gchar) 0;
	memcpy (tz, _tmp7_, 6 * sizeof (gchar));
	_tmp13_ = sscanf (internaldate, "%d-%3s-%d %d:%d:%d %5s", &_tmp8_, mon, &_tmp9_, &_tmp10_, &_tmp11_, &_tmp12_, tz);
	day = _tmp8_;
	year = _tmp9_;
	hour = _tmp10_;
	min = _tmp11_;
	sec = _tmp12_;
	count = _tmp13_;
	if (count != 6) {
		_tmp14_ = count != 7;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		GError* _tmp15_;
		_tmp15_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_PARSE_ERROR, "Invalid INTERNALDATE \"%s\": too few fields (%d)", internaldate, count);
		_inner_error0_ = _tmp15_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (!geary_numeric_int_in_range_inclusive (day, 1, 31)) {
		_tmp19_ = TRUE;
	} else {
		_tmp19_ = !geary_numeric_int_in_range_inclusive (hour, 0, 23);
	}
	if (_tmp19_) {
		_tmp18_ = TRUE;
	} else {
		_tmp18_ = !geary_numeric_int_in_range_inclusive (min, 0, 59);
	}
	if (_tmp18_) {
		_tmp17_ = TRUE;
	} else {
		_tmp17_ = !geary_numeric_int_in_range_inclusive (sec, 0, 59);
	}
	if (_tmp17_) {
		_tmp16_ = TRUE;
	} else {
		_tmp16_ = year < 1970;
	}
	if (_tmp16_) {
		GError* _tmp20_;
		_tmp20_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_PARSE_ERROR, "Invalid INTERNALDATE \"%s\": bad numerical range", internaldate);
		_inner_error0_ = _tmp20_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	month = -1;
	_tmp21_ = geary_ascii_strdown ((const gchar*) mon);
	mon_down = _tmp21_;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp22_ = FALSE;
			_tmp22_ = TRUE;
			while (TRUE) {
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = ctr;
					ctr = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(ctr < G_N_ELEMENTS (GEARY_IMAP_INTERNAL_DATE_EN_US_MON_DOWN))) {
					break;
				}
				_tmp24_ = mon_down;
				_tmp25_ = GEARY_IMAP_INTERNAL_DATE_EN_US_MON_DOWN[ctr];
				if (g_strcmp0 (_tmp24_, _tmp25_) == 0) {
					month = ctr;
					break;
				}
			}
		}
	}
	if (month < 0) {
		GError* _tmp26_;
		_tmp26_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_PARSE_ERROR, "Invalid INTERNALDATE \"%s\": bad month", internaldate);
		_inner_error0_ = _tmp26_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (mon_down);
			return NULL;
		} else {
			_g_free0 (mon_down);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	timezone = NULL;
	_tmp27_ = tz[0];
	if (_tmp27_ != '\0') {
		gchar* tz_string = NULL;
		gchar* _tmp28_;
		_tmp28_ = g_strdup ((const gchar*) tz);
		tz_string = _tmp28_;
		{
			GTimeZone* _tmp29_ = NULL;
			const gchar* _tmp30_;
			GTimeZone* _tmp31_;
			GTimeZone* _tmp32_;
			_tmp30_ = tz_string;
			_tmp31_ = vala_g_time_zone_new_identifier (_tmp30_, &_inner_error0_);
			_tmp29_ = _tmp31_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp32_ = _tmp29_;
			_tmp29_ = NULL;
			_g_time_zone_unref0 (timezone);
			timezone = _tmp32_;
			_g_time_zone_unref0 (_tmp29_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			const gchar* _tmp33_;
			GError* _tmp34_;
			const gchar* _tmp35_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp33_ = tz_string;
			_tmp34_ = err;
			_tmp35_ = _tmp34_->message;
			g_warning ("imap-internal-date.vala:88: Invalid INTERNALDATE timezone \"%s\", %s", _tmp33_, _tmp35_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (tz_string);
				_g_time_zone_unref0 (timezone);
				_g_free0 (mon_down);
				return NULL;
			} else {
				_g_free0 (tz_string);
				_g_time_zone_unref0 (timezone);
				_g_free0 (mon_down);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_g_free0 (tz_string);
	}
	_tmp36_ = timezone;
	if (_tmp36_ == NULL) {
		GTimeZone* _tmp37_;
		_tmp37_ = g_time_zone_new_local ();
		_g_time_zone_unref0 (timezone);
		timezone = _tmp37_;
	}
	_tmp38_ = timezone;
	_tmp39_ = g_date_time_new (_tmp38_, year, month + 1, day, hour, min, (gdouble) sec);
	datetime = _tmp39_;
	_tmp40_ = datetime;
	_tmp41_ = geary_imap_internal_date_new (internaldate, _tmp40_);
	result = _tmp41_;
	_g_date_time_unref0 (datetime);
	_g_time_zone_unref0 (timezone);
	_g_free0 (mon_down);
	return result;
}

/**
     * Returns the {@link InternalDate} as a {@link Parameter}.
     */
GearyImapParameter*
geary_imap_internal_date_to_parameter (GearyImapInternalDate* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GearyImapParameter* _tmp2_;
	GearyImapParameter* _tmp3_;
	GearyImapParameter* result;
	g_return_val_if_fail (GEARY_IMAP_IS_INTERNAL_DATE (self), NULL);
	_tmp0_ = geary_imap_internal_date_serialize (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_imap_parameter_get_for_string (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

/**
     * Returns the {@link InternalDate} as a {@link Parameter} for a {@link SearchCriterion}.
     *
     * @see serialize_for_search
     */
GearyImapParameter*
geary_imap_internal_date_to_search_parameter (GearyImapInternalDate* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GearyImapParameter* _tmp2_;
	GearyImapParameter* _tmp3_;
	GearyImapParameter* result;
	g_return_val_if_fail (GEARY_IMAP_IS_INTERNAL_DATE (self), NULL);
	_tmp0_ = geary_imap_internal_date_serialize_for_search (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_imap_parameter_get_for_string (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

/**
     * Returns the {@link InternalDate}'s string representation.
     *
     * @see serialize_for_search
     */
gchar*
geary_imap_internal_date_serialize (GearyImapInternalDate* self)
{
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp9_;
	gchar* result;
	g_return_val_if_fail (GEARY_IMAP_IS_INTERNAL_DATE (self), NULL);
	_tmp1_ = self->priv->_original;
	_tmp2_ = g_strdup (_tmp1_);
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		GDateTime* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp3_ = self->priv->_value;
		_tmp4_ = g_date_time_format (_tmp3_, "%d-%%s-%Y %H:%M:%S %z");
		_tmp5_ = _tmp4_;
		_tmp6_ = geary_imap_internal_date_get_en_us_mon (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf (_tmp5_, _tmp7_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp8_;
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
	}
	_tmp9_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp9_;
	_g_free0 (_tmp0_);
	return result;
}

/**
     * Returns the {@link InternalDate}'s string representation for a SEARCH command.
     *
     * SEARCH does not respect time or timezone, so drop when sending it.  See
     * [[http://tools.ietf.org/html/rfc3501#section-6.4.4]]
     *
     * @see serialize
     * @see SearchCommand
     */
gchar*
geary_imap_internal_date_serialize_for_search (GearyImapInternalDate* self)
{
	GDateTime* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (GEARY_IMAP_IS_INTERNAL_DATE (self), NULL);
	_tmp0_ = self->priv->_value;
	_tmp1_ = g_date_time_format (_tmp0_, "%d-%%s-%Y");
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_imap_internal_date_get_en_us_mon (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf (_tmp2_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	result = _tmp6_;
	return result;
}

/**
     * Because IMAP's INTERNALDATE strings are ''never'' localized (as best as I can gather), so
     * need to use en_US appreviated month names, as that's the only value in INTERNALDATE that is
     * in a language and not a numeric value.
     */
static gchar*
geary_imap_internal_date_get_en_us_mon (GearyImapInternalDate* self)
{
	gint mon = 0;
	GDateTime* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (GEARY_IMAP_IS_INTERNAL_DATE (self), NULL);
	_tmp0_ = self->priv->_value;
	mon = CLAMP (g_date_time_get_month (_tmp0_) - 1, 0, G_N_ELEMENTS (GEARY_IMAP_INTERNAL_DATE_EN_US_MON) - 1);
	_tmp1_ = GEARY_IMAP_INTERNAL_DATE_EN_US_MON[mon];
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

static guint
geary_imap_internal_date_real_hash (GeeHashable* base)
{
	GearyImapInternalDate * self;
	GDateTime* _tmp0_;
	guint result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_INTERNAL_DATE, GearyImapInternalDate);
	_tmp0_ = self->priv->_value;
	result = g_date_time_hash (_tmp0_);
	return result;
}

static gboolean
geary_imap_internal_date_real_equal_to (GeeHashable* base,
                                        GearyImapInternalDate* other)
{
	GearyImapInternalDate * self;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_INTERNAL_DATE, GearyImapInternalDate);
	g_return_val_if_fail (GEARY_IMAP_IS_INTERNAL_DATE (other), FALSE);
	_tmp0_ = self->priv->_value;
	_tmp1_ = other->priv->_value;
	result = g_date_time_equal (_tmp0_, _tmp1_);
	return result;
}

static gint
geary_imap_internal_date_real_compare_to (GeeComparable* base,
                                          GearyImapInternalDate* other)
{
	GearyImapInternalDate * self;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	gint result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_INTERNAL_DATE, GearyImapInternalDate);
	g_return_val_if_fail (GEARY_IMAP_IS_INTERNAL_DATE (other), 0);
	_tmp0_ = self->priv->_value;
	_tmp1_ = other->priv->_value;
	result = g_date_time_compare (_tmp0_, _tmp1_);
	return result;
}

static gchar*
geary_imap_internal_date_real_to_string (GearyMessageDataAbstractMessageData* base)
{
	GearyImapInternalDate * self;
	gchar* _tmp0_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_INTERNAL_DATE, GearyImapInternalDate);
	_tmp0_ = geary_imap_internal_date_serialize (self);
	result = _tmp0_;
	return result;
}

static void
geary_imap_internal_date_class_init (GearyImapInternalDateClass * klass,
                                     gpointer klass_data)
{
	geary_imap_internal_date_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapInternalDate_private_offset);
	((GearyMessageDataAbstractMessageDataClass *) klass)->to_string = (gchar* (*) (GearyMessageDataAbstractMessageData*)) geary_imap_internal_date_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_internal_date_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_imap_internal_date_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_internal_date_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_INTERNAL_DATE_VALUE_PROPERTY, geary_imap_internal_date_properties[GEARY_IMAP_INTERNAL_DATE_VALUE_PROPERTY] = g_param_spec_boxed ("value", "value", "value", G_TYPE_DATE_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_INTERNAL_DATE_ORIGINAL_PROPERTY, geary_imap_internal_date_properties[GEARY_IMAP_INTERNAL_DATE_ORIGINAL_PROPERTY] = g_param_spec_string ("original", "original", "original", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_imap_internal_date_geary_imap_message_data_interface_init (GearyImapMessageDataIface * iface,
                                                                 gpointer iface_data)
{
	geary_imap_internal_date_geary_imap_message_data_parent_iface = g_type_interface_peek_parent (iface);
}

static void
geary_imap_internal_date_gee_hashable_interface_init (GeeHashableIface * iface,
                                                      gpointer iface_data)
{
	geary_imap_internal_date_gee_hashable_parent_iface = g_type_interface_peek_parent (iface);
	iface->hash = (guint (*) (GeeHashable*)) geary_imap_internal_date_real_hash;
	iface->equal_to = (gboolean (*) (GeeHashable*, gconstpointer)) geary_imap_internal_date_real_equal_to;
}

static void
geary_imap_internal_date_gee_comparable_interface_init (GeeComparableIface * iface,
                                                        gpointer iface_data)
{
	geary_imap_internal_date_gee_comparable_parent_iface = g_type_interface_peek_parent (iface);
	iface->compare_to = (gint (*) (GeeComparable*, gconstpointer)) geary_imap_internal_date_real_compare_to;
}

static void
geary_imap_internal_date_instance_init (GearyImapInternalDate * self,
                                        gpointer klass)
{
	self->priv = geary_imap_internal_date_get_instance_private (self);
	self->priv->_original = NULL;
}

static void
geary_imap_internal_date_finalize (GObject * obj)
{
	GearyImapInternalDate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_TYPE_INTERNAL_DATE, GearyImapInternalDate);
	_g_date_time_unref0 (self->priv->_value);
	_g_free0 (self->priv->_original);
	G_OBJECT_CLASS (geary_imap_internal_date_parent_class)->finalize (obj);
}

/**
 * A representations of IMAP's INTERNALDATE field.
 *
 * INTERNALDATE's format is
 *
 * dd-Mon-yyyy hh:mm:ss +hhmm
 *
 * Note that Mon is the standard ''English'' three-letter abbreviation.
 *
 * See [[http://tools.ietf.org/html/rfc3501#section-2.3.3]]
 */
 G_GNUC_NO_INLINE static GType
geary_imap_internal_date_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapInternalDateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_internal_date_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapInternalDate), 0, (GInstanceInitFunc) geary_imap_internal_date_instance_init, NULL };
	static const GInterfaceInfo geary_imap_message_data_info = { (GInterfaceInitFunc) geary_imap_internal_date_geary_imap_message_data_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gee_hashable_info = { (GInterfaceInitFunc) geary_imap_internal_date_gee_hashable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gee_comparable_info = { (GInterfaceInitFunc) geary_imap_internal_date_gee_comparable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_imap_internal_date_type_id;
	geary_imap_internal_date_type_id = g_type_register_static (GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, "GearyImapInternalDate", &g_define_type_info, 0);
	g_type_add_interface_static (geary_imap_internal_date_type_id, GEARY_IMAP_TYPE_MESSAGE_DATA, &geary_imap_message_data_info);
	g_type_add_interface_static (geary_imap_internal_date_type_id, GEE_TYPE_HASHABLE, &gee_hashable_info);
	g_type_add_interface_static (geary_imap_internal_date_type_id, GEE_TYPE_COMPARABLE, &gee_comparable_info);
	GearyImapInternalDate_private_offset = g_type_add_instance_private (geary_imap_internal_date_type_id, sizeof (GearyImapInternalDatePrivate));
	return geary_imap_internal_date_type_id;
}

GType
geary_imap_internal_date_get_type (void)
{
	static gsize geary_imap_internal_date_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_internal_date_type_id__once)) {
		GType geary_imap_internal_date_type_id;
		geary_imap_internal_date_type_id = geary_imap_internal_date_get_type_once ();
		g_once_init_leave (&geary_imap_internal_date_type_id__once, geary_imap_internal_date_type_id);
	}
	return geary_imap_internal_date_type_id__once;
}

static void
_vala_geary_imap_internal_date_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	GearyImapInternalDate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_INTERNAL_DATE, GearyImapInternalDate);
	switch (property_id) {
		case GEARY_IMAP_INTERNAL_DATE_VALUE_PROPERTY:
		g_value_set_boxed (value, geary_imap_internal_date_get_value (self));
		break;
		case GEARY_IMAP_INTERNAL_DATE_ORIGINAL_PROPERTY:
		g_value_set_string (value, geary_imap_internal_date_get_original (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_imap_internal_date_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	GearyImapInternalDate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_INTERNAL_DATE, GearyImapInternalDate);
	switch (property_id) {
		case GEARY_IMAP_INTERNAL_DATE_VALUE_PROPERTY:
		geary_imap_internal_date_set_value (self, g_value_get_boxed (value));
		break;
		case GEARY_IMAP_INTERNAL_DATE_ORIGINAL_PROPERTY:
		geary_imap_internal_date_set_original (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

