/* imap-folder-properties.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from imap-folder-properties.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_IMAP_FOLDER_PROPERTIES_0_PROPERTY,
	GEARY_IMAP_FOLDER_PROPERTIES_SELECT_EXAMINE_MESSAGES_PROPERTY,
	GEARY_IMAP_FOLDER_PROPERTIES_STATUS_MESSAGES_PROPERTY,
	GEARY_IMAP_FOLDER_PROPERTIES_UNSEEN_PROPERTY,
	GEARY_IMAP_FOLDER_PROPERTIES_RECENT_PROPERTY,
	GEARY_IMAP_FOLDER_PROPERTIES_UID_VALIDITY_PROPERTY,
	GEARY_IMAP_FOLDER_PROPERTIES_UID_NEXT_PROPERTY,
	GEARY_IMAP_FOLDER_PROPERTIES_ATTRS_PROPERTY,
	GEARY_IMAP_FOLDER_PROPERTIES_NUM_PROPERTIES
};
static GParamSpec* geary_imap_folder_properties_properties[GEARY_IMAP_FOLDER_PROPERTIES_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GearyImapFolderPropertiesPrivate {
	gint _select_examine_messages;
	gint _status_messages;
	gint _unseen;
	gint _recent;
	GearyImapUIDValidity* _uid_validity;
	GearyImapUID* _uid_next;
	GearyImapMailboxAttributes* _attrs;
};

static gint GearyImapFolderProperties_private_offset;
static gpointer geary_imap_folder_properties_parent_class = NULL;

static void geary_imap_folder_properties_set_select_examine_messages (GearyImapFolderProperties* self,
                                                               gint value);
static void geary_imap_folder_properties_set_status_messages (GearyImapFolderProperties* self,
                                                       gint value);
static void geary_imap_folder_properties_set_unseen (GearyImapFolderProperties* self,
                                              gint value);
VALA_EXTERN void geary_imap_folder_properties_set_recent (GearyImapFolderProperties* self,
                                              gint value);
VALA_EXTERN void geary_imap_folder_properties_set_uid_validity (GearyImapFolderProperties* self,
                                                    GearyImapUIDValidity* value);
VALA_EXTERN void geary_imap_folder_properties_set_uid_next (GearyImapFolderProperties* self,
                                                GearyImapUID* value);
VALA_EXTERN void geary_imap_folder_properties_set_attrs (GearyImapFolderProperties* self,
                                             GearyImapMailboxAttributes* value);
VALA_EXTERN GearyImapFolderProperties* geary_imap_folder_properties_new_from_imapdb (GearyImapMailboxAttributes* attrs,
                                                                         gint email_total,
                                                                         gint email_unread,
                                                                         GearyImapUIDValidity* uid_validity,
                                                                         GearyImapUID* uid_next);
VALA_EXTERN GearyImapFolderProperties* geary_imap_folder_properties_construct_from_imapdb (GType object_type,
                                                                               GearyImapMailboxAttributes* attrs,
                                                                               gint email_total,
                                                                               gint email_unread,
                                                                               GearyImapUIDValidity* uid_validity,
                                                                               GearyImapUID* uid_next);
static void geary_imap_folder_properties_finalize (GObject * obj);
static GType geary_imap_folder_properties_get_type_once (void);
static void _vala_geary_imap_folder_properties_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_geary_imap_folder_properties_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);

static inline gpointer
geary_imap_folder_properties_get_instance_private (GearyImapFolderProperties* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapFolderProperties_private_offset);
}

gint
geary_imap_folder_properties_get_select_examine_messages (GearyImapFolderProperties* self)
{
	gint result;
	g_return_val_if_fail (GEARY_IMAP_IS_FOLDER_PROPERTIES (self), 0);
	result = self->priv->_select_examine_messages;
	return result;
}

static void
geary_imap_folder_properties_set_select_examine_messages (GearyImapFolderProperties* self,
                                                          gint value)
{
	gint old_value;
	g_return_if_fail (GEARY_IMAP_IS_FOLDER_PROPERTIES (self));
	old_value = geary_imap_folder_properties_get_select_examine_messages (self);
	if (old_value != value) {
		self->priv->_select_examine_messages = value;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_folder_properties_properties[GEARY_IMAP_FOLDER_PROPERTIES_SELECT_EXAMINE_MESSAGES_PROPERTY]);
	}
}

gint
geary_imap_folder_properties_get_status_messages (GearyImapFolderProperties* self)
{
	gint result;
	g_return_val_if_fail (GEARY_IMAP_IS_FOLDER_PROPERTIES (self), 0);
	result = self->priv->_status_messages;
	return result;
}

static void
geary_imap_folder_properties_set_status_messages (GearyImapFolderProperties* self,
                                                  gint value)
{
	gint old_value;
	g_return_if_fail (GEARY_IMAP_IS_FOLDER_PROPERTIES (self));
	old_value = geary_imap_folder_properties_get_status_messages (self);
	if (old_value != value) {
		self->priv->_status_messages = value;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_folder_properties_properties[GEARY_IMAP_FOLDER_PROPERTIES_STATUS_MESSAGES_PROPERTY]);
	}
}

gint
geary_imap_folder_properties_get_unseen (GearyImapFolderProperties* self)
{
	gint result;
	g_return_val_if_fail (GEARY_IMAP_IS_FOLDER_PROPERTIES (self), 0);
	result = self->priv->_unseen;
	return result;
}

static void
geary_imap_folder_properties_set_unseen (GearyImapFolderProperties* self,
                                         gint value)
{
	gint old_value;
	g_return_if_fail (GEARY_IMAP_IS_FOLDER_PROPERTIES (self));
	old_value = geary_imap_folder_properties_get_unseen (self);
	if (old_value != value) {
		self->priv->_unseen = value;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_folder_properties_properties[GEARY_IMAP_FOLDER_PROPERTIES_UNSEEN_PROPERTY]);
	}
}

gint
geary_imap_folder_properties_get_recent (GearyImapFolderProperties* self)
{
	gint result;
	g_return_val_if_fail (GEARY_IMAP_IS_FOLDER_PROPERTIES (self), 0);
	result = self->priv->_recent;
	return result;
}

void
geary_imap_folder_properties_set_recent (GearyImapFolderProperties* self,
                                         gint value)
{
	gint old_value;
	g_return_if_fail (GEARY_IMAP_IS_FOLDER_PROPERTIES (self));
	old_value = geary_imap_folder_properties_get_recent (self);
	if (old_value != value) {
		self->priv->_recent = value;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_folder_properties_properties[GEARY_IMAP_FOLDER_PROPERTIES_RECENT_PROPERTY]);
	}
}

GearyImapUIDValidity*
geary_imap_folder_properties_get_uid_validity (GearyImapFolderProperties* self)
{
	GearyImapUIDValidity* result;
	GearyImapUIDValidity* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_FOLDER_PROPERTIES (self), NULL);
	_tmp0_ = self->priv->_uid_validity;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
geary_imap_folder_properties_set_uid_validity (GearyImapFolderProperties* self,
                                               GearyImapUIDValidity* value)
{
	GearyImapUIDValidity* old_value;
	g_return_if_fail (GEARY_IMAP_IS_FOLDER_PROPERTIES (self));
	old_value = geary_imap_folder_properties_get_uid_validity (self);
	if (old_value != value) {
		GearyImapUIDValidity* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_uid_validity);
		self->priv->_uid_validity = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_folder_properties_properties[GEARY_IMAP_FOLDER_PROPERTIES_UID_VALIDITY_PROPERTY]);
	}
}

GearyImapUID*
geary_imap_folder_properties_get_uid_next (GearyImapFolderProperties* self)
{
	GearyImapUID* result;
	GearyImapUID* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_FOLDER_PROPERTIES (self), NULL);
	_tmp0_ = self->priv->_uid_next;
	result = _tmp0_;
	return result;
}

void
geary_imap_folder_properties_set_uid_next (GearyImapFolderProperties* self,
                                           GearyImapUID* value)
{
	GearyImapUID* old_value;
	g_return_if_fail (GEARY_IMAP_IS_FOLDER_PROPERTIES (self));
	old_value = geary_imap_folder_properties_get_uid_next (self);
	if (old_value != value) {
		GearyImapUID* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_uid_next);
		self->priv->_uid_next = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_folder_properties_properties[GEARY_IMAP_FOLDER_PROPERTIES_UID_NEXT_PROPERTY]);
	}
}

GearyImapMailboxAttributes*
geary_imap_folder_properties_get_attrs (GearyImapFolderProperties* self)
{
	GearyImapMailboxAttributes* result;
	GearyImapMailboxAttributes* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_FOLDER_PROPERTIES (self), NULL);
	_tmp0_ = self->priv->_attrs;
	result = _tmp0_;
	return result;
}

void
geary_imap_folder_properties_set_attrs (GearyImapFolderProperties* self,
                                        GearyImapMailboxAttributes* value)
{
	GearyImapMailboxAttributes* old_value;
	g_return_if_fail (GEARY_IMAP_IS_FOLDER_PROPERTIES (self));
	old_value = geary_imap_folder_properties_get_attrs (self);
	if (old_value != value) {
		GearyImapMailboxAttributes* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_attrs);
		self->priv->_attrs = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_folder_properties_properties[GEARY_IMAP_FOLDER_PROPERTIES_ATTRS_PROPERTY]);
	}
}

/**
     * Constructs properties for an IMAP folder that can be selected.
     */
GearyImapFolderProperties*
geary_imap_folder_properties_construct_selectable (GType object_type,
                                                   GearyImapMailboxAttributes* attrs,
                                                   GearyImapStatusData* status,
                                                   GearyImapCapabilities* capabilities)
{
	GearyImapFolderProperties * self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GearyImapUIDValidity* _tmp10_;
	GearyImapUIDValidity* _tmp11_;
	GearyImapUID* _tmp12_;
	GearyImapUID* _tmp13_;
	g_return_val_if_fail (GEARY_IMAP_IS_MAILBOX_ATTRIBUTES (attrs), NULL);
	g_return_val_if_fail (GEARY_IMAP_IS_STATUS_DATA (status), NULL);
	g_return_val_if_fail (GEARY_IMAP_IS_CAPABILITIES (capabilities), NULL);
	_tmp0_ = geary_imap_status_data_get_messages (status);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_imap_status_data_get_unseen (status);
	_tmp3_ = _tmp2_;
	self = (GearyImapFolderProperties*) geary_imap_folder_properties_construct (object_type, attrs, _tmp1_, _tmp3_, geary_imap_capabilities_supports_uidplus (capabilities));
	geary_imap_folder_properties_set_select_examine_messages (self, -1);
	_tmp4_ = geary_imap_status_data_get_messages (status);
	_tmp5_ = _tmp4_;
	geary_imap_folder_properties_set_status_messages (self, _tmp5_);
	_tmp6_ = geary_imap_status_data_get_recent (status);
	_tmp7_ = _tmp6_;
	geary_imap_folder_properties_set_recent (self, _tmp7_);
	_tmp8_ = geary_imap_status_data_get_unseen (status);
	_tmp9_ = _tmp8_;
	geary_imap_folder_properties_set_unseen (self, _tmp9_);
	_tmp10_ = geary_imap_status_data_get_uid_validity (status);
	_tmp11_ = _tmp10_;
	geary_imap_folder_properties_set_uid_validity (self, _tmp11_);
	_tmp12_ = geary_imap_status_data_get_uid_next (status);
	_tmp13_ = _tmp12_;
	geary_imap_folder_properties_set_uid_next (self, _tmp13_);
	return self;
}

GearyImapFolderProperties*
geary_imap_folder_properties_new_selectable (GearyImapMailboxAttributes* attrs,
                                             GearyImapStatusData* status,
                                             GearyImapCapabilities* capabilities)
{
	return geary_imap_folder_properties_construct_selectable (GEARY_IMAP_TYPE_FOLDER_PROPERTIES, attrs, status, capabilities);
}

/**
     * Constructs properties for an IMAP folder that can not be selected.
     */
GearyImapFolderProperties*
geary_imap_folder_properties_construct_not_selectable (GType object_type,
                                                       GearyImapMailboxAttributes* attrs)
{
	GearyImapFolderProperties * self = NULL;
	g_return_val_if_fail (GEARY_IMAP_IS_MAILBOX_ATTRIBUTES (attrs), NULL);
	self = (GearyImapFolderProperties*) geary_imap_folder_properties_construct (object_type, attrs, 0, 0, FALSE);
	geary_imap_folder_properties_set_select_examine_messages (self, 0);
	geary_imap_folder_properties_set_status_messages (self, -1);
	geary_imap_folder_properties_set_recent (self, 0);
	geary_imap_folder_properties_set_unseen (self, -1);
	geary_imap_folder_properties_set_uid_validity (self, NULL);
	geary_imap_folder_properties_set_uid_next (self, NULL);
	return self;
}

GearyImapFolderProperties*
geary_imap_folder_properties_new_not_selectable (GearyImapMailboxAttributes* attrs)
{
	return geary_imap_folder_properties_construct_not_selectable (GEARY_IMAP_TYPE_FOLDER_PROPERTIES, attrs);
}

/**
     * Reconstitutes properties for an IMAP folder from the database
     */
GearyImapFolderProperties*
geary_imap_folder_properties_construct_from_imapdb (GType object_type,
                                                    GearyImapMailboxAttributes* attrs,
                                                    gint email_total,
                                                    gint email_unread,
                                                    GearyImapUIDValidity* uid_validity,
                                                    GearyImapUID* uid_next)
{
	GearyImapFolderProperties * self = NULL;
	g_return_val_if_fail (GEARY_IMAP_IS_MAILBOX_ATTRIBUTES (attrs), NULL);
	g_return_val_if_fail ((uid_validity == NULL) || GEARY_IMAP_IS_UID_VALIDITY (uid_validity), NULL);
	g_return_val_if_fail ((uid_next == NULL) || GEARY_IMAP_IS_UID (uid_next), NULL);
	self = (GearyImapFolderProperties*) geary_imap_folder_properties_construct (object_type, attrs, email_total, email_unread, FALSE);
	geary_imap_folder_properties_set_select_examine_messages (self, email_total);
	geary_imap_folder_properties_set_status_messages (self, -1);
	geary_imap_folder_properties_set_recent (self, 0);
	geary_imap_folder_properties_set_unseen (self, -1);
	geary_imap_folder_properties_set_uid_validity (self, uid_validity);
	geary_imap_folder_properties_set_uid_next (self, uid_next);
	return self;
}

GearyImapFolderProperties*
geary_imap_folder_properties_new_from_imapdb (GearyImapMailboxAttributes* attrs,
                                              gint email_total,
                                              gint email_unread,
                                              GearyImapUIDValidity* uid_validity,
                                              GearyImapUID* uid_next)
{
	return geary_imap_folder_properties_construct_from_imapdb (GEARY_IMAP_TYPE_FOLDER_PROPERTIES, attrs, email_total, email_unread, uid_validity, uid_next);
}

GearyImapFolderProperties*
geary_imap_folder_properties_construct (GType object_type,
                                        GearyImapMailboxAttributes* attrs,
                                        gint email_total,
                                        gint email_unread,
                                        gboolean supports_uid)
{
	GearyImapFolderProperties * self = NULL;
	GearyTrillian has_children = 0;
	GearyImapMailboxAttribute* _tmp0_;
	GearyImapMailboxAttribute* _tmp1_;
	GearyTrillian supports_children = 0;
	GearyTrillian is_openable = 0;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_val_if_fail (GEARY_IMAP_IS_MAILBOX_ATTRIBUTES (attrs), NULL);
	has_children = GEARY_TRILLIAN_UNKNOWN;
	_tmp0_ = geary_imap_mailbox_attribute_get_HAS_NO_CHILDREN ();
	_tmp1_ = _tmp0_;
	if (geary_imap_flags_contains (G_TYPE_CHECK_INSTANCE_CAST (attrs, GEARY_IMAP_TYPE_FLAGS, GearyImapFlags), G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEARY_IMAP_TYPE_FLAG, GearyImapFlag))) {
		has_children = GEARY_TRILLIAN_FALSE;
	} else {
		GearyImapMailboxAttribute* _tmp2_;
		GearyImapMailboxAttribute* _tmp3_;
		_tmp2_ = geary_imap_mailbox_attribute_get_HAS_CHILDREN ();
		_tmp3_ = _tmp2_;
		if (geary_imap_flags_contains (G_TYPE_CHECK_INSTANCE_CAST (attrs, GEARY_IMAP_TYPE_FLAGS, GearyImapFlags), G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEARY_IMAP_TYPE_FLAG, GearyImapFlag))) {
			has_children = GEARY_TRILLIAN_TRUE;
		}
	}
	supports_children = GEARY_TRILLIAN_UNKNOWN;
	if (has_children != GEARY_TRILLIAN_UNKNOWN) {
		supports_children = has_children;
	} else {
		GearyImapMailboxAttribute* _tmp4_;
		GearyImapMailboxAttribute* _tmp5_;
		_tmp4_ = geary_imap_mailbox_attribute_get_NO_INFERIORS ();
		_tmp5_ = _tmp4_;
		supports_children = geary_trillian_from_boolean (!geary_imap_flags_contains (G_TYPE_CHECK_INSTANCE_CAST (attrs, GEARY_IMAP_TYPE_FLAGS, GearyImapFlags), G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEARY_IMAP_TYPE_FLAG, GearyImapFlag)));
		if (geary_trillian_is_impossible (supports_children)) {
			has_children = GEARY_TRILLIAN_FALSE;
		}
	}
	_tmp6_ = geary_imap_mailbox_attributes_get_is_no_select (attrs);
	_tmp7_ = _tmp6_;
	is_openable = geary_trillian_from_boolean (!_tmp7_);
	self = (GearyImapFolderProperties*) geary_folder_properties_construct (object_type, email_total, email_unread, has_children, supports_children, is_openable, FALSE, FALSE, !supports_uid);
	geary_imap_folder_properties_set_attrs (self, attrs);
	return self;
}

GearyImapFolderProperties*
geary_imap_folder_properties_new (GearyImapMailboxAttributes* attrs,
                                  gint email_total,
                                  gint email_unread,
                                  gboolean supports_uid)
{
	return geary_imap_folder_properties_construct (GEARY_IMAP_TYPE_FOLDER_PROPERTIES, attrs, email_total, email_unread, supports_uid);
}

/**
     * Use with {@link FolderProperties} of the *same folder* seen at different times (i.e. after
     * SELECTing versus data stored locally).  Only compares fields that suggest the contents of
     * the folder have changed.
     *
     * Note that have_contents_changed does *not* discern if message flags have changed.
     */
gboolean
geary_imap_folder_properties_have_contents_changed (GearyImapFolderProperties* self,
                                                    GearyImapFolderProperties* other,
                                                    const gchar* name)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GearyImapUID* _tmp2_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	GearyImapUIDValidity* _tmp14_;
	gboolean _tmp24_ = FALSE;
	gint _tmp25_;
	gboolean _tmp31_ = FALSE;
	gint _tmp32_;
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_IS_FOLDER_PROPERTIES (self), FALSE);
	g_return_val_if_fail (GEARY_IMAP_IS_FOLDER_PROPERTIES (other), FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp2_ = self->priv->_uid_next;
	if (_tmp2_ != NULL) {
		GearyImapUID* _tmp3_;
		_tmp3_ = other->priv->_uid_next;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GearyImapUID* _tmp4_;
		GearyImapUID* _tmp5_;
		_tmp4_ = self->priv->_uid_next;
		_tmp5_ = other->priv->_uid_next;
		_tmp0_ = !geary_message_data_int64_message_data_equal_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData), G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GearyImapUID* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GearyImapUID* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp6_ = self->priv->_uid_next;
		_tmp7_ = geary_message_data_abstract_message_data_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, GearyMessageDataAbstractMessageData));
		_tmp8_ = _tmp7_;
		_tmp9_ = other->priv->_uid_next;
		_tmp10_ = geary_message_data_abstract_message_data_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, GearyMessageDataAbstractMessageData));
		_tmp11_ = _tmp10_;
		g_debug ("imap-folder-properties.vala:156: %s FolderProperties changed: UIDNEXT=" \
"%s other.UIDNEXT=%s", name, _tmp8_, _tmp11_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp8_);
		result = TRUE;
		return result;
	}
	_tmp14_ = self->priv->_uid_validity;
	if (_tmp14_ != NULL) {
		GearyImapUIDValidity* _tmp15_;
		_tmp15_ = other->priv->_uid_validity;
		_tmp13_ = _tmp15_ != NULL;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		GearyImapUIDValidity* _tmp16_;
		GearyImapUIDValidity* _tmp17_;
		_tmp16_ = self->priv->_uid_validity;
		_tmp17_ = other->priv->_uid_validity;
		_tmp12_ = !geary_message_data_int64_message_data_equal_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData), G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		GearyImapUIDValidity* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		GearyImapUIDValidity* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp18_ = self->priv->_uid_validity;
		_tmp19_ = geary_message_data_abstract_message_data_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, GearyMessageDataAbstractMessageData));
		_tmp20_ = _tmp19_;
		_tmp21_ = other->priv->_uid_validity;
		_tmp22_ = geary_message_data_abstract_message_data_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, GearyMessageDataAbstractMessageData));
		_tmp23_ = _tmp22_;
		g_debug ("imap-folder-properties.vala:165: %s FolderProperties changed: UIDVALID" \
"ITY=%s other.UIDVALIDITY=%s", name, _tmp20_, _tmp23_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp20_);
		result = TRUE;
		return result;
	}
	_tmp25_ = self->priv->_select_examine_messages;
	if (_tmp25_ >= 0) {
		gint _tmp26_;
		_tmp26_ = other->priv->_select_examine_messages;
		_tmp24_ = _tmp26_ >= 0;
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		gint diff = 0;
		gint _tmp27_;
		gint _tmp28_;
		_tmp27_ = self->priv->_select_examine_messages;
		_tmp28_ = other->priv->_select_examine_messages;
		diff = _tmp27_ - _tmp28_;
		if (diff != 0) {
			gint _tmp29_;
			gint _tmp30_;
			_tmp29_ = self->priv->_select_examine_messages;
			_tmp30_ = other->priv->_select_examine_messages;
			g_debug ("imap-folder-properties.vala:177: %s FolderProperties changed: SELECT/E" \
"XAMINE=%d other.SELECT/EXAMINE=%d diff=%d", name, _tmp29_, _tmp30_, diff);
			result = TRUE;
			return result;
		}
	}
	_tmp32_ = self->priv->_status_messages;
	if (_tmp32_ >= 0) {
		gint _tmp33_;
		_tmp33_ = other->priv->_status_messages;
		_tmp31_ = _tmp33_ >= 0;
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		gint diff = 0;
		gint _tmp34_;
		gint _tmp35_;
		_tmp34_ = self->priv->_status_messages;
		_tmp35_ = other->priv->_status_messages;
		diff = _tmp34_ - _tmp35_;
		if (diff != 0) {
			gint _tmp36_;
			gint _tmp37_;
			_tmp36_ = self->priv->_status_messages;
			_tmp37_ = other->priv->_status_messages;
			g_debug ("imap-folder-properties.vala:187: %s FolderProperties changed: STATUS=%" \
"d other.STATUS=%d diff=%d", name, _tmp36_, _tmp37_, diff);
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}

/**
     * Update an existing {@link FolderProperties} with fresh {@link StatusData}.
     *
     * This will force the {@link Geary.FolderProperties.email_total} property to match the
     * {@link status_messages} value.
     */
void
geary_imap_folder_properties_update_status (GearyImapFolderProperties* self,
                                            GearyImapStatusData* status)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GearyImapUIDValidity* _tmp6_;
	GearyImapUIDValidity* _tmp7_;
	GearyImapUID* _tmp8_;
	GearyImapUID* _tmp9_;
	g_return_if_fail (GEARY_IMAP_IS_FOLDER_PROPERTIES (self));
	g_return_if_fail (GEARY_IMAP_IS_STATUS_DATA (status));
	_tmp0_ = geary_imap_status_data_get_messages (status);
	_tmp1_ = _tmp0_;
	geary_imap_folder_properties_set_status_message_count (self, _tmp1_, TRUE);
	_tmp2_ = geary_imap_status_data_get_unseen (status);
	_tmp3_ = _tmp2_;
	geary_imap_folder_properties_set_status_unseen (self, _tmp3_);
	_tmp4_ = geary_imap_status_data_get_recent (status);
	_tmp5_ = _tmp4_;
	geary_imap_folder_properties_set_recent (self, _tmp5_);
	_tmp6_ = geary_imap_status_data_get_uid_validity (status);
	_tmp7_ = _tmp6_;
	geary_imap_folder_properties_set_uid_validity (self, _tmp7_);
	_tmp8_ = geary_imap_status_data_get_uid_next (status);
	_tmp9_ = _tmp8_;
	geary_imap_folder_properties_set_uid_next (self, _tmp9_);
}

void
geary_imap_folder_properties_set_status_message_count (GearyImapFolderProperties* self,
                                                       gint messages,
                                                       gboolean force)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (GEARY_IMAP_IS_FOLDER_PROPERTIES (self));
	if (messages < 0) {
		return;
	}
	geary_imap_folder_properties_set_status_messages (self, messages);
	if (force) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp1_;
		_tmp1_ = self->priv->_select_examine_messages;
		_tmp0_ = _tmp1_ < 0;
	}
	if (_tmp0_) {
		geary_folder_properties_set_email_total (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_FOLDER_PROPERTIES, GearyFolderProperties), messages);
	}
}

void
geary_imap_folder_properties_set_select_examine_message_count (GearyImapFolderProperties* self,
                                                               gint messages)
{
	g_return_if_fail (GEARY_IMAP_IS_FOLDER_PROPERTIES (self));
	if (messages < 0) {
		return;
	}
	geary_imap_folder_properties_set_select_examine_messages (self, messages);
	geary_folder_properties_set_email_total (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_FOLDER_PROPERTIES, GearyFolderProperties), messages);
}

void
geary_imap_folder_properties_set_status_unseen (GearyImapFolderProperties* self,
                                                gint count)
{
	g_return_if_fail (GEARY_IMAP_IS_FOLDER_PROPERTIES (self));
	if (count < 0) {
		return;
	}
	geary_imap_folder_properties_set_unseen (self, count);
	geary_folder_properties_set_email_unread (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_FOLDER_PROPERTIES, GearyFolderProperties), count);
}

void
geary_imap_folder_properties_set_from_session_capabilities (GearyImapFolderProperties* self,
                                                            GearyImapCapabilities* capabilities)
{
	g_return_if_fail (GEARY_IMAP_IS_FOLDER_PROPERTIES (self));
	g_return_if_fail (GEARY_IMAP_IS_CAPABILITIES (capabilities));
	geary_folder_properties_set_create_never_returns_id (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_FOLDER_PROPERTIES, GearyFolderProperties), !geary_imap_capabilities_supports_uidplus (capabilities));
}

static void
geary_imap_folder_properties_class_init (GearyImapFolderPropertiesClass * klass,
                                         gpointer klass_data)
{
	geary_imap_folder_properties_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapFolderProperties_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_folder_properties_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_imap_folder_properties_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_folder_properties_finalize;
	/**
	     * -1 if the Folder was not opened via SELECT or EXAMINE.  Updated as EXISTS server data
	     * arrives.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_FOLDER_PROPERTIES_SELECT_EXAMINE_MESSAGES_PROPERTY, geary_imap_folder_properties_properties[GEARY_IMAP_FOLDER_PROPERTIES_SELECT_EXAMINE_MESSAGES_PROPERTY] = g_param_spec_int ("select-examine-messages", "select-examine-messages", "select-examine-messages", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * -1 if the FolderProperties were not obtained or updated via a STATUS command
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_FOLDER_PROPERTIES_STATUS_MESSAGES_PROPERTY, geary_imap_folder_properties_properties[GEARY_IMAP_FOLDER_PROPERTIES_STATUS_MESSAGES_PROPERTY] = g_param_spec_int ("status-messages", "status-messages", "status-messages", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * -1 if the FolderProperties were not obtained or updated via a STATUS command
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_FOLDER_PROPERTIES_UNSEEN_PROPERTY, geary_imap_folder_properties_properties[GEARY_IMAP_FOLDER_PROPERTIES_UNSEEN_PROPERTY] = g_param_spec_int ("unseen", "unseen", "unseen", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_FOLDER_PROPERTIES_RECENT_PROPERTY, geary_imap_folder_properties_properties[GEARY_IMAP_FOLDER_PROPERTIES_RECENT_PROPERTY] = g_param_spec_int ("recent", "recent", "recent", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_FOLDER_PROPERTIES_UID_VALIDITY_PROPERTY, geary_imap_folder_properties_properties[GEARY_IMAP_FOLDER_PROPERTIES_UID_VALIDITY_PROPERTY] = g_param_spec_object ("uid-validity", "uid-validity", "uid-validity", GEARY_IMAP_TYPE_UID_VALIDITY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_FOLDER_PROPERTIES_UID_NEXT_PROPERTY, geary_imap_folder_properties_properties[GEARY_IMAP_FOLDER_PROPERTIES_UID_NEXT_PROPERTY] = g_param_spec_object ("uid-next", "uid-next", "uid-next", GEARY_IMAP_TYPE_UID, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_FOLDER_PROPERTIES_ATTRS_PROPERTY, geary_imap_folder_properties_properties[GEARY_IMAP_FOLDER_PROPERTIES_ATTRS_PROPERTY] = g_param_spec_object ("attrs", "attrs", "attrs", GEARY_IMAP_TYPE_MAILBOX_ATTRIBUTES, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
geary_imap_folder_properties_instance_init (GearyImapFolderProperties * self,
                                            gpointer klass)
{
	self->priv = geary_imap_folder_properties_get_instance_private (self);
}

static void
geary_imap_folder_properties_finalize (GObject * obj)
{
	GearyImapFolderProperties * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_TYPE_FOLDER_PROPERTIES, GearyImapFolderProperties);
	_g_object_unref0 (self->priv->_uid_validity);
	_g_object_unref0 (self->priv->_uid_next);
	_g_object_unref0 (self->priv->_attrs);
	G_OBJECT_CLASS (geary_imap_folder_properties_parent_class)->finalize (obj);
}

/**
 * Geary.Imap.FolderProperties represent the Geary API's notion of FolderProperties but
 * also hangs additional useful information available to IMAP-specific code (in the Engine,
 * that includes imap, imap-engine, and imap-db).
 *
 * One important concept here is that there are two IMAP commands that return this information:
 * STATUS (which is used by the background folder monitor to watch for specific events) and
 * SELECT/EXAMINE (which is used to "enter" or "cd" into a folder and perform operations on mail
 * within).
 *
 * Experience has shown that these commands are *not* guaranteed to return the same information,
 * even if no state has changed on the server.  This would seem to be a server bug, but one that
 * has to be worked around.
 *
 * In any event, the properties here are updated by the following logic:
 *
 * When a folder is first "seen" by Geary, it generates an Imap.FolderProperties object with all
 * the fields filled in except for status_messages or select_examine_messages, depending on which
 * command was used to discover it.  (In practice, the folder will be first recognized via STATUS,
 * but this isn't guaranteed.)
 *
 * When new STATUS information comes in, this object's status_messages, unseen, recent, and attrs
 * fields are updated.
 *
 * When a SELECT/EXAMINE occurs on this folder, this object's select_examine_messages,
 * recent, uid_validity, and uid_next are updated.
 *
 * Over time, this object accumulates information depending on what operation was last
 * performed on it.
 *
 * The base class' email_total is updated when either *_messages is updated; however, SELECT/EXAMINE
 * is considered more authoritative than STATUS.
 */
 G_GNUC_NO_INLINE static GType
geary_imap_folder_properties_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapFolderPropertiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_folder_properties_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapFolderProperties), 0, (GInstanceInitFunc) geary_imap_folder_properties_instance_init, NULL };
	GType geary_imap_folder_properties_type_id;
	geary_imap_folder_properties_type_id = g_type_register_static (GEARY_TYPE_FOLDER_PROPERTIES, "GearyImapFolderProperties", &g_define_type_info, 0);
	GearyImapFolderProperties_private_offset = g_type_add_instance_private (geary_imap_folder_properties_type_id, sizeof (GearyImapFolderPropertiesPrivate));
	return geary_imap_folder_properties_type_id;
}

GType
geary_imap_folder_properties_get_type (void)
{
	static gsize geary_imap_folder_properties_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_folder_properties_type_id__once)) {
		GType geary_imap_folder_properties_type_id;
		geary_imap_folder_properties_type_id = geary_imap_folder_properties_get_type_once ();
		g_once_init_leave (&geary_imap_folder_properties_type_id__once, geary_imap_folder_properties_type_id);
	}
	return geary_imap_folder_properties_type_id__once;
}

static void
_vala_geary_imap_folder_properties_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	GearyImapFolderProperties * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_FOLDER_PROPERTIES, GearyImapFolderProperties);
	switch (property_id) {
		case GEARY_IMAP_FOLDER_PROPERTIES_SELECT_EXAMINE_MESSAGES_PROPERTY:
		g_value_set_int (value, geary_imap_folder_properties_get_select_examine_messages (self));
		break;
		case GEARY_IMAP_FOLDER_PROPERTIES_STATUS_MESSAGES_PROPERTY:
		g_value_set_int (value, geary_imap_folder_properties_get_status_messages (self));
		break;
		case GEARY_IMAP_FOLDER_PROPERTIES_UNSEEN_PROPERTY:
		g_value_set_int (value, geary_imap_folder_properties_get_unseen (self));
		break;
		case GEARY_IMAP_FOLDER_PROPERTIES_RECENT_PROPERTY:
		g_value_set_int (value, geary_imap_folder_properties_get_recent (self));
		break;
		case GEARY_IMAP_FOLDER_PROPERTIES_UID_VALIDITY_PROPERTY:
		g_value_set_object (value, geary_imap_folder_properties_get_uid_validity (self));
		break;
		case GEARY_IMAP_FOLDER_PROPERTIES_UID_NEXT_PROPERTY:
		g_value_set_object (value, geary_imap_folder_properties_get_uid_next (self));
		break;
		case GEARY_IMAP_FOLDER_PROPERTIES_ATTRS_PROPERTY:
		g_value_set_object (value, geary_imap_folder_properties_get_attrs (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_imap_folder_properties_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	GearyImapFolderProperties * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_FOLDER_PROPERTIES, GearyImapFolderProperties);
	switch (property_id) {
		case GEARY_IMAP_FOLDER_PROPERTIES_SELECT_EXAMINE_MESSAGES_PROPERTY:
		geary_imap_folder_properties_set_select_examine_messages (self, g_value_get_int (value));
		break;
		case GEARY_IMAP_FOLDER_PROPERTIES_STATUS_MESSAGES_PROPERTY:
		geary_imap_folder_properties_set_status_messages (self, g_value_get_int (value));
		break;
		case GEARY_IMAP_FOLDER_PROPERTIES_UNSEEN_PROPERTY:
		geary_imap_folder_properties_set_unseen (self, g_value_get_int (value));
		break;
		case GEARY_IMAP_FOLDER_PROPERTIES_RECENT_PROPERTY:
		geary_imap_folder_properties_set_recent (self, g_value_get_int (value));
		break;
		case GEARY_IMAP_FOLDER_PROPERTIES_UID_VALIDITY_PROPERTY:
		geary_imap_folder_properties_set_uid_validity (self, g_value_get_object (value));
		break;
		case GEARY_IMAP_FOLDER_PROPERTIES_UID_NEXT_PROPERTY:
		geary_imap_folder_properties_set_uid_next (self, g_value_get_object (value));
		break;
		case GEARY_IMAP_FOLDER_PROPERTIES_ATTRS_PROPERTY:
		geary_imap_folder_properties_set_attrs (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

