/* imap-engine-replay-append.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from imap-engine-replay-append.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define GEARY_IMAP_DB_FOLDER_REQUIRED_FIELDS ((GEARY_EMAIL_FIELD_PROPERTIES | GEARY_EMAIL_FIELD_REFERENCES) | GEARY_EMAIL_FIELD_FLAGS)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION (geary_imap_engine_replay_operation_get_type ())
#define GEARY_IMAP_ENGINE_REPLAY_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperation))
#define GEARY_IMAP_ENGINE_REPLAY_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperationClass))
#define GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION))
#define GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION))
#define GEARY_IMAP_ENGINE_REPLAY_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperationClass))

typedef struct _GearyImapEngineReplayOperation GearyImapEngineReplayOperation;
typedef struct _GearyImapEngineReplayOperationClass GearyImapEngineReplayOperationClass;
typedef struct _GearyImapEngineReplayOperationPrivate GearyImapEngineReplayOperationPrivate;

#define GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER (geary_imap_db_email_identifier_get_type ())
#define GEARY_IMAP_DB_EMAIL_IDENTIFIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifier))
#define GEARY_IMAP_DB_EMAIL_IDENTIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifierClass))
#define GEARY_IMAP_DB_IS_EMAIL_IDENTIFIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER))
#define GEARY_IMAP_DB_IS_EMAIL_IDENTIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER))
#define GEARY_IMAP_DB_EMAIL_IDENTIFIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifierClass))

typedef struct _GearyImapDBEmailIdentifier GearyImapDBEmailIdentifier;
typedef struct _GearyImapDBEmailIdentifierClass GearyImapDBEmailIdentifierClass;
typedef enum  {
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_STATUS_COMPLETED,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_STATUS_CONTINUE
} GearyImapEngineReplayOperationStatus;

#define GEARY_IMAP_ENGINE_REPLAY_OPERATION_TYPE_STATUS (geary_imap_engine_replay_operation_status_get_type ())

#define GEARY_IMAP_TYPE_FOLDER_SESSION (geary_imap_folder_session_get_type ())
#define GEARY_IMAP_FOLDER_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_TYPE_FOLDER_SESSION, GearyImapFolderSession))
#define GEARY_IMAP_FOLDER_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_TYPE_FOLDER_SESSION, GearyImapFolderSessionClass))
#define GEARY_IMAP_IS_FOLDER_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_TYPE_FOLDER_SESSION))
#define GEARY_IMAP_IS_FOLDER_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_TYPE_FOLDER_SESSION))
#define GEARY_IMAP_FOLDER_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_TYPE_FOLDER_SESSION, GearyImapFolderSessionClass))

typedef struct _GearyImapFolderSession GearyImapFolderSession;
typedef struct _GearyImapFolderSessionClass GearyImapFolderSessionClass;

#define GEARY_IMAP_ENGINE_TYPE_REPLAY_APPEND (geary_imap_engine_replay_append_get_type ())
#define GEARY_IMAP_ENGINE_REPLAY_APPEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_APPEND, GearyImapEngineReplayAppend))
#define GEARY_IMAP_ENGINE_REPLAY_APPEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_REPLAY_APPEND, GearyImapEngineReplayAppendClass))
#define GEARY_IMAP_ENGINE_IS_REPLAY_APPEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_APPEND))
#define GEARY_IMAP_ENGINE_IS_REPLAY_APPEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_REPLAY_APPEND))
#define GEARY_IMAP_ENGINE_REPLAY_APPEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_APPEND, GearyImapEngineReplayAppendClass))

typedef struct _GearyImapEngineReplayAppend GearyImapEngineReplayAppend;
typedef struct _GearyImapEngineReplayAppendClass GearyImapEngineReplayAppendClass;
typedef struct _GearyImapEngineReplayAppendPrivate GearyImapEngineReplayAppendPrivate;

#define GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER (geary_imap_engine_minimal_folder_get_type ())
#define GEARY_IMAP_ENGINE_MINIMAL_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, GearyImapEngineMinimalFolder))
#define GEARY_IMAP_ENGINE_MINIMAL_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, GearyImapEngineMinimalFolderClass))
#define GEARY_IMAP_ENGINE_IS_MINIMAL_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER))
#define GEARY_IMAP_ENGINE_IS_MINIMAL_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER))
#define GEARY_IMAP_ENGINE_MINIMAL_FOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, GearyImapEngineMinimalFolderClass))

typedef struct _GearyImapEngineMinimalFolder GearyImapEngineMinimalFolder;
typedef struct _GearyImapEngineMinimalFolderClass GearyImapEngineMinimalFolderClass;
enum  {
	GEARY_IMAP_ENGINE_REPLAY_APPEND_0_PROPERTY,
	GEARY_IMAP_ENGINE_REPLAY_APPEND_NUM_PROPERTIES
};
static GParamSpec* geary_imap_engine_replay_append_properties[GEARY_IMAP_ENGINE_REPLAY_APPEND_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_SCOPE_LOCAL_AND_REMOTE,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_SCOPE_LOCAL_ONLY,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_SCOPE_REMOTE_ONLY
} GearyImapEngineReplayOperationScope;

#define GEARY_IMAP_ENGINE_REPLAY_OPERATION_TYPE_SCOPE (geary_imap_engine_replay_operation_scope_get_type ())
typedef enum  {
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_ERROR_THROW,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_ERROR_RETRY,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_ERROR_IGNORE_REMOTE
} GearyImapEngineReplayOperationOnError;

#define GEARY_IMAP_ENGINE_REPLAY_OPERATION_TYPE_ON_ERROR (geary_imap_engine_replay_operation_on_error_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GearyImapEngineReplayAppendReplayRemoteAsyncData GearyImapEngineReplayAppendReplayRemoteAsyncData;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define GEARY_IMAP_DB_TYPE_FOLDER (geary_imap_db_folder_get_type ())
#define GEARY_IMAP_DB_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_DB_TYPE_FOLDER, GearyImapDBFolder))
#define GEARY_IMAP_DB_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_DB_TYPE_FOLDER, GearyImapDBFolderClass))
#define GEARY_IMAP_DB_IS_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_DB_TYPE_FOLDER))
#define GEARY_IMAP_DB_IS_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_DB_TYPE_FOLDER))
#define GEARY_IMAP_DB_FOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_DB_TYPE_FOLDER, GearyImapDBFolderClass))

typedef struct _GearyImapDBFolder GearyImapDBFolder;
typedef struct _GearyImapDBFolderClass GearyImapDBFolderClass;

#define GEARY_TYPE_CONTACT_HARVESTER (geary_contact_harvester_get_type ())
#define GEARY_CONTACT_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_TYPE_CONTACT_HARVESTER, GearyContactHarvester))
#define GEARY_IS_CONTACT_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_TYPE_CONTACT_HARVESTER))
#define GEARY_CONTACT_HARVESTER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEARY_TYPE_CONTACT_HARVESTER, GearyContactHarvesterIface))

typedef struct _GearyContactHarvester GearyContactHarvester;
typedef struct _GearyContactHarvesterIface GearyContactHarvesterIface;
typedef struct _GearyImapEngineReplayAppendDoReplayAppendedMessagesData GearyImapEngineReplayAppendDoReplayAppendedMessagesData;
enum  {
	GEARY_IMAP_ENGINE_REPLAY_APPEND_EMAIL_APPENDED_SIGNAL,
	GEARY_IMAP_ENGINE_REPLAY_APPEND_EMAIL_LOCALLY_APPENDED_SIGNAL,
	GEARY_IMAP_ENGINE_REPLAY_APPEND_EMAIL_COUNT_CHANGED_SIGNAL,
	GEARY_IMAP_ENGINE_REPLAY_APPEND_NUM_SIGNALS
};
static guint geary_imap_engine_replay_append_signals[GEARY_IMAP_ENGINE_REPLAY_APPEND_NUM_SIGNALS] = {0};

struct _GearyImapEngineReplayOperation {
	GearyBaseObject parent_instance;
	GearyImapEngineReplayOperationPrivate * priv;
};

struct _GearyImapEngineReplayOperationClass {
	GearyBaseObjectClass parent_class;
	void (*notify_remote_removed_position) (GearyImapEngineReplayOperation* self, GearyImapSequenceNumber* removed);
	void (*notify_remote_removed_ids) (GearyImapEngineReplayOperation* self, GeeCollection* ids);
	void (*get_ids_to_be_remote_removed) (GearyImapEngineReplayOperation* self, GeeCollection* ids);
	void (*replay_local_async) (GearyImapEngineReplayOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GearyImapEngineReplayOperationStatus (*replay_local_finish) (GearyImapEngineReplayOperation* self, GAsyncResult* _res_, GError** error);
	void (*replay_remote_async) (GearyImapEngineReplayOperation* self, GearyImapFolderSession* remote, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*replay_remote_finish) (GearyImapEngineReplayOperation* self, GAsyncResult* _res_, GError** error);
	void (*backout_local_async) (GearyImapEngineReplayOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*backout_local_finish) (GearyImapEngineReplayOperation* self, GAsyncResult* _res_, GError** error);
	gchar* (*describe_state) (GearyImapEngineReplayOperation* self);
};

struct _GearyImapEngineReplayAppend {
	GearyImapEngineReplayOperation parent_instance;
	GearyImapEngineReplayAppendPrivate * priv;
};

struct _GearyImapEngineReplayAppendClass {
	GearyImapEngineReplayOperationClass parent_class;
};

struct _GearyImapEngineReplayAppendPrivate {
	GearyImapEngineMinimalFolder* owner;
	gint remote_count;
	GeeList* positions;
	GCancellable* cancellable;
};

struct _GearyImapEngineReplayAppendReplayRemoteAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapEngineReplayAppend* self;
	GearyImapFolderSession* remote;
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GError* _inner_error0_;
};

struct _GearyContactHarvesterIface {
	GTypeInterface parent_iface;
	void (*harvest_from_email) (GearyContactHarvester* self, GeeCollection* messages, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*harvest_from_email_finish) (GearyContactHarvester* self, GAsyncResult* _res_, GError** error);
};

struct _GearyImapEngineReplayAppendDoReplayAppendedMessagesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapEngineReplayAppend* self;
	GearyImapFolderSession* remote;
	GString* positions_builder;
	GString* _tmp0_;
	GeeList* _remote_position_list;
	GeeList* _tmp1_;
	gint _remote_position_size;
	GeeList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _remote_position_index;
	gint _tmp5_;
	gint _tmp6_;
	GearyImapSequenceNumber* remote_position;
	GeeList* _tmp7_;
	gpointer _tmp8_;
	GString* _tmp9_;
	GearyImapSequenceNumber* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GString* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GString* _tmp16_;
	const gchar* _tmp17_;
	GeeHashSet* created;
	GeeHashSet* _tmp18_;
	GeeHashSet* appended;
	GeeHashSet* _tmp19_;
	GeeList* msg_sets;
	GeeList* _tmp20_;
	GeeList* _tmp21_;
	GeeList* _msg_set_list;
	GeeList* _tmp22_;
	gint _msg_set_size;
	GeeList* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	gint _msg_set_index;
	gint _tmp26_;
	gint _tmp27_;
	GearyImapMessageSet* msg_set;
	GeeList* _tmp28_;
	gpointer _tmp29_;
	GeeList* list;
	GearyImapMessageSet* _tmp30_;
	GCancellable* _tmp31_;
	GeeList* _tmp32_;
	gboolean _tmp33_;
	GeeList* _tmp34_;
	GeeList* _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	GeeList* _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	GearyImapMessageSet* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	GeeMap* created_or_merged;
	GearyImapEngineMinimalFolder* _tmp46_;
	GearyImapDBFolder* _tmp47_;
	GearyImapDBFolder* _tmp48_;
	GeeList* _tmp49_;
	GearyImapEngineMinimalFolder* _tmp50_;
	GearyContactHarvester* _tmp51_;
	GearyContactHarvester* _tmp52_;
	GCancellable* _tmp53_;
	GeeMap* _tmp54_;
	GeeIterator* _email_it;
	GeeMap* _tmp55_;
	GeeSet* _tmp56_;
	GeeSet* _tmp57_;
	GeeSet* _tmp58_;
	GeeIterator* _tmp59_;
	GeeIterator* _tmp60_;
	GeeIterator* _tmp61_;
	GearyEmail* email;
	GeeIterator* _tmp62_;
	gpointer _tmp63_;
	GeeMap* _tmp64_;
	GearyEmail* _tmp65_;
	gpointer _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	GearyEmail* _tmp69_;
	GearyEmailIdentifier* _tmp70_;
	GearyEmailIdentifier* _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	GeeHashSet* _tmp74_;
	GearyEmail* _tmp75_;
	GearyEmailIdentifier* _tmp76_;
	GearyEmailIdentifier* _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	GearyEmail* _tmp80_;
	GearyEmailIdentifier* _tmp81_;
	GearyEmailIdentifier* _tmp82_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	GeeHashSet* _tmp85_;
	GearyEmail* _tmp86_;
	GearyEmailIdentifier* _tmp87_;
	GearyEmailIdentifier* _tmp88_;
	gchar* _tmp89_;
	gchar* _tmp90_;
	GearyImapMessageSet* _tmp91_;
	gchar* _tmp92_;
	gchar* _tmp93_;
	GearyImapEngineMinimalFolder* _tmp94_;
	GearyImapDBFolder* _tmp95_;
	GearyImapDBFolder* _tmp96_;
	GCancellable* _tmp97_;
	GeeHashSet* _tmp98_;
	gint _tmp99_;
	gint _tmp100_;
	GeeHashSet* _tmp101_;
	GeeHashSet* _tmp102_;
	gint _tmp103_;
	gint _tmp104_;
	GeeHashSet* _tmp105_;
	gchar* _tmp106_;
	gchar* _tmp107_;
	GError* _inner_error0_;
};

static gint GearyImapEngineReplayAppend_private_offset;
static gpointer geary_imap_engine_replay_append_parent_class = NULL;

VALA_EXTERN GType geary_imap_engine_replay_operation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_db_email_identifier_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_engine_replay_operation_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_folder_session_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_engine_replay_append_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_engine_minimal_folder_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void geary_imap_engine_replay_operation_notify_remote_removed_position (GearyImapEngineReplayOperation* self,
                                                                        GearyImapSequenceNumber* removed);
VALA_EXTERN void geary_imap_engine_replay_operation_replay_remote_async (GearyImapEngineReplayOperation* self,
                                                             GearyImapFolderSession* remote,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
VALA_EXTERN void geary_imap_engine_replay_operation_replay_remote_finish (GearyImapEngineReplayOperation* self,
                                                              GAsyncResult* _res_,
                                                              GError** error);
VALA_EXTERN gchar* geary_imap_engine_replay_operation_describe_state (GearyImapEngineReplayOperation* self);
static void g_cclosure_user_marshal_VOID__INT_FLAGS (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data);
VALA_EXTERN GearyImapEngineReplayAppend* geary_imap_engine_replay_append_new (GearyImapEngineMinimalFolder* owner,
                                                                  gint remote_count,
                                                                  GeeList* positions,
                                                                  GCancellable* cancellable);
VALA_EXTERN GearyImapEngineReplayAppend* geary_imap_engine_replay_append_construct (GType object_type,
                                                                        GearyImapEngineMinimalFolder* owner,
                                                                        gint remote_count,
                                                                        GeeList* positions,
                                                                        GCancellable* cancellable);
VALA_EXTERN GType geary_imap_engine_replay_operation_scope_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_engine_replay_operation_on_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearyImapEngineReplayOperation* geary_imap_engine_replay_operation_construct (GType object_type,
                                                                              const gchar* name,
                                                                              GearyImapEngineReplayOperationScope scope,
                                                                              GearyImapEngineReplayOperationOnError on_remote_error);
static void geary_imap_engine_replay_append_real_notify_remote_removed_position (GearyImapEngineReplayOperation* base,
                                                                          GearyImapSequenceNumber* removed);
static void geary_imap_engine_replay_append_real_replay_remote_async_data_free (gpointer _data);
static void geary_imap_engine_replay_append_real_replay_remote_async (GearyImapEngineReplayOperation* base,
                                                               GearyImapFolderSession* remote,
                                                               GAsyncReadyCallback _callback_,
                                                               gpointer _user_data_);
static gboolean geary_imap_engine_replay_append_real_replay_remote_async_co (GearyImapEngineReplayAppendReplayRemoteAsyncData* _data_);
static void geary_imap_engine_replay_append_do_replay_appended_messages (GearyImapEngineReplayAppend* self,
                                                                  GearyImapFolderSession* remote,
                                                                  GAsyncReadyCallback _callback_,
                                                                  gpointer _user_data_);
static void geary_imap_engine_replay_append_do_replay_appended_messages_finish (GearyImapEngineReplayAppend* self,
                                                                         GAsyncResult* _res_,
                                                                         GError** error);
static void geary_imap_engine_replay_append_replay_remote_async_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_);
static gchar* geary_imap_engine_replay_append_real_describe_state (GearyImapEngineReplayOperation* base);
static void geary_imap_engine_replay_append_do_replay_appended_messages_data_free (gpointer _data);
static gboolean geary_imap_engine_replay_append_do_replay_appended_messages_co (GearyImapEngineReplayAppendDoReplayAppendedMessagesData* _data_);
VALA_EXTERN gchar* geary_imap_engine_replay_operation_to_string (GearyImapEngineReplayOperation* self);
VALA_EXTERN void geary_imap_folder_session_list_email_async (GearyImapFolderSession* self,
                                                 GearyImapMessageSet* msg_set,
                                                 GearyEmailField fields,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
VALA_EXTERN GeeList* geary_imap_folder_session_list_email_finish (GearyImapFolderSession* self,
                                                      GAsyncResult* _res_,
                                                      GError** error);
static void geary_imap_engine_replay_append_do_replay_appended_messages_ready (GObject* source_object,
                                                                        GAsyncResult* _res_,
                                                                        gpointer _user_data_);
VALA_EXTERN GType geary_imap_db_folder_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearyImapDBFolder* geary_imap_engine_minimal_folder_get_local_folder (GearyImapEngineMinimalFolder* self);
VALA_EXTERN GType geary_contact_harvester_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void geary_imap_db_folder_create_or_merge_email_async (GearyImapDBFolder* self,
                                                       GeeCollection* emails,
                                                       gboolean update_totals,
                                                       GearyContactHarvester* harvester,
                                                       GCancellable* cancellable,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
VALA_EXTERN GeeMap* geary_imap_db_folder_create_or_merge_email_finish (GearyImapDBFolder* self,
                                                           GAsyncResult* _res_,
                                                           GError** error);
VALA_EXTERN GearyContactHarvester* geary_imap_engine_minimal_folder_get_harvester (GearyImapEngineMinimalFolder* self);
VALA_EXTERN void geary_imap_db_folder_update_remote_selected_message_count (GearyImapDBFolder* self,
                                                                gint count,
                                                                GCancellable* cancellable,
                                                                GAsyncReadyCallback _callback_,
                                                                gpointer _user_data_);
VALA_EXTERN void geary_imap_db_folder_update_remote_selected_message_count_finish (GearyImapDBFolder* self,
                                                                       GAsyncResult* _res_,
                                                                       GError** error);
static void geary_imap_engine_replay_append_finalize (GObject * obj);
static GType geary_imap_engine_replay_append_get_type_once (void);

static inline gpointer
geary_imap_engine_replay_append_get_instance_private (GearyImapEngineReplayAppend* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapEngineReplayAppend_private_offset);
}

static void
g_cclosure_user_marshal_VOID__INT_FLAGS (GClosure * closure,
                                         GValue * return_value,
                                         guint n_param_values,
                                         const GValue * param_values,
                                         gpointer invocation_hint,
                                         gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_FLAGS) (gpointer data1, gint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_FLAGS callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_FLAGS) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_flags (param_values + 2), data2);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GearyImapEngineReplayAppend*
geary_imap_engine_replay_append_construct (GType object_type,
                                           GearyImapEngineMinimalFolder* owner,
                                           gint remote_count,
                                           GeeList* positions,
                                           GCancellable* cancellable)
{
	GearyImapEngineReplayAppend * self = NULL;
	GearyImapEngineMinimalFolder* _tmp0_;
	GeeList* _tmp1_;
	GCancellable* _tmp2_;
	g_return_val_if_fail (GEARY_IMAP_ENGINE_IS_MINIMAL_FOLDER (owner), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (positions, GEE_TYPE_LIST), NULL);
	g_return_val_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), NULL);
	self = (GearyImapEngineReplayAppend*) geary_imap_engine_replay_operation_construct (object_type, "Append", GEARY_IMAP_ENGINE_REPLAY_OPERATION_SCOPE_REMOTE_ONLY, GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_ERROR_IGNORE_REMOTE);
	_tmp0_ = _g_object_ref0 (owner);
	_g_object_unref0 (self->priv->owner);
	self->priv->owner = _tmp0_;
	self->priv->remote_count = remote_count;
	_tmp1_ = _g_object_ref0 (positions);
	_g_object_unref0 (self->priv->positions);
	self->priv->positions = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp2_;
	return self;
}

GearyImapEngineReplayAppend*
geary_imap_engine_replay_append_new (GearyImapEngineMinimalFolder* owner,
                                     gint remote_count,
                                     GeeList* positions,
                                     GCancellable* cancellable)
{
	return geary_imap_engine_replay_append_construct (GEARY_IMAP_ENGINE_TYPE_REPLAY_APPEND, owner, remote_count, positions, cancellable);
}

static void
geary_imap_engine_replay_append_real_notify_remote_removed_position (GearyImapEngineReplayOperation* base,
                                                                     GearyImapSequenceNumber* removed)
{
	GearyImapEngineReplayAppend * self;
	GeeList* new_positions = NULL;
	GeeArrayList* _tmp0_;
	GeeList* _tmp27_;
	GeeList* _tmp28_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_ENGINE_TYPE_REPLAY_APPEND, GearyImapEngineReplayAppend);
	g_return_if_fail (GEARY_IMAP_IS_SEQUENCE_NUMBER (removed));
	_tmp0_ = gee_array_list_new (GEARY_IMAP_TYPE_SEQUENCE_NUMBER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	new_positions = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
	{
		GeeList* _position_list = NULL;
		GeeList* _tmp1_;
		gint _position_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _position_index = 0;
		_tmp1_ = self->priv->positions;
		_position_list = _tmp1_;
		_tmp2_ = _position_list;
		_tmp3_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp4_ = _tmp3_;
		_position_size = _tmp4_;
		_position_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			GearyImapSequenceNumber* position = NULL;
			GeeList* _tmp7_;
			gpointer _tmp8_;
			GearyImapSequenceNumber* old_position = NULL;
			GearyImapSequenceNumber* _tmp9_;
			GearyImapSequenceNumber* _tmp10_;
			GearyImapSequenceNumber* _tmp11_;
			GearyImapSequenceNumber* _tmp12_;
			GearyImapSequenceNumber* _tmp13_;
			gchar* _tmp16_ = NULL;
			GearyImapSequenceNumber* _tmp17_;
			GearyImapEngineMinimalFolder* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			GearyImapSequenceNumber* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_position_index = _position_index + 1;
			_tmp5_ = _position_index;
			_tmp6_ = _position_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _position_list;
			_tmp8_ = gee_list_get (_tmp7_, _position_index);
			position = (GearyImapSequenceNumber*) _tmp8_;
			_tmp9_ = position;
			_tmp10_ = _g_object_ref0 (_tmp9_);
			old_position = _tmp10_;
			_tmp11_ = position;
			_tmp12_ = geary_imap_sequence_number_shift_for_removed (_tmp11_, removed);
			_g_object_unref0 (position);
			position = _tmp12_;
			_tmp13_ = position;
			if (_tmp13_ != NULL) {
				GeeList* _tmp14_;
				GearyImapSequenceNumber* _tmp15_;
				_tmp14_ = new_positions;
				_tmp15_ = position;
				gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_COLLECTION, GeeCollection), _tmp15_);
			}
			_tmp17_ = position;
			if (_tmp17_ != NULL) {
				GearyImapSequenceNumber* _tmp18_;
				gchar* _tmp19_;
				_tmp18_ = position;
				_tmp19_ = geary_message_data_abstract_message_data_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, GearyMessageDataAbstractMessageData));
				_g_free0 (_tmp16_);
				_tmp16_ = _tmp19_;
			} else {
				gchar* _tmp20_;
				_tmp20_ = g_strdup ("(null)");
				_g_free0 (_tmp16_);
				_tmp16_ = _tmp20_;
			}
			_tmp21_ = self->priv->owner;
			_tmp22_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
			_tmp23_ = _tmp22_;
			_tmp24_ = old_position;
			_tmp25_ = geary_message_data_abstract_message_data_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, GearyMessageDataAbstractMessageData));
			_tmp26_ = _tmp25_;
			g_debug ("imap-engine-replay-append.vala:46: %s: ReplayAppend remote unsolicited" \
" remove: %s -> %s", _tmp23_, _tmp26_, _tmp16_);
			_g_free0 (_tmp26_);
			_g_free0 (_tmp23_);
			_g_free0 (_tmp16_);
			_g_object_unref0 (old_position);
			_g_object_unref0 (position);
		}
	}
	_tmp27_ = new_positions;
	_tmp28_ = _g_object_ref0 (_tmp27_);
	_g_object_unref0 (self->priv->positions);
	self->priv->positions = _tmp28_;
	_g_object_unref0 (new_positions);
}

static void
geary_imap_engine_replay_append_real_replay_remote_async_data_free (gpointer _data)
{
	GearyImapEngineReplayAppendReplayRemoteAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->remote);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapEngineReplayAppendReplayRemoteAsyncData, _data_);
}

static void
geary_imap_engine_replay_append_real_replay_remote_async (GearyImapEngineReplayOperation* base,
                                                          GearyImapFolderSession* remote,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_)
{
	GearyImapEngineReplayAppend * self;
	GearyImapEngineReplayAppendReplayRemoteAsyncData* _data_;
	GearyImapEngineReplayAppend* _tmp0_;
	GearyImapFolderSession* _tmp1_;
	g_return_if_fail (GEARY_IMAP_IS_FOLDER_SESSION (remote));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_ENGINE_TYPE_REPLAY_APPEND, GearyImapEngineReplayAppend);
	_data_ = g_slice_new0 (GearyImapEngineReplayAppendReplayRemoteAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_engine_replay_append_real_replay_remote_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (remote);
	_g_object_unref0 (_data_->remote);
	_data_->remote = _tmp1_;
	geary_imap_engine_replay_append_real_replay_remote_async_co (_data_);
}

static void
geary_imap_engine_replay_append_replay_remote_finish (GearyImapEngineReplayOperation* base,
                                                      GAsyncResult* _res_,
                                                      GError** error)
{
	GearyImapEngineReplayAppendReplayRemoteAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_imap_engine_replay_append_replay_remote_async_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_)
{
	GearyImapEngineReplayAppendReplayRemoteAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_engine_replay_append_real_replay_remote_async_co (_data_);
}

static gboolean
geary_imap_engine_replay_append_real_replay_remote_async_co (GearyImapEngineReplayAppendReplayRemoteAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->positions;
	_data_->_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_data_->_tmp2_ = _data_->_tmp1_;
	if (_data_->_tmp2_ > 0) {
		_data_->_state_ = 1;
		geary_imap_engine_replay_append_do_replay_appended_messages (_data_->self, _data_->remote, geary_imap_engine_replay_append_replay_remote_async_ready, _data_);
		return FALSE;
		_state_1:
		geary_imap_engine_replay_append_do_replay_appended_messages_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
geary_imap_engine_replay_append_real_describe_state (GearyImapEngineReplayOperation* base)
{
	GearyImapEngineReplayAppend * self;
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_ENGINE_TYPE_REPLAY_APPEND, GearyImapEngineReplayAppend);
	_tmp0_ = self->priv->positions;
	_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("remote_count=%d positions.size=%d", self->priv->remote_count, _tmp2_);
	result = _tmp3_;
	return result;
}

static void
geary_imap_engine_replay_append_do_replay_appended_messages_data_free (gpointer _data)
{
	GearyImapEngineReplayAppendDoReplayAppendedMessagesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->remote);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapEngineReplayAppendDoReplayAppendedMessagesData, _data_);
}

static void
geary_imap_engine_replay_append_do_replay_appended_messages (GearyImapEngineReplayAppend* self,
                                                             GearyImapFolderSession* remote,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_)
{
	GearyImapEngineReplayAppendDoReplayAppendedMessagesData* _data_;
	GearyImapEngineReplayAppend* _tmp0_;
	GearyImapFolderSession* _tmp1_;
	g_return_if_fail (GEARY_IMAP_ENGINE_IS_REPLAY_APPEND (self));
	g_return_if_fail (GEARY_IMAP_IS_FOLDER_SESSION (remote));
	_data_ = g_slice_new0 (GearyImapEngineReplayAppendDoReplayAppendedMessagesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_engine_replay_append_do_replay_appended_messages_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (remote);
	_g_object_unref0 (_data_->remote);
	_data_->remote = _tmp1_;
	geary_imap_engine_replay_append_do_replay_appended_messages_co (_data_);
}

static void
geary_imap_engine_replay_append_do_replay_appended_messages_finish (GearyImapEngineReplayAppend* self,
                                                                    GAsyncResult* _res_,
                                                                    GError** error)
{
	GearyImapEngineReplayAppendDoReplayAppendedMessagesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_imap_engine_replay_append_do_replay_appended_messages_ready (GObject* source_object,
                                                                   GAsyncResult* _res_,
                                                                   gpointer _user_data_)
{
	GearyImapEngineReplayAppendDoReplayAppendedMessagesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_engine_replay_append_do_replay_appended_messages_co (_data_);
}

static gboolean
geary_imap_engine_replay_append_do_replay_appended_messages_co (GearyImapEngineReplayAppendDoReplayAppendedMessagesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_string_new ("( ");
	_data_->positions_builder = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _data_->self->priv->positions;
		_data_->_remote_position_list = _data_->_tmp1_;
		_data_->_tmp2_ = _data_->_remote_position_list;
		_data_->_tmp3_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_remote_position_size = _data_->_tmp4_;
		_data_->_remote_position_index = -1;
		while (TRUE) {
			_data_->_remote_position_index = _data_->_remote_position_index + 1;
			_data_->_tmp5_ = _data_->_remote_position_index;
			_data_->_tmp6_ = _data_->_remote_position_size;
			if (!(_data_->_tmp5_ < _data_->_tmp6_)) {
				break;
			}
			_data_->_tmp7_ = _data_->_remote_position_list;
			_data_->_tmp8_ = gee_list_get (_data_->_tmp7_, _data_->_remote_position_index);
			_data_->remote_position = (GearyImapSequenceNumber*) _data_->_tmp8_;
			_data_->_tmp9_ = _data_->positions_builder;
			_data_->_tmp10_ = _data_->remote_position;
			_data_->_tmp11_ = geary_message_data_abstract_message_data_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp10_, GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, GearyMessageDataAbstractMessageData));
			_data_->_tmp12_ = _data_->_tmp11_;
			g_string_append_printf (_data_->_tmp9_, "%s ", _data_->_tmp12_);
			_g_free0 (_data_->_tmp12_);
			_g_object_unref0 (_data_->remote_position);
		}
	}
	_data_->_tmp13_ = _data_->positions_builder;
	g_string_append (_data_->_tmp13_, ")");
	_data_->_tmp14_ = geary_imap_engine_replay_operation_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperation));
	_data_->_tmp15_ = _data_->_tmp14_;
	_data_->_tmp16_ = _data_->positions_builder;
	_data_->_tmp17_ = _data_->_tmp16_->str;
	g_debug ("imap-engine-replay-append.vala:79: %s do_replay_appended_message: this" \
".remote_count=%d this.positions=%s", _data_->_tmp15_, _data_->self->priv->remote_count, _data_->_tmp17_);
	_g_free0 (_data_->_tmp15_);
	_data_->_tmp18_ = gee_hash_set_new (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->created = _data_->_tmp18_;
	_data_->_tmp19_ = gee_hash_set_new (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->appended = _data_->_tmp19_;
	_data_->_tmp20_ = _data_->self->priv->positions;
	_data_->_tmp21_ = geary_imap_message_set_sparse (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp20_, GEE_TYPE_COLLECTION, GeeCollection));
	_data_->msg_sets = _data_->_tmp21_;
	{
		_data_->_tmp22_ = _data_->msg_sets;
		_data_->_msg_set_list = _data_->_tmp22_;
		_data_->_tmp23_ = _data_->_msg_set_list;
		_data_->_tmp24_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp23_, GEE_TYPE_COLLECTION, GeeCollection));
		_data_->_tmp25_ = _data_->_tmp24_;
		_data_->_msg_set_size = _data_->_tmp25_;
		_data_->_msg_set_index = -1;
		while (TRUE) {
			_data_->_msg_set_index = _data_->_msg_set_index + 1;
			_data_->_tmp26_ = _data_->_msg_set_index;
			_data_->_tmp27_ = _data_->_msg_set_size;
			if (!(_data_->_tmp26_ < _data_->_tmp27_)) {
				break;
			}
			_data_->_tmp28_ = _data_->_msg_set_list;
			_data_->_tmp29_ = gee_list_get (_data_->_tmp28_, _data_->_msg_set_index);
			_data_->msg_set = (GearyImapMessageSet*) _data_->_tmp29_;
			_data_->_tmp30_ = _data_->msg_set;
			_data_->_tmp31_ = _data_->self->priv->cancellable;
			_data_->_state_ = 1;
			geary_imap_folder_session_list_email_async (_data_->remote, _data_->_tmp30_, GEARY_IMAP_DB_FOLDER_REQUIRED_FIELDS, _data_->_tmp31_, geary_imap_engine_replay_append_do_replay_appended_messages_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp32_ = geary_imap_folder_session_list_email_finish (_data_->remote, _data_->_res_, &_data_->_inner_error0_);
			_data_->list = _data_->_tmp32_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->msg_set);
				_g_object_unref0 (_data_->msg_sets);
				_g_object_unref0 (_data_->appended);
				_g_object_unref0 (_data_->created);
				_g_string_free0 (_data_->positions_builder);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp34_ = _data_->list;
			if (_data_->_tmp34_ != NULL) {
				_data_->_tmp35_ = _data_->list;
				_data_->_tmp36_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp35_, GEE_TYPE_COLLECTION, GeeCollection));
				_data_->_tmp37_ = _data_->_tmp36_;
				_data_->_tmp33_ = _data_->_tmp37_ > 0;
			} else {
				_data_->_tmp33_ = FALSE;
			}
			if (_data_->_tmp33_) {
				_data_->_tmp38_ = geary_imap_engine_replay_operation_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperation));
				_data_->_tmp39_ = _data_->_tmp38_;
				_data_->_tmp40_ = _data_->list;
				_data_->_tmp41_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp40_, GEE_TYPE_COLLECTION, GeeCollection));
				_data_->_tmp42_ = _data_->_tmp41_;
				_data_->_tmp43_ = _data_->msg_set;
				_data_->_tmp44_ = geary_imap_message_set_to_string (_data_->_tmp43_);
				_data_->_tmp45_ = _data_->_tmp44_;
				g_debug ("imap-engine-replay-append.vala:90: %s do_replay_appended_message: %d n" \
"ew messages in %s", _data_->_tmp39_, _data_->_tmp42_, _data_->_tmp45_);
				_g_free0 (_data_->_tmp45_);
				_g_free0 (_data_->_tmp39_);
				_data_->_tmp46_ = _data_->self->priv->owner;
				_data_->_tmp47_ = geary_imap_engine_minimal_folder_get_local_folder (_data_->_tmp46_);
				_data_->_tmp48_ = _data_->_tmp47_;
				_data_->_tmp49_ = _data_->list;
				_data_->_tmp50_ = _data_->self->priv->owner;
				_data_->_tmp51_ = geary_imap_engine_minimal_folder_get_harvester (_data_->_tmp50_);
				_data_->_tmp52_ = _data_->_tmp51_;
				_data_->_tmp53_ = _data_->self->priv->cancellable;
				_data_->_state_ = 2;
				geary_imap_db_folder_create_or_merge_email_async (_data_->_tmp48_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp49_, GEE_TYPE_COLLECTION, GeeCollection), TRUE, _data_->_tmp52_, _data_->_tmp53_, geary_imap_engine_replay_append_do_replay_appended_messages_ready, _data_);
				return FALSE;
				_state_2:
				_data_->_tmp54_ = geary_imap_db_folder_create_or_merge_email_finish (_data_->_tmp48_, _data_->_res_, &_data_->_inner_error0_);
				_data_->created_or_merged = _data_->_tmp54_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					_g_object_unref0 (_data_->list);
					_g_object_unref0 (_data_->msg_set);
					_g_object_unref0 (_data_->msg_sets);
					_g_object_unref0 (_data_->appended);
					_g_object_unref0 (_data_->created);
					_g_string_free0 (_data_->positions_builder);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				{
					_data_->_tmp55_ = _data_->created_or_merged;
					_data_->_tmp56_ = gee_map_get_keys (_data_->_tmp55_);
					_data_->_tmp57_ = _data_->_tmp56_;
					_data_->_tmp58_ = _data_->_tmp57_;
					_data_->_tmp59_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp58_, GEE_TYPE_ITERABLE, GeeIterable));
					_data_->_tmp60_ = _data_->_tmp59_;
					_g_object_unref0 (_data_->_tmp58_);
					_data_->_email_it = _data_->_tmp60_;
					while (TRUE) {
						_data_->_tmp61_ = _data_->_email_it;
						if (!gee_iterator_next (_data_->_tmp61_)) {
							break;
						}
						_data_->_tmp62_ = _data_->_email_it;
						_data_->_tmp63_ = gee_iterator_get (_data_->_tmp62_);
						_data_->email = (GearyEmail*) _data_->_tmp63_;
						_data_->_tmp64_ = _data_->created_or_merged;
						_data_->_tmp65_ = _data_->email;
						_data_->_tmp66_ = gee_map_get (_data_->_tmp64_, _data_->_tmp65_);
						if ((gboolean) ((gintptr) _data_->_tmp66_)) {
							_data_->_tmp67_ = geary_imap_engine_replay_operation_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperation));
							_data_->_tmp68_ = _data_->_tmp67_;
							_data_->_tmp69_ = _data_->email;
							_data_->_tmp70_ = geary_email_get_id (_data_->_tmp69_);
							_data_->_tmp71_ = _data_->_tmp70_;
							_data_->_tmp72_ = geary_email_identifier_to_string (_data_->_tmp71_);
							_data_->_tmp73_ = _data_->_tmp72_;
							g_debug ("imap-engine-replay-append.vala:102: %s do_replay_appended_message: app" \
"ended email ID %s added", _data_->_tmp68_, _data_->_tmp73_);
							_g_free0 (_data_->_tmp73_);
							_g_free0 (_data_->_tmp68_);
							_data_->_tmp74_ = _data_->created;
							_data_->_tmp75_ = _data_->email;
							_data_->_tmp76_ = geary_email_get_id (_data_->_tmp75_);
							_data_->_tmp77_ = _data_->_tmp76_;
							gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp74_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _data_->_tmp77_);
						} else {
							_data_->_tmp78_ = geary_imap_engine_replay_operation_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperation));
							_data_->_tmp79_ = _data_->_tmp78_;
							_data_->_tmp80_ = _data_->email;
							_data_->_tmp81_ = geary_email_get_id (_data_->_tmp80_);
							_data_->_tmp82_ = _data_->_tmp81_;
							_data_->_tmp83_ = geary_email_identifier_to_string (_data_->_tmp82_);
							_data_->_tmp84_ = _data_->_tmp83_;
							g_debug ("imap-engine-replay-append.vala:107: %s do_replay_appended_message: app" \
"ended email ID %s associated", _data_->_tmp79_, _data_->_tmp84_);
							_g_free0 (_data_->_tmp84_);
							_g_free0 (_data_->_tmp79_);
						}
						_data_->_tmp85_ = _data_->appended;
						_data_->_tmp86_ = _data_->email;
						_data_->_tmp87_ = geary_email_get_id (_data_->_tmp86_);
						_data_->_tmp88_ = _data_->_tmp87_;
						gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp85_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _data_->_tmp88_);
						_g_object_unref0 (_data_->email);
					}
					_g_object_unref0 (_data_->_email_it);
				}
				_g_object_unref0 (_data_->created_or_merged);
			} else {
				_data_->_tmp89_ = geary_imap_engine_replay_operation_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperation));
				_data_->_tmp90_ = _data_->_tmp89_;
				_data_->_tmp91_ = _data_->msg_set;
				_data_->_tmp92_ = geary_imap_message_set_to_string (_data_->_tmp91_);
				_data_->_tmp93_ = _data_->_tmp92_;
				g_debug ("imap-engine-replay-append.vala:114: %s do_replay_appended_message: no " \
"new messages in %s", _data_->_tmp90_, _data_->_tmp93_);
				_g_free0 (_data_->_tmp93_);
				_g_free0 (_data_->_tmp90_);
			}
			_g_object_unref0 (_data_->list);
			_g_object_unref0 (_data_->msg_set);
		}
	}
	_data_->_tmp94_ = _data_->self->priv->owner;
	_data_->_tmp95_ = geary_imap_engine_minimal_folder_get_local_folder (_data_->_tmp94_);
	_data_->_tmp96_ = _data_->_tmp95_;
	_data_->_tmp97_ = _data_->self->priv->cancellable;
	_data_->_state_ = 3;
	geary_imap_db_folder_update_remote_selected_message_count (_data_->_tmp96_, _data_->self->priv->remote_count, _data_->_tmp97_, geary_imap_engine_replay_append_do_replay_appended_messages_ready, _data_);
	return FALSE;
	_state_3:
	geary_imap_db_folder_update_remote_selected_message_count_finish (_data_->_tmp96_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->msg_sets);
		_g_object_unref0 (_data_->appended);
		_g_object_unref0 (_data_->created);
		_g_string_free0 (_data_->positions_builder);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp98_ = _data_->appended;
	_data_->_tmp99_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp98_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_data_->_tmp100_ = _data_->_tmp99_;
	if (_data_->_tmp100_ > 0) {
		_data_->_tmp101_ = _data_->appended;
		g_signal_emit (_data_->self, geary_imap_engine_replay_append_signals[GEARY_IMAP_ENGINE_REPLAY_APPEND_EMAIL_APPENDED_SIGNAL], 0, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp101_, GEE_TYPE_COLLECTION, GeeCollection));
	}
	_data_->_tmp102_ = _data_->created;
	_data_->_tmp103_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp102_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_data_->_tmp104_ = _data_->_tmp103_;
	if (_data_->_tmp104_ > 0) {
		_data_->_tmp105_ = _data_->created;
		g_signal_emit (_data_->self, geary_imap_engine_replay_append_signals[GEARY_IMAP_ENGINE_REPLAY_APPEND_EMAIL_LOCALLY_APPENDED_SIGNAL], 0, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp105_, GEE_TYPE_COLLECTION, GeeCollection));
	}
	g_signal_emit (_data_->self, geary_imap_engine_replay_append_signals[GEARY_IMAP_ENGINE_REPLAY_APPEND_EMAIL_COUNT_CHANGED_SIGNAL], 0, _data_->self->priv->remote_count, GEARY_FOLDER_COUNT_CHANGE_REASON_APPENDED);
	_data_->_tmp106_ = geary_imap_engine_replay_operation_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperation));
	_data_->_tmp107_ = _data_->_tmp106_;
	g_debug ("imap-engine-replay-append.vala:133: %s do_replay_appended_message: com" \
"pleted, this.remote_count=%d", _data_->_tmp107_, _data_->self->priv->remote_count);
	_g_free0 (_data_->_tmp107_);
	_g_object_unref0 (_data_->msg_sets);
	_g_object_unref0 (_data_->appended);
	_g_object_unref0 (_data_->created);
	_g_string_free0 (_data_->positions_builder);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_engine_replay_append_class_init (GearyImapEngineReplayAppendClass * klass,
                                            gpointer klass_data)
{
	geary_imap_engine_replay_append_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapEngineReplayAppend_private_offset);
	((GearyImapEngineReplayOperationClass *) klass)->notify_remote_removed_position = (void (*) (GearyImapEngineReplayOperation*, GearyImapSequenceNumber*)) geary_imap_engine_replay_append_real_notify_remote_removed_position;
	((GearyImapEngineReplayOperationClass *) klass)->replay_remote_async = (void (*) (GearyImapEngineReplayOperation*, GearyImapFolderSession*, GAsyncReadyCallback, gpointer)) geary_imap_engine_replay_append_real_replay_remote_async;
	((GearyImapEngineReplayOperationClass *) klass)->replay_remote_finish = (void (*) (GearyImapEngineReplayOperation*, GAsyncResult*, GError**)) geary_imap_engine_replay_append_replay_remote_finish;
	((GearyImapEngineReplayOperationClass *) klass)->describe_state = (gchar* (*) (GearyImapEngineReplayOperation*)) geary_imap_engine_replay_append_real_describe_state;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_engine_replay_append_finalize;
	geary_imap_engine_replay_append_signals[GEARY_IMAP_ENGINE_REPLAY_APPEND_EMAIL_APPENDED_SIGNAL] = g_signal_new ("email-appended", GEARY_IMAP_ENGINE_TYPE_REPLAY_APPEND, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
	geary_imap_engine_replay_append_signals[GEARY_IMAP_ENGINE_REPLAY_APPEND_EMAIL_LOCALLY_APPENDED_SIGNAL] = g_signal_new ("email-locally-appended", GEARY_IMAP_ENGINE_TYPE_REPLAY_APPEND, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
	geary_imap_engine_replay_append_signals[GEARY_IMAP_ENGINE_REPLAY_APPEND_EMAIL_COUNT_CHANGED_SIGNAL] = g_signal_new ("email-count-changed", GEARY_IMAP_ENGINE_TYPE_REPLAY_APPEND, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_FLAGS, G_TYPE_NONE, 2, G_TYPE_INT, GEARY_FOLDER_TYPE_COUNT_CHANGE_REASON);
}

static void
geary_imap_engine_replay_append_instance_init (GearyImapEngineReplayAppend * self,
                                               gpointer klass)
{
	self->priv = geary_imap_engine_replay_append_get_instance_private (self);
}

static void
geary_imap_engine_replay_append_finalize (GObject * obj)
{
	GearyImapEngineReplayAppend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_ENGINE_TYPE_REPLAY_APPEND, GearyImapEngineReplayAppend);
	_g_object_unref0 (self->priv->owner);
	_g_object_unref0 (self->priv->positions);
	_g_object_unref0 (self->priv->cancellable);
	G_OBJECT_CLASS (geary_imap_engine_replay_append_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
geary_imap_engine_replay_append_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapEngineReplayAppendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_engine_replay_append_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapEngineReplayAppend), 0, (GInstanceInitFunc) geary_imap_engine_replay_append_instance_init, NULL };
	GType geary_imap_engine_replay_append_type_id;
	geary_imap_engine_replay_append_type_id = g_type_register_static (GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, "GearyImapEngineReplayAppend", &g_define_type_info, 0);
	GearyImapEngineReplayAppend_private_offset = g_type_add_instance_private (geary_imap_engine_replay_append_type_id, sizeof (GearyImapEngineReplayAppendPrivate));
	return geary_imap_engine_replay_append_type_id;
}

GType
geary_imap_engine_replay_append_get_type (void)
{
	static gsize geary_imap_engine_replay_append_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_engine_replay_append_type_id__once)) {
		GType geary_imap_engine_replay_append_type_id;
		geary_imap_engine_replay_append_type_id = geary_imap_engine_replay_append_get_type_once ();
		g_once_init_leave (&geary_imap_engine_replay_append_type_id__once, geary_imap_engine_replay_append_type_id);
	}
	return geary_imap_engine_replay_append_type_id__once;
}

