/* db-transaction-connection.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from db-transaction-connection.vala, do not modify */

/*
 * Copyright © 2016 Software Freedom Conservancy Inc.
 * Copyright © 2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <sqlite3.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GEARY_DB_TYPE_TRANSACTION_CONNECTION (geary_db_transaction_connection_get_type ())
#define GEARY_DB_TRANSACTION_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_DB_TYPE_TRANSACTION_CONNECTION, GearyDbTransactionConnection))
#define GEARY_DB_TRANSACTION_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_DB_TYPE_TRANSACTION_CONNECTION, GearyDbTransactionConnectionClass))
#define GEARY_DB_IS_TRANSACTION_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_DB_TYPE_TRANSACTION_CONNECTION))
#define GEARY_DB_IS_TRANSACTION_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_DB_TYPE_TRANSACTION_CONNECTION))
#define GEARY_DB_TRANSACTION_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_DB_TYPE_TRANSACTION_CONNECTION, GearyDbTransactionConnectionClass))

typedef struct _GearyDbTransactionConnection GearyDbTransactionConnection;
typedef struct _GearyDbTransactionConnectionClass GearyDbTransactionConnectionClass;
typedef struct _GearyDbTransactionConnectionPrivate GearyDbTransactionConnectionPrivate;
enum  {
	GEARY_DB_TRANSACTION_CONNECTION_0_PROPERTY,
	GEARY_DB_TRANSACTION_CONNECTION_DATABASE_PROPERTY,
	GEARY_DB_TRANSACTION_CONNECTION_DB_PROPERTY,
	GEARY_DB_TRANSACTION_CONNECTION_NUM_PROPERTIES
};
static GParamSpec* geary_db_transaction_connection_properties[GEARY_DB_TRANSACTION_CONNECTION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GearyDbTransactionConnection {
	GearyBaseObject parent_instance;
	gchar** transaction_log;
	gint transaction_log_length1;
	gint _transaction_log_size_;
	GearyDbTransactionConnectionPrivate * priv;
};

struct _GearyDbTransactionConnectionClass {
	GearyBaseObjectClass parent_class;
};

struct _GearyDbTransactionConnectionPrivate {
	GearyDbDatabaseConnection* db_cx;
};

static gint GearyDbTransactionConnection_private_offset;
static gpointer geary_db_transaction_connection_parent_class = NULL;
static GearyDbConnectionIface * geary_db_transaction_connection_geary_db_connection_parent_iface = NULL;

VALA_EXTERN GType geary_db_transaction_connection_get_type (void) G_GNUC_CONST ;
VALA_EXTERN sqlite3* geary_db_connection_get_db (GearyDbConnection* self);
VALA_EXTERN GearyDbTransactionConnection* geary_db_transaction_connection_new (GearyDbDatabaseConnection* db_cx);
VALA_EXTERN GearyDbTransactionConnection* geary_db_transaction_connection_construct (GType object_type,
                                                                         GearyDbDatabaseConnection* db_cx);
static GearyDbStatement* geary_db_transaction_connection_real_prepare (GearyDbConnection* base,
                                                                const gchar* sql,
                                                                GError** error);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static GearyDbResult* geary_db_transaction_connection_real_query (GearyDbConnection* base,
                                                           const gchar* sql,
                                                           GCancellable* cancellable,
                                                           GError** error);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void geary_db_transaction_connection_real_exec (GearyDbConnection* base,
                                                const gchar* sql,
                                                GCancellable* cancellable,
                                                GError** error);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void geary_db_transaction_connection_real_exec_file (GearyDbConnection* base,
                                                     GFile* file,
                                                     GCancellable* cancellable,
                                                     GError** error);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void geary_db_transaction_connection_finalize (GObject * obj);
static GType geary_db_transaction_connection_get_type_once (void);
static void _vala_geary_db_transaction_connection_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
geary_db_transaction_connection_get_instance_private (GearyDbTransactionConnection* self)
{
	return G_STRUCT_MEMBER_P (self, GearyDbTransactionConnection_private_offset);
}

static GearyDbDatabase*
geary_db_transaction_connection_real_get_database (GearyDbConnection* base)
{
	GearyDbDatabase* result;
	GearyDbTransactionConnection* self;
	GearyDbDatabaseConnection* _tmp0_;
	GearyDbDatabase* _tmp1_;
	GearyDbDatabase* _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_DB_TYPE_TRANSACTION_CONNECTION, GearyDbTransactionConnection);
	_tmp0_ = self->priv->db_cx;
	_tmp1_ = geary_db_connection_get_database (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_DB_TYPE_CONNECTION, GearyDbConnection));
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static sqlite3*
geary_db_transaction_connection_real_get_db (GearyDbConnection* base)
{
	sqlite3* result;
	GearyDbTransactionConnection* self;
	GearyDbDatabaseConnection* _tmp0_;
	sqlite3* _tmp1_;
	sqlite3* _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_DB_TYPE_TRANSACTION_CONNECTION, GearyDbTransactionConnection);
	_tmp0_ = self->priv->db_cx;
	_tmp1_ = geary_db_connection_get_db (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_DB_TYPE_CONNECTION, GearyDbConnection));
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GearyDbTransactionConnection*
geary_db_transaction_connection_construct (GType object_type,
                                           GearyDbDatabaseConnection* db_cx)
{
	GearyDbTransactionConnection * self = NULL;
	GearyDbDatabaseConnection* _tmp0_;
	g_return_val_if_fail (GEARY_DB_IS_DATABASE_CONNECTION (db_cx), NULL);
	self = (GearyDbTransactionConnection*) geary_base_object_construct (object_type);
	_tmp0_ = _g_object_ref0 (db_cx);
	_g_object_unref0 (self->priv->db_cx);
	self->priv->db_cx = _tmp0_;
	return self;
}

GearyDbTransactionConnection*
geary_db_transaction_connection_new (GearyDbDatabaseConnection* db_cx)
{
	return geary_db_transaction_connection_construct (GEARY_DB_TYPE_TRANSACTION_CONNECTION, db_cx);
}

/** {@inheritDoc} */
static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static GearyDbStatement*
geary_db_transaction_connection_real_prepare (GearyDbConnection* base,
                                              const gchar* sql,
                                              GError** error)
{
	GearyDbTransactionConnection * self;
	gchar* _tmp0_;
	GearyDbStatement* _tmp1_ = NULL;
	GearyDbDatabaseConnection* _tmp2_;
	GearyDbStatement* _tmp3_;
	GearyDbStatement* _tmp4_;
	GError* _inner_error0_ = NULL;
	GearyDbStatement* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_DB_TYPE_TRANSACTION_CONNECTION, GearyDbTransactionConnection);
	g_return_val_if_fail (sql != NULL, NULL);
	_tmp0_ = g_strdup (sql);
	_vala_array_add2 (&self->transaction_log, &self->transaction_log_length1, &self->_transaction_log_size_, _tmp0_);
	_tmp2_ = self->priv->db_cx;
	_tmp3_ = geary_db_connection_prepare (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEARY_DB_TYPE_CONNECTION, GearyDbConnection), sql, &_inner_error0_);
	_tmp1_ = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp4_ = _tmp1_;
	_tmp1_ = NULL;
	result = _tmp4_;
	_g_object_unref0 (_tmp1_);
	return result;
}

/** {@inheritDoc} */
static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static GearyDbResult*
geary_db_transaction_connection_real_query (GearyDbConnection* base,
                                            const gchar* sql,
                                            GCancellable* cancellable,
                                            GError** error)
{
	GearyDbTransactionConnection * self;
	gchar* _tmp0_;
	GearyDbResult* _tmp1_ = NULL;
	GearyDbDatabaseConnection* _tmp2_;
	GearyDbResult* _tmp3_;
	GearyDbResult* _tmp4_;
	GError* _inner_error0_ = NULL;
	GearyDbResult* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_DB_TYPE_TRANSACTION_CONNECTION, GearyDbTransactionConnection);
	g_return_val_if_fail (sql != NULL, NULL);
	g_return_val_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), NULL);
	_tmp0_ = g_strdup (sql);
	_vala_array_add3 (&self->transaction_log, &self->transaction_log_length1, &self->_transaction_log_size_, _tmp0_);
	_tmp2_ = self->priv->db_cx;
	_tmp3_ = geary_db_connection_query (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEARY_DB_TYPE_CONNECTION, GearyDbConnection), sql, cancellable, &_inner_error0_);
	_tmp1_ = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp4_ = _tmp1_;
	_tmp1_ = NULL;
	result = _tmp4_;
	_g_object_unref0 (_tmp1_);
	return result;
}

/** {@inheritDoc} */
static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
geary_db_transaction_connection_real_exec (GearyDbConnection* base,
                                           const gchar* sql,
                                           GCancellable* cancellable,
                                           GError** error)
{
	GearyDbTransactionConnection * self;
	gchar* _tmp0_;
	GearyDbDatabaseConnection* _tmp1_;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_DB_TYPE_TRANSACTION_CONNECTION, GearyDbTransactionConnection);
	g_return_if_fail (sql != NULL);
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_tmp0_ = g_strdup (sql);
	_vala_array_add4 (&self->transaction_log, &self->transaction_log_length1, &self->_transaction_log_size_, _tmp0_);
	_tmp1_ = self->priv->db_cx;
	geary_db_connection_exec (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEARY_DB_TYPE_CONNECTION, GearyDbConnection), sql, cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

/** {@inheritDoc} */
static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
geary_db_transaction_connection_real_exec_file (GearyDbConnection* base,
                                                GFile* file,
                                                GCancellable* cancellable,
                                                GError** error)
{
	GearyDbTransactionConnection * self;
	gchar* _tmp0_;
	GearyDbDatabaseConnection* _tmp1_;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_DB_TYPE_TRANSACTION_CONNECTION, GearyDbTransactionConnection);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_tmp0_ = g_file_get_uri (file);
	_vala_array_add5 (&self->transaction_log, &self->transaction_log_length1, &self->_transaction_log_size_, _tmp0_);
	_tmp1_ = self->priv->db_cx;
	geary_db_connection_exec_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEARY_DB_TYPE_CONNECTION, GearyDbConnection), file, cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
geary_db_transaction_connection_class_init (GearyDbTransactionConnectionClass * klass,
                                            gpointer klass_data)
{
	geary_db_transaction_connection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyDbTransactionConnection_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_db_transaction_connection_get_property;
	G_OBJECT_CLASS (klass)->finalize = geary_db_transaction_connection_finalize;
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_DB_TRANSACTION_CONNECTION_DATABASE_PROPERTY, geary_db_transaction_connection_properties[GEARY_DB_TRANSACTION_CONNECTION_DATABASE_PROPERTY] = g_param_spec_object ("database", "database", "database", GEARY_DB_TYPE_DATABASE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_DB_TRANSACTION_CONNECTION_DB_PROPERTY, geary_db_transaction_connection_properties[GEARY_DB_TRANSACTION_CONNECTION_DB_PROPERTY] = g_param_spec_pointer ("db", "db", "db", G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_db_transaction_connection_geary_db_connection_interface_init (GearyDbConnectionIface * iface,
                                                                    gpointer iface_data)
{
	geary_db_transaction_connection_geary_db_connection_parent_iface = g_type_interface_peek_parent (iface);
	iface->prepare = (GearyDbStatement* (*) (GearyDbConnection*, const gchar*, GError**)) geary_db_transaction_connection_real_prepare;
	iface->query = (GearyDbResult* (*) (GearyDbConnection*, const gchar*, GCancellable*, GError**)) geary_db_transaction_connection_real_query;
	iface->exec = (void (*) (GearyDbConnection*, const gchar*, GCancellable*, GError**)) geary_db_transaction_connection_real_exec;
	iface->exec_file = (void (*) (GearyDbConnection*, GFile*, GCancellable*, GError**)) geary_db_transaction_connection_real_exec_file;
	iface->get_database = geary_db_transaction_connection_real_get_database;
	iface->get_db = geary_db_transaction_connection_real_get_db;
}

static void
geary_db_transaction_connection_instance_init (GearyDbTransactionConnection * self,
                                               gpointer klass)
{
	gchar** _tmp0_;
	self->priv = geary_db_transaction_connection_get_instance_private (self);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	self->transaction_log = _tmp0_;
	self->transaction_log_length1 = 0;
	self->_transaction_log_size_ = self->transaction_log_length1;
}

static void
geary_db_transaction_connection_finalize (GObject * obj)
{
	GearyDbTransactionConnection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_DB_TYPE_TRANSACTION_CONNECTION, GearyDbTransactionConnection);
	self->transaction_log = (_vala_array_free (self->transaction_log, self->transaction_log_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->db_cx);
	G_OBJECT_CLASS (geary_db_transaction_connection_parent_class)->finalize (obj);
}

/**
 * A connection to the database for transactions.
 */
 G_GNUC_NO_INLINE static GType
geary_db_transaction_connection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyDbTransactionConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_db_transaction_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyDbTransactionConnection), 0, (GInstanceInitFunc) geary_db_transaction_connection_instance_init, NULL };
	static const GInterfaceInfo geary_db_connection_info = { (GInterfaceInitFunc) geary_db_transaction_connection_geary_db_connection_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_db_transaction_connection_type_id;
	geary_db_transaction_connection_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyDbTransactionConnection", &g_define_type_info, 0);
	g_type_add_interface_static (geary_db_transaction_connection_type_id, GEARY_DB_TYPE_CONNECTION, &geary_db_connection_info);
	GearyDbTransactionConnection_private_offset = g_type_add_instance_private (geary_db_transaction_connection_type_id, sizeof (GearyDbTransactionConnectionPrivate));
	return geary_db_transaction_connection_type_id;
}

GType
geary_db_transaction_connection_get_type (void)
{
	static gsize geary_db_transaction_connection_type_id__once = 0;
	if (g_once_init_enter (&geary_db_transaction_connection_type_id__once)) {
		GType geary_db_transaction_connection_type_id;
		geary_db_transaction_connection_type_id = geary_db_transaction_connection_get_type_once ();
		g_once_init_leave (&geary_db_transaction_connection_type_id__once, geary_db_transaction_connection_type_id);
	}
	return geary_db_transaction_connection_type_id__once;
}

static void
_vala_geary_db_transaction_connection_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec)
{
	GearyDbTransactionConnection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_DB_TYPE_TRANSACTION_CONNECTION, GearyDbTransactionConnection);
	switch (property_id) {
		case GEARY_DB_TRANSACTION_CONNECTION_DATABASE_PROPERTY:
		g_value_set_object (value, geary_db_connection_get_database (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_DB_TYPE_CONNECTION, GearyDbConnection)));
		break;
		case GEARY_DB_TRANSACTION_CONNECTION_DB_PROPERTY:
		g_value_set_pointer (value, geary_db_connection_get_db (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_DB_TYPE_CONNECTION, GearyDbConnection)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

