/* db-connection.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from db-connection.vala, do not modify */

/*
 * Copyright © 2016 Software Freedom Conservancy Inc.
 * Copyright © 2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <sqlite3.h>
#include <gio/gio.h>

#define GEARY_DB_CONNECTION_PRAGMA_FOREIGN_KEYS "foreign_keys"
#define GEARY_DB_CONNECTION_PRAGMA_RECURSIVE_TRIGGERS "recursive_triggers"
#define GEARY_DB_CONNECTION_PRAGMA_USER_VERSION "user_version"
#define GEARY_DB_CONNECTION_PRAGMA_SCHEMA_VERSION "schema_version"
#define GEARY_DB_CONNECTION_PRAGMA_SECURE_DELETE "secure_delete"
#define GEARY_DB_CONNECTION_PRAGMA_SYNCHRONOUS "synchronous"
#define GEARY_DB_CONNECTION_PRAGMA_FREELIST_COUNT "freelist_count"
#define GEARY_DB_CONNECTION_PRAGMA_PAGE_COUNT "page_count"
#define GEARY_DB_CONNECTION_PRAGMA_PAGE_SIZE "page_size"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

VALA_EXTERN sqlite3* geary_db_connection_get_db (GearyDbConnection* self);
static GType geary_db_connection_get_type_once (void);

gint64
geary_db_connection_get_last_insert_rowid (GearyDbConnection* self)
{
	gint64 result;
	sqlite3* _tmp0_;
	sqlite3* _tmp1_;
	g_return_val_if_fail (GEARY_DB_IS_CONNECTION (self), 0LL);
	_tmp0_ = geary_db_connection_get_db (self);
	_tmp1_ = _tmp0_;
	result = sqlite3_last_insert_rowid (_tmp1_);
	return result;
}

gint
geary_db_connection_get_last_modified_rows (GearyDbConnection* self)
{
	gint result;
	sqlite3* _tmp0_;
	sqlite3* _tmp1_;
	g_return_val_if_fail (GEARY_DB_IS_CONNECTION (self), 0);
	_tmp0_ = geary_db_connection_get_db (self);
	_tmp1_ = _tmp0_;
	result = sqlite3_changes (_tmp1_);
	return result;
}

gint
geary_db_connection_get_total_modified_rows (GearyDbConnection* self)
{
	gint result;
	sqlite3* _tmp0_;
	sqlite3* _tmp1_;
	g_return_val_if_fail (GEARY_DB_IS_CONNECTION (self), 0);
	_tmp0_ = geary_db_connection_get_db (self);
	_tmp1_ = _tmp0_;
	result = sqlite3_total_changes (_tmp1_);
	return result;
}

GearyDbDatabase*
geary_db_connection_get_database (GearyDbConnection* self)
{
	GearyDbConnectionIface* _iface_;
	g_return_val_if_fail (GEARY_DB_IS_CONNECTION (self), NULL);
	_iface_ = GEARY_DB_CONNECTION_GET_INTERFACE (self);
	if (_iface_->get_database) {
		return _iface_->get_database (self);
	}
	return NULL;
}

sqlite3*
geary_db_connection_get_db (GearyDbConnection* self)
{
	GearyDbConnectionIface* _iface_;
	g_return_val_if_fail (GEARY_DB_IS_CONNECTION (self), NULL);
	_iface_ = GEARY_DB_CONNECTION_GET_INTERFACE (self);
	if (_iface_->get_db) {
		return _iface_->get_db (self);
	}
	return NULL;
}

/**
     * Returns the result of a PRAGMA as a boolean.  See [[http://www.sqlite.org/pragma.html]]
     *
     * Note that if the PRAGMA does not return a boolean, the results are undefined.  A boolean
     * in SQLite, however, includes 1 and 0, so an integer may be mistaken as a boolean.
     */
gboolean
geary_db_connection_get_pragma_bool (GearyDbConnection* self,
                                     const gchar* name,
                                     GError** error)
{
	GearyDbResult* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GearyDbResult* _tmp3_;
	GearyDbResult* _tmp4_;
	gchar* response = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GQuark _tmp13_ = 0U;
	static GQuark _tmp12_label0 = 0;
	static GQuark _tmp12_label1 = 0;
	static GQuark _tmp12_label2 = 0;
	static GQuark _tmp12_label3 = 0;
	static GQuark _tmp12_label4 = 0;
	static GQuark _tmp12_label5 = 0;
	static GQuark _tmp12_label6 = 0;
	static GQuark _tmp12_label7 = 0;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp1_ = g_strdup_printf ("PRAGMA %s", name);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_db_connection_query (self, _tmp2_, NULL, &_inner_error0_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp5_;
	}
	_tmp6_ = geary_db_result_nonnull_string_at (_tmp0_, 0, &_inner_error0_);
	_tmp7_ = g_strdup (_tmp6_);
	response = _tmp7_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp8_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp0_);
		return _tmp8_;
	}
	_tmp9_ = response;
	_tmp10_ = g_utf8_strdown (_tmp9_, (gssize) -1);
	_tmp11_ = _tmp10_;
	_tmp13_ = (NULL == _tmp11_) ? 0 : g_quark_from_string (_tmp11_);
	g_free (_tmp11_);
	if ((((_tmp13_ == ((0 != _tmp12_label0) ? _tmp12_label0 : (_tmp12_label0 = g_quark_from_static_string ("1")))) || (_tmp13_ == ((0 != _tmp12_label1) ? _tmp12_label1 : (_tmp12_label1 = g_quark_from_static_string ("yes"))))) || (_tmp13_ == ((0 != _tmp12_label2) ? _tmp12_label2 : (_tmp12_label2 = g_quark_from_static_string ("true"))))) || (_tmp13_ == ((0 != _tmp12_label3) ? _tmp12_label3 : (_tmp12_label3 = g_quark_from_static_string ("on"))))) {
		switch (0) {
			default:
			{
				result = TRUE;
				_g_free0 (response);
				_g_object_unref0 (_tmp0_);
				return result;
			}
		}
	} else if ((((_tmp13_ == ((0 != _tmp12_label4) ? _tmp12_label4 : (_tmp12_label4 = g_quark_from_static_string ("0")))) || (_tmp13_ == ((0 != _tmp12_label5) ? _tmp12_label5 : (_tmp12_label5 = g_quark_from_static_string ("no"))))) || (_tmp13_ == ((0 != _tmp12_label6) ? _tmp12_label6 : (_tmp12_label6 = g_quark_from_static_string ("false"))))) || (_tmp13_ == ((0 != _tmp12_label7) ? _tmp12_label7 : (_tmp12_label7 = g_quark_from_static_string ("off"))))) {
		switch (0) {
			default:
			{
				result = FALSE;
				_g_free0 (response);
				_g_object_unref0 (_tmp0_);
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp14_;
				_tmp14_ = response;
				g_debug ("db-connection.vala:84: Db.Connection.get_pragma_bool: unknown PRAGMA b" \
"oolean response \"%s\"", _tmp14_);
				result = FALSE;
				_g_free0 (response);
				_g_object_unref0 (_tmp0_);
				return result;
			}
		}
	}
}

/**
     * Sets a boolean PRAGMA value to either "true" or "false".
     */
void
geary_db_connection_set_pragma_bool (GearyDbConnection* self,
                                     const gchar* name,
                                     gboolean b,
                                     GError** error)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (name != NULL);
	if (b) {
		_tmp0_ = "true";
	} else {
		_tmp0_ = "false";
	}
	_tmp1_ = g_strdup_printf ("PRAGMA %s=%s", name, _tmp0_);
	_tmp2_ = _tmp1_;
	geary_db_connection_exec (self, _tmp2_, NULL, &_inner_error0_);
	_g_free0 (_tmp2_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

/**
     * Returns the result of a PRAGMA as an integer.  See [[http://www.sqlite.org/pragma.html]]
     *
     * Note that if the PRAGMA does not return an integer, the results are undefined.  Since a
     * boolean in SQLite includes 1 and 0, it's possible for those values to be converted to an
     * integer.
     */
gint
geary_db_connection_get_pragma_int (GearyDbConnection* self,
                                    const gchar* name,
                                    GError** error)
{
	GearyDbResult* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GearyDbResult* _tmp3_;
	GearyDbResult* _tmp4_;
	gint _tmp6_ = 0;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (name != NULL, 0);
	_tmp1_ = g_strdup_printf ("PRAGMA %s", name);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_db_connection_query (self, _tmp2_, NULL, &_inner_error0_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp5_ = -1;
		g_propagate_error (error, _inner_error0_);
		return _tmp5_;
	}
	_tmp6_ = geary_db_result_int_at (_tmp0_, 0, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp7_ = -1;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp0_);
		return _tmp7_;
	}
	result = _tmp6_;
	_g_object_unref0 (_tmp0_);
	return result;
}

/**
     * Sets an integer PRAGMA value.
     */
void
geary_db_connection_set_pragma_int (GearyDbConnection* self,
                                    const gchar* name,
                                    gint d,
                                    GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (name != NULL);
	_tmp0_ = g_strdup_printf ("PRAGMA %s=%d", name, d);
	_tmp1_ = _tmp0_;
	geary_db_connection_exec (self, _tmp1_, NULL, &_inner_error0_);
	_g_free0 (_tmp1_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

/**
     * Returns the result of a PRAGMA as a 64-bit integer. See [[http://www.sqlite.org/pragma.html]]
     *
     * Note that if the PRAGMA does not return an integer, the results are undefined.  Since a
     * boolean in SQLite includes 1 and 0, it's possible for those values to be converted to an
     * integer.
     */
gint64
geary_db_connection_get_pragma_int64 (GearyDbConnection* self,
                                      const gchar* name,
                                      GError** error)
{
	GearyDbResult* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GearyDbResult* _tmp3_;
	GearyDbResult* _tmp4_;
	gint64 _tmp6_ = 0LL;
	GError* _inner_error0_ = NULL;
	gint64 result;
	g_return_val_if_fail (name != NULL, 0LL);
	_tmp1_ = g_strdup_printf ("PRAGMA %s", name);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_db_connection_query (self, _tmp2_, NULL, &_inner_error0_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint64 _tmp5_ = -1LL;
		g_propagate_error (error, _inner_error0_);
		return _tmp5_;
	}
	_tmp6_ = geary_db_result_int64_at (_tmp0_, 0, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint64 _tmp7_ = -1LL;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp0_);
		return _tmp7_;
	}
	result = _tmp6_;
	_g_object_unref0 (_tmp0_);
	return result;
}

/**
     * Sets a 64-bit integer PRAGMA value.
     */
void
geary_db_connection_set_pragma_int64 (GearyDbConnection* self,
                                      const gchar* name,
                                      gint64 ld,
                                      GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (name != NULL);
	_tmp0_ = g_strdup_printf ("%" G_GINT64_FORMAT, ld);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("PRAGMA %s=%s", name, _tmp1_);
	_tmp3_ = _tmp2_;
	geary_db_connection_exec (self, _tmp3_, NULL, &_inner_error0_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

/**
     * Returns the result of a PRAGMA as a string.  See [[http://www.sqlite.org/pragma.html]]
     */
gchar*
geary_db_connection_get_pragma_string (GearyDbConnection* self,
                                       const gchar* name,
                                       GError** error)
{
	GearyDbResult* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GearyDbResult* _tmp3_;
	GearyDbResult* _tmp4_;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp1_ = g_strdup_printf ("PRAGMA %s", name);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_db_connection_query (self, _tmp2_, NULL, &_inner_error0_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp6_ = geary_db_result_nonnull_string_at (_tmp0_, 0, &_inner_error0_);
	_tmp5_ = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp0_);
		return NULL;
	}
	_tmp7_ = g_strdup (_tmp5_);
	result = _tmp7_;
	_g_object_unref0 (_tmp0_);
	return result;
}

/**
     * Sets a string PRAGMA value.
     */
void
geary_db_connection_set_pragma_string (GearyDbConnection* self,
                                       const gchar* name,
                                       const gchar* str,
                                       GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (name != NULL);
	g_return_if_fail (str != NULL);
	_tmp0_ = g_strdup_printf ("PRAGMA %s=%s", name, str);
	_tmp1_ = _tmp0_;
	geary_db_connection_exec (self, _tmp1_, NULL, &_inner_error0_);
	_g_free0 (_tmp1_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

/**
     * Returns the user_version number maintained by SQLite.
     *
     * A new database has a user version number of zero.
     *
     * @see set_user_version_number
     */
gint
geary_db_connection_get_user_version_number (GearyDbConnection* self,
                                             GError** error)
{
	gint _tmp0_ = 0;
	GError* _inner_error0_ = NULL;
	gint result;
	_tmp0_ = geary_db_connection_get_pragma_int (self, GEARY_DB_CONNECTION_PRAGMA_USER_VERSION, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp1_ = -1;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	result = _tmp0_;
	return result;
}

/**
     * Sets the user version number, which is a private number maintained by the user.
     * VersionedDatabase uses this to maintain the version number of the database.
     *
     * See [[http://www.sqlite.org/pragma.html#pragma_schema_version]]
     */
void
geary_db_connection_set_user_version_number (GearyDbConnection* self,
                                             gint version,
                                             GError** error)
{
	GError* _inner_error0_ = NULL;
	geary_db_connection_set_pragma_int (self, GEARY_DB_CONNECTION_PRAGMA_USER_VERSION, version, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

/**
     * Gets the schema version number, which is maintained by SQLite. See
     * [[http://www.sqlite.org/pragma.html#pragma_schema_version]]
     *
     * Since this number is maintained by SQLite, Geary.Db doesn't offer a way to set it.
     */
gint
geary_db_connection_get_schema_version_number (GearyDbConnection* self,
                                               GError** error)
{
	gint _tmp0_ = 0;
	GError* _inner_error0_ = NULL;
	gint result;
	_tmp0_ = geary_db_connection_get_pragma_int (self, GEARY_DB_CONNECTION_PRAGMA_SCHEMA_VERSION, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp1_ = -1;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	result = _tmp0_;
	return result;
}

/**
     * See [[http://www.sqlite.org/pragma.html#pragma_foreign_keys]]
     */
void
geary_db_connection_set_foreign_keys (GearyDbConnection* self,
                                      gboolean enabled,
                                      GError** error)
{
	GError* _inner_error0_ = NULL;
	geary_db_connection_set_pragma_bool (self, GEARY_DB_CONNECTION_PRAGMA_FOREIGN_KEYS, enabled, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

/**
     * See [[http://www.sqlite.org/pragma.html#pragma_foreign_keys]]
     */
gboolean
geary_db_connection_get_foreign_keys (GearyDbConnection* self,
                                      GError** error)
{
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	_tmp0_ = geary_db_connection_get_pragma_bool (self, GEARY_DB_CONNECTION_PRAGMA_FOREIGN_KEYS, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	result = _tmp0_;
	return result;
}

/**
     * See [[http://www.sqlite.org/pragma.html#pragma_recursive_triggers]]
     */
void
geary_db_connection_set_recursive_triggers (GearyDbConnection* self,
                                            gboolean enabled,
                                            GError** error)
{
	GError* _inner_error0_ = NULL;
	geary_db_connection_set_pragma_bool (self, GEARY_DB_CONNECTION_PRAGMA_RECURSIVE_TRIGGERS, enabled, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

/**
     * See [[http://www.sqlite.org/pragma.html#pragma_recursive_triggers]]
     */
gboolean
geary_db_connection_get_recursive_triggers (GearyDbConnection* self,
                                            GError** error)
{
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	_tmp0_ = geary_db_connection_get_pragma_bool (self, GEARY_DB_CONNECTION_PRAGMA_RECURSIVE_TRIGGERS, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	result = _tmp0_;
	return result;
}

/**
     * See [[http://www.sqlite.org/pragma.html#pragma_secure_delete]]
     */
void
geary_db_connection_set_secure_delete (GearyDbConnection* self,
                                       gboolean enabled,
                                       GError** error)
{
	GError* _inner_error0_ = NULL;
	geary_db_connection_set_pragma_bool (self, GEARY_DB_CONNECTION_PRAGMA_SECURE_DELETE, enabled, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

/**
     * See [[http://www.sqlite.org/pragma.html#pragma_secure_delete]]
     */
gboolean
geary_db_connection_get_secure_delete (GearyDbConnection* self,
                                       GError** error)
{
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	_tmp0_ = geary_db_connection_get_pragma_bool (self, GEARY_DB_CONNECTION_PRAGMA_SECURE_DELETE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	result = _tmp0_;
	return result;
}

/**
     * See [[http://www.sqlite.org/pragma.html#pragma_synchronous]]
     */
void
geary_db_connection_set_synchronous (GearyDbConnection* self,
                                     GearyDbSynchronousMode mode,
                                     GError** error)
{
	const gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = geary_db_synchronous_mode_sql (mode);
	geary_db_connection_set_pragma_string (self, GEARY_DB_CONNECTION_PRAGMA_SYNCHRONOUS, _tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

/**
     * See [[http://www.sqlite.org/pragma.html#pragma_synchronous]]
     */
GearyDbSynchronousMode
geary_db_connection_get_synchronous (GearyDbConnection* self,
                                     GError** error)
{
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	GearyDbSynchronousMode result;
	_tmp1_ = geary_db_connection_get_pragma_string (self, GEARY_DB_CONNECTION_PRAGMA_SYNCHRONOUS, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return 0;
	}
	result = geary_db_synchronous_mode_parse (_tmp0_);
	_g_free0 (_tmp0_);
	return result;
}

/**
     * See [[https://www.sqlite.org/pragma.html#pragma_freelist_count]]
     */
gint64
geary_db_connection_get_free_page_count (GearyDbConnection* self,
                                         GError** error)
{
	gint64 _tmp0_ = 0LL;
	GError* _inner_error0_ = NULL;
	gint64 result;
	_tmp0_ = geary_db_connection_get_pragma_int64 (self, GEARY_DB_CONNECTION_PRAGMA_FREELIST_COUNT, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint64 _tmp1_ = -1LL;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	result = _tmp0_;
	return result;
}

/**
     * See [[https://www.sqlite.org/pragma.html#pragma_page_count]]
     */
gint64
geary_db_connection_get_total_page_count (GearyDbConnection* self,
                                          GError** error)
{
	gint64 _tmp0_ = 0LL;
	GError* _inner_error0_ = NULL;
	gint64 result;
	_tmp0_ = geary_db_connection_get_pragma_int64 (self, GEARY_DB_CONNECTION_PRAGMA_PAGE_COUNT, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint64 _tmp1_ = -1LL;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	result = _tmp0_;
	return result;
}

/**
     * See [[https://www.sqlite.org/pragma.html#pragma_page_size]]
     */
gint
geary_db_connection_get_page_size (GearyDbConnection* self,
                                   GError** error)
{
	gint _tmp0_ = 0;
	GError* _inner_error0_ = NULL;
	gint result;
	_tmp0_ = geary_db_connection_get_pragma_int (self, GEARY_DB_CONNECTION_PRAGMA_PAGE_SIZE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp1_ = -1;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	result = _tmp0_;
	return result;
}

/**
     * Prepares a single SQL statement for execution.
     *
     * Only a single SQL statement may be included in the string. See
     * [[http://www.sqlite.org/lang.html]] for more information on
     * SQLite's SQL syntax.
     *
     * The given SQL string may contain placeholders for values, which
     * must then be bound with actual values by calls such as {@link
     * Statement.bind_string} prior to executing.
     *
     * SQLite reference: [[http://www.sqlite.org/c3ref/prepare.html]]
     */
GearyDbStatement*
geary_db_connection_prepare (GearyDbConnection* self,
                             const gchar* sql,
                             GError** error)
{
	GearyDbConnectionIface* _iface_;
	g_return_val_if_fail (GEARY_DB_IS_CONNECTION (self), NULL);
	_iface_ = GEARY_DB_CONNECTION_GET_INTERFACE (self);
	if (_iface_->prepare) {
		return _iface_->prepare (self, sql, error);
	}
	return NULL;
}

/**
     * Executes a single SQL statement, returning a result.
     *
     * Only a single SQL statement may be included in the string. See
     * [[http://www.sqlite.org/lang.html]] for more information on
     * SQLite's SQL syntax.
     *
     * @see exec
     */
GearyDbResult*
geary_db_connection_query (GearyDbConnection* self,
                           const gchar* sql,
                           GCancellable* cancellable,
                           GError** error)
{
	GearyDbConnectionIface* _iface_;
	g_return_val_if_fail (GEARY_DB_IS_CONNECTION (self), NULL);
	_iface_ = GEARY_DB_CONNECTION_GET_INTERFACE (self);
	if (_iface_->query) {
		return _iface_->query (self, sql, cancellable, error);
	}
	return NULL;
}

/**
     * Executes or more SQL statements without returning a result.
     *
     * More than one SQL statement may be in the string. See
     * [[http://www.sqlite.org/lang.html]] for more information on
     * SQLite's SQL syntax.
     *
     * There is no way to retrieve a result iterator from this
     * call. If needed, use {@link query} instead.
     *
     * SQLite reference: [[http://www.sqlite.org/c3ref/exec.html]]
     */
void
geary_db_connection_exec (GearyDbConnection* self,
                          const gchar* sql,
                          GCancellable* cancellable,
                          GError** error)
{
	GearyDbConnectionIface* _iface_;
	g_return_if_fail (GEARY_DB_IS_CONNECTION (self));
	_iface_ = GEARY_DB_CONNECTION_GET_INTERFACE (self);
	if (_iface_->exec) {
		_iface_->exec (self, sql, cancellable, error);
	}
}

/**
     * Executes SQL commands from a plain text file.
     *
     * The given file is read into memory and executed via a single
     * call to {@link exec}.
     *
     * There is no way to retrieve a result iterator from this call.
     *
     * @see Connection.exec
     */
void
geary_db_connection_exec_file (GearyDbConnection* self,
                               GFile* file,
                               GCancellable* cancellable,
                               GError** error)
{
	GearyDbConnectionIface* _iface_;
	g_return_if_fail (GEARY_DB_IS_CONNECTION (self));
	_iface_ = GEARY_DB_CONNECTION_GET_INTERFACE (self);
	if (_iface_->exec_file) {
		_iface_->exec_file (self, file, cancellable, error);
	}
}

static void
geary_db_connection_default_init (GearyDbConnectionIface * iface,
                                  gpointer iface_data)
{
	/** The database this connection is associated with. */
	g_object_interface_install_property (iface, g_param_spec_object ("database", "database", "database", GEARY_DB_TYPE_DATABASE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** The underlying SQLite database connection. */
	g_object_interface_install_property (iface, g_param_spec_pointer ("db", "db", "db", G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

/**
 * Represents a connection to an opened database.
 *
 * Connections are associated with a specific {@link Database}
 * instance. Because SQLite uses a synchronous interface, all calls on
 * a single connection instance are blocking. Use multiple connections
 * for concurrent access to a single database, or use the asynchronous
 * transaction support provided by {@link Database}.
 *
 * A connection will be automatically closed when its last reference
 * is dropped.
 */
 G_GNUC_NO_INLINE static GType
geary_db_connection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyDbConnectionIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_db_connection_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType geary_db_connection_type_id;
	geary_db_connection_type_id = g_type_register_static (G_TYPE_INTERFACE, "GearyDbConnection", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (geary_db_connection_type_id, GEARY_TYPE_BASE_OBJECT);
	return geary_db_connection_type_id;
}

GType
geary_db_connection_get_type (void)
{
	static gsize geary_db_connection_type_id__once = 0;
	if (g_once_init_enter (&geary_db_connection_type_id__once)) {
		GType geary_db_connection_type_id;
		geary_db_connection_type_id = geary_db_connection_get_type_once ();
		g_once_init_leave (&geary_db_connection_type_id__once, geary_db_connection_type_id);
	}
	return geary_db_connection_type_id__once;
}

