/* geary-email.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from geary-email.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2018 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_EMAIL_0_PROPERTY,
	GEARY_EMAIL_ID_PROPERTY,
	GEARY_EMAIL_FROM_PROPERTY,
	GEARY_EMAIL_SENDER_PROPERTY,
	GEARY_EMAIL_REPLY_TO_PROPERTY,
	GEARY_EMAIL_TO_PROPERTY,
	GEARY_EMAIL_CC_PROPERTY,
	GEARY_EMAIL_BCC_PROPERTY,
	GEARY_EMAIL_MESSAGE_ID_PROPERTY,
	GEARY_EMAIL_IN_REPLY_TO_PROPERTY,
	GEARY_EMAIL_REFERENCES_PROPERTY,
	GEARY_EMAIL_SUBJECT_PROPERTY,
	GEARY_EMAIL_DATE_PROPERTY,
	GEARY_EMAIL_HEADER_PROPERTY,
	GEARY_EMAIL_BODY_PROPERTY,
	GEARY_EMAIL_ATTACHMENTS_PROPERTY,
	GEARY_EMAIL_PREVIEW_PROPERTY,
	GEARY_EMAIL_PROPERTIES_PROPERTY,
	GEARY_EMAIL_EMAIL_FLAGS_PROPERTY,
	GEARY_EMAIL_FIELDS_PROPERTY,
	GEARY_EMAIL_NUM_PROPERTIES
};
static GParamSpec* geary_email_properties[GEARY_EMAIL_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GearyEmailPrivate {
	GearyEmailIdentifier* _id;
	GearyRFC822MailboxAddresses* _from;
	GearyRFC822MailboxAddress* _sender;
	GearyRFC822MailboxAddresses* _reply_to;
	GearyRFC822MailboxAddresses* _to;
	GearyRFC822MailboxAddresses* _cc;
	GearyRFC822MailboxAddresses* _bcc;
	GearyRFC822MessageID* _message_id;
	GearyRFC822MessageIDList* _in_reply_to;
	GearyRFC822MessageIDList* _references;
	GearyRFC822Subject* _subject;
	GearyRFC822Date* _date;
	GearyRFC822Header* _header;
	GearyRFC822Text* _body;
	GeeList* _attachments;
	GearyRFC822PreviewText* _preview;
	GearyEmailProperties* _properties;
	GearyEmailFlags* _email_flags;
	GearyEmailField _fields;
	GearyRFC822Message* message;
};

static gint GearyEmail_private_offset;
static gpointer geary_email_parent_class = NULL;
static GearyEmailHeaderSetIface * geary_email_geary_email_header_set_parent_iface = NULL;

static void geary_email_set_id (GearyEmail* self,
                         GearyEmailIdentifier* value);
static void geary_email_set_body (GearyEmail* self,
                           GearyRFC822Text* value);
static void geary_email_set_attachments (GearyEmail* self,
                                  GeeList* value);
static void geary_email_set_preview (GearyEmail* self,
                              GearyRFC822PreviewText* value);
static void geary_email_set_properties (GearyEmail* self,
                                 GearyEmailProperties* value);
static void geary_email_set_email_flags (GearyEmail* self,
                                  GearyEmailFlags* value);
static void geary_email_set_fields (GearyEmail* self,
                             GearyEmailField value);
static gint geary_email_compare_id_ascending (GearyEmail* aemail,
                                       GearyEmail* bemail);
static void geary_email_finalize (GObject * obj);
static GType geary_email_get_type_once (void);
static void _vala_geary_email_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_geary_email_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);

static inline gpointer
geary_email_get_instance_private (GearyEmail* self)
{
	return G_STRUCT_MEMBER_P (self, GearyEmail_private_offset);
}

/**
     * Specifies specific parts of an email message.
     *
     * See the {@link Email.fields} property to determine which parts
     * an email object currently contains.
     */
GearyEmailField*
geary_email_field_all (gint* result_length1)
{
	GearyEmailField* _tmp0_;
	GearyEmailField* _tmp1_;
	gint _tmp1__length1;
	GearyEmailField* result;
	_tmp0_ = g_new0 (GearyEmailField, 10);
	_tmp0_[0] = GEARY_EMAIL_FIELD_DATE;
	_tmp0_[1] = GEARY_EMAIL_FIELD_ORIGINATORS;
	_tmp0_[2] = GEARY_EMAIL_FIELD_RECEIVERS;
	_tmp0_[3] = GEARY_EMAIL_FIELD_REFERENCES;
	_tmp0_[4] = GEARY_EMAIL_FIELD_SUBJECT;
	_tmp0_[5] = GEARY_EMAIL_FIELD_HEADER;
	_tmp0_[6] = GEARY_EMAIL_FIELD_BODY;
	_tmp0_[7] = GEARY_EMAIL_FIELD_PROPERTIES;
	_tmp0_[8] = GEARY_EMAIL_FIELD_PREVIEW;
	_tmp0_[9] = GEARY_EMAIL_FIELD_FLAGS;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 10;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

inline gboolean
geary_email_field_is_all_set (GearyEmailField self,
                              GearyEmailField required_fields)
{
	gboolean result;
	result = (self & required_fields) == required_fields;
	return result;
}

inline gboolean
geary_email_field_is_any_set (GearyEmailField self,
                              GearyEmailField required_fields)
{
	gboolean result;
	result = (self & required_fields) != 0;
	return result;
}

inline GearyEmailField
geary_email_field_set (GearyEmailField self,
                       GearyEmailField field)
{
	GearyEmailField result;
	result = self | field;
	return result;
}

inline GearyEmailField
geary_email_field_clear (GearyEmailField self,
                         GearyEmailField field)
{
	GearyEmailField result;
	result = self & (~field);
	return result;
}

inline gboolean
geary_email_field_fulfills (GearyEmailField self,
                            GearyEmailField required_fields)
{
	gboolean result;
	result = geary_email_field_is_all_set (self, required_fields);
	return result;
}

inline gboolean
geary_email_field_fulfills_any (GearyEmailField self,
                                GearyEmailField required_fields)
{
	gboolean result;
	result = geary_email_field_is_any_set (self, required_fields);
	return result;
}

inline gboolean
geary_email_field_require (GearyEmailField self,
                           GearyEmailField required_fields)
{
	gboolean result;
	result = geary_email_field_is_all_set (self, required_fields);
	return result;
}

inline gboolean
geary_email_field_requires_any (GearyEmailField self,
                                GearyEmailField required_fields)
{
	gboolean result;
	result = geary_email_field_is_any_set (self, required_fields);
	return result;
}

gchar*
geary_email_field_to_string (GearyEmailField self)
{
	gchar* value = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup ("NONE");
	value = _tmp0_;
	if (self == GEARY_EMAIL_FIELD_ALL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("ALL");
		_g_free0 (value);
		value = _tmp1_;
	} else {
		if (self > 0) {
			GString* builder = NULL;
			GString* _tmp2_;
			gint _tmp3_ = 0;
			GearyEmailField* _tmp4_;
			GString* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp2_ = g_string_new ("");
			builder = _tmp2_;
			_tmp4_ = geary_email_field_all (&_tmp3_);
			{
				GearyEmailField* f_collection = NULL;
				gint f_collection_length1 = 0;
				gint _f_collection_size_ = 0;
				gint f_it = 0;
				f_collection = _tmp4_;
				f_collection_length1 = _tmp3_;
				for (f_it = 0; f_it < f_collection_length1; f_it = f_it + 1) {
					GearyEmailField f = 0;
					f = f_collection[f_it];
					{
						if (geary_email_field_is_all_set (self, f)) {
							GString* _tmp5_;
							const gchar* _tmp6_;
							GString* _tmp8_;
							gchar* _tmp9_;
							gchar* _tmp10_;
							gchar* _tmp11_;
							gchar* _tmp12_;
							_tmp5_ = builder;
							_tmp6_ = _tmp5_->str;
							if (!geary_string_is_empty (_tmp6_)) {
								GString* _tmp7_;
								_tmp7_ = builder;
								g_string_append (_tmp7_, ",");
							}
							_tmp8_ = builder;
							_tmp9_ = geary_object_utils_to_enum_nick (GEARY_EMAIL_TYPE_FIELD, NULL, NULL, GEARY_EMAIL_TYPE_FIELD, (gpointer) ((gintptr) f));
							_tmp10_ = _tmp9_;
							_tmp11_ = g_utf8_strup (_tmp10_, (gssize) -1);
							_tmp12_ = _tmp11_;
							g_string_append (_tmp8_, _tmp12_);
							_g_free0 (_tmp12_);
							_g_free0 (_tmp10_);
						}
					}
				}
				f_collection = (g_free (f_collection), NULL);
			}
			_tmp13_ = builder;
			_tmp14_ = _tmp13_->str;
			_tmp15_ = g_strdup (_tmp14_);
			_g_free0 (value);
			value = _tmp15_;
			_g_string_free0 (builder);
		}
	}
	result = value;
	return result;
}

 G_GNUC_NO_INLINE static GType
geary_email_field_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_EMAIL_FIELD_NONE, "GEARY_EMAIL_FIELD_NONE", "none"}, {GEARY_EMAIL_FIELD_DATE, "GEARY_EMAIL_FIELD_DATE", "date"}, {GEARY_EMAIL_FIELD_ORIGINATORS, "GEARY_EMAIL_FIELD_ORIGINATORS", "originators"}, {GEARY_EMAIL_FIELD_RECEIVERS, "GEARY_EMAIL_FIELD_RECEIVERS", "receivers"}, {GEARY_EMAIL_FIELD_REFERENCES, "GEARY_EMAIL_FIELD_REFERENCES", "references"}, {GEARY_EMAIL_FIELD_SUBJECT, "GEARY_EMAIL_FIELD_SUBJECT", "subject"}, {GEARY_EMAIL_FIELD_HEADER, "GEARY_EMAIL_FIELD_HEADER", "header"}, {GEARY_EMAIL_FIELD_BODY, "GEARY_EMAIL_FIELD_BODY", "body"}, {GEARY_EMAIL_FIELD_PROPERTIES, "GEARY_EMAIL_FIELD_PROPERTIES", "properties"}, {GEARY_EMAIL_FIELD_PREVIEW, "GEARY_EMAIL_FIELD_PREVIEW", "preview"}, {GEARY_EMAIL_FIELD_FLAGS, "GEARY_EMAIL_FIELD_FLAGS", "flags"}, {GEARY_EMAIL_FIELD_ENVELOPE, "GEARY_EMAIL_FIELD_ENVELOPE", "envelope"}, {GEARY_EMAIL_FIELD_ALL, "GEARY_EMAIL_FIELD_ALL", "all"}, {0, NULL, NULL}};
	GType geary_email_field_type_id;
	geary_email_field_type_id = g_enum_register_static ("GearyEmailField", values);
	return geary_email_field_type_id;
}

GType
geary_email_field_get_type (void)
{
	static gsize geary_email_field_type_id__once = 0;
	if (g_once_init_enter (&geary_email_field_type_id__once)) {
		GType geary_email_field_type_id;
		geary_email_field_type_id = geary_email_field_get_type_once ();
		g_once_init_leave (&geary_email_field_type_id__once, geary_email_field_type_id);
	}
	return geary_email_field_type_id__once;
}

GearyEmailIdentifier*
geary_email_get_id (GearyEmail* self)
{
	GearyEmailIdentifier* result;
	GearyEmailIdentifier* _tmp0_;
	g_return_val_if_fail (GEARY_IS_EMAIL (self), NULL);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_email_set_id (GearyEmail* self,
                    GearyEmailIdentifier* value)
{
	GearyEmailIdentifier* old_value;
	g_return_if_fail (GEARY_IS_EMAIL (self));
	old_value = geary_email_get_id (self);
	if (old_value != value) {
		GearyEmailIdentifier* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_id);
		self->priv->_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_email_properties[GEARY_EMAIL_ID_PROPERTY]);
	}
}

static GearyRFC822MailboxAddresses*
geary_email_real_get_from (GearyEmailHeaderSet* base)
{
	GearyRFC822MailboxAddresses* result;
	GearyEmail* self;
	GearyRFC822MailboxAddresses* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_EMAIL, GearyEmail);
	_tmp0_ = self->priv->_from;
	result = _tmp0_;
	return result;
}

static GearyRFC822MailboxAddress*
geary_email_real_get_sender (GearyEmailHeaderSet* base)
{
	GearyRFC822MailboxAddress* result;
	GearyEmail* self;
	GearyRFC822MailboxAddress* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_EMAIL, GearyEmail);
	_tmp0_ = self->priv->_sender;
	result = _tmp0_;
	return result;
}

static GearyRFC822MailboxAddresses*
geary_email_real_get_reply_to (GearyEmailHeaderSet* base)
{
	GearyRFC822MailboxAddresses* result;
	GearyEmail* self;
	GearyRFC822MailboxAddresses* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_EMAIL, GearyEmail);
	_tmp0_ = self->priv->_reply_to;
	result = _tmp0_;
	return result;
}

static GearyRFC822MailboxAddresses*
geary_email_real_get_to (GearyEmailHeaderSet* base)
{
	GearyRFC822MailboxAddresses* result;
	GearyEmail* self;
	GearyRFC822MailboxAddresses* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_EMAIL, GearyEmail);
	_tmp0_ = self->priv->_to;
	result = _tmp0_;
	return result;
}

static GearyRFC822MailboxAddresses*
geary_email_real_get_cc (GearyEmailHeaderSet* base)
{
	GearyRFC822MailboxAddresses* result;
	GearyEmail* self;
	GearyRFC822MailboxAddresses* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_EMAIL, GearyEmail);
	_tmp0_ = self->priv->_cc;
	result = _tmp0_;
	return result;
}

static GearyRFC822MailboxAddresses*
geary_email_real_get_bcc (GearyEmailHeaderSet* base)
{
	GearyRFC822MailboxAddresses* result;
	GearyEmail* self;
	GearyRFC822MailboxAddresses* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_EMAIL, GearyEmail);
	_tmp0_ = self->priv->_bcc;
	result = _tmp0_;
	return result;
}

static GearyRFC822MessageID*
geary_email_real_get_message_id (GearyEmailHeaderSet* base)
{
	GearyRFC822MessageID* result;
	GearyEmail* self;
	GearyRFC822MessageID* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_EMAIL, GearyEmail);
	_tmp0_ = self->priv->_message_id;
	result = _tmp0_;
	return result;
}

static GearyRFC822MessageIDList*
geary_email_real_get_in_reply_to (GearyEmailHeaderSet* base)
{
	GearyRFC822MessageIDList* result;
	GearyEmail* self;
	GearyRFC822MessageIDList* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_EMAIL, GearyEmail);
	_tmp0_ = self->priv->_in_reply_to;
	result = _tmp0_;
	return result;
}

static GearyRFC822MessageIDList*
geary_email_real_get_references (GearyEmailHeaderSet* base)
{
	GearyRFC822MessageIDList* result;
	GearyEmail* self;
	GearyRFC822MessageIDList* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_EMAIL, GearyEmail);
	_tmp0_ = self->priv->_references;
	result = _tmp0_;
	return result;
}

static GearyRFC822Subject*
geary_email_real_get_subject (GearyEmailHeaderSet* base)
{
	GearyRFC822Subject* result;
	GearyEmail* self;
	GearyRFC822Subject* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_EMAIL, GearyEmail);
	_tmp0_ = self->priv->_subject;
	result = _tmp0_;
	return result;
}

static GearyRFC822Date*
geary_email_real_get_date (GearyEmailHeaderSet* base)
{
	GearyRFC822Date* result;
	GearyEmail* self;
	GearyRFC822Date* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_EMAIL, GearyEmail);
	_tmp0_ = self->priv->_date;
	result = _tmp0_;
	return result;
}

GearyRFC822Header*
geary_email_get_header (GearyEmail* self)
{
	GearyRFC822Header* result;
	GearyRFC822Header* _tmp0_;
	g_return_val_if_fail (GEARY_IS_EMAIL (self), NULL);
	_tmp0_ = self->priv->_header;
	result = _tmp0_;
	return result;
}

void
geary_email_set_header (GearyEmail* self,
                        GearyRFC822Header* value)
{
	GearyRFC822Header* old_value;
	g_return_if_fail (GEARY_IS_EMAIL (self));
	old_value = geary_email_get_header (self);
	if (old_value != value) {
		GearyRFC822Header* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_header);
		self->priv->_header = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_email_properties[GEARY_EMAIL_HEADER_PROPERTY]);
	}
}

GearyRFC822Text*
geary_email_get_body (GearyEmail* self)
{
	GearyRFC822Text* result;
	GearyRFC822Text* _tmp0_;
	g_return_val_if_fail (GEARY_IS_EMAIL (self), NULL);
	_tmp0_ = self->priv->_body;
	result = _tmp0_;
	return result;
}

static void
geary_email_set_body (GearyEmail* self,
                      GearyRFC822Text* value)
{
	GearyRFC822Text* old_value;
	g_return_if_fail (GEARY_IS_EMAIL (self));
	old_value = geary_email_get_body (self);
	if (old_value != value) {
		GearyRFC822Text* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_body);
		self->priv->_body = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_email_properties[GEARY_EMAIL_BODY_PROPERTY]);
	}
}

GeeList*
geary_email_get_attachments (GearyEmail* self)
{
	GeeList* result;
	GeeList* _tmp0_;
	g_return_val_if_fail (GEARY_IS_EMAIL (self), NULL);
	_tmp0_ = self->priv->_attachments;
	result = _tmp0_;
	return result;
}

static void
geary_email_set_attachments (GearyEmail* self,
                             GeeList* value)
{
	GeeList* old_value;
	g_return_if_fail (GEARY_IS_EMAIL (self));
	old_value = geary_email_get_attachments (self);
	if (old_value != value) {
		GeeList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_attachments);
		self->priv->_attachments = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_email_properties[GEARY_EMAIL_ATTACHMENTS_PROPERTY]);
	}
}

GearyRFC822PreviewText*
geary_email_get_preview (GearyEmail* self)
{
	GearyRFC822PreviewText* result;
	GearyRFC822PreviewText* _tmp0_;
	g_return_val_if_fail (GEARY_IS_EMAIL (self), NULL);
	_tmp0_ = self->priv->_preview;
	result = _tmp0_;
	return result;
}

static void
geary_email_set_preview (GearyEmail* self,
                         GearyRFC822PreviewText* value)
{
	GearyRFC822PreviewText* old_value;
	g_return_if_fail (GEARY_IS_EMAIL (self));
	old_value = geary_email_get_preview (self);
	if (old_value != value) {
		GearyRFC822PreviewText* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_preview);
		self->priv->_preview = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_email_properties[GEARY_EMAIL_PREVIEW_PROPERTY]);
	}
}

GearyEmailProperties*
geary_email_get_properties (GearyEmail* self)
{
	GearyEmailProperties* result;
	GearyEmailProperties* _tmp0_;
	g_return_val_if_fail (GEARY_IS_EMAIL (self), NULL);
	_tmp0_ = self->priv->_properties;
	result = _tmp0_;
	return result;
}

static void
geary_email_set_properties (GearyEmail* self,
                            GearyEmailProperties* value)
{
	GearyEmailProperties* old_value;
	g_return_if_fail (GEARY_IS_EMAIL (self));
	old_value = geary_email_get_properties (self);
	if (old_value != value) {
		GearyEmailProperties* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_properties);
		self->priv->_properties = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_email_properties[GEARY_EMAIL_PROPERTIES_PROPERTY]);
	}
}

GearyEmailFlags*
geary_email_get_email_flags (GearyEmail* self)
{
	GearyEmailFlags* result;
	GearyEmailFlags* _tmp0_;
	g_return_val_if_fail (GEARY_IS_EMAIL (self), NULL);
	_tmp0_ = self->priv->_email_flags;
	result = _tmp0_;
	return result;
}

static void
geary_email_set_email_flags (GearyEmail* self,
                             GearyEmailFlags* value)
{
	GearyEmailFlags* old_value;
	g_return_if_fail (GEARY_IS_EMAIL (self));
	old_value = geary_email_get_email_flags (self);
	if (old_value != value) {
		GearyEmailFlags* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_email_flags);
		self->priv->_email_flags = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_email_properties[GEARY_EMAIL_EMAIL_FLAGS_PROPERTY]);
	}
}

GearyEmailField
geary_email_get_fields (GearyEmail* self)
{
	GearyEmailField result;
	g_return_val_if_fail (GEARY_IS_EMAIL (self), 0);
	result = self->priv->_fields;
	return result;
}

static void
geary_email_set_fields (GearyEmail* self,
                        GearyEmailField value)
{
	GearyEmailField old_value;
	g_return_if_fail (GEARY_IS_EMAIL (self));
	old_value = geary_email_get_fields (self);
	if (old_value != value) {
		self->priv->_fields = value;
		g_object_notify_by_pspec ((GObject *) self, geary_email_properties[GEARY_EMAIL_FIELDS_PROPERTY]);
	}
}

/** Constructs a new, empty email with the given id. */
GearyEmail*
geary_email_construct (GType object_type,
                       GearyEmailIdentifier* id)
{
	GearyEmail * self = NULL;
	g_return_val_if_fail (GEARY_IS_EMAIL_IDENTIFIER (id), NULL);
	self = (GearyEmail*) geary_base_object_construct (object_type);
	geary_email_set_id (self, id);
	return self;
}

GearyEmail*
geary_email_new (GearyEmailIdentifier* id)
{
	return geary_email_construct (GEARY_TYPE_EMAIL, id);
}

/**
     * Construct a Geary.Email from a complete RFC822 message.
     */
GearyEmail*
geary_email_construct_from_message (GType object_type,
                                    GearyEmailIdentifier* id,
                                    GearyRFC822Message* message,
                                    GError** error)
{
	GearyEmail * self = NULL;
	GearyRFC822Date* _tmp0_;
	GearyRFC822Date* _tmp1_;
	GearyRFC822MailboxAddresses* _tmp2_;
	GearyRFC822MailboxAddresses* _tmp3_;
	GearyRFC822MailboxAddress* _tmp4_;
	GearyRFC822MailboxAddress* _tmp5_;
	GearyRFC822MailboxAddresses* _tmp6_;
	GearyRFC822MailboxAddresses* _tmp7_;
	GearyRFC822MailboxAddresses* _tmp8_;
	GearyRFC822MailboxAddresses* _tmp9_;
	GearyRFC822MailboxAddresses* _tmp10_;
	GearyRFC822MailboxAddresses* _tmp11_;
	GearyRFC822MailboxAddresses* _tmp12_;
	GearyRFC822MailboxAddresses* _tmp13_;
	GearyRFC822MessageID* _tmp14_;
	GearyRFC822MessageID* _tmp15_;
	GearyRFC822MessageIDList* _tmp16_;
	GearyRFC822MessageIDList* _tmp17_;
	GearyRFC822MessageIDList* _tmp18_;
	GearyRFC822MessageIDList* _tmp19_;
	GearyRFC822Subject* _tmp20_;
	GearyRFC822Subject* _tmp21_;
	GearyRFC822Header* _tmp22_;
	GearyRFC822Header* _tmp23_;
	GearyRFC822Text* _tmp24_;
	GearyRFC822Text* _tmp25_;
	gchar* preview = NULL;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	GearyRFC822Message* _tmp31_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (GEARY_IS_EMAIL_IDENTIFIER (id), NULL);
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE (message), NULL);
	self = (GearyEmail*) geary_email_construct (object_type, id);
	_tmp0_ = geary_email_header_set_get_date (G_TYPE_CHECK_INSTANCE_CAST (message, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp1_ = _tmp0_;
	geary_email_set_send_date (self, _tmp1_);
	_tmp2_ = geary_email_header_set_get_from (G_TYPE_CHECK_INSTANCE_CAST (message, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp3_ = _tmp2_;
	_tmp4_ = geary_email_header_set_get_sender (G_TYPE_CHECK_INSTANCE_CAST (message, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp5_ = _tmp4_;
	_tmp6_ = geary_email_header_set_get_reply_to (G_TYPE_CHECK_INSTANCE_CAST (message, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp7_ = _tmp6_;
	geary_email_set_originators (self, _tmp3_, _tmp5_, _tmp7_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp8_ = geary_email_header_set_get_to (G_TYPE_CHECK_INSTANCE_CAST (message, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp9_ = _tmp8_;
	_tmp10_ = geary_email_header_set_get_cc (G_TYPE_CHECK_INSTANCE_CAST (message, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp11_ = _tmp10_;
	_tmp12_ = geary_email_header_set_get_bcc (G_TYPE_CHECK_INSTANCE_CAST (message, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp13_ = _tmp12_;
	geary_email_set_receivers (self, _tmp9_, _tmp11_, _tmp13_);
	_tmp14_ = geary_email_header_set_get_message_id (G_TYPE_CHECK_INSTANCE_CAST (message, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp15_ = _tmp14_;
	_tmp16_ = geary_email_header_set_get_in_reply_to (G_TYPE_CHECK_INSTANCE_CAST (message, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp17_ = _tmp16_;
	_tmp18_ = geary_email_header_set_get_references (G_TYPE_CHECK_INSTANCE_CAST (message, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp19_ = _tmp18_;
	geary_email_set_full_references (self, _tmp15_, _tmp17_, _tmp19_);
	_tmp20_ = geary_email_header_set_get_subject (G_TYPE_CHECK_INSTANCE_CAST (message, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp21_ = _tmp20_;
	geary_email_set_message_subject (self, _tmp21_);
	_tmp22_ = geary_rf_c822_message_get_header (message);
	_tmp23_ = _tmp22_;
	geary_email_set_message_header (self, _tmp23_);
	_g_object_unref0 (_tmp23_);
	_tmp24_ = geary_rf_c822_message_get_body (message);
	_tmp25_ = _tmp24_;
	geary_email_set_message_body (self, _tmp25_);
	_g_object_unref0 (_tmp25_);
	_tmp26_ = geary_rf_c822_message_get_preview (message);
	preview = _tmp26_;
	_tmp27_ = preview;
	if (!geary_string_is_empty_or_whitespace (_tmp27_)) {
		const gchar* _tmp28_;
		GearyRFC822PreviewText* _tmp29_;
		GearyRFC822PreviewText* _tmp30_;
		_tmp28_ = preview;
		_tmp29_ = geary_rf_c822_preview_text_new_from_string (_tmp28_);
		_tmp30_ = _tmp29_;
		geary_email_set_message_preview (self, _tmp30_);
		_g_object_unref0 (_tmp30_);
	}
	_tmp31_ = _g_object_ref0 (message);
	_g_object_unref0 (self->priv->message);
	self->priv->message = _tmp31_;
	_g_free0 (preview);
	return self;
}

GearyEmail*
geary_email_new_from_message (GearyEmailIdentifier* id,
                              GearyRFC822Message* message,
                              GError** error)
{
	return geary_email_construct_from_message (GEARY_TYPE_EMAIL, id, message, error);
}

/**
     * Determines if this message is unread from its flags.
     *
     * If {@link email_flags} is not null, returns the value of {@link
     * EmailFlags.is_unread}, otherwise returns {@link
     * Trillian.UNKNOWN}.
     */
inline GearyTrillian
geary_email_is_unread (GearyEmail* self)
{
	GearyTrillian _tmp0_ = 0;
	GearyEmailFlags* _tmp1_;
	GearyTrillian result;
	g_return_val_if_fail (GEARY_IS_EMAIL (self), 0);
	_tmp1_ = self->priv->_email_flags;
	if (_tmp1_ != NULL) {
		GearyEmailFlags* _tmp2_;
		_tmp2_ = self->priv->_email_flags;
		_tmp0_ = geary_trillian_from_boolean (geary_email_flags_is_unread (_tmp2_));
	} else {
		_tmp0_ = GEARY_TRILLIAN_UNKNOWN;
	}
	result = _tmp0_;
	return result;
}

/**
     * Determines if this message is flagged from its flags.
     *
     * If {@link email_flags} is not null, returns the value of {@link
     * EmailFlags.is_flagged}, otherwise returns {@link
     * Trillian.UNKNOWN}.
     */
inline GearyTrillian
geary_email_is_flagged (GearyEmail* self)
{
	GearyTrillian _tmp0_ = 0;
	GearyEmailFlags* _tmp1_;
	GearyTrillian result;
	g_return_val_if_fail (GEARY_IS_EMAIL (self), 0);
	_tmp1_ = self->priv->_email_flags;
	if (_tmp1_ != NULL) {
		GearyEmailFlags* _tmp2_;
		_tmp2_ = self->priv->_email_flags;
		_tmp0_ = geary_trillian_from_boolean (geary_email_flags_is_flagged (_tmp2_));
	} else {
		_tmp0_ = GEARY_TRILLIAN_UNKNOWN;
	}
	result = _tmp0_;
	return result;
}

/**
     * Determines if this message is flagged from its flags.
     *
     * If {@link email_flags} is not null, returns the value of {@link
     * EmailFlags.load_remote_images}, otherwise returns {@link
     * Trillian.UNKNOWN}.
     */
inline GearyTrillian
geary_email_load_remote_images (GearyEmail* self)
{
	GearyTrillian _tmp0_ = 0;
	GearyEmailFlags* _tmp1_;
	GearyTrillian result;
	g_return_val_if_fail (GEARY_IS_EMAIL (self), 0);
	_tmp1_ = self->priv->_email_flags;
	if (_tmp1_ != NULL) {
		GearyEmailFlags* _tmp2_;
		_tmp2_ = self->priv->_email_flags;
		_tmp0_ = geary_trillian_from_boolean (geary_email_flags_load_remote_images (_tmp2_));
	} else {
		_tmp0_ = GEARY_TRILLIAN_UNKNOWN;
	}
	result = _tmp0_;
	return result;
}

void
geary_email_set_send_date (GearyEmail* self,
                           GearyRFC822Date* date)
{
	GearyRFC822Date* _tmp0_;
	GearyEmailField _tmp1_;
	g_return_if_fail (GEARY_IS_EMAIL (self));
	g_return_if_fail ((date == NULL) || GEARY_RF_C822_IS_DATE (date));
	_tmp0_ = _g_object_ref0 (date);
	_g_object_unref0 (self->priv->_date);
	self->priv->_date = _tmp0_;
	_g_object_unref0 (self->priv->message);
	self->priv->message = NULL;
	_tmp1_ = self->priv->_fields;
	geary_email_set_fields (self, _tmp1_ | GEARY_EMAIL_FIELD_DATE);
}

/**
     * Sets the RFC822 originators for the message.
     *
     * RFC 2822 requires at least one From address, that the Sender
     * and From not be identical, and that both From and ReplyTo are
     * optional.
     */
void
geary_email_set_originators (GearyEmail* self,
                             GearyRFC822MailboxAddresses* from,
                             GearyRFC822MailboxAddress* sender,
                             GearyRFC822MailboxAddresses* reply_to,
                             GError** error)
{
	GearyRFC822MailboxAddresses* _tmp0_;
	GearyRFC822MailboxAddress* _tmp1_;
	GearyRFC822MailboxAddresses* _tmp2_;
	GearyEmailField _tmp3_;
	g_return_if_fail (GEARY_IS_EMAIL (self));
	g_return_if_fail ((from == NULL) || GEARY_RF_C822_IS_MAILBOX_ADDRESSES (from));
	g_return_if_fail ((sender == NULL) || GEARY_RF_C822_IS_MAILBOX_ADDRESS (sender));
	g_return_if_fail ((reply_to == NULL) || GEARY_RF_C822_IS_MAILBOX_ADDRESSES (reply_to));
	_tmp0_ = _g_object_ref0 (from);
	_g_object_unref0 (self->priv->_from);
	self->priv->_from = _tmp0_;
	_tmp1_ = _g_object_ref0 (sender);
	_g_object_unref0 (self->priv->_sender);
	self->priv->_sender = _tmp1_;
	_tmp2_ = _g_object_ref0 (reply_to);
	_g_object_unref0 (self->priv->_reply_to);
	self->priv->_reply_to = _tmp2_;
	_g_object_unref0 (self->priv->message);
	self->priv->message = NULL;
	_tmp3_ = self->priv->_fields;
	geary_email_set_fields (self, _tmp3_ | GEARY_EMAIL_FIELD_ORIGINATORS);
}

void
geary_email_set_receivers (GearyEmail* self,
                           GearyRFC822MailboxAddresses* to,
                           GearyRFC822MailboxAddresses* cc,
                           GearyRFC822MailboxAddresses* bcc)
{
	GearyRFC822MailboxAddresses* _tmp0_;
	GearyRFC822MailboxAddresses* _tmp1_;
	GearyRFC822MailboxAddresses* _tmp2_;
	GearyEmailField _tmp3_;
	g_return_if_fail (GEARY_IS_EMAIL (self));
	g_return_if_fail ((to == NULL) || GEARY_RF_C822_IS_MAILBOX_ADDRESSES (to));
	g_return_if_fail ((cc == NULL) || GEARY_RF_C822_IS_MAILBOX_ADDRESSES (cc));
	g_return_if_fail ((bcc == NULL) || GEARY_RF_C822_IS_MAILBOX_ADDRESSES (bcc));
	_tmp0_ = _g_object_ref0 (to);
	_g_object_unref0 (self->priv->_to);
	self->priv->_to = _tmp0_;
	_tmp1_ = _g_object_ref0 (cc);
	_g_object_unref0 (self->priv->_cc);
	self->priv->_cc = _tmp1_;
	_tmp2_ = _g_object_ref0 (bcc);
	_g_object_unref0 (self->priv->_bcc);
	self->priv->_bcc = _tmp2_;
	_g_object_unref0 (self->priv->message);
	self->priv->message = NULL;
	_tmp3_ = self->priv->_fields;
	geary_email_set_fields (self, _tmp3_ | GEARY_EMAIL_FIELD_RECEIVERS);
}

void
geary_email_set_full_references (GearyEmail* self,
                                 GearyRFC822MessageID* message_id,
                                 GearyRFC822MessageIDList* in_reply_to,
                                 GearyRFC822MessageIDList* references)
{
	GearyRFC822MessageID* _tmp0_;
	GearyRFC822MessageIDList* _tmp1_;
	GearyRFC822MessageIDList* _tmp2_;
	GearyEmailField _tmp3_;
	g_return_if_fail (GEARY_IS_EMAIL (self));
	g_return_if_fail ((message_id == NULL) || GEARY_RF_C822_IS_MESSAGE_ID (message_id));
	g_return_if_fail ((in_reply_to == NULL) || GEARY_RF_C822_IS_MESSAGE_ID_LIST (in_reply_to));
	g_return_if_fail ((references == NULL) || GEARY_RF_C822_IS_MESSAGE_ID_LIST (references));
	_tmp0_ = _g_object_ref0 (message_id);
	_g_object_unref0 (self->priv->_message_id);
	self->priv->_message_id = _tmp0_;
	_tmp1_ = _g_object_ref0 (in_reply_to);
	_g_object_unref0 (self->priv->_in_reply_to);
	self->priv->_in_reply_to = _tmp1_;
	_tmp2_ = _g_object_ref0 (references);
	_g_object_unref0 (self->priv->_references);
	self->priv->_references = _tmp2_;
	_g_object_unref0 (self->priv->message);
	self->priv->message = NULL;
	_tmp3_ = self->priv->_fields;
	geary_email_set_fields (self, _tmp3_ | GEARY_EMAIL_FIELD_REFERENCES);
}

void
geary_email_set_message_subject (GearyEmail* self,
                                 GearyRFC822Subject* subject)
{
	GearyRFC822Subject* _tmp0_;
	GearyEmailField _tmp1_;
	g_return_if_fail (GEARY_IS_EMAIL (self));
	g_return_if_fail ((subject == NULL) || GEARY_RF_C822_IS_SUBJECT (subject));
	_tmp0_ = _g_object_ref0 (subject);
	_g_object_unref0 (self->priv->_subject);
	self->priv->_subject = _tmp0_;
	_g_object_unref0 (self->priv->message);
	self->priv->message = NULL;
	_tmp1_ = self->priv->_fields;
	geary_email_set_fields (self, _tmp1_ | GEARY_EMAIL_FIELD_SUBJECT);
}

void
geary_email_set_message_header (GearyEmail* self,
                                GearyRFC822Header* header)
{
	GearyEmailField _tmp0_;
	g_return_if_fail (GEARY_IS_EMAIL (self));
	g_return_if_fail (GEARY_RF_C822_IS_HEADER (header));
	geary_email_set_header (self, header);
	_g_object_unref0 (self->priv->message);
	self->priv->message = NULL;
	_tmp0_ = self->priv->_fields;
	geary_email_set_fields (self, _tmp0_ | GEARY_EMAIL_FIELD_HEADER);
}

void
geary_email_set_message_body (GearyEmail* self,
                              GearyRFC822Text* body)
{
	GearyEmailField _tmp0_;
	g_return_if_fail (GEARY_IS_EMAIL (self));
	g_return_if_fail (GEARY_RF_C822_IS_TEXT (body));
	geary_email_set_body (self, body);
	_g_object_unref0 (self->priv->message);
	self->priv->message = NULL;
	_tmp0_ = self->priv->_fields;
	geary_email_set_fields (self, _tmp0_ | GEARY_EMAIL_FIELD_BODY);
}

void
geary_email_set_email_properties (GearyEmail* self,
                                  GearyEmailProperties* properties)
{
	GearyEmailField _tmp0_;
	g_return_if_fail (GEARY_IS_EMAIL (self));
	g_return_if_fail (GEARY_IS_EMAIL_PROPERTIES (properties));
	geary_email_set_properties (self, properties);
	_tmp0_ = self->priv->_fields;
	geary_email_set_fields (self, _tmp0_ | GEARY_EMAIL_FIELD_PROPERTIES);
}

void
geary_email_set_message_preview (GearyEmail* self,
                                 GearyRFC822PreviewText* preview)
{
	GearyEmailField _tmp0_;
	g_return_if_fail (GEARY_IS_EMAIL (self));
	g_return_if_fail (GEARY_RF_C822_IS_PREVIEW_TEXT (preview));
	geary_email_set_preview (self, preview);
	_tmp0_ = self->priv->_fields;
	geary_email_set_fields (self, _tmp0_ | GEARY_EMAIL_FIELD_PREVIEW);
}

void
geary_email_set_flags (GearyEmail* self,
                       GearyEmailFlags* email_flags)
{
	GearyEmailField _tmp0_;
	g_return_if_fail (GEARY_IS_EMAIL (self));
	g_return_if_fail (GEARY_IS_EMAIL_FLAGS (email_flags));
	geary_email_set_email_flags (self, email_flags);
	_tmp0_ = self->priv->_fields;
	geary_email_set_fields (self, _tmp0_ | GEARY_EMAIL_FIELD_FLAGS);
}

void
geary_email_add_attachment (GearyEmail* self,
                            GearyAttachment* attachment)
{
	GeeList* _tmp0_;
	g_return_if_fail (GEARY_IS_EMAIL (self));
	g_return_if_fail (GEARY_IS_ATTACHMENT (attachment));
	_tmp0_ = self->priv->_attachments;
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), attachment);
}

void
geary_email_add_attachments (GearyEmail* self,
                             GeeCollection* attachments)
{
	GeeList* _tmp0_;
	g_return_if_fail (GEARY_IS_EMAIL (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (attachments, GEE_TYPE_COLLECTION));
	_tmp0_ = self->priv->_attachments;
	gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), attachments);
}

gchar*
geary_email_get_searchable_attachment_list (GearyEmail* self)
{
	GString* search = NULL;
	GString* _tmp0_;
	GString* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* result;
	g_return_val_if_fail (GEARY_IS_EMAIL (self), NULL);
	_tmp0_ = g_string_new ("");
	search = _tmp0_;
	{
		GeeList* _attachment_list = NULL;
		GeeList* _tmp1_;
		gint _attachment_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _attachment_index = 0;
		_tmp1_ = self->priv->_attachments;
		_attachment_list = _tmp1_;
		_tmp2_ = _attachment_list;
		_tmp3_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp4_ = _tmp3_;
		_attachment_size = _tmp4_;
		_attachment_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			GearyAttachment* attachment = NULL;
			GeeList* _tmp7_;
			gpointer _tmp8_;
			GearyAttachment* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			_attachment_index = _attachment_index + 1;
			_tmp5_ = _attachment_index;
			_tmp6_ = _attachment_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _attachment_list;
			_tmp8_ = gee_list_get (_tmp7_, _attachment_index);
			attachment = (GearyAttachment*) _tmp8_;
			_tmp9_ = attachment;
			_tmp10_ = geary_attachment_get_has_content_filename (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_) {
				GString* _tmp12_;
				GearyAttachment* _tmp13_;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				GString* _tmp16_;
				_tmp12_ = search;
				_tmp13_ = attachment;
				_tmp14_ = geary_attachment_get_content_filename (_tmp13_);
				_tmp15_ = _tmp14_;
				g_string_append (_tmp12_, _tmp15_);
				_tmp16_ = search;
				g_string_append (_tmp16_, "\n");
			}
			_g_object_unref0 (attachment);
		}
	}
	_tmp17_ = search;
	_tmp18_ = _tmp17_->str;
	_tmp19_ = g_strdup (_tmp18_);
	result = _tmp19_;
	_g_string_free0 (search);
	return result;
}

/**
     * Constructs a new RFC 822 message from this email.
     *
     * This method requires the {@link REQUIRED_FOR_MESSAGE} fields be
     * present. If not, {@link EngineError.INCOMPLETE_MESSAGE} is
     * thrown.
     */
GearyRFC822Message*
geary_email_get_message (GearyEmail* self,
                         GError** error)
{
	GearyRFC822Message* _tmp0_;
	GearyRFC822Message* _tmp8_;
	GearyRFC822Message* _tmp9_;
	GError* _inner_error0_ = NULL;
	GearyRFC822Message* result;
	g_return_val_if_fail (GEARY_IS_EMAIL (self), NULL);
	_tmp0_ = self->priv->message;
	if (_tmp0_ == NULL) {
		GearyEmailField _tmp1_;
		GearyRFC822Message* _tmp3_ = NULL;
		GearyRFC822Header* _tmp4_;
		GearyRFC822Text* _tmp5_;
		GearyRFC822Message* _tmp6_;
		GearyRFC822Message* _tmp7_;
		_tmp1_ = self->priv->_fields;
		if (!geary_email_field_fulfills (_tmp1_, GEARY_EMAIL_REQUIRED_FOR_MESSAGE)) {
			GError* _tmp2_;
			_tmp2_ = g_error_new_literal (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_INCOMPLETE_MESSAGE, "Parsed email requires HEADER and BODY");
			_inner_error0_ = _tmp2_;
			g_propagate_error (error, _inner_error0_);
			return NULL;
		}
		_tmp4_ = self->priv->_header;
		_tmp5_ = self->priv->_body;
		_tmp6_ = geary_rf_c822_message_new_from_parts (_tmp4_, _tmp5_, &_inner_error0_);
		_tmp3_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		}
		_tmp7_ = _tmp3_;
		_tmp3_ = NULL;
		_g_object_unref0 (self->priv->message);
		self->priv->message = _tmp7_;
		_g_object_unref0 (_tmp3_);
	}
	_tmp8_ = self->priv->message;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	result = _tmp9_;
	return result;
}

/**
     * Returns the attachment with the given MIME Content ID.
     *
     * Requires the REQUIRED_FOR_MESSAGE fields be present; else
     * EngineError.INCOMPLETE_MESSAGE is thrown.
     */
GearyAttachment*
geary_email_get_attachment_by_content_id (GearyEmail* self,
                                          const gchar* cid,
                                          GError** error)
{
	GearyEmailField _tmp0_;
	GError* _inner_error0_ = NULL;
	GearyAttachment* result;
	g_return_val_if_fail (GEARY_IS_EMAIL (self), NULL);
	g_return_val_if_fail (cid != NULL, NULL);
	_tmp0_ = self->priv->_fields;
	if (!geary_email_field_fulfills (_tmp0_, GEARY_EMAIL_REQUIRED_FOR_MESSAGE)) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_INCOMPLETE_MESSAGE, "Parsed email requires HEADER and BODY");
		_inner_error0_ = _tmp1_;
		if (_inner_error0_->domain == GEARY_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	{
		GeeList* _attachment_list = NULL;
		GeeList* _tmp2_;
		gint _attachment_size = 0;
		GeeList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _attachment_index = 0;
		_tmp2_ = self->priv->_attachments;
		_attachment_list = _tmp2_;
		_tmp3_ = _attachment_list;
		_tmp4_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp5_ = _tmp4_;
		_attachment_size = _tmp5_;
		_attachment_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			GearyAttachment* attachment = NULL;
			GeeList* _tmp8_;
			gpointer _tmp9_;
			GearyAttachment* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			_attachment_index = _attachment_index + 1;
			_tmp6_ = _attachment_index;
			_tmp7_ = _attachment_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _attachment_list;
			_tmp9_ = gee_list_get (_tmp8_, _attachment_index);
			attachment = (GearyAttachment*) _tmp9_;
			_tmp10_ = attachment;
			_tmp11_ = geary_attachment_get_content_id (_tmp10_);
			_tmp12_ = _tmp11_;
			if (g_strcmp0 (_tmp12_, cid) == 0) {
				result = attachment;
				return result;
			}
			_g_object_unref0 (attachment);
		}
	}
	result = NULL;
	return result;
}

/**
     * Returns a list of this email's ancestry by Message-ID.  IDs are not returned in any
     * particular order.  The ancestry is made up from this email's Message-ID, its References,
     * and its In-Reply-To.  Thus, this email must have been fetched with Field.REFERENCES for
     * this method to return a complete list.
     */
GeeSet*
geary_email_get_ancestors (GearyEmail* self)
{
	GeeSet* ancestors = NULL;
	GeeHashSet* _tmp0_;
	GearyRFC822MessageID* _tmp1_;
	GearyRFC822MessageID* _tmp2_;
	GearyRFC822MessageIDList* _tmp6_;
	GearyRFC822MessageIDList* _tmp7_;
	GearyRFC822MessageIDList* _tmp13_;
	GearyRFC822MessageIDList* _tmp14_;
	GeeSet* _tmp20_ = NULL;
	GeeSet* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	GeeSet* _tmp25_;
	GeeSet* result;
	g_return_val_if_fail (GEARY_IS_EMAIL (self), NULL);
	_tmp0_ = gee_hash_set_new (GEARY_RF_C822_TYPE_MESSAGE_ID, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	ancestors = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_SET, GeeSet);
	_tmp1_ = geary_email_header_set_get_message_id (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		GeeSet* _tmp3_;
		GearyRFC822MessageID* _tmp4_;
		GearyRFC822MessageID* _tmp5_;
		_tmp3_ = ancestors;
		_tmp4_ = geary_email_header_set_get_message_id (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_tmp5_ = _tmp4_;
		gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection), _tmp5_);
	}
	_tmp6_ = geary_email_header_set_get_references (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		GeeSet* _tmp8_;
		GearyRFC822MessageIDList* _tmp9_;
		GearyRFC822MessageIDList* _tmp10_;
		GeeList* _tmp11_;
		GeeList* _tmp12_;
		_tmp8_ = ancestors;
		_tmp9_ = geary_email_header_set_get_references (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_tmp10_ = _tmp9_;
		_tmp11_ = geary_rf_c822_message_id_list_get_all (_tmp10_);
		_tmp12_ = _tmp11_;
		gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_COLLECTION, GeeCollection));
		_g_object_unref0 (_tmp12_);
	}
	_tmp13_ = geary_email_header_set_get_in_reply_to (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp14_ = _tmp13_;
	if (_tmp14_ != NULL) {
		GeeSet* _tmp15_;
		GearyRFC822MessageIDList* _tmp16_;
		GearyRFC822MessageIDList* _tmp17_;
		GeeList* _tmp18_;
		GeeList* _tmp19_;
		_tmp15_ = ancestors;
		_tmp16_ = geary_email_header_set_get_in_reply_to (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_tmp17_ = _tmp16_;
		_tmp18_ = geary_rf_c822_message_id_list_get_all (_tmp17_);
		_tmp19_ = _tmp18_;
		gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_COLLECTION, GeeCollection));
		_g_object_unref0 (_tmp19_);
	}
	_tmp21_ = ancestors;
	_tmp22_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp23_ = _tmp22_;
	if (_tmp23_ > 0) {
		GeeSet* _tmp24_;
		_tmp24_ = ancestors;
		_tmp20_ = _tmp24_;
	} else {
		_tmp20_ = NULL;
	}
	_tmp25_ = _g_object_ref0 (_tmp20_);
	result = _tmp25_;
	_g_object_unref0 (ancestors);
	return result;
}

gchar*
geary_email_get_preview_as_string (GearyEmail* self)
{
	gchar* _tmp0_ = NULL;
	GearyRFC822PreviewText* _tmp1_;
	gchar* result;
	g_return_val_if_fail (GEARY_IS_EMAIL (self), NULL);
	_tmp1_ = self->priv->_preview;
	if (_tmp1_ != NULL) {
		GearyRFC822PreviewText* _tmp2_;
		GearyMemoryBuffer* _tmp3_;
		GearyMemoryBuffer* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = self->priv->_preview;
		_tmp3_ = geary_message_data_block_message_data_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEARY_MESSAGE_DATA_TYPE_BLOCK_MESSAGE_DATA, GearyMessageDataBlockMessageData));
		_tmp4_ = _tmp3_;
		_tmp5_ = geary_memory_buffer_to_string (_tmp4_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
	} else {
		gchar* _tmp6_;
		_tmp6_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp6_;
	}
	result = _tmp0_;
	return result;
}

gchar*
geary_email_to_string (GearyEmail* self)
{
	GearyEmailIdentifier* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (GEARY_IS_EMAIL (self), NULL);
	_tmp0_ = self->priv->_id;
	_tmp1_ = geary_email_identifier_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("[%s] ", _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}

/**
     * Converts a Collection of {@link Email}s to a Map of Emails keyed by {@link EmailIdentifier}s.
     *
     * @return null if emails is empty or null.
     */
GeeMap*
geary_email_emails_to_map (GeeCollection* emails)
{
	gboolean _tmp0_ = FALSE;
	GeeMap* map = NULL;
	GeeHashMap* _tmp3_;
	GeeMap* result;
	g_return_val_if_fail ((emails == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (emails, GEE_TYPE_COLLECTION), NULL);
	if (emails == NULL) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = gee_collection_get_size (emails);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == 0;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp3_ = gee_hash_map_new (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GEARY_TYPE_EMAIL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	map = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_MAP, GeeMap);
	{
		GeeIterator* _email_it = NULL;
		GeeIterator* _tmp4_;
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (emails, GEE_TYPE_ITERABLE, GeeIterable));
		_email_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			GearyEmail* email = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			GeeMap* _tmp8_;
			GearyEmail* _tmp9_;
			GearyEmailIdentifier* _tmp10_;
			GearyEmail* _tmp11_;
			_tmp5_ = _email_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _email_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			email = (GearyEmail*) _tmp7_;
			_tmp8_ = map;
			_tmp9_ = email;
			_tmp10_ = _tmp9_->priv->_id;
			_tmp11_ = email;
			gee_map_set (_tmp8_, _tmp10_, _tmp11_);
			_g_object_unref0 (email);
		}
		_g_object_unref0 (_email_it);
	}
	result = map;
	return result;
}

/**
     * CompareFunc to sort {@link Email} by {@link date} ascending.
     *
     * If the date field is unavailable on either Email, their identifiers are compared to
     * stabilize the sort.
     */
gint
geary_email_compare_sent_date_ascending (GearyEmail* aemail,
                                         GearyEmail* bemail)
{
	gboolean _tmp0_ = FALSE;
	GearyRFC822Date* _tmp1_;
	GearyRFC822Date* _tmp2_;
	gint compare = 0;
	GearyRFC822Date* _tmp5_;
	GearyRFC822Date* _tmp6_;
	GDateTime* _tmp7_;
	GDateTime* _tmp8_;
	GearyRFC822Date* _tmp9_;
	GearyRFC822Date* _tmp10_;
	GDateTime* _tmp11_;
	GDateTime* _tmp12_;
	gint _tmp13_ = 0;
	gint result;
	g_return_val_if_fail (GEARY_IS_EMAIL (aemail), 0);
	g_return_val_if_fail (GEARY_IS_EMAIL (bemail), 0);
	_tmp1_ = geary_email_header_set_get_date (G_TYPE_CHECK_INSTANCE_CAST (aemail, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GearyRFC822Date* _tmp3_;
		GearyRFC822Date* _tmp4_;
		_tmp3_ = geary_email_header_set_get_date (G_TYPE_CHECK_INSTANCE_CAST (bemail, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == NULL;
	}
	if (_tmp0_) {
		g_message ("geary-email.vala:610: Warning: comparing email for sent date but no Da" \
"te: field loaded");
		result = geary_email_compare_id_ascending (aemail, bemail);
		return result;
	}
	_tmp5_ = geary_email_header_set_get_date (G_TYPE_CHECK_INSTANCE_CAST (aemail, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp6_ = _tmp5_;
	_tmp7_ = geary_rf_c822_date_get_value (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = geary_email_header_set_get_date (G_TYPE_CHECK_INSTANCE_CAST (bemail, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp10_ = _tmp9_;
	_tmp11_ = geary_rf_c822_date_get_value (_tmp10_);
	_tmp12_ = _tmp11_;
	compare = g_date_time_compare (_tmp8_, _tmp12_);
	if (compare != 0) {
		_tmp13_ = compare;
	} else {
		_tmp13_ = geary_email_compare_id_ascending (aemail, bemail);
	}
	result = _tmp13_;
	return result;
}

/**
     * CompareFunc to sort {@link Email} by {@link date} descending.
     *
     * If the date field is unavailable on either Email, their identifiers are compared to
     * stabilize the sort.
     */
gint
geary_email_compare_sent_date_descending (GearyEmail* aemail,
                                          GearyEmail* bemail)
{
	gint result;
	g_return_val_if_fail (GEARY_IS_EMAIL (aemail), 0);
	g_return_val_if_fail (GEARY_IS_EMAIL (bemail), 0);
	result = geary_email_compare_sent_date_ascending (bemail, aemail);
	return result;
}

/**
     * CompareFunc to sort {@link Email} by {@link EmailProperties.date_received} ascending.
     *
     * If {@link properties} is unavailable on either Email, their identifiers are compared to
     * stabilize the sort.
     */
gint
geary_email_compare_recv_date_ascending (GearyEmail* aemail,
                                         GearyEmail* bemail)
{
	gboolean _tmp0_ = FALSE;
	GearyEmailProperties* _tmp1_;
	gint compare = 0;
	GearyEmailProperties* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	GearyEmailProperties* _tmp6_;
	GDateTime* _tmp7_;
	GDateTime* _tmp8_;
	gint _tmp9_ = 0;
	gint result;
	g_return_val_if_fail (GEARY_IS_EMAIL (aemail), 0);
	g_return_val_if_fail (GEARY_IS_EMAIL (bemail), 0);
	_tmp1_ = aemail->priv->_properties;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GearyEmailProperties* _tmp2_;
		_tmp2_ = bemail->priv->_properties;
		_tmp0_ = _tmp2_ == NULL;
	}
	if (_tmp0_) {
		g_message ("geary-email.vala:639: Warning: comparing email for received date but e" \
"mail properties not loaded");
		result = geary_email_compare_id_ascending (aemail, bemail);
		return result;
	}
	_tmp3_ = aemail->priv->_properties;
	_tmp4_ = geary_email_properties_get_date_received (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = bemail->priv->_properties;
	_tmp7_ = geary_email_properties_get_date_received (_tmp6_);
	_tmp8_ = _tmp7_;
	compare = g_date_time_compare (_tmp5_, _tmp8_);
	if (compare != 0) {
		_tmp9_ = compare;
	} else {
		_tmp9_ = geary_email_compare_id_ascending (aemail, bemail);
	}
	result = _tmp9_;
	return result;
}

/**
     * CompareFunc to sort {@link Email} by {@link EmailProperties.date_received} descending.
     *
     * If {@link properties} is unavailable on either Email, their identifiers are compared to
     * stabilize the sort.
     */
gint
geary_email_compare_recv_date_descending (GearyEmail* aemail,
                                          GearyEmail* bemail)
{
	gint result;
	g_return_val_if_fail (GEARY_IS_EMAIL (aemail), 0);
	g_return_val_if_fail (GEARY_IS_EMAIL (bemail), 0);
	result = geary_email_compare_recv_date_ascending (bemail, aemail);
	return result;
}

static gint
geary_email_compare_id_ascending (GearyEmail* aemail,
                                  GearyEmail* bemail)
{
	GearyEmailIdentifier* _tmp0_;
	GearyEmailIdentifier* _tmp1_;
	gint result;
	g_return_val_if_fail (GEARY_IS_EMAIL (aemail), 0);
	g_return_val_if_fail (GEARY_IS_EMAIL (bemail), 0);
	_tmp0_ = aemail->priv->_id;
	_tmp1_ = bemail->priv->_id;
	result = geary_email_identifier_stable_sort_comparator (_tmp0_, _tmp1_);
	return result;
}

/**
     * CompareFunc to sort Email by EmailProperties.total_bytes.  If not available, emails are
     * compared by EmailIdentifier.
     */
gint
geary_email_compare_size_ascending (GearyEmail* aemail,
                                    GearyEmail* bemail)
{
	GearyEmailProperties* aprop = NULL;
	GearyEmailProperties* _tmp0_;
	GearyEmailProperties* _tmp1_;
	GearyEmailProperties* bprop = NULL;
	GearyEmailProperties* _tmp2_;
	GearyEmailProperties* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GearyEmailProperties* _tmp5_;
	gint cmp = 0;
	GearyEmailProperties* _tmp7_;
	gint64 _tmp8_;
	gint64 _tmp9_;
	GearyEmailProperties* _tmp10_;
	gint64 _tmp11_;
	gint64 _tmp12_;
	gint _tmp13_ = 0;
	gint result;
	g_return_val_if_fail (GEARY_IS_EMAIL (aemail), 0);
	g_return_val_if_fail (GEARY_IS_EMAIL (bemail), 0);
	_tmp0_ = aemail->priv->_properties;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_TYPE_EMAIL_PROPERTIES, GearyEmailProperties));
	aprop = _tmp1_;
	_tmp2_ = bemail->priv->_properties;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEARY_TYPE_EMAIL_PROPERTIES, GearyEmailProperties));
	bprop = _tmp3_;
	_tmp5_ = aprop;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		GearyEmailProperties* _tmp6_;
		_tmp6_ = bprop;
		_tmp4_ = _tmp6_ == NULL;
	}
	if (_tmp4_) {
		g_message ("geary-email.vala:674: Warning: comparing email by size but email prope" \
"rties not loaded");
		result = geary_email_compare_id_ascending (aemail, bemail);
		_g_object_unref0 (bprop);
		_g_object_unref0 (aprop);
		return result;
	}
	_tmp7_ = aprop;
	_tmp8_ = geary_email_properties_get_total_bytes (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = bprop;
	_tmp11_ = geary_email_properties_get_total_bytes (_tmp10_);
	_tmp12_ = _tmp11_;
	cmp = (gint) CLAMP (_tmp9_ - _tmp12_, (gint64) -1, (gint64) 1);
	if (cmp != 0) {
		_tmp13_ = cmp;
	} else {
		_tmp13_ = geary_email_compare_id_ascending (aemail, bemail);
	}
	result = _tmp13_;
	_g_object_unref0 (bprop);
	_g_object_unref0 (aprop);
	return result;
}

/**
     * CompareFunc to sort Email by EmailProperties.total_bytes.  If not available, emails are
     * compared by EmailIdentifier.
     */
gint
geary_email_compare_size_descending (GearyEmail* aemail,
                                     GearyEmail* bemail)
{
	gint result;
	g_return_val_if_fail (GEARY_IS_EMAIL (aemail), 0);
	g_return_val_if_fail (GEARY_IS_EMAIL (bemail), 0);
	result = geary_email_compare_size_ascending (bemail, aemail);
	return result;
}

static void
geary_email_class_init (GearyEmailClass * klass,
                        gpointer klass_data)
{
	geary_email_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyEmail_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_email_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_email_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_email_finalize;
	/**
	     * A unique identifier for the Email in the Folder.
	     *
	     * This is is guaranteed to be unique for as long as the Folder is
	     * open. Once closed, guarantees are no longer made.
	     *
	     * This field is always returned, no matter what Fields are used
	     * to retrieve the Email.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_EMAIL_ID_PROPERTY, geary_email_properties[GEARY_EMAIL_ID_PROPERTY] = g_param_spec_object ("id", "id", "id", GEARY_TYPE_EMAIL_IDENTIFIER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * {@inheritDoc}
	     *
	     * Value will be valid if {@link Field.ORIGINATORS} is set.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_EMAIL_FROM_PROPERTY, geary_email_properties[GEARY_EMAIL_FROM_PROPERTY] = g_param_spec_object ("from", "from", "from", GEARY_RF_C822_TYPE_MAILBOX_ADDRESSES, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * {@inheritDoc}
	     *
	     * Value will be valid if {@link Field.ORIGINATORS} is set.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_EMAIL_SENDER_PROPERTY, geary_email_properties[GEARY_EMAIL_SENDER_PROPERTY] = g_param_spec_object ("sender", "sender", "sender", GEARY_RF_C822_TYPE_MAILBOX_ADDRESS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * {@inheritDoc}
	     *
	     * Value will be valid if {@link Field.ORIGINATORS} is set.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_EMAIL_REPLY_TO_PROPERTY, geary_email_properties[GEARY_EMAIL_REPLY_TO_PROPERTY] = g_param_spec_object ("reply-to", "reply-to", "reply-to", GEARY_RF_C822_TYPE_MAILBOX_ADDRESSES, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * {@inheritDoc}
	     *
	     * Value will be valid if {@link Field.RECEIVERS} is set.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_EMAIL_TO_PROPERTY, geary_email_properties[GEARY_EMAIL_TO_PROPERTY] = g_param_spec_object ("to", "to", "to", GEARY_RF_C822_TYPE_MAILBOX_ADDRESSES, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * {@inheritDoc}
	     *
	     * Value will be valid if {@link Field.RECEIVERS} is set.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_EMAIL_CC_PROPERTY, geary_email_properties[GEARY_EMAIL_CC_PROPERTY] = g_param_spec_object ("cc", "cc", "cc", GEARY_RF_C822_TYPE_MAILBOX_ADDRESSES, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * {@inheritDoc}
	     *
	     * Value will be valid if {@link Field.RECEIVERS} is set.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_EMAIL_BCC_PROPERTY, geary_email_properties[GEARY_EMAIL_BCC_PROPERTY] = g_param_spec_object ("bcc", "bcc", "bcc", GEARY_RF_C822_TYPE_MAILBOX_ADDRESSES, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * {@inheritDoc}
	     *
	     * Value will be valid if {@link Field.REFERENCES} is set.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_EMAIL_MESSAGE_ID_PROPERTY, geary_email_properties[GEARY_EMAIL_MESSAGE_ID_PROPERTY] = g_param_spec_object ("message-id", "message-id", "message-id", GEARY_RF_C822_TYPE_MESSAGE_ID, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * {@inheritDoc}
	     *
	     * Value will be valid if {@link Field.REFERENCES} is set.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_EMAIL_IN_REPLY_TO_PROPERTY, geary_email_properties[GEARY_EMAIL_IN_REPLY_TO_PROPERTY] = g_param_spec_object ("in-reply-to", "in-reply-to", "in-reply-to", GEARY_RF_C822_TYPE_MESSAGE_ID_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * {@inheritDoc}
	     *
	     * Value will be valid if {@link Field.REFERENCES} is set.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_EMAIL_REFERENCES_PROPERTY, geary_email_properties[GEARY_EMAIL_REFERENCES_PROPERTY] = g_param_spec_object ("references", "references", "references", GEARY_RF_C822_TYPE_MESSAGE_ID_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * {@inheritDoc}
	     *
	     * Value will be valid if {@link Field.SUBJECT} is set.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_EMAIL_SUBJECT_PROPERTY, geary_email_properties[GEARY_EMAIL_SUBJECT_PROPERTY] = g_param_spec_object ("subject", "subject", "subject", GEARY_RF_C822_TYPE_SUBJECT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * {@inheritDoc}
	     *
	     * Value will be valid if {@link Field.DATE} is set.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_EMAIL_DATE_PROPERTY, geary_email_properties[GEARY_EMAIL_DATE_PROPERTY] = g_param_spec_object ("date", "date", "date", GEARY_RF_C822_TYPE_DATE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * {@inheritDoc}
	     *
	     * Value will be valid if {@link Field.HEADER} is set.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_EMAIL_HEADER_PROPERTY, geary_email_properties[GEARY_EMAIL_HEADER_PROPERTY] = g_param_spec_object ("header", "header", "header", GEARY_RF_C822_TYPE_HEADER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The complete RFC 822 message body.
	     *
	     * Value will be valid if {@link Field.BODY} is set.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_EMAIL_BODY_PROPERTY, geary_email_properties[GEARY_EMAIL_BODY_PROPERTY] = g_param_spec_object ("body", "body", "body", GEARY_RF_C822_TYPE_TEXT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * MIME multipart body parts.
	     *
	     * Value will be valid if {@link Field.BODY} is set.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_EMAIL_ATTACHMENTS_PROPERTY, geary_email_properties[GEARY_EMAIL_ATTACHMENTS_PROPERTY] = g_param_spec_object ("attachments", "attachments", "attachments", GEE_TYPE_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * A plain text prefix of the email's message body.
	     *
	     * Value will be valid if {@link Field.PREVIEW} is set.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_EMAIL_PREVIEW_PROPERTY, geary_email_properties[GEARY_EMAIL_PREVIEW_PROPERTY] = g_param_spec_object ("preview", "preview", "preview", GEARY_RF_C822_TYPE_PREVIEW_TEXT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Set of immutable properties for the email.
	     *
	     * Value will be valid if {@link Field.PROPERTIES} is set.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_EMAIL_PROPERTIES_PROPERTY, geary_email_properties[GEARY_EMAIL_PROPERTIES_PROPERTY] = g_param_spec_object ("properties", "properties", "properties", GEARY_TYPE_EMAIL_PROPERTIES, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Set of mutable flags for the email.
	     *
	     * Value will be valid if {@link Field.FLAGS} is set.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_EMAIL_EMAIL_FLAGS_PROPERTY, geary_email_properties[GEARY_EMAIL_EMAIL_FLAGS_PROPERTY] = g_param_spec_object ("email-flags", "email-flags", "email-flags", GEARY_TYPE_EMAIL_FLAGS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Specifies the properties that have been populated for this email.
	     *
	     * Since this email object may be a partial representation of a
	     * complete email message, this property lists all parts of the
	     * object that have actually been loaded, as opposed to parts that
	     * are simply missing from the email it represents.
	     *
	     * For example, if this property includes the {@link
	     * Field.SUBJECT} flag, then the {@link subject} property has been
	     * set to reflect the Subject header of the message. Of course,
	     * the subject may then still may be null or empty, if the email
	     * did not specify a subject header.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_EMAIL_FIELDS_PROPERTY, geary_email_properties[GEARY_EMAIL_FIELDS_PROPERTY] = g_param_spec_enum ("fields", "fields", "fields", GEARY_EMAIL_TYPE_FIELD, GEARY_EMAIL_FIELD_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_email_geary_email_header_set_interface_init (GearyEmailHeaderSetIface * iface,
                                                   gpointer iface_data)
{
	geary_email_geary_email_header_set_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_from = geary_email_real_get_from;
	iface->get_sender = geary_email_real_get_sender;
	iface->get_reply_to = geary_email_real_get_reply_to;
	iface->get_to = geary_email_real_get_to;
	iface->get_cc = geary_email_real_get_cc;
	iface->get_bcc = geary_email_real_get_bcc;
	iface->get_message_id = geary_email_real_get_message_id;
	iface->get_in_reply_to = geary_email_real_get_in_reply_to;
	iface->get_references = geary_email_real_get_references;
	iface->get_subject = geary_email_real_get_subject;
	iface->get_date = geary_email_real_get_date;
}

static void
geary_email_instance_init (GearyEmail * self,
                           gpointer klass)
{
	GeeArrayList* _tmp0_;
	self->priv = geary_email_get_instance_private (self);
	self->priv->_from = NULL;
	self->priv->_sender = NULL;
	self->priv->_reply_to = NULL;
	self->priv->_to = NULL;
	self->priv->_cc = NULL;
	self->priv->_bcc = NULL;
	self->priv->_message_id = NULL;
	self->priv->_in_reply_to = NULL;
	self->priv->_references = NULL;
	self->priv->_subject = NULL;
	self->priv->_date = NULL;
	self->priv->_header = NULL;
	self->priv->_body = NULL;
	_tmp0_ = gee_array_list_new (GEARY_TYPE_ATTACHMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->_attachments = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
	self->priv->_preview = NULL;
	self->priv->_properties = NULL;
	self->priv->_email_flags = NULL;
	self->priv->_fields = GEARY_EMAIL_FIELD_NONE;
	self->priv->message = NULL;
}

static void
geary_email_finalize (GObject * obj)
{
	GearyEmail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_TYPE_EMAIL, GearyEmail);
	_g_object_unref0 (self->priv->_id);
	_g_object_unref0 (self->priv->_from);
	_g_object_unref0 (self->priv->_sender);
	_g_object_unref0 (self->priv->_reply_to);
	_g_object_unref0 (self->priv->_to);
	_g_object_unref0 (self->priv->_cc);
	_g_object_unref0 (self->priv->_bcc);
	_g_object_unref0 (self->priv->_message_id);
	_g_object_unref0 (self->priv->_in_reply_to);
	_g_object_unref0 (self->priv->_references);
	_g_object_unref0 (self->priv->_subject);
	_g_object_unref0 (self->priv->_date);
	_g_object_unref0 (self->priv->_header);
	_g_object_unref0 (self->priv->_body);
	_g_object_unref0 (self->priv->_attachments);
	_g_object_unref0 (self->priv->_preview);
	_g_object_unref0 (self->priv->_properties);
	_g_object_unref0 (self->priv->_email_flags);
	_g_object_unref0 (self->priv->message);
	G_OBJECT_CLASS (geary_email_parent_class)->finalize (obj);
}

/**
 * An Email represents a single RFC 822 style email message.
 *
 * This class provides a common abstraction over different
 * representations of email messages, allowing messages from different
 * mail systems, from both local and remote sources, and locally
 * composed email messages to all be represented by a single
 * object. While this object represents a RFC 822 message, it also
 * holds additional metadata about an email not specified by that
 * format, such as its unique {@link id}, and unread state and other
 * {@link email_flags}.
 *
 * Email objects may by constructed in many ways, but are usually
 * obtained via a {@link Folder}. Email objects may be partial
 * representations of messages, in cases where a remote message has
 * not been fully downloaded, or a local message not fully loaded from
 * a database. This can be checked via an email's {@link fields}
 * property, and if the currently loaded fields are not sufficient,
 * then additional fields can be loaded via a folder.
 */
 G_GNUC_NO_INLINE static GType
geary_email_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyEmailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_email_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyEmail), 0, (GInstanceInitFunc) geary_email_instance_init, NULL };
	static const GInterfaceInfo geary_email_header_set_info = { (GInterfaceInitFunc) geary_email_geary_email_header_set_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_email_type_id;
	geary_email_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyEmail", &g_define_type_info, 0);
	g_type_add_interface_static (geary_email_type_id, GEARY_TYPE_EMAIL_HEADER_SET, &geary_email_header_set_info);
	GearyEmail_private_offset = g_type_add_instance_private (geary_email_type_id, sizeof (GearyEmailPrivate));
	return geary_email_type_id;
}

GType
geary_email_get_type (void)
{
	static gsize geary_email_type_id__once = 0;
	if (g_once_init_enter (&geary_email_type_id__once)) {
		GType geary_email_type_id;
		geary_email_type_id = geary_email_get_type_once ();
		g_once_init_leave (&geary_email_type_id__once, geary_email_type_id);
	}
	return geary_email_type_id__once;
}

static void
_vala_geary_email_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	GearyEmail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_EMAIL, GearyEmail);
	switch (property_id) {
		case GEARY_EMAIL_ID_PROPERTY:
		g_value_set_object (value, geary_email_get_id (self));
		break;
		case GEARY_EMAIL_FROM_PROPERTY:
		g_value_set_object (value, geary_email_header_set_get_from (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet)));
		break;
		case GEARY_EMAIL_SENDER_PROPERTY:
		g_value_set_object (value, geary_email_header_set_get_sender (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet)));
		break;
		case GEARY_EMAIL_REPLY_TO_PROPERTY:
		g_value_set_object (value, geary_email_header_set_get_reply_to (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet)));
		break;
		case GEARY_EMAIL_TO_PROPERTY:
		g_value_set_object (value, geary_email_header_set_get_to (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet)));
		break;
		case GEARY_EMAIL_CC_PROPERTY:
		g_value_set_object (value, geary_email_header_set_get_cc (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet)));
		break;
		case GEARY_EMAIL_BCC_PROPERTY:
		g_value_set_object (value, geary_email_header_set_get_bcc (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet)));
		break;
		case GEARY_EMAIL_MESSAGE_ID_PROPERTY:
		g_value_set_object (value, geary_email_header_set_get_message_id (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet)));
		break;
		case GEARY_EMAIL_IN_REPLY_TO_PROPERTY:
		g_value_set_object (value, geary_email_header_set_get_in_reply_to (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet)));
		break;
		case GEARY_EMAIL_REFERENCES_PROPERTY:
		g_value_set_object (value, geary_email_header_set_get_references (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet)));
		break;
		case GEARY_EMAIL_SUBJECT_PROPERTY:
		g_value_set_object (value, geary_email_header_set_get_subject (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet)));
		break;
		case GEARY_EMAIL_DATE_PROPERTY:
		g_value_set_object (value, geary_email_header_set_get_date (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet)));
		break;
		case GEARY_EMAIL_HEADER_PROPERTY:
		g_value_set_object (value, geary_email_get_header (self));
		break;
		case GEARY_EMAIL_BODY_PROPERTY:
		g_value_set_object (value, geary_email_get_body (self));
		break;
		case GEARY_EMAIL_ATTACHMENTS_PROPERTY:
		g_value_set_object (value, geary_email_get_attachments (self));
		break;
		case GEARY_EMAIL_PREVIEW_PROPERTY:
		g_value_set_object (value, geary_email_get_preview (self));
		break;
		case GEARY_EMAIL_PROPERTIES_PROPERTY:
		g_value_set_object (value, geary_email_get_properties (self));
		break;
		case GEARY_EMAIL_EMAIL_FLAGS_PROPERTY:
		g_value_set_object (value, geary_email_get_email_flags (self));
		break;
		case GEARY_EMAIL_FIELDS_PROPERTY:
		g_value_set_enum (value, geary_email_get_fields (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_email_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	GearyEmail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_EMAIL, GearyEmail);
	switch (property_id) {
		case GEARY_EMAIL_ID_PROPERTY:
		geary_email_set_id (self, g_value_get_object (value));
		break;
		case GEARY_EMAIL_HEADER_PROPERTY:
		geary_email_set_header (self, g_value_get_object (value));
		break;
		case GEARY_EMAIL_BODY_PROPERTY:
		geary_email_set_body (self, g_value_get_object (value));
		break;
		case GEARY_EMAIL_ATTACHMENTS_PROPERTY:
		geary_email_set_attachments (self, g_value_get_object (value));
		break;
		case GEARY_EMAIL_PREVIEW_PROPERTY:
		geary_email_set_preview (self, g_value_get_object (value));
		break;
		case GEARY_EMAIL_PROPERTIES_PROPERTY:
		geary_email_set_properties (self, g_value_get_object (value));
		break;
		case GEARY_EMAIL_EMAIL_FLAGS_PROPERTY:
		geary_email_set_email_flags (self, g_value_get_object (value));
		break;
		case GEARY_EMAIL_FIELDS_PROPERTY:
		geary_email_set_fields (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

