/* unity-launcher-entry.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from unity-launcher-entry.vala, do not modify */

/*
 * Copyright 2019 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "notification-badge.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "geary-engine.h"
#include <glib-object.h>
#include <gio/gio.h>

#define UNITY_LAUNCHER_ENTRY_DBUS_NAME "com.canonical.Unity.LauncherEntry"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define UNITY_LAUNCHER_ENTRY_TYPE_ENTRY (unity_launcher_entry_entry_get_type ())
#define UNITY_LAUNCHER_ENTRY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_ENTRY_TYPE_ENTRY, UnityLauncherEntryEntry))
#define UNITY_LAUNCHER_ENTRY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_ENTRY_TYPE_ENTRY, UnityLauncherEntryEntryClass))
#define UNITY_LAUNCHER_ENTRY_IS_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_ENTRY_TYPE_ENTRY))
#define UNITY_LAUNCHER_ENTRY_IS_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_ENTRY_TYPE_ENTRY))
#define UNITY_LAUNCHER_ENTRY_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_ENTRY_TYPE_ENTRY, UnityLauncherEntryEntryClass))

typedef struct _UnityLauncherEntryEntry UnityLauncherEntryEntry;
typedef struct _UnityLauncherEntryEntryClass UnityLauncherEntryEntryClass;
enum  {
	UNITY_LAUNCHER_ENTRY_0_PROPERTY,
	UNITY_LAUNCHER_ENTRY_NUM_PROPERTIES
};
static GParamSpec* unity_launcher_entry_properties[UNITY_LAUNCHER_ENTRY_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _UnityLauncherEntryEntryPrivate UnityLauncherEntryEntryPrivate;
enum  {
	UNITY_LAUNCHER_ENTRY_ENTRY_0_PROPERTY,
	UNITY_LAUNCHER_ENTRY_ENTRY_NUM_PROPERTIES
};
static GParamSpec* unity_launcher_entry_entry_properties[UNITY_LAUNCHER_ENTRY_ENTRY_NUM_PROPERTIES];
enum  {
	UNITY_LAUNCHER_ENTRY_ENTRY_UPDATE_SIGNAL,
	UNITY_LAUNCHER_ENTRY_ENTRY_NUM_SIGNALS
};
static guint unity_launcher_entry_entry_signals[UNITY_LAUNCHER_ENTRY_ENTRY_NUM_SIGNALS] = {0};

struct _UnityLauncherEntryPrivate {
	gchar* app_uri;
	UnityLauncherEntryEntry* entry;
	GDBusConnection* connection;
	guint object_id;
	guint watch_id;
	gint64 count;
	gboolean count_visible;
};

struct _UnityLauncherEntryEntry {
	GearyBaseObject parent_instance;
	UnityLauncherEntryEntryPrivate * priv;
};

struct _UnityLauncherEntryEntryClass {
	GearyBaseObjectClass parent_class;
};

static gint UnityLauncherEntry_private_offset;
static gpointer unity_launcher_entry_parent_class = NULL;
static gpointer unity_launcher_entry_entry_parent_class = NULL;
static GType unity_launcher_entry_entry_type_id = 0;
static GType unity_launcher_entry_type_id = 0;

GType unity_launcher_entry_entry_register_type (GTypeModule * module);
VALA_EXTERN GType unity_launcher_entry_entry_get_type (void) G_GNUC_CONST ;
static guint unity_launcher_entry_entry_register_object (void* object,
                                                  GDBusConnection* connection,
                                                  const gchar* path,
                                                  GError** error);
static UnityLauncherEntryEntry* unity_launcher_entry_entry_new (void);
static UnityLauncherEntryEntry* unity_launcher_entry_entry_construct (GType object_type);
static void unity_launcher_entry_on_name_appeared (UnityLauncherEntry* self);
static void _unity_launcher_entry_on_name_appeared_gbus_name_appeared_callback (GDBusConnection* connection,
                                                                         const gchar* name,
                                                                         const gchar* name_owner,
                                                                         gpointer self);
static void unity_launcher_entry_update_all (UnityLauncherEntry* self);
static GHashTable* unity_launcher_entry_new_properties (UnityLauncherEntry* self);
static void unity_launcher_entry_put_count (UnityLauncherEntry* self,
                                     GHashTable* properties);
static void unity_launcher_entry_put_count_visible (UnityLauncherEntry* self,
                                             GHashTable* properties);
static void unity_launcher_entry_send (UnityLauncherEntry* self,
                                GHashTable* properties);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
static void g_cclosure_user_marshal_VOID__STRING_BOXED (GClosure * closure,
                                                 GValue * return_value,
                                                 guint n_param_values,
                                                 const GValue * param_values,
                                                 gpointer invocation_hint,
                                                 gpointer marshal_data);
static void unity_launcher_entry_entry_dbus_interface_method_call (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* method_name,
                                                            GVariant* parameters,
                                                            GDBusMethodInvocation* invocation,
                                                            gpointer user_data);
static GVariant* unity_launcher_entry_entry_dbus_interface_get_property (GDBusConnection* connection,
                                                                  const gchar* sender,
                                                                  const gchar* object_path,
                                                                  const gchar* interface_name,
                                                                  const gchar* property_name,
                                                                  GError** error,
                                                                  gpointer user_data);
static gboolean unity_launcher_entry_entry_dbus_interface_set_property (GDBusConnection* connection,
                                                                 const gchar* sender,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* property_name,
                                                                 GVariant* value,
                                                                 GError** error,
                                                                 gpointer user_data);
static void _dbus_unity_launcher_entry_entry_update (GObject* _sender,
                                              const gchar* app_uri,
                                              GHashTable* properties,
                                              gpointer* _data);
static void _unity_launcher_entry_entry_unregister_object (gpointer user_data);
static void unity_launcher_entry_finalize (GObject * obj);

static const GDBusMethodInfo * const _unity_launcher_entry_entry_dbus_method_info[] = {NULL};
static const GDBusArgInfo _unity_launcher_entry_entry_dbus_arg_info_update_app_uri = {-1, "app_uri", "s", NULL};
static const GDBusArgInfo _unity_launcher_entry_entry_dbus_arg_info_update_properties = {-1, "properties", "a{sv}", NULL};
static const GDBusArgInfo * const _unity_launcher_entry_entry_dbus_arg_info_update[] = {&_unity_launcher_entry_entry_dbus_arg_info_update_app_uri, &_unity_launcher_entry_entry_dbus_arg_info_update_properties, NULL};
static const GDBusSignalInfo _unity_launcher_entry_entry_dbus_signal_info_update = {-1, "Update", (GDBusArgInfo **) (&_unity_launcher_entry_entry_dbus_arg_info_update), NULL};
static const GDBusSignalInfo * const _unity_launcher_entry_entry_dbus_signal_info[] = {&_unity_launcher_entry_entry_dbus_signal_info_update, NULL};
static const GDBusPropertyInfo * const _unity_launcher_entry_entry_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _unity_launcher_entry_entry_dbus_interface_info = {-1, "com.canonical.Unity.LauncherEntry", (GDBusMethodInfo **) (&_unity_launcher_entry_entry_dbus_method_info), (GDBusSignalInfo **) (&_unity_launcher_entry_entry_dbus_signal_info), (GDBusPropertyInfo **) (&_unity_launcher_entry_entry_dbus_property_info), NULL};
static const GDBusInterfaceVTable _unity_launcher_entry_entry_dbus_interface_vtable = {unity_launcher_entry_entry_dbus_interface_method_call, unity_launcher_entry_entry_dbus_interface_get_property, unity_launcher_entry_entry_dbus_interface_set_property};

static inline gpointer
unity_launcher_entry_get_instance_private (UnityLauncherEntry* self)
{
	return G_STRUCT_MEMBER_P (self, UnityLauncherEntry_private_offset);
}

/**
     * Constructions a new launcher entry for the given DBus connection.
     *
     * The given path is used as the path of the DBus object that
     * interacts with the Uniti API, and should be bus-unique. The
     * given desktop identifier must match the name of the desktop
     * file for the application.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_unity_launcher_entry_on_name_appeared_gbus_name_appeared_callback (GDBusConnection* connection,
                                                                    const gchar* name,
                                                                    const gchar* name_owner,
                                                                    gpointer self)
{
	unity_launcher_entry_on_name_appeared ((UnityLauncherEntry*) self);
}

UnityLauncherEntry*
unity_launcher_entry_construct (GType object_type,
                                GDBusConnection* connection,
                                const gchar* dbus_path,
                                const gchar* desktop_id,
                                GError** error)
{
	UnityLauncherEntry * self = NULL;
	gchar* _tmp0_;
	GDBusConnection* _tmp1_;
	guint _tmp2_ = 0U;
	UnityLauncherEntryEntry* _tmp3_;
	guint _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (connection, g_dbus_connection_get_type ()), NULL);
	g_return_val_if_fail (dbus_path != NULL, NULL);
	g_return_val_if_fail (desktop_id != NULL, NULL);
	self = (UnityLauncherEntry*) geary_base_object_construct (object_type);
	_tmp0_ = g_strdup_printf ("application://%s", desktop_id);
	_g_free0 (self->priv->app_uri);
	self->priv->app_uri = _tmp0_;
	_tmp1_ = _g_object_ref0 (connection);
	_g_object_unref0 (self->priv->connection);
	self->priv->connection = _tmp1_;
	_tmp3_ = self->priv->entry;
	_tmp4_ = unity_launcher_entry_entry_register_object (_tmp3_, connection, dbus_path, &_inner_error0_);
	_tmp2_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	self->priv->object_id = _tmp2_;
	self->priv->watch_id = g_bus_watch_name_on_connection_with_closures (connection, UNITY_LAUNCHER_ENTRY_DBUS_NAME, G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((_unity_launcher_entry_on_name_appeared_gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _unity_launcher_entry_on_name_appeared_gbus_name_appeared_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	unity_launcher_entry_update_all (self);
	return self;
}

UnityLauncherEntry*
unity_launcher_entry_new (GDBusConnection* connection,
                          const gchar* dbus_path,
                          const gchar* desktop_id,
                          GError** error)
{
	return unity_launcher_entry_construct (TYPE_UNITY_LAUNCHER_ENTRY, connection, dbus_path, desktop_id, error);
}

/** Sets and shows the count for the application. */
void
unity_launcher_entry_set_count (UnityLauncherEntry* self,
                                gint64 count)
{
	GHashTable* props = NULL;
	GHashTable* _tmp0_;
	GHashTable* _tmp3_;
	g_return_if_fail (IS_UNITY_LAUNCHER_ENTRY (self));
	_tmp0_ = unity_launcher_entry_new_properties (self);
	props = _tmp0_;
	if (self->priv->count != count) {
		GHashTable* _tmp1_;
		self->priv->count = count;
		_tmp1_ = props;
		unity_launcher_entry_put_count (self, _tmp1_);
	}
	if (!self->priv->count_visible) {
		GHashTable* _tmp2_;
		self->priv->count_visible = TRUE;
		_tmp2_ = props;
		unity_launcher_entry_put_count_visible (self, _tmp2_);
	}
	_tmp3_ = props;
	unity_launcher_entry_send (self, _tmp3_);
	_g_hash_table_unref0 (props);
}

/** Clears and hides any count for the application. */
void
unity_launcher_entry_clear_count (UnityLauncherEntry* self)
{
	GHashTable* props = NULL;
	GHashTable* _tmp0_;
	GHashTable* _tmp3_;
	g_return_if_fail (IS_UNITY_LAUNCHER_ENTRY (self));
	_tmp0_ = unity_launcher_entry_new_properties (self);
	props = _tmp0_;
	if (self->priv->count != ((gint64) 0)) {
		GHashTable* _tmp1_;
		self->priv->count = (gint64) 0;
		_tmp1_ = props;
		unity_launcher_entry_put_count (self, _tmp1_);
	}
	if (self->priv->count_visible) {
		GHashTable* _tmp2_;
		self->priv->count_visible = FALSE;
		_tmp2_ = props;
		unity_launcher_entry_put_count_visible (self, _tmp2_);
	}
	_tmp3_ = props;
	unity_launcher_entry_send (self, _tmp3_);
	_g_hash_table_unref0 (props);
}

static void
unity_launcher_entry_update_all (UnityLauncherEntry* self)
{
	GHashTable* props = NULL;
	GHashTable* _tmp0_;
	GHashTable* _tmp3_;
	g_return_if_fail (IS_UNITY_LAUNCHER_ENTRY (self));
	_tmp0_ = unity_launcher_entry_new_properties (self);
	props = _tmp0_;
	if (self->priv->count != ((gint64) 0)) {
		GHashTable* _tmp1_;
		_tmp1_ = props;
		unity_launcher_entry_put_count (self, _tmp1_);
	}
	if (!self->priv->count_visible) {
		GHashTable* _tmp2_;
		_tmp2_ = props;
		unity_launcher_entry_put_count_visible (self, _tmp2_);
	}
	_tmp3_ = props;
	unity_launcher_entry_send (self, _tmp3_);
	_g_hash_table_unref0 (props);
}

static void
unity_launcher_entry_send (UnityLauncherEntry* self,
                           GHashTable* properties)
{
	g_return_if_fail (IS_UNITY_LAUNCHER_ENTRY (self));
	g_return_if_fail (properties != NULL);
	if (g_hash_table_size (properties) > ((guint) 0)) {
		UnityLauncherEntryEntry* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = self->priv->entry;
		_tmp1_ = self->priv->app_uri;
		g_signal_emit (_tmp0_, unity_launcher_entry_entry_signals[UNITY_LAUNCHER_ENTRY_ENTRY_UPDATE_SIGNAL], 0, _tmp1_, properties);
	}
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_variant_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}

static GHashTable*
unity_launcher_entry_new_properties (UnityLauncherEntry* self)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* result;
	g_return_val_if_fail (IS_UNITY_LAUNCHER_ENTRY (self), NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_variant_unref0_);
	result = _tmp2_;
	return result;
}

static void
unity_launcher_entry_put_count (UnityLauncherEntry* self,
                                GHashTable* properties)
{
	gchar* _tmp0_;
	GVariant* _tmp1_;
	g_return_if_fail (IS_UNITY_LAUNCHER_ENTRY (self));
	g_return_if_fail (properties != NULL);
	_tmp0_ = g_strdup ("count");
	_tmp1_ = g_variant_new_int64 (self->priv->count);
	g_variant_ref_sink (_tmp1_);
	g_hash_table_insert (properties, _tmp0_, _tmp1_);
}

static void
unity_launcher_entry_put_count_visible (UnityLauncherEntry* self,
                                        GHashTable* properties)
{
	gchar* _tmp0_;
	GVariant* _tmp1_;
	g_return_if_fail (IS_UNITY_LAUNCHER_ENTRY (self));
	g_return_if_fail (properties != NULL);
	_tmp0_ = g_strdup ("count-visible");
	_tmp1_ = g_variant_new_boolean (self->priv->count_visible);
	g_variant_ref_sink (_tmp1_);
	g_hash_table_insert (properties, _tmp0_, _tmp1_);
}

static void
unity_launcher_entry_on_name_appeared (UnityLauncherEntry* self)
{
	g_return_if_fail (IS_UNITY_LAUNCHER_ENTRY (self));
	unity_launcher_entry_update_all (self);
}

static void
g_cclosure_user_marshal_VOID__STRING_BOXED (GClosure * closure,
                                            GValue * return_value,
                                            guint n_param_values,
                                            const GValue * param_values,
                                            gpointer invocation_hint,
                                            gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_BOXED) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_boxed (param_values + 2), data2);
}

static UnityLauncherEntryEntry*
unity_launcher_entry_entry_construct (GType object_type)
{
	UnityLauncherEntryEntry * self = NULL;
	self = (UnityLauncherEntryEntry*) geary_base_object_construct (object_type);
	return self;
}

static UnityLauncherEntryEntry*
unity_launcher_entry_entry_new (void)
{
	return unity_launcher_entry_entry_construct (UNITY_LAUNCHER_ENTRY_TYPE_ENTRY);
}

static void
unity_launcher_entry_entry_class_init (UnityLauncherEntryEntryClass * klass,
                                       gpointer klass_data)
{
	unity_launcher_entry_entry_parent_class = g_type_class_peek_parent (klass);
	unity_launcher_entry_entry_signals[UNITY_LAUNCHER_ENTRY_ENTRY_UPDATE_SIGNAL] = g_signal_new ("update", UNITY_LAUNCHER_ENTRY_TYPE_ENTRY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOXED, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_HASH_TABLE);
}

static void
unity_launcher_entry_entry_instance_init (UnityLauncherEntryEntry * self,
                                          gpointer klass)
{
}

GType
unity_launcher_entry_entry_get_type (void)
{
	return unity_launcher_entry_entry_type_id;
}

GType
unity_launcher_entry_entry_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (UnityLauncherEntryEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_launcher_entry_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityLauncherEntryEntry), 0, (GInstanceInitFunc) unity_launcher_entry_entry_instance_init, NULL };
	unity_launcher_entry_entry_type_id = g_type_module_register_type (module, GEARY_TYPE_BASE_OBJECT, "UnityLauncherEntryEntry", &g_define_type_info, 0);
	g_type_set_qdata (unity_launcher_entry_entry_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) unity_launcher_entry_entry_register_object);
	return unity_launcher_entry_entry_type_id;
}

static void
unity_launcher_entry_entry_dbus_interface_method_call (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* method_name,
                                                       GVariant* parameters,
                                                       GDBusMethodInvocation* invocation,
                                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
unity_launcher_entry_entry_dbus_interface_get_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GError** error,
                                                        gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
unity_launcher_entry_entry_dbus_interface_set_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GVariant* value,
                                                        GError** error,
                                                        gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_unity_launcher_entry_entry_update (GObject* _sender,
                                         const gchar* app_uri,
                                         GHashTable* properties,
                                         gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp0_;
	GHashTableIter _tmp1_;
	gpointer _tmp2_;
	gpointer _tmp3_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (app_uri));
	g_hash_table_iter_init (&_tmp1_, properties);
	g_variant_builder_init (&_tmp0_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp1_, &_tmp2_, &_tmp3_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp2_;
		_value = (GVariant*) _tmp3_;
		g_variant_builder_add (&_tmp0_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp0_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.canonical.Unity.LauncherEntry", "Update", _arguments, NULL);
}

static guint
unity_launcher_entry_entry_register_object (gpointer object,
                                            GDBusConnection* connection,
                                            const gchar* path,
                                            GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_unity_launcher_entry_entry_dbus_interface_info), &_unity_launcher_entry_entry_dbus_interface_vtable, data, _unity_launcher_entry_entry_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "update", (GCallback) _dbus_unity_launcher_entry_entry_update, data);
	return result;
}

static void
_unity_launcher_entry_entry_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_unity_launcher_entry_entry_update, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
unity_launcher_entry_class_init (UnityLauncherEntryClass * klass,
                                 gpointer klass_data)
{
	unity_launcher_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UnityLauncherEntry_private_offset);
	G_OBJECT_CLASS (klass)->finalize = unity_launcher_entry_finalize;
}

static void
unity_launcher_entry_instance_init (UnityLauncherEntry * self,
                                    gpointer klass)
{
	UnityLauncherEntryEntry* _tmp0_;
	self->priv = unity_launcher_entry_get_instance_private (self);
	_tmp0_ = unity_launcher_entry_entry_new ();
	self->priv->entry = _tmp0_;
	self->priv->count = (gint64) 0;
	self->priv->count_visible = FALSE;
}

static void
unity_launcher_entry_finalize (GObject * obj)
{
	UnityLauncherEntry * self;
	GDBusConnection* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UNITY_LAUNCHER_ENTRY, UnityLauncherEntry);
	g_bus_unwatch_name (self->priv->watch_id);
	_tmp0_ = self->priv->connection;
	g_dbus_connection_unregister_object (_tmp0_, self->priv->object_id);
	_g_free0 (self->priv->app_uri);
	_g_object_unref0 (self->priv->entry);
	_g_object_unref0 (self->priv->connection);
	G_OBJECT_CLASS (unity_launcher_entry_parent_class)->finalize (obj);
}

/**
 * A simple, high-level interface for the Unity Launcher API.
 *
 * See https://wiki.ubuntu.com/Unity/LauncherAPI for documentation.
 */
GType
unity_launcher_entry_get_type (void)
{
	return unity_launcher_entry_type_id;
}

GType
unity_launcher_entry_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (UnityLauncherEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_launcher_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityLauncherEntry), 0, (GInstanceInitFunc) unity_launcher_entry_instance_init, NULL };
	unity_launcher_entry_type_id = g_type_module_register_type (module, GEARY_TYPE_BASE_OBJECT, "UnityLauncherEntry", &g_define_type_info, 0);
	UnityLauncherEntry_private_offset = sizeof (UnityLauncherEntryPrivate);
	return unity_launcher_entry_type_id;
}

