/* mail-merge-csv.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from mail-merge-csv.vala, do not modify */

/*
 * Copyright © 2020 Michael Gratton <mike@vee.net>.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "util.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include "geary-engine.h"

#define MAIL_MERGE_CSV_READER_UTF8_DOUBLE ((guint8) 0x06)
#define MAIL_MERGE_CSV_READER_UTF8_TRIPLE ((guint8) 0x0E)
#define MAIL_MERGE_CSV_READER_UTF8_QUADRUPLE ((guint8) 0x1E)
#define MAIL_MERGE_CSV_READER_UTF8_TRAILER ((guint8) 0x02)
#define MAIL_MERGE_CSV_READER_UNICODE_REPLACEMENT_CHAR ((gunichar) 0xFFFD)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	MAIL_MERGE_CSV_READER_0_PROPERTY,
	MAIL_MERGE_CSV_READER_LINE_ENDING_PROPERTY,
	MAIL_MERGE_CSV_READER_FIELD_SEPARATOR_PROPERTY,
	MAIL_MERGE_CSV_READER_NUM_PROPERTIES
};
static GParamSpec* mail_merge_csv_reader_properties[MAIL_MERGE_CSV_READER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _MailMergeCsvReaderNewData MailMergeCsvReaderNewData;
typedef struct _MailMergeCsvReaderReadRecordData MailMergeCsvReaderReadRecordData;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _MailMergeCsvReaderReadFieldData MailMergeCsvReaderReadFieldData;
typedef struct _MailMergeCsvReaderReadEolData MailMergeCsvReaderReadEolData;
typedef struct _MailMergeCsvReaderReadCharData MailMergeCsvReaderReadCharData;

/** Denotes CSV-specific error conditions. */
struct _MailMergeCsvReaderPrivate {
	gchar* _line_ending;
	gchar _field_separator;
	GInputStream* input;
	GCancellable* cancellable;
	gunichar next_char;
	guint last_record_length;
};

struct _MailMergeCsvReaderNewData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GType object_type;
	MailMergeCsvReader* self;
	GInputStream* input;
	GCancellable* cancellable;
	GBufferedInputStream* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	GError* _inner_error0_;
};

struct _MailMergeCsvReaderReadRecordData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailMergeCsvReader* self;
	gchar** result;
	gint result_length1;
	gchar** record;
	gint record_length1;
	gint _record_size_;
	GInputStream* _tmp0_;
	gchar** _tmp1_;
	gint next_field;
	gchar* field;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gint _tmp9_;
	gchar _tmp10_;
	GInputStream* _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar** _tmp13_;
	gint _tmp13__length1;
	GError* _inner_error0_;
};

struct _MailMergeCsvReaderReadFieldData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailMergeCsvReader* self;
	gchar* result;
	gboolean quoted;
	GString* buf;
	GString* _tmp0_;
	gboolean _tmp1_;
	GInputStream* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gchar _tmp5_;
	gunichar c;
	gboolean _tmp6_;
	GString* _tmp7_;
	GString* _tmp8_;
	GString* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	GError* _inner_error0_;
};

struct _MailMergeCsvReaderReadEolData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailMergeCsvReader* self;
	gboolean _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gunichar c;
	GError* _tmp3_;
	gunichar _vala1_c;
	gint i;
	gboolean _tmp4_;
	gint _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gunichar _tmp9_;
	const gchar* _tmp10_;
	GError* _tmp11_;
	GError* _inner_error0_;
};

struct _MailMergeCsvReaderReadCharData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailMergeCsvReader* self;
	gunichar result;
	gunichar c;
	guint8 buf[1];
	gsize bytes_read;
	GInputStream* _tmp0_;
	GCancellable* _tmp1_;
	gsize _tmp2_;
	guint8 next;
	guint8 _tmp3_;
	GError* _tmp4_;
	guint to_read;
	GError* _tmp5_;
	guint8 utf[5];
	gint i;
	gboolean _tmp6_;
	gint _tmp7_;
	GInputStream* _tmp8_;
	GCancellable* _tmp9_;
	gsize _tmp10_;
	gboolean _tmp11_;
	guint8 _tmp12_;
	guint8 _tmp13_;
	GInputStream* _tmp14_;
	GError* _inner_error0_;
};

static gint MailMergeCsvReader_private_offset;
static gpointer mail_merge_csv_reader_parent_class = NULL;

static inline gboolean mail_merge_csv_reader_is_text_char (gunichar c);
static void mail_merge_csv_reader_construct_data_free (gpointer _data);
static gboolean mail_merge_csv_reader_construct_co (MailMergeCsvReaderNewData* _data_);
static void mail_merge_csv_reader_read_char (MailMergeCsvReader* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static gunichar mail_merge_csv_reader_read_char_finish (MailMergeCsvReader* self,
                                                 GAsyncResult* _res_,
                                                 GError** error);
static void mail_merge_csv_reader_new_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_);
static void mail_merge_csv_reader_read_record_data_free (gpointer _data);
static gboolean mail_merge_csv_reader_read_record_co (MailMergeCsvReaderReadRecordData* _data_);
static void mail_merge_csv_reader_read_field (MailMergeCsvReader* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
static gchar* mail_merge_csv_reader_read_field_finish (MailMergeCsvReader* self,
                                                GAsyncResult* _res_,
                                                GError** error);
static void mail_merge_csv_reader_read_record_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void mail_merge_csv_reader_read_eol (MailMergeCsvReader* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
static void mail_merge_csv_reader_read_eol_finish (MailMergeCsvReader* self,
                                            GAsyncResult* _res_,
                                            GError** error);
static void mail_merge_csv_reader_read_field_data_free (gpointer _data);
static gboolean mail_merge_csv_reader_read_field_co (MailMergeCsvReaderReadFieldData* _data_);
static void mail_merge_csv_reader_read_field_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
static void mail_merge_csv_reader_read_eol_data_free (gpointer _data);
static gboolean mail_merge_csv_reader_read_eol_co (MailMergeCsvReaderReadEolData* _data_);
static void mail_merge_csv_reader_read_eol_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static void mail_merge_csv_reader_read_char_data_free (gpointer _data);
static gboolean mail_merge_csv_reader_read_char_co (MailMergeCsvReaderReadCharData* _data_);
static void mail_merge_csv_reader_read_char_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static void mail_merge_csv_reader_finalize (GObject * obj);
static GType mail_merge_csv_reader_get_type_once (void);
static void _vala_mail_merge_csv_reader_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_mail_merge_csv_reader_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

GQuark
mail_merge_csv_data_error_quark (void)
{
	return g_quark_from_static_string ("mail-merge-csv-data-error-quark");
}

static GType
mail_merge_csv_data_error_get_type_once (void)
{
	static const GEnumValue values[] = {{MAIL_MERGE_CSV_DATA_ERROR_NON_TEXT_DATA, "MAIL_MERGE_CSV_DATA_ERROR_NON_TEXT_DATA", "non-text-data"}, {MAIL_MERGE_CSV_DATA_ERROR_UNKNOWN_EOL, "MAIL_MERGE_CSV_DATA_ERROR_UNKNOWN_EOL", "unknown-eol"}, {MAIL_MERGE_CSV_DATA_ERROR_EOL_NOT_FOUND, "MAIL_MERGE_CSV_DATA_ERROR_EOL_NOT_FOUND", "eol-not-found"}, {0, NULL, NULL}};
	GType mail_merge_csv_data_error_type_id;
	mail_merge_csv_data_error_type_id = g_enum_register_static ("MailMergeCsvDataError", values);
	return mail_merge_csv_data_error_type_id;
}

GType
mail_merge_csv_data_error_get_type (void)
{
	static volatile gsize mail_merge_csv_data_error_type_id__once = 0;
	if (g_once_init_enter (&mail_merge_csv_data_error_type_id__once)) {
		GType mail_merge_csv_data_error_type_id;
		mail_merge_csv_data_error_type_id = mail_merge_csv_data_error_get_type_once ();
		g_once_init_leave (&mail_merge_csv_data_error_type_id__once, mail_merge_csv_data_error_type_id);
	}
	return mail_merge_csv_data_error_type_id__once;
}

static inline gpointer
mail_merge_csv_reader_get_instance_private (MailMergeCsvReader* self)
{
	return G_STRUCT_MEMBER_P (self, MailMergeCsvReader_private_offset);
}

static inline gboolean
mail_merge_csv_reader_is_text_char (gunichar c)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean result;
	if (c == ((gunichar) 0x20)) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = c == ((gunichar) 0x21);
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		if (c >= ((gunichar) 0x23)) {
			_tmp4_ = c <= ((gunichar) 0x2B);
		} else {
			_tmp4_ = FALSE;
		}
		_tmp2_ = _tmp4_;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		if (c >= ((gunichar) 0x2D)) {
			_tmp5_ = c <= ((gunichar) 0x7E);
		} else {
			_tmp5_ = FALSE;
		}
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = c >= ((gunichar) 0x80);
	}
	result = _tmp0_;
	return result;
}

const gchar*
mail_merge_csv_reader_get_line_ending (MailMergeCsvReader* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (MAIL_MERGE_CSV_IS_READER (self), NULL);
	_tmp0_ = self->priv->_line_ending;
	result = _tmp0_;
	return result;
}

void
mail_merge_csv_reader_set_line_ending (MailMergeCsvReader* self,
                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (MAIL_MERGE_CSV_IS_READER (self));
	old_value = mail_merge_csv_reader_get_line_ending (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_line_ending);
		self->priv->_line_ending = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mail_merge_csv_reader_properties[MAIL_MERGE_CSV_READER_LINE_ENDING_PROPERTY]);
	}
}

gchar
mail_merge_csv_reader_get_field_separator (MailMergeCsvReader* self)
{
	gchar result;
	g_return_val_if_fail (MAIL_MERGE_CSV_IS_READER (self), '\0');
	result = self->priv->_field_separator;
	return result;
}

void
mail_merge_csv_reader_set_field_separator (MailMergeCsvReader* self,
                                           gchar value)
{
	gchar old_value;
	g_return_if_fail (MAIL_MERGE_CSV_IS_READER (self));
	old_value = mail_merge_csv_reader_get_field_separator (self);
	if (old_value != value) {
		self->priv->_field_separator = value;
		g_object_notify_by_pspec ((GObject *) self, mail_merge_csv_reader_properties[MAIL_MERGE_CSV_READER_FIELD_SEPARATOR_PROPERTY]);
	}
}

static void
mail_merge_csv_reader_construct_data_free (gpointer _data)
{
	MailMergeCsvReaderNewData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->input);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (MailMergeCsvReaderNewData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
mail_merge_csv_reader_construct (GType object_type,
                                 GInputStream* input,
                                 GCancellable* cancellable,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	MailMergeCsvReaderNewData* _data_;
	GInputStream* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (input, g_input_stream_get_type ()));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (MailMergeCsvReaderNewData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_merge_csv_reader_construct_data_free);
	_data_->object_type = object_type;
	_tmp0_ = _g_object_ref0 (input);
	_g_object_unref0 (_data_->input);
	_data_->input = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	mail_merge_csv_reader_construct_co (_data_);
}

MailMergeCsvReader*
mail_merge_csv_reader_construct_finish (GAsyncResult* _res_,
                                        GError** error)
{
	MailMergeCsvReader* result;
	MailMergeCsvReaderNewData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->self;
	_data_->self = NULL;
	return result;
}

/**
     * Constructs a new CSV file reader.
     *
     * The reader is primed during construction, so the given stream
     * will be read from. As such, an IOError or other error may occur
     * during construction.
     *
     * If the given cancellable is not null, it will be used when
     * performing I/O operations on the given input stream.
     */
static void
mail_merge_csv_reader_new_ready (GObject* source_object,
                                 GAsyncResult* _res_,
                                 gpointer _user_data_)
{
	MailMergeCsvReaderNewData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_merge_csv_reader_construct_co (_data_);
}

static gboolean
mail_merge_csv_reader_construct_co (MailMergeCsvReaderNewData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->self = (MailMergeCsvReader*) geary_base_object_construct (_data_->object_type);
	_data_->_tmp0_ = (GBufferedInputStream*) g_buffered_input_stream_new (_data_->input);
	_g_object_unref0 (_data_->self->priv->input);
	_data_->self->priv->input = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, g_input_stream_get_type (), GInputStream);
	_data_->_tmp2_ = _g_object_ref0 (_data_->cancellable);
	_data_->_tmp1_ = _data_->_tmp2_;
	if (_data_->_tmp1_ == NULL) {
		_data_->_tmp3_ = g_cancellable_new ();
		_g_object_unref0 (_data_->_tmp1_);
		_data_->_tmp1_ = _data_->_tmp3_;
	}
	_data_->_tmp4_ = _data_->_tmp1_;
	_data_->_tmp1_ = NULL;
	_g_object_unref0 (_data_->self->priv->cancellable);
	_data_->self->priv->cancellable = _data_->_tmp4_;
	_data_->_state_ = 1;
	mail_merge_csv_reader_read_char (_data_->self, mail_merge_csv_reader_new_ready, _data_);
	return FALSE;
	_state_1:
	mail_merge_csv_reader_read_char_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp1_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->_tmp1_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
mail_merge_csv_reader_new (GInputStream* input,
                           GCancellable* cancellable,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_)
{
	mail_merge_csv_reader_construct (MAIL_MERGE_CSV_TYPE_READER, input, cancellable, _callback_, _user_data_);
}

MailMergeCsvReader*
mail_merge_csv_reader_new_finish (GAsyncResult* _res_,
                                  GError** error)
{
	return mail_merge_csv_reader_construct_finish (_res_, error);
}

static void
mail_merge_csv_reader_read_record_data_free (gpointer _data)
{
	MailMergeCsvReaderReadRecordData* _data_;
	_data_ = _data;
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (MailMergeCsvReaderReadRecordData, _data_);
}

void
mail_merge_csv_reader_read_record (MailMergeCsvReader* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	MailMergeCsvReaderReadRecordData* _data_;
	MailMergeCsvReader* _tmp0_;
	g_return_if_fail (MAIL_MERGE_CSV_IS_READER (self));
	_data_ = g_slice_new0 (MailMergeCsvReaderReadRecordData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_merge_csv_reader_read_record_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	mail_merge_csv_reader_read_record_co (_data_);
}

gchar**
mail_merge_csv_reader_read_record_finish (MailMergeCsvReader* self,
                                          GAsyncResult* _res_,
                                          gint* result_length1,
                                          GError** error)
{
	gchar** result;
	MailMergeCsvReaderReadRecordData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static void
mail_merge_csv_reader_read_record_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	MailMergeCsvReaderReadRecordData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_merge_csv_reader_read_record_co (_data_);
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
mail_merge_csv_reader_read_record_co (MailMergeCsvReaderReadRecordData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->record = NULL;
	_data_->record_length1 = 0;
	_data_->_record_size_ = _data_->record_length1;
	_data_->_tmp0_ = _data_->self->priv->input;
	if (!g_input_stream_is_closed (_data_->_tmp0_)) {
		_data_->_tmp1_ = g_new0 (gchar*, _data_->self->priv->last_record_length + 1);
		_data_->record = (_vala_array_free (_data_->record, _data_->record_length1, (GDestroyNotify) g_free), NULL);
		_data_->record = _data_->_tmp1_;
		_data_->record_length1 = _data_->self->priv->last_record_length;
		_data_->_record_size_ = _data_->record_length1;
		_data_->next_field = 0;
		while (TRUE) {
			_data_->_state_ = 1;
			mail_merge_csv_reader_read_field (_data_->self, mail_merge_csv_reader_read_record_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp2_ = mail_merge_csv_reader_read_field_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			_data_->field = _data_->_tmp2_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_data_->record = (_vala_array_free (_data_->record, _data_->record_length1, (GDestroyNotify) g_free), NULL);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp3_ = _data_->record;
			_data_->_tmp3__length1 = _data_->record_length1;
			if (_data_->next_field < _data_->_tmp3__length1) {
				_data_->_tmp4_ = _data_->record;
				_data_->_tmp4__length1 = _data_->record_length1;
				_data_->_tmp5_ = _data_->field;
				_data_->_tmp6_ = g_strdup (_data_->_tmp5_);
				_g_free0 (_data_->_tmp4_[_data_->next_field]);
				_data_->_tmp4_[_data_->next_field] = _data_->_tmp6_;
			} else {
				_data_->_tmp7_ = _data_->field;
				_data_->_tmp8_ = g_strdup (_data_->_tmp7_);
				_vala_array_add1 (&_data_->record, &_data_->record_length1, &_data_->_record_size_, _data_->_tmp8_);
			}
			_data_->next_field = _data_->next_field + 1;
			_data_->_tmp9_ = _data_->next_field;
			_data_->_tmp10_ = _data_->self->priv->_field_separator;
			if (_data_->self->priv->next_char == ((gunichar) _data_->_tmp10_)) {
				_data_->_state_ = 2;
				mail_merge_csv_reader_read_char (_data_->self, mail_merge_csv_reader_read_record_ready, _data_);
				return FALSE;
				_state_2:
				mail_merge_csv_reader_read_char_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					_g_free0 (_data_->field);
					_data_->record = (_vala_array_free (_data_->record, _data_->record_length1, (GDestroyNotify) g_free), NULL);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			} else {
				_g_free0 (_data_->field);
				break;
			}
			_g_free0 (_data_->field);
		}
		_data_->_tmp11_ = _data_->self->priv->input;
		if (!g_input_stream_is_closed (_data_->_tmp11_)) {
			_data_->_state_ = 3;
			mail_merge_csv_reader_read_eol (_data_->self, mail_merge_csv_reader_read_record_ready, _data_);
			return FALSE;
			_state_3:
			mail_merge_csv_reader_read_eol_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_data_->record = (_vala_array_free (_data_->record, _data_->record_length1, (GDestroyNotify) g_free), NULL);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	}
	_data_->_tmp12_ = _data_->record;
	_data_->_tmp12__length1 = _data_->record_length1;
	_data_->self->priv->last_record_length = (guint) _data_->_tmp12__length1;
	_data_->_tmp13_ = _data_->record;
	_data_->_tmp13__length1 = _data_->record_length1;
	_data_->result_length1 = _data_->_tmp13__length1;
	_data_->result = _data_->_tmp13_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
mail_merge_csv_reader_read_field_data_free (gpointer _data)
{
	MailMergeCsvReaderReadFieldData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (MailMergeCsvReaderReadFieldData, _data_);
}

static void
mail_merge_csv_reader_read_field (MailMergeCsvReader* self,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	MailMergeCsvReaderReadFieldData* _data_;
	MailMergeCsvReader* _tmp0_;
	g_return_if_fail (MAIL_MERGE_CSV_IS_READER (self));
	_data_ = g_slice_new0 (MailMergeCsvReaderReadFieldData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_merge_csv_reader_read_field_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	mail_merge_csv_reader_read_field_co (_data_);
}

static gchar*
mail_merge_csv_reader_read_field_finish (MailMergeCsvReader* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	gchar* result;
	MailMergeCsvReaderReadFieldData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
mail_merge_csv_reader_read_field_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	MailMergeCsvReaderReadFieldData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_merge_csv_reader_read_field_co (_data_);
}

static gboolean
mail_merge_csv_reader_read_field_co (MailMergeCsvReaderReadFieldData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->quoted = _data_->self->priv->next_char == ((gunichar) '"');
	if (_data_->quoted) {
		_data_->_state_ = 1;
		mail_merge_csv_reader_read_char (_data_->self, mail_merge_csv_reader_read_field_ready, _data_);
		return FALSE;
		_state_1:
		mail_merge_csv_reader_read_char_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp0_ = g_string_new ("");
	_data_->buf = _data_->_tmp0_;
	while (TRUE) {
		_data_->_tmp2_ = _data_->self->priv->input;
		if (!g_input_stream_is_closed (_data_->_tmp2_)) {
			if (_data_->quoted) {
				_data_->_tmp3_ = TRUE;
			} else {
				_data_->_tmp5_ = _data_->self->priv->_field_separator;
				if (_data_->self->priv->next_char != ((gunichar) _data_->_tmp5_)) {
					_data_->_tmp4_ = mail_merge_csv_reader_is_text_char (_data_->self->priv->next_char);
				} else {
					_data_->_tmp4_ = FALSE;
				}
				_data_->_tmp3_ = _data_->_tmp4_;
			}
			_data_->_tmp1_ = _data_->_tmp3_;
		} else {
			_data_->_tmp1_ = FALSE;
		}
		if (!_data_->_tmp1_) {
			break;
		}
		_data_->_state_ = 2;
		mail_merge_csv_reader_read_char (_data_->self, mail_merge_csv_reader_read_field_ready, _data_);
		return FALSE;
		_state_2:
		_data_->c = mail_merge_csv_reader_read_char_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_string_free0 (_data_->buf);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		if (_data_->quoted) {
			_data_->_tmp6_ = _data_->c == ((gunichar) '"');
		} else {
			_data_->_tmp6_ = FALSE;
		}
		if (_data_->_tmp6_) {
			if (_data_->self->priv->next_char == ((gunichar) '"')) {
				_data_->_tmp7_ = _data_->buf;
				g_string_append_c (_data_->_tmp7_, '"');
				_data_->_state_ = 3;
				mail_merge_csv_reader_read_char (_data_->self, mail_merge_csv_reader_read_field_ready, _data_);
				return FALSE;
				_state_3:
				mail_merge_csv_reader_read_char_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					_g_string_free0 (_data_->buf);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			} else {
				_data_->quoted = FALSE;
			}
		} else {
			_data_->_tmp8_ = _data_->buf;
			g_string_append_unichar (_data_->_tmp8_, _data_->c);
		}
	}
	_data_->_tmp9_ = _data_->buf;
	_data_->_tmp10_ = _data_->_tmp9_->str;
	_data_->_tmp11_ = g_strdup (_data_->_tmp10_);
	_data_->result = _data_->_tmp11_;
	_g_string_free0 (_data_->buf);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
mail_merge_csv_reader_read_eol_data_free (gpointer _data)
{
	MailMergeCsvReaderReadEolData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MailMergeCsvReaderReadEolData, _data_);
}

static void
mail_merge_csv_reader_read_eol (MailMergeCsvReader* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	MailMergeCsvReaderReadEolData* _data_;
	MailMergeCsvReader* _tmp0_;
	g_return_if_fail (MAIL_MERGE_CSV_IS_READER (self));
	_data_ = g_slice_new0 (MailMergeCsvReaderReadEolData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_merge_csv_reader_read_eol_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	mail_merge_csv_reader_read_eol_co (_data_);
}

static void
mail_merge_csv_reader_read_eol_finish (MailMergeCsvReader* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	MailMergeCsvReaderReadEolData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
mail_merge_csv_reader_read_eol_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	MailMergeCsvReaderReadEolData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_merge_csv_reader_read_eol_co (_data_);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gboolean
mail_merge_csv_reader_read_eol_co (MailMergeCsvReaderReadEolData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->self->priv->_line_ending;
	if (_data_->_tmp1_ == NULL) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp2_ = _data_->self->priv->_line_ending;
		_data_->_tmp0_ = g_strcmp0 (_data_->_tmp2_, "") == 0;
	}
	if (_data_->_tmp0_) {
		_data_->_state_ = 1;
		mail_merge_csv_reader_read_char (_data_->self, mail_merge_csv_reader_read_eol_ready, _data_);
		return FALSE;
		_state_1:
		_data_->c = mail_merge_csv_reader_read_char_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		if (_data_->c == ((gunichar) '\n')) {
			mail_merge_csv_reader_set_line_ending (_data_->self, "\n");
		} else {
			if (_data_->c == ((gunichar) '\r')) {
				if (_data_->self->priv->next_char == ((gunichar) '\n')) {
					_data_->_state_ = 2;
					mail_merge_csv_reader_read_char (_data_->self, mail_merge_csv_reader_read_eol_ready, _data_);
					return FALSE;
					_state_2:
					mail_merge_csv_reader_read_char_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
					mail_merge_csv_reader_set_line_ending (_data_->self, "\r\n");
				} else {
					mail_merge_csv_reader_set_line_ending (_data_->self, "\r");
				}
			} else {
				_data_->_tmp3_ = g_error_new (MAIL_MERGE_CSV_DATA_ERROR, MAIL_MERGE_CSV_DATA_ERROR_UNKNOWN_EOL, "Unable to determine end of line character 0x%02x", (guint) _data_->c);
				_data_->_inner_error0_ = _data_->_tmp3_;
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	} else {
		{
			_data_->i = 0;
			{
				_data_->_tmp4_ = TRUE;
				while (TRUE) {
					if (!_data_->_tmp4_) {
						_data_->_tmp5_ = _data_->i;
						_data_->i = _data_->_tmp5_ + 1;
					}
					_data_->_tmp4_ = FALSE;
					_data_->_tmp6_ = _data_->self->priv->_line_ending;
					_data_->_tmp7_ = strlen (_data_->_tmp6_);
					_data_->_tmp8_ = _data_->_tmp7_;
					if (!(_data_->i < _data_->_tmp8_)) {
						break;
					}
					_data_->_state_ = 3;
					mail_merge_csv_reader_read_char (_data_->self, mail_merge_csv_reader_read_eol_ready, _data_);
					return FALSE;
					_state_3:
					_data_->_tmp9_ = mail_merge_csv_reader_read_char_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
					_data_->_vala1_c = _data_->_tmp9_;
					_data_->_tmp10_ = _data_->self->priv->_line_ending;
					if (((gunichar) string_get (_data_->_tmp10_, (glong) _data_->i)) != _data_->_vala1_c) {
						_data_->_tmp11_ = g_error_new (MAIL_MERGE_CSV_DATA_ERROR, MAIL_MERGE_CSV_DATA_ERROR_EOL_NOT_FOUND, "Unexpected end of line character: 0x%02X", (guint) _data_->_vala1_c);
						_data_->_inner_error0_ = _data_->_tmp11_;
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
			}
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
mail_merge_csv_reader_read_char_data_free (gpointer _data)
{
	MailMergeCsvReaderReadCharData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MailMergeCsvReaderReadCharData, _data_);
}

static void
mail_merge_csv_reader_read_char (MailMergeCsvReader* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	MailMergeCsvReaderReadCharData* _data_;
	MailMergeCsvReader* _tmp0_;
	g_return_if_fail (MAIL_MERGE_CSV_IS_READER (self));
	_data_ = g_slice_new0 (MailMergeCsvReaderReadCharData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_merge_csv_reader_read_char_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	mail_merge_csv_reader_read_char_co (_data_);
}

static gunichar
mail_merge_csv_reader_read_char_finish (MailMergeCsvReader* self,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	gunichar result;
	MailMergeCsvReaderReadCharData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gunichar _tmp0_ = 0U;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
mail_merge_csv_reader_read_char_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	MailMergeCsvReaderReadCharData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_merge_csv_reader_read_char_co (_data_);
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static gboolean
mail_merge_csv_reader_read_char_co (MailMergeCsvReaderReadCharData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->c = _data_->self->priv->next_char;
	_data_->bytes_read = (gsize) 0;
	_data_->_tmp0_ = _data_->self->priv->input;
	_data_->_tmp1_ = _data_->self->priv->cancellable;
	_data_->_tmp2_ = 0UL;
	_data_->_state_ = 1;
	g_input_stream_read_all_async (_data_->_tmp0_, _data_->buf, (gsize) 1, G_PRIORITY_DEFAULT, _data_->_tmp1_, mail_merge_csv_reader_read_char_ready, _data_);
	return FALSE;
	_state_1:
	g_input_stream_read_all_finish (_data_->_tmp0_, _data_->_res_, &_data_->_tmp2_, &_data_->_inner_error0_);
	_data_->bytes_read = _data_->_tmp2_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->bytes_read > ((gsize) 0)) {
		_data_->_tmp3_ = _data_->buf[0];
		_data_->next = _data_->_tmp3_;
		if (((gint) _data_->next) == 0x00) {
			_data_->_tmp4_ = g_error_new_literal (MAIL_MERGE_CSV_DATA_ERROR, MAIL_MERGE_CSV_DATA_ERROR_NON_TEXT_DATA, "Read null byte");
			_data_->_inner_error0_ = _data_->_tmp4_;
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		if (((gint) _data_->next) <= 0x7F) {
			_data_->self->priv->next_char = (gunichar) _data_->next;
		} else {
			_data_->to_read = (guint) 0;
			if ((_data_->next >> 5) == ((gint) MAIL_MERGE_CSV_READER_UTF8_DOUBLE)) {
				_data_->to_read = (guint) 1;
			} else {
				if ((_data_->next >> 4) == ((gint) MAIL_MERGE_CSV_READER_UTF8_TRIPLE)) {
					_data_->to_read = (guint) 2;
				} else {
					if ((_data_->next >> 3) == ((gint) MAIL_MERGE_CSV_READER_UTF8_QUADRUPLE)) {
						_data_->to_read = (guint) 3;
					} else {
						_data_->_tmp5_ = g_error_new_literal (MAIL_MERGE_CSV_DATA_ERROR, MAIL_MERGE_CSV_DATA_ERROR_NON_TEXT_DATA, "Invalid UTF-8 data");
						_data_->_inner_error0_ = _data_->_tmp5_;
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
			}
			_data_->utf[0] = _data_->next;
			_data_->utf[_data_->to_read + 1] = (guint8) 0x00;
			{
				_data_->i = 0;
				{
					_data_->_tmp6_ = TRUE;
					while (TRUE) {
						if (!_data_->_tmp6_) {
							_data_->_tmp7_ = _data_->i;
							_data_->i = _data_->_tmp7_ + 1;
						}
						_data_->_tmp6_ = FALSE;
						if (!(((guint) _data_->i) < _data_->to_read)) {
							break;
						}
						_data_->_tmp8_ = _data_->self->priv->input;
						_data_->_tmp9_ = _data_->self->priv->cancellable;
						_data_->_tmp10_ = 0UL;
						_data_->_state_ = 2;
						g_input_stream_read_all_async (_data_->_tmp8_, _data_->buf, (gsize) 1, G_PRIORITY_DEFAULT, _data_->_tmp9_, mail_merge_csv_reader_read_char_ready, _data_);
						return FALSE;
						_state_2:
						g_input_stream_read_all_finish (_data_->_tmp8_, _data_->_res_, &_data_->_tmp10_, &_data_->_inner_error0_);
						_data_->bytes_read = _data_->_tmp10_;
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
							g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
							g_object_unref (_data_->_async_result);
							return FALSE;
						}
						if (_data_->bytes_read == ((gsize) 1)) {
							_data_->_tmp12_ = _data_->buf[0];
							_data_->_tmp11_ = (_data_->_tmp12_ >> 6) == ((gint) MAIL_MERGE_CSV_READER_UTF8_TRAILER);
						} else {
							_data_->_tmp11_ = FALSE;
						}
						if (_data_->_tmp11_) {
							_data_->_tmp13_ = _data_->buf[0];
							_data_->utf[_data_->i + 1] = _data_->_tmp13_;
						} else {
							_data_->utf[_data_->i + 1] = (guint8) 0x00;
							break;
						}
					}
				}
			}
			_data_->self->priv->next_char = string_get_char ((const gchar*) _data_->utf, (glong) 0);
			if (!g_unichar_validate (_data_->self->priv->next_char)) {
				_data_->self->priv->next_char = MAIL_MERGE_CSV_READER_UNICODE_REPLACEMENT_CHAR;
			}
		}
	} else {
		_data_->self->priv->next_char = (gunichar) '\0';
		_data_->_tmp14_ = _data_->self->priv->input;
		_data_->_state_ = 3;
		g_input_stream_close_async (_data_->_tmp14_, G_PRIORITY_DEFAULT, NULL, mail_merge_csv_reader_read_char_ready, _data_);
		return FALSE;
		_state_3:
		g_input_stream_close_finish (_data_->_tmp14_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->result = _data_->c;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
mail_merge_csv_reader_class_init (MailMergeCsvReaderClass * klass,
                                  gpointer klass_data)
{
	mail_merge_csv_reader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MailMergeCsvReader_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_mail_merge_csv_reader_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_mail_merge_csv_reader_set_property;
	G_OBJECT_CLASS (klass)->finalize = mail_merge_csv_reader_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_MERGE_CSV_READER_LINE_ENDING_PROPERTY, mail_merge_csv_reader_properties[MAIL_MERGE_CSV_READER_LINE_ENDING_PROPERTY] = g_param_spec_string ("line-ending", "line-ending", "line-ending", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_MERGE_CSV_READER_FIELD_SEPARATOR_PROPERTY, mail_merge_csv_reader_properties[MAIL_MERGE_CSV_READER_FIELD_SEPARATOR_PROPERTY] = g_param_spec_char ("field-separator", "field-separator", "field-separator", G_MININT8, G_MAXINT8, ',', G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
mail_merge_csv_reader_instance_init (MailMergeCsvReader * self,
                                     gpointer klass)
{
	self->priv = mail_merge_csv_reader_get_instance_private (self);
	self->priv->_line_ending = NULL;
	self->priv->_field_separator = ',';
	self->priv->next_char = (gunichar) '\0';
	self->priv->last_record_length = (guint) 0;
}

static void
mail_merge_csv_reader_finalize (GObject * obj)
{
	MailMergeCsvReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_MERGE_CSV_TYPE_READER, MailMergeCsvReader);
	_g_free0 (self->priv->_line_ending);
	_g_object_unref0 (self->priv->input);
	_g_object_unref0 (self->priv->cancellable);
	G_OBJECT_CLASS (mail_merge_csv_reader_parent_class)->finalize (obj);
}

/**
 * A simple comma-separated value (CSV) reader.
 *
 * To use this class, simply construct an instance start calling
 * {@link read_record}.
 */
static GType
mail_merge_csv_reader_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MailMergeCsvReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mail_merge_csv_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MailMergeCsvReader), 0, (GInstanceInitFunc) mail_merge_csv_reader_instance_init, NULL };
	GType mail_merge_csv_reader_type_id;
	mail_merge_csv_reader_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "MailMergeCsvReader", &g_define_type_info, 0);
	MailMergeCsvReader_private_offset = g_type_add_instance_private (mail_merge_csv_reader_type_id, sizeof (MailMergeCsvReaderPrivate));
	return mail_merge_csv_reader_type_id;
}

GType
mail_merge_csv_reader_get_type (void)
{
	static volatile gsize mail_merge_csv_reader_type_id__once = 0;
	if (g_once_init_enter (&mail_merge_csv_reader_type_id__once)) {
		GType mail_merge_csv_reader_type_id;
		mail_merge_csv_reader_type_id = mail_merge_csv_reader_get_type_once ();
		g_once_init_leave (&mail_merge_csv_reader_type_id__once, mail_merge_csv_reader_type_id);
	}
	return mail_merge_csv_reader_type_id__once;
}

static void
_vala_mail_merge_csv_reader_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	MailMergeCsvReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_MERGE_CSV_TYPE_READER, MailMergeCsvReader);
	switch (property_id) {
		case MAIL_MERGE_CSV_READER_LINE_ENDING_PROPERTY:
		g_value_set_string (value, mail_merge_csv_reader_get_line_ending (self));
		break;
		case MAIL_MERGE_CSV_READER_FIELD_SEPARATOR_PROPERTY:
		g_value_set_schar (value, mail_merge_csv_reader_get_field_separator (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_mail_merge_csv_reader_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	MailMergeCsvReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_MERGE_CSV_TYPE_READER, MailMergeCsvReader);
	switch (property_id) {
		case MAIL_MERGE_CSV_READER_LINE_ENDING_PROPERTY:
		mail_merge_csv_reader_set_line_ending (self, g_value_get_string (value));
		break;
		case MAIL_MERGE_CSV_READER_FIELD_SEPARATOR_PROPERTY:
		mail_merge_csv_reader_set_field_separator (self, g_value_get_schar (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

