/* sidebar-tree.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from sidebar-tree.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-client-46.0.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include "geary-engine.h"
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SIDEBAR_TREE_TYPE_ENTRY_WRAPPER (sidebar_tree_entry_wrapper_get_type ())
#define SIDEBAR_TREE_ENTRY_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TREE_TYPE_ENTRY_WRAPPER, SidebarTreeEntryWrapper))
#define SIDEBAR_TREE_ENTRY_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TREE_TYPE_ENTRY_WRAPPER, SidebarTreeEntryWrapperClass))
#define SIDEBAR_TREE_IS_ENTRY_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TREE_TYPE_ENTRY_WRAPPER))
#define SIDEBAR_TREE_IS_ENTRY_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TREE_TYPE_ENTRY_WRAPPER))
#define SIDEBAR_TREE_ENTRY_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TREE_TYPE_ENTRY_WRAPPER, SidebarTreeEntryWrapperClass))

typedef struct _SidebarTreeEntryWrapper SidebarTreeEntryWrapper;
typedef struct _SidebarTreeEntryWrapperClass SidebarTreeEntryWrapperClass;
enum  {
	SIDEBAR_TREE_0_PROPERTY,
	SIDEBAR_TREE_NUM_PROPERTIES
};
static GParamSpec* sidebar_tree_properties[SIDEBAR_TREE_NUM_PROPERTIES];
typedef enum  {
	SIDEBAR_TREE_COLUMNS_NAME,
	SIDEBAR_TREE_COLUMNS_TOOLTIP,
	SIDEBAR_TREE_COLUMNS_WRAPPER,
	SIDEBAR_TREE_COLUMNS_ICON,
	SIDEBAR_TREE_COLUMNS_COUNTER,
	SIDEBAR_TREE_COLUMNS_N_COLUMNS
} SidebarTreeColumns;

#define SIDEBAR_TREE_TYPE_COLUMNS (sidebar_tree_columns_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GtkTreeRowReference_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreeRowReference_free (var), NULL)))
typedef struct _SidebarTreeEntryWrapperPrivate SidebarTreeEntryWrapperPrivate;
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define SIDEBAR_TREE_TYPE_ROOT_WRAPPER (sidebar_tree_root_wrapper_get_type ())
#define SIDEBAR_TREE_ROOT_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TREE_TYPE_ROOT_WRAPPER, SidebarTreeRootWrapper))
#define SIDEBAR_TREE_ROOT_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TREE_TYPE_ROOT_WRAPPER, SidebarTreeRootWrapperClass))
#define SIDEBAR_TREE_IS_ROOT_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TREE_TYPE_ROOT_WRAPPER))
#define SIDEBAR_TREE_IS_ROOT_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TREE_TYPE_ROOT_WRAPPER))
#define SIDEBAR_TREE_ROOT_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TREE_TYPE_ROOT_WRAPPER, SidebarTreeRootWrapperClass))

typedef struct _SidebarTreeRootWrapper SidebarTreeRootWrapper;
typedef struct _SidebarTreeRootWrapperClass SidebarTreeRootWrapperClass;
typedef struct _SidebarTreeRootWrapperPrivate SidebarTreeRootWrapperPrivate;
#define __vala_GtkTreeIter_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreeIter_free (var), NULL)))
enum  {
	SIDEBAR_TREE_ENTRY_WRAPPER_0_PROPERTY,
	SIDEBAR_TREE_ENTRY_WRAPPER_NUM_PROPERTIES
};
static GParamSpec* sidebar_tree_entry_wrapper_properties[SIDEBAR_TREE_ENTRY_WRAPPER_NUM_PROPERTIES];
enum  {
	SIDEBAR_TREE_ROOT_WRAPPER_0_PROPERTY,
	SIDEBAR_TREE_ROOT_WRAPPER_NUM_PROPERTIES
};
static GParamSpec* sidebar_tree_root_wrapper_properties[SIDEBAR_TREE_ROOT_WRAPPER_NUM_PROPERTIES];
enum  {
	SIDEBAR_TREE_ENTRY_SELECTED_SIGNAL,
	SIDEBAR_TREE_ENTRY_ACTIVATED_SIGNAL,
	SIDEBAR_TREE_SELECTED_ENTRY_REMOVED_SIGNAL,
	SIDEBAR_TREE_BRANCH_ADDED_SIGNAL,
	SIDEBAR_TREE_BRANCH_REMOVED_SIGNAL,
	SIDEBAR_TREE_BRANCH_SHOWN_SIGNAL,
	SIDEBAR_TREE_NUM_SIGNALS
};
static guint sidebar_tree_signals[SIDEBAR_TREE_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SidebarTreePrivate {
	GtkTreeStore* store;
	GtkIconTheme* icon_theme;
	GtkTreeViewColumn* text_column;
	GtkCellRendererText* text_renderer;
	SidebarTreeExternalDropHandler drop_handler;
	gpointer drop_handler_target;
	GtkEntry* text_entry;
	GeeHashMap* entry_map;
	GeeHashMap* branches;
	gint editing_disabled;
	gboolean mask_entry_selected_signal;
	SidebarTreeEntryWrapper* selected_wrapper;
	GtkMenu* default_context_menu;
	gboolean is_internal_drag_in_progress;
	SidebarEntry* internal_drag_source_entry;
	GtkTreeRowReference* old_path_ref;
};

struct _SidebarTreeEntryWrapper {
	GObject parent_instance;
	SidebarEntry* entry;
	GtkTreeRowReference* row;
	SidebarTreeEntryWrapperPrivate * priv;
};

struct _SidebarTreeEntryWrapperClass {
	GObjectClass parent_class;
};

struct _SidebarTreeRootWrapper {
	SidebarTreeEntryWrapper parent_instance;
	gint root_position;
	SidebarTreeRootWrapperPrivate * priv;
};

struct _SidebarTreeRootWrapperClass {
	SidebarTreeEntryWrapperClass parent_class;
};

static gint SidebarTree_private_offset;
static gpointer sidebar_tree_parent_class = NULL;
static gpointer sidebar_tree_entry_wrapper_parent_class = NULL;
static gpointer sidebar_tree_root_wrapper_parent_class = NULL;

static GType sidebar_tree_entry_wrapper_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void sidebar_tree_on_editing_canceled (SidebarTree* self);
static void _sidebar_tree_on_editing_canceled_gtk_cell_renderer_editing_canceled (GtkCellRenderer* _sender,
                                                                           gpointer self);
static void sidebar_tree_on_editing_started (SidebarTree* self,
                                      GtkCellEditable* editable,
                                      const gchar* path);
static void _sidebar_tree_on_editing_started_gtk_cell_renderer_editing_started (GtkCellRenderer* _sender,
                                                                         GtkCellEditable* editable,
                                                                         const gchar* path,
                                                                         gpointer self);
static GType sidebar_tree_columns_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void _vala_GtkTreeRowReference_free (GtkTreeRowReference* self);
static void g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static void _sidebar_tree_icon_renderer_function_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                     GtkCellRenderer* cell,
                                                                     GtkTreeModel* tree_model,
                                                                     GtkTreeIter* iter,
                                                                     gpointer self);
static void _sidebar_tree_counter_renderer_function_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                        GtkCellRenderer* cell,
                                                                        GtkTreeModel* tree_model,
                                                                        GtkTreeIter* iter,
                                                                        gpointer self);
static gboolean sidebar_tree_on_selection (SidebarTree* self,
                                    GtkTreeSelection* selection,
                                    GtkTreeModel* model,
                                    GtkTreePath* path,
                                    gboolean path_currently_selected);
static gboolean _sidebar_tree_on_selection_gtk_tree_selection_func (GtkTreeSelection* selection,
                                                             GtkTreeModel* model,
                                                             GtkTreePath* path,
                                                             gboolean path_currently_selected,
                                                             gpointer self);
static gboolean sidebar_tree_on_context_menu_keypress (SidebarTree* self);
static gboolean _sidebar_tree_on_context_menu_keypress_gtk_widget_popup_menu (GtkWidget* _sender,
                                                                       gpointer self);
static void sidebar_tree_on_drag_begin (SidebarTree* self,
                                 GdkDragContext* ctx);
static void _sidebar_tree_on_drag_begin_gtk_widget_drag_begin (GtkWidget* _sender,
                                                        GdkDragContext* context,
                                                        gpointer self);
static void sidebar_tree_on_drag_end (SidebarTree* self,
                               GdkDragContext* ctx);
static void _sidebar_tree_on_drag_end_gtk_widget_drag_end (GtkWidget* _sender,
                                                    GdkDragContext* context,
                                                    gpointer self);
static gboolean sidebar_tree_on_drag_motion (SidebarTree* self,
                                      GdkDragContext* context,
                                      gint x,
                                      gint y,
                                      guint time_);
static gboolean _sidebar_tree_on_drag_motion_gtk_widget_drag_motion (GtkWidget* _sender,
                                                              GdkDragContext* context,
                                                              gint x,
                                                              gint y,
                                                              guint time_,
                                                              gpointer self);
static SidebarTreeEntryWrapper* sidebar_tree_get_wrapper_at_iter (SidebarTree* self,
                                                           GtkTreeIter* iter);
static void _vala_GtkTreePath_free (GtkTreePath* self);
static SidebarTreeEntryWrapper* sidebar_tree_get_wrapper_at_path (SidebarTree* self,
                                                           GtkTreePath* path);
static gboolean sidebar_tree_has_wrapper (SidebarTree* self,
                                   SidebarEntry* entry);
static SidebarTreeEntryWrapper* sidebar_tree_get_wrapper (SidebarTree* self,
                                                   SidebarEntry* entry);
static GtkTreePath* sidebar_tree_entry_wrapper_get_path (SidebarTreeEntryWrapper* self);
static GtkTreePath* sidebar_tree_get_selected_path (SidebarTree* self);
static GtkTreePath* _vala_GtkTreePath_copy (GtkTreePath* self);
static void __vala_GtkTreePath_free0_ (gpointer var);
static inline void _g_list_free___vala_GtkTreePath_free0_ (GList* self);
static gchar* sidebar_tree_get_name_for_entry (SidebarTree* self,
                                        SidebarEntry* entry);
static gboolean sidebar_tree_real_accept_cursor_changed (SidebarTree* self);
static void sidebar_tree_real_row_activated (GtkTreeView* base,
                                      GtkTreePath* path,
                                      GtkTreeViewColumn* column);
static void sidebar_tree_toggle_branch_expansion (SidebarTree* self,
                                           GtkTreePath* path);
static void sidebar_tree_real_cursor_changed (GtkTreeView* base);
static void sidebar_tree_associate_branch (SidebarTree* self,
                                    SidebarBranch* branch);
static void sidebar_tree_on_branch_entry_added (SidebarTree* self,
                                         SidebarBranch* branch,
                                         SidebarEntry* entry);
static void _sidebar_tree_on_branch_entry_added_sidebar_branch_entry_added (SidebarBranch* _sender,
                                                                     SidebarEntry* entry,
                                                                     gpointer self);
static void sidebar_tree_on_branch_entry_removed (SidebarTree* self,
                                           SidebarBranch* branch,
                                           SidebarEntry* entry);
static void _sidebar_tree_on_branch_entry_removed_sidebar_branch_entry_removed (SidebarBranch* _sender,
                                                                         SidebarEntry* entry,
                                                                         gpointer self);
static void sidebar_tree_on_branch_entry_moved (SidebarTree* self,
                                         SidebarBranch* branch,
                                         SidebarEntry* entry);
static void _sidebar_tree_on_branch_entry_moved_sidebar_branch_entry_moved (SidebarBranch* _sender,
                                                                     SidebarEntry* entry,
                                                                     gpointer self);
static void sidebar_tree_on_branch_entry_reparented (SidebarTree* self,
                                              SidebarBranch* branch,
                                              SidebarEntry* entry,
                                              SidebarEntry* old_parent);
static void _sidebar_tree_on_branch_entry_reparented_sidebar_branch_entry_reparented (SidebarBranch* _sender,
                                                                               SidebarEntry* entry,
                                                                               SidebarEntry* old_parent,
                                                                               gpointer self);
static void sidebar_tree_on_branch_children_reordered (SidebarTree* self,
                                                SidebarBranch* branch,
                                                SidebarEntry* entry);
static void _sidebar_tree_on_branch_children_reordered_sidebar_branch_children_reordered (SidebarBranch* _sender,
                                                                                   SidebarEntry* entry,
                                                                                   gpointer self);
static void sidebar_tree_on_show_branch (SidebarTree* self,
                                  SidebarBranch* branch,
                                  gboolean shown);
static void _sidebar_tree_on_show_branch_sidebar_branch_show_branch (SidebarBranch* _sender,
                                                              gboolean show,
                                                              gpointer self);
static GType sidebar_tree_root_wrapper_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void _vala_GtkTreeIter_free (GtkTreeIter* self);
static GtkTreeIter* _vala_GtkTreeIter_copy (GtkTreeIter* self);
static void sidebar_tree_associate_wrapper (SidebarTree* self,
                                     GtkTreeIter* assoc_iter,
                                     SidebarTreeEntryWrapper* wrapper);
static SidebarTreeRootWrapper* sidebar_tree_root_wrapper_new (GtkTreeModel* model,
                                                       SidebarEntry* entry,
                                                       GtkTreePath* path,
                                                       gint root_position);
static SidebarTreeRootWrapper* sidebar_tree_root_wrapper_construct (GType object_type,
                                                             GtkTreeModel* model,
                                                             SidebarEntry* entry,
                                                             GtkTreePath* path,
                                                             gint root_position);
static void sidebar_tree_associate_children (SidebarTree* self,
                                      SidebarBranch* branch,
                                      SidebarEntry* parent,
                                      GtkTreeIter* parent_iter);
static void sidebar_tree_associate_entry (SidebarTree* self,
                                   GtkTreeIter* assoc_iter,
                                   SidebarEntry* entry);
static SidebarTreeEntryWrapper* sidebar_tree_entry_wrapper_new (GtkTreeModel* model,
                                                         SidebarEntry* entry,
                                                         GtkTreePath* path);
static SidebarTreeEntryWrapper* sidebar_tree_entry_wrapper_construct (GType object_type,
                                                               GtkTreeModel* model,
                                                               SidebarEntry* entry,
                                                               GtkTreePath* path);
static void sidebar_tree_on_entry_changed (SidebarTree* self,
                                    SidebarEntry* entry);
static void _sidebar_tree_on_entry_changed_sidebar_entry_entry_changed (SidebarEntry* _sender,
                                                                 gpointer self);
VALA_EXTERN void sidebar_entry_grafted (SidebarEntry* self,
                            SidebarTree* tree);
static SidebarTreeEntryWrapper* sidebar_tree_reparent_wrapper (SidebarTree* self,
                                                        GtkTreeIter* new_iter,
                                                        SidebarTreeEntryWrapper* current_wrapper);
static void sidebar_tree_disassociate_branch (SidebarTree* self,
                                       SidebarBranch* branch);
static void sidebar_tree_disassociate_wrapper_and_signal (SidebarTree* self,
                                                   SidebarTreeEntryWrapper* wrapper,
                                                   gboolean only_children);
static void sidebar_tree_disassociate_wrapper (SidebarTree* self,
                                        SidebarTreeEntryWrapper* wrapper,
                                        gboolean only_children);
static void sidebar_tree_entry_wrapper_get_iter (SidebarTreeEntryWrapper* self,
                                          GtkTreeIter* result);
VALA_EXTERN void sidebar_entry_pruned (SidebarEntry* self,
                           SidebarTree* tree);
static GtkTreePath* sidebar_tree_get_current_path (SidebarTree* self);
static GtkTreePath* sidebar_tree_get_path_from_event (SidebarTree* self,
                                               GdkEventButton* event);
static gboolean sidebar_tree_popup_context_menu (SidebarTree* self,
                                          GtkTreePath* path,
                                          GdkEventButton* event);
static gboolean sidebar_tree_popup_default_context_menu (SidebarTree* self,
                                                  GdkEventButton* event);
static gboolean sidebar_tree_real_button_press_event (GtkWidget* base,
                                               GdkEventButton* event);
static gboolean sidebar_tree_real_key_press_event (GtkWidget* base,
                                            GdkEventKey* event);
static gboolean sidebar_tree_rename_in_place (SidebarTree* self);
static gboolean sidebar_tree_destroy_path (SidebarTree* self,
                                    GtkTreePath* path);
static gboolean sidebar_tree_can_rename_path (SidebarTree* self,
                                       GtkTreePath* path);
static void sidebar_tree_real_drag_data_get (GtkWidget* base,
                                      GdkDragContext* context,
                                      GtkSelectionData* selection_data,
                                      guint info,
                                      guint time);
static void sidebar_tree_real_drag_data_received (GtkWidget* base,
                                           GdkDragContext* context,
                                           gint x,
                                           gint y,
                                           GtkSelectionData* selection_data,
                                           guint info,
                                           guint time);
static gboolean sidebar_tree_real_drag_motion (GtkWidget* base,
                                        GdkDragContext* context,
                                        gint x,
                                        gint y,
                                        guint time);
static void sidebar_tree_on_editing_done (SidebarTree* self);
static void _sidebar_tree_on_editing_done_gtk_cell_editable_editing_done (GtkCellEditable* _sender,
                                                                   gpointer self);
static gboolean sidebar_tree_on_editing_focus_out (SidebarTree* self,
                                            GdkEventFocus* event);
static gboolean _sidebar_tree_on_editing_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                        GdkEventFocus* event,
                                                                        gpointer self);
static void sidebar_tree_entry_wrapper_finalize (GObject * obj);
static GType sidebar_tree_entry_wrapper_get_type_once (void);
static void sidebar_tree_root_wrapper_finalize (GObject * obj);
static GType sidebar_tree_root_wrapper_get_type_once (void);
static void sidebar_tree_finalize (GObject * obj);
static GType sidebar_tree_get_type_once (void);

static inline gpointer
sidebar_tree_get_instance_private (SidebarTree* self)
{
	return G_STRUCT_MEMBER_P (self, SidebarTree_private_offset);
}

static void
_sidebar_tree_on_editing_canceled_gtk_cell_renderer_editing_canceled (GtkCellRenderer* _sender,
                                                                      gpointer self)
{
	sidebar_tree_on_editing_canceled ((SidebarTree*) self);
}

static void
_sidebar_tree_on_editing_started_gtk_cell_renderer_editing_started (GtkCellRenderer* _sender,
                                                                    GtkCellEditable* editable,
                                                                    const gchar* path,
                                                                    gpointer self)
{
	sidebar_tree_on_editing_started ((SidebarTree*) self, editable, path);
}

static GType
sidebar_tree_columns_get_type_once (void)
{
	static const GEnumValue values[] = {{SIDEBAR_TREE_COLUMNS_NAME, "SIDEBAR_TREE_COLUMNS_NAME", "name"}, {SIDEBAR_TREE_COLUMNS_TOOLTIP, "SIDEBAR_TREE_COLUMNS_TOOLTIP", "tooltip"}, {SIDEBAR_TREE_COLUMNS_WRAPPER, "SIDEBAR_TREE_COLUMNS_WRAPPER", "wrapper"}, {SIDEBAR_TREE_COLUMNS_ICON, "SIDEBAR_TREE_COLUMNS_ICON", "icon"}, {SIDEBAR_TREE_COLUMNS_COUNTER, "SIDEBAR_TREE_COLUMNS_COUNTER", "counter"}, {SIDEBAR_TREE_COLUMNS_N_COLUMNS, "SIDEBAR_TREE_COLUMNS_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
	GType sidebar_tree_columns_type_id;
	sidebar_tree_columns_type_id = g_enum_register_static ("SidebarTreeColumns", values);
	return sidebar_tree_columns_type_id;
}

static GType
sidebar_tree_columns_get_type (void)
{
	static volatile gsize sidebar_tree_columns_type_id__once = 0;
	if (g_once_init_enter (&sidebar_tree_columns_type_id__once)) {
		GType sidebar_tree_columns_type_id;
		sidebar_tree_columns_type_id = sidebar_tree_columns_get_type_once ();
		g_once_init_leave (&sidebar_tree_columns_type_id__once, sidebar_tree_columns_type_id);
	}
	return sidebar_tree_columns_type_id__once;
}

static void
_vala_GtkTreeRowReference_free (GtkTreeRowReference* self)
{
	g_boxed_free (gtk_tree_row_reference_get_type (), self);
}

static void
g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_BOOLEAN) (gpointer data1, gpointer arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_sidebar_tree_icon_renderer_function_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                GtkCellRenderer* cell,
                                                                GtkTreeModel* tree_model,
                                                                GtkTreeIter* iter,
                                                                gpointer self)
{
	sidebar_tree_icon_renderer_function ((SidebarTree*) self, cell_layout, cell, tree_model, iter);
}

static void
_sidebar_tree_counter_renderer_function_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                   GtkCellRenderer* cell,
                                                                   GtkTreeModel* tree_model,
                                                                   GtkTreeIter* iter,
                                                                   gpointer self)
{
	sidebar_tree_counter_renderer_function ((SidebarTree*) self, cell_layout, cell, tree_model, iter);
}

static gboolean
_sidebar_tree_on_selection_gtk_tree_selection_func (GtkTreeSelection* selection,
                                                    GtkTreeModel* model,
                                                    GtkTreePath* path,
                                                    gboolean path_currently_selected,
                                                    gpointer self)
{
	gboolean result;
	result = sidebar_tree_on_selection ((SidebarTree*) self, selection, model, path, path_currently_selected);
	return result;
}

static gboolean
_sidebar_tree_on_context_menu_keypress_gtk_widget_popup_menu (GtkWidget* _sender,
                                                              gpointer self)
{
	gboolean result;
	result = sidebar_tree_on_context_menu_keypress ((SidebarTree*) self);
	return result;
}

static void
_sidebar_tree_on_drag_begin_gtk_widget_drag_begin (GtkWidget* _sender,
                                                   GdkDragContext* context,
                                                   gpointer self)
{
	sidebar_tree_on_drag_begin ((SidebarTree*) self, context);
}

static void
_sidebar_tree_on_drag_end_gtk_widget_drag_end (GtkWidget* _sender,
                                               GdkDragContext* context,
                                               gpointer self)
{
	sidebar_tree_on_drag_end ((SidebarTree*) self, context);
}

static gboolean
_sidebar_tree_on_drag_motion_gtk_widget_drag_motion (GtkWidget* _sender,
                                                     GdkDragContext* context,
                                                     gint x,
                                                     gint y,
                                                     guint time_,
                                                     gpointer self)
{
	gboolean result;
	result = sidebar_tree_on_drag_motion ((SidebarTree*) self, context, x, y, time_);
	return result;
}

SidebarTree*
sidebar_tree_construct (GType object_type,
                        GtkTargetEntry* target_entries,
                        gint target_entries_length1,
                        GdkDragAction actions,
                        SidebarTreeExternalDropHandler drop_handler,
                        gpointer drop_handler_target,
                        GtkIconTheme* theme)
{
	SidebarTree * self = NULL;
	GtkTreeStore* _tmp0_;
	GtkIconTheme* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkTreeViewColumn* _tmp3_;
	GtkTreeViewColumn* _tmp4_;
	GtkCellRendererPixbuf* icon_renderer = NULL;
	GtkCellRendererPixbuf* _tmp5_;
	GtkTreeViewColumn* _tmp6_;
	GtkTreeViewColumn* _tmp7_;
	GtkTreeViewColumn* _tmp8_;
	GtkCellRendererText* _tmp9_;
	GtkCellRendererText* _tmp10_;
	GtkCellRendererText* _tmp11_;
	GtkCellRendererText* _tmp12_;
	GtkTreeViewColumn* _tmp13_;
	GtkCellRendererText* _tmp14_;
	GtkTreeViewColumn* _tmp15_;
	GtkCellRendererText* _tmp16_;
	GtkTreeViewColumn* _tmp17_;
	GtkTreeViewColumn* end_column = NULL;
	GtkTreeViewColumn* _tmp18_;
	SidebarCountCellRenderer* unread_renderer = NULL;
	SidebarCountCellRenderer* _tmp19_;
	GtkTreeSelection* selection = NULL;
	GtkTreeSelection* _tmp20_;
	GtkTreeSelection* _tmp21_;
	g_return_val_if_fail ((theme == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (theme, gtk_icon_theme_get_type ()), NULL);
	self = (SidebarTree*) g_object_new (object_type, NULL);
	_tmp0_ = self->priv->store;
	gtk_tree_view_set_model (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_tree_model_get_type (), GtkTreeModel));
	_tmp1_ = _g_object_ref0 (theme);
	_g_object_unref0 (self->priv->icon_theme);
	self->priv->icon_theme = _tmp1_;
	_tmp2_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp2_, "sidebar");
	_tmp3_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->text_column);
	self->priv->text_column = _tmp3_;
	_tmp4_ = self->priv->text_column;
	gtk_tree_view_column_set_expand (_tmp4_, TRUE);
	_tmp5_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp5_);
	icon_renderer = _tmp5_;
	_tmp6_ = self->priv->text_column;
	gtk_cell_layout_pack_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_cell_layout_get_type (), GtkCellLayout), G_TYPE_CHECK_INSTANCE_CAST (icon_renderer, gtk_cell_renderer_get_type (), GtkCellRenderer), FALSE);
	_tmp7_ = self->priv->text_column;
	gtk_cell_layout_add_attribute (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_cell_layout_get_type (), GtkCellLayout), G_TYPE_CHECK_INSTANCE_CAST (icon_renderer, gtk_cell_renderer_get_type (), GtkCellRenderer), "icon_name", (gint) SIDEBAR_TREE_COLUMNS_ICON);
	_tmp8_ = self->priv->text_column;
	gtk_cell_layout_set_cell_data_func (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_cell_layout_get_type (), GtkCellLayout), G_TYPE_CHECK_INSTANCE_CAST (icon_renderer, gtk_cell_renderer_get_type (), GtkCellRenderer), _sidebar_tree_icon_renderer_function_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp9_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->text_renderer);
	self->priv->text_renderer = _tmp9_;
	_tmp10_ = self->priv->text_renderer;
	g_object_set (_tmp10_, "ellipsize", PANGO_ELLIPSIZE_END, NULL);
	_tmp11_ = self->priv->text_renderer;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_cell_renderer_get_type (), GtkCellRenderer), "editing-canceled", (GCallback) _sidebar_tree_on_editing_canceled_gtk_cell_renderer_editing_canceled, self, 0);
	_tmp12_ = self->priv->text_renderer;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_cell_renderer_get_type (), GtkCellRenderer), "editing-started", (GCallback) _sidebar_tree_on_editing_started_gtk_cell_renderer_editing_started, self, 0);
	_tmp13_ = self->priv->text_column;
	_tmp14_ = self->priv->text_renderer;
	gtk_cell_layout_pack_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_cell_layout_get_type (), GtkCellLayout), G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_cell_renderer_get_type (), GtkCellRenderer), TRUE);
	_tmp15_ = self->priv->text_column;
	_tmp16_ = self->priv->text_renderer;
	gtk_cell_layout_add_attribute (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_cell_layout_get_type (), GtkCellLayout), G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_cell_renderer_get_type (), GtkCellRenderer), "markup", (gint) SIDEBAR_TREE_COLUMNS_NAME);
	_tmp17_ = self->priv->text_column;
	gtk_tree_view_append_column (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), _tmp17_);
	_tmp18_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp18_);
	end_column = _tmp18_;
	_tmp19_ = sidebar_count_cell_renderer_new ();
	g_object_ref_sink (_tmp19_);
	unread_renderer = _tmp19_;
	gtk_cell_layout_set_cell_data_func (G_TYPE_CHECK_INSTANCE_CAST (end_column, gtk_cell_layout_get_type (), GtkCellLayout), G_TYPE_CHECK_INSTANCE_CAST (unread_renderer, gtk_cell_renderer_get_type (), GtkCellRenderer), _sidebar_tree_counter_renderer_function_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	gtk_cell_layout_pack_start (G_TYPE_CHECK_INSTANCE_CAST (end_column, gtk_cell_layout_get_type (), GtkCellLayout), G_TYPE_CHECK_INSTANCE_CAST (unread_renderer, gtk_cell_renderer_get_type (), GtkCellRenderer), FALSE);
	gtk_cell_layout_add_attribute (G_TYPE_CHECK_INSTANCE_CAST (end_column, gtk_cell_layout_get_type (), GtkCellLayout), G_TYPE_CHECK_INSTANCE_CAST (unread_renderer, gtk_cell_renderer_get_type (), GtkCellRenderer), "counter", (gint) SIDEBAR_TREE_COLUMNS_COUNTER);
	gtk_tree_view_append_column (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), end_column);
	gtk_tree_view_set_headers_visible (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), FALSE);
	gtk_tree_view_set_enable_search (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), FALSE);
	gtk_tree_view_set_reorderable (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), FALSE);
	gtk_tree_view_set_enable_tree_lines (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), FALSE);
	gtk_tree_view_set_grid_lines (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), GTK_TREE_VIEW_GRID_LINES_NONE);
	gtk_tree_view_set_tooltip_column (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), (gint) SIDEBAR_TREE_COLUMNS_TOOLTIP);
	_tmp20_ = gtk_tree_view_get_selection (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView));
	_tmp21_ = _g_object_ref0 (_tmp20_);
	selection = _tmp21_;
	gtk_tree_selection_set_mode (selection, GTK_SELECTION_BROWSE);
	gtk_tree_selection_set_select_function (selection, _sidebar_tree_on_selection_gtk_tree_selection_func, g_object_ref (self), g_object_unref);
	gtk_tree_view_enable_model_drag_dest (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), target_entries, (gint) target_entries_length1, actions);
	self->priv->drop_handler = drop_handler;
	self->priv->drop_handler_target = drop_handler_target;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "popup-menu", (GCallback) _sidebar_tree_on_context_menu_keypress_gtk_widget_popup_menu, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "drag-begin", (GCallback) _sidebar_tree_on_drag_begin_gtk_widget_drag_begin, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "drag-end", (GCallback) _sidebar_tree_on_drag_end_gtk_widget_drag_end, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "drag-motion", (GCallback) _sidebar_tree_on_drag_motion_gtk_widget_drag_motion, self, 0);
	_g_object_unref0 (selection);
	_g_object_unref0 (unread_renderer);
	_g_object_unref0 (end_column);
	_g_object_unref0 (icon_renderer);
	return self;
}

SidebarTree*
sidebar_tree_new (GtkTargetEntry* target_entries,
                  gint target_entries_length1,
                  GdkDragAction actions,
                  SidebarTreeExternalDropHandler drop_handler,
                  gpointer drop_handler_target,
                  GtkIconTheme* theme)
{
	return sidebar_tree_construct (SIDEBAR_TYPE_TREE, target_entries, target_entries_length1, actions, drop_handler, drop_handler_target, theme);
}

void
sidebar_tree_icon_renderer_function (SidebarTree* self,
                                     GtkCellLayout* layout,
                                     GtkCellRenderer* renderer,
                                     GtkTreeModel* model,
                                     GtkTreeIter* iter)
{
	SidebarTreeEntryWrapper* wrapper = NULL;
	GtkTreeIter _tmp0_;
	SidebarTreeEntryWrapper* _tmp1_;
	SidebarTreeEntryWrapper* _tmp2_;
	SidebarTreeEntryWrapper* _tmp3_;
	SidebarEntry* _tmp4_;
	g_return_if_fail (SIDEBAR_IS_TREE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (layout, gtk_cell_layout_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (renderer, gtk_cell_renderer_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (model, gtk_tree_model_get_type ()));
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	_tmp1_ = sidebar_tree_get_wrapper_at_iter (self, &_tmp0_);
	wrapper = _tmp1_;
	_tmp2_ = wrapper;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (wrapper);
		return;
	}
	_tmp3_ = wrapper;
	_tmp4_ = _tmp3_->entry;
	gtk_cell_renderer_set_visible (renderer, !SIDEBAR_IS_HEADER (_tmp4_));
	_g_object_unref0 (wrapper);
}

void
sidebar_tree_counter_renderer_function (SidebarTree* self,
                                        GtkCellLayout* layout,
                                        GtkCellRenderer* renderer,
                                        GtkTreeModel* model,
                                        GtkTreeIter* iter)
{
	SidebarTreeEntryWrapper* wrapper = NULL;
	GtkTreeIter _tmp0_;
	SidebarTreeEntryWrapper* _tmp1_;
	SidebarTreeEntryWrapper* _tmp2_;
	SidebarCountCellRenderer* counter_renderer = NULL;
	SidebarCountCellRenderer* _tmp3_;
	gboolean _tmp4_ = FALSE;
	SidebarCountCellRenderer* _tmp5_;
	g_return_if_fail (SIDEBAR_IS_TREE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (layout, gtk_cell_layout_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (renderer, gtk_cell_renderer_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (model, gtk_tree_model_get_type ()));
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	_tmp1_ = sidebar_tree_get_wrapper_at_iter (self, &_tmp0_);
	wrapper = _tmp1_;
	_tmp2_ = wrapper;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (wrapper);
		return;
	}
	_tmp3_ = _g_object_ref0 (IS_SIDEBAR_COUNT_CELL_RENDERER (renderer) ? ((SidebarCountCellRenderer*) renderer) : NULL);
	counter_renderer = _tmp3_;
	_tmp5_ = counter_renderer;
	if (_tmp5_ != NULL) {
		SidebarCountCellRenderer* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = counter_renderer;
		_tmp7_ = sidebar_count_cell_renderer_get_counter (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_ > 0;
	} else {
		_tmp4_ = FALSE;
	}
	gtk_cell_renderer_set_visible (renderer, _tmp4_);
	_g_object_unref0 (counter_renderer);
	_g_object_unref0 (wrapper);
}

static void
sidebar_tree_on_drag_begin (SidebarTree* self,
                            GdkDragContext* ctx)
{
	g_return_if_fail (SIDEBAR_IS_TREE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (ctx, gdk_drag_context_get_type ()));
	self->priv->is_internal_drag_in_progress = TRUE;
}

static void
sidebar_tree_on_drag_end (SidebarTree* self,
                          GdkDragContext* ctx)
{
	g_return_if_fail (SIDEBAR_IS_TREE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (ctx, gdk_drag_context_get_type ()));
	self->priv->is_internal_drag_in_progress = FALSE;
	_g_object_unref0 (self->priv->internal_drag_source_entry);
	self->priv->internal_drag_source_entry = NULL;
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

static gboolean
sidebar_tree_on_drag_motion (SidebarTree* self,
                             GdkDragContext* context,
                             gint x,
                             gint y,
                             guint time_)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (SIDEBAR_IS_TREE (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (context, gdk_drag_context_get_type ()), FALSE);
	if (self->priv->is_internal_drag_in_progress) {
		SidebarEntry* _tmp1_;
		_tmp1_ = self->priv->internal_drag_source_entry;
		_tmp0_ = _tmp1_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkTreePath* path = NULL;
		GtkTreeViewDropPosition position = 0;
		GtkTreePath* _tmp2_ = NULL;
		GtkTreeViewDropPosition _tmp3_ = 0;
		GtkTreePath* _tmp4_;
		gtk_tree_view_get_dest_row_at_pos (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), x, y, &_tmp2_, &_tmp3_);
		__vala_GtkTreePath_free0 (path);
		path = _tmp2_;
		position = _tmp3_;
		_tmp4_ = path;
		if (_tmp4_ != NULL) {
			SidebarTreeEntryWrapper* wrapper = NULL;
			GtkTreePath* _tmp5_;
			SidebarTreeEntryWrapper* _tmp6_;
			SidebarTreeEntryWrapper* _tmp7_;
			_tmp5_ = path;
			_tmp6_ = sidebar_tree_get_wrapper_at_path (self, _tmp5_);
			wrapper = _tmp6_;
			_tmp7_ = wrapper;
			if (_tmp7_ != NULL) {
				SidebarTreeEntryWrapper* _tmp8_;
				SidebarEntry* _tmp9_;
				SidebarEntry* _tmp10_;
				_tmp8_ = wrapper;
				_tmp9_ = _tmp8_->entry;
				_tmp10_ = _g_object_ref0 (_tmp9_);
				_g_object_unref0 (self->priv->internal_drag_source_entry);
				self->priv->internal_drag_source_entry = _tmp10_;
			}
			_g_object_unref0 (wrapper);
		}
		__vala_GtkTreePath_free0 (path);
	}
	result = FALSE;
	return result;
}

static gboolean
sidebar_tree_has_wrapper (SidebarTree* self,
                          SidebarEntry* entry)
{
	GeeHashMap* _tmp0_;
	gboolean result;
	g_return_val_if_fail (SIDEBAR_IS_TREE (self), FALSE);
	g_return_val_if_fail (SIDEBAR_IS_ENTRY (entry), FALSE);
	_tmp0_ = self->priv->entry_map;
	result = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), entry);
	return result;
}

static SidebarTreeEntryWrapper*
sidebar_tree_get_wrapper (SidebarTree* self,
                          SidebarEntry* entry)
{
	SidebarTreeEntryWrapper* wrapper = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	SidebarTreeEntryWrapper* _tmp2_;
	SidebarTreeEntryWrapper* result;
	g_return_val_if_fail (SIDEBAR_IS_TREE (self), NULL);
	g_return_val_if_fail (SIDEBAR_IS_ENTRY (entry), NULL);
	_tmp0_ = self->priv->entry_map;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), entry);
	wrapper = (SidebarTreeEntryWrapper*) _tmp1_;
	_tmp2_ = wrapper;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = sidebar_entry_to_string (entry);
		_tmp4_ = _tmp3_;
		g_debug ("sidebar-tree.vala:207: Entry %s not found in sidebar", _tmp4_);
		_g_free0 (_tmp4_);
	}
	result = wrapper;
	return result;
}

static SidebarTreeEntryWrapper*
sidebar_tree_get_wrapper_at_iter (SidebarTree* self,
                                  GtkTreeIter* iter)
{
	GValue val = {0};
	GtkTreeStore* _tmp0_;
	GtkTreeIter _tmp1_;
	GValue _tmp2_ = {0};
	SidebarTreeEntryWrapper* wrapper = NULL;
	GValue _tmp3_;
	SidebarTreeEntryWrapper* _tmp4_;
	SidebarTreeEntryWrapper* _tmp5_;
	SidebarTreeEntryWrapper* result;
	g_return_val_if_fail (SIDEBAR_IS_TREE (self), NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = self->priv->store;
	_tmp1_ = *iter;
	gtk_tree_model_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_tree_model_get_type (), GtkTreeModel), &_tmp1_, (gint) SIDEBAR_TREE_COLUMNS_WRAPPER, &_tmp2_);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	val = _tmp2_;
	_tmp3_ = val;
	_tmp4_ = _g_object_ref0 (g_value_get_object (&_tmp3_));
	wrapper = _tmp4_;
	_tmp5_ = wrapper;
	if (_tmp5_ == NULL) {
		GtkTreeStore* _tmp6_;
		GtkTreeIter _tmp7_;
		GtkTreePath* _tmp8_;
		GtkTreePath* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp6_ = self->priv->store;
		_tmp7_ = *iter;
		_tmp8_ = gtk_tree_model_get_path (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_tree_model_get_type (), GtkTreeModel), &_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = gtk_tree_path_to_string (_tmp9_);
		_tmp11_ = _tmp10_;
		g_message ("sidebar-tree.vala:218: No entry found in sidebar at %s", _tmp11_);
		_g_free0 (_tmp11_);
		__vala_GtkTreePath_free0 (_tmp9_);
	}
	result = wrapper;
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	return result;
}

static SidebarTreeEntryWrapper*
sidebar_tree_get_wrapper_at_path (SidebarTree* self,
                                  GtkTreePath* path)
{
	GtkTreeIter iter = {0};
	GtkTreeStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	GtkTreeIter _tmp5_;
	SidebarTreeEntryWrapper* _tmp6_;
	SidebarTreeEntryWrapper* result;
	g_return_val_if_fail (SIDEBAR_IS_TREE (self), NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = self->priv->store;
	_tmp2_ = gtk_tree_model_get_iter (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_tree_model_get_type (), GtkTreeModel), &_tmp1_, path);
	iter = _tmp1_;
	if (!_tmp2_) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = gtk_tree_path_to_string (path);
		_tmp4_ = _tmp3_;
		g_message ("sidebar-tree.vala:226: No entry found in sidebar at %s", _tmp4_);
		_g_free0 (_tmp4_);
		result = NULL;
		return result;
	}
	_tmp5_ = iter;
	_tmp6_ = sidebar_tree_get_wrapper_at_iter (self, &_tmp5_);
	result = _tmp6_;
	return result;
}

void
sidebar_tree_set_default_context_menu (SidebarTree* self,
                                       GtkMenu* context_menu)
{
	GtkMenu* _tmp0_;
	g_return_if_fail (SIDEBAR_IS_TREE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (context_menu, gtk_menu_get_type ()));
	_tmp0_ = _g_object_ref0 (context_menu);
	_g_object_unref0 (self->priv->default_context_menu);
	self->priv->default_context_menu = _tmp0_;
}

gboolean
sidebar_tree_place_cursor (SidebarTree* self,
                           SidebarEntry* entry,
                           gboolean mask_signal)
{
	SidebarTreeEntryWrapper* wrapper = NULL;
	SidebarTreeEntryWrapper* _tmp0_;
	SidebarTreeEntryWrapper* _tmp1_;
	GtkTreeSelection* _tmp2_;
	SidebarTreeEntryWrapper* _tmp3_;
	GtkTreePath* _tmp4_;
	GtkTreePath* _tmp5_;
	SidebarTreeEntryWrapper* _tmp6_;
	GtkTreePath* _tmp7_;
	GtkTreePath* _tmp8_;
	gboolean result;
	g_return_val_if_fail (SIDEBAR_IS_TREE (self), FALSE);
	g_return_val_if_fail (SIDEBAR_IS_ENTRY (entry), FALSE);
	if (!sidebar_tree_expand_to_entry (self, entry)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = sidebar_tree_get_wrapper (self, entry);
	wrapper = _tmp0_;
	_tmp1_ = wrapper;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_object_unref0 (wrapper);
		return result;
	}
	_tmp2_ = gtk_tree_view_get_selection (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView));
	_tmp3_ = wrapper;
	_tmp4_ = sidebar_tree_entry_wrapper_get_path (_tmp3_);
	_tmp5_ = _tmp4_;
	gtk_tree_selection_select_path (_tmp2_, _tmp5_);
	__vala_GtkTreePath_free0 (_tmp5_);
	self->priv->mask_entry_selected_signal = mask_signal;
	_tmp6_ = wrapper;
	_tmp7_ = sidebar_tree_entry_wrapper_get_path (_tmp6_);
	_tmp8_ = _tmp7_;
	gtk_tree_view_set_cursor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), _tmp8_, NULL, FALSE);
	__vala_GtkTreePath_free0 (_tmp8_);
	self->priv->mask_entry_selected_signal = FALSE;
	result = sidebar_tree_scroll_to_entry (self, entry);
	_g_object_unref0 (wrapper);
	return result;
}

gboolean
sidebar_tree_is_selected (SidebarTree* self,
                          SidebarEntry* entry)
{
	SidebarTreeEntryWrapper* wrapper = NULL;
	SidebarTreeEntryWrapper* _tmp0_;
	GtkTreeSelection* selection = NULL;
	GtkTreeSelection* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GtkTreeSelection* _tmp3_;
	gboolean _tmp4_ = FALSE;
	SidebarTreeEntryWrapper* _tmp5_;
	gboolean result;
	g_return_val_if_fail (SIDEBAR_IS_TREE (self), FALSE);
	g_return_val_if_fail (SIDEBAR_IS_ENTRY (entry), FALSE);
	_tmp0_ = sidebar_tree_get_wrapper (self, entry);
	wrapper = _tmp0_;
	_tmp1_ = gtk_tree_view_get_selection (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView));
	_tmp2_ = _g_object_ref0 (_tmp1_);
	selection = _tmp2_;
	_tmp3_ = selection;
	if (_tmp3_ == NULL) {
		result = FALSE;
		_g_object_unref0 (selection);
		_g_object_unref0 (wrapper);
		return result;
	}
	_tmp5_ = wrapper;
	if (_tmp5_ != NULL) {
		GtkTreeSelection* _tmp6_;
		SidebarTreeEntryWrapper* _tmp7_;
		GtkTreePath* _tmp8_;
		GtkTreePath* _tmp9_;
		_tmp6_ = selection;
		_tmp7_ = wrapper;
		_tmp8_ = sidebar_tree_entry_wrapper_get_path (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp4_ = gtk_tree_selection_path_is_selected (_tmp6_, _tmp9_);
		__vala_GtkTreePath_free0 (_tmp9_);
	} else {
		_tmp4_ = FALSE;
	}
	result = _tmp4_;
	_g_object_unref0 (selection);
	_g_object_unref0 (wrapper);
	return result;
}

gboolean
sidebar_tree_is_any_selected (SidebarTree* self)
{
	GtkTreeSelection* _tmp0_;
	gboolean result;
	g_return_val_if_fail (SIDEBAR_IS_TREE (self), FALSE);
	_tmp0_ = gtk_tree_view_get_selection (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView));
	result = gtk_tree_selection_count_selected_rows (_tmp0_) != 0;
	return result;
}

static GtkTreePath*
_vala_GtkTreePath_copy (GtkTreePath* self)
{
	return g_boxed_copy (gtk_tree_path_get_type (), self);
}

static gpointer
__vala_GtkTreePath_copy0 (gpointer self)
{
	return self ? _vala_GtkTreePath_copy (self) : NULL;
}

static void
__vala_GtkTreePath_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL));
}

static inline void
_g_list_free___vala_GtkTreePath_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) __vala_GtkTreePath_free0_);
}

static GtkTreePath*
sidebar_tree_get_selected_path (SidebarTree* self)
{
	GtkTreeModel* model = NULL;
	GtkTreeSelection* selection = NULL;
	GtkTreeSelection* _tmp0_;
	GtkTreeSelection* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GList* rows = NULL;
	GtkTreeSelection* _tmp3_;
	GtkTreeModel* _tmp4_ = NULL;
	GList* _tmp5_;
	GtkTreeModel* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GList* _tmp8_;
	GtkTreePath* _tmp10_ = NULL;
	GList* _tmp11_;
	GtkTreePath* _tmp14_;
	GtkTreePath* result;
	g_return_val_if_fail (SIDEBAR_IS_TREE (self), NULL);
	_tmp0_ = gtk_tree_view_get_selection (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView));
	_tmp1_ = _g_object_ref0 (_tmp0_);
	selection = _tmp1_;
	_tmp2_ = selection;
	if (_tmp2_ == NULL) {
		result = NULL;
		_g_object_unref0 (selection);
		_g_object_unref0 (model);
		return result;
	}
	_tmp3_ = selection;
	_tmp5_ = gtk_tree_selection_get_selected_rows (_tmp3_, &_tmp4_);
	_g_object_unref0 (model);
	_tmp6_ = _g_object_ref0 (_tmp4_);
	model = _tmp6_;
	rows = _tmp5_;
	_tmp8_ = rows;
	if (g_list_length (_tmp8_) == ((guint) 0)) {
		_tmp7_ = TRUE;
	} else {
		GList* _tmp9_;
		_tmp9_ = rows;
		_tmp7_ = g_list_length (_tmp9_) == ((guint) 1);
	}
	_vala_assert (_tmp7_, "rows.length() == 0 || rows.length() == 1");
	_tmp11_ = rows;
	if (g_list_length (_tmp11_) != ((guint) 0)) {
		GList* _tmp12_;
		gconstpointer _tmp13_;
		_tmp12_ = rows;
		_tmp13_ = g_list_nth_data (_tmp12_, (guint) 0);
		_tmp10_ = (GtkTreePath*) _tmp13_;
	} else {
		_tmp10_ = NULL;
	}
	_tmp14_ = __vala_GtkTreePath_copy0 (_tmp10_);
	result = _tmp14_;
	(rows == NULL) ? NULL : (rows = (_g_list_free___vala_GtkTreePath_free0_ (rows), NULL));
	_g_object_unref0 (selection);
	_g_object_unref0 (model);
	return result;
}

static gchar*
sidebar_tree_get_name_for_entry (SidebarTree* self,
                                 SidebarEntry* entry)
{
	gchar* name = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	SidebarEmphasizableEntry* emphasizable_entry = NULL;
	SidebarEmphasizableEntry* _tmp4_;
	gboolean _tmp5_ = FALSE;
	SidebarEmphasizableEntry* _tmp6_;
	gchar* result;
	g_return_val_if_fail (SIDEBAR_IS_TREE (self), NULL);
	g_return_val_if_fail (SIDEBAR_IS_ENTRY (entry), NULL);
	_tmp0_ = sidebar_entry_get_sidebar_name (entry);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_html_escape_markup (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	name = _tmp3_;
	_tmp4_ = _g_object_ref0 (SIDEBAR_IS_EMPHASIZABLE_ENTRY (entry) ? ((SidebarEmphasizableEntry*) entry) : NULL);
	emphasizable_entry = _tmp4_;
	_tmp6_ = emphasizable_entry;
	if (_tmp6_ != NULL) {
		SidebarEmphasizableEntry* _tmp7_;
		_tmp7_ = emphasizable_entry;
		_tmp5_ = sidebar_emphasizable_entry_is_emphasized (_tmp7_);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = name;
		_tmp9_ = g_strdup_printf ("<b>%s</b>", _tmp8_);
		_g_free0 (name);
		name = _tmp9_;
	}
	result = name;
	_g_object_unref0 (emphasizable_entry);
	return result;
}

static gboolean
sidebar_tree_real_accept_cursor_changed (SidebarTree* self)
{
	gboolean result;
	result = TRUE;
	return result;
}

gboolean
sidebar_tree_accept_cursor_changed (SidebarTree* self)
{
	SidebarTreeClass* _klass_;
	g_return_val_if_fail (SIDEBAR_IS_TREE (self), FALSE);
	_klass_ = SIDEBAR_TREE_GET_CLASS (self);
	if (_klass_->accept_cursor_changed) {
		return _klass_->accept_cursor_changed (self);
	}
	return FALSE;
}

static void
sidebar_tree_real_row_activated (GtkTreeView* base,
                                 GtkTreePath* path,
                                 GtkTreeViewColumn* column)
{
	SidebarTree * self;
	GtkTreeViewColumn* _tmp0_;
	SidebarTreeEntryWrapper* wrapper = NULL;
	SidebarTreeEntryWrapper* _tmp1_;
	SidebarTreeEntryWrapper* _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SIDEBAR_TYPE_TREE, SidebarTree);
	g_return_if_fail (path != NULL);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (column, gtk_tree_view_column_get_type ()));
	_tmp0_ = self->priv->text_column;
	if (column != _tmp0_) {
		return;
	}
	_tmp1_ = sidebar_tree_get_wrapper_at_path (self, path);
	wrapper = _tmp1_;
	_tmp2_ = wrapper;
	if (_tmp2_ != NULL) {
		SidebarSelectableEntry* selectable = NULL;
		SidebarTreeEntryWrapper* _tmp3_;
		SidebarEntry* _tmp4_;
		SidebarSelectableEntry* _tmp5_;
		SidebarSelectableEntry* _tmp6_;
		_tmp3_ = wrapper;
		_tmp4_ = _tmp3_->entry;
		_tmp5_ = _g_object_ref0 (SIDEBAR_IS_SELECTABLE_ENTRY (_tmp4_) ? ((SidebarSelectableEntry*) _tmp4_) : NULL);
		selectable = _tmp5_;
		_tmp6_ = selectable;
		if (_tmp6_ != NULL) {
			SidebarSelectableEntry* _tmp7_;
			_tmp7_ = selectable;
			g_signal_emit (self, sidebar_tree_signals[SIDEBAR_TREE_ENTRY_ACTIVATED_SIGNAL], 0, _tmp7_);
		} else {
			sidebar_tree_toggle_branch_expansion (self, path);
		}
		_g_object_unref0 (selectable);
	}
	_g_object_unref0 (wrapper);
}

static void
sidebar_tree_real_cursor_changed (GtkTreeView* base)
{
	SidebarTree * self;
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp0_;
	GtkTreePath* _tmp1_;
	SidebarTreeEntryWrapper* wrapper = NULL;
	GtkTreePath* _tmp2_;
	SidebarTreeEntryWrapper* _tmp3_;
	SidebarTreeEntryWrapper* _tmp4_;
	SidebarTreeEntryWrapper* _tmp5_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SIDEBAR_TYPE_TREE, SidebarTree);
	_tmp0_ = sidebar_tree_get_selected_path (self);
	path = _tmp0_;
	_tmp1_ = path;
	if (_tmp1_ == NULL) {
		if (GTK_TREE_VIEW_CLASS (sidebar_tree_parent_class)->cursor_changed != NULL) {
			GTK_TREE_VIEW_CLASS (sidebar_tree_parent_class)->cursor_changed (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView));
		}
		__vala_GtkTreePath_free0 (path);
		return;
	}
	_tmp2_ = path;
	_tmp3_ = sidebar_tree_get_wrapper_at_path (self, _tmp2_);
	wrapper = _tmp3_;
	_tmp4_ = self->priv->selected_wrapper;
	_tmp5_ = wrapper;
	if (_tmp4_ != _tmp5_) {
		SidebarTreeEntryWrapper* old_wrapper = NULL;
		SidebarTreeEntryWrapper* _tmp6_;
		SidebarTreeEntryWrapper* _tmp7_;
		SidebarTreeEntryWrapper* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp17_ = FALSE;
		SidebarTreeEntryWrapper* _tmp18_;
		_tmp6_ = self->priv->selected_wrapper;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		old_wrapper = _tmp7_;
		_tmp8_ = wrapper;
		self->priv->selected_wrapper = _tmp8_;
		if (self->priv->editing_disabled == 0) {
			SidebarTreeEntryWrapper* _tmp11_;
			_tmp11_ = wrapper;
			_tmp10_ = _tmp11_ != NULL;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			SidebarTreeEntryWrapper* _tmp12_;
			SidebarEntry* _tmp13_;
			_tmp12_ = wrapper;
			_tmp13_ = _tmp12_->entry;
			_tmp9_ = SIDEBAR_IS_RENAMEABLE_ENTRY (_tmp13_);
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			GtkCellRendererText* _tmp14_;
			SidebarTreeEntryWrapper* _tmp15_;
			SidebarEntry* _tmp16_;
			_tmp14_ = self->priv->text_renderer;
			_tmp15_ = wrapper;
			_tmp16_ = _tmp15_->entry;
			g_object_set (_tmp14_, "editable", sidebar_renameable_entry_is_user_renameable (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, SIDEBAR_TYPE_RENAMEABLE_ENTRY, SidebarRenameableEntry)), NULL);
		}
		_tmp18_ = wrapper;
		if (_tmp18_ != NULL) {
			_tmp17_ = !self->priv->mask_entry_selected_signal;
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			SidebarSelectableEntry* selectable = NULL;
			SidebarTreeEntryWrapper* _tmp19_;
			SidebarEntry* _tmp20_;
			SidebarSelectableEntry* _tmp21_;
			SidebarSelectableEntry* _tmp22_;
			_tmp19_ = wrapper;
			_tmp20_ = _tmp19_->entry;
			_tmp21_ = _g_object_ref0 (SIDEBAR_IS_SELECTABLE_ENTRY (_tmp20_) ? ((SidebarSelectableEntry*) _tmp20_) : NULL);
			selectable = _tmp21_;
			_tmp22_ = selectable;
			if (_tmp22_ != NULL) {
				if (sidebar_tree_accept_cursor_changed (self)) {
					SidebarSelectableEntry* _tmp23_;
					_tmp23_ = selectable;
					g_signal_emit (self, sidebar_tree_signals[SIDEBAR_TREE_ENTRY_SELECTED_SIGNAL], 0, _tmp23_);
				} else {
					SidebarTreeEntryWrapper* _tmp24_;
					SidebarEntry* _tmp25_;
					_tmp24_ = old_wrapper;
					_tmp25_ = _tmp24_->entry;
					sidebar_tree_place_cursor (self, _tmp25_, TRUE);
				}
			}
			_g_object_unref0 (selectable);
		}
		_g_object_unref0 (old_wrapper);
	}
	if (GTK_TREE_VIEW_CLASS (sidebar_tree_parent_class)->cursor_changed != NULL) {
		GTK_TREE_VIEW_CLASS (sidebar_tree_parent_class)->cursor_changed (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView));
	}
	_g_object_unref0 (wrapper);
	__vala_GtkTreePath_free0 (path);
}

void
sidebar_tree_disable_editing (SidebarTree* self)
{
	gint _tmp0_;
	g_return_if_fail (SIDEBAR_IS_TREE (self));
	_tmp0_ = self->priv->editing_disabled;
	self->priv->editing_disabled = _tmp0_ + 1;
	if (_tmp0_ == 0) {
		GtkCellRendererText* _tmp1_;
		_tmp1_ = self->priv->text_renderer;
		g_object_set (_tmp1_, "editable", FALSE, NULL);
	}
}

void
sidebar_tree_enable_editing (SidebarTree* self)
{
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkTreePath* _tmp3_;
	g_return_if_fail (SIDEBAR_IS_TREE (self));
	_tmp0_ = sidebar_tree_get_selected_path (self);
	path = _tmp0_;
	_tmp3_ = path;
	if (_tmp3_ != NULL) {
		_tmp2_ = self->priv->editing_disabled > 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gint _tmp4_;
		self->priv->editing_disabled = self->priv->editing_disabled - 1;
		_tmp4_ = self->priv->editing_disabled;
		_tmp1_ = _tmp4_ == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		SidebarTreeEntryWrapper* wrapper = NULL;
		GtkTreePath* _tmp5_;
		SidebarTreeEntryWrapper* _tmp6_;
		gboolean _tmp7_ = FALSE;
		SidebarTreeEntryWrapper* _tmp8_;
		_tmp5_ = path;
		_tmp6_ = sidebar_tree_get_wrapper_at_path (self, _tmp5_);
		wrapper = _tmp6_;
		_tmp8_ = wrapper;
		if (_tmp8_ != NULL) {
			SidebarTreeEntryWrapper* _tmp9_;
			SidebarEntry* _tmp10_;
			_tmp9_ = wrapper;
			_tmp10_ = _tmp9_->entry;
			_tmp7_ = SIDEBAR_IS_RENAMEABLE_ENTRY (_tmp10_);
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			GtkCellRendererText* _tmp11_;
			SidebarTreeEntryWrapper* _tmp12_;
			SidebarEntry* _tmp13_;
			_tmp11_ = self->priv->text_renderer;
			_tmp12_ = wrapper;
			_tmp13_ = _tmp12_->entry;
			g_object_set (_tmp11_, "editable", sidebar_renameable_entry_is_user_renameable (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, SIDEBAR_TYPE_RENAMEABLE_ENTRY, SidebarRenameableEntry)), NULL);
		}
		_g_object_unref0 (wrapper);
	}
	__vala_GtkTreePath_free0 (path);
}

static void
sidebar_tree_toggle_branch_expansion (SidebarTree* self,
                                      GtkTreePath* path)
{
	g_return_if_fail (SIDEBAR_IS_TREE (self));
	g_return_if_fail (path != NULL);
	if (gtk_tree_view_row_expanded (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), path)) {
		gtk_tree_view_collapse_row (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), path);
	} else {
		gtk_tree_view_expand_row (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), path, FALSE);
	}
}

gboolean
sidebar_tree_expand_to_entry (SidebarTree* self,
                              SidebarEntry* entry)
{
	SidebarTreeEntryWrapper* wrapper = NULL;
	SidebarTreeEntryWrapper* _tmp0_;
	SidebarTreeEntryWrapper* _tmp1_;
	SidebarTreeEntryWrapper* _tmp2_;
	GtkTreePath* _tmp3_;
	GtkTreePath* _tmp4_;
	gboolean result;
	g_return_val_if_fail (SIDEBAR_IS_TREE (self), FALSE);
	g_return_val_if_fail (SIDEBAR_IS_ENTRY (entry), FALSE);
	_tmp0_ = sidebar_tree_get_wrapper (self, entry);
	wrapper = _tmp0_;
	_tmp1_ = wrapper;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_object_unref0 (wrapper);
		return result;
	}
	_tmp2_ = wrapper;
	_tmp3_ = sidebar_tree_entry_wrapper_get_path (_tmp2_);
	_tmp4_ = _tmp3_;
	gtk_tree_view_expand_to_path (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), _tmp4_);
	__vala_GtkTreePath_free0 (_tmp4_);
	result = TRUE;
	_g_object_unref0 (wrapper);
	return result;
}

void
sidebar_tree_expand_to_first_child (SidebarTree* self,
                                    SidebarEntry* entry)
{
	SidebarTreeEntryWrapper* wrapper = NULL;
	SidebarTreeEntryWrapper* _tmp0_;
	SidebarTreeEntryWrapper* _tmp1_;
	GtkTreePath* path = NULL;
	SidebarTreeEntryWrapper* _tmp2_;
	GtkTreePath* _tmp3_;
	GtkTreeIter iter = {0};
	GtkTreePath* _tmp11_;
	g_return_if_fail (SIDEBAR_IS_TREE (self));
	g_return_if_fail (SIDEBAR_IS_ENTRY (entry));
	_tmp0_ = sidebar_tree_get_wrapper (self, entry);
	wrapper = _tmp0_;
	_tmp1_ = wrapper;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (wrapper);
		return;
	}
	_tmp2_ = wrapper;
	_tmp3_ = sidebar_tree_entry_wrapper_get_path (_tmp2_);
	path = _tmp3_;
	while (TRUE) {
		GtkTreeStore* _tmp4_;
		GtkTreePath* _tmp5_;
		GtkTreeIter _tmp6_ = {0};
		gboolean _tmp7_;
		GtkTreeStore* _tmp8_;
		GtkTreeIter _tmp9_;
		GtkTreePath* _tmp10_;
		_tmp4_ = self->priv->store;
		_tmp5_ = path;
		_tmp7_ = gtk_tree_model_get_iter (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_tree_model_get_type (), GtkTreeModel), &_tmp6_, _tmp5_);
		iter = _tmp6_;
		if (!_tmp7_) {
			break;
		}
		_tmp8_ = self->priv->store;
		_tmp9_ = iter;
		if (!gtk_tree_model_iter_has_child (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_tree_model_get_type (), GtkTreeModel), &_tmp9_)) {
			break;
		}
		_tmp10_ = path;
		gtk_tree_path_down (_tmp10_);
	}
	_tmp11_ = path;
	gtk_tree_view_expand_to_path (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), _tmp11_);
	__vala_GtkTreePath_free0 (path);
	_g_object_unref0 (wrapper);
}

gboolean
sidebar_tree_has_branch (SidebarTree* self,
                         SidebarBranch* branch)
{
	GeeHashMap* _tmp0_;
	gboolean result;
	g_return_val_if_fail (SIDEBAR_IS_TREE (self), FALSE);
	g_return_val_if_fail (SIDEBAR_IS_BRANCH (branch), FALSE);
	_tmp0_ = self->priv->branches;
	result = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), branch);
	return result;
}

static void
_sidebar_tree_on_branch_entry_added_sidebar_branch_entry_added (SidebarBranch* _sender,
                                                                SidebarEntry* entry,
                                                                gpointer self)
{
	sidebar_tree_on_branch_entry_added ((SidebarTree*) self, _sender, entry);
}

static void
_sidebar_tree_on_branch_entry_removed_sidebar_branch_entry_removed (SidebarBranch* _sender,
                                                                    SidebarEntry* entry,
                                                                    gpointer self)
{
	sidebar_tree_on_branch_entry_removed ((SidebarTree*) self, _sender, entry);
}

static void
_sidebar_tree_on_branch_entry_moved_sidebar_branch_entry_moved (SidebarBranch* _sender,
                                                                SidebarEntry* entry,
                                                                gpointer self)
{
	sidebar_tree_on_branch_entry_moved ((SidebarTree*) self, _sender, entry);
}

static void
_sidebar_tree_on_branch_entry_reparented_sidebar_branch_entry_reparented (SidebarBranch* _sender,
                                                                          SidebarEntry* entry,
                                                                          SidebarEntry* old_parent,
                                                                          gpointer self)
{
	sidebar_tree_on_branch_entry_reparented ((SidebarTree*) self, _sender, entry, old_parent);
}

static void
_sidebar_tree_on_branch_children_reordered_sidebar_branch_children_reordered (SidebarBranch* _sender,
                                                                              SidebarEntry* entry,
                                                                              gpointer self)
{
	sidebar_tree_on_branch_children_reordered ((SidebarTree*) self, _sender, entry);
}

static void
_sidebar_tree_on_show_branch_sidebar_branch_show_branch (SidebarBranch* _sender,
                                                         gboolean show,
                                                         gpointer self)
{
	sidebar_tree_on_show_branch ((SidebarTree*) self, _sender, show);
}

void
sidebar_tree_graft (SidebarTree* self,
                    SidebarBranch* branch,
                    gint position)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	g_return_if_fail (SIDEBAR_IS_TREE (self));
	g_return_if_fail (SIDEBAR_IS_BRANCH (branch));
	_tmp0_ = self->priv->branches;
	_vala_assert (!gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), branch), "!branches.has_key(branch)");
	_tmp1_ = self->priv->branches;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), branch, (gpointer) ((gintptr) position));
	if (sidebar_branch_get_show_branch (branch)) {
		sidebar_tree_associate_branch (self, branch);
		if (sidebar_branch_is_startup_expand_to_first_child (branch)) {
			SidebarEntry* _tmp2_;
			SidebarEntry* _tmp3_;
			_tmp2_ = sidebar_branch_get_root (branch);
			_tmp3_ = _tmp2_;
			sidebar_tree_expand_to_first_child (self, _tmp3_);
			_g_object_unref0 (_tmp3_);
		}
		if (sidebar_branch_is_startup_open_grouping (branch)) {
			SidebarEntry* _tmp4_;
			SidebarEntry* _tmp5_;
			_tmp4_ = sidebar_branch_get_root (branch);
			_tmp5_ = _tmp4_;
			sidebar_tree_expand_to_entry (self, _tmp5_);
			_g_object_unref0 (_tmp5_);
		}
	}
	g_signal_connect_object (branch, "entry-added", (GCallback) _sidebar_tree_on_branch_entry_added_sidebar_branch_entry_added, self, 0);
	g_signal_connect_object (branch, "entry-removed", (GCallback) _sidebar_tree_on_branch_entry_removed_sidebar_branch_entry_removed, self, 0);
	g_signal_connect_object (branch, "entry-moved", (GCallback) _sidebar_tree_on_branch_entry_moved_sidebar_branch_entry_moved, self, 0);
	g_signal_connect_object (branch, "entry-reparented", (GCallback) _sidebar_tree_on_branch_entry_reparented_sidebar_branch_entry_reparented, self, 0);
	g_signal_connect_object (branch, "children-reordered", (GCallback) _sidebar_tree_on_branch_children_reordered_sidebar_branch_children_reordered, self, 0);
	g_signal_connect_object (branch, "show-branch", (GCallback) _sidebar_tree_on_show_branch_sidebar_branch_show_branch, self, 0);
	g_signal_emit (self, sidebar_tree_signals[SIDEBAR_TREE_BRANCH_ADDED_SIGNAL], 0, branch);
}

gint
sidebar_tree_get_position_for_branch (SidebarTree* self,
                                      SidebarBranch* branch)
{
	GeeHashMap* _tmp0_;
	gint result;
	g_return_val_if_fail (SIDEBAR_IS_TREE (self), 0);
	g_return_val_if_fail (SIDEBAR_IS_BRANCH (branch), 0);
	_tmp0_ = self->priv->branches;
	if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), branch)) {
		GeeHashMap* _tmp1_;
		gpointer _tmp2_;
		_tmp1_ = self->priv->branches;
		_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), branch);
		result = (gint) ((gintptr) _tmp2_);
		return result;
	}
	result = G_MININT;
	return result;
}

static void
_vala_GtkTreeIter_free (GtkTreeIter* self)
{
	g_boxed_free (gtk_tree_iter_get_type (), self);
}

static GtkTreeIter*
_vala_GtkTreeIter_copy (GtkTreeIter* self)
{
	return g_boxed_copy (gtk_tree_iter_get_type (), self);
}

static gpointer
__vala_GtkTreeIter_copy0 (gpointer self)
{
	return self ? _vala_GtkTreeIter_copy (self) : NULL;
}

static void
sidebar_tree_associate_branch (SidebarTree* self,
                               SidebarBranch* branch)
{
	GeeHashMap* _tmp0_;
	gint position = 0;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	GtkTreeIter* insertion_iter = NULL;
	GtkTreeIter iter = {0};
	gboolean found = FALSE;
	GtkTreeStore* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_;
	GtkTreeIter* _tmp18_;
	GtkTreeIter* _tmp23_;
	GtkTreeStore* _tmp24_;
	SidebarEntry* _tmp25_;
	SidebarEntry* _tmp26_;
	GtkTreeStore* _tmp27_;
	GtkTreeIter* _tmp28_;
	GtkTreeIter _tmp29_;
	GtkTreePath* _tmp30_;
	GtkTreePath* _tmp31_;
	SidebarTreeRootWrapper* _tmp32_;
	SidebarTreeRootWrapper* _tmp33_;
	GtkTreeIter _tmp34_;
	SidebarEntry* _tmp35_;
	SidebarEntry* _tmp36_;
	GtkTreeIter* _tmp37_;
	GtkTreeIter _tmp38_;
	g_return_if_fail (SIDEBAR_IS_TREE (self));
	g_return_if_fail (SIDEBAR_IS_BRANCH (branch));
	_tmp0_ = self->priv->branches;
	_vala_assert (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), branch), "branches.has_key(branch)");
	_tmp1_ = self->priv->branches;
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), branch);
	position = (gint) ((gintptr) _tmp2_);
	insertion_iter = NULL;
	_tmp3_ = self->priv->store;
	_tmp5_ = gtk_tree_model_get_iter_first (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_tree_model_get_type (), GtkTreeModel), &_tmp4_);
	iter = _tmp4_;
	found = _tmp5_;
	while (TRUE) {
		SidebarTreeRootWrapper* root_wrapper = NULL;
		GtkTreeIter _tmp6_;
		SidebarTreeEntryWrapper* _tmp7_;
		SidebarTreeRootWrapper* _tmp8_;
		SidebarTreeRootWrapper* _tmp9_;
		SidebarTreeRootWrapper* _tmp10_;
		GtkTreeStore* _tmp16_;
		gboolean _tmp17_;
		if (!found) {
			break;
		}
		_tmp6_ = iter;
		_tmp7_ = sidebar_tree_get_wrapper_at_iter (self, &_tmp6_);
		_tmp8_ = SIDEBAR_TREE_IS_ROOT_WRAPPER (_tmp7_) ? ((SidebarTreeRootWrapper*) _tmp7_) : NULL;
		if (_tmp8_ == NULL) {
			_g_object_unref0 (_tmp7_);
		}
		root_wrapper = _tmp8_;
		_tmp9_ = root_wrapper;
		_vala_assert (_tmp9_ != NULL, "root_wrapper != null");
		_tmp10_ = root_wrapper;
		if (position < _tmp10_->root_position) {
			GtkTreeStore* _tmp11_;
			GtkTreeIter _tmp12_;
			GtkTreeIter _tmp13_ = {0};
			GtkTreeIter _tmp14_;
			GtkTreeIter* _tmp15_;
			_tmp11_ = self->priv->store;
			_tmp12_ = iter;
			gtk_tree_store_insert_before (_tmp11_, &_tmp13_, NULL, &_tmp12_);
			__vala_GtkTreeIter_free0 (insertion_iter);
			_tmp14_ = _tmp13_;
			_tmp15_ = __vala_GtkTreeIter_copy0 (&_tmp14_);
			insertion_iter = _tmp15_;
			_g_object_unref0 (root_wrapper);
			break;
		}
		_tmp16_ = self->priv->store;
		_tmp17_ = gtk_tree_model_iter_next (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_tree_model_get_type (), GtkTreeModel), &iter);
		found = _tmp17_;
		_g_object_unref0 (root_wrapper);
	}
	_tmp18_ = insertion_iter;
	if (_tmp18_ == NULL) {
		GtkTreeStore* _tmp19_;
		GtkTreeIter _tmp20_ = {0};
		GtkTreeIter _tmp21_;
		GtkTreeIter* _tmp22_;
		_tmp19_ = self->priv->store;
		gtk_tree_store_append (_tmp19_, &_tmp20_, NULL);
		__vala_GtkTreeIter_free0 (insertion_iter);
		_tmp21_ = _tmp20_;
		_tmp22_ = __vala_GtkTreeIter_copy0 (&_tmp21_);
		insertion_iter = _tmp22_;
	}
	_tmp23_ = insertion_iter;
	_tmp24_ = self->priv->store;
	_tmp25_ = sidebar_branch_get_root (branch);
	_tmp26_ = _tmp25_;
	_tmp27_ = self->priv->store;
	_tmp28_ = insertion_iter;
	_tmp29_ = *_tmp28_;
	_tmp30_ = gtk_tree_model_get_path (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_tree_model_get_type (), GtkTreeModel), &_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = sidebar_tree_root_wrapper_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_tree_model_get_type (), GtkTreeModel), _tmp26_, _tmp31_, position);
	_tmp33_ = _tmp32_;
	_tmp34_ = *_tmp23_;
	sidebar_tree_associate_wrapper (self, &_tmp34_, G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, SIDEBAR_TREE_TYPE_ENTRY_WRAPPER, SidebarTreeEntryWrapper));
	_g_object_unref0 (_tmp33_);
	__vala_GtkTreePath_free0 (_tmp31_);
	_g_object_unref0 (_tmp26_);
	_tmp35_ = sidebar_branch_get_root (branch);
	_tmp36_ = _tmp35_;
	_tmp37_ = insertion_iter;
	_tmp38_ = *_tmp37_;
	sidebar_tree_associate_children (self, branch, _tmp36_, &_tmp38_);
	_g_object_unref0 (_tmp36_);
	__vala_GtkTreeIter_free0 (insertion_iter);
}

static void
sidebar_tree_associate_children (SidebarTree* self,
                                 SidebarBranch* branch,
                                 SidebarEntry* parent,
                                 GtkTreeIter* parent_iter)
{
	GeeList* children = NULL;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	g_return_if_fail (SIDEBAR_IS_TREE (self));
	g_return_if_fail (SIDEBAR_IS_BRANCH (branch));
	g_return_if_fail (SIDEBAR_IS_ENTRY (parent));
	g_return_if_fail (parent_iter != NULL);
	_tmp0_ = sidebar_branch_get_children (branch, parent);
	children = _tmp0_;
	_tmp1_ = children;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (children);
		return;
	}
	{
		GeeList* _child_list = NULL;
		GeeList* _tmp2_;
		gint _child_size = 0;
		GeeList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _child_index = 0;
		_tmp2_ = children;
		_child_list = _tmp2_;
		_tmp3_ = _child_list;
		_tmp4_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp5_ = _tmp4_;
		_child_size = _tmp5_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			SidebarEntry* child = NULL;
			GeeList* _tmp8_;
			gpointer _tmp9_;
			GtkTreeIter append_iter = {0};
			GtkTreeStore* _tmp10_;
			GtkTreeIter _tmp11_;
			GtkTreeIter _tmp12_ = {0};
			GtkTreeIter _tmp13_;
			SidebarEntry* _tmp14_;
			SidebarEntry* _tmp15_;
			GtkTreeIter _tmp16_;
			_child_index = _child_index + 1;
			_tmp6_ = _child_index;
			_tmp7_ = _child_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _child_list;
			_tmp9_ = gee_list_get (_tmp8_, _child_index);
			child = (SidebarEntry*) _tmp9_;
			_tmp10_ = self->priv->store;
			_tmp11_ = *parent_iter;
			gtk_tree_store_append (_tmp10_, &_tmp12_, &_tmp11_);
			append_iter = _tmp12_;
			_tmp13_ = append_iter;
			_tmp14_ = child;
			sidebar_tree_associate_entry (self, &_tmp13_, _tmp14_);
			_tmp15_ = child;
			_tmp16_ = append_iter;
			sidebar_tree_associate_children (self, branch, _tmp15_, &_tmp16_);
			_g_object_unref0 (child);
		}
	}
	_g_object_unref0 (children);
}

static void
sidebar_tree_associate_entry (SidebarTree* self,
                              GtkTreeIter* assoc_iter,
                              SidebarEntry* entry)
{
	GtkTreeIter _tmp0_;
	GtkTreeStore* _tmp1_;
	GtkTreeStore* _tmp2_;
	GtkTreeIter _tmp3_;
	GtkTreePath* _tmp4_;
	GtkTreePath* _tmp5_;
	SidebarTreeEntryWrapper* _tmp6_;
	SidebarTreeEntryWrapper* _tmp7_;
	g_return_if_fail (SIDEBAR_IS_TREE (self));
	g_return_if_fail (assoc_iter != NULL);
	g_return_if_fail (SIDEBAR_IS_ENTRY (entry));
	_tmp0_ = *assoc_iter;
	_tmp1_ = self->priv->store;
	_tmp2_ = self->priv->store;
	_tmp3_ = *assoc_iter;
	_tmp4_ = gtk_tree_model_get_path (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_tree_model_get_type (), GtkTreeModel), &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = sidebar_tree_entry_wrapper_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_tree_model_get_type (), GtkTreeModel), entry, _tmp5_);
	_tmp7_ = _tmp6_;
	sidebar_tree_associate_wrapper (self, &_tmp0_, _tmp7_);
	_g_object_unref0 (_tmp7_);
	__vala_GtkTreePath_free0 (_tmp5_);
}

static void
_sidebar_tree_on_entry_changed_sidebar_entry_entry_changed (SidebarEntry* _sender,
                                                            gpointer self)
{
	sidebar_tree_on_entry_changed ((SidebarTree*) self, _sender);
}

static void
sidebar_tree_associate_wrapper (SidebarTree* self,
                                GtkTreeIter* assoc_iter,
                                SidebarTreeEntryWrapper* wrapper)
{
	SidebarEntry* entry = NULL;
	SidebarEntry* _tmp0_;
	SidebarEntry* _tmp1_;
	GeeHashMap* _tmp2_;
	SidebarEntry* _tmp3_;
	GeeHashMap* _tmp4_;
	SidebarEntry* _tmp5_;
	gchar* _tmp6_ = NULL;
	SidebarEntry* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_;
	GtkTreeStore* _tmp15_;
	GtkTreeIter _tmp16_;
	SidebarEntry* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	SidebarEntry* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	SidebarEntry* _tmp23_;
	SidebarEntry* _tmp24_;
	SidebarEntry* _tmp25_;
	g_return_if_fail (SIDEBAR_IS_TREE (self));
	g_return_if_fail (assoc_iter != NULL);
	g_return_if_fail (SIDEBAR_TREE_IS_ENTRY_WRAPPER (wrapper));
	_tmp0_ = wrapper->entry;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	entry = _tmp1_;
	_tmp2_ = self->priv->entry_map;
	_tmp3_ = entry;
	_vala_assert (!gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp3_), "!entry_map.has_key(entry)");
	_tmp4_ = self->priv->entry_map;
	_tmp5_ = entry;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp5_, wrapper);
	_tmp7_ = entry;
	_tmp8_ = sidebar_entry_get_sidebar_tooltip (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_ != NULL;
	_g_free0 (_tmp9_);
	if (_tmp10_) {
		SidebarEntry* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp11_ = entry;
		_tmp12_ = sidebar_entry_get_sidebar_tooltip (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = geary_html_escape_markup (_tmp13_);
		_g_free0 (_tmp6_);
		_tmp6_ = _tmp14_;
		_g_free0 (_tmp13_);
	} else {
		_g_free0 (_tmp6_);
		_tmp6_ = NULL;
	}
	_tmp15_ = self->priv->store;
	_tmp16_ = *assoc_iter;
	_tmp17_ = entry;
	_tmp18_ = sidebar_entry_get_sidebar_icon (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = entry;
	_tmp21_ = sidebar_tree_get_name_for_entry (self, _tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = entry;
	gtk_tree_store_set (_tmp15_, &_tmp16_, SIDEBAR_TREE_COLUMNS_WRAPPER, wrapper, SIDEBAR_TREE_COLUMNS_ICON, _tmp19_, SIDEBAR_TREE_COLUMNS_NAME, _tmp22_, SIDEBAR_TREE_COLUMNS_TOOLTIP, _tmp6_, SIDEBAR_TREE_COLUMNS_COUNTER, sidebar_entry_get_count (_tmp23_), -1);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp19_);
	_tmp24_ = entry;
	g_signal_connect_object (_tmp24_, "entry-changed", (GCallback) _sidebar_tree_on_entry_changed_sidebar_entry_entry_changed, self, 0);
	_tmp25_ = entry;
	sidebar_entry_grafted (_tmp25_, self);
	_g_free0 (_tmp6_);
	_g_object_unref0 (entry);
}

static SidebarTreeEntryWrapper*
sidebar_tree_reparent_wrapper (SidebarTree* self,
                               GtkTreeIter* new_iter,
                               SidebarTreeEntryWrapper* current_wrapper)
{
	SidebarEntry* entry = NULL;
	SidebarEntry* _tmp0_;
	SidebarEntry* _tmp1_;
	gboolean removed = FALSE;
	GeeHashMap* _tmp2_;
	SidebarEntry* _tmp3_;
	SidebarTreeEntryWrapper* new_wrapper = NULL;
	GtkTreeStore* _tmp4_;
	SidebarEntry* _tmp5_;
	GtkTreeStore* _tmp6_;
	GtkTreeIter _tmp7_;
	GtkTreePath* _tmp8_;
	GtkTreePath* _tmp9_;
	SidebarTreeEntryWrapper* _tmp10_;
	SidebarTreeEntryWrapper* _tmp11_;
	GeeHashMap* _tmp12_;
	SidebarEntry* _tmp13_;
	SidebarTreeEntryWrapper* _tmp14_;
	gchar* _tmp15_ = NULL;
	SidebarEntry* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gboolean _tmp19_;
	GtkTreeStore* _tmp24_;
	GtkTreeIter _tmp25_;
	SidebarTreeEntryWrapper* _tmp26_;
	SidebarEntry* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	SidebarEntry* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	SidebarEntry* _tmp33_;
	SidebarTreeEntryWrapper* result;
	g_return_val_if_fail (SIDEBAR_IS_TREE (self), NULL);
	g_return_val_if_fail (new_iter != NULL, NULL);
	g_return_val_if_fail (SIDEBAR_TREE_IS_ENTRY_WRAPPER (current_wrapper), NULL);
	_tmp0_ = current_wrapper->entry;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	entry = _tmp1_;
	_tmp2_ = self->priv->entry_map;
	_tmp3_ = entry;
	removed = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp3_, NULL);
	_vala_assert (removed, "removed");
	_tmp4_ = self->priv->store;
	_tmp5_ = entry;
	_tmp6_ = self->priv->store;
	_tmp7_ = *new_iter;
	_tmp8_ = gtk_tree_model_get_path (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_tree_model_get_type (), GtkTreeModel), &_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = sidebar_tree_entry_wrapper_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_tree_model_get_type (), GtkTreeModel), _tmp5_, _tmp9_);
	_tmp11_ = _tmp10_;
	__vala_GtkTreePath_free0 (_tmp9_);
	new_wrapper = _tmp11_;
	_tmp12_ = self->priv->entry_map;
	_tmp13_ = entry;
	_tmp14_ = new_wrapper;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp13_, _tmp14_);
	_tmp16_ = entry;
	_tmp17_ = sidebar_entry_get_sidebar_tooltip (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = _tmp18_ != NULL;
	_g_free0 (_tmp18_);
	if (_tmp19_) {
		SidebarEntry* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp20_ = entry;
		_tmp21_ = sidebar_entry_get_sidebar_tooltip (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = geary_html_escape_markup (_tmp22_);
		_g_free0 (_tmp15_);
		_tmp15_ = _tmp23_;
		_g_free0 (_tmp22_);
	} else {
		_g_free0 (_tmp15_);
		_tmp15_ = NULL;
	}
	_tmp24_ = self->priv->store;
	_tmp25_ = *new_iter;
	_tmp26_ = new_wrapper;
	_tmp27_ = entry;
	_tmp28_ = sidebar_entry_get_sidebar_icon (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = entry;
	_tmp31_ = sidebar_tree_get_name_for_entry (self, _tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = entry;
	gtk_tree_store_set (_tmp24_, &_tmp25_, SIDEBAR_TREE_COLUMNS_WRAPPER, _tmp26_, SIDEBAR_TREE_COLUMNS_ICON, _tmp29_, SIDEBAR_TREE_COLUMNS_NAME, _tmp32_, SIDEBAR_TREE_COLUMNS_TOOLTIP, _tmp15_, SIDEBAR_TREE_COLUMNS_COUNTER, sidebar_entry_get_count (_tmp33_), -1);
	_g_free0 (_tmp32_);
	_g_free0 (_tmp29_);
	result = new_wrapper;
	_g_free0 (_tmp15_);
	_g_object_unref0 (entry);
	return result;
}

void
sidebar_tree_prune_all (SidebarTree* self)
{
	g_return_if_fail (SIDEBAR_IS_TREE (self));
	while (TRUE) {
		GeeHashMap* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gboolean _tmp6_;
		GeeIterator* iterator = NULL;
		GeeHashMap* _tmp7_;
		GeeSet* _tmp8_;
		GeeSet* _tmp9_;
		GeeSet* _tmp10_;
		GeeIterator* _tmp11_;
		GeeIterator* _tmp12_;
		GeeIterator* _tmp13_;
		GeeIterator* _tmp14_;
		gpointer _tmp15_;
		SidebarBranch* _tmp16_;
		_tmp0_ = self->priv->branches;
		_tmp1_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp5_ = _tmp4_;
		_tmp6_ = !(_tmp5_ > 0);
		_g_object_unref0 (_tmp3_);
		if (_tmp6_) {
			break;
		}
		_tmp7_ = self->priv->branches;
		_tmp8_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_;
		_tmp11_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp12_ = _tmp11_;
		_g_object_unref0 (_tmp10_);
		iterator = _tmp12_;
		_tmp13_ = iterator;
		if (!gee_iterator_next (_tmp13_)) {
			_g_object_unref0 (iterator);
			break;
		}
		_tmp14_ = iterator;
		_tmp15_ = gee_iterator_get (_tmp14_);
		_tmp16_ = (SidebarBranch*) _tmp15_;
		sidebar_tree_prune (self, _tmp16_);
		_g_object_unref0 (_tmp16_);
		_g_object_unref0 (iterator);
	}
}

void
sidebar_tree_prune (SidebarTree* self,
                    SidebarBranch* branch)
{
	GeeHashMap* _tmp0_;
	SidebarEntry* _tmp1_;
	SidebarEntry* _tmp2_;
	gboolean _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	gboolean removed = FALSE;
	GeeHashMap* _tmp10_;
	g_return_if_fail (SIDEBAR_IS_TREE (self));
	g_return_if_fail (SIDEBAR_IS_BRANCH (branch));
	_tmp0_ = self->priv->branches;
	_vala_assert (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), branch), "branches.has_key(branch)");
	_tmp1_ = sidebar_branch_get_root (branch);
	_tmp2_ = _tmp1_;
	_tmp3_ = sidebar_tree_has_wrapper (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		sidebar_tree_disassociate_branch (self, branch);
	}
	g_signal_parse_name ("entry-added", SIDEBAR_TYPE_BRANCH, &_tmp4_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (branch, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _sidebar_tree_on_branch_entry_added_sidebar_branch_entry_added, self);
	g_signal_parse_name ("entry-removed", SIDEBAR_TYPE_BRANCH, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (branch, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _sidebar_tree_on_branch_entry_removed_sidebar_branch_entry_removed, self);
	g_signal_parse_name ("entry-moved", SIDEBAR_TYPE_BRANCH, &_tmp6_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (branch, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _sidebar_tree_on_branch_entry_moved_sidebar_branch_entry_moved, self);
	g_signal_parse_name ("entry-reparented", SIDEBAR_TYPE_BRANCH, &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (branch, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _sidebar_tree_on_branch_entry_reparented_sidebar_branch_entry_reparented, self);
	g_signal_parse_name ("children-reordered", SIDEBAR_TYPE_BRANCH, &_tmp8_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (branch, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _sidebar_tree_on_branch_children_reordered_sidebar_branch_children_reordered, self);
	g_signal_parse_name ("show-branch", SIDEBAR_TYPE_BRANCH, &_tmp9_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (branch, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _sidebar_tree_on_show_branch_sidebar_branch_show_branch, self);
	_tmp10_ = self->priv->branches;
	removed = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), branch, NULL);
	_vala_assert (removed, "removed");
	g_signal_emit (self, sidebar_tree_signals[SIDEBAR_TREE_BRANCH_REMOVED_SIGNAL], 0, branch);
}

static void
sidebar_tree_disassociate_branch (SidebarTree* self,
                                  SidebarBranch* branch)
{
	SidebarTreeRootWrapper* root_wrapper = NULL;
	SidebarEntry* _tmp0_;
	SidebarEntry* _tmp1_;
	SidebarTreeEntryWrapper* _tmp2_;
	SidebarTreeRootWrapper* _tmp3_;
	SidebarTreeRootWrapper* _tmp4_;
	g_return_if_fail (SIDEBAR_IS_TREE (self));
	g_return_if_fail (SIDEBAR_IS_BRANCH (branch));
	_tmp0_ = sidebar_branch_get_root (branch);
	_tmp1_ = _tmp0_;
	_tmp2_ = sidebar_tree_get_wrapper (self, _tmp1_);
	_tmp3_ = SIDEBAR_TREE_IS_ROOT_WRAPPER (_tmp2_) ? ((SidebarTreeRootWrapper*) _tmp2_) : NULL;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (_tmp2_);
	}
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	root_wrapper = _tmp4_;
	_vala_assert (root_wrapper != NULL, "root_wrapper != null");
	sidebar_tree_disassociate_wrapper_and_signal (self, G_TYPE_CHECK_INSTANCE_CAST (root_wrapper, SIDEBAR_TREE_TYPE_ENTRY_WRAPPER, SidebarTreeEntryWrapper), FALSE);
	_g_object_unref0 (root_wrapper);
}

static void
sidebar_tree_disassociate_wrapper_and_signal (SidebarTree* self,
                                              SidebarTreeEntryWrapper* wrapper,
                                              gboolean only_children)
{
	gboolean selected = FALSE;
	SidebarEntry* _tmp0_;
	g_return_if_fail (SIDEBAR_IS_TREE (self));
	g_return_if_fail (SIDEBAR_TREE_IS_ENTRY_WRAPPER (wrapper));
	_tmp0_ = wrapper->entry;
	selected = sidebar_tree_is_selected (self, _tmp0_);
	sidebar_tree_disassociate_wrapper (self, wrapper, only_children);
	if (selected) {
		SidebarSelectableEntry* selectable = NULL;
		SidebarEntry* _tmp1_;
		SidebarSelectableEntry* _tmp2_;
		SidebarSelectableEntry* _tmp3_;
		SidebarSelectableEntry* _tmp4_;
		_tmp1_ = wrapper->entry;
		_tmp2_ = _g_object_ref0 (SIDEBAR_IS_SELECTABLE_ENTRY (_tmp1_) ? ((SidebarSelectableEntry*) _tmp1_) : NULL);
		selectable = _tmp2_;
		_tmp3_ = selectable;
		_vala_assert (_tmp3_ != NULL, "selectable != null");
		_tmp4_ = selectable;
		g_signal_emit (self, sidebar_tree_signals[SIDEBAR_TREE_SELECTED_ENTRY_REMOVED_SIGNAL], 0, _tmp4_);
		_g_object_unref0 (selectable);
	}
}

static void
sidebar_tree_disassociate_wrapper (SidebarTree* self,
                                   SidebarTreeEntryWrapper* wrapper,
                                   gboolean only_children)
{
	GeeArrayList* children = NULL;
	GeeArrayList* _tmp0_;
	GtkTreeIter child_iter = {0};
	gboolean found = FALSE;
	GtkTreeStore* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp21_ = {0};
	GtkTreeStore* _tmp22_;
	SidebarTreeEntryWrapper* _tmp23_;
	SidebarEntry* entry = NULL;
	SidebarEntry* _tmp24_;
	SidebarEntry* _tmp25_;
	SidebarEntry* _tmp26_;
	SidebarEntry* _tmp27_;
	guint _tmp28_;
	GeeHashMap* _tmp29_;
	SidebarEntry* _tmp30_;
	g_return_if_fail (SIDEBAR_IS_TREE (self));
	g_return_if_fail (SIDEBAR_TREE_IS_ENTRY_WRAPPER (wrapper));
	_tmp0_ = gee_array_list_new (SIDEBAR_TREE_TYPE_ENTRY_WRAPPER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	children = _tmp0_;
	_tmp1_ = self->priv->store;
	sidebar_tree_entry_wrapper_get_iter (wrapper, &_tmp2_);
	_tmp4_ = gtk_tree_model_iter_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_tree_model_get_type (), GtkTreeModel), &_tmp3_, &_tmp2_);
	child_iter = _tmp3_;
	found = _tmp4_;
	while (TRUE) {
		SidebarTreeEntryWrapper* child_wrapper = NULL;
		GtkTreeIter _tmp5_;
		SidebarTreeEntryWrapper* _tmp6_;
		SidebarTreeEntryWrapper* _tmp7_;
		GeeArrayList* _tmp8_;
		SidebarTreeEntryWrapper* _tmp9_;
		GtkTreeStore* _tmp10_;
		gboolean _tmp11_;
		if (!found) {
			break;
		}
		_tmp5_ = child_iter;
		_tmp6_ = sidebar_tree_get_wrapper_at_iter (self, &_tmp5_);
		child_wrapper = _tmp6_;
		_tmp7_ = child_wrapper;
		_vala_assert (_tmp7_ != NULL, "child_wrapper != null");
		_tmp8_ = children;
		_tmp9_ = child_wrapper;
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp9_);
		_tmp10_ = self->priv->store;
		_tmp11_ = gtk_tree_model_iter_next (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_tree_model_get_type (), GtkTreeModel), &child_iter);
		found = _tmp11_;
		_g_object_unref0 (child_wrapper);
	}
	{
		GeeArrayList* _child_wrapper_list = NULL;
		GeeArrayList* _tmp12_;
		gint _child_wrapper_size = 0;
		GeeArrayList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _child_wrapper_index = 0;
		_tmp12_ = children;
		_child_wrapper_list = _tmp12_;
		_tmp13_ = _child_wrapper_list;
		_tmp14_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_tmp15_ = _tmp14_;
		_child_wrapper_size = _tmp15_;
		_child_wrapper_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			SidebarTreeEntryWrapper* child_wrapper = NULL;
			GeeArrayList* _tmp18_;
			gpointer _tmp19_;
			SidebarTreeEntryWrapper* _tmp20_;
			_child_wrapper_index = _child_wrapper_index + 1;
			_tmp16_ = _child_wrapper_index;
			_tmp17_ = _child_wrapper_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _child_wrapper_list;
			_tmp19_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _child_wrapper_index);
			child_wrapper = (SidebarTreeEntryWrapper*) _tmp19_;
			_tmp20_ = child_wrapper;
			sidebar_tree_disassociate_wrapper (self, _tmp20_, FALSE);
			_g_object_unref0 (child_wrapper);
		}
	}
	if (only_children) {
		_g_object_unref0 (children);
		return;
	}
	sidebar_tree_entry_wrapper_get_iter (wrapper, &_tmp21_);
	iter = _tmp21_;
	_tmp22_ = self->priv->store;
	gtk_tree_store_remove (_tmp22_, &iter);
	_tmp23_ = self->priv->selected_wrapper;
	if (_tmp23_ == wrapper) {
		self->priv->selected_wrapper = NULL;
	}
	_tmp24_ = wrapper->entry;
	_tmp25_ = _g_object_ref0 (_tmp24_);
	entry = _tmp25_;
	_tmp26_ = entry;
	sidebar_entry_pruned (_tmp26_, self);
	_tmp27_ = entry;
	g_signal_parse_name ("entry-changed", SIDEBAR_TYPE_ENTRY, &_tmp28_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp27_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp28_, 0, NULL, (GCallback) _sidebar_tree_on_entry_changed_sidebar_entry_entry_changed, self);
	_tmp29_ = self->priv->entry_map;
	_tmp30_ = entry;
	gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp30_, NULL);
	_g_object_unref0 (entry);
	_g_object_unref0 (children);
}

static void
sidebar_tree_on_branch_entry_added (SidebarTree* self,
                                    SidebarBranch* branch,
                                    SidebarEntry* entry)
{
	SidebarEntry* parent = NULL;
	SidebarEntry* _tmp0_;
	SidebarEntry* _tmp1_;
	SidebarTreeEntryWrapper* parent_wrapper = NULL;
	SidebarEntry* _tmp2_;
	SidebarTreeEntryWrapper* _tmp3_;
	SidebarTreeEntryWrapper* _tmp4_;
	GtkTreeIter insertion_iter = {0};
	SidebarEntry* next = NULL;
	SidebarEntry* _tmp5_;
	SidebarEntry* _tmp6_;
	GtkTreeIter _tmp19_;
	GtkTreeIter _tmp20_;
	gboolean _tmp21_ = FALSE;
	g_return_if_fail (SIDEBAR_IS_TREE (self));
	g_return_if_fail (SIDEBAR_IS_BRANCH (branch));
	g_return_if_fail (SIDEBAR_IS_ENTRY (entry));
	_tmp0_ = sidebar_branch_get_parent (branch, entry);
	parent = _tmp0_;
	_tmp1_ = parent;
	_vala_assert (_tmp1_ != NULL, "parent != null");
	_tmp2_ = parent;
	_tmp3_ = sidebar_tree_get_wrapper (self, _tmp2_);
	parent_wrapper = _tmp3_;
	_tmp4_ = parent_wrapper;
	_vala_assert (_tmp4_ != NULL, "parent_wrapper != null");
	_tmp5_ = sidebar_branch_get_next_sibling (branch, entry);
	next = _tmp5_;
	_tmp6_ = next;
	if (_tmp6_ != NULL) {
		SidebarTreeEntryWrapper* next_wrapper = NULL;
		SidebarEntry* _tmp7_;
		SidebarTreeEntryWrapper* _tmp8_;
		GtkTreeStore* _tmp9_;
		SidebarTreeEntryWrapper* _tmp10_;
		GtkTreeIter _tmp11_ = {0};
		SidebarTreeEntryWrapper* _tmp12_;
		GtkTreeIter _tmp13_ = {0};
		GtkTreeIter _tmp14_ = {0};
		_tmp7_ = next;
		_tmp8_ = sidebar_tree_get_wrapper (self, _tmp7_);
		next_wrapper = _tmp8_;
		_tmp9_ = self->priv->store;
		_tmp10_ = parent_wrapper;
		sidebar_tree_entry_wrapper_get_iter (_tmp10_, &_tmp11_);
		_tmp12_ = next_wrapper;
		sidebar_tree_entry_wrapper_get_iter (_tmp12_, &_tmp13_);
		gtk_tree_store_insert_before (_tmp9_, &_tmp14_, &_tmp11_, &_tmp13_);
		insertion_iter = _tmp14_;
		_g_object_unref0 (next_wrapper);
	} else {
		GtkTreeStore* _tmp15_;
		SidebarTreeEntryWrapper* _tmp16_;
		GtkTreeIter _tmp17_ = {0};
		GtkTreeIter _tmp18_ = {0};
		_tmp15_ = self->priv->store;
		_tmp16_ = parent_wrapper;
		sidebar_tree_entry_wrapper_get_iter (_tmp16_, &_tmp17_);
		gtk_tree_store_append (_tmp15_, &_tmp18_, &_tmp17_);
		insertion_iter = _tmp18_;
	}
	_tmp19_ = insertion_iter;
	sidebar_tree_associate_entry (self, &_tmp19_, entry);
	_tmp20_ = insertion_iter;
	sidebar_tree_associate_children (self, branch, entry, &_tmp20_);
	if (sidebar_branch_is_auto_open_on_new_child (branch)) {
		_tmp21_ = TRUE;
	} else {
		SidebarEntry* _tmp22_;
		_tmp22_ = parent;
		_tmp21_ = SIDEBAR_IS_GROUPING (_tmp22_);
	}
	if (_tmp21_) {
		sidebar_tree_expand_to_entry (self, entry);
	}
	_g_object_unref0 (next);
	_g_object_unref0 (parent_wrapper);
	_g_object_unref0 (parent);
}

static void
sidebar_tree_on_branch_entry_removed (SidebarTree* self,
                                      SidebarBranch* branch,
                                      SidebarEntry* entry)
{
	SidebarTreeEntryWrapper* wrapper = NULL;
	SidebarTreeEntryWrapper* _tmp0_;
	SidebarTreeEntryWrapper* _tmp1_;
	g_return_if_fail (SIDEBAR_IS_TREE (self));
	g_return_if_fail (SIDEBAR_IS_BRANCH (branch));
	g_return_if_fail (SIDEBAR_IS_ENTRY (entry));
	_tmp0_ = sidebar_tree_get_wrapper (self, entry);
	wrapper = _tmp0_;
	_tmp1_ = wrapper;
	if (_tmp1_ != NULL) {
		SidebarTreeEntryWrapper* _tmp2_;
		SidebarTreeEntryWrapper* _tmp3_;
		_tmp2_ = wrapper;
		_vala_assert (!SIDEBAR_TREE_IS_ROOT_WRAPPER (_tmp2_), "!(wrapper is RootWrapper)");
		_tmp3_ = wrapper;
		sidebar_tree_disassociate_wrapper_and_signal (self, _tmp3_, FALSE);
	}
	_g_object_unref0 (wrapper);
}

static void
sidebar_tree_on_branch_entry_moved (SidebarTree* self,
                                    SidebarBranch* branch,
                                    SidebarEntry* entry)
{
	SidebarTreeEntryWrapper* wrapper = NULL;
	SidebarTreeEntryWrapper* _tmp0_;
	SidebarTreeEntryWrapper* _tmp1_;
	SidebarTreeEntryWrapper* _tmp2_;
	GtkTreeIter* prev_iter = NULL;
	SidebarEntry* prev = NULL;
	SidebarEntry* _tmp3_;
	SidebarEntry* _tmp4_;
	GtkTreeIter entry_iter = {0};
	SidebarTreeEntryWrapper* _tmp11_;
	GtkTreeIter _tmp12_ = {0};
	GtkTreeStore* _tmp13_;
	GtkTreeIter* _tmp14_;
	g_return_if_fail (SIDEBAR_IS_TREE (self));
	g_return_if_fail (SIDEBAR_IS_BRANCH (branch));
	g_return_if_fail (SIDEBAR_IS_ENTRY (entry));
	_tmp0_ = sidebar_tree_get_wrapper (self, entry);
	wrapper = _tmp0_;
	_tmp1_ = wrapper;
	_vala_assert (_tmp1_ != NULL, "wrapper != null");
	_tmp2_ = wrapper;
	_vala_assert (!SIDEBAR_TREE_IS_ROOT_WRAPPER (_tmp2_), "!(wrapper is RootWrapper)");
	prev_iter = NULL;
	_tmp3_ = sidebar_branch_get_previous_sibling (branch, entry);
	prev = _tmp3_;
	_tmp4_ = prev;
	if (_tmp4_ != NULL) {
		SidebarTreeEntryWrapper* prev_wrapper = NULL;
		SidebarEntry* _tmp5_;
		SidebarTreeEntryWrapper* _tmp6_;
		SidebarTreeEntryWrapper* _tmp7_;
		SidebarTreeEntryWrapper* _tmp8_;
		GtkTreeIter _tmp9_ = {0};
		GtkTreeIter* _tmp10_;
		_tmp5_ = prev;
		_tmp6_ = sidebar_tree_get_wrapper (self, _tmp5_);
		prev_wrapper = _tmp6_;
		_tmp7_ = prev_wrapper;
		_vala_assert (_tmp7_ != NULL, "prev_wrapper != null");
		_tmp8_ = prev_wrapper;
		sidebar_tree_entry_wrapper_get_iter (_tmp8_, &_tmp9_);
		_tmp10_ = __vala_GtkTreeIter_copy0 (&_tmp9_);
		__vala_GtkTreeIter_free0 (prev_iter);
		prev_iter = _tmp10_;
		_g_object_unref0 (prev_wrapper);
	}
	_tmp11_ = wrapper;
	sidebar_tree_entry_wrapper_get_iter (_tmp11_, &_tmp12_);
	entry_iter = _tmp12_;
	_tmp13_ = self->priv->store;
	_tmp14_ = prev_iter;
	gtk_tree_store_move_after (_tmp13_, &entry_iter, _tmp14_);
	_g_object_unref0 (prev);
	__vala_GtkTreeIter_free0 (prev_iter);
	_g_object_unref0 (wrapper);
}

static void
sidebar_tree_on_branch_entry_reparented (SidebarTree* self,
                                         SidebarBranch* branch,
                                         SidebarEntry* entry,
                                         SidebarEntry* old_parent)
{
	SidebarTreeEntryWrapper* wrapper = NULL;
	SidebarTreeEntryWrapper* _tmp0_;
	SidebarTreeEntryWrapper* _tmp1_;
	SidebarTreeEntryWrapper* _tmp2_;
	gboolean selected = FALSE;
	GtkTreePath* _tmp3_;
	GtkTreePath* _tmp4_;
	SidebarTreeEntryWrapper* _tmp5_;
	GtkTreePath* _tmp6_;
	GtkTreePath* _tmp7_;
	gboolean _tmp8_;
	GtkTreeIter iter = {0};
	SidebarTreeEntryWrapper* _tmp9_;
	GtkTreeIter _tmp10_ = {0};
	GtkTreeStore* _tmp11_;
	SidebarEntry* parent = NULL;
	SidebarEntry* _tmp12_;
	SidebarEntry* _tmp13_;
	SidebarTreeEntryWrapper* parent_wrapper = NULL;
	SidebarEntry* _tmp14_;
	SidebarTreeEntryWrapper* _tmp15_;
	SidebarTreeEntryWrapper* _tmp16_;
	GtkTreeIter* prev_iter = NULL;
	SidebarEntry* prev = NULL;
	SidebarEntry* _tmp17_;
	SidebarEntry* _tmp18_;
	GtkTreeIter new_iter = {0};
	GtkTreeStore* _tmp25_;
	SidebarTreeEntryWrapper* _tmp26_;
	GtkTreeIter _tmp27_ = {0};
	GtkTreeIter* _tmp28_;
	GtkTreeIter _tmp29_ = {0};
	SidebarTreeEntryWrapper* new_wrapper = NULL;
	GtkTreeIter _tmp30_;
	SidebarTreeEntryWrapper* _tmp31_;
	SidebarTreeEntryWrapper* _tmp32_;
	g_return_if_fail (SIDEBAR_IS_TREE (self));
	g_return_if_fail (SIDEBAR_IS_BRANCH (branch));
	g_return_if_fail (SIDEBAR_IS_ENTRY (entry));
	g_return_if_fail (SIDEBAR_IS_ENTRY (old_parent));
	_tmp0_ = sidebar_tree_get_wrapper (self, entry);
	wrapper = _tmp0_;
	_tmp1_ = wrapper;
	_vala_assert (_tmp1_ != NULL, "wrapper != null");
	_tmp2_ = wrapper;
	_vala_assert (!SIDEBAR_TREE_IS_ROOT_WRAPPER (_tmp2_), "!(wrapper is RootWrapper)");
	_tmp3_ = sidebar_tree_get_current_path (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = wrapper;
	_tmp6_ = sidebar_tree_entry_wrapper_get_path (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = gtk_tree_path_compare (_tmp4_, _tmp7_) == 0;
	__vala_GtkTreePath_free0 (_tmp7_);
	__vala_GtkTreePath_free0 (_tmp4_);
	selected = _tmp8_;
	_tmp9_ = wrapper;
	sidebar_tree_entry_wrapper_get_iter (_tmp9_, &_tmp10_);
	iter = _tmp10_;
	_tmp11_ = self->priv->store;
	gtk_tree_store_remove (_tmp11_, &iter);
	_tmp12_ = sidebar_branch_get_parent (branch, entry);
	parent = _tmp12_;
	_tmp13_ = parent;
	_vala_assert (_tmp13_ != NULL, "parent != null");
	_tmp14_ = parent;
	_tmp15_ = sidebar_tree_get_wrapper (self, _tmp14_);
	parent_wrapper = _tmp15_;
	_tmp16_ = parent_wrapper;
	_vala_assert (_tmp16_ != NULL, "parent_wrapper != null");
	prev_iter = NULL;
	_tmp17_ = sidebar_branch_get_previous_sibling (branch, entry);
	prev = _tmp17_;
	_tmp18_ = prev;
	if (_tmp18_ != NULL) {
		SidebarTreeEntryWrapper* prev_wrapper = NULL;
		SidebarEntry* _tmp19_;
		SidebarTreeEntryWrapper* _tmp20_;
		SidebarTreeEntryWrapper* _tmp21_;
		SidebarTreeEntryWrapper* _tmp22_;
		GtkTreeIter _tmp23_ = {0};
		GtkTreeIter* _tmp24_;
		_tmp19_ = prev;
		_tmp20_ = sidebar_tree_get_wrapper (self, _tmp19_);
		prev_wrapper = _tmp20_;
		_tmp21_ = prev_wrapper;
		_vala_assert (_tmp21_ != NULL, "prev_wrapper != null");
		_tmp22_ = prev_wrapper;
		sidebar_tree_entry_wrapper_get_iter (_tmp22_, &_tmp23_);
		_tmp24_ = __vala_GtkTreeIter_copy0 (&_tmp23_);
		__vala_GtkTreeIter_free0 (prev_iter);
		prev_iter = _tmp24_;
		_g_object_unref0 (prev_wrapper);
	}
	_tmp25_ = self->priv->store;
	_tmp26_ = parent_wrapper;
	sidebar_tree_entry_wrapper_get_iter (_tmp26_, &_tmp27_);
	_tmp28_ = prev_iter;
	gtk_tree_store_insert_after (_tmp25_, &_tmp29_, &_tmp27_, _tmp28_);
	new_iter = _tmp29_;
	_tmp30_ = new_iter;
	_tmp31_ = wrapper;
	_tmp32_ = sidebar_tree_reparent_wrapper (self, &_tmp30_, _tmp31_);
	new_wrapper = _tmp32_;
	if (selected) {
		SidebarTreeEntryWrapper* _tmp33_;
		SidebarEntry* _tmp34_;
		SidebarTreeEntryWrapper* _tmp35_;
		SidebarEntry* _tmp36_;
		_tmp33_ = new_wrapper;
		_tmp34_ = _tmp33_->entry;
		sidebar_tree_expand_to_entry (self, _tmp34_);
		_tmp35_ = new_wrapper;
		_tmp36_ = _tmp35_->entry;
		sidebar_tree_place_cursor (self, _tmp36_, FALSE);
	}
	_g_object_unref0 (new_wrapper);
	_g_object_unref0 (prev);
	__vala_GtkTreeIter_free0 (prev_iter);
	_g_object_unref0 (parent_wrapper);
	_g_object_unref0 (parent);
	_g_object_unref0 (wrapper);
}

static void
sidebar_tree_on_branch_children_reordered (SidebarTree* self,
                                           SidebarBranch* branch,
                                           SidebarEntry* entry)
{
	GeeList* children = NULL;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	g_return_if_fail (SIDEBAR_IS_TREE (self));
	g_return_if_fail (SIDEBAR_IS_BRANCH (branch));
	g_return_if_fail (SIDEBAR_IS_ENTRY (entry));
	_tmp0_ = sidebar_branch_get_children (branch, entry);
	children = _tmp0_;
	_tmp1_ = children;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (children);
		return;
	}
	{
		GeeList* _child_list = NULL;
		GeeList* _tmp2_;
		gint _child_size = 0;
		GeeList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _child_index = 0;
		_tmp2_ = children;
		_child_list = _tmp2_;
		_tmp3_ = _child_list;
		_tmp4_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp5_ = _tmp4_;
		_child_size = _tmp5_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			SidebarEntry* child = NULL;
			GeeList* _tmp8_;
			gpointer _tmp9_;
			SidebarTreeEntryWrapper* child_wrapper = NULL;
			SidebarEntry* _tmp10_;
			SidebarTreeEntryWrapper* _tmp11_;
			SidebarTreeEntryWrapper* _tmp12_;
			GtkTreeIter child_iter = {0};
			SidebarTreeEntryWrapper* _tmp13_;
			GtkTreeIter _tmp14_ = {0};
			GtkTreeStore* _tmp15_;
			_child_index = _child_index + 1;
			_tmp6_ = _child_index;
			_tmp7_ = _child_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _child_list;
			_tmp9_ = gee_list_get (_tmp8_, _child_index);
			child = (SidebarEntry*) _tmp9_;
			_tmp10_ = child;
			_tmp11_ = sidebar_tree_get_wrapper (self, _tmp10_);
			child_wrapper = _tmp11_;
			_tmp12_ = child_wrapper;
			_vala_assert (_tmp12_ != NULL, "child_wrapper != null");
			_tmp13_ = child_wrapper;
			sidebar_tree_entry_wrapper_get_iter (_tmp13_, &_tmp14_);
			child_iter = _tmp14_;
			_tmp15_ = self->priv->store;
			gtk_tree_store_move_before (_tmp15_, &child_iter, NULL);
			_g_object_unref0 (child_wrapper);
			_g_object_unref0 (child);
		}
	}
	_g_object_unref0 (children);
}

static void
sidebar_tree_on_show_branch (SidebarTree* self,
                             SidebarBranch* branch,
                             gboolean shown)
{
	g_return_if_fail (SIDEBAR_IS_TREE (self));
	g_return_if_fail (SIDEBAR_IS_BRANCH (branch));
	if (shown) {
		sidebar_tree_associate_branch (self, branch);
	} else {
		sidebar_tree_disassociate_branch (self, branch);
	}
	g_signal_emit (self, sidebar_tree_signals[SIDEBAR_TREE_BRANCH_SHOWN_SIGNAL], 0, branch, shown);
}

static void
sidebar_tree_on_entry_changed (SidebarTree* self,
                               SidebarEntry* entry)
{
	SidebarTreeEntryWrapper* wrapper = NULL;
	SidebarTreeEntryWrapper* _tmp0_;
	SidebarTreeEntryWrapper* _tmp1_;
	g_return_if_fail (SIDEBAR_IS_TREE (self));
	g_return_if_fail (SIDEBAR_IS_ENTRY (entry));
	_tmp0_ = sidebar_tree_get_wrapper (self, entry);
	wrapper = _tmp0_;
	_tmp1_ = wrapper;
	if (_tmp1_ != NULL) {
		gchar* tooltip = NULL;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		GtkTreeStore* _tmp6_;
		SidebarTreeEntryWrapper* _tmp7_;
		GtkTreeIter _tmp8_ = {0};
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		_tmp2_ = sidebar_entry_get_sidebar_tooltip (entry);
		tooltip = _tmp2_;
		_tmp3_ = tooltip;
		if (_tmp3_ != NULL) {
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = tooltip;
			_tmp5_ = geary_html_escape_markup (_tmp4_);
			_g_free0 (tooltip);
			tooltip = _tmp5_;
		}
		_tmp6_ = self->priv->store;
		_tmp7_ = wrapper;
		sidebar_tree_entry_wrapper_get_iter (_tmp7_, &_tmp8_);
		_tmp9_ = sidebar_entry_get_sidebar_icon (entry);
		_tmp10_ = _tmp9_;
		_tmp11_ = sidebar_tree_get_name_for_entry (self, entry);
		_tmp12_ = _tmp11_;
		_tmp13_ = tooltip;
		gtk_tree_store_set (_tmp6_, &_tmp8_, SIDEBAR_TREE_COLUMNS_ICON, _tmp10_, SIDEBAR_TREE_COLUMNS_NAME, _tmp12_, SIDEBAR_TREE_COLUMNS_TOOLTIP, _tmp13_, SIDEBAR_TREE_COLUMNS_COUNTER, sidebar_entry_get_count (entry), -1);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
		_g_free0 (tooltip);
	}
	_g_object_unref0 (wrapper);
}

static gboolean
sidebar_tree_on_selection (SidebarTree* self,
                           GtkTreeSelection* selection,
                           GtkTreeModel* model,
                           GtkTreePath* path,
                           gboolean path_currently_selected)
{
	SidebarTreeEntryWrapper* wrapper = NULL;
	SidebarTreeEntryWrapper* _tmp0_;
	gboolean _tmp1_ = FALSE;
	SidebarTreeEntryWrapper* _tmp2_;
	gboolean result;
	g_return_val_if_fail (SIDEBAR_IS_TREE (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (selection, gtk_tree_selection_get_type ()), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (model, gtk_tree_model_get_type ()), FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = sidebar_tree_get_wrapper_at_path (self, path);
	wrapper = _tmp0_;
	_tmp2_ = wrapper;
	if (_tmp2_ != NULL) {
		SidebarTreeEntryWrapper* _tmp3_;
		SidebarEntry* _tmp4_;
		_tmp3_ = wrapper;
		_tmp4_ = _tmp3_->entry;
		_tmp1_ = SIDEBAR_IS_SELECTABLE_ENTRY (_tmp4_);
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	_g_object_unref0 (wrapper);
	return result;
}

static GtkTreePath*
sidebar_tree_get_path_from_event (SidebarTree* self,
                                  GdkEventButton* event)
{
	gint x = 0;
	gint y = 0;
	GdkModifierType mask = 0U;
	GdkWindow* _tmp0_;
	GdkSeat* _tmp1_;
	GdkDevice* _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GdkModifierType _tmp5_ = 0U;
	gint cell_x = 0;
	gint cell_y = 0;
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp6_ = NULL;
	GtkTreePath* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gboolean _tmp10_;
	GtkTreePath* _tmp12_;
	GtkTreePath* result;
	g_return_val_if_fail (SIDEBAR_IS_TREE (self), NULL);
	g_return_val_if_fail (event != NULL, NULL);
	_tmp0_ = event->window;
	_tmp1_ = gdk_event_get_seat ((GdkEvent*) event);
	_tmp2_ = gdk_seat_get_pointer (_tmp1_);
	gdk_window_get_device_position (_tmp0_, _tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
	x = _tmp3_;
	y = _tmp4_;
	mask = _tmp5_;
	_tmp10_ = gtk_tree_view_get_path_at_pos (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), x, y, &_tmp7_, NULL, &_tmp8_, &_tmp9_);
	__vala_GtkTreePath_free0 (path);
	path = _tmp7_;
	cell_x = _tmp8_;
	cell_y = _tmp9_;
	if (_tmp10_) {
		GtkTreePath* _tmp11_;
		_tmp11_ = path;
		_tmp6_ = _tmp11_;
	} else {
		_tmp6_ = NULL;
	}
	_tmp12_ = __vala_GtkTreePath_copy0 (_tmp6_);
	result = _tmp12_;
	__vala_GtkTreePath_free0 (path);
	return result;
}

static GtkTreePath*
sidebar_tree_get_current_path (SidebarTree* self)
{
	GtkTreeModel* model = NULL;
	GList* rows = NULL;
	GtkTreeSelection* _tmp0_;
	GtkTreeModel* _tmp1_ = NULL;
	GList* _tmp2_;
	GtkTreeModel* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GList* _tmp5_;
	GtkTreePath* _tmp7_ = NULL;
	GList* _tmp8_;
	GtkTreePath* _tmp11_;
	GtkTreePath* result;
	g_return_val_if_fail (SIDEBAR_IS_TREE (self), NULL);
	_tmp0_ = gtk_tree_view_get_selection (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView));
	_tmp2_ = gtk_tree_selection_get_selected_rows (_tmp0_, &_tmp1_);
	_g_object_unref0 (model);
	_tmp3_ = _g_object_ref0 (_tmp1_);
	model = _tmp3_;
	rows = _tmp2_;
	_tmp5_ = rows;
	if (g_list_length (_tmp5_) == ((guint) 0)) {
		_tmp4_ = TRUE;
	} else {
		GList* _tmp6_;
		_tmp6_ = rows;
		_tmp4_ = g_list_length (_tmp6_) == ((guint) 1);
	}
	_vala_assert (_tmp4_, "rows.length() == 0 || rows.length() == 1");
	_tmp8_ = rows;
	if (g_list_length (_tmp8_) != ((guint) 0)) {
		GList* _tmp9_;
		gconstpointer _tmp10_;
		_tmp9_ = rows;
		_tmp10_ = g_list_nth_data (_tmp9_, (guint) 0);
		_tmp7_ = (GtkTreePath*) _tmp10_;
	} else {
		_tmp7_ = NULL;
	}
	_tmp11_ = __vala_GtkTreePath_copy0 (_tmp7_);
	result = _tmp11_;
	(rows == NULL) ? NULL : (rows = (_g_list_free___vala_GtkTreePath_free0_ (rows), NULL));
	_g_object_unref0 (model);
	return result;
}

static gboolean
sidebar_tree_on_context_menu_keypress (SidebarTree* self)
{
	GList* rows = NULL;
	GtkTreeSelection* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	GtkTreePath* path = NULL;
	GList* _tmp3_;
	gconstpointer _tmp4_;
	GtkTreePath* _tmp5_;
	GtkTreePath* _tmp6_;
	GtkTreePath* _tmp7_;
	GtkTreePath* _tmp8_;
	gboolean result;
	g_return_val_if_fail (SIDEBAR_IS_TREE (self), FALSE);
	_tmp0_ = gtk_tree_view_get_selection (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView));
	_tmp1_ = gtk_tree_selection_get_selected_rows (_tmp0_, NULL);
	rows = _tmp1_;
	_tmp2_ = rows;
	if (_tmp2_ == NULL) {
		result = FALSE;
		(rows == NULL) ? NULL : (rows = (_g_list_free___vala_GtkTreePath_free0_ (rows), NULL));
		return result;
	}
	_tmp3_ = rows;
	_tmp4_ = _tmp3_->data;
	_tmp5_ = __vala_GtkTreePath_copy0 ((GtkTreePath*) _tmp4_);
	path = _tmp5_;
	_tmp6_ = path;
	if (_tmp6_ == NULL) {
		result = FALSE;
		__vala_GtkTreePath_free0 (path);
		(rows == NULL) ? NULL : (rows = (_g_list_free___vala_GtkTreePath_free0_ (rows), NULL));
		return result;
	}
	_tmp7_ = path;
	gtk_tree_view_scroll_to_cell (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), _tmp7_, NULL, FALSE, (gfloat) 0, (gfloat) 0);
	_tmp8_ = path;
	result = sidebar_tree_popup_context_menu (self, _tmp8_, NULL);
	__vala_GtkTreePath_free0 (path);
	(rows == NULL) ? NULL : (rows = (_g_list_free___vala_GtkTreePath_free0_ (rows), NULL));
	return result;
}

static gboolean
sidebar_tree_popup_context_menu (SidebarTree* self,
                                 GtkTreePath* path,
                                 GdkEventButton* event)
{
	SidebarTreeEntryWrapper* wrapper = NULL;
	SidebarTreeEntryWrapper* _tmp0_;
	SidebarTreeEntryWrapper* _tmp1_;
	SidebarContextable* contextable = NULL;
	SidebarTreeEntryWrapper* _tmp2_;
	SidebarEntry* _tmp3_;
	SidebarContextable* _tmp4_;
	SidebarContextable* _tmp5_;
	GtkMenu* context_menu = NULL;
	SidebarContextable* _tmp6_;
	GtkMenu* _tmp7_;
	GtkMenu* _tmp8_;
	GtkMenu* _tmp9_;
	gboolean result;
	g_return_val_if_fail (SIDEBAR_IS_TREE (self), FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = sidebar_tree_get_wrapper_at_path (self, path);
	wrapper = _tmp0_;
	_tmp1_ = wrapper;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_object_unref0 (wrapper);
		return result;
	}
	_tmp2_ = wrapper;
	_tmp3_ = _tmp2_->entry;
	_tmp4_ = _g_object_ref0 (SIDEBAR_IS_CONTEXTABLE (_tmp3_) ? ((SidebarContextable*) _tmp3_) : NULL);
	contextable = _tmp4_;
	_tmp5_ = contextable;
	if (_tmp5_ == NULL) {
		result = FALSE;
		_g_object_unref0 (contextable);
		_g_object_unref0 (wrapper);
		return result;
	}
	_tmp6_ = contextable;
	_tmp7_ = sidebar_contextable_get_sidebar_context_menu (_tmp6_, event);
	context_menu = _tmp7_;
	_tmp8_ = context_menu;
	if (_tmp8_ == NULL) {
		result = FALSE;
		_g_object_unref0 (context_menu);
		_g_object_unref0 (contextable);
		_g_object_unref0 (wrapper);
		return result;
	}
	_tmp9_ = context_menu;
	gtk_menu_popup_at_pointer (_tmp9_, (GdkEvent*) event);
	result = TRUE;
	_g_object_unref0 (context_menu);
	_g_object_unref0 (contextable);
	_g_object_unref0 (wrapper);
	return result;
}

static gboolean
sidebar_tree_popup_default_context_menu (SidebarTree* self,
                                         GdkEventButton* event)
{
	GtkMenu* _tmp0_;
	gboolean result;
	g_return_val_if_fail (SIDEBAR_IS_TREE (self), FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->default_context_menu;
	if (_tmp0_ != NULL) {
		GtkMenu* _tmp1_;
		_tmp1_ = self->priv->default_context_menu;
		gtk_menu_popup_at_pointer (_tmp1_, (GdkEvent*) event);
	}
	result = TRUE;
	return result;
}

static gboolean
sidebar_tree_real_button_press_event (GtkWidget* base,
                                      GdkEventButton* event)
{
	SidebarTree * self;
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SIDEBAR_TYPE_TREE, SidebarTree);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = sidebar_tree_get_path_from_event (self, event);
	path = _tmp0_;
	if (event->button == ((guint) 3)) {
		_tmp1_ = event->type == GDK_BUTTON_PRESS;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GtkTreePath* _tmp2_;
		_tmp2_ = path;
		if (_tmp2_ != NULL) {
			GtkTreePath* _tmp3_;
			_tmp3_ = path;
			sidebar_tree_popup_context_menu (self, _tmp3_, event);
		} else {
			sidebar_tree_popup_default_context_menu (self, event);
		}
	} else {
		gboolean _tmp4_ = FALSE;
		if (event->button == ((guint) 1)) {
			_tmp4_ = event->type == GDK_BUTTON_PRESS;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			GtkTreePath* _tmp5_;
			SidebarTreeEntryWrapper* wrapper = NULL;
			GtkTreePath* _tmp6_;
			SidebarTreeEntryWrapper* _tmp7_;
			SidebarTreeEntryWrapper* _tmp8_;
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_ = FALSE;
			GtkTreeRowReference* _tmp11_;
			gboolean _tmp20_ = FALSE;
			SidebarTreeEntryWrapper* _tmp21_;
			SidebarEntry* _tmp22_;
			GtkTreeStore* _tmp26_;
			GtkTreePath* _tmp27_;
			GtkTreeRowReference* _tmp28_;
			_tmp5_ = path;
			if (_tmp5_ == NULL) {
				__vala_GtkTreeRowReference_free0 (self->priv->old_path_ref);
				self->priv->old_path_ref = NULL;
				result = GTK_WIDGET_CLASS (sidebar_tree_parent_class)->button_press_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), gtk_widget_get_type (), GtkWidget), event);
				__vala_GtkTreePath_free0 (path);
				return result;
			}
			_tmp6_ = path;
			_tmp7_ = sidebar_tree_get_wrapper_at_path (self, _tmp6_);
			wrapper = _tmp7_;
			_tmp8_ = wrapper;
			if (_tmp8_ == NULL) {
				__vala_GtkTreeRowReference_free0 (self->priv->old_path_ref);
				self->priv->old_path_ref = NULL;
				result = GTK_WIDGET_CLASS (sidebar_tree_parent_class)->button_press_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), gtk_widget_get_type (), GtkWidget), event);
				_g_object_unref0 (wrapper);
				__vala_GtkTreePath_free0 (path);
				return result;
			}
			_tmp11_ = self->priv->old_path_ref;
			if (_tmp11_ != NULL) {
				GtkTreeRowReference* _tmp12_;
				GtkTreePath* _tmp13_;
				GtkTreePath* _tmp14_;
				_tmp12_ = self->priv->old_path_ref;
				_tmp13_ = gtk_tree_row_reference_get_path (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp10_ = _tmp14_ != NULL;
				__vala_GtkTreePath_free0 (_tmp14_);
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				GtkTreeRowReference* _tmp15_;
				GtkTreePath* _tmp16_;
				GtkTreePath* _tmp17_;
				GtkTreePath* _tmp18_;
				_tmp15_ = self->priv->old_path_ref;
				_tmp16_ = gtk_tree_row_reference_get_path (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = path;
				_tmp9_ = gtk_tree_path_compare (_tmp17_, _tmp18_) == 0;
				__vala_GtkTreePath_free0 (_tmp17_);
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				GtkCellRendererText* _tmp19_;
				_tmp19_ = self->priv->text_renderer;
				g_object_set (_tmp19_, "editable", FALSE, NULL);
				result = GTK_WIDGET_CLASS (sidebar_tree_parent_class)->button_press_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), gtk_widget_get_type (), GtkWidget), event);
				_g_object_unref0 (wrapper);
				__vala_GtkTreePath_free0 (path);
				return result;
			}
			_tmp21_ = wrapper;
			_tmp22_ = _tmp21_->entry;
			if (SIDEBAR_IS_RENAMEABLE_ENTRY (_tmp22_)) {
				SidebarTreeEntryWrapper* _tmp23_;
				SidebarEntry* _tmp24_;
				_tmp23_ = wrapper;
				_tmp24_ = _tmp23_->entry;
				_tmp20_ = sidebar_renameable_entry_is_user_renameable (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, SIDEBAR_TYPE_RENAMEABLE_ENTRY, SidebarRenameableEntry));
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				GtkCellRendererText* _tmp25_;
				_tmp25_ = self->priv->text_renderer;
				g_object_set (_tmp25_, "editable", TRUE, NULL);
			}
			_tmp26_ = self->priv->store;
			_tmp27_ = path;
			_tmp28_ = gtk_tree_row_reference_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, gtk_tree_model_get_type (), GtkTreeModel), _tmp27_);
			__vala_GtkTreeRowReference_free0 (self->priv->old_path_ref);
			self->priv->old_path_ref = _tmp28_;
			_g_object_unref0 (wrapper);
		}
	}
	result = GTK_WIDGET_CLASS (sidebar_tree_parent_class)->button_press_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), gtk_widget_get_type (), GtkWidget), event);
	__vala_GtkTreePath_free0 (path);
	return result;
}

static gboolean
sidebar_tree_real_key_press_event (GtkWidget* base,
                                   GdkEventKey* event)
{
	SidebarTree * self;
	gboolean handled = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SIDEBAR_TYPE_TREE, SidebarTree);
	g_return_val_if_fail (event != NULL, FALSE);
	handled = FALSE;
	_tmp0_ = gdk_keyval_name (event->keyval);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("F2")))) {
		switch (0) {
			default:
			{
				handled = sidebar_tree_rename_in_place (self);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("Delete")))) {
		switch (0) {
			default:
			{
				GtkTreePath* path = NULL;
				GtkTreePath* _tmp4_;
				gboolean _tmp5_ = FALSE;
				GtkTreePath* _tmp6_;
				_tmp4_ = sidebar_tree_get_current_path (self);
				path = _tmp4_;
				_tmp6_ = path;
				if (_tmp6_ != NULL) {
					GtkTreePath* _tmp7_;
					_tmp7_ = path;
					_tmp5_ = sidebar_tree_destroy_path (self, _tmp7_);
				} else {
					_tmp5_ = FALSE;
				}
				handled = _tmp5_;
				__vala_GtkTreePath_free0 (path);
				break;
			}
		}
	}
	if (!handled) {
		handled = GTK_WIDGET_CLASS (sidebar_tree_parent_class)->key_press_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), gtk_widget_get_type (), GtkWidget), event);
	}
	result = handled;
	return result;
}

gboolean
sidebar_tree_rename_entry_in_place (SidebarTree* self,
                                    SidebarEntry* entry)
{
	gboolean result;
	g_return_val_if_fail (SIDEBAR_IS_TREE (self), FALSE);
	g_return_val_if_fail (SIDEBAR_IS_ENTRY (entry), FALSE);
	if (!sidebar_tree_expand_to_entry (self, entry)) {
		result = FALSE;
		return result;
	}
	if (!sidebar_tree_place_cursor (self, entry, FALSE)) {
		result = FALSE;
		return result;
	}
	result = sidebar_tree_rename_in_place (self);
	return result;
}

static gboolean
sidebar_tree_rename_in_place (SidebarTree* self)
{
	GtkTreePath* cursor_path = NULL;
	GtkTreeViewColumn* cursor_column = NULL;
	GtkTreePath* _tmp0_ = NULL;
	GtkTreeViewColumn* _tmp1_ = NULL;
	GtkTreeViewColumn* _tmp2_;
	GtkTreePath* _tmp3_;
	gboolean result;
	g_return_val_if_fail (SIDEBAR_IS_TREE (self), FALSE);
	gtk_tree_view_get_cursor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), &_tmp0_, &_tmp1_);
	__vala_GtkTreePath_free0 (cursor_path);
	cursor_path = _tmp0_;
	_g_object_unref0 (cursor_column);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	cursor_column = _tmp2_;
	_tmp3_ = cursor_path;
	if (sidebar_tree_can_rename_path (self, _tmp3_)) {
		GtkTreePath* _tmp4_;
		GtkTreeViewColumn* _tmp5_;
		_tmp4_ = cursor_path;
		_tmp5_ = cursor_column;
		gtk_tree_view_set_cursor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), _tmp4_, _tmp5_, TRUE);
		result = TRUE;
		_g_object_unref0 (cursor_column);
		__vala_GtkTreePath_free0 (cursor_path);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (cursor_column);
	__vala_GtkTreePath_free0 (cursor_path);
	return result;
}

gboolean
sidebar_tree_scroll_to_entry (SidebarTree* self,
                              SidebarEntry* entry)
{
	SidebarTreeEntryWrapper* wrapper = NULL;
	SidebarTreeEntryWrapper* _tmp0_;
	SidebarTreeEntryWrapper* _tmp1_;
	SidebarTreeEntryWrapper* _tmp2_;
	GtkTreePath* _tmp3_;
	GtkTreePath* _tmp4_;
	gboolean result;
	g_return_val_if_fail (SIDEBAR_IS_TREE (self), FALSE);
	g_return_val_if_fail (SIDEBAR_IS_ENTRY (entry), FALSE);
	_tmp0_ = sidebar_tree_get_wrapper (self, entry);
	wrapper = _tmp0_;
	_tmp1_ = wrapper;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_object_unref0 (wrapper);
		return result;
	}
	_tmp2_ = wrapper;
	_tmp3_ = sidebar_tree_entry_wrapper_get_path (_tmp2_);
	_tmp4_ = _tmp3_;
	gtk_tree_view_scroll_to_cell (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), _tmp4_, NULL, FALSE, (gfloat) 0, (gfloat) 0);
	__vala_GtkTreePath_free0 (_tmp4_);
	result = TRUE;
	_g_object_unref0 (wrapper);
	return result;
}

static void
sidebar_tree_real_drag_data_get (GtkWidget* base,
                                 GdkDragContext* context,
                                 GtkSelectionData* selection_data,
                                 guint info,
                                 guint time)
{
	SidebarTree * self;
	SidebarInternalDragSourceEntry* drag_source = NULL;
	SidebarEntry* _tmp0_;
	SidebarInternalDragSourceEntry* _tmp6_;
	SidebarInternalDragSourceEntry* _tmp16_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SIDEBAR_TYPE_TREE, SidebarTree);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (context, gdk_drag_context_get_type ()));
	g_return_if_fail (selection_data != NULL);
	drag_source = NULL;
	_tmp0_ = self->priv->internal_drag_source_entry;
	if (_tmp0_ != NULL) {
		SidebarSelectableEntry* selectable = NULL;
		SidebarEntry* _tmp1_;
		SidebarSelectableEntry* _tmp2_;
		SidebarSelectableEntry* _tmp3_;
		_tmp1_ = self->priv->internal_drag_source_entry;
		_tmp2_ = _g_object_ref0 (SIDEBAR_IS_SELECTABLE_ENTRY (_tmp1_) ? ((SidebarSelectableEntry*) _tmp1_) : NULL);
		selectable = _tmp2_;
		_tmp3_ = selectable;
		if (_tmp3_ == NULL) {
			SidebarEntry* _tmp4_;
			SidebarInternalDragSourceEntry* _tmp5_;
			_tmp4_ = self->priv->internal_drag_source_entry;
			_tmp5_ = _g_object_ref0 (SIDEBAR_IS_INTERNAL_DRAG_SOURCE_ENTRY (_tmp4_) ? ((SidebarInternalDragSourceEntry*) _tmp4_) : NULL);
			_g_object_unref0 (drag_source);
			drag_source = _tmp5_;
		}
		_g_object_unref0 (selectable);
	}
	_tmp6_ = drag_source;
	if (_tmp6_ == NULL) {
		GtkTreePath* selected_path = NULL;
		GtkTreePath* _tmp7_;
		GtkTreePath* _tmp8_;
		SidebarTreeEntryWrapper* wrapper = NULL;
		GtkTreePath* _tmp9_;
		SidebarTreeEntryWrapper* _tmp10_;
		SidebarTreeEntryWrapper* _tmp11_;
		SidebarTreeEntryWrapper* _tmp12_;
		SidebarEntry* _tmp13_;
		SidebarInternalDragSourceEntry* _tmp14_;
		SidebarInternalDragSourceEntry* _tmp15_;
		_tmp7_ = sidebar_tree_get_selected_path (self);
		selected_path = _tmp7_;
		_tmp8_ = selected_path;
		if (_tmp8_ == NULL) {
			__vala_GtkTreePath_free0 (selected_path);
			_g_object_unref0 (drag_source);
			return;
		}
		_tmp9_ = selected_path;
		_tmp10_ = sidebar_tree_get_wrapper_at_path (self, _tmp9_);
		wrapper = _tmp10_;
		_tmp11_ = wrapper;
		if (_tmp11_ == NULL) {
			_g_object_unref0 (wrapper);
			__vala_GtkTreePath_free0 (selected_path);
			_g_object_unref0 (drag_source);
			return;
		}
		_tmp12_ = wrapper;
		_tmp13_ = _tmp12_->entry;
		_tmp14_ = _g_object_ref0 (SIDEBAR_IS_INTERNAL_DRAG_SOURCE_ENTRY (_tmp13_) ? ((SidebarInternalDragSourceEntry*) _tmp13_) : NULL);
		_g_object_unref0 (drag_source);
		drag_source = _tmp14_;
		_tmp15_ = drag_source;
		if (_tmp15_ == NULL) {
			_g_object_unref0 (wrapper);
			__vala_GtkTreePath_free0 (selected_path);
			_g_object_unref0 (drag_source);
			return;
		}
		_g_object_unref0 (wrapper);
		__vala_GtkTreePath_free0 (selected_path);
	}
	_tmp16_ = drag_source;
	sidebar_internal_drag_source_entry_prepare_selection_data (_tmp16_, selection_data);
	_g_object_unref0 (drag_source);
}

static void
sidebar_tree_real_drag_data_received (GtkWidget* base,
                                      GdkDragContext* context,
                                      gint x,
                                      gint y,
                                      GtkSelectionData* selection_data,
                                      guint info,
                                      guint time)
{
	SidebarTree * self;
	GtkTreePath* path = NULL;
	GtkTreeViewDropPosition pos = 0;
	GtkTreePath* _tmp0_ = NULL;
	GtkTreeViewDropPosition _tmp1_ = 0;
	gboolean _tmp2_;
	SidebarTreeEntryWrapper* wrapper = NULL;
	GtkTreePath* _tmp5_;
	SidebarTreeEntryWrapper* _tmp6_;
	GtkWidget* _tmp7_;
	SidebarTreeEntryWrapper* _tmp13_;
	SidebarInternalDropTargetEntry* targetable = NULL;
	SidebarTreeEntryWrapper* _tmp14_;
	SidebarEntry* _tmp15_;
	SidebarInternalDropTargetEntry* _tmp16_;
	SidebarInternalDropTargetEntry* _tmp17_;
	gboolean success = FALSE;
	SidebarInternalDropTargetEntry* _tmp18_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SIDEBAR_TYPE_TREE, SidebarTree);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (context, gdk_drag_context_get_type ()));
	g_return_if_fail (selection_data != NULL);
	_tmp2_ = gtk_tree_view_get_dest_row_at_pos (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), x, y, &_tmp0_, &_tmp1_);
	__vala_GtkTreePath_free0 (path);
	path = _tmp0_;
	pos = _tmp1_;
	if (!_tmp2_) {
		GtkWidget* _tmp3_;
		_tmp3_ = gtk_drag_get_source_widget (context);
		if (_tmp3_ == NULL) {
			SidebarTreeExternalDropHandler _tmp4_;
			gpointer _tmp4__target;
			_tmp4_ = self->priv->drop_handler;
			_tmp4__target = self->priv->drop_handler_target;
			_tmp4_ (context, NULL, selection_data, info, time, _tmp4__target);
		} else {
			gtk_drag_finish (context, FALSE, FALSE, (guint32) time);
		}
		__vala_GtkTreePath_free0 (path);
		return;
	}
	_tmp5_ = path;
	_tmp6_ = sidebar_tree_get_wrapper_at_path (self, _tmp5_);
	wrapper = _tmp6_;
	_tmp7_ = gtk_drag_get_source_widget (context);
	if (_tmp7_ == NULL) {
		SidebarEntry* _tmp8_ = NULL;
		SidebarTreeEntryWrapper* _tmp9_;
		SidebarTreeExternalDropHandler _tmp12_;
		gpointer _tmp12__target;
		_tmp9_ = wrapper;
		if (_tmp9_ != NULL) {
			SidebarTreeEntryWrapper* _tmp10_;
			SidebarEntry* _tmp11_;
			_tmp10_ = wrapper;
			_tmp11_ = _tmp10_->entry;
			_tmp8_ = _tmp11_;
		} else {
			_tmp8_ = NULL;
		}
		_tmp12_ = self->priv->drop_handler;
		_tmp12__target = self->priv->drop_handler_target;
		_tmp12_ (context, _tmp8_, selection_data, info, time, _tmp12__target);
		_g_object_unref0 (wrapper);
		__vala_GtkTreePath_free0 (path);
		return;
	}
	_tmp13_ = wrapper;
	if (_tmp13_ == NULL) {
		gtk_drag_finish (context, FALSE, FALSE, (guint32) time);
		_g_object_unref0 (wrapper);
		__vala_GtkTreePath_free0 (path);
		return;
	}
	_tmp14_ = wrapper;
	_tmp15_ = _tmp14_->entry;
	_tmp16_ = _g_object_ref0 (SIDEBAR_IS_INTERNAL_DROP_TARGET_ENTRY (_tmp15_) ? ((SidebarInternalDropTargetEntry*) _tmp15_) : NULL);
	targetable = _tmp16_;
	_tmp17_ = targetable;
	if (_tmp17_ == NULL) {
		gtk_drag_finish (context, FALSE, FALSE, (guint32) time);
		_g_object_unref0 (targetable);
		_g_object_unref0 (wrapper);
		__vala_GtkTreePath_free0 (path);
		return;
	}
	_tmp18_ = targetable;
	success = sidebar_internal_drop_target_entry_internal_drop_received (_tmp18_, self, context, selection_data);
	gtk_drag_finish (context, success, FALSE, (guint32) time);
	_g_object_unref0 (targetable);
	_g_object_unref0 (wrapper);
	__vala_GtkTreePath_free0 (path);
}

static gboolean
sidebar_tree_real_drag_motion (GtkWidget* base,
                               GdkDragContext* context,
                               gint x,
                               gint y,
                               guint time)
{
	SidebarTree * self;
	GtkTreePath* path = NULL;
	GtkTreeViewDropPosition pos = 0;
	gboolean has_dest = FALSE;
	GtkTreePath* _tmp0_ = NULL;
	GtkTreeViewDropPosition _tmp1_ = 0;
	gboolean _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SIDEBAR_TYPE_TREE, SidebarTree);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (context, gdk_drag_context_get_type ()), FALSE);
	GTK_WIDGET_CLASS (sidebar_tree_parent_class)->drag_motion (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), gtk_widget_get_type (), GtkWidget), context, x, y, time);
	_tmp2_ = gtk_tree_view_get_dest_row_at_pos (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), x, y, &_tmp0_, &_tmp1_);
	__vala_GtkTreePath_free0 (path);
	path = _tmp0_;
	pos = _tmp1_;
	has_dest = _tmp2_;
	if (!has_dest) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = pos == GTK_TREE_VIEW_DROP_BEFORE;
	}
	if (_tmp3_) {
		GtkTreePath* _tmp4_;
		_tmp4_ = path;
		gtk_tree_view_set_drag_dest_row (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), _tmp4_, GTK_TREE_VIEW_DROP_INTO_OR_BEFORE);
	} else {
		if (pos == GTK_TREE_VIEW_DROP_AFTER) {
			GtkTreePath* _tmp5_;
			_tmp5_ = path;
			gtk_tree_view_set_drag_dest_row (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), _tmp5_, GTK_TREE_VIEW_DROP_INTO_OR_AFTER);
		}
	}
	gdk_drag_status (context, gdk_drag_context_get_suggested_action (context), (guint32) time);
	result = has_dest;
	__vala_GtkTreePath_free0 (path);
	return result;
}

static gboolean
sidebar_tree_can_rename_path (SidebarTree* self,
                              GtkTreePath* path)
{
	SidebarTreeEntryWrapper* wrapper = NULL;
	SidebarTreeEntryWrapper* _tmp0_;
	SidebarTreeEntryWrapper* _tmp1_;
	SidebarRenameableEntry* renameable = NULL;
	SidebarTreeEntryWrapper* _tmp2_;
	SidebarEntry* _tmp3_;
	SidebarRenameableEntry* _tmp4_;
	SidebarRenameableEntry* _tmp5_;
	SidebarTreeEntryWrapper* _tmp6_;
	SidebarEntry* _tmp7_;
	GtkTreeSelection* _tmp8_;
	gboolean result;
	g_return_val_if_fail (SIDEBAR_IS_TREE (self), FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	if (self->priv->editing_disabled > 0) {
		result = FALSE;
		return result;
	}
	_tmp0_ = sidebar_tree_get_wrapper_at_path (self, path);
	wrapper = _tmp0_;
	_tmp1_ = wrapper;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_object_unref0 (wrapper);
		return result;
	}
	_tmp2_ = wrapper;
	_tmp3_ = _tmp2_->entry;
	_tmp4_ = _g_object_ref0 (SIDEBAR_IS_RENAMEABLE_ENTRY (_tmp3_) ? ((SidebarRenameableEntry*) _tmp3_) : NULL);
	renameable = _tmp4_;
	_tmp5_ = renameable;
	if (_tmp5_ == NULL) {
		result = FALSE;
		_g_object_unref0 (renameable);
		_g_object_unref0 (wrapper);
		return result;
	}
	_tmp6_ = wrapper;
	_tmp7_ = _tmp6_->entry;
	if (SIDEBAR_IS_GROUPING (_tmp7_)) {
		result = FALSE;
		_g_object_unref0 (renameable);
		_g_object_unref0 (wrapper);
		return result;
	}
	_tmp8_ = gtk_tree_view_get_selection (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView));
	gtk_tree_selection_select_path (_tmp8_, path);
	result = TRUE;
	_g_object_unref0 (renameable);
	_g_object_unref0 (wrapper);
	return result;
}

static gboolean
sidebar_tree_destroy_path (SidebarTree* self,
                           GtkTreePath* path)
{
	SidebarTreeEntryWrapper* wrapper = NULL;
	SidebarTreeEntryWrapper* _tmp0_;
	SidebarTreeEntryWrapper* _tmp1_;
	SidebarDestroyableEntry* destroyable = NULL;
	SidebarTreeEntryWrapper* _tmp2_;
	SidebarEntry* _tmp3_;
	SidebarDestroyableEntry* _tmp4_;
	SidebarDestroyableEntry* _tmp5_;
	SidebarDestroyableEntry* _tmp6_;
	gboolean result;
	g_return_val_if_fail (SIDEBAR_IS_TREE (self), FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = sidebar_tree_get_wrapper_at_path (self, path);
	wrapper = _tmp0_;
	_tmp1_ = wrapper;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_object_unref0 (wrapper);
		return result;
	}
	_tmp2_ = wrapper;
	_tmp3_ = _tmp2_->entry;
	_tmp4_ = _g_object_ref0 (SIDEBAR_IS_DESTROYABLE_ENTRY (_tmp3_) ? ((SidebarDestroyableEntry*) _tmp3_) : NULL);
	destroyable = _tmp4_;
	_tmp5_ = destroyable;
	if (_tmp5_ == NULL) {
		result = FALSE;
		_g_object_unref0 (destroyable);
		_g_object_unref0 (wrapper);
		return result;
	}
	_tmp6_ = destroyable;
	sidebar_destroyable_entry_destroy_source (_tmp6_);
	result = TRUE;
	_g_object_unref0 (destroyable);
	_g_object_unref0 (wrapper);
	return result;
}

static void
_sidebar_tree_on_editing_done_gtk_cell_editable_editing_done (GtkCellEditable* _sender,
                                                              gpointer self)
{
	sidebar_tree_on_editing_done ((SidebarTree*) self);
}

static gboolean
_sidebar_tree_on_editing_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                               GdkEventFocus* event,
                                                               gpointer self)
{
	gboolean result;
	result = sidebar_tree_on_editing_focus_out ((SidebarTree*) self, event);
	return result;
}

static void
sidebar_tree_on_editing_started (SidebarTree* self,
                                 GtkCellEditable* editable,
                                 const gchar* path)
{
	g_return_if_fail (SIDEBAR_IS_TREE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (editable, gtk_cell_editable_get_type ()));
	g_return_if_fail (path != NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (editable, gtk_entry_get_type ())) {
		GtkEntry* _tmp0_;
		GtkEntry* _tmp1_;
		GtkEntry* _tmp2_;
		GtkEntry* _tmp3_;
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (editable, gtk_entry_get_type (), GtkEntry));
		_g_object_unref0 (self->priv->text_entry);
		self->priv->text_entry = _tmp0_;
		_tmp1_ = self->priv->text_entry;
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_cell_editable_get_type (), GtkCellEditable), "editing-done", (GCallback) _sidebar_tree_on_editing_done_gtk_cell_editable_editing_done, self, 0);
		_tmp2_ = self->priv->text_entry;
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), "focus-out-event", (GCallback) _sidebar_tree_on_editing_focus_out_gtk_widget_focus_out_event, self, 0);
		_tmp3_ = self->priv->text_entry;
		g_object_set (_tmp3_, "editable", TRUE, NULL);
	}
}

static void
sidebar_tree_on_editing_canceled (SidebarTree* self)
{
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	guint _tmp2_;
	GtkEntry* _tmp3_;
	guint _tmp4_;
	g_return_if_fail (SIDEBAR_IS_TREE (self));
	_tmp0_ = self->priv->text_entry;
	g_object_set (_tmp0_, "editable", FALSE, NULL);
	_tmp1_ = self->priv->text_entry;
	g_signal_parse_name ("editing-done", gtk_cell_editable_get_type (), &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_cell_editable_get_type (), GtkCellEditable), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _sidebar_tree_on_editing_done_gtk_cell_editable_editing_done, self);
	_tmp3_ = self->priv->text_entry;
	g_signal_parse_name ("focus-out-event", gtk_widget_get_type (), &_tmp4_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _sidebar_tree_on_editing_focus_out_gtk_widget_focus_out_event, self);
}

static void
sidebar_tree_on_editing_done (SidebarTree* self)
{
	GtkEntry* _tmp0_;
	SidebarTreeEntryWrapper* wrapper = NULL;
	GtkTreePath* _tmp1_;
	GtkTreePath* _tmp2_;
	SidebarTreeEntryWrapper* _tmp3_;
	SidebarTreeEntryWrapper* _tmp4_;
	SidebarTreeEntryWrapper* _tmp5_;
	GtkEntry* _tmp13_;
	guint _tmp14_;
	GtkEntry* _tmp15_;
	guint _tmp16_;
	g_return_if_fail (SIDEBAR_IS_TREE (self));
	_tmp0_ = self->priv->text_entry;
	g_object_set (_tmp0_, "editable", FALSE, NULL);
	_tmp1_ = sidebar_tree_get_current_path (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = sidebar_tree_get_wrapper_at_path (self, _tmp2_);
	_tmp4_ = _tmp3_;
	__vala_GtkTreePath_free0 (_tmp2_);
	wrapper = _tmp4_;
	_tmp5_ = wrapper;
	if (_tmp5_ != NULL) {
		SidebarRenameableEntry* renameable = NULL;
		SidebarTreeEntryWrapper* _tmp6_;
		SidebarEntry* _tmp7_;
		SidebarRenameableEntry* _tmp8_;
		SidebarRenameableEntry* _tmp9_;
		_tmp6_ = wrapper;
		_tmp7_ = _tmp6_->entry;
		_tmp8_ = _g_object_ref0 (SIDEBAR_IS_RENAMEABLE_ENTRY (_tmp7_) ? ((SidebarRenameableEntry*) _tmp7_) : NULL);
		renameable = _tmp8_;
		_tmp9_ = renameable;
		if (_tmp9_ != NULL) {
			SidebarRenameableEntry* _tmp10_;
			GtkEntry* _tmp11_;
			const gchar* _tmp12_;
			_tmp10_ = renameable;
			_tmp11_ = self->priv->text_entry;
			_tmp12_ = gtk_entry_get_text (_tmp11_);
			sidebar_renameable_entry_rename (_tmp10_, _tmp12_);
		}
		_g_object_unref0 (renameable);
	}
	_tmp13_ = self->priv->text_entry;
	g_signal_parse_name ("editing-done", gtk_cell_editable_get_type (), &_tmp14_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_cell_editable_get_type (), GtkCellEditable), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp14_, 0, NULL, (GCallback) _sidebar_tree_on_editing_done_gtk_cell_editable_editing_done, self);
	_tmp15_ = self->priv->text_entry;
	g_signal_parse_name ("focus-out-event", gtk_widget_get_type (), &_tmp16_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp16_, 0, NULL, (GCallback) _sidebar_tree_on_editing_focus_out_gtk_widget_focus_out_event, self);
	_g_object_unref0 (wrapper);
}

static gboolean
sidebar_tree_on_editing_focus_out (SidebarTree* self,
                                   GdkEventFocus* event)
{
	gboolean result;
	g_return_val_if_fail (SIDEBAR_IS_TREE (self), FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	result = FALSE;
	return result;
}

static SidebarTreeEntryWrapper*
sidebar_tree_entry_wrapper_construct (GType object_type,
                                      GtkTreeModel* model,
                                      SidebarEntry* entry,
                                      GtkTreePath* path)
{
	SidebarTreeEntryWrapper * self = NULL;
	SidebarEntry* _tmp0_;
	GtkTreeRowReference* _tmp1_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (model, gtk_tree_model_get_type ()), NULL);
	g_return_val_if_fail (SIDEBAR_IS_ENTRY (entry), NULL);
	g_return_val_if_fail (path != NULL, NULL);
	self = (SidebarTreeEntryWrapper*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (entry);
	_g_object_unref0 (self->entry);
	self->entry = _tmp0_;
	_tmp1_ = gtk_tree_row_reference_new (model, path);
	__vala_GtkTreeRowReference_free0 (self->row);
	self->row = _tmp1_;
	return self;
}

static SidebarTreeEntryWrapper*
sidebar_tree_entry_wrapper_new (GtkTreeModel* model,
                                SidebarEntry* entry,
                                GtkTreePath* path)
{
	return sidebar_tree_entry_wrapper_construct (SIDEBAR_TREE_TYPE_ENTRY_WRAPPER, model, entry, path);
}

static GtkTreePath*
sidebar_tree_entry_wrapper_get_path (SidebarTreeEntryWrapper* self)
{
	GtkTreeRowReference* _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* result;
	g_return_val_if_fail (SIDEBAR_TREE_IS_ENTRY_WRAPPER (self), NULL);
	_tmp0_ = self->row;
	_tmp1_ = gtk_tree_row_reference_get_path (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
sidebar_tree_entry_wrapper_get_iter (SidebarTreeEntryWrapper* self,
                                     GtkTreeIter* result)
{
	GtkTreeIter iter = {0};
	gboolean valid = FALSE;
	GtkTreeRowReference* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreePath* _tmp2_;
	GtkTreePath* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (SIDEBAR_TREE_IS_ENTRY_WRAPPER (self));
	_tmp0_ = self->row;
	_tmp1_ = gtk_tree_row_reference_get_model (_tmp0_);
	_tmp2_ = sidebar_tree_entry_wrapper_get_path (self);
	_tmp3_ = _tmp2_;
	_tmp5_ = gtk_tree_model_get_iter (_tmp1_, &_tmp4_, _tmp3_);
	iter = _tmp4_;
	_tmp6_ = _tmp5_;
	__vala_GtkTreePath_free0 (_tmp3_);
	valid = _tmp6_;
	_vala_assert (valid, "valid");
	*result = iter;
	return;
}

static void
sidebar_tree_entry_wrapper_class_init (SidebarTreeEntryWrapperClass * klass,
                                       gpointer klass_data)
{
	sidebar_tree_entry_wrapper_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = sidebar_tree_entry_wrapper_finalize;
}

static void
sidebar_tree_entry_wrapper_instance_init (SidebarTreeEntryWrapper * self,
                                          gpointer klass)
{
}

static void
sidebar_tree_entry_wrapper_finalize (GObject * obj)
{
	SidebarTreeEntryWrapper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SIDEBAR_TREE_TYPE_ENTRY_WRAPPER, SidebarTreeEntryWrapper);
	_g_object_unref0 (self->entry);
	__vala_GtkTreeRowReference_free0 (self->row);
	G_OBJECT_CLASS (sidebar_tree_entry_wrapper_parent_class)->finalize (obj);
}

static GType
sidebar_tree_entry_wrapper_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SidebarTreeEntryWrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sidebar_tree_entry_wrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SidebarTreeEntryWrapper), 0, (GInstanceInitFunc) sidebar_tree_entry_wrapper_instance_init, NULL };
	GType sidebar_tree_entry_wrapper_type_id;
	sidebar_tree_entry_wrapper_type_id = g_type_register_static (G_TYPE_OBJECT, "SidebarTreeEntryWrapper", &g_define_type_info, 0);
	return sidebar_tree_entry_wrapper_type_id;
}

static GType
sidebar_tree_entry_wrapper_get_type (void)
{
	static volatile gsize sidebar_tree_entry_wrapper_type_id__once = 0;
	if (g_once_init_enter (&sidebar_tree_entry_wrapper_type_id__once)) {
		GType sidebar_tree_entry_wrapper_type_id;
		sidebar_tree_entry_wrapper_type_id = sidebar_tree_entry_wrapper_get_type_once ();
		g_once_init_leave (&sidebar_tree_entry_wrapper_type_id__once, sidebar_tree_entry_wrapper_type_id);
	}
	return sidebar_tree_entry_wrapper_type_id__once;
}

static SidebarTreeRootWrapper*
sidebar_tree_root_wrapper_construct (GType object_type,
                                     GtkTreeModel* model,
                                     SidebarEntry* entry,
                                     GtkTreePath* path,
                                     gint root_position)
{
	SidebarTreeRootWrapper * self = NULL;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (model, gtk_tree_model_get_type ()), NULL);
	g_return_val_if_fail (SIDEBAR_IS_ENTRY (entry), NULL);
	g_return_val_if_fail (path != NULL, NULL);
	self = (SidebarTreeRootWrapper*) sidebar_tree_entry_wrapper_construct (object_type, model, entry, path);
	self->root_position = root_position;
	return self;
}

static SidebarTreeRootWrapper*
sidebar_tree_root_wrapper_new (GtkTreeModel* model,
                               SidebarEntry* entry,
                               GtkTreePath* path,
                               gint root_position)
{
	return sidebar_tree_root_wrapper_construct (SIDEBAR_TREE_TYPE_ROOT_WRAPPER, model, entry, path, root_position);
}

static void
sidebar_tree_root_wrapper_class_init (SidebarTreeRootWrapperClass * klass,
                                      gpointer klass_data)
{
	sidebar_tree_root_wrapper_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = sidebar_tree_root_wrapper_finalize;
}

static void
sidebar_tree_root_wrapper_instance_init (SidebarTreeRootWrapper * self,
                                         gpointer klass)
{
}

static void
sidebar_tree_root_wrapper_finalize (GObject * obj)
{
	SidebarTreeRootWrapper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SIDEBAR_TREE_TYPE_ROOT_WRAPPER, SidebarTreeRootWrapper);
	G_OBJECT_CLASS (sidebar_tree_root_wrapper_parent_class)->finalize (obj);
}

static GType
sidebar_tree_root_wrapper_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SidebarTreeRootWrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sidebar_tree_root_wrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SidebarTreeRootWrapper), 0, (GInstanceInitFunc) sidebar_tree_root_wrapper_instance_init, NULL };
	GType sidebar_tree_root_wrapper_type_id;
	sidebar_tree_root_wrapper_type_id = g_type_register_static (SIDEBAR_TREE_TYPE_ENTRY_WRAPPER, "SidebarTreeRootWrapper", &g_define_type_info, 0);
	return sidebar_tree_root_wrapper_type_id;
}

static GType
sidebar_tree_root_wrapper_get_type (void)
{
	static volatile gsize sidebar_tree_root_wrapper_type_id__once = 0;
	if (g_once_init_enter (&sidebar_tree_root_wrapper_type_id__once)) {
		GType sidebar_tree_root_wrapper_type_id;
		sidebar_tree_root_wrapper_type_id = sidebar_tree_root_wrapper_get_type_once ();
		g_once_init_leave (&sidebar_tree_root_wrapper_type_id__once, sidebar_tree_root_wrapper_type_id);
	}
	return sidebar_tree_root_wrapper_type_id__once;
}

static void
sidebar_tree_class_init (SidebarTreeClass * klass,
                         gpointer klass_data)
{
	sidebar_tree_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SidebarTree_private_offset);
	((SidebarTreeClass *) klass)->accept_cursor_changed = (gboolean (*) (SidebarTree*)) sidebar_tree_real_accept_cursor_changed;
	((GtkTreeViewClass *) klass)->row_activated = (void (*) (GtkTreeView*, GtkTreePath*, GtkTreeViewColumn*)) sidebar_tree_real_row_activated;
	((GtkTreeViewClass *) klass)->cursor_changed = (void (*) (GtkTreeView*)) sidebar_tree_real_cursor_changed;
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) sidebar_tree_real_button_press_event;
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget*, GdkEventKey*)) sidebar_tree_real_key_press_event;
	((GtkWidgetClass *) klass)->drag_data_get = (void (*) (GtkWidget*, GdkDragContext*, GtkSelectionData*, guint, guint)) sidebar_tree_real_drag_data_get;
	((GtkWidgetClass *) klass)->drag_data_received = (void (*) (GtkWidget*, GdkDragContext*, gint, gint, GtkSelectionData*, guint, guint)) sidebar_tree_real_drag_data_received;
	((GtkWidgetClass *) klass)->drag_motion = (gboolean (*) (GtkWidget*, GdkDragContext*, gint, gint, guint)) sidebar_tree_real_drag_motion;
	G_OBJECT_CLASS (klass)->finalize = sidebar_tree_finalize;
	sidebar_tree_signals[SIDEBAR_TREE_ENTRY_SELECTED_SIGNAL] = g_signal_new ("entry-selected", SIDEBAR_TYPE_TREE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SIDEBAR_TYPE_SELECTABLE_ENTRY);
	sidebar_tree_signals[SIDEBAR_TREE_ENTRY_ACTIVATED_SIGNAL] = g_signal_new ("entry-activated", SIDEBAR_TYPE_TREE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SIDEBAR_TYPE_SELECTABLE_ENTRY);
	sidebar_tree_signals[SIDEBAR_TREE_SELECTED_ENTRY_REMOVED_SIGNAL] = g_signal_new ("selected-entry-removed", SIDEBAR_TYPE_TREE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SIDEBAR_TYPE_SELECTABLE_ENTRY);
	sidebar_tree_signals[SIDEBAR_TREE_BRANCH_ADDED_SIGNAL] = g_signal_new ("branch-added", SIDEBAR_TYPE_TREE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SIDEBAR_TYPE_BRANCH);
	sidebar_tree_signals[SIDEBAR_TREE_BRANCH_REMOVED_SIGNAL] = g_signal_new ("branch-removed", SIDEBAR_TYPE_TREE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SIDEBAR_TYPE_BRANCH);
	sidebar_tree_signals[SIDEBAR_TREE_BRANCH_SHOWN_SIGNAL] = g_signal_new ("branch-shown", SIDEBAR_TYPE_TREE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN, G_TYPE_NONE, 2, SIDEBAR_TYPE_BRANCH, G_TYPE_BOOLEAN);
}

static void
sidebar_tree_instance_init (SidebarTree * self,
                            gpointer klass)
{
	GtkTreeStore* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	self->priv = sidebar_tree_get_instance_private (self);
	_tmp0_ = gtk_tree_store_new ((gint) SIDEBAR_TREE_COLUMNS_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, SIDEBAR_TREE_TYPE_ENTRY_WRAPPER, G_TYPE_STRING, G_TYPE_INT);
	self->priv->store = _tmp0_;
	self->priv->text_entry = NULL;
	_tmp1_ = gee_hash_map_new (SIDEBAR_TYPE_ENTRY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, SIDEBAR_TREE_TYPE_ENTRY_WRAPPER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->entry_map = _tmp1_;
	_tmp2_ = gee_hash_map_new (SIDEBAR_TYPE_BRANCH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->branches = _tmp2_;
	self->priv->editing_disabled = 0;
	self->priv->mask_entry_selected_signal = FALSE;
	self->priv->selected_wrapper = NULL;
	self->priv->default_context_menu = NULL;
	self->priv->is_internal_drag_in_progress = FALSE;
	self->priv->internal_drag_source_entry = NULL;
	self->priv->old_path_ref = NULL;
}

static void
sidebar_tree_finalize (GObject * obj)
{
	SidebarTree * self;
	GtkCellRendererText* _tmp0_;
	guint _tmp1_;
	GtkCellRendererText* _tmp2_;
	guint _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SIDEBAR_TYPE_TREE, SidebarTree);
	_tmp0_ = self->priv->text_renderer;
	g_signal_parse_name ("editing-canceled", gtk_cell_renderer_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_cell_renderer_get_type (), GtkCellRenderer), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _sidebar_tree_on_editing_canceled_gtk_cell_renderer_editing_canceled, self);
	_tmp2_ = self->priv->text_renderer;
	g_signal_parse_name ("editing-started", gtk_cell_renderer_get_type (), &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_cell_renderer_get_type (), GtkCellRenderer), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _sidebar_tree_on_editing_started_gtk_cell_renderer_editing_started, self);
	_g_object_unref0 (self->priv->store);
	_g_object_unref0 (self->priv->icon_theme);
	_g_object_unref0 (self->priv->text_column);
	_g_object_unref0 (self->priv->text_renderer);
	_g_object_unref0 (self->priv->text_entry);
	_g_object_unref0 (self->priv->entry_map);
	_g_object_unref0 (self->priv->branches);
	_g_object_unref0 (self->priv->default_context_menu);
	_g_object_unref0 (self->priv->internal_drag_source_entry);
	__vala_GtkTreeRowReference_free0 (self->priv->old_path_ref);
	G_OBJECT_CLASS (sidebar_tree_parent_class)->finalize (obj);
}

static GType
sidebar_tree_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SidebarTreeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sidebar_tree_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SidebarTree), 0, (GInstanceInitFunc) sidebar_tree_instance_init, NULL };
	GType sidebar_tree_type_id;
	sidebar_tree_type_id = g_type_register_static (gtk_tree_view_get_type (), "SidebarTree", &g_define_type_info, 0);
	SidebarTree_private_offset = g_type_add_instance_private (sidebar_tree_type_id, sizeof (SidebarTreePrivate));
	return sidebar_tree_type_id;
}

GType
sidebar_tree_get_type (void)
{
	static volatile gsize sidebar_tree_type_id__once = 0;
	if (g_once_init_enter (&sidebar_tree_type_id__once)) {
		GType sidebar_tree_type_id;
		sidebar_tree_type_id = sidebar_tree_get_type_once ();
		g_once_init_leave (&sidebar_tree_type_id__once, sidebar_tree_type_id);
	}
	return sidebar_tree_type_id__once;
}

