/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "gdm-session-glue.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_service_name,
        const gchar *arg_query,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_service_name,
        const gchar *arg_prompt_message,
        GVariant *arg_query,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              g_marshal_value_peek_variant (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_UINT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringUintStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_service_name,
        const gchar *arg_protocol,
        guint arg_version,
        const gchar *arg_request,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringUintStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 6);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringUintStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              g_marshal_value_peek_uint (param_values + 4),
              g_marshal_value_peek_string (param_values + 5),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_VOID__STRING_STRING (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_StringStringFunc)
       (void *data1,
        const gchar *arg_service_name,
        const gchar *arg_info,
        void *data2);
  _GDbusCodegenMarshalVoid_StringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_StringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_string (param_values + 1),
            g_marshal_value_peek_string (param_values + 2),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOXED (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectBoxedFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *const *arg_extensions,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectBoxedFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectBoxedFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_boxed (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_service_name,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_VOID__STRING_STRING_VARIANT (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_StringStringVariantFunc)
       (void *data1,
        const gchar *arg_service_name,
        const gchar *arg_prompt_message,
        GVariant *arg_list,
        void *data2);
  _GDbusCodegenMarshalVoid_StringStringVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_StringStringVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_string (param_values + 1),
            g_marshal_value_peek_string (param_values + 2),
            g_marshal_value_peek_variant (param_values + 3),
            data2);
}

static void
_g_dbus_codegen_marshal_VOID__STRING_STRING_UINT_STRING (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_StringStringUintStringFunc)
       (void *data1,
        const gchar *arg_service_name,
        const gchar *arg_protocol,
        guint arg_version,
        const gchar *arg_request,
        void *data2);
  _GDbusCodegenMarshalVoid_StringStringUintStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_StringStringUintStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_string (param_values + 1),
            g_marshal_value_peek_string (param_values + 2),
            g_marshal_value_peek_uint (param_values + 3),
            g_marshal_value_peek_string (param_values + 4),
            data2);
}

static void
_g_dbus_codegen_marshal_VOID__STRING_INT (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_StringIntFunc)
       (void *data1,
        const gchar *arg_username,
        gint arg_delay,
        void *data2);
  _GDbusCodegenMarshalVoid_StringIntFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_StringIntFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_string (param_values + 1),
            g_marshal_value_peek_int (param_values + 2),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_BOOLEAN (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringBooleanFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_service_name,
        gboolean arg_should_start_session,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringBooleanFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringBooleanFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_boolean (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.DisplayManager.WorkerManager
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GdmDBusWorkerManager
 * @title: GdmDBusWorkerManager
 * @short_description: Generated C code for the org.gnome.DisplayManager.WorkerManager D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-DisplayManager-WorkerManager.top_of_page">org.gnome.DisplayManager.WorkerManager</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.DisplayManager.WorkerManager ---- */

static const _ExtendedGDBusMethodInfo _gdm_dbus_worker_manager_method_info_hello =
{
  {
    -1,
    (gchar *) "Hello",
    NULL,
    NULL,
    NULL
  },
  "handle-hello",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_manager_method_info_info_query_IN_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_manager_method_info_info_query_IN_ARG_query =
{
  {
    -1,
    (gchar *) "query",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_worker_manager_method_info_info_query_IN_ARG_pointers[] =
{
  &_gdm_dbus_worker_manager_method_info_info_query_IN_ARG_service_name.parent_struct,
  &_gdm_dbus_worker_manager_method_info_info_query_IN_ARG_query.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_manager_method_info_info_query_OUT_ARG_answer =
{
  {
    -1,
    (gchar *) "answer",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_worker_manager_method_info_info_query_OUT_ARG_pointers[] =
{
  &_gdm_dbus_worker_manager_method_info_info_query_OUT_ARG_answer.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_dbus_worker_manager_method_info_info_query =
{
  {
    -1,
    (gchar *) "InfoQuery",
    (GDBusArgInfo **) &_gdm_dbus_worker_manager_method_info_info_query_IN_ARG_pointers,
    (GDBusArgInfo **) &_gdm_dbus_worker_manager_method_info_info_query_OUT_ARG_pointers,
    NULL
  },
  "handle-info-query",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_manager_method_info_secret_info_query_IN_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_manager_method_info_secret_info_query_IN_ARG_query =
{
  {
    -1,
    (gchar *) "query",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_worker_manager_method_info_secret_info_query_IN_ARG_pointers[] =
{
  &_gdm_dbus_worker_manager_method_info_secret_info_query_IN_ARG_service_name.parent_struct,
  &_gdm_dbus_worker_manager_method_info_secret_info_query_IN_ARG_query.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_manager_method_info_secret_info_query_OUT_ARG_answer =
{
  {
    -1,
    (gchar *) "answer",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_worker_manager_method_info_secret_info_query_OUT_ARG_pointers[] =
{
  &_gdm_dbus_worker_manager_method_info_secret_info_query_OUT_ARG_answer.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_dbus_worker_manager_method_info_secret_info_query =
{
  {
    -1,
    (gchar *) "SecretInfoQuery",
    (GDBusArgInfo **) &_gdm_dbus_worker_manager_method_info_secret_info_query_IN_ARG_pointers,
    (GDBusArgInfo **) &_gdm_dbus_worker_manager_method_info_secret_info_query_OUT_ARG_pointers,
    NULL
  },
  "handle-secret-info-query",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_manager_method_info_info_IN_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_manager_method_info_info_IN_ARG_info =
{
  {
    -1,
    (gchar *) "info",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_worker_manager_method_info_info_IN_ARG_pointers[] =
{
  &_gdm_dbus_worker_manager_method_info_info_IN_ARG_service_name.parent_struct,
  &_gdm_dbus_worker_manager_method_info_info_IN_ARG_info.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_dbus_worker_manager_method_info_info =
{
  {
    -1,
    (gchar *) "Info",
    (GDBusArgInfo **) &_gdm_dbus_worker_manager_method_info_info_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-info",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_manager_method_info_problem_IN_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_manager_method_info_problem_IN_ARG_problem =
{
  {
    -1,
    (gchar *) "problem",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_worker_manager_method_info_problem_IN_ARG_pointers[] =
{
  &_gdm_dbus_worker_manager_method_info_problem_IN_ARG_service_name.parent_struct,
  &_gdm_dbus_worker_manager_method_info_problem_IN_ARG_problem.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_dbus_worker_manager_method_info_problem =
{
  {
    -1,
    (gchar *) "Problem",
    (GDBusArgInfo **) &_gdm_dbus_worker_manager_method_info_problem_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-problem",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_manager_method_info_choice_list_query_IN_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_manager_method_info_choice_list_query_IN_ARG_prompt_message =
{
  {
    -1,
    (gchar *) "prompt_message",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_manager_method_info_choice_list_query_IN_ARG_query =
{
  {
    -1,
    (gchar *) "query",
    (gchar *) "a{ss}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_worker_manager_method_info_choice_list_query_IN_ARG_pointers[] =
{
  &_gdm_dbus_worker_manager_method_info_choice_list_query_IN_ARG_service_name.parent_struct,
  &_gdm_dbus_worker_manager_method_info_choice_list_query_IN_ARG_prompt_message.parent_struct,
  &_gdm_dbus_worker_manager_method_info_choice_list_query_IN_ARG_query.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_manager_method_info_choice_list_query_OUT_ARG_answer =
{
  {
    -1,
    (gchar *) "answer",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_worker_manager_method_info_choice_list_query_OUT_ARG_pointers[] =
{
  &_gdm_dbus_worker_manager_method_info_choice_list_query_OUT_ARG_answer.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_dbus_worker_manager_method_info_choice_list_query =
{
  {
    -1,
    (gchar *) "ChoiceListQuery",
    (GDBusArgInfo **) &_gdm_dbus_worker_manager_method_info_choice_list_query_IN_ARG_pointers,
    (GDBusArgInfo **) &_gdm_dbus_worker_manager_method_info_choice_list_query_OUT_ARG_pointers,
    NULL
  },
  "handle-choice-list-query",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_manager_method_info_custom_json_request_IN_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_manager_method_info_custom_json_request_IN_ARG_protocol =
{
  {
    -1,
    (gchar *) "protocol",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_manager_method_info_custom_json_request_IN_ARG_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_manager_method_info_custom_json_request_IN_ARG_request =
{
  {
    -1,
    (gchar *) "request",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_worker_manager_method_info_custom_json_request_IN_ARG_pointers[] =
{
  &_gdm_dbus_worker_manager_method_info_custom_json_request_IN_ARG_service_name.parent_struct,
  &_gdm_dbus_worker_manager_method_info_custom_json_request_IN_ARG_protocol.parent_struct,
  &_gdm_dbus_worker_manager_method_info_custom_json_request_IN_ARG_version.parent_struct,
  &_gdm_dbus_worker_manager_method_info_custom_json_request_IN_ARG_request.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gdm_dbus_worker_manager_method_info_custom_json_request_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_worker_manager_method_info_custom_json_request_OUT_ARG_pointers[] =
{
  &_gdm_dbus_worker_manager_method_info_custom_json_request_OUT_ARG_response.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_dbus_worker_manager_method_info_custom_json_request =
{
  {
    -1,
    (gchar *) "CustomJSONRequest",
    (GDBusArgInfo **) &_gdm_dbus_worker_manager_method_info_custom_json_request_IN_ARG_pointers,
    (GDBusArgInfo **) &_gdm_dbus_worker_manager_method_info_custom_json_request_OUT_ARG_pointers,
    NULL
  },
  "handle-custom-json-request",
  FALSE
};

static const GDBusMethodInfo * const _gdm_dbus_worker_manager_method_info_pointers[] =
{
  &_gdm_dbus_worker_manager_method_info_hello.parent_struct,
  &_gdm_dbus_worker_manager_method_info_info_query.parent_struct,
  &_gdm_dbus_worker_manager_method_info_secret_info_query.parent_struct,
  &_gdm_dbus_worker_manager_method_info_info.parent_struct,
  &_gdm_dbus_worker_manager_method_info_problem.parent_struct,
  &_gdm_dbus_worker_manager_method_info_choice_list_query.parent_struct,
  &_gdm_dbus_worker_manager_method_info_custom_json_request.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _gdm_dbus_worker_manager_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.DisplayManager.WorkerManager",
    (GDBusMethodInfo **) &_gdm_dbus_worker_manager_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "worker-manager",
};


/**
 * gdm_dbus_worker_manager_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-DisplayManager-WorkerManager.top_of_page">org.gnome.DisplayManager.WorkerManager</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
gdm_dbus_worker_manager_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_gdm_dbus_worker_manager_interface_info.parent_struct;
}

/**
 * gdm_dbus_worker_manager_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GdmDBusWorkerManager interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
gdm_dbus_worker_manager_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
gdm_dbus_worker_manager_method_marshal_hello (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_worker_manager_method_marshal_info_query (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_worker_manager_method_marshal_secret_info_query (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_worker_manager_method_marshal_info (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_worker_manager_method_marshal_problem (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_worker_manager_method_marshal_choice_list_query (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_worker_manager_method_marshal_custom_json_request (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_UINT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * GdmDBusWorkerManager:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-WorkerManager.top_of_page">org.gnome.DisplayManager.WorkerManager</link>.
 */

/**
 * GdmDBusWorkerManagerIface:
 * @parent_iface: The parent interface.
 * @handle_choice_list_query: Handler for the #GdmDBusWorkerManager::handle-choice-list-query signal.
 * @handle_custom_json_request: Handler for the #GdmDBusWorkerManager::handle-custom-json-request signal.
 * @handle_hello: Handler for the #GdmDBusWorkerManager::handle-hello signal.
 * @handle_info: Handler for the #GdmDBusWorkerManager::handle-info signal.
 * @handle_info_query: Handler for the #GdmDBusWorkerManager::handle-info-query signal.
 * @handle_problem: Handler for the #GdmDBusWorkerManager::handle-problem signal.
 * @handle_secret_info_query: Handler for the #GdmDBusWorkerManager::handle-secret-info-query signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-WorkerManager.top_of_page">org.gnome.DisplayManager.WorkerManager</link>.
 */

typedef GdmDBusWorkerManagerIface GdmDBusWorkerManagerInterface;
G_DEFINE_INTERFACE (GdmDBusWorkerManager, gdm_dbus_worker_manager, G_TYPE_OBJECT)

static void
gdm_dbus_worker_manager_default_init (GdmDBusWorkerManagerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * GdmDBusWorkerManager::handle-hello:
   * @object: A #GdmDBusWorkerManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.Hello">Hello()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_worker_manager_complete_hello() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-hello",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusWorkerManagerIface, handle_hello),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_worker_manager_method_marshal_hello,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GdmDBusWorkerManager::handle-info-query:
   * @object: A #GdmDBusWorkerManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_service_name: Argument passed by remote caller.
   * @arg_query: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.InfoQuery">InfoQuery()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_worker_manager_complete_info_query() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-info-query",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusWorkerManagerIface, handle_info_query),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_worker_manager_method_marshal_info_query,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * GdmDBusWorkerManager::handle-secret-info-query:
   * @object: A #GdmDBusWorkerManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_service_name: Argument passed by remote caller.
   * @arg_query: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.SecretInfoQuery">SecretInfoQuery()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_worker_manager_complete_secret_info_query() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-secret-info-query",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusWorkerManagerIface, handle_secret_info_query),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_worker_manager_method_marshal_secret_info_query,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * GdmDBusWorkerManager::handle-info:
   * @object: A #GdmDBusWorkerManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_service_name: Argument passed by remote caller.
   * @arg_info: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.Info">Info()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_worker_manager_complete_info() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-info",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusWorkerManagerIface, handle_info),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_worker_manager_method_marshal_info,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * GdmDBusWorkerManager::handle-problem:
   * @object: A #GdmDBusWorkerManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_service_name: Argument passed by remote caller.
   * @arg_problem: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.Problem">Problem()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_worker_manager_complete_problem() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-problem",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusWorkerManagerIface, handle_problem),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_worker_manager_method_marshal_problem,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * GdmDBusWorkerManager::handle-choice-list-query:
   * @object: A #GdmDBusWorkerManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_service_name: Argument passed by remote caller.
   * @arg_prompt_message: Argument passed by remote caller.
   * @arg_query: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.ChoiceListQuery">ChoiceListQuery()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_worker_manager_complete_choice_list_query() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-choice-list-query",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusWorkerManagerIface, handle_choice_list_query),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_worker_manager_method_marshal_choice_list_query,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * GdmDBusWorkerManager::handle-custom-json-request:
   * @object: A #GdmDBusWorkerManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_service_name: Argument passed by remote caller.
   * @arg_protocol: Argument passed by remote caller.
   * @arg_version: Argument passed by remote caller.
   * @arg_request: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.CustomJSONRequest">CustomJSONRequest()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_worker_manager_complete_custom_json_request() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-custom-json-request",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusWorkerManagerIface, handle_custom_json_request),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_worker_manager_method_marshal_custom_json_request,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING);

}

/**
 * gdm_dbus_worker_manager_call_hello:
 * @proxy: A #GdmDBusWorkerManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.Hello">Hello()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_worker_manager_call_hello_finish() to get the result of the operation.
 *
 * See gdm_dbus_worker_manager_call_hello_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_worker_manager_call_hello (
    GdmDBusWorkerManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Hello",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_worker_manager_call_hello_finish:
 * @proxy: A #GdmDBusWorkerManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_worker_manager_call_hello().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_worker_manager_call_hello().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_manager_call_hello_finish (
    GdmDBusWorkerManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_manager_call_hello_sync:
 * @proxy: A #GdmDBusWorkerManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.Hello">Hello()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_worker_manager_call_hello() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_manager_call_hello_sync (
    GdmDBusWorkerManager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Hello",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_manager_call_info_query:
 * @proxy: A #GdmDBusWorkerManagerProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_query: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.InfoQuery">InfoQuery()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_worker_manager_call_info_query_finish() to get the result of the operation.
 *
 * See gdm_dbus_worker_manager_call_info_query_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_worker_manager_call_info_query (
    GdmDBusWorkerManager *proxy,
    const gchar *arg_service_name,
    const gchar *arg_query,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "InfoQuery",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_query),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_worker_manager_call_info_query_finish:
 * @proxy: A #GdmDBusWorkerManagerProxy.
 * @out_answer: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_worker_manager_call_info_query().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_worker_manager_call_info_query().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_manager_call_info_query_finish (
    GdmDBusWorkerManager *proxy,
    gchar **out_answer,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_answer);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_manager_call_info_query_sync:
 * @proxy: A #GdmDBusWorkerManagerProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_query: Argument to pass with the method invocation.
 * @out_answer: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.InfoQuery">InfoQuery()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_worker_manager_call_info_query() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_manager_call_info_query_sync (
    GdmDBusWorkerManager *proxy,
    const gchar *arg_service_name,
    const gchar *arg_query,
    gchar **out_answer,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "InfoQuery",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_query),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_answer);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_manager_call_secret_info_query:
 * @proxy: A #GdmDBusWorkerManagerProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_query: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.SecretInfoQuery">SecretInfoQuery()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_worker_manager_call_secret_info_query_finish() to get the result of the operation.
 *
 * See gdm_dbus_worker_manager_call_secret_info_query_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_worker_manager_call_secret_info_query (
    GdmDBusWorkerManager *proxy,
    const gchar *arg_service_name,
    const gchar *arg_query,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SecretInfoQuery",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_query),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_worker_manager_call_secret_info_query_finish:
 * @proxy: A #GdmDBusWorkerManagerProxy.
 * @out_answer: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_worker_manager_call_secret_info_query().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_worker_manager_call_secret_info_query().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_manager_call_secret_info_query_finish (
    GdmDBusWorkerManager *proxy,
    gchar **out_answer,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_answer);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_manager_call_secret_info_query_sync:
 * @proxy: A #GdmDBusWorkerManagerProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_query: Argument to pass with the method invocation.
 * @out_answer: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.SecretInfoQuery">SecretInfoQuery()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_worker_manager_call_secret_info_query() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_manager_call_secret_info_query_sync (
    GdmDBusWorkerManager *proxy,
    const gchar *arg_service_name,
    const gchar *arg_query,
    gchar **out_answer,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SecretInfoQuery",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_query),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_answer);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_manager_call_info:
 * @proxy: A #GdmDBusWorkerManagerProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_info: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.Info">Info()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_worker_manager_call_info_finish() to get the result of the operation.
 *
 * See gdm_dbus_worker_manager_call_info_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_worker_manager_call_info (
    GdmDBusWorkerManager *proxy,
    const gchar *arg_service_name,
    const gchar *arg_info,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Info",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_info),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_worker_manager_call_info_finish:
 * @proxy: A #GdmDBusWorkerManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_worker_manager_call_info().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_worker_manager_call_info().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_manager_call_info_finish (
    GdmDBusWorkerManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_manager_call_info_sync:
 * @proxy: A #GdmDBusWorkerManagerProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_info: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.Info">Info()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_worker_manager_call_info() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_manager_call_info_sync (
    GdmDBusWorkerManager *proxy,
    const gchar *arg_service_name,
    const gchar *arg_info,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Info",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_info),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_manager_call_problem:
 * @proxy: A #GdmDBusWorkerManagerProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_problem: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.Problem">Problem()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_worker_manager_call_problem_finish() to get the result of the operation.
 *
 * See gdm_dbus_worker_manager_call_problem_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_worker_manager_call_problem (
    GdmDBusWorkerManager *proxy,
    const gchar *arg_service_name,
    const gchar *arg_problem,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Problem",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_problem),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_worker_manager_call_problem_finish:
 * @proxy: A #GdmDBusWorkerManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_worker_manager_call_problem().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_worker_manager_call_problem().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_manager_call_problem_finish (
    GdmDBusWorkerManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_manager_call_problem_sync:
 * @proxy: A #GdmDBusWorkerManagerProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_problem: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.Problem">Problem()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_worker_manager_call_problem() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_manager_call_problem_sync (
    GdmDBusWorkerManager *proxy,
    const gchar *arg_service_name,
    const gchar *arg_problem,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Problem",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_problem),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_manager_call_choice_list_query:
 * @proxy: A #GdmDBusWorkerManagerProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_prompt_message: Argument to pass with the method invocation.
 * @arg_query: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.ChoiceListQuery">ChoiceListQuery()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_worker_manager_call_choice_list_query_finish() to get the result of the operation.
 *
 * See gdm_dbus_worker_manager_call_choice_list_query_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_worker_manager_call_choice_list_query (
    GdmDBusWorkerManager *proxy,
    const gchar *arg_service_name,
    const gchar *arg_prompt_message,
    GVariant *arg_query,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ChoiceListQuery",
    g_variant_new ("(ss@a{ss})",
                   arg_service_name,
                   arg_prompt_message,
                   arg_query),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_worker_manager_call_choice_list_query_finish:
 * @proxy: A #GdmDBusWorkerManagerProxy.
 * @out_answer: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_worker_manager_call_choice_list_query().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_worker_manager_call_choice_list_query().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_manager_call_choice_list_query_finish (
    GdmDBusWorkerManager *proxy,
    gchar **out_answer,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_answer);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_manager_call_choice_list_query_sync:
 * @proxy: A #GdmDBusWorkerManagerProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_prompt_message: Argument to pass with the method invocation.
 * @arg_query: Argument to pass with the method invocation.
 * @out_answer: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.ChoiceListQuery">ChoiceListQuery()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_worker_manager_call_choice_list_query() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_manager_call_choice_list_query_sync (
    GdmDBusWorkerManager *proxy,
    const gchar *arg_service_name,
    const gchar *arg_prompt_message,
    GVariant *arg_query,
    gchar **out_answer,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ChoiceListQuery",
    g_variant_new ("(ss@a{ss})",
                   arg_service_name,
                   arg_prompt_message,
                   arg_query),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_answer);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_manager_call_custom_json_request:
 * @proxy: A #GdmDBusWorkerManagerProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_protocol: Argument to pass with the method invocation.
 * @arg_version: Argument to pass with the method invocation.
 * @arg_request: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.CustomJSONRequest">CustomJSONRequest()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_worker_manager_call_custom_json_request_finish() to get the result of the operation.
 *
 * See gdm_dbus_worker_manager_call_custom_json_request_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_worker_manager_call_custom_json_request (
    GdmDBusWorkerManager *proxy,
    const gchar *arg_service_name,
    const gchar *arg_protocol,
    guint arg_version,
    const gchar *arg_request,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CustomJSONRequest",
    g_variant_new ("(ssus)",
                   arg_service_name,
                   arg_protocol,
                   arg_version,
                   arg_request),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_worker_manager_call_custom_json_request_finish:
 * @proxy: A #GdmDBusWorkerManagerProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_worker_manager_call_custom_json_request().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_worker_manager_call_custom_json_request().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_manager_call_custom_json_request_finish (
    GdmDBusWorkerManager *proxy,
    gchar **out_response,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_response);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_manager_call_custom_json_request_sync:
 * @proxy: A #GdmDBusWorkerManagerProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_protocol: Argument to pass with the method invocation.
 * @arg_version: Argument to pass with the method invocation.
 * @arg_request: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.CustomJSONRequest">CustomJSONRequest()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_worker_manager_call_custom_json_request() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_worker_manager_call_custom_json_request_sync (
    GdmDBusWorkerManager *proxy,
    const gchar *arg_service_name,
    const gchar *arg_protocol,
    guint arg_version,
    const gchar *arg_request,
    gchar **out_response,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CustomJSONRequest",
    g_variant_new ("(ssus)",
                   arg_service_name,
                   arg_protocol,
                   arg_version,
                   arg_request),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_response);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_worker_manager_complete_hello:
 * @object: A #GdmDBusWorkerManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.Hello">Hello()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_worker_manager_complete_hello (
    GdmDBusWorkerManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdm_dbus_worker_manager_complete_info_query:
 * @object: A #GdmDBusWorkerManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @answer: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.InfoQuery">InfoQuery()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_worker_manager_complete_info_query (
    GdmDBusWorkerManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *answer)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   answer));
}

/**
 * gdm_dbus_worker_manager_complete_secret_info_query:
 * @object: A #GdmDBusWorkerManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @answer: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.SecretInfoQuery">SecretInfoQuery()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_worker_manager_complete_secret_info_query (
    GdmDBusWorkerManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *answer)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   answer));
}

/**
 * gdm_dbus_worker_manager_complete_info:
 * @object: A #GdmDBusWorkerManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.Info">Info()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_worker_manager_complete_info (
    GdmDBusWorkerManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdm_dbus_worker_manager_complete_problem:
 * @object: A #GdmDBusWorkerManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.Problem">Problem()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_worker_manager_complete_problem (
    GdmDBusWorkerManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdm_dbus_worker_manager_complete_choice_list_query:
 * @object: A #GdmDBusWorkerManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @answer: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.ChoiceListQuery">ChoiceListQuery()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_worker_manager_complete_choice_list_query (
    GdmDBusWorkerManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *answer)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   answer));
}

/**
 * gdm_dbus_worker_manager_complete_custom_json_request:
 * @object: A #GdmDBusWorkerManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-WorkerManager.CustomJSONRequest">CustomJSONRequest()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_worker_manager_complete_custom_json_request (
    GdmDBusWorkerManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *response)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   response));
}

/* ------------------------------------------------------------------------ */

/**
 * GdmDBusWorkerManagerProxy:
 *
 * The #GdmDBusWorkerManagerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GdmDBusWorkerManagerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GdmDBusWorkerManagerProxy.
 */

struct _GdmDBusWorkerManagerProxyPrivate
{
  GData *qdata;
};

static void gdm_dbus_worker_manager_proxy_iface_init (GdmDBusWorkerManagerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GdmDBusWorkerManagerProxy, gdm_dbus_worker_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GdmDBusWorkerManagerProxy)
                         G_IMPLEMENT_INTERFACE (GDM_DBUS_TYPE_WORKER_MANAGER, gdm_dbus_worker_manager_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GdmDBusWorkerManagerProxy, gdm_dbus_worker_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GDM_DBUS_TYPE_WORKER_MANAGER, gdm_dbus_worker_manager_proxy_iface_init))

#endif
static void
gdm_dbus_worker_manager_proxy_finalize (GObject *object)
{
  GdmDBusWorkerManagerProxy *proxy = GDM_DBUS_WORKER_MANAGER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (gdm_dbus_worker_manager_proxy_parent_class)->finalize (object);
}

static void
gdm_dbus_worker_manager_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gdm_dbus_worker_manager_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gdm_dbus_worker_manager_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_gdm_dbus_worker_manager_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GDM_DBUS_TYPE_WORKER_MANAGER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GDM_DBUS_TYPE_WORKER_MANAGER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
gdm_dbus_worker_manager_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GdmDBusWorkerManagerProxy *proxy = GDM_DBUS_WORKER_MANAGER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_dbus_worker_manager_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_dbus_worker_manager_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
gdm_dbus_worker_manager_proxy_init (GdmDBusWorkerManagerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = gdm_dbus_worker_manager_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GDM_DBUS_TYPE_WORKER_MANAGER_PROXY, GdmDBusWorkerManagerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), gdm_dbus_worker_manager_interface_info ());
}

static void
gdm_dbus_worker_manager_proxy_class_init (GdmDBusWorkerManagerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = gdm_dbus_worker_manager_proxy_finalize;
  gobject_class->get_property = gdm_dbus_worker_manager_proxy_get_property;
  gobject_class->set_property = gdm_dbus_worker_manager_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = gdm_dbus_worker_manager_proxy_g_signal;
  proxy_class->g_properties_changed = gdm_dbus_worker_manager_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GdmDBusWorkerManagerProxyPrivate));
#endif
}

static void
gdm_dbus_worker_manager_proxy_iface_init (GdmDBusWorkerManagerIface *iface G_GNUC_UNUSED)
{
}

/**
 * gdm_dbus_worker_manager_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-WorkerManager.top_of_page">org.gnome.DisplayManager.WorkerManager</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_worker_manager_proxy_new_finish() to get the result of the operation.
 *
 * See gdm_dbus_worker_manager_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
gdm_dbus_worker_manager_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GDM_DBUS_TYPE_WORKER_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.WorkerManager", NULL);
}

/**
 * gdm_dbus_worker_manager_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_worker_manager_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gdm_dbus_worker_manager_proxy_new().
 *
 * Returns: (transfer full) (type GdmDBusWorkerManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmDBusWorkerManager *
gdm_dbus_worker_manager_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GDM_DBUS_WORKER_MANAGER (ret);
  else
    return NULL;
}

/**
 * gdm_dbus_worker_manager_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-WorkerManager.top_of_page">org.gnome.DisplayManager.WorkerManager</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_worker_manager_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GdmDBusWorkerManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmDBusWorkerManager *
gdm_dbus_worker_manager_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GDM_DBUS_TYPE_WORKER_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.WorkerManager", NULL);
  if (ret != NULL)
    return GDM_DBUS_WORKER_MANAGER (ret);
  else
    return NULL;
}


/**
 * gdm_dbus_worker_manager_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like gdm_dbus_worker_manager_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_worker_manager_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See gdm_dbus_worker_manager_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
gdm_dbus_worker_manager_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GDM_DBUS_TYPE_WORKER_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.WorkerManager", NULL);
}

/**
 * gdm_dbus_worker_manager_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_worker_manager_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gdm_dbus_worker_manager_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GdmDBusWorkerManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmDBusWorkerManager *
gdm_dbus_worker_manager_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GDM_DBUS_WORKER_MANAGER (ret);
  else
    return NULL;
}

/**
 * gdm_dbus_worker_manager_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like gdm_dbus_worker_manager_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_worker_manager_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GdmDBusWorkerManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmDBusWorkerManager *
gdm_dbus_worker_manager_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GDM_DBUS_TYPE_WORKER_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.WorkerManager", NULL);
  if (ret != NULL)
    return GDM_DBUS_WORKER_MANAGER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GdmDBusWorkerManagerSkeleton:
 *
 * The #GdmDBusWorkerManagerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GdmDBusWorkerManagerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GdmDBusWorkerManagerSkeleton.
 */

struct _GdmDBusWorkerManagerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_gdm_dbus_worker_manager_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GdmDBusWorkerManagerSkeleton *skeleton = GDM_DBUS_WORKER_MANAGER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GDM_DBUS_TYPE_WORKER_MANAGER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GDM_DBUS_TYPE_WORKER_MANAGER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_gdm_dbus_worker_manager_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GdmDBusWorkerManagerSkeleton *skeleton = GDM_DBUS_WORKER_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_dbus_worker_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_gdm_dbus_worker_manager_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GdmDBusWorkerManagerSkeleton *skeleton = GDM_DBUS_WORKER_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_dbus_worker_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _gdm_dbus_worker_manager_skeleton_vtable =
{
  _gdm_dbus_worker_manager_skeleton_handle_method_call,
  _gdm_dbus_worker_manager_skeleton_handle_get_property,
  _gdm_dbus_worker_manager_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
gdm_dbus_worker_manager_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return gdm_dbus_worker_manager_interface_info ();
}

static GDBusInterfaceVTable *
gdm_dbus_worker_manager_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_gdm_dbus_worker_manager_skeleton_vtable;
}

static GVariant *
gdm_dbus_worker_manager_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GdmDBusWorkerManagerSkeleton *skeleton = GDM_DBUS_WORKER_MANAGER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_gdm_dbus_worker_manager_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _gdm_dbus_worker_manager_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _gdm_dbus_worker_manager_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _gdm_dbus_worker_manager_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.WorkerManager", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
gdm_dbus_worker_manager_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void gdm_dbus_worker_manager_skeleton_iface_init (GdmDBusWorkerManagerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GdmDBusWorkerManagerSkeleton, gdm_dbus_worker_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GdmDBusWorkerManagerSkeleton)
                         G_IMPLEMENT_INTERFACE (GDM_DBUS_TYPE_WORKER_MANAGER, gdm_dbus_worker_manager_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GdmDBusWorkerManagerSkeleton, gdm_dbus_worker_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GDM_DBUS_TYPE_WORKER_MANAGER, gdm_dbus_worker_manager_skeleton_iface_init))

#endif
static void
gdm_dbus_worker_manager_skeleton_finalize (GObject *object)
{
  GdmDBusWorkerManagerSkeleton *skeleton = GDM_DBUS_WORKER_MANAGER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (gdm_dbus_worker_manager_skeleton_parent_class)->finalize (object);
}

static void
gdm_dbus_worker_manager_skeleton_init (GdmDBusWorkerManagerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = gdm_dbus_worker_manager_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GDM_DBUS_TYPE_WORKER_MANAGER_SKELETON, GdmDBusWorkerManagerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
gdm_dbus_worker_manager_skeleton_class_init (GdmDBusWorkerManagerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = gdm_dbus_worker_manager_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = gdm_dbus_worker_manager_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = gdm_dbus_worker_manager_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = gdm_dbus_worker_manager_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = gdm_dbus_worker_manager_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GdmDBusWorkerManagerSkeletonPrivate));
#endif
}

static void
gdm_dbus_worker_manager_skeleton_iface_init (GdmDBusWorkerManagerIface *iface G_GNUC_UNUSED)
{
}

/**
 * gdm_dbus_worker_manager_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-WorkerManager.top_of_page">org.gnome.DisplayManager.WorkerManager</link>.
 *
 * Returns: (transfer full) (type GdmDBusWorkerManagerSkeleton): The skeleton object.
 */
GdmDBusWorkerManager *
gdm_dbus_worker_manager_skeleton_new (void)
{
  return GDM_DBUS_WORKER_MANAGER (g_object_new (GDM_DBUS_TYPE_WORKER_MANAGER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.DisplayManager.UserVerifier
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GdmDBusUserVerifier
 * @title: GdmDBusUserVerifier
 * @short_description: Generated C code for the org.gnome.DisplayManager.UserVerifier D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier.top_of_page">org.gnome.DisplayManager.UserVerifier</link> D-Bus interface in C.
 */

enum
{
  GDM_DBUS__USER_VERIFIER_CONVERSATION_STARTED,
  GDM_DBUS__USER_VERIFIER_CONVERSATION_STOPPED,
  GDM_DBUS__USER_VERIFIER_REAUTHENTICATION_STARTED,
  GDM_DBUS__USER_VERIFIER_INFO,
  GDM_DBUS__USER_VERIFIER_PROBLEM,
  GDM_DBUS__USER_VERIFIER_INFO_QUERY,
  GDM_DBUS__USER_VERIFIER_SECRET_INFO_QUERY,
  GDM_DBUS__USER_VERIFIER_RESET,
  GDM_DBUS__USER_VERIFIER_SERVICE_UNAVAILABLE,
  GDM_DBUS__USER_VERIFIER_VERIFICATION_FAILED,
  GDM_DBUS__USER_VERIFIER_VERIFICATION_COMPLETE,
};

static unsigned GDM_DBUS__USER_VERIFIER_SIGNALS[11] = { 0 };

/* ---- Introspection data for org.gnome.DisplayManager.UserVerifier ---- */

static const _ExtendedGDBusArgInfo _gdm_dbus_user_verifier_method_info_enable_extensions_IN_ARG_extensions =
{
  {
    -1,
    (gchar *) "extensions",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_user_verifier_method_info_enable_extensions_IN_ARG_pointers[] =
{
  &_gdm_dbus_user_verifier_method_info_enable_extensions_IN_ARG_extensions.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_dbus_user_verifier_method_info_enable_extensions =
{
  {
    -1,
    (gchar *) "EnableExtensions",
    (GDBusArgInfo **) &_gdm_dbus_user_verifier_method_info_enable_extensions_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-enable-extensions",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_user_verifier_method_info_begin_verification_IN_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_user_verifier_method_info_begin_verification_IN_ARG_pointers[] =
{
  &_gdm_dbus_user_verifier_method_info_begin_verification_IN_ARG_service_name.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_dbus_user_verifier_method_info_begin_verification =
{
  {
    -1,
    (gchar *) "BeginVerification",
    (GDBusArgInfo **) &_gdm_dbus_user_verifier_method_info_begin_verification_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-begin-verification",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_user_verifier_method_info_begin_verification_for_user_IN_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_user_verifier_method_info_begin_verification_for_user_IN_ARG_username =
{
  {
    -1,
    (gchar *) "username",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_user_verifier_method_info_begin_verification_for_user_IN_ARG_pointers[] =
{
  &_gdm_dbus_user_verifier_method_info_begin_verification_for_user_IN_ARG_service_name.parent_struct,
  &_gdm_dbus_user_verifier_method_info_begin_verification_for_user_IN_ARG_username.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_dbus_user_verifier_method_info_begin_verification_for_user =
{
  {
    -1,
    (gchar *) "BeginVerificationForUser",
    (GDBusArgInfo **) &_gdm_dbus_user_verifier_method_info_begin_verification_for_user_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-begin-verification-for-user",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_user_verifier_method_info_answer_query_IN_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_user_verifier_method_info_answer_query_IN_ARG_answer =
{
  {
    -1,
    (gchar *) "answer",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_user_verifier_method_info_answer_query_IN_ARG_pointers[] =
{
  &_gdm_dbus_user_verifier_method_info_answer_query_IN_ARG_service_name.parent_struct,
  &_gdm_dbus_user_verifier_method_info_answer_query_IN_ARG_answer.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_dbus_user_verifier_method_info_answer_query =
{
  {
    -1,
    (gchar *) "AnswerQuery",
    (GDBusArgInfo **) &_gdm_dbus_user_verifier_method_info_answer_query_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-answer-query",
  FALSE
};

static const _ExtendedGDBusMethodInfo _gdm_dbus_user_verifier_method_info_cancel =
{
  {
    -1,
    (gchar *) "Cancel",
    NULL,
    NULL,
    NULL
  },
  "handle-cancel",
  FALSE
};

static const GDBusMethodInfo * const _gdm_dbus_user_verifier_method_info_pointers[] =
{
  &_gdm_dbus_user_verifier_method_info_enable_extensions.parent_struct,
  &_gdm_dbus_user_verifier_method_info_begin_verification.parent_struct,
  &_gdm_dbus_user_verifier_method_info_begin_verification_for_user.parent_struct,
  &_gdm_dbus_user_verifier_method_info_answer_query.parent_struct,
  &_gdm_dbus_user_verifier_method_info_cancel.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gdm_dbus_user_verifier_signal_info_conversation_started_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_user_verifier_signal_info_conversation_started_ARG_pointers[] =
{
  &_gdm_dbus_user_verifier_signal_info_conversation_started_ARG_service_name.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_dbus_user_verifier_signal_info_conversation_started =
{
  {
    -1,
    (gchar *) "ConversationStarted",
    (GDBusArgInfo **) &_gdm_dbus_user_verifier_signal_info_conversation_started_ARG_pointers,
    NULL
  },
  "conversation-started"
};

static const _ExtendedGDBusArgInfo _gdm_dbus_user_verifier_signal_info_conversation_stopped_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_user_verifier_signal_info_conversation_stopped_ARG_pointers[] =
{
  &_gdm_dbus_user_verifier_signal_info_conversation_stopped_ARG_service_name.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_dbus_user_verifier_signal_info_conversation_stopped =
{
  {
    -1,
    (gchar *) "ConversationStopped",
    (GDBusArgInfo **) &_gdm_dbus_user_verifier_signal_info_conversation_stopped_ARG_pointers,
    NULL
  },
  "conversation-stopped"
};

static const _ExtendedGDBusArgInfo _gdm_dbus_user_verifier_signal_info_reauthentication_started_ARG_pid_of_caller =
{
  {
    -1,
    (gchar *) "pid_of_caller",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_user_verifier_signal_info_reauthentication_started_ARG_pointers[] =
{
  &_gdm_dbus_user_verifier_signal_info_reauthentication_started_ARG_pid_of_caller.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_dbus_user_verifier_signal_info_reauthentication_started =
{
  {
    -1,
    (gchar *) "ReauthenticationStarted",
    (GDBusArgInfo **) &_gdm_dbus_user_verifier_signal_info_reauthentication_started_ARG_pointers,
    NULL
  },
  "reauthentication-started"
};

static const _ExtendedGDBusArgInfo _gdm_dbus_user_verifier_signal_info_info_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_user_verifier_signal_info_info_ARG_info =
{
  {
    -1,
    (gchar *) "info",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_user_verifier_signal_info_info_ARG_pointers[] =
{
  &_gdm_dbus_user_verifier_signal_info_info_ARG_service_name.parent_struct,
  &_gdm_dbus_user_verifier_signal_info_info_ARG_info.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_dbus_user_verifier_signal_info_info =
{
  {
    -1,
    (gchar *) "Info",
    (GDBusArgInfo **) &_gdm_dbus_user_verifier_signal_info_info_ARG_pointers,
    NULL
  },
  "info"
};

static const _ExtendedGDBusArgInfo _gdm_dbus_user_verifier_signal_info_problem_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_user_verifier_signal_info_problem_ARG_problem =
{
  {
    -1,
    (gchar *) "problem",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_user_verifier_signal_info_problem_ARG_pointers[] =
{
  &_gdm_dbus_user_verifier_signal_info_problem_ARG_service_name.parent_struct,
  &_gdm_dbus_user_verifier_signal_info_problem_ARG_problem.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_dbus_user_verifier_signal_info_problem =
{
  {
    -1,
    (gchar *) "Problem",
    (GDBusArgInfo **) &_gdm_dbus_user_verifier_signal_info_problem_ARG_pointers,
    NULL
  },
  "problem"
};

static const _ExtendedGDBusArgInfo _gdm_dbus_user_verifier_signal_info_info_query_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_user_verifier_signal_info_info_query_ARG_query =
{
  {
    -1,
    (gchar *) "query",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_user_verifier_signal_info_info_query_ARG_pointers[] =
{
  &_gdm_dbus_user_verifier_signal_info_info_query_ARG_service_name.parent_struct,
  &_gdm_dbus_user_verifier_signal_info_info_query_ARG_query.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_dbus_user_verifier_signal_info_info_query =
{
  {
    -1,
    (gchar *) "InfoQuery",
    (GDBusArgInfo **) &_gdm_dbus_user_verifier_signal_info_info_query_ARG_pointers,
    NULL
  },
  "info-query"
};

static const _ExtendedGDBusArgInfo _gdm_dbus_user_verifier_signal_info_secret_info_query_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_user_verifier_signal_info_secret_info_query_ARG_query =
{
  {
    -1,
    (gchar *) "query",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_user_verifier_signal_info_secret_info_query_ARG_pointers[] =
{
  &_gdm_dbus_user_verifier_signal_info_secret_info_query_ARG_service_name.parent_struct,
  &_gdm_dbus_user_verifier_signal_info_secret_info_query_ARG_query.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_dbus_user_verifier_signal_info_secret_info_query =
{
  {
    -1,
    (gchar *) "SecretInfoQuery",
    (GDBusArgInfo **) &_gdm_dbus_user_verifier_signal_info_secret_info_query_ARG_pointers,
    NULL
  },
  "secret-info-query"
};

static const _ExtendedGDBusSignalInfo _gdm_dbus_user_verifier_signal_info_reset =
{
  {
    -1,
    (gchar *) "Reset",
    NULL,
    NULL
  },
  "reset"
};

static const _ExtendedGDBusArgInfo _gdm_dbus_user_verifier_signal_info_service_unavailable_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_user_verifier_signal_info_service_unavailable_ARG_message =
{
  {
    -1,
    (gchar *) "message",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_user_verifier_signal_info_service_unavailable_ARG_pointers[] =
{
  &_gdm_dbus_user_verifier_signal_info_service_unavailable_ARG_service_name.parent_struct,
  &_gdm_dbus_user_verifier_signal_info_service_unavailable_ARG_message.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_dbus_user_verifier_signal_info_service_unavailable =
{
  {
    -1,
    (gchar *) "ServiceUnavailable",
    (GDBusArgInfo **) &_gdm_dbus_user_verifier_signal_info_service_unavailable_ARG_pointers,
    NULL
  },
  "service-unavailable"
};

static const _ExtendedGDBusArgInfo _gdm_dbus_user_verifier_signal_info_verification_failed_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_user_verifier_signal_info_verification_failed_ARG_pointers[] =
{
  &_gdm_dbus_user_verifier_signal_info_verification_failed_ARG_service_name.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_dbus_user_verifier_signal_info_verification_failed =
{
  {
    -1,
    (gchar *) "VerificationFailed",
    (GDBusArgInfo **) &_gdm_dbus_user_verifier_signal_info_verification_failed_ARG_pointers,
    NULL
  },
  "verification-failed"
};

static const _ExtendedGDBusArgInfo _gdm_dbus_user_verifier_signal_info_verification_complete_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_user_verifier_signal_info_verification_complete_ARG_pointers[] =
{
  &_gdm_dbus_user_verifier_signal_info_verification_complete_ARG_service_name.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_dbus_user_verifier_signal_info_verification_complete =
{
  {
    -1,
    (gchar *) "VerificationComplete",
    (GDBusArgInfo **) &_gdm_dbus_user_verifier_signal_info_verification_complete_ARG_pointers,
    NULL
  },
  "verification-complete"
};

static const GDBusSignalInfo * const _gdm_dbus_user_verifier_signal_info_pointers[] =
{
  &_gdm_dbus_user_verifier_signal_info_conversation_started.parent_struct,
  &_gdm_dbus_user_verifier_signal_info_conversation_stopped.parent_struct,
  &_gdm_dbus_user_verifier_signal_info_reauthentication_started.parent_struct,
  &_gdm_dbus_user_verifier_signal_info_info.parent_struct,
  &_gdm_dbus_user_verifier_signal_info_problem.parent_struct,
  &_gdm_dbus_user_verifier_signal_info_info_query.parent_struct,
  &_gdm_dbus_user_verifier_signal_info_secret_info_query.parent_struct,
  &_gdm_dbus_user_verifier_signal_info_reset.parent_struct,
  &_gdm_dbus_user_verifier_signal_info_service_unavailable.parent_struct,
  &_gdm_dbus_user_verifier_signal_info_verification_failed.parent_struct,
  &_gdm_dbus_user_verifier_signal_info_verification_complete.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _gdm_dbus_user_verifier_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.DisplayManager.UserVerifier",
    (GDBusMethodInfo **) &_gdm_dbus_user_verifier_method_info_pointers,
    (GDBusSignalInfo **) &_gdm_dbus_user_verifier_signal_info_pointers,
    NULL,
    NULL
  },
  "user-verifier",
};


/**
 * gdm_dbus_user_verifier_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier.top_of_page">org.gnome.DisplayManager.UserVerifier</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
gdm_dbus_user_verifier_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_gdm_dbus_user_verifier_interface_info.parent_struct;
}

/**
 * gdm_dbus_user_verifier_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GdmDBusUserVerifier interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
gdm_dbus_user_verifier_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
gdm_dbus_user_verifier_signal_marshal_conversation_started (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_user_verifier_signal_marshal_conversation_stopped (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_user_verifier_signal_marshal_reauthentication_started (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_user_verifier_signal_marshal_info (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_user_verifier_signal_marshal_problem (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_user_verifier_signal_marshal_info_query (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_user_verifier_signal_marshal_secret_info_query (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_user_verifier_signal_marshal_reset (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_user_verifier_signal_marshal_service_unavailable (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_user_verifier_signal_marshal_verification_failed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_user_verifier_signal_marshal_verification_complete (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_user_verifier_method_marshal_enable_extensions (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOXED (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_user_verifier_method_marshal_begin_verification (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_user_verifier_method_marshal_begin_verification_for_user (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_user_verifier_method_marshal_answer_query (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_user_verifier_method_marshal_cancel (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * GdmDBusUserVerifier:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier.top_of_page">org.gnome.DisplayManager.UserVerifier</link>.
 */

/**
 * GdmDBusUserVerifierIface:
 * @parent_iface: The parent interface.
 * @handle_answer_query: Handler for the #GdmDBusUserVerifier::handle-answer-query signal.
 * @handle_begin_verification: Handler for the #GdmDBusUserVerifier::handle-begin-verification signal.
 * @handle_begin_verification_for_user: Handler for the #GdmDBusUserVerifier::handle-begin-verification-for-user signal.
 * @handle_cancel: Handler for the #GdmDBusUserVerifier::handle-cancel signal.
 * @handle_enable_extensions: Handler for the #GdmDBusUserVerifier::handle-enable-extensions signal.
 * @conversation_started: Handler for the #GdmDBusUserVerifier::conversation-started signal.
 * @conversation_stopped: Handler for the #GdmDBusUserVerifier::conversation-stopped signal.
 * @info: Handler for the #GdmDBusUserVerifier::info signal.
 * @info_query: Handler for the #GdmDBusUserVerifier::info-query signal.
 * @problem: Handler for the #GdmDBusUserVerifier::problem signal.
 * @reauthentication_started: Handler for the #GdmDBusUserVerifier::reauthentication-started signal.
 * @reset: Handler for the #GdmDBusUserVerifier::reset signal.
 * @secret_info_query: Handler for the #GdmDBusUserVerifier::secret-info-query signal.
 * @service_unavailable: Handler for the #GdmDBusUserVerifier::service-unavailable signal.
 * @verification_complete: Handler for the #GdmDBusUserVerifier::verification-complete signal.
 * @verification_failed: Handler for the #GdmDBusUserVerifier::verification-failed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier.top_of_page">org.gnome.DisplayManager.UserVerifier</link>.
 */

typedef GdmDBusUserVerifierIface GdmDBusUserVerifierInterface;
G_DEFINE_INTERFACE (GdmDBusUserVerifier, gdm_dbus_user_verifier, G_TYPE_OBJECT)

static void
gdm_dbus_user_verifier_default_init (GdmDBusUserVerifierIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * GdmDBusUserVerifier::handle-enable-extensions:
   * @object: A #GdmDBusUserVerifier.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_extensions: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.EnableExtensions">EnableExtensions()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_user_verifier_complete_enable_extensions() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-enable-extensions",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusUserVerifierIface, handle_enable_extensions),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_user_verifier_method_marshal_enable_extensions,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV);

  /**
   * GdmDBusUserVerifier::handle-begin-verification:
   * @object: A #GdmDBusUserVerifier.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_service_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.BeginVerification">BeginVerification()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_user_verifier_complete_begin_verification() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-begin-verification",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusUserVerifierIface, handle_begin_verification),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_user_verifier_method_marshal_begin_verification,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * GdmDBusUserVerifier::handle-begin-verification-for-user:
   * @object: A #GdmDBusUserVerifier.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_service_name: Argument passed by remote caller.
   * @arg_username: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.BeginVerificationForUser">BeginVerificationForUser()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_user_verifier_complete_begin_verification_for_user() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-begin-verification-for-user",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusUserVerifierIface, handle_begin_verification_for_user),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_user_verifier_method_marshal_begin_verification_for_user,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * GdmDBusUserVerifier::handle-answer-query:
   * @object: A #GdmDBusUserVerifier.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_service_name: Argument passed by remote caller.
   * @arg_answer: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.AnswerQuery">AnswerQuery()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_user_verifier_complete_answer_query() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-answer-query",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusUserVerifierIface, handle_answer_query),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_user_verifier_method_marshal_answer_query,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * GdmDBusUserVerifier::handle-cancel:
   * @object: A #GdmDBusUserVerifier.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.Cancel">Cancel()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_user_verifier_complete_cancel() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-cancel",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusUserVerifierIface, handle_cancel),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_user_verifier_method_marshal_cancel,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * GdmDBusUserVerifier::conversation-started:
   * @object: A #GdmDBusUserVerifier.
   * @arg_service_name: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.ConversationStarted">"ConversationStarted"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM_DBUS__USER_VERIFIER_SIGNALS[GDM_DBUS__USER_VERIFIER_CONVERSATION_STARTED] =
    g_signal_new ("conversation-started",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmDBusUserVerifierIface, conversation_started),
      NULL,
      NULL,
      gdm_dbus_user_verifier_signal_marshal_conversation_started,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * GdmDBusUserVerifier::conversation-stopped:
   * @object: A #GdmDBusUserVerifier.
   * @arg_service_name: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.ConversationStopped">"ConversationStopped"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM_DBUS__USER_VERIFIER_SIGNALS[GDM_DBUS__USER_VERIFIER_CONVERSATION_STOPPED] =
    g_signal_new ("conversation-stopped",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmDBusUserVerifierIface, conversation_stopped),
      NULL,
      NULL,
      gdm_dbus_user_verifier_signal_marshal_conversation_stopped,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * GdmDBusUserVerifier::reauthentication-started:
   * @object: A #GdmDBusUserVerifier.
   * @arg_pid_of_caller: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.ReauthenticationStarted">"ReauthenticationStarted"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM_DBUS__USER_VERIFIER_SIGNALS[GDM_DBUS__USER_VERIFIER_REAUTHENTICATION_STARTED] =
    g_signal_new ("reauthentication-started",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmDBusUserVerifierIface, reauthentication_started),
      NULL,
      NULL,
      gdm_dbus_user_verifier_signal_marshal_reauthentication_started,
      G_TYPE_NONE,
      1, G_TYPE_INT);

  /**
   * GdmDBusUserVerifier::info:
   * @object: A #GdmDBusUserVerifier.
   * @arg_service_name: Argument.
   * @arg_info: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.Info">"Info"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM_DBUS__USER_VERIFIER_SIGNALS[GDM_DBUS__USER_VERIFIER_INFO] =
    g_signal_new ("info",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmDBusUserVerifierIface, info),
      NULL,
      NULL,
      gdm_dbus_user_verifier_signal_marshal_info,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * GdmDBusUserVerifier::problem:
   * @object: A #GdmDBusUserVerifier.
   * @arg_service_name: Argument.
   * @arg_problem: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.Problem">"Problem"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM_DBUS__USER_VERIFIER_SIGNALS[GDM_DBUS__USER_VERIFIER_PROBLEM] =
    g_signal_new ("problem",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmDBusUserVerifierIface, problem),
      NULL,
      NULL,
      gdm_dbus_user_verifier_signal_marshal_problem,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * GdmDBusUserVerifier::info-query:
   * @object: A #GdmDBusUserVerifier.
   * @arg_service_name: Argument.
   * @arg_query: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.InfoQuery">"InfoQuery"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM_DBUS__USER_VERIFIER_SIGNALS[GDM_DBUS__USER_VERIFIER_INFO_QUERY] =
    g_signal_new ("info-query",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmDBusUserVerifierIface, info_query),
      NULL,
      NULL,
      gdm_dbus_user_verifier_signal_marshal_info_query,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * GdmDBusUserVerifier::secret-info-query:
   * @object: A #GdmDBusUserVerifier.
   * @arg_service_name: Argument.
   * @arg_query: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.SecretInfoQuery">"SecretInfoQuery"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM_DBUS__USER_VERIFIER_SIGNALS[GDM_DBUS__USER_VERIFIER_SECRET_INFO_QUERY] =
    g_signal_new ("secret-info-query",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmDBusUserVerifierIface, secret_info_query),
      NULL,
      NULL,
      gdm_dbus_user_verifier_signal_marshal_secret_info_query,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * GdmDBusUserVerifier::reset:
   * @object: A #GdmDBusUserVerifier.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.Reset">"Reset"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM_DBUS__USER_VERIFIER_SIGNALS[GDM_DBUS__USER_VERIFIER_RESET] =
    g_signal_new ("reset",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmDBusUserVerifierIface, reset),
      NULL,
      NULL,
      gdm_dbus_user_verifier_signal_marshal_reset,
      G_TYPE_NONE,
      0);

  /**
   * GdmDBusUserVerifier::service-unavailable:
   * @object: A #GdmDBusUserVerifier.
   * @arg_service_name: Argument.
   * @arg_message: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.ServiceUnavailable">"ServiceUnavailable"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM_DBUS__USER_VERIFIER_SIGNALS[GDM_DBUS__USER_VERIFIER_SERVICE_UNAVAILABLE] =
    g_signal_new ("service-unavailable",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmDBusUserVerifierIface, service_unavailable),
      NULL,
      NULL,
      gdm_dbus_user_verifier_signal_marshal_service_unavailable,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * GdmDBusUserVerifier::verification-failed:
   * @object: A #GdmDBusUserVerifier.
   * @arg_service_name: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.VerificationFailed">"VerificationFailed"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM_DBUS__USER_VERIFIER_SIGNALS[GDM_DBUS__USER_VERIFIER_VERIFICATION_FAILED] =
    g_signal_new ("verification-failed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmDBusUserVerifierIface, verification_failed),
      NULL,
      NULL,
      gdm_dbus_user_verifier_signal_marshal_verification_failed,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * GdmDBusUserVerifier::verification-complete:
   * @object: A #GdmDBusUserVerifier.
   * @arg_service_name: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.VerificationComplete">"VerificationComplete"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM_DBUS__USER_VERIFIER_SIGNALS[GDM_DBUS__USER_VERIFIER_VERIFICATION_COMPLETE] =
    g_signal_new ("verification-complete",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmDBusUserVerifierIface, verification_complete),
      NULL,
      NULL,
      gdm_dbus_user_verifier_signal_marshal_verification_complete,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

}

/**
 * gdm_dbus_user_verifier_emit_conversation_started:
 * @object: A #GdmDBusUserVerifier.
 * @arg_service_name: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.ConversationStarted">"ConversationStarted"</link> D-Bus signal.
 */
void
gdm_dbus_user_verifier_emit_conversation_started (
    GdmDBusUserVerifier *object,
    const gchar *arg_service_name)
{
  g_signal_emit (object, GDM_DBUS__USER_VERIFIER_SIGNALS[GDM_DBUS__USER_VERIFIER_CONVERSATION_STARTED], 0, arg_service_name);
}

/**
 * gdm_dbus_user_verifier_emit_conversation_stopped:
 * @object: A #GdmDBusUserVerifier.
 * @arg_service_name: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.ConversationStopped">"ConversationStopped"</link> D-Bus signal.
 */
void
gdm_dbus_user_verifier_emit_conversation_stopped (
    GdmDBusUserVerifier *object,
    const gchar *arg_service_name)
{
  g_signal_emit (object, GDM_DBUS__USER_VERIFIER_SIGNALS[GDM_DBUS__USER_VERIFIER_CONVERSATION_STOPPED], 0, arg_service_name);
}

/**
 * gdm_dbus_user_verifier_emit_reauthentication_started:
 * @object: A #GdmDBusUserVerifier.
 * @arg_pid_of_caller: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.ReauthenticationStarted">"ReauthenticationStarted"</link> D-Bus signal.
 */
void
gdm_dbus_user_verifier_emit_reauthentication_started (
    GdmDBusUserVerifier *object,
    gint arg_pid_of_caller)
{
  g_signal_emit (object, GDM_DBUS__USER_VERIFIER_SIGNALS[GDM_DBUS__USER_VERIFIER_REAUTHENTICATION_STARTED], 0, arg_pid_of_caller);
}

/**
 * gdm_dbus_user_verifier_emit_info:
 * @object: A #GdmDBusUserVerifier.
 * @arg_service_name: Argument to pass with the signal.
 * @arg_info: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.Info">"Info"</link> D-Bus signal.
 */
void
gdm_dbus_user_verifier_emit_info (
    GdmDBusUserVerifier *object,
    const gchar *arg_service_name,
    const gchar *arg_info)
{
  g_signal_emit (object, GDM_DBUS__USER_VERIFIER_SIGNALS[GDM_DBUS__USER_VERIFIER_INFO], 0, arg_service_name, arg_info);
}

/**
 * gdm_dbus_user_verifier_emit_problem:
 * @object: A #GdmDBusUserVerifier.
 * @arg_service_name: Argument to pass with the signal.
 * @arg_problem: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.Problem">"Problem"</link> D-Bus signal.
 */
void
gdm_dbus_user_verifier_emit_problem (
    GdmDBusUserVerifier *object,
    const gchar *arg_service_name,
    const gchar *arg_problem)
{
  g_signal_emit (object, GDM_DBUS__USER_VERIFIER_SIGNALS[GDM_DBUS__USER_VERIFIER_PROBLEM], 0, arg_service_name, arg_problem);
}

/**
 * gdm_dbus_user_verifier_emit_info_query:
 * @object: A #GdmDBusUserVerifier.
 * @arg_service_name: Argument to pass with the signal.
 * @arg_query: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.InfoQuery">"InfoQuery"</link> D-Bus signal.
 */
void
gdm_dbus_user_verifier_emit_info_query (
    GdmDBusUserVerifier *object,
    const gchar *arg_service_name,
    const gchar *arg_query)
{
  g_signal_emit (object, GDM_DBUS__USER_VERIFIER_SIGNALS[GDM_DBUS__USER_VERIFIER_INFO_QUERY], 0, arg_service_name, arg_query);
}

/**
 * gdm_dbus_user_verifier_emit_secret_info_query:
 * @object: A #GdmDBusUserVerifier.
 * @arg_service_name: Argument to pass with the signal.
 * @arg_query: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.SecretInfoQuery">"SecretInfoQuery"</link> D-Bus signal.
 */
void
gdm_dbus_user_verifier_emit_secret_info_query (
    GdmDBusUserVerifier *object,
    const gchar *arg_service_name,
    const gchar *arg_query)
{
  g_signal_emit (object, GDM_DBUS__USER_VERIFIER_SIGNALS[GDM_DBUS__USER_VERIFIER_SECRET_INFO_QUERY], 0, arg_service_name, arg_query);
}

/**
 * gdm_dbus_user_verifier_emit_reset:
 * @object: A #GdmDBusUserVerifier.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.Reset">"Reset"</link> D-Bus signal.
 */
void
gdm_dbus_user_verifier_emit_reset (
    GdmDBusUserVerifier *object)
{
  g_signal_emit (object, GDM_DBUS__USER_VERIFIER_SIGNALS[GDM_DBUS__USER_VERIFIER_RESET], 0);
}

/**
 * gdm_dbus_user_verifier_emit_service_unavailable:
 * @object: A #GdmDBusUserVerifier.
 * @arg_service_name: Argument to pass with the signal.
 * @arg_message: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.ServiceUnavailable">"ServiceUnavailable"</link> D-Bus signal.
 */
void
gdm_dbus_user_verifier_emit_service_unavailable (
    GdmDBusUserVerifier *object,
    const gchar *arg_service_name,
    const gchar *arg_message)
{
  g_signal_emit (object, GDM_DBUS__USER_VERIFIER_SIGNALS[GDM_DBUS__USER_VERIFIER_SERVICE_UNAVAILABLE], 0, arg_service_name, arg_message);
}

/**
 * gdm_dbus_user_verifier_emit_verification_failed:
 * @object: A #GdmDBusUserVerifier.
 * @arg_service_name: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.VerificationFailed">"VerificationFailed"</link> D-Bus signal.
 */
void
gdm_dbus_user_verifier_emit_verification_failed (
    GdmDBusUserVerifier *object,
    const gchar *arg_service_name)
{
  g_signal_emit (object, GDM_DBUS__USER_VERIFIER_SIGNALS[GDM_DBUS__USER_VERIFIER_VERIFICATION_FAILED], 0, arg_service_name);
}

/**
 * gdm_dbus_user_verifier_emit_verification_complete:
 * @object: A #GdmDBusUserVerifier.
 * @arg_service_name: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier.VerificationComplete">"VerificationComplete"</link> D-Bus signal.
 */
void
gdm_dbus_user_verifier_emit_verification_complete (
    GdmDBusUserVerifier *object,
    const gchar *arg_service_name)
{
  g_signal_emit (object, GDM_DBUS__USER_VERIFIER_SIGNALS[GDM_DBUS__USER_VERIFIER_VERIFICATION_COMPLETE], 0, arg_service_name);
}

/**
 * gdm_dbus_user_verifier_call_enable_extensions:
 * @proxy: A #GdmDBusUserVerifierProxy.
 * @arg_extensions: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.EnableExtensions">EnableExtensions()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_user_verifier_call_enable_extensions_finish() to get the result of the operation.
 *
 * See gdm_dbus_user_verifier_call_enable_extensions_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_user_verifier_call_enable_extensions (
    GdmDBusUserVerifier *proxy,
    const gchar *const *arg_extensions,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "EnableExtensions",
    g_variant_new ("(^as)",
                   arg_extensions),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_user_verifier_call_enable_extensions_finish:
 * @proxy: A #GdmDBusUserVerifierProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_user_verifier_call_enable_extensions().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_user_verifier_call_enable_extensions().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_user_verifier_call_enable_extensions_finish (
    GdmDBusUserVerifier *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_user_verifier_call_enable_extensions_sync:
 * @proxy: A #GdmDBusUserVerifierProxy.
 * @arg_extensions: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.EnableExtensions">EnableExtensions()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_user_verifier_call_enable_extensions() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_user_verifier_call_enable_extensions_sync (
    GdmDBusUserVerifier *proxy,
    const gchar *const *arg_extensions,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "EnableExtensions",
    g_variant_new ("(^as)",
                   arg_extensions),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_user_verifier_call_begin_verification:
 * @proxy: A #GdmDBusUserVerifierProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.BeginVerification">BeginVerification()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_user_verifier_call_begin_verification_finish() to get the result of the operation.
 *
 * See gdm_dbus_user_verifier_call_begin_verification_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_user_verifier_call_begin_verification (
    GdmDBusUserVerifier *proxy,
    const gchar *arg_service_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "BeginVerification",
    g_variant_new ("(s)",
                   arg_service_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_user_verifier_call_begin_verification_finish:
 * @proxy: A #GdmDBusUserVerifierProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_user_verifier_call_begin_verification().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_user_verifier_call_begin_verification().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_user_verifier_call_begin_verification_finish (
    GdmDBusUserVerifier *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_user_verifier_call_begin_verification_sync:
 * @proxy: A #GdmDBusUserVerifierProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.BeginVerification">BeginVerification()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_user_verifier_call_begin_verification() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_user_verifier_call_begin_verification_sync (
    GdmDBusUserVerifier *proxy,
    const gchar *arg_service_name,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "BeginVerification",
    g_variant_new ("(s)",
                   arg_service_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_user_verifier_call_begin_verification_for_user:
 * @proxy: A #GdmDBusUserVerifierProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_username: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.BeginVerificationForUser">BeginVerificationForUser()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_user_verifier_call_begin_verification_for_user_finish() to get the result of the operation.
 *
 * See gdm_dbus_user_verifier_call_begin_verification_for_user_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_user_verifier_call_begin_verification_for_user (
    GdmDBusUserVerifier *proxy,
    const gchar *arg_service_name,
    const gchar *arg_username,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "BeginVerificationForUser",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_username),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_user_verifier_call_begin_verification_for_user_finish:
 * @proxy: A #GdmDBusUserVerifierProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_user_verifier_call_begin_verification_for_user().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_user_verifier_call_begin_verification_for_user().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_user_verifier_call_begin_verification_for_user_finish (
    GdmDBusUserVerifier *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_user_verifier_call_begin_verification_for_user_sync:
 * @proxy: A #GdmDBusUserVerifierProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_username: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.BeginVerificationForUser">BeginVerificationForUser()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_user_verifier_call_begin_verification_for_user() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_user_verifier_call_begin_verification_for_user_sync (
    GdmDBusUserVerifier *proxy,
    const gchar *arg_service_name,
    const gchar *arg_username,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "BeginVerificationForUser",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_username),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_user_verifier_call_answer_query:
 * @proxy: A #GdmDBusUserVerifierProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_answer: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.AnswerQuery">AnswerQuery()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_user_verifier_call_answer_query_finish() to get the result of the operation.
 *
 * See gdm_dbus_user_verifier_call_answer_query_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_user_verifier_call_answer_query (
    GdmDBusUserVerifier *proxy,
    const gchar *arg_service_name,
    const gchar *arg_answer,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "AnswerQuery",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_answer),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_user_verifier_call_answer_query_finish:
 * @proxy: A #GdmDBusUserVerifierProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_user_verifier_call_answer_query().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_user_verifier_call_answer_query().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_user_verifier_call_answer_query_finish (
    GdmDBusUserVerifier *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_user_verifier_call_answer_query_sync:
 * @proxy: A #GdmDBusUserVerifierProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_answer: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.AnswerQuery">AnswerQuery()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_user_verifier_call_answer_query() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_user_verifier_call_answer_query_sync (
    GdmDBusUserVerifier *proxy,
    const gchar *arg_service_name,
    const gchar *arg_answer,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "AnswerQuery",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_answer),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_user_verifier_call_cancel:
 * @proxy: A #GdmDBusUserVerifierProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.Cancel">Cancel()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_user_verifier_call_cancel_finish() to get the result of the operation.
 *
 * See gdm_dbus_user_verifier_call_cancel_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_user_verifier_call_cancel (
    GdmDBusUserVerifier *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Cancel",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_user_verifier_call_cancel_finish:
 * @proxy: A #GdmDBusUserVerifierProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_user_verifier_call_cancel().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_user_verifier_call_cancel().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_user_verifier_call_cancel_finish (
    GdmDBusUserVerifier *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_user_verifier_call_cancel_sync:
 * @proxy: A #GdmDBusUserVerifierProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.Cancel">Cancel()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_user_verifier_call_cancel() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_user_verifier_call_cancel_sync (
    GdmDBusUserVerifier *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Cancel",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_user_verifier_complete_enable_extensions:
 * @object: A #GdmDBusUserVerifier.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.EnableExtensions">EnableExtensions()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_user_verifier_complete_enable_extensions (
    GdmDBusUserVerifier *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdm_dbus_user_verifier_complete_begin_verification:
 * @object: A #GdmDBusUserVerifier.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.BeginVerification">BeginVerification()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_user_verifier_complete_begin_verification (
    GdmDBusUserVerifier *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdm_dbus_user_verifier_complete_begin_verification_for_user:
 * @object: A #GdmDBusUserVerifier.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.BeginVerificationForUser">BeginVerificationForUser()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_user_verifier_complete_begin_verification_for_user (
    GdmDBusUserVerifier *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdm_dbus_user_verifier_complete_answer_query:
 * @object: A #GdmDBusUserVerifier.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.AnswerQuery">AnswerQuery()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_user_verifier_complete_answer_query (
    GdmDBusUserVerifier *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdm_dbus_user_verifier_complete_cancel:
 * @object: A #GdmDBusUserVerifier.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier.Cancel">Cancel()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_user_verifier_complete_cancel (
    GdmDBusUserVerifier *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * GdmDBusUserVerifierProxy:
 *
 * The #GdmDBusUserVerifierProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GdmDBusUserVerifierProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GdmDBusUserVerifierProxy.
 */

struct _GdmDBusUserVerifierProxyPrivate
{
  GData *qdata;
};

static void gdm_dbus_user_verifier_proxy_iface_init (GdmDBusUserVerifierIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GdmDBusUserVerifierProxy, gdm_dbus_user_verifier_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GdmDBusUserVerifierProxy)
                         G_IMPLEMENT_INTERFACE (GDM_DBUS_TYPE_USER_VERIFIER, gdm_dbus_user_verifier_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GdmDBusUserVerifierProxy, gdm_dbus_user_verifier_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GDM_DBUS_TYPE_USER_VERIFIER, gdm_dbus_user_verifier_proxy_iface_init))

#endif
static void
gdm_dbus_user_verifier_proxy_finalize (GObject *object)
{
  GdmDBusUserVerifierProxy *proxy = GDM_DBUS_USER_VERIFIER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (gdm_dbus_user_verifier_proxy_parent_class)->finalize (object);
}

static void
gdm_dbus_user_verifier_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gdm_dbus_user_verifier_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gdm_dbus_user_verifier_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_gdm_dbus_user_verifier_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GDM_DBUS_TYPE_USER_VERIFIER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GDM_DBUS_TYPE_USER_VERIFIER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
gdm_dbus_user_verifier_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GdmDBusUserVerifierProxy *proxy = GDM_DBUS_USER_VERIFIER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_dbus_user_verifier_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_dbus_user_verifier_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
gdm_dbus_user_verifier_proxy_init (GdmDBusUserVerifierProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = gdm_dbus_user_verifier_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GDM_DBUS_TYPE_USER_VERIFIER_PROXY, GdmDBusUserVerifierProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), gdm_dbus_user_verifier_interface_info ());
}

static void
gdm_dbus_user_verifier_proxy_class_init (GdmDBusUserVerifierProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = gdm_dbus_user_verifier_proxy_finalize;
  gobject_class->get_property = gdm_dbus_user_verifier_proxy_get_property;
  gobject_class->set_property = gdm_dbus_user_verifier_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = gdm_dbus_user_verifier_proxy_g_signal;
  proxy_class->g_properties_changed = gdm_dbus_user_verifier_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GdmDBusUserVerifierProxyPrivate));
#endif
}

static void
gdm_dbus_user_verifier_proxy_iface_init (GdmDBusUserVerifierIface *iface G_GNUC_UNUSED)
{
}

/**
 * gdm_dbus_user_verifier_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier.top_of_page">org.gnome.DisplayManager.UserVerifier</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_user_verifier_proxy_new_finish() to get the result of the operation.
 *
 * See gdm_dbus_user_verifier_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
gdm_dbus_user_verifier_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GDM_DBUS_TYPE_USER_VERIFIER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.UserVerifier", NULL);
}

/**
 * gdm_dbus_user_verifier_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_user_verifier_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gdm_dbus_user_verifier_proxy_new().
 *
 * Returns: (transfer full) (type GdmDBusUserVerifierProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmDBusUserVerifier *
gdm_dbus_user_verifier_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GDM_DBUS_USER_VERIFIER (ret);
  else
    return NULL;
}

/**
 * gdm_dbus_user_verifier_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier.top_of_page">org.gnome.DisplayManager.UserVerifier</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_user_verifier_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GdmDBusUserVerifierProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmDBusUserVerifier *
gdm_dbus_user_verifier_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GDM_DBUS_TYPE_USER_VERIFIER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.UserVerifier", NULL);
  if (ret != NULL)
    return GDM_DBUS_USER_VERIFIER (ret);
  else
    return NULL;
}


/**
 * gdm_dbus_user_verifier_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like gdm_dbus_user_verifier_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_user_verifier_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See gdm_dbus_user_verifier_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
gdm_dbus_user_verifier_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GDM_DBUS_TYPE_USER_VERIFIER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.UserVerifier", NULL);
}

/**
 * gdm_dbus_user_verifier_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_user_verifier_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gdm_dbus_user_verifier_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GdmDBusUserVerifierProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmDBusUserVerifier *
gdm_dbus_user_verifier_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GDM_DBUS_USER_VERIFIER (ret);
  else
    return NULL;
}

/**
 * gdm_dbus_user_verifier_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like gdm_dbus_user_verifier_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_user_verifier_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GdmDBusUserVerifierProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmDBusUserVerifier *
gdm_dbus_user_verifier_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GDM_DBUS_TYPE_USER_VERIFIER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.UserVerifier", NULL);
  if (ret != NULL)
    return GDM_DBUS_USER_VERIFIER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GdmDBusUserVerifierSkeleton:
 *
 * The #GdmDBusUserVerifierSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GdmDBusUserVerifierSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GdmDBusUserVerifierSkeleton.
 */

struct _GdmDBusUserVerifierSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_gdm_dbus_user_verifier_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GdmDBusUserVerifierSkeleton *skeleton = GDM_DBUS_USER_VERIFIER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GDM_DBUS_TYPE_USER_VERIFIER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GDM_DBUS_TYPE_USER_VERIFIER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_gdm_dbus_user_verifier_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GdmDBusUserVerifierSkeleton *skeleton = GDM_DBUS_USER_VERIFIER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_dbus_user_verifier_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_gdm_dbus_user_verifier_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GdmDBusUserVerifierSkeleton *skeleton = GDM_DBUS_USER_VERIFIER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_dbus_user_verifier_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _gdm_dbus_user_verifier_skeleton_vtable =
{
  _gdm_dbus_user_verifier_skeleton_handle_method_call,
  _gdm_dbus_user_verifier_skeleton_handle_get_property,
  _gdm_dbus_user_verifier_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
gdm_dbus_user_verifier_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return gdm_dbus_user_verifier_interface_info ();
}

static GDBusInterfaceVTable *
gdm_dbus_user_verifier_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_gdm_dbus_user_verifier_skeleton_vtable;
}

static GVariant *
gdm_dbus_user_verifier_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GdmDBusUserVerifierSkeleton *skeleton = GDM_DBUS_USER_VERIFIER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_gdm_dbus_user_verifier_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _gdm_dbus_user_verifier_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _gdm_dbus_user_verifier_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _gdm_dbus_user_verifier_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.UserVerifier", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
gdm_dbus_user_verifier_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_gdm_dbus_user_verifier_on_signal_conversation_started (
    GdmDBusUserVerifier *object,
    const gchar *arg_service_name)
{
  GdmDBusUserVerifierSkeleton *skeleton = GDM_DBUS_USER_VERIFIER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_service_name));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.UserVerifier", "ConversationStarted",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_dbus_user_verifier_on_signal_conversation_stopped (
    GdmDBusUserVerifier *object,
    const gchar *arg_service_name)
{
  GdmDBusUserVerifierSkeleton *skeleton = GDM_DBUS_USER_VERIFIER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_service_name));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.UserVerifier", "ConversationStopped",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_dbus_user_verifier_on_signal_reauthentication_started (
    GdmDBusUserVerifier *object,
    gint arg_pid_of_caller)
{
  GdmDBusUserVerifierSkeleton *skeleton = GDM_DBUS_USER_VERIFIER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(i)",
                   arg_pid_of_caller));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.UserVerifier", "ReauthenticationStarted",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_dbus_user_verifier_on_signal_info (
    GdmDBusUserVerifier *object,
    const gchar *arg_service_name,
    const gchar *arg_info)
{
  GdmDBusUserVerifierSkeleton *skeleton = GDM_DBUS_USER_VERIFIER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(ss)",
                   arg_service_name,
                   arg_info));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.UserVerifier", "Info",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_dbus_user_verifier_on_signal_problem (
    GdmDBusUserVerifier *object,
    const gchar *arg_service_name,
    const gchar *arg_problem)
{
  GdmDBusUserVerifierSkeleton *skeleton = GDM_DBUS_USER_VERIFIER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(ss)",
                   arg_service_name,
                   arg_problem));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.UserVerifier", "Problem",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_dbus_user_verifier_on_signal_info_query (
    GdmDBusUserVerifier *object,
    const gchar *arg_service_name,
    const gchar *arg_query)
{
  GdmDBusUserVerifierSkeleton *skeleton = GDM_DBUS_USER_VERIFIER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(ss)",
                   arg_service_name,
                   arg_query));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.UserVerifier", "InfoQuery",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_dbus_user_verifier_on_signal_secret_info_query (
    GdmDBusUserVerifier *object,
    const gchar *arg_service_name,
    const gchar *arg_query)
{
  GdmDBusUserVerifierSkeleton *skeleton = GDM_DBUS_USER_VERIFIER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(ss)",
                   arg_service_name,
                   arg_query));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.UserVerifier", "SecretInfoQuery",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_dbus_user_verifier_on_signal_reset (
    GdmDBusUserVerifier *object)
{
  GdmDBusUserVerifierSkeleton *skeleton = GDM_DBUS_USER_VERIFIER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.UserVerifier", "Reset",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_dbus_user_verifier_on_signal_service_unavailable (
    GdmDBusUserVerifier *object,
    const gchar *arg_service_name,
    const gchar *arg_message)
{
  GdmDBusUserVerifierSkeleton *skeleton = GDM_DBUS_USER_VERIFIER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(ss)",
                   arg_service_name,
                   arg_message));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.UserVerifier", "ServiceUnavailable",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_dbus_user_verifier_on_signal_verification_failed (
    GdmDBusUserVerifier *object,
    const gchar *arg_service_name)
{
  GdmDBusUserVerifierSkeleton *skeleton = GDM_DBUS_USER_VERIFIER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_service_name));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.UserVerifier", "VerificationFailed",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_dbus_user_verifier_on_signal_verification_complete (
    GdmDBusUserVerifier *object,
    const gchar *arg_service_name)
{
  GdmDBusUserVerifierSkeleton *skeleton = GDM_DBUS_USER_VERIFIER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_service_name));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.UserVerifier", "VerificationComplete",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void gdm_dbus_user_verifier_skeleton_iface_init (GdmDBusUserVerifierIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GdmDBusUserVerifierSkeleton, gdm_dbus_user_verifier_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GdmDBusUserVerifierSkeleton)
                         G_IMPLEMENT_INTERFACE (GDM_DBUS_TYPE_USER_VERIFIER, gdm_dbus_user_verifier_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GdmDBusUserVerifierSkeleton, gdm_dbus_user_verifier_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GDM_DBUS_TYPE_USER_VERIFIER, gdm_dbus_user_verifier_skeleton_iface_init))

#endif
static void
gdm_dbus_user_verifier_skeleton_finalize (GObject *object)
{
  GdmDBusUserVerifierSkeleton *skeleton = GDM_DBUS_USER_VERIFIER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (gdm_dbus_user_verifier_skeleton_parent_class)->finalize (object);
}

static void
gdm_dbus_user_verifier_skeleton_init (GdmDBusUserVerifierSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = gdm_dbus_user_verifier_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GDM_DBUS_TYPE_USER_VERIFIER_SKELETON, GdmDBusUserVerifierSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
gdm_dbus_user_verifier_skeleton_class_init (GdmDBusUserVerifierSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = gdm_dbus_user_verifier_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = gdm_dbus_user_verifier_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = gdm_dbus_user_verifier_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = gdm_dbus_user_verifier_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = gdm_dbus_user_verifier_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GdmDBusUserVerifierSkeletonPrivate));
#endif
}

static void
gdm_dbus_user_verifier_skeleton_iface_init (GdmDBusUserVerifierIface *iface)
{
  iface->conversation_started = _gdm_dbus_user_verifier_on_signal_conversation_started;
  iface->conversation_stopped = _gdm_dbus_user_verifier_on_signal_conversation_stopped;
  iface->reauthentication_started = _gdm_dbus_user_verifier_on_signal_reauthentication_started;
  iface->info = _gdm_dbus_user_verifier_on_signal_info;
  iface->problem = _gdm_dbus_user_verifier_on_signal_problem;
  iface->info_query = _gdm_dbus_user_verifier_on_signal_info_query;
  iface->secret_info_query = _gdm_dbus_user_verifier_on_signal_secret_info_query;
  iface->reset = _gdm_dbus_user_verifier_on_signal_reset;
  iface->service_unavailable = _gdm_dbus_user_verifier_on_signal_service_unavailable;
  iface->verification_failed = _gdm_dbus_user_verifier_on_signal_verification_failed;
  iface->verification_complete = _gdm_dbus_user_verifier_on_signal_verification_complete;
}

/**
 * gdm_dbus_user_verifier_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier.top_of_page">org.gnome.DisplayManager.UserVerifier</link>.
 *
 * Returns: (transfer full) (type GdmDBusUserVerifierSkeleton): The skeleton object.
 */
GdmDBusUserVerifier *
gdm_dbus_user_verifier_skeleton_new (void)
{
  return GDM_DBUS_USER_VERIFIER (g_object_new (GDM_DBUS_TYPE_USER_VERIFIER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.DisplayManager.UserVerifier.ChoiceList
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GdmDBusUserVerifierChoiceList
 * @title: GdmDBusUserVerifierChoiceList
 * @short_description: Generated C code for the org.gnome.DisplayManager.UserVerifier.ChoiceList D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier-ChoiceList.top_of_page">org.gnome.DisplayManager.UserVerifier.ChoiceList</link> D-Bus interface in C.
 */

enum
{
  GDM_DBUS__USER_VERIFIER_CHOICE_LIST_CHOICE_QUERY,
};

static unsigned GDM_DBUS__USER_VERIFIER_CHOICE_LIST_SIGNALS[1] = { 0 };

/* ---- Introspection data for org.gnome.DisplayManager.UserVerifier.ChoiceList ---- */

static const _ExtendedGDBusArgInfo _gdm_dbus_user_verifier_choice_list_method_info_select_choice_IN_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_user_verifier_choice_list_method_info_select_choice_IN_ARG_choice =
{
  {
    -1,
    (gchar *) "choice",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_user_verifier_choice_list_method_info_select_choice_IN_ARG_pointers[] =
{
  &_gdm_dbus_user_verifier_choice_list_method_info_select_choice_IN_ARG_service_name.parent_struct,
  &_gdm_dbus_user_verifier_choice_list_method_info_select_choice_IN_ARG_choice.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_dbus_user_verifier_choice_list_method_info_select_choice =
{
  {
    -1,
    (gchar *) "SelectChoice",
    (GDBusArgInfo **) &_gdm_dbus_user_verifier_choice_list_method_info_select_choice_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-select-choice",
  FALSE
};

static const GDBusMethodInfo * const _gdm_dbus_user_verifier_choice_list_method_info_pointers[] =
{
  &_gdm_dbus_user_verifier_choice_list_method_info_select_choice.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gdm_dbus_user_verifier_choice_list_signal_info_choice_query_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_user_verifier_choice_list_signal_info_choice_query_ARG_prompt_message =
{
  {
    -1,
    (gchar *) "prompt_message",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_user_verifier_choice_list_signal_info_choice_query_ARG_list =
{
  {
    -1,
    (gchar *) "list",
    (gchar *) "a{ss}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_user_verifier_choice_list_signal_info_choice_query_ARG_pointers[] =
{
  &_gdm_dbus_user_verifier_choice_list_signal_info_choice_query_ARG_service_name.parent_struct,
  &_gdm_dbus_user_verifier_choice_list_signal_info_choice_query_ARG_prompt_message.parent_struct,
  &_gdm_dbus_user_verifier_choice_list_signal_info_choice_query_ARG_list.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_dbus_user_verifier_choice_list_signal_info_choice_query =
{
  {
    -1,
    (gchar *) "ChoiceQuery",
    (GDBusArgInfo **) &_gdm_dbus_user_verifier_choice_list_signal_info_choice_query_ARG_pointers,
    NULL
  },
  "choice-query"
};

static const GDBusSignalInfo * const _gdm_dbus_user_verifier_choice_list_signal_info_pointers[] =
{
  &_gdm_dbus_user_verifier_choice_list_signal_info_choice_query.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _gdm_dbus_user_verifier_choice_list_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.DisplayManager.UserVerifier.ChoiceList",
    (GDBusMethodInfo **) &_gdm_dbus_user_verifier_choice_list_method_info_pointers,
    (GDBusSignalInfo **) &_gdm_dbus_user_verifier_choice_list_signal_info_pointers,
    NULL,
    NULL
  },
  "user-verifier-choice-list",
};


/**
 * gdm_dbus_user_verifier_choice_list_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier-ChoiceList.top_of_page">org.gnome.DisplayManager.UserVerifier.ChoiceList</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
gdm_dbus_user_verifier_choice_list_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_gdm_dbus_user_verifier_choice_list_interface_info.parent_struct;
}

/**
 * gdm_dbus_user_verifier_choice_list_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GdmDBusUserVerifierChoiceList interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
gdm_dbus_user_verifier_choice_list_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
gdm_dbus_user_verifier_choice_list_signal_marshal_choice_query (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_user_verifier_choice_list_method_marshal_select_choice (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * GdmDBusUserVerifierChoiceList:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier-ChoiceList.top_of_page">org.gnome.DisplayManager.UserVerifier.ChoiceList</link>.
 */

/**
 * GdmDBusUserVerifierChoiceListIface:
 * @parent_iface: The parent interface.
 * @handle_select_choice: Handler for the #GdmDBusUserVerifierChoiceList::handle-select-choice signal.
 * @choice_query: Handler for the #GdmDBusUserVerifierChoiceList::choice-query signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier-ChoiceList.top_of_page">org.gnome.DisplayManager.UserVerifier.ChoiceList</link>.
 */

typedef GdmDBusUserVerifierChoiceListIface GdmDBusUserVerifierChoiceListInterface;
G_DEFINE_INTERFACE (GdmDBusUserVerifierChoiceList, gdm_dbus_user_verifier_choice_list, G_TYPE_OBJECT)

static void
gdm_dbus_user_verifier_choice_list_default_init (GdmDBusUserVerifierChoiceListIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * GdmDBusUserVerifierChoiceList::handle-select-choice:
   * @object: A #GdmDBusUserVerifierChoiceList.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_service_name: Argument passed by remote caller.
   * @arg_choice: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier-ChoiceList.SelectChoice">SelectChoice()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_user_verifier_choice_list_complete_select_choice() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-select-choice",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusUserVerifierChoiceListIface, handle_select_choice),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_user_verifier_choice_list_method_marshal_select_choice,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * GdmDBusUserVerifierChoiceList::choice-query:
   * @object: A #GdmDBusUserVerifierChoiceList.
   * @arg_service_name: Argument.
   * @arg_prompt_message: Argument.
   * @arg_list: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier-ChoiceList.ChoiceQuery">"ChoiceQuery"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM_DBUS__USER_VERIFIER_CHOICE_LIST_SIGNALS[GDM_DBUS__USER_VERIFIER_CHOICE_LIST_CHOICE_QUERY] =
    g_signal_new ("choice-query",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmDBusUserVerifierChoiceListIface, choice_query),
      NULL,
      NULL,
      gdm_dbus_user_verifier_choice_list_signal_marshal_choice_query,
      G_TYPE_NONE,
      3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

}

/**
 * gdm_dbus_user_verifier_choice_list_emit_choice_query:
 * @object: A #GdmDBusUserVerifierChoiceList.
 * @arg_service_name: Argument to pass with the signal.
 * @arg_prompt_message: Argument to pass with the signal.
 * @arg_list: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier-ChoiceList.ChoiceQuery">"ChoiceQuery"</link> D-Bus signal.
 */
void
gdm_dbus_user_verifier_choice_list_emit_choice_query (
    GdmDBusUserVerifierChoiceList *object,
    const gchar *arg_service_name,
    const gchar *arg_prompt_message,
    GVariant *arg_list)
{
  g_signal_emit (object, GDM_DBUS__USER_VERIFIER_CHOICE_LIST_SIGNALS[GDM_DBUS__USER_VERIFIER_CHOICE_LIST_CHOICE_QUERY], 0, arg_service_name, arg_prompt_message, arg_list);
}

/**
 * gdm_dbus_user_verifier_choice_list_call_select_choice:
 * @proxy: A #GdmDBusUserVerifierChoiceListProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_choice: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier-ChoiceList.SelectChoice">SelectChoice()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_user_verifier_choice_list_call_select_choice_finish() to get the result of the operation.
 *
 * See gdm_dbus_user_verifier_choice_list_call_select_choice_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_user_verifier_choice_list_call_select_choice (
    GdmDBusUserVerifierChoiceList *proxy,
    const gchar *arg_service_name,
    const gchar *arg_choice,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SelectChoice",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_choice),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_user_verifier_choice_list_call_select_choice_finish:
 * @proxy: A #GdmDBusUserVerifierChoiceListProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_user_verifier_choice_list_call_select_choice().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_user_verifier_choice_list_call_select_choice().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_user_verifier_choice_list_call_select_choice_finish (
    GdmDBusUserVerifierChoiceList *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_user_verifier_choice_list_call_select_choice_sync:
 * @proxy: A #GdmDBusUserVerifierChoiceListProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_choice: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier-ChoiceList.SelectChoice">SelectChoice()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_user_verifier_choice_list_call_select_choice() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_user_verifier_choice_list_call_select_choice_sync (
    GdmDBusUserVerifierChoiceList *proxy,
    const gchar *arg_service_name,
    const gchar *arg_choice,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SelectChoice",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_choice),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_user_verifier_choice_list_complete_select_choice:
 * @object: A #GdmDBusUserVerifierChoiceList.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier-ChoiceList.SelectChoice">SelectChoice()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_user_verifier_choice_list_complete_select_choice (
    GdmDBusUserVerifierChoiceList *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * GdmDBusUserVerifierChoiceListProxy:
 *
 * The #GdmDBusUserVerifierChoiceListProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GdmDBusUserVerifierChoiceListProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GdmDBusUserVerifierChoiceListProxy.
 */

struct _GdmDBusUserVerifierChoiceListProxyPrivate
{
  GData *qdata;
};

static void gdm_dbus_user_verifier_choice_list_proxy_iface_init (GdmDBusUserVerifierChoiceListIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GdmDBusUserVerifierChoiceListProxy, gdm_dbus_user_verifier_choice_list_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GdmDBusUserVerifierChoiceListProxy)
                         G_IMPLEMENT_INTERFACE (GDM_DBUS_TYPE_USER_VERIFIER_CHOICE_LIST, gdm_dbus_user_verifier_choice_list_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GdmDBusUserVerifierChoiceListProxy, gdm_dbus_user_verifier_choice_list_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GDM_DBUS_TYPE_USER_VERIFIER_CHOICE_LIST, gdm_dbus_user_verifier_choice_list_proxy_iface_init))

#endif
static void
gdm_dbus_user_verifier_choice_list_proxy_finalize (GObject *object)
{
  GdmDBusUserVerifierChoiceListProxy *proxy = GDM_DBUS_USER_VERIFIER_CHOICE_LIST_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (gdm_dbus_user_verifier_choice_list_proxy_parent_class)->finalize (object);
}

static void
gdm_dbus_user_verifier_choice_list_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gdm_dbus_user_verifier_choice_list_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gdm_dbus_user_verifier_choice_list_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_gdm_dbus_user_verifier_choice_list_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GDM_DBUS_TYPE_USER_VERIFIER_CHOICE_LIST);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GDM_DBUS_TYPE_USER_VERIFIER_CHOICE_LIST);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
gdm_dbus_user_verifier_choice_list_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GdmDBusUserVerifierChoiceListProxy *proxy = GDM_DBUS_USER_VERIFIER_CHOICE_LIST_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_dbus_user_verifier_choice_list_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_dbus_user_verifier_choice_list_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
gdm_dbus_user_verifier_choice_list_proxy_init (GdmDBusUserVerifierChoiceListProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = gdm_dbus_user_verifier_choice_list_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GDM_DBUS_TYPE_USER_VERIFIER_CHOICE_LIST_PROXY, GdmDBusUserVerifierChoiceListProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), gdm_dbus_user_verifier_choice_list_interface_info ());
}

static void
gdm_dbus_user_verifier_choice_list_proxy_class_init (GdmDBusUserVerifierChoiceListProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = gdm_dbus_user_verifier_choice_list_proxy_finalize;
  gobject_class->get_property = gdm_dbus_user_verifier_choice_list_proxy_get_property;
  gobject_class->set_property = gdm_dbus_user_verifier_choice_list_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = gdm_dbus_user_verifier_choice_list_proxy_g_signal;
  proxy_class->g_properties_changed = gdm_dbus_user_verifier_choice_list_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GdmDBusUserVerifierChoiceListProxyPrivate));
#endif
}

static void
gdm_dbus_user_verifier_choice_list_proxy_iface_init (GdmDBusUserVerifierChoiceListIface *iface G_GNUC_UNUSED)
{
}

/**
 * gdm_dbus_user_verifier_choice_list_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier-ChoiceList.top_of_page">org.gnome.DisplayManager.UserVerifier.ChoiceList</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_user_verifier_choice_list_proxy_new_finish() to get the result of the operation.
 *
 * See gdm_dbus_user_verifier_choice_list_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
gdm_dbus_user_verifier_choice_list_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GDM_DBUS_TYPE_USER_VERIFIER_CHOICE_LIST_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.UserVerifier.ChoiceList", NULL);
}

/**
 * gdm_dbus_user_verifier_choice_list_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_user_verifier_choice_list_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gdm_dbus_user_verifier_choice_list_proxy_new().
 *
 * Returns: (transfer full) (type GdmDBusUserVerifierChoiceListProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmDBusUserVerifierChoiceList *
gdm_dbus_user_verifier_choice_list_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GDM_DBUS_USER_VERIFIER_CHOICE_LIST (ret);
  else
    return NULL;
}

/**
 * gdm_dbus_user_verifier_choice_list_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier-ChoiceList.top_of_page">org.gnome.DisplayManager.UserVerifier.ChoiceList</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_user_verifier_choice_list_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GdmDBusUserVerifierChoiceListProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmDBusUserVerifierChoiceList *
gdm_dbus_user_verifier_choice_list_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GDM_DBUS_TYPE_USER_VERIFIER_CHOICE_LIST_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.UserVerifier.ChoiceList", NULL);
  if (ret != NULL)
    return GDM_DBUS_USER_VERIFIER_CHOICE_LIST (ret);
  else
    return NULL;
}


/**
 * gdm_dbus_user_verifier_choice_list_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like gdm_dbus_user_verifier_choice_list_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_user_verifier_choice_list_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See gdm_dbus_user_verifier_choice_list_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
gdm_dbus_user_verifier_choice_list_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GDM_DBUS_TYPE_USER_VERIFIER_CHOICE_LIST_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.UserVerifier.ChoiceList", NULL);
}

/**
 * gdm_dbus_user_verifier_choice_list_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_user_verifier_choice_list_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gdm_dbus_user_verifier_choice_list_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GdmDBusUserVerifierChoiceListProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmDBusUserVerifierChoiceList *
gdm_dbus_user_verifier_choice_list_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GDM_DBUS_USER_VERIFIER_CHOICE_LIST (ret);
  else
    return NULL;
}

/**
 * gdm_dbus_user_verifier_choice_list_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like gdm_dbus_user_verifier_choice_list_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_user_verifier_choice_list_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GdmDBusUserVerifierChoiceListProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmDBusUserVerifierChoiceList *
gdm_dbus_user_verifier_choice_list_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GDM_DBUS_TYPE_USER_VERIFIER_CHOICE_LIST_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.UserVerifier.ChoiceList", NULL);
  if (ret != NULL)
    return GDM_DBUS_USER_VERIFIER_CHOICE_LIST (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GdmDBusUserVerifierChoiceListSkeleton:
 *
 * The #GdmDBusUserVerifierChoiceListSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GdmDBusUserVerifierChoiceListSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GdmDBusUserVerifierChoiceListSkeleton.
 */

struct _GdmDBusUserVerifierChoiceListSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_gdm_dbus_user_verifier_choice_list_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GdmDBusUserVerifierChoiceListSkeleton *skeleton = GDM_DBUS_USER_VERIFIER_CHOICE_LIST_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GDM_DBUS_TYPE_USER_VERIFIER_CHOICE_LIST);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GDM_DBUS_TYPE_USER_VERIFIER_CHOICE_LIST);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_gdm_dbus_user_verifier_choice_list_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GdmDBusUserVerifierChoiceListSkeleton *skeleton = GDM_DBUS_USER_VERIFIER_CHOICE_LIST_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_dbus_user_verifier_choice_list_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_gdm_dbus_user_verifier_choice_list_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GdmDBusUserVerifierChoiceListSkeleton *skeleton = GDM_DBUS_USER_VERIFIER_CHOICE_LIST_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_dbus_user_verifier_choice_list_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _gdm_dbus_user_verifier_choice_list_skeleton_vtable =
{
  _gdm_dbus_user_verifier_choice_list_skeleton_handle_method_call,
  _gdm_dbus_user_verifier_choice_list_skeleton_handle_get_property,
  _gdm_dbus_user_verifier_choice_list_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
gdm_dbus_user_verifier_choice_list_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return gdm_dbus_user_verifier_choice_list_interface_info ();
}

static GDBusInterfaceVTable *
gdm_dbus_user_verifier_choice_list_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_gdm_dbus_user_verifier_choice_list_skeleton_vtable;
}

static GVariant *
gdm_dbus_user_verifier_choice_list_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GdmDBusUserVerifierChoiceListSkeleton *skeleton = GDM_DBUS_USER_VERIFIER_CHOICE_LIST_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_gdm_dbus_user_verifier_choice_list_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _gdm_dbus_user_verifier_choice_list_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _gdm_dbus_user_verifier_choice_list_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _gdm_dbus_user_verifier_choice_list_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.UserVerifier.ChoiceList", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
gdm_dbus_user_verifier_choice_list_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_gdm_dbus_user_verifier_choice_list_on_signal_choice_query (
    GdmDBusUserVerifierChoiceList *object,
    const gchar *arg_service_name,
    const gchar *arg_prompt_message,
    GVariant *arg_list)
{
  GdmDBusUserVerifierChoiceListSkeleton *skeleton = GDM_DBUS_USER_VERIFIER_CHOICE_LIST_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(ss@a{ss})",
                   arg_service_name,
                   arg_prompt_message,
                   arg_list));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.UserVerifier.ChoiceList", "ChoiceQuery",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void gdm_dbus_user_verifier_choice_list_skeleton_iface_init (GdmDBusUserVerifierChoiceListIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GdmDBusUserVerifierChoiceListSkeleton, gdm_dbus_user_verifier_choice_list_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GdmDBusUserVerifierChoiceListSkeleton)
                         G_IMPLEMENT_INTERFACE (GDM_DBUS_TYPE_USER_VERIFIER_CHOICE_LIST, gdm_dbus_user_verifier_choice_list_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GdmDBusUserVerifierChoiceListSkeleton, gdm_dbus_user_verifier_choice_list_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GDM_DBUS_TYPE_USER_VERIFIER_CHOICE_LIST, gdm_dbus_user_verifier_choice_list_skeleton_iface_init))

#endif
static void
gdm_dbus_user_verifier_choice_list_skeleton_finalize (GObject *object)
{
  GdmDBusUserVerifierChoiceListSkeleton *skeleton = GDM_DBUS_USER_VERIFIER_CHOICE_LIST_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (gdm_dbus_user_verifier_choice_list_skeleton_parent_class)->finalize (object);
}

static void
gdm_dbus_user_verifier_choice_list_skeleton_init (GdmDBusUserVerifierChoiceListSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = gdm_dbus_user_verifier_choice_list_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GDM_DBUS_TYPE_USER_VERIFIER_CHOICE_LIST_SKELETON, GdmDBusUserVerifierChoiceListSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
gdm_dbus_user_verifier_choice_list_skeleton_class_init (GdmDBusUserVerifierChoiceListSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = gdm_dbus_user_verifier_choice_list_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = gdm_dbus_user_verifier_choice_list_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = gdm_dbus_user_verifier_choice_list_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = gdm_dbus_user_verifier_choice_list_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = gdm_dbus_user_verifier_choice_list_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GdmDBusUserVerifierChoiceListSkeletonPrivate));
#endif
}

static void
gdm_dbus_user_verifier_choice_list_skeleton_iface_init (GdmDBusUserVerifierChoiceListIface *iface)
{
  iface->choice_query = _gdm_dbus_user_verifier_choice_list_on_signal_choice_query;
}

/**
 * gdm_dbus_user_verifier_choice_list_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier-ChoiceList.top_of_page">org.gnome.DisplayManager.UserVerifier.ChoiceList</link>.
 *
 * Returns: (transfer full) (type GdmDBusUserVerifierChoiceListSkeleton): The skeleton object.
 */
GdmDBusUserVerifierChoiceList *
gdm_dbus_user_verifier_choice_list_skeleton_new (void)
{
  return GDM_DBUS_USER_VERIFIER_CHOICE_LIST (g_object_new (GDM_DBUS_TYPE_USER_VERIFIER_CHOICE_LIST_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.DisplayManager.UserVerifier.CustomJSON
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GdmDBusUserVerifierCustomJSON
 * @title: GdmDBusUserVerifierCustomJSON
 * @short_description: Generated C code for the org.gnome.DisplayManager.UserVerifier.CustomJSON D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier-CustomJSON.top_of_page">org.gnome.DisplayManager.UserVerifier.CustomJSON</link> D-Bus interface in C.
 */

enum
{
  GDM_DBUS__USER_VERIFIER_CUSTOM_JSON_REQUEST,
};

static unsigned GDM_DBUS__USER_VERIFIER_CUSTOM_JSON_SIGNALS[1] = { 0 };

/* ---- Introspection data for org.gnome.DisplayManager.UserVerifier.CustomJSON ---- */

static const _ExtendedGDBusArgInfo _gdm_dbus_user_verifier_custom_json_method_info_reply_IN_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_user_verifier_custom_json_method_info_reply_IN_ARG_reply =
{
  {
    -1,
    (gchar *) "reply",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_user_verifier_custom_json_method_info_reply_IN_ARG_pointers[] =
{
  &_gdm_dbus_user_verifier_custom_json_method_info_reply_IN_ARG_service_name.parent_struct,
  &_gdm_dbus_user_verifier_custom_json_method_info_reply_IN_ARG_reply.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_dbus_user_verifier_custom_json_method_info_reply =
{
  {
    -1,
    (gchar *) "Reply",
    (GDBusArgInfo **) &_gdm_dbus_user_verifier_custom_json_method_info_reply_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-reply",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_user_verifier_custom_json_method_info_report_error_IN_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_user_verifier_custom_json_method_info_report_error_IN_ARG_error =
{
  {
    -1,
    (gchar *) "error",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_user_verifier_custom_json_method_info_report_error_IN_ARG_pointers[] =
{
  &_gdm_dbus_user_verifier_custom_json_method_info_report_error_IN_ARG_service_name.parent_struct,
  &_gdm_dbus_user_verifier_custom_json_method_info_report_error_IN_ARG_error.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_dbus_user_verifier_custom_json_method_info_report_error =
{
  {
    -1,
    (gchar *) "ReportError",
    (GDBusArgInfo **) &_gdm_dbus_user_verifier_custom_json_method_info_report_error_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-report-error",
  FALSE
};

static const GDBusMethodInfo * const _gdm_dbus_user_verifier_custom_json_method_info_pointers[] =
{
  &_gdm_dbus_user_verifier_custom_json_method_info_reply.parent_struct,
  &_gdm_dbus_user_verifier_custom_json_method_info_report_error.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gdm_dbus_user_verifier_custom_json_signal_info_request_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_user_verifier_custom_json_signal_info_request_ARG_protocol =
{
  {
    -1,
    (gchar *) "protocol",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_user_verifier_custom_json_signal_info_request_ARG_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_user_verifier_custom_json_signal_info_request_ARG_request =
{
  {
    -1,
    (gchar *) "request",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_user_verifier_custom_json_signal_info_request_ARG_pointers[] =
{
  &_gdm_dbus_user_verifier_custom_json_signal_info_request_ARG_service_name.parent_struct,
  &_gdm_dbus_user_verifier_custom_json_signal_info_request_ARG_protocol.parent_struct,
  &_gdm_dbus_user_verifier_custom_json_signal_info_request_ARG_version.parent_struct,
  &_gdm_dbus_user_verifier_custom_json_signal_info_request_ARG_request.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_dbus_user_verifier_custom_json_signal_info_request =
{
  {
    -1,
    (gchar *) "Request",
    (GDBusArgInfo **) &_gdm_dbus_user_verifier_custom_json_signal_info_request_ARG_pointers,
    NULL
  },
  "request"
};

static const GDBusSignalInfo * const _gdm_dbus_user_verifier_custom_json_signal_info_pointers[] =
{
  &_gdm_dbus_user_verifier_custom_json_signal_info_request.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _gdm_dbus_user_verifier_custom_json_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.DisplayManager.UserVerifier.CustomJSON",
    (GDBusMethodInfo **) &_gdm_dbus_user_verifier_custom_json_method_info_pointers,
    (GDBusSignalInfo **) &_gdm_dbus_user_verifier_custom_json_signal_info_pointers,
    NULL,
    NULL
  },
  "user-verifier-custom-json",
};


/**
 * gdm_dbus_user_verifier_custom_json_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier-CustomJSON.top_of_page">org.gnome.DisplayManager.UserVerifier.CustomJSON</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
gdm_dbus_user_verifier_custom_json_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_gdm_dbus_user_verifier_custom_json_interface_info.parent_struct;
}

/**
 * gdm_dbus_user_verifier_custom_json_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GdmDBusUserVerifierCustomJSON interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
gdm_dbus_user_verifier_custom_json_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
gdm_dbus_user_verifier_custom_json_signal_marshal_request (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_STRING_UINT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_user_verifier_custom_json_method_marshal_reply (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_user_verifier_custom_json_method_marshal_report_error (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * GdmDBusUserVerifierCustomJSON:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier-CustomJSON.top_of_page">org.gnome.DisplayManager.UserVerifier.CustomJSON</link>.
 */

/**
 * GdmDBusUserVerifierCustomJSONIface:
 * @parent_iface: The parent interface.
 * @handle_reply: Handler for the #GdmDBusUserVerifierCustomJSON::handle-reply signal.
 * @handle_report_error: Handler for the #GdmDBusUserVerifierCustomJSON::handle-report-error signal.
 * @request: Handler for the #GdmDBusUserVerifierCustomJSON::request signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier-CustomJSON.top_of_page">org.gnome.DisplayManager.UserVerifier.CustomJSON</link>.
 */

typedef GdmDBusUserVerifierCustomJSONIface GdmDBusUserVerifierCustomJSONInterface;
G_DEFINE_INTERFACE (GdmDBusUserVerifierCustomJSON, gdm_dbus_user_verifier_custom_json, G_TYPE_OBJECT)

static void
gdm_dbus_user_verifier_custom_json_default_init (GdmDBusUserVerifierCustomJSONIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * GdmDBusUserVerifierCustomJSON::handle-reply:
   * @object: A #GdmDBusUserVerifierCustomJSON.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_service_name: Argument passed by remote caller.
   * @arg_reply: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier-CustomJSON.Reply">Reply()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_user_verifier_custom_json_complete_reply() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-reply",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusUserVerifierCustomJSONIface, handle_reply),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_user_verifier_custom_json_method_marshal_reply,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * GdmDBusUserVerifierCustomJSON::handle-report-error:
   * @object: A #GdmDBusUserVerifierCustomJSON.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_service_name: Argument passed by remote caller.
   * @arg_error: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier-CustomJSON.ReportError">ReportError()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_user_verifier_custom_json_complete_report_error() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-report-error",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusUserVerifierCustomJSONIface, handle_report_error),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_user_verifier_custom_json_method_marshal_report_error,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * GdmDBusUserVerifierCustomJSON::request:
   * @object: A #GdmDBusUserVerifierCustomJSON.
   * @arg_service_name: Argument.
   * @arg_protocol: Argument.
   * @arg_version: Argument.
   * @arg_request: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier-CustomJSON.Request">"Request"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM_DBUS__USER_VERIFIER_CUSTOM_JSON_SIGNALS[GDM_DBUS__USER_VERIFIER_CUSTOM_JSON_REQUEST] =
    g_signal_new ("request",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmDBusUserVerifierCustomJSONIface, request),
      NULL,
      NULL,
      gdm_dbus_user_verifier_custom_json_signal_marshal_request,
      G_TYPE_NONE,
      4, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING);

}

/**
 * gdm_dbus_user_verifier_custom_json_emit_request:
 * @object: A #GdmDBusUserVerifierCustomJSON.
 * @arg_service_name: Argument to pass with the signal.
 * @arg_protocol: Argument to pass with the signal.
 * @arg_version: Argument to pass with the signal.
 * @arg_request: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-UserVerifier-CustomJSON.Request">"Request"</link> D-Bus signal.
 */
void
gdm_dbus_user_verifier_custom_json_emit_request (
    GdmDBusUserVerifierCustomJSON *object,
    const gchar *arg_service_name,
    const gchar *arg_protocol,
    guint arg_version,
    const gchar *arg_request)
{
  g_signal_emit (object, GDM_DBUS__USER_VERIFIER_CUSTOM_JSON_SIGNALS[GDM_DBUS__USER_VERIFIER_CUSTOM_JSON_REQUEST], 0, arg_service_name, arg_protocol, arg_version, arg_request);
}

/**
 * gdm_dbus_user_verifier_custom_json_call_reply:
 * @proxy: A #GdmDBusUserVerifierCustomJSONProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_reply: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier-CustomJSON.Reply">Reply()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_user_verifier_custom_json_call_reply_finish() to get the result of the operation.
 *
 * See gdm_dbus_user_verifier_custom_json_call_reply_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_user_verifier_custom_json_call_reply (
    GdmDBusUserVerifierCustomJSON *proxy,
    const gchar *arg_service_name,
    const gchar *arg_reply,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Reply",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_reply),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_user_verifier_custom_json_call_reply_finish:
 * @proxy: A #GdmDBusUserVerifierCustomJSONProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_user_verifier_custom_json_call_reply().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_user_verifier_custom_json_call_reply().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_user_verifier_custom_json_call_reply_finish (
    GdmDBusUserVerifierCustomJSON *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_user_verifier_custom_json_call_reply_sync:
 * @proxy: A #GdmDBusUserVerifierCustomJSONProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_reply: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier-CustomJSON.Reply">Reply()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_user_verifier_custom_json_call_reply() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_user_verifier_custom_json_call_reply_sync (
    GdmDBusUserVerifierCustomJSON *proxy,
    const gchar *arg_service_name,
    const gchar *arg_reply,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Reply",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_reply),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_user_verifier_custom_json_call_report_error:
 * @proxy: A #GdmDBusUserVerifierCustomJSONProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_error: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier-CustomJSON.ReportError">ReportError()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_user_verifier_custom_json_call_report_error_finish() to get the result of the operation.
 *
 * See gdm_dbus_user_verifier_custom_json_call_report_error_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_user_verifier_custom_json_call_report_error (
    GdmDBusUserVerifierCustomJSON *proxy,
    const gchar *arg_service_name,
    const gchar *arg_error,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ReportError",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_error),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_user_verifier_custom_json_call_report_error_finish:
 * @proxy: A #GdmDBusUserVerifierCustomJSONProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_user_verifier_custom_json_call_report_error().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_user_verifier_custom_json_call_report_error().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_user_verifier_custom_json_call_report_error_finish (
    GdmDBusUserVerifierCustomJSON *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_user_verifier_custom_json_call_report_error_sync:
 * @proxy: A #GdmDBusUserVerifierCustomJSONProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_error: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier-CustomJSON.ReportError">ReportError()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_user_verifier_custom_json_call_report_error() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_user_verifier_custom_json_call_report_error_sync (
    GdmDBusUserVerifierCustomJSON *proxy,
    const gchar *arg_service_name,
    const gchar *arg_error,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ReportError",
    g_variant_new ("(ss)",
                   arg_service_name,
                   arg_error),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_user_verifier_custom_json_complete_reply:
 * @object: A #GdmDBusUserVerifierCustomJSON.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier-CustomJSON.Reply">Reply()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_user_verifier_custom_json_complete_reply (
    GdmDBusUserVerifierCustomJSON *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdm_dbus_user_verifier_custom_json_complete_report_error:
 * @object: A #GdmDBusUserVerifierCustomJSON.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-UserVerifier-CustomJSON.ReportError">ReportError()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_user_verifier_custom_json_complete_report_error (
    GdmDBusUserVerifierCustomJSON *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * GdmDBusUserVerifierCustomJSONProxy:
 *
 * The #GdmDBusUserVerifierCustomJSONProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GdmDBusUserVerifierCustomJSONProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GdmDBusUserVerifierCustomJSONProxy.
 */

struct _GdmDBusUserVerifierCustomJSONProxyPrivate
{
  GData *qdata;
};

static void gdm_dbus_user_verifier_custom_json_proxy_iface_init (GdmDBusUserVerifierCustomJSONIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GdmDBusUserVerifierCustomJSONProxy, gdm_dbus_user_verifier_custom_json_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GdmDBusUserVerifierCustomJSONProxy)
                         G_IMPLEMENT_INTERFACE (GDM_DBUS_TYPE_USER_VERIFIER_CUSTOM_JSON, gdm_dbus_user_verifier_custom_json_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GdmDBusUserVerifierCustomJSONProxy, gdm_dbus_user_verifier_custom_json_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GDM_DBUS_TYPE_USER_VERIFIER_CUSTOM_JSON, gdm_dbus_user_verifier_custom_json_proxy_iface_init))

#endif
static void
gdm_dbus_user_verifier_custom_json_proxy_finalize (GObject *object)
{
  GdmDBusUserVerifierCustomJSONProxy *proxy = GDM_DBUS_USER_VERIFIER_CUSTOM_JSON_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (gdm_dbus_user_verifier_custom_json_proxy_parent_class)->finalize (object);
}

static void
gdm_dbus_user_verifier_custom_json_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gdm_dbus_user_verifier_custom_json_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gdm_dbus_user_verifier_custom_json_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_gdm_dbus_user_verifier_custom_json_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GDM_DBUS_TYPE_USER_VERIFIER_CUSTOM_JSON);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GDM_DBUS_TYPE_USER_VERIFIER_CUSTOM_JSON);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
gdm_dbus_user_verifier_custom_json_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GdmDBusUserVerifierCustomJSONProxy *proxy = GDM_DBUS_USER_VERIFIER_CUSTOM_JSON_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_dbus_user_verifier_custom_json_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_dbus_user_verifier_custom_json_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
gdm_dbus_user_verifier_custom_json_proxy_init (GdmDBusUserVerifierCustomJSONProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = gdm_dbus_user_verifier_custom_json_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GDM_DBUS_TYPE_USER_VERIFIER_CUSTOM_JSON_PROXY, GdmDBusUserVerifierCustomJSONProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), gdm_dbus_user_verifier_custom_json_interface_info ());
}

static void
gdm_dbus_user_verifier_custom_json_proxy_class_init (GdmDBusUserVerifierCustomJSONProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = gdm_dbus_user_verifier_custom_json_proxy_finalize;
  gobject_class->get_property = gdm_dbus_user_verifier_custom_json_proxy_get_property;
  gobject_class->set_property = gdm_dbus_user_verifier_custom_json_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = gdm_dbus_user_verifier_custom_json_proxy_g_signal;
  proxy_class->g_properties_changed = gdm_dbus_user_verifier_custom_json_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GdmDBusUserVerifierCustomJSONProxyPrivate));
#endif
}

static void
gdm_dbus_user_verifier_custom_json_proxy_iface_init (GdmDBusUserVerifierCustomJSONIface *iface G_GNUC_UNUSED)
{
}

/**
 * gdm_dbus_user_verifier_custom_json_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier-CustomJSON.top_of_page">org.gnome.DisplayManager.UserVerifier.CustomJSON</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_user_verifier_custom_json_proxy_new_finish() to get the result of the operation.
 *
 * See gdm_dbus_user_verifier_custom_json_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
gdm_dbus_user_verifier_custom_json_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GDM_DBUS_TYPE_USER_VERIFIER_CUSTOM_JSON_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.UserVerifier.CustomJSON", NULL);
}

/**
 * gdm_dbus_user_verifier_custom_json_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_user_verifier_custom_json_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gdm_dbus_user_verifier_custom_json_proxy_new().
 *
 * Returns: (transfer full) (type GdmDBusUserVerifierCustomJSONProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmDBusUserVerifierCustomJSON *
gdm_dbus_user_verifier_custom_json_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GDM_DBUS_USER_VERIFIER_CUSTOM_JSON (ret);
  else
    return NULL;
}

/**
 * gdm_dbus_user_verifier_custom_json_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier-CustomJSON.top_of_page">org.gnome.DisplayManager.UserVerifier.CustomJSON</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_user_verifier_custom_json_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GdmDBusUserVerifierCustomJSONProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmDBusUserVerifierCustomJSON *
gdm_dbus_user_verifier_custom_json_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GDM_DBUS_TYPE_USER_VERIFIER_CUSTOM_JSON_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.UserVerifier.CustomJSON", NULL);
  if (ret != NULL)
    return GDM_DBUS_USER_VERIFIER_CUSTOM_JSON (ret);
  else
    return NULL;
}


/**
 * gdm_dbus_user_verifier_custom_json_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like gdm_dbus_user_verifier_custom_json_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_user_verifier_custom_json_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See gdm_dbus_user_verifier_custom_json_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
gdm_dbus_user_verifier_custom_json_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GDM_DBUS_TYPE_USER_VERIFIER_CUSTOM_JSON_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.UserVerifier.CustomJSON", NULL);
}

/**
 * gdm_dbus_user_verifier_custom_json_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_user_verifier_custom_json_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gdm_dbus_user_verifier_custom_json_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GdmDBusUserVerifierCustomJSONProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmDBusUserVerifierCustomJSON *
gdm_dbus_user_verifier_custom_json_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GDM_DBUS_USER_VERIFIER_CUSTOM_JSON (ret);
  else
    return NULL;
}

/**
 * gdm_dbus_user_verifier_custom_json_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like gdm_dbus_user_verifier_custom_json_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_user_verifier_custom_json_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GdmDBusUserVerifierCustomJSONProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmDBusUserVerifierCustomJSON *
gdm_dbus_user_verifier_custom_json_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GDM_DBUS_TYPE_USER_VERIFIER_CUSTOM_JSON_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.UserVerifier.CustomJSON", NULL);
  if (ret != NULL)
    return GDM_DBUS_USER_VERIFIER_CUSTOM_JSON (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GdmDBusUserVerifierCustomJSONSkeleton:
 *
 * The #GdmDBusUserVerifierCustomJSONSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GdmDBusUserVerifierCustomJSONSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GdmDBusUserVerifierCustomJSONSkeleton.
 */

struct _GdmDBusUserVerifierCustomJSONSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_gdm_dbus_user_verifier_custom_json_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GdmDBusUserVerifierCustomJSONSkeleton *skeleton = GDM_DBUS_USER_VERIFIER_CUSTOM_JSON_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GDM_DBUS_TYPE_USER_VERIFIER_CUSTOM_JSON);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GDM_DBUS_TYPE_USER_VERIFIER_CUSTOM_JSON);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_gdm_dbus_user_verifier_custom_json_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GdmDBusUserVerifierCustomJSONSkeleton *skeleton = GDM_DBUS_USER_VERIFIER_CUSTOM_JSON_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_dbus_user_verifier_custom_json_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_gdm_dbus_user_verifier_custom_json_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GdmDBusUserVerifierCustomJSONSkeleton *skeleton = GDM_DBUS_USER_VERIFIER_CUSTOM_JSON_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_dbus_user_verifier_custom_json_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _gdm_dbus_user_verifier_custom_json_skeleton_vtable =
{
  _gdm_dbus_user_verifier_custom_json_skeleton_handle_method_call,
  _gdm_dbus_user_verifier_custom_json_skeleton_handle_get_property,
  _gdm_dbus_user_verifier_custom_json_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
gdm_dbus_user_verifier_custom_json_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return gdm_dbus_user_verifier_custom_json_interface_info ();
}

static GDBusInterfaceVTable *
gdm_dbus_user_verifier_custom_json_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_gdm_dbus_user_verifier_custom_json_skeleton_vtable;
}

static GVariant *
gdm_dbus_user_verifier_custom_json_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GdmDBusUserVerifierCustomJSONSkeleton *skeleton = GDM_DBUS_USER_VERIFIER_CUSTOM_JSON_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_gdm_dbus_user_verifier_custom_json_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _gdm_dbus_user_verifier_custom_json_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _gdm_dbus_user_verifier_custom_json_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _gdm_dbus_user_verifier_custom_json_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.UserVerifier.CustomJSON", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
gdm_dbus_user_verifier_custom_json_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_gdm_dbus_user_verifier_custom_json_on_signal_request (
    GdmDBusUserVerifierCustomJSON *object,
    const gchar *arg_service_name,
    const gchar *arg_protocol,
    guint arg_version,
    const gchar *arg_request)
{
  GdmDBusUserVerifierCustomJSONSkeleton *skeleton = GDM_DBUS_USER_VERIFIER_CUSTOM_JSON_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(ssus)",
                   arg_service_name,
                   arg_protocol,
                   arg_version,
                   arg_request));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.UserVerifier.CustomJSON", "Request",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void gdm_dbus_user_verifier_custom_json_skeleton_iface_init (GdmDBusUserVerifierCustomJSONIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GdmDBusUserVerifierCustomJSONSkeleton, gdm_dbus_user_verifier_custom_json_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GdmDBusUserVerifierCustomJSONSkeleton)
                         G_IMPLEMENT_INTERFACE (GDM_DBUS_TYPE_USER_VERIFIER_CUSTOM_JSON, gdm_dbus_user_verifier_custom_json_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GdmDBusUserVerifierCustomJSONSkeleton, gdm_dbus_user_verifier_custom_json_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GDM_DBUS_TYPE_USER_VERIFIER_CUSTOM_JSON, gdm_dbus_user_verifier_custom_json_skeleton_iface_init))

#endif
static void
gdm_dbus_user_verifier_custom_json_skeleton_finalize (GObject *object)
{
  GdmDBusUserVerifierCustomJSONSkeleton *skeleton = GDM_DBUS_USER_VERIFIER_CUSTOM_JSON_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (gdm_dbus_user_verifier_custom_json_skeleton_parent_class)->finalize (object);
}

static void
gdm_dbus_user_verifier_custom_json_skeleton_init (GdmDBusUserVerifierCustomJSONSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = gdm_dbus_user_verifier_custom_json_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GDM_DBUS_TYPE_USER_VERIFIER_CUSTOM_JSON_SKELETON, GdmDBusUserVerifierCustomJSONSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
gdm_dbus_user_verifier_custom_json_skeleton_class_init (GdmDBusUserVerifierCustomJSONSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = gdm_dbus_user_verifier_custom_json_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = gdm_dbus_user_verifier_custom_json_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = gdm_dbus_user_verifier_custom_json_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = gdm_dbus_user_verifier_custom_json_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = gdm_dbus_user_verifier_custom_json_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GdmDBusUserVerifierCustomJSONSkeletonPrivate));
#endif
}

static void
gdm_dbus_user_verifier_custom_json_skeleton_iface_init (GdmDBusUserVerifierCustomJSONIface *iface)
{
  iface->request = _gdm_dbus_user_verifier_custom_json_on_signal_request;
}

/**
 * gdm_dbus_user_verifier_custom_json_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-UserVerifier-CustomJSON.top_of_page">org.gnome.DisplayManager.UserVerifier.CustomJSON</link>.
 *
 * Returns: (transfer full) (type GdmDBusUserVerifierCustomJSONSkeleton): The skeleton object.
 */
GdmDBusUserVerifierCustomJSON *
gdm_dbus_user_verifier_custom_json_skeleton_new (void)
{
  return GDM_DBUS_USER_VERIFIER_CUSTOM_JSON (g_object_new (GDM_DBUS_TYPE_USER_VERIFIER_CUSTOM_JSON_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.DisplayManager.Greeter
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GdmDBusGreeter
 * @title: GdmDBusGreeter
 * @short_description: Generated C code for the org.gnome.DisplayManager.Greeter D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-DisplayManager-Greeter.top_of_page">org.gnome.DisplayManager.Greeter</link> D-Bus interface in C.
 */

enum
{
  GDM_DBUS__GREETER_SELECTED_USER_CHANGED,
  GDM_DBUS__GREETER_DEFAULT_LANGUAGE_NAME_CHANGED,
  GDM_DBUS__GREETER_DEFAULT_SESSION_NAME_CHANGED,
  GDM_DBUS__GREETER_TIMED_LOGIN_REQUESTED,
  GDM_DBUS__GREETER_SESSION_OPENED,
  GDM_DBUS__GREETER_REAUTHENTICATED,
};

static unsigned GDM_DBUS__GREETER_SIGNALS[6] = { 0 };

/* ---- Introspection data for org.gnome.DisplayManager.Greeter ---- */

static const _ExtendedGDBusArgInfo _gdm_dbus_greeter_method_info_select_session_IN_ARG_session =
{
  {
    -1,
    (gchar *) "session",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_greeter_method_info_select_session_IN_ARG_pointers[] =
{
  &_gdm_dbus_greeter_method_info_select_session_IN_ARG_session.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_dbus_greeter_method_info_select_session =
{
  {
    -1,
    (gchar *) "SelectSession",
    (GDBusArgInfo **) &_gdm_dbus_greeter_method_info_select_session_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-select-session",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_greeter_method_info_select_user_IN_ARG_username =
{
  {
    -1,
    (gchar *) "username",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_greeter_method_info_select_user_IN_ARG_pointers[] =
{
  &_gdm_dbus_greeter_method_info_select_user_IN_ARG_username.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_dbus_greeter_method_info_select_user =
{
  {
    -1,
    (gchar *) "SelectUser",
    (GDBusArgInfo **) &_gdm_dbus_greeter_method_info_select_user_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-select-user",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_greeter_method_info_begin_auto_login_IN_ARG_username =
{
  {
    -1,
    (gchar *) "username",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_greeter_method_info_begin_auto_login_IN_ARG_pointers[] =
{
  &_gdm_dbus_greeter_method_info_begin_auto_login_IN_ARG_username.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_dbus_greeter_method_info_begin_auto_login =
{
  {
    -1,
    (gchar *) "BeginAutoLogin",
    (GDBusArgInfo **) &_gdm_dbus_greeter_method_info_begin_auto_login_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-begin-auto-login",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_greeter_method_info_get_timed_login_details_OUT_ARG_enabled =
{
  {
    -1,
    (gchar *) "enabled",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_greeter_method_info_get_timed_login_details_OUT_ARG_username =
{
  {
    -1,
    (gchar *) "username",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_greeter_method_info_get_timed_login_details_OUT_ARG_delay =
{
  {
    -1,
    (gchar *) "delay",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_greeter_method_info_get_timed_login_details_OUT_ARG_pointers[] =
{
  &_gdm_dbus_greeter_method_info_get_timed_login_details_OUT_ARG_enabled.parent_struct,
  &_gdm_dbus_greeter_method_info_get_timed_login_details_OUT_ARG_username.parent_struct,
  &_gdm_dbus_greeter_method_info_get_timed_login_details_OUT_ARG_delay.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_dbus_greeter_method_info_get_timed_login_details =
{
  {
    -1,
    (gchar *) "GetTimedLoginDetails",
    NULL,
    (GDBusArgInfo **) &_gdm_dbus_greeter_method_info_get_timed_login_details_OUT_ARG_pointers,
    NULL
  },
  "handle-get-timed-login-details",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_greeter_method_info_start_session_when_ready_IN_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_greeter_method_info_start_session_when_ready_IN_ARG_should_start_session =
{
  {
    -1,
    (gchar *) "should_start_session",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_greeter_method_info_start_session_when_ready_IN_ARG_pointers[] =
{
  &_gdm_dbus_greeter_method_info_start_session_when_ready_IN_ARG_service_name.parent_struct,
  &_gdm_dbus_greeter_method_info_start_session_when_ready_IN_ARG_should_start_session.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_dbus_greeter_method_info_start_session_when_ready =
{
  {
    -1,
    (gchar *) "StartSessionWhenReady",
    (GDBusArgInfo **) &_gdm_dbus_greeter_method_info_start_session_when_ready_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-start-session-when-ready",
  FALSE
};

static const _ExtendedGDBusMethodInfo _gdm_dbus_greeter_method_info_stop_conflicting_session =
{
  {
    -1,
    (gchar *) "StopConflictingSession",
    NULL,
    NULL,
    NULL
  },
  "handle-stop-conflicting-session",
  FALSE
};

static const GDBusMethodInfo * const _gdm_dbus_greeter_method_info_pointers[] =
{
  &_gdm_dbus_greeter_method_info_select_session.parent_struct,
  &_gdm_dbus_greeter_method_info_select_user.parent_struct,
  &_gdm_dbus_greeter_method_info_begin_auto_login.parent_struct,
  &_gdm_dbus_greeter_method_info_get_timed_login_details.parent_struct,
  &_gdm_dbus_greeter_method_info_start_session_when_ready.parent_struct,
  &_gdm_dbus_greeter_method_info_stop_conflicting_session.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gdm_dbus_greeter_signal_info_selected_user_changed_ARG_username =
{
  {
    -1,
    (gchar *) "username",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_greeter_signal_info_selected_user_changed_ARG_pointers[] =
{
  &_gdm_dbus_greeter_signal_info_selected_user_changed_ARG_username.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_dbus_greeter_signal_info_selected_user_changed =
{
  {
    -1,
    (gchar *) "SelectedUserChanged",
    (GDBusArgInfo **) &_gdm_dbus_greeter_signal_info_selected_user_changed_ARG_pointers,
    NULL
  },
  "selected-user-changed"
};

static const _ExtendedGDBusArgInfo _gdm_dbus_greeter_signal_info_default_language_name_changed_ARG_language_name =
{
  {
    -1,
    (gchar *) "language_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_greeter_signal_info_default_language_name_changed_ARG_pointers[] =
{
  &_gdm_dbus_greeter_signal_info_default_language_name_changed_ARG_language_name.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_dbus_greeter_signal_info_default_language_name_changed =
{
  {
    -1,
    (gchar *) "DefaultLanguageNameChanged",
    (GDBusArgInfo **) &_gdm_dbus_greeter_signal_info_default_language_name_changed_ARG_pointers,
    NULL
  },
  "default-language-name-changed"
};

static const _ExtendedGDBusArgInfo _gdm_dbus_greeter_signal_info_default_session_name_changed_ARG_session_name =
{
  {
    -1,
    (gchar *) "session_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_greeter_signal_info_default_session_name_changed_ARG_pointers[] =
{
  &_gdm_dbus_greeter_signal_info_default_session_name_changed_ARG_session_name.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_dbus_greeter_signal_info_default_session_name_changed =
{
  {
    -1,
    (gchar *) "DefaultSessionNameChanged",
    (GDBusArgInfo **) &_gdm_dbus_greeter_signal_info_default_session_name_changed_ARG_pointers,
    NULL
  },
  "default-session-name-changed"
};

static const _ExtendedGDBusArgInfo _gdm_dbus_greeter_signal_info_timed_login_requested_ARG_username =
{
  {
    -1,
    (gchar *) "username",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_greeter_signal_info_timed_login_requested_ARG_delay =
{
  {
    -1,
    (gchar *) "delay",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_greeter_signal_info_timed_login_requested_ARG_pointers[] =
{
  &_gdm_dbus_greeter_signal_info_timed_login_requested_ARG_username.parent_struct,
  &_gdm_dbus_greeter_signal_info_timed_login_requested_ARG_delay.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_dbus_greeter_signal_info_timed_login_requested =
{
  {
    -1,
    (gchar *) "TimedLoginRequested",
    (GDBusArgInfo **) &_gdm_dbus_greeter_signal_info_timed_login_requested_ARG_pointers,
    NULL
  },
  "timed-login-requested"
};

static const _ExtendedGDBusArgInfo _gdm_dbus_greeter_signal_info_session_opened_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdm_dbus_greeter_signal_info_session_opened_ARG_session_id =
{
  {
    -1,
    (gchar *) "session_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_greeter_signal_info_session_opened_ARG_pointers[] =
{
  &_gdm_dbus_greeter_signal_info_session_opened_ARG_service_name.parent_struct,
  &_gdm_dbus_greeter_signal_info_session_opened_ARG_session_id.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_dbus_greeter_signal_info_session_opened =
{
  {
    -1,
    (gchar *) "SessionOpened",
    (GDBusArgInfo **) &_gdm_dbus_greeter_signal_info_session_opened_ARG_pointers,
    NULL
  },
  "session-opened"
};

static const _ExtendedGDBusArgInfo _gdm_dbus_greeter_signal_info_reauthenticated_ARG_service_name =
{
  {
    -1,
    (gchar *) "service_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_greeter_signal_info_reauthenticated_ARG_pointers[] =
{
  &_gdm_dbus_greeter_signal_info_reauthenticated_ARG_service_name.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdm_dbus_greeter_signal_info_reauthenticated =
{
  {
    -1,
    (gchar *) "Reauthenticated",
    (GDBusArgInfo **) &_gdm_dbus_greeter_signal_info_reauthenticated_ARG_pointers,
    NULL
  },
  "reauthenticated"
};

static const GDBusSignalInfo * const _gdm_dbus_greeter_signal_info_pointers[] =
{
  &_gdm_dbus_greeter_signal_info_selected_user_changed.parent_struct,
  &_gdm_dbus_greeter_signal_info_default_language_name_changed.parent_struct,
  &_gdm_dbus_greeter_signal_info_default_session_name_changed.parent_struct,
  &_gdm_dbus_greeter_signal_info_timed_login_requested.parent_struct,
  &_gdm_dbus_greeter_signal_info_session_opened.parent_struct,
  &_gdm_dbus_greeter_signal_info_reauthenticated.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _gdm_dbus_greeter_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.DisplayManager.Greeter",
    (GDBusMethodInfo **) &_gdm_dbus_greeter_method_info_pointers,
    (GDBusSignalInfo **) &_gdm_dbus_greeter_signal_info_pointers,
    NULL,
    NULL
  },
  "greeter",
};


/**
 * gdm_dbus_greeter_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-DisplayManager-Greeter.top_of_page">org.gnome.DisplayManager.Greeter</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
gdm_dbus_greeter_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_gdm_dbus_greeter_interface_info.parent_struct;
}

/**
 * gdm_dbus_greeter_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GdmDBusGreeter interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
gdm_dbus_greeter_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
gdm_dbus_greeter_signal_marshal_selected_user_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_greeter_signal_marshal_default_language_name_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_greeter_signal_marshal_default_session_name_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_greeter_signal_marshal_timed_login_requested (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_greeter_signal_marshal_session_opened (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_greeter_signal_marshal_reauthenticated (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_greeter_method_marshal_select_session (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_greeter_method_marshal_select_user (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_greeter_method_marshal_begin_auto_login (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_greeter_method_marshal_get_timed_login_details (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_greeter_method_marshal_start_session_when_ready (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_greeter_method_marshal_stop_conflicting_session (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * GdmDBusGreeter:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-Greeter.top_of_page">org.gnome.DisplayManager.Greeter</link>.
 */

/**
 * GdmDBusGreeterIface:
 * @parent_iface: The parent interface.
 * @handle_begin_auto_login: Handler for the #GdmDBusGreeter::handle-begin-auto-login signal.
 * @handle_get_timed_login_details: Handler for the #GdmDBusGreeter::handle-get-timed-login-details signal.
 * @handle_select_session: Handler for the #GdmDBusGreeter::handle-select-session signal.
 * @handle_select_user: Handler for the #GdmDBusGreeter::handle-select-user signal.
 * @handle_start_session_when_ready: Handler for the #GdmDBusGreeter::handle-start-session-when-ready signal.
 * @handle_stop_conflicting_session: Handler for the #GdmDBusGreeter::handle-stop-conflicting-session signal.
 * @default_language_name_changed: Handler for the #GdmDBusGreeter::default-language-name-changed signal.
 * @default_session_name_changed: Handler for the #GdmDBusGreeter::default-session-name-changed signal.
 * @reauthenticated: Handler for the #GdmDBusGreeter::reauthenticated signal.
 * @selected_user_changed: Handler for the #GdmDBusGreeter::selected-user-changed signal.
 * @session_opened: Handler for the #GdmDBusGreeter::session-opened signal.
 * @timed_login_requested: Handler for the #GdmDBusGreeter::timed-login-requested signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-Greeter.top_of_page">org.gnome.DisplayManager.Greeter</link>.
 */

typedef GdmDBusGreeterIface GdmDBusGreeterInterface;
G_DEFINE_INTERFACE (GdmDBusGreeter, gdm_dbus_greeter, G_TYPE_OBJECT)

static void
gdm_dbus_greeter_default_init (GdmDBusGreeterIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * GdmDBusGreeter::handle-select-session:
   * @object: A #GdmDBusGreeter.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.SelectSession">SelectSession()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_greeter_complete_select_session() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-select-session",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusGreeterIface, handle_select_session),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_greeter_method_marshal_select_session,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * GdmDBusGreeter::handle-select-user:
   * @object: A #GdmDBusGreeter.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_username: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.SelectUser">SelectUser()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_greeter_complete_select_user() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-select-user",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusGreeterIface, handle_select_user),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_greeter_method_marshal_select_user,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * GdmDBusGreeter::handle-begin-auto-login:
   * @object: A #GdmDBusGreeter.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_username: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.BeginAutoLogin">BeginAutoLogin()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_greeter_complete_begin_auto_login() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-begin-auto-login",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusGreeterIface, handle_begin_auto_login),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_greeter_method_marshal_begin_auto_login,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * GdmDBusGreeter::handle-get-timed-login-details:
   * @object: A #GdmDBusGreeter.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.GetTimedLoginDetails">GetTimedLoginDetails()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_greeter_complete_get_timed_login_details() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-timed-login-details",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusGreeterIface, handle_get_timed_login_details),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_greeter_method_marshal_get_timed_login_details,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GdmDBusGreeter::handle-start-session-when-ready:
   * @object: A #GdmDBusGreeter.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_service_name: Argument passed by remote caller.
   * @arg_should_start_session: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.StartSessionWhenReady">StartSessionWhenReady()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_greeter_complete_start_session_when_ready() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-start-session-when-ready",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusGreeterIface, handle_start_session_when_ready),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_greeter_method_marshal_start_session_when_ready,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_BOOLEAN);

  /**
   * GdmDBusGreeter::handle-stop-conflicting-session:
   * @object: A #GdmDBusGreeter.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.StopConflictingSession">StopConflictingSession()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_greeter_complete_stop_conflicting_session() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-stop-conflicting-session",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusGreeterIface, handle_stop_conflicting_session),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_greeter_method_marshal_stop_conflicting_session,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * GdmDBusGreeter::selected-user-changed:
   * @object: A #GdmDBusGreeter.
   * @arg_username: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-Greeter.SelectedUserChanged">"SelectedUserChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM_DBUS__GREETER_SIGNALS[GDM_DBUS__GREETER_SELECTED_USER_CHANGED] =
    g_signal_new ("selected-user-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmDBusGreeterIface, selected_user_changed),
      NULL,
      NULL,
      gdm_dbus_greeter_signal_marshal_selected_user_changed,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * GdmDBusGreeter::default-language-name-changed:
   * @object: A #GdmDBusGreeter.
   * @arg_language_name: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-Greeter.DefaultLanguageNameChanged">"DefaultLanguageNameChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM_DBUS__GREETER_SIGNALS[GDM_DBUS__GREETER_DEFAULT_LANGUAGE_NAME_CHANGED] =
    g_signal_new ("default-language-name-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmDBusGreeterIface, default_language_name_changed),
      NULL,
      NULL,
      gdm_dbus_greeter_signal_marshal_default_language_name_changed,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * GdmDBusGreeter::default-session-name-changed:
   * @object: A #GdmDBusGreeter.
   * @arg_session_name: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-Greeter.DefaultSessionNameChanged">"DefaultSessionNameChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM_DBUS__GREETER_SIGNALS[GDM_DBUS__GREETER_DEFAULT_SESSION_NAME_CHANGED] =
    g_signal_new ("default-session-name-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmDBusGreeterIface, default_session_name_changed),
      NULL,
      NULL,
      gdm_dbus_greeter_signal_marshal_default_session_name_changed,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * GdmDBusGreeter::timed-login-requested:
   * @object: A #GdmDBusGreeter.
   * @arg_username: Argument.
   * @arg_delay: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-Greeter.TimedLoginRequested">"TimedLoginRequested"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM_DBUS__GREETER_SIGNALS[GDM_DBUS__GREETER_TIMED_LOGIN_REQUESTED] =
    g_signal_new ("timed-login-requested",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmDBusGreeterIface, timed_login_requested),
      NULL,
      NULL,
      gdm_dbus_greeter_signal_marshal_timed_login_requested,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_INT);

  /**
   * GdmDBusGreeter::session-opened:
   * @object: A #GdmDBusGreeter.
   * @arg_service_name: Argument.
   * @arg_session_id: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-Greeter.SessionOpened">"SessionOpened"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM_DBUS__GREETER_SIGNALS[GDM_DBUS__GREETER_SESSION_OPENED] =
    g_signal_new ("session-opened",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmDBusGreeterIface, session_opened),
      NULL,
      NULL,
      gdm_dbus_greeter_signal_marshal_session_opened,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * GdmDBusGreeter::reauthenticated:
   * @object: A #GdmDBusGreeter.
   * @arg_service_name: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-DisplayManager-Greeter.Reauthenticated">"Reauthenticated"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDM_DBUS__GREETER_SIGNALS[GDM_DBUS__GREETER_REAUTHENTICATED] =
    g_signal_new ("reauthenticated",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GdmDBusGreeterIface, reauthenticated),
      NULL,
      NULL,
      gdm_dbus_greeter_signal_marshal_reauthenticated,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

}

/**
 * gdm_dbus_greeter_emit_selected_user_changed:
 * @object: A #GdmDBusGreeter.
 * @arg_username: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-Greeter.SelectedUserChanged">"SelectedUserChanged"</link> D-Bus signal.
 */
void
gdm_dbus_greeter_emit_selected_user_changed (
    GdmDBusGreeter *object,
    const gchar *arg_username)
{
  g_signal_emit (object, GDM_DBUS__GREETER_SIGNALS[GDM_DBUS__GREETER_SELECTED_USER_CHANGED], 0, arg_username);
}

/**
 * gdm_dbus_greeter_emit_default_language_name_changed:
 * @object: A #GdmDBusGreeter.
 * @arg_language_name: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-Greeter.DefaultLanguageNameChanged">"DefaultLanguageNameChanged"</link> D-Bus signal.
 */
void
gdm_dbus_greeter_emit_default_language_name_changed (
    GdmDBusGreeter *object,
    const gchar *arg_language_name)
{
  g_signal_emit (object, GDM_DBUS__GREETER_SIGNALS[GDM_DBUS__GREETER_DEFAULT_LANGUAGE_NAME_CHANGED], 0, arg_language_name);
}

/**
 * gdm_dbus_greeter_emit_default_session_name_changed:
 * @object: A #GdmDBusGreeter.
 * @arg_session_name: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-Greeter.DefaultSessionNameChanged">"DefaultSessionNameChanged"</link> D-Bus signal.
 */
void
gdm_dbus_greeter_emit_default_session_name_changed (
    GdmDBusGreeter *object,
    const gchar *arg_session_name)
{
  g_signal_emit (object, GDM_DBUS__GREETER_SIGNALS[GDM_DBUS__GREETER_DEFAULT_SESSION_NAME_CHANGED], 0, arg_session_name);
}

/**
 * gdm_dbus_greeter_emit_timed_login_requested:
 * @object: A #GdmDBusGreeter.
 * @arg_username: Argument to pass with the signal.
 * @arg_delay: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-Greeter.TimedLoginRequested">"TimedLoginRequested"</link> D-Bus signal.
 */
void
gdm_dbus_greeter_emit_timed_login_requested (
    GdmDBusGreeter *object,
    const gchar *arg_username,
    gint arg_delay)
{
  g_signal_emit (object, GDM_DBUS__GREETER_SIGNALS[GDM_DBUS__GREETER_TIMED_LOGIN_REQUESTED], 0, arg_username, arg_delay);
}

/**
 * gdm_dbus_greeter_emit_session_opened:
 * @object: A #GdmDBusGreeter.
 * @arg_service_name: Argument to pass with the signal.
 * @arg_session_id: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-Greeter.SessionOpened">"SessionOpened"</link> D-Bus signal.
 */
void
gdm_dbus_greeter_emit_session_opened (
    GdmDBusGreeter *object,
    const gchar *arg_service_name,
    const gchar *arg_session_id)
{
  g_signal_emit (object, GDM_DBUS__GREETER_SIGNALS[GDM_DBUS__GREETER_SESSION_OPENED], 0, arg_service_name, arg_session_id);
}

/**
 * gdm_dbus_greeter_emit_reauthenticated:
 * @object: A #GdmDBusGreeter.
 * @arg_service_name: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-DisplayManager-Greeter.Reauthenticated">"Reauthenticated"</link> D-Bus signal.
 */
void
gdm_dbus_greeter_emit_reauthenticated (
    GdmDBusGreeter *object,
    const gchar *arg_service_name)
{
  g_signal_emit (object, GDM_DBUS__GREETER_SIGNALS[GDM_DBUS__GREETER_REAUTHENTICATED], 0, arg_service_name);
}

/**
 * gdm_dbus_greeter_call_select_session:
 * @proxy: A #GdmDBusGreeterProxy.
 * @arg_session: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.SelectSession">SelectSession()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_greeter_call_select_session_finish() to get the result of the operation.
 *
 * See gdm_dbus_greeter_call_select_session_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_greeter_call_select_session (
    GdmDBusGreeter *proxy,
    const gchar *arg_session,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SelectSession",
    g_variant_new ("(s)",
                   arg_session),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_greeter_call_select_session_finish:
 * @proxy: A #GdmDBusGreeterProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_greeter_call_select_session().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_greeter_call_select_session().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_greeter_call_select_session_finish (
    GdmDBusGreeter *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_greeter_call_select_session_sync:
 * @proxy: A #GdmDBusGreeterProxy.
 * @arg_session: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.SelectSession">SelectSession()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_greeter_call_select_session() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_greeter_call_select_session_sync (
    GdmDBusGreeter *proxy,
    const gchar *arg_session,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SelectSession",
    g_variant_new ("(s)",
                   arg_session),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_greeter_call_select_user:
 * @proxy: A #GdmDBusGreeterProxy.
 * @arg_username: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.SelectUser">SelectUser()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_greeter_call_select_user_finish() to get the result of the operation.
 *
 * See gdm_dbus_greeter_call_select_user_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_greeter_call_select_user (
    GdmDBusGreeter *proxy,
    const gchar *arg_username,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SelectUser",
    g_variant_new ("(s)",
                   arg_username),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_greeter_call_select_user_finish:
 * @proxy: A #GdmDBusGreeterProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_greeter_call_select_user().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_greeter_call_select_user().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_greeter_call_select_user_finish (
    GdmDBusGreeter *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_greeter_call_select_user_sync:
 * @proxy: A #GdmDBusGreeterProxy.
 * @arg_username: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.SelectUser">SelectUser()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_greeter_call_select_user() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_greeter_call_select_user_sync (
    GdmDBusGreeter *proxy,
    const gchar *arg_username,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SelectUser",
    g_variant_new ("(s)",
                   arg_username),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_greeter_call_begin_auto_login:
 * @proxy: A #GdmDBusGreeterProxy.
 * @arg_username: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.BeginAutoLogin">BeginAutoLogin()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_greeter_call_begin_auto_login_finish() to get the result of the operation.
 *
 * See gdm_dbus_greeter_call_begin_auto_login_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_greeter_call_begin_auto_login (
    GdmDBusGreeter *proxy,
    const gchar *arg_username,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "BeginAutoLogin",
    g_variant_new ("(s)",
                   arg_username),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_greeter_call_begin_auto_login_finish:
 * @proxy: A #GdmDBusGreeterProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_greeter_call_begin_auto_login().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_greeter_call_begin_auto_login().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_greeter_call_begin_auto_login_finish (
    GdmDBusGreeter *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_greeter_call_begin_auto_login_sync:
 * @proxy: A #GdmDBusGreeterProxy.
 * @arg_username: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.BeginAutoLogin">BeginAutoLogin()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_greeter_call_begin_auto_login() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_greeter_call_begin_auto_login_sync (
    GdmDBusGreeter *proxy,
    const gchar *arg_username,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "BeginAutoLogin",
    g_variant_new ("(s)",
                   arg_username),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_greeter_call_get_timed_login_details:
 * @proxy: A #GdmDBusGreeterProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.GetTimedLoginDetails">GetTimedLoginDetails()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_greeter_call_get_timed_login_details_finish() to get the result of the operation.
 *
 * See gdm_dbus_greeter_call_get_timed_login_details_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_greeter_call_get_timed_login_details (
    GdmDBusGreeter *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetTimedLoginDetails",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_greeter_call_get_timed_login_details_finish:
 * @proxy: A #GdmDBusGreeterProxy.
 * @out_enabled: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_username: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_delay: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_greeter_call_get_timed_login_details().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_greeter_call_get_timed_login_details().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_greeter_call_get_timed_login_details_finish (
    GdmDBusGreeter *proxy,
    gboolean *out_enabled,
    gchar **out_username,
    gint *out_delay,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(bsi)",
                 out_enabled,
                 out_username,
                 out_delay);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_greeter_call_get_timed_login_details_sync:
 * @proxy: A #GdmDBusGreeterProxy.
 * @out_enabled: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_username: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_delay: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.GetTimedLoginDetails">GetTimedLoginDetails()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_greeter_call_get_timed_login_details() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_greeter_call_get_timed_login_details_sync (
    GdmDBusGreeter *proxy,
    gboolean *out_enabled,
    gchar **out_username,
    gint *out_delay,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetTimedLoginDetails",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(bsi)",
                 out_enabled,
                 out_username,
                 out_delay);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_greeter_call_start_session_when_ready:
 * @proxy: A #GdmDBusGreeterProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_should_start_session: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.StartSessionWhenReady">StartSessionWhenReady()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_greeter_call_start_session_when_ready_finish() to get the result of the operation.
 *
 * See gdm_dbus_greeter_call_start_session_when_ready_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_greeter_call_start_session_when_ready (
    GdmDBusGreeter *proxy,
    const gchar *arg_service_name,
    gboolean arg_should_start_session,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "StartSessionWhenReady",
    g_variant_new ("(sb)",
                   arg_service_name,
                   arg_should_start_session),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_greeter_call_start_session_when_ready_finish:
 * @proxy: A #GdmDBusGreeterProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_greeter_call_start_session_when_ready().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_greeter_call_start_session_when_ready().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_greeter_call_start_session_when_ready_finish (
    GdmDBusGreeter *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_greeter_call_start_session_when_ready_sync:
 * @proxy: A #GdmDBusGreeterProxy.
 * @arg_service_name: Argument to pass with the method invocation.
 * @arg_should_start_session: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.StartSessionWhenReady">StartSessionWhenReady()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_greeter_call_start_session_when_ready() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_greeter_call_start_session_when_ready_sync (
    GdmDBusGreeter *proxy,
    const gchar *arg_service_name,
    gboolean arg_should_start_session,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "StartSessionWhenReady",
    g_variant_new ("(sb)",
                   arg_service_name,
                   arg_should_start_session),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_greeter_call_stop_conflicting_session:
 * @proxy: A #GdmDBusGreeterProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.StopConflictingSession">StopConflictingSession()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_greeter_call_stop_conflicting_session_finish() to get the result of the operation.
 *
 * See gdm_dbus_greeter_call_stop_conflicting_session_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_greeter_call_stop_conflicting_session (
    GdmDBusGreeter *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "StopConflictingSession",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_greeter_call_stop_conflicting_session_finish:
 * @proxy: A #GdmDBusGreeterProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_greeter_call_stop_conflicting_session().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_greeter_call_stop_conflicting_session().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_greeter_call_stop_conflicting_session_finish (
    GdmDBusGreeter *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_greeter_call_stop_conflicting_session_sync:
 * @proxy: A #GdmDBusGreeterProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.StopConflictingSession">StopConflictingSession()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_greeter_call_stop_conflicting_session() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_greeter_call_stop_conflicting_session_sync (
    GdmDBusGreeter *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "StopConflictingSession",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_greeter_complete_select_session:
 * @object: A #GdmDBusGreeter.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.SelectSession">SelectSession()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_greeter_complete_select_session (
    GdmDBusGreeter *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdm_dbus_greeter_complete_select_user:
 * @object: A #GdmDBusGreeter.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.SelectUser">SelectUser()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_greeter_complete_select_user (
    GdmDBusGreeter *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdm_dbus_greeter_complete_begin_auto_login:
 * @object: A #GdmDBusGreeter.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.BeginAutoLogin">BeginAutoLogin()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_greeter_complete_begin_auto_login (
    GdmDBusGreeter *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdm_dbus_greeter_complete_get_timed_login_details:
 * @object: A #GdmDBusGreeter.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @enabled: Parameter to return.
 * @username: Parameter to return.
 * @delay: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.GetTimedLoginDetails">GetTimedLoginDetails()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_greeter_complete_get_timed_login_details (
    GdmDBusGreeter *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean enabled,
    const gchar *username,
    gint delay)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(bsi)",
                   enabled,
                   username,
                   delay));
}

/**
 * gdm_dbus_greeter_complete_start_session_when_ready:
 * @object: A #GdmDBusGreeter.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.StartSessionWhenReady">StartSessionWhenReady()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_greeter_complete_start_session_when_ready (
    GdmDBusGreeter *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdm_dbus_greeter_complete_stop_conflicting_session:
 * @object: A #GdmDBusGreeter.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-Greeter.StopConflictingSession">StopConflictingSession()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_greeter_complete_stop_conflicting_session (
    GdmDBusGreeter *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * GdmDBusGreeterProxy:
 *
 * The #GdmDBusGreeterProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GdmDBusGreeterProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GdmDBusGreeterProxy.
 */

struct _GdmDBusGreeterProxyPrivate
{
  GData *qdata;
};

static void gdm_dbus_greeter_proxy_iface_init (GdmDBusGreeterIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GdmDBusGreeterProxy, gdm_dbus_greeter_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GdmDBusGreeterProxy)
                         G_IMPLEMENT_INTERFACE (GDM_DBUS_TYPE_GREETER, gdm_dbus_greeter_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GdmDBusGreeterProxy, gdm_dbus_greeter_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GDM_DBUS_TYPE_GREETER, gdm_dbus_greeter_proxy_iface_init))

#endif
static void
gdm_dbus_greeter_proxy_finalize (GObject *object)
{
  GdmDBusGreeterProxy *proxy = GDM_DBUS_GREETER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (gdm_dbus_greeter_proxy_parent_class)->finalize (object);
}

static void
gdm_dbus_greeter_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gdm_dbus_greeter_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gdm_dbus_greeter_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_gdm_dbus_greeter_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GDM_DBUS_TYPE_GREETER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GDM_DBUS_TYPE_GREETER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
gdm_dbus_greeter_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GdmDBusGreeterProxy *proxy = GDM_DBUS_GREETER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_dbus_greeter_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_dbus_greeter_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
gdm_dbus_greeter_proxy_init (GdmDBusGreeterProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = gdm_dbus_greeter_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GDM_DBUS_TYPE_GREETER_PROXY, GdmDBusGreeterProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), gdm_dbus_greeter_interface_info ());
}

static void
gdm_dbus_greeter_proxy_class_init (GdmDBusGreeterProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = gdm_dbus_greeter_proxy_finalize;
  gobject_class->get_property = gdm_dbus_greeter_proxy_get_property;
  gobject_class->set_property = gdm_dbus_greeter_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = gdm_dbus_greeter_proxy_g_signal;
  proxy_class->g_properties_changed = gdm_dbus_greeter_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GdmDBusGreeterProxyPrivate));
#endif
}

static void
gdm_dbus_greeter_proxy_iface_init (GdmDBusGreeterIface *iface G_GNUC_UNUSED)
{
}

/**
 * gdm_dbus_greeter_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-Greeter.top_of_page">org.gnome.DisplayManager.Greeter</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_greeter_proxy_new_finish() to get the result of the operation.
 *
 * See gdm_dbus_greeter_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
gdm_dbus_greeter_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GDM_DBUS_TYPE_GREETER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.Greeter", NULL);
}

/**
 * gdm_dbus_greeter_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_greeter_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gdm_dbus_greeter_proxy_new().
 *
 * Returns: (transfer full) (type GdmDBusGreeterProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmDBusGreeter *
gdm_dbus_greeter_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GDM_DBUS_GREETER (ret);
  else
    return NULL;
}

/**
 * gdm_dbus_greeter_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-Greeter.top_of_page">org.gnome.DisplayManager.Greeter</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_greeter_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GdmDBusGreeterProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmDBusGreeter *
gdm_dbus_greeter_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GDM_DBUS_TYPE_GREETER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.Greeter", NULL);
  if (ret != NULL)
    return GDM_DBUS_GREETER (ret);
  else
    return NULL;
}


/**
 * gdm_dbus_greeter_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like gdm_dbus_greeter_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_greeter_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See gdm_dbus_greeter_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
gdm_dbus_greeter_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GDM_DBUS_TYPE_GREETER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.Greeter", NULL);
}

/**
 * gdm_dbus_greeter_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_greeter_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gdm_dbus_greeter_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GdmDBusGreeterProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmDBusGreeter *
gdm_dbus_greeter_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GDM_DBUS_GREETER (ret);
  else
    return NULL;
}

/**
 * gdm_dbus_greeter_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like gdm_dbus_greeter_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_greeter_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GdmDBusGreeterProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmDBusGreeter *
gdm_dbus_greeter_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GDM_DBUS_TYPE_GREETER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.Greeter", NULL);
  if (ret != NULL)
    return GDM_DBUS_GREETER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GdmDBusGreeterSkeleton:
 *
 * The #GdmDBusGreeterSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GdmDBusGreeterSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GdmDBusGreeterSkeleton.
 */

struct _GdmDBusGreeterSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_gdm_dbus_greeter_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GdmDBusGreeterSkeleton *skeleton = GDM_DBUS_GREETER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GDM_DBUS_TYPE_GREETER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GDM_DBUS_TYPE_GREETER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_gdm_dbus_greeter_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GdmDBusGreeterSkeleton *skeleton = GDM_DBUS_GREETER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_dbus_greeter_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_gdm_dbus_greeter_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GdmDBusGreeterSkeleton *skeleton = GDM_DBUS_GREETER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_dbus_greeter_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _gdm_dbus_greeter_skeleton_vtable =
{
  _gdm_dbus_greeter_skeleton_handle_method_call,
  _gdm_dbus_greeter_skeleton_handle_get_property,
  _gdm_dbus_greeter_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
gdm_dbus_greeter_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return gdm_dbus_greeter_interface_info ();
}

static GDBusInterfaceVTable *
gdm_dbus_greeter_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_gdm_dbus_greeter_skeleton_vtable;
}

static GVariant *
gdm_dbus_greeter_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GdmDBusGreeterSkeleton *skeleton = GDM_DBUS_GREETER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_gdm_dbus_greeter_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _gdm_dbus_greeter_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _gdm_dbus_greeter_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _gdm_dbus_greeter_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.Greeter", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
gdm_dbus_greeter_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_gdm_dbus_greeter_on_signal_selected_user_changed (
    GdmDBusGreeter *object,
    const gchar *arg_username)
{
  GdmDBusGreeterSkeleton *skeleton = GDM_DBUS_GREETER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_username));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.Greeter", "SelectedUserChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_dbus_greeter_on_signal_default_language_name_changed (
    GdmDBusGreeter *object,
    const gchar *arg_language_name)
{
  GdmDBusGreeterSkeleton *skeleton = GDM_DBUS_GREETER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_language_name));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.Greeter", "DefaultLanguageNameChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_dbus_greeter_on_signal_default_session_name_changed (
    GdmDBusGreeter *object,
    const gchar *arg_session_name)
{
  GdmDBusGreeterSkeleton *skeleton = GDM_DBUS_GREETER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_session_name));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.Greeter", "DefaultSessionNameChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_dbus_greeter_on_signal_timed_login_requested (
    GdmDBusGreeter *object,
    const gchar *arg_username,
    gint arg_delay)
{
  GdmDBusGreeterSkeleton *skeleton = GDM_DBUS_GREETER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(si)",
                   arg_username,
                   arg_delay));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.Greeter", "TimedLoginRequested",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_dbus_greeter_on_signal_session_opened (
    GdmDBusGreeter *object,
    const gchar *arg_service_name,
    const gchar *arg_session_id)
{
  GdmDBusGreeterSkeleton *skeleton = GDM_DBUS_GREETER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(ss)",
                   arg_service_name,
                   arg_session_id));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.Greeter", "SessionOpened",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdm_dbus_greeter_on_signal_reauthenticated (
    GdmDBusGreeter *object,
    const gchar *arg_service_name)
{
  GdmDBusGreeterSkeleton *skeleton = GDM_DBUS_GREETER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_service_name));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.Greeter", "Reauthenticated",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void gdm_dbus_greeter_skeleton_iface_init (GdmDBusGreeterIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GdmDBusGreeterSkeleton, gdm_dbus_greeter_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GdmDBusGreeterSkeleton)
                         G_IMPLEMENT_INTERFACE (GDM_DBUS_TYPE_GREETER, gdm_dbus_greeter_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GdmDBusGreeterSkeleton, gdm_dbus_greeter_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GDM_DBUS_TYPE_GREETER, gdm_dbus_greeter_skeleton_iface_init))

#endif
static void
gdm_dbus_greeter_skeleton_finalize (GObject *object)
{
  GdmDBusGreeterSkeleton *skeleton = GDM_DBUS_GREETER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (gdm_dbus_greeter_skeleton_parent_class)->finalize (object);
}

static void
gdm_dbus_greeter_skeleton_init (GdmDBusGreeterSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = gdm_dbus_greeter_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GDM_DBUS_TYPE_GREETER_SKELETON, GdmDBusGreeterSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
gdm_dbus_greeter_skeleton_class_init (GdmDBusGreeterSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = gdm_dbus_greeter_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = gdm_dbus_greeter_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = gdm_dbus_greeter_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = gdm_dbus_greeter_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = gdm_dbus_greeter_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GdmDBusGreeterSkeletonPrivate));
#endif
}

static void
gdm_dbus_greeter_skeleton_iface_init (GdmDBusGreeterIface *iface)
{
  iface->selected_user_changed = _gdm_dbus_greeter_on_signal_selected_user_changed;
  iface->default_language_name_changed = _gdm_dbus_greeter_on_signal_default_language_name_changed;
  iface->default_session_name_changed = _gdm_dbus_greeter_on_signal_default_session_name_changed;
  iface->timed_login_requested = _gdm_dbus_greeter_on_signal_timed_login_requested;
  iface->session_opened = _gdm_dbus_greeter_on_signal_session_opened;
  iface->reauthenticated = _gdm_dbus_greeter_on_signal_reauthenticated;
}

/**
 * gdm_dbus_greeter_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-Greeter.top_of_page">org.gnome.DisplayManager.Greeter</link>.
 *
 * Returns: (transfer full) (type GdmDBusGreeterSkeleton): The skeleton object.
 */
GdmDBusGreeter *
gdm_dbus_greeter_skeleton_new (void)
{
  return GDM_DBUS_GREETER (g_object_new (GDM_DBUS_TYPE_GREETER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.DisplayManager.RemoteGreeter
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GdmDBusRemoteGreeter
 * @title: GdmDBusRemoteGreeter
 * @short_description: Generated C code for the org.gnome.DisplayManager.RemoteGreeter D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-DisplayManager-RemoteGreeter.top_of_page">org.gnome.DisplayManager.RemoteGreeter</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.DisplayManager.RemoteGreeter ---- */

static const _ExtendedGDBusMethodInfo _gdm_dbus_remote_greeter_method_info_disconnect =
{
  {
    -1,
    (gchar *) "Disconnect",
    NULL,
    NULL,
    NULL
  },
  "handle-disconnect",
  FALSE
};

static const GDBusMethodInfo * const _gdm_dbus_remote_greeter_method_info_pointers[] =
{
  &_gdm_dbus_remote_greeter_method_info_disconnect.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _gdm_dbus_remote_greeter_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.DisplayManager.RemoteGreeter",
    (GDBusMethodInfo **) &_gdm_dbus_remote_greeter_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "remote-greeter",
};


/**
 * gdm_dbus_remote_greeter_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-DisplayManager-RemoteGreeter.top_of_page">org.gnome.DisplayManager.RemoteGreeter</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
gdm_dbus_remote_greeter_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_gdm_dbus_remote_greeter_interface_info.parent_struct;
}

/**
 * gdm_dbus_remote_greeter_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GdmDBusRemoteGreeter interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
gdm_dbus_remote_greeter_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
gdm_dbus_remote_greeter_method_marshal_disconnect (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * GdmDBusRemoteGreeter:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-RemoteGreeter.top_of_page">org.gnome.DisplayManager.RemoteGreeter</link>.
 */

/**
 * GdmDBusRemoteGreeterIface:
 * @parent_iface: The parent interface.
 * @handle_disconnect: Handler for the #GdmDBusRemoteGreeter::handle-disconnect signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-RemoteGreeter.top_of_page">org.gnome.DisplayManager.RemoteGreeter</link>.
 */

typedef GdmDBusRemoteGreeterIface GdmDBusRemoteGreeterInterface;
G_DEFINE_INTERFACE (GdmDBusRemoteGreeter, gdm_dbus_remote_greeter, G_TYPE_OBJECT)

static void
gdm_dbus_remote_greeter_default_init (GdmDBusRemoteGreeterIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * GdmDBusRemoteGreeter::handle-disconnect:
   * @object: A #GdmDBusRemoteGreeter.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-RemoteGreeter.Disconnect">Disconnect()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_remote_greeter_complete_disconnect() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-disconnect",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusRemoteGreeterIface, handle_disconnect),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_remote_greeter_method_marshal_disconnect,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

}

/**
 * gdm_dbus_remote_greeter_call_disconnect:
 * @proxy: A #GdmDBusRemoteGreeterProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-RemoteGreeter.Disconnect">Disconnect()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_remote_greeter_call_disconnect_finish() to get the result of the operation.
 *
 * See gdm_dbus_remote_greeter_call_disconnect_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_remote_greeter_call_disconnect (
    GdmDBusRemoteGreeter *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Disconnect",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_remote_greeter_call_disconnect_finish:
 * @proxy: A #GdmDBusRemoteGreeterProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_remote_greeter_call_disconnect().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_remote_greeter_call_disconnect().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_remote_greeter_call_disconnect_finish (
    GdmDBusRemoteGreeter *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_remote_greeter_call_disconnect_sync:
 * @proxy: A #GdmDBusRemoteGreeterProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-RemoteGreeter.Disconnect">Disconnect()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_remote_greeter_call_disconnect() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_remote_greeter_call_disconnect_sync (
    GdmDBusRemoteGreeter *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Disconnect",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_remote_greeter_complete_disconnect:
 * @object: A #GdmDBusRemoteGreeter.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-RemoteGreeter.Disconnect">Disconnect()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_remote_greeter_complete_disconnect (
    GdmDBusRemoteGreeter *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * GdmDBusRemoteGreeterProxy:
 *
 * The #GdmDBusRemoteGreeterProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GdmDBusRemoteGreeterProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GdmDBusRemoteGreeterProxy.
 */

struct _GdmDBusRemoteGreeterProxyPrivate
{
  GData *qdata;
};

static void gdm_dbus_remote_greeter_proxy_iface_init (GdmDBusRemoteGreeterIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GdmDBusRemoteGreeterProxy, gdm_dbus_remote_greeter_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GdmDBusRemoteGreeterProxy)
                         G_IMPLEMENT_INTERFACE (GDM_DBUS_TYPE_REMOTE_GREETER, gdm_dbus_remote_greeter_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GdmDBusRemoteGreeterProxy, gdm_dbus_remote_greeter_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GDM_DBUS_TYPE_REMOTE_GREETER, gdm_dbus_remote_greeter_proxy_iface_init))

#endif
static void
gdm_dbus_remote_greeter_proxy_finalize (GObject *object)
{
  GdmDBusRemoteGreeterProxy *proxy = GDM_DBUS_REMOTE_GREETER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (gdm_dbus_remote_greeter_proxy_parent_class)->finalize (object);
}

static void
gdm_dbus_remote_greeter_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gdm_dbus_remote_greeter_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gdm_dbus_remote_greeter_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_gdm_dbus_remote_greeter_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GDM_DBUS_TYPE_REMOTE_GREETER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GDM_DBUS_TYPE_REMOTE_GREETER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
gdm_dbus_remote_greeter_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GdmDBusRemoteGreeterProxy *proxy = GDM_DBUS_REMOTE_GREETER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_dbus_remote_greeter_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_dbus_remote_greeter_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
gdm_dbus_remote_greeter_proxy_init (GdmDBusRemoteGreeterProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = gdm_dbus_remote_greeter_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GDM_DBUS_TYPE_REMOTE_GREETER_PROXY, GdmDBusRemoteGreeterProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), gdm_dbus_remote_greeter_interface_info ());
}

static void
gdm_dbus_remote_greeter_proxy_class_init (GdmDBusRemoteGreeterProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = gdm_dbus_remote_greeter_proxy_finalize;
  gobject_class->get_property = gdm_dbus_remote_greeter_proxy_get_property;
  gobject_class->set_property = gdm_dbus_remote_greeter_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = gdm_dbus_remote_greeter_proxy_g_signal;
  proxy_class->g_properties_changed = gdm_dbus_remote_greeter_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GdmDBusRemoteGreeterProxyPrivate));
#endif
}

static void
gdm_dbus_remote_greeter_proxy_iface_init (GdmDBusRemoteGreeterIface *iface G_GNUC_UNUSED)
{
}

/**
 * gdm_dbus_remote_greeter_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-RemoteGreeter.top_of_page">org.gnome.DisplayManager.RemoteGreeter</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_remote_greeter_proxy_new_finish() to get the result of the operation.
 *
 * See gdm_dbus_remote_greeter_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
gdm_dbus_remote_greeter_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GDM_DBUS_TYPE_REMOTE_GREETER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.RemoteGreeter", NULL);
}

/**
 * gdm_dbus_remote_greeter_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_remote_greeter_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gdm_dbus_remote_greeter_proxy_new().
 *
 * Returns: (transfer full) (type GdmDBusRemoteGreeterProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmDBusRemoteGreeter *
gdm_dbus_remote_greeter_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GDM_DBUS_REMOTE_GREETER (ret);
  else
    return NULL;
}

/**
 * gdm_dbus_remote_greeter_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-RemoteGreeter.top_of_page">org.gnome.DisplayManager.RemoteGreeter</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_remote_greeter_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GdmDBusRemoteGreeterProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmDBusRemoteGreeter *
gdm_dbus_remote_greeter_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GDM_DBUS_TYPE_REMOTE_GREETER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.RemoteGreeter", NULL);
  if (ret != NULL)
    return GDM_DBUS_REMOTE_GREETER (ret);
  else
    return NULL;
}


/**
 * gdm_dbus_remote_greeter_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like gdm_dbus_remote_greeter_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_remote_greeter_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See gdm_dbus_remote_greeter_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
gdm_dbus_remote_greeter_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GDM_DBUS_TYPE_REMOTE_GREETER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.RemoteGreeter", NULL);
}

/**
 * gdm_dbus_remote_greeter_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_remote_greeter_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gdm_dbus_remote_greeter_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GdmDBusRemoteGreeterProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmDBusRemoteGreeter *
gdm_dbus_remote_greeter_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GDM_DBUS_REMOTE_GREETER (ret);
  else
    return NULL;
}

/**
 * gdm_dbus_remote_greeter_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like gdm_dbus_remote_greeter_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_remote_greeter_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GdmDBusRemoteGreeterProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmDBusRemoteGreeter *
gdm_dbus_remote_greeter_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GDM_DBUS_TYPE_REMOTE_GREETER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.RemoteGreeter", NULL);
  if (ret != NULL)
    return GDM_DBUS_REMOTE_GREETER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GdmDBusRemoteGreeterSkeleton:
 *
 * The #GdmDBusRemoteGreeterSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GdmDBusRemoteGreeterSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GdmDBusRemoteGreeterSkeleton.
 */

struct _GdmDBusRemoteGreeterSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_gdm_dbus_remote_greeter_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GdmDBusRemoteGreeterSkeleton *skeleton = GDM_DBUS_REMOTE_GREETER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GDM_DBUS_TYPE_REMOTE_GREETER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GDM_DBUS_TYPE_REMOTE_GREETER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_gdm_dbus_remote_greeter_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GdmDBusRemoteGreeterSkeleton *skeleton = GDM_DBUS_REMOTE_GREETER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_dbus_remote_greeter_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_gdm_dbus_remote_greeter_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GdmDBusRemoteGreeterSkeleton *skeleton = GDM_DBUS_REMOTE_GREETER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_dbus_remote_greeter_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _gdm_dbus_remote_greeter_skeleton_vtable =
{
  _gdm_dbus_remote_greeter_skeleton_handle_method_call,
  _gdm_dbus_remote_greeter_skeleton_handle_get_property,
  _gdm_dbus_remote_greeter_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
gdm_dbus_remote_greeter_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return gdm_dbus_remote_greeter_interface_info ();
}

static GDBusInterfaceVTable *
gdm_dbus_remote_greeter_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_gdm_dbus_remote_greeter_skeleton_vtable;
}

static GVariant *
gdm_dbus_remote_greeter_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GdmDBusRemoteGreeterSkeleton *skeleton = GDM_DBUS_REMOTE_GREETER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_gdm_dbus_remote_greeter_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _gdm_dbus_remote_greeter_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _gdm_dbus_remote_greeter_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _gdm_dbus_remote_greeter_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.RemoteGreeter", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
gdm_dbus_remote_greeter_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void gdm_dbus_remote_greeter_skeleton_iface_init (GdmDBusRemoteGreeterIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GdmDBusRemoteGreeterSkeleton, gdm_dbus_remote_greeter_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GdmDBusRemoteGreeterSkeleton)
                         G_IMPLEMENT_INTERFACE (GDM_DBUS_TYPE_REMOTE_GREETER, gdm_dbus_remote_greeter_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GdmDBusRemoteGreeterSkeleton, gdm_dbus_remote_greeter_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GDM_DBUS_TYPE_REMOTE_GREETER, gdm_dbus_remote_greeter_skeleton_iface_init))

#endif
static void
gdm_dbus_remote_greeter_skeleton_finalize (GObject *object)
{
  GdmDBusRemoteGreeterSkeleton *skeleton = GDM_DBUS_REMOTE_GREETER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (gdm_dbus_remote_greeter_skeleton_parent_class)->finalize (object);
}

static void
gdm_dbus_remote_greeter_skeleton_init (GdmDBusRemoteGreeterSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = gdm_dbus_remote_greeter_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GDM_DBUS_TYPE_REMOTE_GREETER_SKELETON, GdmDBusRemoteGreeterSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
gdm_dbus_remote_greeter_skeleton_class_init (GdmDBusRemoteGreeterSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = gdm_dbus_remote_greeter_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = gdm_dbus_remote_greeter_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = gdm_dbus_remote_greeter_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = gdm_dbus_remote_greeter_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = gdm_dbus_remote_greeter_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GdmDBusRemoteGreeterSkeletonPrivate));
#endif
}

static void
gdm_dbus_remote_greeter_skeleton_iface_init (GdmDBusRemoteGreeterIface *iface G_GNUC_UNUSED)
{
}

/**
 * gdm_dbus_remote_greeter_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-RemoteGreeter.top_of_page">org.gnome.DisplayManager.RemoteGreeter</link>.
 *
 * Returns: (transfer full) (type GdmDBusRemoteGreeterSkeleton): The skeleton object.
 */
GdmDBusRemoteGreeter *
gdm_dbus_remote_greeter_skeleton_new (void)
{
  return GDM_DBUS_REMOTE_GREETER (g_object_new (GDM_DBUS_TYPE_REMOTE_GREETER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.DisplayManager.Chooser
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GdmDBusChooser
 * @title: GdmDBusChooser
 * @short_description: Generated C code for the org.gnome.DisplayManager.Chooser D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-DisplayManager-Chooser.top_of_page">org.gnome.DisplayManager.Chooser</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.DisplayManager.Chooser ---- */

static const _ExtendedGDBusArgInfo _gdm_dbus_chooser_method_info_select_hostname_IN_ARG_hostname =
{
  {
    -1,
    (gchar *) "hostname",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdm_dbus_chooser_method_info_select_hostname_IN_ARG_pointers[] =
{
  &_gdm_dbus_chooser_method_info_select_hostname_IN_ARG_hostname.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdm_dbus_chooser_method_info_select_hostname =
{
  {
    -1,
    (gchar *) "SelectHostname",
    (GDBusArgInfo **) &_gdm_dbus_chooser_method_info_select_hostname_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-select-hostname",
  FALSE
};

static const _ExtendedGDBusMethodInfo _gdm_dbus_chooser_method_info_disconnect =
{
  {
    -1,
    (gchar *) "Disconnect",
    NULL,
    NULL,
    NULL
  },
  "handle-disconnect",
  FALSE
};

static const GDBusMethodInfo * const _gdm_dbus_chooser_method_info_pointers[] =
{
  &_gdm_dbus_chooser_method_info_select_hostname.parent_struct,
  &_gdm_dbus_chooser_method_info_disconnect.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _gdm_dbus_chooser_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.DisplayManager.Chooser",
    (GDBusMethodInfo **) &_gdm_dbus_chooser_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "chooser",
};


/**
 * gdm_dbus_chooser_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-DisplayManager-Chooser.top_of_page">org.gnome.DisplayManager.Chooser</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
gdm_dbus_chooser_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_gdm_dbus_chooser_interface_info.parent_struct;
}

/**
 * gdm_dbus_chooser_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GdmDBusChooser interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
gdm_dbus_chooser_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
gdm_dbus_chooser_method_marshal_select_hostname (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdm_dbus_chooser_method_marshal_disconnect (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * GdmDBusChooser:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-Chooser.top_of_page">org.gnome.DisplayManager.Chooser</link>.
 */

/**
 * GdmDBusChooserIface:
 * @parent_iface: The parent interface.
 * @handle_disconnect: Handler for the #GdmDBusChooser::handle-disconnect signal.
 * @handle_select_hostname: Handler for the #GdmDBusChooser::handle-select-hostname signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-Chooser.top_of_page">org.gnome.DisplayManager.Chooser</link>.
 */

typedef GdmDBusChooserIface GdmDBusChooserInterface;
G_DEFINE_INTERFACE (GdmDBusChooser, gdm_dbus_chooser, G_TYPE_OBJECT)

static void
gdm_dbus_chooser_default_init (GdmDBusChooserIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * GdmDBusChooser::handle-select-hostname:
   * @object: A #GdmDBusChooser.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_hostname: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-Chooser.SelectHostname">SelectHostname()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_chooser_complete_select_hostname() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-select-hostname",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusChooserIface, handle_select_hostname),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_chooser_method_marshal_select_hostname,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * GdmDBusChooser::handle-disconnect:
   * @object: A #GdmDBusChooser.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-Chooser.Disconnect">Disconnect()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdm_dbus_chooser_complete_disconnect() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-disconnect",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GdmDBusChooserIface, handle_disconnect),
    g_signal_accumulator_true_handled,
    NULL,
      gdm_dbus_chooser_method_marshal_disconnect,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

}

/**
 * gdm_dbus_chooser_call_select_hostname:
 * @proxy: A #GdmDBusChooserProxy.
 * @arg_hostname: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Chooser.SelectHostname">SelectHostname()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_chooser_call_select_hostname_finish() to get the result of the operation.
 *
 * See gdm_dbus_chooser_call_select_hostname_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_chooser_call_select_hostname (
    GdmDBusChooser *proxy,
    const gchar *arg_hostname,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SelectHostname",
    g_variant_new ("(s)",
                   arg_hostname),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_chooser_call_select_hostname_finish:
 * @proxy: A #GdmDBusChooserProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_chooser_call_select_hostname().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_chooser_call_select_hostname().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_chooser_call_select_hostname_finish (
    GdmDBusChooser *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_chooser_call_select_hostname_sync:
 * @proxy: A #GdmDBusChooserProxy.
 * @arg_hostname: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Chooser.SelectHostname">SelectHostname()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_chooser_call_select_hostname() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_chooser_call_select_hostname_sync (
    GdmDBusChooser *proxy,
    const gchar *arg_hostname,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SelectHostname",
    g_variant_new ("(s)",
                   arg_hostname),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_chooser_call_disconnect:
 * @proxy: A #GdmDBusChooserProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Chooser.Disconnect">Disconnect()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_chooser_call_disconnect_finish() to get the result of the operation.
 *
 * See gdm_dbus_chooser_call_disconnect_sync() for the synchronous, blocking version of this method.
 */
void
gdm_dbus_chooser_call_disconnect (
    GdmDBusChooser *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Disconnect",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdm_dbus_chooser_call_disconnect_finish:
 * @proxy: A #GdmDBusChooserProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_chooser_call_disconnect().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdm_dbus_chooser_call_disconnect().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_chooser_call_disconnect_finish (
    GdmDBusChooser *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_chooser_call_disconnect_sync:
 * @proxy: A #GdmDBusChooserProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-Chooser.Disconnect">Disconnect()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_chooser_call_disconnect() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdm_dbus_chooser_call_disconnect_sync (
    GdmDBusChooser *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Disconnect",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdm_dbus_chooser_complete_select_hostname:
 * @object: A #GdmDBusChooser.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-Chooser.SelectHostname">SelectHostname()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_chooser_complete_select_hostname (
    GdmDBusChooser *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdm_dbus_chooser_complete_disconnect:
 * @object: A #GdmDBusChooser.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-Chooser.Disconnect">Disconnect()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdm_dbus_chooser_complete_disconnect (
    GdmDBusChooser *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * GdmDBusChooserProxy:
 *
 * The #GdmDBusChooserProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GdmDBusChooserProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GdmDBusChooserProxy.
 */

struct _GdmDBusChooserProxyPrivate
{
  GData *qdata;
};

static void gdm_dbus_chooser_proxy_iface_init (GdmDBusChooserIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GdmDBusChooserProxy, gdm_dbus_chooser_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GdmDBusChooserProxy)
                         G_IMPLEMENT_INTERFACE (GDM_DBUS_TYPE_CHOOSER, gdm_dbus_chooser_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GdmDBusChooserProxy, gdm_dbus_chooser_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GDM_DBUS_TYPE_CHOOSER, gdm_dbus_chooser_proxy_iface_init))

#endif
static void
gdm_dbus_chooser_proxy_finalize (GObject *object)
{
  GdmDBusChooserProxy *proxy = GDM_DBUS_CHOOSER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (gdm_dbus_chooser_proxy_parent_class)->finalize (object);
}

static void
gdm_dbus_chooser_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gdm_dbus_chooser_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gdm_dbus_chooser_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_gdm_dbus_chooser_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GDM_DBUS_TYPE_CHOOSER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GDM_DBUS_TYPE_CHOOSER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
gdm_dbus_chooser_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GdmDBusChooserProxy *proxy = GDM_DBUS_CHOOSER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_dbus_chooser_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_dbus_chooser_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
gdm_dbus_chooser_proxy_init (GdmDBusChooserProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = gdm_dbus_chooser_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GDM_DBUS_TYPE_CHOOSER_PROXY, GdmDBusChooserProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), gdm_dbus_chooser_interface_info ());
}

static void
gdm_dbus_chooser_proxy_class_init (GdmDBusChooserProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = gdm_dbus_chooser_proxy_finalize;
  gobject_class->get_property = gdm_dbus_chooser_proxy_get_property;
  gobject_class->set_property = gdm_dbus_chooser_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = gdm_dbus_chooser_proxy_g_signal;
  proxy_class->g_properties_changed = gdm_dbus_chooser_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GdmDBusChooserProxyPrivate));
#endif
}

static void
gdm_dbus_chooser_proxy_iface_init (GdmDBusChooserIface *iface G_GNUC_UNUSED)
{
}

/**
 * gdm_dbus_chooser_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-Chooser.top_of_page">org.gnome.DisplayManager.Chooser</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_chooser_proxy_new_finish() to get the result of the operation.
 *
 * See gdm_dbus_chooser_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
gdm_dbus_chooser_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GDM_DBUS_TYPE_CHOOSER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.Chooser", NULL);
}

/**
 * gdm_dbus_chooser_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_chooser_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gdm_dbus_chooser_proxy_new().
 *
 * Returns: (transfer full) (type GdmDBusChooserProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmDBusChooser *
gdm_dbus_chooser_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GDM_DBUS_CHOOSER (ret);
  else
    return NULL;
}

/**
 * gdm_dbus_chooser_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-Chooser.top_of_page">org.gnome.DisplayManager.Chooser</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_chooser_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GdmDBusChooserProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmDBusChooser *
gdm_dbus_chooser_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GDM_DBUS_TYPE_CHOOSER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.Chooser", NULL);
  if (ret != NULL)
    return GDM_DBUS_CHOOSER (ret);
  else
    return NULL;
}


/**
 * gdm_dbus_chooser_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like gdm_dbus_chooser_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdm_dbus_chooser_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See gdm_dbus_chooser_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
gdm_dbus_chooser_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GDM_DBUS_TYPE_CHOOSER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.Chooser", NULL);
}

/**
 * gdm_dbus_chooser_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdm_dbus_chooser_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gdm_dbus_chooser_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GdmDBusChooserProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmDBusChooser *
gdm_dbus_chooser_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GDM_DBUS_CHOOSER (ret);
  else
    return NULL;
}

/**
 * gdm_dbus_chooser_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like gdm_dbus_chooser_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gdm_dbus_chooser_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GdmDBusChooserProxy): The constructed proxy object or %NULL if @error is set.
 */
GdmDBusChooser *
gdm_dbus_chooser_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GDM_DBUS_TYPE_CHOOSER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.Chooser", NULL);
  if (ret != NULL)
    return GDM_DBUS_CHOOSER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GdmDBusChooserSkeleton:
 *
 * The #GdmDBusChooserSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GdmDBusChooserSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GdmDBusChooserSkeleton.
 */

struct _GdmDBusChooserSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_gdm_dbus_chooser_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GdmDBusChooserSkeleton *skeleton = GDM_DBUS_CHOOSER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GDM_DBUS_TYPE_CHOOSER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GDM_DBUS_TYPE_CHOOSER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_gdm_dbus_chooser_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GdmDBusChooserSkeleton *skeleton = GDM_DBUS_CHOOSER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_dbus_chooser_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_gdm_dbus_chooser_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GdmDBusChooserSkeleton *skeleton = GDM_DBUS_CHOOSER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdm_dbus_chooser_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _gdm_dbus_chooser_skeleton_vtable =
{
  _gdm_dbus_chooser_skeleton_handle_method_call,
  _gdm_dbus_chooser_skeleton_handle_get_property,
  _gdm_dbus_chooser_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
gdm_dbus_chooser_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return gdm_dbus_chooser_interface_info ();
}

static GDBusInterfaceVTable *
gdm_dbus_chooser_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_gdm_dbus_chooser_skeleton_vtable;
}

static GVariant *
gdm_dbus_chooser_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GdmDBusChooserSkeleton *skeleton = GDM_DBUS_CHOOSER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_gdm_dbus_chooser_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _gdm_dbus_chooser_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _gdm_dbus_chooser_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _gdm_dbus_chooser_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.Chooser", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
gdm_dbus_chooser_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void gdm_dbus_chooser_skeleton_iface_init (GdmDBusChooserIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GdmDBusChooserSkeleton, gdm_dbus_chooser_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GdmDBusChooserSkeleton)
                         G_IMPLEMENT_INTERFACE (GDM_DBUS_TYPE_CHOOSER, gdm_dbus_chooser_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GdmDBusChooserSkeleton, gdm_dbus_chooser_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GDM_DBUS_TYPE_CHOOSER, gdm_dbus_chooser_skeleton_iface_init))

#endif
static void
gdm_dbus_chooser_skeleton_finalize (GObject *object)
{
  GdmDBusChooserSkeleton *skeleton = GDM_DBUS_CHOOSER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (gdm_dbus_chooser_skeleton_parent_class)->finalize (object);
}

static void
gdm_dbus_chooser_skeleton_init (GdmDBusChooserSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = gdm_dbus_chooser_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GDM_DBUS_TYPE_CHOOSER_SKELETON, GdmDBusChooserSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
gdm_dbus_chooser_skeleton_class_init (GdmDBusChooserSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = gdm_dbus_chooser_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = gdm_dbus_chooser_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = gdm_dbus_chooser_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = gdm_dbus_chooser_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = gdm_dbus_chooser_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GdmDBusChooserSkeletonPrivate));
#endif
}

static void
gdm_dbus_chooser_skeleton_iface_init (GdmDBusChooserIface *iface G_GNUC_UNUSED)
{
}

/**
 * gdm_dbus_chooser_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-Chooser.top_of_page">org.gnome.DisplayManager.Chooser</link>.
 *
 * Returns: (transfer full) (type GdmDBusChooserSkeleton): The skeleton object.
 */
GdmDBusChooser *
gdm_dbus_chooser_skeleton_new (void)
{
  return GDM_DBUS_CHOOSER (g_object_new (GDM_DBUS_TYPE_CHOOSER_SKELETON, NULL));
}

