/* note-details.c generated by valac 0.56.18, the Vala compiler
 * generated from note-details.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2011 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include "folks/folks.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	FOLKS_NOTE_FIELD_DETAILS_0_PROPERTY,
	FOLKS_NOTE_FIELD_DETAILS_ID_PROPERTY,
	FOLKS_NOTE_FIELD_DETAILS_UID_PROPERTY,
	FOLKS_NOTE_FIELD_DETAILS_NUM_PROPERTIES
};
static GParamSpec* folks_note_field_details_properties[FOLKS_NOTE_FIELD_DETAILS_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FolksNoteDetailsChangeNotesData FolksNoteDetailsChangeNotesData;

struct _FolksNoteFieldDetailsPrivate {
	gchar* _id;
};

struct _FolksNoteDetailsChangeNotesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksNoteDetails* self;
	GeeSet* notes;
	GError* _tmp0_;
	GError* _inner_error0_;
};

static gint FolksNoteFieldDetails_private_offset;
static gpointer folks_note_field_details_parent_class = NULL;

static gboolean folks_note_field_details_real_equal (FolksAbstractFieldDetails* base,
                                              FolksAbstractFieldDetails* that);
static guint folks_note_field_details_real_hash (FolksAbstractFieldDetails* base);
static void folks_note_field_details_finalize (GObject * obj);
static GType folks_note_field_details_get_type_once (void);
static void _vala_folks_note_field_details_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_folks_note_field_details_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void folks_note_details_real_change_notes_data_free (gpointer _data);
static void folks_note_details_real_change_notes (FolksNoteDetails* self,
                                           GeeSet* notes,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static gboolean folks_note_details_real_change_notes_co (FolksNoteDetailsChangeNotesData* _data_);
static GType folks_note_details_get_type_once (void);

static inline gpointer
folks_note_field_details_get_instance_private (FolksNoteFieldDetails* self)
{
	return G_STRUCT_MEMBER_P (self, FolksNoteFieldDetails_private_offset);
}

/**
   * Create a new NoteFieldDetails.
   *
   * @param value the value of the field, which should be a non-empty free-form
   * UTF-8 string as entered by the user
   * @param parameters initial parameters. See
   * {@link AbstractFieldDetails.parameters}. A ``null`` value is equivalent to
   * a empty map of parameters.
   * @param uid UID for the note object itself, if known. A ``null`` value means
   * the note has no unique ID.
   *
   * @return a new NoteFieldDetails
   *
   * @since 0.6.0
   */
FolksNoteFieldDetails*
folks_note_field_details_construct (GType object_type,
                                    const gchar* value,
                                    GeeMultiMap* parameters,
                                    const gchar* uid)
{
	FolksNoteFieldDetails * self = NULL;
	g_return_val_if_fail (value != NULL, NULL);
	if (g_strcmp0 (value, "") == 0) {
		g_warning ("note-details.vala:78: Empty note passed to NoteFieldDetails.");
	}
	self = (FolksNoteFieldDetails*) g_object_new (object_type, "t-type", G_TYPE_STRING, "t-dup-func", (GBoxedCopyFunc) g_strdup, "t-destroy-func", (GDestroyNotify) g_free, "value", value, "id", uid, "parameters", parameters, NULL);
	return self;
}

FolksNoteFieldDetails*
folks_note_field_details_new (const gchar* value,
                              GeeMultiMap* parameters,
                              const gchar* uid)
{
	return folks_note_field_details_construct (FOLKS_TYPE_NOTE_FIELD_DETAILS, value, parameters, uid);
}

/**
   * {@inheritDoc}
   *
   * @since 0.6.0
   */
static gboolean
folks_note_field_details_real_equal (FolksAbstractFieldDetails* base,
                                     FolksAbstractFieldDetails* that)
{
	FolksNoteFieldDetails * self;
	gboolean result;
	self = (FolksNoteFieldDetails*) base;
	g_return_val_if_fail (that != NULL, FALSE);
	result = FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (folks_note_field_details_parent_class)->equal (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails), that);
	return result;
}

/**
   * {@inheritDoc}
   *
   * @since 0.6.0
   */
static guint
folks_note_field_details_real_hash (FolksAbstractFieldDetails* base)
{
	FolksNoteFieldDetails * self;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	guint result;
	self = (FolksNoteFieldDetails*) base;
	_tmp0_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = folks_abstract_field_details_get_id ((FolksAbstractFieldDetails*) self);
	_tmp3_ = _tmp2_;
	result = g_str_hash ((const gchar*) _tmp1_) + g_str_hash (_tmp3_);
	return result;
}

static const gchar*
folks_note_field_details_real_get_id (FolksAbstractFieldDetails* base)
{
	const gchar* result;
	FolksNoteFieldDetails* self;
	const gchar* _tmp0_;
	self = (FolksNoteFieldDetails*) base;
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}

static void
folks_note_field_details_real_set_id (FolksAbstractFieldDetails* base,
                                      const gchar* value)
{
	FolksNoteFieldDetails* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	self = (FolksNoteFieldDetails*) base;
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_id);
	self->priv->_id = _tmp1_;
	g_object_notify_by_pspec ((GObject *) self, folks_note_field_details_properties[FOLKS_NOTE_FIELD_DETAILS_ID_PROPERTY]);
}

const gchar*
folks_note_field_details_get_uid (FolksNoteFieldDetails* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = folks_abstract_field_details_get_id ((FolksAbstractFieldDetails*) self);
	_tmp1_ = _tmp0_;
	result = _tmp1_;
	return result;
}

void
folks_note_field_details_set_uid (FolksNoteFieldDetails* self,
                                  const gchar* value)
{
	g_return_if_fail (self != NULL);
	folks_abstract_field_details_set_id ((FolksAbstractFieldDetails*) self, value);
	g_object_notify_by_pspec ((GObject *) self, folks_note_field_details_properties[FOLKS_NOTE_FIELD_DETAILS_UID_PROPERTY]);
}

static void
folks_note_field_details_class_init (FolksNoteFieldDetailsClass * klass,
                                     gpointer klass_data)
{
	folks_note_field_details_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolksNoteFieldDetails_private_offset);
	((FolksAbstractFieldDetailsClass *) klass)->equal = (gboolean (*) (FolksAbstractFieldDetails*, FolksAbstractFieldDetails*)) folks_note_field_details_real_equal;
	((FolksAbstractFieldDetailsClass *) klass)->hash = (guint (*) (FolksAbstractFieldDetails*)) folks_note_field_details_real_hash;
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->get_id = (const gchar* (*) (FolksAbstractFieldDetails*)) folks_note_field_details_real_get_id;
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->set_id = (void (*) (FolksAbstractFieldDetails*, const gchar*)) folks_note_field_details_real_set_id;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_note_field_details_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_note_field_details_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_note_field_details_finalize;
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_NOTE_FIELD_DETAILS_ID_PROPERTY, folks_note_field_details_properties[FOLKS_NOTE_FIELD_DETAILS_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The UID of the note (if any).
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_NOTE_FIELD_DETAILS_UID_PROPERTY, folks_note_field_details_properties[FOLKS_NOTE_FIELD_DETAILS_UID_PROPERTY] = g_param_spec_string ("uid", "uid", "uid", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_DEPRECATED));
}

static void
folks_note_field_details_instance_init (FolksNoteFieldDetails * self,
                                        gpointer klass)
{
	gchar* _tmp0_;
	self->priv = folks_note_field_details_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_id = _tmp0_;
}

static void
folks_note_field_details_finalize (GObject * obj)
{
	FolksNoteFieldDetails * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_NOTE_FIELD_DETAILS, FolksNoteFieldDetails);
	_g_free0 (self->priv->_id);
	G_OBJECT_CLASS (folks_note_field_details_parent_class)->finalize (obj);
}

/**
 * Object representing a note that can have some parameters associated with it.
 *
 * See {@link Folks.AbstractFieldDetails} for details on common parameter names
 * and values.
 *
 * @since 0.6.0
 */
static GType
folks_note_field_details_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksNoteFieldDetailsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_note_field_details_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksNoteFieldDetails), 0, (GInstanceInitFunc) folks_note_field_details_instance_init, NULL };
	GType folks_note_field_details_type_id;
	folks_note_field_details_type_id = g_type_register_static (FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, "FolksNoteFieldDetails", &g_define_type_info, 0);
	FolksNoteFieldDetails_private_offset = g_type_add_instance_private (folks_note_field_details_type_id, sizeof (FolksNoteFieldDetailsPrivate));
	return folks_note_field_details_type_id;
}

GType
folks_note_field_details_get_type (void)
{
	static volatile gsize folks_note_field_details_type_id__once = 0;
	if (g_once_init_enter (&folks_note_field_details_type_id__once)) {
		GType folks_note_field_details_type_id;
		folks_note_field_details_type_id = folks_note_field_details_get_type_once ();
		g_once_init_leave (&folks_note_field_details_type_id__once, folks_note_field_details_type_id);
	}
	return folks_note_field_details_type_id__once;
}

static void
_vala_folks_note_field_details_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	FolksNoteFieldDetails * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_NOTE_FIELD_DETAILS, FolksNoteFieldDetails);
	switch (property_id) {
		case FOLKS_NOTE_FIELD_DETAILS_ID_PROPERTY:
		g_value_set_string (value, folks_abstract_field_details_get_id ((FolksAbstractFieldDetails*) self));
		break;
		case FOLKS_NOTE_FIELD_DETAILS_UID_PROPERTY:
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
		g_value_set_string (value, folks_note_field_details_get_uid (self));
G_GNUC_END_IGNORE_DEPRECATIONS
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_folks_note_field_details_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	FolksNoteFieldDetails * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_NOTE_FIELD_DETAILS, FolksNoteFieldDetails);
	switch (property_id) {
		case FOLKS_NOTE_FIELD_DETAILS_ID_PROPERTY:
		folks_abstract_field_details_set_id ((FolksAbstractFieldDetails*) self, g_value_get_string (value));
		break;
		case FOLKS_NOTE_FIELD_DETAILS_UID_PROPERTY:
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
		folks_note_field_details_set_uid (self, g_value_get_string (value));
G_GNUC_END_IGNORE_DEPRECATIONS
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
folks_note_details_real_change_notes_data_free (gpointer _data)
{
	FolksNoteDetailsChangeNotesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->notes);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksNoteDetailsChangeNotesData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
folks_note_details_real_change_notes (FolksNoteDetails* self,
                                      GeeSet* notes,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	FolksNoteDetailsChangeNotesData* _data_;
	FolksNoteDetails* _tmp0_;
	GeeSet* _tmp1_;
	g_return_if_fail (notes != NULL);
	_data_ = g_slice_new0 (FolksNoteDetailsChangeNotesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_note_details_real_change_notes_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (notes);
	_g_object_unref0 (_data_->notes);
	_data_->notes = _tmp1_;
	folks_note_details_real_change_notes_co (_data_);
}

static void
folks_note_details_real_change_notes_finish (FolksNoteDetails* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	FolksNoteDetailsChangeNotesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Change the contact's notes.
   *
   * It's preferred to call this rather than setting {@link NoteDetails.notes}
   * directly, as this method gives error notification and will only return once
   * the notes have been written to the relevant backing store (or the
   * operation's failed).
   *
   * @param notes the set of notes
   * @throws PropertyError if setting the notes failed
   * @since 0.6.2
   */
static gboolean
folks_note_details_real_change_notes_co (FolksNoteDetailsChangeNotesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _ ("Notes are not writeable on this contact."));
	_data_->_inner_error0_ = _data_->_tmp0_;
	if (_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
folks_note_details_change_notes (FolksNoteDetails* self,
                                 GeeSet* notes,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	FolksNoteDetailsIface* _iface_;
	_iface_ = FOLKS_NOTE_DETAILS_GET_INTERFACE (self);
	if (_iface_->change_notes) {
		_iface_->change_notes (self, notes, _callback_, _user_data_);
	}
}

void
folks_note_details_change_notes_finish (FolksNoteDetails* self,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	FolksNoteDetailsIface* _iface_;
	_iface_ = FOLKS_NOTE_DETAILS_GET_INTERFACE (self);
	if (_iface_->change_notes_finish) {
		_iface_->change_notes_finish (self, _res_, error);
	}
}

GeeSet*
folks_note_details_get_notes (FolksNoteDetails* self)
{
	FolksNoteDetailsIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = FOLKS_NOTE_DETAILS_GET_INTERFACE (self);
	if (_iface_->get_notes) {
		return _iface_->get_notes (self);
	}
	return NULL;
}

void
folks_note_details_set_notes (FolksNoteDetails* self,
                              GeeSet* value)
{
	FolksNoteDetailsIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = FOLKS_NOTE_DETAILS_GET_INTERFACE (self);
	if (_iface_->set_notes) {
		_iface_->set_notes (self, value);
	}
}

static void
folks_note_details_default_init (FolksNoteDetailsIface * iface,
                                 gpointer iface_data)
{
	/**
	   * The notes about the contact.
	   *
	   * @since 0.5.1
	   */
	g_object_interface_install_property (iface, g_param_spec_object ("notes", "notes", "notes", GEE_TYPE_SET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	iface->change_notes = folks_note_details_real_change_notes;
	iface->change_notes_finish = folks_note_details_real_change_notes_finish;
}

/**
 * This interface represents the list of notes associated
 * to a {@link Persona} and {@link Individual}.
 *
 * @since 0.4.0
 */
static GType
folks_note_details_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksNoteDetailsIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_note_details_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType folks_note_details_type_id;
	folks_note_details_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksNoteDetails", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (folks_note_details_type_id, G_TYPE_OBJECT);
	return folks_note_details_type_id;
}

GType
folks_note_details_get_type (void)
{
	static volatile gsize folks_note_details_type_id__once = 0;
	if (g_once_init_enter (&folks_note_details_type_id__once)) {
		GType folks_note_details_type_id;
		folks_note_details_type_id = folks_note_details_get_type_once ();
		g_once_init_leave (&folks_note_details_type_id__once, folks_note_details_type_id);
	}
	return folks_note_details_type_id__once;
}

