struct cs_radial_gradient_common {
struct Samplers {
 sampler2D_impl sGpuBufferF_impl;
 int sGpuBufferF_slot;
 isampler2D_impl sGpuBufferI_impl;
 int sGpuBufferI_slot;
 sampler2D_impl sGpuCache_impl;
 int sGpuCache_slot;
 sampler2D_impl sRenderTasks_impl;
 int sRenderTasks_slot;
 bool set_slot(int index, int value) {
  switch (index) {
  case 3:
   sGpuBufferF_slot = value;
   return true;
  case 4:
   sGpuBufferI_slot = value;
   return true;
  case 2:
   sGpuCache_slot = value;
   return true;
  case 1:
   sRenderTasks_slot = value;
   return true;
  }
  return false;
 }
} samplers;
struct AttribLocations {
 int aPosition = NULL_ATTRIB;
 int aTaskRect = NULL_ATTRIB;
 int aCenter = NULL_ATTRIB;
 int aScale = NULL_ATTRIB;
 int aStartRadius = NULL_ATTRIB;
 int aEndRadius = NULL_ATTRIB;
 int aXYRatio = NULL_ATTRIB;
 int aExtendMode = NULL_ATTRIB;
 int aGradientStopsAddress = NULL_ATTRIB;
 void bind_loc(const char* name, int index) {
  if (strcmp("aPosition", name) == 0) { aPosition = index; return; }
  if (strcmp("aTaskRect", name) == 0) { aTaskRect = index; return; }
  if (strcmp("aCenter", name) == 0) { aCenter = index; return; }
  if (strcmp("aScale", name) == 0) { aScale = index; return; }
  if (strcmp("aStartRadius", name) == 0) { aStartRadius = index; return; }
  if (strcmp("aEndRadius", name) == 0) { aEndRadius = index; return; }
  if (strcmp("aXYRatio", name) == 0) { aXYRatio = index; return; }
  if (strcmp("aExtendMode", name) == 0) { aExtendMode = index; return; }
  if (strcmp("aGradientStopsAddress", name) == 0) { aGradientStopsAddress = index; return; }
 }
 int get_loc(const char* name) const {
  if (strcmp("aPosition", name) == 0) { return aPosition != NULL_ATTRIB ? aPosition : -1; }
  if (strcmp("aTaskRect", name) == 0) { return aTaskRect != NULL_ATTRIB ? aTaskRect : -1; }
  if (strcmp("aCenter", name) == 0) { return aCenter != NULL_ATTRIB ? aCenter : -1; }
  if (strcmp("aScale", name) == 0) { return aScale != NULL_ATTRIB ? aScale : -1; }
  if (strcmp("aStartRadius", name) == 0) { return aStartRadius != NULL_ATTRIB ? aStartRadius : -1; }
  if (strcmp("aEndRadius", name) == 0) { return aEndRadius != NULL_ATTRIB ? aEndRadius : -1; }
  if (strcmp("aXYRatio", name) == 0) { return aXYRatio != NULL_ATTRIB ? aXYRatio : -1; }
  if (strcmp("aExtendMode", name) == 0) { return aExtendMode != NULL_ATTRIB ? aExtendMode : -1; }
  if (strcmp("aGradientStopsAddress", name) == 0) { return aGradientStopsAddress != NULL_ATTRIB ? aGradientStopsAddress : -1; }
  return -1;
 }
} attrib_locations;
ivec2_scalar v_gradient_address;
vec2_scalar v_gradient_repeat;
vec2_scalar v_start_radius;
sampler2D sGpuBufferF;
isampler2D sGpuBufferI;
sampler2D sGpuCache;
sampler2D sRenderTasks;
mat4_scalar uTransform;
void bind_textures() {
 sGpuBufferF = lookup_sampler(&samplers.sGpuBufferF_impl, samplers.sGpuBufferF_slot);
 sGpuBufferI = lookup_isampler(&samplers.sGpuBufferI_impl, samplers.sGpuBufferI_slot);
 sGpuCache = lookup_sampler(&samplers.sGpuCache_impl, samplers.sGpuCache_slot);
 sRenderTasks = lookup_sampler(&samplers.sRenderTasks_impl, samplers.sRenderTasks_slot);
}
};
struct cs_radial_gradient_vert : VertexShaderImpl, cs_radial_gradient_common {
private:
typedef cs_radial_gradient_vert Self;
// mat4_scalar uTransform;
vec2 aPosition;
struct RectWithSize_scalar {
vec2_scalar p0;
vec2_scalar size;
RectWithSize_scalar() = default;
RectWithSize_scalar(vec2_scalar p0, vec2_scalar size) : p0(p0), size(size){}
};
struct RectWithSize {
vec2 p0;
vec2 size;
RectWithSize() = default;
RectWithSize(vec2 p0, vec2 size) : p0(p0), size(size){}
RectWithSize(vec2_scalar p0, vec2_scalar size):p0(p0),size(size){
}
IMPLICIT RectWithSize(RectWithSize_scalar s):p0(s.p0),size(s.size){
}
friend RectWithSize if_then_else(I32 c, RectWithSize t, RectWithSize e) { return RectWithSize(
if_then_else(c, t.p0, e.p0), if_then_else(c, t.size, e.size));
}};
struct RectWithEndpoint_scalar {
vec2_scalar p0;
vec2_scalar p1;
RectWithEndpoint_scalar() = default;
RectWithEndpoint_scalar(vec2_scalar p0, vec2_scalar p1) : p0(p0), p1(p1){}
};
struct RectWithEndpoint {
vec2 p0;
vec2 p1;
RectWithEndpoint() = default;
RectWithEndpoint(vec2 p0, vec2 p1) : p0(p0), p1(p1){}
RectWithEndpoint(vec2_scalar p0, vec2_scalar p1):p0(p0),p1(p1){
}
IMPLICIT RectWithEndpoint(RectWithEndpoint_scalar s):p0(s.p0),p1(s.p1){
}
friend RectWithEndpoint if_then_else(I32 c, RectWithEndpoint t, RectWithEndpoint e) { return RectWithEndpoint(
if_then_else(c, t.p0, e.p0), if_then_else(c, t.p1, e.p1));
}};
// sampler2D sRenderTasks;
struct RenderTaskData_scalar {
RectWithEndpoint_scalar task_rect;
vec4_scalar user_data;
RenderTaskData_scalar() = default;
RenderTaskData_scalar(RectWithEndpoint_scalar task_rect, vec4_scalar user_data) : task_rect(task_rect), user_data(user_data){}
};
struct RenderTaskData {
RectWithEndpoint task_rect;
vec4 user_data;
RenderTaskData() = default;
RenderTaskData(RectWithEndpoint task_rect, vec4 user_data) : task_rect(task_rect), user_data(user_data){}
RenderTaskData(RectWithEndpoint_scalar task_rect, vec4_scalar user_data):task_rect(task_rect),user_data(user_data){
}
IMPLICIT RenderTaskData(RenderTaskData_scalar s):task_rect(s.task_rect),user_data(s.user_data){
}
friend RenderTaskData if_then_else(I32 c, RenderTaskData t, RenderTaskData e) { return RenderTaskData(
if_then_else(c, t.task_rect, e.task_rect), if_then_else(c, t.user_data, e.user_data));
}};
struct PictureTask_scalar {
RectWithEndpoint_scalar task_rect;
float device_pixel_scale;
vec2_scalar content_origin;
PictureTask_scalar() = default;
PictureTask_scalar(RectWithEndpoint_scalar task_rect, float device_pixel_scale, vec2_scalar content_origin) : task_rect(task_rect), device_pixel_scale(device_pixel_scale), content_origin(content_origin){}
};
struct PictureTask {
RectWithEndpoint task_rect;
Float device_pixel_scale;
vec2 content_origin;
PictureTask() = default;
PictureTask(RectWithEndpoint task_rect, Float device_pixel_scale, vec2 content_origin) : task_rect(task_rect), device_pixel_scale(device_pixel_scale), content_origin(content_origin){}
PictureTask(RectWithEndpoint_scalar task_rect, float device_pixel_scale, vec2_scalar content_origin):task_rect(task_rect),device_pixel_scale(device_pixel_scale),content_origin(content_origin){
}
IMPLICIT PictureTask(PictureTask_scalar s):task_rect(s.task_rect),device_pixel_scale(s.device_pixel_scale),content_origin(s.content_origin){
}
friend PictureTask if_then_else(I32 c, PictureTask t, PictureTask e) { return PictureTask(
if_then_else(c, t.task_rect, e.task_rect), if_then_else(c, t.device_pixel_scale, e.device_pixel_scale), if_then_else(c, t.content_origin, e.content_origin));
}};
struct ClipArea_scalar {
RectWithEndpoint_scalar task_rect;
float device_pixel_scale;
vec2_scalar screen_origin;
ClipArea_scalar() = default;
ClipArea_scalar(RectWithEndpoint_scalar task_rect, float device_pixel_scale, vec2_scalar screen_origin) : task_rect(task_rect), device_pixel_scale(device_pixel_scale), screen_origin(screen_origin){}
};
struct ClipArea {
RectWithEndpoint task_rect;
Float device_pixel_scale;
vec2 screen_origin;
ClipArea() = default;
ClipArea(RectWithEndpoint task_rect, Float device_pixel_scale, vec2 screen_origin) : task_rect(task_rect), device_pixel_scale(device_pixel_scale), screen_origin(screen_origin){}
ClipArea(RectWithEndpoint_scalar task_rect, float device_pixel_scale, vec2_scalar screen_origin):task_rect(task_rect),device_pixel_scale(device_pixel_scale),screen_origin(screen_origin){
}
IMPLICIT ClipArea(ClipArea_scalar s):task_rect(s.task_rect),device_pixel_scale(s.device_pixel_scale),screen_origin(s.screen_origin){
}
friend ClipArea if_then_else(I32 c, ClipArea t, ClipArea e) { return ClipArea(
if_then_else(c, t.task_rect, e.task_rect), if_then_else(c, t.device_pixel_scale, e.device_pixel_scale), if_then_else(c, t.screen_origin, e.screen_origin));
}};
// sampler2D sGpuCache;
struct ImageSource_scalar {
RectWithEndpoint_scalar uv_rect;
vec4_scalar user_data;
ImageSource_scalar() = default;
ImageSource_scalar(RectWithEndpoint_scalar uv_rect, vec4_scalar user_data) : uv_rect(uv_rect), user_data(user_data){}
};
struct ImageSource {
RectWithEndpoint uv_rect;
vec4 user_data;
ImageSource() = default;
ImageSource(RectWithEndpoint uv_rect, vec4 user_data) : uv_rect(uv_rect), user_data(user_data){}
ImageSource(RectWithEndpoint_scalar uv_rect, vec4_scalar user_data):uv_rect(uv_rect),user_data(user_data){
}
IMPLICIT ImageSource(ImageSource_scalar s):uv_rect(s.uv_rect),user_data(s.user_data){
}
friend ImageSource if_then_else(I32 c, ImageSource t, ImageSource e) { return ImageSource(
if_then_else(c, t.uv_rect, e.uv_rect), if_then_else(c, t.user_data, e.user_data));
}};
struct ImageSourceExtra_scalar {
vec4_scalar st_tl;
vec4_scalar st_tr;
vec4_scalar st_bl;
vec4_scalar st_br;
ImageSourceExtra_scalar() = default;
ImageSourceExtra_scalar(vec4_scalar st_tl, vec4_scalar st_tr, vec4_scalar st_bl, vec4_scalar st_br) : st_tl(st_tl), st_tr(st_tr), st_bl(st_bl), st_br(st_br){}
};
struct ImageSourceExtra {
vec4 st_tl;
vec4 st_tr;
vec4 st_bl;
vec4 st_br;
ImageSourceExtra() = default;
ImageSourceExtra(vec4 st_tl, vec4 st_tr, vec4 st_bl, vec4 st_br) : st_tl(st_tl), st_tr(st_tr), st_bl(st_bl), st_br(st_br){}
ImageSourceExtra(vec4_scalar st_tl, vec4_scalar st_tr, vec4_scalar st_bl, vec4_scalar st_br):st_tl(st_tl),st_tr(st_tr),st_bl(st_bl),st_br(st_br){
}
IMPLICIT ImageSourceExtra(ImageSourceExtra_scalar s):st_tl(s.st_tl),st_tr(s.st_tr),st_bl(s.st_bl),st_br(s.st_br){
}
friend ImageSourceExtra if_then_else(I32 c, ImageSourceExtra t, ImageSourceExtra e) { return ImageSourceExtra(
if_then_else(c, t.st_tl, e.st_tl), if_then_else(c, t.st_tr, e.st_tr), if_then_else(c, t.st_bl, e.st_bl), if_then_else(c, t.st_br, e.st_br));
}};
// sampler2D sGpuBufferF;
// isampler2D sGpuBufferI;
// ivec2_scalar v_gradient_address;
// vec2_scalar v_gradient_repeat;
vec2 v_pos;
// vec2_scalar v_start_radius;
vec4_scalar aTaskRect;
vec2_scalar aCenter;
vec2_scalar aScale;
float aStartRadius;
float aEndRadius;
float aXYRatio;
int32_t aExtendMode;
int32_t aGradientStopsAddress;
ALWAYS_INLINE void main(void) {
 float rd = (aEndRadius)-(aStartRadius);
 float radius_scale = (rd)!=(0.f) ? (1.f)/(rd) : 0.f;
 vec2 pos = mix((aTaskRect).sel(X,Y), (aTaskRect).sel(Z,W), (aPosition).sel(X,Y));
 gl_Position = (uTransform)*(make_vec4(pos, 0.f, 1.f));
 (v_start_radius).x = (aStartRadius)*(radius_scale);
 v_pos = ((((((aTaskRect).sel(Z,W))-((aTaskRect).sel(X,Y)))*((aPosition).sel(X,Y)))*(aScale))-(aCenter))*(radius_scale);
 (v_pos).y *= aXYRatio;
 (v_gradient_repeat).x = make_float((make_int((aExtendMode)==(1)))&(1));
 (v_gradient_address).x = aGradientStopsAddress;
}
static void set_uniform_1i(VertexShaderImpl* impl, int index, int value) {
 Self* self = (Self*)impl;
 if (self->samplers.set_slot(index, value)) return;
 switch (index) {
 case 3:
  assert(0); // sGpuBufferF
  break;
 case 4:
  assert(0); // sGpuBufferI
  break;
 case 2:
  assert(0); // sGpuCache
  break;
 case 1:
  assert(0); // sRenderTasks
  break;
 case 5:
  assert(0); // uTransform
  break;
 }
}
static void set_uniform_4fv(VertexShaderImpl* impl, int index, const float *value) {
 Self* self = (Self*)impl;
 switch (index) {
 case 3:
  assert(0); // sGpuBufferF
  break;
 case 4:
  assert(0); // sGpuBufferI
  break;
 case 2:
  assert(0); // sGpuCache
  break;
 case 1:
  assert(0); // sRenderTasks
  break;
 case 5:
  assert(0); // uTransform
  break;
 }
}
static void set_uniform_matrix4fv(VertexShaderImpl* impl, int index, const float *value) {
 Self* self = (Self*)impl;
 switch (index) {
 case 3:
  assert(0); // sGpuBufferF
  break;
 case 4:
  assert(0); // sGpuBufferI
  break;
 case 2:
  assert(0); // sGpuCache
  break;
 case 1:
  assert(0); // sRenderTasks
  break;
 case 5:
  self->uTransform = mat4_scalar::load_from_ptr(value);
  break;
 }
}
static void load_attribs(VertexShaderImpl* impl, VertexAttrib *attribs, uint32_t start, int instance, int count) {Self* self = (Self*)impl;
 load_attrib(self->aPosition, attribs[self->attrib_locations.aPosition], start, instance, count);
 load_flat_attrib(self->aTaskRect, attribs[self->attrib_locations.aTaskRect], start, instance, count);
 load_flat_attrib(self->aCenter, attribs[self->attrib_locations.aCenter], start, instance, count);
 load_flat_attrib(self->aScale, attribs[self->attrib_locations.aScale], start, instance, count);
 load_flat_attrib(self->aStartRadius, attribs[self->attrib_locations.aStartRadius], start, instance, count);
 load_flat_attrib(self->aEndRadius, attribs[self->attrib_locations.aEndRadius], start, instance, count);
 load_flat_attrib(self->aXYRatio, attribs[self->attrib_locations.aXYRatio], start, instance, count);
 load_flat_attrib(self->aExtendMode, attribs[self->attrib_locations.aExtendMode], start, instance, count);
 load_flat_attrib(self->aGradientStopsAddress, attribs[self->attrib_locations.aGradientStopsAddress], start, instance, count);
}
public:
struct InterpOutputs {
vec2_scalar v_pos;
};
private:
ALWAYS_INLINE void store_interp_outputs(char* dest_ptr, size_t stride) {
  for(int n = 0; n < 4; n++) {
    auto* dest = reinterpret_cast<InterpOutputs*>(dest_ptr);
    dest->v_pos = get_nth(v_pos, n);
    dest_ptr += stride;
  }
}
static void run(VertexShaderImpl* impl, char* interps, size_t interp_stride) {
 Self* self = (Self*)impl;
 self->main();
 self->store_interp_outputs(interps, interp_stride);
}
static void init_batch(VertexShaderImpl* impl) {
 Self* self = (Self*)impl; self->bind_textures(); }
public:
cs_radial_gradient_vert() {
 set_uniform_1i_func = &set_uniform_1i;
 set_uniform_4fv_func = &set_uniform_4fv;
 set_uniform_matrix4fv_func = &set_uniform_matrix4fv;
 init_batch_func = &init_batch;
 load_attribs_func = &load_attribs;
 run_primitive_func = &run;
}
};


struct cs_radial_gradient_frag : FragmentShaderImpl, cs_radial_gradient_vert {
private:
typedef cs_radial_gradient_frag Self;
#define oFragColor gl_FragColor
// vec4 oFragColor;
struct RectWithSize_scalar {
vec2_scalar p0;
vec2_scalar size;
RectWithSize_scalar() = default;
RectWithSize_scalar(vec2_scalar p0, vec2_scalar size) : p0(p0), size(size){}
};
struct RectWithSize {
vec2 p0;
vec2 size;
RectWithSize() = default;
RectWithSize(vec2 p0, vec2 size) : p0(p0), size(size){}
RectWithSize(vec2_scalar p0, vec2_scalar size):p0(p0),size(size){
}
IMPLICIT RectWithSize(RectWithSize_scalar s):p0(s.p0),size(s.size){
}
friend RectWithSize if_then_else(I32 c, RectWithSize t, RectWithSize e) { return RectWithSize(
if_then_else(c, t.p0, e.p0), if_then_else(c, t.size, e.size));
}};
struct RectWithEndpoint_scalar {
vec2_scalar p0;
vec2_scalar p1;
RectWithEndpoint_scalar() = default;
RectWithEndpoint_scalar(vec2_scalar p0, vec2_scalar p1) : p0(p0), p1(p1){}
};
struct RectWithEndpoint {
vec2 p0;
vec2 p1;
RectWithEndpoint() = default;
RectWithEndpoint(vec2 p0, vec2 p1) : p0(p0), p1(p1){}
RectWithEndpoint(vec2_scalar p0, vec2_scalar p1):p0(p0),p1(p1){
}
IMPLICIT RectWithEndpoint(RectWithEndpoint_scalar s):p0(s.p0),p1(s.p1){
}
friend RectWithEndpoint if_then_else(I32 c, RectWithEndpoint t, RectWithEndpoint e) { return RectWithEndpoint(
if_then_else(c, t.p0, e.p0), if_then_else(c, t.p1, e.p1));
}};
// sampler2D sGpuCache;
// sampler2D sGpuBufferF;
// isampler2D sGpuBufferI;
// ivec2_scalar v_gradient_address;
// vec2_scalar v_gradient_repeat;
vec2 v_pos;
// vec2_scalar v_start_radius;
Float clamp_gradient_entry(Float offset) {
 return clamp((1.f)+((offset)*(128.f)), 0.f, (1.f)+(128.f));
}
ivec2 get_gpu_buffer_uv(I32 address) {
 return make_ivec2((make_uint(address))%(1024u), (make_uint(address))/(1024u));
}
Array<vec4,2> fetch_from_gpu_buffer_2f(I32 address) {
 ivec2 uv = get_gpu_buffer_uv(address);
 auto sGpuBufferF_uv_fetch = texelFetchPtr(sGpuBufferF, uv, 0, 1, 0, 0);
 return Array<vec4,2>{{texelFetchUnchecked(sGpuBufferF, sGpuBufferF_uv_fetch, 0, 0), texelFetchUnchecked(sGpuBufferF, sGpuBufferF_uv_fetch, 1, 0)}};
}
vec4 dither(vec4 color) {
 return color;
}
vec4 sample_gradient(Float offset) {
 offset -= (floor(offset))*((v_gradient_repeat).x);
 Float x = clamp_gradient_entry(offset);
 Float entry_index = floor(x);
 Float entry_fract = (x)-(entry_index);
 Array<vec4,2> texels = fetch_from_gpu_buffer_2f(((v_gradient_address).x)+((2)*(make_int(entry_index))));
 return dither((texels[0])+((texels[1])*(entry_fract)));
}
ALWAYS_INLINE void main(void) {
 Float offset = (length(v_pos))-((v_start_radius).x);
 oFragColor = sample_gradient(offset);
}
ivec2_scalar get_gpu_buffer_uv(int32_t address) {
 return make_ivec2((make_uint(address))%(1024u), (make_uint(address))/(1024u));
}
void swgl_drawSpanRGBA8() {
 int32_t address = swgl_validateGradient(sGpuBufferF, get_gpu_buffer_uv((v_gradient_address).x), make_int((128.f)+(2.f)));
 if ((address)<(0)) {
  {
   return;
  }
 }
 swgl_commitRadialGradientRGBA8(sGpuBufferF, address, 128.f, ((v_gradient_repeat).x)!=(0.f), v_pos, (v_start_radius).x);
}
typedef cs_radial_gradient_vert::InterpOutputs InterpInputs;
InterpInputs interp_step;
struct InterpPerspective {
vec2 v_pos;
};
InterpPerspective interp_perspective;
static void read_interp_inputs(FragmentShaderImpl* impl, const void* init_, const void* step_) {Self* self = (Self*)impl;const InterpInputs* init = (const InterpInputs*)init_;const InterpInputs* step = (const InterpInputs*)step_;
  self->v_pos = init_interp(init->v_pos, step->v_pos);
  self->interp_step.v_pos = step->v_pos * 4.0f;
}
static void read_perspective_inputs(FragmentShaderImpl* impl, const void* init_, const void* step_) {Self* self = (Self*)impl;const InterpInputs* init = (const InterpInputs*)init_;const InterpInputs* step = (const InterpInputs*)step_;
  Float w = 1.0f / self->gl_FragCoord.w;
  self->interp_perspective.v_pos = init_interp(init->v_pos, step->v_pos);
  self->v_pos = self->interp_perspective.v_pos * w;
  self->interp_step.v_pos = step->v_pos * 4.0f;
}
ALWAYS_INLINE void step_interp_inputs(int steps = 4) {
  float chunks = steps * 0.25f;
  v_pos += interp_step.v_pos * chunks;
}
ALWAYS_INLINE void step_perspective_inputs(int steps = 4) {
  step_perspective(steps);
  float chunks = steps * 0.25f;
  Float w = 1.0f / gl_FragCoord.w;
  interp_perspective.v_pos += interp_step.v_pos * chunks;
  v_pos = w * interp_perspective.v_pos;
}
static void run(FragmentShaderImpl* impl) {
 Self* self = (Self*)impl;
 self->main();
 self->step_interp_inputs();
}
static void skip(FragmentShaderImpl* impl, int steps) {
 Self* self = (Self*)impl;
 self->step_interp_inputs(steps);
}
static void run_perspective(FragmentShaderImpl* impl) {
 Self* self = (Self*)impl;
 self->main();
 self->step_perspective_inputs();
}
static void skip_perspective(FragmentShaderImpl* impl, int steps) {
 Self* self = (Self*)impl;
 self->step_perspective_inputs(steps);
}
static int draw_span_RGBA8(FragmentShaderImpl* impl) {
 Self* self = (Self*)impl; DISPATCH_DRAW_SPAN(self, RGBA8); }
public:
cs_radial_gradient_frag() {
 init_span_func = &read_interp_inputs;
 run_func = &run;
 skip_func = &skip;
 draw_span_RGBA8_func = &draw_span_RGBA8;
 enable_perspective();
 init_span_w_func = &read_perspective_inputs;
 run_w_func = &run_perspective;
 skip_w_func = &skip_perspective;
}
};

struct cs_radial_gradient_program : ProgramImpl, cs_radial_gradient_frag {
int get_uniform(const char *name) const override {
 if (strcmp("sGpuBufferF", name) == 0) { return 3; }
 if (strcmp("sGpuBufferI", name) == 0) { return 4; }
 if (strcmp("sGpuCache", name) == 0) { return 2; }
 if (strcmp("sRenderTasks", name) == 0) { return 1; }
 if (strcmp("uTransform", name) == 0) { return 5; }
 return -1;
}
void bind_attrib(const char* name, int index) override {
 attrib_locations.bind_loc(name, index);
}
int get_attrib(const char* name) const override {
 return attrib_locations.get_loc(name);
}
size_t interpolants_size() const override { return sizeof(InterpOutputs); }
VertexShaderImpl* get_vertex_shader() override {
 return this;
}
FragmentShaderImpl* get_fragment_shader() override {
 return this;
}
const char* get_name() const override { return "cs_radial_gradient"; }
static ProgramImpl* loader() { return new cs_radial_gradient_program; }
};

