//
// Automatically generated by ipdlc.
// Edit at your own risk
//

#ifndef PDNSRequestParams_h
#define PDNSRequestParams_h

#include "mozilla/Attributes.h"
#include "IPCMessageStart.h"
#include "mozilla/RefPtr.h"
#include "nsString.h"
#include "nsTArray.h"
#include "nsTHashtable.h"
#include "mozilla/MozPromise.h"
#include "mozilla/OperatorNewExtensions.h"
#include "mozilla/UniquePtr.h"
#include "mozilla/ipc/ByteBuf.h"
#include "mozilla/ipc/FileDescriptor.h"
#include "mozilla/ipc/IPCForwards.h"
#include "mozilla/ipc/Shmem.h"

// Headers for typedefs
#include "mozilla/TimeStamp.h"
#include "mozilla/ipc/IPDLStructMember.h"
#include "mozilla/net/DNS.h"
#include "mozilla/net/DNSByTypeRecord.h"
#include "nsIRequest.h"


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct DNSRecord|
//
namespace mozilla {
namespace net {
class DNSRecord final
{
private:
    typedef ::nsCString nsCString;
    typedef ::mozilla::net::NetAddr NetAddr;
    typedef ::nsIRequest::TRRMode TRRMode;
    typedef ::uint32_t uint32_t;
    typedef ::mozilla::TimeStamp TimeStamp;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    DNSRecord() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT DNSRecord(
            const nsCString& _canonicalName,
            const nsTArray<NetAddr>& _addrs,
            const double& _trrFetchDuration,
            const double& _trrFetchDurationNetworkOnly,
            const bool& _isTRR,
            const TRRMode& _effectiveTRRMode,
            const uint32_t& _ttl,
            const TimeStamp& _lastUpdate) :
        canonicalName_(_canonicalName),
        addrs_(_addrs),
        isTRR_(_isTRR),
        effectiveTRRMode_(_effectiveTRRMode),
        lastUpdate_(_lastUpdate),
        trrFetchDuration_(_trrFetchDuration),
        trrFetchDurationNetworkOnly_(_trrFetchDurationNetworkOnly),
        ttl_(_ttl)
    {
    }

    MOZ_IMPLICIT DNSRecord(
            nsCString&& _canonicalName,
            nsTArray<NetAddr>&& _addrs,
            double&& _trrFetchDuration,
            double&& _trrFetchDurationNetworkOnly,
            bool&& _isTRR,
            TRRMode&& _effectiveTRRMode,
            uint32_t&& _ttl,
            TimeStamp&& _lastUpdate) :
        canonicalName_(std::move(_canonicalName)),
        addrs_(std::move(_addrs)),
        isTRR_(std::move(_isTRR)),
        effectiveTRRMode_(std::move(_effectiveTRRMode)),
        lastUpdate_(std::move(_lastUpdate)),
        trrFetchDuration_(std::move(_trrFetchDuration)),
        trrFetchDurationNetworkOnly_(std::move(_trrFetchDurationNetworkOnly)),
        ttl_(std::move(_ttl))
    {
    }

    nsCString&
    canonicalName()
    {
        return canonicalName_;
    }
    const nsCString&
    canonicalName() const
    {
        return canonicalName_;
    }

    nsTArray<NetAddr>&
    addrs()
    {
        return addrs_;
    }
    const nsTArray<NetAddr>&
    addrs() const
    {
        return addrs_;
    }

    double&
    trrFetchDuration()
    {
        return trrFetchDuration_;
    }
    const double&
    trrFetchDuration() const
    {
        return trrFetchDuration_;
    }

    double&
    trrFetchDurationNetworkOnly()
    {
        return trrFetchDurationNetworkOnly_;
    }
    const double&
    trrFetchDurationNetworkOnly() const
    {
        return trrFetchDurationNetworkOnly_;
    }

    bool&
    isTRR()
    {
        return isTRR_;
    }
    const bool&
    isTRR() const
    {
        return isTRR_;
    }

    TRRMode&
    effectiveTRRMode()
    {
        return effectiveTRRMode_;
    }
    const TRRMode&
    effectiveTRRMode() const
    {
        return effectiveTRRMode_;
    }

    uint32_t&
    ttl()
    {
        return ttl_;
    }
    const uint32_t&
    ttl() const
    {
        return ttl_;
    }

    TimeStamp&
    lastUpdate()
    {
        return lastUpdate_;
    }
    const TimeStamp&
    lastUpdate() const
    {
        return lastUpdate_;
    }

private:
    void
    StaticAssertions() const;
    ::mozilla::ipc::IPDLStructMember<nsCString> canonicalName_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<NetAddr>> addrs_;
    ::mozilla::ipc::IPDLStructMember<bool> isTRR_;
    ::mozilla::ipc::IPDLStructMember<TRRMode> effectiveTRRMode_;
    ::mozilla::ipc::IPDLStructMember<TimeStamp> lastUpdate_;
    ::mozilla::ipc::IPDLStructMember<double> trrFetchDuration_;
    ::mozilla::ipc::IPDLStructMember<double> trrFetchDurationNetworkOnly_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> ttl_;
};
} // namespace net
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::net::DNSRecord>
{
    typedef ::mozilla::net::DNSRecord paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union DNSRequestResponse|
//
namespace mozilla {
namespace net {
class DNSRequestResponse final
{
public:
    enum Type {
        T__None,
        TDNSRecord = 1,
        TIPCTypeRecord,
        Tnsresult,
        T__Last = Tnsresult
    };

private:
    typedef ::mozilla::net::DNSRecord DNSRecord;
    typedef ::mozilla::net::IPCTypeRecord IPCTypeRecord;
    typedef ::nsresult nsresult;
    typedef DNSRecord DNSRecord__tdef;
    typedef IPCTypeRecord IPCTypeRecord__tdef;
    typedef nsresult nsresult__tdef;

    DNSRecord*
    ptr_DNSRecord()
    {
        return (&(mVDNSRecord));
    }
    const DNSRecord*
    constptr_DNSRecord() const
    {
        return (&(mVDNSRecord));
    }
    IPCTypeRecord*
    ptr_IPCTypeRecord()
    {
        return (&(mVIPCTypeRecord));
    }
    const IPCTypeRecord*
    constptr_IPCTypeRecord() const
    {
        return (&(mVIPCTypeRecord));
    }
    nsresult*
    ptr_nsresult()
    {
        return (&(mVnsresult));
    }
    const nsresult*
    constptr_nsresult() const
    {
        return (&(mVnsresult));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT DNSRequestResponse() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT DNSRequestResponse(const DNSRecord& aOther);

    MOZ_IMPLICIT DNSRequestResponse(DNSRecord&& aOther);

    MOZ_IMPLICIT DNSRequestResponse(const IPCTypeRecord& aOther);

    MOZ_IMPLICIT DNSRequestResponse(IPCTypeRecord&& aOther);

    MOZ_IMPLICIT DNSRequestResponse(const nsresult& aOther);

    MOZ_IMPLICIT DNSRequestResponse(nsresult&& aOther);

    MOZ_IMPLICIT DNSRequestResponse(const DNSRequestResponse& aOther);

    MOZ_IMPLICIT DNSRequestResponse(DNSRequestResponse&& aOther);

    ~DNSRequestResponse();

    Type
    type() const
    {
        return mType;
    }

    DNSRequestResponse&
    operator=(const DNSRecord& aRhs);

    DNSRequestResponse&
    operator=(DNSRecord&& aRhs);

    DNSRequestResponse&
    operator=(const IPCTypeRecord& aRhs);

    DNSRequestResponse&
    operator=(IPCTypeRecord&& aRhs);

    DNSRequestResponse&
    operator=(const nsresult& aRhs);

    DNSRequestResponse&
    operator=(nsresult&& aRhs);

    DNSRequestResponse&
    operator=(const DNSRequestResponse& aRhs);

    DNSRequestResponse&
    operator=(DNSRequestResponse&& aRhs);

    DNSRecord&
    get_DNSRecord()
    {
        AssertSanity(TDNSRecord);
        return (*(ptr_DNSRecord()));
    }
    const DNSRecord&
    get_DNSRecord() const
    {
        AssertSanity(TDNSRecord);
        return (*(constptr_DNSRecord()));
    }
    operator DNSRecord&()
    {
        return get_DNSRecord();
    }
    operator const DNSRecord&() const
    {
        return get_DNSRecord();
    }

    IPCTypeRecord&
    get_IPCTypeRecord()
    {
        AssertSanity(TIPCTypeRecord);
        return (*(ptr_IPCTypeRecord()));
    }
    const IPCTypeRecord&
    get_IPCTypeRecord() const
    {
        AssertSanity(TIPCTypeRecord);
        return (*(constptr_IPCTypeRecord()));
    }
    operator IPCTypeRecord&()
    {
        return get_IPCTypeRecord();
    }
    operator const IPCTypeRecord&() const
    {
        return get_IPCTypeRecord();
    }

    nsresult&
    get_nsresult()
    {
        AssertSanity(Tnsresult);
        return (*(ptr_nsresult()));
    }
    const nsresult&
    get_nsresult() const
    {
        AssertSanity(Tnsresult);
        return (*(constptr_nsresult()));
    }
    operator nsresult&()
    {
        return get_nsresult();
    }
    operator const nsresult&() const
    {
        return get_nsresult();
    }

private:
    union {
        DNSRecord mVDNSRecord;
        IPCTypeRecord mVIPCTypeRecord;
        nsresult mVnsresult;
    };
    Type mType;
};
} // namespace net
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::net::DNSRequestResponse>
{
    typedef ::mozilla::net::DNSRequestResponse paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC

#endif // ifndef PDNSRequestParams_h
