//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/a11y/PDocAccessibleChild.h"
#include "mozilla/GfxMessageUtils.h"
#include "mozilla/ProfilerLabels.h"

#include "mozilla/dom/PBrowserChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace a11y {


auto PDocAccessibleChild::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PDocAccessibleChild::PDocAccessibleChild() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PDocAccessibleChild);
}

PDocAccessibleChild::~PDocAccessibleChild()
{
    MOZ_COUNT_DTOR(PDocAccessibleChild);
}

auto PDocAccessibleChild::ActorAlloc() -> void
{
}

auto PDocAccessibleChild::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PDocAccessibleChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PDocAccessibleChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PDocAccessibleChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PDocAccessibleChild::Manager() const -> PBrowserChild*
{
    return static_cast<PBrowserChild*>(IProtocol::Manager());
}

auto PDocAccessibleChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PDocAccessibleChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PDocAccessibleChild::SendShutdown() -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_Shutdown(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_Shutdown", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleChild::SendEvent(
        const uint64_t& aID,
        const uint32_t& type) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_Event(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aID);
    // Sentinel = 'aID'
    ((&(writer__)))->WriteSentinel(33292527);
    IPC::WriteParam((&(writer__)), type);
    // Sentinel = 'type'
    ((&(writer__)))->WriteSentinel(75760067);


    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_Event", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleChild::SendStateChangeEvent(
        const uint64_t& aID,
        const uint64_t& aState,
        const bool& aEnabled) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_StateChangeEvent(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aID);
    // Sentinel = 'aID'
    ((&(writer__)))->WriteSentinel(33292527);
    IPC::WriteParam((&(writer__)), aState);
    // Sentinel = 'aState'
    ((&(writer__)))->WriteSentinel(137036387);
    IPC::WriteParam((&(writer__)), aEnabled);
    // Sentinel = 'aEnabled'
    ((&(writer__)))->WriteSentinel(224789261);


    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_StateChangeEvent", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleChild::SendCaretMoveEvent(
        const uint64_t& aID,
        const LayoutDeviceIntRect& aCaretRect,
        const int32_t& aOffset,
        const bool& aIsSelectionCollapsed,
        const bool& aIsAtEndOfLine,
        const int32_t& aGranularity,
        const bool& aFromUser) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_CaretMoveEvent(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aID);
    // Sentinel = 'aID'
    ((&(writer__)))->WriteSentinel(33292527);
    IPC::WriteParam((&(writer__)), aCaretRect);
    // Sentinel = 'aCaretRect'
    ((&(writer__)))->WriteSentinel(346555359);
    IPC::WriteParam((&(writer__)), aOffset);
    // Sentinel = 'aOffset'
    ((&(writer__)))->WriteSentinel(179634889);
    IPC::WriteParam((&(writer__)), aIsSelectionCollapsed);
    // Sentinel = 'aIsSelectionCollapsed'
    ((&(writer__)))->WriteSentinel(1514342491);
    IPC::WriteParam((&(writer__)), aIsAtEndOfLine);
    // Sentinel = 'aIsAtEndOfLine'
    ((&(writer__)))->WriteSentinel(635766055);
    IPC::WriteParam((&(writer__)), aGranularity);
    // Sentinel = 'aGranularity'
    ((&(writer__)))->WriteSentinel(519439604);
    IPC::WriteParam((&(writer__)), aFromUser);
    // Sentinel = 'aFromUser'
    ((&(writer__)))->WriteSentinel(291767189);


    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_CaretMoveEvent", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleChild::SendMutationEvents(mozilla::Span<MutationEventData const> aData) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_MutationEvents(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aData);
    // Sentinel = 'aData'
    ((&(writer__)))->WriteSentinel(90571228);


    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_MutationEvents", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleChild::SendRequestAckMutationEvents() -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_RequestAckMutationEvents(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_RequestAckMutationEvents", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleChild::SendSelectionEvent(
        const uint64_t& aID,
        const uint64_t& aWidgetID,
        const uint32_t& aType) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_SelectionEvent(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aID);
    // Sentinel = 'aID'
    ((&(writer__)))->WriteSentinel(33292527);
    IPC::WriteParam((&(writer__)), aWidgetID);
    // Sentinel = 'aWidgetID'
    ((&(writer__)))->WriteSentinel(287966035);
    IPC::WriteParam((&(writer__)), aType);
    // Sentinel = 'aType'
    ((&(writer__)))->WriteSentinel(99222020);


    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_SelectionEvent", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleChild::SendRoleChangedEvent(
        const role& aRole,
        const uint8_t& aRoleMapEntryIndex) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_RoleChangedEvent(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aRole);
    // Sentinel = 'aRole'
    ((&(writer__)))->WriteSentinel(96207348);
    IPC::WriteParam((&(writer__)), aRoleMapEntryIndex);
    // Sentinel = 'aRoleMapEntryIndex'
    ((&(writer__)))->WriteSentinel(1109133084);


    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_RoleChangedEvent", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleChild::SendFocusEvent(
        const uint64_t& aID,
        const LayoutDeviceIntRect& aCaretRect) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_FocusEvent(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aID);
    // Sentinel = 'aID'
    ((&(writer__)))->WriteSentinel(33292527);
    IPC::WriteParam((&(writer__)), aCaretRect);
    // Sentinel = 'aCaretRect'
    ((&(writer__)))->WriteSentinel(346555359);


    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_FocusEvent", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleChild::SendScrollingEvent(
        const uint64_t& aID,
        const uint64_t& aType,
        const uint32_t& aScrollX,
        const uint32_t& aScrollY,
        const uint32_t& aMaxScrollX,
        const uint32_t& aMaxScrollY) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_ScrollingEvent(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aID);
    // Sentinel = 'aID'
    ((&(writer__)))->WriteSentinel(33292527);
    IPC::WriteParam((&(writer__)), aType);
    // Sentinel = 'aType'
    ((&(writer__)))->WriteSentinel(99222020);
    IPC::WriteParam((&(writer__)), aScrollX);
    // Sentinel = 'aScrollX'
    ((&(writer__)))->WriteSentinel(235995945);
    IPC::WriteParam((&(writer__)), aScrollY);
    // Sentinel = 'aScrollY'
    ((&(writer__)))->WriteSentinel(236061482);
    IPC::WriteParam((&(writer__)), aMaxScrollX);
    // Sentinel = 'aMaxScrollX'
    ((&(writer__)))->WriteSentinel(425854031);
    IPC::WriteParam((&(writer__)), aMaxScrollY);
    // Sentinel = 'aMaxScrollY'
    ((&(writer__)))->WriteSentinel(425919568);


    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_ScrollingEvent", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleChild::SendAnnouncementEvent(
        const uint64_t& aID,
        const nsAString& aAnnouncement,
        const uint16_t& aPriority) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_AnnouncementEvent(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aID);
    // Sentinel = 'aID'
    ((&(writer__)))->WriteSentinel(33292527);
    IPC::WriteParam((&(writer__)), aAnnouncement);
    // Sentinel = 'aAnnouncement'
    ((&(writer__)))->WriteSentinel(605750605);
    IPC::WriteParam((&(writer__)), aPriority);
    // Sentinel = 'aPriority'
    ((&(writer__)))->WriteSentinel(303367108);


    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_AnnouncementEvent", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleChild::SendTextSelectionChangeEvent(
        const uint64_t& aID,
        mozilla::Span<TextRangeData const> aSelection) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_TextSelectionChangeEvent(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aID);
    // Sentinel = 'aID'
    ((&(writer__)))->WriteSentinel(33292527);
    IPC::WriteParam((&(writer__)), aSelection);
    // Sentinel = 'aSelection'
    ((&(writer__)))->WriteSentinel(360645640);


    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_TextSelectionChangeEvent", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleChild::SendBindChildDoc(
        mozilla::NotNull<PDocAccessibleChild*> aChildDoc,
        const uint64_t& aID) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_BindChildDoc(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aChildDoc);
    // Sentinel = 'aChildDoc'
    ((&(writer__)))->WriteSentinel(277939036);
    IPC::WriteParam((&(writer__)), aID);
    // Sentinel = 'aID'
    ((&(writer__)))->WriteSentinel(33292527);


    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_BindChildDoc", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleChild::SendCache(
        const CacheUpdateType& aUpdateType,
        mozilla::Span<CacheData const> aData) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_Cache(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aUpdateType);
    // Sentinel = 'aUpdateType'
    ((&(writer__)))->WriteSentinel(435160167);
    IPC::WriteParam((&(writer__)), aData);
    // Sentinel = 'aData'
    ((&(writer__)))->WriteSentinel(90571228);


    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_Cache", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleChild::SendSelectedAccessiblesChanged(
        mozilla::Span<uint64_t const> aSelectedIDs,
        mozilla::Span<uint64_t const> aUnselectedIDs) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_SelectedAccessiblesChanged(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aSelectedIDs);
    // Sentinel = 'aSelectedIDs'
    ((&(writer__)))->WriteSentinel(500892811);
    IPC::WriteParam((&(writer__)), aUnselectedIDs);
    // Sentinel = 'aUnselectedIDs'
    ((&(writer__)))->WriteSentinel(695731566);


    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_SelectedAccessiblesChanged", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleChild::SendAccessiblesWillMove(mozilla::Span<uint64_t const> aIDs) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDocAccessible::Msg_AccessiblesWillMove(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aIDs);
    // Sentinel = 'aIDs'
    ((&(writer__)))->WriteSentinel(56492386);


    if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDocAccessibleChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDocAccessible::Msg_AccessiblesWillMove", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDocAccessibleChild::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PDocAccessibleChild::OnMessageReceived(const Message& msg__) -> PDocAccessibleChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PDocAccessible::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    case PDocAccessible::Msg_RestoreFocus__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_RestoreFocus", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvRestoreFocus();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_ScrollTo__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_ScrollTo", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aID = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aID) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aID = *maybe__aID;
            // Sentinel = 'aID'
            if ((!(((&(reader__)))->ReadSentinel(33292527)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aScrollType = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aScrollType) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aScrollType = *maybe__aScrollType;
            // Sentinel = 'aScrollType'
            if ((!(((&(reader__)))->ReadSentinel(439092339)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvScrollTo(std::move(aID), std::move(aScrollType));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_ScrollToPoint__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_ScrollToPoint", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aID = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aID) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aID = *maybe__aID;
            // Sentinel = 'aID'
            if ((!(((&(reader__)))->ReadSentinel(33292527)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aScrollType = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aScrollType) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aScrollType = *maybe__aScrollType;
            // Sentinel = 'aScrollType'
            if ((!(((&(reader__)))->ReadSentinel(439092339)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aX = IPC::ReadParam<int32_t>((&(reader__)));
            if (!maybe__aX) {
                FatalError("Error deserializing 'int32_t'");
                return MsgValueError;

            }
            auto& aX = *maybe__aX;
            // Sentinel = 'aX'
            if ((!(((&(reader__)))->ReadSentinel(18612410)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
                return MsgValueError;
            }
            auto maybe__aY = IPC::ReadParam<int32_t>((&(reader__)));
            if (!maybe__aY) {
                FatalError("Error deserializing 'int32_t'");
                return MsgValueError;

            }
            auto& aY = *maybe__aY;
            // Sentinel = 'aY'
            if ((!(((&(reader__)))->ReadSentinel(18677947)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvScrollToPoint(std::move(aID), std::move(aScrollType), std::move(aX), std::move(aY));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_Announce__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_Announce", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aID = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aID) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aID = *maybe__aID;
            // Sentinel = 'aID'
            if ((!(((&(reader__)))->ReadSentinel(33292527)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aAnnouncement = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__aAnnouncement) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& aAnnouncement = *maybe__aAnnouncement;
            // Sentinel = 'aAnnouncement'
            if ((!(((&(reader__)))->ReadSentinel(605750605)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            auto maybe__aPriority = IPC::ReadParam<uint16_t>((&(reader__)));
            if (!maybe__aPriority) {
                FatalError("Error deserializing 'uint16_t'");
                return MsgValueError;

            }
            auto& aPriority = *maybe__aPriority;
            // Sentinel = 'aPriority'
            if ((!(((&(reader__)))->ReadSentinel(303367108)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint16_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvAnnounce(std::move(aID), std::move(aAnnouncement), std::move(aPriority));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_SetTextSelection__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_SetTextSelection", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aStartID = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aStartID) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aStartID = *maybe__aStartID;
            // Sentinel = 'aStartID'
            if ((!(((&(reader__)))->ReadSentinel(233571069)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aStartOffset = IPC::ReadParam<int32_t>((&(reader__)));
            if (!maybe__aStartOffset) {
                FatalError("Error deserializing 'int32_t'");
                return MsgValueError;

            }
            auto& aStartOffset = *maybe__aStartOffset;
            // Sentinel = 'aStartOffset'
            if ((!(((&(reader__)))->ReadSentinel(517801175)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
                return MsgValueError;
            }
            auto maybe__aEndID = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aEndID) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aEndID = *maybe__aEndID;
            // Sentinel = 'aEndID'
            if ((!(((&(reader__)))->ReadSentinel(123666950)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aEndOffset = IPC::ReadParam<int32_t>((&(reader__)));
            if (!maybe__aEndOffset) {
                FatalError("Error deserializing 'int32_t'");
                return MsgValueError;

            }
            auto& aEndOffset = *maybe__aEndOffset;
            // Sentinel = 'aEndOffset'
            if ((!(((&(reader__)))->ReadSentinel(343147488)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
                return MsgValueError;
            }
            auto maybe__aSelectionNum = IPC::ReadParam<int32_t>((&(reader__)));
            if (!maybe__aSelectionNum) {
                FatalError("Error deserializing 'int32_t'");
                return MsgValueError;

            }
            auto& aSelectionNum = *maybe__aSelectionNum;
            // Sentinel = 'aSelectionNum'
            if ((!(((&(reader__)))->ReadSentinel(601359672)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
                return MsgValueError;
            }
            auto maybe__aSetFocus = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__aSetFocus) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& aSetFocus = *maybe__aSetFocus;
            // Sentinel = 'aSetFocus'
            if ((!(((&(reader__)))->ReadSentinel(287638414)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvSetTextSelection(std::move(aStartID), std::move(aStartOffset), std::move(aEndID), std::move(aEndOffset), std::move(aSelectionNum), std::move(aSetFocus));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_RemoveTextSelection__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_RemoveTextSelection", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aID = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aID) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aID = *maybe__aID;
            // Sentinel = 'aID'
            if ((!(((&(reader__)))->ReadSentinel(33292527)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aSelectionNum = IPC::ReadParam<int32_t>((&(reader__)));
            if (!maybe__aSelectionNum) {
                FatalError("Error deserializing 'int32_t'");
                return MsgValueError;

            }
            auto& aSelectionNum = *maybe__aSelectionNum;
            // Sentinel = 'aSelectionNum'
            if ((!(((&(reader__)))->ReadSentinel(601359672)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvRemoveTextSelection(std::move(aID), std::move(aSelectionNum));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_ScrollTextLeafRangeIntoView__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_ScrollTextLeafRangeIntoView", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aStartID = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aStartID) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aStartID = *maybe__aStartID;
            // Sentinel = 'aStartID'
            if ((!(((&(reader__)))->ReadSentinel(233571069)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aStartOffset = IPC::ReadParam<int32_t>((&(reader__)));
            if (!maybe__aStartOffset) {
                FatalError("Error deserializing 'int32_t'");
                return MsgValueError;

            }
            auto& aStartOffset = *maybe__aStartOffset;
            // Sentinel = 'aStartOffset'
            if ((!(((&(reader__)))->ReadSentinel(517801175)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
                return MsgValueError;
            }
            auto maybe__aEndID = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aEndID) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aEndID = *maybe__aEndID;
            // Sentinel = 'aEndID'
            if ((!(((&(reader__)))->ReadSentinel(123666950)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aEndOffset = IPC::ReadParam<int32_t>((&(reader__)));
            if (!maybe__aEndOffset) {
                FatalError("Error deserializing 'int32_t'");
                return MsgValueError;

            }
            auto& aEndOffset = *maybe__aEndOffset;
            // Sentinel = 'aEndOffset'
            if ((!(((&(reader__)))->ReadSentinel(343147488)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
                return MsgValueError;
            }
            auto maybe__aScrollType = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aScrollType) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aScrollType = *maybe__aScrollType;
            // Sentinel = 'aScrollType'
            if ((!(((&(reader__)))->ReadSentinel(439092339)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvScrollTextLeafRangeIntoView(std::move(aStartID), std::move(aStartOffset), std::move(aEndID), std::move(aEndOffset), std::move(aScrollType));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_ScrollSubstringToPoint__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_ScrollSubstringToPoint", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aID = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aID) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aID = *maybe__aID;
            // Sentinel = 'aID'
            if ((!(((&(reader__)))->ReadSentinel(33292527)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aStartOffset = IPC::ReadParam<int32_t>((&(reader__)));
            if (!maybe__aStartOffset) {
                FatalError("Error deserializing 'int32_t'");
                return MsgValueError;

            }
            auto& aStartOffset = *maybe__aStartOffset;
            // Sentinel = 'aStartOffset'
            if ((!(((&(reader__)))->ReadSentinel(517801175)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
                return MsgValueError;
            }
            auto maybe__aEndOffset = IPC::ReadParam<int32_t>((&(reader__)));
            if (!maybe__aEndOffset) {
                FatalError("Error deserializing 'int32_t'");
                return MsgValueError;

            }
            auto& aEndOffset = *maybe__aEndOffset;
            // Sentinel = 'aEndOffset'
            if ((!(((&(reader__)))->ReadSentinel(343147488)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
                return MsgValueError;
            }
            auto maybe__aCoordinateType = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aCoordinateType) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aCoordinateType = *maybe__aCoordinateType;
            // Sentinel = 'aCoordinateType'
            if ((!(((&(reader__)))->ReadSentinel(797312524)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aX = IPC::ReadParam<int32_t>((&(reader__)));
            if (!maybe__aX) {
                FatalError("Error deserializing 'int32_t'");
                return MsgValueError;

            }
            auto& aX = *maybe__aX;
            // Sentinel = 'aX'
            if ((!(((&(reader__)))->ReadSentinel(18612410)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
                return MsgValueError;
            }
            auto maybe__aY = IPC::ReadParam<int32_t>((&(reader__)));
            if (!maybe__aY) {
                FatalError("Error deserializing 'int32_t'");
                return MsgValueError;

            }
            auto& aY = *maybe__aY;
            // Sentinel = 'aY'
            if ((!(((&(reader__)))->ReadSentinel(18677947)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvScrollSubstringToPoint(std::move(aID), std::move(aStartOffset), std::move(aEndOffset), std::move(aCoordinateType), std::move(aX), std::move(aY));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_ReplaceText__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_ReplaceText", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aID = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aID) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aID = *maybe__aID;
            // Sentinel = 'aID'
            if ((!(((&(reader__)))->ReadSentinel(33292527)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aText = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__aText) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& aText = *maybe__aText;
            // Sentinel = 'aText'
            if ((!(((&(reader__)))->ReadSentinel(97321479)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvReplaceText(std::move(aID), std::move(aText));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_InsertText__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_InsertText", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aID = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aID) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aID = *maybe__aID;
            // Sentinel = 'aID'
            if ((!(((&(reader__)))->ReadSentinel(33292527)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aText = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__aText) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& aText = *maybe__aText;
            // Sentinel = 'aText'
            if ((!(((&(reader__)))->ReadSentinel(97321479)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            auto maybe__aPosition = IPC::ReadParam<int32_t>((&(reader__)));
            if (!maybe__aPosition) {
                FatalError("Error deserializing 'int32_t'");
                return MsgValueError;

            }
            auto& aPosition = *maybe__aPosition;
            // Sentinel = 'aPosition'
            if ((!(((&(reader__)))->ReadSentinel(303104951)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvInsertText(std::move(aID), std::move(aText), std::move(aPosition));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_CopyText__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_CopyText", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aID = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aID) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aID = *maybe__aID;
            // Sentinel = 'aID'
            if ((!(((&(reader__)))->ReadSentinel(33292527)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aStartPos = IPC::ReadParam<int32_t>((&(reader__)));
            if (!maybe__aStartPos) {
                FatalError("Error deserializing 'int32_t'");
                return MsgValueError;

            }
            auto& aStartPos = *maybe__aStartPos;
            // Sentinel = 'aStartPos'
            if ((!(((&(reader__)))->ReadSentinel(298255266)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
                return MsgValueError;
            }
            auto maybe__aEndPos = IPC::ReadParam<int32_t>((&(reader__)));
            if (!maybe__aEndPos) {
                FatalError("Error deserializing 'int32_t'");
                return MsgValueError;

            }
            auto& aEndPos = *maybe__aEndPos;
            // Sentinel = 'aEndPos'
            if ((!(((&(reader__)))->ReadSentinel(172163755)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvCopyText(std::move(aID), std::move(aStartPos), std::move(aEndPos));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_CutText__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_CutText", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aID = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aID) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aID = *maybe__aID;
            // Sentinel = 'aID'
            if ((!(((&(reader__)))->ReadSentinel(33292527)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aStartPos = IPC::ReadParam<int32_t>((&(reader__)));
            if (!maybe__aStartPos) {
                FatalError("Error deserializing 'int32_t'");
                return MsgValueError;

            }
            auto& aStartPos = *maybe__aStartPos;
            // Sentinel = 'aStartPos'
            if ((!(((&(reader__)))->ReadSentinel(298255266)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
                return MsgValueError;
            }
            auto maybe__aEndPos = IPC::ReadParam<int32_t>((&(reader__)));
            if (!maybe__aEndPos) {
                FatalError("Error deserializing 'int32_t'");
                return MsgValueError;

            }
            auto& aEndPos = *maybe__aEndPos;
            // Sentinel = 'aEndPos'
            if ((!(((&(reader__)))->ReadSentinel(172163755)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvCutText(std::move(aID), std::move(aStartPos), std::move(aEndPos));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_DeleteText__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_DeleteText", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aID = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aID) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aID = *maybe__aID;
            // Sentinel = 'aID'
            if ((!(((&(reader__)))->ReadSentinel(33292527)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aStartPos = IPC::ReadParam<int32_t>((&(reader__)));
            if (!maybe__aStartPos) {
                FatalError("Error deserializing 'int32_t'");
                return MsgValueError;

            }
            auto& aStartPos = *maybe__aStartPos;
            // Sentinel = 'aStartPos'
            if ((!(((&(reader__)))->ReadSentinel(298255266)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
                return MsgValueError;
            }
            auto maybe__aEndPos = IPC::ReadParam<int32_t>((&(reader__)));
            if (!maybe__aEndPos) {
                FatalError("Error deserializing 'int32_t'");
                return MsgValueError;

            }
            auto& aEndPos = *maybe__aEndPos;
            // Sentinel = 'aEndPos'
            if ((!(((&(reader__)))->ReadSentinel(172163755)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvDeleteText(std::move(aID), std::move(aStartPos), std::move(aEndPos));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_PasteText__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_PasteText", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aID = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aID) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aID = *maybe__aID;
            // Sentinel = 'aID'
            if ((!(((&(reader__)))->ReadSentinel(33292527)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aPosition = IPC::ReadParam<int32_t>((&(reader__)));
            if (!maybe__aPosition) {
                FatalError("Error deserializing 'int32_t'");
                return MsgValueError;

            }
            auto& aPosition = *maybe__aPosition;
            // Sentinel = 'aPosition'
            if ((!(((&(reader__)))->ReadSentinel(303104951)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvPasteText(std::move(aID), std::move(aPosition));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_TakeSelection__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_TakeSelection", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aID = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aID) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aID = *maybe__aID;
            // Sentinel = 'aID'
            if ((!(((&(reader__)))->ReadSentinel(33292527)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvTakeSelection(std::move(aID));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_SetSelected__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_SetSelected", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aID = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aID) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aID = *maybe__aID;
            // Sentinel = 'aID'
            if ((!(((&(reader__)))->ReadSentinel(33292527)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aSelected = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__aSelected) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& aSelected = *maybe__aSelected;
            // Sentinel = 'aSelected'
            if ((!(((&(reader__)))->ReadSentinel(291767179)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvSetSelected(std::move(aID), std::move(aSelected));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_DoActionAsync__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_DoActionAsync", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aID = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aID) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aID = *maybe__aID;
            // Sentinel = 'aID'
            if ((!(((&(reader__)))->ReadSentinel(33292527)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aIndex = IPC::ReadParam<uint8_t>((&(reader__)));
            if (!maybe__aIndex) {
                FatalError("Error deserializing 'uint8_t'");
                return MsgValueError;

            }
            auto& aIndex = *maybe__aIndex;
            // Sentinel = 'aIndex'
            if ((!(((&(reader__)))->ReadSentinel(132055642)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint8_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvDoActionAsync(std::move(aID), std::move(aIndex));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_SetCurValue__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_SetCurValue", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aID = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aID) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aID = *maybe__aID;
            // Sentinel = 'aID'
            if ((!(((&(reader__)))->ReadSentinel(33292527)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aValue = IPC::ReadParam<double>((&(reader__)));
            if (!maybe__aValue) {
                FatalError("Error deserializing 'double'");
                return MsgValueError;

            }
            auto& aValue = *maybe__aValue;
            // Sentinel = 'aValue'
            if ((!(((&(reader__)))->ReadSentinel(135332447)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'double'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvSetCurValue(std::move(aID), std::move(aValue));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_TakeFocus__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_TakeFocus", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aID = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aID) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aID = *maybe__aID;
            // Sentinel = 'aID'
            if ((!(((&(reader__)))->ReadSentinel(33292527)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvTakeFocus(std::move(aID));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_VerifyCache__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_VerifyCache", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aID = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aID) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aID = *maybe__aID;
            // Sentinel = 'aID'
            if ((!(((&(reader__)))->ReadSentinel(33292527)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aCacheDomain = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aCacheDomain) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aCacheDomain = *maybe__aCacheDomain;
            // Sentinel = 'aCacheDomain'
            if ((!(((&(reader__)))->ReadSentinel(479921294)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aFields = IPC::ReadParam<RefPtr<AccAttributes>>((&(reader__)));
            if (!maybe__aFields) {
                FatalError("Error deserializing 'AccAttributes'");
                return MsgValueError;

            }
            auto& aFields = *maybe__aFields;
            // Sentinel = 'aFields'
            if ((!(((&(reader__)))->ReadSentinel(175243961)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'AccAttributes'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvVerifyCache(std::move(aID), std::move(aCacheDomain), aFields);
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDocAccessible::Msg_AckMutationEvents__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDocAccessible", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDocAccessibleChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDocAccessible::Msg_AckMutationEvents", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvAckMutationEvents();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PDocAccessibleChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PDocAccessibleChild::Result
{
    return MsgNotKnown;
}



} // namespace a11y
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::a11y::PDocAccessibleChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PDocAccessible'
    (aWriter)->WriteSentinel(640615765);
}

auto ParamTraits<::mozilla::a11y::PDocAccessibleChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PDocAccessible actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PDocAccessible'
    if ((!((aReader)->ReadSentinel(640615765)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PDocAccessible actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PDocAccessibleMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PDocAccessible)");

        return {};
    }
    return static_cast<::mozilla::a11y::PDocAccessibleChild*>(actor);
}

} // namespace IPC
