
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "tabicon_data_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_TabIcon_Data_Type = nullptr;
static PyTypeObject *Sbk_TabIcon_Data_TypeF(void)
{
    return _Sbk_TabIcon_Data_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_TabIcon_Data_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::TabIcon::Data >()))
        return -1;

    ::TabIcon::Data *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "Data", 0, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: Data::Data()
    // 1: Data::Data(TabIcon::Data)
    if (numArgs == 0) {
        overloadId = 0; // Data()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabIcon_Data_IDX]), (pyArgs[0])))) {
        overloadId = 1; // Data(TabIcon::Data)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_TabIcon_Data_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_TabIcon_Data_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // Data()
        {

            // Data()
            cptr = new ::TabIcon::Data();
            break;
        }
        case 1: // Data(const TabIcon::Data &Data)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::TabIcon::Data cppArg0_local;
            ::TabIcon::Data *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // Data(TabIcon::Data)
                cptr = new ::TabIcon::Data(*cppArg0);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::TabIcon::Data >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_TabIcon_Data_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_TabIcon_Data__copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::TabIcon::Data *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabIcon_Data_IDX]), reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabIcon_Data_IDX]), &cppSelf);
    if (Shiboken::Errors::occurred() != nullptr || pyResult == nullptr) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_TabIcon_Data_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_TabIcon_Data_methods[] = {
    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_TabIcon_Data__copy__), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static PyObject *Sbk_TabIcon_Data_get_framesCount(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::TabIcon::Data *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabIcon_Data_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->framesCount;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
}
static int Sbk_TabIcon_Data_set_framesCount(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::TabIcon::Data *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabIcon_Data_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("framesCount");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("framesCount", "int");
        return -1;
    }

    auto cppOut_local = cppSelf->framesCount;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->framesCount = cppOut_local;

    return 0;
}

static PyObject *Sbk_TabIcon_Data_get_animationInterval(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::TabIcon::Data *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabIcon_Data_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->animationInterval;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
}
static int Sbk_TabIcon_Data_set_animationInterval(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::TabIcon::Data *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabIcon_Data_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("animationInterval");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("animationInterval", "int");
        return -1;
    }

    auto cppOut_local = cppSelf->animationInterval;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->animationInterval = cppOut_local;

    return 0;
}

static PyObject *Sbk_TabIcon_Data_get_animationPixmap(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::TabIcon::Data *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabIcon_Data_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    auto *fieldTypeObject = Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]);
    if (auto *sbkOut = Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->animationPixmap), fieldTypeObject)) {
        pyOut = reinterpret_cast<PyObject *>(sbkOut);
        Py_INCREF(pyOut);
    } else {
        pyOut = Shiboken::Object::newObject(fieldTypeObject, &(cppSelf->animationPixmap), false, true);
        Shiboken::Object::setParent(self, pyOut);
    }
    return pyOut;
}
static int Sbk_TabIcon_Data_set_animationPixmap(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::TabIcon::Data *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabIcon_Data_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("animationPixmap");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("animationPixmap", "QPixmap");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->animationPixmap;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_TabIcon_Data_get_audioPlayingPixmap(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::TabIcon::Data *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabIcon_Data_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    auto *fieldTypeObject = Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]);
    if (auto *sbkOut = Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->audioPlayingPixmap), fieldTypeObject)) {
        pyOut = reinterpret_cast<PyObject *>(sbkOut);
        Py_INCREF(pyOut);
    } else {
        pyOut = Shiboken::Object::newObject(fieldTypeObject, &(cppSelf->audioPlayingPixmap), false, true);
        Shiboken::Object::setParent(self, pyOut);
    }
    return pyOut;
}
static int Sbk_TabIcon_Data_set_audioPlayingPixmap(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::TabIcon::Data *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabIcon_Data_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("audioPlayingPixmap");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("audioPlayingPixmap", "QPixmap");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->audioPlayingPixmap;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_TabIcon_Data_get_audioMutedPixmap(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::TabIcon::Data *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabIcon_Data_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    auto *fieldTypeObject = Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]);
    if (auto *sbkOut = Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->audioMutedPixmap), fieldTypeObject)) {
        pyOut = reinterpret_cast<PyObject *>(sbkOut);
        Py_INCREF(pyOut);
    } else {
        pyOut = Shiboken::Object::newObject(fieldTypeObject, &(cppSelf->audioMutedPixmap), false, true);
        Shiboken::Object::setParent(self, pyOut);
    }
    return pyOut;
}
static int Sbk_TabIcon_Data_set_audioMutedPixmap(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::TabIcon::Data *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabIcon_Data_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("audioMutedPixmap");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("audioMutedPixmap", "QPixmap");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->audioMutedPixmap;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

// Getters and Setters for Data
static PyGetSetDef Sbk_TabIcon_Data_getsetlist[] = {
    {const_cast<char *>("framesCount"), Sbk_TabIcon_Data_get_framesCount, Sbk_TabIcon_Data_set_framesCount, nullptr, nullptr},
    {const_cast<char *>("animationInterval"), Sbk_TabIcon_Data_get_animationInterval, Sbk_TabIcon_Data_set_animationInterval, nullptr, nullptr},
    {const_cast<char *>("animationPixmap"), Sbk_TabIcon_Data_get_animationPixmap, Sbk_TabIcon_Data_set_animationPixmap, nullptr, nullptr},
    {const_cast<char *>("audioPlayingPixmap"), Sbk_TabIcon_Data_get_audioPlayingPixmap, Sbk_TabIcon_Data_set_audioPlayingPixmap, nullptr, nullptr},
    {const_cast<char *>("audioMutedPixmap"), Sbk_TabIcon_Data_get_audioMutedPixmap, Sbk_TabIcon_Data_set_audioMutedPixmap, nullptr, nullptr},
    {nullptr, nullptr, nullptr, nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_TabIcon_Data_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_TabIcon_Data_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_TabIcon_Data_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_TabIcon_Data_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_TabIcon_Data_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_TabIcon_Data_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_TabIcon_Data_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_TabIcon_Data_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_TabIcon_Data_spec = {
    "1:PyFalkon.TabIcon.Data",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_TabIcon_Data_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void Data_PythonToCpp_Data_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_TabIcon_Data_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_Data_PythonToCpp_Data_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_TabIcon_Data_TypeF()))
        return Data_PythonToCpp_Data_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *Data_PTR_CppToPython_Data(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_TabIcon_Data_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_TabIcon_Data_TypeF(), const_cast<void *>(cppIn), false);

}

// C++ to Python copy conversion.
static PyObject *Data_COPY_CppToPython_Data(const void *cppIn)
{
    auto *source = reinterpret_cast<const ::TabIcon::Data *>(cppIn);
    return Shiboken::Object::newObject(Sbk_TabIcon_Data_TypeF(), new ::TabIcon::Data(*source), true, true);
}

// Python to C++ copy conversion.
static void Data_PythonToCpp_Data_COPY(PyObject *pyIn, void *cppOut)
{
    *reinterpret_cast<::TabIcon::Data *>(cppOut) = *reinterpret_cast< ::TabIcon::Data *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabIcon_Data_IDX]), reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_Data_PythonToCpp_Data_COPY_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Sbk_TabIcon_Data_TypeF()))
        return Data_PythonToCpp_Data_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *TabIcon_Data_SignatureStrings[] = {
    "1:PyFalkon.TabIcon.Data(self)",
    "0:PyFalkon.TabIcon.Data(self,Data:PyFalkon.TabIcon.Data)",
    "PyFalkon.TabIcon.Data.__copy__(self)->typing._Self",
    nullptr}; // Sentinel
#else
static constexpr size_t TabIcon_Data_SignatureByteSize = 73;
static constexpr uint8_t TabIcon_Data_SignatureBytes[73] = {
    0x78, 0xda, 0x33, 0xb4, 0x0a, 0xa8, 0x74, 0x4b, 0xcc, 0xc9, 0xce, 0xcf, 0xd3, 0x0b, 0x49, 0x4c,
    0xf2, 0x4c, 0x06, 0xd2, 0x2e, 0x89, 0x25, 0x89, 0x1a, 0xc5, 0xa9, 0x39, 0x69, 0x9a, 0x5c, 0x06,
    0x78, 0x64, 0x75, 0x40, 0x2c, 0xec, 0xf2, 0x9a, 0x5c, 0x58, 0x85, 0xf5, 0xe2, 0xe3, 0x93, 0xf3,
    0x0b, 0x2a, 0xe3, 0xe3, 0x21, 0xa6, 0xeb, 0xda, 0x95, 0x54, 0x16, 0x64, 0xe6, 0xa5, 0xeb, 0xc5,
    0x07, 0x03, 0xb9, 0x5c, 0x00, 0xdb, 0x4f, 0x2f, 0xaf
};
#endif

PyTypeObject *init_TabIcon_Data(PyObject *enclosingClass)
{
    if (SbkPyFalkonTypeStructs[SBK_TabIcon_Data_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_TabIcon_Data_IDX].type;

    Shiboken::AutoDecRef Sbk_TabIcon_Data_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_TabIcon_Data_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "Data",
        "TabIcon::Data",
        &Sbk_TabIcon_Data_spec,
        &Shiboken::callCppDestructor< ::TabIcon::Data >,
        Sbk_TabIcon_Data_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::InnerClass | Shiboken::ObjectType::WrapperFlags::Value);
    auto *pyType = Sbk_TabIcon_Data_TypeF(); // references _Sbk_TabIcon_Data_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, TabIcon_Data_SignatureStrings);
#else
    InitSignatureBytes(pyType, TabIcon_Data_SignatureBytes, TabIcon_Data_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_TabIcon_Data_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_TabIcon_Data_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        Data_PythonToCpp_Data_PTR,
        is_Data_PythonToCpp_Data_PTR_Convertible,
        Data_PTR_CppToPython_Data,
        Data_COPY_CppToPython_Data);

    Shiboken::Conversions::registerConverterName(converter, "TabIcon::Data");
    Shiboken::Conversions::registerConverterName(converter, "TabIcon::Data*");
    Shiboken::Conversions::registerConverterName(converter, "TabIcon::Data&");
    Shiboken::Conversions::registerConverterAlias(converter, "Data");
    Shiboken::Conversions::registerConverterAlias(converter, "Data*");
    Shiboken::Conversions::registerConverterAlias(converter, "Data&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::TabIcon::Data).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        Data_PythonToCpp_Data_COPY,
        is_Data_PythonToCpp_Data_COPY_Convertible);

    qRegisterMetaType< ::TabIcon::Data >("Data");
    qRegisterMetaType< ::TabIcon::Data >("TabIcon::Data");

    return pyType;
}
