
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "sitesettingsmanager_sitesettings_wrapper.h"

// Argument includes
#include <sitesettingsmanager.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_SiteSettingsManager_SiteSettings_Type = nullptr;
static PyTypeObject *Sbk_SiteSettingsManager_SiteSettings_TypeF(void)
{
    return _Sbk_SiteSettingsManager_SiteSettings_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_SiteSettingsManager_SiteSettings_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::SiteSettingsManager::SiteSettings >()))
        return -1;

    ::SiteSettingsManager::SiteSettings *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "SiteSettings", 0, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: SiteSettings::SiteSettings()
    // 1: SiteSettings::SiteSettings(SiteSettingsManager::SiteSettings)
    if (numArgs == 0) {
        overloadId = 0; // SiteSettings()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_SiteSettings_IDX]), (pyArgs[0])))) {
        overloadId = 1; // SiteSettings(SiteSettingsManager::SiteSettings)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_SiteSettings_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_SiteSettings_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // SiteSettings()
        {

            // SiteSettings()
            cptr = new ::SiteSettingsManager::SiteSettings();
            break;
        }
        case 1: // SiteSettings(const SiteSettingsManager::SiteSettings &SiteSettings)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::SiteSettingsManager::SiteSettings cppArg0_local;
            ::SiteSettingsManager::SiteSettings *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // SiteSettings(SiteSettingsManager::SiteSettings)
                cptr = new ::SiteSettingsManager::SiteSettings(*cppArg0);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::SiteSettingsManager::SiteSettings >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_SiteSettings_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_SiteSettingsManager_SiteSettings__copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::SiteSettingsManager::SiteSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_SiteSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_SiteSettings_IDX]), &cppSelf);
    if (Shiboken::Errors::occurred() != nullptr || pyResult == nullptr) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_SiteSettingsManager_SiteSettings_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_SiteSettingsManager_SiteSettings_methods[] = {
    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_SiteSettingsManager_SiteSettings__copy__), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_SiteSettingsManager_SiteSettings_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::SiteSettingsManager::SiteSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_SiteSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_SiteSettings_IDX]), (pyArg)))) {
                // operator==(const SiteSettingsManager::SiteSettings &other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::SiteSettingsManager::SiteSettings cppArg0_local;
                ::SiteSettingsManager::SiteSettings *cppArg0 = &cppArg0_local;
                if (pythonToCpp.isValue())
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf == (*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
    }

    return Shiboken::returnFromRichCompare(pyResult);
}

static PyObject *Sbk_SiteSettingsManager_SiteSettings_get_AllowCookies(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::SiteSettingsManager::SiteSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_SiteSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::SiteSettingsManager::Permission cppOut_local = cppSelf->AllowCookies;
    return Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_Permission_IDX])))->converter, &cppOut_local);
}
static int Sbk_SiteSettingsManager_SiteSettings_set_AllowCookies(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::SiteSettingsManager::SiteSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_SiteSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("AllowCookies");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_Permission_IDX])))->converter, (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("AllowCookies", "Permission");
        return -1;
    }

    auto cppOut_local = cppSelf->AllowCookies;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->AllowCookies = cppOut_local;

    return 0;
}

static PyObject *Sbk_SiteSettingsManager_SiteSettings_get_ZoomLevel(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::SiteSettingsManager::SiteSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_SiteSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->ZoomLevel;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
}
static int Sbk_SiteSettingsManager_SiteSettings_set_ZoomLevel(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::SiteSettingsManager::SiteSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_SiteSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("ZoomLevel");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("ZoomLevel", "int");
        return -1;
    }

    auto cppOut_local = cppSelf->ZoomLevel;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->ZoomLevel = cppOut_local;

    return 0;
}

static PyObject *Sbk_SiteSettingsManager_SiteSettings_get_attributes(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::SiteSettingsManager::SiteSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_SiteSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PyFalkon_QMap_QWebEngineSettings_WebAttribute_SiteSettingsManager_Permission_IDX], &cppSelf->attributes);
}
static int Sbk_SiteSettingsManager_SiteSettings_set_attributes(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::SiteSettingsManager::SiteSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_SiteSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("attributes");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QMap_QWebEngineSettings_WebAttribute_SiteSettingsManager_Permission_IDX], (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("attributes", "QMap");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->attributes;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_SiteSettingsManager_SiteSettings_get_features(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::SiteSettingsManager::SiteSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_SiteSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PyFalkon_QMap_QWebEnginePage_Feature_SiteSettingsManager_Permission_IDX], &cppSelf->features);
}
static int Sbk_SiteSettingsManager_SiteSettings_set_features(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::SiteSettingsManager::SiteSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_SiteSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("features");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QMap_QWebEnginePage_Feature_SiteSettingsManager_Permission_IDX], (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("features", "QMap");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->features;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_SiteSettingsManager_SiteSettings_get_server(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::SiteSettingsManager::SiteSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_SiteSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppSelf->server);
}
static int Sbk_SiteSettingsManager_SiteSettings_set_server(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::SiteSettingsManager::SiteSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_SiteSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("server");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("server", "QString");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->server;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

// Getters and Setters for SiteSettings
static PyGetSetDef Sbk_SiteSettingsManager_SiteSettings_getsetlist[] = {
    {const_cast<char *>("AllowCookies"), Sbk_SiteSettingsManager_SiteSettings_get_AllowCookies, Sbk_SiteSettingsManager_SiteSettings_set_AllowCookies, nullptr, nullptr},
    {const_cast<char *>("ZoomLevel"), Sbk_SiteSettingsManager_SiteSettings_get_ZoomLevel, Sbk_SiteSettingsManager_SiteSettings_set_ZoomLevel, nullptr, nullptr},
    {const_cast<char *>("attributes"), Sbk_SiteSettingsManager_SiteSettings_get_attributes, Sbk_SiteSettingsManager_SiteSettings_set_attributes, nullptr, nullptr},
    {const_cast<char *>("features"), Sbk_SiteSettingsManager_SiteSettings_get_features, Sbk_SiteSettingsManager_SiteSettings_set_features, nullptr, nullptr},
    {const_cast<char *>("server"), Sbk_SiteSettingsManager_SiteSettings_get_server, Sbk_SiteSettingsManager_SiteSettings_set_server, nullptr, nullptr},
    {nullptr, nullptr, nullptr, nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_SiteSettingsManager_SiteSettings_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_SiteSettingsManager_SiteSettings_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_SiteSettingsManager_SiteSettings_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_SiteSettingsManager_SiteSettings_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_SiteSettingsManager_SiteSettings_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_SiteSettingsManager_SiteSettings_richcompare)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_SiteSettingsManager_SiteSettings_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_SiteSettingsManager_SiteSettings_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_SiteSettingsManager_SiteSettings_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_SiteSettingsManager_SiteSettings_spec = {
    "1:PyFalkon.SiteSettingsManager.SiteSettings",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_SiteSettingsManager_SiteSettings_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void SiteSettings_PythonToCpp_SiteSettings_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_SiteSettingsManager_SiteSettings_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_SiteSettings_PythonToCpp_SiteSettings_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_SiteSettingsManager_SiteSettings_TypeF()))
        return SiteSettings_PythonToCpp_SiteSettings_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *SiteSettings_PTR_CppToPython_SiteSettings(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_SiteSettingsManager_SiteSettings_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_SiteSettingsManager_SiteSettings_TypeF(), const_cast<void *>(cppIn), false);

}

// C++ to Python copy conversion.
static PyObject *SiteSettings_COPY_CppToPython_SiteSettings(const void *cppIn)
{
    auto *source = reinterpret_cast<const ::SiteSettingsManager::SiteSettings *>(cppIn);
    return Shiboken::Object::newObject(Sbk_SiteSettingsManager_SiteSettings_TypeF(), new ::SiteSettingsManager::SiteSettings(*source), true, true);
}

// Python to C++ copy conversion.
static void SiteSettings_PythonToCpp_SiteSettings_COPY(PyObject *pyIn, void *cppOut)
{
    *reinterpret_cast<::SiteSettingsManager::SiteSettings *>(cppOut) = *reinterpret_cast< ::SiteSettingsManager::SiteSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_SiteSettings_IDX]), reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_SiteSettings_PythonToCpp_SiteSettings_COPY_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Sbk_SiteSettingsManager_SiteSettings_TypeF()))
        return SiteSettings_PythonToCpp_SiteSettings_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *SiteSettingsManager_SiteSettings_SignatureStrings[] = {
    "1:PyFalkon.SiteSettingsManager.SiteSettings(self)",
    "0:PyFalkon.SiteSettingsManager.SiteSettings(self,SiteSettings:PyFalkon.SiteSettingsManager.SiteSettings)",
    "PyFalkon.SiteSettingsManager.SiteSettings.__copy__(self)->typing._Self",
    "PyFalkon.SiteSettingsManager.SiteSettings.__eq__(self,other:PyFalkon.SiteSettingsManager.SiteSettings)->bool",
    nullptr}; // Sentinel
#else
static constexpr size_t SiteSettingsManager_SiteSettings_SignatureByteSize = 105;
static constexpr uint8_t SiteSettingsManager_SiteSettings_SignatureBytes[105] = {
    0x78, 0xda, 0x33, 0xb4, 0x0a, 0xa8, 0x74, 0x4b, 0xcc, 0xc9, 0xce, 0xcf, 0xd3, 0x0b, 0xce, 0x2c,
    0x49, 0x0d, 0x4e, 0x2d, 0x29, 0xc9, 0xcc, 0x4b, 0x2f, 0xf6, 0x4d, 0xcc, 0x4b, 0x4c, 0x4f, 0x2d,
    0x42, 0x11, 0xd3, 0x28, 0x4e, 0xcd, 0x49, 0xd3, 0xe4, 0x32, 0x20, 0x51, 0x87, 0x0e, 0xb2, 0x08,
    0xf1, 0x7a, 0x35, 0xb9, 0x88, 0x56, 0xaa, 0x17, 0x1f, 0x9f, 0x9c, 0x5f, 0x50, 0x19, 0x1f, 0x0f,
    0x71, 0xa1, 0xae, 0x5d, 0x49, 0x65, 0x01, 0x50, 0x5c, 0x2f, 0x3e, 0x18, 0xc8, 0x25, 0xc9, 0x98,
    0xd4, 0x42, 0xa8, 0x21, 0x3a, 0xf9, 0x25, 0x19, 0xa9, 0x45, 0x24, 0xb8, 0x56, 0xd7, 0x2e, 0x29,
    0x3f, 0x3f, 0x87, 0x0b, 0x00, 0xb9, 0x38, 0x7e, 0x01
};
#endif

PyTypeObject *init_SiteSettingsManager_SiteSettings(PyObject *enclosingClass)
{
    if (SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_SiteSettings_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_SiteSettings_IDX].type;

    Shiboken::AutoDecRef Sbk_SiteSettingsManager_SiteSettings_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_SiteSettingsManager_SiteSettings_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "SiteSettings",
        "SiteSettingsManager::SiteSettings",
        &Sbk_SiteSettingsManager_SiteSettings_spec,
        &Shiboken::callCppDestructor< ::SiteSettingsManager::SiteSettings >,
        Sbk_SiteSettingsManager_SiteSettings_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::InnerClass | Shiboken::ObjectType::WrapperFlags::Value);
    auto *pyType = Sbk_SiteSettingsManager_SiteSettings_TypeF(); // references _Sbk_SiteSettingsManager_SiteSettings_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, SiteSettingsManager_SiteSettings_SignatureStrings);
#else
    InitSignatureBytes(pyType, SiteSettingsManager_SiteSettings_SignatureBytes, SiteSettingsManager_SiteSettings_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_SiteSettingsManager_SiteSettings_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_SiteSettings_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        SiteSettings_PythonToCpp_SiteSettings_PTR,
        is_SiteSettings_PythonToCpp_SiteSettings_PTR_Convertible,
        SiteSettings_PTR_CppToPython_SiteSettings,
        SiteSettings_COPY_CppToPython_SiteSettings);

    Shiboken::Conversions::registerConverterName(converter, "SiteSettingsManager::SiteSettings");
    Shiboken::Conversions::registerConverterName(converter, "SiteSettingsManager::SiteSettings*");
    Shiboken::Conversions::registerConverterName(converter, "SiteSettingsManager::SiteSettings&");
    Shiboken::Conversions::registerConverterAlias(converter, "SiteSettings");
    Shiboken::Conversions::registerConverterAlias(converter, "SiteSettings*");
    Shiboken::Conversions::registerConverterAlias(converter, "SiteSettings&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::SiteSettingsManager::SiteSettings).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        SiteSettings_PythonToCpp_SiteSettings_COPY,
        is_SiteSettings_PythonToCpp_SiteSettings_COPY_Convertible);

    qRegisterMetaType< ::SiteSettingsManager::SiteSettings >("SiteSettings");
    qRegisterMetaType< ::SiteSettingsManager::SiteSettings >("SiteSettingsManager::SiteSettings");

    return pyType;
}
