
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "settings_wrapper.h"

// Argument includes
#include <QString>
#include <QStringList>
#include <qvariant.h>
#include <qzsettings.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_Settings_Type = nullptr;
static PyTypeObject *Sbk_Settings_TypeF(void)
{
    return _Sbk_Settings_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Settings_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(args)
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Settings >()))
        return -1;

    ::Settings *cptr{};
    Shiboken::PythonContextMarker pcm;


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_Settings_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {

        // Settings()
        cptr = new ::Settings();
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Settings >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_SettingsFunc_beginGroup(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Settings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Settings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Settings::beginGroup(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // beginGroup(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "beginGroup", errInfo, SbkPyFalkonTypeStructs[SBK_Settings_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // beginGroup(QString)
            cppSelf->beginGroup(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_SettingsFunc_childGroups(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Settings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Settings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // childGroups()const
        QStringList cppResult = const_cast<const ::Settings *>(cppSelf)->childGroups();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SettingsFunc_childKeys(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Settings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Settings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // childKeys()const
        QStringList cppResult = const_cast<const ::Settings *>(cppSelf)->childKeys();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SettingsFunc_contains(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Settings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Settings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Settings::contains(QString)const->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // contains(QString)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "contains", errInfo, SbkPyFalkonTypeStructs[SBK_Settings_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // contains(QString)const
            bool cppResult = const_cast<const ::Settings *>(cppSelf)->contains(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SettingsFunc_createSettings(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static Settings::createSettings(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // createSettings(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "createSettings", errInfo, SbkPyFalkonTypeStructs[SBK_Settings_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // createSettings(QString)
            ::Settings::createSettings(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_SettingsFunc_endGroup(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Settings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Settings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // endGroup()
        cppSelf->endGroup();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_SettingsFunc_globalSettings(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // globalSettings()
        QSettings * cppResult = ::Settings::globalSettings();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSettings_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SettingsFunc_remove(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Settings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Settings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Settings::remove(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // remove(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "remove", errInfo, SbkPyFalkonTypeStructs[SBK_Settings_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // remove(QString)
            cppSelf->remove(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_SettingsFunc_setValue(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Settings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Settings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setValue", errInfo, SbkPyFalkonTypeStructs[SBK_Settings_IDX]);

    if (PyArg_ParseTuple(args, "|OO:setValue", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: Settings::setValue(QString,const QVariant&=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setValue(QString,QVariant)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], (pyArgs[1])))) {
            overloadId = 0; // setValue(QString,QVariant)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setValue", errInfo, SbkPyFalkonTypeStructs[SBK_Settings_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"defaultValue", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setValue", errInfo, SbkPyFalkonTypeStructs[SBK_Settings_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1 = QVariant();
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setValue(QString,QVariant)
            cppSelf->setValue(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_SettingsFunc_staticSettings(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // staticSettings()
        QzSettings * cppResult = ::Settings::staticSettings();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SettingsFunc_sync(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Settings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Settings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // sync()
        cppSelf->sync();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_SettingsFunc_syncSettings(PyObject *self)
{
    SBK_UNUSED(self)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // syncSettings()
        ::Settings::syncSettings();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_SettingsFunc_value(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Settings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Settings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "value", errInfo, SbkPyFalkonTypeStructs[SBK_Settings_IDX]);

    if (PyArg_ParseTuple(args, "|OO:value", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: Settings::value(QString,const QVariant&=)->QVariant
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // value(QString,QVariant)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], (pyArgs[1])))) {
            overloadId = 0; // value(QString,QVariant)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "value", errInfo, SbkPyFalkonTypeStructs[SBK_Settings_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"defaultValue", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "value", errInfo, SbkPyFalkonTypeStructs[SBK_Settings_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1 = QVariant();
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // value(QString,QVariant)
            QVariant cppResult = cppSelf->value(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_Settings_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_Settings_methods[] = {
    {"beginGroup", reinterpret_cast<PyCFunction>(Sbk_SettingsFunc_beginGroup), METH_O, nullptr},
    {"childGroups", reinterpret_cast<PyCFunction>(Sbk_SettingsFunc_childGroups), METH_NOARGS, nullptr},
    {"childKeys", reinterpret_cast<PyCFunction>(Sbk_SettingsFunc_childKeys), METH_NOARGS, nullptr},
    {"contains", reinterpret_cast<PyCFunction>(Sbk_SettingsFunc_contains), METH_O, nullptr},
    {"createSettings", reinterpret_cast<PyCFunction>(Sbk_SettingsFunc_createSettings), METH_O|METH_STATIC, nullptr},
    {"endGroup", reinterpret_cast<PyCFunction>(Sbk_SettingsFunc_endGroup), METH_NOARGS, nullptr},
    {"globalSettings", reinterpret_cast<PyCFunction>(Sbk_SettingsFunc_globalSettings), METH_NOARGS|METH_STATIC, nullptr},
    {"remove", reinterpret_cast<PyCFunction>(Sbk_SettingsFunc_remove), METH_O, nullptr},
    {"setValue", reinterpret_cast<PyCFunction>(Sbk_SettingsFunc_setValue), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"staticSettings", reinterpret_cast<PyCFunction>(Sbk_SettingsFunc_staticSettings), METH_NOARGS|METH_STATIC, nullptr},
    {"sync", reinterpret_cast<PyCFunction>(Sbk_SettingsFunc_sync), METH_NOARGS, nullptr},
    {"syncSettings", reinterpret_cast<PyCFunction>(Sbk_SettingsFunc_syncSettings), METH_NOARGS|METH_STATIC, nullptr},
    {"value", reinterpret_cast<PyCFunction>(Sbk_SettingsFunc_value), METH_VARARGS|METH_KEYWORDS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_Settings_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_Settings_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_Settings_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Settings_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Settings_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Settings_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Settings_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_Settings_spec = {
    "1:PyFalkon.Settings",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_Settings_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void Settings_PythonToCpp_Settings_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_Settings_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_Settings_PythonToCpp_Settings_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_Settings_TypeF()))
        return Settings_PythonToCpp_Settings_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *Settings_PTR_CppToPython_Settings(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_Settings_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_Settings_TypeF(), const_cast<void *>(cppIn), false);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *Settings_SignatureStrings[] = {
    "PyFalkon.Settings(self)",
    "PyFalkon.Settings.beginGroup(self,prefix:QString)",
    "PyFalkon.Settings.childGroups(self)->QStringList",
    "PyFalkon.Settings.childKeys(self)->QStringList",
    "PyFalkon.Settings.contains(self,key:QString)->bool",
    "PyFalkon.Settings.createSettings(fileName:QString)",
    "PyFalkon.Settings.endGroup(self)",
    "PyFalkon.Settings.globalSettings()->PySide6.QtCore.QSettings",
    "PyFalkon.Settings.remove(self,key:QString)",
    "PyFalkon.Settings.setValue(self,key:QString,defaultValue:QVariant=QVariant())",
    "PyFalkon.Settings.staticSettings()->PyFalkon.QzSettings",
    "PyFalkon.Settings.sync(self)",
    "PyFalkon.Settings.syncSettings()",
    "PyFalkon.Settings.value(self,key:QString,defaultValue:QVariant=QVariant())->QVariant",
    nullptr}; // Sentinel
#else
static constexpr size_t Settings_SignatureByteSize = 228;
static constexpr uint8_t Settings_SignatureBytes[228] = {
    0x78, 0xda, 0x9d, 0x92, 0x41, 0x8b, 0xc2, 0x30, 0x10, 0x85, 0xef, 0xfe, 0x12, 0x85, 0xda, 0xa3,
    0x07, 0x41, 0x2f, 0x82, 0x7b, 0x50, 0xa4, 0xa1, 0xe0, 0x7d, 0xda, 0x4e, 0xbb, 0x83, 0xd3, 0x44,
    0x92, 0xa9, 0x18, 0x7f, 0xbd, 0x55, 0x6b, 0xc5, 0x35, 0xca, 0xe2, 0x2d, 0xc9, 0xfb, 0xde, 0xcb,
    0xbc, 0x90, 0xc4, 0x2f, 0x81, 0x77, 0x46, 0xc7, 0x29, 0x8a, 0x90, 0xae, 0xdc, 0xd0, 0x21, 0x97,
    0xa3, 0x41, 0xf2, 0xf7, 0x3c, 0xce, 0xb0, 0x22, 0xfd, 0x63, 0x4d, 0xb3, 0xbf, 0x22, 0xd1, 0xde,
    0x62, 0x49, 0xc7, 0xa9, 0x4a, 0xc5, 0xb6, 0x7a, 0xc8, 0x91, 0xff, 0x12, 0x17, 0x57, 0x47, 0x97,
    0x3a, 0x9e, 0x77, 0xf4, 0x9a, 0x9c, 0xbc, 0x33, 0xac, 0xd0, 0xff, 0x17, 0x37, 0x5a, 0x80, 0xf4,
    0x8d, 0x8e, 0x76, 0xe8, 0xfb, 0x61, 0xc6, 0xf3, 0xcc, 0x18, 0x0e, 0x59, 0x2c, 0x82, 0x60, 0xdf,
    0xb5, 0x24, 0xc6, 0x0d, 0xd4, 0xf8, 0xa9, 0x05, 0xea, 0xe2, 0xd1, 0x3a, 0x04, 0x54, 0x6c, 0x32,
    0xe0, 0x3e, 0xb3, 0xbd, 0x3c, 0xf1, 0x29, 0x15, 0x38, 0x89, 0x95, 0x2c, 0x8c, 0xc5, 0x58, 0xdd,
    0xb5, 0x80, 0xd9, 0x62, 0x6d, 0x0e, 0xf8, 0xda, 0x20, 0x80, 0x3a, 0x94, 0x2d, 0x70, 0xf3, 0x0a,
    0x47, 0x05, 0x96, 0xd0, 0xf0, 0x4d, 0x9d, 0xaa, 0x2d, 0x58, 0x02, 0x2d, 0xb3, 0xfb, 0x62, 0x38,
    0x0a, 0xa6, 0x09, 0x08, 0xe5, 0xcf, 0x53, 0x77, 0x8c, 0x3a, 0x7d, 0x18, 0xd8, 0x79, 0x9d, 0xbf,
    0x7d, 0x8a, 0x8b, 0xf8, 0x88, 0x0c, 0x00, 0x87, 0x2f, 0x0b, 0xb4, 0x5f, 0xa1, 0xdb, 0x0c, 0xce,
    0x27, 0xe5, 0xfe, 0x30
};
#endif

PyTypeObject *init_Settings(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_Settings_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_Settings_IDX].type;

    Shiboken::AutoDecRef Sbk_Settings_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_Settings_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "Settings",
        "Settings*",
        &Sbk_Settings_spec,
        &Shiboken::callCppDestructor< ::Settings >,
        Sbk_Settings_Type_bases.object(),
        0);
    auto *pyType = Sbk_Settings_TypeF(); // references _Sbk_Settings_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, Settings_SignatureStrings);
#else
    InitSignatureBytes(pyType, Settings_SignatureBytes, Settings_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_Settings_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_Settings_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        Settings_PythonToCpp_Settings_PTR,
        is_Settings_PythonToCpp_Settings_PTR_Convertible,
        Settings_PTR_CppToPython_Settings);

    Shiboken::Conversions::registerConverterName(converter, "Settings");
    Shiboken::Conversions::registerConverterName(converter, "Settings*");
    Shiboken::Conversions::registerConverterName(converter, "Settings&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Settings).name());

    qRegisterMetaType< ::Settings *>();

    return pyType;
}
