
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "extensionschemehandler_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_ExtensionSchemeHandler_Type = nullptr;
static PyTypeObject *Sbk_ExtensionSchemeHandler_TypeF(void)
{
    return _Sbk_ExtensionSchemeHandler_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void ExtensionSchemeHandlerWrapper::pysideInitQtMetaTypes()
{
}

void ExtensionSchemeHandlerWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

ExtensionSchemeHandlerWrapper::ExtensionSchemeHandlerWrapper(::QObject * parent) : ExtensionSchemeHandler(parent)
{
}

void ExtensionSchemeHandlerWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ExtensionSchemeHandler_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("ExtensionSchemeHandler", funcName, gil, pyOverride, event);
}

void ExtensionSchemeHandlerWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ExtensionSchemeHandler_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("ExtensionSchemeHandler", funcName, gil, pyOverride, signal);
}

void ExtensionSchemeHandlerWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ExtensionSchemeHandler_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("ExtensionSchemeHandler", funcName, gil, pyOverride, event);
}

void ExtensionSchemeHandlerWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ExtensionSchemeHandler_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("ExtensionSchemeHandler", funcName, gil, pyOverride, signal);
}

bool ExtensionSchemeHandlerWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ExtensionSchemeHandler_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return WebViewWrapper::sbk_o_event("ExtensionSchemeHandler", funcName, gil, pyOverride, event);
}

bool ExtensionSchemeHandlerWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ExtensionSchemeHandler_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("ExtensionSchemeHandler", funcName, gil, pyOverride, watched, event);
}

void ExtensionSchemeHandlerWrapper::requestStarted(::QWebEngineUrlRequestJob * job)
{
    static const char *funcName = "requestStarted";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ExtensionSchemeHandler_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("ExtensionSchemeHandler.requestStarted");
        return;
    }
    sbk_o_requestStarted("ExtensionSchemeHandler", funcName, gil, pyOverride, job);
}

void ExtensionSchemeHandlerWrapper::sbk_o_requestStarted(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QWebEngineUrlRequestJob * job)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineUrlRequestJob_IDX]), job)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineUrlRequestJob_IDX]), job)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void ExtensionSchemeHandlerWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ExtensionSchemeHandler_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("ExtensionSchemeHandler", funcName, gil, pyOverride, event);
}

const QMetaObject *ExtensionSchemeHandlerWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return ExtensionSchemeHandler::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int ExtensionSchemeHandlerWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = ExtensionSchemeHandler::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *ExtensionSchemeHandlerWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< ExtensionSchemeHandlerWrapper *>(this));
    }
    return ExtensionSchemeHandler::qt_metacast(_clname);
}

ExtensionSchemeHandlerWrapper::~ExtensionSchemeHandlerWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_ExtensionSchemeHandler_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_ExtensionSchemeHandler_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(args)
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PyTypeObject *type = self->ob_type;
    PyTypeObject *myType = Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ExtensionSchemeHandler_IDX]);
    if (type == myType) {
        Shiboken::Errors::setInstantiateAbstractClass("ExtensionSchemeHandler");
        return -1;
    }

    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::ExtensionSchemeHandler >()))
        return -1;

    ExtensionSchemeHandlerWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:ExtensionSchemeHandler", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: ExtensionSchemeHandler::ExtensionSchemeHandler(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // ExtensionSchemeHandler(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // ExtensionSchemeHandler(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_ExtensionSchemeHandler_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_ExtensionSchemeHandler_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_ExtensionSchemeHandler_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // ExtensionSchemeHandler(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) ExtensionSchemeHandlerWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new ExtensionSchemeHandlerWrapper(cppArg0);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ExtensionSchemeHandler >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_ExtensionSchemeHandler_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_ExtensionSchemeHandler_IDX]);
    };


    return 1;
}

static PyObject *Sbk_ExtensionSchemeHandlerFunc_requestStarted(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ExtensionSchemeHandlerWrapper *>(reinterpret_cast< ::ExtensionSchemeHandler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ExtensionSchemeHandler_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ExtensionSchemeHandler::requestStarted(QWebEngineUrlRequestJob*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineUrlRequestJob_IDX]), (pyArg)))) {
        overloadId = 0; // requestStarted(QWebEngineUrlRequestJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "requestStarted", errInfo, SbkPyFalkonTypeStructs[SBK_ExtensionSchemeHandler_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWebEngineUrlRequestJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // requestStarted(QWebEngineUrlRequestJob*)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                Shiboken::Errors::setPureVirtualMethodError("ExtensionSchemeHandler.requestStarted");
                return {};
            }
            cppSelf->requestStarted(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ExtensionSchemeHandlerFunc_setReply(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ExtensionSchemeHandlerWrapper *>(reinterpret_cast< ::ExtensionSchemeHandler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ExtensionSchemeHandler_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setReply", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: ExtensionSchemeHandler::setReply(QWebEngineUrlRequestJob*,QByteArray,QByteArray)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineUrlRequestJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), (pyArgs[2])))) {
        overloadId = 0; // setReply(QWebEngineUrlRequestJob*,QByteArray,QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setReply", errInfo, SbkPyFalkonTypeStructs[SBK_ExtensionSchemeHandler_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWebEngineUrlRequestJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QByteArray cppArg1_local;
        ::QByteArray *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1].isValue())
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QByteArray cppArg2_local;
        ::QByteArray *cppArg2 = &cppArg2_local;
        if (pythonToCpp[2].isValue())
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setReply(QWebEngineUrlRequestJob*,QByteArray,QByteArray)
            static_cast<ExtensionSchemeHandlerWrapper *>(cppSelf)->ExtensionSchemeHandlerWrapper::setReply_protected(cppArg0, *cppArg1, *cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_ExtensionSchemeHandler_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_ExtensionSchemeHandler_methods[] = {
    {"requestStarted", reinterpret_cast<PyCFunction>(Sbk_ExtensionSchemeHandlerFunc_requestStarted), METH_O, nullptr},
    {"setReply", reinterpret_cast<PyCFunction>(Sbk_ExtensionSchemeHandlerFunc_setReply), METH_VARARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_ExtensionSchemeHandler_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::ExtensionSchemeHandler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ExtensionSchemeHandler_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<ExtensionSchemeHandlerWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_ExtensionSchemeHandler_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_ExtensionSchemeHandler_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_ExtensionSchemeHandler_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_ExtensionSchemeHandler_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_ExtensionSchemeHandler_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_ExtensionSchemeHandler_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_ExtensionSchemeHandler_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_ExtensionSchemeHandler_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_ExtensionSchemeHandler_spec = {
    "1:PyFalkon.ExtensionSchemeHandler",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_ExtensionSchemeHandler_slots
};

} //extern "C"

static void *Sbk_ExtensionSchemeHandler_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::ExtensionSchemeHandler *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void ExtensionSchemeHandler_PythonToCpp_ExtensionSchemeHandler_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_ExtensionSchemeHandler_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_ExtensionSchemeHandler_PythonToCpp_ExtensionSchemeHandler_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_ExtensionSchemeHandler_TypeF()))
        return ExtensionSchemeHandler_PythonToCpp_ExtensionSchemeHandler_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *ExtensionSchemeHandler_PTR_CppToPython_ExtensionSchemeHandler(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::ExtensionSchemeHandler *>(const_cast<void *>(cppIn)), Sbk_ExtensionSchemeHandler_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *ExtensionSchemeHandler_SignatureStrings[] = {
    "PyFalkon.ExtensionSchemeHandler(self,parent:PySide6.QtCore.QObject=nullptr)",
    "PyFalkon.ExtensionSchemeHandler.requestStarted(self,job:PySide6.QtWebEngineCore.QWebEngineUrlRequestJob)",
    "PyFalkon.ExtensionSchemeHandler.setReply(self,job:PySide6.QtWebEngineCore.QWebEngineUrlRequestJob,contentType:typing.Union[PySide6.QtCore.QByteArray, char*],content:typing.Union[PySide6.QtCore.QByteArray, char*])",
    nullptr}; // Sentinel
#else
static constexpr size_t ExtensionSchemeHandler_SignatureByteSize = 180;
static constexpr uint8_t ExtensionSchemeHandler_SignatureBytes[180] = {
    0x78, 0xda, 0x9d, 0x90, 0xc1, 0x0e, 0xc1, 0x40, 0x14, 0x45, 0xf7, 0xbe, 0xc2, 0x52, 0xa5, 0x99,
    0xa5, 0x45, 0x13, 0x0b, 0x84, 0x88, 0x8d, 0x56, 0x89, 0x85, 0x58, 0x4c, 0xdb, 0x8b, 0xd6, 0x78,
    0x33, 0x5e, 0x9f, 0xc4, 0xfc, 0x3d, 0x49, 0x43, 0xc4, 0x82, 0xb0, 0xbc, 0x8b, 0x73, 0x4e, 0x72,
    0x63, 0x3f, 0xd1, 0xe6, 0x68, 0x49, 0x8d, 0xaf, 0x02, 0xaa, 0x4b, 0x4b, 0x69, 0x7e, 0xc0, 0x09,
    0x53, 0x4d, 0x85, 0x01, 0x77, 0x6a, 0x98, 0x5d, 0xe8, 0x34, 0x83, 0x24, 0x8a, 0x7d, 0x5a, 0x16,
    0xe8, 0xa9, 0x44, 0x46, 0x96, 0xa1, 0x92, 0x79, 0x56, 0x21, 0x97, 0x3e, 0x5d, 0x8c, 0x71, 0xc2,
    0x41, 0x2b, 0xfe, 0xec, 0x52, 0x8c, 0xf3, 0x05, 0xb5, 0xa4, 0xa2, 0x59, 0x50, 0x34, 0xea, 0xca,
    0x66, 0x2f, 0xde, 0x35, 0xb2, 0x31, 0xed, 0x4b, 0x42, 0x13, 0x78, 0xce, 0x15, 0x9b, 0x45, 0x03,
    0xcf, 0x6c, 0xf6, 0x3d, 0x54, 0x43, 0x16, 0x70, 0xc6, 0xff, 0x9d, 0x08, 0x73, 0x4b, 0x77, 0xb3,
    0x2c, 0xbd, 0x43, 0x24, 0xde, 0x95, 0xb4, 0x57, 0x2b, 0xba, 0x77, 0x36, 0xef, 0x1f, 0x0c, 0xbd,
    0x60, 0xc0, 0xac, 0x7d, 0xd8, 0xce, 0x0f, 0x9a, 0xbb, 0xdb, 0x07, 0xfa, 0x23, 0x16, 0xb4, 0x6e,
    0x1e, 0x60, 0x92, 0x60
};
#endif

PyTypeObject *init_ExtensionSchemeHandler(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_ExtensionSchemeHandler_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_ExtensionSchemeHandler_IDX].type;

    Shiboken::AutoDecRef Sbk_ExtensionSchemeHandler_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_ExtensionSchemeHandler_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "ExtensionSchemeHandler",
        "ExtensionSchemeHandler*",
        &Sbk_ExtensionSchemeHandler_spec,
        &Shiboken::callCppDestructor< ExtensionSchemeHandler >,
        Sbk_ExtensionSchemeHandler_Type_bases.object(),
        0);
    auto *pyType = Sbk_ExtensionSchemeHandler_TypeF(); // references _Sbk_ExtensionSchemeHandler_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, ExtensionSchemeHandler_SignatureStrings);
#else
    InitSignatureBytes(pyType, ExtensionSchemeHandler_SignatureBytes, ExtensionSchemeHandler_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_ExtensionSchemeHandler_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_ExtensionSchemeHandler_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        ExtensionSchemeHandler_PythonToCpp_ExtensionSchemeHandler_PTR,
        is_ExtensionSchemeHandler_PythonToCpp_ExtensionSchemeHandler_PTR_Convertible,
        ExtensionSchemeHandler_PTR_CppToPython_ExtensionSchemeHandler);

    Shiboken::Conversions::registerConverterName(converter, "ExtensionSchemeHandler");
    Shiboken::Conversions::registerConverterName(converter, "ExtensionSchemeHandler*");
    Shiboken::Conversions::registerConverterName(converter, "ExtensionSchemeHandler&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::ExtensionSchemeHandler).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(ExtensionSchemeHandlerWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_ExtensionSchemeHandler_TypeF(), &Sbk_ExtensionSchemeHandler_typeDiscovery);

    ExtensionSchemeHandlerWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::ExtensionSchemeHandler::staticMetaObject, sizeof(ExtensionSchemeHandlerWrapper));

    return pyType;
}
