#ifndef _EFL_UI_INTERNAL_TEXT_SCROLLER_EO_H_
#define _EFL_UI_INTERNAL_TEXT_SCROLLER_EO_H_

#ifndef _EFL_UI_INTERNAL_TEXT_SCROLLER_EO_CLASS_TYPE
#define _EFL_UI_INTERNAL_TEXT_SCROLLER_EO_CLASS_TYPE

typedef Eo Efl_Ui_Internal_Text_Scroller;

#endif

#ifndef _EFL_UI_INTERNAL_TEXT_SCROLLER_EO_TYPES
#define _EFL_UI_INTERNAL_TEXT_SCROLLER_EO_TYPES

#ifdef EFL_BETA_API_SUPPORT
typedef enum
{
  EFL_UI_TEXT_SCROLLER_MODE_DEFAULT = 0,
  EFL_UI_TEXT_SCROLLER_MODE_SINGLELINE = 0,
  EFL_UI_TEXT_SCROLLER_MODE_MULTILINE = 1
} Efl_Ui_Text_Scroller_Mode;
#endif /* EFL_BETA_API_SUPPORT */


#endif
#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief Internal-usage text scroller class.
 *
 * This class is a special scroller that evaluates its size based on the
 * @ref Efl_Canvas_Textblock object it holds. On initialization the object is
 * meant to be passed along a container (so that other objects such as a "guide
 * hint" text object are store in such container.
 *
 * @ingroup Efl_Ui_Internal_Text_Scroller
 */
#define EFL_UI_INTERNAL_TEXT_SCROLLER_CLASS efl_ui_internal_text_scroller_class_get()

EAPI EAPI_WEAK const Efl_Class *efl_ui_internal_text_scroller_class_get(void) EINA_CONST;

/**
 * @brief Mode of operation for the scroller, either default (singleline) or
 * multiline.
 *
 * @param[in] obj The object.
 * @param[in] mode
 *
 * @ingroup Efl_Ui_Internal_Text_Scroller
 */
EAPI EAPI_WEAK void efl_ui_internal_text_scroller_mode_set(Eo *obj, Efl_Ui_Text_Scroller_Mode mode);

/** The viewport's clip object
 *
 * @ingroup Efl_Ui_Internal_Text_Scroller
 */
EAPI EAPI_WEAK Efl_Object *efl_ui_internal_text_scroller_viewport_clip_get(const Eo *obj);

/**
 * @brief The Efl.Canvas.Textblock content of this scroller. This should be
 * called upon constructing the object.
 *
 * @param[in] obj The object.
 * @param[in] text_obj The text object to query
 * @param[in] text_table The table container of the @c text_obj
 *
 * @ingroup Efl_Ui_Internal_Text_Scroller
 */
EAPI EAPI_WEAK void efl_ui_internal_text_scroller_initialize(Eo *obj, Efl_Canvas_Textblock *text_obj, Efl_Ui_Table *text_table);
#endif /* EFL_BETA_API_SUPPORT */

#endif
