// Copyright 2019 Drone IO, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package core

import "context"

// Organization represents an organization in the source
// code management system (e.g. GitHub).
type Organization struct {
	Name   string
	Avatar string
}

// OrganizationService provides access to organization and
// team access in the external source code management system
// (e.g. GitHub).
type OrganizationService interface {
	// List returns a list of organization to which the
	// user is a member.
	List(context.Context, *User) ([]*Organization, error)

	// Membership returns true if the user is a member
	// of the organization, and true if the user is an
	// of the organization.
	Membership(context.Context, *User, string) (bool, bool, error)
}
