/* DuplicityPlugin.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DuplicityPlugin.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

#include "deja.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <glib-object.h>

#define DUPLICITY_PLUGIN_REQUIRED_MAJOR 2
#define DUPLICITY_PLUGIN_REQUIRED_MINOR 1
#define DUPLICITY_PLUGIN_REQUIRED_MICRO 0
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	DUPLICITY_PLUGIN_0_PROPERTY,
	DUPLICITY_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* duplicity_plugin_properties[DUPLICITY_PLUGIN_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_DUPLICITY_JOB (duplicity_job_get_type ())
#define DUPLICITY_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DUPLICITY_JOB, DuplicityJob))
#define DUPLICITY_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DUPLICITY_JOB, DuplicityJobClass))
#define IS_DUPLICITY_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DUPLICITY_JOB))
#define IS_DUPLICITY_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DUPLICITY_JOB))
#define DUPLICITY_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DUPLICITY_JOB, DuplicityJobClass))

typedef struct _DuplicityJob DuplicityJob;
typedef struct _DuplicityJobClass DuplicityJobClass;

struct _DuplicityPluginPrivate {
	gboolean has_been_setup;
	gchar* version;
};

static gint DuplicityPlugin_private_offset;
static gpointer duplicity_plugin_parent_class = NULL;

static gchar** duplicity_plugin_real_get_dependencies (DejaDupToolPlugin* base,
                                                gint* result_length1);
static void duplicity_plugin_do_initial_setup (DuplicityPlugin* self,
                                        GError** error);
static gchar* duplicity_plugin_find_and_parse_version (DuplicityPlugin* self,
                                                GError** error);
static gchar* duplicity_plugin_real_get_version (DejaDupToolPlugin* base,
                                          GError** error);
static DejaDupToolJob* duplicity_plugin_real_create_job (DejaDupToolPlugin* base,
                                                  GError** error);
VALA_EXTERN DuplicityJob* duplicity_job_new (void);
VALA_EXTERN DuplicityJob* duplicity_job_construct (GType object_type);
VALA_EXTERN GType duplicity_job_get_type (void) G_GNUC_CONST ;
static gboolean duplicity_plugin_real_supports_backend (DejaDupToolPlugin* base,
                                                 DejaDupBackendKind kind,
                                                 gchar** explanation);
static GObject * duplicity_plugin_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
static void duplicity_plugin_finalize (GObject * obj);
static GType duplicity_plugin_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
duplicity_plugin_get_instance_private (DuplicityPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, DuplicityPlugin_private_offset);
}

static gchar**
duplicity_plugin_real_get_dependencies (DejaDupToolPlugin* base,
                                        gint* result_length1)
{
	DuplicityPlugin * self;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	self = (DuplicityPlugin*) base;
	_tmp1_ = _tmp0_ = g_strsplit (DUPLICITY_PACKAGES, ",", 0);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _vala_array_length (_tmp0_);
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
duplicity_plugin_do_initial_setup (DuplicityPlugin* self,
                                   GError** error)
{
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gint major = 0;
	gint minor = 0;
	gint micro = 0;
	const gchar* _tmp3_;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gboolean _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->has_been_setup) {
		return;
	}
	_tmp1_ = duplicity_plugin_find_and_parse_version (self, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	_g_free0 (self->priv->version);
	self->priv->version = _tmp2_;
	_tmp3_ = self->priv->version;
	_tmp7_ = deja_dup_parse_version (_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
	major = _tmp4_;
	minor = _tmp5_;
	micro = _tmp6_;
	if (!_tmp7_) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GError* _tmp11_;
		GError* _tmp12_;
		_tmp8_ = self->priv->version;
		_tmp9_ = g_strdup_printf (_ ("Could not understand duplicity version ‘%s’."), _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_error_new_literal (G_SPAWN_ERROR, G_SPAWN_ERROR_FAILED, _tmp10_);
		_tmp12_ = _tmp11_;
		_g_free0 (_tmp10_);
		_inner_error0_ = _tmp12_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (_tmp0_);
		return;
	}
	if (!deja_dup_meets_version (major, minor, micro, DUPLICITY_PLUGIN_REQUIRED_MAJOR, DUPLICITY_PLUGIN_REQUIRED_MINOR, DUPLICITY_PLUGIN_REQUIRED_MICRO)) {
		gchar* msg = NULL;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		GError* _tmp17_;
		GError* _tmp18_;
		_tmp13_ = g_strdup (_ ("Backups requires at least version %d.%d.%.2d of duplicity, " "but only found version %d.%d.%.2d"));
		msg = _tmp13_;
		_tmp14_ = msg;
		_tmp15_ = g_strdup_printf (_tmp14_, DUPLICITY_PLUGIN_REQUIRED_MAJOR, DUPLICITY_PLUGIN_REQUIRED_MINOR, DUPLICITY_PLUGIN_REQUIRED_MICRO, major, minor, micro);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_error_new_literal (G_SPAWN_ERROR, G_SPAWN_ERROR_FAILED, _tmp16_);
		_tmp18_ = _tmp17_;
		_g_free0 (_tmp16_);
		_inner_error0_ = _tmp18_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (msg);
		_g_free0 (_tmp0_);
		return;
	}
	self->priv->has_been_setup = TRUE;
	_g_free0 (_tmp0_);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gchar*
duplicity_plugin_find_and_parse_version (DuplicityPlugin* self,
                                         GError** error)
{
	gchar* stderr = NULL;
	gchar* stdout = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar** lines = NULL;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint lines_length1;
	gint _lines_size_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	GError* _tmp25_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = duplicity_plugin_duplicity_command ();
	_tmp1_ = g_strdup ("--version");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 2;
	g_spawn_sync (NULL, _tmp3_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp4_, &_tmp5_, NULL, &_inner_error0_);
	_g_free0 (stdout);
	stdout = _tmp4_;
	_g_free0 (stderr);
	stderr = _tmp5_;
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_SPAWN_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (stdout);
			_g_free0 (stderr);
			return NULL;
		} else {
			_g_free0 (stdout);
			_g_free0 (stderr);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp6_ = stdout;
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "\n", 0);
	lines = _tmp8_;
	lines_length1 = _vala_array_length (_tmp7_);
	_lines_size_ = lines_length1;
	{
		gint i = 0;
		gchar** _tmp9_;
		gint _tmp9__length1;
		_tmp9_ = lines;
		_tmp9__length1 = lines_length1;
		i = _tmp9__length1 - 1;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				gchar** tokens = NULL;
				gchar** _tmp12_;
				gint _tmp12__length1;
				const gchar* _tmp13_;
				gchar** _tmp14_;
				gchar** _tmp15_;
				gint tokens_length1;
				gint _tokens_size_;
				gboolean _tmp16_ = FALSE;
				gchar** _tmp17_;
				gint _tmp17__length1;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ - 1;
				}
				_tmp10_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp12_ = lines;
				_tmp12__length1 = lines_length1;
				_tmp13_ = _tmp12_[i];
				_tmp15_ = _tmp14_ = g_strsplit (_tmp13_, " ", 0);
				tokens = _tmp15_;
				tokens_length1 = _vala_array_length (_tmp14_);
				_tokens_size_ = tokens_length1;
				_tmp17_ = tokens;
				_tmp17__length1 = tokens_length1;
				if (_tmp17__length1 >= 2) {
					gchar** _tmp18_;
					gint _tmp18__length1;
					const gchar* _tmp19_;
					_tmp18_ = tokens;
					_tmp18__length1 = tokens_length1;
					_tmp19_ = _tmp18_[0];
					_tmp16_ = g_strcmp0 (_tmp19_, "duplicity") == 0;
				} else {
					_tmp16_ = FALSE;
				}
				if (_tmp16_) {
					gchar** _tmp20_;
					gint _tmp20__length1;
					const gchar* _tmp21_;
					gchar* _tmp22_;
					_tmp20_ = tokens;
					_tmp20__length1 = tokens_length1;
					_tmp21_ = _tmp20_[1];
					_tmp22_ = string_strip (_tmp21_);
					result = _tmp22_;
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (stdout);
					_g_free0 (stderr);
					return result;
				}
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	_tmp23_ = stderr;
	_tmp24_ = stdout;
	g_warning ("DuplicityPlugin.vala:70: %s\n%s", _tmp23_, _tmp24_);
	_tmp25_ = g_error_new_literal (G_SPAWN_ERROR, G_SPAWN_ERROR_FAILED, _ ("Could not understand duplicity version."));
	_inner_error0_ = _tmp25_;
	if (_inner_error0_->domain == G_SPAWN_ERROR) {
		g_propagate_error (error, _inner_error0_);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (stdout);
		_g_free0 (stderr);
		return NULL;
	} else {
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (stdout);
		_g_free0 (stderr);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static gchar*
duplicity_plugin_real_get_version (DejaDupToolPlugin* base,
                                   GError** error)
{
	DuplicityPlugin * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = (DuplicityPlugin*) base;
	duplicity_plugin_do_initial_setup (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp0_ = self->priv->version;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static DejaDupToolJob*
duplicity_plugin_real_create_job (DejaDupToolPlugin* base,
                                  GError** error)
{
	DuplicityPlugin * self;
	DuplicityJob* _tmp0_;
	GError* _inner_error0_ = NULL;
	DejaDupToolJob* result;
	self = (DuplicityPlugin*) base;
	duplicity_plugin_do_initial_setup (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp0_ = duplicity_job_new ();
	result = (DejaDupToolJob*) _tmp0_;
	return result;
}

static gboolean
duplicity_plugin_real_supports_backend (DejaDupToolPlugin* base,
                                        DejaDupBackendKind kind,
                                        gchar** explanation)
{
	DuplicityPlugin * self;
	gchar* _vala_explanation = NULL;
	gboolean result;
	self = (DuplicityPlugin*) base;
	_g_free0 (_vala_explanation);
	_vala_explanation = NULL;
	switch (kind) {
		case DEJA_DUP_BACKEND_KIND_LOCAL:
		case DEJA_DUP_BACKEND_KIND_GVFS:
		case DEJA_DUP_BACKEND_KIND_GOOGLE:
		case DEJA_DUP_BACKEND_KIND_MICROSOFT:
		case DEJA_DUP_BACKEND_KIND_RCLONE:
		{
			result = TRUE;
			if (explanation) {
				*explanation = _vala_explanation;
			} else {
				_g_free0 (_vala_explanation);
			}
			return result;
		}
		default:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("This storage location is no longer supported. You can still use " "duplicity directly to back up or restore your files."));
			_g_free0 (_vala_explanation);
			_vala_explanation = _tmp0_;
			result = FALSE;
			if (explanation) {
				*explanation = _vala_explanation;
			} else {
				_g_free0 (_vala_explanation);
			}
			return result;
		}
	}
}

gchar*
duplicity_plugin_duplicity_command (void)
{
	gchar* testing_str = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gchar* result;
	_tmp0_ = g_getenv ("DEJA_DUP_TESTING");
	_tmp1_ = g_strdup (_tmp0_);
	testing_str = _tmp1_;
	_tmp3_ = testing_str;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = testing_str;
		_tmp2_ = atoi (_tmp4_) > 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("duplicity");
		result = _tmp5_;
		_g_free0 (testing_str);
		return result;
	} else {
		gchar* _tmp6_;
		_tmp6_ = g_strdup (DUPLICITY_COMMAND);
		result = _tmp6_;
		_g_free0 (testing_str);
		return result;
	}
}

DuplicityPlugin*
duplicity_plugin_construct (GType object_type)
{
	DuplicityPlugin * self = NULL;
	self = (DuplicityPlugin*) deja_dup_tool_plugin_construct (object_type);
	return self;
}

DuplicityPlugin*
duplicity_plugin_new (void)
{
	return duplicity_plugin_construct (TYPE_DUPLICITY_PLUGIN);
}

static GObject *
duplicity_plugin_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DuplicityPlugin * self;
	parent_class = G_OBJECT_CLASS (duplicity_plugin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DUPLICITY_PLUGIN, DuplicityPlugin);
	deja_dup_tool_plugin_set_name ((DejaDupToolPlugin*) self, "duplicity");
	return obj;
}

static void
duplicity_plugin_class_init (DuplicityPluginClass * klass,
                             gpointer klass_data)
{
	duplicity_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DuplicityPlugin_private_offset);
	((DejaDupToolPluginClass *) klass)->get_dependencies = (gchar** (*) (DejaDupToolPlugin*, gint*)) duplicity_plugin_real_get_dependencies;
	((DejaDupToolPluginClass *) klass)->get_version = (gchar* (*) (DejaDupToolPlugin*, GError**)) duplicity_plugin_real_get_version;
	((DejaDupToolPluginClass *) klass)->create_job = (DejaDupToolJob* (*) (DejaDupToolPlugin*, GError**)) duplicity_plugin_real_create_job;
	((DejaDupToolPluginClass *) klass)->supports_backend = (gboolean (*) (DejaDupToolPlugin*, DejaDupBackendKind, gchar**)) duplicity_plugin_real_supports_backend;
	G_OBJECT_CLASS (klass)->constructor = duplicity_plugin_constructor;
	G_OBJECT_CLASS (klass)->finalize = duplicity_plugin_finalize;
}

static void
duplicity_plugin_instance_init (DuplicityPlugin * self,
                                gpointer klass)
{
	self->priv = duplicity_plugin_get_instance_private (self);
	self->priv->has_been_setup = FALSE;
	self->priv->version = NULL;
}

static void
duplicity_plugin_finalize (GObject * obj)
{
	DuplicityPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DUPLICITY_PLUGIN, DuplicityPlugin);
	_g_free0 (self->priv->version);
	G_OBJECT_CLASS (duplicity_plugin_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
duplicity_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DuplicityPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) duplicity_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DuplicityPlugin), 0, (GInstanceInitFunc) duplicity_plugin_instance_init, NULL };
	GType duplicity_plugin_type_id;
	duplicity_plugin_type_id = g_type_register_static (DEJA_DUP_TYPE_TOOL_PLUGIN, "DuplicityPlugin", &g_define_type_info, 0);
	DuplicityPlugin_private_offset = g_type_add_instance_private (duplicity_plugin_type_id, sizeof (DuplicityPluginPrivate));
	return duplicity_plugin_type_id;
}

GType
duplicity_plugin_get_type (void)
{
	static gsize duplicity_plugin_type_id__once = 0;
	if (g_once_init_enter (&duplicity_plugin_type_id__once)) {
		GType duplicity_plugin_type_id;
		duplicity_plugin_type_id = duplicity_plugin_get_type_once ();
		g_once_init_leave (&duplicity_plugin_type_id__once, duplicity_plugin_type_id);
	}
	return duplicity_plugin_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

