/* Rclone.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Rclone.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

#include <glib-object.h>
#include "deja.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <json-glib/json-glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_RCLONE (rclone_get_type ())
#define RCLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RCLONE, Rclone))
#define RCLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RCLONE, RcloneClass))
#define IS_RCLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RCLONE))
#define IS_RCLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RCLONE))
#define RCLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RCLONE, RcloneClass))

typedef struct _Rclone Rclone;
typedef struct _RcloneClass RcloneClass;
typedef struct _RclonePrivate RclonePrivate;
enum  {
	RCLONE_0_PROPERTY,
	RCLONE_NUM_PROPERTIES
};
static GParamSpec* rclone_properties[RCLONE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_strv_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_strv_builder_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RcloneRunData RcloneRunData;
typedef struct _RcloneGetSpaceData RcloneGetSpaceData;
typedef struct _RcloneListFilesData RcloneListFilesData;

struct _Rclone {
	GObject parent_instance;
	RclonePrivate * priv;
};

struct _RcloneClass {
	GObjectClass parent_class;
};

struct _RcloneRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar** argv;
	gint argv_length1;
	DejaDupBackend* backend;
	gboolean add_target;
	GSubprocess* result;
	GList* envp;
	gchar* target;
	gchar* _tmp0_;
	GSubprocessLauncher* launcher;
	GSubprocessLauncher* _tmp1_;
	GSubprocessLauncher* _tmp2_;
	GList* _tmp3_;
	gint _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	GStrvBuilder* args;
	GStrvBuilder* _tmp7_;
	GStrvBuilder* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GStrvBuilder* _tmp11_;
	gboolean _tmp12_;
	const gchar* _tmp13_;
	GStrvBuilder* _tmp14_;
	const gchar* _tmp15_;
	GSubprocess* _tmp16_;
	GSubprocessLauncher* _tmp17_;
	GStrvBuilder* _tmp18_;
	gchar** _tmp19_;
	gchar** _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	GSubprocess* _tmp22_;
	GSubprocess* _tmp23_;
	GSubprocess* _tmp24_;
	GError* err;
	GError* _tmp25_;
	const gchar* _tmp26_;
	GError* _inner_error0_;
};

struct _RcloneGetSpaceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackend* backend;
	guint64 free;
	guint64 total;
	GSubprocess* rclone;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	GSubprocess* _tmp4_;
	GSubprocess* _tmp5_;
	GSubprocess* _tmp6_;
	GInputStream* stdout_raw;
	GSubprocess* _tmp7_;
	GInputStream* _tmp8_;
	GInputStream* _tmp9_;
	JsonParser* parser;
	JsonParser* _tmp10_;
	JsonParser* _tmp11_;
	GInputStream* _tmp12_;
	GError* err;
	GError* _tmp13_;
	const gchar* _tmp14_;
	GSubprocess* _tmp15_;
	GError* _inner_error1_;
	GSubprocess* _tmp16_;
	JsonParser* _tmp17_;
	JsonNode* _tmp18_;
	JsonReader* reader;
	JsonParser* _tmp19_;
	JsonNode* _tmp20_;
	JsonReader* _tmp21_;
	JsonReader* _tmp22_;
	gint64 parsed;
	JsonReader* _tmp23_;
	JsonReader* _tmp24_;
	JsonReader* _tmp25_;
	gint64 _vala1_parsed;
	JsonReader* _tmp26_;
	JsonReader* _tmp27_;
	GError* _inner_error0_;
};

struct _RcloneListFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackend* backend;
	gint max;
	GList* result;
	GSubprocess* rclone;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	GSubprocess* _tmp3_;
	GSubprocess* _tmp4_;
	GSubprocess* _tmp5_;
	GInputStream* stdout_raw;
	GSubprocess* _tmp6_;
	GInputStream* _tmp7_;
	GInputStream* _tmp8_;
	GDataInputStream* stdout;
	GInputStream* _tmp9_;
	GDataInputStream* _tmp10_;
	GList* files;
	GList* _tmp11_;
	gchar* line;
	GDataInputStream* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	guint8* _tmp17_;
	gint _tmp17__length1;
	gint _tmp18_;
	guint8* _tmp19_;
	gint _tmp19__length1;
	const gchar* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	guint8 _tmp23_;
	const gchar* _tmp24_;
	guint8* _tmp25_;
	gint _tmp25__length1;
	gint _tmp26_;
	guint8* _tmp27_;
	gint _tmp27__length1;
	const gchar* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	GError* err;
	GError* _tmp33_;
	const gchar* _tmp34_;
	GSubprocess* _tmp35_;
	GError* _inner_error0_;
};

static gpointer rclone_parent_class = NULL;

VALA_EXTERN GType rclone_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* rclone_fill_envp_from_backend (DejaDupBackend* backend,
                                      GList** envp);
VALA_EXTERN gchar* rclone_rclone_command (void);
static void rclone_run_data_free (gpointer _data);
VALA_EXTERN void rclone_run (gchar** argv,
                 gint argv_length1,
                 DejaDupBackend* backend,
                 gboolean add_target,
                 GAsyncReadyCallback _callback_,
                 gpointer _user_data_);
VALA_EXTERN GSubprocess* rclone_run_finish (GAsyncResult* _res_);
static gboolean rclone_run_co (RcloneRunData* _data_);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static void rclone_get_space_data_free (gpointer _data);
VALA_EXTERN void rclone_get_space (DejaDupBackend* backend,
                       GAsyncReadyCallback _callback_,
                       gpointer _user_data_);
VALA_EXTERN void rclone_get_space_finish (GAsyncResult* _res_,
                              guint64* free,
                              guint64* total);
static gboolean rclone_get_space_co (RcloneGetSpaceData* _data_);
static void rclone_get_space_ready (GObject* source_object,
                             GAsyncResult* _res_,
                             gpointer _user_data_);
static void rclone_list_files_data_free (gpointer _data);
VALA_EXTERN void rclone_list_files (DejaDupBackend* backend,
                        gint max,
                        GAsyncReadyCallback _callback_,
                        gpointer _user_data_);
VALA_EXTERN GList* rclone_list_files_finish (GAsyncResult* _res_);
static gboolean rclone_list_files_co (RcloneListFilesData* _data_);
static void rclone_list_files_ready (GObject* source_object,
                              GAsyncResult* _res_,
                              gpointer _user_data_);
VALA_EXTERN Rclone* rclone_new (void);
VALA_EXTERN Rclone* rclone_construct (GType object_type);
static GType rclone_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

gchar*
rclone_fill_envp_from_backend (DejaDupBackend* backend,
                               GList** envp)
{
	gchar* _tmp0_;
	DejaDupInstallEnv* _tmp1_;
	DejaDupInstallEnv* _tmp2_;
	gboolean _tmp3_;
	DejaDupBackendGoogle* google_backend = NULL;
	DejaDupBackendGoogle* _tmp5_;
	DejaDupBackendGoogle* _tmp6_;
	DejaDupBackendMicrosoft* microsoft_backend = NULL;
	DejaDupBackendMicrosoft* _tmp9_;
	DejaDupBackendMicrosoft* _tmp10_;
	DejaDupBackendRclone* rclone_backend = NULL;
	DejaDupBackendRclone* _tmp13_;
	DejaDupBackendRclone* _tmp14_;
	gchar* result;
	_tmp0_ = g_strdup ("RCLONE_ASK_PASSWORD=false");
	*envp = g_list_append (*envp, _tmp0_);
	_tmp1_ = deja_dup_install_env_instance ();
	_tmp2_ = _tmp1_;
	_tmp3_ = deja_dup_install_env_has_custom_config_home (_tmp2_);
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("XDG_CONFIG_HOME=");
		*envp = g_list_append (*envp, _tmp4_);
	}
	_tmp5_ = _g_object_ref0 (DEJA_DUP_IS_BACKEND_GOOGLE (backend) ? ((DejaDupBackendGoogle*) backend) : NULL);
	google_backend = _tmp5_;
	_tmp6_ = google_backend;
	if (_tmp6_ != NULL) {
		DejaDupBackendGoogle* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = google_backend;
		_tmp8_ = deja_dup_backend_google_fill_envp (_tmp7_, envp);
		result = _tmp8_;
		_g_object_unref0 (google_backend);
		return result;
	}
	_tmp9_ = _g_object_ref0 (DEJA_DUP_IS_BACKEND_MICROSOFT (backend) ? ((DejaDupBackendMicrosoft*) backend) : NULL);
	microsoft_backend = _tmp9_;
	_tmp10_ = microsoft_backend;
	if (_tmp10_ != NULL) {
		DejaDupBackendMicrosoft* _tmp11_;
		gchar* _tmp12_;
		_tmp11_ = microsoft_backend;
		_tmp12_ = deja_dup_backend_microsoft_fill_envp (_tmp11_, envp);
		result = _tmp12_;
		_g_object_unref0 (microsoft_backend);
		_g_object_unref0 (google_backend);
		return result;
	}
	_tmp13_ = _g_object_ref0 (DEJA_DUP_IS_BACKEND_RCLONE (backend) ? ((DejaDupBackendRclone*) backend) : NULL);
	rclone_backend = _tmp13_;
	_tmp14_ = rclone_backend;
	if (_tmp14_ != NULL) {
		DejaDupBackendRclone* _tmp15_;
		gchar* _tmp16_;
		_tmp15_ = rclone_backend;
		_tmp16_ = deja_dup_backend_rclone_fill_envp (_tmp15_, envp);
		result = _tmp16_;
		_g_object_unref0 (rclone_backend);
		_g_object_unref0 (microsoft_backend);
		_g_object_unref0 (google_backend);
		return result;
	}
	result = NULL;
	_g_object_unref0 (rclone_backend);
	_g_object_unref0 (microsoft_backend);
	_g_object_unref0 (google_backend);
	return result;
}

gchar*
rclone_rclone_command (void)
{
	gchar* testing_str = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gchar* result;
	_tmp0_ = g_getenv ("DEJA_DUP_TESTING");
	_tmp1_ = g_strdup (_tmp0_);
	testing_str = _tmp1_;
	_tmp3_ = testing_str;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = testing_str;
		_tmp2_ = atoi (_tmp4_) > 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("rclone");
		result = _tmp5_;
		_g_free0 (testing_str);
		return result;
	} else {
		gchar* _tmp6_;
		_tmp6_ = g_strdup (RCLONE_COMMAND);
		result = _tmp6_;
		_g_free0 (testing_str);
		return result;
	}
}

static void
rclone_run_data_free (gpointer _data)
{
	RcloneRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->backend);
	_g_object_unref0 (_data_->result);
	g_slice_free (RcloneRunData, _data_);
}

void
rclone_run (gchar** argv,
            gint argv_length1,
            DejaDupBackend* backend,
            gboolean add_target,
            GAsyncReadyCallback _callback_,
            gpointer _user_data_)
{
	RcloneRunData* _data_;
	DejaDupBackend* _tmp0_;
	_data_ = g_slice_new0 (RcloneRunData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rclone_run_data_free);
	_data_->argv = argv;
	_data_->argv_length1 = argv_length1;
	_tmp0_ = _g_object_ref0 (backend);
	_g_object_unref0 (_data_->backend);
	_data_->backend = _tmp0_;
	_data_->add_target = add_target;
	rclone_run_co (_data_);
}

GSubprocess*
rclone_run_finish (GAsyncResult* _res_)
{
	GSubprocess* result;
	RcloneRunData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

static gboolean
rclone_run_co (RcloneRunData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->envp = NULL;
	_data_->_tmp0_ = rclone_fill_envp_from_backend (_data_->backend, &_data_->envp);
	_data_->target = _data_->_tmp0_;
	_data_->_tmp1_ = g_subprocess_launcher_new (G_SUBPROCESS_FLAGS_STDOUT_PIPE | G_SUBPROCESS_FLAGS_STDERR_SILENCE);
	_data_->launcher = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->launcher;
	_data_->_tmp3_ = _data_->envp;
	_data_->_tmp4_ = 0;
	_data_->_tmp5_ = deja_dup_copy_env (_data_->_tmp3_, &_data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp6__length1 = _data_->_tmp4_;
	g_subprocess_launcher_set_environ (_data_->_tmp2_, _data_->_tmp6_);
	_data_->_tmp6_ = (_vala_array_free (_data_->_tmp6_, _data_->_tmp6__length1, (GDestroyNotify) g_free), NULL);
	_data_->_tmp7_ = g_strv_builder_new ();
	_data_->args = _data_->_tmp7_;
	_data_->_tmp8_ = _data_->args;
	_data_->_tmp9_ = rclone_rclone_command ();
	_data_->_tmp10_ = _data_->_tmp9_;
	g_strv_builder_add (_data_->_tmp8_, _data_->_tmp10_);
	_g_free0 (_data_->_tmp10_);
	_data_->_tmp11_ = _data_->args;
	g_strv_builder_addv (_data_->_tmp11_, _data_->argv);
	_data_->_tmp13_ = _data_->target;
	if (_data_->_tmp13_ != NULL) {
		_data_->_tmp12_ = _data_->add_target;
	} else {
		_data_->_tmp12_ = FALSE;
	}
	if (_data_->_tmp12_) {
		_data_->_tmp14_ = _data_->args;
		_data_->_tmp15_ = _data_->target;
		g_strv_builder_add (_data_->_tmp14_, _data_->_tmp15_);
	}
	{
		_data_->_tmp17_ = _data_->launcher;
		_data_->_tmp18_ = _data_->args;
		_data_->_tmp20_ = _data_->_tmp19_ = g_strv_builder_end (_data_->_tmp18_);
		_data_->_tmp21_ = _data_->_tmp20_;
		_data_->_tmp21__length1 = _vala_array_length (_data_->_tmp19_);
		_data_->_tmp22_ = g_subprocess_launcher_spawnv (_data_->_tmp17_, _data_->_tmp21_, &_data_->_inner_error0_);
		_data_->_tmp23_ = _data_->_tmp22_;
		_data_->_tmp21_ = (_vala_array_free (_data_->_tmp21_, _data_->_tmp21__length1, (GDestroyNotify) g_free), NULL);
		_data_->_tmp16_ = _data_->_tmp23_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp24_ = _data_->_tmp16_;
		_data_->_tmp16_ = NULL;
		_data_->result = _data_->_tmp24_;
		_g_object_unref0 (_data_->_tmp16_);
		_g_strv_builder_unref0 (_data_->args);
		_g_object_unref0 (_data_->launcher);
		_g_free0 (_data_->target);
		(_data_->envp == NULL) ? NULL : (_data_->envp = (_g_list_free__g_free0_ (_data_->envp), NULL));
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp25_ = _data_->err;
		_data_->_tmp26_ = _data_->_tmp25_->message;
		g_warning ("Rclone.vala:69: Could not launch Rclone: %s", _data_->_tmp26_);
		_data_->result = NULL;
		_g_error_free0 (_data_->err);
		_g_strv_builder_unref0 (_data_->args);
		_g_object_unref0 (_data_->launcher);
		_g_free0 (_data_->target);
		(_data_->envp == NULL) ? NULL : (_data_->envp = (_g_list_free__g_free0_ (_data_->envp), NULL));
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	_g_strv_builder_unref0 (_data_->args);
	_g_object_unref0 (_data_->launcher);
	_g_free0 (_data_->target);
	(_data_->envp == NULL) ? NULL : (_data_->envp = (_g_list_free__g_free0_ (_data_->envp), NULL));
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
	g_clear_error (&_data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rclone_get_space_data_free (gpointer _data)
{
	RcloneGetSpaceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->backend);
	g_slice_free (RcloneGetSpaceData, _data_);
}

void
rclone_get_space (DejaDupBackend* backend,
                  GAsyncReadyCallback _callback_,
                  gpointer _user_data_)
{
	RcloneGetSpaceData* _data_;
	DejaDupBackend* _tmp0_;
	g_return_if_fail (backend != NULL);
	_data_ = g_slice_new0 (RcloneGetSpaceData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rclone_get_space_data_free);
	_tmp0_ = _g_object_ref0 (backend);
	_g_object_unref0 (_data_->backend);
	_data_->backend = _tmp0_;
	rclone_get_space_co (_data_);
}

void
rclone_get_space_finish (GAsyncResult* _res_,
                         guint64* free,
                         guint64* total)
{
	RcloneGetSpaceData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (free) {
		*free = _data_->free;
	}
	if (total) {
		*total = _data_->total;
	}
}

static void
rclone_get_space_ready (GObject* source_object,
                        GAsyncResult* _res_,
                        gpointer _user_data_)
{
	RcloneGetSpaceData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rclone_get_space_co (_data_);
}

static gboolean
rclone_get_space_co (RcloneGetSpaceData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->free = DEJA_DUP_BACKEND_INFINITE_SPACE;
	_data_->total = DEJA_DUP_BACKEND_INFINITE_SPACE;
	_data_->_tmp0_ = g_strdup ("about");
	_data_->_tmp1_ = g_strdup ("--json");
	_data_->_tmp2_ = g_new0 (gchar*, 2 + 1);
	_data_->_tmp2_[0] = _data_->_tmp0_;
	_data_->_tmp2_[1] = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp3__length1 = 2;
	_data_->_state_ = 1;
	rclone_run (_data_->_tmp3_, (gint) 2, _data_->backend, TRUE, rclone_get_space_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp4_ = rclone_run_finish (_data_->_res_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp3_ = (_vala_array_free (_data_->_tmp3_, _data_->_tmp3__length1, (GDestroyNotify) g_free), NULL);
	_data_->rclone = _data_->_tmp5_;
	_data_->_tmp6_ = _data_->rclone;
	if (_data_->_tmp6_ == NULL) {
		_g_object_unref0 (_data_->rclone);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = _data_->rclone;
	_data_->_tmp8_ = g_subprocess_get_stdout_pipe (_data_->_tmp7_);
	_data_->_tmp9_ = _g_object_ref0 (_data_->_tmp8_);
	_data_->stdout_raw = _data_->_tmp9_;
	_data_->_tmp10_ = json_parser_new ();
	_data_->parser = _data_->_tmp10_;
	{
		_data_->_tmp11_ = _data_->parser;
		_data_->_tmp12_ = _data_->stdout_raw;
		_data_->_state_ = 2;
		json_parser_load_from_stream_async (_data_->_tmp11_, _data_->_tmp12_, NULL, rclone_get_space_ready, _data_);
		return FALSE;
		_state_2:
		json_parser_load_from_stream_finish (_data_->_tmp11_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp13_ = _data_->err;
		_data_->_tmp14_ = _data_->_tmp13_->message;
		g_warning ("Rclone.vala:89: Could not parse rclone about: %s", _data_->_tmp14_);
		_g_error_free0 (_data_->err);
		{
			_data_->_tmp15_ = _data_->rclone;
			g_subprocess_force_exit (_data_->_tmp15_);
		}
		_g_object_unref0 (_data_->parser);
		_g_object_unref0 (_data_->stdout_raw);
		_g_object_unref0 (_data_->rclone);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	{
		_data_->_tmp16_ = _data_->rclone;
		g_subprocess_force_exit (_data_->_tmp16_);
	}
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->parser);
		_g_object_unref0 (_data_->stdout_raw);
		_g_object_unref0 (_data_->rclone);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp17_ = _data_->parser;
	_data_->_tmp18_ = json_parser_get_root (_data_->_tmp17_);
	if (_data_->_tmp18_ == NULL) {
		_g_object_unref0 (_data_->parser);
		_g_object_unref0 (_data_->stdout_raw);
		_g_object_unref0 (_data_->rclone);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp19_ = _data_->parser;
	_data_->_tmp20_ = json_parser_get_root (_data_->_tmp19_);
	_data_->_tmp21_ = json_reader_new (_data_->_tmp20_);
	_data_->reader = _data_->_tmp21_;
	_data_->_tmp22_ = _data_->reader;
	if (json_reader_read_member (_data_->_tmp22_, "free")) {
		_data_->_tmp23_ = _data_->reader;
		_data_->parsed = json_reader_get_int_value (_data_->_tmp23_);
		if (_data_->parsed > ((gint64) 0)) {
			_data_->free = (guint64) _data_->parsed;
		}
		_data_->_tmp24_ = _data_->reader;
		json_reader_end_member (_data_->_tmp24_);
	}
	_data_->_tmp25_ = _data_->reader;
	if (json_reader_read_member (_data_->_tmp25_, "total")) {
		_data_->_tmp26_ = _data_->reader;
		_data_->_vala1_parsed = json_reader_get_int_value (_data_->_tmp26_);
		if (_data_->_vala1_parsed > ((gint64) 0)) {
			_data_->total = (guint64) _data_->_vala1_parsed;
		}
		_data_->_tmp27_ = _data_->reader;
		json_reader_end_member (_data_->_tmp27_);
	}
	_g_object_unref0 (_data_->reader);
	_g_object_unref0 (_data_->parser);
	_g_object_unref0 (_data_->stdout_raw);
	_g_object_unref0 (_data_->rclone);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rclone_list_files_data_free (gpointer _data)
{
	RcloneListFilesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->backend);
	(_data_->result == NULL) ? NULL : (_data_->result = (_g_list_free__g_free0_ (_data_->result), NULL));
	g_slice_free (RcloneListFilesData, _data_);
}

void
rclone_list_files (DejaDupBackend* backend,
                   gint max,
                   GAsyncReadyCallback _callback_,
                   gpointer _user_data_)
{
	RcloneListFilesData* _data_;
	DejaDupBackend* _tmp0_;
	g_return_if_fail (backend != NULL);
	_data_ = g_slice_new0 (RcloneListFilesData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rclone_list_files_data_free);
	_tmp0_ = _g_object_ref0 (backend);
	_g_object_unref0 (_data_->backend);
	_data_->backend = _tmp0_;
	_data_->max = max;
	rclone_list_files_co (_data_);
}

GList*
rclone_list_files_finish (GAsyncResult* _res_)
{
	GList* result;
	RcloneListFilesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
rclone_list_files_ready (GObject* source_object,
                         GAsyncResult* _res_,
                         gpointer _user_data_)
{
	RcloneListFilesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rclone_list_files_co (_data_);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static gboolean
rclone_list_files_co (RcloneListFilesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_strdup ("lsf");
	_data_->_tmp1_ = g_new0 (gchar*, 1 + 1);
	_data_->_tmp1_[0] = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp2__length1 = 1;
	_data_->_state_ = 1;
	rclone_run (_data_->_tmp2_, (gint) 1, _data_->backend, TRUE, rclone_list_files_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp3_ = rclone_run_finish (_data_->_res_);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp2_ = (_vala_array_free (_data_->_tmp2_, _data_->_tmp2__length1, (GDestroyNotify) g_free), NULL);
	_data_->rclone = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->rclone;
	if (_data_->_tmp5_ == NULL) {
		_data_->result = NULL;
		_g_object_unref0 (_data_->rclone);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->rclone;
	_data_->_tmp7_ = g_subprocess_get_stdout_pipe (_data_->_tmp6_);
	_data_->_tmp8_ = _g_object_ref0 (_data_->_tmp7_);
	_data_->stdout_raw = _data_->_tmp8_;
	_data_->_tmp9_ = _data_->stdout_raw;
	_data_->_tmp10_ = g_data_input_stream_new (_data_->_tmp9_);
	_data_->stdout = _data_->_tmp10_;
	_data_->files = NULL;
	while (TRUE) {
		_data_->_tmp11_ = _data_->files;
		if (!(g_list_length (_data_->_tmp11_) < ((guint) _data_->max))) {
			break;
		}
		{
			_data_->_tmp12_ = _data_->stdout;
			_data_->_state_ = 2;
			g_data_input_stream_read_line_async (_data_->_tmp12_, G_PRIORITY_LOW, NULL, rclone_list_files_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp13_ = g_data_input_stream_read_line_finish_utf8 (_data_->_tmp12_, _data_->_res_, NULL, &_data_->_inner_error0_);
			_data_->line = _data_->_tmp13_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp14_ = _data_->line;
			if (_data_->_tmp14_ == NULL) {
				_g_free0 (_data_->line);
				break;
			}
			_data_->_tmp15_ = _data_->line;
			if (string_get (_data_->_tmp15_, (glong) 0) == '.') {
				_g_free0 (_data_->line);
				continue;
			}
			_data_->_tmp16_ = _data_->line;
			_data_->_tmp18_ = 0;
			_data_->_tmp17_ = string_get_data (_data_->_tmp16_, &_data_->_tmp18_);
			_data_->_tmp17__length1 = _data_->_tmp18_;
			_data_->_tmp19_ = _data_->_tmp17_;
			_data_->_tmp19__length1 = _data_->_tmp17__length1;
			_data_->_tmp20_ = _data_->line;
			_data_->_tmp21_ = strlen (_data_->_tmp20_);
			_data_->_tmp22_ = _data_->_tmp21_;
			_data_->_tmp23_ = _data_->_tmp19_[_data_->_tmp22_ - 1];
			if (_data_->_tmp23_ == ((guint8) '/')) {
				_data_->_tmp24_ = _data_->line;
				_data_->_tmp26_ = 0;
				_data_->_tmp25_ = string_get_data (_data_->_tmp24_, &_data_->_tmp26_);
				_data_->_tmp25__length1 = _data_->_tmp26_;
				_data_->_tmp27_ = _data_->_tmp25_;
				_data_->_tmp27__length1 = _data_->_tmp25__length1;
				_data_->_tmp28_ = _data_->line;
				_data_->_tmp29_ = strlen (_data_->_tmp28_);
				_data_->_tmp30_ = _data_->_tmp29_;
				_data_->_tmp27_[_data_->_tmp30_ - 1] = (guint8) 0;
			}
			_data_->_tmp31_ = _data_->line;
			_data_->_tmp32_ = g_strdup (_data_->_tmp31_);
			_data_->files = g_list_append (_data_->files, _data_->_tmp32_);
			_g_free0 (_data_->line);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp33_ = _data_->err;
			_data_->_tmp34_ = _data_->_tmp33_->message;
			g_warning ("Rclone.vala:137: Could not parse Rclone output: %s", _data_->_tmp34_);
			_g_error_free0 (_data_->err);
			break;
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			(_data_->files == NULL) ? NULL : (_data_->files = (_g_list_free__g_free0_ (_data_->files), NULL));
			_g_object_unref0 (_data_->stdout);
			_g_object_unref0 (_data_->stdout_raw);
			_g_object_unref0 (_data_->rclone);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp35_ = _data_->rclone;
	g_subprocess_force_exit (_data_->_tmp35_);
	_data_->result = _data_->files;
	_g_object_unref0 (_data_->stdout);
	_g_object_unref0 (_data_->stdout_raw);
	_g_object_unref0 (_data_->rclone);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

Rclone*
rclone_construct (GType object_type)
{
	Rclone * self = NULL;
	self = (Rclone*) g_object_new (object_type, NULL);
	return self;
}

Rclone*
rclone_new (void)
{
	return rclone_construct (TYPE_RCLONE);
}

static void
rclone_class_init (RcloneClass * klass,
                   gpointer klass_data)
{
	rclone_parent_class = g_type_class_peek_parent (klass);
}

static void
rclone_instance_init (Rclone * self,
                      gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
rclone_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RcloneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rclone_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Rclone), 0, (GInstanceInitFunc) rclone_instance_init, NULL };
	GType rclone_type_id;
	rclone_type_id = g_type_register_static (G_TYPE_OBJECT, "Rclone", &g_define_type_info, 0);
	return rclone_type_id;
}

GType
rclone_get_type (void)
{
	static gsize rclone_type_id__once = 0;
	if (g_once_init_enter (&rclone_type_id__once)) {
		GType rclone_type_id;
		rclone_type_id = rclone_get_type_once ();
		g_once_init_leave (&rclone_type_id__once, rclone_type_id);
	}
	return rclone_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

