/* shortcut_entry.c generated by valac 0.56.17, the Vala compiler
 * generated from shortcut_entry.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2011 ~ 2018 Deepin, Inc.
 *               2011 ~ 2018 Wang Yong
 *
 * Author:     Wang Yong <wangyong@deepin.com>
 * Maintainer: Wang Yong <wangyong@deepin.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>

#define GETTEXT_PACKAGE "deepin-terminal-gtk"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define WIDGETS_TYPE_SHORTCUT_ENTRY (widgets_shortcut_entry_get_type ())
#define WIDGETS_SHORTCUT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_SHORTCUT_ENTRY, WidgetsShortcutEntry))
#define WIDGETS_SHORTCUT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_SHORTCUT_ENTRY, WidgetsShortcutEntryClass))
#define WIDGETS_IS_SHORTCUT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_SHORTCUT_ENTRY))
#define WIDGETS_IS_SHORTCUT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_SHORTCUT_ENTRY))
#define WIDGETS_SHORTCUT_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_SHORTCUT_ENTRY, WidgetsShortcutEntryClass))

typedef struct _WidgetsShortcutEntry WidgetsShortcutEntry;
typedef struct _WidgetsShortcutEntryClass WidgetsShortcutEntryClass;
typedef struct _WidgetsShortcutEntryPrivate WidgetsShortcutEntryPrivate;
enum  {
	WIDGETS_SHORTCUT_ENTRY_0_PROPERTY,
	WIDGETS_SHORTCUT_ENTRY_NUM_PROPERTIES
};
static GParamSpec* widgets_shortcut_entry_properties[WIDGETS_SHORTCUT_ENTRY_NUM_PROPERTIES];
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
enum  {
	WIDGETS_SHORTCUT_ENTRY_CHANGE_KEY_SIGNAL,
	WIDGETS_SHORTCUT_ENTRY_NUM_SIGNALS
};
static guint widgets_shortcut_entry_signals[WIDGETS_SHORTCUT_ENTRY_NUM_SIGNALS] = {0};

struct _WidgetsShortcutEntry {
	GtkEventBox parent_instance;
	WidgetsShortcutEntryPrivate * priv;
	cairo_surface_t* button_left_surface;
	cairo_surface_t* button_right_surface;
	GdkRGBA active_frame_color;
	GdkRGBA background_color;
	GdkRGBA hint_color;
	GdkRGBA normal_frame_color;
	GdkRGBA shortcut_background_color;
	GdkRGBA shortcut_font_color;
	GdkRGBA shortcut_frame_color;
	gboolean is_double_clicked;
	gint double_clicked_max_delay;
	gint height;
	gint shortcut_font_padding_x;
	gint shortcut_font_padding_y;
	gint shortcut_font_size;
	gint shortcut_key_padding_x;
	gint shortcut_key_padding_y;
	gint shortcut_key_spacing;
	gchar* shortcut;
};

struct _WidgetsShortcutEntryClass {
	GtkEventBoxClass parent_class;
};

static gpointer widgets_shortcut_entry_parent_class = NULL;

VALA_EXTERN GType widgets_shortcut_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsShortcutEntry, g_object_unref)
VALA_EXTERN WidgetsShortcutEntry* widgets_shortcut_entry_new (void);
VALA_EXTERN WidgetsShortcutEntry* widgets_shortcut_entry_construct (GType object_type);
VALA_EXTERN cairo_surface_t* utils_create_image_surface (const gchar* surface_path);
VALA_EXTERN void utils_hex_to_rgba (const gchar* hex_color,
                        gdouble alpha,
                        GdkRGBA* result);
static gboolean widgets_shortcut_entry_on_draw (WidgetsShortcutEntry* self,
                                         GtkWidget* widget,
                                         cairo_t* cr);
static gboolean _widgets_shortcut_entry_on_draw_gtk_widget_draw (GtkWidget* _sender,
                                                          cairo_t* cr,
                                                          gpointer self);
static gboolean __lambda48_ (WidgetsShortcutEntry* self,
                      GtkWidget* w,
                      GdkEventButton* e);
static gboolean ___lambda49_ (WidgetsShortcutEntry* self);
static gboolean ____lambda49__gsource_func (gpointer self);
static gboolean ___lambda48__gtk_widget_button_press_event (GtkWidget* _sender,
                                                     GdkEventButton* event,
                                                     gpointer self);
static gboolean __lambda50_ (WidgetsShortcutEntry* self,
                      GtkWidget* w,
                      GdkEventKey* e);
VALA_EXTERN gchar* keymap_get_keyevent_name (GdkEventKey* key_event);
static gboolean ___lambda50__gtk_widget_key_press_event (GtkWidget* _sender,
                                                  GdkEventKey* event,
                                                  gpointer self);
VALA_EXTERN void widgets_shortcut_entry_set_text (WidgetsShortcutEntry* self,
                                      const gchar* text);
VALA_EXTERN gchar* widgets_shortcut_entry_get_text (WidgetsShortcutEntry* self);
VALA_EXTERN void draw_stroke_rounded_rectangle (cairo_t* cr,
                                    gint x,
                                    gint y,
                                    gint width,
                                    gint height,
                                    gdouble r,
                                    GdkRGBA* frame_color,
                                    GdkRGBA* background_color,
                                    gint line_width);
VALA_EXTERN void draw_draw_text (cairo_t* cr,
                     const gchar* text,
                     gint x,
                     gint y,
                     gint width,
                     gint height,
                     gint size,
                     PangoAlignment horizontal_alignment,
                     const gchar* vertical_align,
                     gint* wrap_width);
VALA_EXTERN void draw_draw_surface (cairo_t* cr,
                        cairo_surface_t* surface,
                        gint x,
                        gint y,
                        gint width,
                        gint height);
VALA_EXTERN void draw_draw_rectangle (cairo_t* cr,
                          gint x,
                          gint y,
                          gint w,
                          gint h,
                          gboolean fill);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static void widgets_shortcut_entry_finalize (GObject * obj);
static GType widgets_shortcut_entry_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gboolean
_widgets_shortcut_entry_on_draw_gtk_widget_draw (GtkWidget* _sender,
                                                 cairo_t* cr,
                                                 gpointer self)
{
	gboolean result;
	result = widgets_shortcut_entry_on_draw ((WidgetsShortcutEntry*) self, _sender, cr);
	return result;
}

static gboolean
___lambda49_ (WidgetsShortcutEntry* self)
{
	gboolean result;
	self->is_double_clicked = FALSE;
	result = FALSE;
	return result;
}

static gboolean
____lambda49__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda49_ ((WidgetsShortcutEntry*) self);
	return result;
}

static gboolean
__lambda48_ (WidgetsShortcutEntry* self,
             GtkWidget* w,
             GdkEventButton* e)
{
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	gtk_widget_grab_focus ((GtkWidget*) self);
	if (e->type == GDK_BUTTON_PRESS) {
		self->is_double_clicked = TRUE;
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) self->double_clicked_max_delay, ____lambda49__gsource_func, g_object_ref (self), g_object_unref);
	} else {
		if (e->type == GDK_2BUTTON_PRESS) {
			if (self->is_double_clicked) {
				gchar* _tmp0_;
				const gchar* _tmp1_;
				_tmp0_ = g_strdup ("");
				_g_free0 (self->shortcut);
				self->shortcut = _tmp0_;
				_tmp1_ = self->shortcut;
				g_signal_emit (self, widgets_shortcut_entry_signals[WIDGETS_SHORTCUT_ENTRY_CHANGE_KEY_SIGNAL], 0, _tmp1_);
				gtk_widget_queue_draw ((GtkWidget*) self);
			}
		}
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = FALSE;
	return result;
}

static gboolean
___lambda48__gtk_widget_button_press_event (GtkWidget* _sender,
                                            GdkEventButton* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda48_ ((WidgetsShortcutEntry*) self, _sender, event);
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
__lambda50_ (WidgetsShortcutEntry* self,
             GtkWidget* w,
             GdkEventKey* e)
{
	gchar* keyname = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = keymap_get_keyevent_name (e);
	keyname = _tmp0_;
	_tmp1_ = keyname;
	if (g_strcmp0 (_tmp1_, "Backspace") == 0) {
		gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = g_strdup ("");
		_g_free0 (self->shortcut);
		self->shortcut = _tmp2_;
		_tmp3_ = self->shortcut;
		g_signal_emit (self, widgets_shortcut_entry_signals[WIDGETS_SHORTCUT_ENTRY_CHANGE_KEY_SIGNAL], 0, _tmp3_);
		gtk_widget_queue_draw ((GtkWidget*) self);
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		const gchar* _tmp6_;
		_tmp6_ = keyname;
		if (g_strcmp0 (_tmp6_, "Ctrl + Tab") == 0) {
			_tmp5_ = TRUE;
		} else {
			const gchar* _tmp7_;
			_tmp7_ = keyname;
			_tmp5_ = g_strcmp0 (_tmp7_, "Ctrl + Shift + Tab") == 0;
		}
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			const gchar* _tmp8_;
			_tmp8_ = keyname;
			_tmp4_ = g_strcmp0 (_tmp8_, "Shift + Tab") == 0;
		}
		if (_tmp4_) {
			result = FALSE;
			_g_free0 (keyname);
			return result;
		} else {
			gboolean _tmp9_ = FALSE;
			const gchar* _tmp10_;
			_tmp10_ = keyname;
			if (g_str_has_prefix (_tmp10_, "F")) {
				_tmp9_ = TRUE;
			} else {
				const gchar* _tmp11_;
				_tmp11_ = keyname;
				_tmp9_ = string_contains (_tmp11_, "+");
			}
			if (_tmp9_) {
				const gchar* _tmp12_;
				gchar* _tmp13_;
				const gchar* _tmp14_;
				_tmp12_ = keyname;
				_tmp13_ = g_strdup (_tmp12_);
				_g_free0 (self->shortcut);
				self->shortcut = _tmp13_;
				_tmp14_ = self->shortcut;
				g_signal_emit (self, widgets_shortcut_entry_signals[WIDGETS_SHORTCUT_ENTRY_CHANGE_KEY_SIGNAL], 0, _tmp14_);
				gtk_widget_queue_draw ((GtkWidget*) self);
			}
		}
	}
	result = FALSE;
	_g_free0 (keyname);
	return result;
}

static gboolean
___lambda50__gtk_widget_key_press_event (GtkWidget* _sender,
                                         GdkEventKey* event,
                                         gpointer self)
{
	gboolean result;
	result = __lambda50_ ((WidgetsShortcutEntry*) self, _sender, event);
	return result;
}

WidgetsShortcutEntry*
widgets_shortcut_entry_construct (GType object_type)
{
	WidgetsShortcutEntry * self = NULL;
	cairo_surface_t* _tmp0_;
	cairo_surface_t* _tmp1_;
	GdkRGBA _tmp2_ = {0};
	GdkRGBA _tmp3_ = {0};
	GdkRGBA _tmp4_ = {0};
	GdkRGBA _tmp5_ = {0};
	GdkRGBA _tmp6_ = {0};
	GdkRGBA _tmp7_ = {0};
	self = (WidgetsShortcutEntry*) g_object_new (object_type, NULL);
	bindtextdomain (GETTEXT_PACKAGE, "/usr/share/locale");
	_tmp0_ = utils_create_image_surface ("shortcut_button_left.svg");
	_cairo_surface_destroy0 (self->button_left_surface);
	self->button_left_surface = _tmp0_;
	_tmp1_ = utils_create_image_surface ("shortcut_button_right.svg");
	_cairo_surface_destroy0 (self->button_right_surface);
	self->button_right_surface = _tmp1_;
	gtk_event_box_set_visible_window ((GtkEventBox*) self, FALSE);
	gtk_widget_set_can_focus ((GtkWidget*) self, TRUE);
	gtk_widget_set_size_request ((GtkWidget*) self, -1, 24);
	memset (&self->normal_frame_color, 0, sizeof (GdkRGBA));
	self->normal_frame_color.red = (gdouble) 0;
	self->normal_frame_color.green = (gdouble) 0;
	self->normal_frame_color.blue = (gdouble) 0;
	self->normal_frame_color.alpha = 0.1;
	utils_hex_to_rgba ("#2ca7f8", 1.0, &_tmp2_);
	self->active_frame_color = _tmp2_;
	utils_hex_to_rgba ("#ffffff", 1.0, &_tmp3_);
	self->background_color = _tmp3_;
	utils_hex_to_rgba ("#ADAEAF", 1.0, &_tmp4_);
	self->hint_color = _tmp4_;
	utils_hex_to_rgba ("#69AAFF", 1.0, &_tmp5_);
	self->shortcut_background_color = _tmp5_;
	self->shortcut_background_color.alpha = 0.15;
	utils_hex_to_rgba ("#5F9FD9", 1.0, &_tmp6_);
	self->shortcut_frame_color = _tmp6_;
	self->shortcut_frame_color.alpha = 0.30;
	utils_hex_to_rgba ("#303030", 1.0, &_tmp7_);
	self->shortcut_font_color = _tmp7_;
	g_signal_connect_object ((GtkWidget*) self, "draw", (GCallback) _widgets_shortcut_entry_on_draw_gtk_widget_draw, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) ___lambda48__gtk_widget_button_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "key-press-event", (GCallback) ___lambda50__gtk_widget_key_press_event, self, 0);
	return self;
}

WidgetsShortcutEntry*
widgets_shortcut_entry_new (void)
{
	return widgets_shortcut_entry_construct (WIDGETS_TYPE_SHORTCUT_ENTRY);
}

void
widgets_shortcut_entry_set_text (WidgetsShortcutEntry* self,
                                 const gchar* text)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = g_strdup (text);
	_g_free0 (self->shortcut);
	self->shortcut = _tmp0_;
	gtk_widget_queue_draw ((GtkWidget*) self);
}

gchar*
widgets_shortcut_entry_get_text (WidgetsShortcutEntry* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->shortcut;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

static gboolean
widgets_shortcut_entry_on_draw (WidgetsShortcutEntry* self,
                                GtkWidget* widget,
                                cairo_t* cr)
{
	GtkAllocation rect = {0};
	GtkAllocation _tmp0_ = {0};
	gboolean _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp11_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (cr != NULL, FALSE);
	gtk_widget_get_allocation (widget, &_tmp0_);
	rect = _tmp0_;
	g_object_get ((GtkWidget*) self, "is-focus", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkAllocation _tmp3_;
		GtkAllocation _tmp4_;
		GdkRGBA _tmp5_;
		GdkRGBA _tmp6_;
		_tmp3_ = rect;
		_tmp4_ = rect;
		_tmp5_ = self->active_frame_color;
		_tmp6_ = self->background_color;
		draw_stroke_rounded_rectangle (cr, 0, 0, _tmp3_.width, _tmp4_.height, (gdouble) 4, &_tmp5_, &_tmp6_, 1);
	} else {
		GtkAllocation _tmp7_;
		GtkAllocation _tmp8_;
		GdkRGBA _tmp9_;
		GdkRGBA _tmp10_;
		_tmp7_ = rect;
		_tmp8_ = rect;
		_tmp9_ = self->normal_frame_color;
		_tmp10_ = self->background_color;
		draw_stroke_rounded_rectangle (cr, 0, 0, _tmp7_.width, _tmp8_.height, (gdouble) 4, &_tmp9_, &_tmp10_, 1);
	}
	_tmp11_ = self->shortcut;
	if (g_strcmp0 (_tmp11_, "") == 0) {
		GdkRGBA _tmp12_;
		GdkRGBA _tmp13_;
		GdkRGBA _tmp14_;
		GdkRGBA _tmp15_;
		GtkAllocation _tmp16_;
		GtkAllocation _tmp17_;
		_tmp12_ = self->hint_color;
		_tmp13_ = self->hint_color;
		_tmp14_ = self->hint_color;
		_tmp15_ = self->hint_color;
		cairo_set_source_rgba (cr, _tmp12_.red, _tmp13_.green, _tmp14_.blue, _tmp15_.alpha);
		_tmp16_ = rect;
		_tmp17_ = rect;
		draw_draw_text (cr, _ ("Please enter a new shortcut"), self->shortcut_font_padding_x, self->shortcut_font_padding_y, _tmp16_.width - (self->shortcut_font_padding_x * 2), _tmp17_.height - (self->shortcut_font_padding_y * 2), self->shortcut_font_size, PANGO_ALIGN_LEFT, "middle", NULL);
	} else {
		gint x = 0;
		gint y = 0;
		gchar** shortcut_keys = NULL;
		const gchar* _tmp18_;
		gchar** _tmp19_;
		gchar** _tmp20_;
		gint shortcut_keys_length1;
		gint _shortcut_keys_size_;
		gchar** _tmp21_;
		gint _tmp21__length1;
		x = self->shortcut_font_padding_x;
		y = self->shortcut_font_padding_y;
		_tmp18_ = self->shortcut;
		_tmp20_ = _tmp19_ = g_strsplit (_tmp18_, " + ", 0);
		shortcut_keys = _tmp20_;
		shortcut_keys_length1 = _vala_array_length (_tmp19_);
		_shortcut_keys_size_ = shortcut_keys_length1;
		_tmp21_ = shortcut_keys;
		_tmp21__length1 = shortcut_keys_length1;
		{
			gchar** key_collection = NULL;
			gint key_collection_length1 = 0;
			gint _key_collection_size_ = 0;
			gint key_it = 0;
			key_collection = _tmp21_;
			key_collection_length1 = _tmp21__length1;
			for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
				gchar* _tmp22_;
				gchar* key = NULL;
				_tmp22_ = g_strdup (key_collection[key_it]);
				key = _tmp22_;
				{
					PangoFontDescription* font_description = NULL;
					PangoFontDescription* _tmp23_;
					PangoFontDescription* _tmp24_;
					PangoLayout* layout = NULL;
					PangoLayout* _tmp25_;
					PangoLayout* _tmp26_;
					PangoFontDescription* _tmp27_;
					PangoLayout* _tmp28_;
					const gchar* _tmp29_;
					const gchar* _tmp30_;
					gint _tmp31_;
					gint _tmp32_;
					PangoLayout* _tmp33_;
					PangoLayout* _tmp34_;
					PangoLayout* _tmp35_;
					gint text_width = 0;
					gint text_height = 0;
					PangoLayout* _tmp36_;
					gint _tmp37_ = 0;
					gint _tmp38_ = 0;
					gint key_width = 0;
					gint button_width = 0;
					cairo_surface_t* _tmp39_;
					gint button_height = 0;
					cairo_surface_t* _tmp40_;
					gint button_y = 0;
					gint shortcut_key_width = 0;
					cairo_surface_t* _tmp41_;
					cairo_surface_t* _tmp42_;
					GdkRGBA _tmp43_;
					GdkRGBA _tmp44_;
					GdkRGBA _tmp45_;
					GdkRGBA _tmp46_;
					GdkRGBA _tmp47_;
					GdkRGBA _tmp48_;
					GdkRGBA _tmp49_;
					GdkRGBA _tmp50_;
					gint render_y = 0;
					GdkRGBA _tmp51_;
					GdkRGBA _tmp52_;
					GdkRGBA _tmp53_;
					GdkRGBA _tmp54_;
					PangoLayout* _tmp55_;
					PangoLayout* _tmp56_;
					_tmp23_ = pango_font_description_new ();
					font_description = _tmp23_;
					_tmp24_ = font_description;
					pango_font_description_set_size (_tmp24_, (gint) (self->shortcut_font_size * PANGO_SCALE));
					_tmp25_ = pango_cairo_create_layout (cr);
					layout = _tmp25_;
					_tmp26_ = layout;
					_tmp27_ = font_description;
					pango_layout_set_font_description (_tmp26_, _tmp27_);
					_tmp28_ = layout;
					_tmp29_ = key;
					_tmp30_ = key;
					_tmp31_ = strlen (_tmp30_);
					_tmp32_ = _tmp31_;
					pango_layout_set_text (_tmp28_, _tmp29_, _tmp32_);
					_tmp33_ = layout;
					pango_layout_set_alignment (_tmp33_, PANGO_ALIGN_LEFT);
					_tmp34_ = layout;
					pango_layout_set_single_paragraph_mode (_tmp34_, TRUE);
					_tmp35_ = layout;
					pango_layout_set_ellipsize (_tmp35_, PANGO_ELLIPSIZE_END);
					_tmp36_ = layout;
					pango_layout_get_pixel_size (_tmp36_, &_tmp37_, &_tmp38_);
					text_width = _tmp37_;
					text_height = _tmp38_;
					key_width = MAX (text_width, 20);
					_tmp39_ = self->button_left_surface;
					button_width = cairo_image_surface_get_width (_tmp39_) / gtk_widget_get_scale_factor ((GtkWidget*) self);
					_tmp40_ = self->button_left_surface;
					button_height = cairo_image_surface_get_height (_tmp40_) / gtk_widget_get_scale_factor ((GtkWidget*) self);
					button_y = (self->height - button_height) / 2;
					shortcut_key_width = key_width + (self->shortcut_key_padding_x * 2);
					_tmp41_ = self->button_left_surface;
					draw_draw_surface (cr, _tmp41_, x, button_y, 0, 0);
					_tmp42_ = self->button_right_surface;
					draw_draw_surface (cr, _tmp42_, (x + shortcut_key_width) - button_width, button_y, 0, 0);
					_tmp43_ = self->shortcut_background_color;
					_tmp44_ = self->shortcut_background_color;
					_tmp45_ = self->shortcut_background_color;
					_tmp46_ = self->shortcut_background_color;
					cairo_set_source_rgba (cr, _tmp43_.red, _tmp44_.green, _tmp45_.blue, _tmp46_.alpha);
					draw_draw_rectangle (cr, x + button_width, button_y, shortcut_key_width - (button_width * 2), button_height, TRUE);
					_tmp47_ = self->shortcut_frame_color;
					_tmp48_ = self->shortcut_frame_color;
					_tmp49_ = self->shortcut_frame_color;
					_tmp50_ = self->shortcut_frame_color;
					cairo_set_source_rgba (cr, _tmp47_.red, _tmp48_.green, _tmp49_.blue, _tmp50_.alpha);
					draw_draw_rectangle (cr, x + button_width, button_y, shortcut_key_width - (button_width * 2), 1, TRUE);
					draw_draw_rectangle (cr, x + button_width, (button_y + button_height) - 1, shortcut_key_width - (button_width * 2), 1, TRUE);
					render_y = y + MAX (0, (self->height - text_height) / 2);
					_tmp51_ = self->shortcut_font_color;
					_tmp52_ = self->shortcut_font_color;
					_tmp53_ = self->shortcut_font_color;
					_tmp54_ = self->shortcut_font_color;
					cairo_set_source_rgba (cr, _tmp51_.red, _tmp52_.green, _tmp53_.blue, _tmp54_.alpha);
					cairo_move_to (cr, (gdouble) ((x + ((key_width - text_width) / 2)) + self->shortcut_key_padding_x), (gdouble) render_y);
					_tmp55_ = layout;
					pango_cairo_update_layout (cr, _tmp55_);
					_tmp56_ = layout;
					pango_cairo_show_layout (cr, _tmp56_);
					x += (key_width + self->shortcut_key_spacing) + (self->shortcut_key_padding_x * 2);
					_g_object_unref0 (layout);
					__vala_PangoFontDescription_free0 (font_description);
					_g_free0 (key);
				}
			}
		}
		shortcut_keys = (_vala_array_free (shortcut_keys, shortcut_keys_length1, (GDestroyNotify) g_free), NULL);
	}
	result = TRUE;
	return result;
}

static void
widgets_shortcut_entry_class_init (WidgetsShortcutEntryClass * klass,
                                   gpointer klass_data)
{
	widgets_shortcut_entry_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = widgets_shortcut_entry_finalize;
	widgets_shortcut_entry_signals[WIDGETS_SHORTCUT_ENTRY_CHANGE_KEY_SIGNAL] = g_signal_new ("change-key", WIDGETS_TYPE_SHORTCUT_ENTRY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
widgets_shortcut_entry_instance_init (WidgetsShortcutEntry * self,
                                      gpointer klass)
{
	gchar* _tmp0_;
	self->is_double_clicked = FALSE;
	self->double_clicked_max_delay = 150;
	self->height = 24;
	self->shortcut_font_padding_x = 4;
	self->shortcut_font_padding_y = 0;
	self->shortcut_font_size = 8;
	self->shortcut_key_padding_x = 4;
	self->shortcut_key_padding_y = 0;
	self->shortcut_key_spacing = 5;
	_tmp0_ = g_strdup ("");
	self->shortcut = _tmp0_;
}

static void
widgets_shortcut_entry_finalize (GObject * obj)
{
	WidgetsShortcutEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WIDGETS_TYPE_SHORTCUT_ENTRY, WidgetsShortcutEntry);
	_cairo_surface_destroy0 (self->button_left_surface);
	_cairo_surface_destroy0 (self->button_right_surface);
	_g_free0 (self->shortcut);
	G_OBJECT_CLASS (widgets_shortcut_entry_parent_class)->finalize (obj);
}

static GType
widgets_shortcut_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WidgetsShortcutEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) widgets_shortcut_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WidgetsShortcutEntry), 0, (GInstanceInitFunc) widgets_shortcut_entry_instance_init, NULL };
	GType widgets_shortcut_entry_type_id;
	widgets_shortcut_entry_type_id = g_type_register_static (gtk_event_box_get_type (), "WidgetsShortcutEntry", &g_define_type_info, 0);
	return widgets_shortcut_entry_type_id;
}

GType
widgets_shortcut_entry_get_type (void)
{
	static volatile gsize widgets_shortcut_entry_type_id__once = 0;
	if (g_once_init_enter (&widgets_shortcut_entry_type_id__once)) {
		GType widgets_shortcut_entry_type_id;
		widgets_shortcut_entry_type_id = widgets_shortcut_entry_get_type_once ();
		g_once_init_leave (&widgets_shortcut_entry_type_id__once, widgets_shortcut_entry_type_id);
	}
	return widgets_shortcut_entry_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

