/* preference_slidebar.c generated by valac 0.56.17, the Vala compiler
 * generated from preference_slidebar.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2011 ~ 2018 Deepin, Inc.
 *               2011 ~ 2018 Wang Yong
 *
 * Author:     Wang Yong <wangyong@deepin.com>
 * Maintainer: Wang Yong <wangyong@deepin.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>

#define GETTEXT_PACKAGE "deepin-terminal-gtk"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define WIDGETS_TYPE_PREFERENCE_SLIDEBAR (widgets_preference_slidebar_get_type ())
#define WIDGETS_PREFERENCE_SLIDEBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_PREFERENCE_SLIDEBAR, WidgetsPreferenceSlidebar))
#define WIDGETS_PREFERENCE_SLIDEBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_PREFERENCE_SLIDEBAR, WidgetsPreferenceSlidebarClass))
#define WIDGETS_IS_PREFERENCE_SLIDEBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_PREFERENCE_SLIDEBAR))
#define WIDGETS_IS_PREFERENCE_SLIDEBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_PREFERENCE_SLIDEBAR))
#define WIDGETS_PREFERENCE_SLIDEBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_PREFERENCE_SLIDEBAR, WidgetsPreferenceSlidebarClass))

typedef struct _WidgetsPreferenceSlidebar WidgetsPreferenceSlidebar;
typedef struct _WidgetsPreferenceSlidebarClass WidgetsPreferenceSlidebarClass;
typedef struct _WidgetsPreferenceSlidebarPrivate WidgetsPreferenceSlidebarPrivate;

#define WIDGETS_TYPE_PREFERENCE_SLIDE_ITEM (widgets_preference_slide_item_get_type ())
#define WIDGETS_PREFERENCE_SLIDE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_PREFERENCE_SLIDE_ITEM, WidgetsPreferenceSlideItem))
#define WIDGETS_PREFERENCE_SLIDE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_PREFERENCE_SLIDE_ITEM, WidgetsPreferenceSlideItemClass))
#define WIDGETS_IS_PREFERENCE_SLIDE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_PREFERENCE_SLIDE_ITEM))
#define WIDGETS_IS_PREFERENCE_SLIDE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_PREFERENCE_SLIDE_ITEM))
#define WIDGETS_PREFERENCE_SLIDE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_PREFERENCE_SLIDE_ITEM, WidgetsPreferenceSlideItemClass))

typedef struct _WidgetsPreferenceSlideItem WidgetsPreferenceSlideItem;
typedef struct _WidgetsPreferenceSlideItemClass WidgetsPreferenceSlideItemClass;
enum  {
	WIDGETS_PREFERENCE_SLIDEBAR_0_PROPERTY,
	WIDGETS_PREFERENCE_SLIDEBAR_NUM_PROPERTIES
};
static GParamSpec* widgets_preference_slidebar_properties[WIDGETS_PREFERENCE_SLIDEBAR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _WidgetsPreferenceSlideItemPrivate WidgetsPreferenceSlideItemPrivate;
typedef struct _Block22Data Block22Data;
enum  {
	WIDGETS_PREFERENCE_SLIDEBAR_CLICK_ITEM_SIGNAL,
	WIDGETS_PREFERENCE_SLIDEBAR_NUM_SIGNALS
};
static guint widgets_preference_slidebar_signals[WIDGETS_PREFERENCE_SLIDEBAR_NUM_SIGNALS] = {0};
enum  {
	WIDGETS_PREFERENCE_SLIDE_ITEM_0_PROPERTY,
	WIDGETS_PREFERENCE_SLIDE_ITEM_NUM_PROPERTIES
};
static GParamSpec* widgets_preference_slide_item_properties[WIDGETS_PREFERENCE_SLIDE_ITEM_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block23Data Block23Data;

struct _WidgetsPreferenceSlidebar {
	GtkGrid parent_instance;
	WidgetsPreferenceSlidebarPrivate * priv;
	WidgetsPreferenceSlideItem* advanced_key_segment;
	WidgetsPreferenceSlideItem* advanced_segment;
	WidgetsPreferenceSlideItem* basic_segment;
	WidgetsPreferenceSlideItem* cursor_segment;
	WidgetsPreferenceSlideItem* focus_segment_item;
	WidgetsPreferenceSlideItem* hotkey_segment;
	WidgetsPreferenceSlideItem* scroll_segment;
	WidgetsPreferenceSlideItem* terminal_key_segment;
	WidgetsPreferenceSlideItem* theme_segment;
	WidgetsPreferenceSlideItem* window_segment;
	WidgetsPreferenceSlideItem* workspace_key_segment;
	gint height;
	gint segment_spacing;
	gint width;
};

struct _WidgetsPreferenceSlidebarClass {
	GtkGridClass parent_class;
};

struct _WidgetsPreferenceSlideItem {
	GtkEventBox parent_instance;
	WidgetsPreferenceSlideItemPrivate * priv;
	gchar* item_name;
	gboolean item_active;
	gboolean is_first_segment;
	gint first_segment_margin;
	gint second_segment_margin;
	gint first_segment_size;
	gint second_segment_size;
	GdkRGBA first_segment_text_color;
	GdkRGBA second_segment_text_color;
	GdkRGBA highlight_text_color;
	gboolean is_selected;
	gint width;
	gint height;
};

struct _WidgetsPreferenceSlideItemClass {
	GtkEventBoxClass parent_class;
};

struct _Block22Data {
	int _ref_count_;
	WidgetsPreferenceSlidebar* self;
	WidgetsPreferenceSlideItem* item;
};

struct _Block23Data {
	int _ref_count_;
	WidgetsPreferenceSlideItem* self;
	WidgetsPreferenceSlidebar* bar;
	gchar* name;
};

static gpointer widgets_preference_slidebar_parent_class = NULL;
VALA_EXTERN gint constant_PREFERENCE_SLIDEBAR_WIDTH;
VALA_EXTERN gint constant_TITLEBAR_HEIGHT;
static gpointer widgets_preference_slide_item_parent_class = NULL;

VALA_EXTERN GType widgets_preference_slidebar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsPreferenceSlidebar, g_object_unref)
VALA_EXTERN GType widgets_preference_slide_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsPreferenceSlideItem, g_object_unref)
VALA_EXTERN WidgetsPreferenceSlidebar* widgets_preference_slidebar_new (void);
VALA_EXTERN WidgetsPreferenceSlidebar* widgets_preference_slidebar_construct (GType object_type);
VALA_EXTERN WidgetsPreferenceSlideItem* widgets_preference_slide_item_new (WidgetsPreferenceSlidebar* bar,
                                                               const gchar* display_name,
                                                               const gchar* name,
                                                               gboolean is_first);
VALA_EXTERN WidgetsPreferenceSlideItem* widgets_preference_slide_item_construct (GType object_type,
                                                                     WidgetsPreferenceSlidebar* bar,
                                                                     const gchar* display_name,
                                                                     const gchar* name,
                                                                     gboolean is_first);
VALA_EXTERN void widgets_preference_slidebar_add_focus_handler (WidgetsPreferenceSlidebar* self,
                                                    WidgetsPreferenceSlideItem* item);
VALA_EXTERN void widgets_preference_slidebar_focus_item (WidgetsPreferenceSlidebar* self,
                                             WidgetsPreferenceSlideItem* item);
static gboolean widgets_preference_slidebar_on_draw (WidgetsPreferenceSlidebar* self,
                                              GtkWidget* widget,
                                              cairo_t* cr);
static gboolean _widgets_preference_slidebar_on_draw_gtk_widget_draw (GtkWidget* _sender,
                                                               cairo_t* cr,
                                                               gpointer self);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
static gboolean __lambda168_ (Block22Data* _data22_,
                       GtkWidget* w,
                       GdkEventButton* e);
static gboolean ___lambda168__gtk_widget_button_press_event (GtkWidget* _sender,
                                                      GdkEventButton* event,
                                                      gpointer self);
VALA_EXTERN void draw_draw_rectangle (cairo_t* cr,
                          gint x,
                          gint y,
                          gint w,
                          gint h,
                          gboolean fill);
static void widgets_preference_slidebar_finalize (GObject * obj);
static GType widgets_preference_slidebar_get_type_once (void);
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void block23_data_unref (void * _userdata_);
VALA_EXTERN void utils_hex_to_rgba (const gchar* hex_color,
                        gdouble alpha,
                        GdkRGBA* result);
static gboolean __lambda167_ (Block23Data* _data23_,
                       GtkWidget* w,
                       GdkEventButton* e);
static gboolean ___lambda167__gtk_widget_button_press_event (GtkWidget* _sender,
                                                      GdkEventButton* event,
                                                      gpointer self);
static gboolean widgets_preference_slide_item_on_draw (WidgetsPreferenceSlideItem* self,
                                                GtkWidget* widget,
                                                cairo_t* cr);
static gboolean _widgets_preference_slide_item_on_draw_gtk_widget_draw (GtkWidget* _sender,
                                                                 cairo_t* cr,
                                                                 gpointer self);
VALA_EXTERN void utils_set_context_color (cairo_t* cr,
                              GdkRGBA* color);
VALA_EXTERN void draw_draw_text (cairo_t* cr,
                     const gchar* text,
                     gint x,
                     gint y,
                     gint width,
                     gint height,
                     gint size,
                     PangoAlignment horizontal_alignment,
                     const gchar* vertical_align,
                     gint* wrap_width);
static void widgets_preference_slide_item_finalize (GObject * obj);
static GType widgets_preference_slide_item_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gboolean
_widgets_preference_slidebar_on_draw_gtk_widget_draw (GtkWidget* _sender,
                                                      cairo_t* cr,
                                                      gpointer self)
{
	gboolean result;
	result = widgets_preference_slidebar_on_draw ((WidgetsPreferenceSlidebar*) self, _sender, cr);
	return result;
}

WidgetsPreferenceSlidebar*
widgets_preference_slidebar_construct (GType object_type)
{
	WidgetsPreferenceSlidebar * self = NULL;
	GtkBox* spacing_box = NULL;
	GtkBox* _tmp0_;
	WidgetsPreferenceSlideItem* _tmp1_;
	WidgetsPreferenceSlideItem* _tmp2_;
	WidgetsPreferenceSlideItem* _tmp3_;
	WidgetsPreferenceSlideItem* _tmp4_;
	WidgetsPreferenceSlideItem* _tmp5_;
	GtkBox* theme_spacing_box = NULL;
	GtkBox* _tmp6_;
	WidgetsPreferenceSlideItem* _tmp7_;
	WidgetsPreferenceSlideItem* _tmp8_;
	WidgetsPreferenceSlideItem* _tmp9_;
	WidgetsPreferenceSlideItem* _tmp10_;
	WidgetsPreferenceSlideItem* _tmp11_;
	WidgetsPreferenceSlideItem* _tmp12_;
	WidgetsPreferenceSlideItem* _tmp13_;
	WidgetsPreferenceSlideItem* _tmp14_;
	WidgetsPreferenceSlideItem* _tmp15_;
	WidgetsPreferenceSlideItem* _tmp16_;
	WidgetsPreferenceSlideItem* _tmp17_;
	WidgetsPreferenceSlideItem* _tmp18_;
	GtkBox* advanced_key_spacing_box = NULL;
	GtkBox* _tmp19_;
	WidgetsPreferenceSlideItem* _tmp20_;
	WidgetsPreferenceSlideItem* _tmp21_;
	WidgetsPreferenceSlideItem* _tmp22_;
	WidgetsPreferenceSlideItem* _tmp23_;
	WidgetsPreferenceSlideItem* _tmp24_;
	WidgetsPreferenceSlideItem* _tmp25_;
	WidgetsPreferenceSlideItem* _tmp26_;
	WidgetsPreferenceSlideItem* _tmp27_;
	WidgetsPreferenceSlideItem* _tmp28_;
	WidgetsPreferenceSlideItem* _tmp29_;
	WidgetsPreferenceSlideItem* _tmp30_;
	WidgetsPreferenceSlideItem* _tmp31_;
	GtkBox* window_spacing_box = NULL;
	GtkBox* _tmp32_;
	WidgetsPreferenceSlideItem* _tmp33_;
	WidgetsPreferenceSlideItem* _tmp34_;
	WidgetsPreferenceSlideItem* _tmp35_;
	WidgetsPreferenceSlideItem* _tmp36_;
	WidgetsPreferenceSlideItem* _tmp37_;
	WidgetsPreferenceSlideItem* _tmp38_;
	WidgetsPreferenceSlideItem* _tmp39_;
	WidgetsPreferenceSlideItem* _tmp40_;
	WidgetsPreferenceSlideItem* _tmp41_;
	WidgetsPreferenceSlideItem* _tmp42_;
	WidgetsPreferenceSlideItem* _tmp43_;
	WidgetsPreferenceSlideItem* _tmp44_;
	self = (WidgetsPreferenceSlidebar*) g_object_new (object_type, NULL);
	bindtextdomain (GETTEXT_PACKAGE, "/usr/share/locale");
	gtk_widget_set_size_request ((GtkWidget*) self, self->width, -1);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp0_);
	spacing_box = _tmp0_;
	gtk_widget_set_size_request ((GtkWidget*) spacing_box, -1, constant_TITLEBAR_HEIGHT);
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) spacing_box, 0, 0, self->width, self->height);
	_tmp1_ = widgets_preference_slide_item_new (self, _ ("Basic"), "basic", TRUE);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->basic_segment);
	self->basic_segment = _tmp1_;
	_tmp2_ = self->basic_segment;
	gtk_grid_attach_next_to ((GtkGrid*) self, (GtkWidget*) _tmp2_, (GtkWidget*) spacing_box, GTK_POS_BOTTOM, self->width, self->height);
	_tmp3_ = widgets_preference_slide_item_new (self, _ ("Interface"), "theme", FALSE);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->theme_segment);
	self->theme_segment = _tmp3_;
	_tmp4_ = self->theme_segment;
	_tmp5_ = self->basic_segment;
	gtk_grid_attach_next_to ((GtkGrid*) self, (GtkWidget*) _tmp4_, (GtkWidget*) _tmp5_, GTK_POS_BOTTOM, self->width, self->height);
	_tmp6_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp6_);
	theme_spacing_box = _tmp6_;
	gtk_widget_set_size_request ((GtkWidget*) theme_spacing_box, -1, self->segment_spacing);
	_tmp7_ = self->theme_segment;
	gtk_grid_attach_next_to ((GtkGrid*) self, (GtkWidget*) theme_spacing_box, (GtkWidget*) _tmp7_, GTK_POS_BOTTOM, self->width, self->height);
	_tmp8_ = widgets_preference_slide_item_new (self, _ ("Shortcuts"), "hotkey", TRUE);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->hotkey_segment);
	self->hotkey_segment = _tmp8_;
	_tmp9_ = self->hotkey_segment;
	gtk_grid_attach_next_to ((GtkGrid*) self, (GtkWidget*) _tmp9_, (GtkWidget*) theme_spacing_box, GTK_POS_BOTTOM, self->width, self->height);
	_tmp10_ = widgets_preference_slide_item_new (self, _ ("Terminal"), "terminal_key", FALSE);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->terminal_key_segment);
	self->terminal_key_segment = _tmp10_;
	_tmp11_ = self->terminal_key_segment;
	_tmp12_ = self->hotkey_segment;
	gtk_grid_attach_next_to ((GtkGrid*) self, (GtkWidget*) _tmp11_, (GtkWidget*) _tmp12_, GTK_POS_BOTTOM, self->width, self->height);
	_tmp13_ = widgets_preference_slide_item_new (self, _ ("Workspace"), "workspace_key", FALSE);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->workspace_key_segment);
	self->workspace_key_segment = _tmp13_;
	_tmp14_ = self->workspace_key_segment;
	_tmp15_ = self->terminal_key_segment;
	gtk_grid_attach_next_to ((GtkGrid*) self, (GtkWidget*) _tmp14_, (GtkWidget*) _tmp15_, GTK_POS_BOTTOM, self->width, self->height);
	_tmp16_ = widgets_preference_slide_item_new (self, _ ("Advanced"), "advanced_key", FALSE);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->advanced_key_segment);
	self->advanced_key_segment = _tmp16_;
	_tmp17_ = self->advanced_key_segment;
	_tmp18_ = self->workspace_key_segment;
	gtk_grid_attach_next_to ((GtkGrid*) self, (GtkWidget*) _tmp17_, (GtkWidget*) _tmp18_, GTK_POS_BOTTOM, self->width, self->height);
	_tmp19_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp19_);
	advanced_key_spacing_box = _tmp19_;
	gtk_widget_set_size_request ((GtkWidget*) advanced_key_spacing_box, -1, self->segment_spacing);
	_tmp20_ = self->advanced_key_segment;
	gtk_grid_attach_next_to ((GtkGrid*) self, (GtkWidget*) advanced_key_spacing_box, (GtkWidget*) _tmp20_, GTK_POS_BOTTOM, self->width, self->height);
	_tmp21_ = widgets_preference_slide_item_new (self, _ ("Advanced"), "advanced", TRUE);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->advanced_segment);
	self->advanced_segment = _tmp21_;
	_tmp22_ = self->advanced_segment;
	gtk_grid_attach_next_to ((GtkGrid*) self, (GtkWidget*) _tmp22_, (GtkWidget*) advanced_key_spacing_box, GTK_POS_BOTTOM, self->width, self->height);
	_tmp23_ = widgets_preference_slide_item_new (self, _ ("Cursor"), "cursor", FALSE);
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->cursor_segment);
	self->cursor_segment = _tmp23_;
	_tmp24_ = self->cursor_segment;
	_tmp25_ = self->advanced_segment;
	gtk_grid_attach_next_to ((GtkGrid*) self, (GtkWidget*) _tmp24_, (GtkWidget*) _tmp25_, GTK_POS_BOTTOM, self->width, self->height);
	_tmp26_ = widgets_preference_slide_item_new (self, _ ("Scroll"), "scroll", FALSE);
	g_object_ref_sink (_tmp26_);
	_g_object_unref0 (self->scroll_segment);
	self->scroll_segment = _tmp26_;
	_tmp27_ = self->scroll_segment;
	_tmp28_ = self->cursor_segment;
	gtk_grid_attach_next_to ((GtkGrid*) self, (GtkWidget*) _tmp27_, (GtkWidget*) _tmp28_, GTK_POS_BOTTOM, self->width, self->height);
	_tmp29_ = widgets_preference_slide_item_new (self, _ ("Window"), "window", FALSE);
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (self->window_segment);
	self->window_segment = _tmp29_;
	_tmp30_ = self->window_segment;
	_tmp31_ = self->scroll_segment;
	gtk_grid_attach_next_to ((GtkGrid*) self, (GtkWidget*) _tmp30_, (GtkWidget*) _tmp31_, GTK_POS_BOTTOM, self->width, self->height);
	_tmp32_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp32_);
	window_spacing_box = _tmp32_;
	gtk_widget_set_size_request ((GtkWidget*) window_spacing_box, -1, self->segment_spacing);
	_tmp33_ = self->window_segment;
	gtk_grid_attach_next_to ((GtkGrid*) self, (GtkWidget*) window_spacing_box, (GtkWidget*) _tmp33_, GTK_POS_BOTTOM, self->width, self->height);
	_tmp34_ = self->basic_segment;
	widgets_preference_slidebar_add_focus_handler (self, _tmp34_);
	_tmp35_ = self->theme_segment;
	widgets_preference_slidebar_add_focus_handler (self, _tmp35_);
	_tmp36_ = self->hotkey_segment;
	widgets_preference_slidebar_add_focus_handler (self, _tmp36_);
	_tmp37_ = self->terminal_key_segment;
	widgets_preference_slidebar_add_focus_handler (self, _tmp37_);
	_tmp38_ = self->workspace_key_segment;
	widgets_preference_slidebar_add_focus_handler (self, _tmp38_);
	_tmp39_ = self->advanced_key_segment;
	widgets_preference_slidebar_add_focus_handler (self, _tmp39_);
	_tmp40_ = self->advanced_segment;
	widgets_preference_slidebar_add_focus_handler (self, _tmp40_);
	_tmp41_ = self->cursor_segment;
	widgets_preference_slidebar_add_focus_handler (self, _tmp41_);
	_tmp42_ = self->scroll_segment;
	widgets_preference_slidebar_add_focus_handler (self, _tmp42_);
	_tmp43_ = self->window_segment;
	widgets_preference_slidebar_add_focus_handler (self, _tmp43_);
	_tmp44_ = self->basic_segment;
	widgets_preference_slidebar_focus_item (self, _tmp44_);
	g_signal_connect_object ((GtkWidget*) self, "draw", (GCallback) _widgets_preference_slidebar_on_draw_gtk_widget_draw, self, 0);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (window_spacing_box);
	_g_object_unref0 (advanced_key_spacing_box);
	_g_object_unref0 (theme_spacing_box);
	_g_object_unref0 (spacing_box);
	return self;
}

WidgetsPreferenceSlidebar*
widgets_preference_slidebar_new (void)
{
	return widgets_preference_slidebar_construct (WIDGETS_TYPE_PREFERENCE_SLIDEBAR);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
widgets_preference_slidebar_focus_item (WidgetsPreferenceSlidebar* self,
                                        WidgetsPreferenceSlideItem* item)
{
	WidgetsPreferenceSlideItem* _tmp0_;
	WidgetsPreferenceSlideItem* _tmp3_;
	WidgetsPreferenceSlideItem* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = self->focus_segment_item;
	if (_tmp0_ != NULL) {
		WidgetsPreferenceSlideItem* _tmp1_;
		WidgetsPreferenceSlideItem* _tmp2_;
		_tmp1_ = self->focus_segment_item;
		_tmp1_->is_selected = FALSE;
		_tmp2_ = self->focus_segment_item;
		gtk_widget_queue_draw ((GtkWidget*) _tmp2_);
	}
	_tmp3_ = _g_object_ref0 (item);
	_g_object_unref0 (self->focus_segment_item);
	self->focus_segment_item = _tmp3_;
	_tmp4_ = self->focus_segment_item;
	_tmp4_->is_selected = TRUE;
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static Block22Data*
block22_data_ref (Block22Data* _data22_)
{
	g_atomic_int_inc (&_data22_->_ref_count_);
	return _data22_;
}

static void
block22_data_unref (void * _userdata_)
{
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
		WidgetsPreferenceSlidebar* self;
		self = _data22_->self;
		_g_object_unref0 (_data22_->item);
		_g_object_unref0 (self);
		g_slice_free (Block22Data, _data22_);
	}
}

static gboolean
__lambda168_ (Block22Data* _data22_,
              GtkWidget* w,
              GdkEventButton* e)
{
	WidgetsPreferenceSlidebar* self;
	gboolean result;
	self = _data22_->self;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	widgets_preference_slidebar_focus_item (self, _data22_->item);
	result = FALSE;
	return result;
}

static gboolean
___lambda168__gtk_widget_button_press_event (GtkWidget* _sender,
                                             GdkEventButton* event,
                                             gpointer self)
{
	gboolean result;
	result = __lambda168_ (self, _sender, event);
	return result;
}

void
widgets_preference_slidebar_add_focus_handler (WidgetsPreferenceSlidebar* self,
                                               WidgetsPreferenceSlideItem* item)
{
	Block22Data* _data22_;
	WidgetsPreferenceSlideItem* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_data22_ = g_slice_new0 (Block22Data);
	_data22_->_ref_count_ = 1;
	_data22_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (item);
	_g_object_unref0 (_data22_->item);
	_data22_->item = _tmp0_;
	g_signal_connect_data ((GtkWidget*) _data22_->item, "button-press-event", (GCallback) ___lambda168__gtk_widget_button_press_event, block22_data_ref (_data22_), (GClosureNotify) block22_data_unref, 0);
	block22_data_unref (_data22_);
	_data22_ = NULL;
}

static gboolean
widgets_preference_slidebar_on_draw (WidgetsPreferenceSlidebar* self,
                                     GtkWidget* widget,
                                     cairo_t* cr)
{
	GtkAllocation alloc = {0};
	GtkAllocation _tmp0_ = {0};
	GtkAllocation _tmp1_;
	GtkAllocation _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (cr != NULL, FALSE);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
	alloc = _tmp0_;
	cairo_set_source_rgba (cr, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.1);
	_tmp1_ = alloc;
	_tmp2_ = alloc;
	draw_draw_rectangle (cr, _tmp1_.width - 1, 0, 1, _tmp2_.height, TRUE);
	result = FALSE;
	return result;
}

static void
widgets_preference_slidebar_class_init (WidgetsPreferenceSlidebarClass * klass,
                                        gpointer klass_data)
{
	widgets_preference_slidebar_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = widgets_preference_slidebar_finalize;
	widgets_preference_slidebar_signals[WIDGETS_PREFERENCE_SLIDEBAR_CLICK_ITEM_SIGNAL] = g_signal_new ("click-item", WIDGETS_TYPE_PREFERENCE_SLIDEBAR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
widgets_preference_slidebar_instance_init (WidgetsPreferenceSlidebar * self,
                                           gpointer klass)
{
	self->height = 30;
	self->segment_spacing = 20;
	self->width = constant_PREFERENCE_SLIDEBAR_WIDTH;
}

static void
widgets_preference_slidebar_finalize (GObject * obj)
{
	WidgetsPreferenceSlidebar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WIDGETS_TYPE_PREFERENCE_SLIDEBAR, WidgetsPreferenceSlidebar);
	_g_object_unref0 (self->advanced_key_segment);
	_g_object_unref0 (self->advanced_segment);
	_g_object_unref0 (self->basic_segment);
	_g_object_unref0 (self->cursor_segment);
	_g_object_unref0 (self->focus_segment_item);
	_g_object_unref0 (self->hotkey_segment);
	_g_object_unref0 (self->scroll_segment);
	_g_object_unref0 (self->terminal_key_segment);
	_g_object_unref0 (self->theme_segment);
	_g_object_unref0 (self->window_segment);
	_g_object_unref0 (self->workspace_key_segment);
	G_OBJECT_CLASS (widgets_preference_slidebar_parent_class)->finalize (obj);
}

static GType
widgets_preference_slidebar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WidgetsPreferenceSlidebarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) widgets_preference_slidebar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WidgetsPreferenceSlidebar), 0, (GInstanceInitFunc) widgets_preference_slidebar_instance_init, NULL };
	GType widgets_preference_slidebar_type_id;
	widgets_preference_slidebar_type_id = g_type_register_static (gtk_grid_get_type (), "WidgetsPreferenceSlidebar", &g_define_type_info, 0);
	return widgets_preference_slidebar_type_id;
}

GType
widgets_preference_slidebar_get_type (void)
{
	static volatile gsize widgets_preference_slidebar_type_id__once = 0;
	if (g_once_init_enter (&widgets_preference_slidebar_type_id__once)) {
		GType widgets_preference_slidebar_type_id;
		widgets_preference_slidebar_type_id = widgets_preference_slidebar_get_type_once ();
		g_once_init_leave (&widgets_preference_slidebar_type_id__once, widgets_preference_slidebar_type_id);
	}
	return widgets_preference_slidebar_type_id__once;
}

static Block23Data*
block23_data_ref (Block23Data* _data23_)
{
	g_atomic_int_inc (&_data23_->_ref_count_);
	return _data23_;
}

static void
block23_data_unref (void * _userdata_)
{
	Block23Data* _data23_;
	_data23_ = (Block23Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
		WidgetsPreferenceSlideItem* self;
		self = _data23_->self;
		_g_object_unref0 (_data23_->bar);
		_g_free0 (_data23_->name);
		_g_object_unref0 (self);
		g_slice_free (Block23Data, _data23_);
	}
}

static gboolean
__lambda167_ (Block23Data* _data23_,
              GtkWidget* w,
              GdkEventButton* e)
{
	WidgetsPreferenceSlideItem* self;
	gboolean result;
	self = _data23_->self;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	g_signal_emit (_data23_->bar, widgets_preference_slidebar_signals[WIDGETS_PREFERENCE_SLIDEBAR_CLICK_ITEM_SIGNAL], 0, _data23_->name);
	result = FALSE;
	return result;
}

static gboolean
___lambda167__gtk_widget_button_press_event (GtkWidget* _sender,
                                             GdkEventButton* event,
                                             gpointer self)
{
	gboolean result;
	result = __lambda167_ (self, _sender, event);
	return result;
}

static gboolean
_widgets_preference_slide_item_on_draw_gtk_widget_draw (GtkWidget* _sender,
                                                        cairo_t* cr,
                                                        gpointer self)
{
	gboolean result;
	result = widgets_preference_slide_item_on_draw ((WidgetsPreferenceSlideItem*) self, _sender, cr);
	return result;
}

WidgetsPreferenceSlideItem*
widgets_preference_slide_item_construct (GType object_type,
                                         WidgetsPreferenceSlidebar* bar,
                                         const gchar* display_name,
                                         const gchar* name,
                                         gboolean is_first)
{
	WidgetsPreferenceSlideItem * self = NULL;
	Block23Data* _data23_;
	WidgetsPreferenceSlidebar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GdkRGBA _tmp3_ = {0};
	GdkRGBA _tmp4_ = {0};
	GdkRGBA _tmp5_ = {0};
	g_return_val_if_fail (bar != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_data23_ = g_slice_new0 (Block23Data);
	_data23_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (bar);
	_g_object_unref0 (_data23_->bar);
	_data23_->bar = _tmp0_;
	_tmp1_ = g_strdup (name);
	_g_free0 (_data23_->name);
	_data23_->name = _tmp1_;
	self = (WidgetsPreferenceSlideItem*) g_object_new (object_type, NULL);
	_data23_->self = g_object_ref (self);
	gtk_event_box_set_visible_window ((GtkEventBox*) self, FALSE);
	_tmp2_ = g_strdup (display_name);
	_g_free0 (self->item_name);
	self->item_name = _tmp2_;
	self->is_first_segment = is_first;
	utils_hex_to_rgba ("#00162C", 1.0, &_tmp3_);
	self->first_segment_text_color = _tmp3_;
	utils_hex_to_rgba ("#303030", 1.0, &_tmp4_);
	self->second_segment_text_color = _tmp4_;
	utils_hex_to_rgba ("#2ca7f8", 1.0, &_tmp5_);
	self->highlight_text_color = _tmp5_;
	gtk_widget_set_size_request ((GtkWidget*) self, self->width, self->height);
	g_signal_connect_data ((GtkWidget*) self, "button-press-event", (GCallback) ___lambda167__gtk_widget_button_press_event, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
	g_signal_connect_object ((GtkWidget*) self, "draw", (GCallback) _widgets_preference_slide_item_on_draw_gtk_widget_draw, self, 0);
	block23_data_unref (_data23_);
	_data23_ = NULL;
	return self;
}

WidgetsPreferenceSlideItem*
widgets_preference_slide_item_new (WidgetsPreferenceSlidebar* bar,
                                   const gchar* display_name,
                                   const gchar* name,
                                   gboolean is_first)
{
	return widgets_preference_slide_item_construct (WIDGETS_TYPE_PREFERENCE_SLIDE_ITEM, bar, display_name, name, is_first);
}

static gboolean
widgets_preference_slide_item_on_draw (WidgetsPreferenceSlideItem* self,
                                       GtkWidget* widget,
                                       cairo_t* cr)
{
	GtkAllocation rect = {0};
	GtkAllocation _tmp0_ = {0};
	GtkAllocation _tmp1_;
	GtkAllocation _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (cr != NULL, FALSE);
	gtk_widget_get_allocation (widget, &_tmp0_);
	rect = _tmp0_;
	cairo_set_source_rgba (cr, (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	_tmp1_ = rect;
	_tmp2_ = rect;
	draw_draw_rectangle (cr, 0, 0, _tmp1_.width - 1, _tmp2_.height, TRUE);
	if (self->is_selected) {
		GtkAllocation _tmp3_;
		GtkAllocation _tmp4_;
		GtkAllocation _tmp5_;
		GtkAllocation _tmp6_;
		GtkAllocation _tmp7_;
		GtkAllocation _tmp8_;
		GtkAllocation _tmp9_;
		cairo_set_source_rgba (cr, 43 / 255.0, 167 / 255.0, 248 / 255.0, 0.20);
		_tmp3_ = rect;
		_tmp4_ = rect;
		draw_draw_rectangle (cr, 0, 0, _tmp3_.width, _tmp4_.height, TRUE);
		cairo_set_source_rgba (cr, 43 / 255.0, 167 / 255.0, 248 / 255.0, 0.10);
		_tmp5_ = rect;
		draw_draw_rectangle (cr, 0, 0, _tmp5_.width, 1, TRUE);
		cairo_set_source_rgba (cr, 43 / 255.0, 167 / 255.0, 248 / 255.0, 0.10);
		_tmp6_ = rect;
		_tmp7_ = rect;
		draw_draw_rectangle (cr, 0, _tmp6_.height - 1, _tmp7_.width, 1, TRUE);
		cairo_set_source_rgba (cr, 43 / 255.0, 167 / 255.0, 248 / 255.0, (gdouble) 1);
		_tmp8_ = rect;
		_tmp9_ = rect;
		draw_draw_rectangle (cr, _tmp8_.width - 3, 0, 3, _tmp9_.height, TRUE);
	}
	if (self->is_first_segment) {
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		GtkAllocation _tmp17_;
		GtkAllocation _tmp18_;
		if (self->is_selected) {
			GdkRGBA _tmp10_;
			_tmp10_ = self->highlight_text_color;
			utils_set_context_color (cr, &_tmp10_);
		} else {
			GdkRGBA _tmp11_;
			_tmp11_ = self->first_segment_text_color;
			utils_set_context_color (cr, &_tmp11_);
		}
		_tmp12_ = self->item_name;
		_tmp13_ = g_strconcat ("<b>", _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat (_tmp14_, "</b>", NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = rect;
		_tmp18_ = rect;
		draw_draw_text (cr, _tmp16_, self->first_segment_margin, 0, _tmp17_.width - self->first_segment_margin, _tmp18_.height, self->first_segment_size, PANGO_ALIGN_LEFT, "middle", NULL);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp14_);
	} else {
		const gchar* _tmp21_;
		GtkAllocation _tmp22_;
		GtkAllocation _tmp23_;
		if (self->is_selected) {
			GdkRGBA _tmp19_;
			_tmp19_ = self->highlight_text_color;
			utils_set_context_color (cr, &_tmp19_);
		} else {
			GdkRGBA _tmp20_;
			_tmp20_ = self->second_segment_text_color;
			utils_set_context_color (cr, &_tmp20_);
		}
		_tmp21_ = self->item_name;
		_tmp22_ = rect;
		_tmp23_ = rect;
		draw_draw_text (cr, _tmp21_, self->second_segment_margin, 0, _tmp22_.width - self->second_segment_margin, _tmp23_.height, self->second_segment_size, PANGO_ALIGN_LEFT, "middle", NULL);
	}
	result = TRUE;
	return result;
}

static void
widgets_preference_slide_item_class_init (WidgetsPreferenceSlideItemClass * klass,
                                          gpointer klass_data)
{
	widgets_preference_slide_item_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = widgets_preference_slide_item_finalize;
}

static void
widgets_preference_slide_item_instance_init (WidgetsPreferenceSlideItem * self,
                                             gpointer klass)
{
	self->first_segment_margin = 30;
	self->second_segment_margin = 40;
	self->first_segment_size = 12;
	self->second_segment_size = 10;
	self->is_selected = FALSE;
	self->width = constant_PREFERENCE_SLIDEBAR_WIDTH;
	self->height = 30;
}

static void
widgets_preference_slide_item_finalize (GObject * obj)
{
	WidgetsPreferenceSlideItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WIDGETS_TYPE_PREFERENCE_SLIDE_ITEM, WidgetsPreferenceSlideItem);
	_g_free0 (self->item_name);
	G_OBJECT_CLASS (widgets_preference_slide_item_parent_class)->finalize (obj);
}

static GType
widgets_preference_slide_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WidgetsPreferenceSlideItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) widgets_preference_slide_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WidgetsPreferenceSlideItem), 0, (GInstanceInitFunc) widgets_preference_slide_item_instance_init, NULL };
	GType widgets_preference_slide_item_type_id;
	widgets_preference_slide_item_type_id = g_type_register_static (gtk_event_box_get_type (), "WidgetsPreferenceSlideItem", &g_define_type_info, 0);
	return widgets_preference_slide_item_type_id;
}

GType
widgets_preference_slide_item_get_type (void)
{
	static volatile gsize widgets_preference_slide_item_type_id__once = 0;
	if (g_once_init_enter (&widgets_preference_slide_item_type_id__once)) {
		GType widgets_preference_slide_item_type_id;
		widgets_preference_slide_item_type_id = widgets_preference_slide_item_get_type_once ();
		g_once_init_leave (&widgets_preference_slide_item_type_id__once, widgets_preference_slide_item_type_id);
	}
	return widgets_preference_slide_item_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

