/*
 * Copyright (C) 2022 Uniontech Software Technology Co., Ltd.
 *
 * Author:     liuzhangjian<liuzhangjian@uniontech.com>
 *
 * Maintainer: liuzhangjian<liuzhangjian@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include "fsearch_pinyin.h"

#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>
#include <memory.h>

// the basic chinese word's unicode map
static const char basic_dict[] = "yi    ding  kao   qi    shang xia   mu    wan   zhang san   shang xia   ji    bu    yu    mian  gai   chou  chou  zhuan qie   pi    shi   shi   qiu   bing  ye    cong  dong  si    cheng diu   qiu   liang diu   you   liang yan   bing  sang  gun   jiu   ge    ya    zhuangzhong ji    jie   feng  guan  chuan chan  lin   zhuo  zhu   ha    wan   dan   wei   zhu   jing  li    ju    pie   fu    yi    yi    nai   wu    jiu   jiu   tuo   me    yi    ho    zhi   wu    zha   hu    fa    le    yin   ping  pang  qiao  hu    guai  cheng cheng yi    yin   wan   mie   jiu   qi    ye    xi    xiang gai   jiu   hai   ho    shu   dou   shi   ji    nang  kai   keng  ting  mo    ou    mai   luan  cai   ru    xue   yan   peng  sha   na    qian  si    er    cui   ceng  qian  zhi   gui   gan   luan  lin   yi    jue   liao  ma    yu    zheng shi   shi   er    chu   yu    kui   yu    yun   hu    qi    wu    jing  si    sui   gen   geng  ya    xie   ya    qi    ya    ji    tou   wang  kang  da    jiao  hai   yi    chan  heng  mu    ye    xiang jing  ting  liang xiang jing  ye    qin   bo    you   xie   dan   lian  duo   wei   ren   ren   ji    ra    wang  yi    shi   ren   le    ding  ze    jin   pu    chou  ba    zhang jin   jie   bing  reng  cong  fo    tao   lun   er    cang  zai   shi   ta    zhang fu    xian  xian  duo   hong  tong  ren   qian  gan   yi    bo    dai   ling  yi    chao  chang sa    shang yi    mu    men   ren   fan   chao  yang  qian  zhong pi    wo    wu    jian  jia   yao   feng  cang  ren   wang  fen   di    fang  zhong qi    pei   yu    diao  dun   wu    yi    xin   kang  yi    ji    ai    wu    ji    fu    fa    xiu   jin   pi    dan   fu    nu    zhong you   huo   hui   yu    cui   yun   san   wei   chuan che   ya    qian  shang chang lun   cang  xun   xin   wei   zhu   ze    xian  nu    bo    gu    ni    ni    xie   ban   xu    ling  zhou  shen  qu    si    beng  si    ga    pi    yi    si    yi    zheng dian  han   mai   dan   zhu   bu    qu    bi    zhao  ci    wei   di    zhu   zuo   you   yang  ti    zhan  he    bi    tuo   she   yu    yi    fo    zuo   gou   ning  tong  ni    xian  qu    yong  wa    qian  shi   ka    bao   pei   hui   he    lao   xiang ge    yang  bai   fa    ming  jia   er    bing  ji    hen   huo   gui   quan  tiao  jiao  ci    yi    shi   xing  shen  tuo   kan   zhi   gai   lai   yi    chi   kua   guang li    yin   shi   mi    zhu   xu    you   an    lu    mou   er    lun   dong  cha   chi   xun   gong  zhou  yi    ru    jian  xia   si    dai   lv    ta    jiao  zhen  ce    qiao  kuai  chai  ning  nong  jin   wu    hou   jiong cheng zhen  zuo   chou  qin   lv    ju    shu   ting  shen  tuo   bo    nan   xiao  bian  tui   yu    xi    cu    e     qiu   xu    guang ku    wu    jun   yi    fu    liang zu    qiao  li    yong  hun   jing  qian  san   pei   su    fu    xi    li    mian  ping  bao   yu    si    xia   xin   xiu   yu    di    che   chou  zhi   yan   lia   li    lai   si    jian  xiu   fu    huo   ju    xiao  pai   jian  biao  chu   fei   feng  ya    an    bei   yu    xin   bi    chi   chang zhi   bing  jiu   yao   cui   lia   wan   lai   cang  zong  ge    guan  bei   tian  shu   shu   men   dao   tan   jue   chui  xing  peng  tang  hou   yi    qi    ti    gan   jing  jie   sui   chang jie   fang  zhi   kong  juan  zong  ju    qian  ni    lun   zhuo  wo    luo   song  leng  hun   dong  zi    ben   wu    ju    nai   cai   jian  zhai  ye    zhi   sha   qing  qie   ying  cheng qian  yan   ruan  zhong chun  jia   ji    wei   yu    bing  ruo   ti    wei   pian  yan   feng  tang  wo    e     xie   che   sheng kan   di    zuo   cha   ting  bei   ye    huang yao   zhan  chou  yan   you   jian  xu    zha   ci    fu    bi    zhi   zong  mian  ji    yi    xie   xun   cai   duan  ce    zhen  ou    tou   tou   bei   zan   lou   jie   wei   fen   chang kui   sou   zhi   su    xia   fu    yuan  rong  li    nu    yun   jiang ma    bang  dian  tang  hao   jie   xi    shan  qian  jue   cang  chu   san   bei   xiao  yong  yao   tan   suo   yang  fa    bing  jia   dai   zai   tang  gu    bin   chu   nuo   can   lei   cui   yong  zao   zong  peng  song  ao    chuan yu    zhai  zu    shang chuangjing  chi   sha   han   zhang qing  yan   di    xie   lou   bei   piao  jin   lian  lu    man   qian  xian  tan   ying  dong  zhuan xiang shan  qiao  jiong tui   zun   pu    xi    lao   chang guang liao  qi    deng  chan  wei   ji    bo    hui   chuan tie   dan   jiao  jiu   se    fen   xian  ju    e     jiao  jian  tong  lin   bo    gu    xian  su    xian  jiang min   ye    jin   jia   qiao  pi    feng  zhou  ai    sai   yi    jun   nong  chan  yi    dang  jing  xuan  kuai  jian  chu   dan   jiao  sha   zai   can   bin   an    ru    tai   chou  chai  lan   ni    jin   qian  meng  wu    ning  qiong ni    chang lie   lei   lv    kuang bao   yu    biao  zan   zhi   si    you   hao   qing  chen  li    teng  wei   long  chu   chan  rang  shu   hui   li    luo   zan   nuo   tang  yan   lei   nang  er    wu    yun   zan   yuan  xiong chong zhao  xiong xian  guang dui   ke    dui   mian  tu    chang er    dui   er    jin   tu    si    yan   yan   shi   shi   dang  qiang dou   gong  hao   shen  dou   bai   jing  gong  huang ru    wang  nei   quan  liang yu    ba    gong  liu   xi    han   lan   gong  tian  guan  xing  bing  qi    ju    dian  zi    pou   yang  jian  shou  ji    yi    ji    chan  jiong mao   ran   na    yan   mao   gang  ran   ce    jiong ce    zai   gua   jiong mao   zhou  mao   gou   xu    mian  mi    rong  yin   xie   kan   jun   nong  yi    mi    shi   guan  meng  zhong ju    yuan  ming  kou   min   fu    xie   mi    bing  dong  tai   gang  feng  bing  hu    chong jue   hu    kuang ye    leng  pan   fu    min   dong  xian  lie   qia   jian  jing  sou   mei   tu    qi    gu    zhun  song  jing  liang qing  diao  ling  dong  gan   jian  yin   cou   ai    li    cang  ming  zhun  cui   si    duo   jin   lin   lin   ning  xi    du    ji    fan   fan   fan   feng  ju    chu   zheng feng  mu    zhi   fu    feng  ping  feng  kai   huang kai   gan   deng  ping  qian  xiong kuai  tu    ao    chu   ji    dang  han   han   zao   dao   diao  dao   ren   ren   chuangfen   qie   yi    ji    kan   qian  cun   chu   wen   ji    dan   xing  hua   wan   jue   li    yue   lie   liu   ze    gang  chuangfu    chu   qu    diao  shan  min   ling  zhong pan   bie   jie   jie   pao   li    shan  bie   chan  jing  gua   geng  dao   chuangkui   ku    duo   er    zhi   shua  quan  sha   ci    ke    jie   gui   ci    gui   kai   duo   ji    ti    jing  dou   luo   ze    yuan  cuo   xiao  ke    la    qian  cha   chuanggua   jian  cuo   li    ti    fei   pou   chan  qi    chuangzi    gang  wan   bao   ji    duo   qing  shan  du    jian  ji    bo    yan   ju    huo   sheng jian  duo   tuan  wu    gua   fu    sheng jian  ge    da    kai   chuangchuan chan  tuan  lu    li    peng  shan  piao  kou   jiao  gua   qiao  jue   hua   zha   zhuo  lian  ju    pi    liu   gui   jiao  gui   jian  jian  tang  huo   ji    jian  yi    jian  zhi   chan  zuan  mo    li    zhu   li    ya    quan  ban   gong  jia   wu    mai   lie   jin   keng  xie   zhi   dong  zhu   nu    jie   qu    shao  yi    zhu   mo    li    jin   lao   lao   juan  kou   yang  wa    xiao  mou   kuang jie   lie   he    shi   ke    jin   gao   bo    min   chi   lang  yong  yong  mian  ke    xun   juan  qing  lu    bu    meng  chai  le    kai   mian  dong  xu    xu    kan   wu    yi    xun   weng  sheng lao   mu    lu    piao  shi   ji    qin   jiang jiao  quan  xiang yi    jue   fan   juan  tong  ju    dan   xie   mai   xun   xun   lv    li    che   rang  quan  bao   shao  yun   jiu   bao   gou   wu    yun   mang  bi    gai   gai   bao   cong  yi    xiong peng  ju    tao   ge    pu    e     pao   fu    gong  da    jiu   gong  bi    hua   bei   nao   chi   fang  jiu   yi    za    jiang kang  jiang kuang hu    xia   qu    fan   gui   qie   cang  kuang fei   hu    yu    gui   kui   hui   dan   kui   lian  lian  suan  du    jiu   qu    xi    pi    qu    yi    ke    yan   bian  ni    qu    shi   xun   qian  nian  sa    zu    sheng wu    hui   ban   shi   xi    wan   hua   xie   wan   bei   zu    zhuo  xie   dan   mai   nan   dan   ji    bo    shuai bu    guan  bian  bu    zhan  ka    lu    you   lu    xi    gua   wo    xie   jie   jie   wei   yang  qiong zhi   mao   yin   wei   shao  ji    que   luan  chi   juan  xie   xu    jin   que   kui   ji    e     qing  xi    san   chang wei   e     ting  li    zhe   han   li    ya    ya    yan   she   di    zha   pang  a     qie   ya    zhi   ce    mang  ti    li    she   hou   ting  zui   cuo   fei   yuan  ce    yuan  xiang yan   li    jue   xia   dian  chu   jiu   jin   ao    gui   yan   si    li    chang lan   li    yan   yan   yuan  si    gong  lin   rou   qu    qu    keng  lei   du    xian  zhuan san   can   can   can   can   ai    dai   you   cha   ji    you   shuangfan   shou  guai  ba    fa    ruo   shi   shu   zhuo  qu    shou  bian  xu    jia   pan   sou   ji    wei   sou   die   rui   cong  kou   gu    ju    ling  gua   dao   kou   zhi   jiao  zhao  ba    ding  ke    tai   chi   shi   you   qiu   po    ye    hao   si    tan   chi   le    diao  ji    dui   hong  mie   yu    mang  chi   ge    xuan  yao   zi    he    ji    diao  cun   tong  ming  hou   li    tu    xiang zha   xia   ye    lv    a     ma    ou    huo   yi    jun   chou  lin   tun   yin   fei   bi    qin   qin   jie   bu    fou   ba    dun   fen   e     han   ting  keng  shui  qi    hong  zhi   yin   wu    wu    chao  na    xue   xi    chui  dou   wen   hou   hou   wu    gao   ya    jun   lv    e     ge    mei   dai   qi    cheng wu    gao   fu    jiao  yun   chi   sheng ne    tun   fu    yi    dai   ou    li    bai   yuan  guo   wen   qiang wu    e     shi   juan  pen   wen   ne    m     ling  ran   you   di    zhou  shi   zhou  tie   xi    yi    qi    ping  zi    gua   ci    wei   xu    he    nao   xia   pei   yi    xiao  shen  hu    ming  da    qu    ju    han   za    tuo   duo   pou   pao   bie   fu    yang  he    zha   he    hai   jiu   yong  fu    da    zhou  wa    ka    gu    ka    zuo   bu    long  dong  ning  ta    si    xian  huo   qi    er    e     guang zha   xi    yi    lie   zi    mie   mi    zhi   yao   ji    zhou  lo    shu   zan   xiao  ke    hui   kua   huai  tao   xian  e     xuan  xiu   guo   yan   lao   yi    ai    pin   shen  tong  hong  xiong duo   wa    ha    zai   you   die   pai   xiang ai    gen   kuang ya    da    xiao  bi    hui   nian  hua   xing  kuai  duo   pou   ji    nong  mou   yo    hao   yuan  long  pou   mang  ge    ou    chi   shao  li    na    zu    he    ku    xiao  xian  lao   po    zhe   zha   liang ba    mie   lv    sui   fu    bu    han   heng  geng  shui  ge    you   yan   gu    gu    bai   han   suo   chun  yi    ai    jia   tu    xian  wan   li    xi    tang  zuo   qiu   che   wu    zao   ya    dou   qi    di    qin   ma    mao   gong  teng  keng  lao   liang suo   zao   huan  lang  sha   ji    zi    wo    feng  yin   hu    qi    shou  wei   shua  chang er    li    qiang an    ze    yo    dian  yu    tian  lai   sha   xi    tuo   hu    ai    zhao  nou   ken   zhuo  zhuo  shang di    heng  lin   a     xiao  xiang tun   wu    wen   cui   die   gu    qi    qi    tao   dan   dan   wa    zi    bi    cui   chuai he    ya    qi    zhe   fei   liang xian  pi    sha   la    ze    ying  gua   pa    ze    se    zhuan nie   guo   luo   n     di    quan  tan   bo    ding  lang  xiao  geng  tang  chi   ti    an    jiu   dan   ka    yong  wei   nan   shan  yu    zhe   la    jie   hou   han   die   zhou  chai  wai   nuo   yu    yin   zan   yao   wo    mian  hu    yun   chuan hui   huan  huan  xi    he    ji    kui   zhong wei   sha   xu    huang duo   nie   xuan  liang yu    sang  chi   qiao  yan   dan   pen   can   li    yo    zha   wei   miao  ying  pen   peng  kui   bei   yu    geng  lou   ku    zao   huo   ti    yao   he    a     xu    qiang se    yong  su    hong  xie   ai    shuo  ma    cha   hai   ke    da    sang  chen  ru    sou   wa    ji    pang  wu    qian  shi   ge    zi    jie   lao   weng  wa    si    chi   hao   suo   jia   hai   suo   qin   nie   he    ci    sai   n     geng  na    dia   ai    qiang tong  bi    ao    ao    lian  zui   zhe   mo    shuo  sou   tan   di    qi    jiao  chong jiao  kai   tan   shan  cao   jia   ai    xiao  piao  lou   ga    gu    xiao  hu    hui   guo   ou    xian  ze    chang xu    po    de    ma    ma    hu    lei   du    ga    tang  ye    beng  ying  sai   jiao  mi    xiao  hua   mai   ran   chuai peng  lao   xiao  ji    zhu   chao  kui   zui   xiao  si    hao   m     liao  qiao  xi    chu   tan   dan   hei   xun   e     zun   fan   chi   hui   can   chuangcu    dan   yu    kuo   ceng  jiao  ye    xi    qi    hao   lian  xu    deng  hui   yin   pu    jue   qin   xun   nie   lu    si    yan   ying  da    zhan  ou    zhou  jin   nong  hui   xie   qi    e     zao   yi    shi   jiao  yuan  ai    yong  jue   kuai  yu    pen   dao   ga    xin   dun   dang  xin   sai   pi    pi    yin   zui   ning  di    lan   ta    huo   ru    hao   xia   ye    duo   pi    zhou  ji    jin   hao   ti    chang xun   me    ca    ti    lu    hui   bo    you   nie   yin   hu    mei   hong  zhe   li    liu   hai   nang  xiao  mo    yan   li    lu    long  mo    dan   chen  pin   pi    xiang huo   me    xi    duo   ku    yan   chan  ying  rang  die   la    ta    xiao  jue   chuo  huan  huo   zhuan nie   xiao  ca    li    chan  chai  li    yi    luo   nang  zan   su    heng  zen   jian  za    zhu   lan   nie   nang  ra    liu   wei   hui   yin   qiu   si    nin   jian  hui   xin   yin   nan   tuan  tuan  dun   kang  yuan  jiong pian  yun   cong  hu    hui   yuan  e     guo   kun   chuangtong  tu    wei   lun   guo   qun   ri    ling  gu    guo   tai   guo   tu    you   guo   yin   hun   pu    yu    han   yuan  lun   quan  yu    qing  guo   chuan wei   yuan  quan  ku    pu    yuan  yuan  ya    tuan  tu    tu    tuan  lve   hui   yi    yuan  luan  luan  tu    ya    tu    ting  sheng pu    lu    kuai  ju    zai   wei   ge    yu    wu    gui   pi    yi    di    qian  qian  zhen  zhuo  dang  qia   xia   shan  kuang chang qi    nie   mo    ji    jia   zhi   zhi   ban   xun   yi    qin   fen   jun   keng  tun   fang  fen   ben   tan   kan   huai  zuo   keng  bi    jing  di    jing  ji    kuai  chi   jing  jian  tan   li    ba    wu    fen   zhui  po    pan   tang  kun   qu    tan   zhi   tuo   gan   ping  dian  gua   ni    tai   pi    jiong yang  fo    ao    lu    qiu   mu    ke    gou   xue   ba    di    che   ling  zhu   fu    hu    zhi   chui  la    long  long  lu    ao    dai   pao   min   xing  dong  ji    he    lv    ci    chi   lei   gai   yin   hou   dui   zhao  fu    guang yao   duo   duo   gui   cha   yang  yin   fa    gou   yuan  die   xie   ken   shang shou  e     bing  dian  hong  ya    kua   da    ka    dang  kai   hang  nao   an    xing  xian  yuan  bang  fou   ba    yi    yin   han   xu    chui  qin   geng  ai    beng  fang  que   yong  jun   jia   di    mai   lang  juan  cheng shan  jin   zhe   lie   lie   pu    cheng hua   bu    shi   xun   guo   jiong ye    nian  di    yu    bu    ya    quan  sui   pi    qing  wan   ju    lun   zheng kong  chong dong  dai   tan   an    cai   chu   beng  kan   zhi   duo   yi    zhi   yi    pei   ji    zhun  qi    sao   ju    ni    ku    ke    tang  kun   ni    jian  dui   jin   gang  yu    e     peng  gu    tu    leng  fang  ya    qian  kun   an    shen  duo   nao   tu    cheng yin   huan  bi    lian  guo   die   zhuan hou   bao   bao   yu    di    mao   jie   ruan  ye    geng  kan   zong  yu    huang e     yao   yan   bao   ci    mei   chang du    tuo   pou   feng  zhong jie   jin   heng  gang  chun  kan   ping  lei   xing  huang leng  duan  wan   xuan  xi    ji    kuai  ying  ta    cheng yong  kai   su    su    shi   mi    ta    weng  cheng tu    tang  que   zhong li    peng  bang  sai   zang  dui   tian  wu    zheng xun   ge    zhen  ai    gong  yan   kan   tian  yuan  wen   xie   liu   hai   lang  chang peng  beng  chen  lu    lu    ou    qian  mei   mo    tuan  shuangshu   lou   chi   man   biao  jing  ce    shu   zhi   zhang kan   yong  dian  chen  zhi   ji    guo   qiang jin   di    shang mu    cui   yan   ta    zeng  qian  qiang liang wei   zhui  qiao  zeng  xu    shan  shan  ba    pu    kuai  dong  fan   que   mo    dun   dun   cun   di    sheng duo   duo   tan   deng  mu    fen   huang tan   da    ye    zhu   jian  ao    qiang ji    qiao  ken   yi    pi    bi    dian  jiang ye    yong  bo    tan   lan   ju    huai  dang  rang  qian  xun   lan   xi    he    ai    ya    dao   hao   ruan  jin   lei   kuang lu    yan   tan   wei   huai  long  long  rui   li    lin   rang  chan  xun   yan   lei   ba    wan   shi   ren   san   zhuangzhuangsheng yi    mai   ke    zhu   zhuanghu    hu    kun   yi    hu    xu    kun   shou  mang  dun   shou  yi    zhi   gu    chu   jiang feng  bei   zhai  bian  sui   qun   ling  fu    cuo   xia   xiong xie   nao   xia   kui   xi    wai   yuan  mao   su    duo   duo   ye    qing  ou    gou   gou   qi    meng  meng  yin   huo   chen  da    ze    tian  tai   fu    guai  yao   yang  hang  gao   shi   tao   tai   tou   yan   bi    yi    kua   jia   duo   huo   kuang yun   jia   ba    en    lian  huan  di    yan   pao   juan  qi    nai   feng  xie   fen   dian  yang  kui   zou   huan  qi    kai   zha   ben   yi    jiang tao   zang  ben   xi    huang fei   diao  xun   beng  dian  ao    she   weng  po    ao    wu    ao    jiang lian  duo   yun   jiang shi   fen   huo   bi    luan  che   nv    nu    ding  nai   qian  jian  jie   jiu   nuan  cha   hao   xian  fan   ji    shuo  ru    fei   wang  hong  zhuangfu    ma    dan   ren   fu    jing  yan   ha    wen   zhong pa    du    ji    hang  zhong yao   jin   yun   miao  fou   chi   jue   zhuangniu   yan   na    xin   fen   bi    yu    tuo   feng  wan   fang  wu    yu    gui   du    ba    ni    zhou  zhuo  zhao  da    nai   yuan  tou   xian  yi    e     mei   mo    qi    bi    shen  qie   e     he    xu    fa    zheng min   ban   mu    fu    ling  zi    zi    shi   ran   shan  yang  man   jie   gu    si    xing  wei   zi    ju    shan  pin   ren   yao   dong  jiang shu   ji    gai   xiang hua   juan  jiao  gou   lao   jian  jian  yi    nian  zhi   zhen  ji    xian  heng  guang jun   kua   yan   ming  lie   pei   e     you   yan   cha   shen  yin   shi   gui   quan  zi    song  wei   hong  wa    lou   ya    rao   jiao  lian  pin   xian  shao  li    cheng xie   mang  fu    suo   mu    wei   ke    chuo  chuo  ting  niang xing  nan   yu    na    po    nei   juan  shen  zhi   han   di    zhuange     ping  tui   xian  mian  wu    yan   wu    xi    yan   yu    si    yu    wa    li    xian  ju    qu    zhui  qi    xian  zhuo  dong  chang lu    ai    e     e     lou   mian  cong  pou   ju    po    cai   ling  wan   biao  xiao  shu   qi    hui   fu    wo    wo    tan   fei   fei   jie   tian  ni    quan  jing  hun   jing  qian  dian  xing  hu    wan   lai   bi    yin   zhou  nao   fu    jing  lun   an    lan   kun   yin   ya    ju    li    dian  xian  hua   hua   ying  chan  shen  ting  dang  yao   wu    nan   ruo   jia   tou   xu    yu    wei   di    rou   mei   dan   ruan  qin   hui   wo    qian  chun  miao  fu    jie   duan  yi    zhong mei   huang mian  an    ying  xuan  jie   wei   mei   yuan  zheng qiu   ti    xie   tuo   lian  mao   ran   si    pian  wei   wa    cu    hu    ao    jie   bao   xu    tou   gui   zou   yao   pi    xi    yuan  ying  rong  ru    chi   liu   mei   pan   ao    ma    gou   kui   qin   jia   sao   zhen  yuan  jie   rong  ming  ying  ji    su    niao  xian  tao   pang  lang  nao   bao   ai    pi    pin   yi    piao  yu    lei   xuan  man   yi    zhang kang  yong  ni    li    di    gui   yan   jin   zhuan chang ze    han   nen   lao   mo    zhe   hu    hu    ao    ruan  qiang ma    pie   gu    wu    qiao  tuo   zhan  miao  xian  xian  mo    liao  lian  hua   gui   deng  zhi   xu    yi    hua   xi    kui   rao   xi    yan   chan  jiao  mei   fan   fan   xian  yi    hei   jiao  fan   shi   bi    shan  sui   qiang lian  xuan  xin   niao  dong  yi    can   ai    niang ning  ma    tiao  chou  jin   ci    yu    pin   rong  ru    nai   yan   tai   ying  qian  niao  yue   ying  mian  bi    ma    shen  xing  ni    du    liu   yuan  lan   yan   shuangling  jiao  niang lan   xian  ying  shuanghui   quan  mi    li    luan  yan   zhu   lan   zi    jie   jue   jue   kong  yun   zi    zi    cun   sun   fu    bo    zi    xiao  xin   meng  si    tai   bao   ji    gu    nu    xue   you   zhuan hai   luan  sun   nao   mie   cong  qian  shu   chan  ya    zi    ni    fu    zi    li    xue   bo    ru    nai   nie   nie   ying  luan  mian  ning  rong  ta    gui   zhai  qiong yu    shou  an    jia   song  wan   rou   yao   hong  yi    jing  zhun  mi    zhu   dang  hong  zong  guan  zhou  ding  wan   yi    bao   shi   shi   chong shen  ke    xuan  shi   you   huan  yi    tiao  shi   xian  gong  cheng qun   gong  xiao  zai   zha   dao   hai   yan   xiao  jia   shen  chen  rong  huang mi    kou   kuan  bin   su    cai   zan   ji    yuan  ji    yin   mi    kou   qiu   he    zhen  jian  fu    ning  bing  huan  mei   qin   han   yu    shi   ning  jin   ning  zhi   yu    bao   kuan  ning  qin   mo    cha   ju    gua   qin   hu    wu    liao  shi   ning  zhai  shen  wei   xie   kuan  hui   liao  jun   huan  yi    yi    bao   qin   chong bao   feng  cun   dui   si    xun   dao   lv    dui   shou  po    feng  zhuan fu    she   ke    jiang jiang zhuan wei   zun   xun   shu   dui   dao   xiao  jie   shao  er    er    er    ga    jian  shu   chen  shang shang mo    ga    chang liao  xian  xian  kun   you   wang  you   liao  liao  yao   mang  wang  wang  wang  ga    yao   duo   kui   zhong jiu   gan   gu    gan   tui   gan   gan   shi   yin   chi   kao   ni    jin   wei   niao  ju    pi    ceng  xi    bi    ju    jie   tian  qu    ti    jie   wu    diao  shi   shi   ping  ji    xie   zhen  xie   ni    zhan  xi    xi    man   e     lou   ping  ti    fei   zhu   xie   tu    lv    lv    xi    ceng  lv    ju    xie   ju    jue   liao  jue   zhu   xie   che   tun   ni    shan  wa    xian  li    e     dao   hui   long  yi    qi    ren   wu    han   shen  yu    chu   sui   qi    yen   yue   ban   yao   ang   ya    wu    jie   e     ji    qian  fen   wan   qi    cen   qian  qi    cha   jie   qu    gang  xian  ao    lan   dao   ba    zuo   zuo   yang  ju    gang  ke    gou   xue   po    li    tiao  qu    yan   fu    xiu   jia   ling  tuo   pi    ao    dai   kuang yue   qu    hu    po    min   an    tiao  ling  chi   ping  dong  ceng  kui   bang  mao   tong  xue   yi    bian  he    ke    luo   e     fu    xun   die   lu    en    er    gai   quan  dong  yi    mu    shi   an    wei   huan  zhi   mi    li    ji    dong  wei   you   gu    xia   lie   yao   jiao  zheng luan  jiao  e     e     yu    xie   bu    qiao  qun   feng  feng  nao   li    you   xian  rong  dao   shen  cheng tu    geng  jun   gao   xia   yin   yu    lang  kan   lao   lai   xian  que   kong  chong chong ta    lin   hua   ju    lai   qi    min   kun   kun   zu    gu    cui   ya    ya    gang  lun   lun   ling  jue   duo   zheng guo   yin   dong  han   zheng wei   xiao  pi    yan   song  jie   beng  zu    ku    dong  zhan  gu    yin   zi    ze    huang yu    wai   yang  feng  qiu   yang  ti    yi    zhi   shi   zai   yao   e     zhu   kan   lv    yan   mei   han   ji    ji    huan  ting  sheng mei   qian  wu    yu    zong  lan   ke    yan   yan   wei   zong  cha   sui   rong  ke    qin   yu    qi    lou   tu    dui   xi    weng  cang  tang  rong  jie   ai    liu   wu    song  qiao  zi    wei   beng  dian  cuo   qian  yong  nie   cuo   ji    shi   ruo   song  zong  jiang liao  kang  chan  die   cen   ding  tu    lou   zhang zhan  zhan  ao    cao   qu    qiang cui   zui   dao   dao   xi    yu    pei   long  xiang ceng  bo    qin   jiao  yan   lao   zhan  lin   liao  liao  jin   deng  duo   zun   jiao  jue   yao   jiao  yao   jue   zhan  yi    xue   nao   ye    ye    yi    nie   xian  ji    xie   ke    gui   di    ao    zui   wei   yi    rong  dao   ling  jie   yu    yue   yin   ru    jie   li    gui   long  long  dian  ying  xi    ju    chan  ying  kui   yan   wei   nao   quan  chao  cuan  luan  dian  dian  nie   yan   yan   yan   kui   yan   chuan kuai  chuan zhou  huang jing  xun   chao  chao  lie   gong  zuo   qiao  ju    gong  keng  wu    pu    pu    cha   qiu   qiu   ji    yi    si    ba    zhi   zhao  xiang yi    jin   sun   quan  peng  xun   jin   fu    za    bi    shi   bu    ding  shuai fan   nie   shi   fen   pa    zhi   xi    hu    dan   wei   zhang tang  dai   mo    pei   pa    tie   fu    lian  zhi   zhou  bo    zhi   di    mo    yi    yi    ping  qia   juan  ru    shuai dai   zheng shui  qiao  zhen  shi   qun   xi    bang  dai   gui   chou  ping  zhang jian  wan   dai   wei   chang sha   qi    ze    guo   mao   du    hou   zheng xu    mi    wei   wo    fu    yi    bang  ping  die   gong  pan   huang tao   mi    jia   teng  hui   zhong shan  man   mu    biao  guo   ze    mu    bang  zhang jing  chan  fu    zhi   hu    fan   zhuangbi    bi    zhang mi    qiao  chan  fen   meng  bang  chou  mie   chu   jie   xian  lan   gan   ping  nian  jian  bing  bing  xing  gan   yao   huan  you   you   ji    guang pi    ting  ze    guang zhuangme    qing  bi    qin   dun   chuanggui   ya    bai   jie   xu    lu    wu    zhuangku    ying  di    pao   dian  ya    miao  geng  ci    fu    tong  pang  fei   xiang yi    zhi   tiao  zhi   xiu   du    zuo   xiao  tu    gui   ku    meng  ting  you   bu    bing  cheng lai   bi    ji    an    shu   kang  yong  tuo   song  shu   qing  yu    yu    miao  sou   ce    xiang fei   jiu   e     wei   liu   xia   lian  lang  sou   zhi   bu    qing  jiu   jiu   jin   ao    kuo   lou   yin   liao  dai   lu    yi    chu   chan  tu    si    xin   miao  chang wu    fei   guang kou   kuai  bi    qiang xie   lin   lin   liao  lu    ji    ying  xian  ting  yong  li    ting  yin   xun   yan   ting  di    po    jian  hui   nai   hui   gong  nian  kai   bian  yi    qi    nong  fen   ju    yan   yi    zang  bi    yi    yi    er    san   shi   er    shi   shi   gong  diao  yin   hu    fu    hong  wu    di    chi   jiang ba    shen  di    zhang zhang tao   fu    di    mi    xian  hu    chao  nu    jing  zhen  yi    mi    juan  wan   shao  ruo   yuan  jing  diao  zhang jiang qiang peng  dan   qiang bi    bi    she   tan   jian  gou   ge    fa    bi    kou   jian  bie   xiao  dan   guo   jiang hong  mi    guo   wan   jue   ji    ji    gui   dang  lu    lu    tuan  hui   zhi   hui   hui   yi    yi    yi    yi    yue   yue   shan  xing  wen   tong  yan   yan   yu    chi   cai   biao  diao  bin   peng  yong  piao  zhang ying  chi   chi   zhuo  tuo   ji    fang  zhong yi    wang  che   bi    di    ling  fu    wang  zheng cu    wang  jing  dai   xi    xun   hen   yang  huai  lv    hou   wa    cheng zhi   xu    jing  tu    cong  zhi   lai   cong  de    pai   xi    xi    ji    chang zhi   cong  zhou  lai   yu    xie   jie   jian  shi   jia   bian  huang fu    xun   wei   bang  yao   wei   xi    zheng piao  ti    de    zheng zheng bie   de    chong che   yao   hui   jiao  hui   mei   long  xiang bao   qu    xin   xin   bi    yi    le    ren   dao   ding  gai   ji    ren   ren   chan  tan   te    te    gan   yi    shi   cun   zhi   wang  mang  xi    fan   ying  tian  min   wen   zhong chong wu    ji    wu    xi    jie   you   wan   cong  song  kuai  yu    bian  zhi   qi    cui   chen  tai   tun   qian  nian  hun   xiong niu   wang  xian  xin   kang  hu    kai   fen   huai  tai   song  wu    ou    chang chuangju    yi    bao   chao  min   pei   zuo   zen   yang  kou   ban   nu    nao   zheng pa    bu    tie   gu    hu    ju    da    lian  si    you   di    dai   yi    tu    you   fu    ji    peng  xing  yuan  ni    guai  fu    xi    bi    you   qie   xuan  cong  bing  huang xue   chu   pi    shu   xi    tan   yong  zong  dui   mo    keng  yi    shi   ren   xun   shi   xi    lao   heng  kuang mou   zhi   xie   lian  tiao  huang die   hao   kong  gui   heng  qi    xiao  shu   si    hu    qiu   yang  hui   hui   chi   jia   yi    xiong guai  lin   hui   zi    xu    chi   shang nv    hen   en    ke    dong  tian  gong  quan  xi    qia   yue   peng  ken   de    hui   e     xiao  tong  yan   kai   ce    nao   yun   mang  yong  yong  yuan  pi    kun   qiao  yue   yu    tu    jie   xi    zhe   lin   ti    han   hao   qie   ti    bu    yi    qian  hui   xi    bei   man   yi    heng  song  quan  cheng kui   wu    wu    you   li    lang  huan  cong  yi    yue   li    nin   nao   e     que   xuan  qian  wu    min   cong  fei   bei   de    cui   chang men   li    ji    guan  guan  xing  dao   qi    kong  tian  lun   xi    kan   gun   ni    qing  chou  dun   guo   zhan  jing  wan   yuan  jin   ji    lin   yu    huo   he    quan  tan   ti    ti    nie   wang  chuo  hu    hun   xi    chang xin   wei   hui   e     suo   zong  jian  yong  dian  ju    can   cheng de    bei   qie   can   dan   guan  duo   nao   yun   xiang zhui  die   huang chun  qiong re    xing  ce    bian  hun   zong  ti    qiao  chou  bei   xuan  wei   ge    qian  wei   yu    yu    bi    xuan  huan  min   bi    yi    mian  yong  qi    shang yin   e     chen  mao   qia   ke    yu    ai    qie   yan   ruan  gan   yun   zong  sai   leng  fen   ying  kui   kui   que   gong  yun   su    su    qi    yao   song  huang ji    gu    ju    chuangni    xie   kai   zheng yong  cao   xun   shen  bo    kai   yuan  xi    hun   yong  yang  li    sao   tao   yin   ci    xu    qian  tai   huang yun   shen  ming  gong  she   cong  piao  mu    mu    guo   chi   can   can   can   cui   min   te    zhang tong  ao    shuangman   guan  que   zao   jiu   hui   kai   lian  ou    song  jin   yin   lv    shang wei   tuan  man   qian  she   yong  qing  kang  di    zhi   lou   juan  qi    qi    yu    ping  liao  cong  you   chong zhi   tong  cheng qi    qu    peng  bei   bie   qiong jiao  zeng  chi   lian  ping  kui   hui   qiao  cheng yin   yin   xi    xi    dan   tan   duo   dui   dun   su    jue   ce    xiao  fan   fen   lao   lao   chong han   qi    xian  min   jing  liao  wu    can   jue   cu    xian  tan   sheng pi    yi    chu   xian  nong  dan   tan   jing  song  han   ji    wei   huan  dong  qin   qin   ju    cao   ken   xie   ying  ao    mao   yi    lin   se    jun   huai  men   lan   ai    lin   yan   kuo   xia   chi   yu    yin   dai   meng  ai    meng  dui   qi    mo    lan   men   chou  zhi   nuo   nuo   chu   yang  bo    zhi   kuang kuang you   fu    liu   mie   cheng hui   chan  meng  lan   huai  xuan  rang  chan  ji    ju    huan  she   yi    lian  nan   mi    tang  jue   zhuanggang  gang  ge    yue   wu    jian  xu    shu   rong  xi    cheng wo    jie   ge    jian  qiang huo   qiang zhan  dong  qi    jia   die   cai   jia   ji    zhi   kan   ji    kui   gai   deng  zhan  qiang ge    jian  jie   yu    jian  yan   lu    xi    zhan  xi    xi    chuo  dai   qu    hu    hu    hu    e     shi   ti    mao   hu    li    fang  suo   bian  dian  jiong shang yi    yi    shan  hu    fei   yan   shou  shou  cai   zha   qiu   le    pu    ba    da    reng  fan   ru    zai   tuo   zhang diao  kang  yu    ku    han   shen  cha   tuo   gu    kou   wu    den   qian  zhi   ren   kuo   men   sao   yang  niu   ban   che   rao   cha   qian  ban   jia   yu    fu    ao    xi    pi    zhi   zhi   e     den   zhao  cheng ji    yan   kuang bian  chao  ju    wen   hu    yue   jue   ba    qin   shen  zheng yun   wan   ne    yi    shu   zhua  pou   tou   dou   kang  zhe   pou   fu    pao   ba    ao    ze    tuan  kou   lun   qiang yun   hu    bao   bing  zhi   peng  nan   pu    pi    tai   yao   zhen  zha   yang  bao   he    ni    ye    di    chi   pi    jia   mo    mei   chen  ya    chou  qu    min   chu   jia   fu    zhan  zhu   dan   cha   mu    nian  la    fu    pao   ban   pai   lin   na    guai  qian  ju    tuo   ba    tuo   tuo   ao    ju    zhuo  bian  zhao  bai   bai   di    ni    ju    kuo   long  jian  qia   yong  lan   ning  bo    ze    qian  hen   kuo   shi   jie   zheng nin   gong  gong  quan  shuan cun   za    kao   chi   xie   ce    hui   pin   zhuai shi   na    bai   chi   gua   zhi   kuo   duo   duo   zhi   qie   an    nong  zhen  ge    jiao  kua   dong  na    tiao  lie   zha   lu    die   wa    jue   lie   ju    zhi   luan  ya    wo    ta    xie   nao   dang  jiao  zheng ji    hui   xian  yu    ai    tuo   nuo   cuo   bo    geng  ti    zhen  cheng sha   suo   keng  mei   nong  ju    peng  jian  yi    ting  shan  ruo   wan   xie   cha   feng  jiao  wu    jun   ju    tong  kun   huo   tu    zhuo  pou   luo   ba    han   shao  nie   juan  ze    song  ye    jue   bu    wan   bu    zun   ye    zhai  lu    sou   tuo   lao   sun   bang  jian  huan  dao   wei   wan   qin   peng  she   lie   min   men   fu    bai   ju    dao   wo    ai    juan  yue   zong  tian  chui  jie   tu    ben   na    nian  ruo   zuo   wo    qi    xian  cheng dian  sao   lun   qing  gang  duo   shou  diao  pou   di    zhang hun   ji    tao   qia   qi    pai   shu   qian  ling  ye    ya    jue   zheng liang gua   ni    huo   yan   zheng lve   cai   tan   che   bing  jie   ti    kong  tui   yan   cuo   zou   ju    tian  qian  ken   bai   pa    jie   lu    guo   ming  geng  zhi   dan   meng  chan  sao   guan  peng  yuan  nuo   jian  zheng jiu   jian  yu    yan   kui   nan   hong  rou   pi    wei   sai   zou   xuan  miao  ti    nie   cha   shi   zong  zhen  yi    xun   huang bian  yang  huan  yan   zuan  an    xu    ya    wo    ke    chuai ji    ti    la    la    chen  kai   jiu   jiu   tu    jie   hui   gen   chong xiao  die   xie   yuan  qian  ye    cha   zha   bei   yao   wei   den   lan   wen   qin   chan  ge    lou   zong  gen   jiao  gou   qin   rong  que   chou  chu   zhan  sun   sun   bo    chu   rong  peng  cuo   sao   ke    yao   dao   zhi   nu    la    jian  sou   qiu   gao   xian  shuo  sang  jin   mie   e     chui  nuo   shan  ta    zha   tang  pan   ban   da    li    tao   hu    zhi   wa    xia   qian  wen   qiang tian  zhen  e     xie   nuo   quan  cha   zha   ge    wu    en    she   kang  she   shu   bai   yao   bin   rong  tan   sa    chan  suo   jiu   chong chuangguo   bing  feng  shuai di    qi    sou   zhai  lian  cheng chi   guan  lu    luo   lou   zong  gai   hu    zha   qiang tang  hua   cui   nai   mo    jiang gui   ying  zhi   ao    zhi   nie   man   chan  kou   chu   she   tuan  jiao  mo    mo    zhe   chan  qian  biao  jiang yao   gou   qian  liao  ji    ying  jue   pie   pie   lao   dun   xian  ruan  gui   zan   yi    xian  cheng cheng sa    nao   hong  si    han   guang da    zun   nian  lin   zheng hui   zhuangjiao  ji    cao   tan   dan   che   bo    che   jue   xiao  liao  ben   fu    qiao  bo    cuo   zhuo  zhuan tuo   pu    qin   dun   nian  hua   xie   lu    jiao  cuan  ta    han   qiao  wo    jian  gan   yong  lei   nang  lu    shan  zhuo  ze    pu    chuo  ji    dang  se    cao   qing  qing  huan  jie   qin   kuai  dan   xie   ye    pi    bo    ao    ju    ye    e     meng  sou   mi    ji    tai   zhuo  dao   xing  lan   ca    ju    ye    ru    ye    ye    ni    huo   jie   bin   ning  ge    zhi   jie   kuo   mo    jian  xie   lie   tan   bai   sou   lu    lve   rao   zhi   pan   yang  lei   ca    shu   cuan  nian  xian  jun   huo   li    la    huan  ying  lu    long  qian  qian  zan   qian  lan   xian  ying  mei   rang  chan  ying  cuan  xie   she   luo   mei   mi    chi   zan   luan  tan   zuan  li    dian  wa    dang  jiao  jue   lan   li    nang  zhi   gui   gui   ji    xun   pu    pu    shou  kao   you   gai   yi    gong  gan   ban   fang  zheng po    dian  kou   min   wu    gu    he    ce    xiao  mi    chu   ge    di    xu    jiao  min   chen  jiu   zhen  duo   yu    chi   ao    bai   xu    jiao  duo   lian  nie   bi    chang dian  duo   yi    gan   san   ke    yan   dun   ji    tou   xiao  duo   jiao  jing  yang  xia   min   shu   ai    qiao  ai    zheng di    zhen  fu    shu   liao  qu    xiong yi    jiao  shan  jiao  zhuo  yi    lian  bi    li    xiao  xiao  wen   xue   qi    qi    zhai  bin   jue   zhai  zhai  fei   ban   ban   lan   yu    lan   wei   dou   sheng liao  jia   hu    xie   jia   yu    zhen  jiao  wo    tou   dou   jin   chi   yin   fu    qiang zhan  qu    zhuo  zhan  duan  zhuo  si    xin   zhuo  zhuo  qin   lin   zhuo  chu   duan  zhu   fang  jie   hang  yu    shi   pei   you   mu    pang  qi    zhan  mao   lv    pei   pi    liu   fu    fang  xuan  jing  jing  ni    zu    zhao  yi    liu   shao  jian  er    yi    qi    zhi   fan   piao  fan   zhan  kuai  sui   yu    wu    ji    ji    ji    huo   ri    dan   jiu   zhi   zao   xie   tiao  xun   xu    ga    la    gan   han   tai   di    xu    chan  shi   kuang yang  shi   wang  min   min   tun   chun  wu    yun   bei   ang   ze    ban   jie   kun   sheng hu    fang  hao   gui   chang xuan  ming  hun   fen   qin   hu    yi    xi    xin   yan   ze    fang  tan   shen  ju    yang  zan   bing  xing  ying  xuan  po    zhen  ling  chun  hao   mei   zuo   mo    bian  xu    hun   zhao  zong  shi   shi   yu    fei   die   mao   ni    chang wei   dong  ai    bing  ang   zhou  long  xian  kuang tiao  chao  shi   huang huang xuan  kui   kua   jiao  jin   zhi   jin   shang tong  hong  yan   gai   xiang shai  xiao  ye    yun   hui   han   han   jun   wan   xian  kun   zhou  xi    sheng sheng bu    zhe   zhe   wu    han   hui   hao   chen  wan   tian  zhuo  zui   zhou  pu    jing  xi    shan  ni    xi    qing  qi    jing  gui   zheng yi    zhi   an    wan   lin   liang chang wang  xiao  zan   fei   xuan  xuan  yi    xia   yun   hui   xu    min   kui   ye    ying  shu   wei   shu   qing  mao   nan   jian  nuan  an    yang  chun  yao   suo   pu    ming  jiao  kai   gao   weng  chang qi    hao   yan   li    ai    ji    ji    men   zan   xie   hao   mu    mo    cong  ni    zhang hui   bao   han   xuan  chuan liao  xian  tan   jing  pie   lin   tun   xi    yi    ji    huang dai   ye    ye    li    tan   tong  xiao  fei   shen  zhao  hao   yi    xiang xing  shan  jiao  bao   jing  yan   ai    ye    ru    shu   meng  xun   yao   pu    li    chen  kuang die   die   yao   huo   lv    xi    rong  long  nang  luo   luan  shai  tang  yan   zhu   yue   yue   qu    ye    geng  yi    hu    he    shu   cao   cao   sheng man   zeng  zeng  ti    zui   can   xu    hui   yin   qie   fen   pi    yue   you   ruan  peng  ban   fu    ling  fei   qu    qu    nv    tiao  shuo  zhen  lang  lang  zui   ming  huang wang  tun   chao  qi    qi    ying  zong  wang  tong  lang  lao   meng  long  mu    pin   wei   mo    ben   zha   shu   shu   teng  zhu   ren   ba    pu    duo   duo   dao   li    qiu   ji    jiu   bi    xiu   cheng ci    sha   ru    za    quan  qian  yu    gan   wu    cha   shan  xun   fan   wu    zi    li    xing  cai   cun   ren   biao  tuo   di    zhang mang  chi   yi    gai   gong  du    yi    qi    shu   gang  tiao  jiang shan  wan   lai   jiu   mang  yang  ma    miao  xi    yuan  hang  fei   bei   jie   dong  gao   yao   xian  chu   chun  pa    shu   hua   xin   niu   zhu   chou  song  ban   song  ji    yue   jin   gou   ji    mao   pi    bi    wang  ang   fang  fen   yi    fu    nan   xi    hu    ya    dou   xin   zhen  yao   lin   rui   e     mei   zhao  guo   zhi   cong  yun   zui   sheng shu   zao   di    li    lu    jian  cheng song  qiang feng  nan   xiao  xian  ku    ping  si    xi    zhi   guai  xiao  jia   jia   gou   fu    mo    yi    ye    ye    shi   nie   bi    tuo   yi    ling  bing  ni    la    he    pan   fan   zhong dai   ci    yang  fu    bai   mei   gan   qi    ran   rou   shu   shao  song  zhe   xia   you   shen  gui   tuo   zuo   nan   ning  yong  di    zhi   zha   cha   dan   gu    pu    jiu   ao    fu    jian  bo    duo   ke    nai   zhu   bi    liu   chai  zha   si    zhu   pei   shi   guai  cha   yao   cheng jiu   shi   zhi   liu   mei   li    rong  zha   zao   biao  zhan  zhi   long  dong  lu    sa    li    lan   yong  shu   xun   shuan qi    zhen  qi    li    yi    xiang zhen  li    se    kuo   kan   bing  ren   xiao  bai   ren   bing  zi    chou  yi    ci    xu    zhu   jian  zui   er    er    yu    fa    gong  kao   lao   zhan  li    yin   yang  he    gen   yi    shi   ge    zai   luan  fu    jie   heng  gui   tao   guang wei   kuang ru    an    an    juan  yi    zhuo  ku    zhi   qiong tong  sang  sang  huan  ju    jiu   xue   duo   chui  mou   za    nuo   ying  jie   liu   zhan  ya    rao   zhen  dang  qi    qiao  hua   hui   jiang zhuangxun   suo   sa    zhen  bei   ting  kuo   jing  bo    ben   fu    rui   tong  jue   xi    lang  liu   feng  qi    wen   jun   gan   su    liang qiu   ting  you   mei   bang  long  peng  zhuangdi    xuan  tu    zao   you   gu    bi    di    han   zi    zhi   ren   bei   geng  jian  huan  wan   nuo   jia   tiao  ji    xiao  lv    kuan  shao  cen   fen   song  meng  wu    li    si    dou   qin   ying  suo   ju    ti    xie   kun   zhuo  shu   chan  fan   wei   jing  li    bing  xia   fo    tao   zhi   lai   lian  jian  zhuo  ling  li    qi    bing  lun   cong  qian  mian  qi    qi    cai   gun   chan  zhe   fei   pai   bang  bang  hun   zong  cheng zao   ji    li    peng  yu    yu    gu    gun   dong  tang  gang  wang  di    cuo   fan   cheng zhan  qi    yuan  yan   yu    quan  yi    se    ren   chui  leng  qi    zhuo  fu    ke    lai   zou   zou   zhao  guan  fen   fen   chen  qing  ni    wan   guo   lu    hao   jie   yi    chou  ju    ju    cheng zuo   liang qiang zhi   zhui  ya    ju    pi    jiao  zhuo  zi    bin   peng  ding  chu   chang men   hua   jian  gui   xi    du    qian  dao   gui   dian  luo   zhi   quan  mu    fu    geng  peng  shan  yi    tuo   shen  duo   ye    fu    wei   wei   duan  jia   zong  jian  yi    shen  xi    yan   yan   chuan jian  chun  yu    he    zha   wo    pian  bi    yao   guo   xu    ruo   yang  la    yan   ben   hui   kui   jie   kui   si    feng  xie   tuo   ji    jian  mu    mao   chu   ku    hu    lian  leng  ting  nan   yu    you   mei   cong  xuan  xuan  yang  zhen  pian  ye    ji    jie   ye    chu   shui  yu    cou   wei   mei   ti    ji    jie   kai   qiu   ying  rou   huang lou   le    quan  xiang pin   shi   gai   tan   lan   wen   yu    chen  lv    ju    shen  chu   pi    xie   jia   yi    zhan  fu    nuo   mi    lang  rong  gu    jian  ju    ta    yao   zhen  bang  sha   yuan  zi    ming  su    jia   yao   jie   huang gan   fei   zha   qian  ma    sun   yuan  xie   rong  shi   zhi   cui   wen   ting  liu   rong  tang  que   zhai  si    sheng ta    ke    xi    gu    qi    gao   gao   sun   pan   tao   ge    chun  zhen  nou   ji    shuo  gou   chui  qiang cha   qian  huai  mei   xu    gang  gao   zhuo  tuo   qiao  yang  dian  jia   jian  zhi   dao   long  bin   zhu   sang  xi    ji    lian  hui   yong  qian  guo   gai   gai   tuan  hua   qi    se    cui   peng  you   hu    jiang hu    huan  gui   nie   yi    gao   kang  gui   gui   cao   man   jin   zhe   zhuangle    lang  chen  cong  li    xiu   qing  shuangfan   tong  guan  ze    su    lei   lu    liang mi    lou   chao  su    ke    chu   tang  biao  lu    jiu   zhe   zha   shu   zhang man   mo    mu    yang  tiao  peng  zhu   sha   xi    quan  heng  jian  cong  ji    yan   qiang xue   ying  er    xun   zhi   qiao  zui   cong  pu    shu   hua   kui   zhen  zun   yue   shan  xi    chun  dian  fa    gan   mo    wu    qiao  rao   lin   liu   qiao  xian  run   fan   zhan  tuo   lao   yun   shui  dun   cheng tang  meng  ju    cheng su    jue   jue   tan   hui   ji    nuo   xiang tuo   ning  rui   zhu   tong  zeng  fen   qiong ran   heng  qian  gu    liu   lao   gao   chu   xi    sheng zi    san   ji    dou   jing  lu    jian  chu   yuan  da    shu   jiang tan   lin   nao   yin   xi    hui   shan  zui   xuan  cheng gan   ju    zui   yi    qin   pu    yan   lei   feng  hui   dang  ji    sui   bo    ping  cheng chu   zhua  hui   ji    jie   jia   qing  shi   jian  qiang dao   yi    biao  song  she   lin   li    cha   meng  yin   tao   tai   mian  qi    tuan  bing  huo   ji    qian  ni    ning  yi    gao   jian  yin   nou   qing  yan   qi    mi    zhao  gui   chun  ji    kui   po    deng  chu   ge    mian  you   zhi   huang qian  lei   lei   sa    lu    li    cuan  lv    mie   hui   ou    lv    zhi   gao   du    yuan  li    fei   zhuo  sou   lian  jiang chu   qing  zhu   lu    yan   li    zhu   chen  jie   e     su    huai  nie   yu    long  la    jiao  xian  gui   ju    xiao  ling  ying  jian  yin   you   ying  xiang nong  bo    chan  lan   ju    shuangshe   zui   cong  quan  qu    cang  jiu   yu    luo   li    cuan  luan  dang  jue   yan   lan   lan   zhu   lei   li    ba    nang  yu    ling  guang qian  ci    huan  xin   yu    huan  qian  ou    xu    chao  chu   qi    kai   yi    jue   xi    xu    he    yu    kui   lang  kuan  shuo  xi    ai    yi    qi    xu    chi   qin   kuan  kan   kuan  kan   chuan sha   gua   yin   xin   xie   yu    qian  xiao  ye    ge    wu    tan   jin   ou    hu    ti    huan  xu    pen   xi    xiao  xu    xi    xi    lian  chu   yi    e     yu    chuo  huan  zhi   zheng ci    bu    wu    qi    bu    bu    wai   ju    qian  chi   se    chi   se    zhong sui   sui   li    ze    yu    li    gui   dai   e     si    jian  zhe   mo    mo    yao   mo    cu    yang  tian  sheng dai   shang xu    xun   shu   can   jue   piao  qia   qiu   su    qing  yun   lian  yi    tou   zhi   ye    can   hun   dan   ji    die   zhen  yun   wen   chou  bin   ti    jin   shang yin   diao  jiu   kui   cuan  yi    dan   du    jiang lian  bin   du    jian  jian  shu   ou    duan  zhu   yin   qing  yi    sha   ke    qiao  yao   xun   dian  hui   hui   gu    que   ji    yi    ou    hui   duan  yi    xiao  wu    guan  mu    mei   mei   ai    jie   du    yu    bi    bi    bi    pi    pi    bi    chan  mao   mao   mao   pi    lie   jia   zhan  sai   mu    tuo   xun   er    rong  xian  ju    mu    hao   qiu   dou   ou    tan   pei   ju    duo   cui   bi    san   san   mao   sai   shu   shu   tuo   he    jian  ta    san   lv    mu    li    tong  rong  chang pu    lu    zhan  sao   zhan  meng  lu    qu    die   shi   di    min   jue   meng  qi    pie   nai   qi    dao   xian  chuan fen   yang  nei   bin   fu    shen  dong  qing  qi    yin   xi    hai   yang  an    ya    ke    qing  ya    dong  dan   lv    qing  yang  yun   yun   shui  shui  zheng bing  yong  dang  shui  le    ni    tun   fan   gui   ting  zhi   qiu   bin   ze    mian  cuan  hui   diao  han   cha   yue   chuan wan   fan   dai   xi    tuo   mang  qiu   qi    shan  pin   han   qian  wu    wu    xun   si    ru    gong  jiang chi   wu    tu    jiu   tang  zhi   zhi   qian  mi    gu    wang  jing  jing  rui   jun   hong  tai   quan  ji    bian  bian  gan   wen   zhong pang  xiong jue   hu    niu   qi    fen   xu    xu    qin   yi    wo    yun   yuan  hang  yan   shen  chen  dan   you   dun   hu    huo   qi    mu    niu   mei   da    mian  mi    chong pang  bi    sha   zhi   pei   pan   zhui  za    gou   liu   mei   ze    feng  ou    li    lun   cang  feng  wei   hu    mo    mei   shu   ju    za    tuo   tuo   duo   he    li    mi    yi    fa    fei   you   tian  zhi   zhao  gu    zhan  yan   si    kuang jiong ju    xie   qiu   yi    jia   zhong quan  bo    hui   mi    ben   ze    zhu   le    you   gu    hong  gan   fa    mao   si    hu    peng  ci    fan   chi   su    ning  cheng ling  pao   bo    qi    si    ni    ju    xue   zhu   sheng lei   xuan  jue   fu    pan   min   tai   yang  ji    yong  guan  beng  xue   long  lu    dan   luo   xie   po    ze    jing  yin   zhou  jie   ye    hui   hui   zai   cheng yin   wei   hou   jian  yang  lie   si    ji    er    xing  fu    sa    se    zhi   yin   wu    xi    kao   zhu   jiang luo   luo   an    dong  ti    mou   lei   yi    mi    quan  jin   po    wei   xiao  xie   hong  xu    su    kuang tao   qie   ju    er    zhou  ru    ping  xun   xiong zhi   guang huan  ming  huo   wa    qia   pai   wu    qu    liu   yi    jia   jing  qian  jiang jiao  zhen  shi   zhuo  ce    peng  hui   ji    liu   chan  hun   hu    nong  xun   jin   lie   qiu   wei   zhe   jun   han   bang  mang  zhuo  you   xi    bo    dou   huan  hong  yi    pu    ying  lan   hao   lang  han   li    geng  fu    wu    lian  chun  feng  yi    yu    tong  lao   hai   jin   jia   chong jiong mei   sui   cheng pei   xian  shen  tu    kun   ping  nie   han   jing  xiao  she   nian  tu    yong  xiao  xian  ting  e     su    tun   juan  cen   ti    li    shui  si    lei   shui  tao   du    lao   lai   lian  wei   wo    yun   huan  di    heng  run   jian  zhang se    fu    guan  xing  shou  shuan ya    chuo  zhang ye    kong  wan   han   tuo   dong  he    wo    ju    she   liang hun   ta    zhuo  dian  qie   de    juan  zi    xi    xiao  qi    gu    guo   han   lin   tang  zhou  peng  hao   chang shu   qi    fang  chi   lu    nao   ju    tao   cong  lei   zhe   ping  fei   song  tian  pi    dan   yu    ni    yu    lu    gan   mi    jing  ling  lun   yin   cui   qu    huai  yu    nian  shen  biao  chun  hu    yuan  lai   hun   qing  yan   qian  tian  miao  zhi   yin   bo    ben   yuan  wen   ruo   fei   qing  yuan  ke    ji    she   yuan  se    lu    zi    du    qi    jian  sheng pi    xi    yu    yuan  shen  shen  rou   huan  zhu   jian  nuan  yu    qiu   ting  qu    du    feng  zha   bo    wo    wo    ti    wei   wen   ru    xie   ce    wei   he    gang  yan   hong  xuan  mi    ke    mao   ying  yan   you   hong  miao  sheng mei   zai   hun   nai   gui   chi   e     pai   mei   lian  qi    qi    mei   tian  cou   wei   can   tuan  mian  hui   bo    xu    ji    pen   jian  jian  hu    feng  xiang yi    yin   zhan  shi   jie   zhen  huang tan   yu    bi    min   shi   tu    sheng yong  ju    dong  tuan  jiao  jiao  qiu   yan   tang  long  huo   yuan  nan   ban   you   quan  zhuangliang chan  xian  chun  he    zi    wan   shi   man   ying  la    kui   feng  jian  xu    lou   wei   gai   xia   ying  po    jin   gui   tang  yuan  suo   yuan  lian  yao   meng  zhun  cheng ke    tai   da    wa    liu   gou   sao   ming  zha   shi   yi    lun   ma    pu    wei   li    zai   wu    xi    wen   qiang ze    shi   su    ai    qin   sou   yun   xiu   yin   rong  hun   su    suo   ni    ta    shi   ru    ai    pan   chu   chu   pang  weng  cang  mie   ge    dian  hao   huang xi    zi    di    zhi   ying  fu    jie   hua   ge    zi    tao   teng  sui   bi    jiao  hui   gun   yin   gao   shuangzhi   yan   she   man   ying  chun  lu    lan   luan  xiao  bin   tan   yu    xiu   hu    bi    biao  zhi   jiang kou   shen  shang di    mi    ao    lu    hu    hu    you   chan  fan   yong  gun   man   qing  yu    piao  ji    ya    chao  qi    xi    ji    lu    lou   long  jin   guo   cong  lou   zhi   gai   qiang li    yan   cao   jiao  cong  chun  tuan  ou    teng  ye    xi    mi    tang  mo    shang han   lian  lan   wa    chi   gan   peng  xuan  yi    man   zi    mang  kang  luo   peng  shu   zhang zhang chong xu    huan  huo   jian  yan   chuangliao  cui   ti    yang  jiang cong  ying  hong  xin   shu   guan  ying  xiao  cong  kun   xu    lian  zhi   wei   pi    jue   jiao  po    dang  hui   jie   wu    pa    ji    pan   wei   su    qian  qian  xi    lu    xi    sun   dun   huang min   run   su    lao   zhen  cong  yi    zhi   wan   tan   tan   chao  xun   kui   ye    shao  tu    zhu   sa    hei   bi    shan  chan  chan  shu   tong  pu    lin   wei   se    se    cheng jiong cheng hua   jiao  lao   che   gan   cun   hong  si    shu   peng  han   yun   liu   hong  fu    hao   he    xian  jian  shan  xi    ao    lu    lan   ning  yu    lin   sheng zao   dang  huan  ze    xie   yu    li    shi   xue   ling  man   zi    yong  hui   can   lian  dian  ye    ao    huan  zhen  zhan  man   dan   dan   yi    sui   pi    ju    ta    qin   ji    zhuo  lian  nong  guo   jin   pen   se    ji    sui   wei   chu   ta    song  ting  se    zhu   lai   bin   lian  mi    shi   shu   mi    ning  ying  ying  meng  jin   qi    bi    ji    hao   ru    zui   wo    tao   yin   yin   dui   ci    huo   qing  lan   jun   ai    pu    zhuo  wei   bin   gu    qian  ying  bin   kuo   fei   cang  me    jian  wei   luo   zan   lu    li    you   yang  lu    si    zhi   ying  du    wang  hui   xie   pan   shen  biao  chan  mie   liu   jian  pu    se    cheng gu    bin   huo   xian  lu    qin   han   ying  rong  li    jing  xiao  ying  sui   wei   xie   huai  xue   zhu   long  lai   dui   fan   hu    lai   shu   ling  ying  mi    ji    lian  jian  ying  fen   lin   yi    jian  yue   chan  dai   rang  jian  lan   fan   shuangyuan  zhuo  feng  she   lei   lan   cong  qu    yong  qian  fa    guan  jue   yan   hao   ying  sa    zan   luan  yan   li    mi    shan  tan   dang  jiao  chan  ying  hao   ba    zhu   lan   lan   nang  wan   luan  xun   xian  yan   gan   yan   yu    huo   biao  mie   guang deng  hui   xiao  xiao  hui   hong  ling  zao   zhuan jiu   zha   xie   chi   zhuo  zai   zai   can   yang  qi    zhong fen   niu   gui   wen   pu    yi    lu    chui  pi    kai   pan   yan   kai   pang  mu    chao  liao  que   kang  dun   guang xin   zhi   guang guang wei   qiang bian  da    xia   zheng zhu   ke    zhao  fu    ba    xie   xie   ling  zhuo  xuan  ju    tan   pao   jiong pao   tai   tai   bing  yang  tong  shan  zhu   zha   dian  wei   shi   lian  chi   huang zhou  hu    shuo  lan   ting  jiao  xu    heng  quan  lie   huan  yang  xiu   xiu   xian  yin   wu    zhou  yao   shi   wei   tong  xue   zai   kai   hong  lao   xia   zhu   xuan  zheng po    yan   hui   guang che   hui   kao   chen  fan   shao  ye    hui   hui   tang  jin   re    lie   xi    fu    jiong che   pu    ting  zhuo  ting  wan   hai   peng  lang  shan  xu    feng  chi   rong  hu    xi    shu   he    xun   ku    jue   xiao  xi    yan   han   zhuangjun   di    xie   ji    wu    wu    lv    han   yan   huan  men   ju    dao   bei   fen   lin   kun   hun   tun   xi    cui   wu    hong  ju    fu    wo    jiao  cong  feng  ping  qiong ruo   xi    qiong xin   chao  yan   yan   yi    jiao  yu    gang  ran   pi    gu    wang  sheng gua   shao  shao  nei   geng  wei   chen  he    kui   zhong duan  xia   hui   feng  lian  xuan  xing  huang jiao  jian  bi    ying  zhu   wei   tuan  shan  xi    nuan  nuan  chan  yan   jiong jiong yu    mei   sha   wei   zha   jin   qiong rou   mei   huan  xu    zhao  wei   fan   qiu   sui   yang  lie   zhu   jie   zao   gua   bao   hu    yun   nan   shi   liang bian  gou   tui   tang  chao  shan  en    bo    huang xie   xi    wu    xi    yun   he    he    xi    yun   xiong nai   shan  qiong yao   xun   mi    lian  ying  wu    rong  gong  yan   qiang liu   xi    bi    biao  cong  lu    jian  shu   yi    lou   peng  sui   yi    tong  jue   zong  yun   hu    yi    zhi   ao    wei   liu   han   ou    re    jiong man   kun   shang cuan  zeng  jian  xi    xi    xi    yi    xiao  chi   huang chan  ye    xun   ran   yan   xun   qiao  jun   deng  dun   shen  jiao  fen   si    liao  yu    lin   jiong shao  fen   fan   yan   xun   lan   mei   tang  yi    jiong men   jing  jing  ying  yu    yi    xue   lan   tai   zao   can   sui   xi    que   zong  lian  hui   zhu   xie   ling  wei   yi    xie   zhao  hui   da    nuo   bing  ru    xian  he    xun   jin   chou  dao   yao   he    lan   biao  rong  li    mo    bao   ruo   lv    la    ao    xun   kuang shuo  liao  li    lu    jue   liao  yan   xi    xie   long  ye    can   rang  yue   lan   cong  jue   chong guan  ju    che   mi    tang  lan   zhu   lan   ling  cuan  yu    zhua  zhao  pa    zheng pao   cheng yuan  ai    wei   han   jue   jue   fu    ye    ba    die   ye    yao   zu    shuanger    pan   chuangke    zang  die   qiang yong  qiang pian  ban   pan   chao  jian  pai   du    chuangyu    zha   bian  die   bang  bo    chuangyou   you   du    ya    cheng niu   niu   pin   jiu   mou   ta    mu    lao   ren   mang  fang  mao   mu    gang  wu    yan   ge    bei   si    jian  gu    you   ge    sheng mu    di    qian  quan  quan  zi    te    xi    mang  keng  qian  wu    gu    xi    li    li    pou   ji    gang  te    ben   quan  chun  du    ju    jia   jian  feng  pian  ke    ju    kao   chu   xi    bei   luo   jie   ma    san   wei   li    dun   tong  qiao  jiang xi    li    du    lie   pai   piao  bo    xi    chou  wei   rao   chou  quan  quan  ba    fan   qiu   ji    chai  zhuo  an    ge    zhuangguang ma    you   kang  bo    hou   ya    yin   fan   zhuangyun   kuang niu   di    kuang zhong mu    bei   pi    ju    yi    xing  pao   xia   tuo   hu    ling  fei   pi    ni    yao   you   gou   xue   ju    dan   bo    ku    xian  ning  huan  hen   jiao  he    zhao  ji    xun   shan  ta    rong  shou  tong  lao   du    xia   shi   kuai  zheng yu    sun   yu    bi    mang  xi    juan  li    xia   yin   suan  lang  bei   zhi   yan   sha   li    han   xian  jing  pai   fei   xiao  bai   qi    ni    biao  yin   lai   lie   jian  qiang kun   yan   guo   zong  mi    chang yi    zhi   zheng ya    meng  cai   cu    she   lie   ceng  luo   hu    zong  fu    wei   feng  wo    yuan  xing  zhu   mao   wei   chuan xian  tuan  ya    nao   xie   jia   hou   bian  you   you   mei   cha   yao   sun   bo    ming  hua   yuan  sou   ma    yuan  dai   yu    shi   hao   qiang yi    zhen  cang  hao   man   jing  jiang mu    zhang chan  ao    ao    gao   cui   ben   jue   bi    bi    huang bu    lin   xu    tong  yao   liao  shuo  xiao  shou  dun   jiao  ge    juan  du    hui   kuai  xian  xie   ta    xian  xun   ning  bian  huo   nou   meng  lie   nao   guang shou  lu    ta    xian  mi    rang  huan  nao   luo   xian  qi    jue   xuan  miao  zi    lv    lu    yu    su    wang  qiu   ga    ding  le    ba    ji    hong  di    chuan gan   jiu   yu    qi    yu    chang ma    hong  wu    fu    min   jie   ya    fen   men   bang  yue   jue   yun   jue   wan   jian  mei   dan   pin   wei   huan  xian  qiang ling  dai   yi    an    ping  dian  fu    xuan  xi    bo    ci    gou   jia   shao  po    ci    ke    ran   sheng shen  tai   zu    jia   min   shan  liu   bi    zhen  zhen  jue   fa    long  jin   jiao  jian  li    guang xian  zhou  gong  yan   xiu   yang  xu    luo   su    zhu   qin   yin   xun   bao   er    xiang yao   xia   heng  gui   chong xu    ban   pei   lao   dang  ying  hui   wen   e     cheng ti    wu    wu    cheng jun   mei   bei   ting  xian  chu   han   xuan  yan   qiu   xuan  lang  li    xiu   fu    liu   ya    xi    ling  li    jin   lian  suo   suo   feng  wan   dian  pin   zhan  se    min   yu    ju    chen  lai   min   sheng wei   tian  chu   zhuo  beng  cheng hu    qi    e     kun   chang qi    beng  wan   lu    cong  guan  yan   diao  bei   lin   qin   pi    pa    qiang zhuo  qin   fa    jin   qiong du    jie   hui   yu    mao   mei   chun  xuan  ti    xing  dai   rou   min   jian  wei   ruan  huan  xie   chuan jian  zhuan chang lian  quan  xia   duan  yuan  ya    nao   hu    ying  yu    huang rui   se    liu   shi   rong  suo   yao   wen   wu    zhen  jin   ying  ma    tao   liu   tang  li    lang  gui   tian  qiang cuo   jue   zhao  yao   ai    bin   shu   chang kun   zhuan cong  jin   yi    cui   cong  qi    li    jing  zao   qiu   xuan  ao    lian  men   zhang yin   hua   ying  wei   lu    wu    deng  xiu   zeng  xun   qu    dang  lin   liao  qiong su    huang gui   pu    jing  fan   jin   liu   ji    hui   jing  ai    bi    can   qu    zao   dang  jiao  gun   tan   hui   huan  se    sui   tian  chu   yu    jin   lu    bin   shu   wen   zui   lan   xi    ji    xuan  ruan  wo    gai   lei   du    li    zhi   rou   li    zan   qiong ti    gui   sui   la    long  lu    li    zan   lan   ying  mi    xiang qiong guan  dao   zan   huan  gua   bo    die   bo    hu    zhi   piao  ban   rang  li    wa    shi   xiang qiang ban   pen   fang  dan   weng  ou    feng  mie   wa    hu    ling  yi    ping  ci    bai   juan  chang chi   liu   dang  meng  bu    zhui  ping  bian  zhou  zhen  liu   ci    ying  qi    xian  lou   di    ou    meng  zhuan beng  lin   zeng  wu    pi    dan   weng  ying  yan   gan   dai   shen  tian  tian  han   chang sheng qing  shen  chan  chan  rui   sheng su    shen  yong  shuai lu    fu    yong  beng  feng  ning  tian  you   jia   shen  zha   dian  fu    nan   dian  ping  ting  hua   ding  quan  zai   meng  bi    bi    jiu   sun   liu   chang mu    yun   fan   fu    geng  tian  jie   jie   quan  wei   fu    tian  mu    tao   pan   jiang wa    fu    nan   liu   ben   zhen  xu    mu    mu    ce    tian  gai   bi    da    zhi   lve   qi    lve   pan   yi    fan   hua   yu    yu    mu    jun   yi    liu   she   die   chou  hua   dang  zhui  ji    wan   jiang cheng chang tun   lei   ji    cha   liu   die   tuan  lin   jiang jiang chou  pi    die   die   ya    jie   dan   shu   shu   zhi   yi    ne    nai   ding  bi    jie   liao  gang  ge    jiu   zhou  xia   shan  xu    nve   li    yang  chen  you   ba    jie   xue   qi    xia   cui   bi    yi    li    zong  chuangfeng  zhu   pao   pi    gan   ke    ci    xue   zhi   dan   zhen  fa    zhi   teng  ju    ji    fei   ju    shan  jia   xuan  zha   bing  ni    zheng yong  jing  quan  teng  tong  yi    jie   wei   hui   tan   yang  chi   zhi   hen   ya    mei   dou   jing  xiao  tong  tu    mang  pi    xiao  suan  pu    li    zhi   cuo   duo   wu    sha   lao   shou  huan  xian  yi    beng  zhang guan  tan   fei   ma    lin   chi   ji    tian  an    chi   bi    bi    min   gu    dui   ke    wei   yu    cui   ya    zhu   cu    dan   shen  zhong zhi   yu    hou   feng  la    yang  chen  tu    yu    guo   wen   huan  ku    jia   yin   yi    lou   sao   jue   chi   xi    guan  yi    wen   ji    chuangban   hui   liu   chai  shou  nve   dian  da    bie   tan   zhang biao  shen  cu    luo   yi    zong  chou  zhang zhai  sou   se    que   diao  lou   lou   mo    qin   yin   ying  huang fu    liao  long  qiao  liu   lao   xian  fei   dan   yin   he    ai    ban   xian  guan  wei   nong  yu    wei   yi    yong  pi    lei   li    shu   dan   lin   dian  lin   lai   bie   ji    chi   yang  xuan  jie   zheng me    li    huo   lai   ji    dian  xuan  ying  yin   qu    yong  tan   dian  luo   luan  luan  bo    bo    gui   ba    fa    deng  fa    bai   bai   qie   bi    zao   zao   mao   de    pa    jie   huang gui   ci    ling  gao   mo    ji    jiao  peng  gao   ai    e     hao   han   bi    wan   chou  qian  xi    ai    xiao  hao   huang hao   ze    cui   hao   xiao  ye    po    hao   jiao  ai    xing  huang li    piao  he    jiao  pi    gan   pao   zhou  jun   qiu   cun   que   zha   gu    jun   jun   zhou  zha   zha   zhan  du    min   qi    ying  yu    bei   zhao  zhong pen   he    ying  he    yi    bo    wan   he    ang   zhan  yan   jian  he    yu    kui   fan   gai   dao   pan   fu    qiu   sheng dao   lu    zhan  meng  li    jin   xu    jian  pan   guan  an    lu    xu    zhou  dang  an    gu    li    mu    ding  gan   xu    mang  wang  zhi   qi    yuan  tian  xiang dun   xin   xi    pan   feng  dun   min   ming  sheng shi   yun   mian  pan   fang  miao  dan   mei   mao   kan   xian  kou   shi   yang  zheng yao   shen  huo   da    zhen  kuang ju    shen  yi    sheng mei   mo    zhu   zhen  zhen  mian  shi   yuan  die   ni    zi    zi    chao  zha   xuan  bing  mi    long  sui   tong  mi    die   di    ne    ming  xuan  chi   kuang juan  mou   zhen  tiao  yang  yan   mo    zhong mo    zhuo  zheng mei   suo   qiao  han   huan  di    cheng cuo   juan  e     man   xian  xi    kun   lai   jian  shan  tian  gun   wan   leng  shi   qiong lie   ya    jing  zheng li    lai   sui   juan  shui  sui   du    pi    pi    mu    hun   ni    lu    gao   jie   cai   zhou  yu    hun   ma    xia   xing  hui   gun   zai   chun  jian  mei   du    hou   xuan  tian  kui   gao   rui   mao   xu    fa    wo    miao  chou  gui   mi    weng  kou   dang  chen  ke    sou   xia   qiong mo    ming  man   fen   ze    zhang yi    diao  kou   mo    shui  cong  lou   chi   man   piao  cheng gui   meng  huan  shui  pie   xi    qiao  pu    zhu   deng  shen  shui  liao  che   jian  kan   ye    xu    tong  mou   lin   gui   jian  ye    ai    hui   zhan  jian  gu    zhao  ju    mei   chou  sao   ning  xun   yao   huo   meng  mian  pin   mian  lei   kuang jue   xuan  mian  huo   lu    meng  long  guan  man   xi    chu   tang  kan   zhu   mao   jin   qin   yu    shuo  ze    jue   shi   yi    shen  zhi   hou   shen  ying  ju    zhou  jiao  cuo   duan  ai    jiao  zeng  yue   ba    shi   ding  qi    ji    zi    gan   wu    zhe   ku    gang  xi    fan   kuang dang  ma    sha   dan   jue   li    fu    wen   e     xu    kang  zhi   qi    kan   jie   bin   e     ya    pi    zhe   yan   sui   zhuan che   dun   wa    yan   jin   feng  fa    mo    zha   ju    yu    luo   tuo   tuo   di    zhai  zhen  e     fu    mu    zhu   la    bian  nu    ping  peng  ling  pao   le    po    bo    po    shen  za    ai    li    long  tong  yong  li    kuang chu   keng  quan  zhu   guang gui   e     nao   qia   lu    wei   ai    ge    xian  xing  yan   dong  peng  xi    lao   hong  shuo  xia   qiao  qing  wei   qiao  ceng  keng  xiao  que   chan  lang  hong  yu    xiao  xia   bang  long  yong  che   che   wo    liu   ying  mang  que   yan   sha   kun   gu    ceng  hua   lu    chen  jian  nuo   song  zhuo  keng  peng  yan   zhui  kong  cheng qi    zong  qing  lin   jun   bo    ding  min   diao  jian  he    lu    ai    sui   que   leng  bei   yin   dui   wu    qi    lun   wan   dian  nao   bei   qi    chen  ruan  yan   die   ding  zhou  tuo   jie   ying  bian  ke    bi    wei   shuo  zhen  duan  xia   dang  ti    nao   peng  jian  di    tan   cha   tian  qi    dun   feng  xuan  que   qiao  ma    gong  nian  su    e     ci    liu   si    tang  bang  hua   pi    kui   sang  lei   cuo   tian  xia   qi    lian  pan   wei   yun   dui   zhe   ke    la    pai   yao   gun   zhuan chan  qi    ao    peng  liu   lu    kan   chuangchen  yin   lei   piao  qi    mo    qi    cui   zong  qing  chuo  lun   ji    shan  lao   qu    zeng  deng  jian  xi    lin   ding  dian  huang bo    za    qiao  di    li    jian  jiao  xi    zhang qiao  dun   jian  yu    zhui  he    ke    ze    lei   jie   chu   ye    que   dang  yi    jiang pi    pi    yu    pin   qi    ai    ke    jian  yu    ruan  meng  pao   ci    bo    yang  ma    ca    xian  kuang lei   lei   zhi   li    li    fan   que   pao   ying  li    long  long  mo    bo    shuangguan  lan   ca    yan   shi   shi   li    reng  she   yue   si    qi    ta    ma    xie   yao   xian  qi    qi    zhi   beng  dui   zhong zhong yi    shi   you   zhi   tiao  fu    fu    mi    zu    zhi   suan  mei   zuo   qu    hu    zhu   shen  sui   ci    chai  mi    lv    yu    xiang wu    tiao  piao  zhu   gui   xia   zhi   ji    gao   zhen  gao   shui  jin   shen  gai   kun   di    dao   huo   tao   qi    gu    guan  zui   ling  lu    bing  jin   dao   zhi   lu    chan  bi    chu   hui   you   xi    yin   zi    huo   zhen  fu    yuan  wu    xian  yang  zhi   yi    mei   si    di    bei   zhuo  zhen  yong  ji    gao   tang  si    ma    ta    fu    xuan  qi    yu    xi    ji    si    chan  dan   gui   sui   li    nong  mi    dao   li    rang  yue   zhi   zan   lei   rou   yu    yu    li    xie   qin   he    tu    xiu   si    ren   tu    zi    cha   gan   yi    xian  bing  nian  qiu   qiu   zhong fen   hao   yun   ke    miao  zhi   jing  bi    zhi   yu    mi    ku    ban   pi    ni    li    you   zu    pi    bo    ling  mo    cheng nian  qin   yang  zuo   zhi   zhi   shu   ju    zi    huo   ji    chen  tong  zhi   huo   he    yin   zi    zhi   jie   ren   du    yi    zhu   hui   nong  fu    xi    gao   lang  fu    ze    shui  lv    kun   gan   jing  ti    cheng tu    shao  shui  ya    lun   lu    gu    zuo   ren   zhun  bang  bai   ji    zhi   zhi   kun   leng  peng  ke    lin   chou  zu    yu    su    lve   lve   yi    xi    bian  ji    fu    bi    nuo   jie   zhong zong  xu    chen  dao   wen   lian  zi    yu    ji    xu    zhen  zhi   dao   jia   ji    gao   gao   gu    rong  sui   rong  ji    kang  mu    can   men   zhi   ji    lu    su    ji    ying  wen   qiu   se    kuo   yi    huang qie   ji    sui   xiao  pu    jiao  zhuo  tong  zui   lv    sui   nong  se    hui   rang  nuo   yu    pin   ji    tui   wen   cheng huo   kuang lv    biao  se    rang  zhuo  li    cuan  xue   ya    jiu   qiong xi    qiong kong  yu    shen  jing  yao   chuan zhun  tu    lao   qie   zhai  yao   bian  bao   yao   bing  wa    zhu   jiao  qiao  diao  wu    gui   yao   zhi   chuangyao   tiao  jiao  chuangjiong xiao  cheng kou   cuan  wo    dan   ku    ke    zhuo  xu    su    guan  kui   dou   zhuo  xun   wo    wa    ya    yu    ju    qiong yao   yao   tiao  chao  yu    tian  diao  ju    liao  xi    wu    kui   chuangzhao  kuan  kuan  long  cheng cui   liao  zao   cuan  qiao  qiong dou   zao   long  qie   li    chu   shi   fu    qian  chu   hong  qi    hao   sheng fen   shu   miao  qu    zhan  zhu   ling  long  bing  jing  jing  zhang bai   si    jun   hong  tong  song  jing  diao  yi    shu   jing  qu    jie   ping  duan  li    zhuan ceng  deng  cun   wai   jing  kan   jing  zhu   zhu   le    peng  yu    chi   gan   mang  zhu   wan   du    ji    jiao  ba    suan  ji    qin   zhao  sun   ya    zhui  yuan  hu    hang  xiao  cen   pi    bi    jian  yi    dong  shan  sheng xia   di    zhu   na    chi   gu    li    qie   min   bao   tiao  si    fu    ce    ben   pei   da    zi    di    ling  ze    nu    fu    gou   fan   jia   gan   fan   shi   mao   po    shi   jian  qiong long  min   bian  luo   gui   qu    chi   yin   yao   xian  bi    qiong kuo   deng  jiao  jin   quan  sun   ru    fa    kuang zhu   tong  ji    da    hang  ce    zhong kou   lai   bi    shai  dang  zheng ce    fu    jun   tu    pa    li    lang  ju    guan  jian  han   tong  xia   zhi   cheng suan  shi   zhu   zuo   xiao  shao  ting  ce    yan   gao   kuai  gan   chou  kuang gang  yun   ou    qian  xiao  jian  pou   lai   zou   pai   bi    bi    ge    tai   guai  yu    jian  zhao  gu    hu    zheng qing  sha   zhou  lu    bo    ji    lin   suan  jun   fu    zha   gu    kong  qian  qian  jun   chui  guan  yuan  ce    zu    bo    ze    qie   tuo   luo   dan   xiao  ruo   jian  xuan  bian  sun   xiang xian  ping  zhen  xing  hu    shi   zhu   yue   chun  lv    wu    dong  shuo  ji    jie   huang xing  mei   fan   chuan zhuan pian  feng  zhu   hong  qie   hou   qiu   miao  qian  gu    kui   shi   lou   yun   he    tang  yue   chou  gao   fei   ruo   zheng gou   nie   qian  xiao  cuan  gong  pang  du    li    bi    zhuo  chu   shai  chi   zhu   qiang long  lan   jian  bu    li    hui   bi    di    cong  yan   peng  se    cuan  pi    piao  dou   yu    mie   tuan  ze    shai  gui   yi    hu    chan  kou   cu    ping  zao   ji    gui   su    lou   ce    lu    nian  suo   cuan  diao  suo   le    duan  liang xiao  bo    mi    shai  dang  liao  dan   dian  fu    jian  min   kui   dai   jiao  deng  huang sun   lao   zan   xiao  lu    shi   zan   qi    pai   qi    pi    gan   ju    lu    lu    yan   bo    dang  sai   zhua  gou   qian  lian  bu    zhou  lai   shi   lan   kui   yu    yue   hao   zhen  tai   ti    nie   chou  ji    yi    qi    teng  zhuan zhou  fan   shu   zhou  qian  zhuo  teng  lu    lu    jian  tuo   ying  yu    lai   long  qie   lian  lan   qian  yue   zhong qu    lian  bian  duan  zuan  li    shi   luo   ying  yue   zhuo  yu    mi    di    fan   shen  zhe   shen  nv    he    lei   xian  zi    ni    cun   zhang qian  zhai  bi    ban   wu    sha   kang  rou   fen   bi    sui   yin   zhe   mi    tai   hu    ba    li    gan   ju    po    mo    cu    zhan  zhou  chi   su    tiao  li    xi    su    hong  tong  zi    ce    yue   zhou  lin   zhuangbai   lao   fen   er    qu    he    liang xian  fu    liang can   jing  li    yue   lu    ju    qi    cui   bai   zhang lin   zong  jing  guo   hua   san   san   tang  bian  rou   mian  hou   xu    zong  hu    jian  zan   ci    li    xie   fu    nuo   bei   gu    xiu   gao   tang  qiu   jia   cao   zhuangtang  mi    san   fen   zao   kang  jiang mo    san   san   nuo   chi   liang jiang kuai  bo    huan  shu   ji    xian  nuo   tuan  nie   li    zuo   di    nie   tiao  lan   mi    si    jiu   xi    gong  zheng jiu   you   ji    cha   zhou  xun   yue   hong  yu    ge    wan   ren   wen   wen   qiu   na    zi    tou   niu   fou   ji    shu   chun  pi    zhen  sha   hong  zhi   ji    fen   yun   ren   dan   jin   su    fang  suo   cui   jiu   za    ba    jin   fu    zhi   qi    zi    chou  hong  za    lei   xi    fu    xie   shen  bo    zhu   qu    ling  zhu   shao  gan   yang  fu    tuo   zhen  dai   chu   shi   zhong xian  zu    jiong ban   qu    mo    shu   zui   kuang jing  ren   hang  xie   jie   zhu   chou  gua   bai   jue   kuang hu    ci    huan  geng  tao   xie   ku    jiao  quan  gai   luo   xuan  beng  xian  fu    gei   tong  rong  tiao  yin   lei   xie   juan  xu    gai   die   tong  si    jiang xiang hui   jue   zhi   jian  juan  chi   wen   zhen  lv    cheng qiu   shu   bang  tong  xiao  huan  qin   geng  xiu   ti    xiu   xie   hong  xi    fu    ting  sui   dui   kun   fu    jing  hu    zhi   yan   jiong feng  ji    xu    ren   zong  chen  duo   li    lv    liang chou  quan  shao  qi    qi    zhun  qi    wan   qian  xian  shou  wei   qi    tao   wan   gang  wang  beng  zhui  cai   guo   cui   lun   liu   qi    zhan  bi    chuo  ling  mian  qi    qie   tian  zong  gun   zou   xi    zi    xing  liang jin   fei   rui   min   yu    zong  fan   lv    xu    ying  shang qi    xu    xiang jian  ke    xian  ruan  mian  ji    duan  chong di    min   mao   yuan  xie   bao   si    qiu   bian  huan  geng  cong  mian  wei   fu    wei   tou   gou   miao  xie   lian  zong  bian  gun   yin   ti    gua   zhi   yun   cheng chan  dai   xia   yuan  zong  xu    sheng wei   geng  se    ying  jin   yi    zhui  ni    bang  gu    pan   zhou  jian  ci    quan  shuangyun   xia   cui   ji    rong  tao   fu    yun   zhen  gao   ru    hu    zai   teng  xian  su    zhen  zong  tao   huang cai   bi    feng  cu    li    suo   yan   xi    zong  lei   zhuan qian  man   zhi   lv    mo    piao  lian  mi    xuan  zong  ji    shan  sui   fan   lv    beng  yi    sao   miu   yao   qiang hun   xian  ji    sha   xiu   ran   xuan  sui   qiao  zeng  zuo   zhi   shan  san   lin   yu    fan   liao  chao  zun   jian  rao   chan  rui   xiu   hui   hua   zuan  xi    qiang yun   da    sheng hui   ji    se    jian  jiang huan  qiao  cong  jie   jiao  bi    chan  yi    nong  sui   yi    sha   ru    ji    bin   qian  lan   pu    xun   zuan  qi    peng  yao   mo    lei   xie   zuan  kuang you   xu    lei   xian  chan  jiao  lu    chan  ying  cai   rang  xian  zui   zuan  luo   xi    dao   lan   lei   lian  si    jiu   yu    hong  zhou  xian  ge    yue   ji    wan   kuang ji    ren   wei   yun   hong  chun  pi    sha   gang  na    ren   zong  lun   fen   zhi   wen   fang  zhu   zhen  niu   shu   xian  gan   xie   fu    lian  zu    shen  xi    zhi   zhong zhou  ban   fu    chu   shao  yi    jing  dai   bang  rong  jie   ku    rao   die   hang  hui   gei   xuan  jiang luo   jue   jiao  tong  geng  xiao  juan  xiu   xi    sui   tao   ji    ti    ji    xu    ling  ying  xu    qi    fei   chuo  shang gun   sheng wei   mian  shou  beng  chou  tao   liu   quan  zong  zhan  wan   lv    zhui  zi    ke    xiang jian  mian  lan   ti    miao  ji    yun   hui   si    duo   duan  bian  xian  gou   zhui  huan  di    lv    bian  min   yuan  jin   fu    ru    zhen  feng  cui   gao   chan  li    yi    jian  bin   piao  man   lei   ying  suo   miu   sao   xie   liao  shan  zeng  jiang qian  qiao  huan  jiao  zuan  fou   xie   gang  fou   que   fou   qi    bo    ping  xiang zhao  gang  ying  ying  qing  xia   guan  zun   tan   cang  qi    weng  ying  lei   tan   lu    guan  wang  si    gang  wang  han   ra    luo   fu    shen  fa    gu    zhu   ju    meng  gu    min   gang  ba    gua   ti    juan  fu    shen  yan   zhao  zui   gua   zhuo  yu    zhi   an    fa    lan   shu   si    pi    ma    liu   ba    fa    li    chao  wei   bi    ji    zeng  chong liu   ji    juan  mi    zhao  luo   pi    ji    ji    luan  yang  mi    qiang da    mei   yang  you   you   fen   ba    gao   yang  gu    qiang zang  gao   ling  yi    zhu   di    xiu   qiang yi    xian  rong  qun   qun   qiang huan  suo   xian  yi    yang  qiang qian  yu    geng  jie   tang  yuan  xi    fan   shan  fen   shan  lian  lei   geng  nou   qiang chan  yu    gong  yi    chong weng  fen   hong  chi   chi   cui   fu    xia   pen   yi    la    yi    pi    ling  liu   zhi   qu    xi    xie   xiang xi    xi    ke    qiao  hui   hui   xiao  sha   hong  jiang zhai  cui   fei   dao   sha   chi   zhu   jian  xuan  chi   pian  zong  wan   hui   hou   he    he    han   ao    piao  yi    lian  qu    ao    lin   pen   qiao  ao    fan   yi    hui   xuan  dao   yao   lao   lao   kao   mao   zhe   qi    gou   gou   gou   die   die   er    shua  ruan  er    nai   duan  lei   ting  zi    geng  chao  hao   yun   pa    pi    chi   si    qu    jia   ju    huo   chu   lao   lun   ji    tang  ou    lou   nou   jiang pang  ze    lou   ji    lao   huo   you   mo    huai  er    yi    ding  ye    da    song  qin   yun   chi   dan   dan   hong  geng  zhi   zhi   nie   dan   zhen  che   ling  zheng you   wa    liao  long  zhi   ning  tiao  er    ya    tie   guo   se    lian  hao   sheng lie   pin   jing  ju    bi    di    guo   wen   xu    ping  cong  ding  ding  ting  ju    cong  kui   lian  kui   cong  lian  weng  kui   lian  lian  cong  ao    sheng song  ting  kui   nie   zhi   dan   ning  qie   jian  ting  ting  long  yu    nie   zhao  si    su    yi    su    si    zhao  zhao  rou   yi    lei   ji    qiu   ken   cao   ge    di    huan  huang chi   ren   xiao  ru    zhou  yuan  du    gang  rong  gan   cha   wo    chang gu    zhi   han   fu    fei   fen   pei   pang  jian  fang  zhun  you   na    ang   ken   ran   gong  yu    wen   yao   qi    pi    qian  xi    xi    fei   ken   jing  tai   shen  zhong zhang xie   shen  wei   zhou  die   dan   bi    ba    bo    qu    tian  bei   gua   tai   zi    fei   zhi   ni    peng  zi    fu    pang  zhen  xian  zuo   pei   jia   sheng zhi   bao   mu    qu    hu    ke    chi   yin   xu    yang  long  dong  ka    lu    jing  nu    yan   pang  kua   yi    guang hai   ge    dong  chi   jiao  xiong xiong er    an    heng  pian  nen   zi    gui   cheng tiao  zhi   cui   mei   xie   cui   xie   mai   mai   ji    xie   nin   kuai  sa    zang  qi    nao   mi    nong  luan  wen   bo    wen   wan   xiu   jiao  jing  you   heng  cuo   lie   shan  ting  mei   chun  shen  jia   te    juan  ji    xiu   xin   tuo   pao   cheng tui   fu    dou   tuo   niao  nao   pi    gu    luo   lei   lian  zhang sui   jie   liang shui  pi    biao  lun   pian  guo   quan  chui  dan   tian  nei   jing  nai   la    ye    yan   ren   shen  chuo  fu    fu    ju    fei   qiang wan   dong  pi    guo   zong  ding  wo    mei   ruan  dun   chi   cou   luo   ou    di    an    xing  nao   shu   shuan nan   yun   zhong rou   e     sai   tu    yao   jian  wei   jiao  yu    jia   duan  bi    chang fu    xian  ni    mian  wa    teng  tui   bang  qian  lv    wa    shou  tang  su    zhui  ge    yi    bo    liao  ji    pi    xie   gao   lv    bin   ou    chang lu    guo   pang  chuai biao  jiang fu    tang  mo    xi    zhuan lu    jiao  ying  lv    zhi   xue   cen   lin   tong  peng  ni    zha   liao  cui   gui   xiao  teng  fan   zhi   jiao  shan  hu    cui   yen   xiang sui   fen   ying  shan  zhua  dan   kuai  nong  tun   lian  bi    yong  jue   chu   yi    juan  la    lian  sao   tun   gu    qi    cui   bin   xun   nao   wo    zang  xian  biao  xing  kun   la    yan   lu    huo   za    luo   qu    zang  luan  ni    za    chen  qian  wo    guang zang  lin   guang zi    jiao  nie   chou  ji    gao   chou  mian  nie   zhi   zhi   ge    jian  die   zhi   xiu   tai   zhen  jiu   xian  yu    cha   yao   yu    chong que   xi    jiu   yu    yu    xing  ju    jiu   xin   she   she   she   jiu   shi   tan   shu   shi   tian  tan   pu    pu    guan  hua   tian  chuan shui  xia   wu    zhou  dao   chuan shan  yi    fan   pa    tai   fan   ban   chuan hang  fang  ban   bi    lu    zhong jian  cang  ling  zhu   ze    duo   bo    xian  ge    chuan xia   lu    qiong pang  xi    kua   fu    zao   feng  li    shao  yu    lang  ting  ting  wei   bo    meng  nian  ju    huang shou  zong  bian  mu    die   dou   bang  cha   yi    sou   cang  cao   lou   dai   xue   yao   chong deng  dang  qiang lu    yi    ji    jian  huo   meng  qi    lu    lu    chan  shuanggen   liang jian  jian  se    yan   fu    ping  yan   yan   cao   cao   yi    le    ting  jiao  ai    nai   tiao  jiao  jie   peng  wan   yi    cha   mian  mi    gan   qian  yu    yu    shao  xiong du    hu    qi    mang  zi    hui   sui   zhi   xiang pi    fu    tun   wei   wu    zhi   qi    shan  wen   qian  ren   fu    kou   jie   lu    zhu   ji    qin   qi    yan   fen   ba    rui   xin   ji    hua   hua   fang  wu    jue   ji    zhi   yun   qin   ao    chu   mao   ya    fu    reng  hang  cong  yin   you   bian  yi    qie   wei   li    pi    e     xian  chang cang  zhu   su    di    yuan  ran   ling  tai   shao  di    miao  qing  li    yong  ke    mu    bei   bao   gou   min   yi    yi    ju    pie   ruo   ku    zhu   ni    bo    bing  shan  xiu   yao   xian  ben   hong  ying  zha   dong  ju    die   nie   gan   hu    ping  mei   fu    sheng gua   bi    wei   fu    zhuo  mao   fan   qie   mao   mao   ba    ci    mo    zi    zhi   chi   ji    jing  long  cong  niao  niao  xue   ying  qiong ge    ming  li    rong  yin   gen   qian  chai  chen  yu    hao   zi    lie   wu    duo   gui   ci    jian  ci    gou   guang mang  cha   jiao  jiao  fu    yu    zhu   zi    jiang hui   yin   cha   fa    rong  ru    chong mang  tong  zhong qian  zhu   xun   huan  fu    quan  gai   da    jing  xing  chuan cao   jing  er    an    qiao  chi   ren   jian  yi    huang ping  li    jin   lao   shu   zhuangda    jia   rao   bi    ce    qiao  hui   qi    dang  yu    rong  hun   ying  luo   ying  qian  jin   sun   yin   mai   hong  zhou  yao   du    wei   li    dou   fu    ren   yin   he    bi    bu    yun   di    tu    sui   sui   cheng chen  wu    bie   xi    geng  li    pu    zhu   mo    li    zhuangzuo   tuo   qiu   sha   suo   chen  peng  ju    mei   meng  xing  jing  che   xin   jun   yan   ting  you   cuo   wan   han   you   cuo   jia   wang  you   niu   shao  xian  lang  fu    e     mo    wen   jie   nan   mu    kan   lai   lian  shi   wo    tu    xian  huo   you   ying  ying  n     chun  mang  mang  ci    wan   jing  di    qu    dong  jian  zou   gu    la    lu    ju    wei   jun   nie   kun   he    pu    zai   gao   guo   fu    lun   chang chou  song  chui  zhan  men   cai   ba    li    tu    bo    han   bao   qin   juan  xi    qin   di    jie   pu    dang  jin   qiao  tai   geng  hua   gu    ling  fei   qin   an    wang  beng  zhou  yan   zu    jian  lin   tan   shu   tian  dao   hu    qi    he    cui   tao   chun  bi    chang huan  fei   lai   qi    meng  ping  wei   dan   sha   huan  yan   yi    shao  ji    guan  ce    nai   zhen  tuo   jiu   tie   luo   bi    yi    meng  bao   pao   ding  ying  ying  ying  xiao  sa    qiu   ke    xiang wan   yu    yu    fu    lian  xuan  xuan  nan   ce    wo    chun  xiao  yu    bian  mu    an    e     luo   ying  kuo   kuo   jiang mian  zuo   zuo   zu    bao   rou   xi    ye    an    qu    jian  fu    lv    jian  pen   feng  hong  hong  hou   yan   tu    zhu   zi    xiang ren   ge    qia   qing  mi    huang shen  pu    gai   dong  zhou  jian  wei   bo    wei   pa    ji    hu    zang  jia   duan  yao   sui   cong  quan  wei   zhen  kui   ting  hun   xi    shi   qi    lan   zong  yao   yuan  mei   yun   shu   di    zhuan guan  ran   xue   chan  kai   kui   kui   jiang lou   wei   pai   you   sou   yin   shi   chun  shi   yun   zhen  lang  ru    meng  li    que   suan  yuan  li    ju    xi    bang  chu   xu    tu    liu   huo   dian  qian  zu    po    cuo   yuan  chu   yu    kuai  pan   pu    pu    na    shuo  xi    fen   yun   zheng jian  ji    ruo   cang  en    mi    hao   sun   zhen  ming  sou   xu    liu   xi    gu    lang  rong  weng  gai   cuo   shi   tang  luo   ru    suo   xuan  bei   yao   gui   bi    zong  gun   zuo   tiao  ce    pei   lan   lan   ji    li    shen  lang  yu    ling  ying  mo    diao  tiao  mao   tong  zhu   peng  an    lian  cong  xi    ping  qiu   jin   chun  jie   wei   tui   cao   yu    yi    ju    liao  bi    lu    xu    bu    zhang lei   qiang man   yan   ling  ji    biao  gun   han   di    su    lu    she   shang di    mie   xun   man   bo    di    cuo   zhe   shen  xuan  wei   hu    ao    mi    lou   cu    zhong cai   po    jiang mi    cong  niao  hui   juan  yin   shan  yan   shu   yin   guo   chen  hu    sha   kou   qian  ma    cang  ze    qiang dou   lian  lin   kou   ai    bi    li    wei   ji    qian  sheng fan   meng  ou    chan  dian  xun   jiao  rui   rui   lei   yu    qiao  chu   hua   jian  mai   yun   bao   you   qu    lu    rao   hui   e     ti    fei   jue   zui   fei   ru    fen   kui   shui  rui   ya    xu    fu    jue   dang  wu    dong  si    xiao  xi    long  yun   shao  qi    jian  yun   sun   ling  yu    xia   weng  ji    hong  si    nong  lei   xuan  yun   yu    xi    hao   bo    hao   ai    wei   hui   hui   ji    ci    xiang wan   mie   yi    leng  jiang can   shen  qiang lian  ke    yuan  da    ti    tang  xue   bi    zhan  sun   xian  fan   ding  xie   gu    xie   shu   jian  hao   hong  sa    xin   xun   yao   bai   sou   shu   xun   dui   pin   wei   ning  chou  mai   ru    piao  tai   qi    zao   chen  zhen  er    ni    ying  gao   cong  xiao  qi    fa    jian  xu    kui   jie   bian  diao  mi    lan   jin   cang  miao  qiong qie   xian  xian  ou    xian  su    lv    yi    xu    xie   li    yi    la    lei   jiao  di    zhi   bei   teng  yao   mo    huan  biao  fan   sou   tan   tui   qiong qiao  wei   liu   hui   ou    gao   yun   bao   li    shu   zhu   ai    lin   zao   xuan  qin   lai   huo   tuo   wu    rui   rui   qi    heng  lu    su    tui   mang  yun   ping  yu    xun   ji    jiong xuan  mo    qiu   su    jiong feng  nie   bo    rang  yi    xian  yu    ju    lian  lian  yin   qiang ying  long  tou   hua   yue   ling  qu    yao   fan   mei   han   kui   lan   ji    dang  man   lei   lei   hua   feng  zhi   wei   kui   zhan  huai  li    ji    mi    lei   huai  luo   ji    kui   lu    jian  sai   teng  lei   quan  xiao  yi    luan  men   bie   hu    hu    lu    nve   lv    si    xiao  qian  chu   hu    xu    cuo   fu    xu    xu    lu    hu    yu    hao   jiao  ju    guo   bao   yan   zhan  zhan  kui   bin   xi    shu   chong qiu   diao  ji    qiu   cheng shi   shi   jue   zhe   she   yu    han   zi    hong  hui   meng  ge    sui   xia   chai  shi   yi    ma    xiang fang  e     ba    chi   qian  wen   wen   rui   bang  pi    yue   yue   jun   qi    tong  yin   qi    can   yuan  jue   hui   qin   qi    zhong ya    hao   mu    wang  fen   fen   hang  gong  zao   fu    ran   jie   fu    chi   dou   pao   xian  ni    dai   qiu   you   zha   ping  chi   you   he    han   ju    li    fu    ran   zha   gou   pi    bo    xian  zhu   diao  bie   bing  gu    zhan  qu    she   tie   ling  gu    dan   gu    ying  li    cheng qu    mao   ge    ci    hui   hui   mang  fu    yang  wa    lie   zhu   yi    xian  kuo   jiao  li    yi    ping  jie   ge    she   yi    wang  mo    qiong qie   gui   qiong zhi   man   lao   zhe   jia   nao   si    qi    xing  jie   qiu   shao  yong  jia   tui   che   bei   e     han   shu   xuan  feng  shen  zhen  fu    xian  zhe   wu    fu    li    lang  bi    chu   yuan  you   jie   dan   yan   ting  dian  tui   hui   wo    zhi   song  fei   ju    mi    qi    qi    yu    jun   la    meng  qiang si    xi    lun   li    die   tiao  tao   kun   han   han   yu    bang  fei   pi    wei   dun   yi    yuan  suo   quan  qian  rui   ni    qing  wei   liang guo   wan   dong  e     ban   di    wang  can   mi    ying  guo   chan  chan  la    ke    ji    xie   ting  mao   xu    mian  yu    jie   shi   xuan  huang yan   bian  rou   wei   fu    yuan  mei   wei   fu    ruan  xie   you   qiu   mao   xia   ying  shi   chong tang  zhu   zong  ti    fu    yuan  kui   meng  la    du    hu    qiu   die   xi    wo    yun   qu    nan   lou   chun  rong  ying  jiang ban   lang  pang  si    xi    ci    xi    yuan  weng  lian  sou   ban   rong  rong  ji    wu    xiu   han   qin   yi    bi    hua   tang  yi    du    nai   he    hu    hui   ma    ming  yi    wen   ying  teng  zhong cang  si    qi    man   tiao  shang shi   cao   chi   di    ao    lu    wei   zhi   tang  chen  piao  qu    pi    yu    jian  luo   lou   qin   zhong yin   jiang shuai wen   xiao  man   zhe   zhe   ma    ma    guo   liu   mao   xi    cong  li    man   xiao  chang zhang mang  xiang mo    zui   si    qiu   te    zhi   peng  peng  jiao  qu    bie   liao  pan   gui   xi    ji    zhuan huang fei   lao   jue   jue   hui   yin   chan  jiao  shan  nao   xiao  mou   chong xun   si    chu   cheng dang  li    xie   shan  yi    jing  da    chan  qi    ci    xiang she   luo   qin   ying  chai  li    zei   xuan  lian  zhu   ze    xie   mang  xie   qi    rong  jian  meng  hao   ru    huo   zhuo  jie   bin   he    mie   fan   lei   jie   la    min   li    chun  li    qiu   nie   lu    du    xiao  zhu   long  li    long  pang  ye    pi    nang  gu    juan  ying  shu   xi    can   qu    quan  du    can   man   qu    jie   zhu   zhuo  xue   huang nv    pei   nv    xin   zhong mai   er    kai   mie   xi    xing  yan   kan   yuan  qu    ling  xuan  shu   xian  tong  long  jie   xian  ya    hu    wei   dao   chong wei   dao   zhun  heng  qu    yi    yi    bu    gan   yu    biao  cha   yi    shan  chen  fu    gun   fen   shuai jie   na    zhong dan   yi    zhong zhong jie   zhi   xie   ran   zhi   ren   qin   jin   jun   yuan  mei   chai  ao    niao  hui   ran   jia   tuo   ling  dai   bao   pao   yao   zuo   bi    shao  tan   ju    he    xue   xiu   zhen  yi    pa    bo    di    wa    fu    gun   zhi   zhi   ran   pan   yi    mao   tuo   na    gou   xuan  zhe   qu    bei   yu    xi    mi    bo    bo    fu    chi   chi   ku    ren   jiang jia   jian  mo    jie   er    ge    ru    zhu   gui   yin   cai   lie   ka    xing  zhuangdang  se    kun   ken   niao  shu   jia   kun   cheng li    juan  shen  pou   ge    yi    yu    zhen  liu   qiu   qun   ji    yi    bu    zhuangshui  sha   qun   li    lian  lian  ku    jian  xiu   chan  bi    kun   tao   yuan  ling  chi   chang chou  duo   biao  liang shang pei   pei   fei   gun   luo   guo   yan   du    ti    zhi   ju    qi    qi    guo   gua   ken   qi    ti    shi   fu    chong xie   bian  die   kun   duan  xiu   xiu   he    yuan  bao   bao   fu    yu    tuan  yan   hui   bei   chu   lv    pao   dan   yun   ta    gou   da    huai  rong  yuan  ru    nai   jiong cha   ban   tui   chi   sang  niao  ying  jie   qian  huai  ku    lian  lan   li    zhe   shi   lv    yi    die   xie   xian  wei   biao  cao   ji    qiang se    bao   xiang bi    fu    jian  zhuan jian  cui   ji    dan   za    fan   bo    xiang xun   bie   rao   man   lan   ao    ze    gui   cao   sui   nong  chan  lian  bi    jin   dang  shu   tan   bi    lan   fu    ru    zhi   ta    shu   wa    shi   bai   xie   bo    chen  lai   long  xi    xian  lan   zhe   dai   ju    zan   shi   jian  pan   yi    lan   ya    xi    xi    yao   feng  tan   fu    fiao  fu    ba    he    ji    ji    jian  guan  bian  yan   gui   jue   pian  mao   mi    mi    mie   shi   si    chan  zhen  jue   mi    tiao  lian  yao   zhi   jun   xi    shan  wei   xi    tian  yu    lan   e     du    qin   pang  ji    ming  ying  gou   qu    zhan  jin   guan  deng  jian  luo   qu    jian  wei   jue   qu    luo   lan   shen  di    guan  jian  guan  yan   gui   mi    shi   chan  lan   jue   ji    xi    di    tian  yu    gou   jin   qu    jiao  qiu   jin   cu    jue   zhi   chao  ji    gu    dan   zi    di    shang hua   quan  ge    shi   jie   gui   gong  chu   jie   hun   qiu   xing  su    ni    ji    lu    zhi   zha   bi    xing  hu    shang gong  zhi   xue   chu   xi    yi    lu    jue   xi    yan   xi    yan   yan   ding  fu    qiu   qiu   jiao  hong  ji    fan   xun   diao  hong  cha   tao   xu    jie   dan   ren   xun   yin   shan  qi    tuo   ji    xun   yin   e     fen   ya    yao   song  shen  yin   xin   jue   xiao  ne    chen  you   zhi   xiong fang  xin   chao  she   yan   sa    zhun  xu    yi    yi    su    chi   he    shen  he    xu    zhen  zhu   zheng gou   zi    zi    zhan  gu    fu    jian  die   ling  di    yang  li    nao   pan   zhou  gan   yi    ju    yao   zha   tuo   yi    qu    zhao  ping  bi    xiong qu    ba    da    zu    tao   zhu   ci    zhe   yong  xu    xun   yi    huang he    shi   cha   xiao  shi   hen   cha   gou   gui   quan  hui   jie   hua   gai   xiang wei   shen  chou  dong  mi    zhan  ming  e     hui   yan   xiong gua   er    bing  tiao  yi    lei   zhu   kuang kua   wu    yu    teng  ji    zhi   ren   cu    lang  e     kuang xi    shi   ting  dan   bei   chan  you   keng  qiao  qin   shua  an    yu    xiao  cheng jie   xian  wu    wu    gao   song  bu    hui   jing  shui  zhen  shui  du    hua   chang shui  jie   ke    qu    cong  xiao  sui   wang  xian  fei   chi   ta    yi    na    yin   diao  pi    zhuo  chan  chen  zhun  ji    qi    tan   zhui  wei   ju    qing  dong  zheng ze    zou   qian  zhuo  liang jian  chu   xia   lun   shen  biao  hua   pian  yu    die   xu    pian  shi   xuan  shi   hun   hua   e     zhong di    xie   fu    pu    ting  jian  qi    yu    zi    zhuan xi    hui   yin   an    xian  nan   chen  feng  zhu   yang  yan   huang xuan  ge    nuo   qi    mou   ye    wei   xing  teng  zhou  shan  jian  po    kui   huang huo   ge    ying  mi    xiao  mi    xi    qiang chen  xue   ti    su    bang  chi   qian  shi   jiang yuan  xie   xiao  tao   yao   yao   zhi   yu    biao  cong  qing  li    mo    mo    shang zhe   miu   jian  ze    zu    lian  lou   can   ou    gun   xi    zhuo  ao    ao    jin   zhe   yi    hu    jiang man   chao  han   hua   chan  xu    zeng  se    xi    zha   dui   zheng nao   lan   e     ying  jue   ji    zun   jiao  bo    hui   zhuan mo    zen   zha   shi   qiao  tan   zen   pu    sheng xuan  zao   tan   dang  sui   xian  ji    jiao  jing  lian  nou   yi    ai    zhan  pi    hui   hui   yi    yi    shan  rang  nou   qian  dui   ta    hu    zhou  hao   ai    ying  jian  yu    jian  hui   du    zhe   xuan  zan   lei   shen  wei   chan  li    yi    bian  zhe   yan   e     chou  wei   chou  yao   chan  rang  yin   lan   chen  xie   nie   huan  zan   yi    dang  zhan  yan   du    yan   ji    ding  fu    ren   ji    jie   hong  tao   rang  shan  qi    tuo   xun   yi    xun   ji    ren   jiang hui   ou    ju    ya    ne    xu    e     lun   xiong song  feng  she   fang  jue   zheng gu    he    ping  zu    shi   xiong zha   su    zhen  di    zhou  ci    qu    zhao  bi    yi    yi    kuang lei   shi   gua   shi   jie   hui   cheng zhu   shen  hua   dan   gou   quan  gui   xun   yi    zheng gai   xiang cha   hun   xu    zhou  jie   wu    yu    qiao  wu    gao   you   hui   kuang shui  song  xi    qing  zhu   zou   nuo   du    zhuo  fei   ke    wei   yu    shui  shen  diao  chan  liang zhun  sui   tan   shen  yi    mou   chen  die   huang jian  xie   xue   ye    wei   e     yu    xuan  chan  zi    an    yan   di    mi    pian  xu    mo    dang  su    xie   yao   bang  shi   qian  mi    jin   man   zhe   jian  miu   tan   zen   qiao  lan   pu    jue   yan   qian  zhan  chen  gu    qian  hong  xia   ji    hong  han   hong  xi    xi    huo   liao  han   du    long  dou   jiang qi    chi   li    deng  wan   bi    shu   xian  feng  zhi   zhi   yan   yan   shi   chu   hui   tun   yi    tun   yi    jian  ba    hou   e     chu   xiang huan  jian  ken   gai   ju    fu    xi    bin   hao   yu    zhu   jia   fen   xi    bo    wen   huan  bin   di    zong  fen   yi    zhi   bao   chai  an    pi    na    pi    gou   na    you   diao  mo    si    xiu   huan  ken   he    he    mo    an    mao   li    ni    bi    yu    jia   tuan  mao   pi    xi    yi    ju    mo    chu   tan   huan  jue   bei   zhen  yuan  fu    cai   gong  te    yi    hang  wan   pin   huo   fan   tan   guan  ze    zhi   er    zhu   shi   bi    zi    er    gui   pian  bian  mai   dai   sheng kuang fei   tie   yi    chi   mao   he    ben   lu    lin   hui   gai   pian  zi    jia   xu    zei   jiao  gai   zang  jian  ying  xun   zhen  she   bin   bin   qiu   she   chuan zang  zhou  lai   zan   ci    chen  shang tian  pei   geng  xian  mai   jian  sui   fu    tan   cong  cong  zhi   ji    zhang du    jin   min   chun  yun   bao   zai   lai   feng  cang  ji    sheng ai    zhuan fu    gou   sai   ze    liao  yi    bai   chen  wan   zhi   zhui  biao  yun   zeng  dan   zan   yan   pu    shan  wan   ying  jin   gong  xian  zang  bi    du    shu   yan   yan   xuan  long  gan   zang  bei   zhen  fu    yuan  gong  cai   ze    xian  bai   zhang huo   zhi   fan   tan   pin   bian  gou   zhu   guan  er    jian  ben   shi   tie   gui   kuang dai   mao   fei   he    yi    zei   zhi   jia   hui   zi    lin   lu    zang  zi    gai   jin   qiu   zhen  lai   she   fu    du    ji    shu   shang ci    bi    zhou  geng  pei   tan   lai   feng  zhui  fu    zhuan sai   ze    yan   zan   yun   zeng  shan  ying  gan   chi   xi    she   nan   tong  xi    cheng he    cheng zhe   xia   tang  zou   zou   li    jiu   fu    zhao  gan   qi    shan  qiong qin   xian  zi    jue   qin   chi   ci    chen  chen  die   ju    chao  di    xi    zhan  jue   yue   qu    ji    chi   chu   gua   xue   zi    tiao  duo   lie   gan   suo   cu    xi    zhao  su    yin   ju    jian  que   tang  chuo  cui   lu    qu    dang  qiu   zi    ti    qu    chi   huang qiao  qiao  jiao  zao   ti    er    zan   zan   zu    pa    bao   wu    ke    dun   jue   fu    chen  jian  fang  zhi   ta    yue   ba    qi    yue   qiang tuo   tai   yi    jian  ling  mei   ba    die   ku    tuo   jia   ci    pao   qia   zhu   ju    tie   zhi   fu    pan   ju    shan  bo    ni    ju    li    gen   yi    ji    duo   xian  jiao  duo   zhu   quan  kua   zhuai gui   qiong kui   xiang chi   lu    beng  zhi   jia   tiao  cai   jian  da    qiao  bi    xian  duo   ji    ju    ji    shu   tu    chu   jing  nie   xiao  bu    xue   cun   mu    shu   liang yong  jiao  chou  qiao  mi    ta    jian  qi    wo    wei   chuo  jie   ji    nie   ju    nie   lun   lu    leng  huai  ju    chi   wan   quan  ti    bo    zu    qie   qi    cu    zong  cai   zong  peng  zhi   zheng dian  zhi   yu    duo   dun   chun  yong  zhong di    zha   chen  chuai jian  tuo   tang  ju    fu    zu    die   pian  rou   nuo   ti    cha   tui   jian  dao   cuo   qi    ta    qiang zhan  dian  ti    ji    nie   pan   liu   zan   bi    chong lu    liao  cu    tang  dai   su    xi    kui   ji    zhi   qiang zhi   pan   zong  lian  beng  zao   nian  bie   tui   ju    deng  ceng  xian  fan   chu   zhong dun   bo    cu    cu    jue   jue   lin   ta    qiao  qiao  pu    liao  dun   cuan  guan  zao   da    bi    bi    zhu   ju    chu   qiao  dun   chou  ji    wu    yue   nian  lin   lie   zhi   li    zhi   chan  chu   duan  wei   long  lin   xian  wei   zuan  lan   xie   rang  xie   nie   ta    qu    ji    cuan  zuan  xi    kui   jue   lin   shen  gong  dan   fen   qu    ti    duo   duo   gong  lang  ren   luo   ai    ji    ju    tang  kong  kong  yan   mei   kang  qu    lou   lao   duo   zhi   yan   ti    dao   ying  yu    che   zha   gui   jun   wei   yue   xin   dai   xuan  fan   ren   shan  kuang shu   tun   chen  dai   e     na    qi    mao   ruan  kuang qian  zhuan hong  hu    qu    kuang di    ling  dai   ao    zhen  fan   kuang yang  peng  bei   gu    gu    pao   zhu   rong  e     ba    zhou  zhi   yao   ke    yi    qing  shi   ping  er    gong  ju    jiao  guang lu    kai   quan  zhou  zai   zhi   she   liang yu    shao  you   huan  qun   zhe   wan   fu    qing  zhou  ni    ling  zhe   zhan  liang zi    hui   wang  chuo  guo   kan   yi    peng  qian  gun   nian  ping  guan  bei   lun   pai   liang ruan  rou   ji    yang  xian  chuan cou   chun  ge    you   hong  shu   fu    zi    fu    wen   ben   zhan  yu    wen   kan   gu    zhen  xia   yuan  lu    jiao  chao  zhuan wei   hun   xue   zhe   jiao  zhan  bu    lao   fen   fan   lin   ge    se    kan   huan  yi    ji    zhui  er    yu    jian  hong  lei   pei   li    li    lu    lin   che   zha   gui   xuan  dai   ren   zhuan e     lun   ruan  hong  gu    ke    lu    zhou  zhi   yi    hu    zhen  li    yao   qing  shi   zai   zhi   jiao  zhou  quan  lu    jiao  zhe   fu    liang nian  bei   hui   gun   wang  liang chuo  zi    cou   fu    ji    wen   shu   pei   yuan  xia   zhan  lu    zhe   lin   xin   gu    ci    ci    bi    zui   bian  la    la    ci    xue   ban   bian  bian  bian  bian  bian  ban   ci    bian  bian  chen  ru    nong  nong  zhen  chuo  chuo  yi    reng  bian  fan   shi   ru    liao  da    chan  gan   qian  yu    yu    qi    xun   yi    guo   mai   qi    zha   wang  tu    zhun  ying  da    yun   jin   hang  ya    fan   wu    da    e     huan  zhe   zhong jin   yuan  wei   lian  chi   che   ni    tiao  chi   yi    jiong jia   chen  dai   er    di    po    zhu   die   ze    tao   shu   tuo   qu    jing  hui   dong  you   mi    beng  ji    nai   yi    jie   zhui  lie   xun   tui   song  shi   tao   pang  hou   ni    dun   jiong xuan  xun   bu    you   xiao  qiu   tou   zhu   qiu   di    di    tu    jing  ti    dou   yi    zhe   tong  guang wu    shi   cheng su    zao   qun   feng  lian  suo   hui   li    gu    lai   ben   cuo   jue   beng  huan  dai   lu    you   zhou  jin   yu    chuo  kui   wei   ti    yi    da    yuan  luo   bi    nuo   yu    dang  sui   dun   sui   yan   chuan chi   ti    yu    shi   zhen  you   yun   e     bian  guo   e     xia   huang qiu   dao   da    wei   nan   yi    gou   yao   chou  liu   xun   ta    di    chi   yuan  su    ta    qian  ma    yao   guan  zhang ao    shi   ca    chi   su    zao   zhe   dun   di    lou   chi   cuo   lin   zun   rao   qian  xuan  yu    yi    e     liao  ju    shi   bi    yao   mai   xie   sui   huan  zhan  teng  er    miao  bian  bian  la    li    yuan  you   luo   li    yi    ting  deng  qi    yong  shan  han   yu    mang  ru    qiong wan   kuang fu    kang  bin   fang  xing  na    xin   shen  bang  yuan  cun   huo   xie   bang  wu    ju    you   han   tai   qiu   bi    pi    bing  shao  bei   wa    di    zou   ye    lin   kuang gui   zhu   shi   ku    yu    gai   he    xi    zhi   ji    huan  hou   xing  jiao  xi    gui   nuo   lang  jia   kuai  zheng lang  yun   yan   cheng dou   xi    lv    fu    wu    fu    gao   hao   lang  jia   geng  jun   ying  bo    xi    qu    li    yun   bu    xiao  qi    pi    qing  guo   zhou  tan   zou   ping  lai   ni    chen  you   bu    xiang dan   ju    yong  qiao  yi    dou   yan   mei   ruo   bei   e     shu   juan  yu    yun   hou   kui   xiang xiang sou   tang  ming  xi    ru    chu   zi    zou   ye    wu    xiang yun   qiao  yong  bi    mao   chao  fu    liao  yin   zhuan hu    qiao  yan   zhang man   qiao  xu    deng  bi    xun   bi    zeng  wei   zheng mao   shan  lin   po    dan   meng  ye    cao   kuai  feng  meng  zou   kuang lian  zan   chan  you   ji    yan   chan  zan   ling  huan  xi    feng  zan   li    you   ding  qiu   zhuo  pei   zhou  yi    gan   yu    jiu   yan   zui   mao   dan   xu    dou   zhen  fen   yuan  fu    yun   tai   tian  qia   tuo   cu    han   gu    su    po    chou  zai   ming  lao   chuo  chou  you   tong  zhi   xian  jiang cheng yin   tu    jiao  mei   ku    suan  lei   pu    zui   hai   yan   shi   niang wei   lu    lan   yan   tao   pei   zhan  chun  tan   zui   zhui  cu    kun   ti    xian  du    hu    xu    xing  tan   qiu   chun  yun   fa    ke    sou   mi    quan  chou  cuo   yun   yong  ang   zha   hai   tang  jiang piao  chan  yu    li    zao   lao   yi    jiang bu    jiao  xi    tan   po    nong  yi    li    ju    yan   yi    niang ru    xun   chou  yan   ling  mi    mi    niang xin   jiao  shi   mi    yan   bian  cai   shi   you   shi   shi   li    zhong ye    liang li    jin   jin   ga    yi    liao  dao   zhao  ding  po    qiu   ba    fu    zhen  zhi   ba    luan  fu    nai   diao  shan  qiao  kou   chuan zi    fan   yu    wu    han   gang  qi    mang  ri    di    si    xi    yi    cha   shi   tu    xi    nv    qian  qiu   jian  pi    ye    yin   ba    fang  chen  xing  dou   yue   qian  fu    bu    na    xin   e     jue   dun   gou   yin   qian  ban   sa    ren   chao  niu   fen   yun   yi    qin   pi    guo   hong  yin   jun   diao  yi    zhong xi    gai   ri    huo   tai   kang  yuan  lu    n     wen   duo   zi    ni    tu    shi   min   gu    ke    ling  bing  ci    gu    bo    pi    yu    si    zuo   bu    you   dian  jia   zhen  shi   shi   tie   ju    qian  shi   ta    xuan  zhao  bao   he    bi    sheng chu   shi   bo    zhu   chi   za    po    tong  qian  fu    zhai  mao   qian  fu    li    yue   pi    yang  ban   bo    jie   gou   shu   zheng mu    ni    nie   di    jia   mu    tan   shen  yi    si    kuang ka    bei   jian  tong  xing  hong  jiao  chi   er    ge    bing  shi   mou   ha    yin   jun   zhou  chong xiang tong  mo    lei   ji    yu    xu    ren   zun   zhi   qiong shan  chi   xi    xing  quan  pi    tie   zhu   hou   ming  kua   yao   xian  xian  xiu   jun   cha   lao   ji    pi    ru    mi    yi    yin   guang an    diu   you   se    kao   qian  luan  si    n     diao  han   rui   shi   keng  qiu   xiao  zhe   xiu   zang  ti    cuo   gua   hong  yong  dou   lv    mei   lang  wan   xin   yun   bei   wu    su    yu    chan  ting  bo    han   jia   hong  juan  feng  chan  wan   zhi   si    juan  hua   yu    tiao  kuang zhuo  lve   xing  qin   shen  han   lve   ye    chu   zeng  ju    xian  e     mang  pu    li    pan   rui   cheng gao   li    te    bing  zhu   zhen  tu    liu   zui   ju    chang yuan  jian  gang  diao  tao   chang lun   ke    ling  pi    lu    li    qiang pei   juan  min   zui   peng  an    pi    xian  ya    zhui  lei   a     kong  ta    kun   du    wei   chui  zi    zheng ben   nie   zong  chun  tan   ding  qi    qian  zhui  ji    yu    jin   guan  mao   chang tian  xi    lian  tao   gu    cuo   shu   zhen  lu    meng  lu    hua   biao  ga    lai   ken   fang  wu    nai   wan   zan   hu    de    xian  xian  huo   liang fa    men   kai   yang  di    lian  guo   xian  du    tu    wei   wan   fu    rou   ji    e     jun   zhen  ti    zha   hu    yang  duan  xia   yu    keng  sheng huang wei   fu    zhao  cha   qie   shi   hong  kui   nuo   mou   qiao  qiao  hou   tou   zong  huan  ye    min   jian  duan  jian  si    kui   hu    xuan  zhe   jie   zhen  bian  zhong zi    xiu   ye    mei   pai   ai    gai   qian  mei   cha   da    bang  xia   lian  suo   kai   liu   yao   ye    nou   weng  rong  tang  suo   qiang ge    shuo  chui  bo    pan   da    bi    sang  gang  zi    wu    ying  huang tiao  liu   kai   sun   sha   sou   wan   gao   zhen  zhen  lang  yi    yuan  tang  nie   xi    jia   ge    ma    juan  song  zu    suo   suo   feng  wen   na    lu    suo   ou    zu    tuan  xiu   guan  xuan  lian  shou  ao    man   mo    luo   bi    wei   liu   di    san   zong  yi    lu    ao    keng  qiang cui   qi    chang tang  man   yong  chan  feng  jing  biao  shu   lou   xiu   cong  long  zan   jian  cao   li    xia   xi    kang  shuangbeng  zhang qian  cheng lu    hua   ji    pu    hui   qiang po    lin   se    xiu   xian  cheng kui   si    liu   nao   huang pie   sui   fan   qiao  quan  yang  tang  xiang jue   jiao  zun   liao  qie   lao   dui   xin   zan   ji    jian  zhong deng  ya    ying  dui   jue   nou   ti    pu    tie   tie   zhang ding  shan  kai   jian  fei   sui   lu    juan  hui   yu    lian  zhuo  qiao  qian  zhuo  lei   bi    tie   huan  xie   duo   guo   cheng ju    fen   da    bei   yi    ai    zong  xun   diao  zhu   heng  zhui  ji    ni    he    huo   qing  bin   ying  kui   ning  xu    jian  jian  qian  cha   zhi   mie   li    lei   ji    zuan  kuang shang peng  la    du    shuo  chuo  lv    biao  bao   lu    xian  kuan  long  e     lu    xin   jian  lan   bo    jian  yao   chan  xiang jian  xi    guan  cang  nie   lei   cuan  qu    pan   luo   zuan  luan  zao   nie   jue   tang  zhu   lan   jin   ga    yi    zhen  ding  zhao  po    liao  tu    qian  chuan shan  sa    fan   diao  men   nv    yang  cha   xing  gai   bu    tai   ju    dun   chao  zhong na    bei   gang  ban   qian  yue   qin   jun   wu    gou   kang  fang  huo   dou   niu   ba    yu    qian  zheng qian  gu    bo    ke    po    bu    bo    yue   zuan  mu    tan   jia   dian  you   tie   bo    ling  shuo  qian  mao   bao   shi   xuan  ta    bi    ni    pi    duo   xing  kao   lao   er    mang  ya    you   cheng jia   ye    nao   zhi   cheng tong  lv    diao  yin   kai   zha   zhu   xi    ting  diu   xian  hua   quan  sha   ha    tiao  ge    ming  zheng se    jiao  yi    chan  chong tang  an    yin   ru    zhu   lao   pu    yu    lai   te    lian  keng  xiao  suo   li    zeng  chu   guo   gao   e     xiu   cuo   lve   feng  xin   liu   kai   jian  rui   ti    lang  qin   ju    a     qiang zhe   nuo   cuo   mao   ben   qi    de    ke    kun   chang xi    gu    luo   chui  zhui  jin   zhi   xian  juan  huo   pei   tan   ding  jian  ju    meng  zi    qie   ying  kai   qiang si    e     cha   qiao  zhong duan  sou   huang huan  ai    du    mei   lou   zi    fei   mei   mo    zhen  bo    ge    nie   tang  juan  nie   na    liu   gao   bang  yi    jia   bin   rong  biao  tang  man   luo   beng  yong  jing  di    zu    xuan  liu   chan  jue   liao  pu    lu    dui   lan   pu    chuan qiang deng  huo   lei   huan  zhuo  lian  yi    cha   biao  la    chan  xiang chang chang jiu   ao    die   jue   liao  mi    chang men   ma    shuan shan  huo   men   yan   bi    han   bi    shan  kai   kang  beng  hong  run   san   xian  jian  jian  min   xia   shui  dou   zha   nao   zhan  peng  xia   ling  bian  bi    run   he    guan  ge    ge    fa    chu   hong  gui   min   se    kun   lang  lv    ting  sha   ju    yue   yue   chan  qu    lin   chang sha   kun   yan   wen   yan   e     hun   yu    wen   hong  bao   hong  qu    yao   wen   ban   an    wei   yin   kuo   que   lan   du    quan  peng  tian  nie   ta    kai   he    que   chuangguan  dou   qi    kui   tang  guan  piao  kan   xi    hui   chan  pi    dang  huan  ta    wen   wen   men   shuan shan  yan   han   bi    wen   chen  run   wei   xian  hong  jian  min   kang  men   zha   nao   gui   wen   ta    min   lv    kai   fa    ge    he    kun   jiu   yue   lang  du    yu    yan   chang xi    wen   hun   yan   e     chan  lan   qu    hui   kuo   que   he    tian  ta    que   kan   huan  fu    fu    le    dui   xin   qian  wu    yi    zhi   yin   yang  dou   e     sheng ban   pei   gang  yun   ruan  zhi   pi    jing  fang  yang  yin   zhen  jie   cheng e     qu    di    zu    zuo   dian  ling  a     tuo   tuo   bei   bing  fu    ji    lu    long  chen  xing  duo   lou   mo    jiang shu   duo   xian  er    gui   yu    gai   shan  jun   qiao  xing  chun  fu    bi    xia   shan  sheng zhi   pu    dou   yuan  zhen  chu   xian  dao   nie   yun   xian  pei   pei   zou   yi    dui   lun   yin   ju    chui  chen  pi    ling  tao   xian  lu    sheng xian  yin   zhu   yang  reng  xia   chong yan   yin   yu    di    yu    long  wei   wei   nie   dui   sui   an    huang jie   sui   yin   gai   yan   hui   ge    yun   wu    wei   ai    xi    tang  ji    zhang dao   ao    xi    yin   sa    rao   lin   tui   deng  pi    sui   sui   yu    xian  fen   ni    er    ji    dao   xi    yin   zhi   hui   long  xi    li    li    li    zhui  he    zhi   sun   juan  nan   yi    que   yan   qin   qian  xiong ya    ji    gu    huan  zhi   gou   juan  ci    yong  ju    chu   hu    za    luo   yu    chou  diao  sui   han   huo   shuangguan  chu   za    yong  ji    xi    chou  liu   li    nan   xue   za    ji    ji    yu    yu    xue   na    fou   se    mu    wen   fen   pang  yun   li    chi   yang  ling  lei   an    bao   meng  dian  dang  hu    wu    diao  xu    ji    mu    chen  xiao  zha   ting  zhen  pei   mei   ling  qi    zhou  huo   sha   fei   hong  zhan  yin   ni    zhu   tun   lin   ling  dong  ying  wu    ling  shuangling  xia   hong  yin   mai   mai   yun   liu   meng  bin   wu    wei   kuo   yin   xi    yi    ai    dan   teng  xian  yu    lou   long  dai   ji    pang  yang  ba    pi    wei   wei   xi    ji    mai   meng  meng  lei   li    huo   ai    fei   dai   long  ling  ai    feng  li    bao   he    he    he    bing  qing  qing  jing  tian  zhen  jing  cheng qing  jing  jing  dian  jing  tian  fei   fei   kao   mi    mian  mian  bao   ye    tian  hui   ye    ge    ding  cha   jian  ren   di    du    wu    ren   qin   jin   xue   niu   ba    yin   sa    na    mo    zu    da    ban   yi    yao   tao   bai   jie   hong  pao   yang  bing  yin   ge    tao   ji    xie   an    an    hen   gong  qia   da    qiao  ting  man   ying  sui   tiao  qiao  xuan  kong  beng  ta    zhang bi    kuo   ju    la    xie   rou   bang  eng   qiu   qiu   he    qiao  mu    ju    jian  bian  di    jian  ou    tao   gou   ta    bei   xie   pan   ge    bi    kuo   tang  lou   gui   qiao  xue   ji    jian  jiang chan  da    hu    xian  qian  du    wa    jian  lan   wei   ren   fu    mei   quan  ge    wei   qiao  han   chang kuo   rou   yun   she   wei   ge    bai   tao   gou   yun   gao   bi    wei   hui   du    wa    du    wei   ren   fu    han   wei   yun   tao   jiu   jiu   xian  xie   xian  ji    yin   za    yun   shao  le    peng  huang ying  yun   peng  an    yin   xiang hu    ye    ding  qing  kui   xiang shui  han   xu    yi    xu    gu    song  kui   qi    hang  yu    wan   ban   dun   di    dan   pan   po    ling  che   jing  lei   he    qiao  e     e     wei   jie   kuo   shen  yi    yi    ke    dui   bian  ping  lei   tiao  jia   tou   hui   kui   jia   luo   ting  cheng ying  yun   hu    han   jing  tui   tui   pin   lai   tui   zi    zi    chui  ding  lai   tan   han   qian  ke    cui   jiong qin   yi    sai   ti    e     e     yan   wen   kan   yong  zhuan yan   xian  xin   yi    yuan  sang  dian  dian  jiang kui   lei   lao   piao  wai   man   cu    yao   hao   qiao  gu    xun   yan   hui   chan  ru    meng  bin   xian  pin   lu    lin   nie   quan  ye    ding  qing  han   xiang shui  xu    xu    wan   gu    dun   qi    ban   song  hang  yu    lu    ling  po    jing  jie   jia   ting  he    ying  jiong ke    yi    pin   pou   tui   han   ying  ying  ke    ti    yong  e     zhuan yan   e     nie   man   dian  sang  hao   lei   chan  ru    pin   quan  feng  diu   gua   fu    xia   zhan  biao  sa    ba    tai   lie   gua   xuan  shao  ju    biao  si    wei   yang  yao   sou   kai   sao   fan   liu   xi    liu   piao  piao  liu   biao  biao  biao  liao  biao  se    feng  xiu   feng  yang  zhan  biao  sa    ju    si    sou   yao   liu   piao  biao  biao  fei   fan   fei   fei   shi   shi   can   ji    ding  si    tuo   zhan  sun   xiang tun   ren   yu    juan  chi   yin   fan   fan   sun   yin   zhu   yi    zuo   bi    jie   tao   bao   ci    tie   si    bao   shi   duo   hai   ren   tian  jiao  jia   bing  yao   tong  ci    xiang yang  juan  er    yan   le    xi    can   bo    nei   e     bu    jun   dou   su    yu    xi    yao   hun   guo   shi   jian  zhui  bing  xian  bu    ye    dan   fei   zhang wei   guan  e     nuan  yun   hu    huang tie   hui   jian  hou   ai    tang  fen   wei   gu    cha   song  tang  bo    gao   xi    kui   liu   sou   tao   ye    wen   mo    tang  man   bi    yu    xiu   jin   san   kui   zhuan shan  chi   dan   yi    ji    rao   cheng yong  tao   wei   xiang zhan  fen   hai   meng  yan   mo    chan  xiang luo   zan   nang  shi   ding  ji    tuo   tang  tun   xi    ren   yu    chi   fan   yin   jian  shi   bao   si    duo   yi    er    rao   xiang he    le    jiao  xi    bing  bo    dou   e     yu    nei   jun   guo   hun   xian  guan  cha   kui   gu    sou   chan  ye    mo    bo    liu   xiu   jin   man   san   zhuan nang  shou  kui   guo   xiang fen   bo    ni    bi    bo    tu    han   fei   jian  an    ai    fu    xian  yun   xin   fen   pin   xin   ma    yu    feng  han   di    tuo   tuo   chi   xun   zhu   zhi   pei   xin   ri    sa    yun   wen   zhi   dan   lv    you   bo    bao   jue   tuo   yi    qu    pu    qu    jiong po    zhao  yuan  peng  zhou  ju    zhu   nu    ju    pi    zang  jia   ling  zhen  tai   fu    yang  shi   bi    tuo   tuo   si    liu   ma    pian  tao   zhi   rong  teng  dong  xun   quan  shen  jiong er    hai   bo    zhu   yin   luo   zhou  dan   hai   liu   ju    song  qin   mang  lang  han   tu    xuan  tui   jun   e     cheng xing  si    lu    zhui  zhou  she   pian  kun   tao   lai   zong  ke    qi    qi    yan   fei   sao   yan   ge    yao   wu    pian  cong  pian  qian  fei   huang qian  huo   yu    ti    quan  xia   zong  kui   rou   si    gua   tuo   gui   sou   qian  cheng zhi   liu   peng  teng  xi    cao   du    yan   yuan  zou   sao   shan  qi    zhi   shuanglu    xi    luo   zhang mo    ao    can   biao  cong  qu    bi    zhi   yu    xu    hua   bo    su    xiao  lin   zhan  dun   liu   tuo   ceng  dian  jiao  tie   yan   luo   zhan  jing  yi    ye    tuo   pin   zhou  yan   long  lv    teng  xiang ji    shuangju    xi    huan  li    biao  ma    yu    tuo   xun   chi   qu    ri    bo    lv    zang  shi   si    fu    ju    zou   zhu   tuo   nu    jia   yi    tai   xiao  ma    yin   jiao  hua   luo   hai   pian  biao  li    cheng yan   xing  qin   jun   qi    qi    ke    zhui  zong  su    can   pian  zhi   kui   sao   wu    ao    liu   qian  shan  biao  luo   cong  zhan  zhou  ji    shuangxiang gu    wei   wei   wei   yu    gan   yi    ang   tou   jie   bao   bei   ci    ti    di    ku    hai   qiao  hou   kua   ge    tui   geng  pian  bi    ke    qia   yu    sui   lou   bo    xiao  pang  bo    cuo   kuan  bin   mo    liao  lou   xiao  du    zang  sui   ti    bin   kuan  lu    gao   gao   qiao  kao   qiao  lao   sao   biao  kun   kun   di    fang  xiu   ran   mao   dan   kun   bin   fa    tiao  pi    zi    fa    ran   ti    bao   bi    mao   fu    er    rong  qu    gong  xiu   kuo   ji    peng  zhua  shao  suo   ti    li    bin   zong  ti    peng  song  zheng quan  zong  shui  jian  duo   hu    la    jiu   qi    lian  zhen  bin   peng  ma    san   man   man   se    xu    lie   qian  qian  nang  huan  kuo   ning  bin   lie   rang  dou   dou   nao   hong  xi    dou   han   dou   dou   jiu   chang yu    yu    ge    yan   fu    xin   gui   zong  liu   gui   shang yu    gui   mei   qi    qi    ga    kui   hun   ba    po    mei   xu    yan   xiao  liang yu    tui   qi    wang  liang wei   gan   chi   piao  bi    mo    qi    xu    chou  yan   zhan  yu    dao   ren   jie   ba    hong  tuo   di    ji    yu    e     qie   sha   hang  tun   mo    jie   shen  ban   yuan  pi    lu    wen   hu    lu    za    fang  fen   na    you   pian  mo    he    xia   qu    han   pi    ling  tuo   ba    qiu   ping  fu    bi    ji    wei   ju    diao  bo    you   gun   pi    nian  xing  tai   bao   fu    zha   ju    gu    shi   dong  dai   ta    jie   shu   hou   xiang er    an    wei   zhao  zhu   yin   lie   luo   tong  yi    yi    bing  wei   jiao  ku    gui   xian  ge    hui   lao   fu    kao   xiu   duo   jun   ti    mian  shao  zha   suo   qin   yu    nei   zhe   gun   geng  su    wu    qiu   shan  pu    huan  tiao  li    sha   sha   kao   meng  cheng li    zou   xi    yong  shen  zi    qi    qing  xiang nei   chun  ji    diao  qie   gu    zhou  dong  lai   fei   ni    yi    kun   lu    jiu   chang jing  lun   ling  zou   li    meng  zong  zhi   nian  hu    yu    di    shi   shen  huan  ti    hou   xing  zhu   la    zong  ji    bian  bian  huan  quan  zei   wei   wei   yu    chun  rou   die   huang lian  yan   qiu   qiu   jian  bi    e     yang  fu    sai   jian  xia   tuo   hu    shi   ruo   xuan  wen   jian  hao   wu    pang  sao   liu   ma    shi   shi   guan  zi    teng  ta    yao   ge    yong  qian  qi    wen   ruo   shen  lian  ao    le    hui   min   ji    tiao  qu    jian  shen  man   xi    qiu   biao  ji    ji    zhu   jiang qiu   zhuan yong  zhang kang  xue   bie   yu    qu    xiang bo    jiao  xun   su    huang zun   shan  shan  fan   gui   lin   xun   miao  xi    zeng  xiang fen   guan  hou   kuai  zei   sao   zhan  gan   gui   sheng li    chang lei   shu   ai    ru    ji    xu    hu    shu   li    lie   luo   mie   zhen  xiang e     lu    guan  li    xian  yu    dao   ji    you   tun   lu    fang  ba    he    ba    ping  nian  lu    you   zha   fu    bo    bao   hou   pi    tai   gui   jie   kao   wei   er    tong  zei   hou   kuai  ji    jiao  xian  zha   xiang xun   geng  li    lian  jian  li    shi   tiao  gun   sha   huan  jun   ji    yong  qing  ling  qi    zou   fei   kun   chang gu    ni    nian  diao  jing  shen  shi   zi    fen   die   bi    chang ti    wen   wei   sai   e     qiu   fu    huang quan  jiang bian  sao   ao    qi    ta    guan  yao   pang  jian  le    biao  xue   bie   man   min   yong  wei   xi    gui   shan  lin   zun   hu    gan   li    zhan  guan  niao  yi    fu    li    jiu   bu    yan   fu    diao  ji    feng  ru    gan   shi   feng  ming  bao   yuan  zhi   hu    qin   fu    fen   wen   jian  shi   yu    fou   yao   jue   jue   pi    huan  zhen  bao   yan   ya    zheng fang  feng  wen   ou    dai   ge    ru    ling  mie   fu    tuo   min   li    bian  zhi   ge    yuan  ci    qu    xiao  chi   dan   ju    yao   gu    zhong yu    yang  yu    ya    tie   yu    tian  ying  dui   wu    er    gua   ai    zhi   yan   heng  xiao  jia   lie   zhu   yang  ti    hong  lu    ru    mou   ge    ren   jiao  xiu   zhou  chi   luo   heng  nian  e     luan  jia   ji    tu    huan  tuo   bu    wu    juan  yu    bo    jun   jun   bi    xi    jun   ju    tu    jing  ti    e     e     kuang gu    wu    shen  lai   jiao  pan   lu    pi    shu   fu    an    zhuo  peng  qiu   qian  bei   diao  lu    que   jian  ju    tu    ya    yuan  qi    li    ye    zhui  kong  duo   kun   sheng qi    jing  yi    yi    jing  zi    lai   dong  qi    chun  geng  ju    jue   yi    zun   ji    shu   shu   chi   miao  rou   an    qiu   ti    hu    ti    e     jie   mao   fu    chun  tu    yan   he    yuan  pian  kun   mei   hu    ying  chuan wu    ju    dong  cang  fang  hu    ying  yuan  xian  weng  shi   he    chu   tang  xia   ruo   liu   ji    gu    jian  sun   han   ci    ci    yi    yao   yan   ji    li    tian  kou   ti    ti    yi    tu    ma    xiao  gao   tian  chen  ji    tuan  zhe   ao    yao   yi    ou    chi   zhi   liu   yong  lv    bi    shuangzhuo  yu    wu    jue   yin   tan   si    jiao  yi    hua   bi    ying  su    huang fan   jiao  liao  yan   gao   jiu   xian  xian  tu    mai   zun   yu    ying  lu    tuan  xian  xue   yi    pi    shu   luo   xi    yi    ji    ze    yu    zhan  ye    yang  pi    ning  hu    mi    ying  meng  di    yue   yu    lei   bu    lu    he    long  shuangyue   ying  guan  qu    li    luan  niao  jiu   ji    yuan  ming  shi   ou    ya    cang  bao   zhen  gu    dong  lu    ya    xiao  yang  ling  chi   qu    yuan  xue   tuo   si    zhi   er    gua   xiu   heng  zhou  ge    luan  hong  wu    bo    li    juan  gu    e     yu    xian  ti    wu    que   miao  an    kun   bei   peng  qian  chun  geng  yuan  su    hu    he    e     gu    qiu   ci    mei   wu    yi    yao   weng  liu   ji    yi    jian  he    yi    ying  zhe   liu   liao  jiao  jiu   yu    lu    huan  zhan  ying  hu    meng  guan  shuanglu    jin   ling  jian  xian  cuo   jian  jian  yan   cuo   lu    you   cu    ji    biao  cu    pao   zhu   jun   zhu   jian  mi    mi    yu    liu   chen  jun   lin   ni    qi    lu    jiu   jun   jing  li    xiang yan   jia   mi    li    she   zhang lin   jing  qi    ling  yan   cu    mai   mai   he    chao  fu    mian  mian  fu    pao   qu    qu    mou   fu    xian  lai   qu    mian  chi   feng  fu    qu    mian  ma    mo    mo    hui   mo    zou   nuo   fen   huang huang jin   guang tian  tou   hong  hua   kuang hong  shu   li    nian  chi   hei   hei   yi    qian  dan   xi    tun   mo    mo    qian  dai   chu   you   dian  yi    xia   yan   qu    mei   yan   qing  yue   li    dang  du    can   yan   yan   yan   zhen  an    zhen  dai   can   yi    mei   zhan  yan   du    lu    zhi   fen   fu    fu    min   mian  yuan  cu    qu    chao  wa    zhu   zhi   meng  ao    bie   tuo   bi    yuan  chao  tuo   ding  mi    nai   ding  zi    gu    gu    dong  fen   tao   yuan  pi    chang gao   cao   yuan  tang  teng  shu   shu   fen   fei   wen   ba    diao  tuo   zhong qu    sheng shi   you   shi   ting  wu    ju    jing  hun   ju    yan   tu    si    xi    xian  yan   lei   bi    yao   qiu   han   wu    wu    hou   xie   he    zha   xiu   weng  zha   nong  nang  qi    zhai  ji    zi    ji    ji    qi    ji    chi   chen  chen  he    ya    yin   xie   bao   ze    shi   zi    chi   yan   ju    tiao  ling  ling  chu   quan  xie   yin   nie   jiu   yao   chuo  yun   yu    chu   yi    ni    ze    chuo  qu    yun   yan   ou    e     wo    yi    cuo   zou   dian  chu   jin   ya    chi   chen  he    yin   ju    ling  bao   tiao  zi    yin   yu    chuo  qu    wo    long  pang  gong  pang  yan   long  long  gong  kan   da    ling  da    long  gong  kan   gui   qiu   bie   gui   yue   chui  he    jue   xie   yue   ";

// delete the back whitespace
char *right_trim(char *str)
{
    char *endp;
    size_t len = strlen(str);

    if (len == 0) return str;

    endp = str + strlen(str) - 1;
    while (*endp == ' ')
        endp--;
    *(endp + 1) = '\0';

    return str;
}

void utf8_to_pinyin(const char *in, char *out)
{
    int start = PINYIN_UNICODE_START;
    const char *words = in;
    char buf[MAX_PINYIN_LEN + 1];
    while (*words != '\0') {
        memset(buf, 0, MAX_PINYIN_LEN + 1);
        if ((*words >> 7) == 0) {
            strncat(out, words, 1);
            words++;
        } else if ((*words & 0xE0) == 0xC0) {
            strncat(out, words, 2);
            words += 2;
        } else if ((*words & 0xF0) == 0xE0) {
            if (*(words + 1) != '\0' && *(words + 2) != '\0') {
                int tmp = (((int)(*words & 0x0F)) << 12) | (((int)(*(words + 1) & 0x3F)) << 6) | (*(words + 2) & 0x3F);
                if (tmp >= start && tmp <= PINYIN_UNICODE_END) {
                    int offset = (tmp - start) * MAX_PINYIN_LEN;
                    strncpy(buf, basic_dict + offset, MAX_PINYIN_LEN);
                    right_trim(buf);   //remove white spaces at the end
                    strcat(out, buf);
                    words += 3;
                } else {
                    strncat(out, words, 3);
                    words += 3;
                }
            } else {
                strncat(out, words, 3);
                words += 3;
            }
        } else if ((*words & 0xF8) == 0xF0) {
            strncat(out, words, 4);
            words += 4;
        } else if ((*words & 0xFC) == 0xF8) {
            strncat(out, words, 5);
            words += 5;
        } else if ((*words & 0xFE) == 0xFC) {
            strncat(out, words, 6);
            words += 6;
        } else {
            strncat(out, words, 1);
            words++;
            break;
        }
    }
}

void convert_all_pinyin(const char *in, char *first, char *full)
{
    int start = PINYIN_UNICODE_START;
    const char *words = in;
    char buf[MAX_PINYIN_LEN + 1];
    while (*words != '\0') {
        memset(buf, 0, MAX_PINYIN_LEN + 1);
        if ((*words >> 7) == 0) {
            strncat(first, words, 1);
            strncat(full, words, 1);
            words++;
        } else if ((*words & 0xE0) == 0xC0) {
            strncat(first, words, 2);
            strncat(full, words, 2);
            words += 2;
        } else if ((*words & 0xF0) == 0xE0) {
            if (*(words + 1) != '\0' && *(words + 2) != '\0') {
                int tmp = (((int)(*words & 0x0F)) << 12) | (((int)(*(words + 1) & 0x3F)) << 6) | (*(words + 2) & 0x3F);
                if (tmp >= start && tmp <= PINYIN_UNICODE_END) {
                    int offset = (tmp - start) * MAX_PINYIN_LEN;
                    strncpy(buf, basic_dict + offset, MAX_PINYIN_LEN);
                    right_trim(buf);   //remove white spaces at the end
                    strncat(first, buf, 1);   // append the first char of word
                    strcat(full, buf);   // append the full word
                    words += 3;
                } else {
                    strncat(first, words, 3);
                    strncat(full, words, 3);
                    words += 3;
                }
            } else {
                strncat(first, words, 3);
                strncat(full, words, 3);
                words += 3;
            }
        } else if ((*words & 0xF8) == 0xF0) {
            strncat(first, words, 4);
            strncat(full, words, 4);
            words += 4;
        } else if ((*words & 0xFC) == 0xF8) {
            strncat(first, words, 5);
            strncat(full, words, 5);
            words += 5;
        } else if ((*words & 0xFE) == 0xFC) {
            strncat(first, words, 6);
            strncat(full, words, 6);
            words += 6;
        } else {
            strncat(first, words, 1);
            strncat(full, words, 1);
            words++;
            break;
        }
    }
}

char *cat_pinyin(const char *in)
{
    if (in == NULL || !is_text_utf8(in, strlen(in)))
        return NULL;

    const int first_len = 255;   //NAME_MAX;
    char pinyin_first[first_len];
    memset(pinyin_first, 0, first_len);
    const int max_len = 1530;   //NAME_MAX * MAX_PINYIN_LEN;
    char pinyin_full[max_len];
    memset(pinyin_full, 0, max_len);

    char *cat_chars = calloc(first_len + max_len + 1, sizeof(char));
    if (cat_chars == NULL)
        return NULL;

    convert_all_pinyin(in, pinyin_first, pinyin_full);
    strcpy(cat_chars, pinyin_first);
    *(cat_chars + strlen(pinyin_first)) = '|';
    strcpy(cat_chars + strlen(pinyin_first) + 1, pinyin_full);

    return cat_chars;
}

int is_text_utf8(const char *str, long length)
{
    int i;
    int nBytes = 0;   // UFT8可用1-6个字节编码,ASCII用一个字节
    unsigned char chr;
    bool bAllAscii = true;   // 如果全部都是ASCII, 说明不是UTF-8
    for (i = 0; i < length; i++) {
        chr = *(str + i);
        if ((chr & 0x80) != 0)   // 判断是否ASCII编码,如果不是,说明有可能是UTF-8,ASCII用7位编码,但用一个字节存,最高位标记为0,o0xxxxxxx
            bAllAscii = false;
        if (nBytes == 0)   // 如果不是ASCII码,应该是多字节符,计算字节数
        {
            if (chr >= 0x80) {
                if (chr >= 0xFC && chr <= 0xFD)
                    nBytes = 6;
                else if (chr >= 0xF8)
                    nBytes = 5;
                else if (chr >= 0xF0)
                    nBytes = 4;
                else if (chr >= 0xE0)
                    nBytes = 3;
                else if (chr >= 0xC0)
                    nBytes = 2;
                else {
                    return false;
                }
                nBytes--;
            }
        } else   // 多字节符的非首字节,应为 10xxxxxx
        {
            if ((chr & 0xC0) != 0x80) {
                return false;
            }
            nBytes--;
        }
    }
    if (nBytes > 0)   // 违反规则
    {
        return false;
    }

    if (bAllAscii)   // 如果全部都是ASCII, 说明不是UTF-8
    {
        return false;
    }
    return true;
}
