/* Generated by wayland-scanner 1.24.0 */

#ifndef TREELAND_PERSONALIZATION_MANAGER_V1_CLIENT_PROTOCOL_H
#define TREELAND_PERSONALIZATION_MANAGER_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client-core.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_treeland_personalization_manager_v1 The treeland_personalization_manager_v1 protocol
 * @section page_ifaces_treeland_personalization_manager_v1 Interfaces
 * - @subpage page_iface_treeland_personalization_manager_v1 - personalization manager
 * - @subpage page_iface_treeland_personalization_wallpaper_context_v1 - client custom wallpaper context
 * - @subpage page_iface_treeland_personalization_cursor_context_v1 - client custom cursor context
 * - @subpage page_iface_treeland_personalization_window_context_v1 - client custom window context
 * - @subpage page_iface_treeland_personalization_font_context_v1 - treeland window global font settings
 * - @subpage page_iface_treeland_personalization_appearance_context_v1 - treeland window global appearance settings
 * @section page_copyright_treeland_personalization_manager_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
 * SPDX-License-Identifier: MIT
 * </pre>
 */
struct treeland_personalization_appearance_context_v1;
struct treeland_personalization_cursor_context_v1;
struct treeland_personalization_font_context_v1;
struct treeland_personalization_manager_v1;
struct treeland_personalization_wallpaper_context_v1;
struct treeland_personalization_window_context_v1;
struct wl_surface;

#ifndef TREELAND_PERSONALIZATION_MANAGER_V1_INTERFACE
#define TREELAND_PERSONALIZATION_MANAGER_V1_INTERFACE
/**
 * @page page_iface_treeland_personalization_manager_v1 treeland_personalization_manager_v1
 * @section page_iface_treeland_personalization_manager_v1_desc Description
 *
 * This interface allows a client to customized display effects.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_treeland_personalization_manager_v1_api API
 * See @ref iface_treeland_personalization_manager_v1.
 */
/**
 * @defgroup iface_treeland_personalization_manager_v1 The treeland_personalization_manager_v1 interface
 *
 * This interface allows a client to customized display effects.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface treeland_personalization_manager_v1_interface;
#endif
#ifndef TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_INTERFACE
#define TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_INTERFACE
/**
 * @page page_iface_treeland_personalization_wallpaper_context_v1 treeland_personalization_wallpaper_context_v1
 * @section page_iface_treeland_personalization_wallpaper_context_v1_desc Description
 *
 * This interface allows a client personalization wallpaper.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_treeland_personalization_wallpaper_context_v1_api API
 * See @ref iface_treeland_personalization_wallpaper_context_v1.
 */
/**
 * @defgroup iface_treeland_personalization_wallpaper_context_v1 The treeland_personalization_wallpaper_context_v1 interface
 *
 * This interface allows a client personalization wallpaper.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface treeland_personalization_wallpaper_context_v1_interface;
#endif
#ifndef TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_INTERFACE
#define TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_INTERFACE
/**
 * @page page_iface_treeland_personalization_cursor_context_v1 treeland_personalization_cursor_context_v1
 * @section page_iface_treeland_personalization_cursor_context_v1_desc Description
 *
 * This interface allows a client personalization cursor.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_treeland_personalization_cursor_context_v1_api API
 * See @ref iface_treeland_personalization_cursor_context_v1.
 */
/**
 * @defgroup iface_treeland_personalization_cursor_context_v1 The treeland_personalization_cursor_context_v1 interface
 *
 * This interface allows a client personalization cursor.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface treeland_personalization_cursor_context_v1_interface;
#endif
#ifndef TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_INTERFACE
#define TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_INTERFACE
/**
 * @page page_iface_treeland_personalization_window_context_v1 treeland_personalization_window_context_v1
 * @section page_iface_treeland_personalization_window_context_v1_desc Description
 *
 * This interface allows a client personalization window.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_treeland_personalization_window_context_v1_api API
 * See @ref iface_treeland_personalization_window_context_v1.
 */
/**
 * @defgroup iface_treeland_personalization_window_context_v1 The treeland_personalization_window_context_v1 interface
 *
 * This interface allows a client personalization window.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface treeland_personalization_window_context_v1_interface;
#endif
#ifndef TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_INTERFACE
#define TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_INTERFACE
/**
 * @page page_iface_treeland_personalization_font_context_v1 treeland_personalization_font_context_v1
 * @section page_iface_treeland_personalization_font_context_v1_desc Description
 *
 * This interface allows set treeland window global font settings.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_treeland_personalization_font_context_v1_api API
 * See @ref iface_treeland_personalization_font_context_v1.
 */
/**
 * @defgroup iface_treeland_personalization_font_context_v1 The treeland_personalization_font_context_v1 interface
 *
 * This interface allows set treeland window global font settings.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface treeland_personalization_font_context_v1_interface;
#endif
#ifndef TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_INTERFACE
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_INTERFACE
/**
 * @page page_iface_treeland_personalization_appearance_context_v1 treeland_personalization_appearance_context_v1
 * @section page_iface_treeland_personalization_appearance_context_v1_desc Description
 *
 * This interface allows set treeland window global appearance settings.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_treeland_personalization_appearance_context_v1_api API
 * See @ref iface_treeland_personalization_appearance_context_v1.
 */
/**
 * @defgroup iface_treeland_personalization_appearance_context_v1 The treeland_personalization_appearance_context_v1 interface
 *
 * This interface allows set treeland window global appearance settings.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface treeland_personalization_appearance_context_v1_interface;
#endif

#define TREELAND_PERSONALIZATION_MANAGER_V1_GET_WINDOW_CONTEXT 0
#define TREELAND_PERSONALIZATION_MANAGER_V1_GET_WALLPAPER_CONTEXT 1
#define TREELAND_PERSONALIZATION_MANAGER_V1_GET_CURSOR_CONTEXT 2
#define TREELAND_PERSONALIZATION_MANAGER_V1_GET_FONT_CONTEXT 3
#define TREELAND_PERSONALIZATION_MANAGER_V1_GET_APPEARANCE_CONTEXT 4


/**
 * @ingroup iface_treeland_personalization_manager_v1
 */
#define TREELAND_PERSONALIZATION_MANAGER_V1_GET_WINDOW_CONTEXT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_manager_v1
 */
#define TREELAND_PERSONALIZATION_MANAGER_V1_GET_WALLPAPER_CONTEXT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_manager_v1
 */
#define TREELAND_PERSONALIZATION_MANAGER_V1_GET_CURSOR_CONTEXT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_manager_v1
 */
#define TREELAND_PERSONALIZATION_MANAGER_V1_GET_FONT_CONTEXT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_manager_v1
 */
#define TREELAND_PERSONALIZATION_MANAGER_V1_GET_APPEARANCE_CONTEXT_SINCE_VERSION 1

/** @ingroup iface_treeland_personalization_manager_v1 */
static inline void
treeland_personalization_manager_v1_set_user_data(struct treeland_personalization_manager_v1 *treeland_personalization_manager_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) treeland_personalization_manager_v1, user_data);
}

/** @ingroup iface_treeland_personalization_manager_v1 */
static inline void *
treeland_personalization_manager_v1_get_user_data(struct treeland_personalization_manager_v1 *treeland_personalization_manager_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) treeland_personalization_manager_v1);
}

static inline uint32_t
treeland_personalization_manager_v1_get_version(struct treeland_personalization_manager_v1 *treeland_personalization_manager_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) treeland_personalization_manager_v1);
}

/** @ingroup iface_treeland_personalization_manager_v1 */
static inline void
treeland_personalization_manager_v1_destroy(struct treeland_personalization_manager_v1 *treeland_personalization_manager_v1)
{
	wl_proxy_destroy((struct wl_proxy *) treeland_personalization_manager_v1);
}

/**
 * @ingroup iface_treeland_personalization_manager_v1
 *
 * set window background, shadow based on context
 */
static inline struct treeland_personalization_window_context_v1 *
treeland_personalization_manager_v1_get_window_context(struct treeland_personalization_manager_v1 *treeland_personalization_manager_v1, struct wl_surface *surface)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_manager_v1,
			 TREELAND_PERSONALIZATION_MANAGER_V1_GET_WINDOW_CONTEXT, &treeland_personalization_window_context_v1_interface, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_manager_v1), 0, NULL, surface);

	return (struct treeland_personalization_window_context_v1 *) id;
}

/**
 * @ingroup iface_treeland_personalization_manager_v1
 *
 * custom user wallpaper
 */
static inline struct treeland_personalization_wallpaper_context_v1 *
treeland_personalization_manager_v1_get_wallpaper_context(struct treeland_personalization_manager_v1 *treeland_personalization_manager_v1)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_manager_v1,
			 TREELAND_PERSONALIZATION_MANAGER_V1_GET_WALLPAPER_CONTEXT, &treeland_personalization_wallpaper_context_v1_interface, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_manager_v1), 0, NULL);

	return (struct treeland_personalization_wallpaper_context_v1 *) id;
}

/**
 * @ingroup iface_treeland_personalization_manager_v1
 *
 * custom user cursor
 */
static inline struct treeland_personalization_cursor_context_v1 *
treeland_personalization_manager_v1_get_cursor_context(struct treeland_personalization_manager_v1 *treeland_personalization_manager_v1)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_manager_v1,
			 TREELAND_PERSONALIZATION_MANAGER_V1_GET_CURSOR_CONTEXT, &treeland_personalization_cursor_context_v1_interface, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_manager_v1), 0, NULL);

	return (struct treeland_personalization_cursor_context_v1 *) id;
}

/**
 * @ingroup iface_treeland_personalization_manager_v1
 *
 * custom treeland and window global font context
 */
static inline struct treeland_personalization_font_context_v1 *
treeland_personalization_manager_v1_get_font_context(struct treeland_personalization_manager_v1 *treeland_personalization_manager_v1)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_manager_v1,
			 TREELAND_PERSONALIZATION_MANAGER_V1_GET_FONT_CONTEXT, &treeland_personalization_font_context_v1_interface, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_manager_v1), 0, NULL);

	return (struct treeland_personalization_font_context_v1 *) id;
}

/**
 * @ingroup iface_treeland_personalization_manager_v1
 *
 * custom user treeland window appearance global
 */
static inline struct treeland_personalization_appearance_context_v1 *
treeland_personalization_manager_v1_get_appearance_context(struct treeland_personalization_manager_v1 *treeland_personalization_manager_v1)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_manager_v1,
			 TREELAND_PERSONALIZATION_MANAGER_V1_GET_APPEARANCE_CONTEXT, &treeland_personalization_appearance_context_v1_interface, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_manager_v1), 0, NULL);

	return (struct treeland_personalization_appearance_context_v1 *) id;
}

#ifndef TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_OPTIONS_ENUM
#define TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_OPTIONS_ENUM
/**
 * @ingroup iface_treeland_personalization_wallpaper_context_v1
 * xdg desktop portal supported keys
 */
enum treeland_personalization_wallpaper_context_v1_options {
	/**
	 * whether to show a preview of the picture
	 */
	TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_OPTIONS_PREVIEW = 1,
	/**
	 * configure screen background
	 */
	TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_OPTIONS_BACKGROUND = 2,
	/**
	 * configure screen wallpaper
	 */
	TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_OPTIONS_LOCKSCREEN = 4,
};
#endif /* TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_OPTIONS_ENUM */

/**
 * @ingroup iface_treeland_personalization_wallpaper_context_v1
 * @struct treeland_personalization_wallpaper_context_v1_listener
 */
struct treeland_personalization_wallpaper_context_v1_listener {
	/**
	 * get metadata event
	 *
	 * Send this signal after getting the user's wallpaper.
	 * @param metadata user meta data
	 */
	void (*metadata)(void *data,
			 struct treeland_personalization_wallpaper_context_v1 *treeland_personalization_wallpaper_context_v1,
			 const char *metadata);
};

/**
 * @ingroup iface_treeland_personalization_wallpaper_context_v1
 */
static inline int
treeland_personalization_wallpaper_context_v1_add_listener(struct treeland_personalization_wallpaper_context_v1 *treeland_personalization_wallpaper_context_v1,
							   const struct treeland_personalization_wallpaper_context_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) treeland_personalization_wallpaper_context_v1,
				     (void (**)(void)) listener, data);
}

#define TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_SET_FD 0
#define TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_SET_IDENTIFIER 1
#define TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_SET_OUTPUT 2
#define TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_SET_ON 3
#define TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_SET_ISDARK 4
#define TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_COMMIT 5
#define TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_GET_METADATA 6
#define TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_DESTROY 7

/**
 * @ingroup iface_treeland_personalization_wallpaper_context_v1
 */
#define TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_METADATA_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_personalization_wallpaper_context_v1
 */
#define TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_SET_FD_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_wallpaper_context_v1
 */
#define TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_SET_IDENTIFIER_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_wallpaper_context_v1
 */
#define TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_SET_OUTPUT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_wallpaper_context_v1
 */
#define TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_SET_ON_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_wallpaper_context_v1
 */
#define TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_SET_ISDARK_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_wallpaper_context_v1
 */
#define TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_COMMIT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_wallpaper_context_v1
 */
#define TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_GET_METADATA_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_wallpaper_context_v1
 */
#define TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_treeland_personalization_wallpaper_context_v1 */
static inline void
treeland_personalization_wallpaper_context_v1_set_user_data(struct treeland_personalization_wallpaper_context_v1 *treeland_personalization_wallpaper_context_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) treeland_personalization_wallpaper_context_v1, user_data);
}

/** @ingroup iface_treeland_personalization_wallpaper_context_v1 */
static inline void *
treeland_personalization_wallpaper_context_v1_get_user_data(struct treeland_personalization_wallpaper_context_v1 *treeland_personalization_wallpaper_context_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) treeland_personalization_wallpaper_context_v1);
}

static inline uint32_t
treeland_personalization_wallpaper_context_v1_get_version(struct treeland_personalization_wallpaper_context_v1 *treeland_personalization_wallpaper_context_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) treeland_personalization_wallpaper_context_v1);
}

/**
 * @ingroup iface_treeland_personalization_wallpaper_context_v1
 */
static inline void
treeland_personalization_wallpaper_context_v1_set_fd(struct treeland_personalization_wallpaper_context_v1 *treeland_personalization_wallpaper_context_v1, int32_t fd, const char *metadata)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_wallpaper_context_v1,
			 TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_SET_FD, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_wallpaper_context_v1), 0, fd, metadata);
}

/**
 * @ingroup iface_treeland_personalization_wallpaper_context_v1
 */
static inline void
treeland_personalization_wallpaper_context_v1_set_identifier(struct treeland_personalization_wallpaper_context_v1 *treeland_personalization_wallpaper_context_v1, const char *identifier)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_wallpaper_context_v1,
			 TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_SET_IDENTIFIER, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_wallpaper_context_v1), 0, identifier);
}

/**
 * @ingroup iface_treeland_personalization_wallpaper_context_v1
 */
static inline void
treeland_personalization_wallpaper_context_v1_set_output(struct treeland_personalization_wallpaper_context_v1 *treeland_personalization_wallpaper_context_v1, const char *output)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_wallpaper_context_v1,
			 TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_SET_OUTPUT, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_wallpaper_context_v1), 0, output);
}

/**
 * @ingroup iface_treeland_personalization_wallpaper_context_v1
 */
static inline void
treeland_personalization_wallpaper_context_v1_set_on(struct treeland_personalization_wallpaper_context_v1 *treeland_personalization_wallpaper_context_v1, uint32_t options)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_wallpaper_context_v1,
			 TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_SET_ON, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_wallpaper_context_v1), 0, options);
}

/**
 * @ingroup iface_treeland_personalization_wallpaper_context_v1
 */
static inline void
treeland_personalization_wallpaper_context_v1_set_isdark(struct treeland_personalization_wallpaper_context_v1 *treeland_personalization_wallpaper_context_v1, uint32_t isdark)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_wallpaper_context_v1,
			 TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_SET_ISDARK, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_wallpaper_context_v1), 0, isdark);
}

/**
 * @ingroup iface_treeland_personalization_wallpaper_context_v1
 */
static inline void
treeland_personalization_wallpaper_context_v1_commit(struct treeland_personalization_wallpaper_context_v1 *treeland_personalization_wallpaper_context_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_wallpaper_context_v1,
			 TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_COMMIT, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_wallpaper_context_v1), 0);
}

/**
 * @ingroup iface_treeland_personalization_wallpaper_context_v1
 *
 * get the current user's wallpaper
 */
static inline void
treeland_personalization_wallpaper_context_v1_get_metadata(struct treeland_personalization_wallpaper_context_v1 *treeland_personalization_wallpaper_context_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_wallpaper_context_v1,
			 TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_GET_METADATA, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_wallpaper_context_v1), 0);
}

/**
 * @ingroup iface_treeland_personalization_wallpaper_context_v1
 *
 * Destroy the context object.
 */
static inline void
treeland_personalization_wallpaper_context_v1_destroy(struct treeland_personalization_wallpaper_context_v1 *treeland_personalization_wallpaper_context_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_wallpaper_context_v1,
			 TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_wallpaper_context_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_treeland_personalization_cursor_context_v1
 * @struct treeland_personalization_cursor_context_v1_listener
 */
struct treeland_personalization_cursor_context_v1_listener {
	/**
	 * verfity event
	 *
	 * Send this signal after commit cursor configure.
	 * @param success check whether the configuration is successful
	 */
	void (*verfity)(void *data,
			struct treeland_personalization_cursor_context_v1 *treeland_personalization_cursor_context_v1,
			int32_t success);
	/**
	 * cursor theme changed event
	 *
	 * Send this signal after system cursor theme changed.
	 * @param name cursor theme name
	 */
	void (*theme)(void *data,
		      struct treeland_personalization_cursor_context_v1 *treeland_personalization_cursor_context_v1,
		      const char *name);
	/**
	 * cursor size changed event
	 *
	 * Send this signal after system cursor size changed.
	 * @param size cursor size
	 */
	void (*size)(void *data,
		     struct treeland_personalization_cursor_context_v1 *treeland_personalization_cursor_context_v1,
		     uint32_t size);
};

/**
 * @ingroup iface_treeland_personalization_cursor_context_v1
 */
static inline int
treeland_personalization_cursor_context_v1_add_listener(struct treeland_personalization_cursor_context_v1 *treeland_personalization_cursor_context_v1,
							const struct treeland_personalization_cursor_context_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) treeland_personalization_cursor_context_v1,
				     (void (**)(void)) listener, data);
}

#define TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_SET_THEME 0
#define TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_GET_THEME 1
#define TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_SET_SIZE 2
#define TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_GET_SIZE 3
#define TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_COMMIT 4
#define TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_DESTROY 5

/**
 * @ingroup iface_treeland_personalization_cursor_context_v1
 */
#define TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_VERFITY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_cursor_context_v1
 */
#define TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_THEME_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_cursor_context_v1
 */
#define TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_SIZE_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_personalization_cursor_context_v1
 */
#define TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_SET_THEME_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_cursor_context_v1
 */
#define TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_GET_THEME_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_cursor_context_v1
 */
#define TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_SET_SIZE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_cursor_context_v1
 */
#define TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_GET_SIZE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_cursor_context_v1
 */
#define TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_COMMIT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_cursor_context_v1
 */
#define TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_treeland_personalization_cursor_context_v1 */
static inline void
treeland_personalization_cursor_context_v1_set_user_data(struct treeland_personalization_cursor_context_v1 *treeland_personalization_cursor_context_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) treeland_personalization_cursor_context_v1, user_data);
}

/** @ingroup iface_treeland_personalization_cursor_context_v1 */
static inline void *
treeland_personalization_cursor_context_v1_get_user_data(struct treeland_personalization_cursor_context_v1 *treeland_personalization_cursor_context_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) treeland_personalization_cursor_context_v1);
}

static inline uint32_t
treeland_personalization_cursor_context_v1_get_version(struct treeland_personalization_cursor_context_v1 *treeland_personalization_cursor_context_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) treeland_personalization_cursor_context_v1);
}

/**
 * @ingroup iface_treeland_personalization_cursor_context_v1
 */
static inline void
treeland_personalization_cursor_context_v1_set_theme(struct treeland_personalization_cursor_context_v1 *treeland_personalization_cursor_context_v1, const char *name)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_cursor_context_v1,
			 TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_SET_THEME, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_cursor_context_v1), 0, name);
}

/**
 * @ingroup iface_treeland_personalization_cursor_context_v1
 */
static inline void
treeland_personalization_cursor_context_v1_get_theme(struct treeland_personalization_cursor_context_v1 *treeland_personalization_cursor_context_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_cursor_context_v1,
			 TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_GET_THEME, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_cursor_context_v1), 0);
}

/**
 * @ingroup iface_treeland_personalization_cursor_context_v1
 */
static inline void
treeland_personalization_cursor_context_v1_set_size(struct treeland_personalization_cursor_context_v1 *treeland_personalization_cursor_context_v1, uint32_t size)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_cursor_context_v1,
			 TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_SET_SIZE, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_cursor_context_v1), 0, size);
}

/**
 * @ingroup iface_treeland_personalization_cursor_context_v1
 */
static inline void
treeland_personalization_cursor_context_v1_get_size(struct treeland_personalization_cursor_context_v1 *treeland_personalization_cursor_context_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_cursor_context_v1,
			 TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_GET_SIZE, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_cursor_context_v1), 0);
}

/**
 * @ingroup iface_treeland_personalization_cursor_context_v1
 *
 * if only one commit fails validation, the commit will fail
 */
static inline void
treeland_personalization_cursor_context_v1_commit(struct treeland_personalization_cursor_context_v1 *treeland_personalization_cursor_context_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_cursor_context_v1,
			 TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_COMMIT, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_cursor_context_v1), 0);
}

/**
 * @ingroup iface_treeland_personalization_cursor_context_v1
 *
 * Destroy the context object.
 */
static inline void
treeland_personalization_cursor_context_v1_destroy(struct treeland_personalization_cursor_context_v1 *treeland_personalization_cursor_context_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_cursor_context_v1,
			 TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_cursor_context_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifndef TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_BLEND_MODE_ENUM
#define TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_BLEND_MODE_ENUM
/**
 * @ingroup iface_treeland_personalization_window_context_v1
 * window blend mode
 *
 * Window blend mode defines how compositor composite window's surface over other
 * surfaces.
 */
enum treeland_personalization_window_context_v1_blend_mode {
	/**
	 * Normal blend mode, just composite over background with alpha channel
	 */
	TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_BLEND_MODE_TRANSPARENT = 0,
	/**
	 * Composite window over wallpaper
	 */
	TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_BLEND_MODE_WALLPAPER = 1,
	/**
	 * Blur the content of the window background
	 */
	TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_BLEND_MODE_BLUR = 2,
};
#endif /* TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_BLEND_MODE_ENUM */

#ifndef TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_ENABLE_MODE_ENUM
#define TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_ENABLE_MODE_ENUM
/**
 * @ingroup iface_treeland_personalization_window_context_v1
 * window enable mode
 *
 * Set window enable mode
 */
enum treeland_personalization_window_context_v1_enable_mode {
	/**
	 * force enable titlebar
	 */
	TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_ENABLE_MODE_ENABLE = 0,
	/**
	 * force disable titlebar
	 */
	TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_ENABLE_MODE_DISABLE = 1,
};
#endif /* TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_ENABLE_MODE_ENUM */

#define TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_SET_BLEND_MODE 0
#define TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_SET_ROUND_CORNER_RADIUS 1
#define TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_SET_SHADOW 2
#define TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_SET_BORDER 3
#define TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_SET_TITLEBAR 4
#define TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_DESTROY 5


/**
 * @ingroup iface_treeland_personalization_window_context_v1
 */
#define TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_SET_BLEND_MODE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_window_context_v1
 */
#define TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_SET_ROUND_CORNER_RADIUS_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_window_context_v1
 */
#define TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_SET_SHADOW_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_window_context_v1
 */
#define TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_SET_BORDER_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_window_context_v1
 */
#define TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_SET_TITLEBAR_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_window_context_v1
 */
#define TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_treeland_personalization_window_context_v1 */
static inline void
treeland_personalization_window_context_v1_set_user_data(struct treeland_personalization_window_context_v1 *treeland_personalization_window_context_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) treeland_personalization_window_context_v1, user_data);
}

/** @ingroup iface_treeland_personalization_window_context_v1 */
static inline void *
treeland_personalization_window_context_v1_get_user_data(struct treeland_personalization_window_context_v1 *treeland_personalization_window_context_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) treeland_personalization_window_context_v1);
}

static inline uint32_t
treeland_personalization_window_context_v1_get_version(struct treeland_personalization_window_context_v1 *treeland_personalization_window_context_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) treeland_personalization_window_context_v1);
}

/**
 * @ingroup iface_treeland_personalization_window_context_v1
 *
 * Set window background blend mode
 */
static inline void
treeland_personalization_window_context_v1_set_blend_mode(struct treeland_personalization_window_context_v1 *treeland_personalization_window_context_v1, int32_t mode)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_window_context_v1,
			 TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_SET_BLEND_MODE, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_window_context_v1), 0, mode);
}

/**
 * @ingroup iface_treeland_personalization_window_context_v1
 *
 * This request will set window round corner radius, invoking this request means user
 * want to
 * manage window round corner radius by itself. If not invoked, window round corner
 * radius will
 * be decided by compositor.
 */
static inline void
treeland_personalization_window_context_v1_set_round_corner_radius(struct treeland_personalization_window_context_v1 *treeland_personalization_window_context_v1, int32_t radius)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_window_context_v1,
			 TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_SET_ROUND_CORNER_RADIUS, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_window_context_v1), 0, radius);
}

/**
 * @ingroup iface_treeland_personalization_window_context_v1
 *
 * Set window shadow's radius, offset and color, invoking this request indicates that
 * client want to manage
 * the window shadow by itself. If not invoked, window shadow will be decided by the
 * compositor
 */
static inline void
treeland_personalization_window_context_v1_set_shadow(struct treeland_personalization_window_context_v1 *treeland_personalization_window_context_v1, int32_t radius, int32_t offset_x, int32_t offset_y, int32_t r, int32_t g, int32_t b, int32_t a)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_window_context_v1,
			 TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_SET_SHADOW, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_window_context_v1), 0, radius, offset_x, offset_y, r, g, b, a);
}

/**
 * @ingroup iface_treeland_personalization_window_context_v1
 *
 * Set window border width and color
 */
static inline void
treeland_personalization_window_context_v1_set_border(struct treeland_personalization_window_context_v1 *treeland_personalization_window_context_v1, int32_t width, int32_t r, int32_t g, int32_t b, int32_t a)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_window_context_v1,
			 TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_SET_BORDER, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_window_context_v1), 0, width, r, g, b, a);
}

/**
 * @ingroup iface_treeland_personalization_window_context_v1
 *
 * Set if system titlebar is enabled
 */
static inline void
treeland_personalization_window_context_v1_set_titlebar(struct treeland_personalization_window_context_v1 *treeland_personalization_window_context_v1, int32_t mode)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_window_context_v1,
			 TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_SET_TITLEBAR, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_window_context_v1), 0, mode);
}

/**
 * @ingroup iface_treeland_personalization_window_context_v1
 *
 * Destroy the context object.
 */
static inline void
treeland_personalization_window_context_v1_destroy(struct treeland_personalization_window_context_v1 *treeland_personalization_window_context_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_window_context_v1,
			 TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_window_context_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_treeland_personalization_font_context_v1
 * @struct treeland_personalization_font_context_v1_listener
 */
struct treeland_personalization_font_context_v1_listener {
	/**
	 * font event
	 *
	 * Send this signal after setting the system font.
	 * @param font_name font name
	 */
	void (*font)(void *data,
		     struct treeland_personalization_font_context_v1 *treeland_personalization_font_context_v1,
		     const char *font_name);
	/**
	 * monospace font event
	 *
	 * Send this signal after setting the system monospace font.
	 * @param font_name monospace font name
	 */
	void (*monospace_font)(void *data,
			       struct treeland_personalization_font_context_v1 *treeland_personalization_font_context_v1,
			       const char *font_name);
	/**
	 * font size
	 *
	 * Send this signal after setting the system font size.
	 * @param font_size font size
	 */
	void (*font_size)(void *data,
			  struct treeland_personalization_font_context_v1 *treeland_personalization_font_context_v1,
			  uint32_t font_size);
};

/**
 * @ingroup iface_treeland_personalization_font_context_v1
 */
static inline int
treeland_personalization_font_context_v1_add_listener(struct treeland_personalization_font_context_v1 *treeland_personalization_font_context_v1,
						      const struct treeland_personalization_font_context_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) treeland_personalization_font_context_v1,
				     (void (**)(void)) listener, data);
}

#define TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_SET_FONT_SIZE 0
#define TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_GET_FONT_SIZE 1
#define TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_SET_FONT 2
#define TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_GET_FONT 3
#define TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_SET_MONOSPACE_FONT 4
#define TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_GET_MONOSPACE_FONT 5
#define TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_DESTROY 6

/**
 * @ingroup iface_treeland_personalization_font_context_v1
 */
#define TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_FONT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_font_context_v1
 */
#define TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_MONOSPACE_FONT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_font_context_v1
 */
#define TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_FONT_SIZE_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_personalization_font_context_v1
 */
#define TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_SET_FONT_SIZE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_font_context_v1
 */
#define TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_GET_FONT_SIZE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_font_context_v1
 */
#define TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_SET_FONT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_font_context_v1
 */
#define TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_GET_FONT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_font_context_v1
 */
#define TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_SET_MONOSPACE_FONT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_font_context_v1
 */
#define TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_GET_MONOSPACE_FONT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_font_context_v1
 */
#define TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_treeland_personalization_font_context_v1 */
static inline void
treeland_personalization_font_context_v1_set_user_data(struct treeland_personalization_font_context_v1 *treeland_personalization_font_context_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) treeland_personalization_font_context_v1, user_data);
}

/** @ingroup iface_treeland_personalization_font_context_v1 */
static inline void *
treeland_personalization_font_context_v1_get_user_data(struct treeland_personalization_font_context_v1 *treeland_personalization_font_context_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) treeland_personalization_font_context_v1);
}

static inline uint32_t
treeland_personalization_font_context_v1_get_version(struct treeland_personalization_font_context_v1 *treeland_personalization_font_context_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) treeland_personalization_font_context_v1);
}

/**
 * @ingroup iface_treeland_personalization_font_context_v1
 *
 * Set the system font size
 */
static inline void
treeland_personalization_font_context_v1_set_font_size(struct treeland_personalization_font_context_v1 *treeland_personalization_font_context_v1, uint32_t size)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_font_context_v1,
			 TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_SET_FONT_SIZE, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_font_context_v1), 0, size);
}

/**
 * @ingroup iface_treeland_personalization_font_context_v1
 *
 * Get the system font size
 */
static inline void
treeland_personalization_font_context_v1_get_font_size(struct treeland_personalization_font_context_v1 *treeland_personalization_font_context_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_font_context_v1,
			 TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_GET_FONT_SIZE, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_font_context_v1), 0);
}

/**
 * @ingroup iface_treeland_personalization_font_context_v1
 *
 * Set the system font
 */
static inline void
treeland_personalization_font_context_v1_set_font(struct treeland_personalization_font_context_v1 *treeland_personalization_font_context_v1, const char *font_name)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_font_context_v1,
			 TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_SET_FONT, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_font_context_v1), 0, font_name);
}

/**
 * @ingroup iface_treeland_personalization_font_context_v1
 *
 * Get the system font
 */
static inline void
treeland_personalization_font_context_v1_get_font(struct treeland_personalization_font_context_v1 *treeland_personalization_font_context_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_font_context_v1,
			 TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_GET_FONT, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_font_context_v1), 0);
}

/**
 * @ingroup iface_treeland_personalization_font_context_v1
 *
 * Set the system monospace font
 */
static inline void
treeland_personalization_font_context_v1_set_monospace_font(struct treeland_personalization_font_context_v1 *treeland_personalization_font_context_v1, const char *font_name)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_font_context_v1,
			 TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_SET_MONOSPACE_FONT, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_font_context_v1), 0, font_name);
}

/**
 * @ingroup iface_treeland_personalization_font_context_v1
 *
 * Get the system monospace font
 */
static inline void
treeland_personalization_font_context_v1_get_monospace_font(struct treeland_personalization_font_context_v1 *treeland_personalization_font_context_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_font_context_v1,
			 TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_GET_MONOSPACE_FONT, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_font_context_v1), 0);
}

/**
 * @ingroup iface_treeland_personalization_font_context_v1
 *
 * Destroy the context object.
 */
static inline void
treeland_personalization_font_context_v1_destroy(struct treeland_personalization_font_context_v1 *treeland_personalization_font_context_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_font_context_v1,
			 TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_font_context_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifndef TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_THEME_TYPE_ENUM
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_THEME_TYPE_ENUM
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 * window theme type
 */
enum treeland_personalization_appearance_context_v1_theme_type {
	/**
	 * window auto theme
	 */
	TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_THEME_TYPE_AUTO = 1,
	/**
	 * window light theme
	 */
	TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_THEME_TYPE_LIGHT = 2,
	/**
	 * window dark theme
	 */
	TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_THEME_TYPE_DARK = 4,
};
#endif /* TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_THEME_TYPE_ENUM */

#ifndef TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ERROR_ENUM
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ERROR_ENUM
enum treeland_personalization_appearance_context_v1_error {
	/**
	 * Wrong round corner radius
	 */
	TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ERROR_INVALID_ROUND_CORNER_RADIUS = 0,
	/**
	 * Wrong icon theme
	 */
	TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ERROR_INVALID_ICON_THEME = 1,
	/**
	 * Wrong active color
	 */
	TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ERROR_INVALID_ACTIVE_COLOR = 2,
	/**
	 * Wrong window opacity
	 */
	TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ERROR_INVALID_WINDOW_OPACITY = 4,
	/**
	 * Wrong theme type
	 */
	TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ERROR_INVALID_WINDOW_THEME_TYPE = 8,
	/**
	 * Wrong window titlebar height
	 */
	TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ERROR_INVALID_WINDOW_TITLEBAR_HEIGHT = 16,
};
#endif /* TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ERROR_ENUM */

/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 * @struct treeland_personalization_appearance_context_v1_listener
 */
struct treeland_personalization_appearance_context_v1_listener {
	/**
	 * round corner radius event
	 *
	 * Send this signal after setting the round corner radius.
	 * @param radius round corner radius
	 */
	void (*round_corner_radius)(void *data,
				    struct treeland_personalization_appearance_context_v1 *treeland_personalization_appearance_context_v1,
				    int32_t radius);
	/**
	 * icon theme event
	 *
	 * Send this signal after setting the system icon theme.
	 * @param theme_name icon theme name
	 */
	void (*icon_theme)(void *data,
			   struct treeland_personalization_appearance_context_v1 *treeland_personalization_appearance_context_v1,
			   const char *theme_name);
	/**
	 * active color
	 *
	 * Send this signal after setting the system active color
	 * @param active_color active color
	 */
	void (*active_color)(void *data,
			     struct treeland_personalization_appearance_context_v1 *treeland_personalization_appearance_context_v1,
			     const char *active_color);
	/**
	 * window opacity
	 *
	 * Send this signal after setting the system active color
	 * @param opacity window opacity
	 */
	void (*window_opacity)(void *data,
			       struct treeland_personalization_appearance_context_v1 *treeland_personalization_appearance_context_v1,
			       uint32_t opacity);
	/**
	 * window theme
	 *
	 * Send this signal after setting the system theme
	 * @param type window theme type
	 */
	void (*window_theme_type)(void *data,
				  struct treeland_personalization_appearance_context_v1 *treeland_personalization_appearance_context_v1,
				  uint32_t type);
	/**
	 * window titlebar height
	 *
	 * Send this signal after setting the window titlebar height
	 * @param height window titlebar height
	 */
	void (*window_titlebar_height)(void *data,
				       struct treeland_personalization_appearance_context_v1 *treeland_personalization_appearance_context_v1,
				       uint32_t height);
};

/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
static inline int
treeland_personalization_appearance_context_v1_add_listener(struct treeland_personalization_appearance_context_v1 *treeland_personalization_appearance_context_v1,
							    const struct treeland_personalization_appearance_context_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) treeland_personalization_appearance_context_v1,
				     (void (**)(void)) listener, data);
}

#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_SET_ROUND_CORNER_RADIUS 0
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_GET_ROUND_CORNER_RADIUS 1
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_SET_ICON_THEME 2
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_GET_ICON_THEME 3
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_SET_ACTIVE_COLOR 4
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_GET_ACTIVE_COLOR 5
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_SET_WINDOW_OPACITY 6
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_GET_WINDOW_OPACITY 7
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_SET_WINDOW_THEME_TYPE 8
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_GET_WINDOW_THEME_TYPE 9
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_SET_WINDOW_TITLEBAR_HEIGHT 10
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_GET_WINDOW_TITLEBAR_HEIGHT 11
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_DESTROY 12

/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ROUND_CORNER_RADIUS_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ICON_THEME_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ACTIVE_COLOR_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_WINDOW_OPACITY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_WINDOW_THEME_TYPE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_WINDOW_TITLEBAR_HEIGHT_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_SET_ROUND_CORNER_RADIUS_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_GET_ROUND_CORNER_RADIUS_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_SET_ICON_THEME_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_GET_ICON_THEME_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_SET_ACTIVE_COLOR_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_GET_ACTIVE_COLOR_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_SET_WINDOW_OPACITY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_GET_WINDOW_OPACITY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_SET_WINDOW_THEME_TYPE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_GET_WINDOW_THEME_TYPE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_SET_WINDOW_TITLEBAR_HEIGHT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_GET_WINDOW_TITLEBAR_HEIGHT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_treeland_personalization_appearance_context_v1 */
static inline void
treeland_personalization_appearance_context_v1_set_user_data(struct treeland_personalization_appearance_context_v1 *treeland_personalization_appearance_context_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) treeland_personalization_appearance_context_v1, user_data);
}

/** @ingroup iface_treeland_personalization_appearance_context_v1 */
static inline void *
treeland_personalization_appearance_context_v1_get_user_data(struct treeland_personalization_appearance_context_v1 *treeland_personalization_appearance_context_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) treeland_personalization_appearance_context_v1);
}

static inline uint32_t
treeland_personalization_appearance_context_v1_get_version(struct treeland_personalization_appearance_context_v1 *treeland_personalization_appearance_context_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) treeland_personalization_appearance_context_v1);
}

/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 *
 * Set window round corner radius
 */
static inline void
treeland_personalization_appearance_context_v1_set_round_corner_radius(struct treeland_personalization_appearance_context_v1 *treeland_personalization_appearance_context_v1, int32_t radius)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_appearance_context_v1,
			 TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_SET_ROUND_CORNER_RADIUS, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_appearance_context_v1), 0, radius);
}

/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 *
 * Get window round corner radius
 */
static inline void
treeland_personalization_appearance_context_v1_get_round_corner_radius(struct treeland_personalization_appearance_context_v1 *treeland_personalization_appearance_context_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_appearance_context_v1,
			 TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_GET_ROUND_CORNER_RADIUS, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_appearance_context_v1), 0);
}

/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 *
 * Set the system icon theme
 */
static inline void
treeland_personalization_appearance_context_v1_set_icon_theme(struct treeland_personalization_appearance_context_v1 *treeland_personalization_appearance_context_v1, const char *theme)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_appearance_context_v1,
			 TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_SET_ICON_THEME, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_appearance_context_v1), 0, theme);
}

/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 *
 * Get the system icon theme
 */
static inline void
treeland_personalization_appearance_context_v1_get_icon_theme(struct treeland_personalization_appearance_context_v1 *treeland_personalization_appearance_context_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_appearance_context_v1,
			 TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_GET_ICON_THEME, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_appearance_context_v1), 0);
}

/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 *
 * Set the system active color
 */
static inline void
treeland_personalization_appearance_context_v1_set_active_color(struct treeland_personalization_appearance_context_v1 *treeland_personalization_appearance_context_v1, const char *color)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_appearance_context_v1,
			 TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_SET_ACTIVE_COLOR, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_appearance_context_v1), 0, color);
}

/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 *
 * Get the system active color
 */
static inline void
treeland_personalization_appearance_context_v1_get_active_color(struct treeland_personalization_appearance_context_v1 *treeland_personalization_appearance_context_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_appearance_context_v1,
			 TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_GET_ACTIVE_COLOR, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_appearance_context_v1), 0);
}

/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 *
 * Set the window window opacity
 */
static inline void
treeland_personalization_appearance_context_v1_set_window_opacity(struct treeland_personalization_appearance_context_v1 *treeland_personalization_appearance_context_v1, uint32_t opacity)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_appearance_context_v1,
			 TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_SET_WINDOW_OPACITY, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_appearance_context_v1), 0, opacity);
}

/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 *
 * Get the window window opacity
 */
static inline void
treeland_personalization_appearance_context_v1_get_window_opacity(struct treeland_personalization_appearance_context_v1 *treeland_personalization_appearance_context_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_appearance_context_v1,
			 TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_GET_WINDOW_OPACITY, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_appearance_context_v1), 0);
}

/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 *
 * Set the window theme.
 */
static inline void
treeland_personalization_appearance_context_v1_set_window_theme_type(struct treeland_personalization_appearance_context_v1 *treeland_personalization_appearance_context_v1, uint32_t type)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_appearance_context_v1,
			 TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_SET_WINDOW_THEME_TYPE, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_appearance_context_v1), 0, type);
}

/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 *
 * Get the window theme type
 */
static inline void
treeland_personalization_appearance_context_v1_get_window_theme_type(struct treeland_personalization_appearance_context_v1 *treeland_personalization_appearance_context_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_appearance_context_v1,
			 TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_GET_WINDOW_THEME_TYPE, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_appearance_context_v1), 0);
}

/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 *
 * Set the window titlebar height
 */
static inline void
treeland_personalization_appearance_context_v1_set_window_titlebar_height(struct treeland_personalization_appearance_context_v1 *treeland_personalization_appearance_context_v1, uint32_t height)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_appearance_context_v1,
			 TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_SET_WINDOW_TITLEBAR_HEIGHT, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_appearance_context_v1), 0, height);
}

/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 *
 * Get the window titlebar height
 */
static inline void
treeland_personalization_appearance_context_v1_get_window_titlebar_height(struct treeland_personalization_appearance_context_v1 *treeland_personalization_appearance_context_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_appearance_context_v1,
			 TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_GET_WINDOW_TITLEBAR_HEIGHT, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_appearance_context_v1), 0);
}

/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 *
 * Destroy the context object.
 */
static inline void
treeland_personalization_appearance_context_v1_destroy(struct treeland_personalization_appearance_context_v1 *treeland_personalization_appearance_context_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_personalization_appearance_context_v1,
			 TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_personalization_appearance_context_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
