// Code generated by op-codegen - DO NOT EDIT

package onepassword

import (
	"context"
	"encoding/json"

	"github.com/1password/onepassword-sdk-go/internal"
)

type ItemsSharesAPI interface {
	// Get the item sharing policy of your account.
	GetAccountPolicy(ctx context.Context, vaultID string, itemID string) (ItemShareAccountPolicy, error)

	// Validate the recipients of an item sharing link.
	ValidateRecipients(ctx context.Context, policy ItemShareAccountPolicy, recipients []string) ([]ValidRecipient, error)

	// Create a new item sharing link.
	Create(ctx context.Context, item Item, policy ItemShareAccountPolicy, params ItemShareParams) (string, error)
}

type ItemsSharesSource struct {
	internal.InnerClient
}

func NewItemsSharesSource(inner internal.InnerClient) ItemsSharesAPI {
	return &ItemsSharesSource{InnerClient: inner}
}

// Get the item sharing policy of your account.
func (i ItemsSharesSource) GetAccountPolicy(ctx context.Context, vaultID string, itemID string) (ItemShareAccountPolicy, error) {
	resultString, err := clientInvoke(ctx, i.InnerClient, "ItemsSharesGetAccountPolicy", map[string]interface{}{
		"vault_id": vaultID,
		"item_id":  itemID,
	})
	if err != nil {
		return ItemShareAccountPolicy{}, err
	}
	var result ItemShareAccountPolicy
	err = json.Unmarshal([]byte(*resultString), &result)
	if err != nil {
		return ItemShareAccountPolicy{}, err
	}
	return result, nil
}

// Validate the recipients of an item sharing link.
func (i ItemsSharesSource) ValidateRecipients(ctx context.Context, policy ItemShareAccountPolicy, recipients []string) ([]ValidRecipient, error) {
	resultString, err := clientInvoke(ctx, i.InnerClient, "ItemsSharesValidateRecipients", map[string]interface{}{
		"policy":     policy,
		"recipients": recipients,
	})
	if err != nil {
		return nil, err
	}
	var result []ValidRecipient
	err = json.Unmarshal([]byte(*resultString), &result)
	if err != nil {
		return nil, err
	}
	return result, nil
}

// Create a new item sharing link.
func (i ItemsSharesSource) Create(ctx context.Context, item Item, policy ItemShareAccountPolicy, params ItemShareParams) (string, error) {
	resultString, err := clientInvoke(ctx, i.InnerClient, "ItemsSharesCreate", map[string]interface{}{
		"item":   item,
		"policy": policy,
		"params": params,
	})
	if err != nil {
		return "", err
	}
	var result string
	err = json.Unmarshal([]byte(*resultString), &result)
	if err != nil {
		return "", err
	}
	return result, nil
}
