/*********************                                                        */
/*! \file module_template.h
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2020 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Contains code for handling command-line options.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.h file.
 **/

#include "cvc4_private.h"

#ifndef CVC4__OPTIONS__DRIVER_H
#define CVC4__OPTIONS__DRIVER_H

#include "options/options.h"




#define CVC4_OPTIONS__DRIVER__FOR_OPTION_HOLDER \
  earlyExit__option_t::type earlyExit;\
  bool earlyExit__setByUser__; \
  help__option_t::type help;\
  bool help__setByUser__; \
  interactive__option_t::type interactive;\
  bool interactive__setByUser__; \
  interactivePrompt__option_t::type interactivePrompt;\
  bool interactivePrompt__setByUser__; \
  seed__option_t::type seed;\
  bool seed__setByUser__; \
  segvSpin__option_t::type segvSpin;\
  bool segvSpin__setByUser__; \
  tearDownIncremental__option_t::type tearDownIncremental;\
  bool tearDownIncremental__setByUser__; \
  version__option_t::type version;\
  bool version__setByUser__;


namespace CVC4 {

namespace options {



extern struct CVC4_PUBLIC earlyExit__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} earlyExit CVC4_PUBLIC;
extern struct CVC4_PUBLIC help__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} help CVC4_PUBLIC;
extern struct CVC4_PUBLIC interactive__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} interactive CVC4_PUBLIC;
extern struct CVC4_PUBLIC interactivePrompt__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} interactivePrompt CVC4_PUBLIC;
extern struct CVC4_PUBLIC seed__option_t
{
  typedef uint64_t type;
  type operator()() const;
  bool wasSetByUser() const;
} seed CVC4_PUBLIC;
extern struct CVC4_PUBLIC segvSpin__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} segvSpin CVC4_PUBLIC;
extern struct CVC4_PUBLIC tearDownIncremental__option_t
{
  typedef int type;
  type operator()() const;
  bool wasSetByUser() const;
} tearDownIncremental CVC4_PUBLIC;
extern struct CVC4_PUBLIC version__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} version CVC4_PUBLIC;

}  // namespace options

template <> const options::earlyExit__option_t::type& Options::operator[](
    options::earlyExit__option_t) const;
template <> bool Options::wasSetByUser(options::earlyExit__option_t) const;
template <> void Options::assignBool(
    options::earlyExit__option_t,
    std::string option,
    bool value);
template <> const options::help__option_t::type& Options::operator[](
    options::help__option_t) const;
template <> bool Options::wasSetByUser(options::help__option_t) const;
template <> void Options::assignBool(
    options::help__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::interactive__option_t,
    const options::interactive__option_t::type& x);
template <> const options::interactive__option_t::type& Options::operator[](
    options::interactive__option_t) const;
template <> bool Options::wasSetByUser(options::interactive__option_t) const;
template <> void Options::assignBool(
    options::interactive__option_t,
    std::string option,
    bool value);
template <> const options::interactivePrompt__option_t::type& Options::operator[](
    options::interactivePrompt__option_t) const;
template <> bool Options::wasSetByUser(options::interactivePrompt__option_t) const;
template <> void Options::assignBool(
    options::interactivePrompt__option_t,
    std::string option,
    bool value);
template <> const options::seed__option_t::type& Options::operator[](
    options::seed__option_t) const;
template <> bool Options::wasSetByUser(options::seed__option_t) const;
template <> void Options::assign(
    options::seed__option_t,
    std::string option,
    std::string value);
template <> const options::segvSpin__option_t::type& Options::operator[](
    options::segvSpin__option_t) const;
template <> bool Options::wasSetByUser(options::segvSpin__option_t) const;
template <> void Options::assignBool(
    options::segvSpin__option_t,
    std::string option,
    bool value);
template <> const options::tearDownIncremental__option_t::type& Options::operator[](
    options::tearDownIncremental__option_t) const;
template <> bool Options::wasSetByUser(options::tearDownIncremental__option_t) const;
template <> void Options::assign(
    options::tearDownIncremental__option_t,
    std::string option,
    std::string value);
template <> const options::version__option_t::type& Options::operator[](
    options::version__option_t) const;
template <> bool Options::wasSetByUser(options::version__option_t) const;
template <> void Options::assignBool(
    options::version__option_t,
    std::string option,
    bool value);


namespace options {

inline earlyExit__option_t::type earlyExit__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool earlyExit__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline help__option_t::type help__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool help__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline interactive__option_t::type interactive__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool interactive__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void interactive__option_t::set(const interactive__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline interactivePrompt__option_t::type interactivePrompt__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool interactivePrompt__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline seed__option_t::type seed__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool seed__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline segvSpin__option_t::type segvSpin__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool segvSpin__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline tearDownIncremental__option_t::type tearDownIncremental__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool tearDownIncremental__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline version__option_t::type version__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool version__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}

}  // namespace options
}  // namespace CVC4

#endif /* CVC4__OPTIONS__DRIVER_H */
