/*********************                                                        */
/*! \file module_template.h
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2020 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Contains code for handling command-line options.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.h file.
 **/

#include "cvc4_private.h"

#ifndef CVC4__OPTIONS__DECISION_H
#define CVC4__OPTIONS__DECISION_H

#include "options/options.h"

#include "options/decision_weight.h"


#define CVC4_OPTIONS__DECISION__FOR_OPTION_HOLDER \
  decisionRandomWeight__option_t::type decisionRandomWeight;\
  bool decisionRandomWeight__setByUser__; \
  decisionThreshold__option_t::type decisionThreshold;\
  bool decisionThreshold__setByUser__; \
  decisionUseWeight__option_t::type decisionUseWeight;\
  bool decisionUseWeight__setByUser__; \
  decisionWeightInternal__option_t::type decisionWeightInternal;\
  bool decisionWeightInternal__setByUser__; \
  decisionMode__option_t::type decisionMode;\
  bool decisionMode__setByUser__; \
  decisionStopOnly__option_t::type decisionStopOnly;\
  bool decisionStopOnly__setByUser__;


namespace CVC4 {

namespace options {


enum class DecisionWeightInternal
{
  OFF,
  MAX,
  SUM,
  USR1
};
std::ostream&
operator<<(std::ostream& os, DecisionWeightInternal mode) CVC4_PUBLIC;
DecisionWeightInternal
stringToDecisionWeightInternal(const std::string& option, const std::string& optarg);
enum class DecisionMode
{
  INTERNAL,
  JUSTIFICATION,
  RELEVANCY
};
std::ostream&
operator<<(std::ostream& os, DecisionMode mode) CVC4_PUBLIC;
DecisionMode
stringToDecisionMode(const std::string& option, const std::string& optarg);

extern struct CVC4_PUBLIC decisionRandomWeight__option_t
{
  typedef int type;
  type operator()() const;
  bool wasSetByUser() const;
} decisionRandomWeight CVC4_PUBLIC;
extern struct CVC4_PUBLIC decisionThreshold__option_t
{
  typedef decision::DecisionWeight type;
  type operator()() const;
  bool wasSetByUser() const;
} decisionThreshold CVC4_PUBLIC;
extern struct CVC4_PUBLIC decisionUseWeight__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} decisionUseWeight CVC4_PUBLIC;
extern struct CVC4_PUBLIC decisionWeightInternal__option_t
{
  typedef DecisionWeightInternal type;
  type operator()() const;
  bool wasSetByUser() const;
} decisionWeightInternal CVC4_PUBLIC;
extern struct CVC4_PUBLIC decisionMode__option_t
{
  typedef DecisionMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} decisionMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC decisionStopOnly__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} decisionStopOnly CVC4_PUBLIC;

}  // namespace options

template <> const options::decisionRandomWeight__option_t::type& Options::operator[](
    options::decisionRandomWeight__option_t) const;
template <> bool Options::wasSetByUser(options::decisionRandomWeight__option_t) const;
template <> void Options::assign(
    options::decisionRandomWeight__option_t,
    std::string option,
    std::string value);
template <> const options::decisionThreshold__option_t::type& Options::operator[](
    options::decisionThreshold__option_t) const;
template <> bool Options::wasSetByUser(options::decisionThreshold__option_t) const;
template <> void Options::assign(
    options::decisionThreshold__option_t,
    std::string option,
    std::string value);
template <> const options::decisionUseWeight__option_t::type& Options::operator[](
    options::decisionUseWeight__option_t) const;
template <> bool Options::wasSetByUser(options::decisionUseWeight__option_t) const;
template <> void Options::assignBool(
    options::decisionUseWeight__option_t,
    std::string option,
    bool value);
template <> const options::decisionWeightInternal__option_t::type& Options::operator[](
    options::decisionWeightInternal__option_t) const;
template <> bool Options::wasSetByUser(options::decisionWeightInternal__option_t) const;
template <> void Options::assign(
    options::decisionWeightInternal__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::decisionMode__option_t,
    const options::decisionMode__option_t::type& x);
template <> const options::decisionMode__option_t::type& Options::operator[](
    options::decisionMode__option_t) const;
template <> bool Options::wasSetByUser(options::decisionMode__option_t) const;
template <> void Options::assign(
    options::decisionMode__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::decisionStopOnly__option_t,
    const options::decisionStopOnly__option_t::type& x);
template <> const options::decisionStopOnly__option_t::type& Options::operator[](
    options::decisionStopOnly__option_t) const;
template <> bool Options::wasSetByUser(options::decisionStopOnly__option_t) const;
template <> void Options::assignBool(
    options::decisionStopOnly__option_t,
    std::string option,
    bool value);


namespace options {

inline decisionRandomWeight__option_t::type decisionRandomWeight__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool decisionRandomWeight__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline decisionThreshold__option_t::type decisionThreshold__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool decisionThreshold__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline decisionUseWeight__option_t::type decisionUseWeight__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool decisionUseWeight__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline decisionWeightInternal__option_t::type decisionWeightInternal__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool decisionWeightInternal__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline decisionMode__option_t::type decisionMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool decisionMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void decisionMode__option_t::set(const decisionMode__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline decisionStopOnly__option_t::type decisionStopOnly__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool decisionStopOnly__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void decisionStopOnly__option_t::set(const decisionStopOnly__option_t::type& v)
{
  Options::current()->set(*this, v);
}

}  // namespace options
}  // namespace CVC4

#endif /* CVC4__OPTIONS__DECISION_H */
