/*********************                                                        */
/*! \file module_template.cpp
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2020 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Option template for option modules.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.cpp file.
 **/

#include "options/options_holder.h"
#include "base/check.h"

namespace CVC4 {

template <> void Options::set(
    options::bitvectorAig__option_t,
    const options::bitvectorAig__option_t::type& x)
{
  d_holder->bitvectorAig = x;
}
template <> const options::bitvectorAig__option_t::type& Options::operator[](
    options::bitvectorAig__option_t) const
{
  return d_holder->bitvectorAig;
}
template <> bool Options::wasSetByUser(options::bitvectorAig__option_t) const
{
  return d_holder->bitvectorAig__setByUser__;
}
template <> void Options::set(
    options::bitblastMode__option_t,
    const options::bitblastMode__option_t::type& x)
{
  d_holder->bitblastMode = x;
}
template <> const options::bitblastMode__option_t::type& Options::operator[](
    options::bitblastMode__option_t) const
{
  return d_holder->bitblastMode;
}
template <> bool Options::wasSetByUser(options::bitblastMode__option_t) const
{
  return d_holder->bitblastMode__setByUser__;
}
template <> void Options::set(
    options::bitwiseEq__option_t,
    const options::bitwiseEq__option_t::type& x)
{
  d_holder->bitwiseEq = x;
}
template <> const options::bitwiseEq__option_t::type& Options::operator[](
    options::bitwiseEq__option_t) const
{
  return d_holder->bitwiseEq;
}
template <> bool Options::wasSetByUser(options::bitwiseEq__option_t) const
{
  return d_holder->bitwiseEq__setByUser__;
}
template <> void Options::set(
    options::boolToBitvector__option_t,
    const options::boolToBitvector__option_t::type& x)
{
  d_holder->boolToBitvector = x;
}
template <> const options::boolToBitvector__option_t::type& Options::operator[](
    options::boolToBitvector__option_t) const
{
  return d_holder->boolToBitvector;
}
template <> bool Options::wasSetByUser(options::boolToBitvector__option_t) const
{
  return d_holder->boolToBitvector__setByUser__;
}
template <> void Options::set(
    options::bvAbstraction__option_t,
    const options::bvAbstraction__option_t::type& x)
{
  d_holder->bvAbstraction = x;
}
template <> const options::bvAbstraction__option_t::type& Options::operator[](
    options::bvAbstraction__option_t) const
{
  return d_holder->bvAbstraction;
}
template <> bool Options::wasSetByUser(options::bvAbstraction__option_t) const
{
  return d_holder->bvAbstraction__setByUser__;
}
template <> void Options::set(
    options::bitvectorAigSimplifications__option_t,
    const options::bitvectorAigSimplifications__option_t::type& x)
{
  d_holder->bitvectorAigSimplifications = x;
}
template <> const options::bitvectorAigSimplifications__option_t::type& Options::operator[](
    options::bitvectorAigSimplifications__option_t) const
{
  return d_holder->bitvectorAigSimplifications;
}
template <> bool Options::wasSetByUser(options::bitvectorAigSimplifications__option_t) const
{
  return d_holder->bitvectorAigSimplifications__setByUser__;
}
template <> void Options::set(
    options::bvAlgExtf__option_t,
    const options::bvAlgExtf__option_t::type& x)
{
  d_holder->bvAlgExtf = x;
}
template <> const options::bvAlgExtf__option_t::type& Options::operator[](
    options::bvAlgExtf__option_t) const
{
  return d_holder->bvAlgExtf;
}
template <> bool Options::wasSetByUser(options::bvAlgExtf__option_t) const
{
  return d_holder->bvAlgExtf__setByUser__;
}
template <> void Options::set(
    options::bitvectorAlgebraicBudget__option_t,
    const options::bitvectorAlgebraicBudget__option_t::type& x)
{
  d_holder->bitvectorAlgebraicBudget = x;
}
template <> const options::bitvectorAlgebraicBudget__option_t::type& Options::operator[](
    options::bitvectorAlgebraicBudget__option_t) const
{
  return d_holder->bitvectorAlgebraicBudget;
}
template <> bool Options::wasSetByUser(options::bitvectorAlgebraicBudget__option_t) const
{
  return d_holder->bitvectorAlgebraicBudget__setByUser__;
}
template <> void Options::set(
    options::bitvectorAlgebraicSolver__option_t,
    const options::bitvectorAlgebraicSolver__option_t::type& x)
{
  d_holder->bitvectorAlgebraicSolver = x;
}
template <> const options::bitvectorAlgebraicSolver__option_t::type& Options::operator[](
    options::bitvectorAlgebraicSolver__option_t) const
{
  return d_holder->bitvectorAlgebraicSolver;
}
template <> bool Options::wasSetByUser(options::bitvectorAlgebraicSolver__option_t) const
{
  return d_holder->bitvectorAlgebraicSolver__setByUser__;
}
template <> void Options::set(
    options::bitvectorDivByZeroConst__option_t,
    const options::bitvectorDivByZeroConst__option_t::type& x)
{
  d_holder->bitvectorDivByZeroConst = x;
}
template <> const options::bitvectorDivByZeroConst__option_t::type& Options::operator[](
    options::bitvectorDivByZeroConst__option_t) const
{
  return d_holder->bitvectorDivByZeroConst;
}
template <> bool Options::wasSetByUser(options::bitvectorDivByZeroConst__option_t) const
{
  return d_holder->bitvectorDivByZeroConst__setByUser__;
}
template <> void Options::set(
    options::bvEagerExplanations__option_t,
    const options::bvEagerExplanations__option_t::type& x)
{
  d_holder->bvEagerExplanations = x;
}
template <> const options::bvEagerExplanations__option_t::type& Options::operator[](
    options::bvEagerExplanations__option_t) const
{
  return d_holder->bvEagerExplanations;
}
template <> bool Options::wasSetByUser(options::bvEagerExplanations__option_t) const
{
  return d_holder->bvEagerExplanations__setByUser__;
}
template <> void Options::set(
    options::bitvectorEqualitySlicer__option_t,
    const options::bitvectorEqualitySlicer__option_t::type& x)
{
  d_holder->bitvectorEqualitySlicer = x;
}
template <> const options::bitvectorEqualitySlicer__option_t::type& Options::operator[](
    options::bitvectorEqualitySlicer__option_t) const
{
  return d_holder->bitvectorEqualitySlicer;
}
template <> bool Options::wasSetByUser(options::bitvectorEqualitySlicer__option_t) const
{
  return d_holder->bitvectorEqualitySlicer__setByUser__;
}
template <> void Options::set(
    options::bitvectorEqualitySolver__option_t,
    const options::bitvectorEqualitySolver__option_t::type& x)
{
  d_holder->bitvectorEqualitySolver = x;
}
template <> const options::bitvectorEqualitySolver__option_t::type& Options::operator[](
    options::bitvectorEqualitySolver__option_t) const
{
  return d_holder->bitvectorEqualitySolver;
}
template <> bool Options::wasSetByUser(options::bitvectorEqualitySolver__option_t) const
{
  return d_holder->bitvectorEqualitySolver__setByUser__;
}
template <> void Options::set(
    options::bvExtractArithRewrite__option_t,
    const options::bvExtractArithRewrite__option_t::type& x)
{
  d_holder->bvExtractArithRewrite = x;
}
template <> const options::bvExtractArithRewrite__option_t::type& Options::operator[](
    options::bvExtractArithRewrite__option_t) const
{
  return d_holder->bvExtractArithRewrite;
}
template <> bool Options::wasSetByUser(options::bvExtractArithRewrite__option_t) const
{
  return d_holder->bvExtractArithRewrite__setByUser__;
}
template <> const options::bvGaussElim__option_t::type& Options::operator[](
    options::bvGaussElim__option_t) const
{
  return d_holder->bvGaussElim;
}
template <> bool Options::wasSetByUser(options::bvGaussElim__option_t) const
{
  return d_holder->bvGaussElim__setByUser__;
}
template <> void Options::set(
    options::bitvectorInequalitySolver__option_t,
    const options::bitvectorInequalitySolver__option_t::type& x)
{
  d_holder->bitvectorInequalitySolver = x;
}
template <> const options::bitvectorInequalitySolver__option_t::type& Options::operator[](
    options::bitvectorInequalitySolver__option_t) const
{
  return d_holder->bitvectorInequalitySolver;
}
template <> bool Options::wasSetByUser(options::bitvectorInequalitySolver__option_t) const
{
  return d_holder->bitvectorInequalitySolver__setByUser__;
}
template <> const options::bvIntroducePow2__option_t::type& Options::operator[](
    options::bvIntroducePow2__option_t) const
{
  return d_holder->bvIntroducePow2;
}
template <> bool Options::wasSetByUser(options::bvIntroducePow2__option_t) const
{
  return d_holder->bvIntroducePow2__setByUser__;
}
template <> void Options::set(
    options::bvLazyReduceExtf__option_t,
    const options::bvLazyReduceExtf__option_t::type& x)
{
  d_holder->bvLazyReduceExtf = x;
}
template <> const options::bvLazyReduceExtf__option_t::type& Options::operator[](
    options::bvLazyReduceExtf__option_t) const
{
  return d_holder->bvLazyReduceExtf;
}
template <> bool Options::wasSetByUser(options::bvLazyReduceExtf__option_t) const
{
  return d_holder->bvLazyReduceExtf__setByUser__;
}
template <> void Options::set(
    options::bvLazyRewriteExtf__option_t,
    const options::bvLazyRewriteExtf__option_t::type& x)
{
  d_holder->bvLazyRewriteExtf = x;
}
template <> const options::bvLazyRewriteExtf__option_t::type& Options::operator[](
    options::bvLazyRewriteExtf__option_t) const
{
  return d_holder->bvLazyRewriteExtf;
}
template <> bool Options::wasSetByUser(options::bvLazyRewriteExtf__option_t) const
{
  return d_holder->bvLazyRewriteExtf__setByUser__;
}
template <> const options::bvNumFunc__option_t::type& Options::operator[](
    options::bvNumFunc__option_t) const
{
  return d_holder->bvNumFunc;
}
template <> bool Options::wasSetByUser(options::bvNumFunc__option_t) const
{
  return d_holder->bvNumFunc__setByUser__;
}
template <> void Options::set(
    options::bvOptimizeSatProof__option_t,
    const options::bvOptimizeSatProof__option_t::type& x)
{
  d_holder->bvOptimizeSatProof = x;
}
template <> const options::bvOptimizeSatProof__option_t::type& Options::operator[](
    options::bvOptimizeSatProof__option_t) const
{
  return d_holder->bvOptimizeSatProof;
}
template <> bool Options::wasSetByUser(options::bvOptimizeSatProof__option_t) const
{
  return d_holder->bvOptimizeSatProof__setByUser__;
}
template <> void Options::set(
    options::bvPrintConstsAsIndexedSymbols__option_t,
    const options::bvPrintConstsAsIndexedSymbols__option_t::type& x)
{
  d_holder->bvPrintConstsAsIndexedSymbols = x;
}
template <> const options::bvPrintConstsAsIndexedSymbols__option_t::type& Options::operator[](
    options::bvPrintConstsAsIndexedSymbols__option_t) const
{
  return d_holder->bvPrintConstsAsIndexedSymbols;
}
template <> bool Options::wasSetByUser(options::bvPrintConstsAsIndexedSymbols__option_t) const
{
  return d_holder->bvPrintConstsAsIndexedSymbols__setByUser__;
}
template <> void Options::set(
    options::bvProofFormat__option_t,
    const options::bvProofFormat__option_t::type& x)
{
  d_holder->bvProofFormat = x;
}
template <> const options::bvProofFormat__option_t::type& Options::operator[](
    options::bvProofFormat__option_t) const
{
  return d_holder->bvProofFormat;
}
template <> bool Options::wasSetByUser(options::bvProofFormat__option_t) const
{
  return d_holder->bvProofFormat__setByUser__;
}
template <> void Options::set(
    options::bitvectorPropagate__option_t,
    const options::bitvectorPropagate__option_t::type& x)
{
  d_holder->bitvectorPropagate = x;
}
template <> const options::bitvectorPropagate__option_t::type& Options::operator[](
    options::bitvectorPropagate__option_t) const
{
  return d_holder->bitvectorPropagate;
}
template <> bool Options::wasSetByUser(options::bitvectorPropagate__option_t) const
{
  return d_holder->bitvectorPropagate__setByUser__;
}
template <> const options::bitvectorQuickXplain__option_t::type& Options::operator[](
    options::bitvectorQuickXplain__option_t) const
{
  return d_holder->bitvectorQuickXplain;
}
template <> bool Options::wasSetByUser(options::bitvectorQuickXplain__option_t) const
{
  return d_holder->bitvectorQuickXplain__setByUser__;
}
template <> void Options::set(
    options::bvSatSolver__option_t,
    const options::bvSatSolver__option_t::type& x)
{
  d_holder->bvSatSolver = x;
}
template <> const options::bvSatSolver__option_t::type& Options::operator[](
    options::bvSatSolver__option_t) const
{
  return d_holder->bvSatSolver;
}
template <> bool Options::wasSetByUser(options::bvSatSolver__option_t) const
{
  return d_holder->bvSatSolver__setByUser__;
}
template <> void Options::set(
    options::skolemizeArguments__option_t,
    const options::skolemizeArguments__option_t::type& x)
{
  d_holder->skolemizeArguments = x;
}
template <> const options::skolemizeArguments__option_t::type& Options::operator[](
    options::skolemizeArguments__option_t) const
{
  return d_holder->skolemizeArguments;
}
template <> bool Options::wasSetByUser(options::skolemizeArguments__option_t) const
{
  return d_holder->skolemizeArguments__setByUser__;
}
template <> void Options::set(
    options::bitvectorToBool__option_t,
    const options::bitvectorToBool__option_t::type& x)
{
  d_holder->bitvectorToBool = x;
}
template <> const options::bitvectorToBool__option_t::type& Options::operator[](
    options::bitvectorToBool__option_t) const
{
  return d_holder->bitvectorToBool;
}
template <> bool Options::wasSetByUser(options::bitvectorToBool__option_t) const
{
  return d_holder->bitvectorToBool__setByUser__;
}


namespace options {

struct bitvectorAig__option_t bitvectorAig;
struct bitblastMode__option_t bitblastMode;
struct bitwiseEq__option_t bitwiseEq;
struct boolToBitvector__option_t boolToBitvector;
struct bvAbstraction__option_t bvAbstraction;
struct bitvectorAigSimplifications__option_t bitvectorAigSimplifications;
struct bvAlgExtf__option_t bvAlgExtf;
struct bitvectorAlgebraicBudget__option_t bitvectorAlgebraicBudget;
struct bitvectorAlgebraicSolver__option_t bitvectorAlgebraicSolver;
struct bitvectorDivByZeroConst__option_t bitvectorDivByZeroConst;
struct bvEagerExplanations__option_t bvEagerExplanations;
struct bitvectorEqualitySlicer__option_t bitvectorEqualitySlicer;
struct bitvectorEqualitySolver__option_t bitvectorEqualitySolver;
struct bvExtractArithRewrite__option_t bvExtractArithRewrite;
struct bvGaussElim__option_t bvGaussElim;
struct bitvectorInequalitySolver__option_t bitvectorInequalitySolver;
struct bvIntroducePow2__option_t bvIntroducePow2;
struct bvLazyReduceExtf__option_t bvLazyReduceExtf;
struct bvLazyRewriteExtf__option_t bvLazyRewriteExtf;
struct bvNumFunc__option_t bvNumFunc;
struct bvOptimizeSatProof__option_t bvOptimizeSatProof;
struct bvPrintConstsAsIndexedSymbols__option_t bvPrintConstsAsIndexedSymbols;
struct bvProofFormat__option_t bvProofFormat;
struct bitvectorPropagate__option_t bitvectorPropagate;
struct bitvectorQuickXplain__option_t bitvectorQuickXplain;
struct bvSatSolver__option_t bvSatSolver;
struct skolemizeArguments__option_t skolemizeArguments;
struct bitvectorToBool__option_t bitvectorToBool;


std::ostream&
operator<<(std::ostream& os, BitblastMode mode)
{
  os << "BitblastMode::";
  switch(mode) {
    case BitblastMode::LAZY:
      os << "LAZY";
      break;
    case BitblastMode::EAGER:
      os << "EAGER";
      break;
    default:
        Unreachable();
  }
  return os;
}

BitblastMode
stringToBitblastMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "lazy")
  {
    return BitblastMode::LAZY;
  }
  else if (optarg == "eager")
  {
    return BitblastMode::EAGER;
  }
  else if (optarg == "help")
  {
    puts("Bit-blasting modes.\n"
         "Available modes for --bitblast are:\n"
         "+ lazy (default)\n"
         "  Separate boolean structure and term reasoning between the core SAT solver and\n"
         "  the bit-vector SAT solver.\n"
         "+ eager\n"
         "  Bitblast eagerly to bit-vector SAT solver.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --bitblast: `") +
                          optarg + "'.  Try --bitblast=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, BoolToBVMode mode)
{
  os << "BoolToBVMode::";
  switch(mode) {
    case BoolToBVMode::OFF:
      os << "OFF";
      break;
    case BoolToBVMode::ITE:
      os << "ITE";
      break;
    case BoolToBVMode::ALL:
      os << "ALL";
      break;
    default:
        Unreachable();
  }
  return os;
}

BoolToBVMode
stringToBoolToBVMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "off")
  {
    return BoolToBVMode::OFF;
  }
  else if (optarg == "ite")
  {
    return BoolToBVMode::ITE;
  }
  else if (optarg == "all")
  {
    return BoolToBVMode::ALL;
  }
  else if (optarg == "help")
  {
    puts("BoolToBV preprocessing pass modes.\n"
         "Available modes for --bool-to-bv are:\n"
         "+ off (default)\n"
         "  Don't push any booleans to width one bit-vectors.\n"
         "+ ite\n"
         "  Try to turn ITEs into BITVECTOR_ITE when possible. It can fail per-formula if\n"
         "  not all sub-formulas can be turned to bit-vectors.\n"
         "+ all\n"
         "  Force all booleans to be bit-vectors of width one except at the top level.\n"
         "  Most aggressive mode.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --bool-to-bv: `") +
                          optarg + "'.  Try --bool-to-bv=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, BvSlicerMode mode)
{
  os << "BvSlicerMode::";
  switch(mode) {
    case BvSlicerMode::ON:
      os << "ON";
      break;
    case BvSlicerMode::OFF:
      os << "OFF";
      break;
    case BvSlicerMode::AUTO:
      os << "AUTO";
      break;
    default:
        Unreachable();
  }
  return os;
}

BvSlicerMode
stringToBvSlicerMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "on")
  {
    return BvSlicerMode::ON;
  }
  else if (optarg == "off")
  {
    return BvSlicerMode::OFF;
  }
  else if (optarg == "auto")
  {
    return BvSlicerMode::AUTO;
  }
  else if (optarg == "help")
  {
    puts("Bit-vector equality slicer modes.\n"
         "Available modes for --bv-eq-slicer are:\n"
         "+ on\n"
         "  Turn slicer on.\n"
         "+ off (default)\n"
         "  Turn slicer off.\n"
         "+ auto\n"
         "  Turn slicer on if input has only equalities over core symbols.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --bv-eq-slicer: `") +
                          optarg + "'.  Try --bv-eq-slicer=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, BvOptimizeSatProof mode)
{
  os << "BvOptimizeSatProof::";
  switch(mode) {
    case BvOptimizeSatProof::NONE:
      os << "NONE";
      break;
    case BvOptimizeSatProof::PROOF:
      os << "PROOF";
      break;
    case BvOptimizeSatProof::FORMULA:
      os << "FORMULA";
      break;
    default:
        Unreachable();
  }
  return os;
}

BvOptimizeSatProof
stringToBvOptimizeSatProof(const std::string& option, const std::string& optarg)
{
  if (optarg == "none")
  {
    return BvOptimizeSatProof::NONE;
  }
  else if (optarg == "proof")
  {
    return BvOptimizeSatProof::PROOF;
  }
  else if (optarg == "formula")
  {
    return BvOptimizeSatProof::FORMULA;
  }
  else if (optarg == "help")
  {
    puts("SAT proof optimization level.\n"
         "Available modes for --bv-optimize-sat-proof are:\n"
         "+ none\n"
         "  Do not optimize the SAT proof.\n"
         "+ proof\n"
         "  Use drat-trim to shrink the SAT proof.\n"
         "+ formula (default)\n"
         "  Use drat-trim to shrink the SAT proof and formula.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --bv-optimize-sat-proof: `") +
                          optarg + "'.  Try --bv-optimize-sat-proof=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, BvProofFormat mode)
{
  os << "BvProofFormat::";
  switch(mode) {
    case BvProofFormat::ER:
      os << "ER";
      break;
    case BvProofFormat::DRAT:
      os << "DRAT";
      break;
    case BvProofFormat::LRAT:
      os << "LRAT";
      break;
    default:
        Unreachable();
  }
  return os;
}

BvProofFormat
stringToBvProofFormat(const std::string& option, const std::string& optarg)
{
  if (optarg == "er")
  {
    return BvProofFormat::ER;
  }
  else if (optarg == "drat")
  {
    return BvProofFormat::DRAT;
  }
  else if (optarg == "lrat")
  {
    return BvProofFormat::LRAT;
  }
  else if (optarg == "help")
  {
    puts("Bit-vector proof formats.\n"
         "Available modes for --bv-proof-format are:\n"
         "+ er (default)\n"
         "  Extended Resolution, i.e. resolution with new variable definitions.\n"
         "+ drat\n"
         "  Deletion and Resolution Asymmetric Tautology Additions.\n"
         "+ lrat\n"
         "  DRAT with unit propagation hints to accelerate checking.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --bv-proof-format: `") +
                          optarg + "'.  Try --bv-proof-format=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, SatSolverMode mode)
{
  os << "SatSolverMode::";
  switch(mode) {
    case SatSolverMode::MINISAT:
      os << "MINISAT";
      break;
    case SatSolverMode::CRYPTOMINISAT:
      os << "CRYPTOMINISAT";
      break;
    case SatSolverMode::CADICAL:
      os << "CADICAL";
      break;
    case SatSolverMode::KISSAT:
      os << "KISSAT";
      break;
    default:
        Unreachable();
  }
  return os;
}

SatSolverMode
stringToSatSolverMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "minisat")
  {
    return SatSolverMode::MINISAT;
  }
  else if (optarg == "cryptominisat")
  {
    return SatSolverMode::CRYPTOMINISAT;
  }
  else if (optarg == "cadical")
  {
    return SatSolverMode::CADICAL;
  }
  else if (optarg == "kissat")
  {
    return SatSolverMode::KISSAT;
  }
  else if (optarg == "help")
  {
    puts("SAT solver for bit-blasting backend.\n"
         "Available modes for --bv-sat-solver are:\n"
         "+ minisat (default)\n"
         "+ cryptominisat\n"
         "+ cadical\n"
         "+ kissat\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --bv-sat-solver: `") +
                          optarg + "'.  Try --bv-sat-solver=help.");
  }
}


}  // namespace options
}  // namespace CVC4
