/*********************                                                        */
/*! \file module_template.h
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2020 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Contains code for handling command-line options.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.h file.
 **/

#include "cvc4_private.h"

#ifndef CVC4__OPTIONS__ARRAYS_H
#define CVC4__OPTIONS__ARRAYS_H

#include "options/options.h"




#define CVC4_OPTIONS__ARRAYS__FOR_OPTION_HOLDER \
  arraysConfig__option_t::type arraysConfig;\
  bool arraysConfig__setByUser__; \
  arraysEagerIndexSplitting__option_t::type arraysEagerIndexSplitting;\
  bool arraysEagerIndexSplitting__setByUser__; \
  arraysEagerLemmas__option_t::type arraysEagerLemmas;\
  bool arraysEagerLemmas__setByUser__; \
  arraysLazyRIntro1__option_t::type arraysLazyRIntro1;\
  bool arraysLazyRIntro1__setByUser__; \
  arraysModelBased__option_t::type arraysModelBased;\
  bool arraysModelBased__setByUser__; \
  arraysOptimizeLinear__option_t::type arraysOptimizeLinear;\
  bool arraysOptimizeLinear__setByUser__; \
  arraysPropagate__option_t::type arraysPropagate;\
  bool arraysPropagate__setByUser__; \
  arraysReduceSharing__option_t::type arraysReduceSharing;\
  bool arraysReduceSharing__setByUser__; \
  arraysWeakEquivalence__option_t::type arraysWeakEquivalence;\
  bool arraysWeakEquivalence__setByUser__;


namespace CVC4 {

namespace options {



extern struct CVC4_PUBLIC arraysConfig__option_t
{
  typedef int type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} arraysConfig CVC4_PUBLIC;
extern struct CVC4_PUBLIC arraysEagerIndexSplitting__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} arraysEagerIndexSplitting CVC4_PUBLIC;
extern struct CVC4_PUBLIC arraysEagerLemmas__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} arraysEagerLemmas CVC4_PUBLIC;
extern struct CVC4_PUBLIC arraysLazyRIntro1__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} arraysLazyRIntro1 CVC4_PUBLIC;
extern struct CVC4_PUBLIC arraysModelBased__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} arraysModelBased CVC4_PUBLIC;
extern struct CVC4_PUBLIC arraysOptimizeLinear__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} arraysOptimizeLinear CVC4_PUBLIC;
extern struct CVC4_PUBLIC arraysPropagate__option_t
{
  typedef int type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} arraysPropagate CVC4_PUBLIC;
extern struct CVC4_PUBLIC arraysReduceSharing__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} arraysReduceSharing CVC4_PUBLIC;
extern struct CVC4_PUBLIC arraysWeakEquivalence__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} arraysWeakEquivalence CVC4_PUBLIC;

}  // namespace options

template <> void Options::set(
    options::arraysConfig__option_t,
    const options::arraysConfig__option_t::type& x);
template <> const options::arraysConfig__option_t::type& Options::operator[](
    options::arraysConfig__option_t) const;
template <> bool Options::wasSetByUser(options::arraysConfig__option_t) const;
template <> void Options::assign(
    options::arraysConfig__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::arraysEagerIndexSplitting__option_t,
    const options::arraysEagerIndexSplitting__option_t::type& x);
template <> const options::arraysEagerIndexSplitting__option_t::type& Options::operator[](
    options::arraysEagerIndexSplitting__option_t) const;
template <> bool Options::wasSetByUser(options::arraysEagerIndexSplitting__option_t) const;
template <> void Options::assignBool(
    options::arraysEagerIndexSplitting__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::arraysEagerLemmas__option_t,
    const options::arraysEagerLemmas__option_t::type& x);
template <> const options::arraysEagerLemmas__option_t::type& Options::operator[](
    options::arraysEagerLemmas__option_t) const;
template <> bool Options::wasSetByUser(options::arraysEagerLemmas__option_t) const;
template <> void Options::assignBool(
    options::arraysEagerLemmas__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::arraysLazyRIntro1__option_t,
    const options::arraysLazyRIntro1__option_t::type& x);
template <> const options::arraysLazyRIntro1__option_t::type& Options::operator[](
    options::arraysLazyRIntro1__option_t) const;
template <> bool Options::wasSetByUser(options::arraysLazyRIntro1__option_t) const;
template <> void Options::assignBool(
    options::arraysLazyRIntro1__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::arraysModelBased__option_t,
    const options::arraysModelBased__option_t::type& x);
template <> const options::arraysModelBased__option_t::type& Options::operator[](
    options::arraysModelBased__option_t) const;
template <> bool Options::wasSetByUser(options::arraysModelBased__option_t) const;
template <> void Options::assignBool(
    options::arraysModelBased__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::arraysOptimizeLinear__option_t,
    const options::arraysOptimizeLinear__option_t::type& x);
template <> const options::arraysOptimizeLinear__option_t::type& Options::operator[](
    options::arraysOptimizeLinear__option_t) const;
template <> bool Options::wasSetByUser(options::arraysOptimizeLinear__option_t) const;
template <> void Options::assignBool(
    options::arraysOptimizeLinear__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::arraysPropagate__option_t,
    const options::arraysPropagate__option_t::type& x);
template <> const options::arraysPropagate__option_t::type& Options::operator[](
    options::arraysPropagate__option_t) const;
template <> bool Options::wasSetByUser(options::arraysPropagate__option_t) const;
template <> void Options::assign(
    options::arraysPropagate__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::arraysReduceSharing__option_t,
    const options::arraysReduceSharing__option_t::type& x);
template <> const options::arraysReduceSharing__option_t::type& Options::operator[](
    options::arraysReduceSharing__option_t) const;
template <> bool Options::wasSetByUser(options::arraysReduceSharing__option_t) const;
template <> void Options::assignBool(
    options::arraysReduceSharing__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::arraysWeakEquivalence__option_t,
    const options::arraysWeakEquivalence__option_t::type& x);
template <> const options::arraysWeakEquivalence__option_t::type& Options::operator[](
    options::arraysWeakEquivalence__option_t) const;
template <> bool Options::wasSetByUser(options::arraysWeakEquivalence__option_t) const;
template <> void Options::assignBool(
    options::arraysWeakEquivalence__option_t,
    std::string option,
    bool value);


namespace options {

inline arraysConfig__option_t::type arraysConfig__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool arraysConfig__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void arraysConfig__option_t::set(const arraysConfig__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline arraysEagerIndexSplitting__option_t::type arraysEagerIndexSplitting__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool arraysEagerIndexSplitting__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void arraysEagerIndexSplitting__option_t::set(const arraysEagerIndexSplitting__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline arraysEagerLemmas__option_t::type arraysEagerLemmas__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool arraysEagerLemmas__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void arraysEagerLemmas__option_t::set(const arraysEagerLemmas__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline arraysLazyRIntro1__option_t::type arraysLazyRIntro1__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool arraysLazyRIntro1__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void arraysLazyRIntro1__option_t::set(const arraysLazyRIntro1__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline arraysModelBased__option_t::type arraysModelBased__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool arraysModelBased__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void arraysModelBased__option_t::set(const arraysModelBased__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline arraysOptimizeLinear__option_t::type arraysOptimizeLinear__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool arraysOptimizeLinear__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void arraysOptimizeLinear__option_t::set(const arraysOptimizeLinear__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline arraysPropagate__option_t::type arraysPropagate__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool arraysPropagate__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void arraysPropagate__option_t::set(const arraysPropagate__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline arraysReduceSharing__option_t::type arraysReduceSharing__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool arraysReduceSharing__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void arraysReduceSharing__option_t::set(const arraysReduceSharing__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline arraysWeakEquivalence__option_t::type arraysWeakEquivalence__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool arraysWeakEquivalence__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void arraysWeakEquivalence__option_t::set(const arraysWeakEquivalence__option_t::type& v)
{
  Options::current()->set(*this, v);
}

}  // namespace options
}  // namespace CVC4

#endif /* CVC4__OPTIONS__ARRAYS_H */
