/*********************                                                        */
/*! \file module_template.cpp
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2020 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Option template for option modules.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.cpp file.
 **/

#include "options/options_holder.h"
#include "base/check.h"

namespace CVC4 {

template <> void Options::set(
    options::arraysConfig__option_t,
    const options::arraysConfig__option_t::type& x)
{
  d_holder->arraysConfig = x;
}
template <> const options::arraysConfig__option_t::type& Options::operator[](
    options::arraysConfig__option_t) const
{
  return d_holder->arraysConfig;
}
template <> bool Options::wasSetByUser(options::arraysConfig__option_t) const
{
  return d_holder->arraysConfig__setByUser__;
}
template <> void Options::set(
    options::arraysEagerIndexSplitting__option_t,
    const options::arraysEagerIndexSplitting__option_t::type& x)
{
  d_holder->arraysEagerIndexSplitting = x;
}
template <> const options::arraysEagerIndexSplitting__option_t::type& Options::operator[](
    options::arraysEagerIndexSplitting__option_t) const
{
  return d_holder->arraysEagerIndexSplitting;
}
template <> bool Options::wasSetByUser(options::arraysEagerIndexSplitting__option_t) const
{
  return d_holder->arraysEagerIndexSplitting__setByUser__;
}
template <> void Options::set(
    options::arraysEagerLemmas__option_t,
    const options::arraysEagerLemmas__option_t::type& x)
{
  d_holder->arraysEagerLemmas = x;
}
template <> const options::arraysEagerLemmas__option_t::type& Options::operator[](
    options::arraysEagerLemmas__option_t) const
{
  return d_holder->arraysEagerLemmas;
}
template <> bool Options::wasSetByUser(options::arraysEagerLemmas__option_t) const
{
  return d_holder->arraysEagerLemmas__setByUser__;
}
template <> void Options::set(
    options::arraysLazyRIntro1__option_t,
    const options::arraysLazyRIntro1__option_t::type& x)
{
  d_holder->arraysLazyRIntro1 = x;
}
template <> const options::arraysLazyRIntro1__option_t::type& Options::operator[](
    options::arraysLazyRIntro1__option_t) const
{
  return d_holder->arraysLazyRIntro1;
}
template <> bool Options::wasSetByUser(options::arraysLazyRIntro1__option_t) const
{
  return d_holder->arraysLazyRIntro1__setByUser__;
}
template <> void Options::set(
    options::arraysModelBased__option_t,
    const options::arraysModelBased__option_t::type& x)
{
  d_holder->arraysModelBased = x;
}
template <> const options::arraysModelBased__option_t::type& Options::operator[](
    options::arraysModelBased__option_t) const
{
  return d_holder->arraysModelBased;
}
template <> bool Options::wasSetByUser(options::arraysModelBased__option_t) const
{
  return d_holder->arraysModelBased__setByUser__;
}
template <> void Options::set(
    options::arraysOptimizeLinear__option_t,
    const options::arraysOptimizeLinear__option_t::type& x)
{
  d_holder->arraysOptimizeLinear = x;
}
template <> const options::arraysOptimizeLinear__option_t::type& Options::operator[](
    options::arraysOptimizeLinear__option_t) const
{
  return d_holder->arraysOptimizeLinear;
}
template <> bool Options::wasSetByUser(options::arraysOptimizeLinear__option_t) const
{
  return d_holder->arraysOptimizeLinear__setByUser__;
}
template <> void Options::set(
    options::arraysPropagate__option_t,
    const options::arraysPropagate__option_t::type& x)
{
  d_holder->arraysPropagate = x;
}
template <> const options::arraysPropagate__option_t::type& Options::operator[](
    options::arraysPropagate__option_t) const
{
  return d_holder->arraysPropagate;
}
template <> bool Options::wasSetByUser(options::arraysPropagate__option_t) const
{
  return d_holder->arraysPropagate__setByUser__;
}
template <> void Options::set(
    options::arraysReduceSharing__option_t,
    const options::arraysReduceSharing__option_t::type& x)
{
  d_holder->arraysReduceSharing = x;
}
template <> const options::arraysReduceSharing__option_t::type& Options::operator[](
    options::arraysReduceSharing__option_t) const
{
  return d_holder->arraysReduceSharing;
}
template <> bool Options::wasSetByUser(options::arraysReduceSharing__option_t) const
{
  return d_holder->arraysReduceSharing__setByUser__;
}
template <> void Options::set(
    options::arraysWeakEquivalence__option_t,
    const options::arraysWeakEquivalence__option_t::type& x)
{
  d_holder->arraysWeakEquivalence = x;
}
template <> const options::arraysWeakEquivalence__option_t::type& Options::operator[](
    options::arraysWeakEquivalence__option_t) const
{
  return d_holder->arraysWeakEquivalence;
}
template <> bool Options::wasSetByUser(options::arraysWeakEquivalence__option_t) const
{
  return d_holder->arraysWeakEquivalence__setByUser__;
}


namespace options {

struct arraysConfig__option_t arraysConfig;
struct arraysEagerIndexSplitting__option_t arraysEagerIndexSplitting;
struct arraysEagerLemmas__option_t arraysEagerLemmas;
struct arraysLazyRIntro1__option_t arraysLazyRIntro1;
struct arraysModelBased__option_t arraysModelBased;
struct arraysOptimizeLinear__option_t arraysOptimizeLinear;
struct arraysPropagate__option_t arraysPropagate;
struct arraysReduceSharing__option_t arraysReduceSharing;
struct arraysWeakEquivalence__option_t arraysWeakEquivalence;



}  // namespace options
}  // namespace CVC4
