/*********************                                                        */
/** metakind.h
 **
 ** Copyright 2010-2014  New York University and The University of Iowa,
 ** and as below.
 **
 ** This header file automatically generated by:
 **
 **     /build/cvc4/src/cvc5-1.8/src/expr/mkmetakind /build/cvc4/src/cvc5-1.8/src/expr/metakind_template.cpp /build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds /build/cvc4/src/cvc5-1.8/src/theory/booleans/kinds /build/cvc4/src/cvc5-1.8/src/theory/uf/kinds /build/cvc4/src/cvc5-1.8/src/theory/arith/kinds /build/cvc4/src/cvc5-1.8/src/theory/bv/kinds /build/cvc4/src/cvc5-1.8/src/theory/fp/kinds /build/cvc4/src/cvc5-1.8/src/theory/arrays/kinds /build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds /build/cvc4/src/cvc5-1.8/src/theory/sep/kinds /build/cvc4/src/cvc5-1.8/src/theory/sets/kinds /build/cvc4/src/cvc5-1.8/src/theory/strings/kinds /build/cvc4/src/cvc5-1.8/src/theory/quantifiers/kinds
 **
 ** for the CVC4 project.
 **/

/*********************                                                        */
/*! \file metakind_template.cpp
 ** \verbatim
 ** Top contributors (to current version):
 **   Morgan Deters, Andres Noetzli, Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2020 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief [[ Add one-line brief description here ]]
 **
 ** [[ Add lengthier description here ]]
 ** \todo document this file
 **/

#include "expr/metakind.h"

#include <iostream>

namespace CVC4 {
namespace kind {

/**
 * Get the metakind for a particular kind.
 */
MetaKind metaKindOf(Kind k) {
  static const MetaKind metaKinds[] = {
    metakind::INVALID, /* UNDEFINED_KIND */
    metakind::INVALID, /* NULL_EXPR */

    /* from builtin */
    metakind::VARIABLE, /* SORT_TAG */
    metakind::PARAMETERIZED, /* SORT_TYPE */
    metakind::CONSTANT, /* UNINTERPRETED_CONSTANT */
    metakind::CONSTANT, /* ABSTRACT_VALUE */
    metakind::CONSTANT, /* BUILTIN */
    metakind::OPERATOR, /* EQUAL */
    metakind::OPERATOR, /* DISTINCT */
    metakind::VARIABLE, /* VARIABLE */
    metakind::VARIABLE, /* BOUND_VARIABLE */
    metakind::VARIABLE, /* SKOLEM */
    metakind::OPERATOR, /* SEXPR */
    metakind::OPERATOR, /* LAMBDA */
    metakind::OPERATOR, /* WITNESS */
    metakind::CONSTANT, /* TYPE_CONSTANT */
    metakind::OPERATOR, /* FUNCTION_TYPE */
    metakind::OPERATOR, /* SEXPR_TYPE */

    /* from booleans */
    metakind::CONSTANT, /* CONST_BOOLEAN */
    metakind::OPERATOR, /* NOT */
    metakind::OPERATOR, /* AND */
    metakind::OPERATOR, /* IMPLIES */
    metakind::OPERATOR, /* OR */
    metakind::OPERATOR, /* XOR */
    metakind::OPERATOR, /* ITE */

    /* from uf */
    metakind::PARAMETERIZED, /* APPLY_UF */
    metakind::VARIABLE, /* BOOLEAN_TERM_VARIABLE */
    metakind::OPERATOR, /* CARDINALITY_CONSTRAINT */
    metakind::OPERATOR, /* COMBINED_CARDINALITY_CONSTRAINT */
    metakind::PARAMETERIZED, /* PARTIAL_APPLY_UF */
    metakind::OPERATOR, /* CARDINALITY_VALUE */
    metakind::OPERATOR, /* HO_APPLY */

    /* from arith */
    metakind::OPERATOR, /* PLUS */
    metakind::OPERATOR, /* MULT */
    metakind::OPERATOR, /* NONLINEAR_MULT */
    metakind::OPERATOR, /* MINUS */
    metakind::OPERATOR, /* UMINUS */
    metakind::OPERATOR, /* DIVISION */
    metakind::OPERATOR, /* DIVISION_TOTAL */
    metakind::OPERATOR, /* INTS_DIVISION */
    metakind::OPERATOR, /* INTS_DIVISION_TOTAL */
    metakind::OPERATOR, /* INTS_MODULUS */
    metakind::OPERATOR, /* INTS_MODULUS_TOTAL */
    metakind::OPERATOR, /* ABS */
    metakind::PARAMETERIZED, /* DIVISIBLE */
    metakind::OPERATOR, /* POW */
    metakind::OPERATOR, /* EXPONENTIAL */
    metakind::OPERATOR, /* SINE */
    metakind::OPERATOR, /* COSINE */
    metakind::OPERATOR, /* TANGENT */
    metakind::OPERATOR, /* COSECANT */
    metakind::OPERATOR, /* SECANT */
    metakind::OPERATOR, /* COTANGENT */
    metakind::OPERATOR, /* ARCSINE */
    metakind::OPERATOR, /* ARCCOSINE */
    metakind::OPERATOR, /* ARCTANGENT */
    metakind::OPERATOR, /* ARCCOSECANT */
    metakind::OPERATOR, /* ARCSECANT */
    metakind::OPERATOR, /* ARCCOTANGENT */
    metakind::OPERATOR, /* SQRT */
    metakind::CONSTANT, /* DIVISIBLE_OP */
    metakind::CONSTANT, /* CONST_RATIONAL */
    metakind::OPERATOR, /* LT */
    metakind::OPERATOR, /* LEQ */
    metakind::OPERATOR, /* GT */
    metakind::OPERATOR, /* GEQ */
    metakind::OPERATOR, /* IS_INTEGER */
    metakind::OPERATOR, /* TO_INTEGER */
    metakind::OPERATOR, /* TO_REAL */
    metakind::NULLARY_OPERATOR, /* PI */

    /* from bv */
    metakind::CONSTANT, /* BITVECTOR_TYPE */
    metakind::CONSTANT, /* CONST_BITVECTOR */
    metakind::OPERATOR, /* BITVECTOR_CONCAT */
    metakind::OPERATOR, /* BITVECTOR_AND */
    metakind::OPERATOR, /* BITVECTOR_COMP */
    metakind::OPERATOR, /* BITVECTOR_OR */
    metakind::OPERATOR, /* BITVECTOR_XOR */
    metakind::OPERATOR, /* BITVECTOR_NOT */
    metakind::OPERATOR, /* BITVECTOR_NAND */
    metakind::OPERATOR, /* BITVECTOR_NOR */
    metakind::OPERATOR, /* BITVECTOR_XNOR */
    metakind::OPERATOR, /* BITVECTOR_MULT */
    metakind::OPERATOR, /* BITVECTOR_NEG */
    metakind::OPERATOR, /* BITVECTOR_PLUS */
    metakind::OPERATOR, /* BITVECTOR_SUB */
    metakind::OPERATOR, /* BITVECTOR_UDIV */
    metakind::OPERATOR, /* BITVECTOR_UREM */
    metakind::OPERATOR, /* BITVECTOR_SDIV */
    metakind::OPERATOR, /* BITVECTOR_SMOD */
    metakind::OPERATOR, /* BITVECTOR_SREM */
    metakind::OPERATOR, /* BITVECTOR_UDIV_TOTAL */
    metakind::OPERATOR, /* BITVECTOR_UREM_TOTAL */
    metakind::OPERATOR, /* BITVECTOR_ASHR */
    metakind::OPERATOR, /* BITVECTOR_LSHR */
    metakind::OPERATOR, /* BITVECTOR_SHL */
    metakind::OPERATOR, /* BITVECTOR_ULE */
    metakind::OPERATOR, /* BITVECTOR_ULT */
    metakind::OPERATOR, /* BITVECTOR_UGE */
    metakind::OPERATOR, /* BITVECTOR_UGT */
    metakind::OPERATOR, /* BITVECTOR_SLE */
    metakind::OPERATOR, /* BITVECTOR_SLT */
    metakind::OPERATOR, /* BITVECTOR_SGE */
    metakind::OPERATOR, /* BITVECTOR_SGT */
    metakind::OPERATOR, /* BITVECTOR_ULTBV */
    metakind::OPERATOR, /* BITVECTOR_SLTBV */
    metakind::OPERATOR, /* BITVECTOR_REDAND */
    metakind::OPERATOR, /* BITVECTOR_REDOR */
    metakind::OPERATOR, /* BITVECTOR_ITE */
    metakind::OPERATOR, /* BITVECTOR_TO_NAT */
    metakind::OPERATOR, /* BITVECTOR_ACKERMANNIZE_UDIV */
    metakind::OPERATOR, /* BITVECTOR_ACKERMANNIZE_UREM */
    metakind::OPERATOR, /* BITVECTOR_EAGER_ATOM */
    metakind::CONSTANT, /* BITVECTOR_BITOF_OP */
    metakind::PARAMETERIZED, /* BITVECTOR_BITOF */
    metakind::CONSTANT, /* BITVECTOR_EXTRACT_OP */
    metakind::PARAMETERIZED, /* BITVECTOR_EXTRACT */
    metakind::CONSTANT, /* BITVECTOR_REPEAT_OP */
    metakind::PARAMETERIZED, /* BITVECTOR_REPEAT */
    metakind::CONSTANT, /* BITVECTOR_ROTATE_LEFT_OP */
    metakind::PARAMETERIZED, /* BITVECTOR_ROTATE_LEFT */
    metakind::CONSTANT, /* BITVECTOR_ROTATE_RIGHT_OP */
    metakind::PARAMETERIZED, /* BITVECTOR_ROTATE_RIGHT */
    metakind::CONSTANT, /* BITVECTOR_SIGN_EXTEND_OP */
    metakind::PARAMETERIZED, /* BITVECTOR_SIGN_EXTEND */
    metakind::CONSTANT, /* BITVECTOR_ZERO_EXTEND_OP */
    metakind::PARAMETERIZED, /* BITVECTOR_ZERO_EXTEND */
    metakind::CONSTANT, /* INT_TO_BITVECTOR_OP */
    metakind::PARAMETERIZED, /* INT_TO_BITVECTOR */

    /* from fp */
    metakind::CONSTANT, /* CONST_FLOATINGPOINT */
    metakind::CONSTANT, /* CONST_ROUNDINGMODE */
    metakind::CONSTANT, /* FLOATINGPOINT_TYPE */
    metakind::OPERATOR, /* FLOATINGPOINT_FP */
    metakind::OPERATOR, /* FLOATINGPOINT_EQ */
    metakind::OPERATOR, /* FLOATINGPOINT_ABS */
    metakind::OPERATOR, /* FLOATINGPOINT_NEG */
    metakind::OPERATOR, /* FLOATINGPOINT_PLUS */
    metakind::OPERATOR, /* FLOATINGPOINT_SUB */
    metakind::OPERATOR, /* FLOATINGPOINT_MULT */
    metakind::OPERATOR, /* FLOATINGPOINT_DIV */
    metakind::OPERATOR, /* FLOATINGPOINT_FMA */
    metakind::OPERATOR, /* FLOATINGPOINT_SQRT */
    metakind::OPERATOR, /* FLOATINGPOINT_REM */
    metakind::OPERATOR, /* FLOATINGPOINT_RTI */
    metakind::OPERATOR, /* FLOATINGPOINT_MIN */
    metakind::OPERATOR, /* FLOATINGPOINT_MAX */
    metakind::OPERATOR, /* FLOATINGPOINT_MIN_TOTAL */
    metakind::OPERATOR, /* FLOATINGPOINT_MAX_TOTAL */
    metakind::OPERATOR, /* FLOATINGPOINT_LEQ */
    metakind::OPERATOR, /* FLOATINGPOINT_LT */
    metakind::OPERATOR, /* FLOATINGPOINT_GEQ */
    metakind::OPERATOR, /* FLOATINGPOINT_GT */
    metakind::OPERATOR, /* FLOATINGPOINT_ISN */
    metakind::OPERATOR, /* FLOATINGPOINT_ISSN */
    metakind::OPERATOR, /* FLOATINGPOINT_ISZ */
    metakind::OPERATOR, /* FLOATINGPOINT_ISINF */
    metakind::OPERATOR, /* FLOATINGPOINT_ISNAN */
    metakind::OPERATOR, /* FLOATINGPOINT_ISNEG */
    metakind::OPERATOR, /* FLOATINGPOINT_ISPOS */
    metakind::CONSTANT, /* FLOATINGPOINT_TO_FP_IEEE_BITVECTOR_OP */
    metakind::PARAMETERIZED, /* FLOATINGPOINT_TO_FP_IEEE_BITVECTOR */
    metakind::CONSTANT, /* FLOATINGPOINT_TO_FP_FLOATINGPOINT_OP */
    metakind::PARAMETERIZED, /* FLOATINGPOINT_TO_FP_FLOATINGPOINT */
    metakind::CONSTANT, /* FLOATINGPOINT_TO_FP_REAL_OP */
    metakind::PARAMETERIZED, /* FLOATINGPOINT_TO_FP_REAL */
    metakind::CONSTANT, /* FLOATINGPOINT_TO_FP_SIGNED_BITVECTOR_OP */
    metakind::PARAMETERIZED, /* FLOATINGPOINT_TO_FP_SIGNED_BITVECTOR */
    metakind::CONSTANT, /* FLOATINGPOINT_TO_FP_UNSIGNED_BITVECTOR_OP */
    metakind::PARAMETERIZED, /* FLOATINGPOINT_TO_FP_UNSIGNED_BITVECTOR */
    metakind::CONSTANT, /* FLOATINGPOINT_TO_FP_GENERIC_OP */
    metakind::PARAMETERIZED, /* FLOATINGPOINT_TO_FP_GENERIC */
    metakind::CONSTANT, /* FLOATINGPOINT_TO_UBV_OP */
    metakind::PARAMETERIZED, /* FLOATINGPOINT_TO_UBV */
    metakind::CONSTANT, /* FLOATINGPOINT_TO_UBV_TOTAL_OP */
    metakind::PARAMETERIZED, /* FLOATINGPOINT_TO_UBV_TOTAL */
    metakind::CONSTANT, /* FLOATINGPOINT_TO_SBV_OP */
    metakind::PARAMETERIZED, /* FLOATINGPOINT_TO_SBV */
    metakind::CONSTANT, /* FLOATINGPOINT_TO_SBV_TOTAL_OP */
    metakind::PARAMETERIZED, /* FLOATINGPOINT_TO_SBV_TOTAL */
    metakind::OPERATOR, /* FLOATINGPOINT_TO_REAL */
    metakind::OPERATOR, /* FLOATINGPOINT_TO_REAL_TOTAL */
    metakind::OPERATOR, /* FLOATINGPOINT_COMPONENT_NAN */
    metakind::OPERATOR, /* FLOATINGPOINT_COMPONENT_INF */
    metakind::OPERATOR, /* FLOATINGPOINT_COMPONENT_ZERO */
    metakind::OPERATOR, /* FLOATINGPOINT_COMPONENT_SIGN */
    metakind::OPERATOR, /* FLOATINGPOINT_COMPONENT_EXPONENT */
    metakind::OPERATOR, /* FLOATINGPOINT_COMPONENT_SIGNIFICAND */
    metakind::OPERATOR, /* ROUNDINGMODE_BITBLAST */

    /* from arrays */
    metakind::OPERATOR, /* ARRAY_TYPE */
    metakind::OPERATOR, /* SELECT */
    metakind::OPERATOR, /* STORE */
    metakind::CONSTANT, /* STORE_ALL */
    metakind::OPERATOR, /* ARR_TABLE_FUN */
    metakind::OPERATOR, /* ARRAY_LAMBDA */
    metakind::OPERATOR, /* PARTIAL_SELECT_0 */
    metakind::OPERATOR, /* PARTIAL_SELECT_1 */

    /* from datatypes */
    metakind::OPERATOR, /* CONSTRUCTOR_TYPE */
    metakind::OPERATOR, /* SELECTOR_TYPE */
    metakind::OPERATOR, /* TESTER_TYPE */
    metakind::PARAMETERIZED, /* APPLY_CONSTRUCTOR */
    metakind::PARAMETERIZED, /* APPLY_SELECTOR */
    metakind::PARAMETERIZED, /* APPLY_SELECTOR_TOTAL */
    metakind::PARAMETERIZED, /* APPLY_TESTER */
    metakind::CONSTANT, /* DATATYPE_TYPE */
    metakind::OPERATOR, /* PARAMETRIC_DATATYPE */
    metakind::PARAMETERIZED, /* APPLY_TYPE_ASCRIPTION */
    metakind::CONSTANT, /* ASCRIPTION_TYPE */
    metakind::CONSTANT, /* TUPLE_UPDATE_OP */
    metakind::PARAMETERIZED, /* TUPLE_UPDATE */
    metakind::CONSTANT, /* RECORD_UPDATE_OP */
    metakind::PARAMETERIZED, /* RECORD_UPDATE */
    metakind::OPERATOR, /* DT_SIZE */
    metakind::OPERATOR, /* DT_HEIGHT_BOUND */
    metakind::OPERATOR, /* DT_SIZE_BOUND */
    metakind::OPERATOR, /* DT_SYGUS_BOUND */
    metakind::OPERATOR, /* DT_SYGUS_EVAL */
    metakind::OPERATOR, /* MATCH */
    metakind::OPERATOR, /* MATCH_CASE */
    metakind::OPERATOR, /* MATCH_BIND_CASE */

    /* from sep */
    metakind::NULLARY_OPERATOR, /* SEP_NIL */
    metakind::OPERATOR, /* SEP_EMP */
    metakind::OPERATOR, /* SEP_PTO */
    metakind::OPERATOR, /* SEP_STAR */
    metakind::OPERATOR, /* SEP_WAND */
    metakind::OPERATOR, /* SEP_LABEL */

    /* from sets */
    metakind::CONSTANT, /* EMPTYSET */
    metakind::OPERATOR, /* SET_TYPE */
    metakind::OPERATOR, /* UNION */
    metakind::OPERATOR, /* INTERSECTION */
    metakind::OPERATOR, /* SETMINUS */
    metakind::OPERATOR, /* SUBSET */
    metakind::OPERATOR, /* MEMBER */
    metakind::OPERATOR, /* SINGLETON */
    metakind::OPERATOR, /* INSERT */
    metakind::OPERATOR, /* CARD */
    metakind::OPERATOR, /* COMPLEMENT */
    metakind::NULLARY_OPERATOR, /* UNIVERSE_SET */
    metakind::OPERATOR, /* COMPREHENSION */
    metakind::OPERATOR, /* CHOOSE */
    metakind::OPERATOR, /* JOIN */
    metakind::OPERATOR, /* PRODUCT */
    metakind::OPERATOR, /* TRANSPOSE */
    metakind::OPERATOR, /* TCLOSURE */
    metakind::OPERATOR, /* JOIN_IMAGE */
    metakind::OPERATOR, /* IDEN */

    /* from strings */
    metakind::OPERATOR, /* STRING_CONCAT */
    metakind::OPERATOR, /* STRING_IN_REGEXP */
    metakind::OPERATOR, /* STRING_LENGTH */
    metakind::OPERATOR, /* STRING_SUBSTR */
    metakind::OPERATOR, /* STRING_CHARAT */
    metakind::OPERATOR, /* STRING_STRCTN */
    metakind::OPERATOR, /* STRING_LT */
    metakind::OPERATOR, /* STRING_LEQ */
    metakind::OPERATOR, /* STRING_STRIDOF */
    metakind::OPERATOR, /* STRING_STRREPL */
    metakind::OPERATOR, /* STRING_STRREPLALL */
    metakind::OPERATOR, /* STRING_REPLACE_RE */
    metakind::OPERATOR, /* STRING_REPLACE_RE_ALL */
    metakind::OPERATOR, /* STRING_PREFIX */
    metakind::OPERATOR, /* STRING_SUFFIX */
    metakind::OPERATOR, /* STRING_IS_DIGIT */
    metakind::OPERATOR, /* STRING_ITOS */
    metakind::OPERATOR, /* STRING_STOI */
    metakind::OPERATOR, /* STRING_TO_CODE */
    metakind::OPERATOR, /* STRING_FROM_CODE */
    metakind::OPERATOR, /* STRING_TOLOWER */
    metakind::OPERATOR, /* STRING_TOUPPER */
    metakind::OPERATOR, /* STRING_REV */
    metakind::CONSTANT, /* CONST_STRING */
    metakind::OPERATOR, /* SEQUENCE_TYPE */
    metakind::CONSTANT, /* CONST_SEQUENCE */
    metakind::OPERATOR, /* SEQ_UNIT */
    metakind::OPERATOR, /* STRING_TO_REGEXP */
    metakind::OPERATOR, /* REGEXP_CONCAT */
    metakind::OPERATOR, /* REGEXP_UNION */
    metakind::OPERATOR, /* REGEXP_INTER */
    metakind::OPERATOR, /* REGEXP_DIFF */
    metakind::OPERATOR, /* REGEXP_STAR */
    metakind::OPERATOR, /* REGEXP_PLUS */
    metakind::OPERATOR, /* REGEXP_OPT */
    metakind::OPERATOR, /* REGEXP_RANGE */
    metakind::OPERATOR, /* REGEXP_COMPLEMENT */
    metakind::OPERATOR, /* REGEXP_EMPTY */
    metakind::OPERATOR, /* REGEXP_SIGMA */
    metakind::CONSTANT, /* REGEXP_REPEAT_OP */
    metakind::PARAMETERIZED, /* REGEXP_REPEAT */
    metakind::CONSTANT, /* REGEXP_LOOP_OP */
    metakind::PARAMETERIZED, /* REGEXP_LOOP */
    metakind::OPERATOR, /* REGEXP_RV */

    /* from quantifiers */
    metakind::OPERATOR, /* FORALL */
    metakind::OPERATOR, /* EXISTS */
    metakind::VARIABLE, /* INST_CONSTANT */
    metakind::OPERATOR, /* BOUND_VAR_LIST */
    metakind::OPERATOR, /* INST_PATTERN */
    metakind::OPERATOR, /* INST_NO_PATTERN */
    metakind::OPERATOR, /* INST_ATTRIBUTE */
    metakind::OPERATOR, /* INST_PATTERN_LIST */
    metakind::OPERATOR, /* INST_CLOSURE */

    metakind::INVALID /* LAST_KIND */
  };/* metaKinds[] */

  Assert(k >= kind::NULL_EXPR && k < kind::LAST_KIND);

  // We've asserted that k >= NULL_EXPR (which is 0), but we still
  // handle the UNDEFINED_KIND (-1) case.  If we don't, the compiler
  // emits warnings for non-assertion builds, since the check isn't done.
  return metaKinds[k + 1];
}/* metaKindOf(k) */

}/* CVC4::kind namespace */

namespace expr {


// The reinterpret_cast of d_children to "::CVC4::UninterpretedConstant const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::UninterpretedConstant const& NodeValue::getConst< ::CVC4::UninterpretedConstant >() const {
  AssertArgument(getKind() == ::CVC4::kind::UNINTERPRETED_CONSTANT, *this,
                 "Improper kind for getConst<::CVC4::UninterpretedConstant>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::UninterpretedConstant const* >(d_children)
    : *reinterpret_cast< ::CVC4::UninterpretedConstant const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::AbstractValue const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::AbstractValue const& NodeValue::getConst< ::CVC4::AbstractValue >() const {
  AssertArgument(getKind() == ::CVC4::kind::ABSTRACT_VALUE, *this,
                 "Improper kind for getConst<::CVC4::AbstractValue>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::AbstractValue const* >(d_children)
    : *reinterpret_cast< ::CVC4::AbstractValue const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::Kind const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::Kind const& NodeValue::getConst< ::CVC4::Kind >() const {
  AssertArgument(getKind() == ::CVC4::kind::BUILTIN, *this,
                 "Improper kind for getConst<::CVC4::Kind>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::Kind const* >(d_children)
    : *reinterpret_cast< ::CVC4::Kind const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::TypeConstant const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::TypeConstant const& NodeValue::getConst< ::CVC4::TypeConstant >() const {
  AssertArgument(getKind() == ::CVC4::kind::TYPE_CONSTANT, *this,
                 "Improper kind for getConst<::CVC4::TypeConstant>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::TypeConstant const* >(d_children)
    : *reinterpret_cast< ::CVC4::TypeConstant const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "bool const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
bool const& NodeValue::getConst< bool >() const {
  AssertArgument(getKind() == ::CVC4::kind::CONST_BOOLEAN, *this,
                 "Improper kind for getConst<bool>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< bool const* >(d_children)
    : *reinterpret_cast< bool const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::Divisible const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::Divisible const& NodeValue::getConst< ::CVC4::Divisible >() const {
  AssertArgument(getKind() == ::CVC4::kind::DIVISIBLE_OP, *this,
                 "Improper kind for getConst<::CVC4::Divisible>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::Divisible const* >(d_children)
    : *reinterpret_cast< ::CVC4::Divisible const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::Rational const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::Rational const& NodeValue::getConst< ::CVC4::Rational >() const {
  AssertArgument(getKind() == ::CVC4::kind::CONST_RATIONAL, *this,
                 "Improper kind for getConst<::CVC4::Rational>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::Rational const* >(d_children)
    : *reinterpret_cast< ::CVC4::Rational const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::BitVectorSize const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::BitVectorSize const& NodeValue::getConst< ::CVC4::BitVectorSize >() const {
  AssertArgument(getKind() == ::CVC4::kind::BITVECTOR_TYPE, *this,
                 "Improper kind for getConst<::CVC4::BitVectorSize>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::BitVectorSize const* >(d_children)
    : *reinterpret_cast< ::CVC4::BitVectorSize const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::BitVector const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::BitVector const& NodeValue::getConst< ::CVC4::BitVector >() const {
  AssertArgument(getKind() == ::CVC4::kind::CONST_BITVECTOR, *this,
                 "Improper kind for getConst<::CVC4::BitVector>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::BitVector const* >(d_children)
    : *reinterpret_cast< ::CVC4::BitVector const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::BitVectorBitOf const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::BitVectorBitOf const& NodeValue::getConst< ::CVC4::BitVectorBitOf >() const {
  AssertArgument(getKind() == ::CVC4::kind::BITVECTOR_BITOF_OP, *this,
                 "Improper kind for getConst<::CVC4::BitVectorBitOf>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::BitVectorBitOf const* >(d_children)
    : *reinterpret_cast< ::CVC4::BitVectorBitOf const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::BitVectorExtract const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::BitVectorExtract const& NodeValue::getConst< ::CVC4::BitVectorExtract >() const {
  AssertArgument(getKind() == ::CVC4::kind::BITVECTOR_EXTRACT_OP, *this,
                 "Improper kind for getConst<::CVC4::BitVectorExtract>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::BitVectorExtract const* >(d_children)
    : *reinterpret_cast< ::CVC4::BitVectorExtract const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::BitVectorRepeat const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::BitVectorRepeat const& NodeValue::getConst< ::CVC4::BitVectorRepeat >() const {
  AssertArgument(getKind() == ::CVC4::kind::BITVECTOR_REPEAT_OP, *this,
                 "Improper kind for getConst<::CVC4::BitVectorRepeat>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::BitVectorRepeat const* >(d_children)
    : *reinterpret_cast< ::CVC4::BitVectorRepeat const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::BitVectorRotateLeft const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::BitVectorRotateLeft const& NodeValue::getConst< ::CVC4::BitVectorRotateLeft >() const {
  AssertArgument(getKind() == ::CVC4::kind::BITVECTOR_ROTATE_LEFT_OP, *this,
                 "Improper kind for getConst<::CVC4::BitVectorRotateLeft>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::BitVectorRotateLeft const* >(d_children)
    : *reinterpret_cast< ::CVC4::BitVectorRotateLeft const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::BitVectorRotateRight const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::BitVectorRotateRight const& NodeValue::getConst< ::CVC4::BitVectorRotateRight >() const {
  AssertArgument(getKind() == ::CVC4::kind::BITVECTOR_ROTATE_RIGHT_OP, *this,
                 "Improper kind for getConst<::CVC4::BitVectorRotateRight>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::BitVectorRotateRight const* >(d_children)
    : *reinterpret_cast< ::CVC4::BitVectorRotateRight const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::BitVectorSignExtend const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::BitVectorSignExtend const& NodeValue::getConst< ::CVC4::BitVectorSignExtend >() const {
  AssertArgument(getKind() == ::CVC4::kind::BITVECTOR_SIGN_EXTEND_OP, *this,
                 "Improper kind for getConst<::CVC4::BitVectorSignExtend>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::BitVectorSignExtend const* >(d_children)
    : *reinterpret_cast< ::CVC4::BitVectorSignExtend const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::BitVectorZeroExtend const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::BitVectorZeroExtend const& NodeValue::getConst< ::CVC4::BitVectorZeroExtend >() const {
  AssertArgument(getKind() == ::CVC4::kind::BITVECTOR_ZERO_EXTEND_OP, *this,
                 "Improper kind for getConst<::CVC4::BitVectorZeroExtend>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::BitVectorZeroExtend const* >(d_children)
    : *reinterpret_cast< ::CVC4::BitVectorZeroExtend const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::IntToBitVector const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::IntToBitVector const& NodeValue::getConst< ::CVC4::IntToBitVector >() const {
  AssertArgument(getKind() == ::CVC4::kind::INT_TO_BITVECTOR_OP, *this,
                 "Improper kind for getConst<::CVC4::IntToBitVector>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::IntToBitVector const* >(d_children)
    : *reinterpret_cast< ::CVC4::IntToBitVector const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::FloatingPoint const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::FloatingPoint const& NodeValue::getConst< ::CVC4::FloatingPoint >() const {
  AssertArgument(getKind() == ::CVC4::kind::CONST_FLOATINGPOINT, *this,
                 "Improper kind for getConst<::CVC4::FloatingPoint>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::FloatingPoint const* >(d_children)
    : *reinterpret_cast< ::CVC4::FloatingPoint const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::RoundingMode const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::RoundingMode const& NodeValue::getConst< ::CVC4::RoundingMode >() const {
  AssertArgument(getKind() == ::CVC4::kind::CONST_ROUNDINGMODE, *this,
                 "Improper kind for getConst<::CVC4::RoundingMode>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::RoundingMode const* >(d_children)
    : *reinterpret_cast< ::CVC4::RoundingMode const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::FloatingPointSize const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::FloatingPointSize const& NodeValue::getConst< ::CVC4::FloatingPointSize >() const {
  AssertArgument(getKind() == ::CVC4::kind::FLOATINGPOINT_TYPE, *this,
                 "Improper kind for getConst<::CVC4::FloatingPointSize>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::FloatingPointSize const* >(d_children)
    : *reinterpret_cast< ::CVC4::FloatingPointSize const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::FloatingPointToFPIEEEBitVector const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::FloatingPointToFPIEEEBitVector const& NodeValue::getConst< ::CVC4::FloatingPointToFPIEEEBitVector >() const {
  AssertArgument(getKind() == ::CVC4::kind::FLOATINGPOINT_TO_FP_IEEE_BITVECTOR_OP, *this,
                 "Improper kind for getConst<::CVC4::FloatingPointToFPIEEEBitVector>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::FloatingPointToFPIEEEBitVector const* >(d_children)
    : *reinterpret_cast< ::CVC4::FloatingPointToFPIEEEBitVector const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::FloatingPointToFPFloatingPoint const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::FloatingPointToFPFloatingPoint const& NodeValue::getConst< ::CVC4::FloatingPointToFPFloatingPoint >() const {
  AssertArgument(getKind() == ::CVC4::kind::FLOATINGPOINT_TO_FP_FLOATINGPOINT_OP, *this,
                 "Improper kind for getConst<::CVC4::FloatingPointToFPFloatingPoint>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::FloatingPointToFPFloatingPoint const* >(d_children)
    : *reinterpret_cast< ::CVC4::FloatingPointToFPFloatingPoint const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::FloatingPointToFPReal const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::FloatingPointToFPReal const& NodeValue::getConst< ::CVC4::FloatingPointToFPReal >() const {
  AssertArgument(getKind() == ::CVC4::kind::FLOATINGPOINT_TO_FP_REAL_OP, *this,
                 "Improper kind for getConst<::CVC4::FloatingPointToFPReal>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::FloatingPointToFPReal const* >(d_children)
    : *reinterpret_cast< ::CVC4::FloatingPointToFPReal const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::FloatingPointToFPSignedBitVector const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::FloatingPointToFPSignedBitVector const& NodeValue::getConst< ::CVC4::FloatingPointToFPSignedBitVector >() const {
  AssertArgument(getKind() == ::CVC4::kind::FLOATINGPOINT_TO_FP_SIGNED_BITVECTOR_OP, *this,
                 "Improper kind for getConst<::CVC4::FloatingPointToFPSignedBitVector>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::FloatingPointToFPSignedBitVector const* >(d_children)
    : *reinterpret_cast< ::CVC4::FloatingPointToFPSignedBitVector const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::FloatingPointToFPUnsignedBitVector const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::FloatingPointToFPUnsignedBitVector const& NodeValue::getConst< ::CVC4::FloatingPointToFPUnsignedBitVector >() const {
  AssertArgument(getKind() == ::CVC4::kind::FLOATINGPOINT_TO_FP_UNSIGNED_BITVECTOR_OP, *this,
                 "Improper kind for getConst<::CVC4::FloatingPointToFPUnsignedBitVector>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::FloatingPointToFPUnsignedBitVector const* >(d_children)
    : *reinterpret_cast< ::CVC4::FloatingPointToFPUnsignedBitVector const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::FloatingPointToFPGeneric const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::FloatingPointToFPGeneric const& NodeValue::getConst< ::CVC4::FloatingPointToFPGeneric >() const {
  AssertArgument(getKind() == ::CVC4::kind::FLOATINGPOINT_TO_FP_GENERIC_OP, *this,
                 "Improper kind for getConst<::CVC4::FloatingPointToFPGeneric>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::FloatingPointToFPGeneric const* >(d_children)
    : *reinterpret_cast< ::CVC4::FloatingPointToFPGeneric const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::FloatingPointToUBV const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::FloatingPointToUBV const& NodeValue::getConst< ::CVC4::FloatingPointToUBV >() const {
  AssertArgument(getKind() == ::CVC4::kind::FLOATINGPOINT_TO_UBV_OP, *this,
                 "Improper kind for getConst<::CVC4::FloatingPointToUBV>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::FloatingPointToUBV const* >(d_children)
    : *reinterpret_cast< ::CVC4::FloatingPointToUBV const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::FloatingPointToUBVTotal const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::FloatingPointToUBVTotal const& NodeValue::getConst< ::CVC4::FloatingPointToUBVTotal >() const {
  AssertArgument(getKind() == ::CVC4::kind::FLOATINGPOINT_TO_UBV_TOTAL_OP, *this,
                 "Improper kind for getConst<::CVC4::FloatingPointToUBVTotal>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::FloatingPointToUBVTotal const* >(d_children)
    : *reinterpret_cast< ::CVC4::FloatingPointToUBVTotal const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::FloatingPointToSBV const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::FloatingPointToSBV const& NodeValue::getConst< ::CVC4::FloatingPointToSBV >() const {
  AssertArgument(getKind() == ::CVC4::kind::FLOATINGPOINT_TO_SBV_OP, *this,
                 "Improper kind for getConst<::CVC4::FloatingPointToSBV>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::FloatingPointToSBV const* >(d_children)
    : *reinterpret_cast< ::CVC4::FloatingPointToSBV const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::FloatingPointToSBVTotal const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::FloatingPointToSBVTotal const& NodeValue::getConst< ::CVC4::FloatingPointToSBVTotal >() const {
  AssertArgument(getKind() == ::CVC4::kind::FLOATINGPOINT_TO_SBV_TOTAL_OP, *this,
                 "Improper kind for getConst<::CVC4::FloatingPointToSBVTotal>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::FloatingPointToSBVTotal const* >(d_children)
    : *reinterpret_cast< ::CVC4::FloatingPointToSBVTotal const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::ArrayStoreAll const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::ArrayStoreAll const& NodeValue::getConst< ::CVC4::ArrayStoreAll >() const {
  AssertArgument(getKind() == ::CVC4::kind::STORE_ALL, *this,
                 "Improper kind for getConst<::CVC4::ArrayStoreAll>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::ArrayStoreAll const* >(d_children)
    : *reinterpret_cast< ::CVC4::ArrayStoreAll const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::DatatypeIndexConstant const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::DatatypeIndexConstant const& NodeValue::getConst< ::CVC4::DatatypeIndexConstant >() const {
  AssertArgument(getKind() == ::CVC4::kind::DATATYPE_TYPE, *this,
                 "Improper kind for getConst<::CVC4::DatatypeIndexConstant>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::DatatypeIndexConstant const* >(d_children)
    : *reinterpret_cast< ::CVC4::DatatypeIndexConstant const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::AscriptionType const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::AscriptionType const& NodeValue::getConst< ::CVC4::AscriptionType >() const {
  AssertArgument(getKind() == ::CVC4::kind::ASCRIPTION_TYPE, *this,
                 "Improper kind for getConst<::CVC4::AscriptionType>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::AscriptionType const* >(d_children)
    : *reinterpret_cast< ::CVC4::AscriptionType const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::TupleUpdate const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::TupleUpdate const& NodeValue::getConst< ::CVC4::TupleUpdate >() const {
  AssertArgument(getKind() == ::CVC4::kind::TUPLE_UPDATE_OP, *this,
                 "Improper kind for getConst<::CVC4::TupleUpdate>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::TupleUpdate const* >(d_children)
    : *reinterpret_cast< ::CVC4::TupleUpdate const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::RecordUpdate const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::RecordUpdate const& NodeValue::getConst< ::CVC4::RecordUpdate >() const {
  AssertArgument(getKind() == ::CVC4::kind::RECORD_UPDATE_OP, *this,
                 "Improper kind for getConst<::CVC4::RecordUpdate>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::RecordUpdate const* >(d_children)
    : *reinterpret_cast< ::CVC4::RecordUpdate const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::EmptySet const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::EmptySet const& NodeValue::getConst< ::CVC4::EmptySet >() const {
  AssertArgument(getKind() == ::CVC4::kind::EMPTYSET, *this,
                 "Improper kind for getConst<::CVC4::EmptySet>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::EmptySet const* >(d_children)
    : *reinterpret_cast< ::CVC4::EmptySet const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::String const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::String const& NodeValue::getConst< ::CVC4::String >() const {
  AssertArgument(getKind() == ::CVC4::kind::CONST_STRING, *this,
                 "Improper kind for getConst<::CVC4::String>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::String const* >(d_children)
    : *reinterpret_cast< ::CVC4::String const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::ExprSequence const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::ExprSequence const& NodeValue::getConst< ::CVC4::ExprSequence >() const {
  AssertArgument(getKind() == ::CVC4::kind::CONST_SEQUENCE, *this,
                 "Improper kind for getConst<::CVC4::ExprSequence>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::ExprSequence const* >(d_children)
    : *reinterpret_cast< ::CVC4::ExprSequence const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::RegExpRepeat const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::RegExpRepeat const& NodeValue::getConst< ::CVC4::RegExpRepeat >() const {
  AssertArgument(getKind() == ::CVC4::kind::REGEXP_REPEAT_OP, *this,
                 "Improper kind for getConst<::CVC4::RegExpRepeat>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::RegExpRepeat const* >(d_children)
    : *reinterpret_cast< ::CVC4::RegExpRepeat const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"


// The reinterpret_cast of d_children to "::CVC4::RegExpLoop const*"
// flags a "strict aliasing" warning; it's okay, because we never access
// the embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

template <>
::CVC4::RegExpLoop const& NodeValue::getConst< ::CVC4::RegExpLoop >() const {
  AssertArgument(getKind() == ::CVC4::kind::REGEXP_LOOP_OP, *this,
                 "Improper kind for getConst<::CVC4::RegExpLoop>()");
  // To support non-inlined CONSTANT-kinded NodeValues (those that are
  // "constructed" when initially checking them against the NodeManager
  // pool), we must check d_nchildren here.
  return d_nchildren == 0
    ? *reinterpret_cast< ::CVC4::RegExpLoop const* >(d_children)
    : *reinterpret_cast< ::CVC4::RegExpLoop const* >(d_children[0]);
}

// re-enable the warning
#pragma GCC diagnostic warning "-Wstrict-aliasing"



}/* CVC4::expr namespace */

namespace kind {
namespace metakind {

size_t NodeValueCompare::constHash(const ::CVC4::expr::NodeValue* nv)
{
  Assert(nv->getMetaKind() == kind::metakind::CONSTANT);

  switch (nv->d_kind)
  {

  case kind::UNINTERPRETED_CONSTANT:
#line 265 "/build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds"
    return ::CVC4::UninterpretedConstantHashFunction()(nv->getConst< ::CVC4::UninterpretedConstant >());

  case kind::ABSTRACT_VALUE:
#line 275 "/build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds"
    return ::CVC4::AbstractValueHashFunction()(nv->getConst< ::CVC4::AbstractValue >());

  case kind::BUILTIN:
#line 286 "/build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds"
    return ::CVC4::kind::KindHashFunction()(nv->getConst< ::CVC4::Kind >());

  case kind::TYPE_CONSTANT:
#line 303 "/build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds"
    return ::CVC4::TypeConstantHashFunction()(nv->getConst< ::CVC4::TypeConstant >());

  case kind::CONST_BOOLEAN:
#line 21 "/build/cvc4/src/cvc5-1.8/src/theory/booleans/kinds"
    return ::CVC4::BoolHashFunction()(nv->getConst< bool >());

  case kind::DIVISIBLE_OP:
#line 46 "/build/cvc4/src/cvc5-1.8/src/theory/arith/kinds"
    return ::CVC4::DivisibleHashFunction()(nv->getConst< ::CVC4::Divisible >());

  case kind::CONST_RATIONAL:
#line 65 "/build/cvc4/src/cvc5-1.8/src/theory/arith/kinds"
    return ::CVC4::RationalHashFunction()(nv->getConst< ::CVC4::Rational >());

  case kind::BITVECTOR_TYPE:
#line 15 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    return ::CVC4::UnsignedHashFunction< ::CVC4::BitVectorSize >()(nv->getConst< ::CVC4::BitVectorSize >());

  case kind::CONST_BITVECTOR:
#line 24 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    return ::CVC4::BitVectorHashFunction()(nv->getConst< ::CVC4::BitVector >());

  case kind::BITVECTOR_BITOF_OP:
#line 103 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    return ::CVC4::BitVectorBitOfHashFunction()(nv->getConst< ::CVC4::BitVectorBitOf >());

  case kind::BITVECTOR_EXTRACT_OP:
#line 110 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    return ::CVC4::BitVectorExtractHashFunction()(nv->getConst< ::CVC4::BitVectorExtract >());

  case kind::BITVECTOR_REPEAT_OP:
#line 117 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    return ::CVC4::UnsignedHashFunction< ::CVC4::BitVectorRepeat >()(nv->getConst< ::CVC4::BitVectorRepeat >());

  case kind::BITVECTOR_ROTATE_LEFT_OP:
#line 124 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    return ::CVC4::UnsignedHashFunction< ::CVC4::BitVectorRotateLeft >()(nv->getConst< ::CVC4::BitVectorRotateLeft >());

  case kind::BITVECTOR_ROTATE_RIGHT_OP:
#line 131 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    return ::CVC4::UnsignedHashFunction< ::CVC4::BitVectorRotateRight >()(nv->getConst< ::CVC4::BitVectorRotateRight >());

  case kind::BITVECTOR_SIGN_EXTEND_OP:
#line 138 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    return ::CVC4::UnsignedHashFunction< ::CVC4::BitVectorSignExtend >()(nv->getConst< ::CVC4::BitVectorSignExtend >());

  case kind::BITVECTOR_ZERO_EXTEND_OP:
#line 145 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    return ::CVC4::UnsignedHashFunction< ::CVC4::BitVectorZeroExtend >()(nv->getConst< ::CVC4::BitVectorZeroExtend >());

  case kind::INT_TO_BITVECTOR_OP:
#line 152 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    return ::CVC4::UnsignedHashFunction< ::CVC4::IntToBitVector >()(nv->getConst< ::CVC4::IntToBitVector >());

  case kind::CONST_FLOATINGPOINT:
#line 16 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    return ::CVC4::FloatingPointHashFunction()(nv->getConst< ::CVC4::FloatingPoint >());

  case kind::CONST_ROUNDINGMODE:
#line 24 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    return ::CVC4::RoundingModeHashFunction()(nv->getConst< ::CVC4::RoundingMode >());

  case kind::FLOATINGPOINT_TYPE:
#line 47 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    return ::CVC4::FloatingPointSizeHashFunction()(nv->getConst< ::CVC4::FloatingPointSize >());

  case kind::FLOATINGPOINT_TO_FP_IEEE_BITVECTOR_OP:
#line 157 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    return ::CVC4::FloatingPointConvertSortHashFunction<0x1>()(nv->getConst< ::CVC4::FloatingPointToFPIEEEBitVector >());

  case kind::FLOATINGPOINT_TO_FP_FLOATINGPOINT_OP:
#line 169 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    return ::CVC4::FloatingPointConvertSortHashFunction<0x2>()(nv->getConst< ::CVC4::FloatingPointToFPFloatingPoint >());

  case kind::FLOATINGPOINT_TO_FP_REAL_OP:
#line 182 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    return ::CVC4::FloatingPointConvertSortHashFunction<0x4>()(nv->getConst< ::CVC4::FloatingPointToFPReal >());

  case kind::FLOATINGPOINT_TO_FP_SIGNED_BITVECTOR_OP:
#line 194 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    return ::CVC4::FloatingPointConvertSortHashFunction<0x8>()(nv->getConst< ::CVC4::FloatingPointToFPSignedBitVector >());

  case kind::FLOATINGPOINT_TO_FP_UNSIGNED_BITVECTOR_OP:
#line 206 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    return ::CVC4::FloatingPointConvertSortHashFunction<0x10>()(nv->getConst< ::CVC4::FloatingPointToFPUnsignedBitVector >());

  case kind::FLOATINGPOINT_TO_FP_GENERIC_OP:
#line 219 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    return ::CVC4::FloatingPointConvertSortHashFunction<0x11>()(nv->getConst< ::CVC4::FloatingPointToFPGeneric >());

  case kind::FLOATINGPOINT_TO_UBV_OP:
#line 234 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    return ::CVC4::FloatingPointToBVHashFunction<0x1>()(nv->getConst< ::CVC4::FloatingPointToUBV >());

  case kind::FLOATINGPOINT_TO_UBV_TOTAL_OP:
#line 245 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    return ::CVC4::FloatingPointToBVHashFunction<0x4>()(nv->getConst< ::CVC4::FloatingPointToUBVTotal >());

  case kind::FLOATINGPOINT_TO_SBV_OP:
#line 257 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    return ::CVC4::FloatingPointToBVHashFunction<0x2>()(nv->getConst< ::CVC4::FloatingPointToSBV >());

  case kind::FLOATINGPOINT_TO_SBV_TOTAL_OP:
#line 268 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    return ::CVC4::FloatingPointToBVHashFunction<0x8>()(nv->getConst< ::CVC4::FloatingPointToSBVTotal >());

  case kind::STORE_ALL:
#line 35 "/build/cvc4/src/cvc5-1.8/src/theory/arrays/kinds"
    return ::CVC4::ArrayStoreAllHashFunction()(nv->getConst< ::CVC4::ArrayStoreAll >());

  case kind::DATATYPE_TYPE:
#line 41 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
    return ::CVC4::DatatypeIndexConstantHashFunction()(nv->getConst< ::CVC4::DatatypeIndexConstant >());

  case kind::ASCRIPTION_TYPE:
#line 73 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
    return ::CVC4::AscriptionTypeHashFunction()(nv->getConst< ::CVC4::AscriptionType >());

  case kind::TUPLE_UPDATE_OP:
#line 88 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
    return ::CVC4::TupleUpdateHashFunction()(nv->getConst< ::CVC4::TupleUpdate >());

  case kind::RECORD_UPDATE_OP:
#line 97 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
    return ::CVC4::RecordUpdateHashFunction()(nv->getConst< ::CVC4::RecordUpdate >());

  case kind::EMPTYSET:
#line 18 "/build/cvc4/src/cvc5-1.8/src/theory/sets/kinds"
    return ::CVC4::EmptySetHashFunction()(nv->getConst< ::CVC4::EmptySet >());

  case kind::CONST_STRING:
#line 59 "/build/cvc4/src/cvc5-1.8/src/theory/strings/kinds"
    return ::CVC4::strings::StringHashFunction()(nv->getConst< ::CVC4::String >());

  case kind::CONST_SEQUENCE:
#line 78 "/build/cvc4/src/cvc5-1.8/src/theory/strings/kinds"
    return ::CVC4::ExprSequenceHashFunction()(nv->getConst< ::CVC4::ExprSequence >());

  case kind::REGEXP_REPEAT_OP:
#line 101 "/build/cvc4/src/cvc5-1.8/src/theory/strings/kinds"
    return ::CVC4::RegExpRepeatHashFunction()(nv->getConst< ::CVC4::RegExpRepeat >());

  case kind::REGEXP_LOOP_OP:
#line 108 "/build/cvc4/src/cvc5-1.8/src/theory/strings/kinds"
    return ::CVC4::RegExpLoopHashFunction()(nv->getConst< ::CVC4::RegExpLoop >());

    default: Unhandled() << ::CVC4::expr::NodeValue::dKindToKind(nv->d_kind);
  }
}

template <bool pool>
bool NodeValueCompare::compare(const ::CVC4::expr::NodeValue* nv1,
                               const ::CVC4::expr::NodeValue* nv2) {
  if(nv1->d_kind != nv2->d_kind) {
    return false;
  }

  if (nv1->getMetaKind() == kind::metakind::CONSTANT)
  {
    switch (nv1->d_kind)
    {

    case kind::UNINTERPRETED_CONSTANT:
      return NodeValueConstCompare< kind::UNINTERPRETED_CONSTANT, pool >::compare(nv1, nv2);

    case kind::ABSTRACT_VALUE:
      return NodeValueConstCompare< kind::ABSTRACT_VALUE, pool >::compare(nv1, nv2);

    case kind::BUILTIN:
      return NodeValueConstCompare< kind::BUILTIN, pool >::compare(nv1, nv2);

    case kind::TYPE_CONSTANT:
      return NodeValueConstCompare< kind::TYPE_CONSTANT, pool >::compare(nv1, nv2);

    case kind::CONST_BOOLEAN:
      return NodeValueConstCompare< kind::CONST_BOOLEAN, pool >::compare(nv1, nv2);

    case kind::DIVISIBLE_OP:
      return NodeValueConstCompare< kind::DIVISIBLE_OP, pool >::compare(nv1, nv2);

    case kind::CONST_RATIONAL:
      return NodeValueConstCompare< kind::CONST_RATIONAL, pool >::compare(nv1, nv2);

    case kind::BITVECTOR_TYPE:
      return NodeValueConstCompare< kind::BITVECTOR_TYPE, pool >::compare(nv1, nv2);

    case kind::CONST_BITVECTOR:
      return NodeValueConstCompare< kind::CONST_BITVECTOR, pool >::compare(nv1, nv2);

    case kind::BITVECTOR_BITOF_OP:
      return NodeValueConstCompare< kind::BITVECTOR_BITOF_OP, pool >::compare(nv1, nv2);

    case kind::BITVECTOR_EXTRACT_OP:
      return NodeValueConstCompare< kind::BITVECTOR_EXTRACT_OP, pool >::compare(nv1, nv2);

    case kind::BITVECTOR_REPEAT_OP:
      return NodeValueConstCompare< kind::BITVECTOR_REPEAT_OP, pool >::compare(nv1, nv2);

    case kind::BITVECTOR_ROTATE_LEFT_OP:
      return NodeValueConstCompare< kind::BITVECTOR_ROTATE_LEFT_OP, pool >::compare(nv1, nv2);

    case kind::BITVECTOR_ROTATE_RIGHT_OP:
      return NodeValueConstCompare< kind::BITVECTOR_ROTATE_RIGHT_OP, pool >::compare(nv1, nv2);

    case kind::BITVECTOR_SIGN_EXTEND_OP:
      return NodeValueConstCompare< kind::BITVECTOR_SIGN_EXTEND_OP, pool >::compare(nv1, nv2);

    case kind::BITVECTOR_ZERO_EXTEND_OP:
      return NodeValueConstCompare< kind::BITVECTOR_ZERO_EXTEND_OP, pool >::compare(nv1, nv2);

    case kind::INT_TO_BITVECTOR_OP:
      return NodeValueConstCompare< kind::INT_TO_BITVECTOR_OP, pool >::compare(nv1, nv2);

    case kind::CONST_FLOATINGPOINT:
      return NodeValueConstCompare< kind::CONST_FLOATINGPOINT, pool >::compare(nv1, nv2);

    case kind::CONST_ROUNDINGMODE:
      return NodeValueConstCompare< kind::CONST_ROUNDINGMODE, pool >::compare(nv1, nv2);

    case kind::FLOATINGPOINT_TYPE:
      return NodeValueConstCompare< kind::FLOATINGPOINT_TYPE, pool >::compare(nv1, nv2);

    case kind::FLOATINGPOINT_TO_FP_IEEE_BITVECTOR_OP:
      return NodeValueConstCompare< kind::FLOATINGPOINT_TO_FP_IEEE_BITVECTOR_OP, pool >::compare(nv1, nv2);

    case kind::FLOATINGPOINT_TO_FP_FLOATINGPOINT_OP:
      return NodeValueConstCompare< kind::FLOATINGPOINT_TO_FP_FLOATINGPOINT_OP, pool >::compare(nv1, nv2);

    case kind::FLOATINGPOINT_TO_FP_REAL_OP:
      return NodeValueConstCompare< kind::FLOATINGPOINT_TO_FP_REAL_OP, pool >::compare(nv1, nv2);

    case kind::FLOATINGPOINT_TO_FP_SIGNED_BITVECTOR_OP:
      return NodeValueConstCompare< kind::FLOATINGPOINT_TO_FP_SIGNED_BITVECTOR_OP, pool >::compare(nv1, nv2);

    case kind::FLOATINGPOINT_TO_FP_UNSIGNED_BITVECTOR_OP:
      return NodeValueConstCompare< kind::FLOATINGPOINT_TO_FP_UNSIGNED_BITVECTOR_OP, pool >::compare(nv1, nv2);

    case kind::FLOATINGPOINT_TO_FP_GENERIC_OP:
      return NodeValueConstCompare< kind::FLOATINGPOINT_TO_FP_GENERIC_OP, pool >::compare(nv1, nv2);

    case kind::FLOATINGPOINT_TO_UBV_OP:
      return NodeValueConstCompare< kind::FLOATINGPOINT_TO_UBV_OP, pool >::compare(nv1, nv2);

    case kind::FLOATINGPOINT_TO_UBV_TOTAL_OP:
      return NodeValueConstCompare< kind::FLOATINGPOINT_TO_UBV_TOTAL_OP, pool >::compare(nv1, nv2);

    case kind::FLOATINGPOINT_TO_SBV_OP:
      return NodeValueConstCompare< kind::FLOATINGPOINT_TO_SBV_OP, pool >::compare(nv1, nv2);

    case kind::FLOATINGPOINT_TO_SBV_TOTAL_OP:
      return NodeValueConstCompare< kind::FLOATINGPOINT_TO_SBV_TOTAL_OP, pool >::compare(nv1, nv2);

    case kind::STORE_ALL:
      return NodeValueConstCompare< kind::STORE_ALL, pool >::compare(nv1, nv2);

    case kind::DATATYPE_TYPE:
      return NodeValueConstCompare< kind::DATATYPE_TYPE, pool >::compare(nv1, nv2);

    case kind::ASCRIPTION_TYPE:
      return NodeValueConstCompare< kind::ASCRIPTION_TYPE, pool >::compare(nv1, nv2);

    case kind::TUPLE_UPDATE_OP:
      return NodeValueConstCompare< kind::TUPLE_UPDATE_OP, pool >::compare(nv1, nv2);

    case kind::RECORD_UPDATE_OP:
      return NodeValueConstCompare< kind::RECORD_UPDATE_OP, pool >::compare(nv1, nv2);

    case kind::EMPTYSET:
      return NodeValueConstCompare< kind::EMPTYSET, pool >::compare(nv1, nv2);

    case kind::CONST_STRING:
      return NodeValueConstCompare< kind::CONST_STRING, pool >::compare(nv1, nv2);

    case kind::CONST_SEQUENCE:
      return NodeValueConstCompare< kind::CONST_SEQUENCE, pool >::compare(nv1, nv2);

    case kind::REGEXP_REPEAT_OP:
      return NodeValueConstCompare< kind::REGEXP_REPEAT_OP, pool >::compare(nv1, nv2);

    case kind::REGEXP_LOOP_OP:
      return NodeValueConstCompare< kind::REGEXP_LOOP_OP, pool >::compare(nv1, nv2);

      default: Unhandled() << ::CVC4::expr::NodeValue::dKindToKind(nv1->d_kind);
    }
  }

  if(nv1->d_nchildren != nv2->d_nchildren) {
    return false;
  }

  ::CVC4::expr::NodeValue::const_nv_iterator i = nv1->nv_begin();
  ::CVC4::expr::NodeValue::const_nv_iterator j = nv2->nv_begin();
  ::CVC4::expr::NodeValue::const_nv_iterator i_end = nv1->nv_end();

  while(i != i_end) {
    if((*i) != (*j)) {
      return false;
    }
    ++i;
    ++j;
  }

  return true;
}

template bool NodeValueCompare::compare<true>(const ::CVC4::expr::NodeValue* nv1,
                                              const ::CVC4::expr::NodeValue* nv2);
template bool NodeValueCompare::compare<false>(const ::CVC4::expr::NodeValue* nv1,
                                               const ::CVC4::expr::NodeValue* nv2);

void NodeValueConstPrinter::toStream(std::ostream& out,
                                            const ::CVC4::expr::NodeValue* nv) {
  Assert(nv->getMetaKind() == kind::metakind::CONSTANT);

  switch (nv->d_kind)
  {

  case kind::UNINTERPRETED_CONSTANT:
#line 265 "/build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds"
    out << nv->getConst< ::CVC4::UninterpretedConstant >();
    break;

  case kind::ABSTRACT_VALUE:
#line 275 "/build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds"
    out << nv->getConst< ::CVC4::AbstractValue >();
    break;

  case kind::BUILTIN:
#line 286 "/build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds"
    out << nv->getConst< ::CVC4::Kind >();
    break;

  case kind::TYPE_CONSTANT:
#line 303 "/build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds"
    out << nv->getConst< ::CVC4::TypeConstant >();
    break;

  case kind::CONST_BOOLEAN:
#line 21 "/build/cvc4/src/cvc5-1.8/src/theory/booleans/kinds"
    out << nv->getConst< bool >();
    break;

  case kind::DIVISIBLE_OP:
#line 46 "/build/cvc4/src/cvc5-1.8/src/theory/arith/kinds"
    out << nv->getConst< ::CVC4::Divisible >();
    break;

  case kind::CONST_RATIONAL:
#line 65 "/build/cvc4/src/cvc5-1.8/src/theory/arith/kinds"
    out << nv->getConst< ::CVC4::Rational >();
    break;

  case kind::BITVECTOR_TYPE:
#line 15 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    out << nv->getConst< ::CVC4::BitVectorSize >();
    break;

  case kind::CONST_BITVECTOR:
#line 24 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    out << nv->getConst< ::CVC4::BitVector >();
    break;

  case kind::BITVECTOR_BITOF_OP:
#line 103 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    out << nv->getConst< ::CVC4::BitVectorBitOf >();
    break;

  case kind::BITVECTOR_EXTRACT_OP:
#line 110 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    out << nv->getConst< ::CVC4::BitVectorExtract >();
    break;

  case kind::BITVECTOR_REPEAT_OP:
#line 117 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    out << nv->getConst< ::CVC4::BitVectorRepeat >();
    break;

  case kind::BITVECTOR_ROTATE_LEFT_OP:
#line 124 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    out << nv->getConst< ::CVC4::BitVectorRotateLeft >();
    break;

  case kind::BITVECTOR_ROTATE_RIGHT_OP:
#line 131 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    out << nv->getConst< ::CVC4::BitVectorRotateRight >();
    break;

  case kind::BITVECTOR_SIGN_EXTEND_OP:
#line 138 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    out << nv->getConst< ::CVC4::BitVectorSignExtend >();
    break;

  case kind::BITVECTOR_ZERO_EXTEND_OP:
#line 145 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    out << nv->getConst< ::CVC4::BitVectorZeroExtend >();
    break;

  case kind::INT_TO_BITVECTOR_OP:
#line 152 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    out << nv->getConst< ::CVC4::IntToBitVector >();
    break;

  case kind::CONST_FLOATINGPOINT:
#line 16 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    out << nv->getConst< ::CVC4::FloatingPoint >();
    break;

  case kind::CONST_ROUNDINGMODE:
#line 24 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    out << nv->getConst< ::CVC4::RoundingMode >();
    break;

  case kind::FLOATINGPOINT_TYPE:
#line 47 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    out << nv->getConst< ::CVC4::FloatingPointSize >();
    break;

  case kind::FLOATINGPOINT_TO_FP_IEEE_BITVECTOR_OP:
#line 157 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    out << nv->getConst< ::CVC4::FloatingPointToFPIEEEBitVector >();
    break;

  case kind::FLOATINGPOINT_TO_FP_FLOATINGPOINT_OP:
#line 169 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    out << nv->getConst< ::CVC4::FloatingPointToFPFloatingPoint >();
    break;

  case kind::FLOATINGPOINT_TO_FP_REAL_OP:
#line 182 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    out << nv->getConst< ::CVC4::FloatingPointToFPReal >();
    break;

  case kind::FLOATINGPOINT_TO_FP_SIGNED_BITVECTOR_OP:
#line 194 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    out << nv->getConst< ::CVC4::FloatingPointToFPSignedBitVector >();
    break;

  case kind::FLOATINGPOINT_TO_FP_UNSIGNED_BITVECTOR_OP:
#line 206 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    out << nv->getConst< ::CVC4::FloatingPointToFPUnsignedBitVector >();
    break;

  case kind::FLOATINGPOINT_TO_FP_GENERIC_OP:
#line 219 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    out << nv->getConst< ::CVC4::FloatingPointToFPGeneric >();
    break;

  case kind::FLOATINGPOINT_TO_UBV_OP:
#line 234 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    out << nv->getConst< ::CVC4::FloatingPointToUBV >();
    break;

  case kind::FLOATINGPOINT_TO_UBV_TOTAL_OP:
#line 245 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    out << nv->getConst< ::CVC4::FloatingPointToUBVTotal >();
    break;

  case kind::FLOATINGPOINT_TO_SBV_OP:
#line 257 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    out << nv->getConst< ::CVC4::FloatingPointToSBV >();
    break;

  case kind::FLOATINGPOINT_TO_SBV_TOTAL_OP:
#line 268 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    out << nv->getConst< ::CVC4::FloatingPointToSBVTotal >();
    break;

  case kind::STORE_ALL:
#line 35 "/build/cvc4/src/cvc5-1.8/src/theory/arrays/kinds"
    out << nv->getConst< ::CVC4::ArrayStoreAll >();
    break;

  case kind::DATATYPE_TYPE:
#line 41 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
    out << nv->getConst< ::CVC4::DatatypeIndexConstant >();
    break;

  case kind::ASCRIPTION_TYPE:
#line 73 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
    out << nv->getConst< ::CVC4::AscriptionType >();
    break;

  case kind::TUPLE_UPDATE_OP:
#line 88 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
    out << nv->getConst< ::CVC4::TupleUpdate >();
    break;

  case kind::RECORD_UPDATE_OP:
#line 97 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
    out << nv->getConst< ::CVC4::RecordUpdate >();
    break;

  case kind::EMPTYSET:
#line 18 "/build/cvc4/src/cvc5-1.8/src/theory/sets/kinds"
    out << nv->getConst< ::CVC4::EmptySet >();
    break;

  case kind::CONST_STRING:
#line 59 "/build/cvc4/src/cvc5-1.8/src/theory/strings/kinds"
    out << nv->getConst< ::CVC4::String >();
    break;

  case kind::CONST_SEQUENCE:
#line 78 "/build/cvc4/src/cvc5-1.8/src/theory/strings/kinds"
    out << nv->getConst< ::CVC4::ExprSequence >();
    break;

  case kind::REGEXP_REPEAT_OP:
#line 101 "/build/cvc4/src/cvc5-1.8/src/theory/strings/kinds"
    out << nv->getConst< ::CVC4::RegExpRepeat >();
    break;

  case kind::REGEXP_LOOP_OP:
#line 108 "/build/cvc4/src/cvc5-1.8/src/theory/strings/kinds"
    out << nv->getConst< ::CVC4::RegExpLoop >();
    break;

    default: Unhandled() << ::CVC4::expr::NodeValue::dKindToKind(nv->d_kind);
  }
}

void NodeValueConstPrinter::toStream(std::ostream& out, TNode n) {
  toStream(out, n.d_nv);
}

// The reinterpret_cast of d_children to various constant payload types
// in deleteNodeValueConstant(), below, can flag a "strict aliasing"
// warning; it should actually be okay, because we never access the
// embedded constant as a NodeValue* child, and never access an embedded
// NodeValue* child as a constant.
#pragma GCC diagnostic ignored "-Wstrict-aliasing"

/**
 * Cleanup to be performed when a NodeValue zombie is collected, and
 * it has CONSTANT metakind.  This calls the destructor for the underlying
 * C++ type representing the constant value.  See
 * NodeManager::reclaimZombies() for more information.
 *
 * This doesn't support "non-inlined" NodeValues, which shouldn't need this
 * kind of cleanup.
 */
void deleteNodeValueConstant(::CVC4::expr::NodeValue* nv) {
  Assert(nv->getMetaKind() == kind::metakind::CONSTANT);

  switch (nv->d_kind)
  {

  case kind::UNINTERPRETED_CONSTANT:
#line 265 "/build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds"
    std::allocator< ::CVC4::UninterpretedConstant >().destroy(reinterpret_cast< ::CVC4::UninterpretedConstant* >(nv->d_children));
    break;

  case kind::ABSTRACT_VALUE:
#line 275 "/build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds"
    std::allocator< ::CVC4::AbstractValue >().destroy(reinterpret_cast< ::CVC4::AbstractValue* >(nv->d_children));
    break;

  case kind::BUILTIN:
#line 286 "/build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds"
    std::allocator< ::CVC4::Kind >().destroy(reinterpret_cast< ::CVC4::Kind* >(nv->d_children));
    break;

  case kind::TYPE_CONSTANT:
#line 303 "/build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds"
    std::allocator< ::CVC4::TypeConstant >().destroy(reinterpret_cast< ::CVC4::TypeConstant* >(nv->d_children));
    break;

  case kind::CONST_BOOLEAN:
#line 21 "/build/cvc4/src/cvc5-1.8/src/theory/booleans/kinds"
    std::allocator< bool >().destroy(reinterpret_cast< bool* >(nv->d_children));
    break;

  case kind::DIVISIBLE_OP:
#line 46 "/build/cvc4/src/cvc5-1.8/src/theory/arith/kinds"
    std::allocator< ::CVC4::Divisible >().destroy(reinterpret_cast< ::CVC4::Divisible* >(nv->d_children));
    break;

  case kind::CONST_RATIONAL:
#line 65 "/build/cvc4/src/cvc5-1.8/src/theory/arith/kinds"
    std::allocator< ::CVC4::Rational >().destroy(reinterpret_cast< ::CVC4::Rational* >(nv->d_children));
    break;

  case kind::BITVECTOR_TYPE:
#line 15 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    std::allocator< ::CVC4::BitVectorSize >().destroy(reinterpret_cast< ::CVC4::BitVectorSize* >(nv->d_children));
    break;

  case kind::CONST_BITVECTOR:
#line 24 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    std::allocator< ::CVC4::BitVector >().destroy(reinterpret_cast< ::CVC4::BitVector* >(nv->d_children));
    break;

  case kind::BITVECTOR_BITOF_OP:
#line 103 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    std::allocator< ::CVC4::BitVectorBitOf >().destroy(reinterpret_cast< ::CVC4::BitVectorBitOf* >(nv->d_children));
    break;

  case kind::BITVECTOR_EXTRACT_OP:
#line 110 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    std::allocator< ::CVC4::BitVectorExtract >().destroy(reinterpret_cast< ::CVC4::BitVectorExtract* >(nv->d_children));
    break;

  case kind::BITVECTOR_REPEAT_OP:
#line 117 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    std::allocator< ::CVC4::BitVectorRepeat >().destroy(reinterpret_cast< ::CVC4::BitVectorRepeat* >(nv->d_children));
    break;

  case kind::BITVECTOR_ROTATE_LEFT_OP:
#line 124 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    std::allocator< ::CVC4::BitVectorRotateLeft >().destroy(reinterpret_cast< ::CVC4::BitVectorRotateLeft* >(nv->d_children));
    break;

  case kind::BITVECTOR_ROTATE_RIGHT_OP:
#line 131 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    std::allocator< ::CVC4::BitVectorRotateRight >().destroy(reinterpret_cast< ::CVC4::BitVectorRotateRight* >(nv->d_children));
    break;

  case kind::BITVECTOR_SIGN_EXTEND_OP:
#line 138 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    std::allocator< ::CVC4::BitVectorSignExtend >().destroy(reinterpret_cast< ::CVC4::BitVectorSignExtend* >(nv->d_children));
    break;

  case kind::BITVECTOR_ZERO_EXTEND_OP:
#line 145 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    std::allocator< ::CVC4::BitVectorZeroExtend >().destroy(reinterpret_cast< ::CVC4::BitVectorZeroExtend* >(nv->d_children));
    break;

  case kind::INT_TO_BITVECTOR_OP:
#line 152 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    std::allocator< ::CVC4::IntToBitVector >().destroy(reinterpret_cast< ::CVC4::IntToBitVector* >(nv->d_children));
    break;

  case kind::CONST_FLOATINGPOINT:
#line 16 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    std::allocator< ::CVC4::FloatingPoint >().destroy(reinterpret_cast< ::CVC4::FloatingPoint* >(nv->d_children));
    break;

  case kind::CONST_ROUNDINGMODE:
#line 24 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    std::allocator< ::CVC4::RoundingMode >().destroy(reinterpret_cast< ::CVC4::RoundingMode* >(nv->d_children));
    break;

  case kind::FLOATINGPOINT_TYPE:
#line 47 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    std::allocator< ::CVC4::FloatingPointSize >().destroy(reinterpret_cast< ::CVC4::FloatingPointSize* >(nv->d_children));
    break;

  case kind::FLOATINGPOINT_TO_FP_IEEE_BITVECTOR_OP:
#line 157 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    std::allocator< ::CVC4::FloatingPointToFPIEEEBitVector >().destroy(reinterpret_cast< ::CVC4::FloatingPointToFPIEEEBitVector* >(nv->d_children));
    break;

  case kind::FLOATINGPOINT_TO_FP_FLOATINGPOINT_OP:
#line 169 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    std::allocator< ::CVC4::FloatingPointToFPFloatingPoint >().destroy(reinterpret_cast< ::CVC4::FloatingPointToFPFloatingPoint* >(nv->d_children));
    break;

  case kind::FLOATINGPOINT_TO_FP_REAL_OP:
#line 182 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    std::allocator< ::CVC4::FloatingPointToFPReal >().destroy(reinterpret_cast< ::CVC4::FloatingPointToFPReal* >(nv->d_children));
    break;

  case kind::FLOATINGPOINT_TO_FP_SIGNED_BITVECTOR_OP:
#line 194 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    std::allocator< ::CVC4::FloatingPointToFPSignedBitVector >().destroy(reinterpret_cast< ::CVC4::FloatingPointToFPSignedBitVector* >(nv->d_children));
    break;

  case kind::FLOATINGPOINT_TO_FP_UNSIGNED_BITVECTOR_OP:
#line 206 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    std::allocator< ::CVC4::FloatingPointToFPUnsignedBitVector >().destroy(reinterpret_cast< ::CVC4::FloatingPointToFPUnsignedBitVector* >(nv->d_children));
    break;

  case kind::FLOATINGPOINT_TO_FP_GENERIC_OP:
#line 219 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    std::allocator< ::CVC4::FloatingPointToFPGeneric >().destroy(reinterpret_cast< ::CVC4::FloatingPointToFPGeneric* >(nv->d_children));
    break;

  case kind::FLOATINGPOINT_TO_UBV_OP:
#line 234 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    std::allocator< ::CVC4::FloatingPointToUBV >().destroy(reinterpret_cast< ::CVC4::FloatingPointToUBV* >(nv->d_children));
    break;

  case kind::FLOATINGPOINT_TO_UBV_TOTAL_OP:
#line 245 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    std::allocator< ::CVC4::FloatingPointToUBVTotal >().destroy(reinterpret_cast< ::CVC4::FloatingPointToUBVTotal* >(nv->d_children));
    break;

  case kind::FLOATINGPOINT_TO_SBV_OP:
#line 257 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    std::allocator< ::CVC4::FloatingPointToSBV >().destroy(reinterpret_cast< ::CVC4::FloatingPointToSBV* >(nv->d_children));
    break;

  case kind::FLOATINGPOINT_TO_SBV_TOTAL_OP:
#line 268 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    std::allocator< ::CVC4::FloatingPointToSBVTotal >().destroy(reinterpret_cast< ::CVC4::FloatingPointToSBVTotal* >(nv->d_children));
    break;

  case kind::STORE_ALL:
#line 35 "/build/cvc4/src/cvc5-1.8/src/theory/arrays/kinds"
    std::allocator< ::CVC4::ArrayStoreAll >().destroy(reinterpret_cast< ::CVC4::ArrayStoreAll* >(nv->d_children));
    break;

  case kind::DATATYPE_TYPE:
#line 41 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
    std::allocator< ::CVC4::DatatypeIndexConstant >().destroy(reinterpret_cast< ::CVC4::DatatypeIndexConstant* >(nv->d_children));
    break;

  case kind::ASCRIPTION_TYPE:
#line 73 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
    std::allocator< ::CVC4::AscriptionType >().destroy(reinterpret_cast< ::CVC4::AscriptionType* >(nv->d_children));
    break;

  case kind::TUPLE_UPDATE_OP:
#line 88 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
    std::allocator< ::CVC4::TupleUpdate >().destroy(reinterpret_cast< ::CVC4::TupleUpdate* >(nv->d_children));
    break;

  case kind::RECORD_UPDATE_OP:
#line 97 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
    std::allocator< ::CVC4::RecordUpdate >().destroy(reinterpret_cast< ::CVC4::RecordUpdate* >(nv->d_children));
    break;

  case kind::EMPTYSET:
#line 18 "/build/cvc4/src/cvc5-1.8/src/theory/sets/kinds"
    std::allocator< ::CVC4::EmptySet >().destroy(reinterpret_cast< ::CVC4::EmptySet* >(nv->d_children));
    break;

  case kind::CONST_STRING:
#line 59 "/build/cvc4/src/cvc5-1.8/src/theory/strings/kinds"
    std::allocator< ::CVC4::String >().destroy(reinterpret_cast< ::CVC4::String* >(nv->d_children));
    break;

  case kind::CONST_SEQUENCE:
#line 78 "/build/cvc4/src/cvc5-1.8/src/theory/strings/kinds"
    std::allocator< ::CVC4::ExprSequence >().destroy(reinterpret_cast< ::CVC4::ExprSequence* >(nv->d_children));
    break;

  case kind::REGEXP_REPEAT_OP:
#line 101 "/build/cvc4/src/cvc5-1.8/src/theory/strings/kinds"
    std::allocator< ::CVC4::RegExpRepeat >().destroy(reinterpret_cast< ::CVC4::RegExpRepeat* >(nv->d_children));
    break;

  case kind::REGEXP_LOOP_OP:
#line 108 "/build/cvc4/src/cvc5-1.8/src/theory/strings/kinds"
    std::allocator< ::CVC4::RegExpLoop >().destroy(reinterpret_cast< ::CVC4::RegExpLoop* >(nv->d_children));
    break;

    default: Unhandled() << ::CVC4::expr::NodeValue::dKindToKind(nv->d_kind);
  }
}

// re-enable the strict-aliasing warning
# pragma GCC diagnostic warning "-Wstrict-aliasing"

unsigned getLowerBoundForKind(::CVC4::Kind k) {
  static const unsigned lbs[] = {
    0, /* NULL_EXPR */

    0, /* SORT_TAG */
    0, /* SORT_TYPE */
    0, /* UNINTERPRETED_CONSTANT */
    0, /* ABSTRACT_VALUE */
    0, /* BUILTIN */
    2, /* EQUAL */
    2, /* DISTINCT */
    0, /* VARIABLE */
    0, /* BOUND_VARIABLE */
    0, /* SKOLEM */
    0, /* SEXPR */
    2, /* LAMBDA */
    2, /* WITNESS */
    0, /* TYPE_CONSTANT */
    2, /* FUNCTION_TYPE */
    0, /* SEXPR_TYPE */
    0, /* CONST_BOOLEAN */
    1, /* NOT */
    2, /* AND */
    2, /* IMPLIES */
    2, /* OR */
    2, /* XOR */
    3, /* ITE */
    1, /* APPLY_UF */
    0, /* BOOLEAN_TERM_VARIABLE */
    2, /* CARDINALITY_CONSTRAINT */
    1, /* COMBINED_CARDINALITY_CONSTRAINT */
    1, /* PARTIAL_APPLY_UF */
    1, /* CARDINALITY_VALUE */
    2, /* HO_APPLY */
    2, /* PLUS */
    2, /* MULT */
    2, /* NONLINEAR_MULT */
    2, /* MINUS */
    1, /* UMINUS */
    2, /* DIVISION */
    2, /* DIVISION_TOTAL */
    2, /* INTS_DIVISION */
    2, /* INTS_DIVISION_TOTAL */
    2, /* INTS_MODULUS */
    2, /* INTS_MODULUS_TOTAL */
    1, /* ABS */
    1, /* DIVISIBLE */
    2, /* POW */
    1, /* EXPONENTIAL */
    1, /* SINE */
    1, /* COSINE */
    1, /* TANGENT */
    1, /* COSECANT */
    1, /* SECANT */
    1, /* COTANGENT */
    1, /* ARCSINE */
    1, /* ARCCOSINE */
    1, /* ARCTANGENT */
    1, /* ARCCOSECANT */
    1, /* ARCSECANT */
    1, /* ARCCOTANGENT */
    1, /* SQRT */
    0, /* DIVISIBLE_OP */
    0, /* CONST_RATIONAL */
    2, /* LT */
    2, /* LEQ */
    2, /* GT */
    2, /* GEQ */
    1, /* IS_INTEGER */
    1, /* TO_INTEGER */
    1, /* TO_REAL */
    0, /* PI */
    0, /* BITVECTOR_TYPE */
    0, /* CONST_BITVECTOR */
    2, /* BITVECTOR_CONCAT */
    2, /* BITVECTOR_AND */
    2, /* BITVECTOR_COMP */
    2, /* BITVECTOR_OR */
    2, /* BITVECTOR_XOR */
    1, /* BITVECTOR_NOT */
    2, /* BITVECTOR_NAND */
    2, /* BITVECTOR_NOR */
    2, /* BITVECTOR_XNOR */
    2, /* BITVECTOR_MULT */
    1, /* BITVECTOR_NEG */
    2, /* BITVECTOR_PLUS */
    2, /* BITVECTOR_SUB */
    2, /* BITVECTOR_UDIV */
    2, /* BITVECTOR_UREM */
    2, /* BITVECTOR_SDIV */
    2, /* BITVECTOR_SMOD */
    2, /* BITVECTOR_SREM */
    2, /* BITVECTOR_UDIV_TOTAL */
    2, /* BITVECTOR_UREM_TOTAL */
    2, /* BITVECTOR_ASHR */
    2, /* BITVECTOR_LSHR */
    2, /* BITVECTOR_SHL */
    2, /* BITVECTOR_ULE */
    2, /* BITVECTOR_ULT */
    2, /* BITVECTOR_UGE */
    2, /* BITVECTOR_UGT */
    2, /* BITVECTOR_SLE */
    2, /* BITVECTOR_SLT */
    2, /* BITVECTOR_SGE */
    2, /* BITVECTOR_SGT */
    2, /* BITVECTOR_ULTBV */
    2, /* BITVECTOR_SLTBV */
    1, /* BITVECTOR_REDAND */
    1, /* BITVECTOR_REDOR */
    3, /* BITVECTOR_ITE */
    1, /* BITVECTOR_TO_NAT */
    1, /* BITVECTOR_ACKERMANNIZE_UDIV */
    1, /* BITVECTOR_ACKERMANNIZE_UREM */
    1, /* BITVECTOR_EAGER_ATOM */
    0, /* BITVECTOR_BITOF_OP */
    1, /* BITVECTOR_BITOF */
    0, /* BITVECTOR_EXTRACT_OP */
    1, /* BITVECTOR_EXTRACT */
    0, /* BITVECTOR_REPEAT_OP */
    1, /* BITVECTOR_REPEAT */
    0, /* BITVECTOR_ROTATE_LEFT_OP */
    1, /* BITVECTOR_ROTATE_LEFT */
    0, /* BITVECTOR_ROTATE_RIGHT_OP */
    1, /* BITVECTOR_ROTATE_RIGHT */
    0, /* BITVECTOR_SIGN_EXTEND_OP */
    1, /* BITVECTOR_SIGN_EXTEND */
    0, /* BITVECTOR_ZERO_EXTEND_OP */
    1, /* BITVECTOR_ZERO_EXTEND */
    0, /* INT_TO_BITVECTOR_OP */
    1, /* INT_TO_BITVECTOR */
    0, /* CONST_FLOATINGPOINT */
    0, /* CONST_ROUNDINGMODE */
    0, /* FLOATINGPOINT_TYPE */
    3, /* FLOATINGPOINT_FP */
    2, /* FLOATINGPOINT_EQ */
    1, /* FLOATINGPOINT_ABS */
    1, /* FLOATINGPOINT_NEG */
    3, /* FLOATINGPOINT_PLUS */
    3, /* FLOATINGPOINT_SUB */
    3, /* FLOATINGPOINT_MULT */
    3, /* FLOATINGPOINT_DIV */
    4, /* FLOATINGPOINT_FMA */
    2, /* FLOATINGPOINT_SQRT */
    2, /* FLOATINGPOINT_REM */
    2, /* FLOATINGPOINT_RTI */
    2, /* FLOATINGPOINT_MIN */
    2, /* FLOATINGPOINT_MAX */
    3, /* FLOATINGPOINT_MIN_TOTAL */
    3, /* FLOATINGPOINT_MAX_TOTAL */
    2, /* FLOATINGPOINT_LEQ */
    2, /* FLOATINGPOINT_LT */
    2, /* FLOATINGPOINT_GEQ */
    2, /* FLOATINGPOINT_GT */
    1, /* FLOATINGPOINT_ISN */
    1, /* FLOATINGPOINT_ISSN */
    1, /* FLOATINGPOINT_ISZ */
    1, /* FLOATINGPOINT_ISINF */
    1, /* FLOATINGPOINT_ISNAN */
    1, /* FLOATINGPOINT_ISNEG */
    1, /* FLOATINGPOINT_ISPOS */
    0, /* FLOATINGPOINT_TO_FP_IEEE_BITVECTOR_OP */
    1, /* FLOATINGPOINT_TO_FP_IEEE_BITVECTOR */
    0, /* FLOATINGPOINT_TO_FP_FLOATINGPOINT_OP */
    2, /* FLOATINGPOINT_TO_FP_FLOATINGPOINT */
    0, /* FLOATINGPOINT_TO_FP_REAL_OP */
    2, /* FLOATINGPOINT_TO_FP_REAL */
    0, /* FLOATINGPOINT_TO_FP_SIGNED_BITVECTOR_OP */
    2, /* FLOATINGPOINT_TO_FP_SIGNED_BITVECTOR */
    0, /* FLOATINGPOINT_TO_FP_UNSIGNED_BITVECTOR_OP */
    2, /* FLOATINGPOINT_TO_FP_UNSIGNED_BITVECTOR */
    0, /* FLOATINGPOINT_TO_FP_GENERIC_OP */
    1, /* FLOATINGPOINT_TO_FP_GENERIC */
    0, /* FLOATINGPOINT_TO_UBV_OP */
    2, /* FLOATINGPOINT_TO_UBV */
    0, /* FLOATINGPOINT_TO_UBV_TOTAL_OP */
    3, /* FLOATINGPOINT_TO_UBV_TOTAL */
    0, /* FLOATINGPOINT_TO_SBV_OP */
    2, /* FLOATINGPOINT_TO_SBV */
    0, /* FLOATINGPOINT_TO_SBV_TOTAL_OP */
    3, /* FLOATINGPOINT_TO_SBV_TOTAL */
    1, /* FLOATINGPOINT_TO_REAL */
    2, /* FLOATINGPOINT_TO_REAL_TOTAL */
    1, /* FLOATINGPOINT_COMPONENT_NAN */
    1, /* FLOATINGPOINT_COMPONENT_INF */
    1, /* FLOATINGPOINT_COMPONENT_ZERO */
    1, /* FLOATINGPOINT_COMPONENT_SIGN */
    1, /* FLOATINGPOINT_COMPONENT_EXPONENT */
    1, /* FLOATINGPOINT_COMPONENT_SIGNIFICAND */
    1, /* ROUNDINGMODE_BITBLAST */
    2, /* ARRAY_TYPE */
    2, /* SELECT */
    3, /* STORE */
    0, /* STORE_ALL */
    4, /* ARR_TABLE_FUN */
    1, /* ARRAY_LAMBDA */
    0, /* PARTIAL_SELECT_0 */
    0, /* PARTIAL_SELECT_1 */
    1, /* CONSTRUCTOR_TYPE */
    2, /* SELECTOR_TYPE */
    1, /* TESTER_TYPE */
    0, /* APPLY_CONSTRUCTOR */
    1, /* APPLY_SELECTOR */
    1, /* APPLY_SELECTOR_TOTAL */
    1, /* APPLY_TESTER */
    0, /* DATATYPE_TYPE */
    1, /* PARAMETRIC_DATATYPE */
    1, /* APPLY_TYPE_ASCRIPTION */
    0, /* ASCRIPTION_TYPE */
    0, /* TUPLE_UPDATE_OP */
    2, /* TUPLE_UPDATE */
    0, /* RECORD_UPDATE_OP */
    2, /* RECORD_UPDATE */
    1, /* DT_SIZE */
    2, /* DT_HEIGHT_BOUND */
    2, /* DT_SIZE_BOUND */
    2, /* DT_SYGUS_BOUND */
    1, /* DT_SYGUS_EVAL */
    2, /* MATCH */
    2, /* MATCH_CASE */
    3, /* MATCH_BIND_CASE */
    0, /* SEP_NIL */
    2, /* SEP_EMP */
    2, /* SEP_PTO */
    2, /* SEP_STAR */
    2, /* SEP_WAND */
    2, /* SEP_LABEL */
    0, /* EMPTYSET */
    1, /* SET_TYPE */
    2, /* UNION */
    2, /* INTERSECTION */
    2, /* SETMINUS */
    2, /* SUBSET */
    2, /* MEMBER */
    1, /* SINGLETON */
    2, /* INSERT */
    1, /* CARD */
    1, /* COMPLEMENT */
    0, /* UNIVERSE_SET */
    3, /* COMPREHENSION */
    1, /* CHOOSE */
    2, /* JOIN */
    2, /* PRODUCT */
    1, /* TRANSPOSE */
    1, /* TCLOSURE */
    2, /* JOIN_IMAGE */
    1, /* IDEN */
    2, /* STRING_CONCAT */
    2, /* STRING_IN_REGEXP */
    1, /* STRING_LENGTH */
    3, /* STRING_SUBSTR */
    2, /* STRING_CHARAT */
    2, /* STRING_STRCTN */
    2, /* STRING_LT */
    2, /* STRING_LEQ */
    3, /* STRING_STRIDOF */
    3, /* STRING_STRREPL */
    3, /* STRING_STRREPLALL */
    3, /* STRING_REPLACE_RE */
    3, /* STRING_REPLACE_RE_ALL */
    2, /* STRING_PREFIX */
    2, /* STRING_SUFFIX */
    1, /* STRING_IS_DIGIT */
    1, /* STRING_ITOS */
    1, /* STRING_STOI */
    1, /* STRING_TO_CODE */
    1, /* STRING_FROM_CODE */
    1, /* STRING_TOLOWER */
    1, /* STRING_TOUPPER */
    1, /* STRING_REV */
    0, /* CONST_STRING */
    1, /* SEQUENCE_TYPE */
    0, /* CONST_SEQUENCE */
    1, /* SEQ_UNIT */
    1, /* STRING_TO_REGEXP */
    2, /* REGEXP_CONCAT */
    2, /* REGEXP_UNION */
    2, /* REGEXP_INTER */
    2, /* REGEXP_DIFF */
    1, /* REGEXP_STAR */
    1, /* REGEXP_PLUS */
    1, /* REGEXP_OPT */
    2, /* REGEXP_RANGE */
    1, /* REGEXP_COMPLEMENT */
    0, /* REGEXP_EMPTY */
    0, /* REGEXP_SIGMA */
    0, /* REGEXP_REPEAT_OP */
    1, /* REGEXP_REPEAT */
    0, /* REGEXP_LOOP_OP */
    1, /* REGEXP_LOOP */
    1, /* REGEXP_RV */
    2, /* FORALL */
    2, /* EXISTS */
    0, /* INST_CONSTANT */
    1, /* BOUND_VAR_LIST */
    1, /* INST_PATTERN */
    1, /* INST_NO_PATTERN */
    1, /* INST_ATTRIBUTE */
    1, /* INST_PATTERN_LIST */
    1, /* INST_CLOSURE */

    0 /* LAST_KIND */
  };

  return lbs[k];
}

unsigned getUpperBoundForKind(::CVC4::Kind k) {
  static const unsigned ubs[] = {
    0, /* NULL_EXPR */

    0, /* SORT_TAG */
    expr::NodeValue::MAX_CHILDREN, /* SORT_TYPE */
    0, /* UNINTERPRETED_CONSTANT */
    0, /* ABSTRACT_VALUE */
    0, /* BUILTIN */
    2, /* EQUAL */
    expr::NodeValue::MAX_CHILDREN, /* DISTINCT */
    0, /* VARIABLE */
    0, /* BOUND_VARIABLE */
    0, /* SKOLEM */
    expr::NodeValue::MAX_CHILDREN, /* SEXPR */
    2, /* LAMBDA */
    2, /* WITNESS */
    0, /* TYPE_CONSTANT */
    expr::NodeValue::MAX_CHILDREN, /* FUNCTION_TYPE */
    expr::NodeValue::MAX_CHILDREN, /* SEXPR_TYPE */
    0, /* CONST_BOOLEAN */
    1, /* NOT */
    expr::NodeValue::MAX_CHILDREN, /* AND */
    2, /* IMPLIES */
    expr::NodeValue::MAX_CHILDREN, /* OR */
    2, /* XOR */
    3, /* ITE */
    expr::NodeValue::MAX_CHILDREN, /* APPLY_UF */
    0, /* BOOLEAN_TERM_VARIABLE */
    2, /* CARDINALITY_CONSTRAINT */
    1, /* COMBINED_CARDINALITY_CONSTRAINT */
    expr::NodeValue::MAX_CHILDREN, /* PARTIAL_APPLY_UF */
    1, /* CARDINALITY_VALUE */
    2, /* HO_APPLY */
    expr::NodeValue::MAX_CHILDREN, /* PLUS */
    expr::NodeValue::MAX_CHILDREN, /* MULT */
    expr::NodeValue::MAX_CHILDREN, /* NONLINEAR_MULT */
    2, /* MINUS */
    1, /* UMINUS */
    2, /* DIVISION */
    2, /* DIVISION_TOTAL */
    2, /* INTS_DIVISION */
    2, /* INTS_DIVISION_TOTAL */
    2, /* INTS_MODULUS */
    2, /* INTS_MODULUS_TOTAL */
    1, /* ABS */
    1, /* DIVISIBLE */
    2, /* POW */
    1, /* EXPONENTIAL */
    1, /* SINE */
    1, /* COSINE */
    1, /* TANGENT */
    1, /* COSECANT */
    1, /* SECANT */
    1, /* COTANGENT */
    1, /* ARCSINE */
    1, /* ARCCOSINE */
    1, /* ARCTANGENT */
    1, /* ARCCOSECANT */
    1, /* ARCSECANT */
    1, /* ARCCOTANGENT */
    1, /* SQRT */
    0, /* DIVISIBLE_OP */
    0, /* CONST_RATIONAL */
    2, /* LT */
    2, /* LEQ */
    2, /* GT */
    2, /* GEQ */
    1, /* IS_INTEGER */
    1, /* TO_INTEGER */
    1, /* TO_REAL */
    0, /* PI */
    0, /* BITVECTOR_TYPE */
    0, /* CONST_BITVECTOR */
    expr::NodeValue::MAX_CHILDREN, /* BITVECTOR_CONCAT */
    expr::NodeValue::MAX_CHILDREN, /* BITVECTOR_AND */
    2, /* BITVECTOR_COMP */
    expr::NodeValue::MAX_CHILDREN, /* BITVECTOR_OR */
    expr::NodeValue::MAX_CHILDREN, /* BITVECTOR_XOR */
    1, /* BITVECTOR_NOT */
    2, /* BITVECTOR_NAND */
    2, /* BITVECTOR_NOR */
    2, /* BITVECTOR_XNOR */
    expr::NodeValue::MAX_CHILDREN, /* BITVECTOR_MULT */
    1, /* BITVECTOR_NEG */
    expr::NodeValue::MAX_CHILDREN, /* BITVECTOR_PLUS */
    2, /* BITVECTOR_SUB */
    2, /* BITVECTOR_UDIV */
    2, /* BITVECTOR_UREM */
    2, /* BITVECTOR_SDIV */
    2, /* BITVECTOR_SMOD */
    2, /* BITVECTOR_SREM */
    2, /* BITVECTOR_UDIV_TOTAL */
    2, /* BITVECTOR_UREM_TOTAL */
    2, /* BITVECTOR_ASHR */
    2, /* BITVECTOR_LSHR */
    2, /* BITVECTOR_SHL */
    2, /* BITVECTOR_ULE */
    2, /* BITVECTOR_ULT */
    2, /* BITVECTOR_UGE */
    2, /* BITVECTOR_UGT */
    2, /* BITVECTOR_SLE */
    2, /* BITVECTOR_SLT */
    2, /* BITVECTOR_SGE */
    2, /* BITVECTOR_SGT */
    2, /* BITVECTOR_ULTBV */
    2, /* BITVECTOR_SLTBV */
    1, /* BITVECTOR_REDAND */
    1, /* BITVECTOR_REDOR */
    3, /* BITVECTOR_ITE */
    1, /* BITVECTOR_TO_NAT */
    1, /* BITVECTOR_ACKERMANNIZE_UDIV */
    1, /* BITVECTOR_ACKERMANNIZE_UREM */
    1, /* BITVECTOR_EAGER_ATOM */
    0, /* BITVECTOR_BITOF_OP */
    1, /* BITVECTOR_BITOF */
    0, /* BITVECTOR_EXTRACT_OP */
    1, /* BITVECTOR_EXTRACT */
    0, /* BITVECTOR_REPEAT_OP */
    1, /* BITVECTOR_REPEAT */
    0, /* BITVECTOR_ROTATE_LEFT_OP */
    1, /* BITVECTOR_ROTATE_LEFT */
    0, /* BITVECTOR_ROTATE_RIGHT_OP */
    1, /* BITVECTOR_ROTATE_RIGHT */
    0, /* BITVECTOR_SIGN_EXTEND_OP */
    1, /* BITVECTOR_SIGN_EXTEND */
    0, /* BITVECTOR_ZERO_EXTEND_OP */
    1, /* BITVECTOR_ZERO_EXTEND */
    0, /* INT_TO_BITVECTOR_OP */
    1, /* INT_TO_BITVECTOR */
    0, /* CONST_FLOATINGPOINT */
    0, /* CONST_ROUNDINGMODE */
    0, /* FLOATINGPOINT_TYPE */
    3, /* FLOATINGPOINT_FP */
    expr::NodeValue::MAX_CHILDREN, /* FLOATINGPOINT_EQ */
    1, /* FLOATINGPOINT_ABS */
    1, /* FLOATINGPOINT_NEG */
    3, /* FLOATINGPOINT_PLUS */
    3, /* FLOATINGPOINT_SUB */
    3, /* FLOATINGPOINT_MULT */
    3, /* FLOATINGPOINT_DIV */
    4, /* FLOATINGPOINT_FMA */
    2, /* FLOATINGPOINT_SQRT */
    2, /* FLOATINGPOINT_REM */
    2, /* FLOATINGPOINT_RTI */
    2, /* FLOATINGPOINT_MIN */
    2, /* FLOATINGPOINT_MAX */
    3, /* FLOATINGPOINT_MIN_TOTAL */
    3, /* FLOATINGPOINT_MAX_TOTAL */
    expr::NodeValue::MAX_CHILDREN, /* FLOATINGPOINT_LEQ */
    expr::NodeValue::MAX_CHILDREN, /* FLOATINGPOINT_LT */
    expr::NodeValue::MAX_CHILDREN, /* FLOATINGPOINT_GEQ */
    expr::NodeValue::MAX_CHILDREN, /* FLOATINGPOINT_GT */
    1, /* FLOATINGPOINT_ISN */
    1, /* FLOATINGPOINT_ISSN */
    1, /* FLOATINGPOINT_ISZ */
    1, /* FLOATINGPOINT_ISINF */
    1, /* FLOATINGPOINT_ISNAN */
    1, /* FLOATINGPOINT_ISNEG */
    1, /* FLOATINGPOINT_ISPOS */
    0, /* FLOATINGPOINT_TO_FP_IEEE_BITVECTOR_OP */
    1, /* FLOATINGPOINT_TO_FP_IEEE_BITVECTOR */
    0, /* FLOATINGPOINT_TO_FP_FLOATINGPOINT_OP */
    2, /* FLOATINGPOINT_TO_FP_FLOATINGPOINT */
    0, /* FLOATINGPOINT_TO_FP_REAL_OP */
    2, /* FLOATINGPOINT_TO_FP_REAL */
    0, /* FLOATINGPOINT_TO_FP_SIGNED_BITVECTOR_OP */
    2, /* FLOATINGPOINT_TO_FP_SIGNED_BITVECTOR */
    0, /* FLOATINGPOINT_TO_FP_UNSIGNED_BITVECTOR_OP */
    2, /* FLOATINGPOINT_TO_FP_UNSIGNED_BITVECTOR */
    0, /* FLOATINGPOINT_TO_FP_GENERIC_OP */
    2, /* FLOATINGPOINT_TO_FP_GENERIC */
    0, /* FLOATINGPOINT_TO_UBV_OP */
    2, /* FLOATINGPOINT_TO_UBV */
    0, /* FLOATINGPOINT_TO_UBV_TOTAL_OP */
    3, /* FLOATINGPOINT_TO_UBV_TOTAL */
    0, /* FLOATINGPOINT_TO_SBV_OP */
    2, /* FLOATINGPOINT_TO_SBV */
    0, /* FLOATINGPOINT_TO_SBV_TOTAL_OP */
    3, /* FLOATINGPOINT_TO_SBV_TOTAL */
    1, /* FLOATINGPOINT_TO_REAL */
    2, /* FLOATINGPOINT_TO_REAL_TOTAL */
    1, /* FLOATINGPOINT_COMPONENT_NAN */
    1, /* FLOATINGPOINT_COMPONENT_INF */
    1, /* FLOATINGPOINT_COMPONENT_ZERO */
    1, /* FLOATINGPOINT_COMPONENT_SIGN */
    1, /* FLOATINGPOINT_COMPONENT_EXPONENT */
    1, /* FLOATINGPOINT_COMPONENT_SIGNIFICAND */
    1, /* ROUNDINGMODE_BITBLAST */
    2, /* ARRAY_TYPE */
    2, /* SELECT */
    3, /* STORE */
    0, /* STORE_ALL */
    4, /* ARR_TABLE_FUN */
    1, /* ARRAY_LAMBDA */
    2, /* PARTIAL_SELECT_0 */
    2, /* PARTIAL_SELECT_1 */
    expr::NodeValue::MAX_CHILDREN, /* CONSTRUCTOR_TYPE */
    2, /* SELECTOR_TYPE */
    1, /* TESTER_TYPE */
    expr::NodeValue::MAX_CHILDREN, /* APPLY_CONSTRUCTOR */
    1, /* APPLY_SELECTOR */
    1, /* APPLY_SELECTOR_TOTAL */
    1, /* APPLY_TESTER */
    0, /* DATATYPE_TYPE */
    expr::NodeValue::MAX_CHILDREN, /* PARAMETRIC_DATATYPE */
    1, /* APPLY_TYPE_ASCRIPTION */
    0, /* ASCRIPTION_TYPE */
    0, /* TUPLE_UPDATE_OP */
    2, /* TUPLE_UPDATE */
    0, /* RECORD_UPDATE_OP */
    2, /* RECORD_UPDATE */
    1, /* DT_SIZE */
    2, /* DT_HEIGHT_BOUND */
    2, /* DT_SIZE_BOUND */
    2, /* DT_SYGUS_BOUND */
    expr::NodeValue::MAX_CHILDREN, /* DT_SYGUS_EVAL */
    expr::NodeValue::MAX_CHILDREN, /* MATCH */
    2, /* MATCH_CASE */
    3, /* MATCH_BIND_CASE */
    0, /* SEP_NIL */
    2, /* SEP_EMP */
    2, /* SEP_PTO */
    expr::NodeValue::MAX_CHILDREN, /* SEP_STAR */
    2, /* SEP_WAND */
    2, /* SEP_LABEL */
    0, /* EMPTYSET */
    1, /* SET_TYPE */
    2, /* UNION */
    2, /* INTERSECTION */
    2, /* SETMINUS */
    2, /* SUBSET */
    2, /* MEMBER */
    1, /* SINGLETON */
    expr::NodeValue::MAX_CHILDREN, /* INSERT */
    1, /* CARD */
    1, /* COMPLEMENT */
    0, /* UNIVERSE_SET */
    3, /* COMPREHENSION */
    1, /* CHOOSE */
    2, /* JOIN */
    2, /* PRODUCT */
    1, /* TRANSPOSE */
    1, /* TCLOSURE */
    2, /* JOIN_IMAGE */
    1, /* IDEN */
    expr::NodeValue::MAX_CHILDREN, /* STRING_CONCAT */
    2, /* STRING_IN_REGEXP */
    1, /* STRING_LENGTH */
    3, /* STRING_SUBSTR */
    2, /* STRING_CHARAT */
    2, /* STRING_STRCTN */
    2, /* STRING_LT */
    2, /* STRING_LEQ */
    3, /* STRING_STRIDOF */
    3, /* STRING_STRREPL */
    3, /* STRING_STRREPLALL */
    3, /* STRING_REPLACE_RE */
    3, /* STRING_REPLACE_RE_ALL */
    2, /* STRING_PREFIX */
    2, /* STRING_SUFFIX */
    1, /* STRING_IS_DIGIT */
    1, /* STRING_ITOS */
    1, /* STRING_STOI */
    1, /* STRING_TO_CODE */
    1, /* STRING_FROM_CODE */
    1, /* STRING_TOLOWER */
    1, /* STRING_TOUPPER */
    1, /* STRING_REV */
    0, /* CONST_STRING */
    1, /* SEQUENCE_TYPE */
    0, /* CONST_SEQUENCE */
    1, /* SEQ_UNIT */
    1, /* STRING_TO_REGEXP */
    expr::NodeValue::MAX_CHILDREN, /* REGEXP_CONCAT */
    expr::NodeValue::MAX_CHILDREN, /* REGEXP_UNION */
    expr::NodeValue::MAX_CHILDREN, /* REGEXP_INTER */
    expr::NodeValue::MAX_CHILDREN, /* REGEXP_DIFF */
    1, /* REGEXP_STAR */
    1, /* REGEXP_PLUS */
    1, /* REGEXP_OPT */
    2, /* REGEXP_RANGE */
    1, /* REGEXP_COMPLEMENT */
    0, /* REGEXP_EMPTY */
    0, /* REGEXP_SIGMA */
    0, /* REGEXP_REPEAT_OP */
    1, /* REGEXP_REPEAT */
    0, /* REGEXP_LOOP_OP */
    1, /* REGEXP_LOOP */
    1, /* REGEXP_RV */
    3, /* FORALL */
    3, /* EXISTS */
    0, /* INST_CONSTANT */
    expr::NodeValue::MAX_CHILDREN, /* BOUND_VAR_LIST */
    expr::NodeValue::MAX_CHILDREN, /* INST_PATTERN */
    1, /* INST_NO_PATTERN */
    1, /* INST_ATTRIBUTE */
    expr::NodeValue::MAX_CHILDREN, /* INST_PATTERN_LIST */
    1, /* INST_CLOSURE */

    0, /* LAST_KIND */
  };

  return ubs[k];
}

}/* CVC4::metakind namespace */

/**
 * Map a kind of the operator to the kind of the enclosing expression. For
 * example, since the kind of functions is just VARIABLE, it should map
 * VARIABLE to APPLY_UF.
 */
Kind operatorToKind(::CVC4::expr::NodeValue* nv) {
  if(nv->getKind() == kind::BUILTIN) {
    return nv->getConst<Kind>();
  } else if(nv->getKind() == kind::LAMBDA) {
    return kind::APPLY_UF;
  }

  switch(Kind k CVC4_UNUSED = nv->getKind()) {


    /* from builtin */
#line 257 "/build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds"
    case kind::SORT_TAG: return kind::SORT_TYPE;

    /* from booleans */

    /* from uf */
#line 14 "/build/cvc4/src/cvc5-1.8/src/theory/uf/kinds"
    case kind::VARIABLE: return kind::APPLY_UF;
#line 26 "/build/cvc4/src/cvc5-1.8/src/theory/uf/kinds"
    case kind::APPLY_UF: return kind::PARTIAL_APPLY_UF;

    /* from arith */
#line 27 "/build/cvc4/src/cvc5-1.8/src/theory/arith/kinds"
    case kind::DIVISIBLE_OP: return kind::DIVISIBLE;

    /* from bv */
#line 108 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    case kind::BITVECTOR_BITOF_OP: return kind::BITVECTOR_BITOF;
#line 115 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    case kind::BITVECTOR_EXTRACT_OP: return kind::BITVECTOR_EXTRACT;
#line 122 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    case kind::BITVECTOR_REPEAT_OP: return kind::BITVECTOR_REPEAT;
#line 129 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    case kind::BITVECTOR_ROTATE_LEFT_OP: return kind::BITVECTOR_ROTATE_LEFT;
#line 136 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    case kind::BITVECTOR_ROTATE_RIGHT_OP: return kind::BITVECTOR_ROTATE_RIGHT;
#line 143 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    case kind::BITVECTOR_SIGN_EXTEND_OP: return kind::BITVECTOR_SIGN_EXTEND;
#line 150 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    case kind::BITVECTOR_ZERO_EXTEND_OP: return kind::BITVECTOR_ZERO_EXTEND;
#line 157 "/build/cvc4/src/cvc5-1.8/src/theory/bv/kinds"
    case kind::INT_TO_BITVECTOR_OP: return kind::INT_TO_BITVECTOR;

    /* from fp */
#line 164 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    case kind::FLOATINGPOINT_TO_FP_IEEE_BITVECTOR_OP: return kind::FLOATINGPOINT_TO_FP_IEEE_BITVECTOR;
#line 176 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    case kind::FLOATINGPOINT_TO_FP_FLOATINGPOINT_OP: return kind::FLOATINGPOINT_TO_FP_FLOATINGPOINT;
#line 189 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    case kind::FLOATINGPOINT_TO_FP_REAL_OP: return kind::FLOATINGPOINT_TO_FP_REAL;
#line 201 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    case kind::FLOATINGPOINT_TO_FP_SIGNED_BITVECTOR_OP: return kind::FLOATINGPOINT_TO_FP_SIGNED_BITVECTOR;
#line 214 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    case kind::FLOATINGPOINT_TO_FP_UNSIGNED_BITVECTOR_OP: return kind::FLOATINGPOINT_TO_FP_UNSIGNED_BITVECTOR;
#line 227 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    case kind::FLOATINGPOINT_TO_FP_GENERIC_OP: return kind::FLOATINGPOINT_TO_FP_GENERIC;
#line 241 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    case kind::FLOATINGPOINT_TO_UBV_OP: return kind::FLOATINGPOINT_TO_UBV;
#line 252 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    case kind::FLOATINGPOINT_TO_UBV_TOTAL_OP: return kind::FLOATINGPOINT_TO_UBV_TOTAL;
#line 264 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    case kind::FLOATINGPOINT_TO_SBV_OP: return kind::FLOATINGPOINT_TO_SBV;
#line 275 "/build/cvc4/src/cvc5-1.8/src/theory/fp/kinds"
    case kind::FLOATINGPOINT_TO_SBV_TOTAL_OP: return kind::FLOATINGPOINT_TO_SBV_TOTAL;

    /* from arrays */

    /* from datatypes */
#line 34 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
    case kind::APPLY_TYPE_ASCRIPTION: return kind::APPLY_CONSTRUCTOR;
#line 36 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
    case kind::SELECTOR_TYPE: return kind::APPLY_SELECTOR;
#line 39 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
    case kind::TESTER_TYPE: return kind::APPLY_TESTER;
#line 71 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
    case kind::ASCRIPTION_TYPE: return kind::APPLY_TYPE_ASCRIPTION;
#line 93 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
    case kind::TUPLE_UPDATE_OP: return kind::TUPLE_UPDATE;
#line 102 "/build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds"
    case kind::RECORD_UPDATE_OP: return kind::RECORD_UPDATE;

    /* from sep */

    /* from sets */

    /* from strings */
#line 106 "/build/cvc4/src/cvc5-1.8/src/theory/strings/kinds"
    case kind::REGEXP_REPEAT_OP: return kind::REGEXP_REPEAT;
#line 113 "/build/cvc4/src/cvc5-1.8/src/theory/strings/kinds"
    case kind::REGEXP_LOOP_OP: return kind::REGEXP_LOOP;

    /* from quantifiers */

  default:
    return kind::UNDEFINED_KIND;  /* LAST_KIND */
  };
}

}/* CVC4::kind namespace */
}/* CVC4 namespace */
