/* FileService.c generated by valac 0.56.17, the Vala compiler
 * generated from FileService.vala, do not modify */

/*
 * Copyright (C) 2011-2017 elementary Developers
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: ammonkey <am.monkeyd@gmail.com>,
 *          lampe2 <michael@lazarski.me>,
 *          Akshay Shekher <voldyman666@gmail.com>,
 *          Victor Martinez <victoreduardm@gmail.com>
 *
 * Initial implementation of FileService was heavily inspired by
 * Synapse DesktopFileService. Kudos to the Synapse's developers!
 *
 * The original Contractor implementation in Python was created by:
 *          Allen Lowe <lallenlowe@gmail.com>
 */

#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>

#define CONTRACTOR_FILE_SERVICE_CONTRACT_DATA_DIR_NAME "contractor"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTRACTOR_TYPE_FILE_SERVICE (contractor_file_service_get_type ())
#define CONTRACTOR_FILE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTRACTOR_TYPE_FILE_SERVICE, ContractorFileService))
#define CONTRACTOR_FILE_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTRACTOR_TYPE_FILE_SERVICE, ContractorFileServiceClass))
#define CONTRACTOR_IS_FILE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTRACTOR_TYPE_FILE_SERVICE))
#define CONTRACTOR_IS_FILE_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTRACTOR_TYPE_FILE_SERVICE))
#define CONTRACTOR_FILE_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTRACTOR_TYPE_FILE_SERVICE, ContractorFileServiceClass))

typedef struct _ContractorFileService ContractorFileService;
typedef struct _ContractorFileServiceClass ContractorFileServiceClass;
typedef struct _ContractorFileServicePrivate ContractorFileServicePrivate;

#define CONTRACTOR_TYPE_CONTRACT_DIRECTORY (contractor_contract_directory_get_type ())
#define CONTRACTOR_CONTRACT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTRACTOR_TYPE_CONTRACT_DIRECTORY, ContractorContractDirectory))
#define CONTRACTOR_CONTRACT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTRACTOR_TYPE_CONTRACT_DIRECTORY, ContractorContractDirectoryClass))
#define CONTRACTOR_IS_CONTRACT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTRACTOR_TYPE_CONTRACT_DIRECTORY))
#define CONTRACTOR_IS_CONTRACT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTRACTOR_TYPE_CONTRACT_DIRECTORY))
#define CONTRACTOR_CONTRACT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTRACTOR_TYPE_CONTRACT_DIRECTORY, ContractorContractDirectoryClass))

typedef struct _ContractorContractDirectory ContractorContractDirectory;
typedef struct _ContractorContractDirectoryClass ContractorContractDirectoryClass;
enum  {
	CONTRACTOR_FILE_SERVICE_0_PROPERTY,
	CONTRACTOR_FILE_SERVICE_NUM_PROPERTIES
};
static GParamSpec* contractor_file_service_properties[CONTRACTOR_FILE_SERVICE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	CONTRACTOR_FILE_SERVICE_CONTRACT_FILES_CHANGED_SIGNAL,
	CONTRACTOR_FILE_SERVICE_NUM_SIGNALS
};
static guint contractor_file_service_signals[CONTRACTOR_FILE_SERVICE_NUM_SIGNALS] = {0};

struct _ContractorFileService {
	GObject parent_instance;
	ContractorFileServicePrivate * priv;
};

struct _ContractorFileServiceClass {
	GObjectClass parent_class;
};

struct _ContractorFileServicePrivate {
	GeeList* directories;
};

static gint ContractorFileService_private_offset;
static gpointer contractor_file_service_parent_class = NULL;

VALA_EXTERN GType contractor_file_service_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContractorFileService, g_object_unref)
VALA_EXTERN GType contractor_contract_directory_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContractorContractDirectory, g_object_unref)
VALA_EXTERN ContractorFileService* contractor_file_service_new (void);
VALA_EXTERN ContractorFileService* contractor_file_service_construct (GType object_type);
static void contractor_file_service_set_up_directories (ContractorFileService* self);
VALA_EXTERN GeeList* contractor_file_service_load_contract_files (ContractorFileService* self);
VALA_EXTERN GeeList* contractor_contract_directory_lookup_contract_files (ContractorContractDirectory* self);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN ContractorContractDirectory* contractor_contract_directory_new (GFile* directory);
VALA_EXTERN ContractorContractDirectory* contractor_contract_directory_construct (GType object_type,
                                                                      GFile* directory);
static void ____lambda4_ (ContractorFileService* self);
static void _____lambda4__contractor_contract_directory_changed (ContractorContractDirectory* _sender,
                                                          gpointer self);
static void contractor_file_service_finalize (GObject * obj);
static GType contractor_file_service_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
contractor_file_service_get_instance_private (ContractorFileService* self)
{
	return G_STRUCT_MEMBER_P (self, ContractorFileService_private_offset);
}

ContractorFileService*
contractor_file_service_construct (GType object_type)
{
	ContractorFileService * self = NULL;
	GeeLinkedList* _tmp0_;
	self = (ContractorFileService*) g_object_new (object_type, NULL);
	_tmp0_ = gee_linked_list_new (CONTRACTOR_TYPE_CONTRACT_DIRECTORY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->directories);
	self->priv->directories = (GeeList*) _tmp0_;
	contractor_file_service_set_up_directories (self);
	return self;
}

ContractorFileService*
contractor_file_service_new (void)
{
	return contractor_file_service_construct (CONTRACTOR_TYPE_FILE_SERVICE);
}

GeeList*
contractor_file_service_load_contract_files (ContractorFileService* self)
{
	GeeLinkedList* contract_files = NULL;
	GeeLinkedList* _tmp0_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_linked_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	contract_files = _tmp0_;
	{
		GeeList* _directory_list = NULL;
		GeeList* _tmp1_;
		gint _directory_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _directory_index = 0;
		_tmp1_ = self->priv->directories;
		_directory_list = _tmp1_;
		_tmp2_ = _directory_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_directory_size = _tmp4_;
		_directory_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ContractorContractDirectory* directory = NULL;
			GeeList* _tmp7_;
			gpointer _tmp8_;
			GeeLinkedList* _tmp9_;
			ContractorContractDirectory* _tmp10_;
			GeeList* _tmp11_;
			GeeList* _tmp12_;
			_directory_index = _directory_index + 1;
			_tmp5_ = _directory_index;
			_tmp6_ = _directory_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _directory_list;
			_tmp8_ = gee_list_get (_tmp7_, _directory_index);
			directory = (ContractorContractDirectory*) _tmp8_;
			_tmp9_ = contract_files;
			_tmp10_ = directory;
			_tmp11_ = contractor_contract_directory_lookup_contract_files (_tmp10_);
			_tmp12_ = _tmp11_;
			gee_collection_add_all ((GeeCollection*) _tmp9_, (GeeCollection*) _tmp12_);
			_g_object_unref0 (_tmp12_);
			_g_object_unref0 (directory);
		}
	}
	result = (GeeList*) contract_files;
	return result;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
____lambda4_ (ContractorFileService* self)
{
	g_signal_emit (self, contractor_file_service_signals[CONTRACTOR_FILE_SERVICE_CONTRACT_FILES_CHANGED_SIGNAL], 0);
}

static void
_____lambda4__contractor_contract_directory_changed (ContractorContractDirectory* _sender,
                                                     gpointer self)
{
	____lambda4_ ((ContractorFileService*) self);
}

static void
contractor_file_service_set_up_directories (ContractorFileService* self)
{
	gchar** data_dir_paths = NULL;
	gchar** _tmp0_;
	gint data_dir_paths_length1;
	gint _data_dir_paths_size_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	data_dir_paths = _tmp0_;
	data_dir_paths_length1 = 0;
	_data_dir_paths_size_ = data_dir_paths_length1;
	_tmp1_ = g_get_user_data_dir ();
	_tmp2_ = g_strdup (_tmp1_);
	_vala_array_add2 (&data_dir_paths, &data_dir_paths_length1, &_data_dir_paths_size_, _tmp2_);
	_tmp4_ = _tmp3_ = g_get_system_data_dirs ();
	{
		gchar** data_dir_collection = NULL;
		gint data_dir_collection_length1 = 0;
		gint _data_dir_collection_size_ = 0;
		gint data_dir_it = 0;
		data_dir_collection = _tmp4_;
		data_dir_collection_length1 = _vala_array_length (_tmp3_);
		for (data_dir_it = 0; data_dir_it < data_dir_collection_length1; data_dir_it = data_dir_it + 1) {
			gchar* _tmp5_;
			gchar* data_dir = NULL;
			_tmp5_ = g_strdup (data_dir_collection[data_dir_it]);
			data_dir = _tmp5_;
			{
				const gchar* _tmp6_;
				gchar* _tmp7_;
				_tmp6_ = data_dir;
				_tmp7_ = g_strdup (_tmp6_);
				_vala_array_add3 (&data_dir_paths, &data_dir_paths_length1, &_data_dir_paths_size_, _tmp7_);
				_g_free0 (data_dir);
			}
		}
	}
	_tmp8_ = data_dir_paths;
	_tmp8__length1 = data_dir_paths_length1;
	{
		gchar** path_collection = NULL;
		gint path_collection_length1 = 0;
		gint _path_collection_size_ = 0;
		gint path_it = 0;
		path_collection = _tmp8_;
		path_collection_length1 = _tmp8__length1;
		for (path_it = 0; path_it < path_collection_length1; path_it = path_it + 1) {
			gchar* _tmp9_;
			gchar* path = NULL;
			_tmp9_ = g_strdup (path_collection[path_it]);
			path = _tmp9_;
			{
				GFile* directory = NULL;
				const gchar* _tmp10_;
				GFile* _tmp11_;
				GFile* _tmp12_;
				GFile* _tmp13_;
				GFile* _tmp14_;
				ContractorContractDirectory* contract_dir = NULL;
				GFile* _tmp15_;
				ContractorContractDirectory* _tmp16_;
				ContractorContractDirectory* _tmp17_;
				GeeList* _tmp18_;
				ContractorContractDirectory* _tmp19_;
				_tmp10_ = path;
				_tmp11_ = g_file_new_for_path (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_file_get_child (_tmp12_, CONTRACTOR_FILE_SERVICE_CONTRACT_DATA_DIR_NAME);
				_tmp14_ = _tmp13_;
				_g_object_unref0 (_tmp12_);
				directory = _tmp14_;
				_tmp15_ = directory;
				_tmp16_ = contractor_contract_directory_new (_tmp15_);
				contract_dir = _tmp16_;
				_tmp17_ = contract_dir;
				g_signal_connect_object (_tmp17_, "changed", (GCallback) _____lambda4__contractor_contract_directory_changed, self, 0);
				_tmp18_ = self->priv->directories;
				_tmp19_ = contract_dir;
				gee_collection_add ((GeeCollection*) _tmp18_, _tmp19_);
				_g_object_unref0 (contract_dir);
				_g_object_unref0 (directory);
				_g_free0 (path);
			}
		}
	}
	data_dir_paths = (_vala_array_free (data_dir_paths, data_dir_paths_length1, (GDestroyNotify) g_free), NULL);
}

static void
contractor_file_service_class_init (ContractorFileServiceClass * klass,
                                    gpointer klass_data)
{
	contractor_file_service_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContractorFileService_private_offset);
	G_OBJECT_CLASS (klass)->finalize = contractor_file_service_finalize;
	contractor_file_service_signals[CONTRACTOR_FILE_SERVICE_CONTRACT_FILES_CHANGED_SIGNAL] = g_signal_new ("contract-files-changed", CONTRACTOR_TYPE_FILE_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
contractor_file_service_instance_init (ContractorFileService * self,
                                       gpointer klass)
{
	self->priv = contractor_file_service_get_instance_private (self);
}

static void
contractor_file_service_finalize (GObject * obj)
{
	ContractorFileService * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTRACTOR_TYPE_FILE_SERVICE, ContractorFileService);
	_g_object_unref0 (self->priv->directories);
	G_OBJECT_CLASS (contractor_file_service_parent_class)->finalize (obj);
}

static GType
contractor_file_service_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContractorFileServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contractor_file_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContractorFileService), 0, (GInstanceInitFunc) contractor_file_service_instance_init, NULL };
	GType contractor_file_service_type_id;
	contractor_file_service_type_id = g_type_register_static (G_TYPE_OBJECT, "ContractorFileService", &g_define_type_info, 0);
	ContractorFileService_private_offset = g_type_add_instance_private (contractor_file_service_type_id, sizeof (ContractorFileServicePrivate));
	return contractor_file_service_type_id;
}

GType
contractor_file_service_get_type (void)
{
	static volatile gsize contractor_file_service_type_id__once = 0;
	if (g_once_init_enter (&contractor_file_service_type_id__once)) {
		GType contractor_file_service_type_id;
		contractor_file_service_type_id = contractor_file_service_get_type_once ();
		g_once_init_leave (&contractor_file_service_type_id__once, contractor_file_service_type_id);
	}
	return contractor_file_service_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

