/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	certmanagerv1 "github.com/cert-manager/cert-manager/pkg/apis/certmanager/v1"
	metav1 "github.com/cert-manager/cert-manager/pkg/apis/meta/v1"
	apismetav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

// CertificateConditionApplyConfiguration represents a declarative configuration of the CertificateCondition type for use
// with apply.
type CertificateConditionApplyConfiguration struct {
	Type               *certmanagerv1.CertificateConditionType `json:"type,omitempty"`
	Status             *metav1.ConditionStatus                 `json:"status,omitempty"`
	LastTransitionTime *apismetav1.Time                        `json:"lastTransitionTime,omitempty"`
	Reason             *string                                 `json:"reason,omitempty"`
	Message            *string                                 `json:"message,omitempty"`
	ObservedGeneration *int64                                  `json:"observedGeneration,omitempty"`
}

// CertificateConditionApplyConfiguration constructs a declarative configuration of the CertificateCondition type for use with
// apply.
func CertificateCondition() *CertificateConditionApplyConfiguration {
	return &CertificateConditionApplyConfiguration{}
}

// WithType sets the Type field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Type field is set to the value of the last call.
func (b *CertificateConditionApplyConfiguration) WithType(value certmanagerv1.CertificateConditionType) *CertificateConditionApplyConfiguration {
	b.Type = &value
	return b
}

// WithStatus sets the Status field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Status field is set to the value of the last call.
func (b *CertificateConditionApplyConfiguration) WithStatus(value metav1.ConditionStatus) *CertificateConditionApplyConfiguration {
	b.Status = &value
	return b
}

// WithLastTransitionTime sets the LastTransitionTime field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the LastTransitionTime field is set to the value of the last call.
func (b *CertificateConditionApplyConfiguration) WithLastTransitionTime(value apismetav1.Time) *CertificateConditionApplyConfiguration {
	b.LastTransitionTime = &value
	return b
}

// WithReason sets the Reason field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Reason field is set to the value of the last call.
func (b *CertificateConditionApplyConfiguration) WithReason(value string) *CertificateConditionApplyConfiguration {
	b.Reason = &value
	return b
}

// WithMessage sets the Message field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Message field is set to the value of the last call.
func (b *CertificateConditionApplyConfiguration) WithMessage(value string) *CertificateConditionApplyConfiguration {
	b.Message = &value
	return b
}

// WithObservedGeneration sets the ObservedGeneration field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ObservedGeneration field is set to the value of the last call.
func (b *CertificateConditionApplyConfiguration) WithObservedGeneration(value int64) *CertificateConditionApplyConfiguration {
	b.ObservedGeneration = &value
	return b
}
