// Copyright 2023-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        (unknown)
// source: buf/registry/plugin/v1beta1/plugin_service.proto

//go:build !protoopaque

package pluginv1beta1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	v1 "buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/owner/v1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The list order.
type ListPluginsRequest_Order int32

const (
	ListPluginsRequest_ORDER_UNSPECIFIED ListPluginsRequest_Order = 0
	// Order by create_time newest to oldest.
	ListPluginsRequest_ORDER_CREATE_TIME_DESC ListPluginsRequest_Order = 1
	// Order by create_time oldest to newest.
	ListPluginsRequest_ORDER_CREATE_TIME_ASC ListPluginsRequest_Order = 2
)

// Enum value maps for ListPluginsRequest_Order.
var (
	ListPluginsRequest_Order_name = map[int32]string{
		0: "ORDER_UNSPECIFIED",
		1: "ORDER_CREATE_TIME_DESC",
		2: "ORDER_CREATE_TIME_ASC",
	}
	ListPluginsRequest_Order_value = map[string]int32{
		"ORDER_UNSPECIFIED":      0,
		"ORDER_CREATE_TIME_DESC": 1,
		"ORDER_CREATE_TIME_ASC":  2,
	}
)

func (x ListPluginsRequest_Order) Enum() *ListPluginsRequest_Order {
	p := new(ListPluginsRequest_Order)
	*p = x
	return p
}

func (x ListPluginsRequest_Order) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListPluginsRequest_Order) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_registry_plugin_v1beta1_plugin_service_proto_enumTypes[0].Descriptor()
}

func (ListPluginsRequest_Order) Type() protoreflect.EnumType {
	return &file_buf_registry_plugin_v1beta1_plugin_service_proto_enumTypes[0]
}

func (x ListPluginsRequest_Order) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

type GetPluginsRequest struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The Plugins to request.
	PluginRefs    []*PluginRef `protobuf:"bytes,1,rep,name=plugin_refs,json=pluginRefs,proto3" json:"plugin_refs,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetPluginsRequest) Reset() {
	*x = GetPluginsRequest{}
	mi := &file_buf_registry_plugin_v1beta1_plugin_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPluginsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPluginsRequest) ProtoMessage() {}

func (x *GetPluginsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_plugin_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetPluginsRequest) GetPluginRefs() []*PluginRef {
	if x != nil {
		return x.PluginRefs
	}
	return nil
}

func (x *GetPluginsRequest) SetPluginRefs(v []*PluginRef) {
	x.PluginRefs = v
}

type GetPluginsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Plugins to request.
	PluginRefs []*PluginRef
}

func (b0 GetPluginsRequest_builder) Build() *GetPluginsRequest {
	m0 := &GetPluginsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.PluginRefs = b.PluginRefs
	return m0
}

type GetPluginsResponse struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The retrieved Plugins in the same order as requested.
	Plugins       []*Plugin `protobuf:"bytes,1,rep,name=plugins,proto3" json:"plugins,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetPluginsResponse) Reset() {
	*x = GetPluginsResponse{}
	mi := &file_buf_registry_plugin_v1beta1_plugin_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPluginsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPluginsResponse) ProtoMessage() {}

func (x *GetPluginsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_plugin_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetPluginsResponse) GetPlugins() []*Plugin {
	if x != nil {
		return x.Plugins
	}
	return nil
}

func (x *GetPluginsResponse) SetPlugins(v []*Plugin) {
	x.Plugins = v
}

type GetPluginsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The retrieved Plugins in the same order as requested.
	Plugins []*Plugin
}

func (b0 GetPluginsResponse_builder) Build() *GetPluginsResponse {
	m0 := &GetPluginsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.Plugins = b.Plugins
	return m0
}

type ListPluginsRequest struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The maximum number of items to return.
	//
	// The default value is 10.
	PageSize uint32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The page to start from.
	//
	// If empty, the first page is returned.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The specific Organizations to list Plugins for.
	//
	// If empty, all Plugins for all Organizations are listed, but this functionality is limited to
	// Users with the necessary permissions.
	OwnerRefs []*v1.OwnerRef `protobuf:"bytes,3,rep,name=owner_refs,json=ownerRefs,proto3" json:"owner_refs,omitempty"`
	// The specific Collections to list Plugins for.
	//
	// If empty, all Plugins are listed regardless of collection.
	CollectionRefs []*CollectionRef `protobuf:"bytes,4,rep,name=collection_refs,json=collectionRefs,proto3" json:"collection_refs,omitempty"`
	// The order to return the Plugins.
	//
	// If not specified, defaults to ORDER_CREATE_TIME_DESC.
	Order         ListPluginsRequest_Order `protobuf:"varint,5,opt,name=order,proto3,enum=buf.registry.plugin.v1beta1.ListPluginsRequest_Order" json:"order,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListPluginsRequest) Reset() {
	*x = ListPluginsRequest{}
	mi := &file_buf_registry_plugin_v1beta1_plugin_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPluginsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPluginsRequest) ProtoMessage() {}

func (x *ListPluginsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_plugin_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListPluginsRequest) GetPageSize() uint32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPluginsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListPluginsRequest) GetOwnerRefs() []*v1.OwnerRef {
	if x != nil {
		return x.OwnerRefs
	}
	return nil
}

func (x *ListPluginsRequest) GetCollectionRefs() []*CollectionRef {
	if x != nil {
		return x.CollectionRefs
	}
	return nil
}

func (x *ListPluginsRequest) GetOrder() ListPluginsRequest_Order {
	if x != nil {
		return x.Order
	}
	return ListPluginsRequest_ORDER_UNSPECIFIED
}

func (x *ListPluginsRequest) SetPageSize(v uint32) {
	x.PageSize = v
}

func (x *ListPluginsRequest) SetPageToken(v string) {
	x.PageToken = v
}

func (x *ListPluginsRequest) SetOwnerRefs(v []*v1.OwnerRef) {
	x.OwnerRefs = v
}

func (x *ListPluginsRequest) SetCollectionRefs(v []*CollectionRef) {
	x.CollectionRefs = v
}

func (x *ListPluginsRequest) SetOrder(v ListPluginsRequest_Order) {
	x.Order = v
}

type ListPluginsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The maximum number of items to return.
	//
	// The default value is 10.
	PageSize uint32
	// The page to start from.
	//
	// If empty, the first page is returned.
	PageToken string
	// The specific Organizations to list Plugins for.
	//
	// If empty, all Plugins for all Organizations are listed, but this functionality is limited to
	// Users with the necessary permissions.
	OwnerRefs []*v1.OwnerRef
	// The specific Collections to list Plugins for.
	//
	// If empty, all Plugins are listed regardless of collection.
	CollectionRefs []*CollectionRef
	// The order to return the Plugins.
	//
	// If not specified, defaults to ORDER_CREATE_TIME_DESC.
	Order ListPluginsRequest_Order
}

func (b0 ListPluginsRequest_builder) Build() *ListPluginsRequest {
	m0 := &ListPluginsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.PageSize = b.PageSize
	x.PageToken = b.PageToken
	x.OwnerRefs = b.OwnerRefs
	x.CollectionRefs = b.CollectionRefs
	x.Order = b.Order
	return m0
}

type ListPluginsResponse struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The next page token.
	//
	// If empty, there are no more pages.
	NextPageToken string `protobuf:"bytes,1,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The listed Plugins.
	Plugins       []*Plugin `protobuf:"bytes,2,rep,name=plugins,proto3" json:"plugins,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListPluginsResponse) Reset() {
	*x = ListPluginsResponse{}
	mi := &file_buf_registry_plugin_v1beta1_plugin_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPluginsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPluginsResponse) ProtoMessage() {}

func (x *ListPluginsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_plugin_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListPluginsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListPluginsResponse) GetPlugins() []*Plugin {
	if x != nil {
		return x.Plugins
	}
	return nil
}

func (x *ListPluginsResponse) SetNextPageToken(v string) {
	x.NextPageToken = v
}

func (x *ListPluginsResponse) SetPlugins(v []*Plugin) {
	x.Plugins = v
}

type ListPluginsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The next page token.
	//
	// If empty, there are no more pages.
	NextPageToken string
	// The listed Plugins.
	Plugins []*Plugin
}

func (b0 ListPluginsResponse_builder) Build() *ListPluginsResponse {
	m0 := &ListPluginsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.NextPageToken = b.NextPageToken
	x.Plugins = b.Plugins
	return m0
}

type CreatePluginsRequest struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The Plugins to create.
	Values        []*CreatePluginsRequest_Value `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreatePluginsRequest) Reset() {
	*x = CreatePluginsRequest{}
	mi := &file_buf_registry_plugin_v1beta1_plugin_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreatePluginsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePluginsRequest) ProtoMessage() {}

func (x *CreatePluginsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_plugin_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreatePluginsRequest) GetValues() []*CreatePluginsRequest_Value {
	if x != nil {
		return x.Values
	}
	return nil
}

func (x *CreatePluginsRequest) SetValues(v []*CreatePluginsRequest_Value) {
	x.Values = v
}

type CreatePluginsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Plugins to create.
	Values []*CreatePluginsRequest_Value
}

func (b0 CreatePluginsRequest_builder) Build() *CreatePluginsRequest {
	m0 := &CreatePluginsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.Values = b.Values
	return m0
}

type CreatePluginsResponse struct {
	state         protoimpl.MessageState `protogen:"hybrid.v1"`
	Plugins       []*Plugin              `protobuf:"bytes,1,rep,name=plugins,proto3" json:"plugins,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreatePluginsResponse) Reset() {
	*x = CreatePluginsResponse{}
	mi := &file_buf_registry_plugin_v1beta1_plugin_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreatePluginsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePluginsResponse) ProtoMessage() {}

func (x *CreatePluginsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_plugin_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreatePluginsResponse) GetPlugins() []*Plugin {
	if x != nil {
		return x.Plugins
	}
	return nil
}

func (x *CreatePluginsResponse) SetPlugins(v []*Plugin) {
	x.Plugins = v
}

type CreatePluginsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Plugins []*Plugin
}

func (b0 CreatePluginsResponse_builder) Build() *CreatePluginsResponse {
	m0 := &CreatePluginsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.Plugins = b.Plugins
	return m0
}

type UpdatePluginsRequest struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The Plugins to update.
	Values        []*UpdatePluginsRequest_Value `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdatePluginsRequest) Reset() {
	*x = UpdatePluginsRequest{}
	mi := &file_buf_registry_plugin_v1beta1_plugin_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdatePluginsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePluginsRequest) ProtoMessage() {}

func (x *UpdatePluginsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_plugin_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UpdatePluginsRequest) GetValues() []*UpdatePluginsRequest_Value {
	if x != nil {
		return x.Values
	}
	return nil
}

func (x *UpdatePluginsRequest) SetValues(v []*UpdatePluginsRequest_Value) {
	x.Values = v
}

type UpdatePluginsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Plugins to update.
	Values []*UpdatePluginsRequest_Value
}

func (b0 UpdatePluginsRequest_builder) Build() *UpdatePluginsRequest {
	m0 := &UpdatePluginsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.Values = b.Values
	return m0
}

type UpdatePluginsResponse struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The updated Plugins in the same order as given on the request.
	Plugins       []*Plugin `protobuf:"bytes,1,rep,name=plugins,proto3" json:"plugins,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdatePluginsResponse) Reset() {
	*x = UpdatePluginsResponse{}
	mi := &file_buf_registry_plugin_v1beta1_plugin_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdatePluginsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePluginsResponse) ProtoMessage() {}

func (x *UpdatePluginsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_plugin_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UpdatePluginsResponse) GetPlugins() []*Plugin {
	if x != nil {
		return x.Plugins
	}
	return nil
}

func (x *UpdatePluginsResponse) SetPlugins(v []*Plugin) {
	x.Plugins = v
}

type UpdatePluginsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The updated Plugins in the same order as given on the request.
	Plugins []*Plugin
}

func (b0 UpdatePluginsResponse_builder) Build() *UpdatePluginsResponse {
	m0 := &UpdatePluginsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.Plugins = b.Plugins
	return m0
}

type DeletePluginsRequest struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The Plugins to delete.
	PluginRefs    []*PluginRef `protobuf:"bytes,1,rep,name=plugin_refs,json=pluginRefs,proto3" json:"plugin_refs,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeletePluginsRequest) Reset() {
	*x = DeletePluginsRequest{}
	mi := &file_buf_registry_plugin_v1beta1_plugin_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeletePluginsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePluginsRequest) ProtoMessage() {}

func (x *DeletePluginsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_plugin_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DeletePluginsRequest) GetPluginRefs() []*PluginRef {
	if x != nil {
		return x.PluginRefs
	}
	return nil
}

func (x *DeletePluginsRequest) SetPluginRefs(v []*PluginRef) {
	x.PluginRefs = v
}

type DeletePluginsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Plugins to delete.
	PluginRefs []*PluginRef
}

func (b0 DeletePluginsRequest_builder) Build() *DeletePluginsRequest {
	m0 := &DeletePluginsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.PluginRefs = b.PluginRefs
	return m0
}

type DeletePluginsResponse struct {
	state         protoimpl.MessageState `protogen:"hybrid.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeletePluginsResponse) Reset() {
	*x = DeletePluginsResponse{}
	mi := &file_buf_registry_plugin_v1beta1_plugin_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeletePluginsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePluginsResponse) ProtoMessage() {}

func (x *DeletePluginsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_plugin_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type DeletePluginsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 DeletePluginsResponse_builder) Build() *DeletePluginsResponse {
	m0 := &DeletePluginsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

// An individual request to create a Plugin.
type CreatePluginsRequest_Value struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The Organization to create the Plugin under. The OwnerRef must be a reference to an
	// Organization and cannot be a User reference.
	OwnerRef *v1.OwnerRef `protobuf:"bytes,1,opt,name=owner_ref,json=ownerRef,proto3" json:"owner_ref,omitempty"`
	// The name of the Plugin.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The plugin's visibility.
	Visibility PluginVisibility `protobuf:"varint,3,opt,name=visibility,proto3,enum=buf.registry.plugin.v1beta1.PluginVisibility" json:"visibility,omitempty"`
	// The configurable description of the Plugin.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// The configurable source URL of the Plugin.
	SourceUrl string `protobuf:"bytes,5,opt,name=source_url,json=sourceUrl,proto3" json:"source_url,omitempty"`
	// The Plugin type.
	Type          PluginType `protobuf:"varint,6,opt,name=type,proto3,enum=buf.registry.plugin.v1beta1.PluginType" json:"type,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreatePluginsRequest_Value) Reset() {
	*x = CreatePluginsRequest_Value{}
	mi := &file_buf_registry_plugin_v1beta1_plugin_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreatePluginsRequest_Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePluginsRequest_Value) ProtoMessage() {}

func (x *CreatePluginsRequest_Value) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_plugin_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreatePluginsRequest_Value) GetOwnerRef() *v1.OwnerRef {
	if x != nil {
		return x.OwnerRef
	}
	return nil
}

func (x *CreatePluginsRequest_Value) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreatePluginsRequest_Value) GetVisibility() PluginVisibility {
	if x != nil {
		return x.Visibility
	}
	return PluginVisibility_PLUGIN_VISIBILITY_UNSPECIFIED
}

func (x *CreatePluginsRequest_Value) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CreatePluginsRequest_Value) GetSourceUrl() string {
	if x != nil {
		return x.SourceUrl
	}
	return ""
}

func (x *CreatePluginsRequest_Value) GetType() PluginType {
	if x != nil {
		return x.Type
	}
	return PluginType_PLUGIN_TYPE_UNSPECIFIED
}

func (x *CreatePluginsRequest_Value) SetOwnerRef(v *v1.OwnerRef) {
	x.OwnerRef = v
}

func (x *CreatePluginsRequest_Value) SetName(v string) {
	x.Name = v
}

func (x *CreatePluginsRequest_Value) SetVisibility(v PluginVisibility) {
	x.Visibility = v
}

func (x *CreatePluginsRequest_Value) SetDescription(v string) {
	x.Description = v
}

func (x *CreatePluginsRequest_Value) SetSourceUrl(v string) {
	x.SourceUrl = v
}

func (x *CreatePluginsRequest_Value) SetType(v PluginType) {
	x.Type = v
}

func (x *CreatePluginsRequest_Value) HasOwnerRef() bool {
	if x == nil {
		return false
	}
	return x.OwnerRef != nil
}

func (x *CreatePluginsRequest_Value) ClearOwnerRef() {
	x.OwnerRef = nil
}

type CreatePluginsRequest_Value_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Organization to create the Plugin under. The OwnerRef must be a reference to an
	// Organization and cannot be a User reference.
	OwnerRef *v1.OwnerRef
	// The name of the Plugin.
	Name string
	// The plugin's visibility.
	Visibility PluginVisibility
	// The configurable description of the Plugin.
	Description string
	// The configurable source URL of the Plugin.
	SourceUrl string
	// The Plugin type.
	Type PluginType
}

func (b0 CreatePluginsRequest_Value_builder) Build() *CreatePluginsRequest_Value {
	m0 := &CreatePluginsRequest_Value{}
	b, x := &b0, m0
	_, _ = b, x
	x.OwnerRef = b.OwnerRef
	x.Name = b.Name
	x.Visibility = b.Visibility
	x.Description = b.Description
	x.SourceUrl = b.SourceUrl
	x.Type = b.Type
	return m0
}

// An individual request to update a Plugin.
type UpdatePluginsRequest_Value struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The Plugin to update.
	PluginRef *PluginRef `protobuf:"bytes,1,opt,name=plugin_ref,json=pluginRef,proto3" json:"plugin_ref,omitempty"`
	// The plugins's visibility.
	Visibility *PluginVisibility `protobuf:"varint,2,opt,name=visibility,proto3,enum=buf.registry.plugin.v1beta1.PluginVisibility,oneof" json:"visibility,omitempty"`
	// The deprecation status of the Plugin.
	State *PluginState `protobuf:"varint,3,opt,name=state,proto3,enum=buf.registry.plugin.v1beta1.PluginState,oneof" json:"state,omitempty"`
	// The configurable description of the Plugin.
	Description *string `protobuf:"bytes,4,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// The configurable source URL in the description of the Plugin.
	SourceUrl     *string `protobuf:"bytes,5,opt,name=source_url,json=sourceUrl,proto3,oneof" json:"source_url,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdatePluginsRequest_Value) Reset() {
	*x = UpdatePluginsRequest_Value{}
	mi := &file_buf_registry_plugin_v1beta1_plugin_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdatePluginsRequest_Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePluginsRequest_Value) ProtoMessage() {}

func (x *UpdatePluginsRequest_Value) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_plugin_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UpdatePluginsRequest_Value) GetPluginRef() *PluginRef {
	if x != nil {
		return x.PluginRef
	}
	return nil
}

func (x *UpdatePluginsRequest_Value) GetVisibility() PluginVisibility {
	if x != nil && x.Visibility != nil {
		return *x.Visibility
	}
	return PluginVisibility_PLUGIN_VISIBILITY_UNSPECIFIED
}

func (x *UpdatePluginsRequest_Value) GetState() PluginState {
	if x != nil && x.State != nil {
		return *x.State
	}
	return PluginState_PLUGIN_STATE_UNSPECIFIED
}

func (x *UpdatePluginsRequest_Value) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *UpdatePluginsRequest_Value) GetSourceUrl() string {
	if x != nil && x.SourceUrl != nil {
		return *x.SourceUrl
	}
	return ""
}

func (x *UpdatePluginsRequest_Value) SetPluginRef(v *PluginRef) {
	x.PluginRef = v
}

func (x *UpdatePluginsRequest_Value) SetVisibility(v PluginVisibility) {
	x.Visibility = &v
}

func (x *UpdatePluginsRequest_Value) SetState(v PluginState) {
	x.State = &v
}

func (x *UpdatePluginsRequest_Value) SetDescription(v string) {
	x.Description = &v
}

func (x *UpdatePluginsRequest_Value) SetSourceUrl(v string) {
	x.SourceUrl = &v
}

func (x *UpdatePluginsRequest_Value) HasPluginRef() bool {
	if x == nil {
		return false
	}
	return x.PluginRef != nil
}

func (x *UpdatePluginsRequest_Value) HasVisibility() bool {
	if x == nil {
		return false
	}
	return x.Visibility != nil
}

func (x *UpdatePluginsRequest_Value) HasState() bool {
	if x == nil {
		return false
	}
	return x.State != nil
}

func (x *UpdatePluginsRequest_Value) HasDescription() bool {
	if x == nil {
		return false
	}
	return x.Description != nil
}

func (x *UpdatePluginsRequest_Value) HasSourceUrl() bool {
	if x == nil {
		return false
	}
	return x.SourceUrl != nil
}

func (x *UpdatePluginsRequest_Value) ClearPluginRef() {
	x.PluginRef = nil
}

func (x *UpdatePluginsRequest_Value) ClearVisibility() {
	x.Visibility = nil
}

func (x *UpdatePluginsRequest_Value) ClearState() {
	x.State = nil
}

func (x *UpdatePluginsRequest_Value) ClearDescription() {
	x.Description = nil
}

func (x *UpdatePluginsRequest_Value) ClearSourceUrl() {
	x.SourceUrl = nil
}

type UpdatePluginsRequest_Value_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Plugin to update.
	PluginRef *PluginRef
	// The plugins's visibility.
	Visibility *PluginVisibility
	// The deprecation status of the Plugin.
	State *PluginState
	// The configurable description of the Plugin.
	Description *string
	// The configurable source URL in the description of the Plugin.
	SourceUrl *string
}

func (b0 UpdatePluginsRequest_Value_builder) Build() *UpdatePluginsRequest_Value {
	m0 := &UpdatePluginsRequest_Value{}
	b, x := &b0, m0
	_, _ = b, x
	x.PluginRef = b.PluginRef
	x.Visibility = b.Visibility
	x.State = b.State
	x.Description = b.Description
	x.SourceUrl = b.SourceUrl
	return m0
}

var File_buf_registry_plugin_v1beta1_plugin_service_proto protoreflect.FileDescriptor

const file_buf_registry_plugin_v1beta1_plugin_service_proto_rawDesc = "" +
	"\n" +
	"0buf/registry/plugin/v1beta1/plugin_service.proto\x12\x1bbuf.registry.plugin.v1beta1\x1a!buf/registry/owner/v1/owner.proto\x1a,buf/registry/plugin/v1beta1/collection.proto\x1a(buf/registry/plugin/v1beta1/plugin.proto\x1a\x1bbuf/validate/validate.proto\"i\n" +
	"\x11GetPluginsRequest\x12T\n" +
	"\vplugin_refs\x18\x01 \x03(\v2&.buf.registry.plugin.v1beta1.PluginRefB\v\xbaH\b\x92\x01\x05\b\x01\x10\xfa\x01R\n" +
	"pluginRefs\"]\n" +
	"\x12GetPluginsResponse\x12G\n" +
	"\aplugins\x18\x01 \x03(\v2#.buf.registry.plugin.v1beta1.PluginB\b\xbaH\x05\x92\x01\x02\b\x01R\aplugins\"\xa7\x03\n" +
	"\x12ListPluginsRequest\x12%\n" +
	"\tpage_size\x18\x01 \x01(\rB\b\xbaH\x05*\x03\x18\xfa\x01R\bpageSize\x12'\n" +
	"\n" +
	"page_token\x18\x02 \x01(\tB\b\xbaH\x05r\x03\x18\x80 R\tpageToken\x12>\n" +
	"\n" +
	"owner_refs\x18\x03 \x03(\v2\x1f.buf.registry.owner.v1.OwnerRefR\townerRefs\x12S\n" +
	"\x0fcollection_refs\x18\x04 \x03(\v2*.buf.registry.plugin.v1beta1.CollectionRefR\x0ecollectionRefs\x12U\n" +
	"\x05order\x18\x05 \x01(\x0e25.buf.registry.plugin.v1beta1.ListPluginsRequest.OrderB\b\xbaH\x05\x82\x01\x02\x10\x01R\x05order\"U\n" +
	"\x05Order\x12\x15\n" +
	"\x11ORDER_UNSPECIFIED\x10\x00\x12\x1a\n" +
	"\x16ORDER_CREATE_TIME_DESC\x10\x01\x12\x19\n" +
	"\x15ORDER_CREATE_TIME_ASC\x10\x02\"\x86\x01\n" +
	"\x13ListPluginsResponse\x120\n" +
	"\x0fnext_page_token\x18\x01 \x01(\tB\b\xbaH\x05r\x03\x18\x80 R\rnextPageToken\x12=\n" +
	"\aplugins\x18\x02 \x03(\v2#.buf.registry.plugin.v1beta1.PluginR\aplugins\"\xe4\x03\n" +
	"\x14CreatePluginsRequest\x12\\\n" +
	"\x06values\x18\x01 \x03(\v27.buf.registry.plugin.v1beta1.CreatePluginsRequest.ValueB\v\xbaH\b\x92\x01\x05\b\x01\x10\xfa\x01R\x06values\x1a\xed\x02\n" +
	"\x05Value\x12D\n" +
	"\towner_ref\x18\x01 \x01(\v2\x1f.buf.registry.owner.v1.OwnerRefB\x06\xbaH\x03\xc8\x01\x01R\bownerRef\x12\x1d\n" +
	"\x04name\x18\x02 \x01(\tB\t\xbaH\x06r\x04\x10\x02\x18dR\x04name\x12Z\n" +
	"\n" +
	"visibility\x18\x03 \x01(\x0e2-.buf.registry.plugin.v1beta1.PluginVisibilityB\v\xbaH\b\xc8\x01\x01\x82\x01\x02\x10\x01R\n" +
	"visibility\x12*\n" +
	"\vdescription\x18\x04 \x01(\tB\b\xbaH\x05r\x03\x18\xde\x02R\vdescription\x12-\n" +
	"\n" +
	"source_url\x18\x05 \x01(\tB\x0e\xbaH\v\xd8\x01\x01r\x06\x18\xff\x01\x88\x01\x01R\tsourceUrl\x12H\n" +
	"\x04type\x18\x06 \x01(\x0e2'.buf.registry.plugin.v1beta1.PluginTypeB\v\xbaH\b\xc8\x01\x01\x82\x01\x02\x10\x01R\x04type\"`\n" +
	"\x15CreatePluginsResponse\x12G\n" +
	"\aplugins\x18\x01 \x03(\v2#.buf.registry.plugin.v1beta1.PluginB\b\xbaH\x05\x92\x01\x02\b\x01R\aplugins\"\xdd\x04\n" +
	"\x14UpdatePluginsRequest\x12\\\n" +
	"\x06values\x18\x01 \x03(\v27.buf.registry.plugin.v1beta1.UpdatePluginsRequest.ValueB\v\xbaH\b\x92\x01\x05\b\x01\x10\xfa\x01R\x06values\x1a\xe6\x03\n" +
	"\x05Value\x12M\n" +
	"\n" +
	"plugin_ref\x18\x01 \x01(\v2&.buf.registry.plugin.v1beta1.PluginRefB\x06\xbaH\x03\xc8\x01\x01R\tpluginRef\x12^\n" +
	"\n" +
	"visibility\x18\x02 \x01(\x0e2-.buf.registry.plugin.v1beta1.PluginVisibilityB\n" +
	"\xbaH\a\x82\x01\x04\x10\x01 \x00H\x00R\n" +
	"visibility\x88\x01\x01\x12O\n" +
	"\x05state\x18\x03 \x01(\x0e2(.buf.registry.plugin.v1beta1.PluginStateB\n" +
	"\xbaH\a\x82\x01\x04\x10\x01 \x00H\x01R\x05state\x88\x01\x01\x12/\n" +
	"\vdescription\x18\x04 \x01(\tB\b\xbaH\x05r\x03\x18\xde\x02H\x02R\vdescription\x88\x01\x01\x12t\n" +
	"\n" +
	"source_url\x18\x05 \x01(\tBP\xbaHM\xba\x01E\n" +
	"\furi_or_empty\x12\x19value must be a valid URI\x1a\x1athis == '' || this.isUri()r\x03\x18\xff\x01H\x03R\tsourceUrl\x88\x01\x01B\r\n" +
	"\v_visibilityB\b\n" +
	"\x06_stateB\x0e\n" +
	"\f_descriptionB\r\n" +
	"\v_source_url\"`\n" +
	"\x15UpdatePluginsResponse\x12G\n" +
	"\aplugins\x18\x01 \x03(\v2#.buf.registry.plugin.v1beta1.PluginB\b\xbaH\x05\x92\x01\x02\b\x01R\aplugins\"l\n" +
	"\x14DeletePluginsRequest\x12T\n" +
	"\vplugin_refs\x18\x01 \x03(\v2&.buf.registry.plugin.v1beta1.PluginRefB\v\xbaH\b\x92\x01\x05\b\x01\x10\xfa\x01R\n" +
	"pluginRefs\"\x17\n" +
	"\x15DeletePluginsResponse2\xf1\x04\n" +
	"\rPluginService\x12r\n" +
	"\n" +
	"GetPlugins\x12..buf.registry.plugin.v1beta1.GetPluginsRequest\x1a/.buf.registry.plugin.v1beta1.GetPluginsResponse\"\x03\x90\x02\x01\x12u\n" +
	"\vListPlugins\x12/.buf.registry.plugin.v1beta1.ListPluginsRequest\x1a0.buf.registry.plugin.v1beta1.ListPluginsResponse\"\x03\x90\x02\x01\x12{\n" +
	"\rCreatePlugins\x121.buf.registry.plugin.v1beta1.CreatePluginsRequest\x1a2.buf.registry.plugin.v1beta1.CreatePluginsResponse\"\x03\x90\x02\x02\x12{\n" +
	"\rUpdatePlugins\x121.buf.registry.plugin.v1beta1.UpdatePluginsRequest\x1a2.buf.registry.plugin.v1beta1.UpdatePluginsResponse\"\x03\x90\x02\x02\x12{\n" +
	"\rDeletePlugins\x121.buf.registry.plugin.v1beta1.DeletePluginsRequest\x1a2.buf.registry.plugin.v1beta1.DeletePluginsResponse\"\x03\x90\x02\x02BaZ_buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/plugin/v1beta1;pluginv1beta1b\x06proto3"

var file_buf_registry_plugin_v1beta1_plugin_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_buf_registry_plugin_v1beta1_plugin_service_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_buf_registry_plugin_v1beta1_plugin_service_proto_goTypes = []any{
	(ListPluginsRequest_Order)(0),      // 0: buf.registry.plugin.v1beta1.ListPluginsRequest.Order
	(*GetPluginsRequest)(nil),          // 1: buf.registry.plugin.v1beta1.GetPluginsRequest
	(*GetPluginsResponse)(nil),         // 2: buf.registry.plugin.v1beta1.GetPluginsResponse
	(*ListPluginsRequest)(nil),         // 3: buf.registry.plugin.v1beta1.ListPluginsRequest
	(*ListPluginsResponse)(nil),        // 4: buf.registry.plugin.v1beta1.ListPluginsResponse
	(*CreatePluginsRequest)(nil),       // 5: buf.registry.plugin.v1beta1.CreatePluginsRequest
	(*CreatePluginsResponse)(nil),      // 6: buf.registry.plugin.v1beta1.CreatePluginsResponse
	(*UpdatePluginsRequest)(nil),       // 7: buf.registry.plugin.v1beta1.UpdatePluginsRequest
	(*UpdatePluginsResponse)(nil),      // 8: buf.registry.plugin.v1beta1.UpdatePluginsResponse
	(*DeletePluginsRequest)(nil),       // 9: buf.registry.plugin.v1beta1.DeletePluginsRequest
	(*DeletePluginsResponse)(nil),      // 10: buf.registry.plugin.v1beta1.DeletePluginsResponse
	(*CreatePluginsRequest_Value)(nil), // 11: buf.registry.plugin.v1beta1.CreatePluginsRequest.Value
	(*UpdatePluginsRequest_Value)(nil), // 12: buf.registry.plugin.v1beta1.UpdatePluginsRequest.Value
	(*PluginRef)(nil),                  // 13: buf.registry.plugin.v1beta1.PluginRef
	(*Plugin)(nil),                     // 14: buf.registry.plugin.v1beta1.Plugin
	(*v1.OwnerRef)(nil),                // 15: buf.registry.owner.v1.OwnerRef
	(*CollectionRef)(nil),              // 16: buf.registry.plugin.v1beta1.CollectionRef
	(PluginVisibility)(0),              // 17: buf.registry.plugin.v1beta1.PluginVisibility
	(PluginType)(0),                    // 18: buf.registry.plugin.v1beta1.PluginType
	(PluginState)(0),                   // 19: buf.registry.plugin.v1beta1.PluginState
}
var file_buf_registry_plugin_v1beta1_plugin_service_proto_depIdxs = []int32{
	13, // 0: buf.registry.plugin.v1beta1.GetPluginsRequest.plugin_refs:type_name -> buf.registry.plugin.v1beta1.PluginRef
	14, // 1: buf.registry.plugin.v1beta1.GetPluginsResponse.plugins:type_name -> buf.registry.plugin.v1beta1.Plugin
	15, // 2: buf.registry.plugin.v1beta1.ListPluginsRequest.owner_refs:type_name -> buf.registry.owner.v1.OwnerRef
	16, // 3: buf.registry.plugin.v1beta1.ListPluginsRequest.collection_refs:type_name -> buf.registry.plugin.v1beta1.CollectionRef
	0,  // 4: buf.registry.plugin.v1beta1.ListPluginsRequest.order:type_name -> buf.registry.plugin.v1beta1.ListPluginsRequest.Order
	14, // 5: buf.registry.plugin.v1beta1.ListPluginsResponse.plugins:type_name -> buf.registry.plugin.v1beta1.Plugin
	11, // 6: buf.registry.plugin.v1beta1.CreatePluginsRequest.values:type_name -> buf.registry.plugin.v1beta1.CreatePluginsRequest.Value
	14, // 7: buf.registry.plugin.v1beta1.CreatePluginsResponse.plugins:type_name -> buf.registry.plugin.v1beta1.Plugin
	12, // 8: buf.registry.plugin.v1beta1.UpdatePluginsRequest.values:type_name -> buf.registry.plugin.v1beta1.UpdatePluginsRequest.Value
	14, // 9: buf.registry.plugin.v1beta1.UpdatePluginsResponse.plugins:type_name -> buf.registry.plugin.v1beta1.Plugin
	13, // 10: buf.registry.plugin.v1beta1.DeletePluginsRequest.plugin_refs:type_name -> buf.registry.plugin.v1beta1.PluginRef
	15, // 11: buf.registry.plugin.v1beta1.CreatePluginsRequest.Value.owner_ref:type_name -> buf.registry.owner.v1.OwnerRef
	17, // 12: buf.registry.plugin.v1beta1.CreatePluginsRequest.Value.visibility:type_name -> buf.registry.plugin.v1beta1.PluginVisibility
	18, // 13: buf.registry.plugin.v1beta1.CreatePluginsRequest.Value.type:type_name -> buf.registry.plugin.v1beta1.PluginType
	13, // 14: buf.registry.plugin.v1beta1.UpdatePluginsRequest.Value.plugin_ref:type_name -> buf.registry.plugin.v1beta1.PluginRef
	17, // 15: buf.registry.plugin.v1beta1.UpdatePluginsRequest.Value.visibility:type_name -> buf.registry.plugin.v1beta1.PluginVisibility
	19, // 16: buf.registry.plugin.v1beta1.UpdatePluginsRequest.Value.state:type_name -> buf.registry.plugin.v1beta1.PluginState
	1,  // 17: buf.registry.plugin.v1beta1.PluginService.GetPlugins:input_type -> buf.registry.plugin.v1beta1.GetPluginsRequest
	3,  // 18: buf.registry.plugin.v1beta1.PluginService.ListPlugins:input_type -> buf.registry.plugin.v1beta1.ListPluginsRequest
	5,  // 19: buf.registry.plugin.v1beta1.PluginService.CreatePlugins:input_type -> buf.registry.plugin.v1beta1.CreatePluginsRequest
	7,  // 20: buf.registry.plugin.v1beta1.PluginService.UpdatePlugins:input_type -> buf.registry.plugin.v1beta1.UpdatePluginsRequest
	9,  // 21: buf.registry.plugin.v1beta1.PluginService.DeletePlugins:input_type -> buf.registry.plugin.v1beta1.DeletePluginsRequest
	2,  // 22: buf.registry.plugin.v1beta1.PluginService.GetPlugins:output_type -> buf.registry.plugin.v1beta1.GetPluginsResponse
	4,  // 23: buf.registry.plugin.v1beta1.PluginService.ListPlugins:output_type -> buf.registry.plugin.v1beta1.ListPluginsResponse
	6,  // 24: buf.registry.plugin.v1beta1.PluginService.CreatePlugins:output_type -> buf.registry.plugin.v1beta1.CreatePluginsResponse
	8,  // 25: buf.registry.plugin.v1beta1.PluginService.UpdatePlugins:output_type -> buf.registry.plugin.v1beta1.UpdatePluginsResponse
	10, // 26: buf.registry.plugin.v1beta1.PluginService.DeletePlugins:output_type -> buf.registry.plugin.v1beta1.DeletePluginsResponse
	22, // [22:27] is the sub-list for method output_type
	17, // [17:22] is the sub-list for method input_type
	17, // [17:17] is the sub-list for extension type_name
	17, // [17:17] is the sub-list for extension extendee
	0,  // [0:17] is the sub-list for field type_name
}

func init() { file_buf_registry_plugin_v1beta1_plugin_service_proto_init() }
func file_buf_registry_plugin_v1beta1_plugin_service_proto_init() {
	if File_buf_registry_plugin_v1beta1_plugin_service_proto != nil {
		return
	}
	file_buf_registry_plugin_v1beta1_collection_proto_init()
	file_buf_registry_plugin_v1beta1_plugin_proto_init()
	file_buf_registry_plugin_v1beta1_plugin_service_proto_msgTypes[11].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_registry_plugin_v1beta1_plugin_service_proto_rawDesc), len(file_buf_registry_plugin_v1beta1_plugin_service_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_registry_plugin_v1beta1_plugin_service_proto_goTypes,
		DependencyIndexes: file_buf_registry_plugin_v1beta1_plugin_service_proto_depIdxs,
		EnumInfos:         file_buf_registry_plugin_v1beta1_plugin_service_proto_enumTypes,
		MessageInfos:      file_buf_registry_plugin_v1beta1_plugin_service_proto_msgTypes,
	}.Build()
	File_buf_registry_plugin_v1beta1_plugin_service_proto = out.File
	file_buf_registry_plugin_v1beta1_plugin_service_proto_goTypes = nil
	file_buf_registry_plugin_v1beta1_plugin_service_proto_depIdxs = nil
}
