// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.9
// 	protoc        (unknown)
// source: buf/alpha/registry/v1alpha1/admin.proto

package registryv1alpha1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// BreakingChangeCategory is the allowed list of categories for breaking rule settings.
type BreakingChangeCategory int32

const (
	BreakingChangeCategory_BREAKING_CHANGE_CATEGORY_UNSPECIFIED BreakingChangeCategory = 0
	BreakingChangeCategory_BREAKING_CHANGE_CATEGORY_FILE        BreakingChangeCategory = 1
	BreakingChangeCategory_BREAKING_CHANGE_CATEGORY_WIRE_JSON   BreakingChangeCategory = 2
)

// Enum value maps for BreakingChangeCategory.
var (
	BreakingChangeCategory_name = map[int32]string{
		0: "BREAKING_CHANGE_CATEGORY_UNSPECIFIED",
		1: "BREAKING_CHANGE_CATEGORY_FILE",
		2: "BREAKING_CHANGE_CATEGORY_WIRE_JSON",
	}
	BreakingChangeCategory_value = map[string]int32{
		"BREAKING_CHANGE_CATEGORY_UNSPECIFIED": 0,
		"BREAKING_CHANGE_CATEGORY_FILE":        1,
		"BREAKING_CHANGE_CATEGORY_WIRE_JSON":   2,
	}
)

func (x BreakingChangeCategory) Enum() *BreakingChangeCategory {
	p := new(BreakingChangeCategory)
	*p = x
	return p
}

func (x BreakingChangeCategory) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BreakingChangeCategory) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_admin_proto_enumTypes[0].Descriptor()
}

func (BreakingChangeCategory) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_admin_proto_enumTypes[0]
}

func (x BreakingChangeCategory) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// CollisionType is the type of collisions that can occur.
type CollisionType int32

const (
	// Unspecified collision type.
	CollisionType_COLLISION_TYPE_UNSPECIFIED CollisionType = 0
	// A fully qualified proto name
	CollisionType_COLLISION_TYPE_FULLY_QUALIFIED_NAME CollisionType = 1
	// A proto file path
	CollisionType_COLLISION_TYPE_PATH CollisionType = 2
)

// Enum value maps for CollisionType.
var (
	CollisionType_name = map[int32]string{
		0: "COLLISION_TYPE_UNSPECIFIED",
		1: "COLLISION_TYPE_FULLY_QUALIFIED_NAME",
		2: "COLLISION_TYPE_PATH",
	}
	CollisionType_value = map[string]int32{
		"COLLISION_TYPE_UNSPECIFIED":          0,
		"COLLISION_TYPE_FULLY_QUALIFIED_NAME": 1,
		"COLLISION_TYPE_PATH":                 2,
	}
)

func (x CollisionType) Enum() *CollisionType {
	p := new(CollisionType)
	*p = x
	return p
}

func (x CollisionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CollisionType) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_admin_proto_enumTypes[1].Descriptor()
}

func (CollisionType) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_admin_proto_enumTypes[1]
}

func (x CollisionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

type BreakingChangePolicy struct {
	state                             protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Enabled                bool                   `protobuf:"varint,1,opt,name=enabled,proto3,oneof"`
	xxx_hidden_IgnoreUnstablePackages bool                   `protobuf:"varint,2,opt,name=ignore_unstable_packages,json=ignoreUnstablePackages,proto3,oneof"`
	xxx_hidden_Category               BreakingChangeCategory `protobuf:"varint,3,opt,name=category,proto3,enum=buf.alpha.registry.v1alpha1.BreakingChangeCategory"`
	XXX_raceDetectHookData            protoimpl.RaceDetectHookData
	XXX_presence                      [1]uint32
	unknownFields                     protoimpl.UnknownFields
	sizeCache                         protoimpl.SizeCache
}

func (x *BreakingChangePolicy) Reset() {
	*x = BreakingChangePolicy{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BreakingChangePolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BreakingChangePolicy) ProtoMessage() {}

func (x *BreakingChangePolicy) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *BreakingChangePolicy) GetEnabled() bool {
	if x != nil {
		return x.xxx_hidden_Enabled
	}
	return false
}

func (x *BreakingChangePolicy) GetIgnoreUnstablePackages() bool {
	if x != nil {
		return x.xxx_hidden_IgnoreUnstablePackages
	}
	return false
}

func (x *BreakingChangePolicy) GetCategory() BreakingChangeCategory {
	if x != nil {
		return x.xxx_hidden_Category
	}
	return BreakingChangeCategory_BREAKING_CHANGE_CATEGORY_UNSPECIFIED
}

func (x *BreakingChangePolicy) SetEnabled(v bool) {
	x.xxx_hidden_Enabled = v
	protoimpl.X.SetPresent(&(x.XXX_presence[0]), 0, 3)
}

func (x *BreakingChangePolicy) SetIgnoreUnstablePackages(v bool) {
	x.xxx_hidden_IgnoreUnstablePackages = v
	protoimpl.X.SetPresent(&(x.XXX_presence[0]), 1, 3)
}

func (x *BreakingChangePolicy) SetCategory(v BreakingChangeCategory) {
	x.xxx_hidden_Category = v
}

func (x *BreakingChangePolicy) HasEnabled() bool {
	if x == nil {
		return false
	}
	return protoimpl.X.Present(&(x.XXX_presence[0]), 0)
}

func (x *BreakingChangePolicy) HasIgnoreUnstablePackages() bool {
	if x == nil {
		return false
	}
	return protoimpl.X.Present(&(x.XXX_presence[0]), 1)
}

func (x *BreakingChangePolicy) ClearEnabled() {
	protoimpl.X.ClearPresent(&(x.XXX_presence[0]), 0)
	x.xxx_hidden_Enabled = false
}

func (x *BreakingChangePolicy) ClearIgnoreUnstablePackages() {
	protoimpl.X.ClearPresent(&(x.XXX_presence[0]), 1)
	x.xxx_hidden_IgnoreUnstablePackages = false
}

type BreakingChangePolicy_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Enabled                *bool
	IgnoreUnstablePackages *bool
	Category               BreakingChangeCategory
}

func (b0 BreakingChangePolicy_builder) Build() *BreakingChangePolicy {
	m0 := &BreakingChangePolicy{}
	b, x := &b0, m0
	_, _ = b, x
	if b.Enabled != nil {
		protoimpl.X.SetPresentNonAtomic(&(x.XXX_presence[0]), 0, 3)
		x.xxx_hidden_Enabled = *b.Enabled
	}
	if b.IgnoreUnstablePackages != nil {
		protoimpl.X.SetPresentNonAtomic(&(x.XXX_presence[0]), 1, 3)
		x.xxx_hidden_IgnoreUnstablePackages = *b.IgnoreUnstablePackages
	}
	x.xxx_hidden_Category = b.Category
	return m0
}

// UniquenessPolicy is the policy for uniqueness on the server.
type UniquenessPolicy struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Enabled bool                   `protobuf:"varint,1,opt,name=enabled,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *UniquenessPolicy) Reset() {
	*x = UniquenessPolicy{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UniquenessPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UniquenessPolicy) ProtoMessage() {}

func (x *UniquenessPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UniquenessPolicy) GetEnabled() bool {
	if x != nil {
		return x.xxx_hidden_Enabled
	}
	return false
}

func (x *UniquenessPolicy) SetEnabled(v bool) {
	x.xxx_hidden_Enabled = v
}

type UniquenessPolicy_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Whether uniqueness policy is enforced.
	Enabled bool
}

func (b0 UniquenessPolicy_builder) Build() *UniquenessPolicy {
	m0 := &UniquenessPolicy{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Enabled = b.Enabled
	return m0
}

// Collision is a collision that has occurred.
type Collision struct {
	state                               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Reference                string                 `protobuf:"bytes,1,opt,name=reference,proto3"`
	xxx_hidden_Type                     CollisionType          `protobuf:"varint,2,opt,name=type,proto3,enum=buf.alpha.registry.v1alpha1.CollisionType"`
	xxx_hidden_Sources                  *[]*CollisionSource    `protobuf:"bytes,3,rep,name=sources,proto3"`
	xxx_hidden_HasOtherCollisionSources bool                   `protobuf:"varint,4,opt,name=has_other_collision_sources,json=hasOtherCollisionSources,proto3"`
	unknownFields                       protoimpl.UnknownFields
	sizeCache                           protoimpl.SizeCache
}

func (x *Collision) Reset() {
	*x = Collision{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Collision) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Collision) ProtoMessage() {}

func (x *Collision) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Collision) GetReference() string {
	if x != nil {
		return x.xxx_hidden_Reference
	}
	return ""
}

func (x *Collision) GetType() CollisionType {
	if x != nil {
		return x.xxx_hidden_Type
	}
	return CollisionType_COLLISION_TYPE_UNSPECIFIED
}

func (x *Collision) GetSources() []*CollisionSource {
	if x != nil {
		if x.xxx_hidden_Sources != nil {
			return *x.xxx_hidden_Sources
		}
	}
	return nil
}

func (x *Collision) GetHasOtherCollisionSources() bool {
	if x != nil {
		return x.xxx_hidden_HasOtherCollisionSources
	}
	return false
}

func (x *Collision) SetReference(v string) {
	x.xxx_hidden_Reference = v
}

func (x *Collision) SetType(v CollisionType) {
	x.xxx_hidden_Type = v
}

func (x *Collision) SetSources(v []*CollisionSource) {
	x.xxx_hidden_Sources = &v
}

func (x *Collision) SetHasOtherCollisionSources(v bool) {
	x.xxx_hidden_HasOtherCollisionSources = v
}

type Collision_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The reference that has collisions.
	Reference string
	// The type of collision.
	Type CollisionType
	// The sources of the collision that the user is authorized to see.
	Sources []*CollisionSource
	// Whether there are other collision sources that the user is not authorized to see.
	// The user should contact a server admin for more information about these collisions.
	HasOtherCollisionSources bool
}

func (b0 Collision_builder) Build() *Collision {
	m0 := &Collision{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Reference = b.Reference
	x.xxx_hidden_Type = b.Type
	x.xxx_hidden_Sources = &b.Sources
	x.xxx_hidden_HasOtherCollisionSources = b.HasOtherCollisionSources
	return m0
}

// CollisionSource is the source of a collision
type CollisionSource struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerName      string                 `protobuf:"bytes,1,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_RepositoryName string                 `protobuf:"bytes,2,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_Path           string                 `protobuf:"bytes,3,opt,name=path,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *CollisionSource) Reset() {
	*x = CollisionSource{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CollisionSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CollisionSource) ProtoMessage() {}

func (x *CollisionSource) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CollisionSource) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *CollisionSource) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *CollisionSource) GetPath() string {
	if x != nil {
		return x.xxx_hidden_Path
	}
	return ""
}

func (x *CollisionSource) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *CollisionSource) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *CollisionSource) SetPath(v string) {
	x.xxx_hidden_Path = v
}

type CollisionSource_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The name of the owner of the source.
	OwnerName string
	// The name of the repository of the source.
	RepositoryName string
	// The path of the file that is the source of the collision.
	Path string
}

func (b0 CollisionSource_builder) Build() *CollisionSource {
	m0 := &CollisionSource{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_Path = b.Path
	return m0
}

// MonthlyUsage contains the total amount of message, enum and services types
// for every organizations repositories within a single tenant BSR instance
// for a given month and year.
type MonthlyUsage struct {
	state                        protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Month             uint32                 `protobuf:"varint,1,opt,name=month,proto3"`
	xxx_hidden_Year              uint32                 `protobuf:"varint,2,opt,name=year,proto3"`
	xxx_hidden_TotalMessageTypes uint32                 `protobuf:"varint,3,opt,name=total_message_types,json=totalMessageTypes,proto3"`
	xxx_hidden_TotalEnumTypes    uint32                 `protobuf:"varint,4,opt,name=total_enum_types,json=totalEnumTypes,proto3"`
	xxx_hidden_TotalMethodTypes  uint32                 `protobuf:"varint,5,opt,name=total_method_types,json=totalMethodTypes,proto3"`
	unknownFields                protoimpl.UnknownFields
	sizeCache                    protoimpl.SizeCache
}

func (x *MonthlyUsage) Reset() {
	*x = MonthlyUsage{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MonthlyUsage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MonthlyUsage) ProtoMessage() {}

func (x *MonthlyUsage) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *MonthlyUsage) GetMonth() uint32 {
	if x != nil {
		return x.xxx_hidden_Month
	}
	return 0
}

func (x *MonthlyUsage) GetYear() uint32 {
	if x != nil {
		return x.xxx_hidden_Year
	}
	return 0
}

func (x *MonthlyUsage) GetTotalMessageTypes() uint32 {
	if x != nil {
		return x.xxx_hidden_TotalMessageTypes
	}
	return 0
}

func (x *MonthlyUsage) GetTotalEnumTypes() uint32 {
	if x != nil {
		return x.xxx_hidden_TotalEnumTypes
	}
	return 0
}

func (x *MonthlyUsage) GetTotalMethodTypes() uint32 {
	if x != nil {
		return x.xxx_hidden_TotalMethodTypes
	}
	return 0
}

func (x *MonthlyUsage) SetMonth(v uint32) {
	x.xxx_hidden_Month = v
}

func (x *MonthlyUsage) SetYear(v uint32) {
	x.xxx_hidden_Year = v
}

func (x *MonthlyUsage) SetTotalMessageTypes(v uint32) {
	x.xxx_hidden_TotalMessageTypes = v
}

func (x *MonthlyUsage) SetTotalEnumTypes(v uint32) {
	x.xxx_hidden_TotalEnumTypes = v
}

func (x *MonthlyUsage) SetTotalMethodTypes(v uint32) {
	x.xxx_hidden_TotalMethodTypes = v
}

type MonthlyUsage_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The month, between 1 and 12.
	Month uint32
	// The year, between 2020 and the current year.
	Year uint32
	// The total amount of message types for the month and year.
	TotalMessageTypes uint32
	// The total amount of enum types for the month and year.
	TotalEnumTypes uint32
	// The total amount of method types for the month and year.
	TotalMethodTypes uint32
}

func (b0 MonthlyUsage_builder) Build() *MonthlyUsage {
	m0 := &MonthlyUsage{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Month = b.Month
	x.xxx_hidden_Year = b.Year
	x.xxx_hidden_TotalMessageTypes = b.TotalMessageTypes
	x.xxx_hidden_TotalEnumTypes = b.TotalEnumTypes
	x.xxx_hidden_TotalMethodTypes = b.TotalMethodTypes
	return m0
}

type ForceDeleteUserRequest struct {
	state             protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_UserId string                 `protobuf:"bytes,1,opt,name=user_id,json=userId,proto3"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *ForceDeleteUserRequest) Reset() {
	*x = ForceDeleteUserRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ForceDeleteUserRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ForceDeleteUserRequest) ProtoMessage() {}

func (x *ForceDeleteUserRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ForceDeleteUserRequest) GetUserId() string {
	if x != nil {
		return x.xxx_hidden_UserId
	}
	return ""
}

func (x *ForceDeleteUserRequest) SetUserId(v string) {
	x.xxx_hidden_UserId = v
}

type ForceDeleteUserRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	UserId string
}

func (b0 ForceDeleteUserRequest_builder) Build() *ForceDeleteUserRequest {
	m0 := &ForceDeleteUserRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_UserId = b.UserId
	return m0
}

type ForceDeleteUserResponse struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_User          *User                  `protobuf:"bytes,1,opt,name=user,proto3"`
	xxx_hidden_Organizations *[]*Organization       `protobuf:"bytes,2,rep,name=organizations,proto3"`
	xxx_hidden_Repositories  *[]*Repository         `protobuf:"bytes,3,rep,name=repositories,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *ForceDeleteUserResponse) Reset() {
	*x = ForceDeleteUserResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ForceDeleteUserResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ForceDeleteUserResponse) ProtoMessage() {}

func (x *ForceDeleteUserResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ForceDeleteUserResponse) GetUser() *User {
	if x != nil {
		return x.xxx_hidden_User
	}
	return nil
}

func (x *ForceDeleteUserResponse) GetOrganizations() []*Organization {
	if x != nil {
		if x.xxx_hidden_Organizations != nil {
			return *x.xxx_hidden_Organizations
		}
	}
	return nil
}

func (x *ForceDeleteUserResponse) GetRepositories() []*Repository {
	if x != nil {
		if x.xxx_hidden_Repositories != nil {
			return *x.xxx_hidden_Repositories
		}
	}
	return nil
}

func (x *ForceDeleteUserResponse) SetUser(v *User) {
	x.xxx_hidden_User = v
}

func (x *ForceDeleteUserResponse) SetOrganizations(v []*Organization) {
	x.xxx_hidden_Organizations = &v
}

func (x *ForceDeleteUserResponse) SetRepositories(v []*Repository) {
	x.xxx_hidden_Repositories = &v
}

func (x *ForceDeleteUserResponse) HasUser() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_User != nil
}

func (x *ForceDeleteUserResponse) ClearUser() {
	x.xxx_hidden_User = nil
}

type ForceDeleteUserResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The deleted user.
	User *User
	// The deleted organizations.
	Organizations []*Organization
	// The deleted repositories.
	Repositories []*Repository
}

func (b0 ForceDeleteUserResponse_builder) Build() *ForceDeleteUserResponse {
	m0 := &ForceDeleteUserResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_User = b.User
	x.xxx_hidden_Organizations = &b.Organizations
	x.xxx_hidden_Repositories = &b.Repositories
	return m0
}

type UpdateUserVerificationStatusRequest struct {
	state                         protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_UserId             string                 `protobuf:"bytes,1,opt,name=user_id,json=userId,proto3"`
	xxx_hidden_VerificationStatus VerificationStatus     `protobuf:"varint,2,opt,name=verification_status,json=verificationStatus,proto3,enum=buf.alpha.registry.v1alpha1.VerificationStatus"`
	unknownFields                 protoimpl.UnknownFields
	sizeCache                     protoimpl.SizeCache
}

func (x *UpdateUserVerificationStatusRequest) Reset() {
	*x = UpdateUserVerificationStatusRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateUserVerificationStatusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateUserVerificationStatusRequest) ProtoMessage() {}

func (x *UpdateUserVerificationStatusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UpdateUserVerificationStatusRequest) GetUserId() string {
	if x != nil {
		return x.xxx_hidden_UserId
	}
	return ""
}

func (x *UpdateUserVerificationStatusRequest) GetVerificationStatus() VerificationStatus {
	if x != nil {
		return x.xxx_hidden_VerificationStatus
	}
	return VerificationStatus_VERIFICATION_STATUS_UNSPECIFIED
}

func (x *UpdateUserVerificationStatusRequest) SetUserId(v string) {
	x.xxx_hidden_UserId = v
}

func (x *UpdateUserVerificationStatusRequest) SetVerificationStatus(v VerificationStatus) {
	x.xxx_hidden_VerificationStatus = v
}

type UpdateUserVerificationStatusRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	UserId             string
	VerificationStatus VerificationStatus
}

func (b0 UpdateUserVerificationStatusRequest_builder) Build() *UpdateUserVerificationStatusRequest {
	m0 := &UpdateUserVerificationStatusRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_UserId = b.UserId
	x.xxx_hidden_VerificationStatus = b.VerificationStatus
	return m0
}

type UpdateUserVerificationStatusResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateUserVerificationStatusResponse) Reset() {
	*x = UpdateUserVerificationStatusResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateUserVerificationStatusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateUserVerificationStatusResponse) ProtoMessage() {}

func (x *UpdateUserVerificationStatusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type UpdateUserVerificationStatusResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 UpdateUserVerificationStatusResponse_builder) Build() *UpdateUserVerificationStatusResponse {
	m0 := &UpdateUserVerificationStatusResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type UpdateOrganizationVerificationStatusRequest struct {
	state                         protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId     string                 `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	xxx_hidden_VerificationStatus VerificationStatus     `protobuf:"varint,2,opt,name=verification_status,json=verificationStatus,proto3,enum=buf.alpha.registry.v1alpha1.VerificationStatus"`
	unknownFields                 protoimpl.UnknownFields
	sizeCache                     protoimpl.SizeCache
}

func (x *UpdateOrganizationVerificationStatusRequest) Reset() {
	*x = UpdateOrganizationVerificationStatusRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateOrganizationVerificationStatusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateOrganizationVerificationStatusRequest) ProtoMessage() {}

func (x *UpdateOrganizationVerificationStatusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UpdateOrganizationVerificationStatusRequest) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *UpdateOrganizationVerificationStatusRequest) GetVerificationStatus() VerificationStatus {
	if x != nil {
		return x.xxx_hidden_VerificationStatus
	}
	return VerificationStatus_VERIFICATION_STATUS_UNSPECIFIED
}

func (x *UpdateOrganizationVerificationStatusRequest) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

func (x *UpdateOrganizationVerificationStatusRequest) SetVerificationStatus(v VerificationStatus) {
	x.xxx_hidden_VerificationStatus = v
}

type UpdateOrganizationVerificationStatusRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	OrganizationId     string
	VerificationStatus VerificationStatus
}

func (b0 UpdateOrganizationVerificationStatusRequest_builder) Build() *UpdateOrganizationVerificationStatusRequest {
	m0 := &UpdateOrganizationVerificationStatusRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	x.xxx_hidden_VerificationStatus = b.VerificationStatus
	return m0
}

type UpdateOrganizationVerificationStatusResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateOrganizationVerificationStatusResponse) Reset() {
	*x = UpdateOrganizationVerificationStatusResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateOrganizationVerificationStatusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateOrganizationVerificationStatusResponse) ProtoMessage() {}

func (x *UpdateOrganizationVerificationStatusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type UpdateOrganizationVerificationStatusResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 UpdateOrganizationVerificationStatusResponse_builder) Build() *UpdateOrganizationVerificationStatusResponse {
	m0 := &UpdateOrganizationVerificationStatusResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type CreateMachineUserRequest struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Username string                 `protobuf:"bytes,1,opt,name=username,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *CreateMachineUserRequest) Reset() {
	*x = CreateMachineUserRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateMachineUserRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMachineUserRequest) ProtoMessage() {}

func (x *CreateMachineUserRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreateMachineUserRequest) GetUsername() string {
	if x != nil {
		return x.xxx_hidden_Username
	}
	return ""
}

func (x *CreateMachineUserRequest) SetUsername(v string) {
	x.xxx_hidden_Username = v
}

type CreateMachineUserRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Username string
}

func (b0 CreateMachineUserRequest_builder) Build() *CreateMachineUserRequest {
	m0 := &CreateMachineUserRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Username = b.Username
	return m0
}

type CreateMachineUserResponse struct {
	state           protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_User *User                  `protobuf:"bytes,1,opt,name=user,proto3"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *CreateMachineUserResponse) Reset() {
	*x = CreateMachineUserResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateMachineUserResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMachineUserResponse) ProtoMessage() {}

func (x *CreateMachineUserResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreateMachineUserResponse) GetUser() *User {
	if x != nil {
		return x.xxx_hidden_User
	}
	return nil
}

func (x *CreateMachineUserResponse) SetUser(v *User) {
	x.xxx_hidden_User = v
}

func (x *CreateMachineUserResponse) HasUser() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_User != nil
}

func (x *CreateMachineUserResponse) ClearUser() {
	x.xxx_hidden_User = nil
}

type CreateMachineUserResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	User *User
}

func (b0 CreateMachineUserResponse_builder) Build() *CreateMachineUserResponse {
	m0 := &CreateMachineUserResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_User = b.User
	return m0
}

type GetBreakingChangePolicyRequest struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetBreakingChangePolicyRequest) Reset() {
	*x = GetBreakingChangePolicyRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetBreakingChangePolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBreakingChangePolicyRequest) ProtoMessage() {}

func (x *GetBreakingChangePolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type GetBreakingChangePolicyRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 GetBreakingChangePolicyRequest_builder) Build() *GetBreakingChangePolicyRequest {
	m0 := &GetBreakingChangePolicyRequest{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type GetBreakingChangePolicyResponse struct {
	state             protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Policy *BreakingChangePolicy  `protobuf:"bytes,1,opt,name=policy,proto3"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *GetBreakingChangePolicyResponse) Reset() {
	*x = GetBreakingChangePolicyResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetBreakingChangePolicyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBreakingChangePolicyResponse) ProtoMessage() {}

func (x *GetBreakingChangePolicyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetBreakingChangePolicyResponse) GetPolicy() *BreakingChangePolicy {
	if x != nil {
		return x.xxx_hidden_Policy
	}
	return nil
}

func (x *GetBreakingChangePolicyResponse) SetPolicy(v *BreakingChangePolicy) {
	x.xxx_hidden_Policy = v
}

func (x *GetBreakingChangePolicyResponse) HasPolicy() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Policy != nil
}

func (x *GetBreakingChangePolicyResponse) ClearPolicy() {
	x.xxx_hidden_Policy = nil
}

type GetBreakingChangePolicyResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Policy *BreakingChangePolicy
}

func (b0 GetBreakingChangePolicyResponse_builder) Build() *GetBreakingChangePolicyResponse {
	m0 := &GetBreakingChangePolicyResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Policy = b.Policy
	return m0
}

type UpdateBreakingChangePolicyRequest struct {
	state             protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Policy *BreakingChangePolicy  `protobuf:"bytes,1,opt,name=policy,proto3"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *UpdateBreakingChangePolicyRequest) Reset() {
	*x = UpdateBreakingChangePolicyRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateBreakingChangePolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateBreakingChangePolicyRequest) ProtoMessage() {}

func (x *UpdateBreakingChangePolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UpdateBreakingChangePolicyRequest) GetPolicy() *BreakingChangePolicy {
	if x != nil {
		return x.xxx_hidden_Policy
	}
	return nil
}

func (x *UpdateBreakingChangePolicyRequest) SetPolicy(v *BreakingChangePolicy) {
	x.xxx_hidden_Policy = v
}

func (x *UpdateBreakingChangePolicyRequest) HasPolicy() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Policy != nil
}

func (x *UpdateBreakingChangePolicyRequest) ClearPolicy() {
	x.xxx_hidden_Policy = nil
}

type UpdateBreakingChangePolicyRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Policy *BreakingChangePolicy
}

func (b0 UpdateBreakingChangePolicyRequest_builder) Build() *UpdateBreakingChangePolicyRequest {
	m0 := &UpdateBreakingChangePolicyRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Policy = b.Policy
	return m0
}

type UpdateBreakingChangePolicyResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateBreakingChangePolicyResponse) Reset() {
	*x = UpdateBreakingChangePolicyResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateBreakingChangePolicyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateBreakingChangePolicyResponse) ProtoMessage() {}

func (x *UpdateBreakingChangePolicyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type UpdateBreakingChangePolicyResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 UpdateBreakingChangePolicyResponse_builder) Build() *UpdateBreakingChangePolicyResponse {
	m0 := &UpdateBreakingChangePolicyResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type GetUniquenessPolicyRequest struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetUniquenessPolicyRequest) Reset() {
	*x = GetUniquenessPolicyRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetUniquenessPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetUniquenessPolicyRequest) ProtoMessage() {}

func (x *GetUniquenessPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type GetUniquenessPolicyRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 GetUniquenessPolicyRequest_builder) Build() *GetUniquenessPolicyRequest {
	m0 := &GetUniquenessPolicyRequest{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type GetUniquenessPolicyResponse struct {
	state                           protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Policy               *UniquenessPolicy      `protobuf:"bytes,1,opt,name=policy,proto3"`
	xxx_hidden_BackfillTaskComplete bool                   `protobuf:"varint,2,opt,name=backfill_task_complete,json=backfillTaskComplete,proto3"`
	unknownFields                   protoimpl.UnknownFields
	sizeCache                       protoimpl.SizeCache
}

func (x *GetUniquenessPolicyResponse) Reset() {
	*x = GetUniquenessPolicyResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetUniquenessPolicyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetUniquenessPolicyResponse) ProtoMessage() {}

func (x *GetUniquenessPolicyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetUniquenessPolicyResponse) GetPolicy() *UniquenessPolicy {
	if x != nil {
		return x.xxx_hidden_Policy
	}
	return nil
}

func (x *GetUniquenessPolicyResponse) GetBackfillTaskComplete() bool {
	if x != nil {
		return x.xxx_hidden_BackfillTaskComplete
	}
	return false
}

func (x *GetUniquenessPolicyResponse) SetPolicy(v *UniquenessPolicy) {
	x.xxx_hidden_Policy = v
}

func (x *GetUniquenessPolicyResponse) SetBackfillTaskComplete(v bool) {
	x.xxx_hidden_BackfillTaskComplete = v
}

func (x *GetUniquenessPolicyResponse) HasPolicy() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Policy != nil
}

func (x *GetUniquenessPolicyResponse) ClearPolicy() {
	x.xxx_hidden_Policy = nil
}

type GetUniquenessPolicyResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The current uniqueness policy settings.
	Policy *UniquenessPolicy
	// Reports the status of the backfill task, which can be executed by the server admin with the
	// RunServerUniquenessBackfillTask RPC.
	BackfillTaskComplete bool
}

func (b0 GetUniquenessPolicyResponse_builder) Build() *GetUniquenessPolicyResponse {
	m0 := &GetUniquenessPolicyResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Policy = b.Policy
	x.xxx_hidden_BackfillTaskComplete = b.BackfillTaskComplete
	return m0
}

type UpdateUniquenessPolicyRequest struct {
	state             protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Policy *UniquenessPolicy      `protobuf:"bytes,1,opt,name=policy,proto3"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *UpdateUniquenessPolicyRequest) Reset() {
	*x = UpdateUniquenessPolicyRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateUniquenessPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateUniquenessPolicyRequest) ProtoMessage() {}

func (x *UpdateUniquenessPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UpdateUniquenessPolicyRequest) GetPolicy() *UniquenessPolicy {
	if x != nil {
		return x.xxx_hidden_Policy
	}
	return nil
}

func (x *UpdateUniquenessPolicyRequest) SetPolicy(v *UniquenessPolicy) {
	x.xxx_hidden_Policy = v
}

func (x *UpdateUniquenessPolicyRequest) HasPolicy() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Policy != nil
}

func (x *UpdateUniquenessPolicyRequest) ClearPolicy() {
	x.xxx_hidden_Policy = nil
}

type UpdateUniquenessPolicyRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Policy *UniquenessPolicy
}

func (b0 UpdateUniquenessPolicyRequest_builder) Build() *UpdateUniquenessPolicyRequest {
	m0 := &UpdateUniquenessPolicyRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Policy = b.Policy
	return m0
}

type UpdateUniquenessPolicyResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateUniquenessPolicyResponse) Reset() {
	*x = UpdateUniquenessPolicyResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateUniquenessPolicyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateUniquenessPolicyResponse) ProtoMessage() {}

func (x *UpdateUniquenessPolicyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type UpdateUniquenessPolicyResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 UpdateUniquenessPolicyResponse_builder) Build() *UpdateUniquenessPolicyResponse {
	m0 := &UpdateUniquenessPolicyResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type ListServerUniquenessCollisionsRequest struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_PageToken     string                 `protobuf:"bytes,1,opt,name=page_token,json=pageToken,proto3"`
	xxx_hidden_PageSize      uint32                 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_CollisionType CollisionType          `protobuf:"varint,3,opt,name=collision_type,json=collisionType,proto3,enum=buf.alpha.registry.v1alpha1.CollisionType"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *ListServerUniquenessCollisionsRequest) Reset() {
	*x = ListServerUniquenessCollisionsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListServerUniquenessCollisionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListServerUniquenessCollisionsRequest) ProtoMessage() {}

func (x *ListServerUniquenessCollisionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListServerUniquenessCollisionsRequest) GetPageToken() string {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return ""
}

func (x *ListServerUniquenessCollisionsRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *ListServerUniquenessCollisionsRequest) GetCollisionType() CollisionType {
	if x != nil {
		return x.xxx_hidden_CollisionType
	}
	return CollisionType_COLLISION_TYPE_UNSPECIFIED
}

func (x *ListServerUniquenessCollisionsRequest) SetPageToken(v string) {
	x.xxx_hidden_PageToken = v
}

func (x *ListServerUniquenessCollisionsRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *ListServerUniquenessCollisionsRequest) SetCollisionType(v CollisionType) {
	x.xxx_hidden_CollisionType = v
}

type ListServerUniquenessCollisionsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Token of the page to retrieve. If not specified, the first page of
	// results will be returned. Use the value obtained from `next_page_token`
	// in the previous response in order to request the next page of results.
	PageToken string
	// Number of elements to retrieve in a single page.
	// When too large a page is requested, the server may decide to further
	// limit the number of returned resources.
	PageSize uint32
	// The desired collision type to filter by.
	// This must be specified. Only collisions of the specified type will be returned,
	// continue to page through results until no more collisions of the specified
	// type are returned.
	CollisionType CollisionType
}

func (b0 ListServerUniquenessCollisionsRequest_builder) Build() *ListServerUniquenessCollisionsRequest {
	m0 := &ListServerUniquenessCollisionsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PageToken = b.PageToken
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_CollisionType = b.CollisionType
	return m0
}

type ListServerUniquenessCollisionsResponse struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Collisions    *[]*Collision          `protobuf:"bytes,1,rep,name=collisions,proto3"`
	xxx_hidden_NextPageToken string                 `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *ListServerUniquenessCollisionsResponse) Reset() {
	*x = ListServerUniquenessCollisionsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListServerUniquenessCollisionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListServerUniquenessCollisionsResponse) ProtoMessage() {}

func (x *ListServerUniquenessCollisionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListServerUniquenessCollisionsResponse) GetCollisions() []*Collision {
	if x != nil {
		if x.xxx_hidden_Collisions != nil {
			return *x.xxx_hidden_Collisions
		}
	}
	return nil
}

func (x *ListServerUniquenessCollisionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return ""
}

func (x *ListServerUniquenessCollisionsResponse) SetCollisions(v []*Collision) {
	x.xxx_hidden_Collisions = &v
}

func (x *ListServerUniquenessCollisionsResponse) SetNextPageToken(v string) {
	x.xxx_hidden_NextPageToken = v
}

type ListServerUniquenessCollisionsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The collisions.
	Collisions []*Collision
	// Pagination token used to retrieve the next page of results.
	// Pass the content of this string as the `page_token` attribute of
	// the next request. `next_page_token` is not returned for the last
	// page.
	NextPageToken string
}

func (b0 ListServerUniquenessCollisionsResponse_builder) Build() *ListServerUniquenessCollisionsResponse {
	m0 := &ListServerUniquenessCollisionsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Collisions = &b.Collisions
	x.xxx_hidden_NextPageToken = b.NextPageToken
	return m0
}

type RunServerUniquenessBackfillTaskRequest struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RunServerUniquenessBackfillTaskRequest) Reset() {
	*x = RunServerUniquenessBackfillTaskRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RunServerUniquenessBackfillTaskRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunServerUniquenessBackfillTaskRequest) ProtoMessage() {}

func (x *RunServerUniquenessBackfillTaskRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type RunServerUniquenessBackfillTaskRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 RunServerUniquenessBackfillTaskRequest_builder) Build() *RunServerUniquenessBackfillTaskRequest {
	m0 := &RunServerUniquenessBackfillTaskRequest{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type RunServerUniquenessBackfillTaskResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RunServerUniquenessBackfillTaskResponse) Reset() {
	*x = RunServerUniquenessBackfillTaskResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RunServerUniquenessBackfillTaskResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunServerUniquenessBackfillTaskResponse) ProtoMessage() {}

func (x *RunServerUniquenessBackfillTaskResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type RunServerUniquenessBackfillTaskResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 RunServerUniquenessBackfillTaskResponse_builder) Build() *RunServerUniquenessBackfillTaskResponse {
	m0 := &RunServerUniquenessBackfillTaskResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type GetClusterUsageRequest struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3"`
	xxx_hidden_EndTime   *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *GetClusterUsageRequest) Reset() {
	*x = GetClusterUsageRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetClusterUsageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetClusterUsageRequest) ProtoMessage() {}

func (x *GetClusterUsageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetClusterUsageRequest) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_StartTime
	}
	return nil
}

func (x *GetClusterUsageRequest) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_EndTime
	}
	return nil
}

func (x *GetClusterUsageRequest) SetStartTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_StartTime = v
}

func (x *GetClusterUsageRequest) SetEndTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_EndTime = v
}

func (x *GetClusterUsageRequest) HasStartTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_StartTime != nil
}

func (x *GetClusterUsageRequest) HasEndTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_EndTime != nil
}

func (x *GetClusterUsageRequest) ClearStartTime() {
	x.xxx_hidden_StartTime = nil
}

func (x *GetClusterUsageRequest) ClearEndTime() {
	x.xxx_hidden_EndTime = nil
}

type GetClusterUsageRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The timestamp of the beginning time of a date range.
	StartTime *timestamppb.Timestamp
	// The timestamp of the ending time of a date range.
	EndTime *timestamppb.Timestamp
}

func (b0 GetClusterUsageRequest_builder) Build() *GetClusterUsageRequest {
	m0 := &GetClusterUsageRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_StartTime = b.StartTime
	x.xxx_hidden_EndTime = b.EndTime
	return m0
}

type GetClusterUsageResponse struct {
	state            protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Usage *[]*MonthlyUsage       `protobuf:"bytes,1,rep,name=usage,proto3"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *GetClusterUsageResponse) Reset() {
	*x = GetClusterUsageResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetClusterUsageResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetClusterUsageResponse) ProtoMessage() {}

func (x *GetClusterUsageResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetClusterUsageResponse) GetUsage() []*MonthlyUsage {
	if x != nil {
		if x.xxx_hidden_Usage != nil {
			return *x.xxx_hidden_Usage
		}
	}
	return nil
}

func (x *GetClusterUsageResponse) SetUsage(v []*MonthlyUsage) {
	x.xxx_hidden_Usage = &v
}

type GetClusterUsageResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Usage []*MonthlyUsage
}

func (b0 GetClusterUsageResponse_builder) Build() *GetClusterUsageResponse {
	m0 := &GetClusterUsageResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Usage = &b.Usage
	return m0
}

var File_buf_alpha_registry_v1alpha1_admin_proto protoreflect.FileDescriptor

const file_buf_alpha_registry_v1alpha1_admin_proto_rawDesc = "" +
	"\n" +
	"'buf/alpha/registry/v1alpha1/admin.proto\x12\x1bbuf.alpha.registry.v1alpha1\x1a.buf/alpha/registry/v1alpha1/organization.proto\x1a,buf/alpha/registry/v1alpha1/repository.proto\x1a&buf/alpha/registry/v1alpha1/user.proto\x1a5buf/alpha/registry/v1alpha1/verification_status.proto\x1a\x1fgoogle/protobuf/timestamp.proto\"\xee\x01\n" +
	"\x14BreakingChangePolicy\x12\x1d\n" +
	"\aenabled\x18\x01 \x01(\bH\x00R\aenabled\x88\x01\x01\x12=\n" +
	"\x18ignore_unstable_packages\x18\x02 \x01(\bH\x01R\x16ignoreUnstablePackages\x88\x01\x01\x12O\n" +
	"\bcategory\x18\x03 \x01(\x0e23.buf.alpha.registry.v1alpha1.BreakingChangeCategoryR\bcategoryB\n" +
	"\n" +
	"\b_enabledB\x1b\n" +
	"\x19_ignore_unstable_packages\",\n" +
	"\x10UniquenessPolicy\x12\x18\n" +
	"\aenabled\x18\x01 \x01(\bR\aenabled\"\xf0\x01\n" +
	"\tCollision\x12\x1c\n" +
	"\treference\x18\x01 \x01(\tR\treference\x12>\n" +
	"\x04type\x18\x02 \x01(\x0e2*.buf.alpha.registry.v1alpha1.CollisionTypeR\x04type\x12F\n" +
	"\asources\x18\x03 \x03(\v2,.buf.alpha.registry.v1alpha1.CollisionSourceR\asources\x12=\n" +
	"\x1bhas_other_collision_sources\x18\x04 \x01(\bR\x18hasOtherCollisionSources\"m\n" +
	"\x0fCollisionSource\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x01 \x01(\tR\townerName\x12'\n" +
	"\x0frepository_name\x18\x02 \x01(\tR\x0erepositoryName\x12\x12\n" +
	"\x04path\x18\x03 \x01(\tR\x04path\"\xc0\x01\n" +
	"\fMonthlyUsage\x12\x14\n" +
	"\x05month\x18\x01 \x01(\rR\x05month\x12\x12\n" +
	"\x04year\x18\x02 \x01(\rR\x04year\x12.\n" +
	"\x13total_message_types\x18\x03 \x01(\rR\x11totalMessageTypes\x12(\n" +
	"\x10total_enum_types\x18\x04 \x01(\rR\x0etotalEnumTypes\x12,\n" +
	"\x12total_method_types\x18\x05 \x01(\rR\x10totalMethodTypes\"1\n" +
	"\x16ForceDeleteUserRequest\x12\x17\n" +
	"\auser_id\x18\x01 \x01(\tR\x06userId\"\x8e\x02\n" +
	"\x17ForceDeleteUserResponse\x125\n" +
	"\x04user\x18\x01 \x01(\v2!.buf.alpha.registry.v1alpha1.UserR\x04user\x12O\n" +
	"\rorganizations\x18\x02 \x03(\v2).buf.alpha.registry.v1alpha1.OrganizationR\rorganizations\x12K\n" +
	"\frepositories\x18\x03 \x03(\v2'.buf.alpha.registry.v1alpha1.RepositoryR\frepositoriesJ\x04\b\x04\x10\x05J\x04\b\x05\x10\x06R\apluginsR\ttemplates\"\xa0\x01\n" +
	"#UpdateUserVerificationStatusRequest\x12\x17\n" +
	"\auser_id\x18\x01 \x01(\tR\x06userId\x12`\n" +
	"\x13verification_status\x18\x02 \x01(\x0e2/.buf.alpha.registry.v1alpha1.VerificationStatusR\x12verificationStatus\"&\n" +
	"$UpdateUserVerificationStatusResponse\"\xb8\x01\n" +
	"+UpdateOrganizationVerificationStatusRequest\x12'\n" +
	"\x0forganization_id\x18\x01 \x01(\tR\x0eorganizationId\x12`\n" +
	"\x13verification_status\x18\x02 \x01(\x0e2/.buf.alpha.registry.v1alpha1.VerificationStatusR\x12verificationStatus\".\n" +
	",UpdateOrganizationVerificationStatusResponse\"6\n" +
	"\x18CreateMachineUserRequest\x12\x1a\n" +
	"\busername\x18\x01 \x01(\tR\busername\"R\n" +
	"\x19CreateMachineUserResponse\x125\n" +
	"\x04user\x18\x01 \x01(\v2!.buf.alpha.registry.v1alpha1.UserR\x04user\" \n" +
	"\x1eGetBreakingChangePolicyRequest\"l\n" +
	"\x1fGetBreakingChangePolicyResponse\x12I\n" +
	"\x06policy\x18\x01 \x01(\v21.buf.alpha.registry.v1alpha1.BreakingChangePolicyR\x06policy\"n\n" +
	"!UpdateBreakingChangePolicyRequest\x12I\n" +
	"\x06policy\x18\x01 \x01(\v21.buf.alpha.registry.v1alpha1.BreakingChangePolicyR\x06policy\"$\n" +
	"\"UpdateBreakingChangePolicyResponse\"\x1c\n" +
	"\x1aGetUniquenessPolicyRequest\"\x9a\x01\n" +
	"\x1bGetUniquenessPolicyResponse\x12E\n" +
	"\x06policy\x18\x01 \x01(\v2-.buf.alpha.registry.v1alpha1.UniquenessPolicyR\x06policy\x124\n" +
	"\x16backfill_task_complete\x18\x02 \x01(\bR\x14backfillTaskComplete\"f\n" +
	"\x1dUpdateUniquenessPolicyRequest\x12E\n" +
	"\x06policy\x18\x01 \x01(\v2-.buf.alpha.registry.v1alpha1.UniquenessPolicyR\x06policy\" \n" +
	"\x1eUpdateUniquenessPolicyResponse\"\xb6\x01\n" +
	"%ListServerUniquenessCollisionsRequest\x12\x1d\n" +
	"\n" +
	"page_token\x18\x01 \x01(\tR\tpageToken\x12\x1b\n" +
	"\tpage_size\x18\x02 \x01(\rR\bpageSize\x12Q\n" +
	"\x0ecollision_type\x18\x03 \x01(\x0e2*.buf.alpha.registry.v1alpha1.CollisionTypeR\rcollisionType\"\x98\x01\n" +
	"&ListServerUniquenessCollisionsResponse\x12F\n" +
	"\n" +
	"collisions\x18\x01 \x03(\v2&.buf.alpha.registry.v1alpha1.CollisionR\n" +
	"collisions\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken\"(\n" +
	"&RunServerUniquenessBackfillTaskRequest\")\n" +
	"'RunServerUniquenessBackfillTaskResponse\"\x8a\x01\n" +
	"\x16GetClusterUsageRequest\x129\n" +
	"\n" +
	"start_time\x18\x01 \x01(\v2\x1a.google.protobuf.TimestampR\tstartTime\x125\n" +
	"\bend_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\aendTime\"Z\n" +
	"\x17GetClusterUsageResponse\x12?\n" +
	"\x05usage\x18\x01 \x03(\v2).buf.alpha.registry.v1alpha1.MonthlyUsageR\x05usage*\x8d\x01\n" +
	"\x16BreakingChangeCategory\x12(\n" +
	"$BREAKING_CHANGE_CATEGORY_UNSPECIFIED\x10\x00\x12!\n" +
	"\x1dBREAKING_CHANGE_CATEGORY_FILE\x10\x01\x12&\n" +
	"\"BREAKING_CHANGE_CATEGORY_WIRE_JSON\x10\x02*q\n" +
	"\rCollisionType\x12\x1e\n" +
	"\x1aCOLLISION_TYPE_UNSPECIFIED\x10\x00\x12'\n" +
	"#COLLISION_TYPE_FULLY_QUALIFIED_NAME\x10\x01\x12\x17\n" +
	"\x13COLLISION_TYPE_PATH\x10\x022\xc3\r\n" +
	"\fAdminService\x12\x81\x01\n" +
	"\x0fForceDeleteUser\x123.buf.alpha.registry.v1alpha1.ForceDeleteUserRequest\x1a4.buf.alpha.registry.v1alpha1.ForceDeleteUserResponse\"\x03\x90\x02\x02\x12\xa3\x01\n" +
	"\x1cUpdateUserVerificationStatus\x12@.buf.alpha.registry.v1alpha1.UpdateUserVerificationStatusRequest\x1aA.buf.alpha.registry.v1alpha1.UpdateUserVerificationStatusResponse\x12\xbb\x01\n" +
	"$UpdateOrganizationVerificationStatus\x12H.buf.alpha.registry.v1alpha1.UpdateOrganizationVerificationStatusRequest\x1aI.buf.alpha.registry.v1alpha1.UpdateOrganizationVerificationStatusResponse\x12\x87\x01\n" +
	"\x11CreateMachineUser\x125.buf.alpha.registry.v1alpha1.CreateMachineUserRequest\x1a6.buf.alpha.registry.v1alpha1.CreateMachineUserResponse\"\x03\x90\x02\x02\x12\x99\x01\n" +
	"\x17GetBreakingChangePolicy\x12;.buf.alpha.registry.v1alpha1.GetBreakingChangePolicyRequest\x1a<.buf.alpha.registry.v1alpha1.GetBreakingChangePolicyResponse\"\x03\x90\x02\x01\x12\x9d\x01\n" +
	"\x1aUpdateBreakingChangePolicy\x12>.buf.alpha.registry.v1alpha1.UpdateBreakingChangePolicyRequest\x1a?.buf.alpha.registry.v1alpha1.UpdateBreakingChangePolicyResponse\x12\x8d\x01\n" +
	"\x13GetUniquenessPolicy\x127.buf.alpha.registry.v1alpha1.GetUniquenessPolicyRequest\x1a8.buf.alpha.registry.v1alpha1.GetUniquenessPolicyResponse\"\x03\x90\x02\x01\x12\x91\x01\n" +
	"\x16UpdateUniquenessPolicy\x12:.buf.alpha.registry.v1alpha1.UpdateUniquenessPolicyRequest\x1a;.buf.alpha.registry.v1alpha1.UpdateUniquenessPolicyResponse\x12\xae\x01\n" +
	"\x1eListServerUniquenessCollisions\x12B.buf.alpha.registry.v1alpha1.ListServerUniquenessCollisionsRequest\x1aC.buf.alpha.registry.v1alpha1.ListServerUniquenessCollisionsResponse\"\x03\x90\x02\x01\x12\xb1\x01\n" +
	"\x1fRunServerUniquenessBackfillTask\x12C.buf.alpha.registry.v1alpha1.RunServerUniquenessBackfillTaskRequest\x1aD.buf.alpha.registry.v1alpha1.RunServerUniquenessBackfillTaskResponse\"\x03\x90\x02\x02\x12|\n" +
	"\x0fGetClusterUsage\x123.buf.alpha.registry.v1alpha1.GetClusterUsageRequest\x1a4.buf.alpha.registry.v1alpha1.GetClusterUsageResponseB\x97\x02\n" +
	"\x1fcom.buf.alpha.registry.v1alpha1B\n" +
	"AdminProtoP\x01ZYgithub.com/bufbuild/buf/private/gen/proto/go/buf/alpha/registry/v1alpha1;registryv1alpha1\xa2\x02\x03BAR\xaa\x02\x1bBuf.Alpha.Registry.V1alpha1\xca\x02\x1bBuf\\Alpha\\Registry\\V1alpha1\xe2\x02'Buf\\Alpha\\Registry\\V1alpha1\\GPBMetadata\xea\x02\x1eBuf::Alpha::Registry::V1alpha1b\x06proto3"

var file_buf_alpha_registry_v1alpha1_admin_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes = make([]protoimpl.MessageInfo, 27)
var file_buf_alpha_registry_v1alpha1_admin_proto_goTypes = []any{
	(BreakingChangeCategory)(0),                          // 0: buf.alpha.registry.v1alpha1.BreakingChangeCategory
	(CollisionType)(0),                                   // 1: buf.alpha.registry.v1alpha1.CollisionType
	(*BreakingChangePolicy)(nil),                         // 2: buf.alpha.registry.v1alpha1.BreakingChangePolicy
	(*UniquenessPolicy)(nil),                             // 3: buf.alpha.registry.v1alpha1.UniquenessPolicy
	(*Collision)(nil),                                    // 4: buf.alpha.registry.v1alpha1.Collision
	(*CollisionSource)(nil),                              // 5: buf.alpha.registry.v1alpha1.CollisionSource
	(*MonthlyUsage)(nil),                                 // 6: buf.alpha.registry.v1alpha1.MonthlyUsage
	(*ForceDeleteUserRequest)(nil),                       // 7: buf.alpha.registry.v1alpha1.ForceDeleteUserRequest
	(*ForceDeleteUserResponse)(nil),                      // 8: buf.alpha.registry.v1alpha1.ForceDeleteUserResponse
	(*UpdateUserVerificationStatusRequest)(nil),          // 9: buf.alpha.registry.v1alpha1.UpdateUserVerificationStatusRequest
	(*UpdateUserVerificationStatusResponse)(nil),         // 10: buf.alpha.registry.v1alpha1.UpdateUserVerificationStatusResponse
	(*UpdateOrganizationVerificationStatusRequest)(nil),  // 11: buf.alpha.registry.v1alpha1.UpdateOrganizationVerificationStatusRequest
	(*UpdateOrganizationVerificationStatusResponse)(nil), // 12: buf.alpha.registry.v1alpha1.UpdateOrganizationVerificationStatusResponse
	(*CreateMachineUserRequest)(nil),                     // 13: buf.alpha.registry.v1alpha1.CreateMachineUserRequest
	(*CreateMachineUserResponse)(nil),                    // 14: buf.alpha.registry.v1alpha1.CreateMachineUserResponse
	(*GetBreakingChangePolicyRequest)(nil),               // 15: buf.alpha.registry.v1alpha1.GetBreakingChangePolicyRequest
	(*GetBreakingChangePolicyResponse)(nil),              // 16: buf.alpha.registry.v1alpha1.GetBreakingChangePolicyResponse
	(*UpdateBreakingChangePolicyRequest)(nil),            // 17: buf.alpha.registry.v1alpha1.UpdateBreakingChangePolicyRequest
	(*UpdateBreakingChangePolicyResponse)(nil),           // 18: buf.alpha.registry.v1alpha1.UpdateBreakingChangePolicyResponse
	(*GetUniquenessPolicyRequest)(nil),                   // 19: buf.alpha.registry.v1alpha1.GetUniquenessPolicyRequest
	(*GetUniquenessPolicyResponse)(nil),                  // 20: buf.alpha.registry.v1alpha1.GetUniquenessPolicyResponse
	(*UpdateUniquenessPolicyRequest)(nil),                // 21: buf.alpha.registry.v1alpha1.UpdateUniquenessPolicyRequest
	(*UpdateUniquenessPolicyResponse)(nil),               // 22: buf.alpha.registry.v1alpha1.UpdateUniquenessPolicyResponse
	(*ListServerUniquenessCollisionsRequest)(nil),        // 23: buf.alpha.registry.v1alpha1.ListServerUniquenessCollisionsRequest
	(*ListServerUniquenessCollisionsResponse)(nil),       // 24: buf.alpha.registry.v1alpha1.ListServerUniquenessCollisionsResponse
	(*RunServerUniquenessBackfillTaskRequest)(nil),       // 25: buf.alpha.registry.v1alpha1.RunServerUniquenessBackfillTaskRequest
	(*RunServerUniquenessBackfillTaskResponse)(nil),      // 26: buf.alpha.registry.v1alpha1.RunServerUniquenessBackfillTaskResponse
	(*GetClusterUsageRequest)(nil),                       // 27: buf.alpha.registry.v1alpha1.GetClusterUsageRequest
	(*GetClusterUsageResponse)(nil),                      // 28: buf.alpha.registry.v1alpha1.GetClusterUsageResponse
	(*User)(nil),                                         // 29: buf.alpha.registry.v1alpha1.User
	(*Organization)(nil),                                 // 30: buf.alpha.registry.v1alpha1.Organization
	(*Repository)(nil),                                   // 31: buf.alpha.registry.v1alpha1.Repository
	(VerificationStatus)(0),                              // 32: buf.alpha.registry.v1alpha1.VerificationStatus
	(*timestamppb.Timestamp)(nil),                        // 33: google.protobuf.Timestamp
}
var file_buf_alpha_registry_v1alpha1_admin_proto_depIdxs = []int32{
	0,  // 0: buf.alpha.registry.v1alpha1.BreakingChangePolicy.category:type_name -> buf.alpha.registry.v1alpha1.BreakingChangeCategory
	1,  // 1: buf.alpha.registry.v1alpha1.Collision.type:type_name -> buf.alpha.registry.v1alpha1.CollisionType
	5,  // 2: buf.alpha.registry.v1alpha1.Collision.sources:type_name -> buf.alpha.registry.v1alpha1.CollisionSource
	29, // 3: buf.alpha.registry.v1alpha1.ForceDeleteUserResponse.user:type_name -> buf.alpha.registry.v1alpha1.User
	30, // 4: buf.alpha.registry.v1alpha1.ForceDeleteUserResponse.organizations:type_name -> buf.alpha.registry.v1alpha1.Organization
	31, // 5: buf.alpha.registry.v1alpha1.ForceDeleteUserResponse.repositories:type_name -> buf.alpha.registry.v1alpha1.Repository
	32, // 6: buf.alpha.registry.v1alpha1.UpdateUserVerificationStatusRequest.verification_status:type_name -> buf.alpha.registry.v1alpha1.VerificationStatus
	32, // 7: buf.alpha.registry.v1alpha1.UpdateOrganizationVerificationStatusRequest.verification_status:type_name -> buf.alpha.registry.v1alpha1.VerificationStatus
	29, // 8: buf.alpha.registry.v1alpha1.CreateMachineUserResponse.user:type_name -> buf.alpha.registry.v1alpha1.User
	2,  // 9: buf.alpha.registry.v1alpha1.GetBreakingChangePolicyResponse.policy:type_name -> buf.alpha.registry.v1alpha1.BreakingChangePolicy
	2,  // 10: buf.alpha.registry.v1alpha1.UpdateBreakingChangePolicyRequest.policy:type_name -> buf.alpha.registry.v1alpha1.BreakingChangePolicy
	3,  // 11: buf.alpha.registry.v1alpha1.GetUniquenessPolicyResponse.policy:type_name -> buf.alpha.registry.v1alpha1.UniquenessPolicy
	3,  // 12: buf.alpha.registry.v1alpha1.UpdateUniquenessPolicyRequest.policy:type_name -> buf.alpha.registry.v1alpha1.UniquenessPolicy
	1,  // 13: buf.alpha.registry.v1alpha1.ListServerUniquenessCollisionsRequest.collision_type:type_name -> buf.alpha.registry.v1alpha1.CollisionType
	4,  // 14: buf.alpha.registry.v1alpha1.ListServerUniquenessCollisionsResponse.collisions:type_name -> buf.alpha.registry.v1alpha1.Collision
	33, // 15: buf.alpha.registry.v1alpha1.GetClusterUsageRequest.start_time:type_name -> google.protobuf.Timestamp
	33, // 16: buf.alpha.registry.v1alpha1.GetClusterUsageRequest.end_time:type_name -> google.protobuf.Timestamp
	6,  // 17: buf.alpha.registry.v1alpha1.GetClusterUsageResponse.usage:type_name -> buf.alpha.registry.v1alpha1.MonthlyUsage
	7,  // 18: buf.alpha.registry.v1alpha1.AdminService.ForceDeleteUser:input_type -> buf.alpha.registry.v1alpha1.ForceDeleteUserRequest
	9,  // 19: buf.alpha.registry.v1alpha1.AdminService.UpdateUserVerificationStatus:input_type -> buf.alpha.registry.v1alpha1.UpdateUserVerificationStatusRequest
	11, // 20: buf.alpha.registry.v1alpha1.AdminService.UpdateOrganizationVerificationStatus:input_type -> buf.alpha.registry.v1alpha1.UpdateOrganizationVerificationStatusRequest
	13, // 21: buf.alpha.registry.v1alpha1.AdminService.CreateMachineUser:input_type -> buf.alpha.registry.v1alpha1.CreateMachineUserRequest
	15, // 22: buf.alpha.registry.v1alpha1.AdminService.GetBreakingChangePolicy:input_type -> buf.alpha.registry.v1alpha1.GetBreakingChangePolicyRequest
	17, // 23: buf.alpha.registry.v1alpha1.AdminService.UpdateBreakingChangePolicy:input_type -> buf.alpha.registry.v1alpha1.UpdateBreakingChangePolicyRequest
	19, // 24: buf.alpha.registry.v1alpha1.AdminService.GetUniquenessPolicy:input_type -> buf.alpha.registry.v1alpha1.GetUniquenessPolicyRequest
	21, // 25: buf.alpha.registry.v1alpha1.AdminService.UpdateUniquenessPolicy:input_type -> buf.alpha.registry.v1alpha1.UpdateUniquenessPolicyRequest
	23, // 26: buf.alpha.registry.v1alpha1.AdminService.ListServerUniquenessCollisions:input_type -> buf.alpha.registry.v1alpha1.ListServerUniquenessCollisionsRequest
	25, // 27: buf.alpha.registry.v1alpha1.AdminService.RunServerUniquenessBackfillTask:input_type -> buf.alpha.registry.v1alpha1.RunServerUniquenessBackfillTaskRequest
	27, // 28: buf.alpha.registry.v1alpha1.AdminService.GetClusterUsage:input_type -> buf.alpha.registry.v1alpha1.GetClusterUsageRequest
	8,  // 29: buf.alpha.registry.v1alpha1.AdminService.ForceDeleteUser:output_type -> buf.alpha.registry.v1alpha1.ForceDeleteUserResponse
	10, // 30: buf.alpha.registry.v1alpha1.AdminService.UpdateUserVerificationStatus:output_type -> buf.alpha.registry.v1alpha1.UpdateUserVerificationStatusResponse
	12, // 31: buf.alpha.registry.v1alpha1.AdminService.UpdateOrganizationVerificationStatus:output_type -> buf.alpha.registry.v1alpha1.UpdateOrganizationVerificationStatusResponse
	14, // 32: buf.alpha.registry.v1alpha1.AdminService.CreateMachineUser:output_type -> buf.alpha.registry.v1alpha1.CreateMachineUserResponse
	16, // 33: buf.alpha.registry.v1alpha1.AdminService.GetBreakingChangePolicy:output_type -> buf.alpha.registry.v1alpha1.GetBreakingChangePolicyResponse
	18, // 34: buf.alpha.registry.v1alpha1.AdminService.UpdateBreakingChangePolicy:output_type -> buf.alpha.registry.v1alpha1.UpdateBreakingChangePolicyResponse
	20, // 35: buf.alpha.registry.v1alpha1.AdminService.GetUniquenessPolicy:output_type -> buf.alpha.registry.v1alpha1.GetUniquenessPolicyResponse
	22, // 36: buf.alpha.registry.v1alpha1.AdminService.UpdateUniquenessPolicy:output_type -> buf.alpha.registry.v1alpha1.UpdateUniquenessPolicyResponse
	24, // 37: buf.alpha.registry.v1alpha1.AdminService.ListServerUniquenessCollisions:output_type -> buf.alpha.registry.v1alpha1.ListServerUniquenessCollisionsResponse
	26, // 38: buf.alpha.registry.v1alpha1.AdminService.RunServerUniquenessBackfillTask:output_type -> buf.alpha.registry.v1alpha1.RunServerUniquenessBackfillTaskResponse
	28, // 39: buf.alpha.registry.v1alpha1.AdminService.GetClusterUsage:output_type -> buf.alpha.registry.v1alpha1.GetClusterUsageResponse
	29, // [29:40] is the sub-list for method output_type
	18, // [18:29] is the sub-list for method input_type
	18, // [18:18] is the sub-list for extension type_name
	18, // [18:18] is the sub-list for extension extendee
	0,  // [0:18] is the sub-list for field type_name
}

func init() { file_buf_alpha_registry_v1alpha1_admin_proto_init() }
func file_buf_alpha_registry_v1alpha1_admin_proto_init() {
	if File_buf_alpha_registry_v1alpha1_admin_proto != nil {
		return
	}
	file_buf_alpha_registry_v1alpha1_organization_proto_init()
	file_buf_alpha_registry_v1alpha1_repository_proto_init()
	file_buf_alpha_registry_v1alpha1_user_proto_init()
	file_buf_alpha_registry_v1alpha1_verification_status_proto_init()
	file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[0].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_alpha_registry_v1alpha1_admin_proto_rawDesc), len(file_buf_alpha_registry_v1alpha1_admin_proto_rawDesc)),
			NumEnums:      2,
			NumMessages:   27,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_alpha_registry_v1alpha1_admin_proto_goTypes,
		DependencyIndexes: file_buf_alpha_registry_v1alpha1_admin_proto_depIdxs,
		EnumInfos:         file_buf_alpha_registry_v1alpha1_admin_proto_enumTypes,
		MessageInfos:      file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes,
	}.Build()
	File_buf_alpha_registry_v1alpha1_admin_proto = out.File
	file_buf_alpha_registry_v1alpha1_admin_proto_goTypes = nil
	file_buf_alpha_registry_v1alpha1_admin_proto_depIdxs = nil
}
