/* AppContextMenu.c generated by valac 0.56.17, the Vala compiler
 * generated from AppContextMenu.vala, do not modify */

/*
 * Copyright 2019 elementary, Inc. (https://elementary.io)
 * Copyright 2020-2021 Justin Haygood
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "slingshot.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gdesktopappinfo.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SLINGSHOT_APP_CONTEXT_MENU_0_PROPERTY,
	SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_ID_PROPERTY,
	SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_PATH_PROPERTY,
	SLINGSHOT_APP_CONTEXT_MENU_NUM_PROPERTIES
};
static GParamSpec* slingshot_app_context_menu_properties[SLINGSHOT_APP_CONTEXT_MENU_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	SLINGSHOT_APP_CONTEXT_MENU_APP_LAUNCHED_SIGNAL,
	SLINGSHOT_APP_CONTEXT_MENU_NUM_SIGNALS
};
static guint slingshot_app_context_menu_signals[SLINGSHOT_APP_CONTEXT_MENU_NUM_SIGNALS] = {0};

struct _SlingshotAppContextMenuPrivate {
	gchar* _desktop_id;
	gchar* _desktop_path;
	GDesktopAppInfo* app_info;
	gboolean has_system_item;
	SlingshotBackendSwitcherooControl* switcheroo_control;
};

struct _Block6Data {
	int _ref_count_;
	SlingshotAppContextMenu* self;
	gchar* action;
};

struct _Block7Data {
	int _ref_count_;
	SlingshotAppContextMenu* self;
	gboolean prefers_non_default_gpu;
};

static gint SlingshotAppContextMenu_private_offset;
static gpointer slingshot_app_context_menu_parent_class = NULL;
static GType slingshot_app_context_menu_type_id = 0;

static GObject * slingshot_app_context_menu_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void _slingshot_app_context_menu_____lambda34_ (Block6Data* _data6_);
static void __slingshot_app_context_menu_____lambda34__gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                        gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void _slingshot_app_context_menu____lambda35_ (Block7Data* _data7_);
static void __slingshot_app_context_menu____lambda35__gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                       gpointer self);
static void slingshot_app_context_menu_finalize (GObject * obj);
static void _vala_slingshot_app_context_menu_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_slingshot_app_context_menu_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);
static gssize _vala_array_length (gpointer array);

static inline gpointer
slingshot_app_context_menu_get_instance_private (SlingshotAppContextMenu* self)
{
	return G_STRUCT_MEMBER_P (self, SlingshotAppContextMenu_private_offset);
}

SlingshotAppContextMenu*
slingshot_app_context_menu_construct (GType object_type,
                                      const gchar* desktop_id,
                                      const gchar* desktop_path)
{
	SlingshotAppContextMenu * self = NULL;
	g_return_val_if_fail (desktop_id != NULL, NULL);
	g_return_val_if_fail (desktop_path != NULL, NULL);
	self = (SlingshotAppContextMenu*) g_object_new (object_type, "desktop-id", desktop_id, "desktop-path", desktop_path, NULL);
	return self;
}

SlingshotAppContextMenu*
slingshot_app_context_menu_new (const gchar* desktop_id,
                                const gchar* desktop_path)
{
	return slingshot_app_context_menu_construct (SLINGSHOT_TYPE_APP_CONTEXT_MENU, desktop_id, desktop_path);
}

const gchar*
slingshot_app_context_menu_get_desktop_id (SlingshotAppContextMenu* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_desktop_id;
	result = _tmp0_;
	return result;
}

static void
slingshot_app_context_menu_set_desktop_id (SlingshotAppContextMenu* self,
                                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_app_context_menu_get_desktop_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_desktop_id);
		self->priv->_desktop_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_app_context_menu_properties[SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_ID_PROPERTY]);
	}
}

const gchar*
slingshot_app_context_menu_get_desktop_path (SlingshotAppContextMenu* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_desktop_path;
	result = _tmp0_;
	return result;
}

static void
slingshot_app_context_menu_set_desktop_path (SlingshotAppContextMenu* self,
                                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_app_context_menu_get_desktop_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_desktop_path);
		self->priv->_desktop_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_app_context_menu_properties[SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_PATH_PROPERTY]);
	}
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		SlingshotAppContextMenu* self;
		self = _data6_->self;
		_g_free0 (_data6_->action);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
_slingshot_app_context_menu_____lambda34_ (Block6Data* _data6_)
{
	SlingshotAppContextMenu* self;
	GDesktopAppInfo* _tmp0_;
	const gchar* _tmp1_;
	GAppLaunchContext* _tmp2_;
	GAppLaunchContext* _tmp3_;
	self = _data6_->self;
	_tmp0_ = self->priv->app_info;
	_tmp1_ = _data6_->action;
	_tmp2_ = g_app_launch_context_new ();
	_tmp3_ = _tmp2_;
	g_desktop_app_info_launch_action (_tmp0_, _tmp1_, _tmp3_);
	_g_object_unref0 (_tmp3_);
	g_signal_emit (self, slingshot_app_context_menu_signals[SLINGSHOT_APP_CONTEXT_MENU_APP_LAUNCHED_SIGNAL], 0);
}

static void
__slingshot_app_context_menu_____lambda34__gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                   gpointer self)
{
	_slingshot_app_context_menu_____lambda34_ (self);
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		SlingshotAppContextMenu* self;
		self = _data7_->self;
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
_slingshot_app_context_menu____lambda35_ (Block7Data* _data7_)
{
	SlingshotAppContextMenu* self;
	GError* _inner_error0_ = NULL;
	self = _data7_->self;
	{
		GAppLaunchContext* context = NULL;
		GAppLaunchContext* _tmp0_;
		SlingshotBackendSwitcherooControl* _tmp1_;
		GAppLaunchContext* _tmp2_;
		GDesktopAppInfo* _tmp3_;
		GAppLaunchContext* _tmp4_;
		_tmp0_ = g_app_launch_context_new ();
		context = _tmp0_;
		_tmp1_ = self->priv->switcheroo_control;
		_tmp2_ = context;
		slingshot_backend_switcheroo_control_apply_gpu_environment (_tmp1_, _tmp2_, _data7_->prefers_non_default_gpu);
		_tmp3_ = self->priv->app_info;
		_tmp4_ = context;
		g_app_info_launch ((GAppInfo*) _tmp3_, NULL, _tmp4_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (context);
			goto __catch0_g_error;
		}
		g_signal_emit (self, slingshot_app_context_menu_signals[SLINGSHOT_APP_CONTEXT_MENU_APP_LAUNCHED_SIGNAL], 0);
		_g_object_unref0 (context);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = gtk_widget_get_name ((GtkWidget*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("AppContextMenu.vala:91: Failed to launch %s: %s", _tmp6_, _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
__slingshot_app_context_menu____lambda35__gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                  gpointer self)
{
	_slingshot_app_context_menu____lambda35_ (self);
}

static GObject *
slingshot_app_context_menu_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SlingshotAppContextMenu * self;
	SlingshotBackendSwitcherooControl* _tmp0_;
	const gchar* _tmp1_;
	GDesktopAppInfo* _tmp2_;
	GDesktopAppInfo* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gboolean _tmp16_ = FALSE;
	SlingshotBackendSwitcherooControl* _tmp17_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gboolean _tmp32_;
	parent_class = G_OBJECT_CLASS (slingshot_app_context_menu_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_TYPE_APP_CONTEXT_MENU, SlingshotAppContextMenu);
	_tmp0_ = slingshot_backend_switcheroo_control_new ();
	_g_object_unref0 (self->priv->switcheroo_control);
	self->priv->switcheroo_control = _tmp0_;
	_tmp1_ = self->priv->_desktop_id;
	_tmp2_ = g_desktop_app_info_new (_tmp1_);
	_g_object_unref0 (self->priv->app_info);
	self->priv->app_info = _tmp2_;
	_tmp3_ = self->priv->app_info;
	_tmp5_ = _tmp4_ = g_desktop_app_info_list_actions (_tmp3_);
	{
		gchar** _action_collection = NULL;
		gint _action_collection_length1 = 0;
		gint __action_collection_size_ = 0;
		gint _action_it = 0;
		_action_collection = _tmp5_;
		_action_collection_length1 = _vala_array_length (_tmp4_);
		for (_action_it = 0; _action_it < _action_collection_length1; _action_it = _action_it + 1) {
			const gchar* _action = NULL;
			_action = _action_collection[_action_it];
			{
				Block6Data* _data6_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				GtkMenuItem* menuitem = NULL;
				GDesktopAppInfo* _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				GtkMenuItem* _tmp12_;
				GtkMenuItem* _tmp13_;
				GtkMenuItem* _tmp14_;
				GtkMenuItem* _tmp15_;
				_data6_ = g_slice_new0 (Block6Data);
				_data6_->_ref_count_ = 1;
				_data6_->self = g_object_ref (self);
				_tmp6_ = _action;
				_tmp7_ = g_strdup (_tmp6_);
				_data6_->action = _tmp7_;
				_tmp8_ = self->priv->app_info;
				_tmp9_ = _data6_->action;
				_tmp10_ = g_desktop_app_info_get_action_name (_tmp8_, _tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_tmp11_);
				g_object_ref_sink (_tmp12_);
				_tmp13_ = _tmp12_;
				_g_free0 (_tmp11_);
				menuitem = _tmp13_;
				_tmp14_ = menuitem;
				gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp14_);
				_tmp15_ = menuitem;
				g_signal_connect_data (_tmp15_, "activate", (GCallback) __slingshot_app_context_menu_____lambda34__gtk_menu_item_activate, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
				_g_object_unref0 (menuitem);
				block6_data_unref (_data6_);
				_data6_ = NULL;
			}
		}
	}
	_tmp17_ = self->priv->switcheroo_control;
	if (_tmp17_ != NULL) {
		SlingshotBackendSwitcherooControl* _tmp18_;
		gboolean _tmp19_;
		gboolean _tmp20_;
		_tmp18_ = self->priv->switcheroo_control;
		_tmp19_ = slingshot_backend_switcheroo_control_get_has_dual_gpu (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp16_ = _tmp20_;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		Block7Data* _data7_;
		GDesktopAppInfo* _tmp21_;
		gchar* gpu_name = NULL;
		SlingshotBackendSwitcherooControl* _tmp22_;
		gchar* _tmp23_;
		gchar* label = NULL;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		GtkMenuItem* menu_item = NULL;
		const gchar* _tmp26_;
		GtkMenuItem* _tmp27_;
		GtkMenuItem* _tmp28_;
		GtkMenuItem* _tmp29_;
		_data7_ = g_slice_new0 (Block7Data);
		_data7_->_ref_count_ = 1;
		_data7_->self = g_object_ref (self);
		_tmp21_ = self->priv->app_info;
		_data7_->prefers_non_default_gpu = g_desktop_app_info_get_boolean (_tmp21_, "PrefersNonDefaultGPU");
		_tmp22_ = self->priv->switcheroo_control;
		_tmp23_ = slingshot_backend_switcheroo_control_get_gpu_name (_tmp22_, _data7_->prefers_non_default_gpu);
		gpu_name = _tmp23_;
		_tmp24_ = gpu_name;
		_tmp25_ = g_strdup_printf (_ ("Open with %s Graphics"), _tmp24_);
		label = _tmp25_;
		_tmp26_ = label;
		_tmp27_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_tmp26_);
		g_object_ref_sink (_tmp27_);
		menu_item = _tmp27_;
		_tmp28_ = menu_item;
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp28_);
		_tmp29_ = menu_item;
		g_signal_connect_data (_tmp29_, "activate", (GCallback) __slingshot_app_context_menu____lambda35__gtk_menu_item_activate, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
		_g_object_unref0 (menu_item);
		_g_free0 (label);
		_g_free0 (gpu_name);
		block7_data_unref (_data7_);
		_data7_ = NULL;
	}
	_tmp30_ = g_find_program_in_path ("io.elementary.appcenter");
	_tmp31_ = _tmp30_;
	_tmp32_ = _tmp31_ != NULL;
	_g_free0 (_tmp31_);
	if (_tmp32_) {
		gboolean _tmp33_ = FALSE;
		if (!self->priv->has_system_item) {
			GList* _tmp34_;
			GList* _tmp35_;
			_tmp34_ = gtk_container_get_children ((GtkContainer*) self);
			_tmp35_ = _tmp34_;
			_tmp33_ = g_list_length (_tmp35_) > ((guint) 0);
			(_tmp35_ == NULL) ? NULL : (_tmp35_ = (g_list_free (_tmp35_), NULL));
		} else {
			_tmp33_ = FALSE;
		}
		if (_tmp33_) {
			GtkSeparatorMenuItem* _tmp36_;
			GtkSeparatorMenuItem* _tmp37_;
			_tmp36_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
			g_object_ref_sink (_tmp36_);
			_tmp37_ = _tmp36_;
			gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp37_);
			_g_object_unref0 (_tmp37_);
		}
	}
	gtk_widget_show_all ((GtkWidget*) self);
	return obj;
}

static void
slingshot_app_context_menu_class_init (SlingshotAppContextMenuClass * klass,
                                       gpointer klass_data)
{
	slingshot_app_context_menu_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SlingshotAppContextMenu_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_slingshot_app_context_menu_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_slingshot_app_context_menu_set_property;
	G_OBJECT_CLASS (klass)->constructor = slingshot_app_context_menu_constructor;
	G_OBJECT_CLASS (klass)->finalize = slingshot_app_context_menu_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_ID_PROPERTY, slingshot_app_context_menu_properties[SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_ID_PROPERTY] = g_param_spec_string ("desktop-id", "desktop-id", "desktop-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_PATH_PROPERTY, slingshot_app_context_menu_properties[SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_PATH_PROPERTY] = g_param_spec_string ("desktop-path", "desktop-path", "desktop-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	slingshot_app_context_menu_signals[SLINGSHOT_APP_CONTEXT_MENU_APP_LAUNCHED_SIGNAL] = g_signal_new ("app-launched", SLINGSHOT_TYPE_APP_CONTEXT_MENU, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
slingshot_app_context_menu_instance_init (SlingshotAppContextMenu * self,
                                          gpointer klass)
{
	self->priv = slingshot_app_context_menu_get_instance_private (self);
	self->priv->has_system_item = FALSE;
}

static void
slingshot_app_context_menu_finalize (GObject * obj)
{
	SlingshotAppContextMenu * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_TYPE_APP_CONTEXT_MENU, SlingshotAppContextMenu);
	_g_free0 (self->priv->_desktop_id);
	_g_free0 (self->priv->_desktop_path);
	_g_object_unref0 (self->priv->app_info);
	_g_object_unref0 (self->priv->switcheroo_control);
	G_OBJECT_CLASS (slingshot_app_context_menu_parent_class)->finalize (obj);
}

GType
slingshot_app_context_menu_get_type (void)
{
	return slingshot_app_context_menu_type_id;
}

GType
slingshot_app_context_menu_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SlingshotAppContextMenuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slingshot_app_context_menu_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SlingshotAppContextMenu), 0, (GInstanceInitFunc) slingshot_app_context_menu_instance_init, NULL };
	slingshot_app_context_menu_type_id = g_type_module_register_type (module, gtk_menu_get_type (), "SlingshotAppContextMenu", &g_define_type_info, 0);
	SlingshotAppContextMenu_private_offset = sizeof (SlingshotAppContextMenuPrivate);
	return slingshot_app_context_menu_type_id;
}

static void
_vala_slingshot_app_context_menu_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	SlingshotAppContextMenu * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_TYPE_APP_CONTEXT_MENU, SlingshotAppContextMenu);
	switch (property_id) {
		case SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_ID_PROPERTY:
		g_value_set_string (value, slingshot_app_context_menu_get_desktop_id (self));
		break;
		case SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_PATH_PROPERTY:
		g_value_set_string (value, slingshot_app_context_menu_get_desktop_path (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_slingshot_app_context_menu_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	SlingshotAppContextMenu * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_TYPE_APP_CONTEXT_MENU, SlingshotAppContextMenu);
	switch (property_id) {
		case SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_ID_PROPERTY:
		slingshot_app_context_menu_set_desktop_id (self, g_value_get_string (value));
		break;
		case SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_PATH_PROPERTY:
		slingshot_app_context_menu_set_desktop_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

