/* QuickNoteApplet.c generated by valac 0.56.17, the Vala compiler
 * generated from QuickNoteApplet.vala, do not modify */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include "quicknoteapplet.h"
#include <glib-object.h>
#include <plugin.h>
#include <gdk/gdk.h>
#include <libpeas/peas.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	QUICK_NOTE_APPLET_QUICK_NOTE_SETTINGS_0_PROPERTY,
	QUICK_NOTE_APPLET_QUICK_NOTE_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* quick_note_applet_quick_note_settings_properties[QUICK_NOTE_APPLET_QUICK_NOTE_SETTINGS_NUM_PROPERTIES];
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
enum  {
	QUICK_NOTE_APPLET_QUICK_NOTE_0_PROPERTY,
	QUICK_NOTE_APPLET_QUICK_NOTE_NUM_PROPERTIES
};
static GParamSpec* quick_note_applet_quick_note_properties[QUICK_NOTE_APPLET_QUICK_NOTE_NUM_PROPERTIES];
enum  {
	QUICK_NOTE_APPLET_QUICK_NOTE_POPOVER_0_PROPERTY,
	QUICK_NOTE_APPLET_QUICK_NOTE_POPOVER_NUM_PROPERTIES
};
static GParamSpec* quick_note_applet_quick_note_popover_properties[QUICK_NOTE_APPLET_QUICK_NOTE_POPOVER_NUM_PROPERTIES];
enum  {
	QUICK_NOTE_APPLET_QUICK_NOTE_APPLET_0_PROPERTY,
	QUICK_NOTE_APPLET_QUICK_NOTE_APPLET_UUID_PROPERTY,
	QUICK_NOTE_APPLET_QUICK_NOTE_APPLET_NUM_PROPERTIES
};
static GParamSpec* quick_note_applet_quick_note_applet_properties[QUICK_NOTE_APPLET_QUICK_NOTE_APPLET_NUM_PROPERTIES];

struct _QuickNoteAppletQuickNoteSettingsPrivate {
	GtkScale** scales;
	gint scales_length1;
	gint _scales_size_;
	GtkCheckButton* usecustom;
	GtkEntry* dir_entry;
	GtkButton* dir_button;
	gint maxlen;
};

struct _QuickNoteAppletQuickNotePopoverPrivate {
	GtkEventBox* indicatorBox;
	GtkImage* indicatorIcon;
	GtkButton** quicknotebuttons;
	gint quicknotebuttons_length1;
	gint _quicknotebuttons_size_;
	gint last_index;
};

struct _QuickNoteAppletQuickNoteAppletPrivate {
	GtkEventBox* indicatorBox;
	QuickNoteAppletQuickNotePopover* popover;
	BudgiePopoverManager* manager;
	gchar* _uuid;
};

VALA_EXTERN GtkScrolledWindow* quick_note_applet_win;
GtkScrolledWindow* quick_note_applet_win = NULL;
VALA_EXTERN gboolean quick_note_applet_scroll_setbyindicatorbox;
gboolean quick_note_applet_scroll_setbyindicatorbox = TRUE;
VALA_EXTERN gdouble quick_note_applet_vert_scrollposition;
gdouble quick_note_applet_vert_scrollposition = 0.0;
VALA_EXTERN GSettings* quick_note_applet_qn_settings;
GSettings* quick_note_applet_qn_settings = NULL;
VALA_EXTERN GtkTextView* quick_note_applet_view;
GtkTextView* quick_note_applet_view = NULL;
VALA_EXTERN gchar** quick_note_applet_steps;
VALA_EXTERN gint quick_note_applet_steps_length1;
gchar** quick_note_applet_steps = NULL;
gint quick_note_applet_steps_length1 = 0;
static gint _quick_note_applet_steps_size_ = 0;
VALA_EXTERN gchar* quick_note_applet_newtext;
gchar* quick_note_applet_newtext = NULL;
VALA_EXTERN gboolean quick_note_applet_update_steps;
gboolean quick_note_applet_update_steps = FALSE;
static gint QuickNoteAppletQuickNoteSettings_private_offset;
static gpointer quick_note_applet_quick_note_settings_parent_class = NULL;
static GType quick_note_applet_quick_note_settings_type_id = 0;
static gpointer quick_note_applet_quick_note_parent_class = NULL;
static BudgiePluginIface * quick_note_applet_quick_note_budgie_plugin_parent_iface = NULL;
static GType quick_note_applet_quick_note_type_id = 0;
static gint QuickNoteAppletQuickNotePopover_private_offset;
static gpointer quick_note_applet_quick_note_popover_parent_class = NULL;
static GType quick_note_applet_quick_note_popover_type_id = 0;
static gint QuickNoteAppletQuickNoteApplet_private_offset;
static gpointer quick_note_applet_quick_note_applet_parent_class = NULL;
static GType quick_note_applet_quick_note_applet_type_id = 0;

VALA_EXTERN gchar** supporting_functions_keepsection (gchar** arr_in,
                                          gint arr_in_length1,
                                          gint lastn,
                                          gint* result_length1);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
VALA_EXTERN gint supporting_functions_get_buttonindex (GtkButton* button,
                                           GtkButton** arr,
                                           gint arr_length1);
VALA_EXTERN GSettings* supporting_functions_get_settings (const gchar* path);
VALA_EXTERN gchar* supporting_functions_readfile (const gchar* path);
VALA_EXTERN void supporting_functions_writefile (const gchar* path,
                                     const gchar* notes);
VALA_EXTERN void quick_note_applet_set_content (void);
VALA_EXTERN gchar* quick_note_applet_get_qntext (GSettings* settings,
                                     const gchar* key);
VALA_EXTERN gchar* quick_note_applet_get_filepath (GSettings* settings,
                                       const gchar* key);
static void quick_note_applet_quick_note_settings_trim_text (QuickNoteAppletQuickNoteSettings* self,
                                                      const gchar* text);
static void quick_note_applet_quick_note_settings_update_size (QuickNoteAppletQuickNoteSettings* self,
                                                        GtkRange* scale);
static void _quick_note_applet_quick_note_settings_update_size_gtk_range_value_changed (GtkRange* _sender,
                                                                                 gpointer self);
static void _vala_array_add1 (GtkScale** * array,
                       gint* length,
                       gint* size,
                       GtkScale* value);
static void _vala_array_add2 (GtkScale** * array,
                       gint* length,
                       gint* size,
                       GtkScale* value);
static void quick_note_applet_quick_note_settings_set_widgets (QuickNoteAppletQuickNoteSettings* self,
                                                        gboolean state,
                                                        const gchar* path);
static void quick_note_applet_quick_note_settings_act_oncustomtoggle (QuickNoteAppletQuickNoteSettings* self,
                                                               GtkToggleButton* check);
static void _quick_note_applet_quick_note_settings_act_oncustomtoggle_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                                          gpointer self);
static void quick_note_applet_quick_note_settings_get_directory (QuickNoteAppletQuickNoteSettings* self,
                                                          GtkButton* button);
static void _quick_note_applet_quick_note_settings_get_directory_gtk_button_clicked (GtkButton* _sender,
                                                                              gpointer self);
static void quick_note_applet_quick_note_settings_finalize (GObject * obj);
static BudgieApplet* quick_note_applet_quick_note_real_get_panel_widget (BudgiePlugin* base,
                                                                  const gchar* uuid);
static void quick_note_applet_quick_note_popover_manage_text (QuickNoteAppletQuickNotePopover* self,
                                                       GtkTextBuffer* buffer);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void quick_note_applet_quick_note_popover_do_redo (QuickNoteAppletQuickNotePopover* self,
                                                   GtkButton* button);
static void quick_note_applet_quick_note_popover_do_copy (QuickNoteAppletQuickNotePopover* self,
                                                   GtkButton* button);
static void quick_note_applet_quick_note_popover_do_paste (QuickNoteAppletQuickNotePopover* self,
                                                    GtkButton* button);
static void __lambda4_ (QuickNoteAppletQuickNotePopover* self);
static void ___lambda4__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                               gpointer self);
static gboolean quick_note_applet_quick_note_popover_disable_popup (QuickNoteAppletQuickNotePopover* self,
                                                             GdkEvent* event);
static gboolean _quick_note_applet_quick_note_popover_disable_popup_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                                            GdkEventButton* event,
                                                                                            gpointer self);
static void _quick_note_applet_quick_note_popover_manage_text_gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                                                                gpointer self);
static void _vala_array_add4 (GtkButton** * array,
                       gint* length,
                       gint* size,
                       GtkButton* value);
static void _vala_array_add5 (GtkButton** * array,
                       gint* length,
                       gint* size,
                       GtkButton* value);
static void _quick_note_applet_quick_note_popover_do_redo_gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self);
static void _vala_array_add6 (GtkButton** * array,
                       gint* length,
                       gint* size,
                       GtkButton* value);
static void _quick_note_applet_quick_note_popover_do_copy_gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self);
static void _vala_array_add7 (GtkButton** * array,
                       gint* length,
                       gint* size,
                       GtkButton* value);
static void _quick_note_applet_quick_note_popover_do_paste_gtk_button_clicked (GtkButton* _sender,
                                                                        gpointer self);
static void quick_note_applet_quick_note_popover_finalize (GObject * obj);
static gboolean quick_note_applet_quick_note_applet_real_supports_settings (BudgieApplet* base);
static GtkWidget* quick_note_applet_quick_note_applet_real_get_settings_ui (BudgieApplet* base);
static gboolean __lambda5_ (QuickNoteAppletQuickNoteApplet* self,
                     GdkEventButton* e);
static gboolean ___lambda6_ (QuickNoteAppletQuickNoteApplet* self);
static gboolean ____lambda6__gsource_func (gpointer self);
static gboolean ___lambda5__gtk_widget_button_press_event (GtkWidget* _sender,
                                                    GdkEventButton* event,
                                                    gpointer self);
static void quick_note_applet_quick_note_applet_real_update_popovers (BudgieApplet* base,
                                                               BudgiePopoverManager* manager);
static void quick_note_applet_quick_note_applet_finalize (GObject * obj);
static void _vala_quick_note_applet_quick_note_applet_get_property (GObject * object,
                                                             guint property_id,
                                                             GValue * value,
                                                             GParamSpec * pspec);
static void _vala_quick_note_applet_quick_note_applet_set_property (GObject * object,
                                                             guint property_id,
                                                             const GValue * value,
                                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

gchar**
supporting_functions_keepsection (gchar** arr_in,
                                  gint arr_in_length1,
                                  gint lastn,
                                  gint* result_length1)
{
	gchar** temparr = NULL;
	gchar** _tmp0_;
	gint temparr_length1;
	gint _temparr_size_;
	gint currlen = 0;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** result;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	temparr = _tmp0_;
	temparr_length1 = 0;
	_temparr_size_ = temparr_length1;
	currlen = arr_in_length1;
	if (currlen > lastn) {
		gint remove = 0;
		gchar** _tmp1_;
		gint _tmp1__length1;
		gchar** _tmp2_;
		gint _tmp2__length1;
		remove = currlen - lastn;
		_tmp1_ = (arr_in != NULL) ? _vala_array_dup1 (arr_in + remove, currlen - remove) : arr_in;
		_tmp1__length1 = currlen - remove;
		temparr = (_vala_array_free (temparr, temparr_length1, (GDestroyNotify) g_free), NULL);
		temparr = _tmp1_;
		temparr_length1 = _tmp1__length1;
		_temparr_size_ = temparr_length1;
		_tmp2_ = temparr;
		_tmp2__length1 = temparr_length1;
		if (result_length1) {
			*result_length1 = _tmp2__length1;
		}
		result = _tmp2_;
		return result;
	}
	_tmp3_ = (arr_in != NULL) ? _vala_array_dup2 (arr_in, arr_in_length1) : arr_in;
	_tmp3__length1 = arr_in_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	temparr = (_vala_array_free (temparr, temparr_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

gint
supporting_functions_get_buttonindex (GtkButton* button,
                                      GtkButton** arr,
                                      gint arr_length1)
{
	gint result;
	g_return_val_if_fail (button != NULL, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GtkButton* _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < arr_length1)) {
					break;
				}
				_tmp2_ = arr[i];
				if (button == _tmp2_) {
					result = i;
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}

GSettings*
supporting_functions_get_settings (const gchar* path)
{
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	GSettings* result;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = g_settings_new (path);
	settings = _tmp0_;
	result = settings;
	return result;
}

gchar*
supporting_functions_readfile (const gchar* path)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (path != NULL, NULL);
	{
		gchar* read = NULL;
		gchar* _tmp0_ = NULL;
		g_file_get_contents (path, &_tmp0_, NULL, &_inner_error0_);
		_g_free0 (read);
		read = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (read);
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		result = read;
		return result;
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		gchar* welcome = NULL;
		gchar* _tmp1_;
		g_clear_error (&_inner_error0_);
		_tmp1_ = g_strconcat (_ ("Welcome to QuickNote."), " ", _ ("Text will be saved automatically while typing."), NULL);
		welcome = _tmp1_;
		result = welcome;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

void
supporting_functions_writefile (const gchar* path,
                                const gchar* notes)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (path != NULL);
	g_return_if_fail (notes != NULL);
	{
		g_file_set_contents (path, notes, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		g_clear_error (&_inner_error0_);
		g_print ("Cannot write to file. Is the directory available?");
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
quick_note_applet_set_content (void)
{
	gint app_width = 0;
	GSettings* _tmp0_;
	gint app_height = 0;
	GSettings* _tmp1_;
	GtkScrolledWindow* _tmp2_;
	GSettings* _tmp3_;
	gchar* _tmp4_;
	GtkTextView* _tmp5_;
	GtkTextBuffer* _tmp6_;
	GtkTextBuffer* _tmp7_;
	const gchar* _tmp8_;
	_tmp0_ = quick_note_applet_qn_settings;
	app_width = g_settings_get_int (_tmp0_, "width");
	_tmp1_ = quick_note_applet_qn_settings;
	app_height = g_settings_get_int (_tmp1_, "height");
	_tmp2_ = quick_note_applet_win;
	gtk_widget_set_size_request ((GtkWidget*) _tmp2_, app_width, app_height);
	quick_note_applet_update_steps = FALSE;
	_tmp3_ = quick_note_applet_qn_settings;
	_tmp4_ = quick_note_applet_get_qntext (_tmp3_, "custompath");
	_g_free0 (quick_note_applet_newtext);
	quick_note_applet_newtext = _tmp4_;
	_tmp5_ = quick_note_applet_view;
	_tmp6_ = gtk_text_view_get_buffer (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = quick_note_applet_newtext;
	g_object_set (_tmp7_, "text", _tmp8_, NULL);
	quick_note_applet_update_steps = TRUE;
}

gchar*
quick_note_applet_get_filepath (GSettings* settings,
                                const gchar* key)
{
	gchar* filename = NULL;
	gchar* _tmp0_;
	gchar* filepath = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (settings != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = g_strdup ("quicknote_data.txt");
	filename = _tmp0_;
	_tmp1_ = g_settings_get_string (settings, key);
	filepath = _tmp1_;
	_tmp2_ = filepath;
	if (g_strcmp0 (_tmp2_, "") == 0) {
		gchar* homedir = NULL;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* settingsdir = NULL;
		gchar* _tmp5_;
		gchar* custompath = NULL;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		GFile* file = NULL;
		const gchar* _tmp9_;
		GFile* _tmp10_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp3_ = g_get_home_dir ();
		_tmp4_ = g_strdup (_tmp3_);
		homedir = _tmp4_;
		_tmp5_ = g_strdup (".config/budgie-extras/quicknote");
		settingsdir = _tmp5_;
		_tmp6_ = homedir;
		_tmp7_ = settingsdir;
		_tmp8_ = g_build_path ("/", _tmp6_, _tmp7_, NULL);
		custompath = _tmp8_;
		_tmp9_ = custompath;
		_tmp10_ = g_file_new_for_path (_tmp9_);
		file = _tmp10_;
		{
			GFile* _tmp11_;
			_tmp11_ = file;
			g_file_make_directory_with_parents (_tmp11_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			_g_free0 (custompath);
			_g_free0 (settingsdir);
			_g_free0 (homedir);
			_g_free0 (filepath);
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp12_ = custompath;
		_tmp13_ = filename;
		_tmp14_ = g_build_filename (_tmp12_, _tmp13_, NULL);
		result = _tmp14_;
		_g_object_unref0 (file);
		_g_free0 (custompath);
		_g_free0 (settingsdir);
		_g_free0 (homedir);
		_g_free0 (filepath);
		_g_free0 (filename);
		return result;
	} else {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp15_ = filepath;
		_tmp16_ = filename;
		_tmp17_ = g_build_filename (_tmp15_, _tmp16_, NULL);
		result = _tmp17_;
		_g_free0 (filepath);
		_g_free0 (filename);
		return result;
	}
}

gchar*
quick_note_applet_get_qntext (GSettings* settings,
                              const gchar* key)
{
	gchar* filepath = NULL;
	gchar* _tmp0_;
	gchar* initialtext = NULL;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (settings != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = quick_note_applet_get_filepath (settings, key);
	filepath = _tmp0_;
	_tmp1_ = supporting_functions_readfile (filepath);
	initialtext = _tmp1_;
	result = initialtext;
	_g_free0 (filepath);
	return result;
}

static inline gpointer
quick_note_applet_quick_note_settings_get_instance_private (QuickNoteAppletQuickNoteSettings* self)
{
	return G_STRUCT_MEMBER_P (self, QuickNoteAppletQuickNoteSettings_private_offset);
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
quick_note_applet_quick_note_settings_trim_text (QuickNoteAppletQuickNoteSettings* self,
                                                 const gchar* text)
{
	gchar* newtext = NULL;
	gint lenstring = 0;
	gint _tmp0_;
	gint _tmp1_;
	GtkEntry* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = strlen (text);
	_tmp1_ = _tmp0_;
	lenstring = _tmp1_;
	if (lenstring > self->priv->maxlen) {
		gchar* slice = NULL;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = string_slice (text, (glong) ((lenstring - self->priv->maxlen) + 3), (glong) lenstring);
		slice = _tmp2_;
		_tmp3_ = slice;
		_tmp4_ = g_strconcat ("...", _tmp3_, NULL);
		_g_free0 (newtext);
		newtext = _tmp4_;
		_g_free0 (slice);
	} else {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (text);
		_g_free0 (newtext);
		newtext = _tmp5_;
	}
	_tmp6_ = self->priv->dir_entry;
	_tmp7_ = newtext;
	gtk_entry_set_text (_tmp6_, _tmp7_);
	_g_free0 (newtext);
}

static void
_quick_note_applet_quick_note_settings_update_size_gtk_range_value_changed (GtkRange* _sender,
                                                                            gpointer self)
{
	quick_note_applet_quick_note_settings_update_size ((QuickNoteAppletQuickNoteSettings*) self, _sender);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_vala_array_add1 (GtkScale** * array,
                  gint* length,
                  gint* size,
                  GtkScale* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkScale*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add2 (GtkScale** * array,
                  gint* length,
                  gint* size,
                  GtkScale* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkScale*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_quick_note_applet_quick_note_settings_act_oncustomtoggle_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                                     gpointer self)
{
	quick_note_applet_quick_note_settings_act_oncustomtoggle ((QuickNoteAppletQuickNoteSettings*) self, _sender);
}

static void
_quick_note_applet_quick_note_settings_get_directory_gtk_button_clicked (GtkButton* _sender,
                                                                         gpointer self)
{
	quick_note_applet_quick_note_settings_get_directory ((QuickNoteAppletQuickNoteSettings*) self, _sender);
}

QuickNoteAppletQuickNoteSettings*
quick_note_applet_quick_note_settings_construct (GType object_type,
                                                 GSettings* settings)
{
	QuickNoteAppletQuickNoteSettings * self = NULL;
	gint app_width = 0;
	GSettings* _tmp0_;
	gint app_height = 0;
	GSettings* _tmp1_;
	gchar* set_custompath = NULL;
	GSettings* _tmp2_;
	gchar* _tmp3_;
	GtkLabel* widthlabel = NULL;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkScale* widthscale = NULL;
	GtkScale* _tmp7_;
	GtkScale* _tmp8_;
	GtkLabel* heightlabel = NULL;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkScale* heightscale = NULL;
	GtkScale* _tmp12_;
	GtkScale* _tmp13_;
	GtkScale* _tmp14_;
	GtkScale* _tmp15_;
	GtkScale* _tmp16_;
	GtkScale* _tmp17_;
	GtkScale* _tmp18_;
	GtkScale* _tmp19_;
	GtkScale* _tmp20_;
	GtkScale* _tmp21_;
	GtkCheckButton* _tmp22_;
	GtkLabel* customlabel = NULL;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GtkLabel* _tmp25_;
	GtkLabel* _tmp26_;
	GtkLabel* _tmp27_;
	GtkLabel* spacelabel = NULL;
	GtkLabel* _tmp28_;
	GtkLabel* _tmp29_;
	GtkCheckButton* _tmp30_;
	GtkLabel* _tmp31_;
	GtkEntry* _tmp32_;
	GtkEntry* _tmp33_;
	GtkEntry* _tmp34_;
	GtkEntry* _tmp35_;
	GtkLabel* spacelabel2 = NULL;
	GtkLabel* _tmp36_;
	GtkLabel* _tmp37_;
	GtkButton* _tmp38_;
	GtkButton* _tmp39_;
	gboolean custom_isset = FALSE;
	const gchar* _tmp40_;
	GtkCheckButton* _tmp41_;
	GtkCheckButton* _tmp43_;
	GtkButton* _tmp44_;
	self = (QuickNoteAppletQuickNoteSettings*) g_object_new (object_type, NULL);
	self->priv->maxlen = 20;
	_tmp0_ = quick_note_applet_qn_settings;
	app_width = g_settings_get_int (_tmp0_, "width");
	_tmp1_ = quick_note_applet_qn_settings;
	app_height = g_settings_get_int (_tmp1_, "height");
	_tmp2_ = quick_note_applet_qn_settings;
	_tmp3_ = g_settings_get_string (_tmp2_, "custompath");
	set_custompath = _tmp3_;
	_tmp4_ = (GtkLabel*) gtk_label_new (_ ("Text area width"));
	g_object_ref_sink (_tmp4_);
	widthlabel = _tmp4_;
	_tmp5_ = widthlabel;
	gtk_label_set_xalign (_tmp5_, (gfloat) 0);
	_tmp6_ = widthlabel;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp6_, 0, 0, 2, 1);
	_tmp7_ = (GtkScale*) gtk_scale_new_with_range (GTK_ORIENTATION_HORIZONTAL, (gdouble) 250, (gdouble) 750, (gdouble) 5);
	g_object_ref_sink (_tmp7_);
	widthscale = _tmp7_;
	_tmp8_ = widthscale;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp8_, 0, 1, 2, 1);
	_tmp9_ = (GtkLabel*) gtk_label_new (_ ("Text area height"));
	g_object_ref_sink (_tmp9_);
	heightlabel = _tmp9_;
	_tmp10_ = heightlabel;
	gtk_label_set_xalign (_tmp10_, (gfloat) 0);
	_tmp11_ = heightlabel;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp11_, 0, 2, 2, 1);
	_tmp12_ = (GtkScale*) gtk_scale_new_with_range (GTK_ORIENTATION_HORIZONTAL, (gdouble) 150, (gdouble) 450, (gdouble) 5);
	g_object_ref_sink (_tmp12_);
	heightscale = _tmp12_;
	_tmp13_ = heightscale;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp13_, 0, 3, 2, 1);
	_tmp14_ = heightscale;
	gtk_range_set_value ((GtkRange*) _tmp14_, (gdouble) app_height);
	_tmp15_ = widthscale;
	gtk_range_set_value ((GtkRange*) _tmp15_, (gdouble) app_width);
	_tmp16_ = heightscale;
	g_signal_connect_object ((GtkRange*) _tmp16_, "value-changed", (GCallback) _quick_note_applet_quick_note_settings_update_size_gtk_range_value_changed, self, 0);
	_tmp17_ = widthscale;
	g_signal_connect_object ((GtkRange*) _tmp17_, "value-changed", (GCallback) _quick_note_applet_quick_note_settings_update_size_gtk_range_value_changed, self, 0);
	_tmp18_ = widthscale;
	_tmp19_ = _g_object_ref0 (_tmp18_);
	_vala_array_add1 (&self->priv->scales, &self->priv->scales_length1, &self->priv->_scales_size_, _tmp19_);
	_tmp20_ = heightscale;
	_tmp21_ = _g_object_ref0 (_tmp20_);
	_vala_array_add2 (&self->priv->scales, &self->priv->scales_length1, &self->priv->_scales_size_, _tmp21_);
	_tmp22_ = (GtkCheckButton*) gtk_check_button_new ();
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->usecustom);
	self->priv->usecustom = _tmp22_;
	_tmp23_ = g_strconcat (" ", _ ("Set a custom directory"), NULL);
	_tmp24_ = _tmp23_;
	_tmp25_ = (GtkLabel*) gtk_label_new (_tmp24_);
	g_object_ref_sink (_tmp25_);
	_tmp26_ = _tmp25_;
	_g_free0 (_tmp24_);
	customlabel = _tmp26_;
	_tmp27_ = customlabel;
	gtk_label_set_xalign (_tmp27_, (gfloat) 0);
	_tmp28_ = (GtkLabel*) gtk_label_new ("\n");
	g_object_ref_sink (_tmp28_);
	spacelabel = _tmp28_;
	_tmp29_ = spacelabel;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp29_, 0, 4, 1, 1);
	_tmp30_ = self->priv->usecustom;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp30_, 0, 5, 1, 1);
	_tmp31_ = customlabel;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp31_, 1, 5, 1, 1);
	_tmp32_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp32_);
	_g_object_unref0 (self->priv->dir_entry);
	self->priv->dir_entry = _tmp32_;
	_tmp33_ = self->priv->dir_entry;
	gtk_editable_set_editable ((GtkEditable*) _tmp33_, FALSE);
	_tmp34_ = self->priv->dir_entry;
	gtk_entry_set_alignment (_tmp34_, (gfloat) 0);
	_tmp35_ = self->priv->dir_entry;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp35_, 0, 6, 2, 1);
	_tmp36_ = (GtkLabel*) gtk_label_new ("\n");
	g_object_ref_sink (_tmp36_);
	spacelabel2 = _tmp36_;
	_tmp37_ = spacelabel2;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp37_, 0, 7, 2, 1);
	_tmp38_ = (GtkButton*) gtk_button_new_with_label (_ ("Choose directory"));
	g_object_ref_sink (_tmp38_);
	_g_object_unref0 (self->priv->dir_button);
	self->priv->dir_button = _tmp38_;
	_tmp39_ = self->priv->dir_button;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp39_, 0, 8, 2, 1);
	_tmp40_ = set_custompath;
	custom_isset = g_strcmp0 (_tmp40_, "") != 0;
	quick_note_applet_quick_note_settings_set_widgets (self, custom_isset, NULL);
	_tmp41_ = self->priv->usecustom;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp41_, custom_isset);
	if (custom_isset == TRUE) {
		const gchar* _tmp42_;
		_tmp42_ = set_custompath;
		quick_note_applet_quick_note_settings_trim_text (self, _tmp42_);
	}
	_tmp43_ = self->priv->usecustom;
	g_signal_connect_object ((GtkToggleButton*) _tmp43_, "toggled", (GCallback) _quick_note_applet_quick_note_settings_act_oncustomtoggle_gtk_toggle_button_toggled, self, 0);
	_tmp44_ = self->priv->dir_button;
	g_signal_connect_object (_tmp44_, "clicked", (GCallback) _quick_note_applet_quick_note_settings_get_directory_gtk_button_clicked, self, 0);
	_g_object_unref0 (spacelabel2);
	_g_object_unref0 (spacelabel);
	_g_object_unref0 (customlabel);
	_g_object_unref0 (heightscale);
	_g_object_unref0 (heightlabel);
	_g_object_unref0 (widthscale);
	_g_object_unref0 (widthlabel);
	_g_free0 (set_custompath);
	return self;
}

QuickNoteAppletQuickNoteSettings*
quick_note_applet_quick_note_settings_new (GSettings* settings)
{
	return quick_note_applet_quick_note_settings_construct (QUICK_NOTE_APPLET_TYPE_QUICK_NOTE_SETTINGS, settings);
}

static void
quick_note_applet_quick_note_settings_set_widgets (QuickNoteAppletQuickNoteSettings* self,
                                                   gboolean state,
                                                   const gchar* path)
{
	GtkButton* _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->dir_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, state);
	_tmp1_ = self->priv->dir_entry;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, state);
	_tmp2_ = self->priv->dir_entry;
	gtk_entry_set_text (_tmp2_, "");
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
quick_note_applet_quick_note_settings_get_directory (QuickNoteAppletQuickNoteSettings* self,
                                                     GtkButton* button)
{
	GtkFileChooserDialog* chooser = NULL;
	GtkFileChooserDialog* _tmp0_;
	GtkFileChooserDialog* _tmp1_;
	GtkFileChooserDialog* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new ("Select a directory", NULL, GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER, _ ("Cancel"), GTK_RESPONSE_CANCEL, _ ("Use"), GTK_RESPONSE_ACCEPT, NULL);
	g_object_ref_sink (_tmp0_);
	chooser = _tmp0_;
	_tmp1_ = chooser;
	if (gtk_dialog_run ((GtkDialog*) _tmp1_) == ((gint) GTK_RESPONSE_ACCEPT)) {
		gchar* newpath = NULL;
		GtkFileChooserDialog* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		GSettings* _tmp8_;
		const gchar* _tmp9_;
		_tmp2_ = chooser;
		_tmp3_ = gtk_file_chooser_get_uri ((GtkFileChooser*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = string_replace (_tmp4_, "file://", "");
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		newpath = _tmp6_;
		_tmp7_ = newpath;
		quick_note_applet_quick_note_settings_trim_text (self, _tmp7_);
		_tmp8_ = quick_note_applet_qn_settings;
		_tmp9_ = newpath;
		g_settings_set_string (_tmp8_, "custompath", _tmp9_);
		_g_free0 (newpath);
	}
	_tmp10_ = chooser;
	g_signal_emit_by_name ((GtkDialog*) _tmp10_, "close");
	_g_object_unref0 (chooser);
}

static void
quick_note_applet_quick_note_settings_act_oncustomtoggle (QuickNoteAppletQuickNoteSettings* self,
                                                          GtkToggleButton* check)
{
	gboolean isactive = FALSE;
	GtkCheckButton* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (check != NULL);
	_tmp0_ = self->priv->usecustom;
	isactive = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	quick_note_applet_quick_note_settings_set_widgets (self, isactive, NULL);
	if (isactive == FALSE) {
		GtkEntry* _tmp1_;
		GSettings* _tmp2_;
		_tmp1_ = self->priv->dir_entry;
		gtk_entry_set_text (_tmp1_, "");
		_tmp2_ = quick_note_applet_qn_settings;
		g_settings_set_string (_tmp2_, "custompath", "");
	}
}

static void
quick_note_applet_quick_note_settings_update_size (QuickNoteAppletQuickNoteSettings* self,
                                                   GtkRange* scale)
{
	gint newval = 0;
	GtkScale** _tmp0_;
	gint _tmp0__length1;
	GtkScale* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scale != NULL);
	newval = (gint) gtk_range_get_value (scale);
	_tmp0_ = self->priv->scales;
	_tmp0__length1 = self->priv->scales_length1;
	_tmp1_ = _tmp0_[0];
	if (scale == G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_range_get_type (), GtkRange)) {
		GSettings* _tmp2_;
		_tmp2_ = quick_note_applet_qn_settings;
		g_settings_set_int (_tmp2_, "width", newval);
	} else {
		GSettings* _tmp3_;
		_tmp3_ = quick_note_applet_qn_settings;
		g_settings_set_int (_tmp3_, "height", newval);
	}
	quick_note_applet_set_content ();
}

static void
quick_note_applet_quick_note_settings_class_init (QuickNoteAppletQuickNoteSettingsClass * klass,
                                                  gpointer klass_data)
{
	quick_note_applet_quick_note_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &QuickNoteAppletQuickNoteSettings_private_offset);
	G_OBJECT_CLASS (klass)->finalize = quick_note_applet_quick_note_settings_finalize;
}

static void
quick_note_applet_quick_note_settings_instance_init (QuickNoteAppletQuickNoteSettings * self,
                                                     gpointer klass)
{
	GtkScale** _tmp0_;
	self->priv = quick_note_applet_quick_note_settings_get_instance_private (self);
	_tmp0_ = g_new0 (GtkScale*, 0 + 1);
	self->priv->scales = _tmp0_;
	self->priv->scales_length1 = 0;
	self->priv->_scales_size_ = self->priv->scales_length1;
}

static void
quick_note_applet_quick_note_settings_finalize (GObject * obj)
{
	QuickNoteAppletQuickNoteSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, QUICK_NOTE_APPLET_TYPE_QUICK_NOTE_SETTINGS, QuickNoteAppletQuickNoteSettings);
	self->priv->scales = (_vala_array_free (self->priv->scales, self->priv->scales_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->usecustom);
	_g_object_unref0 (self->priv->dir_entry);
	_g_object_unref0 (self->priv->dir_button);
	G_OBJECT_CLASS (quick_note_applet_quick_note_settings_parent_class)->finalize (obj);
}

GType
quick_note_applet_quick_note_settings_get_type (void)
{
	return quick_note_applet_quick_note_settings_type_id;
}

GType
quick_note_applet_quick_note_settings_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (QuickNoteAppletQuickNoteSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) quick_note_applet_quick_note_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (QuickNoteAppletQuickNoteSettings), 0, (GInstanceInitFunc) quick_note_applet_quick_note_settings_instance_init, NULL };
	quick_note_applet_quick_note_settings_type_id = g_type_module_register_type (module, gtk_grid_get_type (), "QuickNoteAppletQuickNoteSettings", &g_define_type_info, 0);
	QuickNoteAppletQuickNoteSettings_private_offset = sizeof (QuickNoteAppletQuickNoteSettingsPrivate);
	return quick_note_applet_quick_note_settings_type_id;
}

static BudgieApplet*
quick_note_applet_quick_note_real_get_panel_widget (BudgiePlugin* base,
                                                    const gchar* uuid)
{
	QuickNoteAppletQuickNote * self;
	QuickNoteAppletQuickNoteApplet* _tmp0_;
	BudgieApplet* result;
	self = (QuickNoteAppletQuickNote*) base;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = quick_note_applet_quick_note_applet_new ();
	g_object_ref_sink (_tmp0_);
	result = (BudgieApplet*) _tmp0_;
	return result;
}

QuickNoteAppletQuickNote*
quick_note_applet_quick_note_construct (GType object_type)
{
	QuickNoteAppletQuickNote * self = NULL;
	self = (QuickNoteAppletQuickNote*) g_object_new (object_type, NULL);
	return self;
}

QuickNoteAppletQuickNote*
quick_note_applet_quick_note_new (void)
{
	return quick_note_applet_quick_note_construct (QUICK_NOTE_APPLET_TYPE_QUICK_NOTE);
}

static void
quick_note_applet_quick_note_class_init (QuickNoteAppletQuickNoteClass * klass,
                                         gpointer klass_data)
{
	quick_note_applet_quick_note_parent_class = g_type_class_peek_parent (klass);
}

static void
quick_note_applet_quick_note_budgie_plugin_interface_init (BudgiePluginIface * iface,
                                                           gpointer iface_data)
{
	quick_note_applet_quick_note_budgie_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_panel_widget = (BudgieApplet* (*) (BudgiePlugin*, const gchar*)) quick_note_applet_quick_note_real_get_panel_widget;
}

static void
quick_note_applet_quick_note_instance_init (QuickNoteAppletQuickNote * self,
                                            gpointer klass)
{
}

GType
quick_note_applet_quick_note_get_type (void)
{
	return quick_note_applet_quick_note_type_id;
}

GType
quick_note_applet_quick_note_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (QuickNoteAppletQuickNoteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) quick_note_applet_quick_note_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (QuickNoteAppletQuickNote), 0, (GInstanceInitFunc) quick_note_applet_quick_note_instance_init, NULL };
	static const GInterfaceInfo budgie_plugin_info = { (GInterfaceInitFunc) quick_note_applet_quick_note_budgie_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	quick_note_applet_quick_note_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "QuickNoteAppletQuickNote", &g_define_type_info, 0);
	g_type_module_add_interface (module, quick_note_applet_quick_note_type_id, budgie_plugin_get_type (), &budgie_plugin_info);
	return quick_note_applet_quick_note_type_id;
}

static inline gpointer
quick_note_applet_quick_note_popover_get_instance_private (QuickNoteAppletQuickNotePopover* self)
{
	return G_STRUCT_MEMBER_P (self, QuickNoteAppletQuickNotePopover_private_offset);
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
quick_note_applet_quick_note_popover_manage_text (QuickNoteAppletQuickNotePopover* self,
                                                  GtkTextBuffer* buffer)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (buffer != NULL);
	if (quick_note_applet_update_steps == TRUE) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* fpath = NULL;
		GSettings* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		gint _tmp9_ = 0;
		gchar** _tmp10_;
		g_object_get (buffer, "text", &_tmp0_, NULL);
		_tmp1_ = _tmp0_;
		_g_free0 (quick_note_applet_newtext);
		quick_note_applet_newtext = _tmp1_;
		_tmp2_ = quick_note_applet_qn_settings;
		_tmp3_ = quick_note_applet_get_filepath (_tmp2_, "custompath");
		fpath = _tmp3_;
		_tmp4_ = fpath;
		_tmp5_ = quick_note_applet_newtext;
		supporting_functions_writefile (_tmp4_, _tmp5_);
		_tmp6_ = quick_note_applet_newtext;
		_tmp7_ = g_strdup (_tmp6_);
		_vala_array_add3 (&quick_note_applet_steps, &quick_note_applet_steps_length1, &_quick_note_applet_steps_size_, _tmp7_);
		_tmp8_ = quick_note_applet_steps;
		_tmp8__length1 = quick_note_applet_steps_length1;
		_tmp10_ = supporting_functions_keepsection (_tmp8_, (gint) _tmp8__length1, 30, &_tmp9_);
		quick_note_applet_steps = (_vala_array_free (quick_note_applet_steps, quick_note_applet_steps_length1, (GDestroyNotify) g_free), NULL);
		quick_note_applet_steps = _tmp10_;
		quick_note_applet_steps_length1 = _tmp9_;
		_quick_note_applet_steps_size_ = quick_note_applet_steps_length1;
		self->priv->last_index = 1000;
		_g_free0 (fpath);
	}
}

static void
quick_note_applet_quick_note_popover_do_redo (QuickNoteAppletQuickNotePopover* self,
                                              GtkButton* button)
{
	gint b_index = 0;
	GtkButton** _tmp0_;
	gint _tmp0__length1;
	gint lensteps = 0;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	quick_note_applet_update_steps = FALSE;
	_tmp0_ = self->priv->quicknotebuttons;
	_tmp0__length1 = self->priv->quicknotebuttons_length1;
	b_index = supporting_functions_get_buttonindex (button, _tmp0_, (gint) _tmp0__length1);
	_tmp1_ = quick_note_applet_steps;
	_tmp1__length1 = quick_note_applet_steps_length1;
	lensteps = _tmp1__length1;
	if (b_index == 0) {
		if (self->priv->last_index == 1000) {
			self->priv->last_index = lensteps - 2;
		} else {
			self->priv->last_index = self->priv->last_index - 1;
		}
		if (self->priv->last_index >= 0) {
			gchar** _tmp2_;
			gint _tmp2__length1;
			const gchar* _tmp3_;
			gchar* _tmp4_;
			GtkTextView* _tmp5_;
			GtkTextBuffer* _tmp6_;
			GtkTextBuffer* _tmp7_;
			const gchar* _tmp8_;
			_tmp2_ = quick_note_applet_steps;
			_tmp2__length1 = quick_note_applet_steps_length1;
			_tmp3_ = _tmp2_[self->priv->last_index];
			_tmp4_ = g_strdup (_tmp3_);
			_g_free0 (quick_note_applet_newtext);
			quick_note_applet_newtext = _tmp4_;
			_tmp5_ = quick_note_applet_view;
			_tmp6_ = gtk_text_view_get_buffer (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = quick_note_applet_newtext;
			g_object_set (_tmp7_, "text", _tmp8_, NULL);
		} else {
			self->priv->last_index = 0;
		}
	} else {
		gint len_steps = 0;
		gchar** _tmp9_;
		gint _tmp9__length1;
		_tmp9_ = quick_note_applet_steps;
		_tmp9__length1 = quick_note_applet_steps_length1;
		len_steps = _tmp9__length1;
		if (self->priv->last_index < (len_steps - 1)) {
			gchar** _tmp10_;
			gint _tmp10__length1;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			GtkTextView* _tmp13_;
			GtkTextBuffer* _tmp14_;
			GtkTextBuffer* _tmp15_;
			const gchar* _tmp16_;
			self->priv->last_index = self->priv->last_index + 1;
			_tmp10_ = quick_note_applet_steps;
			_tmp10__length1 = quick_note_applet_steps_length1;
			_tmp11_ = _tmp10_[self->priv->last_index];
			_tmp12_ = g_strdup (_tmp11_);
			_g_free0 (quick_note_applet_newtext);
			quick_note_applet_newtext = _tmp12_;
			_tmp13_ = quick_note_applet_view;
			_tmp14_ = gtk_text_view_get_buffer (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = quick_note_applet_newtext;
			g_object_set (_tmp15_, "text", _tmp16_, NULL);
		}
	}
	quick_note_applet_update_steps = TRUE;
}

static void
quick_note_applet_quick_note_popover_do_copy (QuickNoteAppletQuickNotePopover* self,
                                              GtkButton* button)
{
	GtkTextView* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = quick_note_applet_view;
	g_signal_emit_by_name (_tmp0_, "copy-clipboard");
}

static void
quick_note_applet_quick_note_popover_do_paste (QuickNoteAppletQuickNotePopover* self,
                                               GtkButton* button)
{
	GtkTextView* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = quick_note_applet_view;
	g_signal_emit_by_name (_tmp0_, "paste-clipboard");
}

static void
__lambda4_ (QuickNoteAppletQuickNotePopover* self)
{
	if (!quick_note_applet_scroll_setbyindicatorbox) {
		GtkScrolledWindow* _tmp0_;
		GtkAdjustment* _tmp1_;
		GtkAdjustment* _tmp2_;
		_tmp0_ = quick_note_applet_win;
		_tmp1_ = gtk_scrolled_window_get_vadjustment (_tmp0_);
		_tmp2_ = _tmp1_;
		quick_note_applet_vert_scrollposition = gtk_adjustment_get_value (_tmp2_);
	}
	quick_note_applet_scroll_setbyindicatorbox = FALSE;
}

static void
___lambda4__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                          gpointer self)
{
	__lambda4_ ((QuickNoteAppletQuickNotePopover*) self);
}

static gboolean
_quick_note_applet_quick_note_popover_disable_popup_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                                   GdkEventButton* event,
                                                                                   gpointer self)
{
	gboolean result;
	result = quick_note_applet_quick_note_popover_disable_popup ((QuickNoteAppletQuickNotePopover*) self, event);
	return result;
}

static void
_quick_note_applet_quick_note_popover_manage_text_gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                                                           gpointer self)
{
	quick_note_applet_quick_note_popover_manage_text ((QuickNoteAppletQuickNotePopover*) self, _sender);
}

static void
_vala_array_add4 (GtkButton** * array,
                  gint* length,
                  gint* size,
                  GtkButton* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkButton*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add5 (GtkButton** * array,
                  gint* length,
                  gint* size,
                  GtkButton* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkButton*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_quick_note_applet_quick_note_popover_do_redo_gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self)
{
	quick_note_applet_quick_note_popover_do_redo ((QuickNoteAppletQuickNotePopover*) self, _sender);
}

static void
_vala_array_add6 (GtkButton** * array,
                  gint* length,
                  gint* size,
                  GtkButton* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkButton*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_quick_note_applet_quick_note_popover_do_copy_gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self)
{
	quick_note_applet_quick_note_popover_do_copy ((QuickNoteAppletQuickNotePopover*) self, _sender);
}

static void
_vala_array_add7 (GtkButton** * array,
                  gint* length,
                  gint* size,
                  GtkButton* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkButton*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_quick_note_applet_quick_note_popover_do_paste_gtk_button_clicked (GtkButton* _sender,
                                                                   gpointer self)
{
	quick_note_applet_quick_note_popover_do_paste ((QuickNoteAppletQuickNotePopover*) self, _sender);
}

QuickNoteAppletQuickNotePopover*
quick_note_applet_quick_note_popover_construct (GType object_type,
                                                GtkEventBox* indicatorBox)
{
	QuickNoteAppletQuickNotePopover * self = NULL;
	GtkEventBox* _tmp0_;
	GtkImage* _tmp1_;
	GtkImage* _tmp2_;
	GtkGrid* maingrid = NULL;
	GtkGrid* _tmp3_;
	GtkScrolledWindow* _tmp4_;
	GtkScrolledWindow* _tmp5_;
	GtkAdjustment* _tmp6_;
	GtkAdjustment* _tmp7_;
	GtkScrolledWindow* _tmp8_;
	GtkTextView* _tmp9_;
	GtkTextView* _tmp10_;
	GtkTextView* _tmp11_;
	GtkTextView* _tmp12_;
	GtkTextView* _tmp13_;
	GtkTextView* _tmp14_;
	GtkTextView* _tmp15_;
	GtkTextBuffer* content = NULL;
	GtkTextView* _tmp16_;
	GtkTextBuffer* _tmp17_;
	GtkTextBuffer* _tmp18_;
	GtkScrolledWindow* _tmp19_;
	GtkTextView* _tmp20_;
	GtkButtonBox* bbox = NULL;
	GtkButtonBox* _tmp21_;
	GtkButton* undo = NULL;
	GtkButton* _tmp22_;
	GtkButton* redo = NULL;
	GtkButton* _tmp23_;
	GtkButton* _tmp24_;
	GtkButton* _tmp25_;
	GtkButton* copy = NULL;
	GtkButton* _tmp26_;
	GtkButton* _tmp27_;
	GtkButton* paste = NULL;
	GtkButton* _tmp28_;
	GtkButton* _tmp29_;
	g_return_val_if_fail (indicatorBox != NULL, NULL);
	self = (QuickNoteAppletQuickNotePopover*) g_object_new (object_type, "relative-to", indicatorBox, NULL);
	_tmp0_ = _g_object_ref0 (indicatorBox);
	_g_object_unref0 (self->priv->indicatorBox);
	self->priv->indicatorBox = _tmp0_;
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name ("budgie-quicknote-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->indicatorIcon);
	self->priv->indicatorIcon = _tmp1_;
	_tmp2_ = self->priv->indicatorIcon;
	gtk_container_add ((GtkContainer*) indicatorBox, (GtkWidget*) _tmp2_);
	_tmp3_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp3_);
	maingrid = _tmp3_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) maingrid);
	_tmp4_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (quick_note_applet_win);
	quick_note_applet_win = _tmp4_;
	_tmp5_ = quick_note_applet_win;
	_tmp6_ = gtk_scrolled_window_get_vadjustment (_tmp5_);
	_tmp7_ = _tmp6_;
	g_signal_connect_object (_tmp7_, "value-changed", (GCallback) ___lambda4__gtk_adjustment_value_changed, self, 0);
	_tmp8_ = quick_note_applet_win;
	gtk_grid_attach (maingrid, (GtkWidget*) _tmp8_, 0, 0, 1, 1);
	_tmp9_ = (GtkTextView*) gtk_text_view_new ();
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (quick_note_applet_view);
	quick_note_applet_view = _tmp9_;
	_tmp10_ = quick_note_applet_view;
	g_signal_connect_object ((GtkWidget*) _tmp10_, "button-press-event", (GCallback) _quick_note_applet_quick_note_popover_disable_popup_gtk_widget_button_press_event, self, 0);
	_tmp11_ = quick_note_applet_view;
	gtk_text_view_set_left_margin (_tmp11_, 20);
	_tmp12_ = quick_note_applet_view;
	gtk_text_view_set_top_margin (_tmp12_, 20);
	_tmp13_ = quick_note_applet_view;
	gtk_text_view_set_right_margin (_tmp13_, 20);
	_tmp14_ = quick_note_applet_view;
	gtk_text_view_set_bottom_margin (_tmp14_, 20);
	_tmp15_ = quick_note_applet_view;
	gtk_text_view_set_wrap_mode (_tmp15_, GTK_WRAP_WORD);
	_tmp16_ = quick_note_applet_view;
	_tmp17_ = gtk_text_view_get_buffer (_tmp16_);
	_tmp18_ = _g_object_ref0 (_tmp17_);
	content = _tmp18_;
	g_signal_connect_object (content, "changed", (GCallback) _quick_note_applet_quick_note_popover_manage_text_gtk_text_buffer_changed, self, 0);
	_tmp19_ = quick_note_applet_win;
	_tmp20_ = quick_note_applet_view;
	gtk_container_add ((GtkContainer*) _tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = (GtkButtonBox*) gtk_button_box_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp21_);
	bbox = _tmp21_;
	gtk_button_box_set_layout (bbox, GTK_BUTTONBOX_CENTER);
	_tmp22_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-undo-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp22_);
	undo = _tmp22_;
	gtk_widget_set_tooltip_text ((GtkWidget*) undo, "Undo");
	gtk_button_set_relief (undo, GTK_RELIEF_NONE);
	gtk_box_pack_start ((GtkBox*) bbox, (GtkWidget*) undo, FALSE, FALSE, (guint) 0);
	_tmp23_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-redo-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp23_);
	redo = _tmp23_;
	gtk_widget_set_tooltip_text ((GtkWidget*) redo, "Redo");
	_tmp24_ = _g_object_ref0 (undo);
	_vala_array_add4 (&self->priv->quicknotebuttons, &self->priv->quicknotebuttons_length1, &self->priv->_quicknotebuttons_size_, _tmp24_);
	_tmp25_ = _g_object_ref0 (redo);
	_vala_array_add5 (&self->priv->quicknotebuttons, &self->priv->quicknotebuttons_length1, &self->priv->_quicknotebuttons_size_, _tmp25_);
	g_signal_connect_object (undo, "clicked", (GCallback) _quick_note_applet_quick_note_popover_do_redo_gtk_button_clicked, self, 0);
	g_signal_connect_object (redo, "clicked", (GCallback) _quick_note_applet_quick_note_popover_do_redo_gtk_button_clicked, self, 0);
	gtk_button_set_relief (redo, GTK_RELIEF_NONE);
	gtk_box_pack_start ((GtkBox*) bbox, (GtkWidget*) redo, FALSE, FALSE, (guint) 0);
	_tmp26_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-copy-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp26_);
	copy = _tmp26_;
	gtk_widget_set_tooltip_text ((GtkWidget*) copy, "Copy");
	_tmp27_ = _g_object_ref0 (copy);
	_vala_array_add6 (&self->priv->quicknotebuttons, &self->priv->quicknotebuttons_length1, &self->priv->_quicknotebuttons_size_, _tmp27_);
	g_signal_connect_object (copy, "clicked", (GCallback) _quick_note_applet_quick_note_popover_do_copy_gtk_button_clicked, self, 0);
	gtk_button_set_relief (copy, GTK_RELIEF_NONE);
	gtk_box_pack_start ((GtkBox*) bbox, (GtkWidget*) copy, FALSE, FALSE, (guint) 0);
	_tmp28_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-paste-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp28_);
	paste = _tmp28_;
	gtk_widget_set_tooltip_text ((GtkWidget*) paste, "Paste");
	_tmp29_ = _g_object_ref0 (paste);
	_vala_array_add7 (&self->priv->quicknotebuttons, &self->priv->quicknotebuttons_length1, &self->priv->_quicknotebuttons_size_, _tmp29_);
	g_signal_connect_object (paste, "clicked", (GCallback) _quick_note_applet_quick_note_popover_do_paste_gtk_button_clicked, self, 0);
	gtk_button_set_relief (paste, GTK_RELIEF_NONE);
	gtk_box_pack_start ((GtkBox*) bbox, (GtkWidget*) paste, FALSE, FALSE, (guint) 0);
	gtk_grid_attach (maingrid, (GtkWidget*) bbox, 0, 1, 1, 1);
	quick_note_applet_set_content ();
	gtk_widget_show_all ((GtkWidget*) maingrid);
	_g_object_unref0 (paste);
	_g_object_unref0 (copy);
	_g_object_unref0 (redo);
	_g_object_unref0 (undo);
	_g_object_unref0 (bbox);
	_g_object_unref0 (content);
	_g_object_unref0 (maingrid);
	return self;
}

QuickNoteAppletQuickNotePopover*
quick_note_applet_quick_note_popover_new (GtkEventBox* indicatorBox)
{
	return quick_note_applet_quick_note_popover_construct (QUICK_NOTE_APPLET_TYPE_QUICK_NOTE_POPOVER, indicatorBox);
}

static gboolean
quick_note_applet_quick_note_popover_disable_popup (QuickNoteAppletQuickNotePopover* self,
                                                    GdkEvent* event)
{
	guint test = 0U;
	guint _tmp0_ = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	gdk_event_get_button (event, &_tmp0_);
	test = _tmp0_;
	if (((gint) test) == 3) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static void
quick_note_applet_quick_note_popover_class_init (QuickNoteAppletQuickNotePopoverClass * klass,
                                                 gpointer klass_data)
{
	quick_note_applet_quick_note_popover_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &QuickNoteAppletQuickNotePopover_private_offset);
	G_OBJECT_CLASS (klass)->finalize = quick_note_applet_quick_note_popover_finalize;
}

static void
quick_note_applet_quick_note_popover_instance_init (QuickNoteAppletQuickNotePopover * self,
                                                    gpointer klass)
{
	self->priv = quick_note_applet_quick_note_popover_get_instance_private (self);
}

static void
quick_note_applet_quick_note_popover_finalize (GObject * obj)
{
	QuickNoteAppletQuickNotePopover * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, QUICK_NOTE_APPLET_TYPE_QUICK_NOTE_POPOVER, QuickNoteAppletQuickNotePopover);
	_g_object_unref0 (self->priv->indicatorBox);
	_g_object_unref0 (self->priv->indicatorIcon);
	self->priv->quicknotebuttons = (_vala_array_free (self->priv->quicknotebuttons, self->priv->quicknotebuttons_length1, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (quick_note_applet_quick_note_popover_parent_class)->finalize (obj);
}

GType
quick_note_applet_quick_note_popover_get_type (void)
{
	return quick_note_applet_quick_note_popover_type_id;
}

GType
quick_note_applet_quick_note_popover_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (QuickNoteAppletQuickNotePopoverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) quick_note_applet_quick_note_popover_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (QuickNoteAppletQuickNotePopover), 0, (GInstanceInitFunc) quick_note_applet_quick_note_popover_instance_init, NULL };
	quick_note_applet_quick_note_popover_type_id = g_type_module_register_type (module, budgie_popover_get_type (), "QuickNoteAppletQuickNotePopover", &g_define_type_info, 0);
	QuickNoteAppletQuickNotePopover_private_offset = sizeof (QuickNoteAppletQuickNotePopoverPrivate);
	return quick_note_applet_quick_note_popover_type_id;
}

static inline gpointer
quick_note_applet_quick_note_applet_get_instance_private (QuickNoteAppletQuickNoteApplet* self)
{
	return G_STRUCT_MEMBER_P (self, QuickNoteAppletQuickNoteApplet_private_offset);
}

static gboolean
quick_note_applet_quick_note_applet_real_supports_settings (BudgieApplet* base)
{
	QuickNoteAppletQuickNoteApplet * self;
	gboolean result;
	self = (QuickNoteAppletQuickNoteApplet*) base;
	result = TRUE;
	return result;
}

static GtkWidget*
quick_note_applet_quick_note_applet_real_get_settings_ui (BudgieApplet* base)
{
	QuickNoteAppletQuickNoteApplet * self;
	const gchar* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	QuickNoteAppletQuickNoteSettings* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* result;
	self = (QuickNoteAppletQuickNoteApplet*) base;
	_tmp0_ = self->priv->_uuid;
	_tmp1_ = budgie_applet_get_applet_settings ((BudgieApplet*) self, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = quick_note_applet_quick_note_settings_new (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = (GtkWidget*) _tmp3_;
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

static gboolean
___lambda6_ (QuickNoteAppletQuickNoteApplet* self)
{
	GtkScrolledWindow* _tmp0_;
	GtkAdjustment* _tmp1_;
	GtkAdjustment* _tmp2_;
	gboolean result;
	_tmp0_ = quick_note_applet_win;
	_tmp1_ = gtk_scrolled_window_get_vadjustment (_tmp0_);
	_tmp2_ = _tmp1_;
	gtk_adjustment_set_value (_tmp2_, quick_note_applet_vert_scrollposition);
	result = FALSE;
	return result;
}

static gboolean
____lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda6_ ((QuickNoteAppletQuickNoteApplet*) self);
	return result;
}

static gboolean
__lambda5_ (QuickNoteAppletQuickNoteApplet* self,
            GdkEventButton* e)
{
	QuickNoteAppletQuickNotePopover* _tmp0_;
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->button != ((guint) 1)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp0_ = self->priv->popover;
	if (gtk_widget_get_visible ((GtkWidget*) _tmp0_)) {
		QuickNoteAppletQuickNotePopover* _tmp1_;
		_tmp1_ = self->priv->popover;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
	} else {
		BudgiePopoverManager* _tmp2_;
		GtkEventBox* _tmp3_;
		quick_note_applet_scroll_setbyindicatorbox = TRUE;
		quick_note_applet_set_content ();
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 150, ____lambda6__gsource_func, g_object_ref (self), g_object_unref);
		_tmp2_ = self->priv->manager;
		_tmp3_ = self->priv->indicatorBox;
		budgie_popover_manager_show_popover (_tmp2_, (GtkWidget*) _tmp3_);
	}
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
___lambda5__gtk_widget_button_press_event (GtkWidget* _sender,
                                           GdkEventButton* event,
                                           gpointer self)
{
	gboolean result;
	result = __lambda5_ ((QuickNoteAppletQuickNoteApplet*) self, event);
	return result;
}

QuickNoteAppletQuickNoteApplet*
quick_note_applet_quick_note_applet_construct (GType object_type)
{
	QuickNoteAppletQuickNoteApplet * self = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	GtkEventBox* _tmp6_;
	GtkEventBox* _tmp7_;
	GtkEventBox* _tmp8_;
	QuickNoteAppletQuickNotePopover* _tmp9_;
	GtkEventBox* _tmp10_;
	QuickNoteAppletQuickNotePopover* _tmp11_;
	GtkWidget* _tmp12_;
	self = (QuickNoteAppletQuickNoteApplet*) g_object_new (object_type, NULL);
	quick_note_applet_vert_scrollposition = (gdouble) 0;
	_tmp0_ = supporting_functions_get_settings ("org.ubuntubudgie.plugins.quicknote");
	_g_object_unref0 (quick_note_applet_qn_settings);
	quick_note_applet_qn_settings = _tmp0_;
	_tmp1_ = quick_note_applet_qn_settings;
	_tmp2_ = quick_note_applet_get_qntext (_tmp1_, "custompath");
	_g_free0 (quick_note_applet_newtext);
	quick_note_applet_newtext = _tmp2_;
	_tmp3_ = quick_note_applet_newtext;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = g_new0 (gchar*, 1 + 1);
	_tmp5_[0] = _tmp4_;
	quick_note_applet_steps = (_vala_array_free (quick_note_applet_steps, quick_note_applet_steps_length1, (GDestroyNotify) g_free), NULL);
	quick_note_applet_steps = _tmp5_;
	quick_note_applet_steps_length1 = 1;
	_quick_note_applet_steps_size_ = quick_note_applet_steps_length1;
	_tmp6_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->indicatorBox);
	self->priv->indicatorBox = _tmp6_;
	_tmp7_ = self->priv->indicatorBox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp7_);
	_tmp8_ = self->priv->indicatorBox;
	_tmp9_ = quick_note_applet_quick_note_popover_new (_tmp8_);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->popover);
	self->priv->popover = _tmp9_;
	_tmp10_ = self->priv->indicatorBox;
	g_signal_connect_object ((GtkWidget*) _tmp10_, "button-press-event", (GCallback) ___lambda5__gtk_widget_button_press_event, self, 0);
	_tmp11_ = self->priv->popover;
	_tmp12_ = gtk_bin_get_child ((GtkBin*) _tmp11_);
	gtk_widget_show_all (_tmp12_);
	gtk_widget_show_all ((GtkWidget*) self);
	return self;
}

QuickNoteAppletQuickNoteApplet*
quick_note_applet_quick_note_applet_new (void)
{
	return quick_note_applet_quick_note_applet_construct (QUICK_NOTE_APPLET_TYPE_QUICK_NOTE_APPLET);
}

static void
quick_note_applet_quick_note_applet_real_update_popovers (BudgieApplet* base,
                                                          BudgiePopoverManager* manager)
{
	QuickNoteAppletQuickNoteApplet * self;
	GtkEventBox* _tmp0_;
	QuickNoteAppletQuickNotePopover* _tmp1_;
	self = (QuickNoteAppletQuickNoteApplet*) base;
	self->priv->manager = manager;
	_tmp0_ = self->priv->indicatorBox;
	_tmp1_ = self->priv->popover;
	budgie_popover_manager_register_popover (manager, (GtkWidget*) _tmp0_, (BudgiePopover*) _tmp1_);
}

const gchar*
quick_note_applet_quick_note_applet_get_uuid (QuickNoteAppletQuickNoteApplet* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uuid;
	result = _tmp0_;
	return result;
}

void
quick_note_applet_quick_note_applet_set_uuid (QuickNoteAppletQuickNoteApplet* self,
                                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = quick_note_applet_quick_note_applet_get_uuid (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uuid);
		self->priv->_uuid = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, quick_note_applet_quick_note_applet_properties[QUICK_NOTE_APPLET_QUICK_NOTE_APPLET_UUID_PROPERTY]);
	}
}

static void
quick_note_applet_quick_note_applet_class_init (QuickNoteAppletQuickNoteAppletClass * klass,
                                                gpointer klass_data)
{
	quick_note_applet_quick_note_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &QuickNoteAppletQuickNoteApplet_private_offset);
	((BudgieAppletClass *) klass)->supports_settings = (gboolean (*) (BudgieApplet*)) quick_note_applet_quick_note_applet_real_supports_settings;
	((BudgieAppletClass *) klass)->get_settings_ui = (GtkWidget* (*) (BudgieApplet*)) quick_note_applet_quick_note_applet_real_get_settings_ui;
	((BudgieAppletClass *) klass)->update_popovers = (void (*) (BudgieApplet*, BudgiePopoverManager*)) quick_note_applet_quick_note_applet_real_update_popovers;
	G_OBJECT_CLASS (klass)->get_property = _vala_quick_note_applet_quick_note_applet_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_quick_note_applet_quick_note_applet_set_property;
	G_OBJECT_CLASS (klass)->finalize = quick_note_applet_quick_note_applet_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), QUICK_NOTE_APPLET_QUICK_NOTE_APPLET_UUID_PROPERTY, quick_note_applet_quick_note_applet_properties[QUICK_NOTE_APPLET_QUICK_NOTE_APPLET_UUID_PROPERTY] = g_param_spec_string ("uuid", "uuid", "uuid", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
quick_note_applet_quick_note_applet_instance_init (QuickNoteAppletQuickNoteApplet * self,
                                                   gpointer klass)
{
	self->priv = quick_note_applet_quick_note_applet_get_instance_private (self);
	self->priv->popover = NULL;
	self->priv->manager = NULL;
}

static void
quick_note_applet_quick_note_applet_finalize (GObject * obj)
{
	QuickNoteAppletQuickNoteApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, QUICK_NOTE_APPLET_TYPE_QUICK_NOTE_APPLET, QuickNoteAppletQuickNoteApplet);
	_g_object_unref0 (self->priv->indicatorBox);
	_g_object_unref0 (self->priv->popover);
	_g_free0 (self->priv->_uuid);
	G_OBJECT_CLASS (quick_note_applet_quick_note_applet_parent_class)->finalize (obj);
}

GType
quick_note_applet_quick_note_applet_get_type (void)
{
	return quick_note_applet_quick_note_applet_type_id;
}

GType
quick_note_applet_quick_note_applet_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (QuickNoteAppletQuickNoteAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) quick_note_applet_quick_note_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (QuickNoteAppletQuickNoteApplet), 0, (GInstanceInitFunc) quick_note_applet_quick_note_applet_instance_init, NULL };
	quick_note_applet_quick_note_applet_type_id = g_type_module_register_type (module, budgie_applet_get_type (), "QuickNoteAppletQuickNoteApplet", &g_define_type_info, 0);
	QuickNoteAppletQuickNoteApplet_private_offset = sizeof (QuickNoteAppletQuickNoteAppletPrivate);
	return quick_note_applet_quick_note_applet_type_id;
}

static void
_vala_quick_note_applet_quick_note_applet_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec)
{
	QuickNoteAppletQuickNoteApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, QUICK_NOTE_APPLET_TYPE_QUICK_NOTE_APPLET, QuickNoteAppletQuickNoteApplet);
	switch (property_id) {
		case QUICK_NOTE_APPLET_QUICK_NOTE_APPLET_UUID_PROPERTY:
		g_value_set_string (value, quick_note_applet_quick_note_applet_get_uuid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_quick_note_applet_quick_note_applet_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec)
{
	QuickNoteAppletQuickNoteApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, QUICK_NOTE_APPLET_TYPE_QUICK_NOTE_APPLET, QuickNoteAppletQuickNoteApplet);
	switch (property_id) {
		case QUICK_NOTE_APPLET_QUICK_NOTE_APPLET_UUID_PROPERTY:
		quick_note_applet_quick_note_applet_set_uuid (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	quick_note_applet_quick_note_settings_register_type (module);
	quick_note_applet_quick_note_register_type (module);
	quick_note_applet_quick_note_popover_register_type (module);
	quick_note_applet_quick_note_applet_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, budgie_plugin_get_type (), QUICK_NOTE_APPLET_TYPE_QUICK_NOTE);
	_g_object_unref0 (objmodule);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

