/* WifiInterface.c generated by valac 0.56.17, the Vala compiler
 * generated from WifiInterface.vala, do not modify */

/*
* Copyright (c) 2015-2017 elementary LLC (http://launchpad.net/wingpanel-indicator-network)
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU Library General Public License as published by
* the Free Software Foundation, either version 2.1 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU Library General Public License for more details.
*
* You should have received a copy of the GNU Library General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*/

#include "networkapplet.h"
#include <glib.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <NetworkManager.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NETWORK_WIFI_INTERFACE_0_PROPERTY,
	NETWORK_WIFI_INTERFACE_HIDDEN_SENSITIVITY_PROPERTY,
	NETWORK_WIFI_INTERFACE_NUM_PROPERTIES
};
static GParamSpec* network_wifi_interface_properties[NETWORK_WIFI_INTERFACE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))

struct _NetworkWifiInterfacePrivate {
	gboolean _hidden_sensitivity;
	NetworkWidgetsSwitch* wifi_item;
	GtkRevealer* revealer;
	GCancellable* wifi_scan_cancellable;
};

struct _Block5Data {
	int _ref_count_;
	NetworkWifiInterface* self;
	NMClient* nm_client;
};

static gint NetworkWifiInterface_private_offset;
static gpointer network_wifi_interface_parent_class = NULL;
static GType network_wifi_interface_type_id = 0;

static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda12_ (NetworkWifiInterface* self);
static void ___lambda12__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda13_ (Block5Data* _data5_);
static void ___lambda13__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void network_wifi_interface_real_update (NetworkWidgetNMInterface* base);
static void network_wifi_interface_real_wifi_activate_cb (NetworkAbstractWifiInterface* base,
                                                   NetworkWifiMenuItem* i);
static gboolean __lambda14_ (NetworkWifiInterface* self);
static gboolean ___lambda14__gsource_func (gpointer self);
static GObject * network_wifi_interface_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void network_wifi_interface_finalize (GObject * obj);
static void _vala_network_wifi_interface_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_network_wifi_interface_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
network_wifi_interface_get_instance_private (NetworkWifiInterface* self)
{
	return G_STRUCT_MEMBER_P (self, NetworkWifiInterface_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		NetworkWifiInterface* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->nm_client);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
__lambda12_ (NetworkWifiInterface* self)
{
	NetworkWidgetsSwitch* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	_tmp0_ = self->priv->wifi_item;
	_tmp1_ = network_widget_nm_interface_get_display_title ((NetworkWidgetNMInterface*) self);
	_tmp2_ = _tmp1_;
	network_widgets_switch_set_caption (_tmp0_, _tmp2_);
}

static void
___lambda12__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda12_ ((NetworkWifiInterface*) self);
}

static void
__lambda13_ (Block5Data* _data5_)
{
	NetworkWifiInterface* self;
	gboolean active = FALSE;
	NetworkWidgetsSwitch* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = _data5_->self;
	_tmp0_ = self->priv->wifi_item;
	_tmp1_ = network_widgets_switch_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	active = _tmp2_;
	if (active != (!((NetworkAbstractWifiInterface*) self)->software_locked)) {
		RFKillManager* _tmp3_;
		_tmp3_ = ((NetworkAbstractWifiInterface*) self)->rfkill;
		rf_kill_manager_set_software_lock (_tmp3_, RF_KILL_DEVICE_TYPE_WLAN, !active);
		nm_client_wireless_set_enabled (_data5_->nm_client, active);
	}
}

static void
___lambda13__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda13_ (self);
}

NetworkWifiInterface*
network_wifi_interface_construct (GType object_type,
                                  NMClient* nm_client,
                                  NMDevice* _device)
{
	NetworkWifiInterface * self = NULL;
	Block5Data* _data5_;
	NMClient* _tmp0_;
	NetworkWidgetsSwitch* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	NetworkWidgetsSwitch* _tmp4_;
	g_return_val_if_fail (nm_client != NULL, NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (nm_client);
	_g_object_unref0 (_data5_->nm_client);
	_data5_->nm_client = _tmp0_;
	self = (NetworkWifiInterface*) network_abstract_wifi_interface_construct (object_type);
	_data5_->self = g_object_ref (self);
	network_abstract_wifi_interface_init_wifi_interface ((NetworkAbstractWifiInterface*) self, _data5_->nm_client, _device);
	_tmp1_ = self->priv->wifi_item;
	_tmp2_ = network_widget_nm_interface_get_display_title ((NetworkWidgetNMInterface*) self);
	_tmp3_ = _tmp2_;
	network_widgets_switch_set_caption (_tmp1_, _tmp3_);
	g_signal_connect_object ((GObject*) self, "notify::display-title", (GCallback) ___lambda12__g_object_notify, self, 0);
	_tmp4_ = self->priv->wifi_item;
	g_signal_connect_data ((GObject*) _tmp4_, "notify::active", (GCallback) ___lambda13__g_object_notify, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return self;
}

NetworkWifiInterface*
network_wifi_interface_new (NMClient* nm_client,
                            NMDevice* _device)
{
	return network_wifi_interface_construct (NETWORK_TYPE_WIFI_INTERFACE, nm_client, _device);
}

static void
network_wifi_interface_real_update (NetworkWidgetNMInterface* base)
{
	NetworkWifiInterface * self;
	NetworkWidgetsSwitch* _tmp0_;
	NetworkWidgetsSwitch* _tmp1_;
	NMDeviceWifi* _tmp2_;
	NMAccessPoint* _tmp3_;
	NMAccessPoint* _tmp4_;
	gboolean _tmp5_ = FALSE;
	NMDeviceWifi* _tmp6_;
	NMDeviceState _tmp7_;
	NMDeviceState _tmp8_;
	self = (NetworkWifiInterface*) base;
	NETWORK_WIDGET_NM_INTERFACE_CLASS (network_wifi_interface_parent_class)->update ((NetworkWidgetNMInterface*) G_TYPE_CHECK_INSTANCE_CAST (self, NETWORK_TYPE_ABSTRACT_WIFI_INTERFACE, NetworkAbstractWifiInterface));
	_tmp0_ = self->priv->wifi_item;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, !((NetworkAbstractWifiInterface*) self)->hardware_locked);
	_tmp1_ = self->priv->wifi_item;
	network_widgets_switch_set_active (_tmp1_, !((NetworkAbstractWifiInterface*) self)->locked);
	_tmp2_ = ((NetworkAbstractWifiInterface*) self)->wifi_device;
	_tmp3_ = nm_device_wifi_get_active_access_point (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (((NetworkAbstractWifiInterface*) self)->active_ap);
	((NetworkAbstractWifiInterface*) self)->active_ap = _tmp4_;
	_tmp6_ = ((NetworkAbstractWifiInterface*) self)->wifi_device;
	_tmp7_ = nm_device_get_state ((NMDevice*) _tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == NM_DEVICE_STATE_UNAVAILABLE) {
		_tmp5_ = TRUE;
	} else {
		NetworkState _tmp9_;
		NetworkState _tmp10_;
		_tmp9_ = network_widget_nm_interface_get_state ((NetworkWidgetNMInterface*) self);
		_tmp10_ = _tmp9_;
		_tmp5_ = _tmp10_ == NETWORK_STATE_FAILED_WIFI;
	}
	if (_tmp5_) {
		GtkRevealer* _tmp11_;
		_tmp11_ = self->priv->revealer;
		gtk_revealer_set_reveal_child (_tmp11_, FALSE);
		network_wifi_interface_set_hidden_sensitivity (self, FALSE);
	} else {
		GtkRevealer* _tmp12_;
		_tmp12_ = self->priv->revealer;
		gtk_revealer_set_reveal_child (_tmp12_, TRUE);
		network_wifi_interface_set_hidden_sensitivity (self, TRUE);
	}
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static gboolean
__lambda14_ (NetworkWifiInterface* self)
{
	gboolean result;
	network_widget_nm_interface_update ((NetworkWidgetNMInterface*) self);
	result = FALSE;
	return result;
}

static gboolean
___lambda14__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda14_ ((NetworkWifiInterface*) self);
	return result;
}

static void
network_wifi_interface_real_wifi_activate_cb (NetworkAbstractWifiInterface* base,
                                              NetworkWifiMenuItem* i)
{
	NetworkWifiInterface * self;
	GPtrArray* connections = NULL;
	NMClient* _tmp0_;
	GPtrArray* _tmp1_;
	GPtrArray* _tmp2_;
	GPtrArray* device_connections = NULL;
	NMDeviceWifi* _tmp3_;
	GPtrArray* _tmp4_;
	GPtrArray* _tmp5_;
	NMAccessPoint* ap = NULL;
	NMAccessPoint* _tmp6_;
	GPtrArray* ap_connections = NULL;
	NMAccessPoint* _tmp7_;
	GPtrArray* _tmp8_;
	GPtrArray* _tmp9_;
	gboolean already_connected = FALSE;
	GPtrArray* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	self = (NetworkWifiInterface*) base;
	g_return_if_fail (i != NULL);
	_tmp0_ = ((NetworkAbstractWifiInterface*) self)->nm_client;
	_tmp1_ = nm_client_get_connections (_tmp0_);
	_tmp2_ = _g_ptr_array_ref0 (_tmp1_);
	connections = _tmp2_;
	_tmp3_ = ((NetworkAbstractWifiInterface*) self)->wifi_device;
	_tmp4_ = connections;
	_tmp5_ = nm_device_filter_connections ((NMDevice*) _tmp3_, _tmp4_);
	device_connections = _tmp5_;
	_tmp6_ = network_wifi_menu_item_get_nearest_ap (i);
	ap = _tmp6_;
	_tmp7_ = ap;
	_tmp8_ = device_connections;
	_tmp9_ = nm_access_point_filter_connections (_tmp7_, _tmp8_);
	ap_connections = _tmp9_;
	_tmp10_ = ap_connections;
	_tmp11_ = vala_g_ptr_array_get_length (_tmp10_);
	_tmp12_ = _tmp11_;
	already_connected = _tmp12_ > 0;
	if (already_connected) {
		NMClient* _tmp13_;
		GPtrArray* _tmp14_;
		gconstpointer _tmp15_;
		NMDeviceWifi* _tmp16_;
		NMAccessPoint* _tmp17_;
		const gchar* _tmp18_;
		_tmp13_ = ((NetworkAbstractWifiInterface*) self)->nm_client;
		_tmp14_ = ap_connections;
		_tmp15_ = g_ptr_array_index (_tmp14_, (guint) 0);
		_tmp16_ = ((NetworkAbstractWifiInterface*) self)->wifi_device;
		_tmp17_ = ap;
		_tmp18_ = nm_object_get_path ((NMObject*) _tmp17_);
		nm_client_activate_connection_async (_tmp13_, (NMConnection*) _tmp15_, (NMDevice*) _tmp16_, _tmp18_, NULL, NULL, NULL);
	} else {
		NMAccessPoint* _tmp19_;
		GBytes* _tmp20_;
		GBytes* _tmp21_;
		gsize _tmp22_ = 0;
		guint8* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		NMAccessPoint* _tmp26_;
		NM80211ApSecurityFlags _tmp27_;
		NM80211ApSecurityFlags _tmp28_;
		_tmp19_ = ap;
		_tmp20_ = nm_access_point_get_ssid (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp23_ = g_bytes_get_data (_tmp21_, &_tmp22_);
		_tmp24_ = nm_utils_ssid_to_utf8 (_tmp23_, (gsize) _tmp22_);
		_tmp25_ = _tmp24_;
		g_debug ("WifiInterface.vala:92: Trying to connect to %s", _tmp25_);
		_g_free0 (_tmp25_);
		_tmp26_ = ap;
		_tmp27_ = nm_access_point_get_wpa_flags (_tmp26_);
		_tmp28_ = _tmp27_;
		if (_tmp28_ == NM_802_11_AP_SEC_NONE) {
			NMClient* _tmp29_;
			NMConnection* _tmp30_;
			NMConnection* _tmp31_;
			NMDevice* _tmp32_;
			NMAccessPoint* _tmp33_;
			const gchar* _tmp34_;
			g_debug ("WifiInterface.vala:95: Directly, as it is an insecure network.");
			_tmp29_ = ((NetworkAbstractWifiInterface*) self)->nm_client;
			_tmp30_ = nm_simple_connection_new ();
			_tmp31_ = _tmp30_;
			_tmp32_ = ((NetworkWidgetNMInterface*) self)->device;
			_tmp33_ = ap;
			_tmp34_ = nm_object_get_path ((NMObject*) _tmp33_);
			nm_client_add_and_activate_connection_async (_tmp29_, _tmp31_, _tmp32_, _tmp34_, NULL, NULL, NULL);
			_g_object_unref0 (_tmp31_);
		} else {
			g_debug ("WifiInterface.vala:102: Needs a password or a certificate, let's open " \
"switchboard.");
			g_signal_emit_by_name ((NetworkWidgetNMInterface*) self, "need-settings");
		}
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda14__gsource_func, g_object_ref (self), g_object_unref);
	_g_ptr_array_unref0 (ap_connections);
	_g_object_unref0 (ap);
	_g_ptr_array_unref0 (device_connections);
	_g_ptr_array_unref0 (connections);
}

void
network_wifi_interface_start_scanning (NetworkWifiInterface* self)
{
	GCancellable* _tmp0_;
	NMDeviceWifi* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->wifi_scan_cancellable;
	g_cancellable_reset (_tmp0_);
	_tmp1_ = ((NetworkAbstractWifiInterface*) self)->wifi_device;
	_tmp2_ = self->priv->wifi_scan_cancellable;
	nm_device_wifi_request_scan_async (_tmp1_, _tmp2_, NULL, NULL);
}

void
network_wifi_interface_cancel_scanning (NetworkWifiInterface* self)
{
	GCancellable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->wifi_scan_cancellable;
	g_cancellable_cancel (_tmp0_);
}

gboolean
network_wifi_interface_get_hidden_sensitivity (NetworkWifiInterface* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_hidden_sensitivity;
	return result;
}

void
network_wifi_interface_set_hidden_sensitivity (NetworkWifiInterface* self,
                                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = network_wifi_interface_get_hidden_sensitivity (self);
	if (old_value != value) {
		self->priv->_hidden_sensitivity = value;
		g_object_notify_by_pspec ((GObject *) self, network_wifi_interface_properties[NETWORK_WIFI_INTERFACE_HIDDEN_SENSITIVITY_PROPERTY]);
	}
}

static GObject *
network_wifi_interface_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NetworkWifiInterface * self;
	NetworkWidgetsSwitch* _tmp0_;
	NetworkWidgetsSwitch* _tmp1_;
	GtkStyleContext* _tmp2_;
	NetworkWidgetsSwitch* _tmp3_;
	GtkScrolledWindow* scrolled_box = NULL;
	GtkScrolledWindow* _tmp4_;
	GtkScrolledWindow* _tmp5_;
	GtkScrolledWindow* _tmp6_;
	GtkScrolledWindow* _tmp7_;
	GtkScrolledWindow* _tmp8_;
	GtkListBox* _tmp9_;
	GtkRevealer* _tmp10_;
	GtkRevealer* _tmp11_;
	GtkScrolledWindow* _tmp12_;
	GtkRevealer* _tmp13_;
	parent_class = G_OBJECT_CLASS (network_wifi_interface_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_WIFI_INTERFACE, NetworkWifiInterface);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	_tmp0_ = network_widgets_switch_new ("");
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->wifi_item);
	self->priv->wifi_item = _tmp0_;
	_tmp1_ = self->priv->wifi_item;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
	gtk_style_context_add_class (_tmp2_, "h4");
	_tmp3_ = self->priv->wifi_item;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp3_, TRUE, TRUE, (guint) 0);
	_tmp4_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp4_);
	scrolled_box = _tmp4_;
	_tmp5_ = scrolled_box;
	g_object_set (_tmp5_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	_tmp6_ = scrolled_box;
	gtk_scrolled_window_set_max_content_height (_tmp6_, 512);
	_tmp7_ = scrolled_box;
	gtk_scrolled_window_set_propagate_natural_height (_tmp7_, TRUE);
	_tmp8_ = scrolled_box;
	_tmp9_ = ((NetworkAbstractWifiInterface*) self)->wifi_list;
	gtk_container_add ((GtkContainer*) _tmp8_, (GtkWidget*) _tmp9_);
	_tmp10_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->revealer);
	self->priv->revealer = _tmp10_;
	_tmp11_ = self->priv->revealer;
	_tmp12_ = scrolled_box;
	gtk_container_add ((GtkContainer*) _tmp11_, (GtkWidget*) _tmp12_);
	_tmp13_ = self->priv->revealer;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp13_, TRUE, TRUE, (guint) 0);
	_g_object_unref0 (scrolled_box);
	return obj;
}

static void
network_wifi_interface_class_init (NetworkWifiInterfaceClass * klass,
                                   gpointer klass_data)
{
	network_wifi_interface_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NetworkWifiInterface_private_offset);
	((NetworkWidgetNMInterfaceClass *) klass)->update = (void (*) (NetworkWidgetNMInterface*)) network_wifi_interface_real_update;
	((NetworkAbstractWifiInterfaceClass *) klass)->wifi_activate_cb = (void (*) (NetworkAbstractWifiInterface*, NetworkWifiMenuItem*)) network_wifi_interface_real_wifi_activate_cb;
	G_OBJECT_CLASS (klass)->get_property = _vala_network_wifi_interface_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_network_wifi_interface_set_property;
	G_OBJECT_CLASS (klass)->constructor = network_wifi_interface_constructor;
	G_OBJECT_CLASS (klass)->finalize = network_wifi_interface_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIFI_INTERFACE_HIDDEN_SENSITIVITY_PROPERTY, network_wifi_interface_properties[NETWORK_WIFI_INTERFACE_HIDDEN_SENSITIVITY_PROPERTY] = g_param_spec_boolean ("hidden-sensitivity", "hidden-sensitivity", "hidden-sensitivity", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
network_wifi_interface_instance_init (NetworkWifiInterface * self,
                                      gpointer klass)
{
	GCancellable* _tmp0_;
	self->priv = network_wifi_interface_get_instance_private (self);
	self->priv->_hidden_sensitivity = TRUE;
	_tmp0_ = g_cancellable_new ();
	self->priv->wifi_scan_cancellable = _tmp0_;
}

static void
network_wifi_interface_finalize (GObject * obj)
{
	NetworkWifiInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_WIFI_INTERFACE, NetworkWifiInterface);
	_g_object_unref0 (self->priv->wifi_item);
	_g_object_unref0 (self->priv->revealer);
	_g_object_unref0 (self->priv->wifi_scan_cancellable);
	G_OBJECT_CLASS (network_wifi_interface_parent_class)->finalize (obj);
}

GType
network_wifi_interface_get_type (void)
{
	return network_wifi_interface_type_id;
}

GType
network_wifi_interface_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (NetworkWifiInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) network_wifi_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetworkWifiInterface), 0, (GInstanceInitFunc) network_wifi_interface_instance_init, NULL };
	network_wifi_interface_type_id = g_type_module_register_type (module, NETWORK_TYPE_ABSTRACT_WIFI_INTERFACE, "NetworkWifiInterface", &g_define_type_info, 0);
	NetworkWifiInterface_private_offset = sizeof (NetworkWifiInterfacePrivate);
	return network_wifi_interface_type_id;
}

static void
_vala_network_wifi_interface_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	NetworkWifiInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_TYPE_WIFI_INTERFACE, NetworkWifiInterface);
	switch (property_id) {
		case NETWORK_WIFI_INTERFACE_HIDDEN_SENSITIVITY_PROPERTY:
		g_value_set_boolean (value, network_wifi_interface_get_hidden_sensitivity (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_network_wifi_interface_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	NetworkWifiInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_TYPE_WIFI_INTERFACE, NetworkWifiInterface);
	switch (property_id) {
		case NETWORK_WIFI_INTERFACE_HIDDEN_SENSITIVITY_PROPERTY:
		network_wifi_interface_set_hidden_sensitivity (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

