/* BluetoothInterface.c generated by valac 0.56.17, the Vala compiler
 * generated from BluetoothInterface.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2022 Ubuntu Budgie Developers
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: David Mohammed <fossfreedom@ubuntu.com>
 */

#include "networkapplet.h"
#include <glib-object.h>
#include <NetworkManager.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NETWORK_BLUETOOTH_INTERFACE_0_PROPERTY,
	NETWORK_BLUETOOTH_INTERFACE_NUM_PROPERTIES
};
static GParamSpec* network_bluetooth_interface_properties[NETWORK_BLUETOOTH_INTERFACE_NUM_PROPERTIES];
typedef enum  {
	NETWORK_BLUETOOTH_INTERFACE_BLUETOOTH_TYPE_NONE = 0,
	NETWORK_BLUETOOTH_INTERFACE_BLUETOOTH_TYPE_DUN = 1 << 0,
	NETWORK_BLUETOOTH_INTERFACE_BLUETOOTH_TYPE_NAP = 1 << 1
} NetworkBluetoothInterfaceBluetoothType;

#define NETWORK_BLUETOOTH_INTERFACE_TYPE_BLUETOOTH_TYPE (network_bluetooth_interface_bluetooth_type_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block6Data Block6Data;

struct _NetworkBluetoothInterfacePrivate {
	NetworkWidgetsSwitch* bluetooth_item;
};

struct _Block6Data {
	int _ref_count_;
	NetworkBluetoothInterface* self;
	NMClient* nm_client;
};

static gint NetworkBluetoothInterface_private_offset;
static gpointer network_bluetooth_interface_parent_class = NULL;
static GType network_bluetooth_interface_type_id = 0;

static GType network_bluetooth_interface_bluetooth_type_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda24_ (NetworkBluetoothInterface* self);
static void ___lambda24__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda25_ (Block6Data* _data6_);
static void ____lambda26_ (NetworkBluetoothInterface* self);
static void _____lambda26__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static void ___lambda25__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda27_ (NetworkBluetoothInterface* self);
static void ___lambda27__nm_device_state_changed (NMDevice* _sender,
                                           guint new_state,
                                           guint old_state,
                                           guint reason,
                                           gpointer self);
static void network_bluetooth_interface_real_update (NetworkWidgetNMInterface* base);
static void network_bluetooth_interface_finalize (GObject * obj);

static inline gpointer
network_bluetooth_interface_get_instance_private (NetworkBluetoothInterface* self)
{
	return G_STRUCT_MEMBER_P (self, NetworkBluetoothInterface_private_offset);
}

static GType
network_bluetooth_interface_bluetooth_type_get_type_once (void)
{
	static const GEnumValue values[] = {{NETWORK_BLUETOOTH_INTERFACE_BLUETOOTH_TYPE_NONE, "NETWORK_BLUETOOTH_INTERFACE_BLUETOOTH_TYPE_NONE", "none"}, {NETWORK_BLUETOOTH_INTERFACE_BLUETOOTH_TYPE_DUN, "NETWORK_BLUETOOTH_INTERFACE_BLUETOOTH_TYPE_DUN", "dun"}, {NETWORK_BLUETOOTH_INTERFACE_BLUETOOTH_TYPE_NAP, "NETWORK_BLUETOOTH_INTERFACE_BLUETOOTH_TYPE_NAP", "nap"}, {0, NULL, NULL}};
	GType network_bluetooth_interface_bluetooth_type_type_id;
	network_bluetooth_interface_bluetooth_type_type_id = g_enum_register_static ("NetworkBluetoothInterfaceBluetoothType", values);
	return network_bluetooth_interface_bluetooth_type_type_id;
}

static GType
network_bluetooth_interface_bluetooth_type_get_type (void)
{
	static volatile gsize network_bluetooth_interface_bluetooth_type_type_id__once = 0;
	if (g_once_init_enter (&network_bluetooth_interface_bluetooth_type_type_id__once)) {
		GType network_bluetooth_interface_bluetooth_type_type_id;
		network_bluetooth_interface_bluetooth_type_type_id = network_bluetooth_interface_bluetooth_type_get_type_once ();
		g_once_init_leave (&network_bluetooth_interface_bluetooth_type_type_id__once, network_bluetooth_interface_bluetooth_type_type_id);
	}
	return network_bluetooth_interface_bluetooth_type_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		NetworkBluetoothInterface* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->nm_client);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
__lambda24_ (NetworkBluetoothInterface* self)
{
	NetworkWidgetsSwitch* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	_tmp0_ = self->priv->bluetooth_item;
	_tmp1_ = network_widget_nm_interface_get_display_title ((NetworkWidgetNMInterface*) self);
	_tmp2_ = _tmp1_;
	network_widgets_switch_set_caption (_tmp0_, _tmp2_);
}

static void
___lambda24__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda24_ ((NetworkBluetoothInterface*) self);
}

static void
____lambda26_ (NetworkBluetoothInterface* self)
{
	g_debug ("BluetoothInterface.vala:43: Successfully disconnected.");
}

static void
_____lambda26__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	____lambda26_ ((NetworkBluetoothInterface*) self);
	g_object_unref (self);
}

static void
__lambda25_ (Block6Data* _data6_)
{
	NetworkBluetoothInterface* self;
	gboolean _tmp0_ = FALSE;
	NetworkWidgetsSwitch* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = _data6_->self;
	_tmp1_ = self->priv->bluetooth_item;
	_tmp2_ = network_widgets_switch_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		NMDevice* _tmp4_;
		NMDeviceState _tmp5_;
		NMDeviceState _tmp6_;
		_tmp4_ = ((NetworkWidgetNMInterface*) self)->device;
		_tmp5_ = nm_device_get_state (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ == NM_DEVICE_STATE_DISCONNECTED;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		NMDevice* _tmp7_;
		_tmp7_ = ((NetworkWidgetNMInterface*) self)->device;
		nm_client_activate_connection_async (_data6_->nm_client, NULL, _tmp7_, NULL, NULL, NULL, NULL);
	} else {
		gboolean _tmp8_ = FALSE;
		NetworkWidgetsSwitch* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp9_ = self->priv->bluetooth_item;
		_tmp10_ = network_widgets_switch_get_active (_tmp9_);
		_tmp11_ = _tmp10_;
		if (!_tmp11_) {
			NMDevice* _tmp12_;
			NMDeviceState _tmp13_;
			NMDeviceState _tmp14_;
			_tmp12_ = ((NetworkWidgetNMInterface*) self)->device;
			_tmp13_ = nm_device_get_state (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp8_ = _tmp14_ == NM_DEVICE_STATE_ACTIVATED;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			NMDevice* _tmp15_;
			_tmp15_ = ((NetworkWidgetNMInterface*) self)->device;
			nm_device_disconnect_async (_tmp15_, NULL, _____lambda26__gasync_ready_callback, g_object_ref (self));
		}
	}
}

static void
___lambda25__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda25_ (self);
}

static void
__lambda27_ (NetworkBluetoothInterface* self)
{
	network_widget_nm_interface_update ((NetworkWidgetNMInterface*) self);
}

static void
___lambda27__nm_device_state_changed (NMDevice* _sender,
                                      guint new_state,
                                      guint old_state,
                                      guint reason,
                                      gpointer self)
{
	__lambda27_ ((NetworkBluetoothInterface*) self);
}

NetworkBluetoothInterface*
network_bluetooth_interface_construct (GType object_type,
                                       NMClient* nm_client,
                                       NMDevice* _device)
{
	NetworkBluetoothInterface * self = NULL;
	Block6Data* _data6_;
	NMClient* _tmp0_;
	NMDevice* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	NetworkWidgetsSwitch* _tmp4_;
	NetworkWidgetsSwitch* _tmp5_;
	GtkStyleContext* _tmp6_;
	NetworkWidgetsSwitch* _tmp7_;
	NetworkWidgetsSwitch* _tmp8_;
	NMDevice* _tmp9_;
	g_return_val_if_fail (nm_client != NULL, NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (nm_client);
	_g_object_unref0 (_data6_->nm_client);
	_data6_->nm_client = _tmp0_;
	self = (NetworkBluetoothInterface*) network_abstract_bluetooth_interface_construct (object_type);
	_data6_->self = g_object_ref (self);
	_tmp1_ = _g_object_ref0 (_device);
	_g_object_unref0 (((NetworkWidgetNMInterface*) self)->device);
	((NetworkWidgetNMInterface*) self)->device = _tmp1_;
	_tmp2_ = network_widget_nm_interface_get_display_title ((NetworkWidgetNMInterface*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = network_widgets_switch_new (_tmp3_);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->bluetooth_item);
	self->priv->bluetooth_item = _tmp4_;
	g_signal_connect_object ((GObject*) self, "notify::display-title", (GCallback) ___lambda24__g_object_notify, self, 0);
	_tmp5_ = self->priv->bluetooth_item;
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _tmp5_);
	gtk_style_context_add_class (_tmp6_, "h4");
	_tmp7_ = self->priv->bluetooth_item;
	g_signal_connect_data ((GObject*) _tmp7_, "notify::active", (GCallback) ___lambda25__g_object_notify, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_tmp8_ = self->priv->bluetooth_item;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp8_);
	_tmp9_ = ((NetworkWidgetNMInterface*) self)->device;
	g_signal_connect_object (_tmp9_, "state-changed", (GCallback) ___lambda27__nm_device_state_changed, self, 0);
	block6_data_unref (_data6_);
	_data6_ = NULL;
	return self;
}

NetworkBluetoothInterface*
network_bluetooth_interface_new (NMClient* nm_client,
                                 NMDevice* _device)
{
	return network_bluetooth_interface_construct (NETWORK_TYPE_BLUETOOTH_INTERFACE, nm_client, _device);
}

static void
network_bluetooth_interface_real_update (NetworkWidgetNMInterface* base)
{
	NetworkBluetoothInterface * self;
	NMDevice* _tmp0_;
	NMDeviceState _tmp1_;
	NMDeviceState _tmp2_;
	self = (NetworkBluetoothInterface*) base;
	_tmp0_ = ((NetworkWidgetNMInterface*) self)->device;
	_tmp1_ = nm_device_get_state (_tmp0_);
	_tmp2_ = _tmp1_;
	switch (_tmp2_) {
		case NM_DEVICE_STATE_UNKNOWN:
		case NM_DEVICE_STATE_UNMANAGED:
		case NM_DEVICE_STATE_UNAVAILABLE:
		case NM_DEVICE_STATE_FAILED:
		{
			NetworkWidgetsSwitch* _tmp3_;
			NetworkWidgetsSwitch* _tmp4_;
			_tmp3_ = self->priv->bluetooth_item;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, FALSE);
			_tmp4_ = self->priv->bluetooth_item;
			network_widgets_switch_set_active (_tmp4_, FALSE);
			network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, NETWORK_STATE_WIRED_UNPLUGGED);
			break;
		}
		case NM_DEVICE_STATE_DISCONNECTED:
		case NM_DEVICE_STATE_DEACTIVATING:
		{
			NetworkWidgetsSwitch* _tmp5_;
			NetworkWidgetsSwitch* _tmp6_;
			_tmp5_ = self->priv->bluetooth_item;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, TRUE);
			_tmp6_ = self->priv->bluetooth_item;
			network_widgets_switch_set_active (_tmp6_, FALSE);
			network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, NETWORK_STATE_FAILED_MOBILE);
			break;
		}
		case NM_DEVICE_STATE_PREPARE:
		case NM_DEVICE_STATE_CONFIG:
		case NM_DEVICE_STATE_NEED_AUTH:
		case NM_DEVICE_STATE_IP_CONFIG:
		case NM_DEVICE_STATE_IP_CHECK:
		case NM_DEVICE_STATE_SECONDARIES:
		{
			NetworkWidgetsSwitch* _tmp7_;
			NetworkWidgetsSwitch* _tmp8_;
			_tmp7_ = self->priv->bluetooth_item;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, TRUE);
			_tmp8_ = self->priv->bluetooth_item;
			network_widgets_switch_set_active (_tmp8_, TRUE);
			network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, NETWORK_STATE_CONNECTING_MOBILE);
			break;
		}
		case NM_DEVICE_STATE_ACTIVATED:
		{
			NetworkWidgetsSwitch* _tmp9_;
			NetworkWidgetsSwitch* _tmp10_;
			_tmp9_ = self->priv->bluetooth_item;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, TRUE);
			_tmp10_ = self->priv->bluetooth_item;
			network_widgets_switch_set_active (_tmp10_, TRUE);
			network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, NETWORK_STATE_CONNECTED_WIFI_EXCELLENT);
			break;
		}
		default:
		break;
	}
}

static void
network_bluetooth_interface_class_init (NetworkBluetoothInterfaceClass * klass,
                                        gpointer klass_data)
{
	network_bluetooth_interface_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NetworkBluetoothInterface_private_offset);
	((NetworkWidgetNMInterfaceClass *) klass)->update = (void (*) (NetworkWidgetNMInterface*)) network_bluetooth_interface_real_update;
	G_OBJECT_CLASS (klass)->finalize = network_bluetooth_interface_finalize;
}

static void
network_bluetooth_interface_instance_init (NetworkBluetoothInterface * self,
                                           gpointer klass)
{
	self->priv = network_bluetooth_interface_get_instance_private (self);
}

static void
network_bluetooth_interface_finalize (GObject * obj)
{
	NetworkBluetoothInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_BLUETOOTH_INTERFACE, NetworkBluetoothInterface);
	_g_object_unref0 (self->priv->bluetooth_item);
	G_OBJECT_CLASS (network_bluetooth_interface_parent_class)->finalize (obj);
}

GType
network_bluetooth_interface_get_type (void)
{
	return network_bluetooth_interface_type_id;
}

GType
network_bluetooth_interface_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (NetworkBluetoothInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) network_bluetooth_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetworkBluetoothInterface), 0, (GInstanceInitFunc) network_bluetooth_interface_instance_init, NULL };
	network_bluetooth_interface_type_id = g_type_module_register_type (module, NETWORK_TYPE_ABSTRACT_BLUETOOTH_INTERFACE, "NetworkBluetoothInterface", &g_define_type_info, 0);
	NetworkBluetoothInterface_private_offset = sizeof (NetworkBluetoothInterfacePrivate);
	return network_bluetooth_interface_type_id;
}

