/* settings_raven_widgets.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from settings_raven_widgets.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include "budgie-private.h"
#include "raven.h"
#include "raven-plugin.h"
#include <libpeas/peas.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_RAVEN_WIDGET_SETTINGS_FRAME (budgie_raven_widget_settings_frame_get_type ())
#define BUDGIE_RAVEN_WIDGET_SETTINGS_FRAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_RAVEN_WIDGET_SETTINGS_FRAME, BudgieRavenWidgetSettingsFrame))
#define BUDGIE_RAVEN_WIDGET_SETTINGS_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_RAVEN_WIDGET_SETTINGS_FRAME, BudgieRavenWidgetSettingsFrameClass))
#define BUDGIE_IS_RAVEN_WIDGET_SETTINGS_FRAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_RAVEN_WIDGET_SETTINGS_FRAME))
#define BUDGIE_IS_RAVEN_WIDGET_SETTINGS_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_RAVEN_WIDGET_SETTINGS_FRAME))
#define BUDGIE_RAVEN_WIDGET_SETTINGS_FRAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_RAVEN_WIDGET_SETTINGS_FRAME, BudgieRavenWidgetSettingsFrameClass))

typedef struct _BudgieRavenWidgetSettingsFrame BudgieRavenWidgetSettingsFrame;
typedef struct _BudgieRavenWidgetSettingsFrameClass BudgieRavenWidgetSettingsFrameClass;
typedef struct _BudgieRavenWidgetSettingsFramePrivate BudgieRavenWidgetSettingsFramePrivate;
enum  {
	BUDGIE_RAVEN_WIDGET_SETTINGS_FRAME_0_PROPERTY,
	BUDGIE_RAVEN_WIDGET_SETTINGS_FRAME_NUM_PROPERTIES
};
static GParamSpec* budgie_raven_widget_settings_frame_properties[BUDGIE_RAVEN_WIDGET_SETTINGS_FRAME_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BUDGIE_TYPE_RAVEN_WIDGETS_PAGE (budgie_raven_widgets_page_get_type ())
#define BUDGIE_RAVEN_WIDGETS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_RAVEN_WIDGETS_PAGE, BudgieRavenWidgetsPage))
#define BUDGIE_RAVEN_WIDGETS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_RAVEN_WIDGETS_PAGE, BudgieRavenWidgetsPageClass))
#define BUDGIE_IS_RAVEN_WIDGETS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_RAVEN_WIDGETS_PAGE))
#define BUDGIE_IS_RAVEN_WIDGETS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_RAVEN_WIDGETS_PAGE))
#define BUDGIE_RAVEN_WIDGETS_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_RAVEN_WIDGETS_PAGE, BudgieRavenWidgetsPageClass))

typedef struct _BudgieRavenWidgetsPage BudgieRavenWidgetsPage;
typedef struct _BudgieRavenWidgetsPageClass BudgieRavenWidgetsPageClass;
typedef struct _BudgieRavenWidgetsPagePrivate BudgieRavenWidgetsPagePrivate;

#define BUDGIE_TYPE_RAVEN_WIDGET_ITEM (budgie_raven_widget_item_get_type ())
#define BUDGIE_RAVEN_WIDGET_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_RAVEN_WIDGET_ITEM, BudgieRavenWidgetItem))
#define BUDGIE_RAVEN_WIDGET_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_RAVEN_WIDGET_ITEM, BudgieRavenWidgetItemClass))
#define BUDGIE_IS_RAVEN_WIDGET_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_RAVEN_WIDGET_ITEM))
#define BUDGIE_IS_RAVEN_WIDGET_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_RAVEN_WIDGET_ITEM))
#define BUDGIE_RAVEN_WIDGET_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_RAVEN_WIDGET_ITEM, BudgieRavenWidgetItemClass))

typedef struct _BudgieRavenWidgetItem BudgieRavenWidgetItem;
typedef struct _BudgieRavenWidgetItemClass BudgieRavenWidgetItemClass;
enum  {
	BUDGIE_RAVEN_WIDGETS_PAGE_0_PROPERTY,
	BUDGIE_RAVEN_WIDGETS_PAGE_NUM_PROPERTIES
};
static GParamSpec* budgie_raven_widgets_page_properties[BUDGIE_RAVEN_WIDGETS_PAGE_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define BUDGIE_TYPE_SETTINGS_GRID (budgie_settings_grid_get_type ())
#define BUDGIE_SETTINGS_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SETTINGS_GRID, BudgieSettingsGrid))
#define BUDGIE_SETTINGS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SETTINGS_GRID, BudgieSettingsGridClass))
#define BUDGIE_IS_SETTINGS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SETTINGS_GRID))
#define BUDGIE_IS_SETTINGS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SETTINGS_GRID))
#define BUDGIE_SETTINGS_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SETTINGS_GRID, BudgieSettingsGridClass))

typedef struct _BudgieSettingsGrid BudgieSettingsGrid;
typedef struct _BudgieSettingsGridClass BudgieSettingsGridClass;
typedef struct _BudgieSettingsGridPrivate BudgieSettingsGridPrivate;

#define BUDGIE_TYPE_SETTINGS_ROW (budgie_settings_row_get_type ())
#define BUDGIE_SETTINGS_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SETTINGS_ROW, BudgieSettingsRow))
#define BUDGIE_SETTINGS_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SETTINGS_ROW, BudgieSettingsRowClass))
#define BUDGIE_IS_SETTINGS_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SETTINGS_ROW))
#define BUDGIE_IS_SETTINGS_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SETTINGS_ROW))
#define BUDGIE_SETTINGS_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SETTINGS_ROW, BudgieSettingsRowClass))

typedef struct _BudgieSettingsRow BudgieSettingsRow;
typedef struct _BudgieSettingsRowClass BudgieSettingsRowClass;
typedef struct _BudgieRavenWidgetItemPrivate BudgieRavenWidgetItemPrivate;

#define BUDGIE_TYPE_SETTINGS_PLUGIN_CHOOSER (budgie_settings_plugin_chooser_get_type ())
#define BUDGIE_SETTINGS_PLUGIN_CHOOSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SETTINGS_PLUGIN_CHOOSER, BudgieSettingsPluginChooser))
#define BUDGIE_SETTINGS_PLUGIN_CHOOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SETTINGS_PLUGIN_CHOOSER, BudgieSettingsPluginChooserClass))
#define BUDGIE_IS_SETTINGS_PLUGIN_CHOOSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SETTINGS_PLUGIN_CHOOSER))
#define BUDGIE_IS_SETTINGS_PLUGIN_CHOOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SETTINGS_PLUGIN_CHOOSER))
#define BUDGIE_SETTINGS_PLUGIN_CHOOSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SETTINGS_PLUGIN_CHOOSER, BudgieSettingsPluginChooserClass))

typedef struct _BudgieSettingsPluginChooser BudgieSettingsPluginChooser;
typedef struct _BudgieSettingsPluginChooserClass BudgieSettingsPluginChooserClass;

#define BUDGIE_TYPE_REMOVE_RAVEN_WIDGET_DIALOG (budgie_remove_raven_widget_dialog_get_type ())
#define BUDGIE_REMOVE_RAVEN_WIDGET_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_REMOVE_RAVEN_WIDGET_DIALOG, BudgieRemoveRavenWidgetDialog))
#define BUDGIE_REMOVE_RAVEN_WIDGET_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_REMOVE_RAVEN_WIDGET_DIALOG, BudgieRemoveRavenWidgetDialogClass))
#define BUDGIE_IS_REMOVE_RAVEN_WIDGET_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_REMOVE_RAVEN_WIDGET_DIALOG))
#define BUDGIE_IS_REMOVE_RAVEN_WIDGET_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_REMOVE_RAVEN_WIDGET_DIALOG))
#define BUDGIE_REMOVE_RAVEN_WIDGET_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_REMOVE_RAVEN_WIDGET_DIALOG, BudgieRemoveRavenWidgetDialogClass))

typedef struct _BudgieRemoveRavenWidgetDialog BudgieRemoveRavenWidgetDialog;
typedef struct _BudgieRemoveRavenWidgetDialogClass BudgieRemoveRavenWidgetDialogClass;
#define _budgie_raven_widget_data_unref0(var) ((var == NULL) ? NULL : (var = (budgie_raven_widget_data_unref (var), NULL)))
enum  {
	BUDGIE_RAVEN_WIDGET_ITEM_0_PROPERTY,
	BUDGIE_RAVEN_WIDGET_ITEM_NUM_PROPERTIES
};
static GParamSpec* budgie_raven_widget_item_properties[BUDGIE_RAVEN_WIDGET_ITEM_NUM_PROPERTIES];

struct _BudgieRavenWidgetSettingsFrame {
	GtkBox parent_instance;
	BudgieRavenWidgetSettingsFramePrivate * priv;
};

struct _BudgieRavenWidgetSettingsFrameClass {
	GtkBoxClass parent_class;
};

struct _BudgieRavenWidgetsPage {
	GtkBox parent_instance;
	BudgieRavenWidgetsPagePrivate * priv;
};

struct _BudgieRavenWidgetsPageClass {
	GtkBoxClass parent_class;
};

struct _BudgieRavenWidgetsPagePrivate {
	BudgieDesktopManager* manager;
	BudgieRaven* raven;
	GtkListBox* listbox_widgets;
	GHashTable* items;
	GtkButton* button_add;
	GtkButton* button_move_widget_up;
	GtkButton* button_move_widget_down;
	GtkButton* button_remove_widget;
	GtkStack* settings_stack;
};

struct _BudgieSettingsGrid {
	GtkGrid parent_instance;
	BudgieSettingsGridPrivate * priv;
	gint current_row;
	gboolean small_mode;
};

struct _BudgieSettingsGridClass {
	GtkGridClass parent_class;
};

struct _BudgieRavenWidgetItem {
	GtkBox parent_instance;
	BudgieRavenWidgetItemPrivate * priv;
	BudgieRavenWidgetData* widget_data;
};

struct _BudgieRavenWidgetItemClass {
	GtkBoxClass parent_class;
};

struct _BudgieRavenWidgetItemPrivate {
	GtkImage* image;
	GtkLabel* label;
};

static gpointer budgie_raven_widget_settings_frame_parent_class = NULL;
static gint BudgieRavenWidgetsPage_private_offset;
static gpointer budgie_raven_widgets_page_parent_class = NULL;
static gint BudgieRavenWidgetItem_private_offset;
static gpointer budgie_raven_widget_item_parent_class = NULL;

VALA_EXTERN GType budgie_raven_widget_settings_frame_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieRavenWidgetSettingsFrame, g_object_unref)
VALA_EXTERN BudgieRavenWidgetSettingsFrame* budgie_raven_widget_settings_frame_new (void);
VALA_EXTERN BudgieRavenWidgetSettingsFrame* budgie_raven_widget_settings_frame_construct (GType object_type);
static void budgie_raven_widget_settings_frame_real_add (GtkContainer* base,
                                                  GtkWidget* widget);
static GType budgie_raven_widget_settings_frame_get_type_once (void);
VALA_EXTERN GType budgie_raven_widgets_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieRavenWidgetsPage, g_object_unref)
VALA_EXTERN GType budgie_raven_widget_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieRavenWidgetItem, g_object_unref)
VALA_EXTERN BudgieRavenWidgetsPage* budgie_raven_widgets_page_new (BudgieDesktopManager* manager);
VALA_EXTERN BudgieRavenWidgetsPage* budgie_raven_widgets_page_construct (GType object_type,
                                                             BudgieDesktopManager* manager);
static void __lambda19_ (BudgieRavenWidgetsPage* self);
static void budgie_raven_widgets_page_move_widget_by_offset (BudgieRavenWidgetsPage* self,
                                                      gint offset);
static void ___lambda19__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda20_ (BudgieRavenWidgetsPage* self);
static void ___lambda20__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void budgie_raven_widgets_page_remove_widget (BudgieRavenWidgetsPage* self);
static void _budgie_raven_widgets_page_remove_widget_gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void budgie_raven_widgets_page_row_selected (BudgieRavenWidgetsPage* self,
                                             GtkListBoxRow* row);
static void _budgie_raven_widgets_page_row_selected_gtk_list_box_row_selected (GtkListBox* _sender,
                                                                        GtkListBoxRow* row,
                                                                        gpointer self);
static void budgie_raven_widgets_page_configure_actions (BudgieRavenWidgetsPage* self);
static void budgie_raven_widgets_page_add_widget_item (BudgieRavenWidgetsPage* self,
                                                BudgieRavenWidgetData* widget_data);
static void _budgie_raven_widgets_page_add_widget_item_budgie_raven_on_widget_added (BudgieRaven* _sender,
                                                                              BudgieRavenWidgetData* widget_data,
                                                                              gpointer self);
static void _budgie_raven_widgets_page_add_widget_item_gfunc (gconstpointer data,
                                                       gpointer self);
VALA_EXTERN BudgieRavenWidgetItem* budgie_raven_widget_item_new (BudgieRavenWidgetData* widget_data);
VALA_EXTERN BudgieRavenWidgetItem* budgie_raven_widget_item_construct (GType object_type,
                                                           BudgieRavenWidgetData* widget_data);
VALA_EXTERN GType budgie_settings_grid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieSettingsGrid, g_object_unref)
VALA_EXTERN BudgieSettingsGrid* budgie_settings_grid_new (void);
VALA_EXTERN BudgieSettingsGrid* budgie_settings_grid_construct (GType object_type);
static void budgie_raven_widgets_page_add_widget (BudgieRavenWidgetsPage* self);
static void _budgie_raven_widgets_page_add_widget_gtk_button_clicked (GtkButton* _sender,
                                                               gpointer self);
VALA_EXTERN GType budgie_settings_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieSettingsRow, g_object_unref)
VALA_EXTERN void budgie_settings_grid_add_row (BudgieSettingsGrid* self,
                                   BudgieSettingsRow* row);
VALA_EXTERN BudgieSettingsRow* budgie_settings_row_new (GtkWidget* widget,
                                            const gchar* label,
                                            const gchar* description);
VALA_EXTERN BudgieSettingsRow* budgie_settings_row_construct (GType object_type,
                                                  GtkWidget* widget,
                                                  const gchar* label,
                                                  const gchar* description);
static gboolean __lambda21_ (BudgieRavenWidgetsPage* self);
static gboolean ___lambda21__gsource_func (gpointer self);
static void budgie_raven_widgets_page_update_action_buttons (BudgieRavenWidgetsPage* self);
VALA_EXTERN GType budgie_settings_plugin_chooser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieSettingsPluginChooser, g_object_unref)
VALA_EXTERN BudgieSettingsPluginChooser* budgie_settings_plugin_chooser_new (GtkWindow* parent,
                                                                 gboolean use_applet_name);
VALA_EXTERN BudgieSettingsPluginChooser* budgie_settings_plugin_chooser_construct (GType object_type,
                                                                       GtkWindow* parent,
                                                                       gboolean use_applet_name);
VALA_EXTERN void budgie_settings_plugin_chooser_set_plugin_list (BudgieSettingsPluginChooser* self,
                                                     GList* plugins);
static void _vala_PeasPluginInfo_free (PeasPluginInfo* self);
static void __vala_PeasPluginInfo_free0_ (gpointer var);
static inline void _g_list_free___vala_PeasPluginInfo_free0_ (GList* self);
VALA_EXTERN gchar* budgie_settings_plugin_chooser_run (BudgieSettingsPluginChooser* self);
VALA_EXTERN GType budgie_remove_raven_widget_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieRemoveRavenWidgetDialog, g_object_unref)
VALA_EXTERN BudgieRemoveRavenWidgetDialog* budgie_remove_raven_widget_dialog_new (GtkWindow* parent);
VALA_EXTERN BudgieRemoveRavenWidgetDialog* budgie_remove_raven_widget_dialog_construct (GType object_type,
                                                                            GtkWindow* parent);
VALA_EXTERN gboolean budgie_remove_raven_widget_dialog_run (BudgieRemoveRavenWidgetDialog* self);
static BudgieRavenWidgetData* budgie_raven_widgets_page_get_current_data (BudgieRavenWidgetsPage* self);
static void budgie_raven_widgets_page_finalize (GObject * obj);
static GType budgie_raven_widgets_page_get_type_once (void);
static void budgie_raven_widget_item_finalize (GObject * obj);
static GType budgie_raven_widget_item_get_type_once (void);

BudgieRavenWidgetSettingsFrame*
budgie_raven_widget_settings_frame_construct (GType object_type)
{
	BudgieRavenWidgetSettingsFrame * self = NULL;
	GtkLabel* lab = NULL;
	GtkLabel* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkSeparator* sep = NULL;
	GtkSeparator* _tmp5_;
	self = (BudgieRavenWidgetSettingsFrame*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, "spacing", 0, NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp0_);
	lab = _tmp0_;
	_tmp1_ = g_strdup_printf ("<big>%s</big>", _ ("Widget Settings"));
	_tmp2_ = _tmp1_;
	gtk_label_set_markup (lab, _tmp2_);
	_g_free0 (_tmp2_);
	gtk_widget_set_halign ((GtkWidget*) lab, GTK_ALIGN_START);
	gtk_widget_set_margin_bottom ((GtkWidget*) lab, 6);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_START);
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp3_, "settings-frame");
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) lab);
	gtk_style_context_add_class (_tmp4_, "settings-title");
	_tmp5_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp5_);
	sep = _tmp5_;
	gtk_widget_set_margin_bottom ((GtkWidget*) sep, 6);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) lab, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) sep, FALSE, FALSE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (sep);
	_g_object_unref0 (lab);
	return self;
}

BudgieRavenWidgetSettingsFrame*
budgie_raven_widget_settings_frame_new (void)
{
	return budgie_raven_widget_settings_frame_construct (BUDGIE_TYPE_RAVEN_WIDGET_SETTINGS_FRAME);
}

static void
budgie_raven_widget_settings_frame_real_add (GtkContainer* base,
                                             GtkWidget* widget)
{
	BudgieRavenWidgetSettingsFrame * self;
	self = (BudgieRavenWidgetSettingsFrame*) base;
	g_return_if_fail (widget != NULL);
	gtk_box_pack_start ((GtkBox*) self, widget, FALSE, FALSE, (guint) 0);
}

static void
budgie_raven_widget_settings_frame_class_init (BudgieRavenWidgetSettingsFrameClass * klass,
                                               gpointer klass_data)
{
	budgie_raven_widget_settings_frame_parent_class = g_type_class_peek_parent (klass);
	((GtkContainerClass *) klass)->add = (void (*) (GtkContainer*, GtkWidget*)) budgie_raven_widget_settings_frame_real_add;
}

static void
budgie_raven_widget_settings_frame_instance_init (BudgieRavenWidgetSettingsFrame * self,
                                                  gpointer klass)
{
}

/**
* RavenWidgetSettingsFrame provides a UI wrapper for widget instance settings
*/
static GType
budgie_raven_widget_settings_frame_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieRavenWidgetSettingsFrameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_raven_widget_settings_frame_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieRavenWidgetSettingsFrame), 0, (GInstanceInitFunc) budgie_raven_widget_settings_frame_instance_init, NULL };
	GType budgie_raven_widget_settings_frame_type_id;
	budgie_raven_widget_settings_frame_type_id = g_type_register_static (gtk_box_get_type (), "BudgieRavenWidgetSettingsFrame", &g_define_type_info, 0);
	return budgie_raven_widget_settings_frame_type_id;
}

GType
budgie_raven_widget_settings_frame_get_type (void)
{
	static volatile gsize budgie_raven_widget_settings_frame_type_id__once = 0;
	if (g_once_init_enter (&budgie_raven_widget_settings_frame_type_id__once)) {
		GType budgie_raven_widget_settings_frame_type_id;
		budgie_raven_widget_settings_frame_type_id = budgie_raven_widget_settings_frame_get_type_once ();
		g_once_init_leave (&budgie_raven_widget_settings_frame_type_id__once, budgie_raven_widget_settings_frame_type_id);
	}
	return budgie_raven_widget_settings_frame_type_id__once;
}

static inline gpointer
budgie_raven_widgets_page_get_instance_private (BudgieRavenWidgetsPage* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieRavenWidgetsPage_private_offset);
}

static void
__lambda19_ (BudgieRavenWidgetsPage* self)
{
	budgie_raven_widgets_page_move_widget_by_offset (self, -1);
}

static void
___lambda19__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda19_ ((BudgieRavenWidgetsPage*) self);
}

static void
__lambda20_ (BudgieRavenWidgetsPage* self)
{
	budgie_raven_widgets_page_move_widget_by_offset (self, 1);
}

static void
___lambda20__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda20_ ((BudgieRavenWidgetsPage*) self);
}

static void
_budgie_raven_widgets_page_remove_widget_gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self)
{
	budgie_raven_widgets_page_remove_widget ((BudgieRavenWidgetsPage*) self);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_budgie_raven_widgets_page_row_selected_gtk_list_box_row_selected (GtkListBox* _sender,
                                                                   GtkListBoxRow* row,
                                                                   gpointer self)
{
	budgie_raven_widgets_page_row_selected ((BudgieRavenWidgetsPage*) self, row);
}

static void
_budgie_raven_widgets_page_add_widget_item_budgie_raven_on_widget_added (BudgieRaven* _sender,
                                                                         BudgieRavenWidgetData* widget_data,
                                                                         gpointer self)
{
	budgie_raven_widgets_page_add_widget_item ((BudgieRavenWidgetsPage*) self, widget_data);
}

static void
_budgie_raven_widgets_page_add_widget_item_gfunc (gconstpointer data,
                                                  gpointer self)
{
	budgie_raven_widgets_page_add_widget_item ((BudgieRavenWidgetsPage*) self, (BudgieRavenWidgetData*) data);
}

BudgieRavenWidgetsPage*
budgie_raven_widgets_page_construct (GType object_type,
                                     BudgieDesktopManager* manager)
{
	BudgieRavenWidgetsPage * self = NULL;
	BudgieRaven* _tmp0_;
	GtkBox* frame_box = NULL;
	GtkBox* _tmp1_;
	GtkButtonBox* move_box = NULL;
	GtkButtonBox* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	GtkButton* _tmp6_;
	GtkButton* _tmp7_;
	GtkButton* _tmp8_;
	GtkButton* _tmp9_;
	GtkButton* _tmp10_;
	GtkButton* _tmp11_;
	GtkButton* _tmp12_;
	GtkFrame* frame = NULL;
	GtkFrame* _tmp13_;
	GHashFunc _tmp14_;
	GEqualFunc _tmp15_;
	GHashTable* _tmp16_;
	GtkListBox* _tmp17_;
	GtkListBox* _tmp18_;
	GtkListBox* _tmp19_;
	GtkScrolledWindow* scroll = NULL;
	GtkScrolledWindow* _tmp20_;
	GtkListBox* _tmp21_;
	GtkStyleContext* _tmp22_;
	GtkListBox* _tmp23_;
	GtkStyleContext* _tmp24_;
	BudgieRaven* _tmp25_;
	BudgieRaven* _tmp26_;
	GList* _tmp27_;
	GList* _tmp28_;
	g_return_val_if_fail (manager != NULL, NULL);
	self = (BudgieRavenWidgetsPage*) g_object_new (object_type, "orientation", GTK_ORIENTATION_HORIZONTAL, "spacing", 0, NULL);
	self->priv->manager = manager;
	_tmp0_ = budgie_raven_get_instance ();
	self->priv->raven = _tmp0_;
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_FILL);
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp1_);
	frame_box = _tmp1_;
	_tmp2_ = (GtkButtonBox*) gtk_button_box_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp2_);
	move_box = _tmp2_;
	gtk_button_box_set_layout (move_box, GTK_BUTTONBOX_START);
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) move_box);
	gtk_style_context_add_class (_tmp3_, GTK_STYLE_CLASS_INLINE_TOOLBAR);
	_tmp4_ = (GtkButton*) gtk_button_new_from_icon_name ("go-up-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->button_move_widget_up);
	self->priv->button_move_widget_up = _tmp4_;
	_tmp5_ = self->priv->button_move_widget_up;
	g_signal_connect_object (_tmp5_, "clicked", (GCallback) ___lambda19__gtk_button_clicked, self, 0);
	_tmp6_ = self->priv->button_move_widget_up;
	gtk_container_add ((GtkContainer*) move_box, (GtkWidget*) _tmp6_);
	_tmp7_ = (GtkButton*) gtk_button_new_from_icon_name ("go-down-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->button_move_widget_down);
	self->priv->button_move_widget_down = _tmp7_;
	_tmp8_ = self->priv->button_move_widget_down;
	g_signal_connect_object (_tmp8_, "clicked", (GCallback) ___lambda20__gtk_button_clicked, self, 0);
	_tmp9_ = self->priv->button_move_widget_down;
	gtk_container_add ((GtkContainer*) move_box, (GtkWidget*) _tmp9_);
	_tmp10_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-delete-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->button_remove_widget);
	self->priv->button_remove_widget = _tmp10_;
	_tmp11_ = self->priv->button_remove_widget;
	g_signal_connect_object (_tmp11_, "clicked", (GCallback) _budgie_raven_widgets_page_remove_widget_gtk_button_clicked, self, 0);
	_tmp12_ = self->priv->button_remove_widget;
	gtk_container_add ((GtkContainer*) move_box, (GtkWidget*) _tmp12_);
	gtk_box_pack_start (frame_box, (GtkWidget*) move_box, FALSE, FALSE, (guint) 0);
	_tmp13_ = (GtkFrame*) gtk_frame_new (NULL);
	g_object_ref_sink (_tmp13_);
	frame = _tmp13_;
	gtk_widget_set_vexpand ((GtkWidget*) frame, FALSE);
	gtk_widget_set_margin_end ((GtkWidget*) frame, 20);
	gtk_widget_set_margin_top ((GtkWidget*) frame, 6);
	gtk_container_add ((GtkContainer*) frame, (GtkWidget*) frame_box);
	_tmp14_ = g_str_hash;
	_tmp15_ = g_str_equal;
	_tmp16_ = g_hash_table_new_full (_tmp14_, _tmp15_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->items);
	self->priv->items = _tmp16_;
	_tmp17_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->listbox_widgets);
	self->priv->listbox_widgets = _tmp17_;
	_tmp18_ = self->priv->listbox_widgets;
	gtk_list_box_set_activate_on_single_click (_tmp18_, TRUE);
	_tmp19_ = self->priv->listbox_widgets;
	g_signal_connect_object (_tmp19_, "row-selected", (GCallback) _budgie_raven_widgets_page_row_selected_gtk_list_box_row_selected, self, 0);
	_tmp20_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp20_);
	scroll = _tmp20_;
	_tmp21_ = self->priv->listbox_widgets;
	gtk_container_add ((GtkContainer*) scroll, (GtkWidget*) _tmp21_);
	gtk_scrolled_window_set_policy (scroll, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start (frame_box, (GtkWidget*) scroll, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) frame, FALSE, FALSE, (guint) 0);
	_tmp22_ = gtk_widget_get_style_context ((GtkWidget*) move_box);
	gtk_style_context_set_junction_sides (_tmp22_, GTK_JUNCTION_BOTTOM);
	_tmp23_ = self->priv->listbox_widgets;
	_tmp24_ = gtk_widget_get_style_context ((GtkWidget*) _tmp23_);
	gtk_style_context_set_junction_sides (_tmp24_, GTK_JUNCTION_TOP);
	budgie_raven_widgets_page_configure_actions (self);
	_tmp25_ = self->priv->raven;
	g_signal_connect_object (_tmp25_, "on-widget-added", (GCallback) _budgie_raven_widgets_page_add_widget_item_budgie_raven_on_widget_added, self, 0);
	_tmp26_ = self->priv->raven;
	_tmp27_ = budgie_raven_get_existing_widgets (_tmp26_);
	_tmp28_ = _tmp27_;
	g_list_foreach (_tmp28_, _budgie_raven_widgets_page_add_widget_item_gfunc, self);
	(_tmp28_ == NULL) ? NULL : (_tmp28_ = (g_list_free (_tmp28_), NULL));
	_g_object_unref0 (scroll);
	_g_object_unref0 (frame);
	_g_object_unref0 (move_box);
	_g_object_unref0 (frame_box);
	return self;
}

BudgieRavenWidgetsPage*
budgie_raven_widgets_page_new (BudgieDesktopManager* manager)
{
	return budgie_raven_widgets_page_construct (BUDGIE_TYPE_RAVEN_WIDGETS_PAGE, manager);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
budgie_raven_widgets_page_add_widget_item (BudgieRavenWidgetsPage* self,
                                           BudgieRavenWidgetData* widget_data)
{
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	BudgieRavenWidgetItem* item = NULL;
	BudgieRavenWidgetItem* _tmp17_;
	BudgieRavenWidgetItem* _tmp18_;
	GtkListBox* _tmp19_;
	BudgieRavenWidgetItem* _tmp20_;
	GHashTable* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	BudgieRavenWidgetItem* _tmp25_;
	BudgieRavenWidgetItem* _tmp26_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget_data != NULL);
	_tmp0_ = self->priv->items;
	_tmp1_ = budgie_raven_widget_data_get_uuid (widget_data);
	_tmp2_ = _tmp1_;
	if (g_hash_table_contains (_tmp0_, _tmp2_)) {
		return;
	}
	_tmp3_ = budgie_raven_widget_data_get_supports_settings (widget_data);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		BudgieRavenWidgetSettingsFrame* frame = NULL;
		BudgieRavenWidgetSettingsFrame* _tmp5_;
		GtkWidget* ui = NULL;
		GtkBin* _tmp6_;
		GtkBin* _tmp7_;
		GtkWidget* _tmp8_;
		BudgieRavenWidgetSettingsFrame* _tmp9_;
		GtkWidget* _tmp10_;
		GtkWidget* _tmp11_;
		BudgieRavenWidgetSettingsFrame* _tmp12_;
		GtkStack* _tmp13_;
		BudgieRavenWidgetSettingsFrame* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp5_ = budgie_raven_widget_settings_frame_new ();
		g_object_ref_sink (_tmp5_);
		frame = _tmp5_;
		_tmp6_ = budgie_raven_widget_data_get_widget_instance (widget_data);
		_tmp7_ = _tmp6_;
		_tmp8_ = budgie_raven_widget_build_settings_ui (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, budgie_raven_widget_get_type (), BudgieRavenWidget));
		ui = _tmp8_;
		_tmp9_ = frame;
		_tmp10_ = ui;
		gtk_container_add ((GtkContainer*) _tmp9_, _tmp10_);
		_tmp11_ = ui;
		gtk_widget_show (_tmp11_);
		_tmp12_ = frame;
		gtk_widget_show ((GtkWidget*) _tmp12_);
		_tmp13_ = self->priv->settings_stack;
		_tmp14_ = frame;
		_tmp15_ = budgie_raven_widget_data_get_uuid (widget_data);
		_tmp16_ = _tmp15_;
		gtk_stack_add_named (_tmp13_, (GtkWidget*) _tmp14_, _tmp16_);
		_g_object_unref0 (ui);
		_g_object_unref0 (frame);
	}
	_tmp17_ = budgie_raven_widget_item_new (widget_data);
	g_object_ref_sink (_tmp17_);
	item = _tmp17_;
	_tmp18_ = item;
	gtk_widget_show_all ((GtkWidget*) _tmp18_);
	_tmp19_ = self->priv->listbox_widgets;
	_tmp20_ = item;
	gtk_container_add ((GtkContainer*) _tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = self->priv->items;
	_tmp22_ = budgie_raven_widget_data_get_uuid (widget_data);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strdup (_tmp23_);
	_tmp25_ = item;
	_tmp26_ = _g_object_ref0 (_tmp25_);
	g_hash_table_insert (_tmp21_, _tmp24_, _tmp26_);
	_g_object_unref0 (item);
}

/**
* Configure the action grid to manipulation the widgets
*/
static void
_budgie_raven_widgets_page_add_widget_gtk_button_clicked (GtkButton* _sender,
                                                          gpointer self)
{
	budgie_raven_widgets_page_add_widget ((BudgieRavenWidgetsPage*) self);
}

static gboolean
__lambda21_ (BudgieRavenWidgetsPage* self)
{
	GtkStack* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->settings_stack;
	gtk_stack_set_visible_child_name (_tmp0_, "main");
	result = FALSE;
	return result;
}

static gboolean
___lambda21__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda21_ ((BudgieRavenWidgetsPage*) self);
	return result;
}

static void
budgie_raven_widgets_page_configure_actions (BudgieRavenWidgetsPage* self)
{
	BudgieSettingsGrid* grid = NULL;
	BudgieSettingsGrid* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
	GtkStyleContext* _tmp5_;
	GtkButton* _tmp6_;
	GtkStyleContext* _tmp7_;
	GtkButton* _tmp8_;
	GtkButton* _tmp9_;
	BudgieSettingsRow* _tmp10_;
	BudgieSettingsRow* _tmp11_;
	GtkStack* _tmp12_;
	GtkStack* _tmp13_;
	GtkStack* _tmp14_;
	GtkStack* _tmp15_;
	GtkStack* _tmp16_;
	GtkStack* _tmp17_;
	gint _tmp18_;
	GtkBox* placeholder = NULL;
	GtkBox* _tmp19_;
	GtkImage* placeholder_img = NULL;
	GtkImage* _tmp20_;
	GtkLabel* placeholder_text = NULL;
	GtkLabel* _tmp21_;
	GtkStack* _tmp22_;
	GtkEventBox* empty = NULL;
	GtkEventBox* _tmp23_;
	GtkStack* _tmp24_;
	g_return_if_fail (self != NULL);
	_tmp0_ = budgie_settings_grid_new ();
	g_object_ref_sink (_tmp0_);
	grid = _tmp0_;
	grid->small_mode = TRUE;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) grid, FALSE, FALSE, (guint) 0);
	_tmp1_ = (GtkButton*) gtk_button_new_from_icon_name ("list-add-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->button_add);
	self->priv->button_add = _tmp1_;
	_tmp2_ = self->priv->button_add;
	gtk_widget_set_valign ((GtkWidget*) _tmp2_, GTK_ALIGN_CENTER);
	_tmp3_ = self->priv->button_add;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp3_, FALSE);
	_tmp4_ = self->priv->button_add;
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _tmp4_);
	gtk_style_context_add_class (_tmp5_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp6_ = self->priv->button_add;
	_tmp7_ = gtk_widget_get_style_context ((GtkWidget*) _tmp6_);
	gtk_style_context_add_class (_tmp7_, "round-button");
	_tmp8_ = self->priv->button_add;
	g_signal_connect_object (_tmp8_, "clicked", (GCallback) _budgie_raven_widgets_page_add_widget_gtk_button_clicked, self, 0);
	_tmp9_ = self->priv->button_add;
	_tmp10_ = budgie_settings_row_new ((GtkWidget*) _tmp9_, _ ("Add widget"), _ ("Choose a new widget to add to the Widgets view"));
	_tmp11_ = _tmp10_;
	budgie_settings_grid_add_row (grid, _tmp11_);
	_g_object_unref0 (_tmp11_);
	_tmp12_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->settings_stack);
	self->priv->settings_stack = _tmp12_;
	_tmp13_ = self->priv->settings_stack;
	gtk_stack_set_homogeneous (_tmp13_, FALSE);
	_tmp14_ = self->priv->settings_stack;
	gtk_widget_set_halign ((GtkWidget*) _tmp14_, GTK_ALIGN_FILL);
	_tmp15_ = self->priv->settings_stack;
	gtk_widget_set_valign ((GtkWidget*) _tmp15_, GTK_ALIGN_START);
	_tmp16_ = self->priv->settings_stack;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp16_, 24);
	_tmp17_ = self->priv->settings_stack;
	grid->current_row = grid->current_row + 1;
	_tmp18_ = grid->current_row;
	gtk_grid_attach ((GtkGrid*) grid, (GtkWidget*) _tmp17_, 0, _tmp18_, 2, 1);
	_tmp19_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp19_);
	placeholder = _tmp19_;
	gtk_widget_set_valign ((GtkWidget*) placeholder, GTK_ALIGN_START);
	_tmp20_ = (GtkImage*) gtk_image_new_from_icon_name ("dialog-information-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp20_);
	placeholder_img = _tmp20_;
	_tmp21_ = (GtkLabel*) gtk_label_new (_ ("No settings available"));
	g_object_ref_sink (_tmp21_);
	placeholder_text = _tmp21_;
	gtk_widget_set_margin_start ((GtkWidget*) placeholder_text, 10);
	gtk_box_pack_start (placeholder, (GtkWidget*) placeholder_img, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start (placeholder, (GtkWidget*) placeholder_text, FALSE, FALSE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) placeholder);
	gtk_widget_set_valign ((GtkWidget*) placeholder_img, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) placeholder_text, GTK_ALIGN_CENTER);
	_tmp22_ = self->priv->settings_stack;
	gtk_stack_add_named (_tmp22_, (GtkWidget*) placeholder, "no-settings");
	_tmp23_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp23_);
	empty = _tmp23_;
	_tmp24_ = self->priv->settings_stack;
	gtk_stack_add_named (_tmp24_, (GtkWidget*) empty, "main");
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda21__gsource_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (empty);
	_g_object_unref0 (placeholder_text);
	_g_object_unref0 (placeholder_img);
	_g_object_unref0 (placeholder);
	_g_object_unref0 (grid);
}

/**
* Changed the row so update the UI
*/
static void
budgie_raven_widgets_page_row_selected (BudgieRavenWidgetsPage* self,
                                        GtkListBoxRow* row)
{
	BudgieRavenWidgetItem* item = NULL;
	GtkWidget* _tmp1_;
	BudgieRavenWidgetItem* _tmp2_;
	BudgieRavenWidgetData* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GtkWidget* lookup = NULL;
	GtkStack* _tmp7_;
	BudgieRavenWidgetItem* _tmp8_;
	BudgieRavenWidgetData* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	GtkWidget* _tmp12_;
	GtkStack* _tmp13_;
	GtkWidget* _tmp14_;
	g_return_if_fail (self != NULL);
	if (row == NULL) {
		GtkStack* _tmp0_;
		_tmp0_ = self->priv->settings_stack;
		gtk_stack_set_visible_child_name (_tmp0_, "main");
		return;
	}
	budgie_raven_widgets_page_update_action_buttons (self);
	_tmp1_ = gtk_bin_get_child ((GtkBin*) row);
	item = BUDGIE_IS_RAVEN_WIDGET_ITEM (_tmp1_) ? ((BudgieRavenWidgetItem*) _tmp1_) : NULL;
	_tmp2_ = item;
	_tmp3_ = _tmp2_->widget_data;
	_tmp4_ = budgie_raven_widget_data_get_supports_settings (_tmp3_);
	_tmp5_ = _tmp4_;
	if (!_tmp5_) {
		GtkStack* _tmp6_;
		_tmp6_ = self->priv->settings_stack;
		gtk_stack_set_visible_child_name (_tmp6_, "no-settings");
		return;
	}
	_tmp7_ = self->priv->settings_stack;
	_tmp8_ = item;
	_tmp9_ = _tmp8_->widget_data;
	_tmp10_ = budgie_raven_widget_data_get_uuid (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = gtk_stack_get_child_by_name (_tmp7_, _tmp11_);
	lookup = _tmp12_;
	_tmp13_ = self->priv->settings_stack;
	_tmp14_ = lookup;
	gtk_stack_set_visible_child (_tmp13_, _tmp14_);
}

/**
* Update the sensitivity of the action buttons based on the current
* selection.
*/
static void
budgie_raven_widgets_page_update_action_buttons (BudgieRavenWidgetsPage* self)
{
	GtkListBoxRow* selected_row = NULL;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	GtkButton* _tmp6_;
	GtkButton* _tmp7_;
	GtkListBoxRow* _tmp8_;
	GtkButton* _tmp9_;
	GtkListBoxRow* _tmp10_;
	GtkListBox* _tmp11_;
	GList* _tmp12_;
	GList* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->listbox_widgets;
	_tmp1_ = gtk_list_box_get_selected_row (_tmp0_);
	selected_row = _tmp1_;
	_tmp2_ = selected_row;
	if (_tmp2_ == NULL) {
		GtkButton* _tmp3_;
		GtkButton* _tmp4_;
		GtkButton* _tmp5_;
		_tmp3_ = self->priv->button_remove_widget;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, FALSE);
		_tmp4_ = self->priv->button_move_widget_up;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, FALSE);
		_tmp5_ = self->priv->button_move_widget_down;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, FALSE);
		return;
	}
	_tmp6_ = self->priv->button_remove_widget;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, TRUE);
	_tmp7_ = self->priv->button_move_widget_up;
	_tmp8_ = selected_row;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, gtk_list_box_row_get_index (_tmp8_) > 0);
	_tmp9_ = self->priv->button_move_widget_down;
	_tmp10_ = selected_row;
	_tmp11_ = self->priv->listbox_widgets;
	_tmp12_ = gtk_container_get_children ((GtkContainer*) _tmp11_);
	_tmp13_ = _tmp12_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, ((guint) gtk_list_box_row_get_index (_tmp10_)) < (g_list_length (_tmp13_) - 1));
	(_tmp13_ == NULL) ? NULL : (_tmp13_ = (g_list_free (_tmp13_), NULL));
}

static void
_vala_PeasPluginInfo_free (PeasPluginInfo* self)
{
	g_boxed_free (peas_plugin_info_get_type (), self);
}

static void
__vala_PeasPluginInfo_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_PeasPluginInfo_free (var), NULL));
}

static inline void
_g_list_free___vala_PeasPluginInfo_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) __vala_PeasPluginInfo_free0_);
}

static void
budgie_raven_widgets_page_add_widget (BudgieRavenWidgetsPage* self)
{
	BudgieDesktopManager* _tmp0_;
	BudgieSettingsPluginChooser* dlg = NULL;
	GtkWidget* _tmp1_;
	BudgieSettingsPluginChooser* _tmp2_;
	BudgieSettingsPluginChooser* _tmp3_;
	BudgieDesktopManager* _tmp4_;
	GList* _tmp5_;
	GList* _tmp6_;
	gchar* widget_id = NULL;
	BudgieSettingsPluginChooser* _tmp7_;
	gchar* _tmp8_;
	BudgieSettingsPluginChooser* _tmp9_;
	const gchar* _tmp10_;
	BudgieRavenWidgetCreationResult _result_ = 0;
	BudgieRaven* _tmp11_;
	const gchar* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->manager;
	budgie_desktop_manager_rescan_raven_plugins (_tmp0_);
	_tmp1_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp2_ = budgie_settings_plugin_chooser_new (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp1_) : NULL, FALSE);
	g_object_ref_sink (_tmp2_);
	dlg = _tmp2_;
	_tmp3_ = dlg;
	_tmp4_ = self->priv->manager;
	_tmp5_ = budgie_desktop_manager_get_raven_plugins (_tmp4_);
	_tmp6_ = _tmp5_;
	budgie_settings_plugin_chooser_set_plugin_list (_tmp3_, _tmp6_);
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (_g_list_free___vala_PeasPluginInfo_free0_ (_tmp6_), NULL));
	_tmp7_ = dlg;
	_tmp8_ = budgie_settings_plugin_chooser_run (_tmp7_);
	widget_id = _tmp8_;
	_tmp9_ = dlg;
	gtk_widget_destroy ((GtkWidget*) _tmp9_);
	_tmp10_ = widget_id;
	if (_tmp10_ == NULL) {
		_g_free0 (widget_id);
		_g_object_unref0 (dlg);
		return;
	}
	_tmp11_ = self->priv->raven;
	_tmp12_ = widget_id;
	_result_ = budgie_raven_create_widget_instance (_tmp11_, _tmp12_);
	if (_result_ != BUDGIE_RAVEN_WIDGET_CREATION_RESULT_SUCCESS) {
		gchar* markup = NULL;
		GtkMessageDialog* failure_dialog = NULL;
		GtkWidget* _tmp18_;
		const gchar* _tmp19_;
		GtkMessageDialog* _tmp20_;
		GtkMessageDialog* _tmp21_;
		GtkMessageDialog* _tmp22_;
		markup = NULL;
		switch (_result_) {
			case BUDGIE_RAVEN_WIDGET_CREATION_RESULT_PLUGIN_INFO_MISSING:
			{
				gchar* _tmp13_;
				_tmp13_ = g_strdup (_ ("Failed to create the widget instance. The plugin engine could not find" \
" info for this plugin."));
				_g_free0 (markup);
				markup = _tmp13_;
				break;
			}
			case BUDGIE_RAVEN_WIDGET_CREATION_RESULT_INVALID_MODULE_NAME:
			{
				gchar* _tmp14_;
				_tmp14_ = g_strdup (_ ("Failed to create the widget instance. The module name must be in rever" \
"se-DNS format, " "such as 'tld.domain.group.WidgetName.so' for C/Vala or 'tld_domain_gro" \
"up_WidgetName' for Python."));
				_g_free0 (markup);
				markup = _tmp14_;
				break;
			}
			case BUDGIE_RAVEN_WIDGET_CREATION_RESULT_PLUGIN_LOAD_FAILED:
			{
				gchar* _tmp15_;
				_tmp15_ = g_strdup (_ ("Failed to create the widget instance. The plugin engine failed to load" \
" the plugin from the disk."));
				_g_free0 (markup);
				markup = _tmp15_;
				break;
			}
			case BUDGIE_RAVEN_WIDGET_CREATION_RESULT_SCHEMA_LOAD_FAILED:
			{
				gchar* _tmp16_;
				_tmp16_ = g_strdup (_ ("Failed to create the widget instance. The plugin supports settings, bu" \
"t does not install a " "settings schema with the same name.\n" \
"\n" \
"The schema name should be identical to the module name, but " "with no extension and (in the case of Python) the underscores replaced" \
" with periods."));
				_g_free0 (markup);
				markup = _tmp16_;
				break;
			}
			case BUDGIE_RAVEN_WIDGET_CREATION_RESULT_INSTANCE_CREATION_FAILED:
			{
				gchar* _tmp17_;
				_tmp17_ = g_strdup (_ ("Failed to create the widget instance due to an unknown failure."));
				_g_free0 (markup);
				markup = _tmp17_;
				break;
			}
			default:
			{
				break;
			}
		}
		_tmp18_ = gtk_widget_get_toplevel ((GtkWidget*) self);
		_tmp19_ = markup;
		_tmp20_ = (GtkMessageDialog*) gtk_message_dialog_new_with_markup (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp18_) : NULL, GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", _tmp19_);
		g_object_ref_sink (_tmp20_);
		failure_dialog = _tmp20_;
		_tmp21_ = failure_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp21_);
		_tmp22_ = failure_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp22_);
		_g_object_unref0 (failure_dialog);
		_g_free0 (markup);
	}
	_g_free0 (widget_id);
	_g_object_unref0 (dlg);
}

/**
* User requested we delete this widget. Make sure they meant it!
*/
static void
budgie_raven_widgets_page_remove_widget (BudgieRavenWidgetsPage* self)
{
	GtkListBoxRow* row = NULL;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	GtkListBoxRow* _tmp3_;
	BudgieRemoveRavenWidgetDialog* dlg = NULL;
	GtkWidget* _tmp4_;
	BudgieRemoveRavenWidgetDialog* _tmp5_;
	gboolean del = FALSE;
	BudgieRemoveRavenWidgetDialog* _tmp6_;
	BudgieRemoveRavenWidgetDialog* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->listbox_widgets;
	_tmp1_ = gtk_list_box_get_selected_row (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	row = _tmp2_;
	_tmp3_ = row;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (row);
		return;
	}
	_tmp4_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp5_ = budgie_remove_raven_widget_dialog_new (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp4_) : NULL);
	g_object_ref_sink (_tmp5_);
	dlg = _tmp5_;
	_tmp6_ = dlg;
	del = budgie_remove_raven_widget_dialog_run (_tmp6_);
	_tmp7_ = dlg;
	gtk_widget_destroy ((GtkWidget*) _tmp7_);
	if (del) {
		BudgieRaven* _tmp8_;
		BudgieRavenWidgetData* _tmp9_;
		BudgieRavenWidgetData* _tmp10_;
		GtkListBox* _tmp11_;
		GtkListBoxRow* _tmp12_;
		_tmp8_ = self->priv->raven;
		_tmp9_ = budgie_raven_widgets_page_get_current_data (self);
		_tmp10_ = _tmp9_;
		budgie_raven_remove_widget (_tmp8_, _tmp10_);
		_budgie_raven_widget_data_unref0 (_tmp10_);
		_tmp11_ = self->priv->listbox_widgets;
		_tmp12_ = row;
		gtk_container_remove ((GtkContainer*) _tmp11_, (GtkWidget*) _tmp12_);
		budgie_raven_widgets_page_update_action_buttons (self);
	}
	_g_object_unref0 (dlg);
	_g_object_unref0 (row);
}

static void
budgie_raven_widgets_page_move_widget_by_offset (BudgieRavenWidgetsPage* self,
                                                 gint offset)
{
	GtkListBoxRow* row = NULL;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	GtkListBoxRow* _tmp3_;
	gint new_index = 0;
	GtkListBoxRow* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GtkListBox* _tmp6_;
	GList* _tmp7_;
	GList* _tmp8_;
	gboolean _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->listbox_widgets;
	_tmp1_ = gtk_list_box_get_selected_row (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	row = _tmp2_;
	_tmp3_ = row;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (row);
		return;
	}
	_tmp4_ = row;
	new_index = gtk_list_box_row_get_index (_tmp4_) + offset;
	_tmp6_ = self->priv->listbox_widgets;
	_tmp7_ = gtk_container_get_children ((GtkContainer*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = ((guint) new_index) < g_list_length (_tmp8_);
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (g_list_free (_tmp8_), NULL));
	if (_tmp9_) {
		_tmp5_ = new_index >= 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		GtkListBox* _tmp10_;
		GtkListBoxRow* _tmp11_;
		GtkListBox* _tmp12_;
		GtkListBoxRow* _tmp13_;
		GtkListBox* _tmp14_;
		GtkListBoxRow* _tmp15_;
		GtkListBox* _tmp16_;
		GtkListBoxRow* _tmp17_;
		BudgieRaven* _tmp18_;
		GtkListBoxRow* _tmp19_;
		GtkWidget* _tmp20_;
		BudgieRavenWidgetData* _tmp21_;
		_tmp10_ = self->priv->listbox_widgets;
		_tmp11_ = row;
		gtk_list_box_unselect_row (_tmp10_, _tmp11_);
		_tmp12_ = self->priv->listbox_widgets;
		_tmp13_ = row;
		gtk_container_remove ((GtkContainer*) _tmp12_, (GtkWidget*) _tmp13_);
		_tmp14_ = self->priv->listbox_widgets;
		_tmp15_ = row;
		gtk_list_box_insert (_tmp14_, (GtkWidget*) _tmp15_, new_index);
		_tmp16_ = self->priv->listbox_widgets;
		_tmp17_ = row;
		gtk_list_box_select_row (_tmp16_, _tmp17_);
		_tmp18_ = self->priv->raven;
		_tmp19_ = row;
		_tmp20_ = gtk_bin_get_child ((GtkBin*) _tmp19_);
		_tmp21_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, BUDGIE_TYPE_RAVEN_WIDGET_ITEM, BudgieRavenWidgetItem)->widget_data;
		budgie_raven_move_widget_by_offset (_tmp18_, _tmp21_, offset);
	}
	_g_object_unref0 (row);
}

static gpointer
_budgie_raven_widget_data_ref0 (gpointer self)
{
	return self ? budgie_raven_widget_data_ref (self) : NULL;
}

static BudgieRavenWidgetData*
budgie_raven_widgets_page_get_current_data (BudgieRavenWidgetsPage* self)
{
	GtkListBoxRow* row = NULL;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkWidget* _tmp2_;
	BudgieRavenWidgetData* _tmp3_;
	BudgieRavenWidgetData* _tmp4_;
	BudgieRavenWidgetData* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->listbox_widgets;
	_tmp1_ = gtk_list_box_get_selected_row (_tmp0_);
	row = _tmp1_;
	_tmp2_ = gtk_bin_get_child ((GtkBin*) row);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, BUDGIE_TYPE_RAVEN_WIDGET_ITEM, BudgieRavenWidgetItem)->widget_data;
	_tmp4_ = _budgie_raven_widget_data_ref0 (_tmp3_);
	result = _tmp4_;
	return result;
}

static void
budgie_raven_widgets_page_class_init (BudgieRavenWidgetsPageClass * klass,
                                      gpointer klass_data)
{
	budgie_raven_widgets_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieRavenWidgetsPage_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_raven_widgets_page_finalize;
}

static void
budgie_raven_widgets_page_instance_init (BudgieRavenWidgetsPage * self,
                                         gpointer klass)
{
	self->priv = budgie_raven_widgets_page_get_instance_private (self);
	self->priv->manager = NULL;
	self->priv->raven = NULL;
}

static void
budgie_raven_widgets_page_finalize (GObject * obj)
{
	BudgieRavenWidgetsPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_RAVEN_WIDGETS_PAGE, BudgieRavenWidgetsPage);
	_g_object_unref0 (self->priv->listbox_widgets);
	_g_hash_table_unref0 (self->priv->items);
	_g_object_unref0 (self->priv->button_add);
	_g_object_unref0 (self->priv->button_move_widget_up);
	_g_object_unref0 (self->priv->button_move_widget_down);
	_g_object_unref0 (self->priv->button_remove_widget);
	_g_object_unref0 (self->priv->settings_stack);
	G_OBJECT_CLASS (budgie_raven_widgets_page_parent_class)->finalize (obj);
}

static GType
budgie_raven_widgets_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieRavenWidgetsPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_raven_widgets_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieRavenWidgetsPage), 0, (GInstanceInitFunc) budgie_raven_widgets_page_instance_init, NULL };
	GType budgie_raven_widgets_page_type_id;
	budgie_raven_widgets_page_type_id = g_type_register_static (gtk_box_get_type (), "BudgieRavenWidgetsPage", &g_define_type_info, 0);
	BudgieRavenWidgetsPage_private_offset = g_type_add_instance_private (budgie_raven_widgets_page_type_id, sizeof (BudgieRavenWidgetsPagePrivate));
	return budgie_raven_widgets_page_type_id;
}

GType
budgie_raven_widgets_page_get_type (void)
{
	static volatile gsize budgie_raven_widgets_page_type_id__once = 0;
	if (g_once_init_enter (&budgie_raven_widgets_page_type_id__once)) {
		GType budgie_raven_widgets_page_type_id;
		budgie_raven_widgets_page_type_id = budgie_raven_widgets_page_get_type_once ();
		g_once_init_leave (&budgie_raven_widgets_page_type_id__once, budgie_raven_widgets_page_type_id);
	}
	return budgie_raven_widgets_page_type_id__once;
}

static inline gpointer
budgie_raven_widget_item_get_instance_private (BudgieRavenWidgetItem* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieRavenWidgetItem_private_offset);
}

/**
* Construct a new WidgetItem for the given widget
*/
BudgieRavenWidgetItem*
budgie_raven_widget_item_construct (GType object_type,
                                    BudgieRavenWidgetData* widget_data)
{
	BudgieRavenWidgetItem * self = NULL;
	BudgieRavenWidgetData* _tmp0_;
	GtkStyleContext* _tmp1_;
	PeasPluginInfo* _tmp2_;
	PeasPluginInfo* _tmp3_;
	const gchar* _tmp4_;
	GtkImage* _tmp5_;
	GtkImage* _tmp6_;
	GtkImage* _tmp7_;
	GtkImage* _tmp8_;
	PeasPluginInfo* _tmp9_;
	PeasPluginInfo* _tmp10_;
	const gchar* _tmp11_;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_;
	GtkLabel* _tmp15_;
	g_return_val_if_fail (widget_data != NULL, NULL);
	self = (BudgieRavenWidgetItem*) g_object_new (object_type, NULL);
	_tmp0_ = _budgie_raven_widget_data_ref0 (widget_data);
	_budgie_raven_widget_data_unref0 (self->widget_data);
	self->widget_data = _tmp0_;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp1_, "widget-item");
	gtk_widget_set_margin_top ((GtkWidget*) self, 4);
	gtk_widget_set_margin_bottom ((GtkWidget*) self, 4);
	_tmp2_ = budgie_raven_widget_data_get_plugin_info (widget_data);
	_tmp3_ = _tmp2_;
	_tmp4_ = peas_plugin_info_get_icon_name (_tmp3_);
	_tmp5_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp4_, (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->image);
	self->priv->image = _tmp5_;
	_tmp6_ = self->priv->image;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp6_, 12);
	_tmp7_ = self->priv->image;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp7_, 14);
	_tmp8_ = self->priv->image;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp8_, FALSE, FALSE, (guint) 0);
	_tmp9_ = budgie_raven_widget_data_get_plugin_info (widget_data);
	_tmp10_ = _tmp9_;
	_tmp11_ = peas_plugin_info_get_name (_tmp10_);
	_tmp12_ = (GtkLabel*) gtk_label_new (_tmp11_);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->label);
	self->priv->label = _tmp12_;
	_tmp13_ = self->priv->label;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp13_, 18);
	_tmp14_ = self->priv->label;
	gtk_widget_set_halign ((GtkWidget*) _tmp14_, GTK_ALIGN_START);
	_tmp15_ = self->priv->label;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp15_, FALSE, FALSE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) self);
	return self;
}

BudgieRavenWidgetItem*
budgie_raven_widget_item_new (BudgieRavenWidgetData* widget_data)
{
	return budgie_raven_widget_item_construct (BUDGIE_TYPE_RAVEN_WIDGET_ITEM, widget_data);
}

static void
budgie_raven_widget_item_class_init (BudgieRavenWidgetItemClass * klass,
                                     gpointer klass_data)
{
	budgie_raven_widget_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieRavenWidgetItem_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_raven_widget_item_finalize;
}

static void
budgie_raven_widget_item_instance_init (BudgieRavenWidgetItem * self,
                                        gpointer klass)
{
	self->priv = budgie_raven_widget_item_get_instance_private (self);
}

static void
budgie_raven_widget_item_finalize (GObject * obj)
{
	BudgieRavenWidgetItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_RAVEN_WIDGET_ITEM, BudgieRavenWidgetItem);
	_budgie_raven_widget_data_unref0 (self->widget_data);
	_g_object_unref0 (self->priv->image);
	_g_object_unref0 (self->priv->label);
	G_OBJECT_CLASS (budgie_raven_widget_item_parent_class)->finalize (obj);
}

/**
* WidgetItem is used to represent a Budgie Widget in the list
*/
static GType
budgie_raven_widget_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieRavenWidgetItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_raven_widget_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieRavenWidgetItem), 0, (GInstanceInitFunc) budgie_raven_widget_item_instance_init, NULL };
	GType budgie_raven_widget_item_type_id;
	budgie_raven_widget_item_type_id = g_type_register_static (gtk_box_get_type (), "BudgieRavenWidgetItem", &g_define_type_info, 0);
	BudgieRavenWidgetItem_private_offset = g_type_add_instance_private (budgie_raven_widget_item_type_id, sizeof (BudgieRavenWidgetItemPrivate));
	return budgie_raven_widget_item_type_id;
}

GType
budgie_raven_widget_item_get_type (void)
{
	static volatile gsize budgie_raven_widget_item_type_id__once = 0;
	if (g_once_init_enter (&budgie_raven_widget_item_type_id__once)) {
		GType budgie_raven_widget_item_type_id;
		budgie_raven_widget_item_type_id = budgie_raven_widget_item_get_type_once ();
		g_once_init_leave (&budgie_raven_widget_item_type_id__once, budgie_raven_widget_item_type_id);
	}
	return budgie_raven_widget_item_type_id__once;
}

