/* ListView.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ListView.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "budgiemenuapplet.h"
#include <glib.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "budgie-appindexer.h"
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>

#define APPLICATION_LIST_VIEW_HEIGHT 510
#define APPLICATION_LIST_VIEW_WIDTH 300
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	APPLICATION_LIST_VIEW_0_PROPERTY,
	APPLICATION_LIST_VIEW_SETTINGS_PROPERTY,
	APPLICATION_LIST_VIEW_NUM_PROPERTIES
};
static GParamSpec* application_list_view_properties[APPLICATION_LIST_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ApplicationListViewPrivate {
	gint SCALED_HEIGHT;
	gint SCALED_WIDTH;
	GtkBox* categories;
	GtkListBox* applications;
	GtkScrolledWindow* categories_scroll;
	GtkScrolledWindow* content_scroll;
	CategoryButton* all_categories;
	GSettings* _settings;
	BudgieCategory* current_category;
	gboolean compact_mode;
	gboolean headers_visible;
	gboolean show_control_center_panels;
	gboolean rollover_menus;
	gboolean reloading;
	GRecMutex __lock_reloading;
};

struct _Block1Data {
	int _ref_count_;
	ApplicationListView* self;
	BudgieAppIndex* app_tracker;
};

struct _Block2Data {
	int _ref_count_;
	ApplicationListView* self;
	CategoryButton* btn;
};

struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	BudgieApplication* app;
};

static gint ApplicationListView_private_offset;
static gpointer application_list_view_parent_class = NULL;
static GType application_list_view_type_id = 0;

static void application_list_view_set_scaled_sizing (ApplicationListView* self);
static void application_list_view_real_refresh (ApplicationView* base,
                                         BudgieAppIndex* app_tracker);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda7_ (ApplicationListView* self,
                 GtkWidget* child);
static void ___lambda7__gfunc (gconstpointer data,
                        gpointer self);
static gboolean __lambda8_ (Block1Data* _data1_);
static void application_list_view_load_menus (ApplicationListView* self,
                                       BudgieAppIndex* app_tracker);
static gboolean ___lambda8__gsource_func (gpointer self);
static gboolean application_list_view_on_mouse_enter (ApplicationListView* self,
                                               GtkWidget* source_widget,
                                               GdkEventCrossing* e);
static gboolean _application_list_view_on_mouse_enter_gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                                              GdkEventCrossing* event,
                                                                              gpointer self);
static void __lambda9_ (ApplicationListView* self);
static void application_list_view_update_category (ApplicationListView* self,
                                            CategoryButton* btn);
static void ___lambda9__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                            gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void ____lambda10_ (Block2Data* _data2_);
static void _____lambda10__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                               gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void ______lambda11_ (Block3Data* _data3_);
static void _______lambda11__gtk_button_clicked (GtkButton* _sender,
                                          gpointer self);
static void application_list_view_real_invalidate (ApplicationView* base);
static void application_list_view_real_on_search_entry_activated (ApplicationView* base);
static void application_list_view_on_settings_changed (ApplicationListView* self,
                                                const gchar* key);
static void application_list_view_do_list_header (ApplicationListView* self,
                                           GtkListBoxRow* before,
                                           GtkListBoxRow* after);
static void _application_list_view_do_list_header_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                            GtkListBoxRow* before,
                                                                            gpointer self);
static void application_list_view_on_row_activate (ApplicationListView* self,
                                            GtkListBoxRow* row);
static gboolean application_list_view_do_filter_list (ApplicationListView* self,
                                               GtkListBoxRow* row);
static gint application_list_view_do_sort_list (ApplicationListView* self,
                                         GtkListBoxRow* row1,
                                         GtkListBoxRow* row2);
static void application_list_view_real_on_show (ApplicationView* base);
static GObject * application_list_view_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void _application_list_view___lambda12_ (ApplicationListView* self);
static void __application_list_view___lambda12__g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self);
static void _application_list_view___lambda13_ (ApplicationListView* self);
static void __application_list_view___lambda13__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                    gpointer self);
static void _application_list_view_on_row_activate_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                        GtkListBoxRow* row,
                                                                        gpointer self);
static void _application_list_view_on_settings_changed_g_settings_changed (GSettings* _sender,
                                                                    const gchar* key,
                                                                    gpointer self);
static gboolean _application_list_view_do_filter_list_gtk_list_box_filter_func (GtkListBoxRow* row,
                                                                         gpointer self);
static gint _application_list_view_do_sort_list_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                 GtkListBoxRow* row2,
                                                                 gpointer self);
static void application_list_view_finalize (GObject * obj);
static void _vala_application_list_view_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_application_list_view_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static inline gpointer
application_list_view_get_instance_private (ApplicationListView* self)
{
	return G_STRUCT_MEMBER_P (self, ApplicationListView_private_offset);
}

ApplicationListView*
application_list_view_construct (GType object_type,
                                 GSettings* settings)
{
	ApplicationListView * self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (settings != NULL, NULL);
	self = (ApplicationListView*) g_object_new (object_type, "settings", settings, "orientation", GTK_ORIENTATION_HORIZONTAL, "spacing", 0, NULL);
	_tmp0_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
	_tmp1_ = _tmp0_;
	self->priv->SCALED_HEIGHT = APPLICATION_LIST_VIEW_HEIGHT / _tmp1_;
	_tmp2_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
	_tmp3_ = _tmp2_;
	self->priv->SCALED_WIDTH = APPLICATION_LIST_VIEW_WIDTH / _tmp3_;
	return self;
}

ApplicationListView*
application_list_view_new (GSettings* settings)
{
	return application_list_view_construct (TYPE_APPLICATION_LIST_VIEW, settings);
}

/**
* Sets various widgets to use sizing based on current scale and our default HEIGHT
*/
static void
application_list_view_set_scaled_sizing (ApplicationListView* self)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GtkScrolledWindow* _tmp4_;
	GtkScrolledWindow* _tmp5_;
	GtkListBox* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
	_tmp1_ = _tmp0_;
	self->priv->SCALED_HEIGHT = APPLICATION_LIST_VIEW_HEIGHT / _tmp1_;
	_tmp2_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
	_tmp3_ = _tmp2_;
	self->priv->SCALED_WIDTH = APPLICATION_LIST_VIEW_WIDTH / _tmp3_;
	gtk_widget_set_size_request ((GtkWidget*) self, self->priv->SCALED_WIDTH, self->priv->SCALED_HEIGHT);
	_tmp4_ = self->priv->categories_scroll;
	gtk_scrolled_window_set_min_content_height (_tmp4_, self->priv->SCALED_HEIGHT);
	_tmp5_ = self->priv->content_scroll;
	gtk_scrolled_window_set_min_content_height (_tmp5_, self->priv->SCALED_HEIGHT);
	_tmp6_ = self->priv->applications;
	g_object_set ((GtkWidget*) _tmp6_, "height-request", self->priv->SCALED_HEIGHT, NULL);
}

/**
 * Refreshes the category and application lists.
 */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ApplicationListView* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->app_tracker);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda7_ (ApplicationListView* self,
            GtkWidget* child)
{
	g_return_if_fail (child != NULL);
	gtk_widget_destroy (child);
}

static void
___lambda7__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda7_ ((ApplicationListView*) self, (GtkWidget*) data);
}

static gboolean
__lambda8_ (Block1Data* _data1_)
{
	ApplicationListView* self;
	gboolean result;
	self = _data1_->self;
	application_list_view_load_menus (self, _data1_->app_tracker);
	application_view_invalidate ((ApplicationView*) self);
	result = FALSE;
	return result;
}

static gboolean
___lambda8__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda8_ (self);
	return result;
}

static void
application_list_view_real_refresh (ApplicationView* base,
                                    BudgieAppIndex* app_tracker)
{
	ApplicationListView * self;
	Block1Data* _data1_;
	BudgieAppIndex* _tmp0_;
	GtkListBox* _tmp1_;
	GList* _tmp2_;
	GHashTable* _tmp4_;
	GHashTable* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	GtkBox* _tmp8_;
	GList* _tmp9_;
	GList* _tmp10_;
	GError* _inner_error0_ = NULL;
	self = (ApplicationListView*) base;
	g_return_if_fail (app_tracker != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (app_tracker);
	_g_object_unref0 (_data1_->app_tracker);
	_data1_->app_tracker = _tmp0_;
	{
		g_rec_mutex_lock (&self->priv->__lock_reloading);
		{
			if (self->priv->reloading) {
				{
					g_rec_mutex_unlock (&self->priv->__lock_reloading);
				}
				block1_data_unref (_data1_);
				_data1_ = NULL;
				return;
			}
			self->priv->reloading = TRUE;
		}
		__finally0:
		{
			g_rec_mutex_unlock (&self->priv->__lock_reloading);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp1_ = self->priv->applications;
	_tmp2_ = gtk_container_get_children ((GtkContainer*) _tmp1_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp2_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				GtkWidget* _tmp3_;
				_tmp3_ = child;
				gtk_widget_destroy (_tmp3_);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	_tmp4_ = application_view_get_application_buttons ((ApplicationView*) self);
	_tmp5_ = _tmp4_;
	g_hash_table_remove_all (_tmp5_);
	_tmp6_ = application_view_get_control_center_buttons ((ApplicationView*) self);
	_tmp7_ = _tmp6_;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp7_);
	_tmp8_ = self->priv->categories;
	_tmp9_ = gtk_container_get_children ((GtkContainer*) _tmp8_);
	_tmp10_ = _tmp9_;
	g_list_foreach (_tmp10_, ___lambda7__gfunc, self);
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (g_list_free (_tmp10_), NULL));
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda8__gsource_func, block1_data_ref (_data1_), block1_data_unref);
	{
		g_rec_mutex_lock (&self->priv->__lock_reloading);
		{
			self->priv->reloading = FALSE;
		}
		__finally1:
		{
			g_rec_mutex_unlock (&self->priv->__lock_reloading);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

/**
 * Build the category and application lists.
 */
static gboolean
_application_list_view_on_mouse_enter_gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                                     GdkEventCrossing* event,
                                                                     gpointer self)
{
	gboolean result;
	result = application_list_view_on_mouse_enter ((ApplicationListView*) self, _sender, event);
	return result;
}

static void
__lambda9_ (ApplicationListView* self)
{
	CategoryButton* _tmp0_;
	_tmp0_ = self->priv->all_categories;
	application_list_view_update_category (self, _tmp0_);
}

static void
___lambda9__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                       gpointer self)
{
	__lambda9_ ((ApplicationListView*) self);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		ApplicationListView* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->btn);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
____lambda10_ (Block2Data* _data2_)
{
	ApplicationListView* self;
	CategoryButton* _tmp0_;
	self = _data2_->self;
	_tmp0_ = _data2_->btn;
	application_list_view_update_category (self, _tmp0_);
}

static void
_____lambda10__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                          gpointer self)
{
	____lambda10_ (self);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		ApplicationListView* self;
		self = _data3_->_data2_->self;
		_g_object_unref0 (_data3_->app);
		block2_data_unref (_data3_->_data2_);
		_data3_->_data2_ = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}

static void
______lambda11_ (Block3Data* _data3_)
{
	Block2Data* _data2_;
	ApplicationListView* self;
	BudgieApplication* _tmp0_;
	_data2_ = _data3_->_data2_;
	self = _data2_->self;
	_tmp0_ = _data3_->app;
	budgie_application_launch (_tmp0_);
	g_signal_emit_by_name ((ApplicationView*) self, "app-launched");
}

static void
_______lambda11__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self)
{
	______lambda11_ (self);
}

static void
application_list_view_load_menus (ApplicationListView* self,
                                  BudgieAppIndex* app_tracker)
{
	CategoryButton* _tmp0_;
	CategoryButton* _tmp1_;
	CategoryButton* _tmp2_;
	CategoryButton* _tmp3_;
	GtkBox* _tmp4_;
	CategoryButton* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app_tracker != NULL);
	_tmp0_ = category_button_new (NULL);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->all_categories);
	self->priv->all_categories = _tmp0_;
	_tmp1_ = self->priv->all_categories;
	g_signal_connect_object ((GtkWidget*) _tmp1_, "enter-notify-event", (GCallback) _application_list_view_on_mouse_enter_gtk_widget_enter_notify_event, self, 0);
	_tmp2_ = self->priv->all_categories;
	g_signal_connect_object ((GtkToggleButton*) _tmp2_, "toggled", (GCallback) ___lambda9__gtk_toggle_button_toggled, self, 0);
	_tmp3_ = self->priv->all_categories;
	gtk_widget_show_all ((GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->categories;
	_tmp5_ = self->priv->all_categories;
	gtk_box_pack_start (_tmp4_, (GtkWidget*) _tmp5_, FALSE, TRUE, (guint) 0);
	{
		GeeArrayList* _category_list = NULL;
		GeeArrayList* _tmp6_;
		gint _category_size = 0;
		GeeArrayList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _category_index = 0;
		_tmp6_ = budgie_app_index_get_categories (app_tracker);
		_category_list = _tmp6_;
		_tmp7_ = _category_list;
		_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_category_size = _tmp9_;
		_category_index = -1;
		while (TRUE) {
			Block2Data* _data2_;
			gint _tmp10_;
			gint _tmp11_;
			BudgieCategory* category = NULL;
			GeeArrayList* _tmp12_;
			gpointer _tmp13_;
			BudgieCategory* _tmp14_;
			GeeArrayList* _tmp15_;
			GeeArrayList* _tmp16_;
			gboolean _tmp17_;
			gboolean _tmp18_;
			BudgieCategory* _tmp19_;
			CategoryButton* _tmp20_;
			CategoryButton* _tmp21_;
			CategoryButton* _tmp22_;
			CategoryButton* _tmp23_;
			CategoryButton* _tmp24_;
			CategoryButton* _tmp25_;
			GtkBox* _tmp26_;
			CategoryButton* _tmp27_;
			_data2_ = g_slice_new0 (Block2Data);
			_data2_->_ref_count_ = 1;
			_data2_->self = g_object_ref (self);
			_category_index = _category_index + 1;
			_tmp10_ = _category_index;
			_tmp11_ = _category_size;
			if (!(_tmp10_ < _tmp11_)) {
				block2_data_unref (_data2_);
				_data2_ = NULL;
				break;
			}
			_tmp12_ = _category_list;
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _category_index);
			category = (BudgieCategory*) _tmp13_;
			_tmp14_ = category;
			_tmp15_ = budgie_category_get_apps (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = gee_collection_get_is_empty ((GeeCollection*) _tmp16_);
			_tmp18_ = _tmp17_;
			if (_tmp18_) {
				_g_object_unref0 (category);
				block2_data_unref (_data2_);
				_data2_ = NULL;
				continue;
			}
			_tmp19_ = category;
			_tmp20_ = category_button_new (_tmp19_);
			g_object_ref_sink (_tmp20_);
			_data2_->btn = _tmp20_;
			_tmp21_ = _data2_->btn;
			_tmp22_ = self->priv->all_categories;
			gtk_radio_button_join_group ((GtkRadioButton*) _tmp21_, (GtkRadioButton*) _tmp22_);
			_tmp23_ = _data2_->btn;
			g_signal_connect_object ((GtkWidget*) _tmp23_, "enter-notify-event", (GCallback) _application_list_view_on_mouse_enter_gtk_widget_enter_notify_event, self, 0);
			_tmp24_ = _data2_->btn;
			g_signal_connect_data ((GtkToggleButton*) _tmp24_, "toggled", (GCallback) _____lambda10__gtk_toggle_button_toggled, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
			_tmp25_ = _data2_->btn;
			gtk_widget_show_all ((GtkWidget*) _tmp25_);
			_tmp26_ = self->priv->categories;
			_tmp27_ = _data2_->btn;
			gtk_box_pack_start (_tmp26_, (GtkWidget*) _tmp27_, FALSE, TRUE, (guint) 0);
			{
				GeeArrayList* _app_list = NULL;
				BudgieCategory* _tmp28_;
				GeeArrayList* _tmp29_;
				GeeArrayList* _tmp30_;
				gint _app_size = 0;
				GeeArrayList* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				gint _app_index = 0;
				_tmp28_ = category;
				_tmp29_ = budgie_category_get_apps (_tmp28_);
				_tmp30_ = _tmp29_;
				_app_list = _tmp30_;
				_tmp31_ = _app_list;
				_tmp32_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp31_);
				_tmp33_ = _tmp32_;
				_app_size = _tmp33_;
				_app_index = -1;
				while (TRUE) {
					Block3Data* _data3_;
					gint _tmp34_;
					gint _tmp35_;
					GeeArrayList* _tmp36_;
					gpointer _tmp37_;
					MenuButton* app_btn = NULL;
					BudgieApplication* _tmp38_;
					BudgieCategory* _tmp39_;
					gint _tmp40_;
					gint _tmp41_;
					MenuButton* _tmp42_;
					MenuButton* _tmp43_;
					GHashTable* _tmp44_;
					GHashTable* _tmp45_;
					BudgieApplication* _tmp46_;
					const gchar* _tmp47_;
					const gchar* _tmp48_;
					gchar* _tmp49_;
					MenuButton* _tmp50_;
					MenuButton* _tmp51_;
					MenuButton* _tmp52_;
					GtkListBox* _tmp53_;
					MenuButton* _tmp54_;
					MenuButton* _tmp55_;
					_data3_ = g_slice_new0 (Block3Data);
					_data3_->_ref_count_ = 1;
					_data3_->_data2_ = block2_data_ref (_data2_);
					_app_index = _app_index + 1;
					_tmp34_ = _app_index;
					_tmp35_ = _app_size;
					if (!(_tmp34_ < _tmp35_)) {
						block3_data_unref (_data3_);
						_data3_ = NULL;
						break;
					}
					_tmp36_ = _app_list;
					_tmp37_ = gee_abstract_list_get ((GeeAbstractList*) _tmp36_, _app_index);
					_data3_->app = (BudgieApplication*) _tmp37_;
					_tmp38_ = _data3_->app;
					_tmp39_ = category;
					_tmp40_ = application_view_get_icon_size ((ApplicationView*) self);
					_tmp41_ = _tmp40_;
					_tmp42_ = menu_button_new (_tmp38_, _tmp39_, _tmp41_);
					g_object_ref_sink (_tmp42_);
					app_btn = _tmp42_;
					_tmp43_ = app_btn;
					g_signal_connect_data ((GtkButton*) _tmp43_, "clicked", (GCallback) _______lambda11__gtk_button_clicked, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
					_tmp44_ = application_view_get_application_buttons ((ApplicationView*) self);
					_tmp45_ = _tmp44_;
					_tmp46_ = _data3_->app;
					_tmp47_ = budgie_application_get_desktop_id (_tmp46_);
					_tmp48_ = _tmp47_;
					_tmp49_ = g_strdup (_tmp48_);
					_tmp50_ = app_btn;
					_tmp51_ = _g_object_ref0 (_tmp50_);
					g_hash_table_insert (_tmp45_, _tmp49_, _tmp51_);
					_tmp52_ = app_btn;
					gtk_widget_show_all ((GtkWidget*) _tmp52_);
					_tmp53_ = self->priv->applications;
					_tmp54_ = app_btn;
					gtk_container_add ((GtkContainer*) _tmp53_, (GtkWidget*) _tmp54_);
					_tmp55_ = app_btn;
					if (menu_button_is_control_center_panel (_tmp55_)) {
						GeeArrayList* _tmp56_;
						GeeArrayList* _tmp57_;
						MenuButton* _tmp58_;
						_tmp56_ = application_view_get_control_center_buttons ((ApplicationView*) self);
						_tmp57_ = _tmp56_;
						_tmp58_ = app_btn;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp57_, _tmp58_);
					}
					_g_object_unref0 (app_btn);
					block3_data_unref (_data3_);
					_data3_ = NULL;
				}
			}
			_g_object_unref0 (category);
			block2_data_unref (_data2_);
			_data2_ = NULL;
		}
		_g_object_unref0 (_category_list);
	}
}

/**
 * Invalidate the application headers, filters, and sorting.
 */
static void
application_list_view_real_invalidate (ApplicationView* base)
{
	ApplicationListView * self;
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	GtkListBox* _tmp2_;
	self = (ApplicationListView*) base;
	_tmp0_ = self->priv->applications;
	gtk_list_box_invalidate_headers (_tmp0_);
	_tmp1_ = self->priv->applications;
	gtk_list_box_invalidate_filter (_tmp1_);
	_tmp2_ = self->priv->applications;
	gtk_list_box_invalidate_sort (_tmp2_);
}

/**
 * Launches the application selected by the current search result.
 */
static void
application_list_view_real_on_search_entry_activated (ApplicationView* base)
{
	ApplicationListView * self;
	GtkListBoxRow* selected = NULL;
	GList* rows = NULL;
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	GtkListBoxRow* _tmp13_;
	MenuButton* btn = NULL;
	GtkListBoxRow* _tmp14_;
	GtkWidget* _tmp15_;
	MenuButton* _tmp16_;
	MenuButton* _tmp17_;
	BudgieApplication* _tmp18_;
	BudgieApplication* _tmp19_;
	self = (ApplicationListView*) base;
	selected = NULL;
	_tmp0_ = self->priv->applications;
	_tmp1_ = gtk_list_box_get_selected_rows (_tmp0_);
	rows = _tmp1_;
	_tmp2_ = rows;
	if (_tmp2_ != NULL) {
		GList* _tmp3_;
		gconstpointer _tmp4_;
		GtkListBoxRow* _tmp5_;
		_tmp3_ = rows;
		_tmp4_ = _tmp3_->data;
		_tmp5_ = _g_object_ref0 ((GtkListBoxRow*) _tmp4_);
		_g_object_unref0 (selected);
		selected = _tmp5_;
	} else {
		GtkListBox* _tmp6_;
		GList* _tmp7_;
		_tmp6_ = self->priv->applications;
		_tmp7_ = gtk_container_get_children ((GtkContainer*) _tmp6_);
		{
			GList* child_collection = NULL;
			GList* child_it = NULL;
			child_collection = _tmp7_;
			for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
				GtkWidget* child = NULL;
				child = (GtkWidget*) child_it->data;
				{
					gboolean _tmp8_ = FALSE;
					GtkWidget* _tmp9_;
					_tmp9_ = child;
					if (gtk_widget_get_visible (_tmp9_)) {
						GtkWidget* _tmp10_;
						_tmp10_ = child;
						_tmp8_ = gtk_widget_get_child_visible (_tmp10_);
					} else {
						_tmp8_ = FALSE;
					}
					if (_tmp8_) {
						GtkWidget* _tmp11_;
						GtkListBoxRow* _tmp12_;
						_tmp11_ = child;
						_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, gtk_list_box_row_get_type ()) ? ((GtkListBoxRow*) _tmp11_) : NULL);
						_g_object_unref0 (selected);
						selected = _tmp12_;
						break;
					}
				}
			}
			(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
		}
	}
	_tmp13_ = selected;
	if (_tmp13_ == NULL) {
		(rows == NULL) ? NULL : (rows = (g_list_free (rows), NULL));
		_g_object_unref0 (selected);
		return;
	}
	_tmp14_ = selected;
	_tmp15_ = gtk_bin_get_child ((GtkBin*) _tmp14_);
	_tmp16_ = _g_object_ref0 (IS_MENU_BUTTON (_tmp15_) ? ((MenuButton*) _tmp15_) : NULL);
	btn = _tmp16_;
	_tmp17_ = btn;
	_tmp18_ = menu_button_get_app (_tmp17_);
	_tmp19_ = _tmp18_;
	budgie_application_launch (_tmp19_);
	g_signal_emit_by_name ((ApplicationView*) self, "app-launched");
	_g_object_unref0 (btn);
	(rows == NULL) ? NULL : (rows = (g_list_free (rows), NULL));
	_g_object_unref0 (selected);
}

/**
 * Permits "rolling" over categories.
 */
static gboolean
application_list_view_on_mouse_enter (ApplicationListView* self,
                                      GtkWidget* source_widget,
                                      GdkEventCrossing* e)
{
	GtkToggleButton* b = NULL;
	GtkToggleButton* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GtkToggleButton* _tmp2_;
	GtkToggleButton* _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source_widget != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	if (!self->priv->rollover_menus) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (source_widget, gtk_toggle_button_get_type ()) ? ((GtkToggleButton*) source_widget) : NULL);
	b = _tmp0_;
	_tmp2_ = b;
	if (!gtk_widget_get_sensitive ((GtkWidget*) _tmp2_)) {
		_tmp1_ = TRUE;
	} else {
		GtkToggleButton* _tmp3_;
		_tmp3_ = b;
		_tmp1_ = !gtk_widget_get_visible ((GtkWidget*) _tmp3_);
	}
	if (_tmp1_) {
		result = GDK_EVENT_PROPAGATE;
		_g_object_unref0 (b);
		return result;
	}
	_tmp4_ = b;
	gtk_toggle_button_set_active (_tmp4_, TRUE);
	result = GDK_EVENT_PROPAGATE;
	_g_object_unref0 (b);
	return result;
}

/**
 * Handles changes to our applet settings.
 */
static void
_application_list_view_do_list_header_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                       GtkListBoxRow* before,
                                                                       gpointer self)
{
	application_list_view_do_list_header ((ApplicationListView*) self, row, before);
}

static void
application_list_view_on_settings_changed (ApplicationListView* self,
                                           const gchar* key)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("menu-compact")))) {
		switch (0) {
			default:
			{
				gboolean vis = FALSE;
				GSettings* _tmp3_;
				GtkScrolledWindow* _tmp4_;
				GtkScrolledWindow* _tmp5_;
				_tmp3_ = self->priv->_settings;
				vis = g_settings_get_boolean (_tmp3_, key);
				_tmp4_ = self->priv->categories_scroll;
				gtk_widget_set_no_show_all ((GtkWidget*) _tmp4_, vis);
				_tmp5_ = self->priv->categories_scroll;
				gtk_widget_set_visible ((GtkWidget*) _tmp5_, vis);
				self->priv->compact_mode = vis;
				application_view_invalidate ((ApplicationView*) self);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("menu-headers")))) {
		switch (0) {
			default:
			{
				gboolean hed = FALSE;
				GSettings* _tmp6_;
				_tmp6_ = self->priv->_settings;
				hed = g_settings_get_boolean (_tmp6_, key);
				self->priv->headers_visible = hed;
				if (hed) {
					GtkListBox* _tmp7_;
					_tmp7_ = self->priv->applications;
					gtk_list_box_set_header_func (_tmp7_, _application_list_view_do_list_header_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
				} else {
					GtkListBox* _tmp8_;
					_tmp8_ = self->priv->applications;
					gtk_list_box_set_header_func (_tmp8_, NULL, NULL, NULL);
				}
				application_view_invalidate ((ApplicationView*) self);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("menu-categories-hover")))) {
		switch (0) {
			default:
			{
				GSettings* _tmp9_;
				_tmp9_ = self->priv->_settings;
				self->priv->rollover_menus = g_settings_get_boolean (_tmp9_, key);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("menu-show-control-center-items")))) {
		switch (0) {
			default:
			{
				GSettings* _tmp10_;
				_tmp10_ = self->priv->_settings;
				self->priv->show_control_center_panels = g_settings_get_boolean (_tmp10_, key);
				application_view_invalidate ((ApplicationView*) self);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
}

/**
 * Launches the application in the given row.
 */
static void
application_list_view_on_row_activate (ApplicationListView* self,
                                       GtkListBoxRow* row)
{
	MenuButton* btn = NULL;
	GtkWidget* _tmp0_;
	MenuButton* _tmp1_;
	MenuButton* _tmp2_;
	BudgieApplication* _tmp3_;
	BudgieApplication* _tmp4_;
	g_return_if_fail (self != NULL);
	if (row == NULL) {
		return;
	}
	_tmp0_ = gtk_bin_get_child ((GtkBin*) row);
	_tmp1_ = _g_object_ref0 (IS_MENU_BUTTON (_tmp0_) ? ((MenuButton*) _tmp0_) : NULL);
	btn = _tmp1_;
	_tmp2_ = btn;
	_tmp3_ = menu_button_get_app (_tmp2_);
	_tmp4_ = _tmp3_;
	budgie_application_launch (_tmp4_);
	g_signal_emit_by_name ((ApplicationView*) self, "app-launched");
	_g_object_unref0 (btn);
}

/**
 * Provide category headers in the "All" category
 */
static void
application_list_view_do_list_header (ApplicationListView* self,
                                      GtkListBoxRow* before,
                                      GtkListBoxRow* after)
{
	MenuButton* child = NULL;
	gchar* prev = NULL;
	gchar* next = NULL;
	BudgieCategory* _tmp0_;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	g_return_if_fail (self != NULL);
	child = NULL;
	prev = NULL;
	next = NULL;
	_tmp0_ = self->priv->current_category;
	if (_tmp0_ != NULL) {
		if (before != NULL) {
			gtk_list_box_row_set_header (before, NULL);
		}
		if (after != NULL) {
			gtk_list_box_row_set_header (after, NULL);
		}
		_g_free0 (next);
		_g_free0 (prev);
		_g_object_unref0 (child);
		return;
	}
	if (before != NULL) {
		GtkWidget* _tmp1_;
		MenuButton* _tmp2_;
		MenuButton* _tmp3_;
		BudgieCategory* _tmp4_;
		BudgieCategory* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp1_ = gtk_bin_get_child ((GtkBin*) before);
		_tmp2_ = _g_object_ref0 (IS_MENU_BUTTON (_tmp1_) ? ((MenuButton*) _tmp1_) : NULL);
		_g_object_unref0 (child);
		child = _tmp2_;
		_tmp3_ = child;
		_tmp4_ = menu_button_get_category (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = budgie_category_get_name (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (prev);
		prev = _tmp8_;
	}
	if (after != NULL) {
		GtkWidget* _tmp9_;
		MenuButton* _tmp10_;
		MenuButton* _tmp11_;
		BudgieCategory* _tmp12_;
		BudgieCategory* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp9_ = gtk_bin_get_child ((GtkBin*) after);
		_tmp10_ = _g_object_ref0 (IS_MENU_BUTTON (_tmp9_) ? ((MenuButton*) _tmp9_) : NULL);
		_g_object_unref0 (child);
		child = _tmp10_;
		_tmp11_ = child;
		_tmp12_ = menu_button_get_category (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = budgie_category_get_name (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strdup (_tmp15_);
		_g_free0 (next);
		next = _tmp16_;
	}
	if (before == NULL) {
		_tmp18_ = TRUE;
	} else {
		_tmp18_ = after == NULL;
	}
	if (_tmp18_) {
		_tmp17_ = TRUE;
	} else {
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		_tmp19_ = prev;
		_tmp20_ = next;
		_tmp17_ = g_strcmp0 (_tmp19_, _tmp20_) != 0;
	}
	if (_tmp17_) {
		GtkLabel* label = NULL;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		GtkLabel* _tmp24_;
		GtkLabel* _tmp25_;
		GtkLabel* _tmp26_;
		GtkStyleContext* _tmp27_;
		GtkLabel* _tmp28_;
		GtkLabel* _tmp29_;
		GtkLabel* _tmp30_;
		GtkLabel* _tmp31_;
		_tmp21_ = prev;
		_tmp22_ = g_markup_printf_escaped ("<big>%s</big>", _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = (GtkLabel*) gtk_label_new (_tmp23_);
		g_object_ref_sink (_tmp24_);
		_tmp25_ = _tmp24_;
		_g_free0 (_tmp23_);
		label = _tmp25_;
		_tmp26_ = label;
		_tmp27_ = gtk_widget_get_style_context ((GtkWidget*) _tmp26_);
		gtk_style_context_add_class (_tmp27_, "dim-label");
		_tmp28_ = label;
		gtk_widget_set_halign ((GtkWidget*) _tmp28_, GTK_ALIGN_START);
		_tmp29_ = label;
		gtk_label_set_use_markup (_tmp29_, TRUE);
		_tmp30_ = label;
		gtk_list_box_row_set_header (before, (GtkWidget*) _tmp30_);
		_tmp31_ = label;
		g_object_set ((GtkWidget*) _tmp31_, "margin", 6, NULL);
		_g_object_unref0 (label);
	} else {
		gtk_list_box_row_set_header (before, NULL);
	}
	_g_free0 (next);
	_g_free0 (prev);
	_g_object_unref0 (child);
}

/**
 * Filter out results in the list according to whatever the current filter is,
 * i.e. group based or search based
 */
static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
application_list_view_do_filter_list (ApplicationListView* self,
                                      GtkListBoxRow* row)
{
	MenuButton* child = NULL;
	GtkWidget* _tmp0_;
	MenuButton* _tmp1_;
	gchar* term = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GtkBox* _tmp14_;
	BudgieCategory* _tmp15_;
	MenuButton* _tmp18_;
	BudgieCategory* _tmp19_;
	BudgieCategory* _tmp20_;
	BudgieCategory* _tmp21_;
	MenuButton* _tmp22_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (row != NULL, FALSE);
	_tmp0_ = gtk_bin_get_child ((GtkBin*) row);
	_tmp1_ = _g_object_ref0 (IS_MENU_BUTTON (_tmp0_) ? ((MenuButton*) _tmp0_) : NULL);
	child = _tmp1_;
	_tmp2_ = application_view_get_search_term ((ApplicationView*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_strip (_tmp3_);
	term = _tmp4_;
	_tmp5_ = term;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ > 0) {
		GtkBox* _tmp8_;
		MenuButton* _tmp9_;
		BudgieRelevancyService* _tmp10_;
		MenuButton* _tmp11_;
		BudgieApplication* _tmp12_;
		BudgieApplication* _tmp13_;
		_tmp8_ = self->priv->categories;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, FALSE);
		_tmp9_ = child;
		if (application_view_is_item_dupe ((ApplicationView*) self, _tmp9_)) {
			result = FALSE;
			_g_free0 (term);
			_g_object_unref0 (child);
			return result;
		}
		_tmp10_ = ((ApplicationView*) self)->relevancy_service;
		_tmp11_ = child;
		_tmp12_ = menu_button_get_app (_tmp11_);
		_tmp13_ = _tmp12_;
		result = budgie_relevancy_service_is_app_relevant (_tmp10_, _tmp13_);
		_g_free0 (term);
		_g_object_unref0 (child);
		return result;
	}
	_tmp14_ = self->priv->categories;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp14_, TRUE);
	_tmp15_ = self->priv->current_category;
	if (_tmp15_ == NULL) {
		MenuButton* _tmp16_;
		_tmp16_ = child;
		if (menu_button_is_control_center_panel (_tmp16_)) {
			if (!self->priv->show_control_center_panels) {
				result = FALSE;
				_g_free0 (term);
				_g_object_unref0 (child);
				return result;
			}
		}
		if (self->priv->headers_visible) {
			result = TRUE;
			_g_free0 (term);
			_g_object_unref0 (child);
			return result;
		} else {
			MenuButton* _tmp17_;
			_tmp17_ = child;
			result = !application_view_is_item_dupe ((ApplicationView*) self, _tmp17_);
			_g_free0 (term);
			_g_object_unref0 (child);
			return result;
		}
	}
	_tmp18_ = child;
	_tmp19_ = menu_button_get_category (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = self->priv->current_category;
	if (_tmp20_ != _tmp21_) {
		result = FALSE;
		_g_free0 (term);
		_g_object_unref0 (child);
		return result;
	}
	_tmp22_ = child;
	if (menu_button_is_control_center_panel (_tmp22_)) {
		if (!self->priv->show_control_center_panels) {
			result = FALSE;
			_g_free0 (term);
			_g_object_unref0 (child);
			return result;
		}
	}
	result = TRUE;
	_g_free0 (term);
	_g_object_unref0 (child);
	return result;
}

/**
 * Sorts two list items.
 *
 * If there is an active search, items will be sorted by how well they match the term.
 * Otherwise, they will be sorted alphebetically by their name.
 */
static gint
application_list_view_do_sort_list (ApplicationListView* self,
                                    GtkListBoxRow* row1,
                                    GtkListBoxRow* row2)
{
	MenuButton* child1 = NULL;
	GtkWidget* _tmp0_;
	MenuButton* _tmp1_;
	MenuButton* child2 = NULL;
	GtkWidget* _tmp2_;
	MenuButton* _tmp3_;
	gchar* term = NULL;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gchar* parentA = NULL;
	MenuButton* _tmp28_;
	BudgieCategory* _tmp29_;
	BudgieCategory* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* parentB = NULL;
	MenuButton* _tmp34_;
	BudgieCategory* _tmp35_;
	BudgieCategory* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	gchar* _tmp39_;
	gboolean _tmp40_ = FALSE;
	MenuButton* _tmp41_;
	BudgieCategory* _tmp42_;
	BudgieCategory* _tmp43_;
	MenuButton* _tmp44_;
	BudgieCategory* _tmp45_;
	BudgieCategory* _tmp46_;
	gchar* nameA = NULL;
	MenuButton* _tmp49_;
	BudgieApplication* _tmp50_;
	BudgieApplication* _tmp51_;
	const gchar* _tmp52_;
	const gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* nameB = NULL;
	MenuButton* _tmp55_;
	BudgieApplication* _tmp56_;
	BudgieApplication* _tmp57_;
	const gchar* _tmp58_;
	const gchar* _tmp59_;
	gchar* _tmp60_;
	const gchar* _tmp61_;
	const gchar* _tmp62_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (row1 != NULL, 0);
	g_return_val_if_fail (row2 != NULL, 0);
	_tmp0_ = gtk_bin_get_child ((GtkBin*) row1);
	_tmp1_ = _g_object_ref0 (IS_MENU_BUTTON (_tmp0_) ? ((MenuButton*) _tmp0_) : NULL);
	child1 = _tmp1_;
	_tmp2_ = gtk_bin_get_child ((GtkBin*) row2);
	_tmp3_ = _g_object_ref0 (IS_MENU_BUTTON (_tmp2_) ? ((MenuButton*) _tmp2_) : NULL);
	child2 = _tmp3_;
	_tmp4_ = application_view_get_search_term ((ApplicationView*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = string_strip (_tmp5_);
	term = _tmp6_;
	_tmp7_ = term;
	_tmp8_ = strlen (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ > 0) {
		gint sc1 = 0;
		BudgieRelevancyService* _tmp10_;
		MenuButton* _tmp11_;
		BudgieApplication* _tmp12_;
		BudgieApplication* _tmp13_;
		gint sc2 = 0;
		BudgieRelevancyService* _tmp14_;
		MenuButton* _tmp15_;
		BudgieApplication* _tmp16_;
		BudgieApplication* _tmp17_;
		_tmp10_ = ((ApplicationView*) self)->relevancy_service;
		_tmp11_ = child1;
		_tmp12_ = menu_button_get_app (_tmp11_);
		_tmp13_ = _tmp12_;
		sc1 = budgie_relevancy_service_get_score (_tmp10_, _tmp13_);
		_tmp14_ = ((ApplicationView*) self)->relevancy_service;
		_tmp15_ = child2;
		_tmp16_ = menu_button_get_app (_tmp15_);
		_tmp17_ = _tmp16_;
		sc2 = budgie_relevancy_service_get_score (_tmp14_, _tmp17_);
		if (sc1 < sc2) {
			result = -1;
			_g_free0 (term);
			_g_object_unref0 (child2);
			_g_object_unref0 (child1);
			return result;
		} else {
			if (sc1 > sc2) {
				result = 1;
				_g_free0 (term);
				_g_object_unref0 (child2);
				_g_object_unref0 (child1);
				return result;
			} else {
				MenuButton* _tmp18_;
				BudgieApplication* _tmp19_;
				BudgieApplication* _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				MenuButton* _tmp23_;
				BudgieApplication* _tmp24_;
				BudgieApplication* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				_tmp18_ = child1;
				_tmp19_ = menu_button_get_app (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = budgie_application_get_name (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = child2;
				_tmp24_ = menu_button_get_app (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = budgie_application_get_name (_tmp25_);
				_tmp27_ = _tmp26_;
				result = g_utf8_collate (_tmp22_, _tmp27_);
				_g_free0 (term);
				_g_object_unref0 (child2);
				_g_object_unref0 (child1);
				return result;
			}
		}
	}
	_tmp28_ = child1;
	_tmp29_ = menu_button_get_category (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = budgie_category_get_name (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = budgie_relevancy_service_searchable_string (_tmp32_);
	parentA = _tmp33_;
	_tmp34_ = child2;
	_tmp35_ = menu_button_get_category (_tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = budgie_category_get_name (_tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = budgie_relevancy_service_searchable_string (_tmp38_);
	parentB = _tmp39_;
	_tmp41_ = child1;
	_tmp42_ = menu_button_get_category (_tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = child2;
	_tmp45_ = menu_button_get_category (_tmp44_);
	_tmp46_ = _tmp45_;
	if (_tmp43_ != _tmp46_) {
		_tmp40_ = self->priv->headers_visible;
	} else {
		_tmp40_ = FALSE;
	}
	if (_tmp40_) {
		const gchar* _tmp47_;
		const gchar* _tmp48_;
		_tmp47_ = parentA;
		_tmp48_ = parentB;
		result = g_utf8_collate (_tmp47_, _tmp48_);
		_g_free0 (parentB);
		_g_free0 (parentA);
		_g_free0 (term);
		_g_object_unref0 (child2);
		_g_object_unref0 (child1);
		return result;
	}
	_tmp49_ = child1;
	_tmp50_ = menu_button_get_app (_tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = budgie_application_get_name (_tmp51_);
	_tmp53_ = _tmp52_;
	_tmp54_ = budgie_relevancy_service_searchable_string (_tmp53_);
	nameA = _tmp54_;
	_tmp55_ = child2;
	_tmp56_ = menu_button_get_app (_tmp55_);
	_tmp57_ = _tmp56_;
	_tmp58_ = budgie_application_get_name (_tmp57_);
	_tmp59_ = _tmp58_;
	_tmp60_ = budgie_relevancy_service_searchable_string (_tmp59_);
	nameB = _tmp60_;
	_tmp61_ = nameA;
	_tmp62_ = nameB;
	result = g_utf8_collate (_tmp61_, _tmp62_);
	_g_free0 (nameB);
	_g_free0 (nameA);
	_g_free0 (parentB);
	_g_free0 (parentA);
	_g_free0 (term);
	_g_object_unref0 (child2);
	_g_object_unref0 (child1);
	return result;
}

/**
 * Change the current group/category
 */
static void
application_list_view_update_category (ApplicationListView* self,
                                       CategoryButton* btn)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (btn != NULL);
	_tmp0_ = gtk_toggle_button_get_active ((GtkToggleButton*) btn);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		BudgieCategory* _tmp2_;
		BudgieCategory* _tmp3_;
		BudgieCategory* _tmp4_;
		_tmp2_ = category_button_get_category (btn);
		_tmp3_ = _tmp2_;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_g_object_unref0 (self->priv->current_category);
		self->priv->current_category = _tmp4_;
		application_view_invalidate ((ApplicationView*) self);
	}
}

/**
 * We need to make some changes to our display before we go showing ourselves
 * again! :)
 */
static void
application_list_view_real_on_show (ApplicationView* base)
{
	ApplicationListView * self;
	CategoryButton* _tmp0_;
	CategoryButton* _tmp1_;
	GtkListBox* _tmp2_;
	GtkScrolledWindow* _tmp3_;
	GtkAdjustment* _tmp4_;
	GtkScrolledWindow* _tmp5_;
	GtkAdjustment* _tmp6_;
	GtkBox* _tmp7_;
	self = (ApplicationListView*) base;
	_tmp0_ = self->priv->all_categories;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp0_, TRUE);
	_tmp1_ = self->priv->all_categories;
	application_list_view_update_category (self, _tmp1_);
	_tmp2_ = self->priv->applications;
	gtk_list_box_select_row (_tmp2_, NULL);
	_tmp3_ = self->priv->content_scroll;
	_tmp4_ = gtk_scrolled_window_get_vadjustment (_tmp3_);
	gtk_adjustment_set_value (_tmp4_, (gdouble) 0);
	_tmp5_ = self->priv->categories_scroll;
	_tmp6_ = gtk_scrolled_window_get_vadjustment (_tmp5_);
	gtk_adjustment_set_value (_tmp6_, (gdouble) 0);
	_tmp7_ = self->priv->categories;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, TRUE);
	if (!self->priv->compact_mode) {
		GtkScrolledWindow* _tmp8_;
		_tmp8_ = self->priv->categories_scroll;
		gtk_widget_show_all ((GtkWidget*) _tmp8_);
	} else {
		GtkScrolledWindow* _tmp9_;
		_tmp9_ = self->priv->categories_scroll;
		gtk_widget_hide ((GtkWidget*) _tmp9_);
	}
}

GSettings*
application_list_view_get_settings (ApplicationListView* self)
{
	GSettings* result;
	GSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	result = _tmp0_;
	return result;
}

static void
application_list_view_set_settings (ApplicationListView* self,
                                    GSettings* value)
{
	GSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = application_list_view_get_settings (self);
	if (old_value != value) {
		GSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_settings);
		self->priv->_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_list_view_properties[APPLICATION_LIST_VIEW_SETTINGS_PROPERTY]);
	}
}

static void
_application_list_view___lambda12_ (ApplicationListView* self)
{
	application_list_view_set_scaled_sizing (self);
}

static void
__application_list_view___lambda12__g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self)
{
	_application_list_view___lambda12_ ((ApplicationListView*) self);
}

static void
_application_list_view___lambda13_ (ApplicationListView* self)
{
	CategoryButton* _tmp0_;
	_tmp0_ = self->priv->all_categories;
	application_list_view_update_category (self, _tmp0_);
}

static void
__application_list_view___lambda13__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                               gpointer self)
{
	_application_list_view___lambda13_ ((ApplicationListView*) self);
}

static void
_application_list_view_on_row_activate_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                   GtkListBoxRow* row,
                                                                   gpointer self)
{
	application_list_view_on_row_activate ((ApplicationListView*) self, row);
}

static void
_application_list_view_on_settings_changed_g_settings_changed (GSettings* _sender,
                                                               const gchar* key,
                                                               gpointer self)
{
	application_list_view_on_settings_changed ((ApplicationListView*) self, key);
}

static gboolean
_application_list_view_do_filter_list_gtk_list_box_filter_func (GtkListBoxRow* row,
                                                                gpointer self)
{
	gboolean result;
	result = application_list_view_do_filter_list ((ApplicationListView*) self, row);
	return result;
}

static gint
_application_list_view_do_sort_list_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                            GtkListBoxRow* row2,
                                                            gpointer self)
{
	gint result;
	result = application_list_view_do_sort_list ((ApplicationListView*) self, row1, row2);
	return result;
}

static GObject *
application_list_view_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ApplicationListView * self;
	GSettings* _tmp0_;
	GtkBox* _tmp1_ = NULL;
	GtkScrolledWindow* _tmp2_ = NULL;
	GtkScrolledWindow* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkScrolledWindow* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkScrolledWindow* _tmp7_;
	GtkBox* _tmp8_;
	GtkScrolledWindow* _tmp9_;
	CategoryButton* _tmp10_;
	CategoryButton* _tmp11_;
	CategoryButton* _tmp12_;
	GtkBox* _tmp13_;
	CategoryButton* _tmp14_;
	GtkBox* right_layout = NULL;
	GtkBox* _tmp15_;
	GtkBox* _tmp16_;
	GtkListBox* _tmp17_ = NULL;
	GtkListBox* _tmp18_;
	GtkScrolledWindow* _tmp19_ = NULL;
	GtkScrolledWindow* _tmp20_;
	GtkScrolledWindow* _tmp21_;
	GtkListBox* _tmp22_;
	GtkBox* _tmp23_;
	GtkScrolledWindow* _tmp24_;
	GtkLabel* placeholder = NULL;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GtkLabel* _tmp27_ = NULL;
	GtkLabel* _tmp28_;
	GtkLabel* _tmp29_;
	GtkStyleContext* _tmp30_;
	GtkLabel* _tmp31_;
	GtkListBox* _tmp32_;
	GtkLabel* _tmp33_;
	GSettings* _tmp34_;
	GtkListBox* _tmp35_;
	GtkListBox* _tmp36_;
	parent_class = G_OBJECT_CLASS (application_list_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_APPLICATION_LIST_VIEW, ApplicationListView);
	gtk_widget_set_size_request ((GtkWidget*) self, self->priv->SCALED_WIDTH, self->priv->SCALED_HEIGHT);
	_tmp0_ = self->priv->_settings;
	application_view_set_icon_size ((ApplicationView*) self, g_settings_get_int (_tmp0_, "menu-icons-size"));
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp1_, 3);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp1_, 3);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->categories);
	self->priv->categories = _tmp1_;
	g_signal_connect_object ((GObject*) self, "notify::scale-factor", (GCallback) __application_list_view___lambda12__g_object_notify, self, 0);
	_tmp2_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_overlay_scrolling (_tmp2_, FALSE);
	gtk_scrolled_window_set_shadow_type (_tmp2_, GTK_SHADOW_NONE);
	g_object_set (_tmp2_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	g_object_set (_tmp2_, "vscrollbar-policy", GTK_POLICY_AUTOMATIC, NULL);
	gtk_scrolled_window_set_min_content_height (_tmp2_, self->priv->SCALED_HEIGHT);
	gtk_scrolled_window_set_propagate_natural_height (_tmp2_, TRUE);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->categories_scroll);
	self->priv->categories_scroll = _tmp2_;
	_tmp3_ = self->priv->categories_scroll;
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
	gtk_style_context_add_class (_tmp4_, "categories");
	_tmp5_ = self->priv->categories_scroll;
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _tmp5_);
	gtk_style_context_add_class (_tmp6_, "sidebar");
	_tmp7_ = self->priv->categories_scroll;
	_tmp8_ = self->priv->categories;
	gtk_container_add ((GtkContainer*) _tmp7_, (GtkWidget*) _tmp8_);
	_tmp9_ = self->priv->categories_scroll;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp9_, FALSE, FALSE, (guint) 0);
	_tmp10_ = category_button_new (NULL);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->all_categories);
	self->priv->all_categories = _tmp10_;
	_tmp11_ = self->priv->all_categories;
	g_signal_connect_object ((GtkWidget*) _tmp11_, "enter-notify-event", (GCallback) _application_list_view_on_mouse_enter_gtk_widget_enter_notify_event, self, 0);
	_tmp12_ = self->priv->all_categories;
	g_signal_connect_object ((GtkToggleButton*) _tmp12_, "toggled", (GCallback) __application_list_view___lambda13__gtk_toggle_button_toggled, self, 0);
	_tmp13_ = self->priv->categories;
	_tmp14_ = self->priv->all_categories;
	gtk_box_pack_start (_tmp13_, (GtkWidget*) _tmp14_, FALSE, TRUE, (guint) 0);
	_tmp15_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp15_);
	right_layout = _tmp15_;
	_tmp16_ = right_layout;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp16_, TRUE, TRUE, (guint) 0);
	_tmp17_ = (GtkListBox*) gtk_list_box_new ();
	gtk_list_box_set_selection_mode (_tmp17_, GTK_SELECTION_SINGLE);
	gtk_widget_set_valign ((GtkWidget*) _tmp17_, GTK_ALIGN_START);
	g_object_set ((GtkWidget*) _tmp17_, "height-request", self->priv->SCALED_HEIGHT, NULL);
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->applications);
	self->priv->applications = _tmp17_;
	_tmp18_ = self->priv->applications;
	g_signal_connect_object (_tmp18_, "row-activated", (GCallback) _application_list_view_on_row_activate_gtk_list_box_row_activated, self, 0);
	_tmp19_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_overlay_scrolling (_tmp19_, TRUE);
	g_object_set (_tmp19_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	g_object_set (_tmp19_, "vscrollbar-policy", GTK_POLICY_AUTOMATIC, NULL);
	gtk_scrolled_window_set_min_content_height (_tmp19_, self->priv->SCALED_HEIGHT);
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->content_scroll);
	self->priv->content_scroll = _tmp19_;
	_tmp20_ = self->priv->content_scroll;
	gtk_scrolled_window_set_overlay_scrolling (_tmp20_, TRUE);
	_tmp21_ = self->priv->content_scroll;
	_tmp22_ = self->priv->applications;
	gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
	_tmp23_ = right_layout;
	_tmp24_ = self->priv->content_scroll;
	gtk_box_pack_start (_tmp23_, (GtkWidget*) _tmp24_, TRUE, TRUE, (guint) 0);
	_tmp25_ = g_strdup_printf ("<big>%s</big>", _ ("Sorry, no items found"));
	_tmp26_ = _tmp25_;
	_tmp27_ = (GtkLabel*) gtk_label_new (_tmp26_);
	gtk_label_set_use_markup (_tmp27_, TRUE);
	g_object_set ((GtkWidget*) _tmp27_, "margin", 6, NULL);
	g_object_ref_sink (_tmp27_);
	_tmp28_ = _tmp27_;
	_g_free0 (_tmp26_);
	placeholder = _tmp28_;
	_tmp29_ = placeholder;
	_tmp30_ = gtk_widget_get_style_context ((GtkWidget*) _tmp29_);
	gtk_style_context_add_class (_tmp30_, "dim-label");
	_tmp31_ = placeholder;
	gtk_widget_show ((GtkWidget*) _tmp31_);
	_tmp32_ = self->priv->applications;
	_tmp33_ = placeholder;
	gtk_list_box_set_placeholder (_tmp32_, (GtkWidget*) _tmp33_);
	_tmp34_ = self->priv->_settings;
	g_signal_connect_object (_tmp34_, "changed", (GCallback) _application_list_view_on_settings_changed_g_settings_changed, self, 0);
	application_list_view_on_settings_changed (self, "menu-compact");
	application_list_view_on_settings_changed (self, "menu-headers");
	application_list_view_on_settings_changed (self, "menu-categories-hover");
	application_list_view_on_settings_changed (self, "menu-show-control-center-items");
	_tmp35_ = self->priv->applications;
	gtk_list_box_set_filter_func (_tmp35_, _application_list_view_do_filter_list_gtk_list_box_filter_func, g_object_ref (self), g_object_unref);
	_tmp36_ = self->priv->applications;
	gtk_list_box_set_sort_func (_tmp36_, _application_list_view_do_sort_list_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	application_list_view_set_scaled_sizing (self);
	_g_object_unref0 (placeholder);
	_g_object_unref0 (right_layout);
	return obj;
}

static void
application_list_view_class_init (ApplicationListViewClass * klass,
                                  gpointer klass_data)
{
	application_list_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ApplicationListView_private_offset);
	((ApplicationViewClass *) klass)->refresh = (void (*) (ApplicationView*, BudgieAppIndex*)) application_list_view_real_refresh;
	((ApplicationViewClass *) klass)->invalidate = (void (*) (ApplicationView*)) application_list_view_real_invalidate;
	((ApplicationViewClass *) klass)->on_search_entry_activated = (void (*) (ApplicationView*)) application_list_view_real_on_search_entry_activated;
	((ApplicationViewClass *) klass)->on_show = (void (*) (ApplicationView*)) application_list_view_real_on_show;
	G_OBJECT_CLASS (klass)->get_property = _vala_application_list_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_application_list_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = application_list_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = application_list_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_LIST_VIEW_SETTINGS_PROPERTY, application_list_view_properties[APPLICATION_LIST_VIEW_SETTINGS_PROPERTY] = g_param_spec_object ("settings", "settings", "settings", g_settings_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
application_list_view_instance_init (ApplicationListView * self,
                                     gpointer klass)
{
	self->priv = application_list_view_get_instance_private (self);
	self->priv->SCALED_HEIGHT = APPLICATION_LIST_VIEW_HEIGHT;
	self->priv->SCALED_WIDTH = APPLICATION_LIST_VIEW_WIDTH;
	self->priv->_settings = NULL;
	self->priv->current_category = NULL;
	self->priv->rollover_menus = TRUE;
	g_rec_mutex_init (&self->priv->__lock_reloading);
	self->priv->reloading = FALSE;
}

static void
application_list_view_finalize (GObject * obj)
{
	ApplicationListView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_APPLICATION_LIST_VIEW, ApplicationListView);
	_g_object_unref0 (self->priv->categories);
	_g_object_unref0 (self->priv->applications);
	_g_object_unref0 (self->priv->categories_scroll);
	_g_object_unref0 (self->priv->content_scroll);
	_g_object_unref0 (self->priv->all_categories);
	_g_object_unref0 (self->priv->_settings);
	_g_object_unref0 (self->priv->current_category);
	g_rec_mutex_clear (&self->priv->__lock_reloading);
	G_OBJECT_CLASS (application_list_view_parent_class)->finalize (obj);
}

/**
 * Widget to display applications in a list.
 *
 * This shows a list of categories on the left, and all applications
 * on the right.
 */
GType
application_list_view_get_type (void)
{
	return application_list_view_type_id;
}

GType
application_list_view_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ApplicationListViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_list_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ApplicationListView), 0, (GInstanceInitFunc) application_list_view_instance_init, NULL };
	application_list_view_type_id = g_type_module_register_type (module, TYPE_APPLICATION_VIEW, "ApplicationListView", &g_define_type_info, 0);
	ApplicationListView_private_offset = sizeof (ApplicationListViewPrivate);
	return application_list_view_type_id;
}

static void
_vala_application_list_view_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	ApplicationListView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_APPLICATION_LIST_VIEW, ApplicationListView);
	switch (property_id) {
		case APPLICATION_LIST_VIEW_SETTINGS_PROPERTY:
		g_value_set_object (value, application_list_view_get_settings (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_application_list_view_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	ApplicationListView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_APPLICATION_LIST_VIEW, ApplicationListView);
	switch (property_id) {
		case APPLICATION_LIST_VIEW_SETTINGS_PROPERTY:
		application_list_view_set_settings (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

