// This file is generated by kconfig_compiler_kf6 from bovo.kcfg.
// All changes you do to this file will be lost.
#ifndef GUI_SETTINGS_H
#define GUI_SETTINGS_H

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>

namespace gui {

class Settings : public KConfigSkeleton
{
  public:
    class EnumAi
    {
      public:
      enum type { Gabor, Aron, COUNT };
    };

    static Settings *self();
    ~Settings() override;

    /**
      Set Theme
    */
    static
    void setTheme( const QString & v )
    {
      if (!self()->isThemeImmutable())
        self()->mTheme = v;
    }

    /**
      Get Theme
    */
    static
    QString theme()
    {
      return self()->mTheme;
    }

    /**
      Is Theme Immutable
    */
    static
    bool isThemeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "theme" ) );
    }

    /**
      Set Speed of demo and replay playback.
    */
    static
    void setPlaybackSpeed( int v )
    {
      if (v < 150)
      {
        qDebug() << "setPlaybackSpeed: value " << v << " is less than the minimum value of 150";
        v = 150;
      }

      if (v > 2000)
      {
        qDebug() << "setPlaybackSpeed: value " << v << " is greater than the maximum value of 2000";
        v = 2000;
      }

      if (!self()->isPlaybackSpeedImmutable())
        self()->mPlaybackSpeed = v;
    }

    /**
      Get Speed of demo and replay playback.
    */
    static
    int playbackSpeed()
    {
      return self()->mPlaybackSpeed;
    }

    /**
      Is Speed of demo and replay playback. Immutable
    */
    static
    bool isPlaybackSpeedImmutable()
    {
      return self()->isImmutable( QStringLiteral( "playbackSpeed" ) );
    }

    /**
      Set Whether moves should be animated or not.
    */
    static
    void setAnimation( bool v )
    {
      if (!self()->isAnimationImmutable())
        self()->mAnimation = v;
    }

    /**
      Get Whether moves should be animated or not.
    */
    static
    bool animation()
    {
      return self()->mAnimation;
    }

    /**
      Is Whether moves should be animated or not. Immutable
    */
    static
    bool isAnimationImmutable()
    {
      return self()->isImmutable( QStringLiteral( "animation" ) );
    }

    /**
      Set AI engine to use.
    */
    static
    void setAi( int v )
    {
      if (!self()->isAiImmutable())
        self()->mAi = v;
    }

    /**
      Get AI engine to use.
    */
    static
    int ai()
    {
      return self()->mAi;
    }

    /**
      Is AI engine to use. Immutable
    */
    static
    bool isAiImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ai" ) );
    }

  protected:
    Settings();
    friend class SettingsHelper;


    // bovo
    QString mTheme;
    int mPlaybackSpeed;
    bool mAnimation;
    int mAi;

  private:
};

}

#endif

