/* Tool.c generated by valac 0.56.17, the Vala compiler
 * generated from Tool.vala, do not modify */

/*
Copyright (C) 2012, 2014 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <cairo-gobject.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_TOOL_0_PROPERTY,
	BIRD_FONT_TOOL_NUM_PROPERTIES
};
static GParamSpec* bird_font_tool_properties[BIRD_FONT_TOOL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
typedef struct _Block70Data Block70Data;
typedef struct _Block71Data Block71Data;
enum  {
	BIRD_FONT_TOOL_SELECT_ACTION_SIGNAL,
	BIRD_FONT_TOOL_DESELECT_ACTION_SIGNAL,
	BIRD_FONT_TOOL_PRESS_ACTION_SIGNAL,
	BIRD_FONT_TOOL_DOUBLE_CLICK_ACTION_SIGNAL,
	BIRD_FONT_TOOL_MOVE_ACTION_SIGNAL,
	BIRD_FONT_TOOL_MOVE_OUT_ACTION_SIGNAL,
	BIRD_FONT_TOOL_RELEASE_ACTION_SIGNAL,
	BIRD_FONT_TOOL_SCROLL_WHEEL_UP_ACTION_SIGNAL,
	BIRD_FONT_TOOL_SCROLL_WHEEL_DOWN_ACTION_SIGNAL,
	BIRD_FONT_TOOL_KEY_PRESS_ACTION_SIGNAL,
	BIRD_FONT_TOOL_KEY_RELEASE_ACTION_SIGNAL,
	BIRD_FONT_TOOL_PANEL_PRESS_ACTION_SIGNAL,
	BIRD_FONT_TOOL_PANEL_RELEASE_ACTION_SIGNAL,
	BIRD_FONT_TOOL_PANEL_DOUBLE_CLICK_ACTION_SIGNAL,
	BIRD_FONT_TOOL_PANEL_MOVE_ACTION_SIGNAL,
	BIRD_FONT_TOOL_DRAW_ACTION_SIGNAL,
	BIRD_FONT_TOOL_REDRAW_TOOL_SIGNAL,
	BIRD_FONT_TOOL_NUM_SIGNALS
};
static guint bird_font_tool_signals[BIRD_FONT_TOOL_NUM_SIGNALS] = {0};

struct _BirdFontToolPrivate {
	gdouble scale;
	gint id;
	gboolean show_bg;
	gboolean waiting_for_tooltip;
	gboolean showing_this_tooltip;
};

struct _Block70Data {
	int _ref_count_;
	BirdFontToolbox* toolbox;
};

struct _Block71Data {
	int _ref_count_;
	gboolean timeout;
};

static gint BirdFontTool_private_offset;
static gpointer bird_font_tool_parent_class = NULL;
static gint bird_font_tool_next_id;
static gint bird_font_tool_next_id = 1;
static BirdFontTool* bird_font_tool_active_tooltip;
static BirdFontTool* bird_font_tool_active_tooltip = NULL;

static void __lambda588_ (BirdFontTool* self,
                   BirdFontTool* _self_,
                   guint button,
                   gdouble x,
                   gdouble y);
static void ___lambda588__bird_font_tool_panel_press_action (BirdFontTool* _sender,
                                                      BirdFontTool* selected,
                                                      guint button,
                                                      gdouble x,
                                                      gdouble y,
                                                      gpointer self);
static void __lambda589_ (BirdFontTool* self,
                   BirdFontTool* _self_);
static void ___lambda589__bird_font_tool_select_action (BirdFontTool* _sender,
                                                 BirdFontTool* selected,
                                                 gpointer self);
static void __lambda590_ (BirdFontTool* self,
                   BirdFontTool* _self_);
static void ___lambda590__bird_font_tool_deselect_action (BirdFontTool* _sender,
                                                   BirdFontTool* selected,
                                                   gpointer self);
static void __lambda591_ (BirdFontTool* self,
                   BirdFontTool* _self_);
static void ___lambda591__bird_font_tool_move_out_action (BirdFontTool* _sender,
                                                   BirdFontTool* selected,
                                                   gpointer self);
static gboolean __lambda592_ (BirdFontTool* self,
                       BirdFontTool* _self_,
                       gdouble x,
                       gdouble y);
static void bird_font_tool_wait_for_tooltip (BirdFontTool* self);
static gboolean ___lambda592__bird_font_tool_panel_move_action (BirdFontTool* _sender,
                                                         BirdFontTool* selected,
                                                         gdouble x,
                                                         gdouble y,
                                                         gpointer self);
static gchar* bird_font_tool_real_get_tip (BirdFontTool* self);
static void bird_font_tool_real_draw (BirdFontWidget* base,
                               cairo_t* cr);
static gdouble bird_font_tool_real_get_height (BirdFontWidget* base);
static gdouble bird_font_tool_real_get_width (BirdFontWidget* base);
static gboolean ____lambda593_ (BirdFontTool* self);
static gboolean _____lambda593__gsource_func (gpointer self);
static Block70Data* block70_data_ref (Block70Data* _data70_);
static void block70_data_unref (void * _userdata_);
static gboolean ___lambda594_ (Block70Data* _data70_);
static gboolean ____lambda594__gsource_func (gpointer self);
static void bird_font_tool_real_draw_tool (BirdFontTool* self,
                                    cairo_t* cr,
                                    gdouble px,
                                    gdouble py);
static Block71Data* block71_data_ref (Block71Data* _data71_);
static void block71_data_unref (void * _userdata_);
VALA_EXTERN gboolean bird_font_test_bird_font_is_slow_test (void);
static gboolean ___lambda221_ (Block71Data* _data71_);
static gboolean ____lambda221__gsource_func (gpointer self);
static void bird_font_tool_real_before_undo (BirdFontTool* self);
static void bird_font_tool_real_after_undo (BirdFontTool* self);
static void g_cclosure_user_marshal_VOID__OBJECT_INT_INT_INT (GClosure * closure,
                                                       GValue * return_value,
                                                       guint n_param_values,
                                                       const GValue * param_values,
                                                       gpointer invocation_hint,
                                                       gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__OBJECT_INT_INT (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__OBJECT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__OBJECT_UINT (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__OBJECT_UINT_DOUBLE_DOUBLE (GClosure * closure,
                                                              GValue * return_value,
                                                              guint n_param_values,
                                                              const GValue * param_values,
                                                              gpointer invocation_hint,
                                                              gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__OBJECT_DOUBLE_DOUBLE (GClosure * closure,
                                                            GValue * return_value,
                                                            guint n_param_values,
                                                            const GValue * param_values,
                                                            gpointer invocation_hint,
                                                            gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__OBJECT_BOXED_OBJECT (GClosure * closure,
                                                        GValue * return_value,
                                                        guint n_param_values,
                                                        const GValue * param_values,
                                                        gpointer invocation_hint,
                                                        gpointer marshal_data);
static void bird_font_tool_finalize (GObject * obj);
static GType bird_font_tool_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
bird_font_tool_get_instance_private (BirdFontTool* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontTool_private_offset);
}

/** Create tool with a certain name and load icon "name".png */
static void
__lambda588_ (BirdFontTool* self,
              BirdFontTool* _self_,
              guint button,
              gdouble x,
              gdouble y)
{
	g_return_if_fail (_self_ != NULL);
	if (bird_font_tool_is_active (self)) {
		bird_font_tool_redraw (self);
	}
}

static void
___lambda588__bird_font_tool_panel_press_action (BirdFontTool* _sender,
                                                 BirdFontTool* selected,
                                                 guint button,
                                                 gdouble x,
                                                 gdouble y,
                                                 gpointer self)
{
	__lambda588_ ((BirdFontTool*) self, selected, button, x, y);
}

static void
__lambda589_ (BirdFontTool* self,
              BirdFontTool* _self_)
{
	g_return_if_fail (_self_ != NULL);
	bird_font_tool_redraw (self);
}

static void
___lambda589__bird_font_tool_select_action (BirdFontTool* _sender,
                                            BirdFontTool* selected,
                                            gpointer self)
{
	__lambda589_ ((BirdFontTool*) self, selected);
}

static void
__lambda590_ (BirdFontTool* self,
              BirdFontTool* _self_)
{
	g_return_if_fail (_self_ != NULL);
	bird_font_tool_redraw (self);
}

static void
___lambda590__bird_font_tool_deselect_action (BirdFontTool* _sender,
                                              BirdFontTool* selected,
                                              gpointer self)
{
	__lambda590_ ((BirdFontTool*) self, selected);
}

static void
__lambda591_ (BirdFontTool* self,
              BirdFontTool* _self_)
{
	BirdFontToolbox* _tmp0_;
	BirdFontToolbox* _tmp1_;
	BirdFontTool* _tmp2_;
	g_return_if_fail (_self_ != NULL);
	_tmp0_ = bird_font_main_window_get_toolbox ();
	_tmp1_ = _tmp0_;
	bird_font_toolbox_hide_tooltip (_tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = bird_font_tool_active_tooltip;
	_tmp2_->priv->showing_this_tooltip = FALSE;
	bird_font_tool_redraw (self);
}

static void
___lambda591__bird_font_tool_move_out_action (BirdFontTool* _sender,
                                              BirdFontTool* selected,
                                              gpointer self)
{
	__lambda591_ ((BirdFontTool*) self, selected);
}

static gboolean
__lambda592_ (BirdFontTool* self,
              BirdFontTool* _self_,
              gdouble x,
              gdouble y)
{
	gboolean result;
	g_return_val_if_fail (_self_ != NULL, FALSE);
	if (bird_font_tool_is_active (self)) {
		bird_font_tool_wait_for_tooltip (self);
		bird_font_tool_redraw (self);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda592__bird_font_tool_panel_move_action (BirdFontTool* _sender,
                                                BirdFontTool* selected,
                                                gdouble x,
                                                gdouble y,
                                                gpointer self)
{
	gboolean result;
	result = __lambda592_ ((BirdFontTool*) self, selected, x, y);
	return result;
}

BirdFontTool*
bird_font_tool_construct (GType object_type,
                          const gchar* name,
                          const gchar* tip)
{
	BirdFontTool * self = NULL;
	gchar* _tmp0_;
	BirdFontText* _tmp1_;
	gint _tmp3_;
	g_return_val_if_fail (tip != NULL, NULL);
	self = (BirdFontTool*) bird_font_widget_construct (object_type);
	_tmp0_ = g_strdup (tip);
	_g_free0 (self->tip);
	self->tip = _tmp0_;
	_tmp1_ = bird_font_text_new ("", (gdouble) 17, (gdouble) 0);
	_g_object_unref0 (self->icon_font);
	self->icon_font = _tmp1_;
	self->priv->scale = bird_font_main_window_units;
	self->w = 33 * bird_font_toolbox_get_scale ();
	self->h = (33 / 1.11) * bird_font_toolbox_get_scale ();
	if (name != NULL) {
		gchar* _tmp2_;
		bird_font_tool_set_icon (self, (const gchar*) name);
		_tmp2_ = g_strdup ((const gchar*) name);
		_g_free0 (self->name);
		self->name = _tmp2_;
	}
	self->priv->id = bird_font_tool_next_id;
	_tmp3_ = bird_font_tool_next_id;
	bird_font_tool_next_id = _tmp3_ + 1;
	g_signal_connect_object (self, "panel-press-action", (GCallback) ___lambda588__bird_font_tool_panel_press_action, self, 0);
	g_signal_connect_object (self, "select-action", (GCallback) ___lambda589__bird_font_tool_select_action, self, 0);
	g_signal_connect_object (self, "deselect-action", (GCallback) ___lambda590__bird_font_tool_deselect_action, self, 0);
	g_signal_connect_object (self, "move-out-action", (GCallback) ___lambda591__bird_font_tool_move_out_action, self, 0);
	g_signal_connect_object (self, "panel-move-action", (GCallback) ___lambda592__bird_font_tool_panel_move_action, self, 0);
	return self;
}

BirdFontTool*
bird_font_tool_new (const gchar* name,
                    const gchar* tip)
{
	return bird_font_tool_construct (BIRD_FONT_TYPE_TOOL, name, tip);
}

static gchar*
bird_font_tool_real_get_tip (BirdFontTool* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = self->tip;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
bird_font_tool_get_tip (BirdFontTool* self)
{
	BirdFontToolClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = BIRD_FONT_TOOL_GET_CLASS (self);
	if (_klass_->get_tip) {
		return _klass_->get_tip (self);
	}
	return NULL;
}

static void
bird_font_tool_real_draw (BirdFontWidget* base,
                          cairo_t* cr)
{
	BirdFontTool * self;
	self = (BirdFontTool*) base;
	g_return_if_fail (cr != NULL);
	bird_font_tool_draw_tool (self, cr, (gdouble) 0, (gdouble) 0);
}

void
bird_font_tool_redraw (BirdFontTool* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, bird_font_tool_signals[BIRD_FONT_TOOL_REDRAW_TOOL_SIGNAL], 0);
	bird_font_toolbox_redraw_tool_box ();
}

static gdouble
bird_font_tool_real_get_height (BirdFontWidget* base)
{
	BirdFontTool * self;
	gdouble result;
	self = (BirdFontTool*) base;
	result = 33 * self->priv->scale;
	return result;
}

static gdouble
bird_font_tool_real_get_width (BirdFontWidget* base)
{
	BirdFontTool * self;
	gdouble result;
	self = (BirdFontTool*) base;
	result = 33 * self->priv->scale;
	return result;
}

void
bird_font_tool_set_tool_visibility (BirdFontTool* self,
                                    gboolean v)
{
	g_return_if_fail (self != NULL);
	self->visible = v;
}

gboolean
bird_font_tool_tool_is_visible (BirdFontTool* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->visible;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
____lambda593_ (BirdFontTool* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean result;
	_tmp2_ = bird_font_tool_get_tip (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, "") != 0;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		BirdFontTool* _tmp5_;
		_tmp5_ = bird_font_tool_active_tooltip;
		_tmp1_ = bird_font_tool_is_active (_tmp5_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		BirdFontTool* _tmp6_;
		_tmp6_ = bird_font_tool_active_tooltip;
		_tmp0_ = !_tmp6_->priv->showing_this_tooltip;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		bird_font_tool_show_tooltip ();
	}
	self->priv->waiting_for_tooltip = FALSE;
	result = self->priv->waiting_for_tooltip;
	return result;
}

static gboolean
_____lambda593__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda593_ ((BirdFontTool*) self);
	return result;
}

static void
bird_font_tool_wait_for_tooltip (BirdFontTool* self)
{
	GSource* timer_show = NULL;
	gint timeout_interval = 0;
	BirdFontTool* _tmp0_;
	g_return_if_fail (self != NULL);
	timeout_interval = 1500;
	_tmp0_ = bird_font_tool_active_tooltip;
	if (_tmp0_ != self) {
		BirdFontTool* _tmp1_;
		BirdFontTool* _tmp2_;
		BirdFontTool* _tmp3_;
		_tmp1_ = bird_font_tool_active_tooltip;
		if (_tmp1_->priv->showing_this_tooltip) {
			timeout_interval = 1;
		}
		_tmp2_ = bird_font_tool_active_tooltip;
		_tmp2_->priv->showing_this_tooltip = FALSE;
		self->priv->showing_this_tooltip = FALSE;
		_tmp3_ = _g_object_ref0 (self);
		_g_object_unref0 (bird_font_tool_active_tooltip);
		bird_font_tool_active_tooltip = _tmp3_;
		if (!self->priv->waiting_for_tooltip) {
			GSource* _tmp4_;
			GSource* _tmp5_;
			GSource* _tmp6_;
			self->priv->waiting_for_tooltip = TRUE;
			_tmp4_ = g_timeout_source_new ((guint) timeout_interval);
			_g_source_unref0 (timer_show);
			timer_show = _tmp4_;
			_tmp5_ = timer_show;
			g_source_set_callback (_tmp5_, _____lambda593__gsource_func, g_object_ref (self), g_object_unref);
			_tmp6_ = timer_show;
			g_source_attach (_tmp6_, NULL);
		}
	}
	_g_source_unref0 (timer_show);
}

static Block70Data*
block70_data_ref (Block70Data* _data70_)
{
	g_atomic_int_inc (&_data70_->_ref_count_);
	return _data70_;
}

static void
block70_data_unref (void * _userdata_)
{
	Block70Data* _data70_;
	_data70_ = (Block70Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data70_->_ref_count_)) {
		_g_object_unref0 (_data70_->toolbox);
		g_slice_free (Block70Data, _data70_);
	}
}

static gboolean
___lambda594_ (Block70Data* _data70_)
{
	BirdFontTool* _tmp0_;
	BirdFontTool* _tmp4_;
	gboolean result;
	_tmp0_ = bird_font_tool_active_tooltip;
	if (!bird_font_tool_is_active (_tmp0_)) {
		BirdFontToolbox* _tmp1_;
		BirdFontTool* _tmp2_;
		BirdFontTool* _tmp3_;
		_tmp1_ = _data70_->toolbox;
		bird_font_toolbox_hide_tooltip (_tmp1_);
		_tmp2_ = bird_font_tool_active_tooltip;
		_tmp2_->priv->showing_this_tooltip = FALSE;
		_tmp3_ = bird_font_tool_new (NULL, "");
		_g_object_unref0 (bird_font_tool_active_tooltip);
		bird_font_tool_active_tooltip = _tmp3_;
	}
	_tmp4_ = bird_font_tool_active_tooltip;
	result = _tmp4_->priv->showing_this_tooltip;
	return result;
}

static gboolean
____lambda594__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda594_ (self);
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

void
bird_font_tool_show_tooltip (void)
{
	Block70Data* _data70_;
	GSource* timer_hide = NULL;
	gchar* tip = NULL;
	gchar* key_binding = NULL;
	BirdFontToolbox* _tmp0_;
	BirdFontTool* _tmp1_;
	BirdFontTool* _tmp5_;
	BirdFontTool* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	BirdFontTool* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	BirdFontToolbox* _tmp21_;
	BirdFontToolbox* _tmp22_;
	const gchar* _tmp23_;
	BirdFontTool* _tmp24_;
	BirdFontTool* _tmp25_;
	_data70_ = g_slice_new0 (Block70Data);
	_data70_->_ref_count_ = 1;
	_tmp0_ = bird_font_main_window_get_toolbox ();
	_g_object_unref0 (_data70_->toolbox);
	_data70_->toolbox = _tmp0_;
	_tmp1_ = bird_font_tool_active_tooltip;
	if (!_tmp1_->priv->showing_this_tooltip) {
		GSource* _tmp2_;
		GSource* _tmp3_;
		GSource* _tmp4_;
		_tmp2_ = g_timeout_source_new ((guint) 1500);
		_g_source_unref0 (timer_hide);
		timer_hide = _tmp2_;
		_tmp3_ = timer_hide;
		g_source_set_callback (_tmp3_, ____lambda594__gsource_func, block70_data_ref (_data70_), block70_data_unref);
		_tmp4_ = timer_hide;
		g_source_attach (_tmp4_, NULL);
	}
	_tmp5_ = bird_font_tool_active_tooltip;
	_tmp5_->priv->showing_this_tooltip = TRUE;
	_tmp6_ = bird_font_tool_active_tooltip;
	_tmp7_ = bird_font_tool_get_tip (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = string_to_string (_tmp8_);
	_tmp10_ = g_strdup (_tmp9_);
	_g_free0 (tip);
	tip = _tmp10_;
	_g_free0 (_tmp8_);
	_tmp11_ = bird_font_tool_active_tooltip;
	_tmp12_ = bird_font_tool_get_key_binding (_tmp11_);
	_g_free0 (key_binding);
	key_binding = _tmp12_;
	_tmp13_ = key_binding;
	if (g_strcmp0 (_tmp13_, "") != 0) {
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp14_ = tip;
		_tmp15_ = key_binding;
		_tmp16_ = g_strconcat (" (", _tmp15_, NULL);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strconcat (_tmp17_, ")", NULL);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp14_, _tmp19_, NULL);
		_g_free0 (tip);
		tip = _tmp20_;
		_g_free0 (_tmp19_);
		_g_free0 (_tmp17_);
	}
	_tmp21_ = _data70_->toolbox;
	bird_font_toolbox_hide_tooltip (_tmp21_);
	_tmp22_ = _data70_->toolbox;
	_tmp23_ = tip;
	_tmp24_ = bird_font_tool_active_tooltip;
	_tmp25_ = bird_font_tool_active_tooltip;
	bird_font_toolbox_show_tooltip (_tmp22_, _tmp23_, (gdouble) ((gint) _tmp24_->x), (gdouble) ((gint) _tmp25_->y));
	_g_free0 (key_binding);
	_g_free0 (tip);
	_g_source_unref0 (timer_hide);
	block70_data_unref (_data70_);
	_data70_ = NULL;
}

gchar*
bird_font_tool_get_key_binding (BirdFontTool* self)
{
	BirdFontToolItem* ti = NULL;
	BirdFontAbstractMenu* _tmp0_;
	BirdFontAbstractMenu* _tmp1_;
	BirdFontToolItem* _tmp2_;
	BirdFontToolItem* _tmp3_;
	BirdFontToolItem* t = NULL;
	BirdFontToolItem* _tmp4_;
	BirdFontToolItem* _tmp6_;
	BirdFontToolItem* _tmp7_;
	BirdFontToolItem* _tmp8_;
	gchar* _tmp9_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_main_window_get_menu ();
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_abstract_menu_get_item_for_tool (_tmp1_, self);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	ti = _tmp3_;
	_tmp4_ = ti;
	if (_tmp4_ == NULL) {
		gchar* _tmp5_;
		g_warning ("Tool.vala:228: No key binding for tool.");
		_tmp5_ = g_strdup ("");
		result = _tmp5_;
		_g_object_unref0 (t);
		_g_object_unref0 (ti);
		return result;
	}
	_tmp6_ = ti;
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, BIRD_FONT_TYPE_TOOL_ITEM, BirdFontToolItem));
	_g_object_unref0 (t);
	t = _tmp7_;
	_tmp8_ = t;
	_tmp9_ = bird_font_tool_item_get_key_binding (_tmp8_);
	result = _tmp9_;
	_g_object_unref0 (t);
	_g_object_unref0 (ti);
	return result;
}

void
bird_font_tool_set_icon (BirdFontTool* self,
                         const gchar* name)
{
	gboolean found = FALSE;
	gchar* icon_file = NULL;
	gchar* _tmp0_;
	BirdFontText* _tmp1_;
	BirdFontText* _tmp2_;
	const gchar* _tmp3_;
	BirdFontText* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = bird_font_theme_get_icon_file ();
	_g_free0 (icon_file);
	icon_file = _tmp0_;
	_tmp1_ = bird_font_text_new ((const gchar*) name, (gdouble) 17, (gdouble) 0);
	_g_object_unref0 (self->icon_font);
	self->icon_font = _tmp1_;
	_tmp2_ = self->icon_font;
	_tmp3_ = icon_file;
	found = bird_font_text_load_font (_tmp2_, _tmp3_);
	_tmp4_ = self->icon_font;
	bird_font_text_set_font_size (_tmp4_, 40 * bird_font_toolbox_get_scale ());
	if (!found) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp5_ = icon_file;
		_tmp6_ = string_to_string (_tmp5_);
		_tmp7_ = g_strconcat ("Icon font for toolbox was not found. (", _tmp6_, ")", NULL);
		_tmp8_ = _tmp7_;
		g_warning ("Tool.vala:246: %s", _tmp8_);
		_g_free0 (_tmp8_);
	}
	_g_free0 (icon_file);
}

gboolean
bird_font_tool_is_active (BirdFontTool* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->active;
	return result;
}

void
bird_font_tool_set_show_background (BirdFontTool* self,
                                    gboolean bg)
{
	g_return_if_fail (self != NULL);
	self->priv->show_bg = bg;
}

gint
bird_font_tool_get_id (BirdFontTool* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->id;
	return result;
}

gchar*
bird_font_tool_get_name (BirdFontTool* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
bird_font_tool_is_selected (BirdFontTool* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->selected;
	return result;
}

gboolean
bird_font_tool_is_over (BirdFontTool* self,
                        gdouble xp,
                        gdouble yp)
{
	gboolean _tmp0_ = FALSE;
	gdouble _tmp1_;
	gboolean r = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = xp;
	if ((self->x <= _tmp1_) && (_tmp1_ <= (self->x + self->w))) {
		gdouble _tmp2_;
		_tmp2_ = yp;
		_tmp0_ = (self->y <= _tmp2_) && (_tmp2_ <= (self->y + self->h));
	} else {
		_tmp0_ = FALSE;
	}
	r = _tmp0_;
	result = r;
	return result;
}

gboolean
bird_font_tool_set_selected (BirdFontTool* self,
                             gboolean a)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	self->new_selection = TRUE;
	self->selected = a;
	bird_font_tool_set_active (self, a);
	if (!a) {
		g_signal_emit (self, bird_font_tool_signals[BIRD_FONT_TOOL_DESELECT_ACTION_SIGNAL], 0, self);
	}
	result = TRUE;
	return result;
}

/** @return true if this tool changes state, */
gboolean
bird_font_tool_set_active (BirdFontTool* self,
                           gboolean ac)
{
	gboolean ret = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	ret = self->active != ac;
	self->active = ac;
	result = ret;
	return result;
}

static void
bird_font_tool_real_draw_tool (BirdFontTool* self,
                               cairo_t* cr,
                               gdouble px,
                               gdouble py)
{
	gdouble xt = 0.0;
	gdouble yt = 0.0;
	gdouble bgx = 0.0;
	gdouble bgy = 0.0;
	gdouble iconx = 0.0;
	gdouble icony = 0.0;
	gchar* border = NULL;
	gchar* _tmp0_;
	gchar* background = NULL;
	gchar* _tmp1_;
	gdouble scale = 0.0;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	BirdFontText* _tmp14_;
	BirdFontText* _tmp15_;
	const gchar* _tmp16_;
	BirdFontText* _tmp21_;
	BirdFontText* _tmp22_;
	BirdFontText* _tmp23_;
	g_return_if_fail (cr != NULL);
	xt = self->x - px;
	yt = self->y - py;
	_tmp0_ = g_strdup ("Button Border 3");
	border = _tmp0_;
	_tmp1_ = g_strdup ("Button Border 3");
	background = _tmp1_;
	scale = bird_font_toolbox_get_scale ();
	cairo_save (cr);
	bgx = xt;
	bgy = yt;
	if (self->selected) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = g_strdup ("Button Border 1");
		_g_free0 (border);
		border = _tmp2_;
		_tmp3_ = g_strdup ("Button Background 1");
		_g_free0 (background);
		background = _tmp3_;
	}
	if (self->selected) {
		_tmp4_ = self->active;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = g_strdup ("Button Border 2");
		_g_free0 (border);
		border = _tmp5_;
		_tmp6_ = g_strdup ("Button Background 2");
		_g_free0 (background);
		background = _tmp6_;
	}
	if (!self->selected) {
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = g_strdup ("Button Border 3");
		_g_free0 (border);
		border = _tmp7_;
		_tmp8_ = g_strdup ("Button Background 3");
		_g_free0 (background);
		background = _tmp8_;
	}
	if (!self->selected) {
		_tmp9_ = self->active;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = g_strdup ("Button Border 4");
		_g_free0 (border);
		border = _tmp10_;
		_tmp11_ = g_strdup ("Button Background 4");
		_g_free0 (background);
		background = _tmp11_;
	}
	_tmp12_ = background;
	bird_font_theme_color (cr, _tmp12_);
	bird_font_widget_draw_rounded_rectangle (cr, bgx, bgy, 34 * scale, 28 * scale, 4 * scale);
	cairo_fill (cr);
	cairo_set_line_width (cr, (gdouble) 1);
	_tmp13_ = border;
	bird_font_theme_color (cr, _tmp13_);
	bird_font_widget_draw_rounded_rectangle (cr, bgx, bgy, 34 * scale, 28 * scale, 4 * scale);
	cairo_stroke (cr);
	_tmp14_ = self->icon_font;
	iconx = ((bgx + 1) + ((self->w - 1) / 2)) - (bird_font_text_get_sidebearing_extent (_tmp14_) / 2);
	_tmp15_ = self->icon_font;
	icony = ((bgy + 1) + ((self->h - 1) / 2)) - (bird_font_widget_get_height ((BirdFontWidget*) _tmp15_) / 2);
	_tmp16_ = self->icon_color;
	if (g_strcmp0 (_tmp16_, "") == 0) {
		if (!self->selected) {
			BirdFontText* _tmp17_;
			_tmp17_ = self->icon_font;
			bird_font_theme_text_color (_tmp17_, "Tool Foreground");
		} else {
			BirdFontText* _tmp18_;
			_tmp18_ = self->icon_font;
			bird_font_theme_text_color (_tmp18_, "Selected Tool Foreground");
		}
	} else {
		BirdFontText* _tmp19_;
		const gchar* _tmp20_;
		_tmp19_ = self->icon_font;
		_tmp20_ = self->icon_color;
		bird_font_theme_text_color (_tmp19_, _tmp20_);
	}
	_tmp21_ = self->icon_font;
	((BirdFontWidget*) _tmp21_)->widget_x = iconx;
	_tmp22_ = self->icon_font;
	((BirdFontWidget*) _tmp22_)->widget_y = icony;
	_tmp23_ = self->icon_font;
	bird_font_widget_draw ((BirdFontWidget*) _tmp23_, cr);
	cairo_restore (cr);
	_g_free0 (background);
	_g_free0 (border);
}

void
bird_font_tool_draw_tool (BirdFontTool* self,
                          cairo_t* cr,
                          gdouble px,
                          gdouble py)
{
	BirdFontToolClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BIRD_FONT_TOOL_GET_CLASS (self);
	if (_klass_->draw_tool) {
		_klass_->draw_tool (self, cr, px, py);
	}
}

/** Run pending events in main loop before continuing. */
static Block71Data*
block71_data_ref (Block71Data* _data71_)
{
	g_atomic_int_inc (&_data71_->_ref_count_);
	return _data71_;
}

static void
block71_data_unref (void * _userdata_)
{
	Block71Data* _data71_;
	_data71_ = (Block71Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data71_->_ref_count_)) {
		g_slice_free (Block71Data, _data71_);
	}
}

static gboolean
___lambda221_ (Block71Data* _data71_)
{
	gboolean result;
	_data71_->timeout = TRUE;
	result = FALSE;
	return result;
}

static gboolean
____lambda221__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda221_ (self);
	return result;
}

void
bird_font_tool_yield (void)
{
	Block71Data* _data71_;
	gint t = 0;
	GSource* time = NULL;
	GSource* _tmp0_;
	GMainContext* context = NULL;
	gboolean acquired = FALSE;
	GMainContext* _tmp3_;
	GMainContext* _tmp4_;
	GMainContext* _tmp11_;
	_data71_ = g_slice_new0 (Block71Data);
	_data71_->_ref_count_ = 1;
	t = 0;
	_tmp0_ = g_timeout_source_new ((guint) 500);
	time = _tmp0_;
	if (bird_font_test_bird_font_is_slow_test ()) {
		GSource* _tmp1_;
		GSource* _tmp2_;
		_data71_->timeout = FALSE;
		_tmp1_ = time;
		g_source_set_callback (_tmp1_, ____lambda221__gsource_func, block71_data_ref (_data71_), block71_data_unref);
		_tmp2_ = time;
		g_source_attach (_tmp2_, NULL);
	} else {
		_data71_->timeout = TRUE;
	}
	_tmp3_ = g_main_context_default ();
	context = _tmp3_;
	_tmp4_ = context;
	acquired = g_main_context_acquire (_tmp4_);
	if (G_UNLIKELY (!acquired)) {
		g_warning ("Tool.vala:387: Failed to acquire main loop.\n");
		_g_source_unref0 (time);
		block71_data_unref (_data71_);
		_data71_ = NULL;
		return;
	}
	while (TRUE) {
		gboolean _tmp5_ = FALSE;
		GMainContext* _tmp6_;
		GMainContext* _tmp7_;
		gint _tmp8_;
		gboolean _tmp9_ = FALSE;
		GMainContext* _tmp10_;
		_tmp6_ = context;
		if (g_main_context_pending (_tmp6_)) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = bird_font_test_bird_font_is_slow_test ();
		}
		if (!_tmp5_) {
			break;
		}
		_tmp7_ = context;
		g_main_context_iteration (_tmp7_, TRUE);
		_tmp8_ = t;
		t = _tmp8_ + 1;
		_tmp10_ = context;
		if (!g_main_context_pending (_tmp10_)) {
			_tmp9_ = bird_font_test_bird_font_is_slow_test ();
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			if (_data71_->timeout) {
				break;
			}
		}
	}
	_tmp11_ = context;
	g_main_context_release (_tmp11_);
	_g_source_unref0 (time);
	block71_data_unref (_data71_);
	_data71_ = NULL;
}

void
bird_font_tool_set_persistent (BirdFontTool* self,
                               gboolean p)
{
	g_return_if_fail (self != NULL);
	self->persistent = p;
}

static void
bird_font_tool_real_before_undo (BirdFontTool* self)
{
}

void
bird_font_tool_before_undo (BirdFontTool* self)
{
	BirdFontToolClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BIRD_FONT_TOOL_GET_CLASS (self);
	if (_klass_->before_undo) {
		_klass_->before_undo (self);
	}
}

static void
bird_font_tool_real_after_undo (BirdFontTool* self)
{
}

void
bird_font_tool_after_undo (BirdFontTool* self)
{
	BirdFontToolClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BIRD_FONT_TOOL_GET_CLASS (self);
	if (_klass_->after_undo) {
		_klass_->after_undo (self);
	}
}

static void
g_cclosure_user_marshal_VOID__OBJECT_INT_INT_INT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_INT_INT_INT) (gpointer data1, gpointer arg_1, gint arg_2, gint arg_3, gint arg_4, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_INT_INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_INT_INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_int (param_values + 2), g_value_get_int (param_values + 3), g_value_get_int (param_values + 4), data2);
}

static void
g_cclosure_user_marshal_VOID__OBJECT_INT_INT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_INT_INT) (gpointer data1, gpointer arg_1, gint arg_2, gint arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_int (param_values + 2), g_value_get_int (param_values + 3), data2);
}

static void
g_cclosure_user_marshal_BOOLEAN__OBJECT (GClosure * closure,
                                         GValue * return_value,
                                         guint n_param_values,
                                         const GValue * param_values,
                                         gpointer invocation_hint,
                                         gpointer marshal_data)
{
	typedef gboolean (*GMarshalFunc_BOOLEAN__OBJECT) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_BOOLEAN__OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__OBJECT) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_object (param_values + 1), data2);
	g_value_set_boolean (return_value, v_return);
}

static void
g_cclosure_user_marshal_VOID__OBJECT_UINT (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_UINT) (gpointer data1, gpointer arg_1, guint32 arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_uint (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_VOID__OBJECT_UINT_DOUBLE_DOUBLE (GClosure * closure,
                                                         GValue * return_value,
                                                         guint n_param_values,
                                                         const GValue * param_values,
                                                         gpointer invocation_hint,
                                                         gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_UINT_DOUBLE_DOUBLE) (gpointer data1, gpointer arg_1, guint arg_2, gdouble arg_3, gdouble arg_4, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_UINT_DOUBLE_DOUBLE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_UINT_DOUBLE_DOUBLE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_double (param_values + 3), g_value_get_double (param_values + 4), data2);
}

static void
g_cclosure_user_marshal_BOOLEAN__OBJECT_DOUBLE_DOUBLE (GClosure * closure,
                                                       GValue * return_value,
                                                       guint n_param_values,
                                                       const GValue * param_values,
                                                       gpointer invocation_hint,
                                                       gpointer marshal_data)
{
	typedef gboolean (*GMarshalFunc_BOOLEAN__OBJECT_DOUBLE_DOUBLE) (gpointer data1, gpointer arg_1, gdouble arg_2, gdouble arg_3, gpointer data2);
	register GMarshalFunc_BOOLEAN__OBJECT_DOUBLE_DOUBLE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__OBJECT_DOUBLE_DOUBLE) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_object (param_values + 1), g_value_get_double (param_values + 2), g_value_get_double (param_values + 3), data2);
	g_value_set_boolean (return_value, v_return);
}

static void
g_cclosure_user_marshal_VOID__OBJECT_BOXED_OBJECT (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_BOXED_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_BOXED_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_BOXED_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_boxed (param_values + 2), g_value_get_object (param_values + 3), data2);
}

static void
bird_font_tool_class_init (BirdFontToolClass * klass,
                           gpointer klass_data)
{
	BirdFontTool* _tmp0_;
	bird_font_tool_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontTool_private_offset);
	((BirdFontToolClass *) klass)->get_tip = (gchar* (*) (BirdFontTool*)) bird_font_tool_real_get_tip;
	((BirdFontWidgetClass *) klass)->draw = (void (*) (BirdFontWidget*, cairo_t*)) bird_font_tool_real_draw;
	((BirdFontWidgetClass *) klass)->get_height = (gdouble (*) (BirdFontWidget*)) bird_font_tool_real_get_height;
	((BirdFontWidgetClass *) klass)->get_width = (gdouble (*) (BirdFontWidget*)) bird_font_tool_real_get_width;
	((BirdFontToolClass *) klass)->draw_tool = (void (*) (BirdFontTool*, cairo_t*, gdouble, gdouble)) bird_font_tool_real_draw_tool;
	((BirdFontToolClass *) klass)->before_undo = (void (*) (BirdFontTool*)) bird_font_tool_real_before_undo;
	((BirdFontToolClass *) klass)->after_undo = (void (*) (BirdFontTool*)) bird_font_tool_real_after_undo;
	G_OBJECT_CLASS (klass)->finalize = bird_font_tool_finalize;
	bird_font_tool_signals[BIRD_FONT_TOOL_SELECT_ACTION_SIGNAL] = g_signal_new ("select-action", BIRD_FONT_TYPE_TOOL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, BIRD_FONT_TYPE_TOOL);
	bird_font_tool_signals[BIRD_FONT_TOOL_DESELECT_ACTION_SIGNAL] = g_signal_new ("deselect-action", BIRD_FONT_TYPE_TOOL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, BIRD_FONT_TYPE_TOOL);
	bird_font_tool_signals[BIRD_FONT_TOOL_PRESS_ACTION_SIGNAL] = g_signal_new ("press-action", BIRD_FONT_TYPE_TOOL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_INT_INT_INT, G_TYPE_NONE, 4, BIRD_FONT_TYPE_TOOL, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT);
	bird_font_tool_signals[BIRD_FONT_TOOL_DOUBLE_CLICK_ACTION_SIGNAL] = g_signal_new ("double-click-action", BIRD_FONT_TYPE_TOOL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_INT_INT_INT, G_TYPE_NONE, 4, BIRD_FONT_TYPE_TOOL, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT);
	bird_font_tool_signals[BIRD_FONT_TOOL_MOVE_ACTION_SIGNAL] = g_signal_new ("move-action", BIRD_FONT_TYPE_TOOL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_INT_INT, G_TYPE_NONE, 3, BIRD_FONT_TYPE_TOOL, G_TYPE_INT, G_TYPE_INT);
	bird_font_tool_signals[BIRD_FONT_TOOL_MOVE_OUT_ACTION_SIGNAL] = g_signal_new ("move-out-action", BIRD_FONT_TYPE_TOOL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, BIRD_FONT_TYPE_TOOL);
	bird_font_tool_signals[BIRD_FONT_TOOL_RELEASE_ACTION_SIGNAL] = g_signal_new ("release-action", BIRD_FONT_TYPE_TOOL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_INT_INT_INT, G_TYPE_NONE, 4, BIRD_FONT_TYPE_TOOL, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT);
	/** Returns true if tool is listening for scroll wheel actions. */
	bird_font_tool_signals[BIRD_FONT_TOOL_SCROLL_WHEEL_UP_ACTION_SIGNAL] = g_signal_new ("scroll-wheel-up-action", BIRD_FONT_TYPE_TOOL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__OBJECT, G_TYPE_BOOLEAN, 1, BIRD_FONT_TYPE_TOOL);
	bird_font_tool_signals[BIRD_FONT_TOOL_SCROLL_WHEEL_DOWN_ACTION_SIGNAL] = g_signal_new ("scroll-wheel-down-action", BIRD_FONT_TYPE_TOOL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__OBJECT, G_TYPE_BOOLEAN, 1, BIRD_FONT_TYPE_TOOL);
	bird_font_tool_signals[BIRD_FONT_TOOL_KEY_PRESS_ACTION_SIGNAL] = g_signal_new ("key-press-action", BIRD_FONT_TYPE_TOOL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_UINT, G_TYPE_NONE, 2, BIRD_FONT_TYPE_TOOL, G_TYPE_UINT);
	bird_font_tool_signals[BIRD_FONT_TOOL_KEY_RELEASE_ACTION_SIGNAL] = g_signal_new ("key-release-action", BIRD_FONT_TYPE_TOOL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_UINT, G_TYPE_NONE, 2, BIRD_FONT_TYPE_TOOL, G_TYPE_UINT);
	bird_font_tool_signals[BIRD_FONT_TOOL_PANEL_PRESS_ACTION_SIGNAL] = g_signal_new ("panel-press-action", BIRD_FONT_TYPE_TOOL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_UINT_DOUBLE_DOUBLE, G_TYPE_NONE, 4, BIRD_FONT_TYPE_TOOL, G_TYPE_UINT, G_TYPE_DOUBLE, G_TYPE_DOUBLE);
	bird_font_tool_signals[BIRD_FONT_TOOL_PANEL_RELEASE_ACTION_SIGNAL] = g_signal_new ("panel-release-action", BIRD_FONT_TYPE_TOOL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_UINT_DOUBLE_DOUBLE, G_TYPE_NONE, 4, BIRD_FONT_TYPE_TOOL, G_TYPE_UINT, G_TYPE_DOUBLE, G_TYPE_DOUBLE);
	bird_font_tool_signals[BIRD_FONT_TOOL_PANEL_DOUBLE_CLICK_ACTION_SIGNAL] = g_signal_new ("panel-double-click-action", BIRD_FONT_TYPE_TOOL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_UINT_DOUBLE_DOUBLE, G_TYPE_NONE, 4, BIRD_FONT_TYPE_TOOL, G_TYPE_UINT, G_TYPE_DOUBLE, G_TYPE_DOUBLE);
	/** @return true is event is consumed. */
	bird_font_tool_signals[BIRD_FONT_TOOL_PANEL_MOVE_ACTION_SIGNAL] = g_signal_new ("panel-move-action", BIRD_FONT_TYPE_TOOL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__OBJECT_DOUBLE_DOUBLE, G_TYPE_BOOLEAN, 3, BIRD_FONT_TYPE_TOOL, G_TYPE_DOUBLE, G_TYPE_DOUBLE);
	bird_font_tool_signals[BIRD_FONT_TOOL_DRAW_ACTION_SIGNAL] = g_signal_new ("draw-action", BIRD_FONT_TYPE_TOOL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_BOXED_OBJECT, G_TYPE_NONE, 3, BIRD_FONT_TYPE_TOOL, cairo_gobject_context_get_type (), BIRD_FONT_TYPE_GLYPH);
	bird_font_tool_signals[BIRD_FONT_TOOL_REDRAW_TOOL_SIGNAL] = g_signal_new ("redraw-tool", BIRD_FONT_TYPE_TOOL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = bird_font_tool_new (NULL, "");
	bird_font_tool_active_tooltip = _tmp0_;
}

static void
bird_font_tool_instance_init (BirdFontTool * self,
                              gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	self->priv = bird_font_tool_get_instance_private (self);
	self->x = (gdouble) 0;
	self->y = (gdouble) 0;
	self->active = FALSE;
	self->selected = FALSE;
	_tmp0_ = g_strdup ("");
	self->name = _tmp0_;
	self->new_selection = FALSE;
	self->priv->show_bg = TRUE;
	_tmp1_ = g_strdup ("");
	self->tip = _tmp1_;
	self->persistent = FALSE;
	self->editor_events = FALSE;
	self->priv->waiting_for_tooltip = FALSE;
	self->priv->showing_this_tooltip = FALSE;
	self->visible = TRUE;
	self->is_tool_modifier = FALSE;
	_tmp2_ = g_strdup ("");
	self->icon_color = _tmp2_;
}

static void
bird_font_tool_finalize (GObject * obj)
{
	BirdFontTool * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_TOOL, BirdFontTool);
	_g_object_unref0 (self->icon_font);
	_g_free0 (self->name);
	_g_free0 (self->tip);
	_g_free0 (self->icon_color);
	G_OBJECT_CLASS (bird_font_tool_parent_class)->finalize (obj);
}

static GType
bird_font_tool_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontToolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_tool_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontTool), 0, (GInstanceInitFunc) bird_font_tool_instance_init, NULL };
	GType bird_font_tool_type_id;
	bird_font_tool_type_id = g_type_register_static (BIRD_FONT_TYPE_WIDGET, "BirdFontTool", &g_define_type_info, 0);
	BirdFontTool_private_offset = g_type_add_instance_private (bird_font_tool_type_id, sizeof (BirdFontToolPrivate));
	return bird_font_tool_type_id;
}

GType
bird_font_tool_get_type (void)
{
	static volatile gsize bird_font_tool_type_id__once = 0;
	if (g_once_init_enter (&bird_font_tool_type_id__once)) {
		GType bird_font_tool_type_id;
		bird_font_tool_type_id = bird_font_tool_get_type_once ();
		g_once_init_leave (&bird_font_tool_type_id__once, bird_font_tool_type_id);
	}
	return bird_font_tool_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

