/* StrokeTool.c generated by valac 0.56.17, the Vala compiler
 * generated from StrokeTool.vala, do not modify */

/*
Copyright (C) 2014 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <birdgems.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_STROKE_TOOL_0_PROPERTY,
	BIRD_FONT_STROKE_TOOL_NUM_PROPERTIES
};
static GParamSpec* bird_font_stroke_tool_properties[BIRD_FONT_STROKE_TOOL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block63Data Block63Data;
typedef struct _Block64Data Block64Data;
#define _bird_font_color_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_color_unref (var), NULL)))
typedef struct _Block65Data Block65Data;

struct _BirdFontStrokeToolPrivate {
	BirdFontStrokeTask* task;
};

struct _Block63Data {
	int _ref_count_;
	BirdFontStrokeTool* self;
	gboolean intersection;
	BirdFontPath* path;
};

struct _Block64Data {
	int _ref_count_;
	BirdFontStrokeTool* self;
	gboolean intersection;
	BirdFontPath* path;
	gboolean only_offsets;
};

struct _Block65Data {
	int _ref_count_;
	BirdFontStrokeTool* self;
	gboolean intersection;
	BirdFontPath* path2;
};

static gint BirdFontStrokeTool_private_offset;
static gpointer bird_font_stroke_tool_parent_class = NULL;
gdouble bird_font_stroke_tool_stroke_width = (gdouble) 0;
gboolean bird_font_stroke_tool_add_stroke = FALSE;
gboolean bird_font_stroke_tool_show_stroke_tools = FALSE;
gboolean bird_font_stroke_tool_convert_stroke = FALSE;
BirdFontLineCap bird_font_stroke_tool_line_cap = BIRD_FONT_LINE_CAP_BUTT;

static BirdFontPathList* bird_font_stroke_tool_get_all_parts (BirdFontStrokeTool* self,
                                                       BirdFontPathList* pl);
static BirdFontPathList* bird_font_stroke_tool_remove_intersection_paths (BirdFontStrokeTool* self,
                                                                   BirdFontPathList* pl);
static BirdFontPath* bird_font_stroke_tool_simplify_stroke (BirdFontStrokeTool* self,
                                                     BirdFontPath* p);
static void bird_font_stroke_tool_reset_flags (BirdFontStrokeTool* self,
                                        BirdFontPathList* o);
static void bird_font_stroke_tool_remove_single_point_intersections (BirdFontStrokeTool* self,
                                                              BirdFontPath* p);
static BirdFontPathList* bird_font_stroke_tool_remove_overlap (BirdFontStrokeTool* self,
                                                        BirdFontPathList* pl,
                                                        gboolean* _error_);
static void bird_font_stroke_tool_remove_merged_curve_parts (BirdFontStrokeTool* self,
                                                      BirdFontPathList* r);
static void bird_font_stroke_tool_add_double_point_at_intersection (BirdFontStrokeTool* self,
                                                             BirdFontPath* pp,
                                                             BirdFontEditPoint* lep,
                                                             BirdFontEditPoint* ep);
static BirdFontPathList* bird_font_stroke_tool_remove_self_intersections (BirdFontStrokeTool* self,
                                                                   BirdFontPath* original,
                                                                   gboolean* _error_);
static BirdFontPathList* bird_font_stroke_tool_merge_paths_with_curves (BirdFontStrokeTool* self,
                                                                 BirdFontPath* path1,
                                                                 BirdFontPath* path2);
static void bird_font_stroke_tool_reset_intersections (BirdFontStrokeTool* self,
                                                BirdFontPath* p);
static gint bird_font_stroke_tool_index_of (BirdFontStrokeTool* self,
                                     BirdFontPath* p,
                                     BirdFontEditPoint* ep);
static gboolean bird_font_stroke_tool_has_new_corner (BirdFontStrokeTool* self,
                                               BirdFontPath* p);
static void bird_font_stroke_tool_add_line_cap (BirdFontStrokeTool* self,
                                         BirdFontPath* path,
                                         BirdFontPath* stroke1,
                                         BirdFontPath* stroke2,
                                         gboolean last_cap);
static void bird_font_stroke_tool_add_square_cap (BirdFontStrokeTool* self,
                                           BirdFontPath* path,
                                           BirdFontPath* stroke1,
                                           BirdFontPath* stroke2,
                                           gboolean last_cap);
static void bird_font_stroke_tool_add_round_cap (BirdFontStrokeTool* self,
                                          BirdFontPath* path,
                                          BirdFontPath* stroke1,
                                          BirdFontPath* stroke2,
                                          gboolean last_cap);
static BirdFontPath* bird_font_stroke_tool_merge_strokes (BirdFontStrokeTool* self,
                                                   BirdFontPath* path,
                                                   BirdFontPath* stroke,
                                                   BirdFontPath* counter);
static void bird_font_stroke_tool_add_corner (BirdFontStrokeTool* self,
                                       BirdFontPath* stroked,
                                       BirdFontEditPoint* previous,
                                       BirdFontEditPoint* next,
                                       BirdFontEditPoint* original,
                                       gdouble stroke_width);
static BirdFontPathList* bird_font_stroke_tool_get_parts (BirdFontStrokeTool* self,
                                                   BirdFontPath* path);
static BirdFontPathList* bird_font_stroke_tool_get_parts_self (BirdFontStrokeTool* self,
                                                        BirdFontPath* path,
                                                        BirdFontPathList* paths);
static BirdFontPathList* bird_font_stroke_tool_split (BirdFontStrokeTool* self,
                                               BirdFontPath* path);
static gboolean bird_font_stroke_tool_has_self_intersection (BirdFontStrokeTool* self,
                                                      BirdFontPath* path);
static gboolean bird_font_stroke_tool_has_intersection_points (BirdFontStrokeTool* self,
                                                        BirdFontPath* path);
static gboolean bird_font_stroke_tool_add_self_intersection_points (BirdFontStrokeTool* self,
                                                             BirdFontPath* path,
                                                             gboolean only_offsets);
static gint bird_font_stroke_tool_mark_intersection_as_deleted (BirdFontStrokeTool* self,
                                                         BirdFontPath* path);
static BirdFontPathList* bird_font_stroke_tool_get_remaining_points (BirdFontStrokeTool* self,
                                                              BirdFontPath* old_path);
static BirdFontPathList* bird_font_stroke_tool_process_deleted_control_points (BirdFontStrokeTool* self,
                                                                        BirdFontPath* path);
static Block63Data* block63_data_ref (Block63Data* _data63_);
static void block63_data_unref (void * _userdata_);
static gboolean __lambda31_ (Block63Data* _data63_,
                      BirdFontEditPoint* ep1,
                      BirdFontEditPoint* ep2);
static gboolean bird_font_stroke_tool_segment_intersects (BirdFontStrokeTool* self,
                                                   BirdFontPath* path,
                                                   BirdFontEditPoint* ep,
                                                   BirdFontEditPoint* next,
                                                   gdouble* ix,
                                                   gdouble* iy,
                                                   BirdFontEditPoint** ia,
                                                   BirdFontEditPoint** ib,
                                                   gboolean skip_points_on_points,
                                                   gboolean only_offsets);
static gboolean ___lambda31__bird_font_path_segment_iterator (BirdFontEditPoint* start,
                                                       BirdFontEditPoint* stop,
                                                       gpointer self);
static Block64Data* block64_data_ref (Block64Data* _data64_);
static void block64_data_unref (void * _userdata_);
static gboolean __lambda32_ (Block64Data* _data64_,
                      BirdFontEditPoint* ep1,
                      BirdFontEditPoint* ep2);
static BirdFontEditPoint* bird_font_stroke_tool_add_intersection (BirdFontStrokeTool* self,
                                                           BirdFontPath* path,
                                                           BirdFontEditPoint* prev,
                                                           BirdFontEditPoint* next,
                                                           gdouble px,
                                                           gdouble py,
                                                           BirdFontColor* c);
static gboolean ___lambda32__bird_font_path_segment_iterator (BirdFontEditPoint* start,
                                                       BirdFontEditPoint* stop,
                                                       gpointer self);
static gboolean bird_font_stroke_tool_segments_intersects (BirdFontStrokeTool* self,
                                                    BirdFontEditPoint* p1,
                                                    BirdFontEditPoint* p2,
                                                    BirdFontEditPoint* ep,
                                                    BirdFontEditPoint* next,
                                                    gdouble* ix,
                                                    gdouble* iy,
                                                    gboolean skip_points_on_points);
static gboolean bird_font_stroke_tool_is_line (BirdFontStrokeTool* self,
                                        gdouble x1,
                                        gdouble y1,
                                        gdouble x2,
                                        gdouble y2,
                                        gdouble x3,
                                        gdouble y3,
                                        gdouble tolerance);
static gboolean bird_font_stroke_tool_is_inside_of_path (BirdFontStrokeTool* self,
                                                  BirdFontPointSelection* ps,
                                                  BirdFontPathList* pl,
                                                  BirdFontPath** outline);
static void bird_font_stroke_tool_remove_single_points (BirdFontStrokeTool* self,
                                                 BirdFontPathList* pl);
static gboolean bird_font_stroke_tool_paths_has_intersection (BirdFontStrokeTool* self,
                                                       BirdFontPathList* r,
                                                       BirdFontPath** path1,
                                                       BirdFontPath** path2);
static gboolean bird_font_stroke_tool_merge_path (BirdFontStrokeTool* self,
                                           BirdFontPath* path1,
                                           BirdFontPath* path2,
                                           BirdFontPathList** merged_paths,
                                           gboolean* _error_);
static void bird_font_stroke_tool_remove_merged_parts (BirdFontStrokeTool* self,
                                                BirdFontPathList* r);
static gboolean bird_font_stroke_tool_is_clockwise (BirdFontStrokeTool* self,
                                             BirdFontPath* p);
static gboolean bird_font_stroke_tool_has_intersection (BirdFontStrokeTool* self,
                                                 BirdFontPath* path1,
                                                 BirdFontPath* path2);
static Block65Data* block65_data_ref (Block65Data* _data65_);
static void block65_data_unref (void * _userdata_);
static gboolean __lambda33_ (Block65Data* _data65_,
                      BirdFontEditPoint* ep1,
                      BirdFontEditPoint* ep2);
static gboolean ___lambda33__bird_font_path_segment_iterator (BirdFontEditPoint* start,
                                                       BirdFontEditPoint* stop,
                                                       gpointer self);
static void bird_font_stroke_tool_convert_to_curve (BirdFontStrokeTool* self,
                                             BirdFontPath* path);
static void bird_font_stroke_tool_finalize (GObject * obj);
static GType bird_font_stroke_tool_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GType
bird_font_line_cap_get_type_once (void)
{
	static const GEnumValue values[] = {{BIRD_FONT_LINE_CAP_BUTT, "BIRD_FONT_LINE_CAP_BUTT", "butt"}, {BIRD_FONT_LINE_CAP_SQUARE, "BIRD_FONT_LINE_CAP_SQUARE", "square"}, {BIRD_FONT_LINE_CAP_ROUND, "BIRD_FONT_LINE_CAP_ROUND", "round"}, {0, NULL, NULL}};
	GType bird_font_line_cap_type_id;
	bird_font_line_cap_type_id = g_enum_register_static ("BirdFontLineCap", values);
	return bird_font_line_cap_type_id;
}

GType
bird_font_line_cap_get_type (void)
{
	static volatile gsize bird_font_line_cap_type_id__once = 0;
	if (g_once_init_enter (&bird_font_line_cap_type_id__once)) {
		GType bird_font_line_cap_type_id;
		bird_font_line_cap_type_id = bird_font_line_cap_get_type_once ();
		g_once_init_leave (&bird_font_line_cap_type_id__once, bird_font_line_cap_type_id);
	}
	return bird_font_line_cap_type_id__once;
}

static inline gpointer
bird_font_stroke_tool_get_instance_private (BirdFontStrokeTool* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontStrokeTool_private_offset);
}

BirdFontStrokeTool*
bird_font_stroke_tool_construct (GType object_type)
{
	BirdFontStrokeTool * self = NULL;
	BirdFontStrokeTask* _tmp0_;
	self = (BirdFontStrokeTool*) g_object_new (object_type, NULL);
	_tmp0_ = bird_font_stroke_task_new_none ();
	_g_object_unref0 (self->priv->task);
	self->priv->task = _tmp0_;
	return self;
}

BirdFontStrokeTool*
bird_font_stroke_tool_new (void)
{
	return bird_font_stroke_tool_construct (BIRD_FONT_TYPE_STROKE_TOOL);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BirdFontStrokeTool*
bird_font_stroke_tool_construct_with_task (GType object_type,
                                           BirdFontStrokeTask* cancelable_task)
{
	BirdFontStrokeTool * self = NULL;
	BirdFontStrokeTask* _tmp0_;
	g_return_val_if_fail (cancelable_task != NULL, NULL);
	self = (BirdFontStrokeTool*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (cancelable_task);
	_g_object_unref0 (self->priv->task);
	self->priv->task = _tmp0_;
	return self;
}

BirdFontStrokeTool*
bird_font_stroke_tool_new_with_task (BirdFontStrokeTask* cancelable_task)
{
	return bird_font_stroke_tool_construct_with_task (BIRD_FONT_TYPE_STROKE_TOOL, cancelable_task);
}

/** Create strokes for the selected outlines. */
void
bird_font_stroke_tool_stroke_selected_paths (BirdFontStrokeTool* self)
{
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp0_;
	BirdFontPathList* paths = NULL;
	BirdFontPathList* _tmp1_;
	BirdFontGlyph* _tmp2_;
	BirdFontPathList* _tmp19_;
	GeeArrayList* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	g = _tmp0_;
	_tmp1_ = bird_font_path_list_new ();
	paths = _tmp1_;
	bird_font_stroke_tool_convert_stroke = TRUE;
	_tmp2_ = g;
	bird_font_glyph_store_undo_state (_tmp2_, FALSE);
	{
		GeeArrayList* _p_list = NULL;
		BirdFontGlyph* _tmp3_;
		GeeArrayList* _tmp4_;
		gint _p_size = 0;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _p_index = 0;
		_tmp3_ = g;
		_tmp4_ = _tmp3_->active_paths;
		_p_list = _tmp4_;
		_tmp5_ = _p_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_p_size = _tmp7_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp10_;
			gpointer _tmp11_;
			BirdFontPath* _tmp12_;
			gdouble _tmp13_;
			gdouble _tmp14_;
			_p_index = _p_index + 1;
			_tmp8_ = _p_index;
			_tmp9_ = _p_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _p_list;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _p_index);
			p = (BirdFontPath*) _tmp11_;
			_tmp12_ = p;
			_tmp13_ = bird_font_path_get_stroke (_tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_ > ((gdouble) 0)) {
				BirdFontPathList* _tmp15_;
				BirdFontPath* _tmp16_;
				BirdFontPathList* _tmp17_;
				BirdFontPathList* _tmp18_;
				_tmp15_ = paths;
				_tmp16_ = p;
				_tmp17_ = bird_font_path_get_completed_stroke (_tmp16_);
				_tmp18_ = _tmp17_;
				bird_font_path_list_append (_tmp15_, _tmp18_);
				_g_object_unref0 (_tmp18_);
			}
			_g_object_unref0 (p);
		}
	}
	_tmp19_ = paths;
	_tmp20_ = _tmp19_->paths;
	_tmp21_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp20_);
	_tmp22_ = _tmp21_;
	if (_tmp22_ > 0) {
		BirdFontGlyph* _tmp35_;
		GeeArrayList* _tmp36_;
		{
			GeeArrayList* _p_list = NULL;
			BirdFontGlyph* _tmp23_;
			GeeArrayList* _tmp24_;
			gint _p_size = 0;
			GeeArrayList* _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			gint _p_index = 0;
			_tmp23_ = g;
			_tmp24_ = _tmp23_->active_paths;
			_p_list = _tmp24_;
			_tmp25_ = _p_list;
			_tmp26_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp25_);
			_tmp27_ = _tmp26_;
			_p_size = _tmp27_;
			_p_index = -1;
			while (TRUE) {
				gint _tmp28_;
				gint _tmp29_;
				BirdFontPath* p = NULL;
				GeeArrayList* _tmp30_;
				gpointer _tmp31_;
				BirdFontGlyph* _tmp32_;
				BirdFontLayer* _tmp33_;
				BirdFontPath* _tmp34_;
				_p_index = _p_index + 1;
				_tmp28_ = _p_index;
				_tmp29_ = _p_size;
				if (!(_tmp28_ < _tmp29_)) {
					break;
				}
				_tmp30_ = _p_list;
				_tmp31_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, _p_index);
				p = (BirdFontPath*) _tmp31_;
				_tmp32_ = g;
				_tmp33_ = _tmp32_->layers;
				_tmp34_ = p;
				bird_font_layer_remove_path (_tmp33_, _tmp34_);
				_g_object_unref0 (p);
			}
		}
		_tmp35_ = g;
		_tmp36_ = _tmp35_->active_paths;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp36_);
		{
			GeeArrayList* _np_list = NULL;
			BirdFontPathList* _tmp37_;
			GeeArrayList* _tmp38_;
			gint _np_size = 0;
			GeeArrayList* _tmp39_;
			gint _tmp40_;
			gint _tmp41_;
			gint _np_index = 0;
			_tmp37_ = paths;
			_tmp38_ = _tmp37_->paths;
			_np_list = _tmp38_;
			_tmp39_ = _np_list;
			_tmp40_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp39_);
			_tmp41_ = _tmp40_;
			_np_size = _tmp41_;
			_np_index = -1;
			while (TRUE) {
				gint _tmp42_;
				gint _tmp43_;
				BirdFontPath* np = NULL;
				GeeArrayList* _tmp44_;
				gpointer _tmp45_;
				BirdFontGlyph* _tmp46_;
				BirdFontPath* _tmp47_;
				BirdFontGlyph* _tmp48_;
				GeeArrayList* _tmp49_;
				BirdFontPath* _tmp50_;
				_np_index = _np_index + 1;
				_tmp42_ = _np_index;
				_tmp43_ = _np_size;
				if (!(_tmp42_ < _tmp43_)) {
					break;
				}
				_tmp44_ = _np_list;
				_tmp45_ = gee_abstract_list_get ((GeeAbstractList*) _tmp44_, _np_index);
				np = (BirdFontPath*) _tmp45_;
				_tmp46_ = g;
				_tmp47_ = np;
				bird_font_glyph_add_path (_tmp46_, _tmp47_);
				_tmp48_ = g;
				_tmp49_ = _tmp48_->active_paths;
				_tmp50_ = np;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp49_, _tmp50_);
				_g_object_unref0 (np);
			}
		}
		bird_font_pen_tool_update_orientation ();
		bird_font_glyph_canvas_redraw ();
	}
	bird_font_pen_tool_update_orientation ();
	bird_font_stroke_tool_convert_stroke = FALSE;
	_g_object_unref0 (paths);
	_g_object_unref0 (g);
}

BirdFontPathList*
bird_font_stroke_tool_get_stroke_fast (BirdFontStrokeTool* self,
                                       BirdFontPath* path,
                                       gdouble thickness)
{
	BirdFontPathList* o = NULL;
	BirdFontPath* stroke = NULL;
	BirdFontStrokeTool* s = NULL;
	BirdFontStrokeTool* _tmp0_;
	BirdFontPath* _tmp1_;
	BirdFontPathList* _tmp2_;
	BirdFontPathList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = bird_font_stroke_tool_new ();
	s = _tmp0_;
	_tmp1_ = bird_font_path_copy (path);
	_g_object_unref0 (stroke);
	stroke = _tmp1_;
	bird_font_path_remove_points_on_points (stroke, 0.1);
	_tmp2_ = bird_font_stroke_tool_create_stroke (s, stroke, thickness);
	_g_object_unref0 (o);
	o = _tmp2_;
	result = o;
	_g_object_unref0 (s);
	_g_object_unref0 (stroke);
	return result;
}

BirdFontPathList*
bird_font_stroke_tool_get_stroke (BirdFontStrokeTool* self,
                                  BirdFontPath* path,
                                  gdouble thickness)
{
	BirdFontPathList* o = NULL;
	BirdFontPathList* m = NULL;
	BirdFontPath* stroke = NULL;
	BirdFontStrokeTask* _tmp0_;
	BirdFontPath* _tmp2_;
	BirdFontPath* _tmp3_;
	BirdFontPath* _tmp4_;
	BirdFontPathList* _tmp5_;
	BirdFontPathList* _tmp6_;
	BirdFontPathList* _tmp7_;
	BirdFontPathList* _tmp8_;
	BirdFontPathList* _tmp9_;
	BirdFontPathList* _tmp10_;
	BirdFontPathList* _tmp11_;
	BirdFontPathList* _tmp12_;
	BirdFontPathList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = self->priv->task;
	if (bird_font_task_is_cancelled ((BirdFontTask*) _tmp0_)) {
		BirdFontPathList* _tmp1_;
		_tmp1_ = bird_font_path_list_new ();
		result = _tmp1_;
		_g_object_unref0 (stroke);
		_g_object_unref0 (m);
		_g_object_unref0 (o);
		return result;
	}
	_tmp2_ = bird_font_path_copy (path);
	_g_object_unref0 (stroke);
	stroke = _tmp2_;
	_tmp3_ = stroke;
	bird_font_path_remove_points_on_points (_tmp3_, 0.1);
	_tmp4_ = stroke;
	_tmp5_ = bird_font_stroke_tool_create_stroke (self, _tmp4_, thickness);
	_g_object_unref0 (o);
	o = _tmp5_;
	_tmp6_ = o;
	_tmp7_ = bird_font_stroke_tool_get_all_parts (self, _tmp6_);
	_g_object_unref0 (o);
	o = _tmp7_;
	_tmp8_ = o;
	_tmp9_ = bird_font_stroke_tool_remove_intersection_paths (self, _tmp8_);
	_g_object_unref0 (o);
	o = _tmp9_;
	_tmp10_ = o;
	_tmp11_ = bird_font_stroke_tool_merge (self, _tmp10_);
	_g_object_unref0 (o);
	o = _tmp11_;
	_tmp12_ = bird_font_path_list_new ();
	_g_object_unref0 (m);
	m = _tmp12_;
	{
		GeeArrayList* _p_list = NULL;
		BirdFontPathList* _tmp13_;
		GeeArrayList* _tmp14_;
		gint _p_size = 0;
		GeeArrayList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _p_index = 0;
		_tmp13_ = o;
		_tmp14_ = _tmp13_->paths;
		_p_list = _tmp14_;
		_tmp15_ = _p_list;
		_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_p_size = _tmp17_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp20_;
			gpointer _tmp21_;
			BirdFontPathList* _tmp22_;
			BirdFontPath* _tmp23_;
			BirdFontPath* _tmp24_;
			BirdFontPath* _tmp25_;
			_p_index = _p_index + 1;
			_tmp18_ = _p_index;
			_tmp19_ = _p_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _p_list;
			_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _p_index);
			p = (BirdFontPath*) _tmp21_;
			_tmp22_ = m;
			_tmp23_ = p;
			_tmp24_ = bird_font_stroke_tool_simplify_stroke (self, _tmp23_);
			_tmp25_ = _tmp24_;
			bird_font_path_list_add (_tmp22_, _tmp25_);
			_g_object_unref0 (_tmp25_);
			_g_object_unref0 (p);
		}
	}
	result = m;
	_g_object_unref0 (stroke);
	_g_object_unref0 (o);
	return result;
}

static void
bird_font_stroke_tool_reset_flags (BirdFontStrokeTool* self,
                                   BirdFontPathList* o)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp0_;
		gint _p_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p_index = 0;
		_tmp0_ = o->paths;
		_p_list = _tmp0_;
		_tmp1_ = _p_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p_size = _tmp3_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontPath* _tmp20_;
			_p_index = _p_index + 1;
			_tmp4_ = _p_index;
			_tmp5_ = _p_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _p_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _p_index);
			p = (BirdFontPath*) _tmp7_;
			{
				GeeArrayList* _ep_list = NULL;
				BirdFontPath* _tmp8_;
				GeeArrayList* _tmp9_;
				GeeArrayList* _tmp10_;
				gint _ep_size = 0;
				GeeArrayList* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				gint _ep_index = 0;
				_tmp8_ = p;
				_tmp9_ = bird_font_path_get_points (_tmp8_);
				_tmp10_ = _tmp9_;
				_ep_list = _tmp10_;
				_tmp11_ = _ep_list;
				_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
				_tmp13_ = _tmp12_;
				_ep_size = _tmp13_;
				_ep_index = -1;
				while (TRUE) {
					gint _tmp14_;
					gint _tmp15_;
					BirdFontEditPoint* ep = NULL;
					GeeArrayList* _tmp16_;
					gpointer _tmp17_;
					BirdFontEditPoint* _tmp18_;
					BirdFontEditPoint* _tmp19_;
					_ep_index = _ep_index + 1;
					_tmp14_ = _ep_index;
					_tmp15_ = _ep_size;
					if (!(_tmp14_ < _tmp15_)) {
						break;
					}
					_tmp16_ = _ep_list;
					_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _ep_index);
					ep = (BirdFontEditPoint*) _tmp17_;
					_tmp18_ = ep;
					_tmp19_ = ep;
					_tmp19_->flags = _tmp19_->flags & (~(((BIRD_FONT_EDIT_POINT_INTERSECTION | BIRD_FONT_EDIT_POINT_COPIED) | BIRD_FONT_EDIT_POINT_NEW_CORNER) | BIRD_FONT_EDIT_POINT_SELF_INTERSECTION));
					_g_object_unref0 (ep);
				}
			}
			_tmp20_ = p;
			bird_font_path_update_region_boundaries (_tmp20_);
			_g_object_unref0 (p);
		}
	}
}

void
bird_font_stroke_tool_merge_selected_paths (BirdFontStrokeTool* self)
{
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp0_;
	BirdFontPathList* o = NULL;
	BirdFontPathList* _tmp1_;
	BirdFontPathList* r = NULL;
	BirdFontPathList* new_paths = NULL;
	BirdFontPathList* _tmp2_;
	gboolean _error_ = FALSE;
	BirdFontGlyph* _tmp3_;
	BirdFontPathList* _tmp33_;
	gboolean _tmp34_ = FALSE;
	BirdFontPathList* _tmp35_;
	BirdFontPathList* _tmp36_;
	BirdFontPathList* _tmp37_;
	BirdFontPathList* _tmp38_;
	BirdFontStrokeTask* _tmp86_;
	BirdFontGlyph* _tmp98_;
	BirdFontPathList* _tmp99_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	g = _tmp0_;
	_tmp1_ = bird_font_path_list_new ();
	o = _tmp1_;
	_tmp2_ = bird_font_path_list_new ();
	new_paths = _tmp2_;
	_error_ = FALSE;
	_tmp3_ = g;
	bird_font_glyph_store_undo_state (_tmp3_, FALSE);
	{
		GeeArrayList* _p_list = NULL;
		BirdFontGlyph* _tmp4_;
		GeeArrayList* _tmp5_;
		gint _p_size = 0;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _p_index = 0;
		_tmp4_ = g;
		_tmp5_ = _tmp4_->active_paths;
		_p_list = _tmp5_;
		_tmp6_ = _p_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_p_size = _tmp8_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp11_;
			gpointer _tmp12_;
			BirdFontPath* _tmp13_;
			gdouble _tmp14_;
			gdouble _tmp15_;
			_p_index = _p_index + 1;
			_tmp9_ = _p_index;
			_tmp10_ = _p_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _p_list;
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _p_index);
			p = (BirdFontPath*) _tmp12_;
			_tmp13_ = p;
			_tmp14_ = bird_font_path_get_stroke (_tmp13_);
			_tmp15_ = _tmp14_;
			if (_tmp15_ == ((gdouble) 0)) {
				BirdFontPathList* _tmp16_;
				BirdFontPath* _tmp17_;
				_tmp16_ = o;
				_tmp17_ = p;
				bird_font_path_list_add (_tmp16_, _tmp17_);
			} else {
				BirdFontPathList* _tmp18_;
				BirdFontPath* _tmp19_;
				BirdFontPathList* _tmp20_;
				BirdFontPathList* _tmp21_;
				_tmp18_ = o;
				_tmp19_ = p;
				_tmp20_ = bird_font_path_get_completed_stroke (_tmp19_);
				_tmp21_ = _tmp20_;
				bird_font_path_list_append (_tmp18_, _tmp21_);
				_g_object_unref0 (_tmp21_);
			}
			_g_object_unref0 (p);
		}
	}
	{
		GeeArrayList* _p_list = NULL;
		BirdFontPathList* _tmp22_;
		GeeArrayList* _tmp23_;
		gint _p_size = 0;
		GeeArrayList* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _p_index = 0;
		_tmp22_ = o;
		_tmp23_ = _tmp22_->paths;
		_p_list = _tmp23_;
		_tmp24_ = _p_list;
		_tmp25_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp24_);
		_tmp26_ = _tmp25_;
		_p_size = _tmp26_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp27_;
			gint _tmp28_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp29_;
			gpointer _tmp30_;
			BirdFontPath* _tmp31_;
			BirdFontPath* _tmp32_;
			_p_index = _p_index + 1;
			_tmp27_ = _p_index;
			_tmp28_ = _p_size;
			if (!(_tmp27_ < _tmp28_)) {
				break;
			}
			_tmp29_ = _p_list;
			_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp29_, _p_index);
			p = (BirdFontPath*) _tmp30_;
			_tmp31_ = p;
			bird_font_path_close (_tmp31_);
			_tmp32_ = p;
			bird_font_stroke_tool_remove_single_point_intersections (self, _tmp32_);
			_g_object_unref0 (p);
		}
	}
	_tmp33_ = o;
	_tmp35_ = bird_font_stroke_tool_remove_overlap (self, _tmp33_, &_tmp34_);
	_error_ = _tmp34_;
	_g_object_unref0 (o);
	o = _tmp35_;
	if (_error_) {
		g_warning ("StrokeTool.vala:153: merge_selected_paths failed.");
		_g_object_unref0 (new_paths);
		_g_object_unref0 (r);
		_g_object_unref0 (o);
		_g_object_unref0 (g);
		return;
	}
	_tmp36_ = o;
	bird_font_stroke_tool_reset_flags (self, _tmp36_);
	_tmp37_ = new_paths;
	_tmp38_ = o;
	bird_font_path_list_append (_tmp37_, _tmp38_);
	{
		gint merge = 0;
		merge = 0;
		{
			gboolean _tmp39_ = FALSE;
			_tmp39_ = TRUE;
			while (TRUE) {
				if (!_tmp39_) {
					gint _tmp40_;
					_tmp40_ = merge;
					merge = _tmp40_ + 1;
				}
				_tmp39_ = FALSE;
				if (!(merge < 2)) {
					break;
				}
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp41_ = FALSE;
						_tmp41_ = TRUE;
						while (TRUE) {
							BirdFontPathList* _tmp43_;
							GeeArrayList* _tmp44_;
							gint _tmp45_;
							gint _tmp46_;
							if (!_tmp41_) {
								gint _tmp42_;
								_tmp42_ = i;
								i = _tmp42_ + 1;
							}
							_tmp41_ = FALSE;
							_tmp43_ = o;
							_tmp44_ = _tmp43_->paths;
							_tmp45_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp44_);
							_tmp46_ = _tmp45_;
							if (!(i < _tmp46_)) {
								break;
							}
							{
								gint j = 0;
								j = 0;
								{
									gboolean _tmp47_ = FALSE;
									_tmp47_ = TRUE;
									while (TRUE) {
										BirdFontPathList* _tmp49_;
										GeeArrayList* _tmp50_;
										gint _tmp51_;
										gint _tmp52_;
										BirdFontPath* p1 = NULL;
										BirdFontPath* p2 = NULL;
										BirdFontStrokeTask* _tmp53_;
										BirdFontPathList* _tmp54_;
										GeeArrayList* _tmp55_;
										gpointer _tmp56_;
										BirdFontPathList* _tmp57_;
										GeeArrayList* _tmp58_;
										gpointer _tmp59_;
										BirdFontPath* _tmp64_;
										BirdFontPath* _tmp65_;
										gboolean _tmp66_ = FALSE;
										BirdFontPathList* _tmp67_;
										BirdFontPathList* _tmp68_;
										BirdFontPathList* _tmp69_;
										GeeArrayList* _tmp70_;
										gint _tmp71_;
										gint _tmp72_;
										if (!_tmp47_) {
											gint _tmp48_;
											_tmp48_ = j;
											j = _tmp48_ + 1;
										}
										_tmp47_ = FALSE;
										_tmp49_ = o;
										_tmp50_ = _tmp49_->paths;
										_tmp51_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp50_);
										_tmp52_ = _tmp51_;
										if (!(j < _tmp52_)) {
											break;
										}
										_tmp53_ = self->priv->task;
										if (bird_font_task_is_cancelled ((BirdFontTask*) _tmp53_)) {
											_g_object_unref0 (p2);
											_g_object_unref0 (p1);
											_g_object_unref0 (new_paths);
											_g_object_unref0 (r);
											_g_object_unref0 (o);
											_g_object_unref0 (g);
											return;
										}
										_tmp54_ = o;
										_tmp55_ = _tmp54_->paths;
										_tmp56_ = gee_abstract_list_get ((GeeAbstractList*) _tmp55_, i);
										_g_object_unref0 (p1);
										p1 = (BirdFontPath*) _tmp56_;
										_tmp57_ = o;
										_tmp58_ = _tmp57_->paths;
										_tmp59_ = gee_abstract_list_get ((GeeAbstractList*) _tmp58_, j);
										_g_object_unref0 (p2);
										p2 = (BirdFontPath*) _tmp59_;
										if (merge == 0) {
											BirdFontPath* _tmp60_;
											BirdFontPath* _tmp61_;
											_tmp60_ = p1;
											_tmp61_ = p2;
											if (bird_font_path_is_clockwise (_tmp60_) == bird_font_path_is_clockwise (_tmp61_)) {
												_g_object_unref0 (p2);
												_g_object_unref0 (p1);
												continue;
											}
										}
										if (merge == 1) {
											BirdFontPath* _tmp62_;
											BirdFontPath* _tmp63_;
											_tmp62_ = p1;
											_tmp63_ = p2;
											if (bird_font_path_is_clockwise (_tmp62_) != bird_font_path_is_clockwise (_tmp63_)) {
												_g_object_unref0 (p2);
												_g_object_unref0 (p1);
												continue;
											}
										}
										if (i == j) {
											_g_object_unref0 (p2);
											_g_object_unref0 (p1);
											continue;
										}
										_tmp64_ = p1;
										_tmp65_ = p2;
										_tmp67_ = bird_font_stroke_tool_merge_selected (self, _tmp64_, _tmp65_, FALSE, &_tmp66_);
										_error_ = _tmp66_;
										_g_object_unref0 (r);
										r = _tmp67_;
										if (_error_) {
											g_warning ("StrokeTool.vala:191: Can't merge selected paths.");
											_g_object_unref0 (p2);
											_g_object_unref0 (p1);
											_g_object_unref0 (new_paths);
											_g_object_unref0 (r);
											_g_object_unref0 (o);
											_g_object_unref0 (g);
											return;
										}
										_tmp68_ = r;
										bird_font_stroke_tool_remove_merged_curve_parts (self, _tmp68_);
										_tmp69_ = r;
										_tmp70_ = _tmp69_->paths;
										_tmp71_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp70_);
										_tmp72_ = _tmp71_;
										if (_tmp72_ > 0) {
											BirdFontPathList* _tmp73_;
											BirdFontPathList* _tmp74_;
											BirdFontPathList* _tmp75_;
											BirdFontPathList* _tmp76_;
											BirdFontPath* _tmp77_;
											BirdFontPathList* _tmp78_;
											BirdFontPath* _tmp79_;
											BirdFontPathList* _tmp80_;
											BirdFontPath* _tmp81_;
											BirdFontPathList* _tmp82_;
											BirdFontPath* _tmp83_;
											BirdFontPathList* _tmp84_;
											BirdFontPathList* _tmp85_;
											_tmp73_ = r;
											bird_font_stroke_tool_reset_flags (self, _tmp73_);
											_tmp74_ = new_paths;
											_tmp75_ = r;
											bird_font_path_list_append (_tmp74_, _tmp75_);
											_tmp76_ = new_paths;
											_tmp77_ = p1;
											bird_font_path_list_remove (_tmp76_, _tmp77_);
											_tmp78_ = new_paths;
											_tmp79_ = p2;
											bird_font_path_list_remove (_tmp78_, _tmp79_);
											_tmp80_ = o;
											_tmp81_ = p1;
											bird_font_path_list_remove (_tmp80_, _tmp81_);
											_tmp82_ = o;
											_tmp83_ = p2;
											bird_font_path_list_remove (_tmp82_, _tmp83_);
											_tmp84_ = o;
											_tmp85_ = r;
											bird_font_path_list_append (_tmp84_, _tmp85_);
											i = 0;
											j = 0;
										}
										_g_object_unref0 (p2);
										_g_object_unref0 (p1);
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp86_ = self->priv->task;
	if (bird_font_task_is_cancelled ((BirdFontTask*) _tmp86_)) {
		_g_object_unref0 (new_paths);
		_g_object_unref0 (r);
		_g_object_unref0 (o);
		_g_object_unref0 (g);
		return;
	}
	{
		GeeArrayList* _p_list = NULL;
		BirdFontGlyph* _tmp87_;
		GeeArrayList* _tmp88_;
		gint _p_size = 0;
		GeeArrayList* _tmp89_;
		gint _tmp90_;
		gint _tmp91_;
		gint _p_index = 0;
		_tmp87_ = g;
		_tmp88_ = _tmp87_->active_paths;
		_p_list = _tmp88_;
		_tmp89_ = _p_list;
		_tmp90_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp89_);
		_tmp91_ = _tmp90_;
		_p_size = _tmp91_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp92_;
			gint _tmp93_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp94_;
			gpointer _tmp95_;
			BirdFontGlyph* _tmp96_;
			BirdFontPath* _tmp97_;
			_p_index = _p_index + 1;
			_tmp92_ = _p_index;
			_tmp93_ = _p_size;
			if (!(_tmp92_ < _tmp93_)) {
				break;
			}
			_tmp94_ = _p_list;
			_tmp95_ = gee_abstract_list_get ((GeeAbstractList*) _tmp94_, _p_index);
			p = (BirdFontPath*) _tmp95_;
			_tmp96_ = g;
			_tmp97_ = p;
			bird_font_glyph_delete_path (_tmp96_, _tmp97_);
			_g_object_unref0 (p);
		}
	}
	_tmp98_ = g;
	bird_font_glyph_clear_active_paths (_tmp98_);
	_tmp99_ = new_paths;
	bird_font_stroke_tool_remove_merged_curve_parts (self, _tmp99_);
	{
		GeeArrayList* _p_list = NULL;
		BirdFontPathList* _tmp100_;
		GeeArrayList* _tmp101_;
		gint _p_size = 0;
		GeeArrayList* _tmp102_;
		gint _tmp103_;
		gint _tmp104_;
		gint _p_index = 0;
		_tmp100_ = new_paths;
		_tmp101_ = _tmp100_->paths;
		_p_list = _tmp101_;
		_tmp102_ = _p_list;
		_tmp103_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp102_);
		_tmp104_ = _tmp103_;
		_p_size = _tmp104_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp105_;
			gint _tmp106_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp107_;
			gpointer _tmp108_;
			BirdFontGlyph* _tmp109_;
			BirdFontPath* _tmp110_;
			BirdFontGlyph* _tmp111_;
			BirdFontPath* _tmp112_;
			_p_index = _p_index + 1;
			_tmp105_ = _p_index;
			_tmp106_ = _p_size;
			if (!(_tmp105_ < _tmp106_)) {
				break;
			}
			_tmp107_ = _p_list;
			_tmp108_ = gee_abstract_list_get ((GeeAbstractList*) _tmp107_, _p_index);
			p = (BirdFontPath*) _tmp108_;
			_tmp109_ = g;
			_tmp110_ = p;
			bird_font_glyph_add_path (_tmp109_, _tmp110_);
			_tmp111_ = g;
			_tmp112_ = p;
			bird_font_glyph_add_active_path (_tmp111_, NULL, _tmp112_);
			_g_object_unref0 (p);
		}
	}
	bird_font_pen_tool_update_orientation ();
	bird_font_glyph_canvas_redraw ();
	_g_object_unref0 (new_paths);
	_g_object_unref0 (r);
	_g_object_unref0 (o);
	_g_object_unref0 (g);
}

static void
bird_font_stroke_tool_remove_single_point_intersections (BirdFontStrokeTool* self,
                                                         BirdFontPath* p)
{
	BirdFontPointSelection* ps = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	bird_font_path_remove_points_on_points (p, 0.00001);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp2_;
				GeeArrayList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				BirdFontEditPoint* ep = NULL;
				GeeArrayList* _tmp6_;
				GeeArrayList* _tmp7_;
				gpointer _tmp8_;
				BirdFontEditPoint* next = NULL;
				GeeArrayList* _tmp9_;
				GeeArrayList* _tmp10_;
				GeeArrayList* _tmp11_;
				GeeArrayList* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				gpointer _tmp15_;
				BirdFontEditPoint* _tmp16_;
				BirdFontEditPointHandle* _tmp17_;
				BirdFontEditPoint* _tmp18_;
				BirdFontEditPointHandle* _tmp19_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = bird_font_path_get_points (p);
				_tmp3_ = _tmp2_;
				_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(i < _tmp5_)) {
					break;
				}
				_tmp6_ = bird_font_path_get_points (p);
				_tmp7_ = _tmp6_;
				_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, i);
				ep = (BirdFontEditPoint*) _tmp8_;
				_tmp9_ = bird_font_path_get_points (p);
				_tmp10_ = _tmp9_;
				_tmp11_ = bird_font_path_get_points (p);
				_tmp12_ = _tmp11_;
				_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, (i + 1) % _tmp14_);
				next = (BirdFontEditPoint*) _tmp15_;
				_tmp16_ = ep;
				_tmp17_ = bird_font_edit_point_get_right_handle (_tmp16_);
				_tmp18_ = ep;
				_tmp19_ = bird_font_edit_point_get_left_handle (_tmp18_);
				if (fmod (fabs (_tmp17_->angle - _tmp19_->angle), 2 * G_PI) < 0.01) {
					gboolean _tmp20_ = FALSE;
					BirdFontEditPoint* _tmp21_;
					BirdFontEditPointHandle* _tmp22_;
					_tmp21_ = ep;
					_tmp22_ = bird_font_edit_point_get_right_handle (_tmp21_);
					if (_tmp22_->length > ((gdouble) 0)) {
						BirdFontEditPoint* _tmp23_;
						BirdFontEditPointHandle* _tmp24_;
						_tmp23_ = ep;
						_tmp24_ = bird_font_edit_point_get_left_handle (_tmp23_);
						_tmp20_ = _tmp24_->length > ((gdouble) 0);
					} else {
						_tmp20_ = FALSE;
					}
					if (_tmp20_) {
						BirdFontEditPoint* _tmp25_;
						BirdFontPointSelection* _tmp26_;
						BirdFontPointSelection* _tmp27_;
						_tmp25_ = ep;
						_tmp26_ = bird_font_point_selection_new (_tmp25_, p);
						_g_object_unref0 (ps);
						ps = _tmp26_;
						_tmp27_ = ps;
						bird_font_pen_tool_remove_point_simplify (_tmp27_, 0.6);
					}
				} else {
					BirdFontEditPoint* _tmp28_;
					BirdFontEditPoint* _tmp29_;
					_tmp28_ = ep;
					_tmp29_ = next;
					if (bird_font_path_distance_to_point (_tmp28_, _tmp29_) < 0.01) {
						BirdFontEditPoint* _tmp30_;
						BirdFontPointSelection* _tmp31_;
						BirdFontPointSelection* _tmp32_;
						_tmp30_ = ep;
						_tmp31_ = bird_font_point_selection_new (_tmp30_, p);
						_g_object_unref0 (ps);
						ps = _tmp31_;
						_tmp32_ = ps;
						bird_font_pen_tool_remove_point_simplify (_tmp32_, 0.6);
					}
				}
				_g_object_unref0 (next);
				_g_object_unref0 (ep);
			}
		}
	}
	_g_object_unref0 (ps);
}

static BirdFontPathList*
bird_font_stroke_tool_remove_overlap (BirdFontStrokeTool* self,
                                      BirdFontPathList* pl,
                                      gboolean* _error_)
{
	gboolean _vala__error_ = FALSE;
	BirdFontPathList* r = NULL;
	BirdFontPathList* _tmp0_;
	BirdFontPathList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (pl != NULL, NULL);
	_tmp0_ = bird_font_path_list_new ();
	r = _tmp0_;
	_vala__error_ = FALSE;
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp1_;
		gint _p_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _p_index = 0;
		_tmp1_ = pl->paths;
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontPathList* m = NULL;
			BirdFontPath* _tmp9_;
			BirdFontPath* _tmp10_;
			BirdFontPath* _tmp11_;
			gboolean _tmp12_ = FALSE;
			BirdFontPathList* _tmp13_;
			BirdFontPathList* _tmp14_;
			BirdFontPathList* _tmp16_;
			GeeArrayList* _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			_p_index = _p_index + 1;
			_tmp5_ = _p_index;
			_tmp6_ = _p_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _p_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _p_index);
			p = (BirdFontPath*) _tmp8_;
			_tmp9_ = p;
			_tmp10_ = bird_font_path_new ();
			_tmp11_ = _tmp10_;
			_tmp13_ = bird_font_stroke_tool_merge_selected (self, _tmp9_, _tmp11_, TRUE, &_tmp12_);
			_vala__error_ = _tmp12_;
			_tmp14_ = _tmp13_;
			_g_object_unref0 (_tmp11_);
			m = _tmp14_;
			if (_vala__error_) {
				BirdFontPathList* _tmp15_;
				g_warning ("StrokeTool.vala:266: Can't remove overlap.");
				_tmp15_ = _g_object_ref0 (pl);
				result = _tmp15_;
				_g_object_unref0 (m);
				_g_object_unref0 (p);
				_g_object_unref0 (r);
				if (_error_) {
					*_error_ = _vala__error_;
				}
				return result;
			}
			_tmp16_ = m;
			_tmp17_ = _tmp16_->paths;
			_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
			_tmp19_ = _tmp18_;
			if (_tmp19_ > 0) {
				BirdFontPathList* _tmp20_;
				BirdFontPathList* _tmp21_;
				_tmp20_ = r;
				_tmp21_ = m;
				bird_font_path_list_append (_tmp20_, _tmp21_);
			} else {
				BirdFontPathList* _tmp22_;
				BirdFontPath* _tmp23_;
				_tmp22_ = r;
				_tmp23_ = p;
				bird_font_path_list_add (_tmp22_, _tmp23_);
			}
			_g_object_unref0 (m);
			_g_object_unref0 (p);
		}
	}
	result = r;
	if (_error_) {
		*_error_ = _vala__error_;
	}
	return result;
}

static void
bird_font_stroke_tool_remove_merged_curve_parts (BirdFontStrokeTool* self,
                                                 BirdFontPathList* r)
{
	GeeArrayList* remove = NULL;
	GeeArrayList* _tmp0_;
	BirdFontPathList* flat = NULL;
	BirdFontPathList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (r != NULL);
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_PATH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	remove = _tmp0_;
	_tmp1_ = bird_font_path_list_new ();
	flat = _tmp1_;
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp2_;
		gint _p_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _p_index = 0;
		_tmp2_ = r->paths;
		_p_list = _tmp2_;
		_tmp3_ = _p_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_p_size = _tmp5_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			BirdFontPath* _tmp10_;
			BirdFontPathList* _tmp11_;
			BirdFontPath* _tmp12_;
			BirdFontPath* _tmp13_;
			BirdFontPath* _tmp14_;
			_p_index = _p_index + 1;
			_tmp6_ = _p_index;
			_tmp7_ = _p_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _p_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _p_index);
			p = (BirdFontPath*) _tmp9_;
			_tmp10_ = p;
			bird_font_path_update_region_boundaries (_tmp10_);
			_tmp11_ = flat;
			_tmp12_ = p;
			_tmp13_ = bird_font_path_flatten (_tmp12_, 10);
			_tmp14_ = _tmp13_;
			bird_font_path_list_add (_tmp11_, _tmp14_);
			_g_object_unref0 (_tmp14_);
			_g_object_unref0 (p);
		}
	}
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp15_;
		gint _p_size = 0;
		GeeArrayList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _p_index = 0;
		_tmp15_ = r->paths;
		_p_list = _tmp15_;
		_tmp16_ = _p_list;
		_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_p_size = _tmp18_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp19_;
			gint _tmp20_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp21_;
			gpointer _tmp22_;
			BirdFontPathList* pl = NULL;
			BirdFontPathList* _tmp23_;
			BirdFontPath* _tmp24_;
			BirdFontPathList* _tmp25_;
			gint counters = 0;
			gint clockwise = 0;
			BirdFontPath* _tmp38_;
			_p_index = _p_index + 1;
			_tmp19_ = _p_index;
			_tmp20_ = _p_size;
			if (!(_tmp19_ < _tmp20_)) {
				break;
			}
			_tmp21_ = _p_list;
			_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _p_index);
			p = (BirdFontPath*) _tmp22_;
			_tmp23_ = flat;
			_tmp24_ = p;
			_tmp25_ = bird_font_stroke_tool_get_insides (self, _tmp23_, _tmp24_);
			pl = _tmp25_;
			counters = 0;
			clockwise = 0;
			{
				GeeArrayList* _i_list = NULL;
				BirdFontPathList* _tmp26_;
				GeeArrayList* _tmp27_;
				gint _i_size = 0;
				GeeArrayList* _tmp28_;
				gint _tmp29_;
				gint _tmp30_;
				gint _i_index = 0;
				_tmp26_ = pl;
				_tmp27_ = _tmp26_->paths;
				_i_list = _tmp27_;
				_tmp28_ = _i_list;
				_tmp29_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp28_);
				_tmp30_ = _tmp29_;
				_i_size = _tmp30_;
				_i_index = -1;
				while (TRUE) {
					gint _tmp31_;
					gint _tmp32_;
					BirdFontPath* i = NULL;
					GeeArrayList* _tmp33_;
					gpointer _tmp34_;
					BirdFontPath* _tmp35_;
					_i_index = _i_index + 1;
					_tmp31_ = _i_index;
					_tmp32_ = _i_size;
					if (!(_tmp31_ < _tmp32_)) {
						break;
					}
					_tmp33_ = _i_list;
					_tmp34_ = gee_abstract_list_get ((GeeAbstractList*) _tmp33_, _i_index);
					i = (BirdFontPath*) _tmp34_;
					_tmp35_ = i;
					if (bird_font_path_is_clockwise (_tmp35_)) {
						gint _tmp36_;
						_tmp36_ = clockwise;
						clockwise = _tmp36_ + 1;
					} else {
						gint _tmp37_;
						_tmp37_ = counters;
						counters = _tmp37_ + 1;
					}
					_g_object_unref0 (i);
				}
			}
			_tmp38_ = p;
			if (bird_font_path_is_clockwise (_tmp38_)) {
				if ((clockwise - 1) > counters) {
					GeeArrayList* _tmp39_;
					BirdFontPath* _tmp40_;
					_tmp39_ = remove;
					_tmp40_ = p;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp39_, _tmp40_);
					_g_object_unref0 (pl);
					_g_object_unref0 (p);
					break;
				}
			} else {
				if (clockwise < (counters - 1)) {
					GeeArrayList* _tmp41_;
					BirdFontPath* _tmp42_;
					_tmp41_ = remove;
					_tmp42_ = p;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp41_, _tmp42_);
					_g_object_unref0 (pl);
					_g_object_unref0 (p);
					break;
				}
			}
			_g_object_unref0 (pl);
			_g_object_unref0 (p);
		}
	}
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp43_;
		gint _p_size = 0;
		GeeArrayList* _tmp44_;
		gint _tmp45_;
		gint _tmp46_;
		gint _p_index = 0;
		_tmp43_ = remove;
		_p_list = _tmp43_;
		_tmp44_ = _p_list;
		_tmp45_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp44_);
		_tmp46_ = _tmp45_;
		_p_size = _tmp46_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp47_;
			gint _tmp48_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp49_;
			gpointer _tmp50_;
			GeeArrayList* _tmp51_;
			BirdFontPath* _tmp52_;
			_p_index = _p_index + 1;
			_tmp47_ = _p_index;
			_tmp48_ = _p_size;
			if (!(_tmp47_ < _tmp48_)) {
				break;
			}
			_tmp49_ = _p_list;
			_tmp50_ = gee_abstract_list_get ((GeeAbstractList*) _tmp49_, _p_index);
			p = (BirdFontPath*) _tmp50_;
			_tmp51_ = r->paths;
			_tmp52_ = p;
			gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp51_, _tmp52_);
			bird_font_stroke_tool_remove_merged_curve_parts (self, r);
			_g_object_unref0 (p);
			_g_object_unref0 (flat);
			_g_object_unref0 (remove);
			return;
		}
	}
	_g_object_unref0 (flat);
	_g_object_unref0 (remove);
}

BirdFontPathList*
bird_font_stroke_tool_merge_selected (BirdFontStrokeTool* self,
                                      BirdFontPath* path1,
                                      BirdFontPath* path2,
                                      gboolean self_intersection,
                                      gboolean* _error_)
{
	gboolean _vala__error_ = FALSE;
	BirdFontPathList* flat = NULL;
	BirdFontPathList* _tmp0_;
	BirdFontPathList* o = NULL;
	BirdFontPathList* _tmp1_;
	BirdFontPathList* pl = NULL;
	BirdFontPathList* _tmp2_;
	BirdFontPathList* r = NULL;
	BirdFontPathList* _tmp3_;
	BirdFontPathList* _tmp4_;
	BirdFontPathList* _tmp5_;
	BirdFontPathList* _tmp26_;
	BirdFontPathList* _tmp27_;
	gboolean has_split_point = FALSE;
	BirdFontEditPoint* prev = NULL;
	BirdFontEditPoint* _tmp206_;
	BirdFontPathList* _tmp273_;
	GeeArrayList* _tmp274_;
	gint _tmp275_;
	gint _tmp276_;
	BirdFontPathList* _tmp277_;
	BirdFontPath* p1 = NULL;
	BirdFontPath* p2 = NULL;
	BirdFontPathList* _tmp278_;
	GeeArrayList* _tmp279_;
	gpointer _tmp280_;
	BirdFontPathList* _tmp281_;
	GeeArrayList* _tmp282_;
	gpointer _tmp283_;
	BirdFontPathList* parts = NULL;
	BirdFontPathList* _tmp284_;
	BirdFontPathList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path1 != NULL, NULL);
	g_return_val_if_fail (path2 != NULL, NULL);
	_tmp0_ = bird_font_path_list_new ();
	flat = _tmp0_;
	_tmp1_ = bird_font_path_list_new ();
	o = _tmp1_;
	_tmp2_ = bird_font_path_list_new ();
	pl = _tmp2_;
	_tmp3_ = bird_font_path_list_new ();
	r = _tmp3_;
	_tmp4_ = pl;
	bird_font_path_list_add (_tmp4_, path1);
	_tmp5_ = pl;
	bird_font_path_list_add (_tmp5_, path2);
	_vala__error_ = FALSE;
	if (!self_intersection) {
		if (!bird_font_path_boundaries_intersecting (path1, path2)) {
			result = r;
			_g_object_unref0 (pl);
			_g_object_unref0 (o);
			_g_object_unref0 (flat);
			if (_error_) {
				*_error_ = _vala__error_;
			}
			return result;
		}
	}
	{
		GeeArrayList* _p_list = NULL;
		BirdFontPathList* _tmp6_;
		GeeArrayList* _tmp7_;
		gint _p_size = 0;
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _p_index = 0;
		_tmp6_ = pl;
		_tmp7_ = _tmp6_->paths;
		_p_list = _tmp7_;
		_tmp8_ = _p_list;
		_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_p_size = _tmp10_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp13_;
			gpointer _tmp14_;
			BirdFontPath* _tmp15_;
			gdouble _tmp16_;
			gdouble _tmp17_;
			_p_index = _p_index + 1;
			_tmp11_ = _p_index;
			_tmp12_ = _p_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _p_list;
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, _p_index);
			p = (BirdFontPath*) _tmp14_;
			_tmp15_ = p;
			_tmp16_ = bird_font_path_get_stroke (_tmp15_);
			_tmp17_ = _tmp16_;
			if (_tmp17_ == ((gdouble) 0)) {
				BirdFontPathList* _tmp18_;
				BirdFontPath* _tmp19_;
				BirdFontPathList* _tmp20_;
				BirdFontPath* _tmp21_;
				BirdFontPath* _tmp22_;
				BirdFontPath* _tmp23_;
				BirdFontPath* _tmp24_;
				BirdFontPath* _tmp25_;
				_tmp18_ = o;
				_tmp19_ = p;
				bird_font_path_list_add (_tmp18_, _tmp19_);
				_tmp20_ = flat;
				_tmp21_ = p;
				_tmp22_ = bird_font_path_copy (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = bird_font_path_flatten (_tmp23_, 50);
				_tmp25_ = _tmp24_;
				bird_font_path_list_add (_tmp20_, _tmp25_);
				_g_object_unref0 (_tmp25_);
				_g_object_unref0 (_tmp23_);
			}
			_g_object_unref0 (p);
		}
	}
	_tmp26_ = flat;
	_tmp27_ = bird_font_stroke_tool_merge (self, _tmp26_);
	_g_object_unref0 (flat);
	flat = _tmp27_;
	{
		GeeArrayList* _pp_list = NULL;
		BirdFontPathList* _tmp28_;
		GeeArrayList* _tmp29_;
		gint _pp_size = 0;
		GeeArrayList* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		gint _pp_index = 0;
		_tmp28_ = o;
		_tmp29_ = _tmp28_->paths;
		_pp_list = _tmp29_;
		_tmp30_ = _pp_list;
		_tmp31_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_pp_size = _tmp32_;
		_pp_index = -1;
		while (TRUE) {
			gint _tmp33_;
			gint _tmp34_;
			BirdFontPath* pp = NULL;
			GeeArrayList* _tmp35_;
			gpointer _tmp36_;
			BirdFontPath* _tmp37_;
			_pp_index = _pp_index + 1;
			_tmp33_ = _pp_index;
			_tmp34_ = _pp_size;
			if (!(_tmp33_ < _tmp34_)) {
				break;
			}
			_tmp35_ = _pp_list;
			_tmp36_ = gee_abstract_list_get ((GeeAbstractList*) _tmp35_, _pp_index);
			pp = (BirdFontPath*) _tmp36_;
			_tmp37_ = pp;
			bird_font_path_remove_points_on_points (_tmp37_, 0.1);
			_g_object_unref0 (pp);
		}
	}
	has_split_point = FALSE;
	{
		GeeArrayList* _p_list = NULL;
		BirdFontPathList* _tmp38_;
		GeeArrayList* _tmp39_;
		gint _p_size = 0;
		GeeArrayList* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		gint _p_index = 0;
		_tmp38_ = flat;
		_tmp39_ = _tmp38_->paths;
		_p_list = _tmp39_;
		_tmp40_ = _p_list;
		_tmp41_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp40_);
		_tmp42_ = _tmp41_;
		_p_size = _tmp42_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp43_;
			gint _tmp44_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp45_;
			gpointer _tmp46_;
			_p_index = _p_index + 1;
			_tmp43_ = _p_index;
			_tmp44_ = _p_size;
			if (!(_tmp43_ < _tmp44_)) {
				break;
			}
			_tmp45_ = _p_list;
			_tmp46_ = gee_abstract_list_get ((GeeAbstractList*) _tmp45_, _p_index);
			p = (BirdFontPath*) _tmp46_;
			{
				GeeArrayList* _ep_list = NULL;
				BirdFontPath* _tmp47_;
				GeeArrayList* _tmp48_;
				GeeArrayList* _tmp49_;
				gint _ep_size = 0;
				GeeArrayList* _tmp50_;
				gint _tmp51_;
				gint _tmp52_;
				gint _ep_index = 0;
				_tmp47_ = p;
				_tmp48_ = bird_font_path_get_points (_tmp47_);
				_tmp49_ = _tmp48_;
				_ep_list = _tmp49_;
				_tmp50_ = _ep_list;
				_tmp51_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp50_);
				_tmp52_ = _tmp51_;
				_ep_size = _tmp52_;
				_ep_index = -1;
				while (TRUE) {
					gint _tmp53_;
					gint _tmp54_;
					BirdFontEditPoint* ep = NULL;
					GeeArrayList* _tmp55_;
					gpointer _tmp56_;
					BirdFontEditPoint* _tmp57_;
					_ep_index = _ep_index + 1;
					_tmp53_ = _ep_index;
					_tmp54_ = _ep_size;
					if (!(_tmp53_ < _tmp54_)) {
						break;
					}
					_tmp55_ = _ep_list;
					_tmp56_ = gee_abstract_list_get ((GeeAbstractList*) _tmp55_, _ep_index);
					ep = (BirdFontEditPoint*) _tmp56_;
					_tmp57_ = ep;
					if ((_tmp57_->flags & BIRD_FONT_EDIT_POINT_SPLIT_POINT) > ((guint) 0)) {
						{
							GeeArrayList* _pp_list = NULL;
							BirdFontPathList* _tmp58_;
							GeeArrayList* _tmp59_;
							gint _pp_size = 0;
							GeeArrayList* _tmp60_;
							gint _tmp61_;
							gint _tmp62_;
							gint _pp_index = 0;
							_tmp58_ = o;
							_tmp59_ = _tmp58_->paths;
							_pp_list = _tmp59_;
							_tmp60_ = _pp_list;
							_tmp61_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp60_);
							_tmp62_ = _tmp61_;
							_pp_size = _tmp62_;
							_pp_index = -1;
							while (TRUE) {
								gint _tmp63_;
								gint _tmp64_;
								BirdFontPath* pp = NULL;
								GeeArrayList* _tmp65_;
								gpointer _tmp66_;
								BirdFontEditPoint* lep = NULL;
								BirdFontEditPoint* _tmp67_;
								BirdFontPath* _tmp68_;
								GeeArrayList* _tmp69_;
								GeeArrayList* _tmp70_;
								gint _tmp71_;
								gint _tmp72_;
								_pp_index = _pp_index + 1;
								_tmp63_ = _pp_index;
								_tmp64_ = _pp_size;
								if (!(_tmp63_ < _tmp64_)) {
									break;
								}
								_tmp65_ = _pp_list;
								_tmp66_ = gee_abstract_list_get ((GeeAbstractList*) _tmp65_, _pp_index);
								pp = (BirdFontPath*) _tmp66_;
								_tmp67_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
								lep = _tmp67_;
								_tmp68_ = pp;
								_tmp69_ = bird_font_path_get_points (_tmp68_);
								_tmp70_ = _tmp69_;
								_tmp71_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp70_);
								_tmp72_ = _tmp71_;
								if (_tmp72_ > 1) {
									BirdFontPath* _tmp73_;
									BirdFontEditPoint* _tmp74_;
									BirdFontEditPoint* _tmp75_;
									BirdFontEditPoint* _tmp76_;
									BirdFontEditPoint* _tmp77_;
									BirdFontEditPoint* _tmp78_;
									_tmp73_ = pp;
									_tmp74_ = lep;
									_tmp75_ = ep;
									_tmp76_ = ep;
									bird_font_path_get_closest_point_on_path (_tmp73_, _tmp74_, _tmp75_->x, _tmp76_->y, NULL, NULL, -1);
									_tmp77_ = ep;
									_tmp78_ = lep;
									if (bird_font_path_distance_to_point (_tmp77_, _tmp78_) < 0.1) {
										BirdFontEditPoint* lep2 = NULL;
										BirdFontEditPoint* _tmp79_;
										BirdFontPath* _tmp80_;
										BirdFontEditPoint* _tmp81_;
										BirdFontEditPoint* _tmp82_;
										BirdFontEditPoint* _tmp83_;
										BirdFontEditPoint* _tmp84_;
										BirdFontEditPoint* _tmp85_;
										BirdFontEditPoint* _tmp86_;
										BirdFontEditPoint* _tmp87_;
										BirdFontEditPoint* _tmp88_;
										BirdFontEditPoint* _tmp89_;
										BirdFontEditPoint* _tmp101_;
										BirdFontEditPoint* _tmp102_;
										BirdFontEditPoint* _tmp114_;
										BirdFontEditPoint* _tmp115_;
										BirdFontEditPoint* _tmp127_;
										BirdFontEditPoint* _tmp128_;
										gboolean _tmp140_ = FALSE;
										BirdFontEditPoint* _tmp141_;
										BirdFontEditPoint* _tmp142_;
										_tmp79_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
										lep2 = _tmp79_;
										_tmp80_ = pp;
										_tmp81_ = lep2;
										_tmp82_ = ep;
										_tmp83_ = ep;
										_tmp84_ = lep;
										_tmp85_ = _tmp84_->prev;
										_tmp86_ = lep;
										_tmp87_ = _tmp86_->next;
										bird_font_path_get_closest_point_on_path (_tmp80_, _tmp81_, _tmp82_->x, _tmp83_->y, _tmp85_, _tmp87_, -1);
										_tmp88_ = lep;
										_tmp89_ = _tmp88_->prev;
										if (_tmp89_ != NULL) {
											BirdFontEditPoint* _tmp90_;
											BirdFontEditPointHandle* _tmp91_;
											BirdFontEditPoint* _tmp92_;
											BirdFontEditPoint* _tmp93_;
											BirdFontEditPointHandle* _tmp94_;
											_tmp90_ = lep;
											_tmp91_ = bird_font_edit_point_get_left_handle (_tmp90_);
											_tmp92_ = lep;
											_tmp93_ = bird_font_edit_point_get_prev (_tmp92_);
											_tmp94_ = bird_font_edit_point_get_right_handle (_tmp93_);
											_tmp91_->type = _tmp94_->type;
										} else {
											BirdFontEditPoint* _tmp95_;
											BirdFontEditPointHandle* _tmp96_;
											BirdFontPath* _tmp97_;
											BirdFontEditPoint* _tmp98_;
											BirdFontEditPoint* _tmp99_;
											BirdFontEditPointHandle* _tmp100_;
											_tmp95_ = lep;
											_tmp96_ = bird_font_edit_point_get_left_handle (_tmp95_);
											_tmp97_ = pp;
											_tmp98_ = bird_font_path_get_last_point (_tmp97_);
											_tmp99_ = _tmp98_;
											_tmp100_ = bird_font_edit_point_get_right_handle (_tmp99_);
											_tmp96_->type = _tmp100_->type;
											_g_object_unref0 (_tmp99_);
										}
										_tmp101_ = lep;
										_tmp102_ = _tmp101_->next;
										if (_tmp102_ != NULL) {
											BirdFontEditPoint* _tmp103_;
											BirdFontEditPointHandle* _tmp104_;
											BirdFontEditPoint* _tmp105_;
											BirdFontEditPoint* _tmp106_;
											BirdFontEditPointHandle* _tmp107_;
											_tmp103_ = lep;
											_tmp104_ = bird_font_edit_point_get_right_handle (_tmp103_);
											_tmp105_ = lep;
											_tmp106_ = bird_font_edit_point_get_next (_tmp105_);
											_tmp107_ = bird_font_edit_point_get_left_handle (_tmp106_);
											_tmp104_->type = _tmp107_->type;
										} else {
											BirdFontEditPoint* _tmp108_;
											BirdFontEditPointHandle* _tmp109_;
											BirdFontPath* _tmp110_;
											BirdFontEditPoint* _tmp111_;
											BirdFontEditPoint* _tmp112_;
											BirdFontEditPointHandle* _tmp113_;
											_tmp108_ = lep;
											_tmp109_ = bird_font_edit_point_get_left_handle (_tmp108_);
											_tmp110_ = pp;
											_tmp111_ = bird_font_path_get_first_point (_tmp110_);
											_tmp112_ = _tmp111_;
											_tmp113_ = bird_font_edit_point_get_right_handle (_tmp112_);
											_tmp109_->type = _tmp113_->type;
											_g_object_unref0 (_tmp112_);
										}
										_tmp114_ = lep2;
										_tmp115_ = _tmp114_->prev;
										if (_tmp115_ != NULL) {
											BirdFontEditPoint* _tmp116_;
											BirdFontEditPointHandle* _tmp117_;
											BirdFontEditPoint* _tmp118_;
											BirdFontEditPoint* _tmp119_;
											BirdFontEditPointHandle* _tmp120_;
											_tmp116_ = lep2;
											_tmp117_ = bird_font_edit_point_get_left_handle (_tmp116_);
											_tmp118_ = lep2;
											_tmp119_ = bird_font_edit_point_get_prev (_tmp118_);
											_tmp120_ = bird_font_edit_point_get_right_handle (_tmp119_);
											_tmp117_->type = _tmp120_->type;
										} else {
											BirdFontEditPoint* _tmp121_;
											BirdFontEditPointHandle* _tmp122_;
											BirdFontPath* _tmp123_;
											BirdFontEditPoint* _tmp124_;
											BirdFontEditPoint* _tmp125_;
											BirdFontEditPointHandle* _tmp126_;
											_tmp121_ = lep2;
											_tmp122_ = bird_font_edit_point_get_left_handle (_tmp121_);
											_tmp123_ = pp;
											_tmp124_ = bird_font_path_get_first_point (_tmp123_);
											_tmp125_ = _tmp124_;
											_tmp126_ = bird_font_edit_point_get_right_handle (_tmp125_);
											_tmp122_->type = _tmp126_->type;
											_g_object_unref0 (_tmp125_);
										}
										_tmp127_ = lep2;
										_tmp128_ = _tmp127_->next;
										if (_tmp128_ != NULL) {
											BirdFontEditPoint* _tmp129_;
											BirdFontEditPointHandle* _tmp130_;
											BirdFontEditPoint* _tmp131_;
											BirdFontEditPoint* _tmp132_;
											BirdFontEditPointHandle* _tmp133_;
											_tmp129_ = lep2;
											_tmp130_ = bird_font_edit_point_get_right_handle (_tmp129_);
											_tmp131_ = lep2;
											_tmp132_ = bird_font_edit_point_get_next (_tmp131_);
											_tmp133_ = bird_font_edit_point_get_left_handle (_tmp132_);
											_tmp130_->type = _tmp133_->type;
										} else {
											BirdFontEditPoint* _tmp134_;
											BirdFontEditPointHandle* _tmp135_;
											BirdFontPath* _tmp136_;
											BirdFontEditPoint* _tmp137_;
											BirdFontEditPoint* _tmp138_;
											BirdFontEditPointHandle* _tmp139_;
											_tmp134_ = lep2;
											_tmp135_ = bird_font_edit_point_get_left_handle (_tmp134_);
											_tmp136_ = pp;
											_tmp137_ = bird_font_path_get_last_point (_tmp136_);
											_tmp138_ = _tmp137_;
											_tmp139_ = bird_font_edit_point_get_right_handle (_tmp138_);
											_tmp135_->type = _tmp139_->type;
											_g_object_unref0 (_tmp138_);
										}
										_tmp141_ = ep;
										_tmp142_ = lep2;
										if (bird_font_path_distance_to_point (_tmp141_, _tmp142_) < 0.1) {
											BirdFontEditPoint* _tmp143_;
											BirdFontEditPoint* _tmp144_;
											_tmp143_ = ep;
											_tmp144_ = lep;
											_tmp140_ = bird_font_path_distance_to_point (_tmp143_, _tmp144_) < 0.1;
										} else {
											_tmp140_ = FALSE;
										}
										if (_tmp140_) {
											BirdFontEditPoint* _tmp145_;
											BirdFontEditPoint* _tmp146_;
											BirdFontEditPoint* _tmp147_;
											BirdFontEditPoint* _tmp148_;
											BirdFontEditPoint* _tmp149_;
											BirdFontEditPoint* _tmp150_;
											BirdFontPath* _tmp151_;
											BirdFontEditPoint* _tmp152_;
											BirdFontEditPoint* _tmp153_;
											BirdFontPath* _tmp154_;
											BirdFontEditPoint* _tmp155_;
											BirdFontEditPoint* _tmp156_;
											BirdFontPath* _tmp157_;
											BirdFontEditPoint* _tmp158_;
											BirdFontPath* _tmp159_;
											BirdFontEditPoint* _tmp160_;
											BirdFontEditPoint* _tmp161_;
											BirdFontEditPoint* _tmp162_;
											BirdFontEditPoint* _tmp163_;
											BirdFontEditPoint* _tmp164_;
											BirdFontEditPoint* _tmp165_;
											BirdFontEditPoint* _tmp166_;
											BirdFontEditPoint* _tmp167_;
											BirdFontEditPoint* _tmp168_;
											_tmp145_ = lep;
											_tmp146_ = lep;
											_tmp147_ = _tmp146_->prev;
											if (bird_font_path_distance_to_point (_tmp145_, G_TYPE_CHECK_INSTANCE_CAST (_tmp147_, BIRD_FONT_TYPE_EDIT_POINT, BirdFontEditPoint)) < 0.001) {
												_g_object_unref0 (lep2);
												_g_object_unref0 (lep);
												_g_object_unref0 (pp);
												continue;
											}
											_tmp148_ = lep;
											_tmp149_ = lep;
											_tmp150_ = _tmp149_->next;
											if (bird_font_path_distance_to_point (_tmp148_, G_TYPE_CHECK_INSTANCE_CAST (_tmp150_, BIRD_FONT_TYPE_EDIT_POINT, BirdFontEditPoint)) < 0.001) {
												_g_object_unref0 (lep2);
												_g_object_unref0 (lep);
												_g_object_unref0 (pp);
												continue;
											}
											_tmp151_ = pp;
											_tmp152_ = lep;
											_tmp153_ = ep;
											bird_font_stroke_tool_add_double_point_at_intersection (self, _tmp151_, _tmp152_, _tmp153_);
											_tmp154_ = pp;
											_tmp155_ = lep2;
											_tmp156_ = ep;
											bird_font_stroke_tool_add_double_point_at_intersection (self, _tmp154_, _tmp155_, _tmp156_);
											_tmp157_ = pp;
											_tmp158_ = lep;
											bird_font_path_insert_new_point_on_path (_tmp157_, _tmp158_, (gdouble) -1, FALSE);
											_tmp159_ = pp;
											_tmp160_ = lep2;
											bird_font_path_insert_new_point_on_path (_tmp159_, _tmp160_, (gdouble) -1, FALSE);
											_tmp161_ = lep;
											_tmp162_ = lep;
											_tmp162_->flags = _tmp162_->flags | BIRD_FONT_EDIT_POINT_SELF_INTERSECTION;
											_tmp163_ = lep2;
											_tmp164_ = lep2;
											_tmp164_->flags = _tmp164_->flags | BIRD_FONT_EDIT_POINT_SELF_INTERSECTION;
											_tmp165_ = lep;
											bird_font_edit_point_set_tie_handles (_tmp165_, FALSE);
											_tmp166_ = lep;
											bird_font_edit_point_set_reflective_point (_tmp166_, FALSE);
											_tmp167_ = lep2;
											bird_font_edit_point_set_tie_handles (_tmp167_, FALSE);
											_tmp168_ = lep2;
											bird_font_edit_point_set_reflective_point (_tmp168_, FALSE);
										} else {
											gboolean _tmp169_ = FALSE;
											BirdFontEditPoint* _tmp170_;
											BirdFontEditPoint* _tmp171_;
											gboolean _tmp183_ = FALSE;
											BirdFontEditPoint* _tmp184_;
											BirdFontEditPoint* _tmp185_;
											BirdFontPath* _tmp197_;
											BirdFontEditPoint* _tmp198_;
											BirdFontEditPoint* _tmp199_;
											BirdFontPath* _tmp200_;
											BirdFontEditPoint* _tmp201_;
											BirdFontEditPoint* _tmp202_;
											BirdFontEditPoint* _tmp203_;
											BirdFontEditPoint* _tmp204_;
											BirdFontEditPoint* _tmp205_;
											_tmp170_ = lep;
											_tmp171_ = _tmp170_->prev;
											if (_tmp171_ != NULL) {
												BirdFontEditPoint* _tmp172_;
												BirdFontEditPoint* _tmp173_;
												BirdFontEditPoint* _tmp174_;
												_tmp172_ = lep;
												_tmp173_ = lep;
												_tmp174_ = _tmp173_->prev;
												_tmp169_ = bird_font_path_distance_to_point (_tmp172_, G_TYPE_CHECK_INSTANCE_CAST (_tmp174_, BIRD_FONT_TYPE_EDIT_POINT, BirdFontEditPoint)) < 0.00000001;
											} else {
												_tmp169_ = FALSE;
											}
											if (_tmp169_) {
												BirdFontEditPoint* _tmp175_;
												BirdFontEditPoint* _tmp176_;
												BirdFontEditPoint* _tmp177_;
												BirdFontEditPoint* _tmp178_;
												BirdFontEditPoint* _tmp179_;
												BirdFontEditPoint* _tmp180_;
												BirdFontEditPoint* _tmp181_;
												BirdFontEditPoint* _tmp182_;
												_tmp175_ = lep;
												_tmp176_ = bird_font_edit_point_get_prev (_tmp175_);
												_tmp177_ = lep;
												_tmp178_ = bird_font_edit_point_get_prev (_tmp177_);
												_tmp178_->flags = _tmp178_->flags | BIRD_FONT_EDIT_POINT_INTERSECTION;
												_tmp179_ = lep;
												_tmp180_ = bird_font_edit_point_get_prev (_tmp179_);
												bird_font_edit_point_set_tie_handles (_tmp180_, FALSE);
												_tmp181_ = lep;
												_tmp182_ = bird_font_edit_point_get_prev (_tmp181_);
												bird_font_edit_point_set_reflective_point (_tmp182_, FALSE);
												_g_object_unref0 (lep2);
												_g_object_unref0 (lep);
												_g_object_unref0 (pp);
												continue;
											}
											_tmp184_ = lep;
											_tmp185_ = _tmp184_->next;
											if (_tmp185_ != NULL) {
												BirdFontEditPoint* _tmp186_;
												BirdFontEditPoint* _tmp187_;
												BirdFontEditPoint* _tmp188_;
												_tmp186_ = lep;
												_tmp187_ = lep;
												_tmp188_ = _tmp187_->next;
												_tmp183_ = bird_font_path_distance_to_point (_tmp186_, G_TYPE_CHECK_INSTANCE_CAST (_tmp188_, BIRD_FONT_TYPE_EDIT_POINT, BirdFontEditPoint)) < 0.00000001;
											} else {
												_tmp183_ = FALSE;
											}
											if (_tmp183_) {
												BirdFontEditPoint* _tmp189_;
												BirdFontEditPoint* _tmp190_;
												BirdFontEditPoint* _tmp191_;
												BirdFontEditPoint* _tmp192_;
												BirdFontEditPoint* _tmp193_;
												BirdFontEditPoint* _tmp194_;
												BirdFontEditPoint* _tmp195_;
												BirdFontEditPoint* _tmp196_;
												_tmp189_ = lep;
												_tmp190_ = bird_font_edit_point_get_next (_tmp189_);
												_tmp191_ = lep;
												_tmp192_ = bird_font_edit_point_get_next (_tmp191_);
												_tmp192_->flags = _tmp192_->flags | BIRD_FONT_EDIT_POINT_INTERSECTION;
												_tmp193_ = lep;
												_tmp194_ = bird_font_edit_point_get_next (_tmp193_);
												bird_font_edit_point_set_tie_handles (_tmp194_, FALSE);
												_tmp195_ = lep;
												_tmp196_ = bird_font_edit_point_get_next (_tmp195_);
												bird_font_edit_point_set_reflective_point (_tmp196_, FALSE);
												_g_object_unref0 (lep2);
												_g_object_unref0 (lep);
												_g_object_unref0 (pp);
												continue;
											}
											_tmp197_ = pp;
											_tmp198_ = lep;
											_tmp199_ = ep;
											bird_font_stroke_tool_add_double_point_at_intersection (self, _tmp197_, _tmp198_, _tmp199_);
											_tmp200_ = pp;
											_tmp201_ = lep;
											bird_font_path_insert_new_point_on_path (_tmp200_, _tmp201_, (gdouble) -1, FALSE);
											_tmp202_ = lep;
											_tmp203_ = lep;
											_tmp203_->flags = _tmp203_->flags | BIRD_FONT_EDIT_POINT_INTERSECTION;
											_tmp204_ = lep;
											bird_font_edit_point_set_tie_handles (_tmp204_, FALSE);
											_tmp205_ = lep;
											bird_font_edit_point_set_reflective_point (_tmp205_, FALSE);
										}
										has_split_point = TRUE;
										_g_object_unref0 (lep2);
									}
								}
								_g_object_unref0 (lep);
								_g_object_unref0 (pp);
							}
						}
					}
					_g_object_unref0 (ep);
				}
			}
			_g_object_unref0 (p);
		}
	}
	if (!has_split_point) {
		result = r;
		_g_object_unref0 (pl);
		_g_object_unref0 (o);
		_g_object_unref0 (flat);
		if (_error_) {
			*_error_ = _vala__error_;
		}
		return result;
	}
	_tmp206_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
	prev = _tmp206_;
	{
		GeeArrayList* _pp_list = NULL;
		BirdFontPathList* _tmp207_;
		GeeArrayList* _tmp208_;
		gint _pp_size = 0;
		GeeArrayList* _tmp209_;
		gint _tmp210_;
		gint _tmp211_;
		gint _pp_index = 0;
		_tmp207_ = o;
		_tmp208_ = _tmp207_->paths;
		_pp_list = _tmp208_;
		_tmp209_ = _pp_list;
		_tmp210_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp209_);
		_tmp211_ = _tmp210_;
		_pp_size = _tmp211_;
		_pp_index = -1;
		while (TRUE) {
			gint _tmp212_;
			gint _tmp213_;
			BirdFontPath* pp = NULL;
			GeeArrayList* _tmp214_;
			gpointer _tmp215_;
			_pp_index = _pp_index + 1;
			_tmp212_ = _pp_index;
			_tmp213_ = _pp_size;
			if (!(_tmp212_ < _tmp213_)) {
				break;
			}
			_tmp214_ = _pp_list;
			_tmp215_ = gee_abstract_list_get ((GeeAbstractList*) _tmp214_, _pp_index);
			pp = (BirdFontPath*) _tmp215_;
			{
				GeeArrayList* _ep_list = NULL;
				BirdFontPath* _tmp216_;
				GeeArrayList* _tmp217_;
				GeeArrayList* _tmp218_;
				gint _ep_size = 0;
				GeeArrayList* _tmp219_;
				gint _tmp220_;
				gint _tmp221_;
				gint _ep_index = 0;
				_tmp216_ = pp;
				_tmp217_ = bird_font_path_get_points (_tmp216_);
				_tmp218_ = _tmp217_;
				_ep_list = _tmp218_;
				_tmp219_ = _ep_list;
				_tmp220_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp219_);
				_tmp221_ = _tmp220_;
				_ep_size = _tmp221_;
				_ep_index = -1;
				while (TRUE) {
					gint _tmp222_;
					gint _tmp223_;
					BirdFontEditPoint* ep = NULL;
					GeeArrayList* _tmp224_;
					gpointer _tmp225_;
					gboolean _tmp226_ = FALSE;
					gboolean _tmp227_ = FALSE;
					gboolean _tmp228_ = FALSE;
					gboolean _tmp229_ = FALSE;
					BirdFontEditPoint* _tmp230_;
					BirdFontEditPoint* _tmp240_;
					BirdFontEditPoint* _tmp241_;
					_ep_index = _ep_index + 1;
					_tmp222_ = _ep_index;
					_tmp223_ = _ep_size;
					if (!(_tmp222_ < _tmp223_)) {
						break;
					}
					_tmp224_ = _ep_list;
					_tmp225_ = gee_abstract_list_get ((GeeAbstractList*) _tmp224_, _ep_index);
					ep = (BirdFontEditPoint*) _tmp225_;
					_tmp230_ = prev;
					if ((_tmp230_->flags & BIRD_FONT_EDIT_POINT_SELF_INTERSECTION) > ((guint) 0)) {
						_tmp229_ = TRUE;
					} else {
						BirdFontEditPoint* _tmp231_;
						_tmp231_ = prev;
						_tmp229_ = (_tmp231_->flags & BIRD_FONT_EDIT_POINT_INTERSECTION) > ((guint) 0);
					}
					if (_tmp229_) {
						gboolean _tmp232_ = FALSE;
						BirdFontEditPoint* _tmp233_;
						_tmp233_ = ep;
						if ((_tmp233_->flags & BIRD_FONT_EDIT_POINT_SELF_INTERSECTION) > ((guint) 0)) {
							_tmp232_ = TRUE;
						} else {
							BirdFontEditPoint* _tmp234_;
							_tmp234_ = ep;
							_tmp232_ = (_tmp234_->flags & BIRD_FONT_EDIT_POINT_INTERSECTION) > ((guint) 0);
						}
						_tmp228_ = _tmp232_;
					} else {
						_tmp228_ = FALSE;
					}
					if (_tmp228_) {
						BirdFontEditPoint* _tmp235_;
						BirdFontEditPoint* _tmp236_;
						_tmp235_ = ep;
						_tmp236_ = prev;
						_tmp227_ = fabs (_tmp235_->x - _tmp236_->x) < 0.2;
					} else {
						_tmp227_ = FALSE;
					}
					if (_tmp227_) {
						BirdFontEditPoint* _tmp237_;
						BirdFontEditPoint* _tmp238_;
						_tmp237_ = ep;
						_tmp238_ = prev;
						_tmp226_ = fabs (_tmp237_->y - _tmp238_->y) < 0.2;
					} else {
						_tmp226_ = FALSE;
					}
					if (_tmp226_) {
						BirdFontEditPoint* _tmp239_;
						_tmp239_ = prev;
						bird_font_edit_point_set_deleted (_tmp239_, TRUE);
					}
					_tmp240_ = ep;
					_tmp241_ = _g_object_ref0 (_tmp240_);
					_g_object_unref0 (prev);
					prev = _tmp241_;
					_g_object_unref0 (ep);
				}
			}
			_g_object_unref0 (pp);
		}
	}
	{
		GeeArrayList* _pp_list = NULL;
		BirdFontPathList* _tmp242_;
		GeeArrayList* _tmp243_;
		gint _pp_size = 0;
		GeeArrayList* _tmp244_;
		gint _tmp245_;
		gint _tmp246_;
		gint _pp_index = 0;
		_tmp242_ = o;
		_tmp243_ = _tmp242_->paths;
		_pp_list = _tmp243_;
		_tmp244_ = _pp_list;
		_tmp245_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp244_);
		_tmp246_ = _tmp245_;
		_pp_size = _tmp246_;
		_pp_index = -1;
		while (TRUE) {
			gint _tmp247_;
			gint _tmp248_;
			BirdFontPath* pp = NULL;
			GeeArrayList* _tmp249_;
			gpointer _tmp250_;
			BirdFontPath* _tmp251_;
			_pp_index = _pp_index + 1;
			_tmp247_ = _pp_index;
			_tmp248_ = _pp_size;
			if (!(_tmp247_ < _tmp248_)) {
				break;
			}
			_tmp249_ = _pp_list;
			_tmp250_ = gee_abstract_list_get ((GeeAbstractList*) _tmp249_, _pp_index);
			pp = (BirdFontPath*) _tmp250_;
			_tmp251_ = pp;
			bird_font_path_remove_deleted_points (_tmp251_);
			_g_object_unref0 (pp);
		}
	}
	{
		GeeArrayList* _p_list = NULL;
		BirdFontPathList* _tmp252_;
		GeeArrayList* _tmp253_;
		gint _p_size = 0;
		GeeArrayList* _tmp254_;
		gint _tmp255_;
		gint _tmp256_;
		gint _p_index = 0;
		_tmp252_ = o;
		_tmp253_ = _tmp252_->paths;
		_p_list = _tmp253_;
		_tmp254_ = _p_list;
		_tmp255_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp254_);
		_tmp256_ = _tmp255_;
		_p_size = _tmp256_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp257_;
			gint _tmp258_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp259_;
			gpointer _tmp260_;
			_p_index = _p_index + 1;
			_tmp257_ = _p_index;
			_tmp258_ = _p_size;
			if (!(_tmp257_ < _tmp258_)) {
				break;
			}
			_tmp259_ = _p_list;
			_tmp260_ = gee_abstract_list_get ((GeeAbstractList*) _tmp259_, _p_index);
			p = (BirdFontPath*) _tmp260_;
			{
				GeeArrayList* _ep_list = NULL;
				BirdFontPath* _tmp261_;
				GeeArrayList* _tmp262_;
				GeeArrayList* _tmp263_;
				gint _ep_size = 0;
				GeeArrayList* _tmp264_;
				gint _tmp265_;
				gint _tmp266_;
				gint _ep_index = 0;
				_tmp261_ = p;
				_tmp262_ = bird_font_path_get_points (_tmp261_);
				_tmp263_ = _tmp262_;
				_ep_list = _tmp263_;
				_tmp264_ = _ep_list;
				_tmp265_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp264_);
				_tmp266_ = _tmp265_;
				_ep_size = _tmp266_;
				_ep_index = -1;
				while (TRUE) {
					gint _tmp267_;
					gint _tmp268_;
					BirdFontEditPoint* ep = NULL;
					GeeArrayList* _tmp269_;
					gpointer _tmp270_;
					BirdFontEditPoint* _tmp271_;
					BirdFontEditPoint* _tmp272_;
					_ep_index = _ep_index + 1;
					_tmp267_ = _ep_index;
					_tmp268_ = _ep_size;
					if (!(_tmp267_ < _tmp268_)) {
						break;
					}
					_tmp269_ = _ep_list;
					_tmp270_ = gee_abstract_list_get ((GeeAbstractList*) _tmp269_, _ep_index);
					ep = (BirdFontEditPoint*) _tmp270_;
					_tmp271_ = ep;
					_tmp272_ = ep;
					_tmp272_->flags = _tmp272_->flags & (~BIRD_FONT_EDIT_POINT_COPIED);
					_g_object_unref0 (ep);
				}
			}
			_g_object_unref0 (p);
		}
	}
	_tmp273_ = o;
	_tmp274_ = _tmp273_->paths;
	_tmp275_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp274_);
	_tmp276_ = _tmp275_;
	_tmp277_ = r;
	g_return_val_if_fail (_tmp276_ == 2, _tmp277_);
	_tmp278_ = o;
	_tmp279_ = _tmp278_->paths;
	_tmp280_ = gee_abstract_list_get ((GeeAbstractList*) _tmp279_, 0);
	_g_object_unref0 (p1);
	p1 = (BirdFontPath*) _tmp280_;
	_tmp281_ = o;
	_tmp282_ = _tmp281_->paths;
	_tmp283_ = gee_abstract_list_get ((GeeAbstractList*) _tmp282_, 1);
	_g_object_unref0 (p2);
	p2 = (BirdFontPath*) _tmp283_;
	_tmp284_ = bird_font_path_list_new ();
	parts = _tmp284_;
	if (self_intersection) {
		BirdFontPathList* self_parts = NULL;
		BirdFontPath* _tmp285_;
		gboolean _tmp286_ = FALSE;
		BirdFontPathList* _tmp287_;
		BirdFontPathList* _tmp289_;
		BirdFontPathList* _tmp290_;
		_tmp285_ = p1;
		_tmp287_ = bird_font_stroke_tool_remove_self_intersections (self, _tmp285_, &_tmp286_);
		_vala__error_ = _tmp286_;
		_g_object_unref0 (self_parts);
		self_parts = _tmp287_;
		if (_vala__error_) {
			BirdFontPathList* _tmp288_;
			g_warning ("StrokeTool.vala:492: remove_self_intersections failed");
			_tmp288_ = bird_font_path_list_new ();
			result = _tmp288_;
			_g_object_unref0 (self_parts);
			_g_object_unref0 (parts);
			_g_object_unref0 (p2);
			_g_object_unref0 (p1);
			_g_object_unref0 (prev);
			_g_object_unref0 (r);
			_g_object_unref0 (pl);
			_g_object_unref0 (o);
			_g_object_unref0 (flat);
			if (_error_) {
				*_error_ = _vala__error_;
			}
			return result;
		}
		_tmp289_ = parts;
		_tmp290_ = self_parts;
		bird_font_path_list_append (_tmp289_, _tmp290_);
		_g_object_unref0 (self_parts);
	} else {
		BirdFontPathList* merged_paths = NULL;
		BirdFontPath* _tmp291_;
		BirdFontPath* _tmp292_;
		BirdFontPathList* _tmp293_;
		BirdFontPathList* _tmp294_;
		GeeArrayList* _tmp295_;
		gint _tmp296_;
		gint _tmp297_;
		_tmp291_ = p1;
		_tmp292_ = p2;
		_tmp293_ = bird_font_stroke_tool_merge_paths_with_curves (self, _tmp291_, _tmp292_);
		merged_paths = _tmp293_;
		_tmp294_ = merged_paths;
		_tmp295_ = _tmp294_->paths;
		_tmp296_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp295_);
		_tmp297_ = _tmp296_;
		if (_tmp297_ > 0) {
			BirdFontPathList* _tmp298_;
			BirdFontPathList* _tmp299_;
			_tmp298_ = parts;
			_tmp299_ = merged_paths;
			bird_font_path_list_append (_tmp298_, _tmp299_);
		} else {
			BirdFontPathList* _tmp300_;
			BirdFontPath* _tmp301_;
			BirdFontPathList* _tmp302_;
			BirdFontPath* _tmp303_;
			_tmp300_ = parts;
			_tmp301_ = p1;
			bird_font_path_list_add (_tmp300_, _tmp301_);
			_tmp302_ = parts;
			_tmp303_ = p2;
			bird_font_path_list_add (_tmp302_, _tmp303_);
		}
		_g_object_unref0 (merged_paths);
	}
	{
		GeeArrayList* _p_list = NULL;
		BirdFontPathList* _tmp304_;
		GeeArrayList* _tmp305_;
		gint _p_size = 0;
		GeeArrayList* _tmp306_;
		gint _tmp307_;
		gint _tmp308_;
		gint _p_index = 0;
		_tmp304_ = parts;
		_tmp305_ = _tmp304_->paths;
		_p_list = _tmp305_;
		_tmp306_ = _p_list;
		_tmp307_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp306_);
		_tmp308_ = _tmp307_;
		_p_size = _tmp308_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp309_;
			gint _tmp310_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp311_;
			gpointer _tmp312_;
			BirdFontPath* _tmp313_;
			_p_index = _p_index + 1;
			_tmp309_ = _p_index;
			_tmp310_ = _p_size;
			if (!(_tmp309_ < _tmp310_)) {
				break;
			}
			_tmp311_ = _p_list;
			_tmp312_ = gee_abstract_list_get ((GeeAbstractList*) _tmp311_, _p_index);
			p = (BirdFontPath*) _tmp312_;
			_tmp313_ = p;
			bird_font_stroke_tool_reset_intersections (self, _tmp313_);
			_g_object_unref0 (p);
		}
	}
	bird_font_stroke_tool_reset_intersections (self, path1);
	bird_font_stroke_tool_reset_intersections (self, path2);
	result = parts;
	_g_object_unref0 (p2);
	_g_object_unref0 (p1);
	_g_object_unref0 (prev);
	_g_object_unref0 (r);
	_g_object_unref0 (pl);
	_g_object_unref0 (o);
	_g_object_unref0 (flat);
	if (_error_) {
		*_error_ = _vala__error_;
	}
	return result;
}

/** Add hidden double points to make sure that the path does not
 * change when new points are added to a 2x2 path.
 */
static void
bird_font_stroke_tool_add_double_point_at_intersection (BirdFontStrokeTool* self,
                                                        BirdFontPath* pp,
                                                        BirdFontEditPoint* lep,
                                                        BirdFontEditPoint* ep)
{
	BirdFontEditPoint* prev = NULL;
	BirdFontEditPoint* next = NULL;
	BirdFontEditPoint* hidden = NULL;
	gdouble px = 0.0;
	gdouble py = 0.0;
	gboolean _tmp0_ = FALSE;
	BirdFontEditPointHandle* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pp != NULL);
	g_return_if_fail (lep != NULL);
	g_return_if_fail (ep != NULL);
	_tmp1_ = bird_font_edit_point_get_right_handle (lep);
	if (_tmp1_->type == BIRD_FONT_POINT_TYPE_DOUBLE_CURVE) {
		_tmp0_ = TRUE;
	} else {
		BirdFontEditPointHandle* _tmp2_;
		_tmp2_ = bird_font_edit_point_get_right_handle (lep);
		_tmp0_ = _tmp2_->type == BIRD_FONT_POINT_TYPE_LINE_DOUBLE_CURVE;
	}
	if (_tmp0_) {
		BirdFontEditPoint* _tmp3_;
		BirdFontEditPoint* _tmp4_;
		BirdFontEditPoint* _tmp5_;
		BirdFontEditPoint* _tmp6_;
		BirdFontEditPoint* _tmp7_;
		BirdFontEditPoint* _tmp8_;
		BirdFontEditPoint* _tmp9_;
		BirdFontEditPoint* _tmp10_;
		BirdFontEditPointHandle* _tmp11_;
		gdouble _tmp12_;
		gdouble _tmp13_;
		BirdFontEditPoint* _tmp14_;
		BirdFontEditPointHandle* _tmp15_;
		gdouble _tmp16_;
		gdouble _tmp17_;
		BirdFontEditPoint* _tmp18_;
		BirdFontEditPointHandle* _tmp19_;
		gdouble _tmp20_;
		gdouble _tmp21_;
		BirdFontEditPoint* _tmp22_;
		BirdFontEditPointHandle* _tmp23_;
		gdouble _tmp24_;
		gdouble _tmp25_;
		BirdFontEditPoint* _tmp26_;
		BirdFontEditPoint* _tmp27_;
		BirdFontEditPoint* _tmp28_;
		BirdFontEditPointHandle* _tmp29_;
		BirdFontEditPoint* _tmp30_;
		BirdFontEditPointHandle* _tmp31_;
		gdouble _tmp32_;
		gdouble _tmp33_;
		BirdFontEditPoint* _tmp34_;
		BirdFontEditPointHandle* _tmp35_;
		BirdFontEditPoint* _tmp36_;
		BirdFontEditPointHandle* _tmp37_;
		gdouble _tmp38_;
		gdouble _tmp39_;
		BirdFontEditPoint* _tmp40_;
		BirdFontEditPointHandle* _tmp41_;
		BirdFontEditPoint* _tmp42_;
		BirdFontEditPointHandle* _tmp43_;
		gdouble _tmp44_;
		gdouble _tmp45_;
		BirdFontEditPoint* _tmp46_;
		BirdFontEditPointHandle* _tmp47_;
		BirdFontEditPoint* _tmp48_;
		BirdFontEditPointHandle* _tmp49_;
		gdouble _tmp50_;
		gdouble _tmp51_;
		BirdFontEditPoint* _tmp52_;
		BirdFontEditPoint* _tmp53_;
		BirdFontEditPoint* _tmp54_;
		BirdFontEditPoint* _tmp55_;
		BirdFontEditPoint* _tmp56_;
		BirdFontEditPointHandle* _tmp57_;
		BirdFontEditPoint* _tmp58_;
		BirdFontEditPointHandle* _tmp59_;
		BirdFontEditPoint* _tmp60_;
		BirdFontEditPointHandle* _tmp61_;
		BirdFontEditPoint* _tmp62_;
		BirdFontEditPointHandle* _tmp63_;
		BirdFontEditPoint* _tmp64_;
		BirdFontEditPoint* _tmp65_;
		_tmp3_ = lep->prev;
		g_return_if_fail (_tmp3_ != NULL);
		_tmp4_ = lep->next;
		g_return_if_fail (_tmp4_ != NULL);
		_tmp5_ = bird_font_edit_point_get_prev (lep);
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_g_object_unref0 (prev);
		prev = _tmp6_;
		_tmp7_ = bird_font_edit_point_get_next (lep);
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_g_object_unref0 (next);
		next = _tmp8_;
		_tmp9_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_QUADRATIC);
		_g_object_unref0 (hidden);
		hidden = _tmp9_;
		_tmp10_ = next;
		_tmp11_ = bird_font_edit_point_get_left_handle (_tmp10_);
		_tmp12_ = bird_font_edit_point_handle_get_x (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = prev;
		_tmp15_ = bird_font_edit_point_get_right_handle (_tmp14_);
		_tmp16_ = bird_font_edit_point_handle_get_x (_tmp15_);
		_tmp17_ = _tmp16_;
		px = (_tmp13_ + _tmp17_) / 2.0;
		_tmp18_ = next;
		_tmp19_ = bird_font_edit_point_get_left_handle (_tmp18_);
		_tmp20_ = bird_font_edit_point_handle_get_y (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = prev;
		_tmp23_ = bird_font_edit_point_get_right_handle (_tmp22_);
		_tmp24_ = bird_font_edit_point_handle_get_y (_tmp23_);
		_tmp25_ = _tmp24_;
		py = (_tmp21_ + _tmp25_) / 2.0;
		_tmp26_ = hidden;
		bird_font_edit_point_set_independent_x (_tmp26_, px);
		_tmp27_ = hidden;
		bird_font_edit_point_set_independent_y (_tmp27_, py);
		_tmp28_ = hidden;
		_tmp29_ = bird_font_edit_point_get_right_handle (_tmp28_);
		_tmp30_ = next;
		_tmp31_ = bird_font_edit_point_get_left_handle (_tmp30_);
		_tmp32_ = bird_font_edit_point_handle_get_x (_tmp31_);
		_tmp33_ = _tmp32_;
		bird_font_edit_point_handle_set_x (_tmp29_, _tmp33_);
		_tmp34_ = hidden;
		_tmp35_ = bird_font_edit_point_get_right_handle (_tmp34_);
		_tmp36_ = next;
		_tmp37_ = bird_font_edit_point_get_left_handle (_tmp36_);
		_tmp38_ = bird_font_edit_point_handle_get_y (_tmp37_);
		_tmp39_ = _tmp38_;
		bird_font_edit_point_handle_set_y (_tmp35_, _tmp39_);
		_tmp40_ = hidden;
		_tmp41_ = bird_font_edit_point_get_left_handle (_tmp40_);
		_tmp42_ = prev;
		_tmp43_ = bird_font_edit_point_get_right_handle (_tmp42_);
		_tmp44_ = bird_font_edit_point_handle_get_x (_tmp43_);
		_tmp45_ = _tmp44_;
		bird_font_edit_point_handle_set_x (_tmp41_, _tmp45_);
		_tmp46_ = hidden;
		_tmp47_ = bird_font_edit_point_get_left_handle (_tmp46_);
		_tmp48_ = prev;
		_tmp49_ = bird_font_edit_point_get_right_handle (_tmp48_);
		_tmp50_ = bird_font_edit_point_handle_get_y (_tmp49_);
		_tmp51_ = _tmp50_;
		bird_font_edit_point_handle_set_y (_tmp47_, _tmp51_);
		_tmp52_ = hidden;
		_tmp53_ = prev;
		_tmp54_ = bird_font_path_add_point_after (pp, _tmp52_, _tmp53_);
		_tmp55_ = _tmp54_;
		_g_object_unref0 (_tmp55_);
		_tmp56_ = hidden;
		_tmp57_ = bird_font_edit_point_get_right_handle (_tmp56_);
		_tmp57_->type = BIRD_FONT_POINT_TYPE_QUADRATIC;
		_tmp58_ = hidden;
		_tmp59_ = bird_font_edit_point_get_left_handle (_tmp58_);
		_tmp59_->type = BIRD_FONT_POINT_TYPE_QUADRATIC;
		_tmp60_ = prev;
		_tmp61_ = bird_font_edit_point_get_right_handle (_tmp60_);
		_tmp61_->type = BIRD_FONT_POINT_TYPE_QUADRATIC;
		_tmp62_ = next;
		_tmp63_ = bird_font_edit_point_get_left_handle (_tmp62_);
		_tmp63_->type = BIRD_FONT_POINT_TYPE_QUADRATIC;
		_tmp64_ = prev;
		_tmp64_->type = BIRD_FONT_POINT_TYPE_QUADRATIC;
		_tmp65_ = next;
		_tmp65_->type = BIRD_FONT_POINT_TYPE_QUADRATIC;
		bird_font_path_get_closest_point_on_path (pp, lep, ep->x, ep->y, NULL, NULL, -1);
	}
	_g_object_unref0 (hidden);
	_g_object_unref0 (next);
	_g_object_unref0 (prev);
}

static BirdFontPathList*
bird_font_stroke_tool_remove_self_intersections (BirdFontStrokeTool* self,
                                                 BirdFontPath* original,
                                                 gboolean* _error_)
{
	gboolean _vala__error_ = FALSE;
	BirdFontPath* merged = NULL;
	BirdFontPath* _tmp0_;
	BirdFontIntersectionList* intersections = NULL;
	BirdFontIntersectionList* _tmp1_;
	BirdFontEditPoint* ep1 = NULL;
	BirdFontEditPoint* ep2 = NULL;
	BirdFontEditPoint* found = NULL;
	gdouble d = 0.0;
	gdouble min_d = 0.0;
	BirdFontPath* current = NULL;
	gboolean found_intersection = FALSE;
	BirdFontPathList* parts = NULL;
	gint i = 0;
	BirdFontPath* path = NULL;
	BirdFontPath* _tmp2_;
	BirdFontPath* _tmp3_;
	BirdFontPathList* _tmp4_;
	BirdFontPath* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	BirdFontIntersectionList* _tmp89_;
	GeeArrayList* _tmp90_;
	gint _tmp91_;
	gint _tmp92_;
	BirdFontPath* _tmp93_;
	BirdFontPath* _tmp94_;
	BirdFontPath* _tmp95_;
	BirdFontPathList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (original != NULL, NULL);
	_tmp0_ = bird_font_path_new ();
	merged = _tmp0_;
	_tmp1_ = bird_font_intersection_list_new ();
	intersections = _tmp1_;
	i = 0;
	_tmp2_ = bird_font_path_copy (original);
	path = _tmp2_;
	_vala__error_ = FALSE;
	_tmp3_ = path;
	bird_font_path_remove_points_on_points (_tmp3_, 0.00001);
	_tmp4_ = bird_font_path_list_new ();
	_g_object_unref0 (parts);
	parts = _tmp4_;
	_tmp5_ = path;
	_tmp6_ = bird_font_path_get_points (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ <= 1) {
		result = parts;
		_g_object_unref0 (path);
		_g_object_unref0 (current);
		_g_object_unref0 (found);
		_g_object_unref0 (ep2);
		_g_object_unref0 (ep1);
		_g_object_unref0 (intersections);
		_g_object_unref0 (merged);
		if (_error_) {
			*_error_ = _vala__error_;
		}
		return result;
	}
	{
		GeeArrayList* _n_list = NULL;
		BirdFontPath* _tmp10_;
		GeeArrayList* _tmp11_;
		GeeArrayList* _tmp12_;
		gint _n_size = 0;
		GeeArrayList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _n_index = 0;
		_tmp10_ = path;
		_tmp11_ = bird_font_path_get_points (_tmp10_);
		_tmp12_ = _tmp11_;
		_n_list = _tmp12_;
		_tmp13_ = _n_list;
		_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_n_size = _tmp15_;
		_n_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			BirdFontEditPoint* n = NULL;
			GeeArrayList* _tmp18_;
			gpointer _tmp19_;
			BirdFontEditPoint* _tmp20_;
			BirdFontEditPoint* _tmp21_;
			_n_index = _n_index + 1;
			_tmp16_ = _n_index;
			_tmp17_ = _n_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _n_list;
			_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _n_index);
			n = (BirdFontEditPoint*) _tmp19_;
			_tmp20_ = n;
			_tmp21_ = n;
			_tmp21_->flags = _tmp21_->flags & (~BIRD_FONT_EDIT_POINT_COPIED);
			_g_object_unref0 (n);
		}
	}
	{
		gboolean _tmp22_ = FALSE;
		i = 0;
		_tmp22_ = TRUE;
		while (TRUE) {
			BirdFontPath* _tmp24_;
			GeeArrayList* _tmp25_;
			GeeArrayList* _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			BirdFontPath* _tmp29_;
			GeeArrayList* _tmp30_;
			GeeArrayList* _tmp31_;
			gpointer _tmp32_;
			gboolean _tmp33_ = FALSE;
			BirdFontEditPoint* _tmp34_;
			if (!_tmp22_) {
				gint _tmp23_;
				_tmp23_ = i;
				i = _tmp23_ + 1;
			}
			_tmp22_ = FALSE;
			_tmp24_ = path;
			_tmp25_ = bird_font_path_get_points (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp26_);
			_tmp28_ = _tmp27_;
			if (!(i < _tmp28_)) {
				break;
			}
			_tmp29_ = path;
			_tmp30_ = bird_font_path_get_points (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, i);
			_g_object_unref0 (ep1);
			ep1 = (BirdFontEditPoint*) _tmp32_;
			_tmp34_ = ep1;
			if ((_tmp34_->flags & BIRD_FONT_EDIT_POINT_SELF_INTERSECTION) > ((guint) 0)) {
				BirdFontEditPoint* _tmp35_;
				_tmp35_ = ep1;
				_tmp33_ = (_tmp35_->flags & BIRD_FONT_EDIT_POINT_COPIED) == ((guint) 0);
			} else {
				_tmp33_ = FALSE;
			}
			if (_tmp33_) {
				BirdFontEditPoint* _tmp36_;
				BirdFontEditPoint* _tmp37_;
				BirdFontEditPoint* _tmp38_;
				BirdFontEditPoint* _tmp62_;
				BirdFontEditPoint* _tmp63_;
				BirdFontEditPoint* _tmp64_;
				BirdFontEditPoint* _tmp65_;
				BirdFontEditPoint* _tmp66_;
				BirdFontEditPoint* _tmp67_;
				BirdFontIntersection* intersection = NULL;
				BirdFontEditPoint* _tmp68_;
				BirdFontPath* _tmp69_;
				BirdFontEditPoint* _tmp70_;
				BirdFontPath* _tmp71_;
				BirdFontIntersection* _tmp72_;
				BirdFontIntersection* _tmp73_;
				BirdFontIntersectionList* _tmp74_;
				GeeArrayList* _tmp75_;
				BirdFontIntersection* _tmp76_;
				_tmp36_ = ep1;
				_tmp37_ = ep1;
				_tmp37_->flags = _tmp37_->flags | BIRD_FONT_EDIT_POINT_COPIED;
				_tmp38_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
				_g_object_unref0 (found);
				found = _tmp38_;
				min_d = DBL_MAX;
				found_intersection = FALSE;
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp39_ = FALSE;
						_tmp39_ = TRUE;
						while (TRUE) {
							BirdFontPath* _tmp41_;
							GeeArrayList* _tmp42_;
							GeeArrayList* _tmp43_;
							gint _tmp44_;
							gint _tmp45_;
							BirdFontPath* _tmp46_;
							GeeArrayList* _tmp47_;
							GeeArrayList* _tmp48_;
							gpointer _tmp49_;
							BirdFontEditPoint* _tmp50_;
							BirdFontEditPoint* _tmp51_;
							gboolean _tmp52_ = FALSE;
							BirdFontEditPoint* _tmp53_;
							if (!_tmp39_) {
								gint _tmp40_;
								_tmp40_ = j;
								j = _tmp40_ + 1;
							}
							_tmp39_ = FALSE;
							_tmp41_ = path;
							_tmp42_ = bird_font_path_get_points (_tmp41_);
							_tmp43_ = _tmp42_;
							_tmp44_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp43_);
							_tmp45_ = _tmp44_;
							if (!(j < _tmp45_)) {
								break;
							}
							_tmp46_ = path;
							_tmp47_ = bird_font_path_get_points (_tmp46_);
							_tmp48_ = _tmp47_;
							_tmp49_ = gee_abstract_list_get ((GeeAbstractList*) _tmp48_, j);
							_g_object_unref0 (ep2);
							ep2 = (BirdFontEditPoint*) _tmp49_;
							_tmp50_ = ep1;
							_tmp51_ = ep2;
							d = bird_font_path_distance_to_point (_tmp50_, _tmp51_);
							_tmp53_ = ep2;
							if ((_tmp53_->flags & BIRD_FONT_EDIT_POINT_COPIED) == ((guint) 0)) {
								BirdFontEditPoint* _tmp54_;
								_tmp54_ = ep2;
								_tmp52_ = (_tmp54_->flags & BIRD_FONT_EDIT_POINT_SELF_INTERSECTION) > ((guint) 0);
							} else {
								_tmp52_ = FALSE;
							}
							if (_tmp52_) {
								if (d < min_d) {
									BirdFontEditPoint* _tmp55_;
									BirdFontEditPoint* _tmp56_;
									min_d = d;
									found_intersection = TRUE;
									_tmp55_ = ep2;
									_tmp56_ = _g_object_ref0 (_tmp55_);
									_g_object_unref0 (found);
									found = _tmp56_;
								}
							}
						}
					}
				}
				if (!found_intersection) {
					BirdFontEditPoint* _tmp57_;
					gchar* _tmp58_;
					gchar* _tmp59_;
					gchar* _tmp60_;
					gchar* _tmp61_;
					_tmp57_ = ep1;
					_tmp58_ = bird_font_edit_point_to_string (_tmp57_);
					_tmp59_ = _tmp58_;
					_tmp60_ = g_strconcat ("No self intersection:\n", _tmp59_, NULL);
					_tmp61_ = _tmp60_;
					g_warning ("StrokeTool.vala:614: %s", _tmp61_);
					_g_free0 (_tmp61_);
					_g_free0 (_tmp59_);
					result = parts;
					_g_object_unref0 (path);
					_g_object_unref0 (current);
					_g_object_unref0 (found);
					_g_object_unref0 (ep2);
					_g_object_unref0 (ep1);
					_g_object_unref0 (intersections);
					_g_object_unref0 (merged);
					if (_error_) {
						*_error_ = _vala__error_;
					}
					return result;
				}
				_tmp62_ = ep1;
				bird_font_edit_point_set_tie_handles (_tmp62_, FALSE);
				_tmp63_ = ep1;
				bird_font_edit_point_set_reflective_point (_tmp63_, FALSE);
				_tmp64_ = found;
				bird_font_edit_point_set_tie_handles (_tmp64_, FALSE);
				_tmp65_ = found;
				bird_font_edit_point_set_reflective_point (_tmp65_, FALSE);
				_tmp66_ = found;
				_tmp67_ = found;
				_tmp67_->flags = _tmp67_->flags | BIRD_FONT_EDIT_POINT_COPIED;
				_tmp68_ = ep1;
				_tmp69_ = path;
				_tmp70_ = found;
				_tmp71_ = path;
				_tmp72_ = bird_font_intersection_new (_tmp68_, _tmp69_, _tmp70_, _tmp71_);
				intersection = _tmp72_;
				_tmp73_ = intersection;
				_tmp73_->self_intersection = TRUE;
				_tmp74_ = intersections;
				_tmp75_ = _tmp74_->points;
				_tmp76_ = intersection;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp75_, _tmp76_);
				_g_object_unref0 (intersection);
			}
		}
	}
	{
		GeeArrayList* _n_list = NULL;
		BirdFontPath* _tmp77_;
		GeeArrayList* _tmp78_;
		GeeArrayList* _tmp79_;
		gint _n_size = 0;
		GeeArrayList* _tmp80_;
		gint _tmp81_;
		gint _tmp82_;
		gint _n_index = 0;
		_tmp77_ = path;
		_tmp78_ = bird_font_path_get_points (_tmp77_);
		_tmp79_ = _tmp78_;
		_n_list = _tmp79_;
		_tmp80_ = _n_list;
		_tmp81_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp80_);
		_tmp82_ = _tmp81_;
		_n_size = _tmp82_;
		_n_index = -1;
		while (TRUE) {
			gint _tmp83_;
			gint _tmp84_;
			BirdFontEditPoint* n = NULL;
			GeeArrayList* _tmp85_;
			gpointer _tmp86_;
			BirdFontEditPoint* _tmp87_;
			BirdFontEditPoint* _tmp88_;
			_n_index = _n_index + 1;
			_tmp83_ = _n_index;
			_tmp84_ = _n_size;
			if (!(_tmp83_ < _tmp84_)) {
				break;
			}
			_tmp85_ = _n_list;
			_tmp86_ = gee_abstract_list_get ((GeeAbstractList*) _tmp85_, _n_index);
			n = (BirdFontEditPoint*) _tmp86_;
			_tmp87_ = n;
			_tmp88_ = n;
			_tmp88_->flags = _tmp88_->flags & (~BIRD_FONT_EDIT_POINT_COPIED);
			_g_object_unref0 (n);
		}
	}
	_tmp89_ = intersections;
	_tmp90_ = _tmp89_->points;
	_tmp91_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp90_);
	_tmp92_ = _tmp91_;
	if (_tmp92_ == 0) {
		g_warning ("StrokeTool.vala:636: No intersection points.");
		_vala__error_ = TRUE;
		result = parts;
		_g_object_unref0 (path);
		_g_object_unref0 (current);
		_g_object_unref0 (found);
		_g_object_unref0 (ep2);
		_g_object_unref0 (ep1);
		_g_object_unref0 (intersections);
		_g_object_unref0 (merged);
		if (_error_) {
			*_error_ = _vala__error_;
		}
		return result;
	}
	_tmp93_ = path;
	_tmp94_ = _g_object_ref0 (_tmp93_);
	_g_object_unref0 (current);
	current = _tmp94_;
	_tmp95_ = current;
	bird_font_path_reverse (_tmp95_);
	while (TRUE) {
		BirdFontEditPoint* modified = NULL;
		BirdFontIntersection* new_start = NULL;
		BirdFontIntersection* _tmp96_;
		BirdFontPath* _tmp97_;
		GeeArrayList* _tmp98_;
		GeeArrayList* _tmp99_;
		gpointer _tmp100_;
		BirdFontPath* _tmp101_;
		BirdFontPath* _tmp102_;
		BirdFontEditPoint* _tmp103_;
		BirdFontEditPoint* _tmp104_;
		gboolean _tmp121_ = FALSE;
		BirdFontPath* _tmp122_;
		GeeArrayList* _tmp123_;
		GeeArrayList* _tmp124_;
		gint _tmp125_;
		gint _tmp126_;
		BirdFontEditPoint* _tmp213_;
		BirdFontEditPoint* _tmp214_;
		i = 0;
		_tmp96_ = bird_font_intersection_new_empty ();
		new_start = _tmp96_;
		_tmp97_ = current;
		_tmp98_ = bird_font_path_get_points (_tmp97_);
		_tmp99_ = _tmp98_;
		_tmp100_ = gee_abstract_list_get ((GeeAbstractList*) _tmp99_, i);
		_g_object_unref0 (ep1);
		ep1 = (BirdFontEditPoint*) _tmp100_;
		_tmp101_ = path;
		_tmp102_ = _g_object_ref0 (_tmp101_);
		_g_object_unref0 (current);
		current = _tmp102_;
		_tmp103_ = ep1;
		_tmp104_ = bird_font_edit_point_copy (_tmp103_);
		_g_object_unref0 (modified);
		modified = _tmp104_;
		{
			gboolean _tmp105_ = FALSE;
			i = 0;
			_tmp105_ = TRUE;
			while (TRUE) {
				BirdFontPath* _tmp107_;
				GeeArrayList* _tmp108_;
				GeeArrayList* _tmp109_;
				gint _tmp110_;
				gint _tmp111_;
				BirdFontPath* _tmp112_;
				GeeArrayList* _tmp113_;
				GeeArrayList* _tmp114_;
				gpointer _tmp115_;
				BirdFontEditPoint* _tmp116_;
				BirdFontEditPoint* _tmp117_;
				gboolean _tmp118_ = FALSE;
				BirdFontEditPoint* _tmp119_;
				if (!_tmp105_) {
					gint _tmp106_;
					_tmp106_ = i;
					i = _tmp106_ + 1;
				}
				_tmp105_ = FALSE;
				_tmp107_ = current;
				_tmp108_ = bird_font_path_get_points (_tmp107_);
				_tmp109_ = _tmp108_;
				_tmp110_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp109_);
				_tmp111_ = _tmp110_;
				if (!(i < _tmp111_)) {
					break;
				}
				_tmp112_ = current;
				_tmp113_ = bird_font_path_get_points (_tmp112_);
				_tmp114_ = _tmp113_;
				_tmp115_ = gee_abstract_list_get ((GeeAbstractList*) _tmp114_, i);
				_g_object_unref0 (ep1);
				ep1 = (BirdFontEditPoint*) _tmp115_;
				_tmp116_ = ep1;
				_tmp117_ = bird_font_edit_point_copy (_tmp116_);
				_g_object_unref0 (modified);
				modified = _tmp117_;
				_tmp119_ = ep1;
				if ((_tmp119_->flags & BIRD_FONT_EDIT_POINT_COPIED) == ((guint) 0)) {
					BirdFontEditPoint* _tmp120_;
					_tmp120_ = ep1;
					_tmp118_ = (_tmp120_->flags & BIRD_FONT_EDIT_POINT_SELF_INTERSECTION) == ((guint) 0);
				} else {
					_tmp118_ = FALSE;
				}
				if (_tmp118_) {
					break;
				}
			}
		}
		_tmp122_ = current;
		_tmp123_ = bird_font_path_get_points (_tmp122_);
		_tmp124_ = _tmp123_;
		_tmp125_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp124_);
		_tmp126_ = _tmp125_;
		if (i >= _tmp126_) {
			_tmp121_ = TRUE;
		} else {
			BirdFontEditPoint* _tmp127_;
			_tmp127_ = ep1;
			_tmp121_ = (_tmp127_->flags & BIRD_FONT_EDIT_POINT_COPIED) > ((guint) 0);
		}
		if (_tmp121_) {
			_g_object_unref0 (new_start);
			_g_object_unref0 (modified);
			break;
		}
		while (TRUE) {
			BirdFontEditPoint* _tmp128_;
			BirdFontEditPoint* _tmp166_;
			BirdFontEditPoint* _tmp186_;
			BirdFontEditPoint* _tmp193_;
			BirdFontEditPoint* _tmp194_;
			BirdFontPath* _tmp195_;
			BirdFontEditPoint* _tmp196_;
			BirdFontEditPoint* _tmp197_;
			BirdFontEditPoint* _tmp198_;
			BirdFontEditPoint* _tmp199_;
			BirdFontEditPoint* _tmp200_;
			gint _tmp201_;
			BirdFontPath* _tmp202_;
			GeeArrayList* _tmp203_;
			GeeArrayList* _tmp204_;
			BirdFontPath* _tmp205_;
			GeeArrayList* _tmp206_;
			GeeArrayList* _tmp207_;
			gint _tmp208_;
			gint _tmp209_;
			gpointer _tmp210_;
			BirdFontEditPoint* _tmp211_;
			BirdFontEditPoint* _tmp212_;
			_tmp128_ = ep1;
			if ((_tmp128_->flags & BIRD_FONT_EDIT_POINT_SELF_INTERSECTION) > ((guint) 0)) {
				gboolean other = FALSE;
				BirdFontEditPointHandle* handle = NULL;
				BirdFontEditPoint* _tmp129_;
				BirdFontEditPointHandle* _tmp130_;
				BirdFontEditPointHandle* _tmp131_;
				BirdFontIntersectionList* _tmp132_;
				BirdFontEditPoint* _tmp133_;
				gboolean _tmp134_ = FALSE;
				BirdFontIntersection* _tmp135_;
				BirdFontEditPoint* _tmp136_ = NULL;
				BirdFontPath* _tmp141_;
				BirdFontPath* _tmp142_;
				GeeArrayList* _tmp143_;
				GeeArrayList* _tmp144_;
				gint _tmp145_;
				gint _tmp146_;
				gint _tmp147_;
				BirdFontPath* _tmp152_;
				GeeArrayList* _tmp153_;
				GeeArrayList* _tmp154_;
				gpointer _tmp155_;
				BirdFontEditPoint* _tmp156_;
				BirdFontEditPoint* _tmp157_;
				BirdFontEditPoint* _tmp158_;
				BirdFontEditPointHandle* _tmp159_;
				BirdFontEditPointHandle* _tmp160_;
				gdouble _tmp161_;
				gdouble _tmp162_;
				BirdFontEditPointHandle* _tmp163_;
				gdouble _tmp164_;
				gdouble _tmp165_;
				_tmp129_ = ep1;
				_tmp130_ = bird_font_edit_point_get_left_handle (_tmp129_);
				_tmp131_ = _g_object_ref0 (_tmp130_);
				_g_object_unref0 (handle);
				handle = _tmp131_;
				_tmp132_ = intersections;
				_tmp133_ = ep1;
				_tmp135_ = bird_font_intersection_list_get_point (_tmp132_, _tmp133_, &_tmp134_);
				other = _tmp134_;
				_g_object_unref0 (new_start);
				new_start = _tmp135_;
				if (other) {
					BirdFontIntersection* _tmp137_;
					BirdFontEditPoint* _tmp138_;
					_tmp137_ = new_start;
					_tmp138_ = _tmp137_->point;
					_tmp136_ = _tmp138_;
				} else {
					BirdFontIntersection* _tmp139_;
					BirdFontEditPoint* _tmp140_;
					_tmp139_ = new_start;
					_tmp140_ = _tmp139_->other_point;
					_tmp136_ = _tmp140_;
				}
				_tmp141_ = current;
				i = bird_font_stroke_tool_index_of (self, _tmp141_, _tmp136_);
				_tmp142_ = current;
				_tmp143_ = bird_font_path_get_points (_tmp142_);
				_tmp144_ = _tmp143_;
				_tmp145_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp144_);
				_tmp146_ = _tmp145_;
				_tmp147_ = i;
				if (!((0 <= _tmp147_) && (_tmp147_ < _tmp146_))) {
					gchar* _tmp148_;
					gchar* _tmp149_;
					gchar* _tmp150_;
					gchar* _tmp151_;
					_tmp148_ = g_strdup_printf ("%i", i);
					_tmp149_ = _tmp148_;
					_tmp150_ = g_strconcat ("Index out of bounds. (", _tmp149_, ")", NULL);
					_tmp151_ = _tmp150_;
					g_warning ("StrokeTool.vala:679: %s", _tmp151_);
					_g_free0 (_tmp151_);
					_g_free0 (_tmp149_);
					result = parts;
					_g_object_unref0 (handle);
					_g_object_unref0 (new_start);
					_g_object_unref0 (modified);
					_g_object_unref0 (path);
					_g_object_unref0 (current);
					_g_object_unref0 (found);
					_g_object_unref0 (ep2);
					_g_object_unref0 (ep1);
					_g_object_unref0 (intersections);
					_g_object_unref0 (merged);
					if (_error_) {
						*_error_ = _vala__error_;
					}
					return result;
				}
				_tmp152_ = current;
				_tmp153_ = bird_font_path_get_points (_tmp152_);
				_tmp154_ = _tmp153_;
				_tmp155_ = gee_abstract_list_get ((GeeAbstractList*) _tmp154_, i);
				_g_object_unref0 (ep1);
				ep1 = (BirdFontEditPoint*) _tmp155_;
				_tmp156_ = ep1;
				_tmp157_ = bird_font_edit_point_copy (_tmp156_);
				_g_object_unref0 (modified);
				modified = _tmp157_;
				_tmp158_ = modified;
				_tmp159_ = _tmp158_->left_handle;
				_tmp160_ = handle;
				_tmp161_ = bird_font_edit_point_handle_get_x (_tmp160_);
				_tmp162_ = _tmp161_;
				_tmp163_ = handle;
				_tmp164_ = bird_font_edit_point_handle_get_y (_tmp163_);
				_tmp165_ = _tmp164_;
				bird_font_edit_point_handle_move_to_coordinate (_tmp159_, _tmp162_, _tmp165_);
				_g_object_unref0 (handle);
			}
			_tmp166_ = ep1;
			if ((_tmp166_->flags & BIRD_FONT_EDIT_POINT_COPIED) > ((guint) 0)) {
				BirdFontPath* _tmp167_;
				BirdFontPath* _tmp168_;
				BirdFontPath* _tmp169_;
				BirdFontPathList* _tmp170_;
				BirdFontPath* _tmp171_;
				BirdFontPath* _tmp184_;
				BirdFontPath* _tmp185_;
				_tmp167_ = merged;
				bird_font_path_close (_tmp167_);
				_tmp168_ = merged;
				bird_font_path_close (_tmp168_);
				_tmp169_ = merged;
				bird_font_path_create_list (_tmp169_);
				_tmp170_ = parts;
				_tmp171_ = merged;
				bird_font_path_list_add (_tmp170_, _tmp171_);
				{
					GeeArrayList* _n_list = NULL;
					BirdFontPath* _tmp172_;
					GeeArrayList* _tmp173_;
					GeeArrayList* _tmp174_;
					gint _n_size = 0;
					GeeArrayList* _tmp175_;
					gint _tmp176_;
					gint _tmp177_;
					gint _n_index = 0;
					_tmp172_ = merged;
					_tmp173_ = bird_font_path_get_points (_tmp172_);
					_tmp174_ = _tmp173_;
					_n_list = _tmp174_;
					_tmp175_ = _n_list;
					_tmp176_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp175_);
					_tmp177_ = _tmp176_;
					_n_size = _tmp177_;
					_n_index = -1;
					while (TRUE) {
						gint _tmp178_;
						gint _tmp179_;
						BirdFontEditPoint* n = NULL;
						GeeArrayList* _tmp180_;
						gpointer _tmp181_;
						BirdFontEditPoint* _tmp182_;
						BirdFontEditPoint* _tmp183_;
						_n_index = _n_index + 1;
						_tmp178_ = _n_index;
						_tmp179_ = _n_size;
						if (!(_tmp178_ < _tmp179_)) {
							break;
						}
						_tmp180_ = _n_list;
						_tmp181_ = gee_abstract_list_get ((GeeAbstractList*) _tmp180_, _n_index);
						n = (BirdFontEditPoint*) _tmp181_;
						_tmp182_ = n;
						_tmp183_ = n;
						_tmp183_->flags = _tmp183_->flags & (~BIRD_FONT_EDIT_POINT_SELF_INTERSECTION);
						_g_object_unref0 (n);
					}
				}
				_tmp184_ = merged;
				bird_font_path_reverse (_tmp184_);
				_tmp185_ = bird_font_path_new ();
				_g_object_unref0 (merged);
				merged = _tmp185_;
				break;
			}
			_tmp186_ = ep1;
			if ((_tmp186_->flags & BIRD_FONT_EDIT_POINT_INTERSECTION) > ((guint) 0)) {
				BirdFontEditPoint* _tmp187_;
				BirdFontEditPointHandle* _tmp188_;
				BirdFontEditPoint* _tmp189_;
				BirdFontEditPointHandle* _tmp190_;
				BirdFontEditPoint* _tmp191_;
				BirdFontEditPoint* _tmp192_;
				_tmp187_ = ep1;
				_tmp188_ = _tmp187_->left_handle;
				bird_font_edit_point_handle_convert_to_curve (_tmp188_);
				_tmp189_ = ep1;
				_tmp190_ = _tmp189_->right_handle;
				bird_font_edit_point_handle_convert_to_curve (_tmp190_);
				_tmp191_ = ep1;
				bird_font_edit_point_set_tie_handles (_tmp191_, FALSE);
				_tmp192_ = ep1;
				bird_font_edit_point_set_reflective_point (_tmp192_, FALSE);
			}
			_tmp193_ = ep1;
			_tmp194_ = ep1;
			_tmp194_->flags = _tmp194_->flags | BIRD_FONT_EDIT_POINT_COPIED;
			_tmp195_ = merged;
			_tmp196_ = modified;
			_tmp197_ = bird_font_edit_point_copy (_tmp196_);
			_tmp198_ = _tmp197_;
			_tmp199_ = bird_font_path_add_point (_tmp195_, _tmp198_);
			_tmp200_ = _tmp199_;
			_g_object_unref0 (_tmp200_);
			_g_object_unref0 (_tmp198_);
			_tmp201_ = i;
			i = _tmp201_ + 1;
			_tmp202_ = current;
			_tmp203_ = bird_font_path_get_points (_tmp202_);
			_tmp204_ = _tmp203_;
			_tmp205_ = current;
			_tmp206_ = bird_font_path_get_points (_tmp205_);
			_tmp207_ = _tmp206_;
			_tmp208_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp207_);
			_tmp209_ = _tmp208_;
			_tmp210_ = gee_abstract_list_get ((GeeAbstractList*) _tmp204_, i % _tmp209_);
			_g_object_unref0 (ep1);
			ep1 = (BirdFontEditPoint*) _tmp210_;
			_tmp211_ = ep1;
			_tmp212_ = bird_font_edit_point_copy (_tmp211_);
			_g_object_unref0 (modified);
			modified = _tmp212_;
		}
		_tmp213_ = ep1;
		_tmp214_ = ep1;
		_tmp214_->flags = _tmp214_->flags | BIRD_FONT_EDIT_POINT_COPIED;
		_g_object_unref0 (new_start);
		_g_object_unref0 (modified);
	}
	result = parts;
	_g_object_unref0 (path);
	_g_object_unref0 (current);
	_g_object_unref0 (found);
	_g_object_unref0 (ep2);
	_g_object_unref0 (ep1);
	_g_object_unref0 (intersections);
	_g_object_unref0 (merged);
	if (_error_) {
		*_error_ = _vala__error_;
	}
	return result;
}

static BirdFontPathList*
bird_font_stroke_tool_merge_paths_with_curves (BirdFontStrokeTool* self,
                                               BirdFontPath* path1,
                                               BirdFontPath* path2)
{
	BirdFontPathList* r = NULL;
	BirdFontPathList* _tmp0_;
	BirdFontIntersectionList* intersections = NULL;
	BirdFontIntersectionList* _tmp1_;
	BirdFontEditPoint* ep1 = NULL;
	BirdFontEditPoint* ep2 = NULL;
	BirdFontEditPoint* found = NULL;
	gdouble d = 0.0;
	gdouble min_d = 0.0;
	BirdFontPath* current = NULL;
	gboolean found_intersection = FALSE;
	BirdFontPath* flat1 = NULL;
	BirdFontPath* flat2 = NULL;
	gboolean _tmp2_ = FALSE;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	BirdFontPath* _tmp11_;
	BirdFontPath* _tmp12_;
	BirdFontIntersectionList* _tmp91_;
	GeeArrayList* _tmp92_;
	gint _tmp93_;
	gint _tmp94_;
	BirdFontPath* new_path = NULL;
	BirdFontPath* _tmp95_;
	BirdFontPath* _tmp96_;
	BirdFontPathList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path1 != NULL, NULL);
	g_return_val_if_fail (path2 != NULL, NULL);
	_tmp0_ = bird_font_path_list_new ();
	r = _tmp0_;
	_tmp1_ = bird_font_intersection_list_new ();
	intersections = _tmp1_;
	_tmp3_ = bird_font_path_get_points (path1);
	_tmp4_ = _tmp3_;
	_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ <= 1) {
		_tmp2_ = TRUE;
	} else {
		GeeArrayList* _tmp7_;
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp7_ = bird_font_path_get_points (path2);
		_tmp8_ = _tmp7_;
		_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp2_ = _tmp10_ <= 1;
	}
	if (_tmp2_) {
		result = r;
		_g_object_unref0 (flat2);
		_g_object_unref0 (flat1);
		_g_object_unref0 (current);
		_g_object_unref0 (found);
		_g_object_unref0 (ep2);
		_g_object_unref0 (ep1);
		_g_object_unref0 (intersections);
		return result;
	}
	_tmp11_ = bird_font_path_flatten (path1, 10);
	_g_object_unref0 (flat1);
	flat1 = _tmp11_;
	_tmp12_ = bird_font_path_flatten (path2, 10);
	_g_object_unref0 (flat2);
	flat2 = _tmp12_;
	{
		GeeArrayList* _n_list = NULL;
		GeeArrayList* _tmp13_;
		GeeArrayList* _tmp14_;
		gint _n_size = 0;
		GeeArrayList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _n_index = 0;
		_tmp13_ = bird_font_path_get_points (path2);
		_tmp14_ = _tmp13_;
		_n_list = _tmp14_;
		_tmp15_ = _n_list;
		_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_n_size = _tmp17_;
		_n_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			BirdFontEditPoint* n = NULL;
			GeeArrayList* _tmp20_;
			gpointer _tmp21_;
			BirdFontEditPoint* _tmp22_;
			BirdFontEditPoint* _tmp23_;
			_n_index = _n_index + 1;
			_tmp18_ = _n_index;
			_tmp19_ = _n_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _n_list;
			_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _n_index);
			n = (BirdFontEditPoint*) _tmp21_;
			_tmp22_ = n;
			_tmp23_ = n;
			_tmp23_->flags = _tmp23_->flags & (~BIRD_FONT_EDIT_POINT_COPIED);
			_g_object_unref0 (n);
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp24_ = FALSE;
			_tmp24_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp26_;
				GeeArrayList* _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				GeeArrayList* _tmp30_;
				GeeArrayList* _tmp31_;
				gpointer _tmp32_;
				BirdFontEditPoint* _tmp33_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				_tmp26_ = bird_font_path_get_points (path1);
				_tmp27_ = _tmp26_;
				_tmp28_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp27_);
				_tmp29_ = _tmp28_;
				if (!(i < _tmp29_)) {
					break;
				}
				_tmp30_ = bird_font_path_get_points (path1);
				_tmp31_ = _tmp30_;
				_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, i);
				_g_object_unref0 (ep1);
				ep1 = (BirdFontEditPoint*) _tmp32_;
				_tmp33_ = ep1;
				if ((_tmp33_->flags & BIRD_FONT_EDIT_POINT_INTERSECTION) > ((guint) 0)) {
					BirdFontEditPoint* _tmp34_;
					BirdFontEditPoint* _tmp57_;
					BirdFontEditPoint* _tmp58_;
					BirdFontEditPoint* _tmp59_;
					BirdFontEditPoint* _tmp60_;
					BirdFontEditPoint* _tmp61_;
					BirdFontEditPoint* _tmp62_;
					BirdFontIntersection* intersection = NULL;
					BirdFontEditPoint* _tmp63_;
					BirdFontEditPoint* _tmp64_;
					BirdFontIntersection* _tmp65_;
					BirdFontIntersectionList* _tmp66_;
					GeeArrayList* _tmp67_;
					BirdFontIntersection* _tmp68_;
					_tmp34_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
					_g_object_unref0 (found);
					found = _tmp34_;
					min_d = DBL_MAX;
					found_intersection = FALSE;
					{
						gint j = 0;
						j = 0;
						{
							gboolean _tmp35_ = FALSE;
							_tmp35_ = TRUE;
							while (TRUE) {
								GeeArrayList* _tmp37_;
								GeeArrayList* _tmp38_;
								gint _tmp39_;
								gint _tmp40_;
								GeeArrayList* _tmp41_;
								GeeArrayList* _tmp42_;
								gpointer _tmp43_;
								BirdFontEditPoint* _tmp44_;
								BirdFontEditPoint* _tmp45_;
								gboolean _tmp46_ = FALSE;
								BirdFontEditPoint* _tmp47_;
								if (!_tmp35_) {
									gint _tmp36_;
									_tmp36_ = j;
									j = _tmp36_ + 1;
								}
								_tmp35_ = FALSE;
								_tmp37_ = bird_font_path_get_points (path2);
								_tmp38_ = _tmp37_;
								_tmp39_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp38_);
								_tmp40_ = _tmp39_;
								if (!(j < _tmp40_)) {
									break;
								}
								_tmp41_ = bird_font_path_get_points (path2);
								_tmp42_ = _tmp41_;
								_tmp43_ = gee_abstract_list_get ((GeeAbstractList*) _tmp42_, j);
								_g_object_unref0 (ep2);
								ep2 = (BirdFontEditPoint*) _tmp43_;
								_tmp44_ = ep1;
								_tmp45_ = ep2;
								d = bird_font_path_distance_to_point (_tmp44_, _tmp45_);
								_tmp47_ = ep2;
								if ((_tmp47_->flags & BIRD_FONT_EDIT_POINT_COPIED) == ((guint) 0)) {
									BirdFontEditPoint* _tmp48_;
									_tmp48_ = ep2;
									_tmp46_ = (_tmp48_->flags & BIRD_FONT_EDIT_POINT_INTERSECTION) > ((guint) 0);
								} else {
									_tmp46_ = FALSE;
								}
								if (_tmp46_) {
									gboolean _tmp49_ = FALSE;
									if (d < min_d) {
										_tmp49_ = d < 0.1;
									} else {
										_tmp49_ = FALSE;
									}
									if (_tmp49_) {
										BirdFontEditPoint* _tmp50_;
										BirdFontEditPoint* _tmp51_;
										min_d = d;
										found_intersection = TRUE;
										_tmp50_ = ep2;
										_tmp51_ = _g_object_ref0 (_tmp50_);
										_g_object_unref0 (found);
										found = _tmp51_;
									}
								}
							}
						}
					}
					if (!found_intersection) {
						BirdFontEditPoint* _tmp52_;
						gchar* _tmp53_;
						gchar* _tmp54_;
						gchar* _tmp55_;
						gchar* _tmp56_;
						_tmp52_ = ep1;
						_tmp53_ = bird_font_edit_point_to_string (_tmp52_);
						_tmp54_ = _tmp53_;
						_tmp55_ = g_strconcat ("No intersection for:\n ", _tmp54_, NULL);
						_tmp56_ = _tmp55_;
						g_warning ("StrokeTool.vala:774: %s", _tmp56_);
						_g_free0 (_tmp56_);
						_g_free0 (_tmp54_);
						continue;
					}
					_tmp57_ = found;
					_tmp58_ = found;
					_tmp58_->flags = _tmp58_->flags | BIRD_FONT_EDIT_POINT_COPIED;
					_tmp59_ = ep1;
					bird_font_edit_point_set_tie_handles (_tmp59_, FALSE);
					_tmp60_ = ep1;
					bird_font_edit_point_set_reflective_point (_tmp60_, FALSE);
					_tmp61_ = found;
					bird_font_edit_point_set_tie_handles (_tmp61_, FALSE);
					_tmp62_ = found;
					bird_font_edit_point_set_reflective_point (_tmp62_, FALSE);
					_tmp63_ = ep1;
					_tmp64_ = found;
					_tmp65_ = bird_font_intersection_new (_tmp63_, path1, _tmp64_, path2);
					intersection = _tmp65_;
					_tmp66_ = intersections;
					_tmp67_ = _tmp66_->points;
					_tmp68_ = intersection;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp67_, _tmp68_);
					_g_object_unref0 (intersection);
				}
			}
		}
	}
	{
		GeeArrayList* _n_list = NULL;
		GeeArrayList* _tmp69_;
		GeeArrayList* _tmp70_;
		gint _n_size = 0;
		GeeArrayList* _tmp71_;
		gint _tmp72_;
		gint _tmp73_;
		gint _n_index = 0;
		_tmp69_ = bird_font_path_get_points (path1);
		_tmp70_ = _tmp69_;
		_n_list = _tmp70_;
		_tmp71_ = _n_list;
		_tmp72_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp71_);
		_tmp73_ = _tmp72_;
		_n_size = _tmp73_;
		_n_index = -1;
		while (TRUE) {
			gint _tmp74_;
			gint _tmp75_;
			BirdFontEditPoint* n = NULL;
			GeeArrayList* _tmp76_;
			gpointer _tmp77_;
			BirdFontEditPoint* _tmp78_;
			BirdFontEditPoint* _tmp79_;
			_n_index = _n_index + 1;
			_tmp74_ = _n_index;
			_tmp75_ = _n_size;
			if (!(_tmp74_ < _tmp75_)) {
				break;
			}
			_tmp76_ = _n_list;
			_tmp77_ = gee_abstract_list_get ((GeeAbstractList*) _tmp76_, _n_index);
			n = (BirdFontEditPoint*) _tmp77_;
			_tmp78_ = n;
			_tmp79_ = n;
			_tmp79_->flags = _tmp79_->flags & (~BIRD_FONT_EDIT_POINT_COPIED);
			_g_object_unref0 (n);
		}
	}
	{
		GeeArrayList* _n_list = NULL;
		GeeArrayList* _tmp80_;
		GeeArrayList* _tmp81_;
		gint _n_size = 0;
		GeeArrayList* _tmp82_;
		gint _tmp83_;
		gint _tmp84_;
		gint _n_index = 0;
		_tmp80_ = bird_font_path_get_points (path2);
		_tmp81_ = _tmp80_;
		_n_list = _tmp81_;
		_tmp82_ = _n_list;
		_tmp83_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp82_);
		_tmp84_ = _tmp83_;
		_n_size = _tmp84_;
		_n_index = -1;
		while (TRUE) {
			gint _tmp85_;
			gint _tmp86_;
			BirdFontEditPoint* n = NULL;
			GeeArrayList* _tmp87_;
			gpointer _tmp88_;
			BirdFontEditPoint* _tmp89_;
			BirdFontEditPoint* _tmp90_;
			_n_index = _n_index + 1;
			_tmp85_ = _n_index;
			_tmp86_ = _n_size;
			if (!(_tmp85_ < _tmp86_)) {
				break;
			}
			_tmp87_ = _n_list;
			_tmp88_ = gee_abstract_list_get ((GeeAbstractList*) _tmp87_, _n_index);
			n = (BirdFontEditPoint*) _tmp88_;
			_tmp89_ = n;
			_tmp90_ = n;
			_tmp90_->flags = _tmp90_->flags & (~BIRD_FONT_EDIT_POINT_COPIED);
			_g_object_unref0 (n);
		}
	}
	_tmp91_ = intersections;
	_tmp92_ = _tmp91_->points;
	_tmp93_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp92_);
	_tmp94_ = _tmp93_;
	if (_tmp94_ == 0) {
		g_warning ("StrokeTool.vala:799: No intersection points.");
		result = r;
		_g_object_unref0 (flat2);
		_g_object_unref0 (flat1);
		_g_object_unref0 (current);
		_g_object_unref0 (found);
		_g_object_unref0 (ep2);
		_g_object_unref0 (ep1);
		_g_object_unref0 (intersections);
		return result;
	}
	_tmp95_ = bird_font_path_new ();
	new_path = _tmp95_;
	_tmp96_ = _g_object_ref0 (path1);
	_g_object_unref0 (current);
	current = _tmp96_;
	while (TRUE) {
		gboolean find_parts = FALSE;
		BirdFontIntersection* new_start = NULL;
		BirdFontIntersection* _tmp97_;
		BirdFontPath* _tmp114_;
		GeeArrayList* _tmp115_;
		GeeArrayList* _tmp116_;
		gint _tmp117_;
		gint _tmp118_;
		BirdFontIntersection* _tmp124_;
		BirdFontPath* _tmp125_;
		BirdFontEditPoint* _tmp126_;
		BirdFontEditPoint* _tmp127_;
		gboolean _tmp128_;
		gint i = 0;
		BirdFontPath* _tmp132_;
		BirdFontIntersection* _tmp133_;
		BirdFontPath* _tmp134_;
		BirdFontEditPoint* _tmp135_;
		BirdFontEditPoint* _tmp136_;
		gint _tmp137_;
		BirdFontEditPoint* previous = NULL;
		BirdFontEditPoint* _tmp138_;
		BirdFontPath* _tmp139_;
		BirdFontPath* _tmp140_;
		GeeArrayList* _tmp141_;
		GeeArrayList* _tmp142_;
		gpointer _tmp143_;
		BirdFontIntersection* _tmp144_;
		BirdFontPath* _tmp145_;
		BirdFontPath* _tmp146_;
		gboolean first = FALSE;
		BirdFontEditPoint* _tmp316_;
		BirdFontEditPoint* _tmp317_;
		BirdFontIntersection* _tmp318_;
		find_parts = FALSE;
		_tmp97_ = bird_font_intersection_new_empty ();
		new_start = _tmp97_;
		{
			GeeArrayList* _inter_list = NULL;
			BirdFontIntersectionList* _tmp98_;
			GeeArrayList* _tmp99_;
			gint _inter_size = 0;
			GeeArrayList* _tmp100_;
			gint _tmp101_;
			gint _tmp102_;
			gint _inter_index = 0;
			_tmp98_ = intersections;
			_tmp99_ = _tmp98_->points;
			_inter_list = _tmp99_;
			_tmp100_ = _inter_list;
			_tmp101_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp100_);
			_tmp102_ = _tmp101_;
			_inter_size = _tmp102_;
			_inter_index = -1;
			while (TRUE) {
				gint _tmp103_;
				gint _tmp104_;
				BirdFontIntersection* inter = NULL;
				GeeArrayList* _tmp105_;
				gpointer _tmp106_;
				gboolean _tmp107_ = FALSE;
				BirdFontIntersection* _tmp108_;
				_inter_index = _inter_index + 1;
				_tmp103_ = _inter_index;
				_tmp104_ = _inter_size;
				if (!(_tmp103_ < _tmp104_)) {
					break;
				}
				_tmp105_ = _inter_list;
				_tmp106_ = gee_abstract_list_get ((GeeAbstractList*) _tmp105_, _inter_index);
				inter = (BirdFontIntersection*) _tmp106_;
				_tmp108_ = inter;
				if (!_tmp108_->done) {
					_tmp107_ = !find_parts;
				} else {
					_tmp107_ = FALSE;
				}
				if (_tmp107_) {
					BirdFontIntersection* _tmp109_;
					BirdFontIntersection* _tmp110_;
					BirdFontIntersection* _tmp111_;
					BirdFontPath* _tmp112_;
					BirdFontPath* _tmp113_;
					find_parts = TRUE;
					_tmp109_ = inter;
					_tmp110_ = _g_object_ref0 (_tmp109_);
					_g_object_unref0 (new_start);
					new_start = _tmp110_;
					_tmp111_ = new_start;
					_tmp112_ = _tmp111_->path;
					_tmp113_ = _g_object_ref0 (_tmp112_);
					_g_object_unref0 (current);
					current = _tmp113_;
				}
				_g_object_unref0 (inter);
			}
		}
		_tmp114_ = new_path;
		_tmp115_ = bird_font_path_get_points (_tmp114_);
		_tmp116_ = _tmp115_;
		_tmp117_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp116_);
		_tmp118_ = _tmp117_;
		if (_tmp118_ > 0) {
			BirdFontPath* _tmp119_;
			BirdFontPath* _tmp120_;
			BirdFontPath* _tmp121_;
			BirdFontPathList* _tmp122_;
			BirdFontPath* _tmp123_;
			_tmp119_ = new_path;
			bird_font_path_close (_tmp119_);
			_tmp120_ = new_path;
			bird_font_path_recalculate_linear_handles (_tmp120_);
			_tmp121_ = new_path;
			bird_font_path_update_region_boundaries (_tmp121_);
			_tmp122_ = r;
			_tmp123_ = new_path;
			bird_font_path_list_add (_tmp122_, _tmp123_);
		}
		if (!find_parts) {
			_g_object_unref0 (new_start);
			break;
		}
		_tmp124_ = new_start;
		_tmp125_ = current;
		_tmp126_ = bird_font_intersection_get_point (_tmp124_, _tmp125_);
		_tmp127_ = _tmp126_;
		_tmp128_ = (_tmp127_->flags & BIRD_FONT_EDIT_POINT_COPIED) > ((guint) 0);
		_g_object_unref0 (_tmp127_);
		if (_tmp128_) {
			BirdFontIntersection* _tmp129_;
			BirdFontPath* _tmp130_;
			BirdFontPath* _tmp131_;
			_tmp129_ = new_start;
			_tmp130_ = current;
			_tmp131_ = bird_font_intersection_get_other_path (_tmp129_, _tmp130_);
			_g_object_unref0 (current);
			current = _tmp131_;
		}
		_tmp132_ = current;
		_tmp133_ = new_start;
		_tmp134_ = current;
		_tmp135_ = bird_font_intersection_get_point (_tmp133_, _tmp134_);
		_tmp136_ = _tmp135_;
		_tmp137_ = bird_font_stroke_tool_index_of (self, _tmp132_, _tmp136_);
		_g_object_unref0 (_tmp136_);
		i = _tmp137_;
		if (i < 0) {
			g_warning ("StrokeTool.vala:835: i < 0");
			result = r;
			_g_object_unref0 (new_start);
			_g_object_unref0 (new_path);
			_g_object_unref0 (flat2);
			_g_object_unref0 (flat1);
			_g_object_unref0 (current);
			_g_object_unref0 (found);
			_g_object_unref0 (ep2);
			_g_object_unref0 (ep1);
			_g_object_unref0 (intersections);
			return result;
		}
		_tmp138_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
		previous = _tmp138_;
		_tmp139_ = bird_font_path_new ();
		_g_object_unref0 (new_path);
		new_path = _tmp139_;
		_tmp140_ = current;
		_tmp141_ = bird_font_path_get_points (_tmp140_);
		_tmp142_ = _tmp141_;
		_tmp143_ = gee_abstract_list_get ((GeeAbstractList*) _tmp142_, i);
		_g_object_unref0 (ep1);
		ep1 = (BirdFontEditPoint*) _tmp143_;
		_tmp144_ = new_start;
		_tmp145_ = current;
		_tmp146_ = bird_font_intersection_get_other_path (_tmp144_, _tmp145_);
		_g_object_unref0 (current);
		current = _tmp146_;
		first = TRUE;
		while (TRUE) {
			BirdFontEditPoint* _tmp147_;
			BirdFontEditPoint* _tmp253_;
			BirdFontEditPoint* _tmp280_;
			BirdFontEditPoint* _tmp285_;
			BirdFontEditPoint* _tmp286_;
			BirdFontPath* _tmp287_;
			BirdFontEditPoint* _tmp288_;
			BirdFontEditPoint* _tmp289_;
			BirdFontEditPoint* _tmp290_;
			BirdFontEditPoint* _tmp291_;
			BirdFontEditPoint* _tmp292_;
			BirdFontEditPoint* _tmp293_;
			gint _tmp306_;
			BirdFontPath* _tmp307_;
			GeeArrayList* _tmp308_;
			GeeArrayList* _tmp309_;
			BirdFontPath* _tmp310_;
			GeeArrayList* _tmp311_;
			GeeArrayList* _tmp312_;
			gint _tmp313_;
			gint _tmp314_;
			gpointer _tmp315_;
			_tmp147_ = ep1;
			if ((_tmp147_->flags & BIRD_FONT_EDIT_POINT_INTERSECTION) > ((guint) 0)) {
				gboolean other = FALSE;
				BirdFontEditPoint* _tmp148_;
				BirdFontEditPoint* _tmp149_;
				BirdFontIntersectionList* _tmp150_;
				BirdFontEditPoint* _tmp151_;
				_tmp148_ = ep1;
				_tmp149_ = _g_object_ref0 (_tmp148_);
				_g_object_unref0 (previous);
				previous = _tmp149_;
				_tmp150_ = intersections;
				_tmp151_ = ep1;
				if (G_LIKELY (bird_font_intersection_list_has_point (_tmp150_, _tmp151_))) {
					BirdFontIntersectionList* _tmp152_;
					BirdFontEditPoint* _tmp153_;
					gboolean _tmp154_ = FALSE;
					BirdFontIntersection* _tmp155_;
					BirdFontIntersection* _tmp156_;
					BirdFontPath* _tmp157_;
					BirdFontPath* _tmp158_;
					BirdFontPath* _tmp159_;
					BirdFontIntersection* _tmp160_;
					BirdFontPath* _tmp161_;
					BirdFontEditPoint* _tmp162_;
					BirdFontEditPoint* _tmp163_;
					BirdFontPath* _tmp164_;
					GeeArrayList* _tmp165_;
					GeeArrayList* _tmp166_;
					gint _tmp167_;
					gint _tmp168_;
					gint _tmp169_;
					BirdFontPath* _tmp174_;
					GeeArrayList* _tmp175_;
					GeeArrayList* _tmp176_;
					gpointer _tmp177_;
					BirdFontPath* _tmp178_;
					GeeArrayList* _tmp179_;
					GeeArrayList* _tmp180_;
					BirdFontPath* _tmp181_;
					GeeArrayList* _tmp182_;
					GeeArrayList* _tmp183_;
					gint _tmp184_;
					gint _tmp185_;
					gpointer _tmp186_;
					gdouble px = 0.0;
					gdouble py = 0.0;
					BirdFontEditPoint* _tmp187_;
					BirdFontEditPoint* _tmp188_;
					gdouble _tmp189_ = 0.0;
					gdouble _tmp190_ = 0.0;
					gboolean _tmp191_ = FALSE;
					gboolean _tmp192_ = FALSE;
					BirdFontPath* _tmp193_;
					gboolean inside = FALSE;
					gboolean _tmp198_ = FALSE;
					gboolean _tmp199_ = FALSE;
					BirdFontPath* _tmp200_;
					gboolean other_inside = FALSE;
					gboolean _tmp205_ = FALSE;
					gboolean _tmp236_ = FALSE;
					gboolean _tmp237_ = FALSE;
					BirdFontPath* _tmp238_;
					_tmp152_ = intersections;
					_tmp153_ = ep1;
					_tmp155_ = bird_font_intersection_list_get_point (_tmp152_, _tmp153_, &_tmp154_);
					other = _tmp154_;
					_g_object_unref0 (new_start);
					new_start = _tmp155_;
					_tmp156_ = new_start;
					_tmp157_ = current;
					_tmp158_ = bird_font_intersection_get_other_path (_tmp156_, _tmp157_);
					_g_object_unref0 (current);
					current = _tmp158_;
					_tmp159_ = current;
					_tmp160_ = new_start;
					_tmp161_ = current;
					_tmp162_ = bird_font_intersection_get_point (_tmp160_, _tmp161_);
					_tmp163_ = _tmp162_;
					i = bird_font_stroke_tool_index_of (self, _tmp159_, _tmp163_);
					_g_object_unref0 (_tmp163_);
					_tmp164_ = current;
					_tmp165_ = bird_font_path_get_points (_tmp164_);
					_tmp166_ = _tmp165_;
					_tmp167_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp166_);
					_tmp168_ = _tmp167_;
					_tmp169_ = i;
					if (!((0 <= _tmp169_) && (_tmp169_ < _tmp168_))) {
						gchar* _tmp170_;
						gchar* _tmp171_;
						gchar* _tmp172_;
						gchar* _tmp173_;
						_tmp170_ = g_strdup_printf ("%i", i);
						_tmp171_ = _tmp170_;
						_tmp172_ = g_strconcat ("Index out of bounds. (", _tmp171_, ")", NULL);
						_tmp173_ = _tmp172_;
						g_warning ("StrokeTool.vala:856: %s", _tmp173_);
						_g_free0 (_tmp173_);
						_g_free0 (_tmp171_);
						result = r;
						_g_object_unref0 (previous);
						_g_object_unref0 (new_start);
						_g_object_unref0 (new_path);
						_g_object_unref0 (flat2);
						_g_object_unref0 (flat1);
						_g_object_unref0 (current);
						_g_object_unref0 (found);
						_g_object_unref0 (ep2);
						_g_object_unref0 (ep1);
						_g_object_unref0 (intersections);
						return result;
					}
					_tmp174_ = current;
					_tmp175_ = bird_font_path_get_points (_tmp174_);
					_tmp176_ = _tmp175_;
					_tmp177_ = gee_abstract_list_get ((GeeAbstractList*) _tmp176_, i);
					_g_object_unref0 (ep1);
					ep1 = (BirdFontEditPoint*) _tmp177_;
					_tmp178_ = current;
					_tmp179_ = bird_font_path_get_points (_tmp178_);
					_tmp180_ = _tmp179_;
					_tmp181_ = current;
					_tmp182_ = bird_font_path_get_points (_tmp181_);
					_tmp183_ = _tmp182_;
					_tmp184_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp183_);
					_tmp185_ = _tmp184_;
					_tmp186_ = gee_abstract_list_get ((GeeAbstractList*) _tmp180_, (i + 1) % _tmp185_);
					_g_object_unref0 (ep2);
					ep2 = (BirdFontEditPoint*) _tmp186_;
					_tmp187_ = ep1;
					_tmp188_ = ep2;
					bird_font_path_get_point_for_step (_tmp187_, _tmp188_, 0.5, &_tmp189_, &_tmp190_);
					px = _tmp189_;
					py = _tmp190_;
					_tmp193_ = current;
					if (_tmp193_ == path1) {
						BirdFontPath* _tmp194_;
						_tmp194_ = flat2;
						_tmp192_ = bird_font_path_is_over_coordinate (_tmp194_, px, py);
					} else {
						_tmp192_ = FALSE;
					}
					if (_tmp192_) {
						_tmp191_ = TRUE;
					} else {
						gboolean _tmp195_ = FALSE;
						BirdFontPath* _tmp196_;
						_tmp196_ = current;
						if (_tmp196_ == path2) {
							BirdFontPath* _tmp197_;
							_tmp197_ = flat1;
							_tmp195_ = bird_font_path_is_over_coordinate (_tmp197_, px, py);
						} else {
							_tmp195_ = FALSE;
						}
						_tmp191_ = _tmp195_;
					}
					inside = _tmp191_;
					_tmp200_ = current;
					if (_tmp200_ != path1) {
						BirdFontPath* _tmp201_;
						_tmp201_ = flat2;
						_tmp199_ = bird_font_path_is_over_coordinate (_tmp201_, px, py);
					} else {
						_tmp199_ = FALSE;
					}
					if (_tmp199_) {
						_tmp198_ = TRUE;
					} else {
						gboolean _tmp202_ = FALSE;
						BirdFontPath* _tmp203_;
						_tmp203_ = current;
						if (_tmp203_ != path2) {
							BirdFontPath* _tmp204_;
							_tmp204_ = flat1;
							_tmp202_ = bird_font_path_is_over_coordinate (_tmp204_, px, py);
						} else {
							_tmp202_ = FALSE;
						}
						_tmp198_ = _tmp202_;
					}
					other_inside = _tmp198_;
					if (inside) {
						_tmp205_ = !other_inside;
					} else {
						_tmp205_ = FALSE;
					}
					if (_tmp205_) {
						BirdFontIntersection* _tmp206_;
						BirdFontPath* _tmp207_;
						BirdFontPath* _tmp208_;
						BirdFontPath* _tmp209_;
						BirdFontIntersection* _tmp210_;
						BirdFontPath* _tmp211_;
						BirdFontEditPoint* _tmp212_;
						BirdFontEditPoint* _tmp213_;
						BirdFontPath* _tmp214_;
						GeeArrayList* _tmp215_;
						GeeArrayList* _tmp216_;
						gint _tmp217_;
						gint _tmp218_;
						gint _tmp219_;
						BirdFontIntersection* _tmp231_;
						BirdFontPath* _tmp232_;
						GeeArrayList* _tmp233_;
						GeeArrayList* _tmp234_;
						gpointer _tmp235_;
						_tmp206_ = new_start;
						_tmp207_ = current;
						_tmp208_ = bird_font_intersection_get_other_path (_tmp206_, _tmp207_);
						_g_object_unref0 (current);
						current = _tmp208_;
						_tmp209_ = current;
						_tmp210_ = new_start;
						_tmp211_ = current;
						_tmp212_ = bird_font_intersection_get_point (_tmp210_, _tmp211_);
						_tmp213_ = _tmp212_;
						i = bird_font_stroke_tool_index_of (self, _tmp209_, _tmp213_);
						_g_object_unref0 (_tmp213_);
						_tmp214_ = current;
						_tmp215_ = bird_font_path_get_points (_tmp214_);
						_tmp216_ = _tmp215_;
						_tmp217_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp216_);
						_tmp218_ = _tmp217_;
						_tmp219_ = i;
						if (!((0 <= _tmp219_) && (_tmp219_ < _tmp218_))) {
							gchar* _tmp220_;
							gchar* _tmp221_;
							BirdFontPath* _tmp222_;
							GeeArrayList* _tmp223_;
							GeeArrayList* _tmp224_;
							gint _tmp225_;
							gint _tmp226_;
							gchar* _tmp227_;
							gchar* _tmp228_;
							gchar* _tmp229_;
							gchar* _tmp230_;
							_tmp220_ = g_strdup_printf ("%i", i);
							_tmp221_ = _tmp220_;
							_tmp222_ = current;
							_tmp223_ = bird_font_path_get_points (_tmp222_);
							_tmp224_ = _tmp223_;
							_tmp225_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp224_);
							_tmp226_ = _tmp225_;
							_tmp227_ = g_strdup_printf ("%i", _tmp226_);
							_tmp228_ = _tmp227_;
							_tmp229_ = g_strconcat ("Index out of bounds. (", _tmp221_, " >= ", _tmp228_, ") ", NULL);
							_tmp230_ = _tmp229_;
							g_warning ("StrokeTool.vala:877: %s", _tmp230_);
							_g_free0 (_tmp230_);
							_g_free0 (_tmp228_);
							_g_free0 (_tmp221_);
							result = r;
							_g_object_unref0 (previous);
							_g_object_unref0 (new_start);
							_g_object_unref0 (new_path);
							_g_object_unref0 (flat2);
							_g_object_unref0 (flat1);
							_g_object_unref0 (current);
							_g_object_unref0 (found);
							_g_object_unref0 (ep2);
							_g_object_unref0 (ep1);
							_g_object_unref0 (intersections);
							return result;
						}
						_tmp231_ = new_start;
						_tmp231_->done = TRUE;
						_tmp232_ = current;
						_tmp233_ = bird_font_path_get_points (_tmp232_);
						_tmp234_ = _tmp233_;
						_tmp235_ = gee_abstract_list_get ((GeeAbstractList*) _tmp234_, i);
						_g_object_unref0 (ep1);
						ep1 = (BirdFontEditPoint*) _tmp235_;
					}
					_tmp238_ = current;
					if (_tmp238_ == path1) {
						BirdFontPath* _tmp239_;
						_tmp239_ = flat2;
						_tmp237_ = bird_font_path_is_over_coordinate (_tmp239_, px, py);
					} else {
						_tmp237_ = FALSE;
					}
					if (_tmp237_) {
						_tmp236_ = TRUE;
					} else {
						gboolean _tmp240_ = FALSE;
						BirdFontPath* _tmp241_;
						_tmp241_ = current;
						if (_tmp241_ == path2) {
							BirdFontPath* _tmp242_;
							_tmp242_ = flat1;
							_tmp240_ = bird_font_path_is_over_coordinate (_tmp242_, px, py);
						} else {
							_tmp240_ = FALSE;
						}
						_tmp236_ = _tmp240_;
					}
					inside = _tmp236_;
					if (first) {
						BirdFontPath* c = NULL;
						BirdFontIntersection* _tmp243_;
						BirdFontPath* _tmp244_;
						BirdFontPath* _tmp245_;
						BirdFontPath* _tmp246_;
						GeeArrayList* _tmp247_;
						GeeArrayList* _tmp248_;
						gint _tmp249_;
						gint _tmp250_;
						_tmp243_ = new_start;
						_tmp244_ = current;
						_tmp245_ = bird_font_intersection_get_other_path (_tmp243_, _tmp244_);
						c = _tmp245_;
						_tmp246_ = c;
						_tmp247_ = bird_font_path_get_points (_tmp246_);
						_tmp248_ = _tmp247_;
						_tmp249_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp248_);
						_tmp250_ = _tmp249_;
						if (_tmp250_ >= 1) {
							BirdFontPath* _tmp251_;
							BirdFontEditPoint* _tmp252_;
							_tmp251_ = c;
							_tmp252_ = bird_font_path_get_first_point (_tmp251_);
							_g_object_unref0 (previous);
							previous = _tmp252_;
						}
						first = FALSE;
						_g_object_unref0 (c);
					}
				}
			}
			_tmp253_ = ep1;
			if ((_tmp253_->flags & BIRD_FONT_EDIT_POINT_COPIED) > ((guint) 0)) {
				BirdFontPath* _tmp254_;
				BirdFontPath* _tmp255_;
				GeeArrayList* _tmp256_;
				GeeArrayList* _tmp257_;
				gint _tmp258_;
				gint _tmp259_;
				_tmp254_ = new_path;
				bird_font_path_close (_tmp254_);
				_tmp255_ = new_path;
				_tmp256_ = bird_font_path_get_points (_tmp255_);
				_tmp257_ = _tmp256_;
				_tmp258_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp257_);
				_tmp259_ = _tmp258_;
				if (_tmp259_ >= 1) {
					BirdFontEditPoint* first_point = NULL;
					BirdFontPath* _tmp260_;
					BirdFontEditPoint* _tmp261_;
					BirdFontEditPointHandle* h = NULL;
					BirdFontEditPoint* _tmp262_;
					_tmp260_ = new_path;
					_tmp261_ = bird_font_path_get_first_point (_tmp260_);
					first_point = _tmp261_;
					_tmp262_ = ep1;
					if ((_tmp262_->flags & BIRD_FONT_EDIT_POINT_INTERSECTION) > ((guint) 0)) {
						BirdFontEditPoint* _tmp263_;
						BirdFontEditPointHandle* _tmp264_;
						BirdFontEditPoint* _tmp265_;
						BirdFontEditPointHandle* _tmp266_;
						gdouble _tmp267_;
						gdouble _tmp268_;
						BirdFontEditPoint* _tmp269_;
						BirdFontEditPointHandle* _tmp270_;
						gdouble _tmp271_;
						gdouble _tmp272_;
						BirdFontEditPoint* _tmp273_;
						BirdFontEditPoint* _tmp274_;
						_tmp263_ = first_point;
						_tmp264_ = _tmp263_->left_handle;
						_tmp265_ = previous;
						_tmp266_ = _tmp265_->left_handle;
						_tmp267_ = bird_font_edit_point_handle_get_x (_tmp266_);
						_tmp268_ = _tmp267_;
						_tmp269_ = previous;
						_tmp270_ = _tmp269_->left_handle;
						_tmp271_ = bird_font_edit_point_handle_get_y (_tmp270_);
						_tmp272_ = _tmp271_;
						bird_font_edit_point_handle_move_to_coordinate (_tmp264_, _tmp268_, _tmp272_);
						_tmp273_ = first_point;
						_tmp274_ = _tmp273_->next;
						if (_tmp274_ != NULL) {
							BirdFontEditPoint* _tmp275_;
							BirdFontEditPoint* _tmp276_;
							BirdFontEditPointHandle* _tmp277_;
							BirdFontEditPointHandle* _tmp278_;
							BirdFontEditPointHandle* _tmp279_;
							_tmp275_ = first_point;
							_tmp276_ = bird_font_edit_point_get_next (_tmp275_);
							_tmp277_ = bird_font_edit_point_get_left_handle (_tmp276_);
							_tmp278_ = _g_object_ref0 (_tmp277_);
							_g_object_unref0 (h);
							h = _tmp278_;
							_tmp279_ = h;
							bird_font_edit_point_handle_process_connected_handle (_tmp279_);
						}
					}
					_g_object_unref0 (h);
					_g_object_unref0 (first_point);
				}
				break;
			}
			_tmp280_ = ep1;
			if ((_tmp280_->flags & BIRD_FONT_EDIT_POINT_INTERSECTION) > ((guint) 0)) {
				BirdFontEditPoint* _tmp281_;
				BirdFontEditPointHandle* _tmp282_;
				BirdFontEditPoint* _tmp283_;
				BirdFontEditPointHandle* _tmp284_;
				_tmp281_ = ep1;
				_tmp282_ = _tmp281_->left_handle;
				bird_font_edit_point_handle_convert_to_curve (_tmp282_);
				_tmp283_ = ep1;
				_tmp284_ = _tmp283_->right_handle;
				bird_font_edit_point_handle_convert_to_curve (_tmp284_);
			}
			_tmp285_ = ep1;
			_tmp286_ = ep1;
			_tmp286_->flags = _tmp286_->flags | BIRD_FONT_EDIT_POINT_COPIED;
			_tmp287_ = new_path;
			_tmp288_ = ep1;
			_tmp289_ = bird_font_edit_point_copy (_tmp288_);
			_tmp290_ = _tmp289_;
			_tmp291_ = bird_font_path_add_point (_tmp287_, _tmp290_);
			_tmp292_ = _tmp291_;
			_g_object_unref0 (_tmp292_);
			_g_object_unref0 (_tmp290_);
			_tmp293_ = ep1;
			if ((_tmp293_->flags & BIRD_FONT_EDIT_POINT_INTERSECTION) > ((guint) 0)) {
				BirdFontPath* _tmp294_;
				BirdFontEditPoint* _tmp295_;
				BirdFontEditPoint* _tmp296_;
				BirdFontEditPointHandle* _tmp297_;
				BirdFontEditPoint* _tmp298_;
				BirdFontEditPointHandle* _tmp299_;
				gdouble _tmp300_;
				gdouble _tmp301_;
				BirdFontEditPoint* _tmp302_;
				BirdFontEditPointHandle* _tmp303_;
				gdouble _tmp304_;
				gdouble _tmp305_;
				_tmp294_ = new_path;
				_tmp295_ = bird_font_path_get_last_point (_tmp294_);
				_tmp296_ = _tmp295_;
				_tmp297_ = _tmp296_->left_handle;
				_tmp298_ = previous;
				_tmp299_ = _tmp298_->left_handle;
				_tmp300_ = bird_font_edit_point_handle_get_x (_tmp299_);
				_tmp301_ = _tmp300_;
				_tmp302_ = previous;
				_tmp303_ = _tmp302_->left_handle;
				_tmp304_ = bird_font_edit_point_handle_get_y (_tmp303_);
				_tmp305_ = _tmp304_;
				bird_font_edit_point_handle_move_to_coordinate (_tmp297_, _tmp301_, _tmp305_);
				_g_object_unref0 (_tmp296_);
			}
			_tmp306_ = i;
			i = _tmp306_ + 1;
			_tmp307_ = current;
			_tmp308_ = bird_font_path_get_points (_tmp307_);
			_tmp309_ = _tmp308_;
			_tmp310_ = current;
			_tmp311_ = bird_font_path_get_points (_tmp310_);
			_tmp312_ = _tmp311_;
			_tmp313_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp312_);
			_tmp314_ = _tmp313_;
			_tmp315_ = gee_abstract_list_get ((GeeAbstractList*) _tmp309_, i % _tmp314_);
			_g_object_unref0 (ep1);
			ep1 = (BirdFontEditPoint*) _tmp315_;
		}
		_tmp316_ = ep1;
		_tmp317_ = ep1;
		_tmp317_->flags = _tmp317_->flags | BIRD_FONT_EDIT_POINT_COPIED;
		_tmp318_ = new_start;
		if (!_tmp318_->done) {
			BirdFontIntersection* _tmp319_;
			BirdFontIntersection* _tmp320_;
			BirdFontPath* _tmp321_;
			BirdFontEditPoint* _tmp322_;
			BirdFontEditPoint* _tmp323_;
			_tmp319_ = new_start;
			_tmp320_ = new_start;
			_tmp321_ = current;
			_tmp322_ = bird_font_intersection_get_other_point (_tmp320_, _tmp321_);
			_tmp323_ = _tmp322_;
			_tmp319_->done = (_tmp323_->flags & BIRD_FONT_EDIT_POINT_COPIED) > ((guint) 0);
			_g_object_unref0 (_tmp323_);
		}
		_g_object_unref0 (previous);
		_g_object_unref0 (new_start);
	}
	result = r;
	_g_object_unref0 (new_path);
	_g_object_unref0 (flat2);
	_g_object_unref0 (flat1);
	_g_object_unref0 (current);
	_g_object_unref0 (found);
	_g_object_unref0 (ep2);
	_g_object_unref0 (ep1);
	_g_object_unref0 (intersections);
	return result;
}

static BirdFontPath*
bird_font_stroke_tool_simplify_stroke (BirdFontStrokeTool* self,
                                       BirdFontPath* p)
{
	BirdFontPath* simplified = NULL;
	BirdFontPath* _tmp0_;
	BirdFontPath* segment = NULL;
	BirdFontPath* added_segment = NULL;
	BirdFontEditPoint* ep = NULL;
	BirdFontEditPoint* ep_start = NULL;
	BirdFontEditPoint* last = NULL;
	BirdFontEditPoint* first = NULL;
	BirdFontEditPoint* segment_last = NULL;
	gint start = 0;
	gint stop = 0;
	gint j = 0;
	BirdFontEditPointHandle* last_handle = NULL;
	BirdFontEditPointHandle* _tmp1_;
	BirdFontEditPoint* _tmp2_;
	BirdFontEditPoint* _tmp3_;
	gboolean has_curve_start = FALSE;
	BirdFontPath* _tmp157_;
	BirdFontPath* _tmp158_;
	BirdFontPath* _tmp159_;
	BirdFontPath* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (p != NULL, NULL);
	_tmp0_ = bird_font_path_new ();
	simplified = _tmp0_;
	_tmp1_ = bird_font_edit_point_handle_new_empty ();
	_g_object_unref0 (last_handle);
	last_handle = _tmp1_;
	_tmp2_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
	_g_object_unref0 (segment_last);
	segment_last = _tmp2_;
	_tmp3_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
	_g_object_unref0 (last);
	last = _tmp3_;
	bird_font_path_remove_points_on_points (p, 0.00001);
	{
		GeeArrayList* _e_list = NULL;
		GeeArrayList* _tmp4_;
		GeeArrayList* _tmp5_;
		gint _e_size = 0;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _e_index = 0;
		_tmp4_ = bird_font_path_get_points (p);
		_tmp5_ = _tmp4_;
		_e_list = _tmp5_;
		_tmp6_ = _e_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_e_size = _tmp8_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			BirdFontEditPoint* e = NULL;
			GeeArrayList* _tmp11_;
			gpointer _tmp12_;
			BirdFontEditPoint* _tmp13_;
			_e_index = _e_index + 1;
			_tmp9_ = _e_index;
			_tmp10_ = _e_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _e_list;
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _e_index);
			e = (BirdFontEditPoint*) _tmp12_;
			_tmp13_ = e;
			bird_font_pen_tool_convert_point_type (_tmp13_, BIRD_FONT_POINT_TYPE_CUBIC);
			_g_object_unref0 (e);
		}
	}
	has_curve_start = TRUE;
	{
		GeeArrayList* _e_list = NULL;
		GeeArrayList* _tmp14_;
		GeeArrayList* _tmp15_;
		gint _e_size = 0;
		GeeArrayList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _e_index = 0;
		_tmp14_ = bird_font_path_get_points (p);
		_tmp15_ = _tmp14_;
		_e_list = _tmp15_;
		_tmp16_ = _e_list;
		_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_e_size = _tmp18_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp19_;
			gint _tmp20_;
			BirdFontEditPoint* e = NULL;
			GeeArrayList* _tmp21_;
			gpointer _tmp22_;
			BirdFontEditPoint* _tmp23_;
			BirdFontEditPoint* _tmp24_;
			BirdFontEditPoint* _tmp25_;
			_e_index = _e_index + 1;
			_tmp19_ = _e_index;
			_tmp20_ = _e_size;
			if (!(_tmp19_ < _tmp20_)) {
				break;
			}
			_tmp21_ = _e_list;
			_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _e_index);
			e = (BirdFontEditPoint*) _tmp22_;
			_tmp23_ = e;
			_tmp24_ = e;
			_tmp24_->flags = _tmp24_->flags & (~BIRD_FONT_EDIT_POINT_NEW_CORNER);
			_tmp25_ = e;
			if ((_tmp25_->flags & BIRD_FONT_EDIT_POINT_CURVE) == ((guint) 0)) {
				BirdFontEditPoint* _tmp26_;
				_tmp26_ = e;
				bird_font_path_set_new_start (p, _tmp26_);
				has_curve_start = FALSE;
				_g_object_unref0 (e);
				break;
			}
			_g_object_unref0 (e);
		}
	}
	if (has_curve_start) {
		g_warning ("StrokeTool.vala:977: Curve start");
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp27_ = FALSE;
			_tmp27_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp29_;
				GeeArrayList* _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				GeeArrayList* _tmp33_;
				GeeArrayList* _tmp34_;
				gpointer _tmp35_;
				BirdFontEditPoint* _tmp36_;
				if (!_tmp27_) {
					gint _tmp28_;
					_tmp28_ = i;
					i = _tmp28_ + 1;
				}
				_tmp27_ = FALSE;
				_tmp29_ = bird_font_path_get_points (p);
				_tmp30_ = _tmp29_;
				_tmp31_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp30_);
				_tmp32_ = _tmp31_;
				if (!(i < _tmp32_)) {
					break;
				}
				_tmp33_ = bird_font_path_get_points (p);
				_tmp34_ = _tmp33_;
				_tmp35_ = gee_abstract_list_get ((GeeAbstractList*) _tmp34_, i);
				_g_object_unref0 (ep);
				ep = (BirdFontEditPoint*) _tmp35_;
				_tmp36_ = ep;
				if ((_tmp36_->flags & BIRD_FONT_EDIT_POINT_CURVE) > ((guint) 0)) {
					BirdFontStrokeTask* _tmp47_;
					GeeArrayList* _tmp49_;
					GeeArrayList* _tmp50_;
					gint _tmp51_;
					gint _tmp52_;
					GeeArrayList* _tmp57_;
					GeeArrayList* _tmp58_;
					gpointer _tmp59_;
					GeeArrayList* _tmp60_;
					GeeArrayList* _tmp61_;
					gpointer _tmp62_;
					gdouble l = 0.0;
					BirdFontEditPoint* _tmp63_;
					BirdFontEditPoint* _tmp64_;
					BirdFontPath* _tmp65_;
					BirdFontPath* _tmp66_;
					BirdFontPath* _tmp67_;
					BirdFontPath* _tmp68_;
					GeeArrayList* _tmp69_;
					GeeArrayList* _tmp70_;
					gint _tmp71_;
					gint _tmp72_;
					BirdFontPath* _tmp75_;
					GeeArrayList* _tmp76_;
					GeeArrayList* _tmp77_;
					gint _tmp78_;
					gint _tmp79_;
					start = i;
					{
						gboolean _tmp37_ = FALSE;
						j = start + 1;
						_tmp37_ = TRUE;
						while (TRUE) {
							GeeArrayList* _tmp39_;
							GeeArrayList* _tmp40_;
							gint _tmp41_;
							gint _tmp42_;
							GeeArrayList* _tmp43_;
							GeeArrayList* _tmp44_;
							gpointer _tmp45_;
							BirdFontEditPoint* _tmp46_;
							if (!_tmp37_) {
								gint _tmp38_;
								_tmp38_ = j;
								j = _tmp38_ + 1;
							}
							_tmp37_ = FALSE;
							_tmp39_ = bird_font_path_get_points (p);
							_tmp40_ = _tmp39_;
							_tmp41_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp40_);
							_tmp42_ = _tmp41_;
							if (!(j < _tmp42_)) {
								break;
							}
							_tmp43_ = bird_font_path_get_points (p);
							_tmp44_ = _tmp43_;
							_tmp45_ = gee_abstract_list_get ((GeeAbstractList*) _tmp44_, j);
							_g_object_unref0 (ep);
							ep = (BirdFontEditPoint*) _tmp45_;
							_tmp46_ = ep;
							if ((_tmp46_->flags & BIRD_FONT_EDIT_POINT_CURVE) == ((guint) 0)) {
								break;
							}
						}
					}
					_tmp47_ = self->priv->task;
					if (bird_font_task_is_cancelled ((BirdFontTask*) _tmp47_)) {
						BirdFontPath* _tmp48_;
						_tmp48_ = bird_font_path_new ();
						result = _tmp48_;
						_g_object_unref0 (last_handle);
						_g_object_unref0 (segment_last);
						_g_object_unref0 (first);
						_g_object_unref0 (last);
						_g_object_unref0 (ep_start);
						_g_object_unref0 (ep);
						_g_object_unref0 (added_segment);
						_g_object_unref0 (segment);
						_g_object_unref0 (simplified);
						return result;
					}
					stop = j;
					start -= 1;
					if (start < 0) {
						g_warning ("StrokeTool.vala:1001: start < 0");
						start = 0;
					}
					_tmp49_ = bird_font_path_get_points (p);
					_tmp50_ = _tmp49_;
					_tmp51_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp50_);
					_tmp52_ = _tmp51_;
					if (stop >= _tmp52_) {
						GeeArrayList* _tmp53_;
						GeeArrayList* _tmp54_;
						gint _tmp55_;
						gint _tmp56_;
						g_warning ("StrokeTool.vala:1006: stop >= p.points.size");
						_tmp53_ = bird_font_path_get_points (p);
						_tmp54_ = _tmp53_;
						_tmp55_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp54_);
						_tmp56_ = _tmp55_;
						stop = _tmp56_ - 1;
					}
					_tmp57_ = bird_font_path_get_points (p);
					_tmp58_ = _tmp57_;
					_tmp59_ = gee_abstract_list_get ((GeeAbstractList*) _tmp58_, start);
					_g_object_unref0 (ep_start);
					ep_start = (BirdFontEditPoint*) _tmp59_;
					_tmp60_ = bird_font_path_get_points (p);
					_tmp61_ = _tmp60_;
					_tmp62_ = gee_abstract_list_get ((GeeAbstractList*) _tmp61_, stop);
					_g_object_unref0 (ep);
					ep = (BirdFontEditPoint*) _tmp62_;
					_tmp63_ = ep_start;
					_tmp64_ = ep;
					l = bird_font_path_distance_to_point (_tmp63_, _tmp64_);
					_tmp65_ = bird_font_stroke_tool_fit_bezier_path (p, start, stop, (0.00001 * l) * l);
					_g_object_unref0 (segment);
					segment = _tmp65_;
					_tmp66_ = segment;
					_tmp67_ = bird_font_path_copy (_tmp66_);
					_g_object_unref0 (added_segment);
					added_segment = _tmp67_;
					_tmp68_ = simplified;
					_tmp69_ = bird_font_path_get_points (_tmp68_);
					_tmp70_ = _tmp69_;
					_tmp71_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp70_);
					_tmp72_ = _tmp71_;
					if (_tmp72_ > 0) {
						BirdFontPath* _tmp73_;
						BirdFontEditPoint* _tmp74_;
						_tmp73_ = simplified;
						_tmp74_ = bird_font_path_get_last_point (_tmp73_);
						_g_object_unref0 (last);
						last = _tmp74_;
					}
					_tmp75_ = added_segment;
					_tmp76_ = bird_font_path_get_points (_tmp75_);
					_tmp77_ = _tmp76_;
					_tmp78_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp77_);
					_tmp79_ = _tmp78_;
					if (_tmp79_ > 0) {
						BirdFontPath* _tmp80_;
						BirdFontEditPoint* _tmp81_;
						BirdFontPath* _tmp82_;
						BirdFontEditPoint* _tmp83_;
						BirdFontEditPoint* _tmp84_;
						BirdFontEditPoint* _tmp85_;
						BirdFontEditPointHandle* _tmp86_;
						BirdFontEditPointHandle* _tmp87_;
						BirdFontPath* _tmp88_;
						GeeArrayList* _tmp89_;
						GeeArrayList* _tmp90_;
						gint _tmp91_;
						gint _tmp92_;
						BirdFontEditPoint* _tmp95_;
						BirdFontEditPoint* _tmp96_;
						BirdFontEditPoint* _tmp97_;
						BirdFontEditPointHandle* _tmp98_;
						BirdFontEditPoint* _tmp99_;
						BirdFontEditPointHandle* _tmp100_;
						gdouble _tmp101_;
						gdouble _tmp102_;
						BirdFontEditPoint* _tmp103_;
						BirdFontEditPointHandle* _tmp104_;
						BirdFontEditPoint* _tmp105_;
						BirdFontEditPointHandle* _tmp106_;
						gdouble _tmp107_;
						gdouble _tmp108_;
						BirdFontEditPoint* _tmp109_;
						BirdFontEditPointHandle* _tmp110_;
						BirdFontEditPoint* _tmp111_;
						BirdFontEditPointHandle* _tmp112_;
						BirdFontEditPoint* _tmp113_;
						BirdFontEditPointHandle* _tmp114_;
						gdouble _tmp115_;
						gdouble _tmp116_;
						BirdFontEditPoint* _tmp117_;
						BirdFontEditPointHandle* _tmp118_;
						BirdFontEditPoint* _tmp119_;
						BirdFontEditPointHandle* _tmp120_;
						gdouble _tmp121_;
						gdouble _tmp122_;
						BirdFontPath* _tmp123_;
						BirdFontEditPoint* _tmp124_;
						BirdFontEditPoint* _tmp125_;
						BirdFontEditPoint* _tmp126_;
						BirdFontEditPointHandle* _tmp127_;
						BirdFontEditPointHandle* _tmp128_;
						BirdFontPath* _tmp129_;
						BirdFontEditPoint* _tmp130_;
						BirdFontPath* _tmp131_;
						BirdFontPath* _tmp132_;
						BirdFontEditPoint* _tmp133_;
						BirdFontEditPoint* _tmp134_;
						BirdFontEditPointHandle* _tmp135_;
						BirdFontEditPointHandle* _tmp136_;
						BirdFontPath* _tmp137_;
						GeeArrayList* _tmp138_;
						GeeArrayList* _tmp139_;
						gint _tmp140_;
						gint _tmp141_;
						BirdFontEditPoint* _tmp148_;
						BirdFontEditPointHandle* _tmp149_;
						BirdFontEditPointHandle* _tmp150_;
						_tmp80_ = added_segment;
						_tmp81_ = bird_font_path_get_last_point (_tmp80_);
						_g_object_unref0 (segment_last);
						segment_last = _tmp81_;
						_tmp82_ = added_segment;
						_tmp83_ = bird_font_path_get_first_point (_tmp82_);
						_g_object_unref0 (first);
						first = _tmp83_;
						_tmp84_ = segment_last;
						_tmp85_ = ep_start;
						_tmp86_ = bird_font_edit_point_get_right_handle (_tmp85_);
						_tmp87_ = bird_font_edit_point_handle_copy (_tmp86_);
						_g_object_unref0 (_tmp84_->right_handle);
						_tmp84_->right_handle = _tmp87_;
						_tmp88_ = simplified;
						_tmp89_ = bird_font_path_get_points (_tmp88_);
						_tmp90_ = _tmp89_;
						_tmp91_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp90_);
						_tmp92_ = _tmp91_;
						if (_tmp92_ > 1) {
							BirdFontPath* _tmp93_;
							BirdFontEditPoint* _tmp94_;
							_tmp93_ = simplified;
							_tmp94_ = bird_font_path_delete_last_point (_tmp93_);
							_g_object_unref0 (last);
							last = _tmp94_;
						}
						_tmp95_ = first;
						bird_font_edit_point_set_tie_handle (_tmp95_, FALSE);
						_tmp96_ = last;
						bird_font_edit_point_set_tie_handle (_tmp96_, FALSE);
						_tmp97_ = last;
						_tmp98_ = bird_font_edit_point_get_right_handle (_tmp97_);
						_tmp99_ = first;
						_tmp100_ = bird_font_edit_point_get_right_handle (_tmp99_);
						_tmp101_ = bird_font_edit_point_handle_get_x (_tmp100_);
						_tmp102_ = _tmp101_;
						bird_font_edit_point_handle_set_x (_tmp98_, _tmp102_);
						_tmp103_ = last;
						_tmp104_ = bird_font_edit_point_get_right_handle (_tmp103_);
						_tmp105_ = first;
						_tmp106_ = bird_font_edit_point_get_right_handle (_tmp105_);
						_tmp107_ = bird_font_edit_point_handle_get_y (_tmp106_);
						_tmp108_ = _tmp107_;
						bird_font_edit_point_handle_set_y (_tmp104_, _tmp108_);
						_tmp109_ = first;
						_tmp110_ = bird_font_edit_point_get_left_handle (_tmp109_);
						bird_font_edit_point_handle_convert_to_curve (_tmp110_);
						_tmp111_ = first;
						_tmp112_ = bird_font_edit_point_get_left_handle (_tmp111_);
						_tmp113_ = last;
						_tmp114_ = bird_font_edit_point_get_left_handle (_tmp113_);
						_tmp115_ = bird_font_edit_point_handle_get_x (_tmp114_);
						_tmp116_ = _tmp115_;
						bird_font_edit_point_handle_set_x (_tmp112_, _tmp116_);
						_tmp117_ = first;
						_tmp118_ = bird_font_edit_point_get_left_handle (_tmp117_);
						_tmp119_ = last;
						_tmp120_ = bird_font_edit_point_get_left_handle (_tmp119_);
						_tmp121_ = bird_font_edit_point_handle_get_y (_tmp120_);
						_tmp122_ = _tmp121_;
						bird_font_edit_point_handle_set_y (_tmp118_, _tmp122_);
						_tmp123_ = added_segment;
						_tmp124_ = bird_font_path_get_last_point (_tmp123_);
						_g_object_unref0 (last);
						last = _tmp124_;
						_tmp125_ = last;
						_tmp126_ = ep;
						_tmp127_ = bird_font_edit_point_get_right_handle (_tmp126_);
						_tmp128_ = bird_font_edit_point_handle_copy (_tmp127_);
						_g_object_unref0 (_tmp125_->right_handle);
						_tmp125_->right_handle = _tmp128_;
						_tmp129_ = added_segment;
						_tmp130_ = last;
						bird_font_path_recalculate_linear_handles_for_point (_tmp129_, _tmp130_);
						_tmp131_ = simplified;
						_tmp132_ = added_segment;
						bird_font_path_append_path (_tmp131_, _tmp132_);
						_tmp133_ = segment_last;
						_tmp134_ = ep;
						_tmp135_ = bird_font_edit_point_get_right_handle (_tmp134_);
						_tmp136_ = bird_font_edit_point_handle_copy (_tmp135_);
						_g_object_unref0 (_tmp133_->right_handle);
						_tmp133_->right_handle = _tmp136_;
						_tmp137_ = added_segment;
						_tmp138_ = bird_font_path_get_points (_tmp137_);
						_tmp139_ = _tmp138_;
						_tmp140_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp139_);
						_tmp141_ = _tmp140_;
						if (_tmp141_ > 0) {
							BirdFontEditPoint* _tmp142_;
							BirdFontEditPointHandle* _tmp143_;
							_tmp142_ = ep_start;
							_tmp143_ = bird_font_edit_point_get_right_handle (_tmp142_);
							if (bird_font_edit_point_handle_is_line (_tmp143_)) {
								BirdFontPath* _tmp144_;
								BirdFontEditPoint* _tmp145_;
								BirdFontPath* _tmp146_;
								BirdFontEditPoint* _tmp147_;
								_tmp144_ = added_segment;
								_tmp145_ = bird_font_path_get_first_point (_tmp144_);
								_g_object_unref0 (first);
								first = _tmp145_;
								_tmp146_ = simplified;
								_tmp147_ = first;
								bird_font_path_recalculate_linear_handles_for_point (_tmp146_, _tmp147_);
							}
						}
						_tmp148_ = last;
						_tmp149_ = bird_font_edit_point_get_left_handle (_tmp148_);
						_tmp150_ = _g_object_ref0 (_tmp149_);
						_g_object_unref0 (last_handle);
						last_handle = _tmp150_;
					} else {
						g_warning ("StrokeTool.vala:1058: No points in segment.");
					}
					i = stop;
				} else {
					BirdFontPath* _tmp151_;
					BirdFontEditPoint* _tmp152_;
					BirdFontEditPoint* _tmp153_;
					BirdFontEditPoint* _tmp154_;
					BirdFontEditPoint* _tmp155_;
					BirdFontEditPoint* _tmp156_;
					_tmp151_ = simplified;
					_tmp152_ = ep;
					_tmp153_ = bird_font_edit_point_copy (_tmp152_);
					_tmp154_ = _tmp153_;
					_tmp155_ = bird_font_path_add_point (_tmp151_, _tmp154_);
					_tmp156_ = _tmp155_;
					_g_object_unref0 (_tmp156_);
					_g_object_unref0 (_tmp154_);
				}
			}
		}
	}
	_tmp157_ = simplified;
	bird_font_path_recalculate_linear_handles (_tmp157_);
	_tmp158_ = simplified;
	bird_font_path_close (_tmp158_);
	_tmp159_ = simplified;
	bird_font_stroke_tool_remove_single_point_intersections (self, _tmp159_);
	result = simplified;
	_g_object_unref0 (last_handle);
	_g_object_unref0 (segment_last);
	_g_object_unref0 (first);
	_g_object_unref0 (last);
	_g_object_unref0 (ep_start);
	_g_object_unref0 (ep);
	_g_object_unref0 (added_segment);
	_g_object_unref0 (segment);
	return result;
}

BirdFontPath*
bird_font_stroke_tool_fit_bezier_path (BirdFontPath* p,
                                       gint start,
                                       gint stop,
                                       gdouble _error_)
{
	gint index = 0;
	gint size = 0;
	BirdFontPath* simplified = NULL;
	gdouble* lines = NULL;
	gint lines_length1 = 0;
	gint _lines_size_ = 0;
	gdouble* _result_ = NULL;
	gint _result__length1 = 0;
	gint __result__size_ = 0;
	BirdFontEditPoint* ep = NULL;
	BirdFontPath* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	BirdFontPath* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	BirdFontPath* _tmp12_;
	gdouble* _tmp13_;
	BirdFontPath* _tmp25_;
	BirdFontPath* _tmp26_;
	gdouble* _tmp27_;
	gint _tmp27__length1;
	gdouble* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	gdouble* _tmp30_;
	gint _tmp30__length1;
	BirdFontPath* _tmp31_;
	BirdFontPath* result;
	g_return_val_if_fail (p != NULL, NULL);
	_tmp0_ = bird_font_path_new ();
	_g_object_unref0 (simplified);
	simplified = _tmp0_;
	_tmp1_ = bird_font_path_get_points (p);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = start;
	_tmp6_ = simplified;
	g_return_val_if_fail ((0 <= _tmp5_) && (_tmp5_ < _tmp4_), _tmp6_);
	_tmp7_ = bird_font_path_get_points (p);
	_tmp8_ = _tmp7_;
	_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = stop;
	_tmp12_ = simplified;
	g_return_val_if_fail ((0 <= _tmp11_) && (_tmp11_ < _tmp10_), _tmp12_);
	size = (stop - start) + 1;
	_tmp13_ = g_new0 (gdouble, 2 * size);
	lines = (g_free (lines), NULL);
	lines = _tmp13_;
	lines_length1 = 2 * size;
	_lines_size_ = lines_length1;
	index = 0;
	{
		gint i = 0;
		i = start;
		{
			gboolean _tmp14_ = FALSE;
			_tmp14_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp16_;
				GeeArrayList* _tmp17_;
				gpointer _tmp18_;
				gdouble* _tmp19_;
				gint _tmp19__length1;
				BirdFontEditPoint* _tmp20_;
				gint _tmp21_;
				gdouble* _tmp22_;
				gint _tmp22__length1;
				BirdFontEditPoint* _tmp23_;
				gint _tmp24_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp14_ = FALSE;
				if (!(i <= stop)) {
					break;
				}
				_tmp16_ = bird_font_path_get_points (p);
				_tmp17_ = _tmp16_;
				_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, i);
				_g_object_unref0 (ep);
				ep = (BirdFontEditPoint*) _tmp18_;
				_tmp19_ = lines;
				_tmp19__length1 = lines_length1;
				_tmp20_ = ep;
				_tmp19_[index] = _tmp20_->x;
				_tmp21_ = index;
				index = _tmp21_ + 1;
				_tmp22_ = lines;
				_tmp22__length1 = lines_length1;
				_tmp23_ = ep;
				_tmp22_[index] = _tmp23_->y;
				_tmp24_ = index;
				index = _tmp24_ + 1;
			}
		}
	}
	_tmp25_ = bird_font_path_new ();
	_tmp26_ = _tmp25_;
	g_return_val_if_fail ((2 * size) == index, _tmp26_);
	_g_object_unref0 (_tmp26_);
	_tmp27_ = lines;
	_tmp27__length1 = lines_length1;
	fit_bezier_curve_to_line (_tmp27_, (gint) _tmp27__length1, _error_, &_tmp28_, &_tmp29_);
	_result_ = (g_free (_result_), NULL);
	_result_ = _tmp28_;
	_result__length1 = _tmp29_;
	__result__size_ = _result__length1;
	_tmp30_ = _result_;
	_tmp30__length1 = _result__length1;
	_tmp31_ = simplified;
	g_return_val_if_fail (!bird_font_is_null (_tmp30_), _tmp31_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp32_ = FALSE;
			_tmp32_ = TRUE;
			while (TRUE) {
				gdouble* _tmp33_;
				gint _tmp33__length1;
				BirdFontPath* _tmp34_;
				gdouble* _tmp35_;
				gint _tmp35__length1;
				gdouble _tmp36_;
				gdouble* _tmp37_;
				gint _tmp37__length1;
				gdouble _tmp38_;
				gdouble* _tmp39_;
				gint _tmp39__length1;
				gdouble _tmp40_;
				gdouble* _tmp41_;
				gint _tmp41__length1;
				gdouble _tmp42_;
				gdouble* _tmp43_;
				gint _tmp43__length1;
				gdouble _tmp44_;
				gdouble* _tmp45_;
				gint _tmp45__length1;
				gdouble _tmp46_;
				gdouble* _tmp47_;
				gint _tmp47__length1;
				gdouble _tmp48_;
				gdouble* _tmp49_;
				gint _tmp49__length1;
				gdouble _tmp50_;
				if (!_tmp32_) {
					i += 8;
				}
				_tmp32_ = FALSE;
				_tmp33_ = _result_;
				_tmp33__length1 = _result__length1;
				if (!((i + 7) < _tmp33__length1)) {
					break;
				}
				_tmp34_ = simplified;
				_tmp35_ = _result_;
				_tmp35__length1 = _result__length1;
				_tmp36_ = _tmp35_[i];
				_tmp37_ = _result_;
				_tmp37__length1 = _result__length1;
				_tmp38_ = _tmp37_[i + 1];
				_tmp39_ = _result_;
				_tmp39__length1 = _result__length1;
				_tmp40_ = _tmp39_[i + 2];
				_tmp41_ = _result_;
				_tmp41__length1 = _result__length1;
				_tmp42_ = _tmp41_[i + 3];
				_tmp43_ = _result_;
				_tmp43__length1 = _result__length1;
				_tmp44_ = _tmp43_[i + 4];
				_tmp45_ = _result_;
				_tmp45__length1 = _result__length1;
				_tmp46_ = _tmp45_[i + 5];
				_tmp47_ = _result_;
				_tmp47__length1 = _result__length1;
				_tmp48_ = _tmp47_[i + 6];
				_tmp49_ = _result_;
				_tmp49__length1 = _result__length1;
				_tmp50_ = _tmp49_[i + 7];
				bird_font_path_add_cubic_bezier_points (_tmp34_, _tmp36_, _tmp38_, _tmp40_, _tmp42_, _tmp44_, _tmp46_, _tmp48_, _tmp50_);
			}
		}
	}
	result = simplified;
	_g_object_unref0 (ep);
	_result_ = (g_free (_result_), NULL);
	lines = (g_free (lines), NULL);
	return result;
}

static BirdFontPathList*
bird_font_stroke_tool_remove_intersection_paths (BirdFontStrokeTool* self,
                                                 BirdFontPathList* pl)
{
	BirdFontPathList* r = NULL;
	BirdFontPathList* _tmp0_;
	BirdFontPathList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (pl != NULL, NULL);
	_tmp0_ = bird_font_path_list_new ();
	r = _tmp0_;
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp1_;
		gint _p_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _p_index = 0;
		_tmp1_ = pl->paths;
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontPath* _tmp9_;
			GeeArrayList* _tmp10_;
			GeeArrayList* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			_p_index = _p_index + 1;
			_tmp5_ = _p_index;
			_tmp6_ = _p_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _p_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _p_index);
			p = (BirdFontPath*) _tmp8_;
			_tmp9_ = p;
			_tmp10_ = bird_font_path_get_points (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
			_tmp13_ = _tmp12_;
			if (_tmp13_ > 7) {
				BirdFontPathList* _tmp14_;
				BirdFontPath* _tmp15_;
				_tmp14_ = r;
				_tmp15_ = p;
				bird_font_path_list_add (_tmp14_, _tmp15_);
			} else {
				BirdFontPath* _tmp16_;
				_tmp16_ = p;
				if (!bird_font_stroke_tool_has_new_corner (self, _tmp16_)) {
					BirdFontPathList* _tmp17_;
					BirdFontPath* _tmp18_;
					_tmp17_ = r;
					_tmp18_ = p;
					bird_font_path_list_add (_tmp17_, _tmp18_);
				} else {
					BirdFontPath* _tmp19_;
					_tmp19_ = p;
					if (bird_font_stroke_tool_counters (self, pl, _tmp19_) == 0) {
						BirdFontPathList* _tmp20_;
						BirdFontPath* _tmp21_;
						_tmp20_ = r;
						_tmp21_ = p;
						bird_font_path_list_add (_tmp20_, _tmp21_);
					}
				}
			}
			_g_object_unref0 (p);
		}
	}
	result = r;
	return result;
}

static gboolean
bird_font_stroke_tool_has_new_corner (BirdFontStrokeTool* self,
                                      BirdFontPath* p)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (p != NULL, FALSE);
	{
		GeeArrayList* _ep_list = NULL;
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _ep_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _ep_index = 0;
		_tmp0_ = bird_font_path_get_points (p);
		_tmp1_ = _tmp0_;
		_ep_list = _tmp1_;
		_tmp2_ = _ep_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_ep_size = _tmp4_;
		_ep_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontEditPoint* ep = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontEditPoint* _tmp9_;
			_ep_index = _ep_index + 1;
			_tmp5_ = _ep_index;
			_tmp6_ = _ep_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _ep_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _ep_index);
			ep = (BirdFontEditPoint*) _tmp8_;
			_tmp9_ = ep;
			if ((_tmp9_->flags & BIRD_FONT_EDIT_POINT_NEW_CORNER) > ((guint) 0)) {
				result = TRUE;
				_g_object_unref0 (ep);
				return result;
			}
			_g_object_unref0 (ep);
		}
	}
	result = FALSE;
	return result;
}

static void
bird_font_stroke_tool_add_line_cap (BirdFontStrokeTool* self,
                                    BirdFontPath* path,
                                    BirdFontPath* stroke1,
                                    BirdFontPath* stroke2,
                                    gboolean last_cap)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (stroke1 != NULL);
	g_return_if_fail (stroke2 != NULL);
	if (path->line_cap == BIRD_FONT_LINE_CAP_SQUARE) {
		bird_font_stroke_tool_add_square_cap (self, path, stroke1, stroke2, last_cap);
	} else {
		if (path->line_cap == BIRD_FONT_LINE_CAP_ROUND) {
			bird_font_stroke_tool_add_round_cap (self, path, stroke1, stroke2, last_cap);
		}
	}
}

static void
bird_font_stroke_tool_add_round_cap (BirdFontStrokeTool* self,
                                     BirdFontPath* path,
                                     BirdFontPath* stroke1,
                                     BirdFontPath* stroke2,
                                     gboolean last_cap)
{
	gdouble px = 0.0;
	gdouble py = 0.0;
	gdouble step = 0.0;
	gdouble start_angle = 0.0;
	gdouble stop_angle = 0.0;
	gdouble radius = 0.0;
	BirdFontEditPoint* n = NULL;
	BirdFontEditPoint* nstart = NULL;
	BirdFontEditPoint* nend = NULL;
	BirdFontPath* cap = NULL;
	BirdFontPath* _tmp0_;
	BirdFontEditPoint* start = NULL;
	BirdFontEditPoint* end = NULL;
	BirdFontEditPointHandle* last_handle = NULL;
	BirdFontEditPoint* first = NULL;
	BirdFontEditPoint* last = NULL;
	BirdFontEditPoint* _tmp1_;
	BirdFontEditPoint* _tmp2_;
	BirdFontEditPointHandle* _tmp3_;
	BirdFontEditPointHandle* _tmp4_;
	BirdFontEditPoint* _tmp5_;
	BirdFontEditPoint* _tmp6_;
	BirdFontEditPointHandle* _tmp7_;
	BirdFontPath* _tmp8_;
	BirdFontEditPoint* _tmp9_;
	BirdFontEditPoint* _tmp10_;
	BirdFontEditPoint* _tmp11_;
	BirdFontEditPoint* _tmp12_;
	BirdFontEditPoint* _tmp13_;
	BirdFontPath* _tmp27_;
	BirdFontEditPoint* _tmp28_;
	BirdFontEditPoint* _tmp29_;
	BirdFontEditPoint* _tmp30_;
	gint size = 0;
	BirdFontPath* _tmp44_;
	GeeArrayList* _tmp45_;
	GeeArrayList* _tmp46_;
	gint _tmp47_;
	gint _tmp48_;
	gint f = 0;
	GeeArrayList* _tmp58_;
	GeeArrayList* _tmp59_;
	gint _tmp60_;
	gint _tmp61_;
	BirdFontPath* _tmp78_;
	GeeArrayList* _tmp79_;
	GeeArrayList* _tmp80_;
	gint _tmp81_;
	gint _tmp82_;
	gint _tmp83_;
	GeeArrayList* _tmp84_;
	GeeArrayList* _tmp85_;
	gpointer _tmp86_;
	BirdFontEditPoint* _tmp87_;
	BirdFontEditPoint* _tmp88_;
	BirdFontEditPoint* _tmp89_;
	BirdFontEditPoint* _tmp90_;
	BirdFontEditPoint* _tmp91_;
	BirdFontEditPoint* _tmp92_;
	BirdFontEditPoint* _tmp93_;
	BirdFontEditPoint* _tmp94_;
	BirdFontEditPoint* _tmp95_;
	BirdFontEditPoint* _tmp96_;
	BirdFontEditPoint* _tmp97_;
	BirdFontEditPoint* _tmp98_;
	BirdFontEditPoint* _tmp99_;
	BirdFontEditPoint* _tmp100_;
	BirdFontEditPoint* _tmp101_;
	BirdFontEditPoint* _tmp102_;
	BirdFontEditPoint* _tmp103_;
	BirdFontEditPoint* _tmp104_;
	BirdFontEditPointHandle* _tmp105_;
	BirdFontEditPoint* _tmp106_;
	BirdFontEditPointHandle* _tmp107_;
	BirdFontEditPoint* _tmp108_;
	BirdFontEditPointHandle* _tmp109_;
	BirdFontEditPoint* _tmp110_;
	gdouble a = 0.0;
	gdouble l = 0.0;
	BirdFontPath* _tmp111_;
	GeeArrayList* _tmp112_;
	GeeArrayList* _tmp113_;
	gint _tmp114_;
	gint _tmp115_;
	BirdFontEditPointHandle* _tmp116_;
	BirdFontPath* _tmp117_;
	GeeArrayList* _tmp118_;
	GeeArrayList* _tmp119_;
	gpointer _tmp120_;
	BirdFontEditPoint* _tmp121_;
	BirdFontEditPointHandle* _tmp122_;
	BirdFontEditPointHandle* _tmp123_;
	BirdFontEditPointHandle* _tmp124_;
	BirdFontEditPointHandle* _tmp125_;
	BirdFontEditPointHandle* _tmp126_;
	BirdFontEditPoint* _tmp127_;
	BirdFontEditPointHandle* _tmp128_;
	BirdFontEditPoint* _tmp129_;
	BirdFontEditPointHandle* _tmp130_;
	BirdFontEditPoint* _tmp131_;
	BirdFontEditPointHandle* _tmp132_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (stroke1 != NULL);
	g_return_if_fail (stroke2 != NULL);
	_tmp0_ = bird_font_path_new ();
	cap = _tmp0_;
	bird_font_path_remove_points_on_points (stroke1, 0.00001);
	bird_font_path_remove_points_on_points (stroke2, 0.00001);
	_tmp1_ = bird_font_path_get_first_point (path);
	_tmp2_ = _tmp1_;
	_tmp3_ = bird_font_edit_point_get_right_handle (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (last_handle);
	last_handle = _tmp4_;
	_g_object_unref0 (_tmp2_);
	_tmp5_ = bird_font_path_get_last_point (stroke1);
	_g_object_unref0 (start);
	start = _tmp5_;
	_tmp6_ = bird_font_path_get_first_point (stroke2);
	_g_object_unref0 (end);
	end = _tmp6_;
	_tmp7_ = last_handle;
	start_angle = _tmp7_->angle + (G_PI / 2);
	stop_angle = start_angle + G_PI;
	_tmp8_ = cap;
	_tmp9_ = start;
	_tmp10_ = start;
	_tmp11_ = bird_font_path_add (_tmp8_, _tmp9_->x, _tmp10_->y);
	_g_object_unref0 (nstart);
	nstart = _tmp11_;
	_tmp12_ = start;
	_tmp13_ = end;
	radius = bird_font_path_distance_to_point (_tmp12_, _tmp13_) / 2;
	step = G_PI / 5;
	{
		gint j = 0;
		j = 0;
		{
			gboolean _tmp14_ = FALSE;
			_tmp14_ = TRUE;
			while (TRUE) {
				gdouble angle = 0.0;
				BirdFontEditPointHandle* _tmp16_;
				BirdFontEditPoint* _tmp17_;
				BirdFontEditPointHandle* _tmp18_;
				BirdFontEditPoint* _tmp19_;
				BirdFontPath* _tmp20_;
				BirdFontEditPoint* _tmp21_;
				BirdFontEditPoint* _tmp22_;
				BirdFontEditPoint* _tmp23_;
				BirdFontEditPointHandle* _tmp24_;
				BirdFontEditPoint* _tmp25_;
				BirdFontEditPointHandle* _tmp26_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = j;
					j = _tmp15_ + 1;
				}
				_tmp14_ = FALSE;
				if (!(j < 5)) {
					break;
				}
				angle = start_angle + (step * j);
				_tmp16_ = last_handle;
				_tmp17_ = _tmp16_->parent;
				px = (radius * cos (angle)) + _tmp17_->x;
				_tmp18_ = last_handle;
				_tmp19_ = _tmp18_->parent;
				py = (radius * sin (angle)) + _tmp19_->y;
				_tmp20_ = cap;
				_tmp21_ = bird_font_path_add (_tmp20_, px, py);
				_g_object_unref0 (n);
				n = _tmp21_;
				_tmp22_ = n;
				_tmp22_->type = BIRD_FONT_POINT_TYPE_LINE_CUBIC;
				_tmp23_ = n;
				_tmp24_ = bird_font_edit_point_get_right_handle (_tmp23_);
				_tmp24_->type = BIRD_FONT_POINT_TYPE_LINE_CUBIC;
				_tmp25_ = n;
				_tmp26_ = bird_font_edit_point_get_left_handle (_tmp25_);
				_tmp26_->type = BIRD_FONT_POINT_TYPE_LINE_CUBIC;
			}
		}
	}
	_tmp27_ = cap;
	_tmp28_ = end;
	_tmp29_ = end;
	_tmp30_ = bird_font_path_add (_tmp27_, _tmp28_->x, _tmp29_->y);
	_g_object_unref0 (nend);
	nend = _tmp30_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp31_ = FALSE;
			_tmp31_ = TRUE;
			while (TRUE) {
				BirdFontPath* _tmp33_;
				GeeArrayList* _tmp34_;
				GeeArrayList* _tmp35_;
				gint _tmp36_;
				gint _tmp37_;
				BirdFontPath* _tmp38_;
				BirdFontPath* _tmp39_;
				GeeArrayList* _tmp40_;
				GeeArrayList* _tmp41_;
				gpointer _tmp42_;
				BirdFontEditPoint* _tmp43_;
				if (!_tmp31_) {
					gint _tmp32_;
					_tmp32_ = i;
					i = _tmp32_ + 1;
				}
				_tmp31_ = FALSE;
				_tmp33_ = cap;
				_tmp34_ = bird_font_path_get_points (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp35_);
				_tmp37_ = _tmp36_;
				if (!(i < _tmp37_)) {
					break;
				}
				_tmp38_ = cap;
				_tmp39_ = cap;
				_tmp40_ = bird_font_path_get_points (_tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = gee_abstract_list_get ((GeeAbstractList*) _tmp41_, i);
				_tmp43_ = (BirdFontEditPoint*) _tmp42_;
				bird_font_path_recalculate_linear_handles_for_point (_tmp38_, _tmp43_);
				_g_object_unref0 (_tmp43_);
			}
		}
	}
	_tmp44_ = cap;
	_tmp45_ = bird_font_path_get_points (_tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp46_);
	_tmp48_ = _tmp47_;
	size = _tmp48_;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp49_ = FALSE;
			_tmp49_ = TRUE;
			while (TRUE) {
				BirdFontPath* _tmp51_;
				GeeArrayList* _tmp52_;
				GeeArrayList* _tmp53_;
				gpointer _tmp54_;
				BirdFontEditPoint* _tmp55_;
				BirdFontEditPoint* _tmp56_;
				BirdFontEditPoint* _tmp57_;
				if (!_tmp49_) {
					gint _tmp50_;
					_tmp50_ = i;
					i = _tmp50_ + 1;
				}
				_tmp49_ = FALSE;
				if (!(i < size)) {
					break;
				}
				_tmp51_ = cap;
				_tmp52_ = bird_font_path_get_points (_tmp51_);
				_tmp53_ = _tmp52_;
				_tmp54_ = gee_abstract_list_get ((GeeAbstractList*) _tmp53_, i);
				_g_object_unref0 (n);
				n = (BirdFontEditPoint*) _tmp54_;
				_tmp55_ = n;
				bird_font_edit_point_convert_to_curve (_tmp55_);
				_tmp56_ = n;
				bird_font_edit_point_set_tie_handle (_tmp56_, TRUE);
				_tmp57_ = n;
				bird_font_edit_point_process_tied_handle (_tmp57_);
			}
		}
	}
	_tmp58_ = bird_font_path_get_points (stroke1);
	_tmp59_ = _tmp58_;
	_tmp60_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp59_);
	_tmp61_ = _tmp60_;
	f = _tmp61_ - 1;
	{
		gint i = 0;
		i = 2;
		{
			gboolean _tmp62_ = FALSE;
			_tmp62_ = TRUE;
			while (TRUE) {
				BirdFontPath* _tmp64_;
				GeeArrayList* _tmp65_;
				GeeArrayList* _tmp66_;
				gint _tmp67_;
				gint _tmp68_;
				BirdFontPath* _tmp69_;
				GeeArrayList* _tmp70_;
				GeeArrayList* _tmp71_;
				gpointer _tmp72_;
				BirdFontEditPoint* _tmp73_;
				BirdFontEditPoint* _tmp74_;
				BirdFontEditPoint* _tmp75_;
				BirdFontEditPoint* _tmp76_;
				BirdFontEditPoint* _tmp77_;
				if (!_tmp62_) {
					gint _tmp63_;
					_tmp63_ = i;
					i = _tmp63_ + 1;
				}
				_tmp62_ = FALSE;
				_tmp64_ = cap;
				_tmp65_ = bird_font_path_get_points (_tmp64_);
				_tmp66_ = _tmp65_;
				_tmp67_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp66_);
				_tmp68_ = _tmp67_;
				if (!(i < (_tmp68_ - 1))) {
					break;
				}
				_tmp69_ = cap;
				_tmp70_ = bird_font_path_get_points (_tmp69_);
				_tmp71_ = _tmp70_;
				_tmp72_ = gee_abstract_list_get ((GeeAbstractList*) _tmp71_, i);
				_tmp73_ = (BirdFontEditPoint*) _tmp72_;
				_tmp74_ = bird_font_edit_point_copy (_tmp73_);
				_g_object_unref0 (n);
				n = _tmp74_;
				_g_object_unref0 (_tmp73_);
				_tmp75_ = n;
				_tmp76_ = bird_font_path_add_point (stroke1, _tmp75_);
				_tmp77_ = _tmp76_;
				_g_object_unref0 (_tmp77_);
			}
		}
	}
	_tmp78_ = cap;
	bird_font_path_remove_points_on_points (_tmp78_, 0.00001);
	_tmp79_ = bird_font_path_get_points (stroke1);
	_tmp80_ = _tmp79_;
	_tmp81_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp80_);
	_tmp82_ = _tmp81_;
	_tmp83_ = f;
	g_return_if_fail ((0 < _tmp83_) && (_tmp83_ < _tmp82_));
	_tmp84_ = bird_font_path_get_points (stroke1);
	_tmp85_ = _tmp84_;
	_tmp86_ = gee_abstract_list_get ((GeeAbstractList*) _tmp85_, f);
	_g_object_unref0 (first);
	first = (BirdFontEditPoint*) _tmp86_;
	_tmp87_ = bird_font_path_get_last_point (stroke1);
	_g_object_unref0 (last);
	last = _tmp87_;
	_tmp88_ = last;
	bird_font_edit_point_convert_to_curve (_tmp88_);
	_tmp89_ = bird_font_path_get_first_point (stroke2);
	_tmp90_ = _tmp89_;
	_tmp91_ = bird_font_path_add_point (stroke1, _tmp90_);
	_g_object_unref0 (last);
	last = _tmp91_;
	_g_object_unref0 (_tmp90_);
	_tmp92_ = bird_font_path_delete_first_point (stroke2);
	_tmp93_ = _tmp92_;
	_g_object_unref0 (_tmp93_);
	_tmp94_ = last;
	bird_font_edit_point_convert_to_line (_tmp94_);
	_tmp95_ = last;
	bird_font_path_recalculate_linear_handles_for_point (stroke1, _tmp95_);
	_tmp96_ = last;
	_tmp97_ = bird_font_path_get_first_point (stroke2);
	_tmp98_ = _tmp97_;
	_tmp99_ = bird_font_path_add_point (stroke1, _tmp98_);
	_tmp100_ = _tmp99_;
	_tmp101_ = bird_font_edit_point_get_link_item (_tmp100_);
	_tmp96_->next = _tmp101_;
	_g_object_unref0 (_tmp100_);
	_g_object_unref0 (_tmp98_);
	_tmp102_ = bird_font_path_delete_first_point (stroke2);
	_tmp103_ = _tmp102_;
	_g_object_unref0 (_tmp103_);
	_tmp104_ = last;
	_tmp105_ = bird_font_edit_point_get_left_handle (_tmp104_);
	bird_font_edit_point_handle_convert_to_curve (_tmp105_);
	_tmp106_ = last;
	_tmp107_ = bird_font_edit_point_get_left_handle (_tmp106_);
	_tmp108_ = last;
	_tmp109_ = bird_font_edit_point_get_right_handle (_tmp108_);
	_tmp107_->angle = _tmp109_->angle + G_PI;
	_tmp110_ = last;
	_tmp110_->flags = BIRD_FONT_EDIT_POINT_CURVE_KEEP;
	_tmp111_ = cap;
	_tmp112_ = bird_font_path_get_points (_tmp111_);
	_tmp113_ = _tmp112_;
	_tmp114_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp113_);
	_tmp115_ = _tmp114_;
	g_return_if_fail (_tmp115_ > 1);
	_tmp116_ = bird_font_edit_point_get_left_handle (first);
	a = fmod (_tmp116_->angle + G_PI, 2 * G_PI);
	_tmp117_ = cap;
	_tmp118_ = bird_font_path_get_points (_tmp117_);
	_tmp119_ = _tmp118_;
	_tmp120_ = gee_abstract_list_get ((GeeAbstractList*) _tmp119_, 1);
	_tmp121_ = (BirdFontEditPoint*) _tmp120_;
	_tmp122_ = bird_font_edit_point_get_right_handle (_tmp121_);
	l = _tmp122_->length;
	_g_object_unref0 (_tmp121_);
	_tmp123_ = bird_font_edit_point_get_right_handle (first);
	bird_font_edit_point_handle_convert_to_curve (_tmp123_);
	_tmp124_ = bird_font_edit_point_get_right_handle (first);
	_tmp124_->angle = a;
	_tmp125_ = bird_font_edit_point_get_right_handle (first);
	_tmp125_->length = l;
	_tmp126_ = bird_font_edit_point_get_left_handle (first);
	a = fmod (_tmp126_->angle + G_PI, 2 * G_PI);
	_tmp127_ = last;
	_tmp128_ = bird_font_edit_point_get_left_handle (_tmp127_);
	bird_font_edit_point_handle_convert_to_curve (_tmp128_);
	_tmp129_ = last;
	_tmp130_ = bird_font_edit_point_get_left_handle (_tmp129_);
	_tmp130_->angle = a;
	_tmp131_ = last;
	_tmp132_ = bird_font_edit_point_get_left_handle (_tmp131_);
	_tmp132_->length = l;
	_g_object_unref0 (last);
	_g_object_unref0 (first);
	_g_object_unref0 (last_handle);
	_g_object_unref0 (end);
	_g_object_unref0 (start);
	_g_object_unref0 (cap);
	_g_object_unref0 (nend);
	_g_object_unref0 (nstart);
	_g_object_unref0 (n);
}

static void
bird_font_stroke_tool_add_square_cap (BirdFontStrokeTool* self,
                                      BirdFontPath* path,
                                      BirdFontPath* stroke1,
                                      BirdFontPath* stroke2,
                                      gboolean last_cap)
{
	BirdFontEditPointHandle* last_handle = NULL;
	BirdFontEditPoint* start = NULL;
	BirdFontEditPoint* end = NULL;
	BirdFontEditPoint* n = NULL;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble stroke_width = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	BirdFontEditPoint* _tmp2_;
	BirdFontEditPoint* _tmp3_;
	BirdFontEditPointHandle* _tmp4_;
	BirdFontEditPointHandle* _tmp5_;
	BirdFontEditPoint* _tmp6_;
	BirdFontEditPoint* _tmp7_;
	BirdFontEditPoint* _tmp8_;
	BirdFontEditPoint* _tmp9_;
	BirdFontEditPoint* _tmp10_;
	BirdFontEditPointHandle* _tmp11_;
	BirdFontEditPoint* _tmp12_;
	BirdFontEditPointHandle* _tmp13_;
	BirdFontEditPoint* _tmp14_;
	BirdFontEditPoint* _tmp15_;
	BirdFontEditPoint* _tmp16_;
	BirdFontEditPoint* _tmp17_;
	BirdFontEditPointHandle* _tmp18_;
	BirdFontEditPoint* _tmp19_;
	BirdFontEditPointHandle* _tmp20_;
	BirdFontEditPoint* _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (stroke1 != NULL);
	g_return_if_fail (stroke2 != NULL);
	_tmp0_ = bird_font_path_get_stroke (path);
	_tmp1_ = _tmp0_;
	stroke_width = _tmp1_ / 2;
	_tmp2_ = bird_font_path_get_first_point (path);
	_tmp3_ = _tmp2_;
	_tmp4_ = bird_font_edit_point_get_right_handle (_tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (last_handle);
	last_handle = _tmp5_;
	_g_object_unref0 (_tmp3_);
	_tmp6_ = bird_font_path_get_last_point (stroke1);
	_g_object_unref0 (start);
	start = _tmp6_;
	_tmp7_ = bird_font_path_get_first_point (stroke2);
	_g_object_unref0 (end);
	end = _tmp7_;
	y = sin (last_handle->angle - G_PI) * stroke_width;
	x = cos (last_handle->angle - G_PI) * stroke_width;
	_tmp8_ = bird_font_path_add (stroke1, start->x + x, start->y + y);
	_g_object_unref0 (n);
	n = _tmp8_;
	_tmp9_ = n;
	_tmp9_->type = BIRD_FONT_POINT_TYPE_CUBIC;
	_tmp10_ = n;
	_tmp11_ = bird_font_edit_point_get_right_handle (_tmp10_);
	_tmp11_->type = BIRD_FONT_POINT_TYPE_CUBIC;
	_tmp12_ = n;
	_tmp13_ = bird_font_edit_point_get_left_handle (_tmp12_);
	_tmp13_->type = BIRD_FONT_POINT_TYPE_CUBIC;
	_tmp14_ = n;
	bird_font_edit_point_convert_to_line (_tmp14_);
	_tmp15_ = bird_font_path_add (stroke1, end->x + x, end->y + y);
	_g_object_unref0 (n);
	n = _tmp15_;
	_tmp16_ = n;
	_tmp16_->type = BIRD_FONT_POINT_TYPE_CUBIC;
	_tmp17_ = n;
	_tmp18_ = bird_font_edit_point_get_right_handle (_tmp17_);
	_tmp18_->type = BIRD_FONT_POINT_TYPE_CUBIC;
	_tmp19_ = n;
	_tmp20_ = bird_font_edit_point_get_left_handle (_tmp19_);
	_tmp20_->type = BIRD_FONT_POINT_TYPE_CUBIC;
	_tmp21_ = n;
	bird_font_edit_point_convert_to_line (_tmp21_);
	_g_object_unref0 (n);
	_g_object_unref0 (end);
	_g_object_unref0 (start);
	_g_object_unref0 (last_handle);
}

/** Create one stroke from the outline and counter stroke and close the 
 * open endings.
 * 
 * @param path the path to create stroke for
 * @param stroke for the outline of path
 * @param stroke for the counter path
 */
static BirdFontPath*
bird_font_stroke_tool_merge_strokes (BirdFontStrokeTool* self,
                                     BirdFontPath* path,
                                     BirdFontPath* stroke,
                                     BirdFontPath* counter)
{
	BirdFontPath* merged = NULL;
	BirdFontEditPoint* last_counter = NULL;
	BirdFontEditPoint* first = NULL;
	BirdFontPath* _tmp0_;
	BirdFontEditPoint* _tmp1_;
	BirdFontEditPoint* _tmp2_;
	BirdFontPath* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (stroke != NULL, NULL);
	g_return_val_if_fail (counter != NULL, NULL);
	_tmp0_ = bird_font_path_copy (stroke);
	_g_object_unref0 (merged);
	merged = _tmp0_;
	bird_font_path_reverse (merged);
	_tmp1_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
	_g_object_unref0 (last_counter);
	last_counter = _tmp1_;
	_tmp2_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
	_g_object_unref0 (first);
	first = _tmp2_;
	bird_font_stroke_tool_add_line_cap (self, path, merged, counter, TRUE);
	bird_font_path_reverse (path);
	bird_font_stroke_tool_add_line_cap (self, path, counter, merged, TRUE);
	bird_font_path_reverse (path);
	bird_font_path_append_path (merged, counter);
	bird_font_path_close (merged);
	bird_font_path_create_list (merged);
	bird_font_path_recalculate_linear_handles (merged);
	result = merged;
	_g_object_unref0 (first);
	_g_object_unref0 (last_counter);
	return result;
}

void
bird_font_stroke_tool_move_segment (BirdFontEditPoint* stroke_start,
                                    BirdFontEditPoint* stroke_stop,
                                    gdouble thickness)
{
	BirdFontEditPointHandle* r = NULL;
	BirdFontEditPointHandle* l = NULL;
	gdouble m = 0.0;
	gdouble n = 0.0;
	gdouble qx = 0.0;
	gdouble qy = 0.0;
	BirdFontEditPointHandle* _tmp0_;
	BirdFontEditPointHandle* _tmp1_;
	BirdFontEditPointHandle* _tmp2_;
	BirdFontEditPointHandle* _tmp3_;
	BirdFontEditPointHandle* _tmp4_;
	BirdFontEditPointHandle* _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	BirdFontEditPointHandle* _tmp10_;
	BirdFontEditPointHandle* _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	g_return_if_fail (stroke_start != NULL);
	g_return_if_fail (stroke_stop != NULL);
	bird_font_edit_point_set_tie_handle (stroke_start, FALSE);
	bird_font_edit_point_set_tie_handle (stroke_stop, FALSE);
	_tmp0_ = bird_font_edit_point_get_right_handle (stroke_start);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (r);
	r = _tmp1_;
	_tmp2_ = bird_font_edit_point_get_left_handle (stroke_stop);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (l);
	l = _tmp3_;
	m = cos (r->angle + (G_PI / 2)) * thickness;
	n = sin (r->angle + (G_PI / 2)) * thickness;
	_tmp4_ = bird_font_edit_point_get_right_handle (stroke_start);
	bird_font_edit_point_handle_move_to_coordinate_delta (_tmp4_, m, n);
	_tmp5_ = bird_font_edit_point_get_left_handle (stroke_start);
	bird_font_edit_point_handle_move_to_coordinate_delta (_tmp5_, m, n);
	_tmp6_ = bird_font_edit_point_get_independent_x (stroke_start);
	_tmp7_ = _tmp6_;
	bird_font_edit_point_set_independent_x (stroke_start, _tmp7_ + m);
	_tmp8_ = bird_font_edit_point_get_independent_y (stroke_start);
	_tmp9_ = _tmp8_;
	bird_font_edit_point_set_independent_y (stroke_start, _tmp9_ + n);
	qx = cos (l->angle - (G_PI / 2)) * thickness;
	qy = sin (l->angle - (G_PI / 2)) * thickness;
	_tmp10_ = bird_font_edit_point_get_right_handle (stroke_stop);
	bird_font_edit_point_handle_move_to_coordinate_delta (_tmp10_, qx, qy);
	_tmp11_ = bird_font_edit_point_get_left_handle (stroke_stop);
	bird_font_edit_point_handle_move_to_coordinate_delta (_tmp11_, qx, qy);
	_tmp12_ = bird_font_edit_point_get_independent_x (stroke_stop);
	_tmp13_ = _tmp12_;
	bird_font_edit_point_set_independent_x (stroke_stop, _tmp13_ + qx);
	_tmp14_ = bird_font_edit_point_get_independent_y (stroke_stop);
	_tmp15_ = _tmp14_;
	bird_font_edit_point_set_independent_y (stroke_stop, _tmp15_ + qy);
	_g_object_unref0 (l);
	_g_object_unref0 (r);
}

static void
bird_font_stroke_tool_add_corner (BirdFontStrokeTool* self,
                                  BirdFontPath* stroked,
                                  BirdFontEditPoint* previous,
                                  BirdFontEditPoint* next,
                                  BirdFontEditPoint* original,
                                  gdouble stroke_width)
{
	gdouble ratio = 0.0;
	gdouble distance = 0.0;
	BirdFontEditPoint* corner = NULL;
	gdouble corner_x = 0.0;
	gdouble corner_y = 0.0;
	BirdFontEditPointHandle* previous_handle = NULL;
	BirdFontEditPointHandle* next_handle = NULL;
	BirdFontEditPoint* cutoff1 = NULL;
	BirdFontEditPoint* cutoff2 = NULL;
	gdouble adjusted_stroke = 0.0;
	gboolean d1 = FALSE;
	gboolean d2 = FALSE;
	BirdFontEditPointHandle* _tmp0_;
	BirdFontEditPointHandle* _tmp1_;
	BirdFontEditPointHandle* _tmp2_;
	BirdFontEditPointHandle* _tmp3_;
	BirdFontEditPointHandle* _tmp4_;
	BirdFontEditPointHandle* _tmp5_;
	BirdFontEditPointHandle* _tmp6_;
	BirdFontEditPointHandle* _tmp7_;
	BirdFontEditPointHandle* _tmp8_;
	BirdFontEditPointHandle* _tmp9_;
	BirdFontEditPointHandle* _tmp10_;
	BirdFontEditPointHandle* _tmp11_;
	gdouble _tmp12_ = 0.0;
	gdouble _tmp13_ = 0.0;
	BirdFontEditPoint* _tmp14_;
	BirdFontEditPoint* _tmp15_;
	BirdFontEditPointHandle* _tmp16_;
	BirdFontEditPointHandle* _tmp17_;
	BirdFontEditPointHandle* _tmp18_;
	BirdFontEditPointHandle* _tmp19_;
	BirdFontEditPoint* _tmp20_;
	gdouble or = 0.0;
	BirdFontEditPointHandle* _tmp21_;
	gdouble ol = 0.0;
	BirdFontEditPointHandle* _tmp22_;
	BirdFontEditPoint* _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stroked != NULL);
	g_return_if_fail (previous != NULL);
	g_return_if_fail (next != NULL);
	g_return_if_fail (original != NULL);
	adjusted_stroke = (stroke_width * 0.999999) / 2.0;
	_tmp0_ = bird_font_edit_point_get_left_handle (previous);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (previous_handle);
	previous_handle = _tmp1_;
	_tmp2_ = bird_font_edit_point_get_right_handle (next);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (next_handle);
	next_handle = _tmp3_;
	_tmp4_ = previous_handle;
	bird_font_edit_point_handle_convert_to_line (_tmp4_);
	_tmp5_ = next_handle;
	bird_font_edit_point_handle_convert_to_line (_tmp5_);
	_tmp6_ = previous_handle;
	_tmp7_ = previous_handle;
	_tmp7_->angle = _tmp7_->angle + G_PI;
	_tmp8_ = next_handle;
	_tmp9_ = next_handle;
	_tmp9_->angle = _tmp9_->angle + G_PI;
	_tmp10_ = previous_handle;
	_tmp11_ = next_handle;
	bird_font_path_find_intersection_handle (_tmp10_, _tmp11_, &_tmp12_, &_tmp13_);
	corner_x = _tmp12_;
	corner_y = _tmp13_;
	_tmp14_ = bird_font_edit_point_new (corner_x, corner_y, BIRD_FONT_POINT_TYPE_CUBIC);
	_g_object_unref0 (corner);
	corner = _tmp14_;
	_tmp15_ = corner;
	bird_font_edit_point_convert_to_line (_tmp15_);
	_tmp16_ = previous_handle;
	_tmp17_ = previous_handle;
	_tmp17_->angle = _tmp17_->angle - G_PI;
	_tmp18_ = next_handle;
	_tmp19_ = next_handle;
	_tmp19_->angle = _tmp19_->angle - G_PI;
	_tmp20_ = corner;
	distance = bird_font_path_distance_to_point (_tmp20_, original);
	ratio = (1.5 * fabs (adjusted_stroke)) / distance;
	_tmp21_ = bird_font_edit_point_get_right_handle (original);
	or = _tmp21_->angle;
	_tmp22_ = bird_font_edit_point_get_left_handle (original);
	ol = _tmp22_->angle;
	_tmp23_ = previous->prev;
	if (_tmp23_ == NULL) {
		g_warning ("StrokeTool.vala:1376: Point before corner.");
		d1 = FALSE;
		d2 = FALSE;
	} else {
		BirdFontEditPoint* _tmp24_;
		BirdFontEditPoint* _tmp25_;
		gdouble _tmp26_;
		gdouble _tmp27_;
		BirdFontEditPoint* _tmp28_;
		BirdFontEditPoint* _tmp29_;
		gdouble _tmp30_;
		gdouble _tmp31_;
		_tmp24_ = corner;
		_tmp25_ = bird_font_edit_point_get_prev (previous);
		_tmp26_ = (gdouble) 0;
		_tmp27_ = previous->x - _tmp25_->x;
		d1 = (((_tmp24_->x - previous->x) >= _tmp26_) && (_tmp26_ == _tmp27_)) && (_tmp27_ >= ((gdouble) 0));
		_tmp28_ = corner;
		_tmp29_ = bird_font_edit_point_get_prev (previous);
		_tmp30_ = (gdouble) 0;
		_tmp31_ = previous->y - _tmp29_->y;
		d2 = (((_tmp28_->y - previous->y) >= _tmp30_) && (_tmp30_ == _tmp31_)) && (_tmp31_ >= ((gdouble) 0));
	}
	if (ratio > ((gdouble) 1)) {
		gboolean _tmp32_ = FALSE;
		if (!d1) {
			_tmp32_ = !d2;
		} else {
			_tmp32_ = FALSE;
		}
		if (_tmp32_) {
			_g_object_unref0 (cutoff2);
			_g_object_unref0 (cutoff1);
			_g_object_unref0 (next_handle);
			_g_object_unref0 (previous_handle);
			_g_object_unref0 (corner);
			return;
		} else {
			BirdFontEditPoint* _tmp33_;
			BirdFontEditPoint* _tmp34_;
			BirdFontEditPoint* _tmp35_;
			_tmp33_ = corner;
			_tmp34_ = bird_font_path_add_point (stroked, _tmp33_);
			_tmp35_ = _tmp34_;
			_g_object_unref0 (_tmp35_);
		}
	} else {
		BirdFontEditPoint* _tmp36_;
		BirdFontEditPoint* _tmp37_;
		BirdFontEditPoint* _tmp38_;
		BirdFontEditPoint* _tmp39_;
		BirdFontEditPoint* _tmp40_;
		BirdFontEditPoint* _tmp41_;
		gboolean _tmp54_ = FALSE;
		BirdFontEditPoint* _tmp55_;
		BirdFontEditPoint* _tmp61_;
		BirdFontEditPoint* _tmp62_;
		gboolean _tmp63_ = FALSE;
		_tmp36_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
		_g_object_unref0 (cutoff1);
		cutoff1 = _tmp36_;
		_tmp37_ = cutoff1;
		bird_font_edit_point_set_point_type (_tmp37_, previous->type);
		_tmp38_ = cutoff1;
		bird_font_edit_point_convert_to_line (_tmp38_);
		_tmp39_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
		_g_object_unref0 (cutoff2);
		cutoff2 = _tmp39_;
		_tmp40_ = cutoff2;
		bird_font_edit_point_set_point_type (_tmp40_, previous->type);
		_tmp41_ = cutoff2;
		bird_font_edit_point_convert_to_line (_tmp41_);
		if (fabs (or - ol) < 0.001) {
			BirdFontEditPoint* _tmp42_;
			BirdFontEditPoint* _tmp43_;
			BirdFontEditPoint* _tmp44_;
			BirdFontEditPoint* _tmp45_;
			_tmp42_ = cutoff1;
			_tmp42_->x = previous->x + ((1.5 * fabs (adjusted_stroke)) * (-cos (or)));
			_tmp43_ = cutoff1;
			_tmp43_->y = previous->y + ((1.5 * fabs (adjusted_stroke)) * (-sin (or)));
			_tmp44_ = cutoff2;
			_tmp44_->x = next->x + ((1.5 * fabs (adjusted_stroke)) * (-cos (or)));
			_tmp45_ = cutoff2;
			_tmp45_->y = next->y + ((1.5 * fabs (adjusted_stroke)) * (-sin (or)));
		} else {
			BirdFontEditPoint* _tmp46_;
			BirdFontEditPoint* _tmp47_;
			BirdFontEditPoint* _tmp48_;
			BirdFontEditPoint* _tmp49_;
			BirdFontEditPoint* _tmp50_;
			BirdFontEditPoint* _tmp51_;
			BirdFontEditPoint* _tmp52_;
			BirdFontEditPoint* _tmp53_;
			_tmp46_ = cutoff1;
			_tmp47_ = corner;
			_tmp46_->x = previous->x + ((_tmp47_->x - previous->x) * ratio);
			_tmp48_ = cutoff1;
			_tmp49_ = corner;
			_tmp48_->y = previous->y + ((_tmp49_->y - previous->y) * ratio);
			_tmp50_ = cutoff2;
			_tmp51_ = corner;
			_tmp50_->x = next->x + ((_tmp51_->x - next->x) * ratio);
			_tmp52_ = cutoff2;
			_tmp53_ = corner;
			_tmp52_->y = next->y + ((_tmp53_->y - next->y) * ratio);
		}
		_tmp55_ = cutoff1;
		if (!bird_font_edit_point_is_valid (_tmp55_)) {
			_tmp54_ = TRUE;
		} else {
			BirdFontEditPoint* _tmp56_;
			_tmp56_ = cutoff2;
			_tmp54_ = bird_font_edit_point_is_valid (_tmp56_);
		}
		if (_tmp54_) {
			BirdFontEditPoint* _tmp57_;
			BirdFontEditPoint* _tmp58_;
			BirdFontEditPoint* _tmp59_;
			BirdFontEditPoint* _tmp60_;
			_tmp57_ = cutoff1;
			_tmp58_ = bird_font_path_add_point (stroked, _tmp57_);
			_g_object_unref0 (cutoff1);
			cutoff1 = _tmp58_;
			_tmp59_ = cutoff2;
			_tmp60_ = bird_font_path_add_point (stroked, _tmp59_);
			_g_object_unref0 (cutoff2);
			cutoff2 = _tmp60_;
		}
		_tmp61_ = cutoff1;
		bird_font_path_recalculate_linear_handles_for_point (stroked, _tmp61_);
		_tmp62_ = cutoff2;
		bird_font_path_recalculate_linear_handles_for_point (stroked, _tmp62_);
		if (!d1) {
			_tmp63_ = !d2;
		} else {
			_tmp63_ = FALSE;
		}
		if (_tmp63_) {
			BirdFontEditPoint* _tmp64_;
			BirdFontEditPoint* _tmp65_;
			_tmp64_ = cutoff1;
			bird_font_edit_point_set_deleted (_tmp64_, TRUE);
			_tmp65_ = cutoff2;
			bird_font_edit_point_set_deleted (_tmp65_, TRUE);
			bird_font_path_remove_deleted_points (stroked);
			_g_object_unref0 (cutoff2);
			_g_object_unref0 (cutoff1);
			_g_object_unref0 (next_handle);
			_g_object_unref0 (previous_handle);
			_g_object_unref0 (corner);
			return;
		}
		if (distance > (4 * stroke_width)) {
			previous->flags = BIRD_FONT_EDIT_POINT_NONE;
			next->flags = BIRD_FONT_EDIT_POINT_NONE;
		} else {
			previous->flags = previous->flags | BIRD_FONT_EDIT_POINT_NEW_CORNER;
			next->flags = next->flags | BIRD_FONT_EDIT_POINT_NEW_CORNER;
		}
	}
	_g_object_unref0 (cutoff2);
	_g_object_unref0 (cutoff1);
	_g_object_unref0 (next_handle);
	_g_object_unref0 (previous_handle);
	_g_object_unref0 (corner);
}

static BirdFontPathList*
bird_font_stroke_tool_get_parts (BirdFontStrokeTool* self,
                                 BirdFontPath* path)
{
	BirdFontPathList* intersections = NULL;
	BirdFontPathList* r = NULL;
	BirdFontPathList* _tmp0_;
	BirdFontPathList* _tmp1_;
	BirdFontPathList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = bird_font_stroke_tool_get_parts_self (self, path, NULL);
	_g_object_unref0 (r);
	r = _tmp0_;
	_tmp1_ = bird_font_path_list_new ();
	_g_object_unref0 (intersections);
	intersections = _tmp1_;
	{
		GeeArrayList* _p_list = NULL;
		BirdFontPathList* _tmp2_;
		GeeArrayList* _tmp3_;
		gint _p_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _p_index = 0;
		_tmp2_ = r;
		_tmp3_ = _tmp2_->paths;
		_p_list = _tmp3_;
		_tmp4_ = _p_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_p_size = _tmp6_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			BirdFontPathList* _tmp11_;
			BirdFontPath* _tmp12_;
			_p_index = _p_index + 1;
			_tmp7_ = _p_index;
			_tmp8_ = _p_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _p_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _p_index);
			p = (BirdFontPath*) _tmp10_;
			_tmp11_ = intersections;
			_tmp12_ = p;
			bird_font_path_list_add (_tmp11_, _tmp12_);
			_g_object_unref0 (p);
		}
	}
	result = intersections;
	_g_object_unref0 (r);
	return result;
}

static BirdFontPathList*
bird_font_stroke_tool_get_parts_self (BirdFontStrokeTool* self,
                                      BirdFontPath* path,
                                      BirdFontPathList* paths)
{
	BirdFontPathList* pl = NULL;
	BirdFontPathList* r = NULL;
	BirdFontStrokeTask* _tmp0_;
	BirdFontPathList* _tmp2_ = NULL;
	BirdFontPathList* _tmp5_;
	BirdFontPathList* _tmp6_;
	BirdFontPathList* _tmp23_;
	GeeArrayList* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	BirdFontPathList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = self->priv->task;
	if (bird_font_task_is_cancelled ((BirdFontTask*) _tmp0_)) {
		BirdFontPathList* _tmp1_;
		_tmp1_ = bird_font_path_list_new ();
		result = _tmp1_;
		_g_object_unref0 (r);
		_g_object_unref0 (pl);
		return result;
	}
	if (paths == NULL) {
		BirdFontPathList* _tmp3_;
		_tmp3_ = bird_font_path_list_new ();
		_g_object_unref0 (_tmp2_);
		_tmp2_ = _tmp3_;
	} else {
		BirdFontPathList* _tmp4_;
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (paths, BIRD_FONT_TYPE_PATH_LIST, BirdFontPathList));
		_g_object_unref0 (_tmp2_);
		_tmp2_ = _tmp4_;
	}
	_tmp5_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (r);
	r = _tmp5_;
	_tmp6_ = bird_font_stroke_tool_split (self, path);
	_g_object_unref0 (pl);
	pl = _tmp6_;
	{
		GeeArrayList* _part_list = NULL;
		BirdFontPathList* _tmp7_;
		GeeArrayList* _tmp8_;
		gint _part_size = 0;
		GeeArrayList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _part_index = 0;
		_tmp7_ = pl;
		_tmp8_ = _tmp7_->paths;
		_part_list = _tmp8_;
		_tmp9_ = _part_list;
		_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_part_size = _tmp11_;
		_part_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			BirdFontPath* part = NULL;
			GeeArrayList* _tmp14_;
			gpointer _tmp15_;
			BirdFontPath* _tmp16_;
			_part_index = _part_index + 1;
			_tmp12_ = _part_index;
			_tmp13_ = _part_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _part_list;
			_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, _part_index);
			part = (BirdFontPath*) _tmp15_;
			_tmp16_ = part;
			if (!bird_font_stroke_tool_has_self_intersection (self, _tmp16_)) {
				BirdFontPathList* _tmp17_;
				BirdFontPath* _tmp18_;
				_tmp17_ = r;
				_tmp18_ = part;
				bird_font_path_list_add (_tmp17_, _tmp18_);
			} else {
				BirdFontPath* _tmp19_;
				BirdFontPathList* _tmp20_;
				BirdFontPathList* _tmp21_;
				BirdFontPathList* _tmp22_;
				_tmp19_ = part;
				_tmp20_ = r;
				_tmp21_ = bird_font_stroke_tool_get_parts_self (self, _tmp19_, _tmp20_);
				_tmp22_ = _tmp21_;
				_g_object_unref0 (_tmp22_);
			}
			_g_object_unref0 (part);
		}
	}
	_tmp23_ = r;
	_tmp24_ = _tmp23_->paths;
	_tmp25_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp24_);
	_tmp26_ = _tmp25_;
	if (_tmp26_ == 0) {
		g_warning ("StrokeTool.vala:1559: No parts in path");
	}
	result = r;
	_g_object_unref0 (_tmp2_);
	_g_object_unref0 (pl);
	return result;
}

static gboolean
bird_font_stroke_tool_has_intersection_points (BirdFontStrokeTool* self,
                                               BirdFontPath* path)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _p_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _p_index = 0;
		_tmp0_ = bird_font_path_get_points (path);
		_tmp1_ = _tmp0_;
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontEditPoint* p = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontEditPoint* _tmp9_;
			_p_index = _p_index + 1;
			_tmp5_ = _p_index;
			_tmp6_ = _p_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _p_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _p_index);
			p = (BirdFontEditPoint*) _tmp8_;
			_tmp9_ = p;
			if ((_tmp9_->flags & BIRD_FONT_EDIT_POINT_INTERSECTION) > ((guint) 0)) {
				result = TRUE;
				_g_object_unref0 (p);
				return result;
			}
			_g_object_unref0 (p);
		}
	}
	result = FALSE;
	return result;
}

/** Split one path at intersection points in two parts. */
static BirdFontPathList*
bird_font_stroke_tool_split (BirdFontStrokeTool* self,
                             BirdFontPath* path)
{
	BirdFontPath* new_path = NULL;
	BirdFontPathList* pl = NULL;
	gint i = 0;
	gboolean _tmp11_ = FALSE;
	BirdFontPath* _tmp16_;
	BirdFontPathList* _tmp17_;
	BirdFontPathList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	if (!bird_font_stroke_tool_has_intersection_points (self, path)) {
		bird_font_stroke_tool_add_self_intersection_points (self, path, FALSE);
	} else {
		g_warning ("StrokeTool.vala:1584: points already created.");
	}
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _p_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _p_index = 0;
		_tmp0_ = bird_font_path_get_points (path);
		_tmp1_ = _tmp0_;
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontEditPoint* p = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontEditPoint* _tmp9_;
			_p_index = _p_index + 1;
			_tmp5_ = _p_index;
			_tmp6_ = _p_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _p_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _p_index);
			p = (BirdFontEditPoint*) _tmp8_;
			_tmp9_ = p;
			if (bird_font_stroke_tool_insides (self, _tmp9_, path) == 1) {
				BirdFontEditPoint* _tmp10_;
				_tmp10_ = p;
				bird_font_path_set_new_start (path, _tmp10_);
				bird_font_path_close (path);
				_g_object_unref0 (p);
				break;
			}
			_g_object_unref0 (p);
		}
	}
	i = bird_font_stroke_tool_mark_intersection_as_deleted (self, path);
	if (i == 0) {
		_tmp11_ = TRUE;
	} else {
		_tmp11_ = i == 2;
	}
	if (!_tmp11_) {
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp12_ = g_strdup_printf ("%i", i);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat ("Split should only create two parts, ", _tmp13_, " points will be deleted.", NULL);
		_tmp15_ = _tmp14_;
		g_warning ("StrokeTool.vala:1598: %s", _tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
	}
	_tmp16_ = bird_font_path_copy (path);
	_g_object_unref0 (new_path);
	new_path = _tmp16_;
	_tmp17_ = bird_font_stroke_tool_get_remaining_points (self, new_path);
	_g_object_unref0 (pl);
	pl = _tmp17_;
	result = pl;
	_g_object_unref0 (new_path);
	return result;
}

static BirdFontPathList*
bird_font_stroke_tool_process_deleted_control_points (BirdFontStrokeTool* self,
                                                      BirdFontPath* path)
{
	BirdFontPathList* paths = NULL;
	BirdFontPathList* nl = NULL;
	BirdFontPathList* pl = NULL;
	BirdFontPathList* rl = NULL;
	BirdFontPathList* _result_ = NULL;
	BirdFontPathList* _tmp0_;
	BirdFontPathList* _tmp1_;
	BirdFontPathList* _tmp2_;
	BirdFontPathList* _tmp3_;
	BirdFontPathList* _tmp4_;
	BirdFontPathList* _tmp25_;
	BirdFontPathList* _tmp55_;
	BirdFontPathList* _tmp56_;
	BirdFontPathList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = bird_font_path_list_new ();
	_g_object_unref0 (paths);
	paths = _tmp0_;
	_tmp1_ = bird_font_path_list_new ();
	_g_object_unref0 (rl);
	rl = _tmp1_;
	_tmp2_ = bird_font_path_list_new ();
	_g_object_unref0 (pl);
	pl = _tmp2_;
	_tmp3_ = bird_font_path_list_new ();
	_g_object_unref0 (nl);
	nl = _tmp3_;
	if (!bird_font_path_has_deleted_point (path)) {
		result = pl;
		_g_object_unref0 (_result_);
		_g_object_unref0 (rl);
		_g_object_unref0 (nl);
		_g_object_unref0 (paths);
		return result;
	}
	_tmp4_ = pl;
	bird_font_path_list_add (_tmp4_, path);
	{
		GeeArrayList* _p_list = NULL;
		BirdFontPathList* _tmp5_;
		GeeArrayList* _tmp6_;
		gint _p_size = 0;
		GeeArrayList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _p_index = 0;
		_tmp5_ = pl;
		_tmp6_ = _tmp5_->paths;
		_p_list = _tmp6_;
		_tmp7_ = _p_list;
		_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_p_size = _tmp9_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp12_;
			gpointer _tmp13_;
			BirdFontPath* _tmp14_;
			BirdFontPathList* _tmp15_;
			BirdFontPathList* _tmp16_;
			GeeArrayList* _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			_p_index = _p_index + 1;
			_tmp10_ = _p_index;
			_tmp11_ = _p_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _p_list;
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _p_index);
			p = (BirdFontPath*) _tmp13_;
			_tmp14_ = p;
			_tmp15_ = bird_font_path_process_deleted_points (_tmp14_);
			_g_object_unref0 (nl);
			nl = _tmp15_;
			_tmp16_ = nl;
			_tmp17_ = _tmp16_->paths;
			_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
			_tmp19_ = _tmp18_;
			if (_tmp19_ > 0) {
				BirdFontPathList* _tmp20_;
				BirdFontPathList* _tmp21_;
				BirdFontPathList* _tmp22_;
				GeeArrayList* _tmp23_;
				BirdFontPath* _tmp24_;
				_tmp20_ = rl;
				_tmp21_ = nl;
				bird_font_path_list_append (_tmp20_, _tmp21_);
				_tmp22_ = rl;
				_tmp23_ = _tmp22_->paths;
				_tmp24_ = p;
				gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp23_, _tmp24_);
			}
			_g_object_unref0 (p);
		}
	}
	_tmp25_ = bird_font_path_list_new ();
	_g_object_unref0 (_result_);
	_result_ = _tmp25_;
	{
		GeeArrayList* _p_list = NULL;
		BirdFontPathList* _tmp26_;
		GeeArrayList* _tmp27_;
		gint _p_size = 0;
		GeeArrayList* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		gint _p_index = 0;
		_tmp26_ = rl;
		_tmp27_ = _tmp26_->paths;
		_p_list = _tmp27_;
		_tmp28_ = _p_list;
		_tmp29_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp28_);
		_tmp30_ = _tmp29_;
		_p_size = _tmp30_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp31_;
			gint _tmp32_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp33_;
			gpointer _tmp34_;
			BirdFontPath* _tmp35_;
			BirdFontPathList* _tmp36_;
			BirdFontPathList* _tmp37_;
			GeeArrayList* _tmp38_;
			gint _tmp39_;
			gint _tmp40_;
			_p_index = _p_index + 1;
			_tmp31_ = _p_index;
			_tmp32_ = _p_size;
			if (!(_tmp31_ < _tmp32_)) {
				break;
			}
			_tmp33_ = _p_list;
			_tmp34_ = gee_abstract_list_get ((GeeAbstractList*) _tmp33_, _p_index);
			p = (BirdFontPath*) _tmp34_;
			_tmp35_ = p;
			_tmp36_ = bird_font_stroke_tool_process_deleted_control_points (self, _tmp35_);
			_g_object_unref0 (pl);
			pl = _tmp36_;
			_tmp37_ = pl;
			_tmp38_ = _tmp37_->paths;
			_tmp39_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp38_);
			_tmp40_ = _tmp39_;
			if (_tmp40_ > 0) {
				BirdFontPathList* _tmp41_;
				BirdFontPathList* _tmp42_;
				_tmp41_ = _result_;
				_tmp42_ = pl;
				bird_font_path_list_append (_tmp41_, _tmp42_);
			} else {
				BirdFontPathList* _tmp43_;
				BirdFontPath* _tmp44_;
				_tmp43_ = _result_;
				_tmp44_ = p;
				bird_font_path_list_add (_tmp43_, _tmp44_);
			}
			_g_object_unref0 (p);
		}
	}
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp45_ = FALSE;
			_tmp45_ = TRUE;
			while (TRUE) {
				BirdFontPathList* _tmp47_;
				GeeArrayList* _tmp48_;
				gint _tmp49_;
				gint _tmp50_;
				BirdFontPathList* _tmp51_;
				GeeArrayList* _tmp52_;
				gpointer _tmp53_;
				BirdFontPath* _tmp54_;
				if (!_tmp45_) {
					gint _tmp46_;
					_tmp46_ = i;
					i = _tmp46_ + 1;
				}
				_tmp45_ = FALSE;
				_tmp47_ = _result_;
				_tmp48_ = _tmp47_->paths;
				_tmp49_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp48_);
				_tmp50_ = _tmp49_;
				if (!(i < _tmp50_)) {
					break;
				}
				_tmp51_ = _result_;
				_tmp52_ = _tmp51_->paths;
				_tmp53_ = gee_abstract_list_get ((GeeAbstractList*) _tmp52_, i);
				_tmp54_ = (BirdFontPath*) _tmp53_;
				bird_font_path_reverse (_tmp54_);
				_g_object_unref0 (_tmp54_);
			}
		}
	}
	_tmp55_ = paths;
	_tmp56_ = _result_;
	bird_font_path_list_append (_tmp55_, _tmp56_);
	result = paths;
	_g_object_unref0 (_result_);
	_g_object_unref0 (rl);
	_g_object_unref0 (pl);
	_g_object_unref0 (nl);
	return result;
}

static BirdFontPathList*
bird_font_stroke_tool_get_remaining_points (BirdFontStrokeTool* self,
                                            BirdFontPath* old_path)
{
	BirdFontPathList* pl = NULL;
	BirdFontPathList* _tmp0_;
	BirdFontPathList* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	BirdFontPathList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old_path != NULL, NULL);
	bird_font_path_close (old_path);
	_tmp0_ = bird_font_stroke_tool_process_deleted_control_points (self, old_path);
	_g_object_unref0 (pl);
	pl = _tmp0_;
	_tmp1_ = pl;
	_tmp2_ = _tmp1_->paths;
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		BirdFontPathList* _tmp5_;
		_tmp5_ = pl;
		bird_font_path_list_add (_tmp5_, old_path);
	}
	{
		GeeArrayList* _pn_list = NULL;
		BirdFontPathList* _tmp6_;
		GeeArrayList* _tmp7_;
		gint _pn_size = 0;
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _pn_index = 0;
		_tmp6_ = pl;
		_tmp7_ = _tmp6_->paths;
		_pn_list = _tmp7_;
		_tmp8_ = _pn_list;
		_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_pn_size = _tmp10_;
		_pn_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			BirdFontPath* pn = NULL;
			GeeArrayList* _tmp13_;
			gpointer _tmp14_;
			BirdFontPath* _tmp15_;
			_pn_index = _pn_index + 1;
			_tmp11_ = _pn_index;
			_tmp12_ = _pn_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _pn_list;
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, _pn_index);
			pn = (BirdFontPath*) _tmp14_;
			_tmp15_ = pn;
			bird_font_path_close (_tmp15_);
			_g_object_unref0 (pn);
		}
	}
	result = pl;
	return result;
}

static Block63Data*
block63_data_ref (Block63Data* _data63_)
{
	g_atomic_int_inc (&_data63_->_ref_count_);
	return _data63_;
}

static void
block63_data_unref (void * _userdata_)
{
	Block63Data* _data63_;
	_data63_ = (Block63Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data63_->_ref_count_)) {
		BirdFontStrokeTool* self;
		self = _data63_->self;
		_g_object_unref0 (_data63_->path);
		_g_object_unref0 (self);
		g_slice_free (Block63Data, _data63_);
	}
}

static gboolean
__lambda31_ (Block63Data* _data63_,
             BirdFontEditPoint* ep1,
             BirdFontEditPoint* ep2)
{
	BirdFontStrokeTool* self;
	gdouble ix = 0.0;
	gdouble iy = 0.0;
	BirdFontEditPoint* p1 = NULL;
	BirdFontEditPoint* p2 = NULL;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	BirdFontEditPoint* _tmp2_ = NULL;
	BirdFontEditPoint* _tmp3_ = NULL;
	gboolean _tmp4_;
	gboolean result;
	self = _data63_->self;
	g_return_val_if_fail (ep1 != NULL, FALSE);
	g_return_val_if_fail (ep2 != NULL, FALSE);
	_tmp4_ = bird_font_stroke_tool_segment_intersects (self, _data63_->path, ep1, ep2, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_, TRUE, FALSE);
	ix = _tmp0_;
	iy = _tmp1_;
	_g_object_unref0 (p1);
	p1 = _tmp2_;
	_g_object_unref0 (p2);
	p2 = _tmp3_;
	if (_tmp4_) {
		_data63_->intersection = TRUE;
		result = FALSE;
		_g_object_unref0 (p2);
		_g_object_unref0 (p1);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (p2);
	_g_object_unref0 (p1);
	return result;
}

static gboolean
___lambda31__bird_font_path_segment_iterator (BirdFontEditPoint* start,
                                              BirdFontEditPoint* stop,
                                              gpointer self)
{
	gboolean result;
	result = __lambda31_ (self, start, stop);
	return result;
}

static gboolean
bird_font_stroke_tool_has_self_intersection (BirdFontStrokeTool* self,
                                             BirdFontPath* path)
{
	Block63Data* _data63_;
	BirdFontPath* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_data63_ = g_slice_new0 (Block63Data);
	_data63_->_ref_count_ = 1;
	_data63_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (path);
	_g_object_unref0 (_data63_->path);
	_data63_->path = _tmp0_;
	_data63_->intersection = FALSE;
	bird_font_path_all_segments (_data63_->path, ___lambda31__bird_font_path_segment_iterator, _data63_);
	result = _data63_->intersection;
	block63_data_unref (_data63_);
	_data63_ = NULL;
	return result;
}

static Block64Data*
block64_data_ref (Block64Data* _data64_)
{
	g_atomic_int_inc (&_data64_->_ref_count_);
	return _data64_;
}

static void
block64_data_unref (void * _userdata_)
{
	Block64Data* _data64_;
	_data64_ = (Block64Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data64_->_ref_count_)) {
		BirdFontStrokeTool* self;
		self = _data64_->self;
		_g_object_unref0 (_data64_->path);
		_g_object_unref0 (self);
		g_slice_free (Block64Data, _data64_);
	}
}

static gboolean
__lambda32_ (Block64Data* _data64_,
             BirdFontEditPoint* ep1,
             BirdFontEditPoint* ep2)
{
	BirdFontStrokeTool* self;
	gdouble ix = 0.0;
	gdouble iy = 0.0;
	BirdFontEditPoint* p1 = NULL;
	BirdFontEditPoint* p2 = NULL;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	BirdFontEditPoint* _tmp2_ = NULL;
	BirdFontEditPoint* _tmp3_ = NULL;
	gboolean _tmp4_;
	gboolean result;
	self = _data64_->self;
	g_return_val_if_fail (ep1 != NULL, FALSE);
	g_return_val_if_fail (ep2 != NULL, FALSE);
	_tmp4_ = bird_font_stroke_tool_segment_intersects (self, _data64_->path, ep1, ep2, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_, TRUE, _data64_->only_offsets);
	ix = _tmp0_;
	iy = _tmp1_;
	_g_object_unref0 (p1);
	p1 = _tmp2_;
	_g_object_unref0 (p2);
	p2 = _tmp3_;
	if (_tmp4_) {
		BirdFontEditPoint* _tmp5_;
		BirdFontEditPoint* _tmp6_;
		BirdFontEditPoint* _tmp7_;
		BirdFontEditPoint* _tmp8_;
		BirdFontEditPoint* _tmp9_;
		BirdFontEditPoint* _tmp10_;
		_tmp5_ = bird_font_stroke_tool_add_intersection (self, _data64_->path, ep1, ep2, ix, iy, NULL);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp6_);
		_tmp7_ = p1;
		_tmp8_ = p2;
		_tmp9_ = bird_font_stroke_tool_add_intersection (self, _data64_->path, _tmp7_, _tmp8_, ix, iy, NULL);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp10_);
		_data64_->intersection = TRUE;
		result = FALSE;
		_g_object_unref0 (p2);
		_g_object_unref0 (p1);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (p2);
	_g_object_unref0 (p1);
	return result;
}

static gboolean
___lambda32__bird_font_path_segment_iterator (BirdFontEditPoint* start,
                                              BirdFontEditPoint* stop,
                                              gpointer self)
{
	gboolean result;
	result = __lambda32_ (self, start, stop);
	return result;
}

static gboolean
bird_font_stroke_tool_add_self_intersection_points (BirdFontStrokeTool* self,
                                                    BirdFontPath* path,
                                                    gboolean only_offsets)
{
	Block64Data* _data64_;
	BirdFontPath* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_data64_ = g_slice_new0 (Block64Data);
	_data64_->_ref_count_ = 1;
	_data64_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (path);
	_g_object_unref0 (_data64_->path);
	_data64_->path = _tmp0_;
	_data64_->only_offsets = only_offsets;
	_data64_->intersection = FALSE;
	bird_font_path_all_segments (_data64_->path, ___lambda32__bird_font_path_segment_iterator, _data64_);
	result = _data64_->intersection;
	block64_data_unref (_data64_);
	_data64_ = NULL;
	return result;
}

static gpointer
_bird_font_color_ref0 (gpointer self)
{
	return self ? bird_font_color_ref (self) : NULL;
}

static BirdFontEditPoint*
bird_font_stroke_tool_add_intersection (BirdFontStrokeTool* self,
                                        BirdFontPath* path,
                                        BirdFontEditPoint* prev,
                                        BirdFontEditPoint* next,
                                        gdouble px,
                                        gdouble py,
                                        BirdFontColor* c)
{
	GeeArrayList* n = NULL;
	GeeArrayList* _tmp0_;
	BirdFontEditPoint* ep1 = NULL;
	BirdFontEditPoint* _tmp1_;
	BirdFontEditPoint* ep2 = NULL;
	BirdFontEditPoint* _tmp2_;
	BirdFontEditPoint* ep3 = NULL;
	BirdFontEditPoint* _tmp3_;
	gdouble d = 0.0;
	BirdFontEditPoint* _tmp4_;
	BirdFontEditPoint* _tmp5_;
	gboolean _tmp6_;
	BirdFontEditPoint* _tmp9_;
	BirdFontEditPoint* _tmp10_;
	BirdFontEditPoint* _tmp11_;
	BirdFontEditPoint* _tmp12_;
	BirdFontEditPoint* _tmp13_;
	BirdFontEditPoint* _tmp14_;
	BirdFontEditPoint* _tmp15_;
	BirdFontEditPoint* _tmp16_;
	BirdFontEditPoint* _tmp17_;
	BirdFontColor* _tmp18_;
	GeeArrayList* _tmp19_;
	BirdFontEditPoint* _tmp20_;
	BirdFontEditPoint* _tmp21_;
	BirdFontEditPoint* _tmp22_;
	BirdFontEditPoint* _tmp23_;
	BirdFontEditPoint* _tmp24_;
	BirdFontEditPoint* _tmp25_;
	BirdFontEditPoint* _tmp26_;
	BirdFontEditPoint* _tmp27_;
	BirdFontEditPoint* _tmp28_;
	BirdFontEditPoint* _tmp29_;
	BirdFontEditPoint* _tmp30_;
	BirdFontColor* _tmp31_;
	GeeArrayList* _tmp32_;
	BirdFontEditPoint* _tmp33_;
	BirdFontEditPoint* _tmp34_;
	BirdFontEditPoint* _tmp35_;
	BirdFontEditPoint* _tmp36_;
	BirdFontEditPoint* _tmp37_;
	BirdFontEditPoint* _tmp38_;
	BirdFontEditPoint* _tmp39_;
	BirdFontEditPoint* _tmp40_;
	BirdFontEditPoint* _tmp41_;
	BirdFontEditPoint* _tmp42_;
	BirdFontColor* _tmp43_;
	GeeArrayList* _tmp44_;
	BirdFontEditPoint* _tmp45_;
	BirdFontEditPointHandle* _tmp46_;
	BirdFontEditPoint* _tmp59_;
	BirdFontEditPoint* _tmp60_;
	BirdFontEditPoint* _tmp61_;
	BirdFontEditPoint* _tmp62_;
	BirdFontEditPoint* _tmp63_;
	BirdFontEditPoint* _tmp64_;
	BirdFontEditPointHandle* _tmp65_;
	BirdFontEditPointHandle* _tmp66_;
	BirdFontEditPoint* _tmp67_;
	BirdFontEditPointHandle* _tmp68_;
	BirdFontEditPointHandle* _tmp69_;
	BirdFontEditPoint* _tmp70_;
	BirdFontEditPoint* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (prev != NULL, NULL);
	g_return_val_if_fail (next != NULL, NULL);
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_EDIT_POINT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	n = _tmp0_;
	_tmp1_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
	ep1 = _tmp1_;
	_tmp2_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
	ep2 = _tmp2_;
	_tmp3_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
	ep3 = _tmp3_;
	_tmp4_ = bird_font_path_get_first_point (path);
	_tmp5_ = _tmp4_;
	_tmp6_ = next == _tmp5_;
	_g_object_unref0 (_tmp5_);
	if (_tmp6_) {
		BirdFontEditPoint* _tmp7_;
		_tmp7_ = ep1;
		_tmp7_->prev = NULL;
	} else {
		BirdFontEditPoint* _tmp8_;
		_tmp8_ = ep1;
		_tmp8_->prev = prev;
	}
	_tmp9_ = ep1;
	_tmp9_->prev = prev;
	_tmp10_ = ep1;
	_tmp11_ = ep2;
	_tmp10_->next = _tmp11_;
	_tmp12_ = ep1;
	_tmp13_ = ep1;
	_tmp13_->flags = _tmp13_->flags | (BIRD_FONT_EDIT_POINT_NEW_CORNER | BIRD_FONT_EDIT_POINT_SPLIT_POINT);
	_tmp14_ = ep1;
	_tmp14_->type = prev->type;
	_tmp15_ = ep1;
	_tmp15_->x = px;
	_tmp16_ = ep1;
	_tmp16_->y = py;
	_tmp17_ = ep1;
	_tmp18_ = _bird_font_color_ref0 (c);
	_bird_font_color_unref0 (_tmp17_->color);
	_tmp17_->color = _tmp18_;
	_tmp19_ = n;
	_tmp20_ = ep1;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, _tmp20_);
	_tmp21_ = ep2;
	_tmp22_ = ep1;
	_tmp21_->prev = _tmp22_;
	_tmp23_ = ep2;
	_tmp24_ = ep3;
	_tmp23_->next = _tmp24_;
	_tmp25_ = ep2;
	_tmp26_ = ep2;
	_tmp26_->flags = _tmp26_->flags | (BIRD_FONT_EDIT_POINT_INTERSECTION | BIRD_FONT_EDIT_POINT_SPLIT_POINT);
	_tmp27_ = ep2;
	_tmp27_->type = prev->type;
	_tmp28_ = ep2;
	_tmp28_->x = px;
	_tmp29_ = ep2;
	_tmp29_->y = py;
	_tmp30_ = ep2;
	_tmp31_ = _bird_font_color_ref0 (c);
	_bird_font_color_unref0 (_tmp30_->color);
	_tmp30_->color = _tmp31_;
	_tmp32_ = n;
	_tmp33_ = ep2;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp32_, _tmp33_);
	_tmp34_ = ep3;
	_tmp35_ = ep2;
	_tmp34_->prev = _tmp35_;
	_tmp36_ = ep3;
	_tmp36_->next = next;
	_tmp37_ = ep3;
	_tmp38_ = ep3;
	_tmp38_->flags = _tmp38_->flags | (BIRD_FONT_EDIT_POINT_NEW_CORNER | BIRD_FONT_EDIT_POINT_SPLIT_POINT);
	_tmp39_ = ep3;
	_tmp39_->type = prev->type;
	_tmp40_ = ep3;
	_tmp40_->x = px;
	_tmp41_ = ep3;
	_tmp41_->y = py;
	_tmp42_ = ep3;
	_tmp43_ = _bird_font_color_ref0 (c);
	_bird_font_color_unref0 (_tmp42_->color);
	_tmp42_->color = _tmp43_;
	_tmp44_ = n;
	_tmp45_ = ep3;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp44_, _tmp45_);
	_tmp46_ = bird_font_edit_point_get_left_handle (next);
	bird_font_edit_point_handle_convert_to_line (_tmp46_);
	{
		GeeArrayList* _np_list = NULL;
		GeeArrayList* _tmp47_;
		gint _np_size = 0;
		GeeArrayList* _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
		gint _np_index = 0;
		_tmp47_ = n;
		_np_list = _tmp47_;
		_tmp48_ = _np_list;
		_tmp49_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp48_);
		_tmp50_ = _tmp49_;
		_np_size = _tmp50_;
		_np_index = -1;
		while (TRUE) {
			gint _tmp51_;
			gint _tmp52_;
			BirdFontEditPoint* np = NULL;
			GeeArrayList* _tmp53_;
			gpointer _tmp54_;
			BirdFontEditPoint* _tmp55_;
			BirdFontEditPoint* _tmp56_;
			BirdFontEditPoint* _tmp57_;
			BirdFontEditPoint* _tmp58_;
			_np_index = _np_index + 1;
			_tmp51_ = _np_index;
			_tmp52_ = _np_size;
			if (!(_tmp51_ < _tmp52_)) {
				break;
			}
			_tmp53_ = _np_list;
			_tmp54_ = gee_abstract_list_get ((GeeAbstractList*) _tmp53_, _np_index);
			np = (BirdFontEditPoint*) _tmp54_;
			_tmp55_ = np;
			_tmp56_ = np;
			_tmp57_ = _tmp56_->prev;
			_tmp58_ = bird_font_path_add_point_after (path, _tmp55_, _tmp57_);
			_g_object_unref0 (np);
			np = _tmp58_;
			bird_font_path_create_list (path);
			_g_object_unref0 (np);
		}
	}
	_tmp59_ = ep1;
	bird_font_pen_tool_convert_point_to_line (_tmp59_, TRUE);
	_tmp60_ = ep2;
	bird_font_pen_tool_convert_point_to_line (_tmp60_, TRUE);
	_tmp61_ = ep3;
	bird_font_pen_tool_convert_point_to_line (_tmp61_, TRUE);
	_tmp62_ = ep1;
	bird_font_path_recalculate_linear_handles_for_point (path, _tmp62_);
	_tmp63_ = ep2;
	bird_font_path_recalculate_linear_handles_for_point (path, _tmp63_);
	_tmp64_ = ep3;
	bird_font_path_recalculate_linear_handles_for_point (path, _tmp64_);
	d = bird_font_path_distance_to_point (prev, next);
	_tmp65_ = bird_font_edit_point_get_right_handle (prev);
	_tmp66_ = bird_font_edit_point_get_right_handle (prev);
	_tmp67_ = ep1;
	_tmp66_->length = _tmp66_->length * (bird_font_path_distance_to_point (prev, _tmp67_) / d);
	_tmp68_ = bird_font_edit_point_get_left_handle (next);
	_tmp69_ = bird_font_edit_point_get_left_handle (next);
	_tmp70_ = ep3;
	_tmp69_->length = _tmp69_->length * (bird_font_path_distance_to_point (_tmp70_, next) / d);
	bird_font_path_recalculate_linear_handles_for_point (path, next);
	result = ep2;
	_g_object_unref0 (ep3);
	_g_object_unref0 (ep1);
	_g_object_unref0 (n);
	return result;
}

static gboolean
bird_font_stroke_tool_segments_intersects (BirdFontStrokeTool* self,
                                           BirdFontEditPoint* p1,
                                           BirdFontEditPoint* p2,
                                           BirdFontEditPoint* ep,
                                           BirdFontEditPoint* next,
                                           gdouble* ix,
                                           gdouble* iy,
                                           gboolean skip_points_on_points)
{
	gdouble _vala_ix = 0.0;
	gdouble _vala_iy = 0.0;
	gdouble cross_x = 0.0;
	gdouble cross_y = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gboolean _tmp2_ = FALSE;
	gdouble _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (p1 != NULL, FALSE);
	g_return_val_if_fail (p2 != NULL, FALSE);
	g_return_val_if_fail (ep != NULL, FALSE);
	g_return_val_if_fail (next != NULL, FALSE);
	_vala_ix = (gdouble) 0;
	_vala_iy = (gdouble) 0;
	if (bird_font_stroke_tool_is_line (self, ep->x, ep->y, p1->x, p1->y, next->x, next->y, 0.01)) {
		_vala_ix = p1->x;
		_vala_iy = p1->y;
		result = TRUE;
		if (ix) {
			*ix = _vala_ix;
		}
		if (iy) {
			*iy = _vala_iy;
		}
		return result;
	}
	if (bird_font_stroke_tool_is_line (self, ep->x, ep->y, p2->x, p2->y, next->x, next->y, 0.01)) {
		_vala_ix = p2->x;
		_vala_iy = p2->y;
		result = TRUE;
		if (ix) {
			*ix = _vala_ix;
		}
		if (iy) {
			*iy = _vala_iy;
		}
		return result;
	}
	if (bird_font_stroke_tool_is_line (self, p1->x, p1->y, ep->x, ep->y, p2->x, p2->y, 0.01)) {
		_vala_ix = ep->x;
		_vala_iy = ep->y;
		result = TRUE;
		if (ix) {
			*ix = _vala_ix;
		}
		if (iy) {
			*iy = _vala_iy;
		}
		return result;
	}
	if (bird_font_stroke_tool_is_line (self, p1->x, p1->y, next->x, next->y, p2->x, p2->y, 0.01)) {
		_vala_ix = next->x;
		_vala_iy = next->y;
		result = TRUE;
		if (ix) {
			*ix = _vala_ix;
		}
		if (iy) {
			*iy = _vala_iy;
		}
		return result;
	}
	bird_font_path_find_intersection_point (ep, next, p1, p2, &_tmp0_, &_tmp1_);
	cross_x = _tmp0_;
	cross_y = _tmp1_;
	_tmp3_ = cross_x;
	if (((fmin (ep->x, next->x) - 0.00001) <= _tmp3_) && (_tmp3_ <= (fmax (ep->x, next->x) + 0.00001))) {
		gdouble _tmp4_;
		_tmp4_ = cross_y;
		_tmp2_ = ((fmin (ep->y, next->y) - 0.00001) <= _tmp4_) && (_tmp4_ <= (fmax (ep->y, next->y) + 0.00001));
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp5_ = FALSE;
		if (bird_font_stroke_tool_is_line (self, ep->x, ep->y, cross_x, cross_y, next->x, next->y, 0.01)) {
			_tmp5_ = bird_font_stroke_tool_is_line (self, p1->x, p1->y, cross_x, cross_y, p2->x, p2->y, 0.01);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			_vala_ix = cross_x;
			_vala_iy = cross_y;
			result = TRUE;
			if (ix) {
				*ix = _vala_ix;
			}
			if (iy) {
				*iy = _vala_iy;
			}
			return result;
		}
	}
	result = FALSE;
	if (ix) {
		*ix = _vala_ix;
	}
	if (iy) {
		*iy = _vala_iy;
	}
	return result;
}

static gboolean
bird_font_stroke_tool_segment_intersects (BirdFontStrokeTool* self,
                                          BirdFontPath* path,
                                          BirdFontEditPoint* ep,
                                          BirdFontEditPoint* next,
                                          gdouble* ix,
                                          gdouble* iy,
                                          BirdFontEditPoint** ia,
                                          BirdFontEditPoint** ib,
                                          gboolean skip_points_on_points,
                                          gboolean only_offsets)
{
	gdouble _vala_ix = 0.0;
	gdouble _vala_iy = 0.0;
	BirdFontEditPoint* _vala_ia = NULL;
	BirdFontEditPoint* _vala_ib = NULL;
	BirdFontEditPoint* p1 = NULL;
	BirdFontEditPoint* p2 = NULL;
	gboolean intersection = FALSE;
	gboolean inter = FALSE;
	gdouble iix = 0.0;
	gdouble iiy = 0.0;
	gdouble distance = 0.0;
	gdouble min_distance = 0.0;
	BirdFontEditPoint* _tmp0_;
	BirdFontEditPoint* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp8_;
	GeeArrayList* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gpointer _tmp12_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (ep != NULL, FALSE);
	g_return_val_if_fail (next != NULL, FALSE);
	intersection = FALSE;
	_vala_ix = (gdouble) 0;
	_vala_iy = (gdouble) 0;
	iix = (gdouble) 0;
	iiy = (gdouble) 0;
	_tmp0_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
	_g_object_unref0 (_vala_ia);
	_vala_ia = _tmp0_;
	_tmp1_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
	_g_object_unref0 (_vala_ib);
	_vala_ib = _tmp1_;
	_tmp2_ = bird_font_path_get_points (path);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == 0) {
		result = FALSE;
		_g_object_unref0 (p2);
		_g_object_unref0 (p1);
		if (ix) {
			*ix = _vala_ix;
		}
		if (iy) {
			*iy = _vala_iy;
		}
		if (ia) {
			*ia = _vala_ia;
		} else {
			_g_object_unref0 (_vala_ia);
		}
		if (ib) {
			*ib = _vala_ib;
		} else {
			_g_object_unref0 (_vala_ib);
		}
		return result;
	}
	min_distance = DBL_MAX;
	_tmp6_ = bird_font_path_get_points (path);
	_tmp7_ = _tmp6_;
	_tmp8_ = bird_font_path_get_points (path);
	_tmp9_ = _tmp8_;
	_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _tmp11_ - 1);
	_g_object_unref0 (p1);
	p1 = (BirdFontEditPoint*) _tmp12_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp13_ = FALSE;
			_tmp13_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp15_;
				GeeArrayList* _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				GeeArrayList* _tmp19_;
				GeeArrayList* _tmp20_;
				gpointer _tmp21_;
				gboolean _tmp22_ = FALSE;
				gboolean _tmp23_ = FALSE;
				gboolean _tmp24_ = FALSE;
				BirdFontEditPoint* _tmp25_;
				gboolean is_offset = FALSE;
				gboolean _tmp27_ = FALSE;
				BirdFontEditPoint* _tmp40_;
				BirdFontEditPoint* _tmp41_;
				if (!_tmp13_) {
					gint _tmp14_;
					_tmp14_ = i;
					i = _tmp14_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp15_ = bird_font_path_get_points (path);
				_tmp16_ = _tmp15_;
				_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
				_tmp18_ = _tmp17_;
				if (!(i < _tmp18_)) {
					break;
				}
				_tmp19_ = bird_font_path_get_points (path);
				_tmp20_ = _tmp19_;
				_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, i);
				_g_object_unref0 (p2);
				p2 = (BirdFontEditPoint*) _tmp21_;
				_tmp25_ = p1;
				if ((_tmp25_->flags & BIRD_FONT_EDIT_POINT_STROKE_OFFSET) > ((guint) 0)) {
					BirdFontEditPoint* _tmp26_;
					_tmp26_ = p2;
					_tmp24_ = (_tmp26_->flags & BIRD_FONT_EDIT_POINT_STROKE_OFFSET) > ((guint) 0);
				} else {
					_tmp24_ = FALSE;
				}
				if (_tmp24_) {
					_tmp23_ = (ep->flags & BIRD_FONT_EDIT_POINT_STROKE_OFFSET) > ((guint) 0);
				} else {
					_tmp23_ = FALSE;
				}
				if (_tmp23_) {
					_tmp22_ = (next->flags & BIRD_FONT_EDIT_POINT_STROKE_OFFSET) > ((guint) 0);
				} else {
					_tmp22_ = FALSE;
				}
				is_offset = _tmp22_;
				if (!only_offsets) {
					_tmp27_ = TRUE;
				} else {
					_tmp27_ = is_offset;
				}
				if (_tmp27_) {
					gboolean _tmp28_ = FALSE;
					BirdFontEditPoint* _tmp29_;
					_tmp29_ = p1;
					if (_tmp29_ != ep) {
						BirdFontEditPoint* _tmp30_;
						_tmp30_ = p2;
						_tmp28_ = _tmp30_ != next;
					} else {
						_tmp28_ = FALSE;
					}
					if (_tmp28_) {
						BirdFontEditPoint* _tmp31_;
						BirdFontEditPoint* _tmp32_;
						gdouble _tmp33_ = 0.0;
						gdouble _tmp34_ = 0.0;
						gboolean _tmp35_;
						_tmp31_ = p1;
						_tmp32_ = p2;
						_tmp35_ = bird_font_stroke_tool_segments_intersects (self, _tmp31_, _tmp32_, ep, next, &_tmp33_, &_tmp34_, skip_points_on_points);
						iix = _tmp33_;
						iiy = _tmp34_;
						inter = _tmp35_;
						if (inter) {
							distance = bird_font_path_distance (ep->x, iix, ep->y, iiy);
							if (distance < min_distance) {
								BirdFontEditPoint* _tmp36_;
								BirdFontEditPoint* _tmp37_;
								BirdFontEditPoint* _tmp38_;
								BirdFontEditPoint* _tmp39_;
								_tmp36_ = p1;
								_tmp37_ = _g_object_ref0 (_tmp36_);
								_g_object_unref0 (_vala_ia);
								_vala_ia = _tmp37_;
								_tmp38_ = p2;
								_tmp39_ = _g_object_ref0 (_tmp38_);
								_g_object_unref0 (_vala_ib);
								_vala_ib = _tmp39_;
								_vala_ix = iix;
								_vala_iy = iiy;
								intersection = TRUE;
								min_distance = distance;
							}
						}
					}
				}
				_tmp40_ = p2;
				_tmp41_ = _g_object_ref0 (_tmp40_);
				_g_object_unref0 (p1);
				p1 = _tmp41_;
			}
		}
	}
	result = intersection;
	_g_object_unref0 (p2);
	_g_object_unref0 (p1);
	if (ix) {
		*ix = _vala_ix;
	}
	if (iy) {
		*iy = _vala_iy;
	}
	if (ia) {
		*ia = _vala_ia;
	} else {
		_g_object_unref0 (_vala_ia);
	}
	if (ib) {
		*ib = _vala_ib;
	} else {
		_g_object_unref0 (_vala_ib);
	}
	return result;
}

/** @return true if p2 is on the line p1 to p3 */
static gboolean
bird_font_stroke_tool_is_line (BirdFontStrokeTool* self,
                               gdouble x1,
                               gdouble y1,
                               gdouble x2,
                               gdouble y2,
                               gdouble x3,
                               gdouble y3,
                               gdouble tolerance)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((fmin (x1, x3) - 0.00001) <= x2) {
		_tmp3_ = x2 <= (fmax (x1, x3) + 0.00001);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = (fmin (y1, y3) - 0.00001) <= y2;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = y2 <= (fmax (y1, y3) + 0.00001);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = bird_font_stroke_tool_is_flat (x1, y1, x2, y2, x3, y3, tolerance);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
bird_font_stroke_tool_is_flat (gdouble x1,
                               gdouble y1,
                               gdouble x2,
                               gdouble y2,
                               gdouble x3,
                               gdouble y3,
                               gdouble tolerance)
{
	gdouble ds = 0.0;
	gdouble d1 = 0.0;
	gdouble d2 = 0.0;
	gdouble p = 0.0;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble d = 0.0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean result;
	ds = bird_font_path_distance (x1, x3, y1, y3);
	d1 = bird_font_path_distance (x1, x2, y1, y2);
	d2 = bird_font_path_distance (x2, x3, y2, y3);
	p = d1 / ds;
	x = fabs (((x3 - x1) * p) - (x2 - x1)) / ds;
	y = fabs (((y3 - y1) * p) - (y2 - y1)) / ds;
	d = fabs (ds - (d1 + d2)) / ds;
	if (ds > 0.001) {
		_tmp4_ = d1 > 0.001;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = d2 > 0.001;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = d < tolerance;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = x < tolerance;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = y < tolerance;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
bird_font_stroke_tool_reset_intersections (BirdFontStrokeTool* self,
                                           BirdFontPath* p)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	{
		GeeArrayList* _ep_list = NULL;
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _ep_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _ep_index = 0;
		_tmp0_ = bird_font_path_get_points (p);
		_tmp1_ = _tmp0_;
		_ep_list = _tmp1_;
		_tmp2_ = _ep_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_ep_size = _tmp4_;
		_ep_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontEditPoint* ep = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontEditPoint* _tmp9_;
			BirdFontEditPoint* _tmp10_;
			BirdFontEditPoint* _tmp11_;
			BirdFontEditPoint* _tmp12_;
			BirdFontEditPoint* _tmp13_;
			BirdFontEditPoint* _tmp14_;
			BirdFontEditPoint* _tmp15_;
			_ep_index = _ep_index + 1;
			_tmp5_ = _ep_index;
			_tmp6_ = _ep_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _ep_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _ep_index);
			ep = (BirdFontEditPoint*) _tmp8_;
			_tmp9_ = ep;
			_tmp10_ = ep;
			_tmp10_->flags = _tmp10_->flags & (~BIRD_FONT_EDIT_POINT_INTERSECTION);
			_tmp11_ = ep;
			_tmp12_ = ep;
			_tmp12_->flags = _tmp12_->flags & (~BIRD_FONT_EDIT_POINT_COPIED);
			_tmp13_ = ep;
			_tmp14_ = ep;
			_tmp14_->flags = _tmp14_->flags & (~BIRD_FONT_EDIT_POINT_SELF_INTERSECTION);
			_tmp15_ = ep;
			bird_font_edit_point_set_deleted (_tmp15_, FALSE);
			_g_object_unref0 (ep);
		}
	}
	bird_font_path_remove_points_on_points (p, 0.00001);
}

static gboolean
bird_font_stroke_tool_is_inside_of_path (BirdFontStrokeTool* self,
                                         BirdFontPointSelection* ps,
                                         BirdFontPathList* pl,
                                         BirdFontPath** outline)
{
	BirdFontPath* _vala_outline = NULL;
	BirdFontPath* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ps != NULL, FALSE);
	g_return_val_if_fail (pl != NULL, FALSE);
	_tmp0_ = bird_font_path_new ();
	_g_object_unref0 (_vala_outline);
	_vala_outline = _tmp0_;
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp1_;
		gint _p_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _p_index = 0;
		_tmp1_ = pl->paths;
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontPath* _tmp9_;
			BirdFontPath* _tmp10_;
			_p_index = _p_index + 1;
			_tmp5_ = _p_index;
			_tmp6_ = _p_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _p_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _p_index);
			p = (BirdFontPath*) _tmp8_;
			_tmp9_ = p;
			_tmp10_ = ps->path;
			if (_tmp9_ != _tmp10_) {
				BirdFontEditPoint* _tmp11_;
				BirdFontPath* _tmp12_;
				_tmp11_ = ps->point;
				_tmp12_ = p;
				if (bird_font_stroke_tool_is_inside (_tmp11_, _tmp12_)) {
					BirdFontPath* _tmp13_;
					BirdFontPath* _tmp14_;
					_tmp13_ = p;
					_tmp14_ = _g_object_ref0 (_tmp13_);
					_g_object_unref0 (_vala_outline);
					_vala_outline = _tmp14_;
					result = TRUE;
					_g_object_unref0 (p);
					if (outline) {
						*outline = _vala_outline;
					} else {
						_g_object_unref0 (_vala_outline);
					}
					return result;
				}
			}
			_g_object_unref0 (p);
		}
	}
	result = FALSE;
	if (outline) {
		*outline = _vala_outline;
	} else {
		_g_object_unref0 (_vala_outline);
	}
	return result;
}

static BirdFontPathList*
bird_font_stroke_tool_get_all_parts (BirdFontStrokeTool* self,
                                     BirdFontPathList* pl)
{
	BirdFontPathList* m = NULL;
	gboolean intersects = FALSE;
	BirdFontPathList* r = NULL;
	BirdFontPathList* _tmp0_;
	BirdFontPathList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (pl != NULL, NULL);
	intersects = FALSE;
	_tmp0_ = bird_font_path_list_new ();
	r = _tmp0_;
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp1_;
		gint _p_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _p_index = 0;
		_tmp1_ = pl->paths;
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontPath* _tmp9_;
			_p_index = _p_index + 1;
			_tmp5_ = _p_index;
			_tmp6_ = _p_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _p_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _p_index);
			p = (BirdFontPath*) _tmp8_;
			_tmp9_ = p;
			if (bird_font_stroke_tool_has_self_intersection (self, _tmp9_)) {
				BirdFontPath* _tmp10_;
				BirdFontPathList* _tmp11_;
				BirdFontPathList* _tmp12_;
				BirdFontPathList* _tmp13_;
				_tmp10_ = p;
				_tmp11_ = bird_font_stroke_tool_get_parts (self, _tmp10_);
				_g_object_unref0 (m);
				m = _tmp11_;
				_tmp12_ = r;
				_tmp13_ = m;
				bird_font_path_list_append (_tmp12_, _tmp13_);
				intersects = TRUE;
			} else {
				BirdFontPathList* _tmp14_;
				BirdFontPath* _tmp15_;
				_tmp14_ = r;
				_tmp15_ = p;
				bird_font_path_list_add (_tmp14_, _tmp15_);
			}
			_g_object_unref0 (p);
		}
	}
	{
		GeeArrayList* _p_list = NULL;
		BirdFontPathList* _tmp16_;
		GeeArrayList* _tmp17_;
		gint _p_size = 0;
		GeeArrayList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _p_index = 0;
		_tmp16_ = r;
		_tmp17_ = _tmp16_->paths;
		_p_list = _tmp17_;
		_tmp18_ = _p_list;
		_tmp19_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_p_size = _tmp20_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp23_;
			gpointer _tmp24_;
			BirdFontPath* _tmp25_;
			BirdFontPath* _tmp26_;
			_p_index = _p_index + 1;
			_tmp21_ = _p_index;
			_tmp22_ = _p_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _p_list;
			_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, _p_index);
			p = (BirdFontPath*) _tmp24_;
			_tmp25_ = p;
			bird_font_path_close (_tmp25_);
			_tmp26_ = p;
			bird_font_path_update_region_boundaries (_tmp26_);
			_g_object_unref0 (p);
		}
	}
	if (intersects) {
		BirdFontPathList* _tmp27_;
		BirdFontPathList* _tmp28_;
		_tmp27_ = r;
		_tmp28_ = bird_font_stroke_tool_get_all_parts (self, _tmp27_);
		result = _tmp28_;
		_g_object_unref0 (r);
		_g_object_unref0 (m);
		return result;
	}
	result = r;
	_g_object_unref0 (m);
	return result;
}

static void
bird_font_stroke_tool_remove_single_points (BirdFontStrokeTool* self,
                                            BirdFontPathList* pl)
{
	BirdFontPathList* r = NULL;
	BirdFontPathList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pl != NULL);
	_tmp0_ = bird_font_path_list_new ();
	r = _tmp0_;
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp1_;
		gint _p_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _p_index = 0;
		_tmp1_ = pl->paths;
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontPath* _tmp9_;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			BirdFontPath* _tmp12_;
			GeeArrayList* _tmp13_;
			GeeArrayList* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			_p_index = _p_index + 1;
			_tmp5_ = _p_index;
			_tmp6_ = _p_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _p_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _p_index);
			p = (BirdFontPath*) _tmp8_;
			_tmp9_ = p;
			bird_font_path_update_region_boundaries (_tmp9_);
			_tmp12_ = p;
			_tmp13_ = bird_font_path_get_points (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
			_tmp16_ = _tmp15_;
			if (_tmp16_ < 10) {
				_tmp11_ = TRUE;
			} else {
				BirdFontPath* _tmp17_;
				BirdFontPath* _tmp18_;
				_tmp17_ = p;
				_tmp18_ = p;
				_tmp11_ = (_tmp17_->xmax - _tmp18_->xmin) < 0.01;
			}
			if (_tmp11_) {
				_tmp10_ = TRUE;
			} else {
				BirdFontPath* _tmp19_;
				BirdFontPath* _tmp20_;
				_tmp19_ = p;
				_tmp20_ = p;
				_tmp10_ = (_tmp19_->ymax - _tmp20_->ymin) < 0.01;
			}
			if (_tmp10_) {
				BirdFontPathList* _tmp21_;
				BirdFontPath* _tmp22_;
				_tmp21_ = r;
				_tmp22_ = p;
				bird_font_path_list_add (_tmp21_, _tmp22_);
			}
			_g_object_unref0 (p);
		}
	}
	{
		GeeArrayList* _p_list = NULL;
		BirdFontPathList* _tmp23_;
		GeeArrayList* _tmp24_;
		gint _p_size = 0;
		GeeArrayList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _p_index = 0;
		_tmp23_ = r;
		_tmp24_ = _tmp23_->paths;
		_p_list = _tmp24_;
		_tmp25_ = _p_list;
		_tmp26_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_p_size = _tmp27_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp30_;
			gpointer _tmp31_;
			BirdFontPath* _tmp32_;
			_p_index = _p_index + 1;
			_tmp28_ = _p_index;
			_tmp29_ = _p_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _p_list;
			_tmp31_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, _p_index);
			p = (BirdFontPath*) _tmp31_;
			_tmp32_ = p;
			bird_font_path_list_remove (pl, _tmp32_);
			_g_object_unref0 (p);
		}
	}
	_g_object_unref0 (r);
}

BirdFontPathList*
bird_font_stroke_tool_merge (BirdFontStrokeTool* self,
                             BirdFontPathList* pl)
{
	gboolean _error_ = FALSE;
	BirdFontPathList* m = NULL;
	BirdFontPathList* r = NULL;
	BirdFontPathList* _tmp0_;
	BirdFontPath* p1 = NULL;
	BirdFontPath* p2 = NULL;
	BirdFontPathList* _tmp1_;
	BirdFontPathList* _tmp2_;
	BirdFontPathList* _tmp3_;
	BirdFontStrokeTask* _tmp54_;
	BirdFontPathList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (pl != NULL, NULL);
	_error_ = FALSE;
	_tmp0_ = _g_object_ref0 (pl);
	r = _tmp0_;
	_tmp1_ = r;
	_tmp2_ = bird_font_stroke_tool_get_all_parts (self, _tmp1_);
	_g_object_unref0 (r);
	r = _tmp2_;
	_tmp3_ = r;
	bird_font_stroke_tool_remove_single_points (self, _tmp3_);
	while (TRUE) {
		BirdFontPathList* _tmp4_;
		BirdFontPath* _tmp5_ = NULL;
		BirdFontPath* _tmp6_ = NULL;
		gboolean _tmp7_;
		BirdFontStrokeTask* _tmp8_;
		BirdFontPath* _tmp10_;
		BirdFontPath* _tmp11_;
		BirdFontPathList* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_;
		_tmp4_ = r;
		_tmp7_ = bird_font_stroke_tool_paths_has_intersection (self, _tmp4_, &_tmp5_, &_tmp6_);
		_g_object_unref0 (p1);
		p1 = _tmp5_;
		_g_object_unref0 (p2);
		p2 = _tmp6_;
		if (!_tmp7_) {
			break;
		}
		_tmp8_ = self->priv->task;
		if (bird_font_task_is_cancelled ((BirdFontTask*) _tmp8_)) {
			BirdFontPathList* _tmp9_;
			_tmp9_ = bird_font_path_list_new ();
			result = _tmp9_;
			_g_object_unref0 (p2);
			_g_object_unref0 (p1);
			_g_object_unref0 (r);
			_g_object_unref0 (m);
			return result;
		}
		_tmp10_ = p1;
		_tmp11_ = p2;
		_tmp14_ = bird_font_stroke_tool_merge_path (self, _tmp10_, _tmp11_, &_tmp12_, &_tmp13_);
		_g_object_unref0 (m);
		m = _tmp12_;
		_error_ = _tmp13_;
		if (_tmp14_) {
			BirdFontPathList* _tmp15_;
			GeeArrayList* _tmp16_;
			BirdFontPath* _tmp17_;
			BirdFontPathList* _tmp18_;
			GeeArrayList* _tmp19_;
			BirdFontPath* _tmp20_;
			BirdFontStrokeTask* _tmp33_;
			BirdFontPathList* _tmp35_;
			BirdFontPathList* _tmp36_;
			BirdFontPathList* _tmp37_;
			BirdFontPathList* _tmp38_;
			BirdFontPath* _tmp39_ = NULL;
			BirdFontPath* _tmp40_ = NULL;
			gboolean _tmp41_;
			_tmp15_ = r;
			_tmp16_ = _tmp15_->paths;
			_tmp17_ = p1;
			gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp16_, _tmp17_);
			_tmp18_ = r;
			_tmp19_ = _tmp18_->paths;
			_tmp20_ = p2;
			gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp19_, _tmp20_);
			{
				GeeArrayList* _np_list = NULL;
				BirdFontPathList* _tmp21_;
				GeeArrayList* _tmp22_;
				gint _np_size = 0;
				GeeArrayList* _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				gint _np_index = 0;
				_tmp21_ = m;
				_tmp22_ = _tmp21_->paths;
				_np_list = _tmp22_;
				_tmp23_ = _np_list;
				_tmp24_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp23_);
				_tmp25_ = _tmp24_;
				_np_size = _tmp25_;
				_np_index = -1;
				while (TRUE) {
					gint _tmp26_;
					gint _tmp27_;
					BirdFontPath* np = NULL;
					GeeArrayList* _tmp28_;
					gpointer _tmp29_;
					BirdFontPath* _tmp30_;
					BirdFontPathList* _tmp31_;
					BirdFontPath* _tmp32_;
					_np_index = _np_index + 1;
					_tmp26_ = _np_index;
					_tmp27_ = _np_size;
					if (!(_tmp26_ < _tmp27_)) {
						break;
					}
					_tmp28_ = _np_list;
					_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, _np_index);
					np = (BirdFontPath*) _tmp29_;
					_tmp30_ = np;
					bird_font_path_remove_points_on_points (_tmp30_, 0.00001);
					_tmp31_ = r;
					_tmp32_ = np;
					bird_font_path_list_add (_tmp31_, _tmp32_);
					_g_object_unref0 (np);
				}
			}
			_tmp33_ = self->priv->task;
			if (bird_font_task_is_cancelled ((BirdFontTask*) _tmp33_)) {
				BirdFontPathList* _tmp34_;
				_tmp34_ = bird_font_path_list_new ();
				result = _tmp34_;
				_g_object_unref0 (p2);
				_g_object_unref0 (p1);
				_g_object_unref0 (r);
				_g_object_unref0 (m);
				return result;
			}
			_tmp35_ = r;
			_tmp36_ = bird_font_stroke_tool_get_all_parts (self, _tmp35_);
			_g_object_unref0 (r);
			r = _tmp36_;
			_tmp37_ = r;
			bird_font_stroke_tool_remove_single_points (self, _tmp37_);
			_tmp38_ = m;
			_tmp41_ = bird_font_stroke_tool_paths_has_intersection (self, _tmp38_, &_tmp39_, &_tmp40_);
			_g_object_unref0 (p1);
			p1 = _tmp39_;
			_g_object_unref0 (p2);
			p2 = _tmp40_;
			if (_tmp41_) {
				g_warning ("StrokeTool.vala:2156: Paths are not merged.");
				_error_ = TRUE;
			}
		} else {
			g_warning ("StrokeTool.vala:2160: Not merged.");
			_error_ = TRUE;
		}
		if (_error_) {
			g_warning ("StrokeTool.vala:2165: Merge error");
			break;
		}
	}
	if (!_error_) {
		BirdFontPathList* _tmp42_;
		_tmp42_ = r;
		bird_font_stroke_tool_remove_merged_parts (self, _tmp42_);
	}
	{
		GeeArrayList* _p_list = NULL;
		BirdFontPathList* _tmp43_;
		GeeArrayList* _tmp44_;
		gint _p_size = 0;
		GeeArrayList* _tmp45_;
		gint _tmp46_;
		gint _tmp47_;
		gint _p_index = 0;
		_tmp43_ = r;
		_tmp44_ = _tmp43_->paths;
		_p_list = _tmp44_;
		_tmp45_ = _p_list;
		_tmp46_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp45_);
		_tmp47_ = _tmp46_;
		_p_size = _tmp47_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp48_;
			gint _tmp49_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp50_;
			gpointer _tmp51_;
			BirdFontPath* _tmp52_;
			BirdFontPath* _tmp53_;
			_p_index = _p_index + 1;
			_tmp48_ = _p_index;
			_tmp49_ = _p_size;
			if (!(_tmp48_ < _tmp49_)) {
				break;
			}
			_tmp50_ = _p_list;
			_tmp51_ = gee_abstract_list_get ((GeeAbstractList*) _tmp50_, _p_index);
			p = (BirdFontPath*) _tmp51_;
			_tmp52_ = p;
			bird_font_path_close (_tmp52_);
			_tmp53_ = p;
			bird_font_path_recalculate_linear_handles (_tmp53_);
			_g_object_unref0 (p);
		}
	}
	_tmp54_ = self->priv->task;
	if (bird_font_task_is_cancelled ((BirdFontTask*) _tmp54_)) {
		BirdFontPathList* _tmp55_;
		_tmp55_ = bird_font_path_list_new ();
		result = _tmp55_;
		_g_object_unref0 (p2);
		_g_object_unref0 (p1);
		_g_object_unref0 (r);
		_g_object_unref0 (m);
		return result;
	}
	result = r;
	_g_object_unref0 (p2);
	_g_object_unref0 (p1);
	_g_object_unref0 (m);
	return result;
}

static void
bird_font_stroke_tool_remove_merged_parts (BirdFontStrokeTool* self,
                                           BirdFontPathList* r)
{
	GeeArrayList* remove = NULL;
	GeeArrayList* _tmp0_;
	gint c = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (r != NULL);
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_PATH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	remove = _tmp0_;
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp1_;
		gint _p_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _p_index = 0;
		_tmp1_ = r->paths;
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontPath* _tmp9_;
			_p_index = _p_index + 1;
			_tmp5_ = _p_index;
			_tmp6_ = _p_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _p_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _p_index);
			p = (BirdFontPath*) _tmp8_;
			_tmp9_ = p;
			bird_font_path_update_region_boundaries (_tmp9_);
			_g_object_unref0 (p);
		}
	}
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp10_;
		gint _p_size = 0;
		GeeArrayList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _p_index = 0;
		_tmp10_ = r->paths;
		_p_list = _tmp10_;
		_tmp11_ = _p_list;
		_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_p_size = _tmp13_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp16_;
			gpointer _tmp17_;
			BirdFontPath* _tmp18_;
			_p_index = _p_index + 1;
			_tmp14_ = _p_index;
			_tmp15_ = _p_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _p_list;
			_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _p_index);
			p = (BirdFontPath*) _tmp17_;
			_tmp18_ = p;
			c = bird_font_stroke_tool_counters (self, r, _tmp18_);
			if ((c % 2) == 0) {
				BirdFontPath* _tmp19_;
				_tmp19_ = p;
				if (!bird_font_path_is_clockwise (_tmp19_)) {
					GeeArrayList* _tmp20_;
					BirdFontPath* _tmp21_;
					_tmp20_ = remove;
					_tmp21_ = p;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, _tmp21_);
				}
			} else {
				BirdFontPath* _tmp22_;
				_tmp22_ = p;
				if (bird_font_path_is_clockwise (_tmp22_)) {
					GeeArrayList* _tmp23_;
					BirdFontPath* _tmp24_;
					_tmp23_ = remove;
					_tmp24_ = p;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, _tmp24_);
				}
			}
			_g_object_unref0 (p);
		}
	}
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp25_;
		gint _p_size = 0;
		GeeArrayList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gint _p_index = 0;
		_tmp25_ = remove;
		_p_list = _tmp25_;
		_tmp26_ = _p_list;
		_tmp27_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp26_);
		_tmp28_ = _tmp27_;
		_p_size = _tmp28_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp29_;
			gint _tmp30_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp31_;
			gpointer _tmp32_;
			GeeArrayList* _tmp33_;
			BirdFontPath* _tmp34_;
			_p_index = _p_index + 1;
			_tmp29_ = _p_index;
			_tmp30_ = _p_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _p_list;
			_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, _p_index);
			p = (BirdFontPath*) _tmp32_;
			_tmp33_ = r->paths;
			_tmp34_ = p;
			gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp33_, _tmp34_);
			_g_object_unref0 (p);
		}
	}
	_g_object_unref0 (remove);
}

BirdFontPathList*
bird_font_stroke_tool_get_insides (BirdFontStrokeTool* self,
                                   BirdFontPathList* pl,
                                   BirdFontPath* path)
{
	gboolean inside = FALSE;
	BirdFontPathList* insides = NULL;
	BirdFontPathList* _tmp0_;
	BirdFontPathList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (pl != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	inside = FALSE;
	_tmp0_ = bird_font_path_list_new ();
	insides = _tmp0_;
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp1_;
		gint _p_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _p_index = 0;
		_tmp1_ = pl->paths;
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_ = FALSE;
			BirdFontPath* _tmp11_;
			GeeArrayList* _tmp12_;
			GeeArrayList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			_p_index = _p_index + 1;
			_tmp5_ = _p_index;
			_tmp6_ = _p_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _p_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _p_index);
			p = (BirdFontPath*) _tmp8_;
			_tmp11_ = p;
			_tmp12_ = bird_font_path_get_points (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			if (_tmp15_ > 1) {
				BirdFontPath* _tmp16_;
				_tmp16_ = p;
				_tmp10_ = _tmp16_ != path;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				BirdFontPath* _tmp17_;
				_tmp17_ = p;
				_tmp9_ = bird_font_path_boundaries_intersecting (path, _tmp17_);
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				inside = TRUE;
				{
					GeeArrayList* _ep_list = NULL;
					GeeArrayList* _tmp18_;
					GeeArrayList* _tmp19_;
					gint _ep_size = 0;
					GeeArrayList* _tmp20_;
					gint _tmp21_;
					gint _tmp22_;
					gint _ep_index = 0;
					_tmp18_ = bird_font_path_get_points (path);
					_tmp19_ = _tmp18_;
					_ep_list = _tmp19_;
					_tmp20_ = _ep_list;
					_tmp21_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp20_);
					_tmp22_ = _tmp21_;
					_ep_size = _tmp22_;
					_ep_index = -1;
					while (TRUE) {
						gint _tmp23_;
						gint _tmp24_;
						BirdFontEditPoint* ep = NULL;
						GeeArrayList* _tmp25_;
						gpointer _tmp26_;
						BirdFontEditPoint* _tmp27_;
						BirdFontPath* _tmp28_;
						_ep_index = _ep_index + 1;
						_tmp23_ = _ep_index;
						_tmp24_ = _ep_size;
						if (!(_tmp23_ < _tmp24_)) {
							break;
						}
						_tmp25_ = _ep_list;
						_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, _ep_index);
						ep = (BirdFontEditPoint*) _tmp26_;
						_tmp27_ = ep;
						_tmp28_ = p;
						if (!bird_font_stroke_tool_is_inside (_tmp27_, _tmp28_)) {
							inside = FALSE;
							_g_object_unref0 (ep);
							break;
						}
						_g_object_unref0 (ep);
					}
				}
				if (inside) {
					BirdFontPathList* _tmp29_;
					BirdFontPath* _tmp30_;
					_tmp29_ = insides;
					_tmp30_ = p;
					bird_font_path_list_add (_tmp29_, _tmp30_);
				}
			}
			_g_object_unref0 (p);
		}
	}
	result = insides;
	return result;
}

gint
bird_font_stroke_tool_counters (BirdFontStrokeTool* self,
                                BirdFontPathList* pl,
                                BirdFontPath* path)
{
	gint inside_count = 0;
	gboolean inside = FALSE;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (pl != NULL, 0);
	g_return_val_if_fail (path != NULL, 0);
	inside_count = 0;
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp0_;
		gint _p_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p_index = 0;
		_tmp0_ = pl->paths;
		_p_list = _tmp0_;
		_tmp1_ = _p_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p_size = _tmp3_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_ = FALSE;
			BirdFontPath* _tmp10_;
			GeeArrayList* _tmp11_;
			GeeArrayList* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			_p_index = _p_index + 1;
			_tmp4_ = _p_index;
			_tmp5_ = _p_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _p_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _p_index);
			p = (BirdFontPath*) _tmp7_;
			inside = TRUE;
			_tmp10_ = p;
			_tmp11_ = bird_font_path_get_points (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_ > 1) {
				BirdFontPath* _tmp15_;
				_tmp15_ = p;
				_tmp9_ = _tmp15_ != path;
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				BirdFontPath* _tmp16_;
				_tmp16_ = p;
				_tmp8_ = bird_font_path_boundaries_intersecting (path, _tmp16_);
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				{
					GeeArrayList* _ep_list = NULL;
					GeeArrayList* _tmp17_;
					GeeArrayList* _tmp18_;
					gint _ep_size = 0;
					GeeArrayList* _tmp19_;
					gint _tmp20_;
					gint _tmp21_;
					gint _ep_index = 0;
					_tmp17_ = bird_font_path_get_points (path);
					_tmp18_ = _tmp17_;
					_ep_list = _tmp18_;
					_tmp19_ = _ep_list;
					_tmp20_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp19_);
					_tmp21_ = _tmp20_;
					_ep_size = _tmp21_;
					_ep_index = -1;
					while (TRUE) {
						gint _tmp22_;
						gint _tmp23_;
						BirdFontEditPoint* ep = NULL;
						GeeArrayList* _tmp24_;
						gpointer _tmp25_;
						BirdFontEditPoint* _tmp26_;
						BirdFontPath* _tmp27_;
						_ep_index = _ep_index + 1;
						_tmp22_ = _ep_index;
						_tmp23_ = _ep_size;
						if (!(_tmp22_ < _tmp23_)) {
							break;
						}
						_tmp24_ = _ep_list;
						_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp24_, _ep_index);
						ep = (BirdFontEditPoint*) _tmp25_;
						_tmp26_ = ep;
						_tmp27_ = p;
						if (!bird_font_stroke_tool_is_inside (_tmp26_, _tmp27_)) {
							inside = FALSE;
							_g_object_unref0 (ep);
							break;
						}
						_g_object_unref0 (ep);
					}
				}
				if (inside) {
					gint _tmp28_;
					_tmp28_ = inside_count;
					inside_count = _tmp28_ + 1;
				}
			}
			_g_object_unref0 (p);
		}
	}
	result = inside_count;
	return result;
}

gboolean
bird_font_stroke_tool_is_inside (BirdFontEditPoint* point,
                                 BirdFontPath* path)
{
	BirdFontEditPoint* prev = NULL;
	gboolean inside = FALSE;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gpointer _tmp10_;
	gboolean result;
	g_return_val_if_fail (point != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	inside = FALSE;
	_tmp0_ = bird_font_path_get_points (path);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ <= 1) {
		result = FALSE;
		_g_object_unref0 (prev);
		return result;
	}
	_tmp4_ = bird_font_path_get_points (path);
	_tmp5_ = _tmp4_;
	_tmp6_ = bird_font_path_get_points (path);
	_tmp7_ = _tmp6_;
	_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _tmp9_ - 1);
	_g_object_unref0 (prev);
	prev = (BirdFontEditPoint*) _tmp10_;
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp11_;
		GeeArrayList* _tmp12_;
		gint _p_size = 0;
		GeeArrayList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _p_index = 0;
		_tmp11_ = bird_font_path_get_points (path);
		_tmp12_ = _tmp11_;
		_p_list = _tmp12_;
		_tmp13_ = _p_list;
		_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_p_size = _tmp15_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			BirdFontEditPoint* p = NULL;
			GeeArrayList* _tmp18_;
			gpointer _tmp19_;
			gboolean _tmp20_ = FALSE;
			gboolean _tmp21_ = FALSE;
			BirdFontEditPoint* _tmp22_;
			BirdFontEditPoint* _tmp36_;
			BirdFontEditPoint* _tmp37_;
			_p_index = _p_index + 1;
			_tmp16_ = _p_index;
			_tmp17_ = _p_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _p_list;
			_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _p_index);
			p = (BirdFontEditPoint*) _tmp19_;
			_tmp22_ = p;
			if (fabs (_tmp22_->x - point->x) < 0.1) {
				BirdFontEditPoint* _tmp23_;
				_tmp23_ = p;
				_tmp21_ = fabs (_tmp23_->y - point->y) < 0.1;
			} else {
				_tmp21_ = FALSE;
			}
			if (_tmp21_) {
				_tmp20_ = TRUE;
			} else {
				gboolean _tmp24_ = FALSE;
				BirdFontEditPoint* _tmp25_;
				_tmp25_ = prev;
				if (fabs (_tmp25_->x - point->x) < 0.1) {
					BirdFontEditPoint* _tmp26_;
					_tmp26_ = prev;
					_tmp24_ = fabs (_tmp26_->y - point->y) < 0.1;
				} else {
					_tmp24_ = FALSE;
				}
				_tmp20_ = _tmp24_;
			}
			if (_tmp20_) {
				result = TRUE;
				_g_object_unref0 (p);
				_g_object_unref0 (prev);
				return result;
			} else {
				gboolean _tmp27_ = FALSE;
				BirdFontEditPoint* _tmp28_;
				BirdFontEditPoint* _tmp29_;
				_tmp28_ = p;
				_tmp29_ = prev;
				if ((_tmp28_->y > point->y) != (_tmp29_->y > point->y)) {
					BirdFontEditPoint* _tmp30_;
					BirdFontEditPoint* _tmp31_;
					BirdFontEditPoint* _tmp32_;
					BirdFontEditPoint* _tmp33_;
					BirdFontEditPoint* _tmp34_;
					BirdFontEditPoint* _tmp35_;
					_tmp30_ = prev;
					_tmp31_ = p;
					_tmp32_ = p;
					_tmp33_ = prev;
					_tmp34_ = p;
					_tmp35_ = p;
					_tmp27_ = point->x < ((((_tmp30_->x - _tmp31_->x) * (point->y - _tmp32_->y)) / (_tmp33_->y - _tmp34_->y)) + _tmp35_->x);
				} else {
					_tmp27_ = FALSE;
				}
				if (_tmp27_) {
					inside = !inside;
				}
			}
			_tmp36_ = p;
			_tmp37_ = _g_object_ref0 (_tmp36_);
			_g_object_unref0 (prev);
			prev = _tmp37_;
			_g_object_unref0 (p);
		}
	}
	result = inside;
	_g_object_unref0 (prev);
	return result;
}

gint
bird_font_stroke_tool_insides (BirdFontStrokeTool* self,
                               BirdFontEditPoint* point,
                               BirdFontPath* path)
{
	BirdFontEditPoint* prev = NULL;
	gint inside = 0;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	BirdFontEditPoint* _tmp4_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (point != NULL, 0);
	g_return_val_if_fail (path != NULL, 0);
	inside = 0;
	_tmp0_ = bird_font_path_get_points (path);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ <= 1) {
		result = 0;
		_g_object_unref0 (prev);
		return result;
	}
	_tmp4_ = bird_font_path_get_last_point (path);
	_g_object_unref0 (prev);
	prev = _tmp4_;
	{
		GeeArrayList* _start_list = NULL;
		GeeArrayList* _tmp5_;
		GeeArrayList* _tmp6_;
		gint _start_size = 0;
		GeeArrayList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _start_index = 0;
		_tmp5_ = bird_font_path_get_points (path);
		_tmp6_ = _tmp5_;
		_start_list = _tmp6_;
		_tmp7_ = _start_list;
		_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_start_size = _tmp9_;
		_start_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			BirdFontEditPoint* start = NULL;
			GeeArrayList* _tmp12_;
			gpointer _tmp13_;
			gboolean _tmp14_ = FALSE;
			BirdFontEditPoint* _tmp15_;
			BirdFontEditPoint* _tmp28_;
			BirdFontEditPoint* _tmp29_;
			_start_index = _start_index + 1;
			_tmp10_ = _start_index;
			_tmp11_ = _start_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _start_list;
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _start_index);
			start = (BirdFontEditPoint*) _tmp13_;
			_tmp15_ = start;
			if (_tmp15_->x == point->x) {
				BirdFontEditPoint* _tmp16_;
				_tmp16_ = start;
				_tmp14_ = point->y == _tmp16_->y;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				gint _tmp17_;
				_tmp17_ = inside;
				inside = _tmp17_ + 1;
			} else {
				gboolean _tmp18_ = FALSE;
				BirdFontEditPoint* _tmp19_;
				BirdFontEditPoint* _tmp20_;
				_tmp19_ = start;
				_tmp20_ = prev;
				if ((_tmp19_->y > point->y) != (_tmp20_->y > point->y)) {
					BirdFontEditPoint* _tmp21_;
					BirdFontEditPoint* _tmp22_;
					BirdFontEditPoint* _tmp23_;
					BirdFontEditPoint* _tmp24_;
					BirdFontEditPoint* _tmp25_;
					BirdFontEditPoint* _tmp26_;
					_tmp21_ = prev;
					_tmp22_ = start;
					_tmp23_ = start;
					_tmp24_ = prev;
					_tmp25_ = start;
					_tmp26_ = start;
					_tmp18_ = point->x < ((((_tmp21_->x - _tmp22_->x) * (point->y - _tmp23_->y)) / (_tmp24_->y - _tmp25_->y)) + _tmp26_->x);
				} else {
					_tmp18_ = FALSE;
				}
				if (_tmp18_) {
					gint _tmp27_;
					_tmp27_ = inside;
					inside = _tmp27_ + 1;
				}
			}
			_tmp28_ = start;
			_tmp29_ = _g_object_ref0 (_tmp28_);
			_g_object_unref0 (prev);
			prev = _tmp29_;
			_g_object_unref0 (start);
		}
	}
	result = inside;
	_g_object_unref0 (prev);
	return result;
}

static gboolean
bird_font_stroke_tool_merge_path (BirdFontStrokeTool* self,
                                  BirdFontPath* path1,
                                  BirdFontPath* path2,
                                  BirdFontPathList** merged_paths,
                                  gboolean* _error_)
{
	BirdFontPathList* _vala_merged_paths = NULL;
	gboolean _vala__error_ = FALSE;
	BirdFontIntersectionList* intersections = NULL;
	BirdFontEditPoint* ep1 = NULL;
	BirdFontEditPoint* next = NULL;
	BirdFontEditPoint* p1 = NULL;
	BirdFontEditPoint* p2 = NULL;
	BirdFontEditPoint* pp1 = NULL;
	BirdFontEditPoint* pp2 = NULL;
	BirdFontPath* path = NULL;
	BirdFontPath* other = NULL;
	BirdFontPath* merged = NULL;
	BirdFontPathList* r = NULL;
	BirdFontPathList* other_paths = NULL;
	BirdFontPathList* _result_ = NULL;
	gboolean intersects = FALSE;
	gint s = 0;
	gint i = 0;
	gdouble ix = 0.0;
	gdouble iy = 0.0;
	gdouble iix = 0.0;
	gdouble iiy = 0.0;
	gboolean merge = FALSE;
	BirdFontEditPoint* intersection_point = NULL;
	BirdFontEditPoint* other_intersection_point = NULL;
	gboolean path1_direction = FALSE;
	gboolean path2_direction = FALSE;
	BirdFontPathList* _tmp0_;
	BirdFontIntersectionList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	BirdFontPathList* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GeeArrayList* _tmp12_;
	GeeArrayList* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	BirdFontPath* original_path1 = NULL;
	BirdFontPath* _tmp20_;
	BirdFontPath* original_path2 = NULL;
	BirdFontPath* _tmp21_;
	GeeArrayList* _tmp38_;
	GeeArrayList* _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	BirdFontPath* _tmp61_;
	GeeArrayList* _tmp62_;
	GeeArrayList* _tmp63_;
	gint _tmp64_;
	gint _tmp65_;
	BirdFontPath* _tmp66_;
	BirdFontPath* _tmp67_;
	BirdFontPath* _tmp68_;
	BirdFontPath* _tmp69_;
	BirdFontPathList* _tmp70_;
	BirdFontPathList* _tmp71_;
	BirdFontPathList* _tmp72_;
	BirdFontPath* _tmp73_;
	BirdFontPathList* _tmp74_;
	BirdFontPath* _tmp75_;
	BirdFontEditPoint* _tmp76_;
	BirdFontEditPoint* _tmp77_;
	BirdFontEditPoint* _tmp78_;
	BirdFontEditPoint* _tmp79_;
	BirdFontPath* _tmp80_;
	BirdFontPath* _tmp81_;
	BirdFontPath* _tmp82_;
	gboolean _tmp402_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path1 != NULL, FALSE);
	g_return_val_if_fail (path2 != NULL, FALSE);
	merge = FALSE;
	_vala__error_ = FALSE;
	_tmp0_ = bird_font_path_list_new ();
	_g_object_unref0 (_vala_merged_paths);
	_vala_merged_paths = _tmp0_;
	_tmp1_ = bird_font_intersection_list_new ();
	_g_object_unref0 (intersections);
	intersections = _tmp1_;
	_tmp2_ = bird_font_path_get_points (path1);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == 0) {
		result = FALSE;
		_g_object_unref0 (other_intersection_point);
		_g_object_unref0 (intersection_point);
		_g_object_unref0 (_result_);
		_g_object_unref0 (other_paths);
		_g_object_unref0 (r);
		_g_object_unref0 (merged);
		_g_object_unref0 (other);
		_g_object_unref0 (path);
		_g_object_unref0 (pp2);
		_g_object_unref0 (pp1);
		_g_object_unref0 (p2);
		_g_object_unref0 (p1);
		_g_object_unref0 (next);
		_g_object_unref0 (ep1);
		_g_object_unref0 (intersections);
		if (merged_paths) {
			*merged_paths = _vala_merged_paths;
		} else {
			_g_object_unref0 (_vala_merged_paths);
		}
		if (_error_) {
			*_error_ = _vala__error_;
		}
		return result;
	}
	_tmp6_ = bird_font_path_get_points (path2);
	_tmp7_ = _tmp6_;
	_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == 0) {
		result = FALSE;
		_g_object_unref0 (other_intersection_point);
		_g_object_unref0 (intersection_point);
		_g_object_unref0 (_result_);
		_g_object_unref0 (other_paths);
		_g_object_unref0 (r);
		_g_object_unref0 (merged);
		_g_object_unref0 (other);
		_g_object_unref0 (path);
		_g_object_unref0 (pp2);
		_g_object_unref0 (pp1);
		_g_object_unref0 (p2);
		_g_object_unref0 (p1);
		_g_object_unref0 (next);
		_g_object_unref0 (ep1);
		_g_object_unref0 (intersections);
		if (merged_paths) {
			*merged_paths = _vala_merged_paths;
		} else {
			_g_object_unref0 (_vala_merged_paths);
		}
		if (_error_) {
			*_error_ = _vala__error_;
		}
		return result;
	}
	bird_font_stroke_tool_reset_intersections (self, path1);
	bird_font_stroke_tool_reset_intersections (self, path2);
	iix = (gdouble) 0;
	iiy = (gdouble) 0;
	_tmp10_ = bird_font_path_list_new ();
	_g_object_unref0 (_result_);
	_result_ = _tmp10_;
	_tmp12_ = bird_font_path_get_points (path1);
	_tmp13_ = _tmp12_;
	_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_ == 0) {
		_tmp11_ = TRUE;
	} else {
		GeeArrayList* _tmp16_;
		GeeArrayList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		_tmp16_ = bird_font_path_get_points (path2);
		_tmp17_ = _tmp16_;
		_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp11_ = _tmp19_ == 0;
	}
	if (_tmp11_) {
		g_warning ("StrokeTool.vala:2348: No points in path.");
		_vala__error_ = TRUE;
		result = FALSE;
		_g_object_unref0 (other_intersection_point);
		_g_object_unref0 (intersection_point);
		_g_object_unref0 (_result_);
		_g_object_unref0 (other_paths);
		_g_object_unref0 (r);
		_g_object_unref0 (merged);
		_g_object_unref0 (other);
		_g_object_unref0 (path);
		_g_object_unref0 (pp2);
		_g_object_unref0 (pp1);
		_g_object_unref0 (p2);
		_g_object_unref0 (p1);
		_g_object_unref0 (next);
		_g_object_unref0 (ep1);
		_g_object_unref0 (intersections);
		if (merged_paths) {
			*merged_paths = _vala_merged_paths;
		} else {
			_g_object_unref0 (_vala_merged_paths);
		}
		if (_error_) {
			*_error_ = _vala__error_;
		}
		return result;
	}
	if (!bird_font_path_boundaries_intersecting (path1, path2)) {
		result = FALSE;
		_g_object_unref0 (other_intersection_point);
		_g_object_unref0 (intersection_point);
		_g_object_unref0 (_result_);
		_g_object_unref0 (other_paths);
		_g_object_unref0 (r);
		_g_object_unref0 (merged);
		_g_object_unref0 (other);
		_g_object_unref0 (path);
		_g_object_unref0 (pp2);
		_g_object_unref0 (pp1);
		_g_object_unref0 (p2);
		_g_object_unref0 (p1);
		_g_object_unref0 (next);
		_g_object_unref0 (ep1);
		_g_object_unref0 (intersections);
		if (merged_paths) {
			*merged_paths = _vala_merged_paths;
		} else {
			_g_object_unref0 (_vala_merged_paths);
		}
		if (_error_) {
			*_error_ = _vala__error_;
		}
		return result;
	}
	_tmp20_ = bird_font_path_copy (path1);
	original_path1 = _tmp20_;
	_tmp21_ = bird_font_path_copy (path2);
	original_path2 = _tmp21_;
	s = 0;
	{
		GeeArrayList* _e_list = NULL;
		BirdFontPath* _tmp22_;
		GeeArrayList* _tmp23_;
		GeeArrayList* _tmp24_;
		gint _e_size = 0;
		GeeArrayList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _e_index = 0;
		_tmp22_ = original_path1;
		_tmp23_ = bird_font_path_get_points (_tmp22_);
		_tmp24_ = _tmp23_;
		_e_list = _tmp24_;
		_tmp25_ = _e_list;
		_tmp26_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_e_size = _tmp27_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			BirdFontEditPoint* e = NULL;
			GeeArrayList* _tmp30_;
			gpointer _tmp31_;
			gboolean _tmp32_ = FALSE;
			BirdFontEditPoint* _tmp33_;
			BirdFontPath* _tmp34_;
			gint _tmp37_;
			_e_index = _e_index + 1;
			_tmp28_ = _e_index;
			_tmp29_ = _e_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _e_list;
			_tmp31_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, _e_index);
			e = (BirdFontEditPoint*) _tmp31_;
			_tmp33_ = e;
			_tmp34_ = original_path2;
			if (!bird_font_stroke_tool_is_inside (_tmp33_, _tmp34_)) {
				BirdFontEditPoint* _tmp35_;
				BirdFontPath* _tmp36_;
				_tmp35_ = e;
				_tmp36_ = original_path1;
				_tmp32_ = bird_font_stroke_tool_insides (self, _tmp35_, _tmp36_) == 1;
			} else {
				_tmp32_ = FALSE;
			}
			if (_tmp32_) {
				_g_object_unref0 (e);
				break;
			}
			_tmp37_ = s;
			s = _tmp37_ + 1;
			_g_object_unref0 (e);
		}
	}
	_tmp38_ = bird_font_path_get_points (path1);
	_tmp39_ = _tmp38_;
	_tmp40_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp39_);
	_tmp41_ = _tmp40_;
	if (s >= _tmp41_) {
		BirdFontPath* t = NULL;
		BirdFontPath* _tmp42_;
		BirdFontPath* _tmp43_;
		BirdFontPath* _tmp44_;
		BirdFontPath* _tmp45_;
		BirdFontPath* _tmp46_;
		BirdFontPath* _tmp47_;
		_tmp42_ = original_path1;
		_tmp43_ = _g_object_ref0 (_tmp42_);
		_g_object_unref0 (t);
		t = _tmp43_;
		_tmp44_ = original_path2;
		_tmp45_ = _g_object_ref0 (_tmp44_);
		_g_object_unref0 (original_path1);
		original_path1 = _tmp45_;
		_tmp46_ = t;
		_tmp47_ = _g_object_ref0 (_tmp46_);
		_g_object_unref0 (original_path2);
		original_path2 = _tmp47_;
		s = 0;
		{
			GeeArrayList* _e_list = NULL;
			BirdFontPath* _tmp48_;
			GeeArrayList* _tmp49_;
			GeeArrayList* _tmp50_;
			gint _e_size = 0;
			GeeArrayList* _tmp51_;
			gint _tmp52_;
			gint _tmp53_;
			gint _e_index = 0;
			_tmp48_ = original_path1;
			_tmp49_ = bird_font_path_get_points (_tmp48_);
			_tmp50_ = _tmp49_;
			_e_list = _tmp50_;
			_tmp51_ = _e_list;
			_tmp52_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp51_);
			_tmp53_ = _tmp52_;
			_e_size = _tmp53_;
			_e_index = -1;
			while (TRUE) {
				gint _tmp54_;
				gint _tmp55_;
				BirdFontEditPoint* e = NULL;
				GeeArrayList* _tmp56_;
				gpointer _tmp57_;
				BirdFontEditPoint* _tmp58_;
				BirdFontPath* _tmp59_;
				gint _tmp60_;
				_e_index = _e_index + 1;
				_tmp54_ = _e_index;
				_tmp55_ = _e_size;
				if (!(_tmp54_ < _tmp55_)) {
					break;
				}
				_tmp56_ = _e_list;
				_tmp57_ = gee_abstract_list_get ((GeeAbstractList*) _tmp56_, _e_index);
				e = (BirdFontEditPoint*) _tmp57_;
				_tmp58_ = e;
				_tmp59_ = original_path2;
				if (!bird_font_stroke_tool_is_inside (_tmp58_, _tmp59_)) {
					_g_object_unref0 (e);
					break;
				}
				_tmp60_ = s;
				s = _tmp60_ + 1;
				_g_object_unref0 (e);
			}
		}
		_g_object_unref0 (t);
	}
	_tmp61_ = original_path1;
	_tmp62_ = bird_font_path_get_points (_tmp61_);
	_tmp63_ = _tmp62_;
	_tmp64_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp63_);
	_tmp65_ = _tmp64_;
	if (s >= _tmp65_) {
		g_warning ("StrokeTool.vala:2384: No start point found.");
		_vala__error_ = TRUE;
		result = FALSE;
		_g_object_unref0 (original_path2);
		_g_object_unref0 (original_path1);
		_g_object_unref0 (other_intersection_point);
		_g_object_unref0 (intersection_point);
		_g_object_unref0 (_result_);
		_g_object_unref0 (other_paths);
		_g_object_unref0 (r);
		_g_object_unref0 (merged);
		_g_object_unref0 (other);
		_g_object_unref0 (path);
		_g_object_unref0 (pp2);
		_g_object_unref0 (pp1);
		_g_object_unref0 (p2);
		_g_object_unref0 (p1);
		_g_object_unref0 (next);
		_g_object_unref0 (ep1);
		_g_object_unref0 (intersections);
		if (merged_paths) {
			*merged_paths = _vala_merged_paths;
		} else {
			_g_object_unref0 (_vala_merged_paths);
		}
		if (_error_) {
			*_error_ = _vala__error_;
		}
		return result;
	}
	_tmp66_ = original_path1;
	_tmp67_ = _g_object_ref0 (_tmp66_);
	_g_object_unref0 (path);
	path = _tmp67_;
	_tmp68_ = original_path2;
	_tmp69_ = _g_object_ref0 (_tmp68_);
	_g_object_unref0 (other);
	other = _tmp69_;
	_tmp70_ = bird_font_path_list_new ();
	_g_object_unref0 (other_paths);
	other_paths = _tmp70_;
	_tmp71_ = bird_font_path_list_new ();
	_g_object_unref0 (r);
	r = _tmp71_;
	_tmp72_ = other_paths;
	_tmp73_ = path;
	bird_font_path_list_add (_tmp72_, _tmp73_);
	_tmp74_ = other_paths;
	_tmp75_ = other;
	bird_font_path_list_add (_tmp74_, _tmp75_);
	intersects = FALSE;
	_tmp76_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
	_g_object_unref0 (p1);
	p1 = _tmp76_;
	_tmp77_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
	_g_object_unref0 (p2);
	p2 = _tmp77_;
	_tmp78_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
	_g_object_unref0 (pp1);
	pp1 = _tmp78_;
	_tmp79_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
	_g_object_unref0 (pp2);
	pp2 = _tmp79_;
	ix = (gdouble) 0;
	iy = (gdouble) 0;
	i = s;
	_tmp80_ = bird_font_path_new ();
	_g_object_unref0 (merged);
	merged = _tmp80_;
	_tmp81_ = original_path1;
	path1_direction = bird_font_stroke_tool_is_clockwise (self, _tmp81_);
	_tmp82_ = original_path1;
	path2_direction = bird_font_stroke_tool_is_clockwise (self, _tmp82_);
	while (TRUE) {
		BirdFontPath* _tmp83_;
		GeeArrayList* _tmp84_;
		GeeArrayList* _tmp85_;
		BirdFontPath* _tmp86_;
		GeeArrayList* _tmp87_;
		GeeArrayList* _tmp88_;
		gint _tmp89_;
		gint _tmp90_;
		gpointer _tmp91_;
		BirdFontPath* _tmp92_;
		GeeArrayList* _tmp93_;
		GeeArrayList* _tmp94_;
		BirdFontPath* _tmp95_;
		GeeArrayList* _tmp96_;
		GeeArrayList* _tmp97_;
		gint _tmp98_;
		gint _tmp99_;
		gpointer _tmp100_;
		BirdFontEditPoint* _tmp101_;
		gdouble dm = 0.0;
		gdouble d = 0.0;
		BirdFontEditPoint* _tmp156_;
		gint _tmp377_;
		_tmp83_ = path;
		_tmp84_ = bird_font_path_get_points (_tmp83_);
		_tmp85_ = _tmp84_;
		_tmp86_ = path;
		_tmp87_ = bird_font_path_get_points (_tmp86_);
		_tmp88_ = _tmp87_;
		_tmp89_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp88_);
		_tmp90_ = _tmp89_;
		_tmp91_ = gee_abstract_list_get ((GeeAbstractList*) _tmp85_, i % _tmp90_);
		_g_object_unref0 (ep1);
		ep1 = (BirdFontEditPoint*) _tmp91_;
		_tmp92_ = path;
		_tmp93_ = bird_font_path_get_points (_tmp92_);
		_tmp94_ = _tmp93_;
		_tmp95_ = path;
		_tmp96_ = bird_font_path_get_points (_tmp95_);
		_tmp97_ = _tmp96_;
		_tmp98_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp97_);
		_tmp99_ = _tmp98_;
		_tmp100_ = gee_abstract_list_get ((GeeAbstractList*) _tmp94_, (i + 1) % _tmp99_);
		_g_object_unref0 (next);
		next = (BirdFontEditPoint*) _tmp100_;
		_tmp101_ = ep1;
		if ((_tmp101_->flags & BIRD_FONT_EDIT_POINT_COPIED) > ((guint) 0)) {
			BirdFontPath* _tmp107_;
			gboolean find_parts = FALSE;
			BirdFontIntersection* new_start = NULL;
			BirdFontIntersection* _tmp108_;
			BirdFontStrokeTask* _tmp122_;
			if (merge) {
				BirdFontPath* _tmp102_;
				BirdFontPathList* _tmp103_;
				BirdFontPath* _tmp104_;
				BirdFontPath* _tmp105_;
				BirdFontPath* _tmp106_;
				_tmp102_ = merged;
				bird_font_path_close (_tmp102_);
				_tmp103_ = _result_;
				_tmp104_ = merged;
				_tmp105_ = bird_font_path_copy (_tmp104_);
				_tmp106_ = _tmp105_;
				bird_font_path_list_add (_tmp103_, _tmp106_);
				_g_object_unref0 (_tmp106_);
			}
			_tmp107_ = bird_font_path_new ();
			_g_object_unref0 (merged);
			merged = _tmp107_;
			find_parts = FALSE;
			_tmp108_ = bird_font_intersection_new_empty ();
			new_start = _tmp108_;
			{
				GeeArrayList* _inter_list = NULL;
				BirdFontIntersectionList* _tmp109_;
				GeeArrayList* _tmp110_;
				gint _inter_size = 0;
				GeeArrayList* _tmp111_;
				gint _tmp112_;
				gint _tmp113_;
				gint _inter_index = 0;
				_tmp109_ = intersections;
				_tmp110_ = _tmp109_->points;
				_inter_list = _tmp110_;
				_tmp111_ = _inter_list;
				_tmp112_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp111_);
				_tmp113_ = _tmp112_;
				_inter_size = _tmp113_;
				_inter_index = -1;
				while (TRUE) {
					gint _tmp114_;
					gint _tmp115_;
					BirdFontIntersection* inter = NULL;
					GeeArrayList* _tmp116_;
					gpointer _tmp117_;
					gboolean _tmp118_ = FALSE;
					BirdFontIntersection* _tmp119_;
					_inter_index = _inter_index + 1;
					_tmp114_ = _inter_index;
					_tmp115_ = _inter_size;
					if (!(_tmp114_ < _tmp115_)) {
						break;
					}
					_tmp116_ = _inter_list;
					_tmp117_ = gee_abstract_list_get ((GeeAbstractList*) _tmp116_, _inter_index);
					inter = (BirdFontIntersection*) _tmp117_;
					_tmp119_ = inter;
					if (!_tmp119_->done) {
						_tmp118_ = !find_parts;
					} else {
						_tmp118_ = FALSE;
					}
					if (_tmp118_) {
						BirdFontIntersection* _tmp120_;
						BirdFontIntersection* _tmp121_;
						find_parts = TRUE;
						_tmp120_ = inter;
						_tmp121_ = _g_object_ref0 (_tmp120_);
						_g_object_unref0 (new_start);
						new_start = _tmp121_;
						_g_object_unref0 (inter);
						break;
					}
					_g_object_unref0 (inter);
				}
			}
			_tmp122_ = self->priv->task;
			if (bird_font_task_is_cancelled ((BirdFontTask*) _tmp122_)) {
				result = FALSE;
				_g_object_unref0 (new_start);
				_g_object_unref0 (original_path2);
				_g_object_unref0 (original_path1);
				_g_object_unref0 (other_intersection_point);
				_g_object_unref0 (intersection_point);
				_g_object_unref0 (_result_);
				_g_object_unref0 (other_paths);
				_g_object_unref0 (r);
				_g_object_unref0 (merged);
				_g_object_unref0 (other);
				_g_object_unref0 (path);
				_g_object_unref0 (pp2);
				_g_object_unref0 (pp1);
				_g_object_unref0 (p2);
				_g_object_unref0 (p1);
				_g_object_unref0 (next);
				_g_object_unref0 (ep1);
				_g_object_unref0 (intersections);
				if (merged_paths) {
					*merged_paths = _vala_merged_paths;
				} else {
					_g_object_unref0 (_vala_merged_paths);
				}
				if (_error_) {
					*_error_ = _vala__error_;
				}
				return result;
			}
			if (!find_parts) {
				_g_object_unref0 (new_start);
				break;
			} else {
				BirdFontIntersection* _tmp123_;
				BirdFontPath* _tmp124_;
				BirdFontPath* _tmp125_;
				BirdFontPath* _tmp126_;
				GeeArrayList* _tmp127_;
				GeeArrayList* _tmp128_;
				gint _tmp129_;
				gint _tmp130_;
				BirdFontPath* _tmp131_;
				BirdFontIntersection* _tmp132_;
				BirdFontPath* _tmp133_;
				BirdFontEditPoint* _tmp134_;
				BirdFontEditPoint* _tmp135_;
				BirdFontPath* _tmp136_;
				GeeArrayList* _tmp137_;
				GeeArrayList* _tmp138_;
				BirdFontPath* _tmp139_;
				GeeArrayList* _tmp140_;
				GeeArrayList* _tmp141_;
				gint _tmp142_;
				gint _tmp143_;
				gpointer _tmp144_;
				BirdFontPath* _tmp145_;
				GeeArrayList* _tmp146_;
				GeeArrayList* _tmp147_;
				BirdFontPath* _tmp148_;
				GeeArrayList* _tmp149_;
				GeeArrayList* _tmp150_;
				gint _tmp151_;
				gint _tmp152_;
				gpointer _tmp153_;
				BirdFontEditPoint* _tmp154_;
				BirdFontIntersection* _tmp155_;
				_tmp123_ = new_start;
				_tmp124_ = _tmp123_->other_path;
				_tmp125_ = _g_object_ref0 (_tmp124_);
				_g_object_unref0 (path);
				path = _tmp125_;
				_tmp126_ = path;
				_tmp127_ = bird_font_path_get_points (_tmp126_);
				_tmp128_ = _tmp127_;
				_tmp129_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp128_);
				_tmp130_ = _tmp129_;
				if (_tmp130_ == 0) {
					g_warning ("StrokeTool.vala:2443: No points.");
					_vala__error_ = TRUE;
					result = FALSE;
					_g_object_unref0 (new_start);
					_g_object_unref0 (original_path2);
					_g_object_unref0 (original_path1);
					_g_object_unref0 (other_intersection_point);
					_g_object_unref0 (intersection_point);
					_g_object_unref0 (_result_);
					_g_object_unref0 (other_paths);
					_g_object_unref0 (r);
					_g_object_unref0 (merged);
					_g_object_unref0 (other);
					_g_object_unref0 (path);
					_g_object_unref0 (pp2);
					_g_object_unref0 (pp1);
					_g_object_unref0 (p2);
					_g_object_unref0 (p1);
					_g_object_unref0 (next);
					_g_object_unref0 (ep1);
					_g_object_unref0 (intersections);
					if (merged_paths) {
						*merged_paths = _vala_merged_paths;
					} else {
						_g_object_unref0 (_vala_merged_paths);
					}
					if (_error_) {
						*_error_ = _vala__error_;
					}
					return result;
				}
				_tmp131_ = path;
				_tmp132_ = new_start;
				_tmp133_ = path;
				_tmp134_ = bird_font_intersection_get_point (_tmp132_, _tmp133_);
				_tmp135_ = _tmp134_;
				i = bird_font_stroke_tool_index_of (self, _tmp131_, _tmp135_);
				_g_object_unref0 (_tmp135_);
				if (i < 0) {
					g_warning ("StrokeTool.vala:2451: Start point not found.");
					_vala__error_ = TRUE;
					result = FALSE;
					_g_object_unref0 (new_start);
					_g_object_unref0 (original_path2);
					_g_object_unref0 (original_path1);
					_g_object_unref0 (other_intersection_point);
					_g_object_unref0 (intersection_point);
					_g_object_unref0 (_result_);
					_g_object_unref0 (other_paths);
					_g_object_unref0 (r);
					_g_object_unref0 (merged);
					_g_object_unref0 (other);
					_g_object_unref0 (path);
					_g_object_unref0 (pp2);
					_g_object_unref0 (pp1);
					_g_object_unref0 (p2);
					_g_object_unref0 (p1);
					_g_object_unref0 (next);
					_g_object_unref0 (ep1);
					_g_object_unref0 (intersections);
					if (merged_paths) {
						*merged_paths = _vala_merged_paths;
					} else {
						_g_object_unref0 (_vala_merged_paths);
					}
					if (_error_) {
						*_error_ = _vala__error_;
					}
					return result;
				}
				_tmp136_ = path;
				_tmp137_ = bird_font_path_get_points (_tmp136_);
				_tmp138_ = _tmp137_;
				_tmp139_ = path;
				_tmp140_ = bird_font_path_get_points (_tmp139_);
				_tmp141_ = _tmp140_;
				_tmp142_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp141_);
				_tmp143_ = _tmp142_;
				_tmp144_ = gee_abstract_list_get ((GeeAbstractList*) _tmp138_, i % _tmp143_);
				_g_object_unref0 (ep1);
				ep1 = (BirdFontEditPoint*) _tmp144_;
				_tmp145_ = path;
				_tmp146_ = bird_font_path_get_points (_tmp145_);
				_tmp147_ = _tmp146_;
				_tmp148_ = path;
				_tmp149_ = bird_font_path_get_points (_tmp148_);
				_tmp150_ = _tmp149_;
				_tmp151_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp150_);
				_tmp152_ = _tmp151_;
				_tmp153_ = gee_abstract_list_get ((GeeAbstractList*) _tmp147_, (i + 1) % _tmp152_);
				_g_object_unref0 (next);
				next = (BirdFontEditPoint*) _tmp153_;
				_tmp154_ = ep1;
				if ((_tmp154_->flags & BIRD_FONT_EDIT_POINT_INTERSECTION) == ((guint) 0)) {
					g_warning ("StrokeTool.vala:2460: Not starting on an intersection point.");
					_vala__error_ = TRUE;
					result = FALSE;
					_g_object_unref0 (new_start);
					_g_object_unref0 (original_path2);
					_g_object_unref0 (original_path1);
					_g_object_unref0 (other_intersection_point);
					_g_object_unref0 (intersection_point);
					_g_object_unref0 (_result_);
					_g_object_unref0 (other_paths);
					_g_object_unref0 (r);
					_g_object_unref0 (merged);
					_g_object_unref0 (other);
					_g_object_unref0 (path);
					_g_object_unref0 (pp2);
					_g_object_unref0 (pp1);
					_g_object_unref0 (p2);
					_g_object_unref0 (p1);
					_g_object_unref0 (next);
					_g_object_unref0 (ep1);
					_g_object_unref0 (intersections);
					if (merged_paths) {
						*merged_paths = _vala_merged_paths;
					} else {
						_g_object_unref0 (_vala_merged_paths);
					}
					if (_error_) {
						*_error_ = _vala__error_;
					}
					return result;
				}
				_tmp155_ = new_start;
				_tmp155_->done = TRUE;
			}
			_g_object_unref0 (new_start);
		}
		intersects = FALSE;
		_tmp156_ = ep1;
		if ((_tmp156_->flags & BIRD_FONT_EDIT_POINT_INTERSECTION) > ((guint) 0)) {
			BirdFontIntersection* current_intersection = NULL;
			gboolean continue_on_other_path = FALSE;
			BirdFontIntersectionList* _tmp157_;
			BirdFontEditPoint* _tmp158_;
			gboolean _tmp159_ = FALSE;
			BirdFontIntersection* _tmp160_;
			BirdFontIntersection* _tmp161_;
			BirdFontEditPoint* _tmp162_;
			BirdFontIntersection* _tmp276_;
			_tmp157_ = intersections;
			_tmp158_ = ep1;
			_tmp160_ = bird_font_intersection_list_get_point (_tmp157_, _tmp158_, &_tmp159_);
			continue_on_other_path = _tmp159_;
			_g_object_unref0 (current_intersection);
			current_intersection = _tmp160_;
			_tmp161_ = current_intersection;
			_tmp161_->done = TRUE;
			_tmp162_ = next;
			if ((_tmp162_->flags & BIRD_FONT_EDIT_POINT_COPIED) != ((guint) 0)) {
				gboolean next_is_intersection = FALSE;
				gboolean next_continue_on_other_path = FALSE;
				BirdFontEditPoint* _tmp163_;
				next_is_intersection = FALSE;
				_tmp163_ = next;
				next_is_intersection = (_tmp163_->flags & BIRD_FONT_EDIT_POINT_INTERSECTION) > ((guint) 0);
				if (next_is_intersection) {
					BirdFontIntersection* next_intersection = NULL;
					BirdFontIntersectionList* _tmp164_;
					BirdFontEditPoint* _tmp165_;
					gboolean _tmp166_ = FALSE;
					BirdFontIntersection* _tmp167_;
					BirdFontEditPoint* _tmp168_;
					BirdFontEditPoint* _tmp169_;
					BirdFontPath* _tmp170_;
					BirdFontEditPoint* _tmp171_;
					BirdFontEditPoint* _tmp172_;
					BirdFontEditPoint* _tmp173_;
					BirdFontEditPoint* _tmp174_;
					BirdFontEditPoint* _tmp175_;
					BirdFontIntersection* _tmp176_;
					_tmp164_ = intersections;
					_tmp165_ = next;
					_tmp167_ = bird_font_intersection_list_get_point (_tmp164_, _tmp165_, &_tmp166_);
					next_continue_on_other_path = _tmp166_;
					next_intersection = _tmp167_;
					_tmp168_ = ep1;
					_tmp169_ = ep1;
					_tmp169_->flags = _tmp169_->flags | BIRD_FONT_EDIT_POINT_COPIED;
					_tmp170_ = merged;
					_tmp171_ = ep1;
					_tmp172_ = bird_font_edit_point_copy (_tmp171_);
					_tmp173_ = _tmp172_;
					_tmp174_ = bird_font_path_add_point (_tmp170_, _tmp173_);
					_tmp175_ = _tmp174_;
					_g_object_unref0 (_tmp175_);
					_g_object_unref0 (_tmp173_);
					_tmp176_ = next_intersection;
					if (!_tmp176_->done) {
						BirdFontEditPoint* new_start_point = NULL;
						BirdFontPath* _tmp177_ = NULL;
						BirdFontPath* _tmp182_;
						BirdFontEditPoint* _tmp183_ = NULL;
						BirdFontEditPoint* _tmp188_;
						BirdFontPath* _tmp189_;
						BirdFontEditPoint* _tmp190_;
						BirdFontPath* _tmp191_;
						GeeArrayList* _tmp192_;
						GeeArrayList* _tmp193_;
						BirdFontPath* _tmp194_;
						GeeArrayList* _tmp195_;
						GeeArrayList* _tmp196_;
						gint _tmp197_;
						gint _tmp198_;
						gpointer _tmp199_;
						BirdFontPath* _tmp200_;
						GeeArrayList* _tmp201_;
						GeeArrayList* _tmp202_;
						BirdFontPath* _tmp203_;
						GeeArrayList* _tmp204_;
						GeeArrayList* _tmp205_;
						gint _tmp206_;
						gint _tmp207_;
						gpointer _tmp208_;
						if (next_continue_on_other_path) {
							BirdFontIntersection* _tmp178_;
							BirdFontPath* _tmp179_;
							_tmp178_ = next_intersection;
							_tmp179_ = _tmp178_->other_path;
							_tmp177_ = _tmp179_;
						} else {
							BirdFontIntersection* _tmp180_;
							BirdFontPath* _tmp181_;
							_tmp180_ = next_intersection;
							_tmp181_ = _tmp180_->path;
							_tmp177_ = _tmp181_;
						}
						_tmp182_ = _g_object_ref0 (_tmp177_);
						_g_object_unref0 (path);
						path = _tmp182_;
						if (next_continue_on_other_path) {
							BirdFontIntersection* _tmp184_;
							BirdFontEditPoint* _tmp185_;
							_tmp184_ = next_intersection;
							_tmp185_ = _tmp184_->other_point;
							_tmp183_ = _tmp185_;
						} else {
							BirdFontIntersection* _tmp186_;
							BirdFontEditPoint* _tmp187_;
							_tmp186_ = next_intersection;
							_tmp187_ = _tmp186_->point;
							_tmp183_ = _tmp187_;
						}
						_tmp188_ = _g_object_ref0 (_tmp183_);
						_g_object_unref0 (new_start_point);
						new_start_point = _tmp188_;
						_tmp189_ = path;
						_tmp190_ = new_start_point;
						i = bird_font_stroke_tool_index_of (self, _tmp189_, _tmp190_);
						if (i < 0) {
							g_warning ("StrokeTool.vala:2505: Point not found in path.\n");
							_vala__error_ = TRUE;
							result = FALSE;
							_g_object_unref0 (new_start_point);
							_g_object_unref0 (next_intersection);
							_g_object_unref0 (current_intersection);
							_g_object_unref0 (original_path2);
							_g_object_unref0 (original_path1);
							_g_object_unref0 (other_intersection_point);
							_g_object_unref0 (intersection_point);
							_g_object_unref0 (_result_);
							_g_object_unref0 (other_paths);
							_g_object_unref0 (r);
							_g_object_unref0 (merged);
							_g_object_unref0 (other);
							_g_object_unref0 (path);
							_g_object_unref0 (pp2);
							_g_object_unref0 (pp1);
							_g_object_unref0 (p2);
							_g_object_unref0 (p1);
							_g_object_unref0 (next);
							_g_object_unref0 (ep1);
							_g_object_unref0 (intersections);
							if (merged_paths) {
								*merged_paths = _vala_merged_paths;
							} else {
								_g_object_unref0 (_vala_merged_paths);
							}
							if (_error_) {
								*_error_ = _vala__error_;
							}
							return result;
						}
						_tmp191_ = path;
						_tmp192_ = bird_font_path_get_points (_tmp191_);
						_tmp193_ = _tmp192_;
						_tmp194_ = path;
						_tmp195_ = bird_font_path_get_points (_tmp194_);
						_tmp196_ = _tmp195_;
						_tmp197_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp196_);
						_tmp198_ = _tmp197_;
						_tmp199_ = gee_abstract_list_get ((GeeAbstractList*) _tmp193_, i % _tmp198_);
						_g_object_unref0 (ep1);
						ep1 = (BirdFontEditPoint*) _tmp199_;
						_tmp200_ = path;
						_tmp201_ = bird_font_path_get_points (_tmp200_);
						_tmp202_ = _tmp201_;
						_tmp203_ = path;
						_tmp204_ = bird_font_path_get_points (_tmp203_);
						_tmp205_ = _tmp204_;
						_tmp206_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp205_);
						_tmp207_ = _tmp206_;
						_tmp208_ = gee_abstract_list_get ((GeeAbstractList*) _tmp202_, (i + 1) % _tmp207_);
						_g_object_unref0 (next);
						next = (BirdFontEditPoint*) _tmp208_;
						_g_object_unref0 (new_start_point);
					} else {
						g_warning ("StrokeTool.vala:2513: Part is already created.\n");
						_vala__error_ = TRUE;
						result = FALSE;
						_g_object_unref0 (next_intersection);
						_g_object_unref0 (current_intersection);
						_g_object_unref0 (original_path2);
						_g_object_unref0 (original_path1);
						_g_object_unref0 (other_intersection_point);
						_g_object_unref0 (intersection_point);
						_g_object_unref0 (_result_);
						_g_object_unref0 (other_paths);
						_g_object_unref0 (r);
						_g_object_unref0 (merged);
						_g_object_unref0 (other);
						_g_object_unref0 (path);
						_g_object_unref0 (pp2);
						_g_object_unref0 (pp1);
						_g_object_unref0 (p2);
						_g_object_unref0 (p1);
						_g_object_unref0 (next);
						_g_object_unref0 (ep1);
						_g_object_unref0 (intersections);
						if (merged_paths) {
							*merged_paths = _vala_merged_paths;
						} else {
							_g_object_unref0 (_vala_merged_paths);
						}
						if (_error_) {
							*_error_ = _vala__error_;
						}
						return result;
					}
					_g_object_unref0 (next_intersection);
				} else {
					BirdFontEditPoint* _tmp209_;
					BirdFontEditPoint* _tmp210_;
					BirdFontPath* _tmp211_;
					BirdFontEditPoint* _tmp212_;
					BirdFontEditPoint* _tmp213_;
					BirdFontEditPoint* _tmp214_;
					BirdFontEditPoint* _tmp215_;
					BirdFontEditPoint* _tmp216_;
					BirdFontEditPoint* new_start_point = NULL;
					BirdFontEditPoint* _tmp217_;
					_tmp209_ = ep1;
					_tmp210_ = ep1;
					_tmp210_->flags = _tmp210_->flags | BIRD_FONT_EDIT_POINT_COPIED;
					_tmp211_ = merged;
					_tmp212_ = ep1;
					_tmp213_ = bird_font_edit_point_copy (_tmp212_);
					_tmp214_ = _tmp213_;
					_tmp215_ = bird_font_path_add_point (_tmp211_, _tmp214_);
					_tmp216_ = _tmp215_;
					_g_object_unref0 (_tmp216_);
					_g_object_unref0 (_tmp214_);
					_tmp217_ = next;
					if ((_tmp217_->flags & BIRD_FONT_EDIT_POINT_COPIED) > ((guint) 0)) {
						BirdFontIntersection* _tmp218_;
						BirdFontPath* _tmp219_;
						BirdFontPath* _tmp220_;
						BirdFontIntersection* _tmp221_;
						BirdFontPath* _tmp222_;
						BirdFontEditPoint* _tmp223_;
						BirdFontPath* _tmp224_;
						BirdFontEditPoint* _tmp225_;
						BirdFontPath* _tmp226_;
						GeeArrayList* _tmp227_;
						GeeArrayList* _tmp228_;
						BirdFontPath* _tmp229_;
						GeeArrayList* _tmp230_;
						GeeArrayList* _tmp231_;
						gint _tmp232_;
						gint _tmp233_;
						gpointer _tmp234_;
						BirdFontPath* _tmp235_;
						GeeArrayList* _tmp236_;
						GeeArrayList* _tmp237_;
						BirdFontPath* _tmp238_;
						GeeArrayList* _tmp239_;
						GeeArrayList* _tmp240_;
						gint _tmp241_;
						gint _tmp242_;
						gpointer _tmp243_;
						BirdFontEditPoint* _tmp244_;
						BirdFontEditPoint* _tmp245_;
						_tmp218_ = current_intersection;
						_tmp219_ = path;
						_tmp220_ = bird_font_intersection_get_other_path (_tmp218_, _tmp219_);
						_g_object_unref0 (path);
						path = _tmp220_;
						_tmp221_ = current_intersection;
						_tmp222_ = path;
						_tmp223_ = bird_font_intersection_get_point (_tmp221_, _tmp222_);
						_g_object_unref0 (new_start_point);
						new_start_point = _tmp223_;
						_tmp224_ = path;
						_tmp225_ = new_start_point;
						i = bird_font_stroke_tool_index_of (self, _tmp224_, _tmp225_);
						if (i < 0) {
							g_warning ("StrokeTool.vala:2529: Point not found in path.");
							_vala__error_ = TRUE;
							result = FALSE;
							_g_object_unref0 (new_start_point);
							_g_object_unref0 (current_intersection);
							_g_object_unref0 (original_path2);
							_g_object_unref0 (original_path1);
							_g_object_unref0 (other_intersection_point);
							_g_object_unref0 (intersection_point);
							_g_object_unref0 (_result_);
							_g_object_unref0 (other_paths);
							_g_object_unref0 (r);
							_g_object_unref0 (merged);
							_g_object_unref0 (other);
							_g_object_unref0 (path);
							_g_object_unref0 (pp2);
							_g_object_unref0 (pp1);
							_g_object_unref0 (p2);
							_g_object_unref0 (p1);
							_g_object_unref0 (next);
							_g_object_unref0 (ep1);
							_g_object_unref0 (intersections);
							if (merged_paths) {
								*merged_paths = _vala_merged_paths;
							} else {
								_g_object_unref0 (_vala_merged_paths);
							}
							if (_error_) {
								*_error_ = _vala__error_;
							}
							return result;
						}
						_tmp226_ = path;
						_tmp227_ = bird_font_path_get_points (_tmp226_);
						_tmp228_ = _tmp227_;
						_tmp229_ = path;
						_tmp230_ = bird_font_path_get_points (_tmp229_);
						_tmp231_ = _tmp230_;
						_tmp232_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp231_);
						_tmp233_ = _tmp232_;
						_tmp234_ = gee_abstract_list_get ((GeeAbstractList*) _tmp228_, i % _tmp233_);
						_g_object_unref0 (ep1);
						ep1 = (BirdFontEditPoint*) _tmp234_;
						_tmp235_ = path;
						_tmp236_ = bird_font_path_get_points (_tmp235_);
						_tmp237_ = _tmp236_;
						_tmp238_ = path;
						_tmp239_ = bird_font_path_get_points (_tmp238_);
						_tmp240_ = _tmp239_;
						_tmp241_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp240_);
						_tmp242_ = _tmp241_;
						_tmp243_ = gee_abstract_list_get ((GeeAbstractList*) _tmp237_, (i + 1) % _tmp242_);
						_g_object_unref0 (next);
						next = (BirdFontEditPoint*) _tmp243_;
						_tmp244_ = next;
						if ((_tmp244_->flags & BIRD_FONT_EDIT_POINT_INTERSECTION) > ((guint) 0)) {
							g_warning ("StrokeTool.vala:2538: Wrong type.");
							_vala__error_ = TRUE;
							result = FALSE;
							_g_object_unref0 (new_start_point);
							_g_object_unref0 (current_intersection);
							_g_object_unref0 (original_path2);
							_g_object_unref0 (original_path1);
							_g_object_unref0 (other_intersection_point);
							_g_object_unref0 (intersection_point);
							_g_object_unref0 (_result_);
							_g_object_unref0 (other_paths);
							_g_object_unref0 (r);
							_g_object_unref0 (merged);
							_g_object_unref0 (other);
							_g_object_unref0 (path);
							_g_object_unref0 (pp2);
							_g_object_unref0 (pp1);
							_g_object_unref0 (p2);
							_g_object_unref0 (p1);
							_g_object_unref0 (next);
							_g_object_unref0 (ep1);
							_g_object_unref0 (intersections);
							if (merged_paths) {
								*merged_paths = _vala_merged_paths;
							} else {
								_g_object_unref0 (_vala_merged_paths);
							}
							if (_error_) {
								*_error_ = _vala__error_;
							}
							return result;
						}
						_tmp245_ = next;
						if ((_tmp245_->flags & BIRD_FONT_EDIT_POINT_COPIED) > ((guint) 0)) {
							BirdFontPath* _tmp246_;
							BirdFontEditPoint* _tmp247_;
							BirdFontEditPoint* _tmp248_;
							BirdFontEditPoint* _tmp249_;
							BirdFontEditPoint* _tmp250_;
							BirdFontEditPoint* _tmp251_;
							_tmp246_ = merged;
							_tmp247_ = ep1;
							_tmp248_ = bird_font_edit_point_copy (_tmp247_);
							_tmp249_ = _tmp248_;
							_tmp250_ = bird_font_path_add_point (_tmp246_, _tmp249_);
							_tmp251_ = _tmp250_;
							_g_object_unref0 (_tmp251_);
							_g_object_unref0 (_tmp249_);
							_g_object_unref0 (new_start_point);
							_g_object_unref0 (current_intersection);
							continue;
						}
					} else {
						BirdFontEditPoint* _tmp252_;
						BirdFontEditPoint* _tmp253_;
						BirdFontPath* _tmp254_;
						BirdFontEditPoint* _tmp255_;
						BirdFontEditPoint* _tmp256_;
						BirdFontEditPoint* _tmp257_;
						BirdFontEditPoint* _tmp258_;
						BirdFontEditPoint* _tmp259_;
						_tmp252_ = ep1;
						_tmp253_ = ep1;
						_tmp253_->flags = _tmp253_->flags | BIRD_FONT_EDIT_POINT_COPIED;
						_tmp254_ = merged;
						_tmp255_ = ep1;
						_tmp256_ = bird_font_edit_point_copy (_tmp255_);
						_tmp257_ = _tmp256_;
						_tmp258_ = bird_font_path_add_point (_tmp254_, _tmp257_);
						_tmp259_ = _tmp258_;
						_g_object_unref0 (_tmp259_);
						_g_object_unref0 (_tmp257_);
					}
					_g_object_unref0 (new_start_point);
				}
			} else {
				BirdFontEditPoint* _tmp260_;
				BirdFontEditPoint* _tmp261_;
				_tmp260_ = ep1;
				_tmp261_ = ep1;
				_tmp261_->flags = _tmp261_->flags | BIRD_FONT_EDIT_POINT_COPIED;
				if (path1_direction == path2_direction) {
					BirdFontEditPoint* _tmp262_;
					BirdFontPath* _tmp263_;
					_tmp262_ = ep1;
					_tmp263_ = original_path1;
					if (!bird_font_stroke_tool_is_inside (_tmp262_, _tmp263_)) {
						BirdFontPath* _tmp264_;
						BirdFontEditPoint* _tmp265_;
						BirdFontEditPoint* _tmp266_;
						BirdFontEditPoint* _tmp267_;
						BirdFontEditPoint* _tmp268_;
						BirdFontEditPoint* _tmp269_;
						_tmp264_ = merged;
						_tmp265_ = ep1;
						_tmp266_ = bird_font_edit_point_copy (_tmp265_);
						_tmp267_ = _tmp266_;
						_tmp268_ = bird_font_path_add_point (_tmp264_, _tmp267_);
						_tmp269_ = _tmp268_;
						_g_object_unref0 (_tmp269_);
						_g_object_unref0 (_tmp267_);
					}
				} else {
					BirdFontPath* _tmp270_;
					BirdFontEditPoint* _tmp271_;
					BirdFontEditPoint* _tmp272_;
					BirdFontEditPoint* _tmp273_;
					BirdFontEditPoint* _tmp274_;
					BirdFontEditPoint* _tmp275_;
					_tmp270_ = merged;
					_tmp271_ = ep1;
					_tmp272_ = bird_font_edit_point_copy (_tmp271_);
					_tmp273_ = _tmp272_;
					_tmp274_ = bird_font_path_add_point (_tmp270_, _tmp273_);
					_tmp275_ = _tmp274_;
					_g_object_unref0 (_tmp275_);
					_g_object_unref0 (_tmp273_);
				}
			}
			_tmp276_ = current_intersection;
			_tmp276_->done = TRUE;
			_g_object_unref0 (current_intersection);
		} else {
			dm = DBL_MAX;
			{
				GeeArrayList* _o_list = NULL;
				BirdFontPathList* _tmp277_;
				GeeArrayList* _tmp278_;
				gint _o_size = 0;
				GeeArrayList* _tmp279_;
				gint _tmp280_;
				gint _tmp281_;
				gint _o_index = 0;
				_tmp277_ = other_paths;
				_tmp278_ = _tmp277_->paths;
				_o_list = _tmp278_;
				_tmp279_ = _o_list;
				_tmp280_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp279_);
				_tmp281_ = _tmp280_;
				_o_size = _tmp281_;
				_o_index = -1;
				while (TRUE) {
					gint _tmp282_;
					gint _tmp283_;
					BirdFontPath* o = NULL;
					GeeArrayList* _tmp284_;
					gpointer _tmp285_;
					gboolean inter = FALSE;
					BirdFontPath* _tmp286_;
					BirdFontEditPoint* _tmp287_;
					BirdFontEditPoint* _tmp288_;
					gdouble _tmp289_ = 0.0;
					gdouble _tmp290_ = 0.0;
					BirdFontEditPoint* _tmp291_ = NULL;
					BirdFontEditPoint* _tmp292_ = NULL;
					gboolean _tmp293_;
					BirdFontEditPoint* _tmp294_;
					BirdFontEditPoint* _tmp295_;
					gboolean _tmp296_ = FALSE;
					_o_index = _o_index + 1;
					_tmp282_ = _o_index;
					_tmp283_ = _o_size;
					if (!(_tmp282_ < _tmp283_)) {
						break;
					}
					_tmp284_ = _o_list;
					_tmp285_ = gee_abstract_list_get ((GeeAbstractList*) _tmp284_, _o_index);
					o = (BirdFontPath*) _tmp285_;
					_tmp286_ = o;
					_tmp287_ = ep1;
					_tmp288_ = next;
					_tmp293_ = bird_font_stroke_tool_segment_intersects (self, _tmp286_, _tmp287_, _tmp288_, &_tmp289_, &_tmp290_, &_tmp291_, &_tmp292_, FALSE, FALSE);
					iix = _tmp289_;
					iiy = _tmp290_;
					_g_object_unref0 (pp1);
					pp1 = _tmp291_;
					_g_object_unref0 (pp2);
					pp2 = _tmp292_;
					inter = _tmp293_;
					_tmp294_ = ep1;
					_tmp295_ = ep1;
					d = bird_font_path_distance (_tmp294_->x, iix, _tmp295_->y, iiy);
					if (d < dm) {
						_tmp296_ = inter;
					} else {
						_tmp296_ = FALSE;
					}
					if (_tmp296_) {
						BirdFontPath* _tmp297_;
						BirdFontPath* _tmp298_;
						BirdFontEditPoint* _tmp299_;
						BirdFontEditPoint* _tmp300_;
						BirdFontEditPoint* _tmp301_;
						BirdFontEditPoint* _tmp302_;
						_tmp297_ = o;
						_tmp298_ = _g_object_ref0 (_tmp297_);
						_g_object_unref0 (other);
						other = _tmp298_;
						dm = d;
						intersects = TRUE;
						_tmp299_ = pp1;
						_tmp300_ = _g_object_ref0 (_tmp299_);
						_g_object_unref0 (p1);
						p1 = _tmp300_;
						_tmp301_ = pp2;
						_tmp302_ = _g_object_ref0 (_tmp301_);
						_g_object_unref0 (p2);
						p2 = _tmp302_;
						ix = iix;
						iy = iiy;
					}
					if (d < 0.0001) {
						intersects = FALSE;
					}
					_g_object_unref0 (o);
				}
			}
			if (intersects) {
				BirdFontPath* _tmp303_;
				BirdFontEditPoint* _tmp304_;
				BirdFontEditPoint* _tmp305_;
				BirdFontEditPoint* _tmp306_;
				BirdFontEditPoint* _tmp307_;
				BirdFontEditPoint* _tmp308_;
				BirdFontEditPoint* _tmp309_;
				BirdFontEditPoint* _tmp310_;
				BirdFontPath* _tmp311_;
				BirdFontEditPoint* _tmp312_;
				BirdFontEditPoint* _tmp313_;
				BirdFontEditPoint* _tmp314_;
				BirdFontPath* _tmp315_;
				BirdFontEditPoint* _tmp316_;
				BirdFontEditPoint* _tmp317_;
				BirdFontEditPoint* _tmp318_;
				gboolean g = FALSE;
				BirdFontPath* _tmp344_;
				BirdFontEditPoint* _tmp345_;
				BirdFontEditPoint* _tmp346_;
				BirdFontEditPoint* _tmp347_;
				BirdFontEditPoint* _tmp348_;
				BirdFontEditPoint* _tmp349_;
				BirdFontEditPoint* _tmp350_;
				BirdFontEditPoint* _tmp351_;
				BirdFontPath* _tmp352_;
				BirdFontEditPoint* _tmp353_;
				BirdFontPath* _tmp358_;
				BirdFontPath* _tmp359_;
				_tmp303_ = merged;
				_tmp304_ = ep1;
				_tmp305_ = bird_font_edit_point_copy (_tmp304_);
				_tmp306_ = _tmp305_;
				_tmp307_ = bird_font_path_add_point (_tmp303_, _tmp306_);
				_tmp308_ = _tmp307_;
				_g_object_unref0 (_tmp308_);
				_g_object_unref0 (_tmp306_);
				_tmp309_ = ep1;
				_tmp310_ = ep1;
				_tmp310_->flags = _tmp310_->flags | BIRD_FONT_EDIT_POINT_COPIED;
				_tmp311_ = path;
				_tmp312_ = ep1;
				_tmp313_ = next;
				_tmp314_ = bird_font_stroke_tool_add_intersection (self, _tmp311_, _tmp312_, _tmp313_, ix, iy, NULL);
				_g_object_unref0 (intersection_point);
				intersection_point = _tmp314_;
				_tmp315_ = other;
				_tmp316_ = p1;
				_tmp317_ = p2;
				_tmp318_ = bird_font_stroke_tool_add_intersection (self, _tmp315_, _tmp316_, _tmp317_, ix, iy, NULL);
				_g_object_unref0 (other_intersection_point);
				other_intersection_point = _tmp318_;
				g = FALSE;
				{
					GeeArrayList* _old_intersection_list = NULL;
					BirdFontIntersectionList* _tmp319_;
					GeeArrayList* _tmp320_;
					gint _old_intersection_size = 0;
					GeeArrayList* _tmp321_;
					gint _tmp322_;
					gint _tmp323_;
					gint _old_intersection_index = 0;
					_tmp319_ = intersections;
					_tmp320_ = _tmp319_->points;
					_old_intersection_list = _tmp320_;
					_tmp321_ = _old_intersection_list;
					_tmp322_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp321_);
					_tmp323_ = _tmp322_;
					_old_intersection_size = _tmp323_;
					_old_intersection_index = -1;
					while (TRUE) {
						gint _tmp324_;
						gint _tmp325_;
						BirdFontIntersection* old_intersection = NULL;
						GeeArrayList* _tmp326_;
						gpointer _tmp327_;
						gboolean _tmp328_ = FALSE;
						BirdFontIntersection* _tmp329_;
						BirdFontEditPoint* _tmp330_;
						BirdFontEditPoint* _tmp331_;
						_old_intersection_index = _old_intersection_index + 1;
						_tmp324_ = _old_intersection_index;
						_tmp325_ = _old_intersection_size;
						if (!(_tmp324_ < _tmp325_)) {
							break;
						}
						_tmp326_ = _old_intersection_list;
						_tmp327_ = gee_abstract_list_get ((GeeAbstractList*) _tmp326_, _old_intersection_index);
						old_intersection = (BirdFontIntersection*) _tmp327_;
						_tmp329_ = old_intersection;
						_tmp330_ = _tmp329_->point;
						_tmp331_ = intersection_point;
						if (_tmp330_ == _tmp331_) {
							_tmp328_ = TRUE;
						} else {
							BirdFontIntersection* _tmp332_;
							BirdFontEditPoint* _tmp333_;
							BirdFontEditPoint* _tmp334_;
							_tmp332_ = old_intersection;
							_tmp333_ = _tmp332_->other_point;
							_tmp334_ = other_intersection_point;
							_tmp328_ = _tmp333_ == _tmp334_;
						}
						if (_tmp328_) {
							BirdFontIntersection* _tmp335_;
							_tmp335_ = old_intersection;
							_tmp335_->done = TRUE;
							g = TRUE;
						}
						_g_object_unref0 (old_intersection);
					}
				}
				if (!g) {
					BirdFontIntersection* ip = NULL;
					BirdFontEditPoint* _tmp336_;
					BirdFontPath* _tmp337_;
					BirdFontEditPoint* _tmp338_;
					BirdFontPath* _tmp339_;
					BirdFontIntersection* _tmp340_;
					BirdFontIntersectionList* _tmp341_;
					GeeArrayList* _tmp342_;
					BirdFontIntersection* _tmp343_;
					_tmp336_ = intersection_point;
					_tmp337_ = path;
					_tmp338_ = other_intersection_point;
					_tmp339_ = other;
					_tmp340_ = bird_font_intersection_new (_tmp336_, _tmp337_, _tmp338_, _tmp339_);
					ip = _tmp340_;
					_tmp341_ = intersections;
					_tmp342_ = _tmp341_->points;
					_tmp343_ = ip;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp342_, _tmp343_);
					_g_object_unref0 (ip);
				}
				_tmp344_ = merged;
				_tmp345_ = intersection_point;
				_tmp346_ = bird_font_edit_point_copy (_tmp345_);
				_tmp347_ = _tmp346_;
				_tmp348_ = bird_font_path_add_point (_tmp344_, _tmp347_);
				_tmp349_ = _tmp348_;
				_g_object_unref0 (_tmp349_);
				_g_object_unref0 (_tmp347_);
				_tmp350_ = intersection_point;
				_tmp351_ = intersection_point;
				_tmp351_->flags = _tmp351_->flags | BIRD_FONT_EDIT_POINT_COPIED;
				_tmp352_ = other;
				_tmp353_ = other_intersection_point;
				i = bird_font_stroke_tool_index_of (self, _tmp352_, _tmp353_);
				if (i < 0) {
					gchar* _tmp354_;
					gchar* _tmp355_;
					gchar* _tmp356_;
					gchar* _tmp357_;
					_tmp354_ = g_strdup_printf ("%i", i);
					_tmp355_ = _tmp354_;
					_tmp356_ = g_strconcat ("Point not found (", _tmp355_, ").", NULL);
					_tmp357_ = _tmp356_;
					g_warning ("StrokeTool.vala:2614: %s", _tmp357_);
					_g_free0 (_tmp357_);
					_g_free0 (_tmp355_);
					break;
				}
				_tmp358_ = other;
				_tmp359_ = _g_object_ref0 (_tmp358_);
				_g_object_unref0 (path);
				path = _tmp359_;
				merge = TRUE;
			} else {
				BirdFontEditPoint* _tmp360_;
				BirdFontEditPoint* _tmp361_;
				BirdFontPath* _tmp362_;
				BirdFontEditPoint* _tmp363_;
				BirdFontEditPoint* _tmp364_;
				BirdFontEditPoint* _tmp365_;
				BirdFontEditPoint* _tmp366_;
				BirdFontEditPoint* _tmp367_;
				BirdFontPointSelection* ps = NULL;
				BirdFontPath* outline = NULL;
				BirdFontPath* _tmp368_;
				_tmp360_ = ep1;
				_tmp361_ = ep1;
				_tmp361_->flags = _tmp361_->flags | BIRD_FONT_EDIT_POINT_COPIED;
				_tmp362_ = merged;
				_tmp363_ = ep1;
				_tmp364_ = bird_font_edit_point_copy (_tmp363_);
				_tmp365_ = _tmp364_;
				_tmp366_ = bird_font_path_add_point (_tmp362_, _tmp365_);
				_tmp367_ = _tmp366_;
				_g_object_unref0 (_tmp367_);
				_g_object_unref0 (_tmp365_);
				_tmp368_ = original_path2;
				if (bird_font_stroke_tool_is_clockwise (self, _tmp368_)) {
					BirdFontEditPoint* _tmp369_;
					BirdFontPath* _tmp370_;
					BirdFontPointSelection* _tmp371_;
					BirdFontPointSelection* _tmp372_;
					BirdFontPathList* _tmp373_;
					BirdFontPath* _tmp374_ = NULL;
					gboolean _tmp375_;
					_tmp369_ = ep1;
					_tmp370_ = merged;
					_tmp371_ = bird_font_point_selection_new (_tmp369_, _tmp370_);
					_g_object_unref0 (ps);
					ps = _tmp371_;
					_tmp372_ = ps;
					_tmp373_ = _result_;
					_tmp375_ = bird_font_stroke_tool_is_inside_of_path (self, _tmp372_, _tmp373_, &_tmp374_);
					_g_object_unref0 (outline);
					outline = _tmp374_;
					if (_tmp375_) {
						BirdFontEditPoint* _tmp376_;
						_tmp376_ = ep1;
						bird_font_edit_point_set_deleted (_tmp376_, TRUE);
					}
				}
				_g_object_unref0 (outline);
				_g_object_unref0 (ps);
			}
		}
		_tmp377_ = i;
		i = _tmp377_ + 1;
	}
	if (merge) {
		BirdFontPath* _tmp378_;
		BirdFontPath* _tmp379_;
		BirdFontPath* _tmp380_;
		BirdFontPath* _tmp381_;
		_tmp378_ = original_path1;
		bird_font_path_remove_points_on_points (_tmp378_, 0.00001);
		_tmp379_ = original_path2;
		bird_font_path_remove_points_on_points (_tmp379_, 0.00001);
		_tmp380_ = original_path1;
		bird_font_path_remove_deleted_points (_tmp380_);
		_tmp381_ = original_path2;
		bird_font_path_remove_deleted_points (_tmp381_);
		{
			GeeArrayList* _np_list = NULL;
			BirdFontPathList* _tmp382_;
			GeeArrayList* _tmp383_;
			gint _np_size = 0;
			GeeArrayList* _tmp384_;
			gint _tmp385_;
			gint _tmp386_;
			gint _np_index = 0;
			_tmp382_ = _result_;
			_tmp383_ = _tmp382_->paths;
			_np_list = _tmp383_;
			_tmp384_ = _np_list;
			_tmp385_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp384_);
			_tmp386_ = _tmp385_;
			_np_size = _tmp386_;
			_np_index = -1;
			while (TRUE) {
				gint _tmp387_;
				gint _tmp388_;
				BirdFontPath* np = NULL;
				GeeArrayList* _tmp389_;
				gpointer _tmp390_;
				BirdFontPath* p = NULL;
				BirdFontPath* _tmp391_;
				BirdFontPath* _tmp392_;
				gboolean has_direction = FALSE;
				BirdFontPath* _tmp393_;
				_np_index = _np_index + 1;
				_tmp387_ = _np_index;
				_tmp388_ = _np_size;
				if (!(_tmp387_ < _tmp388_)) {
					break;
				}
				_tmp389_ = _np_list;
				_tmp390_ = gee_abstract_list_get ((GeeAbstractList*) _tmp389_, _np_index);
				np = (BirdFontPath*) _tmp390_;
				_tmp391_ = np;
				_tmp392_ = bird_font_path_copy (_tmp391_);
				p = _tmp392_;
				has_direction = TRUE;
				_tmp393_ = p;
				bird_font_path_remove_points_on_points (_tmp393_, 0.00001);
				if (has_direction) {
					BirdFontPath* _tmp394_;
					BirdFontPath* _tmp395_;
					BirdFontPathList* _tmp396_;
					BirdFontPath* _tmp397_;
					BirdFontPathList* _tmp398_;
					BirdFontPathList* _tmp399_;
					BirdFontPath* _tmp400_;
					BirdFontPath* _tmp401_;
					_tmp394_ = p;
					bird_font_path_close (_tmp394_);
					_tmp395_ = p;
					bird_font_stroke_tool_reset_intersections (self, _tmp395_);
					_tmp396_ = _vala_merged_paths;
					_tmp397_ = p;
					_tmp398_ = bird_font_stroke_tool_get_parts (self, _tmp397_);
					_tmp399_ = _tmp398_;
					bird_font_path_list_append (_tmp396_, _tmp399_);
					_g_object_unref0 (_tmp399_);
					_tmp400_ = p;
					bird_font_path_update_region_boundaries (_tmp400_);
					_tmp401_ = p;
					bird_font_path_recalculate_linear_handles (_tmp401_);
				}
				_g_object_unref0 (p);
				_g_object_unref0 (np);
			}
		}
	}
	if (merge) {
		_tmp402_ = !_vala__error_;
	} else {
		_tmp402_ = FALSE;
	}
	result = _tmp402_;
	_g_object_unref0 (original_path2);
	_g_object_unref0 (original_path1);
	_g_object_unref0 (other_intersection_point);
	_g_object_unref0 (intersection_point);
	_g_object_unref0 (_result_);
	_g_object_unref0 (other_paths);
	_g_object_unref0 (r);
	_g_object_unref0 (merged);
	_g_object_unref0 (other);
	_g_object_unref0 (path);
	_g_object_unref0 (pp2);
	_g_object_unref0 (pp1);
	_g_object_unref0 (p2);
	_g_object_unref0 (p1);
	_g_object_unref0 (next);
	_g_object_unref0 (ep1);
	_g_object_unref0 (intersections);
	if (merged_paths) {
		*merged_paths = _vala_merged_paths;
	} else {
		_g_object_unref0 (_vala_merged_paths);
	}
	if (_error_) {
		*_error_ = _vala__error_;
	}
	return result;
}

static gint
bird_font_stroke_tool_index_of (BirdFontStrokeTool* self,
                                BirdFontPath* p,
                                BirdFontEditPoint* ep)
{
	gint i = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (p != NULL, 0);
	g_return_val_if_fail (ep != NULL, 0);
	i = 0;
	{
		GeeArrayList* _e_list = NULL;
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _e_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _e_index = 0;
		_tmp0_ = bird_font_path_get_points (p);
		_tmp1_ = _tmp0_;
		_e_list = _tmp1_;
		_tmp2_ = _e_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_e_size = _tmp4_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontEditPoint* e = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontEditPoint* _tmp9_;
			gint _tmp10_;
			_e_index = _e_index + 1;
			_tmp5_ = _e_index;
			_tmp6_ = _e_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _e_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _e_index);
			e = (BirdFontEditPoint*) _tmp8_;
			_tmp9_ = e;
			if (_tmp9_ == ep) {
				result = i;
				_g_object_unref0 (e);
				return result;
			}
			_tmp10_ = i;
			i = _tmp10_ + 1;
			_g_object_unref0 (e);
		}
	}
	result = -1;
	return result;
}

gint
bird_font_stroke_tool_counters_in_point_in_path (BirdFontStrokeTool* self,
                                                 BirdFontPath* p,
                                                 BirdFontEditPoint* ep)
{
	gint inside_count = 0;
	gboolean inside = FALSE;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (p != NULL, 0);
	g_return_val_if_fail (ep != NULL, 0);
	inside_count = 0;
	_tmp0_ = bird_font_path_get_points (p);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 1) {
		inside = TRUE;
		if (!bird_font_stroke_tool_is_inside (ep, p)) {
			inside = FALSE;
		}
		if (inside) {
			gint _tmp4_;
			_tmp4_ = inside_count;
			inside_count = _tmp4_ + 1;
		}
	}
	result = inside_count;
	return result;
}

static gint
bird_font_stroke_tool_mark_intersection_as_deleted (BirdFontStrokeTool* self,
                                                    BirdFontPath* path)
{
	gint i = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (path != NULL, 0);
	i = 0;
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _p_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _p_index = 0;
		_tmp0_ = bird_font_path_get_points (path);
		_tmp1_ = _tmp0_;
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontEditPoint* p = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontEditPoint* _tmp9_;
			_p_index = _p_index + 1;
			_tmp5_ = _p_index;
			_tmp6_ = _p_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _p_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _p_index);
			p = (BirdFontEditPoint*) _tmp8_;
			_tmp9_ = p;
			if ((_tmp9_->flags & BIRD_FONT_EDIT_POINT_INTERSECTION) > ((guint) 0)) {
				BirdFontEditPoint* _tmp10_;
				gint _tmp11_;
				_tmp10_ = p;
				bird_font_edit_point_set_deleted (_tmp10_, TRUE);
				_tmp11_ = i;
				i = _tmp11_ + 1;
			}
			_g_object_unref0 (p);
		}
	}
	result = i;
	return result;
}

/** @param n number of interrsections to find per path. */
static Block65Data*
block65_data_ref (Block65Data* _data65_)
{
	g_atomic_int_inc (&_data65_->_ref_count_);
	return _data65_;
}

static void
block65_data_unref (void * _userdata_)
{
	Block65Data* _data65_;
	_data65_ = (Block65Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data65_->_ref_count_)) {
		BirdFontStrokeTool* self;
		self = _data65_->self;
		_g_object_unref0 (_data65_->path2);
		_g_object_unref0 (self);
		g_slice_free (Block65Data, _data65_);
	}
}

static gboolean
__lambda33_ (Block65Data* _data65_,
             BirdFontEditPoint* ep1,
             BirdFontEditPoint* ep2)
{
	BirdFontStrokeTool* self;
	gdouble ix = 0.0;
	gdouble iy = 0.0;
	BirdFontEditPoint* p1 = NULL;
	BirdFontEditPoint* p2 = NULL;
	gboolean i = FALSE;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	BirdFontEditPoint* _tmp2_ = NULL;
	BirdFontEditPoint* _tmp3_ = NULL;
	gboolean _tmp4_;
	gboolean result;
	self = _data65_->self;
	g_return_val_if_fail (ep1 != NULL, FALSE);
	g_return_val_if_fail (ep2 != NULL, FALSE);
	_tmp4_ = bird_font_stroke_tool_segment_intersects (self, _data65_->path2, ep1, ep2, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_, TRUE, FALSE);
	ix = _tmp0_;
	iy = _tmp1_;
	_g_object_unref0 (p1);
	p1 = _tmp2_;
	_g_object_unref0 (p2);
	p2 = _tmp3_;
	i = _tmp4_;
	if (i) {
		_data65_->intersection = TRUE;
	}
	result = !_data65_->intersection;
	_g_object_unref0 (p2);
	_g_object_unref0 (p1);
	return result;
}

static gboolean
___lambda33__bird_font_path_segment_iterator (BirdFontEditPoint* start,
                                              BirdFontEditPoint* stop,
                                              gpointer self)
{
	gboolean result;
	result = __lambda33_ (self, start, stop);
	return result;
}

static gboolean
bird_font_stroke_tool_has_intersection (BirdFontStrokeTool* self,
                                        BirdFontPath* path1,
                                        BirdFontPath* path2)
{
	Block65Data* _data65_;
	BirdFontPath* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path1 != NULL, FALSE);
	g_return_val_if_fail (path2 != NULL, FALSE);
	_data65_ = g_slice_new0 (Block65Data);
	_data65_->_ref_count_ = 1;
	_data65_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (path2);
	_g_object_unref0 (_data65_->path2);
	_data65_->path2 = _tmp0_;
	_data65_->intersection = FALSE;
	if (!bird_font_path_boundaries_intersecting (path1, _data65_->path2)) {
		result = FALSE;
		block65_data_unref (_data65_);
		_data65_ = NULL;
		return result;
	}
	bird_font_path_all_segments (path1, ___lambda33__bird_font_path_segment_iterator, _data65_);
	result = _data65_->intersection;
	block65_data_unref (_data65_);
	_data65_ = NULL;
	return result;
}

static gboolean
bird_font_stroke_tool_paths_has_intersection (BirdFontStrokeTool* self,
                                              BirdFontPathList* r,
                                              BirdFontPath** path1,
                                              BirdFontPath** path2)
{
	BirdFontPath* _vala_path1 = NULL;
	BirdFontPath* _vala_path2 = NULL;
	gint i = 0;
	gint j = 0;
	BirdFontPath* _tmp0_;
	BirdFontPath* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (r != NULL, FALSE);
	_tmp0_ = bird_font_path_new ();
	_g_object_unref0 (_vala_path1);
	_vala_path1 = _tmp0_;
	_tmp1_ = bird_font_path_new ();
	_g_object_unref0 (_vala_path2);
	_vala_path2 = _tmp1_;
	i = 0;
	{
		GeeArrayList* _p1_list = NULL;
		GeeArrayList* _tmp2_;
		gint _p1_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _p1_index = 0;
		_tmp2_ = r->paths;
		_p1_list = _tmp2_;
		_tmp3_ = _p1_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_p1_size = _tmp5_;
		_p1_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			BirdFontPath* p1 = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			gint _tmp27_;
			_p1_index = _p1_index + 1;
			_tmp6_ = _p1_index;
			_tmp7_ = _p1_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _p1_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _p1_index);
			p1 = (BirdFontPath*) _tmp9_;
			j = 0;
			{
				GeeArrayList* _p2_list = NULL;
				GeeArrayList* _tmp10_;
				gint _p2_size = 0;
				GeeArrayList* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				gint _p2_index = 0;
				_tmp10_ = r->paths;
				_p2_list = _tmp10_;
				_tmp11_ = _p2_list;
				_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
				_tmp13_ = _tmp12_;
				_p2_size = _tmp13_;
				_p2_index = -1;
				while (TRUE) {
					gint _tmp14_;
					gint _tmp15_;
					BirdFontPath* p2 = NULL;
					GeeArrayList* _tmp16_;
					gpointer _tmp17_;
					BirdFontPath* _tmp18_;
					BirdFontPath* _tmp19_;
					gint _tmp26_;
					_p2_index = _p2_index + 1;
					_tmp14_ = _p2_index;
					_tmp15_ = _p2_size;
					if (!(_tmp14_ < _tmp15_)) {
						break;
					}
					_tmp16_ = _p2_list;
					_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _p2_index);
					p2 = (BirdFontPath*) _tmp17_;
					_tmp18_ = p1;
					_tmp19_ = p2;
					if (_tmp18_ != _tmp19_) {
						BirdFontPath* _tmp20_;
						BirdFontPath* _tmp21_;
						_tmp20_ = p1;
						_tmp21_ = p2;
						if (bird_font_stroke_tool_has_intersection (self, _tmp20_, _tmp21_)) {
							BirdFontPath* _tmp22_;
							BirdFontPath* _tmp23_;
							BirdFontPath* _tmp24_;
							BirdFontPath* _tmp25_;
							_tmp22_ = p1;
							_tmp23_ = _g_object_ref0 (_tmp22_);
							_g_object_unref0 (_vala_path1);
							_vala_path1 = _tmp23_;
							_tmp24_ = p2;
							_tmp25_ = _g_object_ref0 (_tmp24_);
							_g_object_unref0 (_vala_path2);
							_vala_path2 = _tmp25_;
							result = TRUE;
							_g_object_unref0 (p2);
							_g_object_unref0 (p1);
							if (path1) {
								*path1 = _vala_path1;
							} else {
								_g_object_unref0 (_vala_path1);
							}
							if (path2) {
								*path2 = _vala_path2;
							} else {
								_g_object_unref0 (_vala_path2);
							}
							return result;
						}
					}
					_tmp26_ = j;
					j = _tmp26_ + 1;
					_g_object_unref0 (p2);
				}
			}
			_tmp27_ = i;
			i = _tmp27_ + 1;
			_g_object_unref0 (p1);
		}
	}
	result = FALSE;
	if (path1) {
		*path1 = _vala_path1;
	} else {
		_g_object_unref0 (_vala_path1);
	}
	if (path2) {
		*path2 = _vala_path2;
	} else {
		_g_object_unref0 (_vala_path2);
	}
	return result;
}

gboolean
bird_font_stroke_tool_has_points_outside (BirdFontStrokeTool* self,
                                          BirdFontPathList* pl,
                                          BirdFontPath* p)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (pl != NULL, FALSE);
	g_return_val_if_fail (p != NULL, FALSE);
	_tmp0_ = pl->paths;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != 2) {
		g_warning ("StrokeTool.vala:2761: Stroke should only create two parts.");
		result = FALSE;
		return result;
	}
	{
		GeeArrayList* _path_list = NULL;
		GeeArrayList* _tmp3_;
		gint _path_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _path_index = 0;
		_tmp3_ = pl->paths;
		_path_list = _tmp3_;
		_tmp4_ = _path_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_path_size = _tmp6_;
		_path_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			BirdFontPath* path = NULL;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			BirdFontPath* _tmp11_;
			_path_index = _path_index + 1;
			_tmp7_ = _path_index;
			_tmp8_ = _path_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _path_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _path_index);
			path = (BirdFontPath*) _tmp10_;
			_tmp11_ = path;
			if (_tmp11_ != p) {
				{
					GeeArrayList* _ep_list = NULL;
					GeeArrayList* _tmp12_;
					GeeArrayList* _tmp13_;
					gint _ep_size = 0;
					GeeArrayList* _tmp14_;
					gint _tmp15_;
					gint _tmp16_;
					gint _ep_index = 0;
					_tmp12_ = bird_font_path_get_points (p);
					_tmp13_ = _tmp12_;
					_ep_list = _tmp13_;
					_tmp14_ = _ep_list;
					_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
					_tmp16_ = _tmp15_;
					_ep_size = _tmp16_;
					_ep_index = -1;
					while (TRUE) {
						gint _tmp17_;
						gint _tmp18_;
						BirdFontEditPoint* ep = NULL;
						GeeArrayList* _tmp19_;
						gpointer _tmp20_;
						BirdFontEditPoint* _tmp21_;
						BirdFontPath* _tmp22_;
						_ep_index = _ep_index + 1;
						_tmp17_ = _ep_index;
						_tmp18_ = _ep_size;
						if (!(_tmp17_ < _tmp18_)) {
							break;
						}
						_tmp19_ = _ep_list;
						_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _ep_index);
						ep = (BirdFontEditPoint*) _tmp20_;
						_tmp21_ = ep;
						_tmp22_ = path;
						if (!bird_font_stroke_tool_is_inside (_tmp21_, _tmp22_)) {
							result = TRUE;
							_g_object_unref0 (ep);
							_g_object_unref0 (path);
							return result;
						}
						_g_object_unref0 (ep);
					}
				}
			}
			_g_object_unref0 (path);
		}
	}
	result = FALSE;
	return result;
}

static gboolean
bird_font_stroke_tool_is_clockwise (BirdFontStrokeTool* self,
                                    BirdFontPath* p)
{
	gdouble sum = 0.0;
	BirdFontEditPoint* p1 = NULL;
	BirdFontEditPoint* p2 = NULL;
	BirdFontEditPointHandle* l = NULL;
	BirdFontEditPointHandle* r = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (p != NULL, FALSE);
	sum = (gdouble) 0;
	bird_font_path_recalculate_linear_handles (p);
	_tmp0_ = bird_font_path_get_points (p);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ < 3) {
		result = TRUE;
		_g_object_unref0 (r);
		_g_object_unref0 (l);
		_g_object_unref0 (p2);
		_g_object_unref0 (p1);
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp6_;
				GeeArrayList* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				GeeArrayList* _tmp10_;
				GeeArrayList* _tmp11_;
				gpointer _tmp12_;
				GeeArrayList* _tmp13_;
				GeeArrayList* _tmp14_;
				GeeArrayList* _tmp15_;
				GeeArrayList* _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				gpointer _tmp19_;
				BirdFontEditPoint* _tmp20_;
				BirdFontEditPointHandle* _tmp21_;
				BirdFontEditPointHandle* _tmp22_;
				BirdFontEditPoint* _tmp23_;
				BirdFontEditPointHandle* _tmp24_;
				BirdFontEditPointHandle* _tmp25_;
				gboolean _tmp26_ = FALSE;
				gboolean _tmp27_ = FALSE;
				BirdFontEditPointHandle* _tmp28_;
				BirdFontEditPointHandle* _tmp29_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = bird_font_path_get_points (p);
				_tmp7_ = _tmp6_;
				_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
				_tmp9_ = _tmp8_;
				if (!(i < _tmp9_)) {
					break;
				}
				_tmp10_ = bird_font_path_get_points (p);
				_tmp11_ = _tmp10_;
				_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, i);
				_g_object_unref0 (p1);
				p1 = (BirdFontEditPoint*) _tmp12_;
				_tmp13_ = bird_font_path_get_points (p);
				_tmp14_ = _tmp13_;
				_tmp15_ = bird_font_path_get_points (p);
				_tmp16_ = _tmp15_;
				_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, (i + 1) % _tmp18_);
				_g_object_unref0 (p2);
				p2 = (BirdFontEditPoint*) _tmp19_;
				_tmp20_ = p1;
				_tmp21_ = bird_font_edit_point_get_left_handle (_tmp20_);
				_tmp22_ = _g_object_ref0 (_tmp21_);
				_g_object_unref0 (l);
				l = _tmp22_;
				_tmp23_ = p1;
				_tmp24_ = bird_font_edit_point_get_right_handle (_tmp23_);
				_tmp25_ = _g_object_ref0 (_tmp24_);
				_g_object_unref0 (r);
				r = _tmp25_;
				_tmp28_ = l;
				_tmp29_ = r;
				if (fabs (_tmp28_->angle - _tmp29_->angle) < 0.0001) {
					BirdFontEditPointHandle* _tmp30_;
					_tmp30_ = l;
					_tmp27_ = _tmp30_->length > 0.01;
				} else {
					_tmp27_ = FALSE;
				}
				if (_tmp27_) {
					BirdFontEditPointHandle* _tmp31_;
					_tmp31_ = r;
					_tmp26_ = _tmp31_->length > 0.01;
				} else {
					_tmp26_ = FALSE;
				}
				if (!_tmp26_) {
					BirdFontEditPoint* _tmp32_;
					BirdFontEditPoint* _tmp33_;
					BirdFontEditPoint* _tmp34_;
					BirdFontEditPoint* _tmp35_;
					_tmp32_ = p2;
					_tmp33_ = p1;
					_tmp34_ = p2;
					_tmp35_ = p1;
					sum += (_tmp32_->x - _tmp33_->x) * (_tmp34_->y + _tmp35_->y);
				}
			}
		}
	}
	result = sum > ((gdouble) 0);
	_g_object_unref0 (r);
	_g_object_unref0 (l);
	_g_object_unref0 (p2);
	_g_object_unref0 (p1);
	return result;
}

BirdFontPathList*
bird_font_stroke_tool_create_stroke (BirdFontStrokeTool* self,
                                     BirdFontPath* original_path,
                                     gdouble thickness)
{
	BirdFontPathList* pl = NULL;
	BirdFontEditPoint* p1 = NULL;
	BirdFontEditPoint* p2 = NULL;
	BirdFontEditPoint* p3 = NULL;
	BirdFontEditPoint* previous = NULL;
	BirdFontEditPoint* previous_inside = NULL;
	BirdFontEditPoint* start = NULL;
	BirdFontEditPoint* start_inside = NULL;
	BirdFontPath* side1 = NULL;
	BirdFontPath* side2 = NULL;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble x2 = 0.0;
	gdouble y2 = 0.0;
	gdouble x3 = 0.0;
	gdouble y3 = 0.0;
	gint size = 0;
	gboolean flat = FALSE;
	gboolean f_next = FALSE;
	gboolean f_bigger = FALSE;
	gint i = 0;
	gdouble tolerance = 0.0;
	gdouble step_increment = 0.0;
	gdouble step_size = 0.0;
	BirdFontEditPoint* corner1 = NULL;
	BirdFontEditPoint* corner1_inside = NULL;
	gdouble step = 0.0;
	gdouble min_increment = 0.0;
	BirdFontEditPointHandle* l = NULL;
	BirdFontEditPointHandle* r = NULL;
	BirdFontPath* path = NULL;
	BirdFontPath* _tmp0_;
	gint keep = 0;
	gboolean on_curve = FALSE;
	BirdFontPathList* _tmp1_;
	gint _tmp2_ = 0;
	BirdFontPath* _tmp3_;
	BirdFontPath* _tmp14_;
	BirdFontPath* _tmp15_;
	BirdFontPath* _tmp28_;
	BirdFontPath* _tmp29_;
	GeeArrayList* _tmp30_;
	GeeArrayList* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	BirdFontEditPoint* _tmp34_;
	BirdFontEditPoint* _tmp35_;
	BirdFontEditPoint* _tmp36_;
	BirdFontEditPoint* _tmp37_;
	BirdFontPath* _tmp38_;
	BirdFontPath* _tmp299_;
	BirdFontPath* _tmp300_;
	BirdFontPath* _tmp301_;
	BirdFontPath* _tmp302_;
	BirdFontPath* _tmp303_;
	BirdFontPath* _tmp304_;
	BirdFontPath* _tmp305_;
	BirdFontPath* _tmp306_;
	BirdFontPathList* _tmp307_;
	BirdFontPathList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (original_path != NULL, NULL);
	_tmp0_ = bird_font_path_copy (original_path);
	path = _tmp0_;
	_tmp1_ = bird_font_path_list_new ();
	_g_object_unref0 (pl);
	pl = _tmp1_;
	_tmp3_ = path;
	if (bird_font_path_is_open (_tmp3_)) {
		BirdFontPath* _tmp4_;
		GeeArrayList* _tmp5_;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp4_ = path;
		_tmp5_ = bird_font_path_get_points (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ - 1;
	} else {
		BirdFontPath* _tmp9_;
		GeeArrayList* _tmp10_;
		GeeArrayList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp9_ = path;
		_tmp10_ = bird_font_path_get_points (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp2_ = _tmp13_;
	}
	size = _tmp2_;
	_tmp14_ = bird_font_path_new ();
	_g_object_unref0 (side1);
	side1 = _tmp14_;
	_tmp15_ = bird_font_path_new ();
	_g_object_unref0 (side2);
	side2 = _tmp15_;
	{
		GeeArrayList* _ph_list = NULL;
		BirdFontPath* _tmp16_;
		GeeArrayList* _tmp17_;
		GeeArrayList* _tmp18_;
		gint _ph_size = 0;
		GeeArrayList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _ph_index = 0;
		_tmp16_ = path;
		_tmp17_ = bird_font_path_get_points (_tmp16_);
		_tmp18_ = _tmp17_;
		_ph_list = _tmp18_;
		_tmp19_ = _ph_list;
		_tmp20_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_ph_size = _tmp21_;
		_ph_index = -1;
		while (TRUE) {
			gint _tmp22_;
			gint _tmp23_;
			BirdFontEditPoint* ph = NULL;
			GeeArrayList* _tmp24_;
			gpointer _tmp25_;
			BirdFontEditPoint* _tmp26_;
			_ph_index = _ph_index + 1;
			_tmp22_ = _ph_index;
			_tmp23_ = _ph_size;
			if (!(_tmp22_ < _tmp23_)) {
				break;
			}
			_tmp24_ = _ph_list;
			_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp24_, _ph_index);
			ph = (BirdFontEditPoint*) _tmp25_;
			_tmp26_ = ph;
			if (_tmp26_->type == BIRD_FONT_POINT_TYPE_HIDDEN) {
				BirdFontEditPoint* _tmp27_;
				_tmp27_ = ph;
				_tmp27_->type = BIRD_FONT_POINT_TYPE_CUBIC;
			}
			_g_object_unref0 (ph);
		}
	}
	_tmp28_ = path;
	bird_font_path_remove_deleted_points (_tmp28_);
	_tmp29_ = path;
	_tmp30_ = bird_font_path_get_points (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp31_);
	_tmp33_ = _tmp32_;
	if (_tmp33_ < 2) {
		result = pl;
		_g_object_unref0 (path);
		_g_object_unref0 (r);
		_g_object_unref0 (l);
		_g_object_unref0 (corner1_inside);
		_g_object_unref0 (corner1);
		_g_object_unref0 (side2);
		_g_object_unref0 (side1);
		_g_object_unref0 (start_inside);
		_g_object_unref0 (start);
		_g_object_unref0 (previous_inside);
		_g_object_unref0 (previous);
		_g_object_unref0 (p3);
		_g_object_unref0 (p2);
		_g_object_unref0 (p1);
		return result;
	}
	_tmp34_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
	_g_object_unref0 (previous);
	previous = _tmp34_;
	_tmp35_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
	_g_object_unref0 (previous_inside);
	previous_inside = _tmp35_;
	_tmp36_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
	_g_object_unref0 (corner1);
	corner1 = _tmp36_;
	_tmp37_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
	_g_object_unref0 (corner1_inside);
	corner1_inside = _tmp37_;
	_tmp38_ = path;
	if (bird_font_path_is_open (_tmp38_)) {
		BirdFontPath* _tmp39_;
		GeeArrayList* _tmp40_;
		GeeArrayList* _tmp41_;
		gpointer _tmp42_;
		BirdFontPath* _tmp43_;
		GeeArrayList* _tmp44_;
		GeeArrayList* _tmp45_;
		BirdFontPath* _tmp46_;
		GeeArrayList* _tmp47_;
		GeeArrayList* _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
		gpointer _tmp51_;
		BirdFontEditPoint* _tmp52_;
		BirdFontEditPoint* _tmp53_;
		BirdFontEditPoint* _tmp54_ = NULL;
		BirdFontEditPoint* _tmp55_;
		BirdFontEditPoint* _tmp56_;
		BirdFontEditPoint* _tmp57_ = NULL;
		BirdFontEditPoint* _tmp58_;
		BirdFontEditPoint* _tmp59_;
		BirdFontEditPoint* _tmp60_;
		BirdFontEditPoint* _tmp61_;
		BirdFontEditPoint* _tmp62_;
		BirdFontEditPoint* _tmp63_;
		BirdFontEditPoint* _tmp64_;
		BirdFontEditPoint* _tmp65_;
		BirdFontPath* _tmp66_;
		BirdFontEditPoint* _tmp67_;
		BirdFontEditPoint* _tmp68_;
		BirdFontEditPoint* _tmp69_;
		BirdFontPath* _tmp70_;
		BirdFontEditPoint* _tmp71_;
		BirdFontEditPoint* _tmp72_;
		BirdFontEditPoint* _tmp73_;
		_tmp39_ = path;
		_tmp40_ = bird_font_path_get_points (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = gee_abstract_list_get ((GeeAbstractList*) _tmp41_, 0);
		_g_object_unref0 (p1);
		p1 = (BirdFontEditPoint*) _tmp42_;
		_tmp43_ = path;
		_tmp44_ = bird_font_path_get_points (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = path;
		_tmp47_ = bird_font_path_get_points (_tmp46_);
		_tmp48_ = _tmp47_;
		_tmp49_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = gee_abstract_list_get ((GeeAbstractList*) _tmp45_, 1 % _tmp50_);
		_g_object_unref0 (p2);
		p2 = (BirdFontEditPoint*) _tmp51_;
		_tmp52_ = p1;
		_tmp53_ = p2;
		bird_font_stroke_tool_get_segment (self, thickness, (gdouble) 0, 0.00001, _tmp52_, _tmp53_, &_tmp54_);
		_g_object_unref0 (start);
		start = _tmp54_;
		_tmp55_ = p1;
		_tmp56_ = p2;
		bird_font_stroke_tool_get_segment (self, -thickness, (gdouble) 0, 0.00001, _tmp55_, _tmp56_, &_tmp57_);
		_g_object_unref0 (start_inside);
		start_inside = _tmp57_;
		_tmp58_ = start;
		_tmp59_ = bird_font_edit_point_copy (_tmp58_);
		_g_object_unref0 (previous);
		previous = _tmp59_;
		_tmp60_ = start_inside;
		_tmp61_ = bird_font_edit_point_copy (_tmp60_);
		_g_object_unref0 (previous_inside);
		previous_inside = _tmp61_;
		_tmp62_ = previous;
		_tmp63_ = previous;
		_tmp63_->flags = _tmp63_->flags | BIRD_FONT_EDIT_POINT_CURVE_KEEP;
		_tmp64_ = previous_inside;
		_tmp65_ = previous_inside;
		_tmp65_->flags = _tmp65_->flags | BIRD_FONT_EDIT_POINT_CURVE_KEEP;
		_tmp66_ = side1;
		_tmp67_ = previous;
		_tmp68_ = bird_font_path_add_point (_tmp66_, _tmp67_);
		_tmp69_ = _tmp68_;
		_g_object_unref0 (_tmp69_);
		_tmp70_ = side2;
		_tmp71_ = previous_inside;
		_tmp72_ = bird_font_path_add_point (_tmp70_, _tmp71_);
		_tmp73_ = _tmp72_;
		_g_object_unref0 (_tmp73_);
	}
	min_increment = 0.02;
	{
		gboolean _tmp74_ = FALSE;
		i = 0;
		_tmp74_ = TRUE;
		while (TRUE) {
			BirdFontPath* _tmp76_;
			GeeArrayList* _tmp77_;
			GeeArrayList* _tmp78_;
			BirdFontPath* _tmp79_;
			GeeArrayList* _tmp80_;
			GeeArrayList* _tmp81_;
			gint _tmp82_;
			gint _tmp83_;
			gpointer _tmp84_;
			BirdFontPath* _tmp85_;
			GeeArrayList* _tmp86_;
			GeeArrayList* _tmp87_;
			BirdFontPath* _tmp88_;
			GeeArrayList* _tmp89_;
			GeeArrayList* _tmp90_;
			gint _tmp91_;
			gint _tmp92_;
			gpointer _tmp93_;
			BirdFontPath* _tmp94_;
			GeeArrayList* _tmp95_;
			GeeArrayList* _tmp96_;
			BirdFontPath* _tmp97_;
			GeeArrayList* _tmp98_;
			GeeArrayList* _tmp99_;
			gint _tmp100_;
			gint _tmp101_;
			gpointer _tmp102_;
			BirdFontStrokeTask* _tmp103_;
			BirdFontEditPoint* _tmp105_;
			gboolean _tmp106_ = FALSE;
			BirdFontEditPoint* _tmp107_;
			BirdFontEditPoint* _tmp109_;
			BirdFontEditPoint* _tmp110_;
			BirdFontEditPoint* _tmp111_ = NULL;
			BirdFontEditPoint* _tmp112_;
			BirdFontEditPoint* _tmp113_;
			BirdFontEditPoint* _tmp114_ = NULL;
			BirdFontEditPoint* _tmp115_;
			BirdFontEditPoint* _tmp116_;
			BirdFontEditPoint* _tmp117_;
			BirdFontEditPoint* _tmp118_;
			BirdFontEditPoint* _tmp119_;
			BirdFontEditPoint* _tmp120_;
			BirdFontEditPoint* _tmp121_;
			BirdFontEditPoint* _tmp122_;
			BirdFontPath* _tmp123_;
			BirdFontEditPoint* _tmp124_;
			BirdFontEditPoint* _tmp125_;
			BirdFontEditPoint* _tmp126_;
			BirdFontPath* _tmp127_;
			BirdFontEditPoint* _tmp128_;
			BirdFontEditPoint* _tmp129_;
			BirdFontEditPoint* _tmp130_;
			BirdFontEditPoint* _tmp217_;
			BirdFontEditPointHandle* _tmp218_;
			BirdFontEditPoint* _tmp219_;
			BirdFontEditPointHandle* _tmp220_;
			BirdFontEditPoint* _tmp221_;
			BirdFontEditPointHandle* _tmp222_;
			BirdFontEditPoint* _tmp223_;
			BirdFontEditPointHandle* _tmp224_;
			BirdFontEditPoint* _tmp225_;
			BirdFontEditPointHandle* _tmp226_;
			BirdFontEditPoint* _tmp227_;
			BirdFontEditPointHandle* _tmp228_;
			BirdFontEditPoint* _tmp229_;
			BirdFontEditPointHandle* _tmp230_;
			BirdFontEditPoint* _tmp231_;
			BirdFontEditPointHandle* _tmp232_;
			BirdFontEditPoint* _tmp233_;
			BirdFontEditPoint* _tmp234_;
			BirdFontEditPoint* _tmp235_ = NULL;
			BirdFontEditPoint* _tmp236_;
			BirdFontEditPoint* _tmp237_;
			BirdFontEditPoint* _tmp238_ = NULL;
			BirdFontEditPoint* _tmp239_;
			BirdFontEditPoint* _tmp240_;
			BirdFontEditPoint* _tmp241_;
			BirdFontEditPoint* _tmp242_;
			BirdFontEditPoint* _tmp243_;
			BirdFontEditPointHandle* _tmp244_;
			BirdFontEditPoint* _tmp245_;
			BirdFontEditPointHandle* _tmp246_;
			BirdFontEditPoint* _tmp247_;
			BirdFontEditPointHandle* _tmp248_;
			BirdFontEditPoint* _tmp249_;
			BirdFontEditPointHandle* _tmp250_;
			BirdFontEditPoint* _tmp251_;
			BirdFontEditPointHandle* _tmp252_;
			BirdFontEditPoint* _tmp253_;
			BirdFontEditPointHandle* _tmp254_;
			BirdFontEditPoint* _tmp255_;
			BirdFontEditPointHandle* _tmp256_;
			BirdFontEditPoint* _tmp257_;
			BirdFontEditPointHandle* _tmp258_;
			BirdFontEditPoint* _tmp259_;
			BirdFontEditPoint* _tmp260_;
			BirdFontEditPoint* _tmp261_;
			BirdFontEditPoint* _tmp262_;
			BirdFontPath* _tmp263_;
			BirdFontEditPoint* _tmp264_;
			BirdFontEditPoint* _tmp265_;
			BirdFontEditPoint* _tmp266_;
			BirdFontPath* _tmp267_;
			BirdFontEditPoint* _tmp268_;
			BirdFontEditPoint* _tmp269_;
			BirdFontEditPoint* _tmp270_;
			BirdFontEditPoint* _tmp271_;
			BirdFontEditPointHandle* _tmp272_;
			BirdFontEditPointHandle* _tmp273_;
			BirdFontEditPoint* _tmp274_;
			BirdFontEditPointHandle* _tmp275_;
			BirdFontEditPointHandle* _tmp276_;
			BirdFontEditPointHandle* _tmp277_;
			BirdFontEditPointHandle* _tmp278_;
			if (!_tmp74_) {
				gint _tmp75_;
				_tmp75_ = i;
				i = _tmp75_ + 1;
			}
			_tmp74_ = FALSE;
			if (!(i < size)) {
				break;
			}
			_tmp76_ = path;
			_tmp77_ = bird_font_path_get_points (_tmp76_);
			_tmp78_ = _tmp77_;
			_tmp79_ = path;
			_tmp80_ = bird_font_path_get_points (_tmp79_);
			_tmp81_ = _tmp80_;
			_tmp82_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp81_);
			_tmp83_ = _tmp82_;
			_tmp84_ = gee_abstract_list_get ((GeeAbstractList*) _tmp78_, i % _tmp83_);
			_g_object_unref0 (p1);
			p1 = (BirdFontEditPoint*) _tmp84_;
			_tmp85_ = path;
			_tmp86_ = bird_font_path_get_points (_tmp85_);
			_tmp87_ = _tmp86_;
			_tmp88_ = path;
			_tmp89_ = bird_font_path_get_points (_tmp88_);
			_tmp90_ = _tmp89_;
			_tmp91_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp90_);
			_tmp92_ = _tmp91_;
			_tmp93_ = gee_abstract_list_get ((GeeAbstractList*) _tmp87_, (i + 1) % _tmp92_);
			_g_object_unref0 (p2);
			p2 = (BirdFontEditPoint*) _tmp93_;
			_tmp94_ = path;
			_tmp95_ = bird_font_path_get_points (_tmp94_);
			_tmp96_ = _tmp95_;
			_tmp97_ = path;
			_tmp98_ = bird_font_path_get_points (_tmp97_);
			_tmp99_ = _tmp98_;
			_tmp100_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp99_);
			_tmp101_ = _tmp100_;
			_tmp102_ = gee_abstract_list_get ((GeeAbstractList*) _tmp96_, (i + 2) % _tmp101_);
			_g_object_unref0 (p3);
			p3 = (BirdFontEditPoint*) _tmp102_;
			_tmp103_ = self->priv->task;
			if (G_UNLIKELY (bird_font_task_is_cancelled ((BirdFontTask*) _tmp103_))) {
				BirdFontPathList* _tmp104_;
				_tmp104_ = bird_font_path_list_new ();
				result = _tmp104_;
				_g_object_unref0 (path);
				_g_object_unref0 (r);
				_g_object_unref0 (l);
				_g_object_unref0 (corner1_inside);
				_g_object_unref0 (corner1);
				_g_object_unref0 (side2);
				_g_object_unref0 (side1);
				_g_object_unref0 (start_inside);
				_g_object_unref0 (start);
				_g_object_unref0 (previous_inside);
				_g_object_unref0 (previous);
				_g_object_unref0 (p3);
				_g_object_unref0 (p2);
				_g_object_unref0 (p1);
				_g_object_unref0 (pl);
				return result;
			}
			tolerance = 0.01;
			step_increment = 1.05;
			step_size = 0.039;
			_tmp105_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
			_g_object_unref0 (corner1);
			corner1 = _tmp105_;
			_tmp107_ = p1;
			if (_tmp107_->type == BIRD_FONT_POINT_TYPE_HIDDEN) {
				_tmp106_ = TRUE;
			} else {
				BirdFontEditPoint* _tmp108_;
				_tmp108_ = p2;
				_tmp106_ = _tmp108_->type == BIRD_FONT_POINT_TYPE_HIDDEN;
			}
			if (_tmp106_) {
				continue;
			}
			_tmp109_ = p1;
			_tmp110_ = p2;
			bird_font_stroke_tool_get_segment (self, thickness, (gdouble) 0, 0.00001, _tmp109_, _tmp110_, &_tmp111_);
			_g_object_unref0 (start);
			start = _tmp111_;
			_tmp112_ = p1;
			_tmp113_ = p2;
			bird_font_stroke_tool_get_segment (self, -thickness, (gdouble) 0, 0.00001, _tmp112_, _tmp113_, &_tmp114_);
			_g_object_unref0 (start_inside);
			start_inside = _tmp114_;
			_tmp115_ = start;
			_tmp116_ = bird_font_edit_point_copy (_tmp115_);
			_g_object_unref0 (previous);
			previous = _tmp116_;
			_tmp117_ = start_inside;
			_tmp118_ = bird_font_edit_point_copy (_tmp117_);
			_g_object_unref0 (previous_inside);
			previous_inside = _tmp118_;
			_tmp119_ = previous;
			_tmp120_ = previous;
			_tmp120_->flags = _tmp120_->flags | (BIRD_FONT_EDIT_POINT_CURVE | BIRD_FONT_EDIT_POINT_SEGMENT_END);
			_tmp121_ = previous_inside;
			_tmp122_ = previous_inside;
			_tmp122_->flags = _tmp122_->flags | (BIRD_FONT_EDIT_POINT_CURVE | BIRD_FONT_EDIT_POINT_SEGMENT_END);
			_tmp123_ = side1;
			_tmp124_ = previous;
			_tmp125_ = bird_font_path_add_point (_tmp123_, _tmp124_);
			_tmp126_ = _tmp125_;
			_g_object_unref0 (_tmp126_);
			_tmp127_ = side2;
			_tmp128_ = previous_inside;
			_tmp129_ = bird_font_path_add_point (_tmp127_, _tmp128_);
			_tmp130_ = _tmp129_;
			_g_object_unref0 (_tmp130_);
			step = step_size;
			keep = 0;
			step_size = 0.05;
			while (TRUE) {
				BirdFontEditPoint* _tmp131_;
				BirdFontEditPoint* _tmp132_;
				gdouble _tmp133_ = 0.0;
				gdouble _tmp134_ = 0.0;
				BirdFontEditPoint* _tmp135_;
				BirdFontEditPoint* _tmp136_;
				gdouble _tmp137_ = 0.0;
				gdouble _tmp138_ = 0.0;
				BirdFontEditPoint* _tmp139_;
				BirdFontEditPoint* _tmp140_;
				gdouble _tmp141_ = 0.0;
				gdouble _tmp142_ = 0.0;
				BirdFontEditPoint* _tmp143_;
				BirdFontEditPoint* _tmp144_;
				gdouble _tmp145_ = 0.0;
				gdouble _tmp146_ = 0.0;
				BirdFontEditPoint* _tmp147_;
				BirdFontEditPoint* _tmp148_;
				gdouble _tmp149_ = 0.0;
				gdouble _tmp150_ = 0.0;
				BirdFontEditPoint* _tmp151_;
				BirdFontEditPoint* _tmp152_;
				gdouble _tmp153_ = 0.0;
				gdouble _tmp154_ = 0.0;
				BirdFontEditPoint* _tmp155_;
				BirdFontEditPoint* _tmp156_;
				gdouble _tmp157_ = 0.0;
				gdouble _tmp158_ = 0.0;
				BirdFontEditPoint* _tmp159_;
				BirdFontEditPoint* _tmp160_;
				gdouble _tmp161_ = 0.0;
				gdouble _tmp162_ = 0.0;
				BirdFontEditPoint* _tmp163_;
				BirdFontEditPoint* _tmp164_;
				gdouble _tmp165_ = 0.0;
				gdouble _tmp166_ = 0.0;
				gboolean _tmp167_ = FALSE;
				gboolean _tmp168_ = FALSE;
				gboolean _tmp169_ = FALSE;
				gboolean _tmp170_ = FALSE;
				BirdFontEditPoint* _tmp171_;
				BirdFontEditPoint* _tmp172_;
				BirdFontEditPoint* _tmp173_ = NULL;
				BirdFontEditPoint* _tmp174_;
				BirdFontEditPoint* _tmp175_;
				BirdFontEditPoint* _tmp176_ = NULL;
				BirdFontEditPoint* _tmp177_;
				BirdFontEditPointHandle* _tmp178_;
				BirdFontEditPoint* _tmp179_;
				BirdFontEditPointHandle* _tmp180_;
				BirdFontEditPoint* _tmp181_;
				BirdFontEditPointHandle* _tmp182_;
				BirdFontEditPoint* _tmp183_;
				BirdFontEditPointHandle* _tmp184_;
				BirdFontEditPoint* _tmp185_;
				BirdFontEditPointHandle* _tmp186_;
				BirdFontEditPoint* _tmp187_;
				BirdFontEditPointHandle* _tmp188_;
				BirdFontEditPoint* _tmp189_;
				BirdFontEditPointHandle* _tmp190_;
				BirdFontEditPoint* _tmp191_;
				BirdFontEditPointHandle* _tmp192_;
				BirdFontEditPoint* _tmp193_;
				BirdFontEditPoint* _tmp194_;
				BirdFontEditPoint* _tmp195_;
				BirdFontEditPoint* _tmp196_;
				gboolean _tmp197_ = FALSE;
				BirdFontPath* _tmp209_;
				BirdFontEditPoint* _tmp210_;
				BirdFontEditPoint* _tmp211_;
				BirdFontEditPoint* _tmp212_;
				BirdFontPath* _tmp213_;
				BirdFontEditPoint* _tmp214_;
				BirdFontEditPoint* _tmp215_;
				BirdFontEditPoint* _tmp216_;
				if (!(step < (1 - (2 * step_size)))) {
					break;
				}
				_tmp131_ = p1;
				_tmp132_ = p2;
				bird_font_path_get_point_for_step (_tmp131_, _tmp132_, step, &_tmp133_, &_tmp134_);
				x = _tmp133_;
				y = _tmp134_;
				_tmp135_ = p1;
				_tmp136_ = p2;
				bird_font_path_get_point_for_step (_tmp135_, _tmp136_, step + step_size, &_tmp137_, &_tmp138_);
				x2 = _tmp137_;
				y2 = _tmp138_;
				_tmp139_ = p1;
				_tmp140_ = p2;
				bird_font_path_get_point_for_step (_tmp139_, _tmp140_, step + (2 * step_size), &_tmp141_, &_tmp142_);
				x3 = _tmp141_;
				y3 = _tmp142_;
				flat = bird_font_stroke_tool_is_flat (x, y, x2, y2, x3, y3, tolerance);
				_tmp143_ = p1;
				_tmp144_ = p2;
				bird_font_path_get_point_for_step (_tmp143_, _tmp144_, step, &_tmp145_, &_tmp146_);
				x = _tmp145_;
				y = _tmp146_;
				_tmp147_ = p1;
				_tmp148_ = p2;
				bird_font_path_get_point_for_step (_tmp147_, _tmp148_, step + (step_size / step_increment), &_tmp149_, &_tmp150_);
				x2 = _tmp149_;
				y2 = _tmp150_;
				_tmp151_ = p1;
				_tmp152_ = p2;
				bird_font_path_get_point_for_step (_tmp151_, _tmp152_, step + ((2 * step_size) / step_increment), &_tmp153_, &_tmp154_);
				x3 = _tmp153_;
				y3 = _tmp154_;
				f_next = bird_font_stroke_tool_is_flat (x, y, x2, y2, x3, y3, tolerance);
				_tmp155_ = p1;
				_tmp156_ = p2;
				bird_font_path_get_point_for_step (_tmp155_, _tmp156_, step, &_tmp157_, &_tmp158_);
				x = _tmp157_;
				y = _tmp158_;
				_tmp159_ = p1;
				_tmp160_ = p2;
				bird_font_path_get_point_for_step (_tmp159_, _tmp160_, step + (step_size * step_increment), &_tmp161_, &_tmp162_);
				x2 = _tmp161_;
				y2 = _tmp162_;
				_tmp163_ = p1;
				_tmp164_ = p2;
				bird_font_path_get_point_for_step (_tmp163_, _tmp164_, step + ((2 * step_size) * step_increment), &_tmp165_, &_tmp166_);
				x3 = _tmp165_;
				y3 = _tmp166_;
				f_bigger = bird_font_stroke_tool_is_flat (x, y, x2, y2, x3, y3, tolerance);
				if (!flat) {
					_tmp168_ = !f_next;
				} else {
					_tmp168_ = FALSE;
				}
				if (_tmp168_) {
					_tmp167_ = step_size > min_increment;
				} else {
					_tmp167_ = FALSE;
				}
				if (_tmp167_) {
					step_size /= step_increment;
					continue;
				}
				if (flat) {
					_tmp170_ = f_bigger;
				} else {
					_tmp170_ = FALSE;
				}
				if (_tmp170_) {
					_tmp169_ = step_size < 0.1;
				} else {
					_tmp169_ = FALSE;
				}
				if (_tmp169_) {
					step_size *= step_increment;
					continue;
				}
				_tmp171_ = p1;
				_tmp172_ = p2;
				bird_font_stroke_tool_get_segment (self, thickness, step, step_size, _tmp171_, _tmp172_, &_tmp173_);
				_g_object_unref0 (corner1);
				corner1 = _tmp173_;
				_tmp174_ = p1;
				_tmp175_ = p2;
				bird_font_stroke_tool_get_segment (self, -thickness, step, step_size, _tmp174_, _tmp175_, &_tmp176_);
				_g_object_unref0 (corner1_inside);
				corner1_inside = _tmp176_;
				_tmp177_ = previous;
				_tmp178_ = bird_font_edit_point_get_right_handle (_tmp177_);
				_tmp179_ = previous;
				_tmp180_ = bird_font_edit_point_get_right_handle (_tmp179_);
				_tmp180_->length = _tmp180_->length * step_size;
				_tmp181_ = corner1;
				_tmp182_ = bird_font_edit_point_get_left_handle (_tmp181_);
				_tmp183_ = corner1;
				_tmp184_ = bird_font_edit_point_get_left_handle (_tmp183_);
				_tmp184_->length = _tmp184_->length * step_size;
				_tmp185_ = previous_inside;
				_tmp186_ = bird_font_edit_point_get_right_handle (_tmp185_);
				_tmp187_ = previous_inside;
				_tmp188_ = bird_font_edit_point_get_right_handle (_tmp187_);
				_tmp188_->length = _tmp188_->length * step_size;
				_tmp189_ = corner1_inside;
				_tmp190_ = bird_font_edit_point_get_left_handle (_tmp189_);
				_tmp191_ = corner1_inside;
				_tmp192_ = bird_font_edit_point_get_left_handle (_tmp191_);
				_tmp192_->length = _tmp192_->length * step_size;
				_tmp193_ = corner1;
				_tmp194_ = bird_font_edit_point_copy (_tmp193_);
				_g_object_unref0 (previous);
				previous = _tmp194_;
				_tmp195_ = corner1_inside;
				_tmp196_ = bird_font_edit_point_copy (_tmp195_);
				_g_object_unref0 (previous_inside);
				previous_inside = _tmp196_;
				if (keep == 0) {
					_tmp197_ = step > 0.3;
				} else {
					_tmp197_ = FALSE;
				}
				if (_tmp197_) {
					gint _tmp198_;
					on_curve = TRUE;
					_tmp198_ = keep;
					keep = _tmp198_ + 1;
				} else {
					gboolean _tmp199_ = FALSE;
					if (keep == 1) {
						_tmp199_ = step > 0.6;
					} else {
						_tmp199_ = FALSE;
					}
					if (_tmp199_) {
						gint _tmp200_;
						on_curve = TRUE;
						_tmp200_ = keep;
						keep = _tmp200_ + 1;
					} else {
						on_curve = FALSE;
					}
				}
				if (!on_curve) {
					BirdFontEditPoint* _tmp201_;
					BirdFontEditPoint* _tmp202_;
					BirdFontEditPoint* _tmp203_;
					BirdFontEditPoint* _tmp204_;
					_tmp201_ = previous;
					_tmp202_ = previous;
					_tmp202_->flags = _tmp202_->flags | BIRD_FONT_EDIT_POINT_CURVE;
					_tmp203_ = previous_inside;
					_tmp204_ = previous_inside;
					_tmp204_->flags = _tmp204_->flags | BIRD_FONT_EDIT_POINT_CURVE;
				} else {
					BirdFontEditPoint* _tmp205_;
					BirdFontEditPoint* _tmp206_;
					BirdFontEditPoint* _tmp207_;
					BirdFontEditPoint* _tmp208_;
					_tmp205_ = previous;
					_tmp206_ = previous;
					_tmp206_->flags = _tmp206_->flags | BIRD_FONT_EDIT_POINT_CURVE_KEEP;
					_tmp207_ = previous_inside;
					_tmp208_ = previous_inside;
					_tmp208_->flags = _tmp208_->flags | BIRD_FONT_EDIT_POINT_CURVE_KEEP;
				}
				_tmp209_ = side1;
				_tmp210_ = previous;
				_tmp211_ = bird_font_path_add_point (_tmp209_, _tmp210_);
				_tmp212_ = _tmp211_;
				_g_object_unref0 (_tmp212_);
				_tmp213_ = side2;
				_tmp214_ = previous_inside;
				_tmp215_ = bird_font_path_add_point (_tmp213_, _tmp214_);
				_tmp216_ = _tmp215_;
				_g_object_unref0 (_tmp216_);
				step += step_size;
			}
			_tmp217_ = previous;
			_tmp218_ = bird_font_edit_point_get_right_handle (_tmp217_);
			_tmp219_ = previous;
			_tmp220_ = bird_font_edit_point_get_right_handle (_tmp219_);
			_tmp220_->length = _tmp220_->length * step_size;
			_tmp221_ = corner1;
			_tmp222_ = bird_font_edit_point_get_left_handle (_tmp221_);
			_tmp223_ = corner1;
			_tmp224_ = bird_font_edit_point_get_left_handle (_tmp223_);
			_tmp224_->length = _tmp224_->length * step_size;
			_tmp225_ = previous_inside;
			_tmp226_ = bird_font_edit_point_get_right_handle (_tmp225_);
			_tmp227_ = previous_inside;
			_tmp228_ = bird_font_edit_point_get_right_handle (_tmp227_);
			_tmp228_->length = _tmp228_->length * step_size;
			_tmp229_ = corner1_inside;
			_tmp230_ = bird_font_edit_point_get_left_handle (_tmp229_);
			_tmp231_ = corner1_inside;
			_tmp232_ = bird_font_edit_point_get_left_handle (_tmp231_);
			_tmp232_->length = _tmp232_->length * step_size;
			_tmp233_ = p1;
			_tmp234_ = p2;
			bird_font_stroke_tool_get_segment (self, thickness, 1 - 0.00001, 0.00001, _tmp233_, _tmp234_, &_tmp235_);
			_g_object_unref0 (corner1);
			corner1 = _tmp235_;
			_tmp236_ = p1;
			_tmp237_ = p2;
			bird_font_stroke_tool_get_segment (self, -thickness, 1 - 0.00001, 0.00001, _tmp236_, _tmp237_, &_tmp238_);
			_g_object_unref0 (corner1_inside);
			corner1_inside = _tmp238_;
			_tmp239_ = corner1;
			_tmp240_ = bird_font_edit_point_copy (_tmp239_);
			_g_object_unref0 (previous);
			previous = _tmp240_;
			_tmp241_ = corner1_inside;
			_tmp242_ = bird_font_edit_point_copy (_tmp241_);
			_g_object_unref0 (previous_inside);
			previous_inside = _tmp242_;
			_tmp243_ = previous;
			_tmp244_ = bird_font_edit_point_get_right_handle (_tmp243_);
			_tmp245_ = previous;
			_tmp246_ = bird_font_edit_point_get_right_handle (_tmp245_);
			_tmp246_->length = _tmp246_->length * step_size;
			_tmp247_ = previous;
			_tmp248_ = bird_font_edit_point_get_left_handle (_tmp247_);
			_tmp249_ = previous;
			_tmp250_ = bird_font_edit_point_get_left_handle (_tmp249_);
			_tmp250_->length = _tmp250_->length * step_size;
			_tmp251_ = previous_inside;
			_tmp252_ = bird_font_edit_point_get_right_handle (_tmp251_);
			_tmp253_ = previous_inside;
			_tmp254_ = bird_font_edit_point_get_right_handle (_tmp253_);
			_tmp254_->length = _tmp254_->length * step_size;
			_tmp255_ = previous_inside;
			_tmp256_ = bird_font_edit_point_get_left_handle (_tmp255_);
			_tmp257_ = previous_inside;
			_tmp258_ = bird_font_edit_point_get_left_handle (_tmp257_);
			_tmp258_->length = _tmp258_->length * step_size;
			_tmp259_ = previous;
			_tmp260_ = previous;
			_tmp260_->flags = _tmp260_->flags | (BIRD_FONT_EDIT_POINT_CURVE | BIRD_FONT_EDIT_POINT_SEGMENT_END);
			_tmp261_ = previous_inside;
			_tmp262_ = previous_inside;
			_tmp262_->flags = _tmp262_->flags | (BIRD_FONT_EDIT_POINT_CURVE | BIRD_FONT_EDIT_POINT_SEGMENT_END);
			_tmp263_ = side1;
			_tmp264_ = previous;
			_tmp265_ = bird_font_path_add_point (_tmp263_, _tmp264_);
			_tmp266_ = _tmp265_;
			_g_object_unref0 (_tmp266_);
			_tmp267_ = side2;
			_tmp268_ = previous_inside;
			_tmp269_ = bird_font_path_add_point (_tmp267_, _tmp268_);
			_tmp270_ = _tmp269_;
			_g_object_unref0 (_tmp270_);
			_tmp271_ = p2;
			_tmp272_ = bird_font_edit_point_get_left_handle (_tmp271_);
			_tmp273_ = _g_object_ref0 (_tmp272_);
			_g_object_unref0 (l);
			l = _tmp273_;
			_tmp274_ = p2;
			_tmp275_ = bird_font_edit_point_get_right_handle (_tmp274_);
			_tmp276_ = _g_object_ref0 (_tmp275_);
			_g_object_unref0 (r);
			r = _tmp276_;
			_tmp277_ = l;
			_tmp278_ = r;
			if (fabs (fmod ((_tmp277_->angle + _tmp278_->angle) + G_PI, 2 * G_PI) - G_PI) > 0.005) {
				gboolean _tmp279_ = FALSE;
				BirdFontPath* _tmp280_;
				_tmp280_ = path;
				if (!bird_font_path_is_open (_tmp280_)) {
					_tmp279_ = TRUE;
				} else {
					_tmp279_ = i < (size - 1);
				}
				if (_tmp279_) {
					BirdFontEditPoint* _tmp281_;
					BirdFontEditPoint* _tmp282_;
					BirdFontEditPoint* _tmp283_ = NULL;
					BirdFontPath* _tmp284_;
					BirdFontEditPoint* _tmp285_;
					BirdFontEditPoint* _tmp286_;
					BirdFontEditPoint* _tmp287_;
					BirdFontEditPoint* _tmp288_;
					BirdFontEditPoint* _tmp289_;
					BirdFontEditPoint* _tmp290_;
					BirdFontEditPoint* _tmp291_;
					BirdFontEditPoint* _tmp292_ = NULL;
					BirdFontPath* _tmp293_;
					BirdFontEditPoint* _tmp294_;
					BirdFontEditPoint* _tmp295_;
					BirdFontEditPoint* _tmp296_;
					BirdFontEditPoint* _tmp297_;
					BirdFontEditPoint* _tmp298_;
					_tmp281_ = p2;
					_tmp282_ = p3;
					bird_font_stroke_tool_get_segment (self, thickness, (gdouble) 0, 0.00001, _tmp281_, _tmp282_, &_tmp283_);
					_g_object_unref0 (start);
					start = _tmp283_;
					_tmp284_ = side1;
					_tmp285_ = previous;
					_tmp286_ = start;
					_tmp287_ = p2;
					_tmp288_ = bird_font_edit_point_copy (_tmp287_);
					_tmp289_ = _tmp288_;
					bird_font_stroke_tool_add_corner (self, _tmp284_, _tmp285_, _tmp286_, _tmp289_, thickness);
					_g_object_unref0 (_tmp289_);
					_tmp290_ = p2;
					_tmp291_ = p3;
					bird_font_stroke_tool_get_segment (self, -thickness, (gdouble) 0, 0.00001, _tmp290_, _tmp291_, &_tmp292_);
					_g_object_unref0 (start);
					start = _tmp292_;
					_tmp293_ = side2;
					_tmp294_ = previous_inside;
					_tmp295_ = start;
					_tmp296_ = p2;
					_tmp297_ = bird_font_edit_point_copy (_tmp296_);
					_tmp298_ = _tmp297_;
					bird_font_stroke_tool_add_corner (self, _tmp293_, _tmp294_, _tmp295_, _tmp298_, thickness);
					_g_object_unref0 (_tmp298_);
				}
			}
		}
	}
	_tmp299_ = side1;
	bird_font_path_remove_points_on_points (_tmp299_, 0.00001);
	_tmp300_ = side2;
	bird_font_path_remove_points_on_points (_tmp300_, 0.00001);
	_tmp301_ = side1;
	bird_font_stroke_tool_convert_to_curve (self, _tmp301_);
	_tmp302_ = side2;
	bird_font_stroke_tool_convert_to_curve (self, _tmp302_);
	_tmp303_ = side2;
	bird_font_path_reverse (_tmp303_);
	_tmp304_ = path;
	_tmp305_ = side1;
	_tmp306_ = side2;
	_tmp307_ = bird_font_stroke_tool_merge_stroke_parts (self, _tmp304_, _tmp305_, _tmp306_);
	_g_object_unref0 (pl);
	pl = _tmp307_;
	result = pl;
	_g_object_unref0 (path);
	_g_object_unref0 (r);
	_g_object_unref0 (l);
	_g_object_unref0 (corner1_inside);
	_g_object_unref0 (corner1);
	_g_object_unref0 (side2);
	_g_object_unref0 (side1);
	_g_object_unref0 (start_inside);
	_g_object_unref0 (start);
	_g_object_unref0 (previous_inside);
	_g_object_unref0 (previous);
	_g_object_unref0 (p3);
	_g_object_unref0 (p2);
	_g_object_unref0 (p1);
	return result;
}

static void
bird_font_stroke_tool_convert_to_curve (BirdFontStrokeTool* self,
                                        BirdFontPath* path)
{
	BirdFontStrokeTask* _tmp22_;
	BirdFontStrokeTask* _tmp37_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	if (bird_font_path_is_open (path)) {
		BirdFontEditPoint* _tmp0_;
		BirdFontEditPoint* _tmp1_;
		BirdFontEditPoint* _tmp2_;
		BirdFontEditPoint* _tmp3_;
		BirdFontEditPoint* _tmp4_;
		BirdFontEditPoint* _tmp5_;
		BirdFontEditPoint* _tmp6_;
		BirdFontEditPoint* _tmp7_;
		_tmp0_ = bird_font_path_get_first_point (path);
		_tmp1_ = _tmp0_;
		_tmp2_ = bird_font_path_get_first_point (path);
		_tmp3_ = _tmp2_;
		_tmp3_->flags = _tmp3_->flags & (~BIRD_FONT_EDIT_POINT_CURVE);
		_g_object_unref0 (_tmp3_);
		_g_object_unref0 (_tmp1_);
		_tmp4_ = bird_font_path_get_last_point (path);
		_tmp5_ = _tmp4_;
		_tmp6_ = bird_font_path_get_last_point (path);
		_tmp7_ = _tmp6_;
		_tmp7_->flags = _tmp7_->flags & (~BIRD_FONT_EDIT_POINT_CURVE);
		_g_object_unref0 (_tmp7_);
		_g_object_unref0 (_tmp5_);
	}
	bird_font_path_recalculate_linear_handles (path);
	{
		GeeArrayList* _ep_list = NULL;
		GeeArrayList* _tmp8_;
		GeeArrayList* _tmp9_;
		gint _ep_size = 0;
		GeeArrayList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _ep_index = 0;
		_tmp8_ = bird_font_path_get_points (path);
		_tmp9_ = _tmp8_;
		_ep_list = _tmp9_;
		_tmp10_ = _ep_list;
		_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_ep_size = _tmp12_;
		_ep_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			BirdFontEditPoint* ep = NULL;
			GeeArrayList* _tmp15_;
			gpointer _tmp16_;
			BirdFontEditPoint* _tmp17_;
			_ep_index = _ep_index + 1;
			_tmp13_ = _ep_index;
			_tmp14_ = _ep_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _ep_list;
			_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _ep_index);
			ep = (BirdFontEditPoint*) _tmp16_;
			_tmp17_ = ep;
			if ((_tmp17_->flags & BIRD_FONT_EDIT_POINT_SEGMENT_END) == ((guint) 0)) {
				gboolean _tmp18_ = FALSE;
				BirdFontEditPoint* _tmp19_;
				_tmp19_ = ep;
				if ((_tmp19_->flags & BIRD_FONT_EDIT_POINT_CURVE) > ((guint) 0)) {
					_tmp18_ = TRUE;
				} else {
					BirdFontEditPoint* _tmp20_;
					_tmp20_ = ep;
					_tmp18_ = (_tmp20_->flags & BIRD_FONT_EDIT_POINT_CURVE_KEEP) > ((guint) 0);
				}
				if (_tmp18_) {
					BirdFontEditPoint* _tmp21_;
					_tmp21_ = ep;
					bird_font_edit_point_convert_to_curve (_tmp21_);
				}
			}
			_g_object_unref0 (ep);
		}
	}
	_tmp22_ = self->priv->task;
	if (bird_font_task_is_cancelled ((BirdFontTask*) _tmp22_)) {
		return;
	}
	{
		GeeArrayList* _ep_list = NULL;
		GeeArrayList* _tmp23_;
		GeeArrayList* _tmp24_;
		gint _ep_size = 0;
		GeeArrayList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _ep_index = 0;
		_tmp23_ = bird_font_path_get_points (path);
		_tmp24_ = _tmp23_;
		_ep_list = _tmp24_;
		_tmp25_ = _ep_list;
		_tmp26_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_ep_size = _tmp27_;
		_ep_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			BirdFontEditPoint* ep = NULL;
			GeeArrayList* _tmp30_;
			gpointer _tmp31_;
			BirdFontEditPoint* _tmp32_;
			_ep_index = _ep_index + 1;
			_tmp28_ = _ep_index;
			_tmp29_ = _ep_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _ep_list;
			_tmp31_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, _ep_index);
			ep = (BirdFontEditPoint*) _tmp31_;
			_tmp32_ = ep;
			if ((_tmp32_->flags & BIRD_FONT_EDIT_POINT_SEGMENT_END) == ((guint) 0)) {
				gboolean _tmp33_ = FALSE;
				BirdFontEditPoint* _tmp34_;
				_tmp34_ = ep;
				if ((_tmp34_->flags & BIRD_FONT_EDIT_POINT_CURVE) > ((guint) 0)) {
					_tmp33_ = TRUE;
				} else {
					BirdFontEditPoint* _tmp35_;
					_tmp35_ = ep;
					_tmp33_ = (_tmp35_->flags & BIRD_FONT_EDIT_POINT_CURVE_KEEP) > ((guint) 0);
				}
				if (_tmp33_) {
					BirdFontEditPoint* _tmp36_;
					_tmp36_ = ep;
					bird_font_edit_point_set_tie_handle (_tmp36_, TRUE);
				}
			}
			_g_object_unref0 (ep);
		}
	}
	_tmp37_ = self->priv->task;
	if (bird_font_task_is_cancelled ((BirdFontTask*) _tmp37_)) {
		return;
	}
	{
		GeeArrayList* _ep_list = NULL;
		GeeArrayList* _tmp38_;
		GeeArrayList* _tmp39_;
		gint _ep_size = 0;
		GeeArrayList* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		gint _ep_index = 0;
		_tmp38_ = bird_font_path_get_points (path);
		_tmp39_ = _tmp38_;
		_ep_list = _tmp39_;
		_tmp40_ = _ep_list;
		_tmp41_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp40_);
		_tmp42_ = _tmp41_;
		_ep_size = _tmp42_;
		_ep_index = -1;
		while (TRUE) {
			gint _tmp43_;
			gint _tmp44_;
			BirdFontEditPoint* ep = NULL;
			GeeArrayList* _tmp45_;
			gpointer _tmp46_;
			BirdFontEditPoint* _tmp47_;
			_ep_index = _ep_index + 1;
			_tmp43_ = _ep_index;
			_tmp44_ = _ep_size;
			if (!(_tmp43_ < _tmp44_)) {
				break;
			}
			_tmp45_ = _ep_list;
			_tmp46_ = gee_abstract_list_get ((GeeAbstractList*) _tmp45_, _ep_index);
			ep = (BirdFontEditPoint*) _tmp46_;
			_tmp47_ = ep;
			if ((_tmp47_->flags & BIRD_FONT_EDIT_POINT_SEGMENT_END) == ((guint) 0)) {
				gboolean _tmp48_ = FALSE;
				BirdFontEditPoint* _tmp49_;
				_tmp49_ = ep;
				if ((_tmp49_->flags & BIRD_FONT_EDIT_POINT_CURVE) > ((guint) 0)) {
					_tmp48_ = TRUE;
				} else {
					BirdFontEditPoint* _tmp50_;
					_tmp50_ = ep;
					_tmp48_ = (_tmp50_->flags & BIRD_FONT_EDIT_POINT_CURVE_KEEP) > ((guint) 0);
				}
				if (_tmp48_) {
					BirdFontEditPoint* _tmp51_;
					_tmp51_ = ep;
					bird_font_edit_point_process_tied_handle (_tmp51_);
				}
			}
			_g_object_unref0 (ep);
		}
	}
}

void
bird_font_stroke_tool_get_segment (BirdFontStrokeTool* self,
                                   gdouble stroke_thickness,
                                   gdouble step,
                                   gdouble step_size,
                                   BirdFontEditPoint* p1,
                                   BirdFontEditPoint* p2,
                                   BirdFontEditPoint** ep1)
{
	BirdFontEditPoint* _vala_ep1 = NULL;
	gdouble thickness = 0.0;
	BirdFontPath* overlay = NULL;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble x2 = 0.0;
	gdouble y2 = 0.0;
	gdouble x3 = 0.0;
	gdouble y3 = 0.0;
	BirdFontEditPoint* corner1 = NULL;
	BirdFontEditPoint* corner2 = NULL;
	BirdFontEditPoint* corner3 = NULL;
	BirdFontPointType type = 0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	BirdFontPath* _tmp6_;
	BirdFontEditPointHandle* _tmp7_;
	BirdFontEditPoint* _tmp8_;
	BirdFontEditPoint* _tmp9_;
	BirdFontEditPoint* _tmp10_;
	BirdFontEditPoint* _tmp11_;
	BirdFontEditPoint* _tmp12_;
	BirdFontEditPoint* _tmp13_;
	BirdFontEditPoint* _tmp14_;
	BirdFontEditPoint* _tmp15_;
	BirdFontEditPoint* _tmp16_;
	BirdFontEditPoint* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p1 != NULL);
	g_return_if_fail (p2 != NULL);
	thickness = stroke_thickness / 2;
	bird_font_path_get_point_for_step (p1, p2, step, &_tmp0_, &_tmp1_);
	x = _tmp0_;
	y = _tmp1_;
	bird_font_path_get_point_for_step (p1, p2, step + step_size, &_tmp2_, &_tmp3_);
	x2 = _tmp2_;
	y2 = _tmp3_;
	bird_font_path_get_point_for_step (p1, p2, step + (2 * step_size), &_tmp4_, &_tmp5_);
	x3 = _tmp4_;
	y3 = _tmp5_;
	_tmp6_ = bird_font_path_new ();
	_g_object_unref0 (overlay);
	overlay = _tmp6_;
	_tmp7_ = bird_font_edit_point_get_right_handle (p1);
	type = _tmp7_->type;
	_tmp8_ = bird_font_edit_point_new (x, y, type);
	_g_object_unref0 (corner1);
	corner1 = _tmp8_;
	_tmp9_ = bird_font_edit_point_new (x2, y2, type);
	_g_object_unref0 (corner2);
	corner2 = _tmp9_;
	_tmp10_ = bird_font_edit_point_new (x3, y3, type);
	_g_object_unref0 (corner3);
	corner3 = _tmp10_;
	bird_font_edit_point_convert_to_line (corner2);
	_tmp11_ = bird_font_path_add_point (overlay, corner1);
	_tmp12_ = _tmp11_;
	_g_object_unref0 (_tmp12_);
	_tmp13_ = bird_font_path_add_point (overlay, corner2);
	_tmp14_ = _tmp13_;
	_g_object_unref0 (_tmp14_);
	_tmp15_ = bird_font_path_add_point (overlay, corner3);
	_tmp16_ = _tmp15_;
	_g_object_unref0 (_tmp16_);
	bird_font_path_close (overlay);
	bird_font_path_recalculate_linear_handles (overlay);
	bird_font_stroke_tool_move_segment (corner1, corner2, thickness);
	_tmp17_ = _g_object_ref0 (corner2);
	_g_object_unref0 (_vala_ep1);
	_vala_ep1 = _tmp17_;
	_g_object_unref0 (corner3);
	_g_object_unref0 (corner2);
	_g_object_unref0 (corner1);
	_g_object_unref0 (overlay);
	if (ep1) {
		*ep1 = _vala_ep1;
	} else {
		_g_object_unref0 (_vala_ep1);
	}
}

BirdFontPathList*
bird_font_stroke_tool_merge_stroke_parts (BirdFontStrokeTool* self,
                                          BirdFontPath* p,
                                          BirdFontPath* side1,
                                          BirdFontPath* side2)
{
	BirdFontPath* merged = NULL;
	BirdFontPath* _tmp0_;
	BirdFontPathList* paths = NULL;
	BirdFontPathList* _tmp1_;
	BirdFontPathList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (p != NULL, NULL);
	g_return_val_if_fail (side1 != NULL, NULL);
	g_return_val_if_fail (side2 != NULL, NULL);
	_tmp0_ = bird_font_path_new ();
	merged = _tmp0_;
	_tmp1_ = bird_font_path_list_new ();
	paths = _tmp1_;
	if (!bird_font_path_is_open (p)) {
		BirdFontPathList* _tmp2_;
		BirdFontPathList* _tmp3_;
		bird_font_path_update_region_boundaries (side1);
		_tmp2_ = paths;
		bird_font_path_list_add (_tmp2_, side1);
		bird_font_path_update_region_boundaries (side2);
		_tmp3_ = paths;
		bird_font_path_list_add (_tmp3_, side2);
		bird_font_path_close (side1);
		bird_font_path_close (side2);
	} else {
		if (bird_font_path_is_open (p)) {
			BirdFontPath* _tmp4_;
			BirdFontPath* _tmp5_;
			BirdFontPath* _tmp6_;
			BirdFontPathList* _tmp7_;
			BirdFontPath* _tmp8_;
			BirdFontPath* _tmp9_;
			bird_font_path_reverse (side2);
			_tmp4_ = bird_font_stroke_tool_merge_strokes (self, p, side1, side2);
			_g_object_unref0 (merged);
			merged = _tmp4_;
			_tmp5_ = merged;
			bird_font_path_close (_tmp5_);
			_tmp6_ = merged;
			bird_font_path_update_region_boundaries (_tmp6_);
			_tmp7_ = paths;
			_tmp8_ = merged;
			bird_font_path_list_add (_tmp7_, _tmp8_);
			_tmp9_ = merged;
			bird_font_path_reverse (_tmp9_);
		} else {
			BirdFontPathList* _tmp10_;
			g_warning ("StrokeTool.vala:3113: Can not create stroke.");
			_tmp10_ = paths;
			bird_font_path_list_add (_tmp10_, p);
		}
	}
	result = paths;
	_g_object_unref0 (merged);
	return result;
}

BirdFontPath*
bird_font_stroke_tool_change_weight_fast (BirdFontPath* path,
                                          gdouble weight,
                                          gboolean counter)
{
	BirdFontStrokeTool* tool = NULL;
	BirdFontStrokeTool* _tmp0_;
	BirdFontPathList* pl = NULL;
	BirdFontStrokeTool* _tmp1_;
	BirdFontPathList* _tmp2_;
	BirdFontPathList* _tmp3_;
	GeeArrayList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	BirdFontPath* _tmp7_;
	BirdFontPath* _tmp8_;
	BirdFontPathList* _tmp9_;
	GeeArrayList* _tmp10_;
	gpointer _tmp11_;
	BirdFontPath* _tmp12_;
	gboolean _tmp13_;
	BirdFontPathList* _tmp17_;
	GeeArrayList* _tmp18_;
	gpointer _tmp19_;
	BirdFontPath* result;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = bird_font_stroke_tool_new ();
	tool = _tmp0_;
	_tmp1_ = tool;
	_tmp2_ = bird_font_stroke_tool_get_stroke_fast (_tmp1_, path, fabs (weight));
	_g_object_unref0 (pl);
	pl = _tmp2_;
	_tmp3_ = pl;
	_tmp4_ = _tmp3_->paths;
	_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = bird_font_path_new ();
	_tmp8_ = _tmp7_;
	g_return_val_if_fail (_tmp6_ == 2, _tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = pl;
	_tmp10_ = _tmp9_->paths;
	_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, 0);
	_tmp12_ = (BirdFontPath*) _tmp11_;
	_tmp13_ = counter == (!bird_font_path_is_clockwise (_tmp12_));
	_g_object_unref0 (_tmp12_);
	if (_tmp13_) {
		BirdFontPathList* _tmp14_;
		GeeArrayList* _tmp15_;
		gpointer _tmp16_;
		_tmp14_ = pl;
		_tmp15_ = _tmp14_->paths;
		_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, 0);
		result = (BirdFontPath*) _tmp16_;
		_g_object_unref0 (pl);
		_g_object_unref0 (tool);
		return result;
	}
	_tmp17_ = pl;
	_tmp18_ = _tmp17_->paths;
	_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, 1);
	result = (BirdFontPath*) _tmp19_;
	_g_object_unref0 (pl);
	_g_object_unref0 (tool);
	return result;
}

BirdFontPath*
bird_font_stroke_tool_change_weight (BirdFontPath* path,
                                     gboolean counter,
                                     gdouble weight)
{
	BirdFontStrokeTool* tool = NULL;
	BirdFontStrokeTool* _tmp0_;
	BirdFontPath* o = NULL;
	BirdFontPath* _tmp1_;
	BirdFontPath* interpolated = NULL;
	BirdFontPath* _tmp2_;
	BirdFontPath* _tmp3_;
	gdouble default_weight = 0.0;
	BirdFontPathList* pl = NULL;
	BirdFontStrokeTool* _tmp4_;
	BirdFontPath* _tmp5_;
	BirdFontPathList* _tmp6_;
	GeeArrayList* deleted = NULL;
	GeeArrayList* _tmp7_;
	BirdFontPathList* _tmp8_;
	GeeArrayList* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	BirdFontPath* _tmp12_;
	BirdFontPath* _tmp13_;
	BirdFontPath* result;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = bird_font_stroke_tool_new ();
	tool = _tmp0_;
	_tmp1_ = bird_font_path_copy (path);
	o = _tmp1_;
	_tmp2_ = bird_font_path_new ();
	interpolated = _tmp2_;
	_tmp3_ = o;
	bird_font_path_force_direction (_tmp3_, BIRD_FONT_DIRECTION_CLOCKWISE);
	default_weight = (gdouble) 5;
	_tmp4_ = tool;
	_tmp5_ = o;
	_tmp6_ = bird_font_stroke_tool_get_stroke (_tmp4_, _tmp5_, default_weight);
	pl = _tmp6_;
	_tmp7_ = gee_array_list_new (BIRD_FONT_TYPE_POINT_SELECTION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (deleted);
	deleted = _tmp7_;
	_tmp8_ = pl;
	_tmp9_ = _tmp8_->paths;
	_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = bird_font_path_new ();
	_tmp13_ = _tmp12_;
	g_return_val_if_fail (_tmp11_ > 0, _tmp13_);
	_g_object_unref0 (_tmp13_);
	if (weight < ((gdouble) 0)) {
		counter = !counter;
	}
	{
		GeeArrayList* _sp_list = NULL;
		BirdFontPathList* _tmp14_;
		GeeArrayList* _tmp15_;
		gint _sp_size = 0;
		GeeArrayList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _sp_index = 0;
		_tmp14_ = pl;
		_tmp15_ = _tmp14_->paths;
		_sp_list = _tmp15_;
		_tmp16_ = _sp_list;
		_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_sp_size = _tmp18_;
		_sp_index = -1;
		while (TRUE) {
			gint _tmp19_;
			gint _tmp20_;
			BirdFontPath* sp = NULL;
			GeeArrayList* _tmp21_;
			gpointer _tmp22_;
			gboolean _tmp23_ = FALSE;
			BirdFontPath* _tmp24_;
			GeeArrayList* _tmp25_;
			GeeArrayList* _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			BirdFontPath* _tmp29_;
			GeeArrayList* _tmp30_;
			GeeArrayList* _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			_sp_index = _sp_index + 1;
			_tmp19_ = _sp_index;
			_tmp20_ = _sp_size;
			if (!(_tmp19_ < _tmp20_)) {
				break;
			}
			_tmp21_ = _sp_list;
			_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _sp_index);
			sp = (BirdFontPath*) _tmp22_;
			_tmp24_ = sp;
			_tmp25_ = bird_font_path_get_points (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = interpolated;
			_tmp30_ = bird_font_path_get_points (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp31_);
			_tmp33_ = _tmp32_;
			if (_tmp28_ > _tmp33_) {
				BirdFontPath* _tmp34_;
				_tmp34_ = sp;
				_tmp23_ = counter == (!bird_font_path_is_clockwise (_tmp34_));
			} else {
				_tmp23_ = FALSE;
			}
			if (_tmp23_) {
				BirdFontPath* _tmp35_;
				BirdFontPath* _tmp36_;
				_tmp35_ = sp;
				_tmp36_ = _g_object_ref0 (_tmp35_);
				_g_object_unref0 (interpolated);
				interpolated = _tmp36_;
			}
			_g_object_unref0 (sp);
		}
	}
	result = interpolated;
	_g_object_unref0 (deleted);
	_g_object_unref0 (pl);
	_g_object_unref0 (o);
	_g_object_unref0 (tool);
	return result;
}

static void
bird_font_stroke_tool_class_init (BirdFontStrokeToolClass * klass,
                                  gpointer klass_data)
{
	bird_font_stroke_tool_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontStrokeTool_private_offset);
	G_OBJECT_CLASS (klass)->finalize = bird_font_stroke_tool_finalize;
}

static void
bird_font_stroke_tool_instance_init (BirdFontStrokeTool * self,
                                     gpointer klass)
{
	self->priv = bird_font_stroke_tool_get_instance_private (self);
}

static void
bird_font_stroke_tool_finalize (GObject * obj)
{
	BirdFontStrokeTool * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_STROKE_TOOL, BirdFontStrokeTool);
	_g_object_unref0 (self->priv->task);
	G_OBJECT_CLASS (bird_font_stroke_tool_parent_class)->finalize (obj);
}

static GType
bird_font_stroke_tool_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontStrokeToolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_stroke_tool_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontStrokeTool), 0, (GInstanceInitFunc) bird_font_stroke_tool_instance_init, NULL };
	GType bird_font_stroke_tool_type_id;
	bird_font_stroke_tool_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontStrokeTool", &g_define_type_info, 0);
	BirdFontStrokeTool_private_offset = g_type_add_instance_private (bird_font_stroke_tool_type_id, sizeof (BirdFontStrokeToolPrivate));
	return bird_font_stroke_tool_type_id;
}

GType
bird_font_stroke_tool_get_type (void)
{
	static volatile gsize bird_font_stroke_tool_type_id__once = 0;
	if (g_once_init_enter (&bird_font_stroke_tool_type_id__once)) {
		GType bird_font_stroke_tool_type_id;
		bird_font_stroke_tool_type_id = bird_font_stroke_tool_get_type_once ();
		g_once_init_leave (&bird_font_stroke_tool_type_id__once, bird_font_stroke_tool_type_id);
	}
	return bird_font_stroke_tool_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

