/* EotWriter.c generated by valac 0.56.17, the Vala compiler
 * generated from EotWriter.vala, do not modify */

/*
Copyright (C) 2012 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "birdfont.h"
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define BIRD_FONT_TYPE_EOT_WRITER (bird_font_eot_writer_get_type ())
#define BIRD_FONT_EOT_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BIRD_FONT_TYPE_EOT_WRITER, BirdFontEotWriter))
#define BIRD_FONT_EOT_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BIRD_FONT_TYPE_EOT_WRITER, BirdFontEotWriterClass))
#define BIRD_FONT_IS_EOT_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BIRD_FONT_TYPE_EOT_WRITER))
#define BIRD_FONT_IS_EOT_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BIRD_FONT_TYPE_EOT_WRITER))
#define BIRD_FONT_EOT_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BIRD_FONT_TYPE_EOT_WRITER, BirdFontEotWriterClass))

typedef struct _BirdFontEotWriter BirdFontEotWriter;
typedef struct _BirdFontEotWriterClass BirdFontEotWriterClass;
typedef struct _BirdFontEotWriterPrivate BirdFontEotWriterPrivate;
enum  {
	BIRD_FONT_EOT_WRITER_0_PROPERTY,
	BIRD_FONT_EOT_WRITER_NUM_PROPERTIES
};
static GParamSpec* bird_font_eot_writer_properties[BIRD_FONT_EOT_WRITER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _BirdFontEotWriter {
	GObject parent_instance;
	BirdFontEotWriterPrivate * priv;
};

struct _BirdFontEotWriterClass {
	GObjectClass parent_class;
};

struct _BirdFontEotWriterPrivate {
	gchar* ttf_file_name;
	gchar* eot_file_name;
};

static gint BirdFontEotWriter_private_offset;
static gpointer bird_font_eot_writer_parent_class = NULL;

VALA_EXTERN GType bird_font_eot_writer_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BirdFontEotWriter* bird_font_eot_writer_new (const gchar* ttf_file,
                                             const gchar* eot_file);
VALA_EXTERN BirdFontEotWriter* bird_font_eot_writer_construct (GType object_type,
                                                   const gchar* ttf_file,
                                                   const gchar* eot_file);
VALA_EXTERN void bird_font_eot_writer_write (BirdFontEotWriter* self,
                                 GError** error);
static void bird_font_eot_writer_finalize (GObject * obj);
static GType bird_font_eot_writer_get_type_once (void);

static inline gpointer
bird_font_eot_writer_get_instance_private (BirdFontEotWriter* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontEotWriter_private_offset);
}

BirdFontEotWriter*
bird_font_eot_writer_construct (GType object_type,
                                const gchar* ttf_file,
                                const gchar* eot_file)
{
	BirdFontEotWriter * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (ttf_file != NULL, NULL);
	g_return_val_if_fail (eot_file != NULL, NULL);
	self = (BirdFontEotWriter*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (ttf_file);
	_g_free0 (self->priv->ttf_file_name);
	self->priv->ttf_file_name = _tmp0_;
	_tmp1_ = g_strdup (eot_file);
	_g_free0 (self->priv->eot_file_name);
	self->priv->eot_file_name = _tmp1_;
	return self;
}

BirdFontEotWriter*
bird_font_eot_writer_new (const gchar* ttf_file,
                          const gchar* eot_file)
{
	return bird_font_eot_writer_construct (BIRD_FONT_TYPE_EOT_WRITER, ttf_file, eot_file);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
bird_font_eot_writer_write (BirdFontEotWriter* self,
                            GError** error)
{
	BirdFontFontData* fd = NULL;
	BirdFontFontData* _tmp0_;
	BirdFontFontData* ttf_data = NULL;
	BirdFontFontData* _tmp1_;
	BirdFontOpenFontFormatReader* input = NULL;
	guint32 ttf_length = 0U;
	GFile* ttf_file = NULL;
	GFile* eot_file = NULL;
	GFileInfo* file_info = NULL;
	BirdFontOtfInputStream* dis = NULL;
	GDataOutputStream* os = NULL;
	guint8* data = NULL;
	guint32 l = 0U;
	BirdFontNameTable* names = NULL;
	gchar* tn = NULL;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	const gchar* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	GFileOutputStream* _tmp15_ = NULL;
	GFile* _tmp16_;
	GFileOutputStream* _tmp17_;
	GDataOutputStream* _tmp18_;
	GFileInfo* _tmp19_ = NULL;
	GFile* _tmp20_;
	GFileInfo* _tmp21_;
	GFileInfo* _tmp22_;
	GFileInfo* _tmp23_;
	GFileInputStream* _tmp24_ = NULL;
	GFile* _tmp25_;
	GFileInputStream* _tmp26_;
	BirdFontOtfInputStream* _tmp27_ = NULL;
	BirdFontOtfInputStream* _tmp28_;
	BirdFontOtfInputStream* _tmp29_;
	BirdFontFontData* _tmp30_;
	BirdFontOtfInputStream* _tmp31_;
	BirdFontOpenFontFormatReader* _tmp32_;
	BirdFontOpenFontFormatReader* _tmp33_;
	const gchar* _tmp34_;
	BirdFontOpenFontFormatReader* _tmp35_;
	BirdFontDirectoryTable* _tmp36_;
	BirdFontNameTable* _tmp37_;
	BirdFontNameTable* _tmp38_;
	BirdFontFontData* _tmp39_;
	BirdFontFontData* _tmp40_;
	BirdFontFontData* _tmp41_;
	BirdFontFontData* _tmp42_;
	BirdFontFontData* _tmp46_;
	BirdFontFontData* _tmp47_;
	BirdFontFontData* _tmp48_;
	BirdFontFontData* _tmp49_;
	BirdFontFontData* _tmp50_;
	BirdFontFontData* _tmp51_;
	BirdFontFontData* _tmp52_;
	BirdFontFontData* _tmp53_;
	BirdFontFontData* _tmp54_;
	BirdFontFontData* _tmp55_;
	BirdFontFontData* _tmp56_;
	BirdFontFontData* _tmp57_;
	BirdFontOpenFontFormatReader* _tmp58_;
	BirdFontFontData* _tmp59_;
	BirdFontFontData* _tmp60_;
	BirdFontFontData* _tmp61_;
	BirdFontFontData* _tmp62_;
	BirdFontFontData* _tmp63_;
	BirdFontNameTable* _tmp64_;
	gchar* _tmp65_;
	BirdFontFontData* _tmp66_;
	const gchar* _tmp67_;
	BirdFontFontData* _tmp68_;
	const gchar* _tmp69_;
	BirdFontFontData* _tmp70_;
	BirdFontNameTable* _tmp71_;
	gchar* _tmp72_;
	BirdFontFontData* _tmp73_;
	const gchar* _tmp74_;
	BirdFontFontData* _tmp75_;
	const gchar* _tmp76_;
	BirdFontFontData* _tmp77_;
	BirdFontNameTable* _tmp78_;
	gchar* _tmp79_;
	BirdFontFontData* _tmp80_;
	const gchar* _tmp81_;
	BirdFontFontData* _tmp82_;
	const gchar* _tmp83_;
	BirdFontFontData* _tmp84_;
	BirdFontNameTable* _tmp85_;
	gchar* _tmp86_;
	BirdFontFontData* _tmp87_;
	const gchar* _tmp88_;
	BirdFontFontData* _tmp89_;
	const gchar* _tmp90_;
	BirdFontFontData* _tmp91_;
	BirdFontFontData* _tmp92_;
	BirdFontFontData* _tmp93_;
	BirdFontFontData* _tmp94_;
	BirdFontFontData* _tmp95_;
	BirdFontFontData* _tmp96_;
	BirdFontFontData* _tmp97_;
	guint8* _tmp98_;
	BirdFontFontData* _tmp104_;
	BirdFontFontData* _tmp105_;
	guint8* _tmp106_;
	BirdFontOtfInputStream* _tmp112_;
	GDataOutputStream* _tmp113_;
	BirdFontOpenFontFormatReader* _tmp114_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_font_data_new ((guint32) 1024);
	fd = _tmp0_;
	_tmp1_ = bird_font_font_data_new ((guint32) 1024);
	ttf_data = _tmp1_;
	_tmp2_ = self->priv->ttf_file_name;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	_g_object_unref0 (ttf_file);
	ttf_file = _tmp3_;
	_tmp4_ = ttf_file;
	if (!g_file_query_exists (_tmp4_, NULL)) {
		GFile* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp5_ = ttf_file;
		_tmp6_ = g_file_get_path (_tmp5_);
		_tmp7_ = (gchar*) _tmp6_;
		_tmp8_ = string_to_string (_tmp7_);
		_tmp9_ = g_strconcat ("EotWriter: file does not exist. ", _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		g_warning ("EotWriter.vala:47: %s", _tmp10_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp7_);
		_g_free0 (tn);
		_g_object_unref0 (names);
		_g_object_unref0 (os);
		_g_object_unref0 (dis);
		_g_object_unref0 (file_info);
		_g_object_unref0 (eot_file);
		_g_object_unref0 (ttf_file);
		_g_object_unref0 (input);
		_g_object_unref0 (ttf_data);
		_g_object_unref0 (fd);
		return;
	}
	_tmp11_ = self->priv->eot_file_name;
	_tmp12_ = g_file_new_for_path (_tmp11_);
	_g_object_unref0 (eot_file);
	eot_file = _tmp12_;
	_tmp13_ = eot_file;
	if (g_file_query_exists (_tmp13_, NULL)) {
		GFile* _tmp14_;
		g_warning ("EotWriter.vala:54: EOT file exists in eot export.");
		_tmp14_ = eot_file;
		g_file_delete (_tmp14_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (tn);
			_g_object_unref0 (names);
			_g_object_unref0 (os);
			_g_object_unref0 (dis);
			_g_object_unref0 (file_info);
			_g_object_unref0 (eot_file);
			_g_object_unref0 (ttf_file);
			_g_object_unref0 (input);
			_g_object_unref0 (ttf_data);
			_g_object_unref0 (fd);
			return;
		}
	}
	_tmp16_ = eot_file;
	_tmp17_ = g_file_create (_tmp16_, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error0_);
	_tmp15_ = _tmp17_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (tn);
		_g_object_unref0 (names);
		_g_object_unref0 (os);
		_g_object_unref0 (dis);
		_g_object_unref0 (file_info);
		_g_object_unref0 (eot_file);
		_g_object_unref0 (ttf_file);
		_g_object_unref0 (input);
		_g_object_unref0 (ttf_data);
		_g_object_unref0 (fd);
		return;
	}
	_tmp18_ = g_data_output_stream_new ((GOutputStream*) _tmp15_);
	_g_object_unref0 (os);
	os = _tmp18_;
	_tmp20_ = ttf_file;
	_tmp21_ = g_file_query_info (_tmp20_, "*", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
	_tmp19_ = _tmp21_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp15_);
		_g_free0 (tn);
		_g_object_unref0 (names);
		_g_object_unref0 (os);
		_g_object_unref0 (dis);
		_g_object_unref0 (file_info);
		_g_object_unref0 (eot_file);
		_g_object_unref0 (ttf_file);
		_g_object_unref0 (input);
		_g_object_unref0 (ttf_data);
		_g_object_unref0 (fd);
		return;
	}
	_tmp22_ = _tmp19_;
	_tmp19_ = NULL;
	_g_object_unref0 (file_info);
	file_info = _tmp22_;
	_tmp23_ = file_info;
	ttf_length = (guint32) g_file_info_get_size (_tmp23_);
	if (ttf_length == ((guint32) 0)) {
		g_warning ("EotWriter.vala:64: TTF file is of zero length.");
		_g_object_unref0 (_tmp19_);
		_g_object_unref0 (_tmp15_);
		_g_free0 (tn);
		_g_object_unref0 (names);
		_g_object_unref0 (os);
		_g_object_unref0 (dis);
		_g_object_unref0 (file_info);
		_g_object_unref0 (eot_file);
		_g_object_unref0 (ttf_file);
		_g_object_unref0 (input);
		_g_object_unref0 (ttf_data);
		_g_object_unref0 (fd);
		return;
	}
	_tmp25_ = ttf_file;
	_tmp26_ = g_file_read (_tmp25_, NULL, &_inner_error0_);
	_tmp24_ = _tmp26_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp19_);
		_g_object_unref0 (_tmp15_);
		_g_free0 (tn);
		_g_object_unref0 (names);
		_g_object_unref0 (os);
		_g_object_unref0 (dis);
		_g_object_unref0 (file_info);
		_g_object_unref0 (eot_file);
		_g_object_unref0 (ttf_file);
		_g_object_unref0 (input);
		_g_object_unref0 (ttf_data);
		_g_object_unref0 (fd);
		return;
	}
	_tmp28_ = bird_font_otf_input_stream_new (_tmp24_, &_inner_error0_);
	_tmp27_ = _tmp28_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp24_);
		_g_object_unref0 (_tmp19_);
		_g_object_unref0 (_tmp15_);
		_g_free0 (tn);
		_g_object_unref0 (names);
		_g_object_unref0 (os);
		_g_object_unref0 (dis);
		_g_object_unref0 (file_info);
		_g_object_unref0 (eot_file);
		_g_object_unref0 (ttf_file);
		_g_object_unref0 (input);
		_g_object_unref0 (ttf_data);
		_g_object_unref0 (fd);
		return;
	}
	_tmp29_ = _tmp27_;
	_tmp27_ = NULL;
	_g_object_unref0 (dis);
	dis = _tmp29_;
	_tmp30_ = ttf_data;
	_tmp31_ = dis;
	bird_font_font_data_write_table (_tmp30_, _tmp31_, (guint32) 0, ttf_length, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp27_);
		_g_object_unref0 (_tmp24_);
		_g_object_unref0 (_tmp19_);
		_g_object_unref0 (_tmp15_);
		_g_free0 (tn);
		_g_object_unref0 (names);
		_g_object_unref0 (os);
		_g_object_unref0 (dis);
		_g_object_unref0 (file_info);
		_g_object_unref0 (eot_file);
		_g_object_unref0 (ttf_file);
		_g_object_unref0 (input);
		_g_object_unref0 (ttf_data);
		_g_object_unref0 (fd);
		return;
	}
	_tmp32_ = bird_font_open_font_format_reader_new ();
	_g_object_unref0 (input);
	input = _tmp32_;
	_tmp33_ = input;
	_tmp34_ = self->priv->ttf_file_name;
	bird_font_open_font_format_reader_parse_index (_tmp33_, _tmp34_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp27_);
		_g_object_unref0 (_tmp24_);
		_g_object_unref0 (_tmp19_);
		_g_object_unref0 (_tmp15_);
		_g_free0 (tn);
		_g_object_unref0 (names);
		_g_object_unref0 (os);
		_g_object_unref0 (dis);
		_g_object_unref0 (file_info);
		_g_object_unref0 (eot_file);
		_g_object_unref0 (ttf_file);
		_g_object_unref0 (input);
		_g_object_unref0 (ttf_data);
		_g_object_unref0 (fd);
		return;
	}
	_tmp35_ = input;
	_tmp36_ = _tmp35_->directory_table;
	_tmp37_ = _tmp36_->name_table;
	_tmp38_ = _g_object_ref0 (_tmp37_);
	_g_object_unref0 (names);
	names = _tmp38_;
	_tmp39_ = fd;
	bird_font_font_data_add_littleendian_u32 (_tmp39_, (guint32) 0);
	_tmp40_ = fd;
	bird_font_font_data_add_littleendian_u32 (_tmp40_, ttf_length);
	_tmp41_ = fd;
	bird_font_font_data_add_littleendian_u32 (_tmp41_, (guint32) 0x00020001);
	_tmp42_ = fd;
	bird_font_font_data_add_littleendian_u32 (_tmp42_, (guint32) 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp43_ = FALSE;
			_tmp43_ = TRUE;
			while (TRUE) {
				BirdFontFontData* _tmp45_;
				if (!_tmp43_) {
					gint _tmp44_;
					_tmp44_ = i;
					i = _tmp44_ + 1;
				}
				_tmp43_ = FALSE;
				if (!(i < 10)) {
					break;
				}
				_tmp45_ = fd;
				bird_font_font_data_add (_tmp45_, (guint8) 0);
			}
		}
	}
	_tmp46_ = fd;
	bird_font_font_data_add (_tmp46_, (guint8) 1);
	_tmp47_ = fd;
	bird_font_font_data_add (_tmp47_, (guint8) 0);
	_tmp48_ = fd;
	bird_font_font_data_add_littleendian_u32 (_tmp48_, (guint32) 400);
	_tmp49_ = fd;
	bird_font_font_data_add_littleendian_u16 (_tmp49_, (guint32) 0);
	_tmp50_ = fd;
	bird_font_font_data_add_littleendian_u16 (_tmp50_, (guint32) 0x504C);
	_tmp51_ = fd;
	bird_font_font_data_add_littleendian_u32 (_tmp51_, (guint32) 0);
	_tmp52_ = fd;
	bird_font_font_data_add_littleendian_u32 (_tmp52_, (guint32) 0);
	_tmp53_ = fd;
	bird_font_font_data_add_littleendian_u32 (_tmp53_, (guint32) 0);
	_tmp54_ = fd;
	bird_font_font_data_add_littleendian_u32 (_tmp54_, (guint32) 0);
	_tmp55_ = fd;
	bird_font_font_data_add_littleendian_u32 (_tmp55_, (guint32) 0);
	_tmp56_ = fd;
	bird_font_font_data_add_littleendian_u32 (_tmp56_, (guint32) 0);
	_tmp57_ = fd;
	_tmp58_ = input;
	bird_font_font_data_add_littleendian_u32 (_tmp57_, bird_font_open_font_format_reader_get_head_checksum (_tmp58_));
	_tmp59_ = fd;
	bird_font_font_data_add_littleendian_u32 (_tmp59_, (guint32) 0);
	_tmp60_ = fd;
	bird_font_font_data_add_littleendian_u32 (_tmp60_, (guint32) 0);
	_tmp61_ = fd;
	bird_font_font_data_add_littleendian_u32 (_tmp61_, (guint32) 0);
	_tmp62_ = fd;
	bird_font_font_data_add_littleendian_u32 (_tmp62_, (guint32) 0);
	_tmp63_ = fd;
	bird_font_font_data_add_littleendian_u16 (_tmp63_, (guint32) 0);
	_tmp64_ = names;
	_tmp65_ = bird_font_name_table_get_name (_tmp64_, BIRD_FONT_NAME_TABLE_FONT_NAME);
	_g_free0 (tn);
	tn = _tmp65_;
	_tmp66_ = fd;
	_tmp67_ = tn;
	bird_font_font_data_add_littleendian_u16 (_tmp66_, (guint32) ((guint16) (2 * g_utf8_strlen (_tmp67_, (gssize) -1))));
	_tmp68_ = fd;
	_tmp69_ = tn;
	bird_font_font_data_add_str_littleendian_utf16 (_tmp68_, _tmp69_);
	_tmp70_ = fd;
	bird_font_font_data_add_littleendian_u16 (_tmp70_, (guint32) 0);
	_tmp71_ = names;
	_tmp72_ = bird_font_name_table_get_name (_tmp71_, BIRD_FONT_NAME_TABLE_SUBFAMILY_NAME);
	_g_free0 (tn);
	tn = _tmp72_;
	_tmp73_ = fd;
	_tmp74_ = tn;
	bird_font_font_data_add_littleendian_u16 (_tmp73_, (guint32) ((guint16) (2 * g_utf8_strlen (_tmp74_, (gssize) -1))));
	_tmp75_ = fd;
	_tmp76_ = tn;
	bird_font_font_data_add_str_littleendian_utf16 (_tmp75_, _tmp76_);
	_tmp77_ = fd;
	bird_font_font_data_add_littleendian_u16 (_tmp77_, (guint32) 0);
	_tmp78_ = names;
	_tmp79_ = bird_font_name_table_get_name (_tmp78_, BIRD_FONT_NAME_TABLE_VERSION);
	_g_free0 (tn);
	tn = _tmp79_;
	_tmp80_ = fd;
	_tmp81_ = tn;
	bird_font_font_data_add_littleendian_u16 (_tmp80_, (guint32) ((guint16) (2 * g_utf8_strlen (_tmp81_, (gssize) -1))));
	_tmp82_ = fd;
	_tmp83_ = tn;
	bird_font_font_data_add_str_littleendian_utf16 (_tmp82_, _tmp83_);
	_tmp84_ = fd;
	bird_font_font_data_add_littleendian_u16 (_tmp84_, (guint32) 0);
	_tmp85_ = names;
	_tmp86_ = bird_font_name_table_get_name (_tmp85_, BIRD_FONT_NAME_TABLE_FULL_FONT_NAME);
	_g_free0 (tn);
	tn = _tmp86_;
	_tmp87_ = fd;
	_tmp88_ = tn;
	bird_font_font_data_add_littleendian_u16 (_tmp87_, (guint32) ((guint16) (2 * g_utf8_strlen (_tmp88_, (gssize) -1))));
	_tmp89_ = fd;
	_tmp90_ = tn;
	bird_font_font_data_add_str_littleendian_utf16 (_tmp89_, _tmp90_);
	_tmp91_ = fd;
	bird_font_font_data_add_littleendian_u16 (_tmp91_, (guint32) 0);
	_tmp92_ = fd;
	bird_font_font_data_add_littleendian_u16 (_tmp92_, (guint32) 0);
	_tmp93_ = fd;
	bird_font_font_data_seek (_tmp93_, (guint) 0);
	_tmp94_ = fd;
	_tmp95_ = fd;
	bird_font_font_data_add_littleendian_u32 (_tmp94_, (guint32) (bird_font_font_data_length (_tmp95_) + ttf_length));
	_tmp96_ = fd;
	l = (guint32) bird_font_font_data_length_with_padding (_tmp96_);
	_tmp97_ = fd;
	_tmp98_ = _tmp97_->table_data;
	data = _tmp98_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp99_ = FALSE;
			_tmp99_ = TRUE;
			while (TRUE) {
				GDataOutputStream* _tmp101_;
				guint8* _tmp102_;
				guint8 _tmp103_;
				if (!_tmp99_) {
					gint _tmp100_;
					_tmp100_ = i;
					i = _tmp100_ + 1;
				}
				_tmp99_ = FALSE;
				if (!(((guint32) i) < l)) {
					break;
				}
				_tmp101_ = os;
				_tmp102_ = data;
				_tmp103_ = _tmp102_[i];
				g_data_output_stream_put_byte (_tmp101_, _tmp103_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (_tmp27_);
					_g_object_unref0 (_tmp24_);
					_g_object_unref0 (_tmp19_);
					_g_object_unref0 (_tmp15_);
					_g_free0 (tn);
					_g_object_unref0 (names);
					_g_object_unref0 (os);
					_g_object_unref0 (dis);
					_g_object_unref0 (file_info);
					_g_object_unref0 (eot_file);
					_g_object_unref0 (ttf_file);
					_g_object_unref0 (input);
					_g_object_unref0 (ttf_data);
					_g_object_unref0 (fd);
					return;
				}
			}
		}
	}
	_tmp104_ = ttf_data;
	l = (guint32) bird_font_font_data_length_with_padding (_tmp104_);
	_tmp105_ = ttf_data;
	_tmp106_ = _tmp105_->table_data;
	data = _tmp106_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp107_ = FALSE;
			_tmp107_ = TRUE;
			while (TRUE) {
				GDataOutputStream* _tmp109_;
				guint8* _tmp110_;
				guint8 _tmp111_;
				if (!_tmp107_) {
					gint _tmp108_;
					_tmp108_ = i;
					i = _tmp108_ + 1;
				}
				_tmp107_ = FALSE;
				if (!(((guint32) i) < l)) {
					break;
				}
				_tmp109_ = os;
				_tmp110_ = data;
				_tmp111_ = _tmp110_[i];
				g_data_output_stream_put_byte (_tmp109_, _tmp111_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (_tmp27_);
					_g_object_unref0 (_tmp24_);
					_g_object_unref0 (_tmp19_);
					_g_object_unref0 (_tmp15_);
					_g_free0 (tn);
					_g_object_unref0 (names);
					_g_object_unref0 (os);
					_g_object_unref0 (dis);
					_g_object_unref0 (file_info);
					_g_object_unref0 (eot_file);
					_g_object_unref0 (ttf_file);
					_g_object_unref0 (input);
					_g_object_unref0 (ttf_data);
					_g_object_unref0 (fd);
					return;
				}
			}
		}
	}
	_tmp112_ = dis;
	bird_font_otf_input_stream_close (_tmp112_);
	_tmp113_ = os;
	g_output_stream_close ((GOutputStream*) _tmp113_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp27_);
		_g_object_unref0 (_tmp24_);
		_g_object_unref0 (_tmp19_);
		_g_object_unref0 (_tmp15_);
		_g_free0 (tn);
		_g_object_unref0 (names);
		_g_object_unref0 (os);
		_g_object_unref0 (dis);
		_g_object_unref0 (file_info);
		_g_object_unref0 (eot_file);
		_g_object_unref0 (ttf_file);
		_g_object_unref0 (input);
		_g_object_unref0 (ttf_data);
		_g_object_unref0 (fd);
		return;
	}
	_tmp114_ = input;
	bird_font_open_font_format_reader_close (_tmp114_);
	_g_object_unref0 (_tmp27_);
	_g_object_unref0 (_tmp24_);
	_g_object_unref0 (_tmp19_);
	_g_object_unref0 (_tmp15_);
	_g_free0 (tn);
	_g_object_unref0 (names);
	_g_object_unref0 (os);
	_g_object_unref0 (dis);
	_g_object_unref0 (file_info);
	_g_object_unref0 (eot_file);
	_g_object_unref0 (ttf_file);
	_g_object_unref0 (input);
	_g_object_unref0 (ttf_data);
	_g_object_unref0 (fd);
}

static void
bird_font_eot_writer_class_init (BirdFontEotWriterClass * klass,
                                 gpointer klass_data)
{
	bird_font_eot_writer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontEotWriter_private_offset);
	G_OBJECT_CLASS (klass)->finalize = bird_font_eot_writer_finalize;
}

static void
bird_font_eot_writer_instance_init (BirdFontEotWriter * self,
                                    gpointer klass)
{
	self->priv = bird_font_eot_writer_get_instance_private (self);
}

static void
bird_font_eot_writer_finalize (GObject * obj)
{
	BirdFontEotWriter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_EOT_WRITER, BirdFontEotWriter);
	_g_free0 (self->priv->ttf_file_name);
	_g_free0 (self->priv->eot_file_name);
	G_OBJECT_CLASS (bird_font_eot_writer_parent_class)->finalize (obj);
}

static GType
bird_font_eot_writer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontEotWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_eot_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontEotWriter), 0, (GInstanceInitFunc) bird_font_eot_writer_instance_init, NULL };
	GType bird_font_eot_writer_type_id;
	bird_font_eot_writer_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontEotWriter", &g_define_type_info, 0);
	BirdFontEotWriter_private_offset = g_type_add_instance_private (bird_font_eot_writer_type_id, sizeof (BirdFontEotWriterPrivate));
	return bird_font_eot_writer_type_id;
}

GType
bird_font_eot_writer_get_type (void)
{
	static volatile gsize bird_font_eot_writer_type_id__once = 0;
	if (g_once_init_enter (&bird_font_eot_writer_type_id__once)) {
		GType bird_font_eot_writer_type_id;
		bird_font_eot_writer_type_id = bird_font_eot_writer_get_type_once ();
		g_once_init_leave (&bird_font_eot_writer_type_id__once, bird_font_eot_writer_type_id);
	}
	return bird_font_eot_writer_type_id__once;
}

