/* EditPointHandle.c generated by valac 0.56.17, the Vala compiler
 * generated from EditPointHandle.vala, do not modify */

/*
Copyright (C) 2012 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_EDIT_POINT_HANDLE_0_PROPERTY,
	BIRD_FONT_EDIT_POINT_HANDLE_X_PROPERTY,
	BIRD_FONT_EDIT_POINT_HANDLE_Y_PROPERTY,
	BIRD_FONT_EDIT_POINT_HANDLE_INDEPENDENT_X_PROPERTY,
	BIRD_FONT_EDIT_POINT_HANDLE_INDEPENDENT_Y_PROPERTY,
	BIRD_FONT_EDIT_POINT_HANDLE_NUM_PROPERTIES
};
static GParamSpec* bird_font_edit_point_handle_properties[BIRD_FONT_EDIT_POINT_HANDLE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _BirdFontEditPointHandlePrivate {
	BirdFontEditPoint* visual_handle;
};

static gint BirdFontEditPointHandle_private_offset;
static gpointer bird_font_edit_point_handle_parent_class = NULL;
static BirdFontEditPoint* bird_font_edit_point_handle_none;
static BirdFontEditPoint* bird_font_edit_point_handle_none = NULL;

static gdouble bird_font_edit_point_handle_px (BirdFontEditPointHandle* self);
static gdouble bird_font_edit_point_handle_py (BirdFontEditPointHandle* self);
VALA_EXTERN void bird_font_edit_point_handle_print_position (BirdFontEditPointHandle* self);
static void bird_font_edit_point_handle_finalize (GObject * obj);
static GType bird_font_edit_point_handle_get_type_once (void);
static void _vala_bird_font_edit_point_handle_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_bird_font_edit_point_handle_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);

static inline gpointer
bird_font_edit_point_handle_get_instance_private (BirdFontEditPointHandle* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontEditPointHandle_private_offset);
}

BirdFontEditPointHandle*
bird_font_edit_point_handle_construct_empty (GType object_type)
{
	BirdFontEditPointHandle * self = NULL;
	BirdFontEditPoint* _tmp0_;
	self = (BirdFontEditPointHandle*) g_object_new (object_type, NULL);
	_tmp0_ = bird_font_edit_point_handle_none;
	self->parent = _tmp0_;
	self->angle = (gdouble) 0;
	self->length = (gdouble) 10;
	self->type = BIRD_FONT_POINT_TYPE_NONE;
	self->active = FALSE;
	self->selected = FALSE;
	return self;
}

BirdFontEditPointHandle*
bird_font_edit_point_handle_new_empty (void)
{
	return bird_font_edit_point_handle_construct_empty (BIRD_FONT_TYPE_EDIT_POINT_HANDLE);
}

BirdFontEditPointHandle*
bird_font_edit_point_handle_construct (GType object_type,
                                       BirdFontEditPoint* parent,
                                       gdouble angle,
                                       gdouble length)
{
	BirdFontEditPointHandle * self = NULL;
	g_return_val_if_fail (parent != NULL, NULL);
	self = (BirdFontEditPointHandle*) g_object_new (object_type, NULL);
	self->parent = parent;
	self->angle = angle;
	self->length = length;
	self->type = BIRD_FONT_POINT_TYPE_LINE_CUBIC;
	self->active = FALSE;
	self->selected = FALSE;
	return self;
}

BirdFontEditPointHandle*
bird_font_edit_point_handle_new (BirdFontEditPoint* parent,
                                 gdouble angle,
                                 gdouble length)
{
	return bird_font_edit_point_handle_construct (BIRD_FONT_TYPE_EDIT_POINT_HANDLE, parent, angle, length);
}

BirdFontEditPointHandle*
bird_font_edit_point_handle_copy (BirdFontEditPointHandle* self)
{
	BirdFontEditPointHandle* n = NULL;
	BirdFontEditPointHandle* _tmp0_;
	BirdFontEditPoint* _tmp1_;
	BirdFontEditPointHandle* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_edit_point_handle_new_empty ();
	n = _tmp0_;
	n->angle = self->angle;
	n->length = self->length;
	_tmp1_ = self->parent;
	n->parent = _tmp1_;
	n->type = self->type;
	n->active = self->active;
	n->selected = self->selected;
	result = n;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BirdFontEditPoint*
bird_font_edit_point_handle_get_parent (BirdFontEditPointHandle* self)
{
	BirdFontEditPoint* _tmp0_;
	BirdFontEditPoint* _tmp1_;
	BirdFontEditPoint* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->parent;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
bird_font_edit_point_handle_convert_to_line (BirdFontEditPointHandle* self)
{
	BirdFontEditPoint* _tmp0_;
	BirdFontEditPoint* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->parent;
	bird_font_edit_point_set_tie_handles (_tmp0_, FALSE);
	_tmp1_ = self->parent;
	bird_font_edit_point_set_reflective_point (_tmp1_, FALSE);
	switch (self->type) {
		case BIRD_FONT_POINT_TYPE_QUADRATIC:
		{
			self->type = BIRD_FONT_POINT_TYPE_LINE_QUADRATIC;
			break;
		}
		case BIRD_FONT_POINT_TYPE_DOUBLE_CURVE:
		{
			self->type = BIRD_FONT_POINT_TYPE_LINE_DOUBLE_CURVE;
			break;
		}
		case BIRD_FONT_POINT_TYPE_CUBIC:
		{
			self->type = BIRD_FONT_POINT_TYPE_LINE_CUBIC;
			break;
		}
		default:
		{
			break;
		}
	}
}

gboolean
bird_font_edit_point_handle_is_curve (BirdFontEditPointHandle* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	switch (self->type) {
		case BIRD_FONT_POINT_TYPE_LINE_QUADRATIC:
		{
			result = FALSE;
			return result;
		}
		case BIRD_FONT_POINT_TYPE_LINE_DOUBLE_CURVE:
		{
			result = FALSE;
			return result;
		}
		case BIRD_FONT_POINT_TYPE_LINE_CUBIC:
		{
			result = FALSE;
			return result;
		}
		default:
		break;
	}
	result = TRUE;
	return result;
}

void
bird_font_edit_point_handle_convert_to_curve (BirdFontEditPointHandle* self)
{
	g_return_if_fail (self != NULL);
	switch (self->type) {
		case BIRD_FONT_POINT_TYPE_LINE_QUADRATIC:
		{
			self->type = BIRD_FONT_POINT_TYPE_QUADRATIC;
			break;
		}
		case BIRD_FONT_POINT_TYPE_LINE_DOUBLE_CURVE:
		{
			self->type = BIRD_FONT_POINT_TYPE_DOUBLE_CURVE;
			break;
		}
		case BIRD_FONT_POINT_TYPE_LINE_CUBIC:
		{
			self->type = BIRD_FONT_POINT_TYPE_CUBIC;
			break;
		}
		case BIRD_FONT_POINT_TYPE_QUADRATIC:
		{
			break;
		}
		case BIRD_FONT_POINT_TYPE_DOUBLE_CURVE:
		{
			break;
		}
		case BIRD_FONT_POINT_TYPE_CUBIC:
		{
			break;
		}
		default:
		{
			GEnumValue* _tmp0_;
			gchar* _tmp1_;
			gchar* _tmp2_;
			_tmp0_ = g_enum_get_value (g_type_class_ref (BIRD_FONT_TYPE_POINT_TYPE), self->type);
			_tmp1_ = g_strconcat ("Type ", (_tmp0_ != NULL) ? _tmp0_->value_name : NULL, NULL);
			_tmp2_ = _tmp1_;
			g_warning ("EditPointHandle.vala:202: %s", _tmp2_);
			_g_free0 (_tmp2_);
			break;
		}
	}
}

void
bird_font_edit_point_handle_set_point_type (BirdFontEditPointHandle* self,
                                            BirdFontPointType point_type)
{
	g_return_if_fail (self != NULL);
	self->type = point_type;
}

static gdouble
bird_font_edit_point_handle_px (BirdFontEditPointHandle* self)
{
	BirdFontEditPoint* _tmp0_;
	BirdFontEditPoint* _tmp1_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->parent;
	_vala_assert (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, BIRD_FONT_TYPE_EDIT_POINT, BirdFontEditPoint) != NULL, "(EditPoint?) parent != null");
	_tmp1_ = self->parent;
	result = (cos (self->angle) * self->length) + _tmp1_->x;
	return result;
}

static gdouble
bird_font_edit_point_handle_py (BirdFontEditPointHandle* self)
{
	BirdFontEditPoint* _tmp0_;
	BirdFontEditPoint* _tmp1_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->parent;
	_vala_assert (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, BIRD_FONT_TYPE_EDIT_POINT, BirdFontEditPoint) != NULL, "(EditPoint?) parent != null");
	_tmp1_ = self->parent;
	result = (sin (self->angle) * self->length) + _tmp1_->y;
	return result;
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

void
bird_font_edit_point_handle_print_position (BirdFontEditPointHandle* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	BirdFontEditPoint* _tmp6_;
	GEnumValue* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = double_to_string (bird_font_edit_point_handle_px (self));
	_tmp1_ = _tmp0_;
	_tmp2_ = double_to_string (bird_font_edit_point_handle_py (self));
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("\nEdit point handle at position ", _tmp1_, ",", _tmp3_, " is not valid.\n", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->parent;
	_tmp7_ = g_enum_get_value (g_type_class_ref (BIRD_FONT_TYPE_POINT_TYPE), _tmp6_->type);
	_tmp8_ = g_strconcat ("Type: ", (_tmp7_ != NULL) ? _tmp7_->value_name : NULL, ", ", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp5_, _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = double_to_string (self->angle);
	_tmp13_ = _tmp12_;
	_tmp14_ = double_to_string (self->length);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strconcat ("Angle: ", _tmp13_, ", Length: ", _tmp15_, ".", NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strconcat (_tmp11_, _tmp17_, NULL);
	_tmp19_ = _tmp18_;
	g_warning ("EditPointHandle.vala:222: %s", _tmp19_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
}

BirdFontEditPoint*
bird_font_edit_point_handle_get_point (BirdFontEditPointHandle* self)
{
	BirdFontEditPoint* p = NULL;
	BirdFontEditPoint* _tmp0_;
	BirdFontEditPoint* _tmp2_;
	BirdFontEditPoint* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	BirdFontEditPoint* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->visual_handle;
	if (_tmp0_ == NULL) {
		BirdFontEditPoint* _tmp1_;
		_tmp1_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
		_g_object_unref0 (self->priv->visual_handle);
		self->priv->visual_handle = _tmp1_;
	}
	_tmp2_ = self->priv->visual_handle;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, BIRD_FONT_TYPE_EDIT_POINT, BirdFontEditPoint));
	_g_object_unref0 (p);
	p = _tmp3_;
	_tmp4_ = bird_font_edit_point_handle_get_x (self);
	_tmp5_ = _tmp4_;
	p->x = _tmp5_;
	_tmp6_ = bird_font_edit_point_handle_get_y (self);
	_tmp7_ = _tmp6_;
	p->y = _tmp7_;
	result = p;
	return result;
}

gboolean
bird_font_edit_point_handle_is_left_handle (BirdFontEditPointHandle* self)
{
	BirdFontEditPoint* _tmp0_;
	BirdFontEditPointHandle* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->parent;
	_tmp1_ = bird_font_edit_point_get_left_handle (_tmp0_);
	result = _tmp1_ == self;
	return result;
}

void
bird_font_edit_point_handle_move_to_coordinate_delta (BirdFontEditPointHandle* self,
                                                      gdouble dx,
                                                      gdouble dy)
{
	g_return_if_fail (self != NULL);
	bird_font_edit_point_handle_move_to_coordinate_internal (self, bird_font_edit_point_handle_px (self) + dx, bird_font_edit_point_handle_py (self) + dy);
}

void
bird_font_edit_point_handle_move_to_coordinate (BirdFontEditPointHandle* self,
                                                gdouble x,
                                                gdouble y)
{
	BirdFontEditPoint* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	BirdFontEditPoint* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	bird_font_edit_point_handle_move_to_coordinate_internal (self, x, y);
	_tmp0_ = self->parent;
	_tmp1_ = bird_font_edit_point_get_tie_handles (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		bird_font_edit_point_handle_tie_handle (self);
	}
	_tmp3_ = self->parent;
	_tmp4_ = bird_font_edit_point_get_reflective_point (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		bird_font_edit_point_handle_tie_handle (self);
		bird_font_edit_point_handle_process_symmetrical_handle (self);
	}
	bird_font_edit_point_handle_process_connected_handle (self);
}

void
bird_font_edit_point_handle_move_to_coordinate_internal (BirdFontEditPointHandle* self,
                                                         gdouble x,
                                                         gdouble y)
{
	gdouble a = 0.0;
	gdouble b = 0.0;
	gdouble c = 0.0;
	BirdFontEditPoint* _tmp0_;
	BirdFontEditPoint* _tmp1_;
	BirdFontEditPoint* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->parent;
	a = _tmp0_->x - x;
	_tmp1_ = self->parent;
	b = _tmp1_->y - y;
	c = (a * a) + (b * b);
	if (G_UNLIKELY (c == ((gdouble) 0))) {
		self->angle = (gdouble) 0;
		self->length = (gdouble) 0;
		return;
	}
	self->length = sqrt (fabs (c));
	if (c < ((gdouble) 0)) {
		self->length = -self->length;
	}
	_tmp2_ = self->parent;
	if (y < _tmp2_->y) {
		self->angle = acos (a / self->length) + G_PI;
	} else {
		self->angle = (-acos (a / self->length)) + G_PI;
	}
}

void
bird_font_edit_point_handle_process_connected_handle (BirdFontEditPointHandle* self)
{
	BirdFontEditPointHandle* h = NULL;
	g_return_if_fail (self != NULL);
	if (G_UNLIKELY (self->type == BIRD_FONT_POINT_TYPE_NONE)) {
		g_warning ("EditPointHandle.vala:292: Invalid type.");
	}
	if (self->type == BIRD_FONT_POINT_TYPE_QUADRATIC) {
		if (!bird_font_edit_point_handle_is_left_handle (self)) {
			BirdFontEditPoint* _tmp0_;
			BirdFontEditPoint* _tmp1_;
			_tmp0_ = self->parent;
			_tmp1_ = _tmp0_->next;
			if (_tmp1_ != NULL) {
				BirdFontEditPoint* _tmp2_;
				BirdFontEditPoint* _tmp3_;
				BirdFontEditPointHandle* _tmp4_;
				BirdFontEditPointHandle* _tmp5_;
				BirdFontEditPointHandle* _tmp6_;
				BirdFontEditPoint* _tmp7_;
				BirdFontEditPointHandle* _tmp8_;
				BirdFontEditPoint* _tmp9_;
				BirdFontEditPointHandle* _tmp10_;
				BirdFontEditPointHandle* _tmp11_;
				gdouble _tmp12_;
				gdouble _tmp13_;
				gdouble _tmp14_;
				gdouble _tmp15_;
				_tmp2_ = self->parent;
				_tmp3_ = bird_font_edit_point_get_next (_tmp2_);
				_tmp4_ = bird_font_edit_point_get_left_handle (_tmp3_);
				_tmp5_ = _g_object_ref0 (_tmp4_);
				_g_object_unref0 (h);
				h = _tmp5_;
				_tmp6_ = h;
				_tmp7_ = _tmp6_->parent;
				bird_font_edit_point_set_reflective_handles (_tmp7_, FALSE);
				_tmp8_ = h;
				_tmp9_ = _tmp8_->parent;
				bird_font_edit_point_set_tie_handle (_tmp9_, FALSE);
				_tmp10_ = h;
				_tmp10_->type = BIRD_FONT_POINT_TYPE_QUADRATIC;
				_tmp11_ = h;
				_tmp12_ = bird_font_edit_point_handle_get_x (self);
				_tmp13_ = _tmp12_;
				_tmp14_ = bird_font_edit_point_handle_get_y (self);
				_tmp15_ = _tmp14_;
				bird_font_edit_point_handle_move_to_coordinate_internal (_tmp11_, _tmp13_, _tmp15_);
			}
		} else {
			BirdFontEditPoint* _tmp16_;
			BirdFontEditPoint* _tmp17_;
			_tmp16_ = self->parent;
			_tmp17_ = _tmp16_->prev;
			if (_tmp17_ != NULL) {
				BirdFontEditPoint* _tmp18_;
				BirdFontEditPoint* _tmp19_;
				BirdFontEditPointHandle* _tmp20_;
				BirdFontEditPointHandle* _tmp21_;
				BirdFontEditPointHandle* _tmp22_;
				BirdFontEditPoint* _tmp23_;
				BirdFontEditPointHandle* _tmp24_;
				BirdFontEditPoint* _tmp25_;
				BirdFontEditPointHandle* _tmp26_;
				BirdFontEditPointHandle* _tmp27_;
				gdouble _tmp28_;
				gdouble _tmp29_;
				gdouble _tmp30_;
				gdouble _tmp31_;
				_tmp18_ = self->parent;
				_tmp19_ = bird_font_edit_point_get_prev (_tmp18_);
				_tmp20_ = bird_font_edit_point_get_right_handle (_tmp19_);
				_tmp21_ = _g_object_ref0 (_tmp20_);
				_g_object_unref0 (h);
				h = _tmp21_;
				_tmp22_ = h;
				_tmp23_ = _tmp22_->parent;
				bird_font_edit_point_set_reflective_handles (_tmp23_, FALSE);
				_tmp24_ = h;
				_tmp25_ = _tmp24_->parent;
				bird_font_edit_point_set_tie_handle (_tmp25_, FALSE);
				_tmp26_ = h;
				_tmp26_->type = BIRD_FONT_POINT_TYPE_QUADRATIC;
				_tmp27_ = h;
				_tmp28_ = bird_font_edit_point_handle_get_x (self);
				_tmp29_ = _tmp28_;
				_tmp30_ = bird_font_edit_point_handle_get_y (self);
				_tmp31_ = _tmp30_;
				bird_font_edit_point_handle_move_to_coordinate_internal (_tmp27_, _tmp29_, _tmp31_);
			}
		}
	}
	_g_object_unref0 (h);
}

void
bird_font_edit_point_handle_process_symmetrical_handle (BirdFontEditPointHandle* self)
{
	g_return_if_fail (self != NULL);
	if (bird_font_edit_point_handle_is_left_handle (self)) {
		BirdFontEditPoint* _tmp0_;
		BirdFontEditPointHandle* _tmp1_;
		BirdFontEditPoint* _tmp2_;
		BirdFontEditPointHandle* _tmp3_;
		_tmp0_ = self->parent;
		_tmp1_ = bird_font_edit_point_get_right_handle (_tmp0_);
		_tmp1_->length = self->length;
		_tmp2_ = self->parent;
		_tmp3_ = bird_font_edit_point_get_right_handle (_tmp2_);
		bird_font_edit_point_handle_process_connected_handle (_tmp3_);
	} else {
		BirdFontEditPoint* _tmp4_;
		BirdFontEditPointHandle* _tmp5_;
		BirdFontEditPoint* _tmp6_;
		BirdFontEditPointHandle* _tmp7_;
		_tmp4_ = self->parent;
		_tmp5_ = bird_font_edit_point_get_left_handle (_tmp4_);
		_tmp5_->length = self->length;
		_tmp6_ = self->parent;
		_tmp7_ = bird_font_edit_point_get_left_handle (_tmp6_);
		bird_font_edit_point_handle_process_connected_handle (_tmp7_);
	}
	bird_font_edit_point_handle_process_connected_handle (self);
}

void
bird_font_edit_point_handle_tie_handle (BirdFontEditPointHandle* self)
{
	g_return_if_fail (self != NULL);
	if (bird_font_edit_point_handle_is_left_handle (self)) {
		BirdFontEditPoint* _tmp0_;
		BirdFontEditPointHandle* _tmp1_;
		BirdFontEditPoint* _tmp2_;
		BirdFontEditPointHandle* _tmp3_;
		_tmp0_ = self->parent;
		_tmp1_ = bird_font_edit_point_get_right_handle (_tmp0_);
		_tmp1_->angle = self->angle - G_PI;
		_tmp2_ = self->parent;
		_tmp3_ = bird_font_edit_point_get_right_handle (_tmp2_);
		bird_font_edit_point_handle_process_connected_handle (_tmp3_);
	} else {
		BirdFontEditPoint* _tmp4_;
		BirdFontEditPointHandle* _tmp5_;
		BirdFontEditPoint* _tmp6_;
		BirdFontEditPointHandle* _tmp7_;
		_tmp4_ = self->parent;
		_tmp5_ = bird_font_edit_point_get_left_handle (_tmp4_);
		_tmp5_->angle = self->angle - G_PI;
		_tmp6_ = self->parent;
		_tmp7_ = bird_font_edit_point_get_left_handle (_tmp6_);
		bird_font_edit_point_handle_process_connected_handle (_tmp7_);
	}
	bird_font_edit_point_handle_process_connected_handle (self);
}

void
bird_font_edit_point_handle_move_delta_coordinate (BirdFontEditPointHandle* self,
                                                   gdouble dx,
                                                   gdouble dy)
{
	gdouble px = 0.0;
	gdouble py = 0.0;
	g_return_if_fail (self != NULL);
	px = bird_font_edit_point_handle_px (self) + dx;
	py = bird_font_edit_point_handle_py (self) + dy;
	bird_font_edit_point_handle_move_to_coordinate (self, px, py);
}

void
bird_font_edit_point_handle_move_to (BirdFontEditPointHandle* self,
                                     gdouble x,
                                     gdouble y)
{
	g_return_if_fail (self != NULL);
	bird_font_edit_point_to_coordinate (&x, &y);
	bird_font_edit_point_handle_move_to_coordinate (self, x, y);
}

gboolean
bird_font_edit_point_handle_is_line (BirdFontEditPointHandle* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = bird_font_pen_tool_is_line (self->type);
	return result;
}

gdouble
bird_font_edit_point_handle_average_angle (gdouble angle1,
                                           gdouble angle2)
{
	BirdFontEditPointHandle* handle = NULL;
	BirdFontEditPoint* _tmp0_;
	BirdFontEditPoint* _tmp1_;
	BirdFontEditPointHandle* _tmp2_;
	BirdFontEditPointHandle* _tmp3_;
	gdouble x = 0.0;
	gdouble y = 0.0;
	BirdFontEditPointHandle* _tmp4_;
	gboolean _tmp5_ = FALSE;
	BirdFontEditPointHandle* _tmp6_;
	gdouble result;
	_tmp0_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_CUBIC);
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_edit_point_handle_new (_tmp1_, (gdouble) 0, (gdouble) 1);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	handle = _tmp3_;
	x = (cos (angle1) + cos (angle2)) / 2;
	y = (sin (angle1) + sin (angle2)) / 2;
	_tmp4_ = handle;
	bird_font_edit_point_handle_move_to_coordinate (_tmp4_, x, y);
	if (fabs (x) < 0.001) {
		_tmp5_ = fabs (y) < 0.001;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		result = fmod (angle1 + (G_PI / 2), 2 * G_PI);
		_g_object_unref0 (handle);
		return result;
	}
	_tmp6_ = handle;
	result = _tmp6_->angle;
	_g_object_unref0 (handle);
	return result;
}

gdouble
bird_font_edit_point_handle_get_x (BirdFontEditPointHandle* self)
{
	gdouble result;
	gdouble r = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	r = bird_font_edit_point_handle_px (self);
	if (G_UNLIKELY (r <= ((gdouble) -100000))) {
		bird_font_edit_point_handle_print_position (self);
		bird_font_edit_point_handle_move_to (self, (gdouble) 0, (gdouble) 0);
	}
	result = r;
	return result;
}

void
bird_font_edit_point_handle_set_x (BirdFontEditPointHandle* self,
                                   gdouble value)
{
	BirdFontEditPoint* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	BirdFontEditPoint* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	bird_font_edit_point_handle_move_to_coordinate_internal (self, value, bird_font_edit_point_handle_py (self));
	_tmp0_ = self->parent;
	_tmp1_ = bird_font_edit_point_get_tie_handles (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		BirdFontEditPoint* _tmp3_;
		_tmp3_ = self->parent;
		bird_font_edit_point_process_tied_handle (_tmp3_);
	}
	_tmp4_ = self->parent;
	_tmp5_ = bird_font_edit_point_get_reflective_point (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		bird_font_edit_point_handle_process_symmetrical_handle (self);
	}
	bird_font_edit_point_handle_process_connected_handle (self);
	g_object_notify_by_pspec ((GObject *) self, bird_font_edit_point_handle_properties[BIRD_FONT_EDIT_POINT_HANDLE_X_PROPERTY]);
}

gdouble
bird_font_edit_point_handle_get_y (BirdFontEditPointHandle* self)
{
	gdouble result;
	gdouble r = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	r = bird_font_edit_point_handle_py (self);
	if (G_UNLIKELY (r <= ((gdouble) -100000))) {
		bird_font_edit_point_handle_print_position (self);
		bird_font_edit_point_handle_move_to (self, (gdouble) 0, (gdouble) 0);
	}
	result = r;
	return result;
}

void
bird_font_edit_point_handle_set_y (BirdFontEditPointHandle* self,
                                   gdouble value)
{
	BirdFontEditPoint* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	BirdFontEditPoint* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	bird_font_edit_point_handle_move_to_coordinate_internal (self, bird_font_edit_point_handle_px (self), value);
	_tmp0_ = self->parent;
	_tmp1_ = bird_font_edit_point_get_tie_handles (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		BirdFontEditPoint* _tmp3_;
		_tmp3_ = self->parent;
		bird_font_edit_point_process_tied_handle (_tmp3_);
	}
	_tmp4_ = self->parent;
	_tmp5_ = bird_font_edit_point_get_reflective_point (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		bird_font_edit_point_handle_process_symmetrical_handle (self);
	}
	bird_font_edit_point_handle_process_connected_handle (self);
	g_object_notify_by_pspec ((GObject *) self, bird_font_edit_point_handle_properties[BIRD_FONT_EDIT_POINT_HANDLE_Y_PROPERTY]);
}

gdouble
bird_font_edit_point_handle_get_independent_x (BirdFontEditPointHandle* self)
{
	gdouble result;
	gdouble r = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	r = bird_font_edit_point_handle_px (self);
	if (G_UNLIKELY (r <= ((gdouble) -100000))) {
		bird_font_edit_point_handle_print_position (self);
		bird_font_edit_point_handle_move_to (self, (gdouble) 0, (gdouble) 0);
	}
	result = r;
	return result;
}

void
bird_font_edit_point_handle_set_independent_x (BirdFontEditPointHandle* self,
                                               gdouble value)
{
	g_return_if_fail (self != NULL);
	bird_font_edit_point_handle_move_to_coordinate_internal (self, value, bird_font_edit_point_handle_py (self));
	g_object_notify_by_pspec ((GObject *) self, bird_font_edit_point_handle_properties[BIRD_FONT_EDIT_POINT_HANDLE_INDEPENDENT_X_PROPERTY]);
}

gdouble
bird_font_edit_point_handle_get_independent_y (BirdFontEditPointHandle* self)
{
	gdouble result;
	gdouble r = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	r = bird_font_edit_point_handle_py (self);
	if (G_UNLIKELY (r <= ((gdouble) -100000))) {
		bird_font_edit_point_handle_print_position (self);
		bird_font_edit_point_handle_move_to (self, (gdouble) 0, (gdouble) 0);
	}
	result = r;
	return result;
}

void
bird_font_edit_point_handle_set_independent_y (BirdFontEditPointHandle* self,
                                               gdouble value)
{
	g_return_if_fail (self != NULL);
	bird_font_edit_point_handle_move_to_coordinate_internal (self, bird_font_edit_point_handle_px (self), value);
	g_object_notify_by_pspec ((GObject *) self, bird_font_edit_point_handle_properties[BIRD_FONT_EDIT_POINT_HANDLE_INDEPENDENT_Y_PROPERTY]);
}

static void
bird_font_edit_point_handle_class_init (BirdFontEditPointHandleClass * klass,
                                        gpointer klass_data)
{
	BirdFontEditPoint* _tmp0_;
	bird_font_edit_point_handle_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontEditPointHandle_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_bird_font_edit_point_handle_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_bird_font_edit_point_handle_set_property;
	G_OBJECT_CLASS (klass)->finalize = bird_font_edit_point_handle_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_EDIT_POINT_HANDLE_X_PROPERTY, bird_font_edit_point_handle_properties[BIRD_FONT_EDIT_POINT_HANDLE_X_PROPERTY] = g_param_spec_double ("x", "x", "x", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_EDIT_POINT_HANDLE_Y_PROPERTY, bird_font_edit_point_handle_properties[BIRD_FONT_EDIT_POINT_HANDLE_Y_PROPERTY] = g_param_spec_double ("y", "y", "y", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_EDIT_POINT_HANDLE_INDEPENDENT_X_PROPERTY, bird_font_edit_point_handle_properties[BIRD_FONT_EDIT_POINT_HANDLE_INDEPENDENT_X_PROPERTY] = g_param_spec_double ("independent-x", "independent-x", "independent-x", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_EDIT_POINT_HANDLE_INDEPENDENT_Y_PROPERTY, bird_font_edit_point_handle_properties[BIRD_FONT_EDIT_POINT_HANDLE_INDEPENDENT_Y_PROPERTY] = g_param_spec_double ("independent-y", "independent-y", "independent-y", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
	bird_font_edit_point_handle_none = _tmp0_;
}

static void
bird_font_edit_point_handle_instance_init (BirdFontEditPointHandle * self,
                                           gpointer klass)
{
	self->priv = bird_font_edit_point_handle_get_instance_private (self);
	self->priv->visual_handle = NULL;
}

static void
bird_font_edit_point_handle_finalize (GObject * obj)
{
	BirdFontEditPointHandle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_EDIT_POINT_HANDLE, BirdFontEditPointHandle);
	_g_object_unref0 (self->priv->visual_handle);
	G_OBJECT_CLASS (bird_font_edit_point_handle_parent_class)->finalize (obj);
}

static GType
bird_font_edit_point_handle_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontEditPointHandleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_edit_point_handle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontEditPointHandle), 0, (GInstanceInitFunc) bird_font_edit_point_handle_instance_init, NULL };
	GType bird_font_edit_point_handle_type_id;
	bird_font_edit_point_handle_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontEditPointHandle", &g_define_type_info, 0);
	BirdFontEditPointHandle_private_offset = g_type_add_instance_private (bird_font_edit_point_handle_type_id, sizeof (BirdFontEditPointHandlePrivate));
	return bird_font_edit_point_handle_type_id;
}

GType
bird_font_edit_point_handle_get_type (void)
{
	static volatile gsize bird_font_edit_point_handle_type_id__once = 0;
	if (g_once_init_enter (&bird_font_edit_point_handle_type_id__once)) {
		GType bird_font_edit_point_handle_type_id;
		bird_font_edit_point_handle_type_id = bird_font_edit_point_handle_get_type_once ();
		g_once_init_leave (&bird_font_edit_point_handle_type_id__once, bird_font_edit_point_handle_type_id);
	}
	return bird_font_edit_point_handle_type_id__once;
}

static void
_vala_bird_font_edit_point_handle_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	BirdFontEditPointHandle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BIRD_FONT_TYPE_EDIT_POINT_HANDLE, BirdFontEditPointHandle);
	switch (property_id) {
		case BIRD_FONT_EDIT_POINT_HANDLE_X_PROPERTY:
		g_value_set_double (value, bird_font_edit_point_handle_get_x (self));
		break;
		case BIRD_FONT_EDIT_POINT_HANDLE_Y_PROPERTY:
		g_value_set_double (value, bird_font_edit_point_handle_get_y (self));
		break;
		case BIRD_FONT_EDIT_POINT_HANDLE_INDEPENDENT_X_PROPERTY:
		g_value_set_double (value, bird_font_edit_point_handle_get_independent_x (self));
		break;
		case BIRD_FONT_EDIT_POINT_HANDLE_INDEPENDENT_Y_PROPERTY:
		g_value_set_double (value, bird_font_edit_point_handle_get_independent_y (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_bird_font_edit_point_handle_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	BirdFontEditPointHandle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BIRD_FONT_TYPE_EDIT_POINT_HANDLE, BirdFontEditPointHandle);
	switch (property_id) {
		case BIRD_FONT_EDIT_POINT_HANDLE_X_PROPERTY:
		bird_font_edit_point_handle_set_x (self, g_value_get_double (value));
		break;
		case BIRD_FONT_EDIT_POINT_HANDLE_Y_PROPERTY:
		bird_font_edit_point_handle_set_y (self, g_value_get_double (value));
		break;
		case BIRD_FONT_EDIT_POINT_HANDLE_INDEPENDENT_X_PROPERTY:
		bird_font_edit_point_handle_set_independent_x (self, g_value_get_double (value));
		break;
		case BIRD_FONT_EDIT_POINT_HANDLE_INDEPENDENT_Y_PROPERTY:
		bird_font_edit_point_handle_set_independent_y (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

